/*
 * Decompiled with CFR 0.152.
 */
package ink.markidea.note.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class JsonUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);
    private static ObjectMapper objectMapper = new ObjectMapper();

    private static void initObjMapper() {
        objectMapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }

    public static <T> String objToString(T obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (IOException e) {
            log.error("parse object to string error", (Throwable)e);
            return null;
        }
    }

    public static <T> String objToStringPretty(T obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        try {
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        catch (IOException e) {
            log.error("parse object to string error", (Throwable)e);
            return null;
        }
    }

    public static <T> T stringToObj(String string, Class<T> clazz) {
        if (StringUtils.isEmpty((Object)string) || clazz == null) {
            return null;
        }
        if (clazz.equals(String.class)) {
            return (T)string;
        }
        try {
            return (T)objectMapper.readValue(string, clazz);
        }
        catch (IOException e) {
            log.error("Parse string to object ", (Throwable)e);
            return null;
        }
    }

    public static <T> T stringToObj(String string, TypeReference<T> typeReference) {
        if (StringUtils.isEmpty((Object)string) || typeReference == null) {
            return null;
        }
        if (typeReference.getType().equals(String.class)) {
            return (T)string;
        }
        try {
            return (T)objectMapper.readValue(string, typeReference);
        }
        catch (IOException e) {
            log.error("Parse string to object ", (Throwable)e);
            return null;
        }
    }

    public static <T> T stringToObj(String string, Class<?> collectionClass, Class<?> ... classes) {
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(collectionClass, (Class[])classes);
        if (StringUtils.isEmpty((Object)string)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(string, javaType);
        }
        catch (IOException e) {
            log.error("Parse string to object ", (Throwable)e);
            return null;
        }
    }

    static {
        JsonUtil.initObjMapper();
    }
}

