/*
 Language: HTMLBars (legacy)
 Requires: xml.js
 Description: Matcher for Handlebars as well as EmberJS additions.
 Website: https://github.com/tildeio/htmlbars
 Category: template
 */

/*

See: https://github.com/highlightjs/highlight.js/issues/2181

This file is a stub that is only left in place for compatbility reasons for
anyone who may be manually pulling in this file via a require or fetching
it individually via CDN.

TODO: Remove in version 11.0.

*/

// compile time dependency on handlebars
import handlebars from "./handlebars.js"

export default function(hljs) {
  const definition = handlebars(hljs)

  definition.name = "HTMLbars"

  // HACK: This lets handlebars do the auto-detection if it's been loaded (by
  // default the build script will load in alphabetical order) and if not (perhaps
  // an install is only using `htmlbars`, not `handlebars`) then this will still
  // allow HTMLBars to participate in the auto-detection

  // worse case someone will have HTMLbars and handlebars competing for the same
  // content and will need to change their setup to only require handlebars, but
  // I don't consider this a breaking change
  if (hljs.getLanguage("handlebars")) {
    definition.disableAutodetect = true
  }

  return definition
}
