// https://github.com/substack/deep-freeze/blob/master/index.js
/** @param {any} obj */
export default function deepFreeze(obj) {
  Object.freeze(obj);

  var objIsFunction = typeof obj === 'function';

  Object.getOwnPropertyNames(obj).forEach(function(prop) {
    if (Object.hasOwnProperty.call(obj, prop)
    && obj[prop] !== null
    && (typeof obj[prop] === "object" || typeof obj[prop] === "function")
    // IE11 fix: https://github.com/highlightjs/highlight.js/issues/2318
    // TODO: remove in the future
    && (objIsFunction ? prop !== 'caller' && prop !== 'callee' && prop !== 'arguments' : true)
    && !Object.isFrozen(obj[prop])) {
      deepFreeze(obj[prop]);
    }
  });

  return obj;
}
