package Client.Action;

import Client.Util.PropertiesUtils;
import Client.Util.RequestIdUtil;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.HashMap;

/**
 * Created by l05826 on 2020/7/29.
 * 界面获取后台数据接口
 */
@Controller
public class DemoWebMsg
{
    public static String constant = System.getProperty("user.dir") + "/config/constant.properties";
    public static String parkAlarm = System.getProperty("user.dir") + "/config/parkAlarm.properties";
    public static String capture = System.getProperty("user.dir") + "/config/capture.properties";
    public static String status = System.getProperty("user.dir") + "/config/status.properties";
    public static String captureResponse = System.getProperty("user.dir") + "/config/captureResponse.properties";
    public static String reboot = System.getProperty("user.dir") + "/config/reboot.properties";
    public static String setLamp = System.getProperty("user.dir") + "/config/setLamp.properties";
    public static String list = System.getProperty("user.dir") + "/config/list.properties";
    public static String openGate = System.getProperty("user.dir") + "/config/openGate.properties";


    /**************************************************上行 Start*******************************/
    @RequestMapping("/index")
    public String index() {
        return "explain";
    }

    @RequestMapping("/uplink")
    public String uplink() {
        return "uplink";
    }

    @RequestMapping("/basicInfo")
    public String basicInfo(Model model) {
        model.addAttribute("serverIp", PropertiesUtils.readValue(constant, "serverIp"));
        model.addAttribute("serverPort",PropertiesUtils.readValue(constant, "serverPort"));
        model.addAttribute("version", PropertiesUtils.readValue(constant, "version"));
        model.addAttribute("parkId",PropertiesUtils.readValue(constant, "parkId"));
        model.addAttribute("deviceId", PropertiesUtils.readValue(constant, "deviceId"));
        model.addAttribute("deviceType", PropertiesUtils.readValue(constant, "deviceType"));
        model.addAttribute("deviceName",PropertiesUtils.readValue(constant, "deviceName"));
        model.addAttribute("senceType", PropertiesUtils.readValue(constant, "senceType"));
        model.addAttribute("keepalive", PropertiesUtils.readValue(constant, "keepalive"));
        model.addAttribute("shootPosition", PropertiesUtils.readValue(constant, "shootPosition"));
        model.addAttribute("ipAddress", PropertiesUtils.readValue(constant, "ipAddress"));
        model.addAttribute("resolution", PropertiesUtils.readValue(constant, "resolution"));
        model.addAttribute("softwareVersion", PropertiesUtils.readValue(constant, "softwareVersion"));
        model.addAttribute("serialNum", PropertiesUtils.readValue(constant, "serialNum"));
        model.addAttribute("isSupportLamp", PropertiesUtils.readValue(constant, "isSupportLamp"));
        model.addAttribute("isSupportGate", PropertiesUtils.readValue(constant, "isSupportGate"));
        model.addAttribute("isSupprotCoil", PropertiesUtils.readValue(constant, "isSupprotCoil"));
        model.addAttribute("isSupportRadar", PropertiesUtils.readValue(constant, "isSupportRadar"));
        model.addAttribute("isSupportLED", PropertiesUtils.readValue(constant, "isSupportLED"));
        model.addAttribute("isSupportStore", PropertiesUtils.readValue(constant, "isSupportStore"));
        model.addAttribute("isSupportParkDetection", PropertiesUtils.readValue(constant, "isSupportParkDetection"));
        model.addAttribute("totalParkNum", PropertiesUtils.readValue(constant, "totalParkNum"));
        model.addAttribute("area", PropertiesUtils.readValue(constant, "area"));
        model.addAttribute("id", PropertiesUtils.readValue(constant, "id"));
        model.addAttribute("type", PropertiesUtils.readValue(constant, "type"));
        model.addAttribute("mode", PropertiesUtils.readValue(constant, "mode"));
        model.addAttribute("color", PropertiesUtils.readValue(constant, "color"));
        return "basicInfo";
    }

    @RequestMapping("/parkAlarm")
    public String parkAlarm(Model model) {
        model.addAttribute("serverIp", PropertiesUtils.readValue(constant, "serverIp"));
        model.addAttribute("serverPort",PropertiesUtils.readValue(constant, "serverPort"));
        model.addAttribute("version", PropertiesUtils.readValue(constant, "version"));
        model.addAttribute("parkId",PropertiesUtils.readValue(constant, "parkId"));
        model.addAttribute("deviceId", PropertiesUtils.readValue(constant, "deviceId"));
        model.addAttribute("recordId", RequestIdUtil.getRequestId());
        model.addAttribute("roadId", PropertiesUtils.readValue(parkAlarm, "roadId"));
        model.addAttribute("roadName",PropertiesUtils.readValue(parkAlarm, "roadName"));
        model.addAttribute("area", PropertiesUtils.readValue(parkAlarm, "area"));
        model.addAttribute("id", PropertiesUtils.readValue(parkAlarm, "id"));
        model.addAttribute("crossAlarm", PropertiesUtils.readValue(parkAlarm, "crossAlarm"));
        model.addAttribute("coverAlarm", PropertiesUtils.readValue(parkAlarm, "coverAlarm"));
        model.addAttribute("type", PropertiesUtils.readValue(parkAlarm, "type"));
        return "parkAlarm";
    }

    @RequestMapping("/capture")
    public String capture(Model model) {
        model.addAttribute("serverIp", PropertiesUtils.readValue(constant, "serverIp"));
        model.addAttribute("serverPort",PropertiesUtils.readValue(constant, "serverPort"));
        model.addAttribute("version", PropertiesUtils.readValue(constant, "version"));
        model.addAttribute("parkId",PropertiesUtils.readValue(constant, "parkId"));
        model.addAttribute("deviceId", PropertiesUtils.readValue(constant, "deviceId"));
        model.addAttribute("recordId", RequestIdUtil.getRequestId());
        model.addAttribute("picTime", PropertiesUtils.readValue(capture, "picTime"));
        model.addAttribute("plateNo",PropertiesUtils.readValue(capture, "plateNo"));
        model.addAttribute("confidence", PropertiesUtils.readValue(capture, "confidence"));
        model.addAttribute("vehicleType", PropertiesUtils.readValue(capture, "vehicleType"));
        model.addAttribute("vehicleColor", PropertiesUtils.readValue(capture, "vehicleColor"));
        model.addAttribute("plateType", PropertiesUtils.readValue(capture, "plateType"));
        model.addAttribute("plateColor", PropertiesUtils.readValue(capture, "plateColor"));
        model.addAttribute("shootPosition", PropertiesUtils.readValue(capture, "shootPosition"));
        model.addAttribute("type", PropertiesUtils.readValue(capture, "type"));
        return "capture";
    }

    @RequestMapping("/parkStatus")
    public String parkStatus(Model model) {
        model.addAttribute("serverIp", PropertiesUtils.readValue(constant, "serverIp"));
        model.addAttribute("serverPort",PropertiesUtils.readValue(constant, "serverPort"));
        model.addAttribute("version", PropertiesUtils.readValue(constant, "version"));
        model.addAttribute("parkId",PropertiesUtils.readValue(constant, "parkId"));
        model.addAttribute("deviceId", PropertiesUtils.readValue(constant, "deviceId"));
        model.addAttribute("recordId", RequestIdUtil.getRequestId());
        model.addAttribute("roadId", PropertiesUtils.readValue(status, "roadId"));
        model.addAttribute("roadName",PropertiesUtils.readValue(status, "roadName"));
        model.addAttribute("picTime", PropertiesUtils.readValue(status, "picTime"));
        model.addAttribute("area", PropertiesUtils.readValue(status, "area"));
        model.addAttribute("id", PropertiesUtils.readValue(status, "id"));
        model.addAttribute("status", PropertiesUtils.readValue(status, "status"));
        model.addAttribute("plateNo", PropertiesUtils.readValue(status, "plateNo"));
        model.addAttribute("confidence", PropertiesUtils.readValue(status, "confidence"));
        model.addAttribute("vehicleType", PropertiesUtils.readValue(status, "vehicleType"));
        model.addAttribute("vehicleColor", PropertiesUtils.readValue(status, "vehicleColor"));
        model.addAttribute("plateType", PropertiesUtils.readValue(status, "plateType"));
        model.addAttribute("plateColor", PropertiesUtils.readValue(status, "plateColor"));
        model.addAttribute("ledMode", PropertiesUtils.readValue(status, "ledMode"));
        model.addAttribute("ledColor", PropertiesUtils.readValue(status, "ledColor"));
        model.addAttribute("longitude", PropertiesUtils.readValue(status, "longitude"));
        model.addAttribute("latitude", PropertiesUtils.readValue(status, "latitude"));
        model.addAttribute("altitude", PropertiesUtils.readValue(status, "altitude"));
        model.addAttribute("type", PropertiesUtils.readValue(status, "type"));
        return "parkStatus";
    }

    @RequestMapping("/transChannel")
    public String transChannel(Model model) {
        model.addAttribute("serverIp", PropertiesUtils.readValue(constant, "serverIp"));
        model.addAttribute("serverPort",PropertiesUtils.readValue(constant, "serverPort"));
        model.addAttribute("version", PropertiesUtils.readValue(constant, "version"));
        model.addAttribute("parkId",PropertiesUtils.readValue(constant, "parkId"));
        model.addAttribute("deviceId", PropertiesUtils.readValue(constant, "deviceId"));
        return "transChannel";
    }

    /**************************************************上行 End*******************************/


    /**************************************************下行 Start*******************************/
    @RequestMapping("/downward")
    public String downwardExplain() {
        return "downward";
    }

    @RequestMapping("/downward/capture")
    public String downwardCapture(Model model) {
        HashMap<String,String> map = PropertiesUtils.readProperties(captureResponse);
        model.addAttribute("mapCapture", map);
        return "downwardCapture";
    }


    @RequestMapping("/downward/reboot")
    public String downwardReboot(Model model) {
        HashMap<String,String> map = PropertiesUtils.readProperties(reboot);
        model.addAttribute("mapReboot", map);
        return "downwardReboot";
    }

    @RequestMapping("/downward/setLamp")
    public String downwardSetLamp(Model model) {
        HashMap<String,String> map = PropertiesUtils.readProperties(setLamp);
        model.addAttribute("mapSetLamp", map);
        return "downwardSetLamp";
    }

    @RequestMapping("/downward/setVehicleList")
    public String downwardList(Model model) {
        HashMap<String,String> map = PropertiesUtils.readProperties(list);
        model.addAttribute("mapList", map);
        return "downwardList";
    }

    @RequestMapping("/downward/openGate")
    public String downwardOpenGate(Model model) {
        HashMap<String,String> map = PropertiesUtils.readProperties(openGate);
        model.addAttribute("mapOpenGate", map);
        return "downwardOpenGate";
    }


    /**************************************************下行 End*******************************/
}
