package Client.Action;

import Client.Bean.ResultMap;
import Client.Bean.request.*;
import Client.Service.KeepAliveService;
import Client.Util.AddressUtil;
import Client.Util.HttpClientUtil;
import Client.Util.PropertiesUtils;
import com.alibaba.fastjson.JSONObject;
import org.apache.http.client.methods.HttpPost;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * Created by l05826 on 2020/7/30.
 * 上行数据主动上报
 */
@Controller
@Component
@RequestMapping("/client")
public class UplinkMsg
{
    public static String constant = System.getProperty("user.dir") + "/config/constant.properties";
    HttpClientUtil ohHttp = HttpClientUtil.getInstance();
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /**
     * 基础数据
     */
    @RequestMapping("/basicInfo")
    @ResponseBody
    public ResultMap<String> basicInfo(BasicInfoReq basicInfoReq) {
        writeProperties(basicInfoReq);
        String url = AddressUtil.getAddress() + "/api/upark/basicinfo";
        System.out.println(url);
        BasicInfo basicInfo= new BasicInfo();
        basicInfo.setDeviceName(basicInfoReq.getDeviceName());
        basicInfo.setDeviceType(basicInfoReq.getDeviceType());
        basicInfo.setSenceType(basicInfoReq.getSenceType());
        basicInfo.setKeepalive(basicInfoReq.getKeepalive());
        basicInfo.setTotalParkNum(basicInfoReq.getTotalParkNum());
        basicInfo.setShootPosition(basicInfoReq.getShootPosition());
        basicInfo.setIpAddress(basicInfoReq.getIpAddress());
        basicInfo.setResolution(basicInfoReq.getResolution());
        basicInfo.setSoftwareVersion(basicInfoReq.getSoftwareVersion());
        basicInfo.setSerialNum(basicInfoReq.getSerialNum());
        basicInfo.getDeviceCapability().setIsSupportLamp(basicInfoReq.getIsSupportLamp());
        basicInfo.getDeviceCapability().setIsSupportGate(basicInfoReq.getIsSupportGate());
        basicInfo.getDeviceCapability().setIsSupprotCoil(basicInfoReq.getIsSupprotCoil());
        basicInfo.getDeviceCapability().setIsSupportRadar(basicInfoReq.getIsSupportRadar());
        basicInfo.getDeviceCapability().setIsSupportLED(basicInfoReq.getIsSupportLED());
        basicInfo.getDeviceCapability().setIsSupportStore(basicInfoReq.getIsSupportStore());
        basicInfo.getDeviceCapability().setIsSupportParkDetection(basicInfoReq.getIsSupportParkDetection());
        basicInfo.getParkInfo().getIampInfo().get(0).setColor(basicInfoReq.getColor());
        basicInfo.getParkInfo().getIampInfo().get(0).setMode(basicInfoReq.getMode());
        basicInfo.getParkInfo().getIampInfo().get(0).setType(basicInfoReq.getType());
        basicInfo.getParkInfo().getIdInfo().get(0).setId(basicInfoReq.getId());
        basicInfo.getParkInfo().getIdInfo().get(0).setArea(basicInfoReq.getArea());
        ResultMap<String> resultMap = sendMsg(url, basicInfo);
        int keepAliveTime = Integer.parseInt(PropertiesUtils.readValue(constant, "keepalive"));
        if (0 >= keepAliveTime) {
            keepAliveTime = 30;    //默认30s
        }

        if ("200".equals(resultMap.getCode())) {
            ScheduledExecutorService oThreadExecutor = Executors.newScheduledThreadPool(1);
            oThreadExecutor.scheduleWithFixedDelay(new KeepAliveService(), 0, keepAliveTime, TimeUnit.SECONDS);
        }
        return resultMap;
    }

    /**
     * 车位告警
     */
    @RequestMapping("/parkAlarm")
    @ResponseBody
    public ResultMap<String> parkAlarm(ParkAlarmReq parkAlarmReq) {
        String url = AddressUtil.getAddress() + "/api/upark/parkalarm";
        System.out.println("车位告警信息url:" + url);
        ParkAlarm parkAlarm = new ParkAlarm();
        parkAlarm.setRecordId(parkAlarmReq.getRecordId());
        parkAlarm.setRoadId(parkAlarmReq.getRoadId());
        parkAlarm.getAlarmInfoReq().setArea(parkAlarmReq.getArea());
        parkAlarm.getAlarmInfoReq().setId(parkAlarmReq.getId());
        parkAlarm.getAlarmInfoReq().setCoverAlarm(parkAlarmReq.getCoverAlarm());
        parkAlarm.getAlarmInfoReq().setCrossAlarm(parkAlarmReq.getCrossAlarm());
        parkAlarm.setRoadName(parkAlarmReq.getRoadName());
        parkAlarm.setPicNum(1);
        parkAlarm.getPicInfoReq().get(0).setUrl("");
        parkAlarm.getPicInfoReq().get(0).setSize(12);
        parkAlarm.getPicInfoReq().get(0).setType(parkAlarmReq.getType());
        parkAlarm.getPicInfoReq().get(0).setData("");
        return sendMsg(url, parkAlarm);
    }



    /**
     * 过车抓拍
     */
    @RequestMapping("/capture")
    @ResponseBody
    public ResultMap<String> capture(CaptureReq captureReq) {
        String url = AddressUtil.getAddress() + "/api/upark/capture";
        System.out.println("过车抓拍url:" + url);
        Capture capture = new Capture();
        capture.setRecordId(captureReq.getRecordId());
        capture.setPicTime(sdf.format(new Date()));
        capture.setPlateNo(captureReq.getPlateNo());
        capture.setConfidence(captureReq.getConfidence());
        capture.setVehicleType(captureReq.getVehicleType());
        capture.setVehicleColor(captureReq.getVehicleColor());
        capture.setPlateType(captureReq.getPlateType());
        capture.setPlateColor(captureReq.getPlateColor());
        capture.setShootPosition(captureReq.getShootPosition());
        capture.setPicNum(1);
        capture.getPicInfo().get(0).setData("");
        capture.getPicInfo().get(0).setSize(12);
        capture.getPicInfo().get(0).setType(captureReq.getType());
        capture.getPicInfo().get(0).setUrl("");
        return sendMsg(url, capture);
    }

    /**
     * 车位状态
     */
    @RequestMapping("/parkStatus")
    @ResponseBody
    public ResultMap<String> parkStatus(ParkStatusReq parkStatusReq) {
        String url = AddressUtil.getAddress() + "/api/upark/parkstatus";
        System.out.println("车位状态:" + url);
        ParkStatus parkStatus = new ParkStatus();
        parkStatus.setRecordId(parkStatusReq.getRecordId());
        parkStatus.setRoadId(parkStatusReq.getRoadId());
        parkStatus.setRoadName(parkStatusReq.getRoadName());
        parkStatus.setPicTime(sdf.format(new Date()));
        parkStatus.getGpsInfo().setAltitude(parkStatusReq.getAltitude());
        parkStatus.getGpsInfo().setLatitude(parkStatusReq.getLatitude());
        parkStatus.getGpsInfo().setLongitude(parkStatusReq.getLongitude());
        parkStatus.setPicNum(1);
        parkStatus.getPicInfo().get(0).setUrl("");
        parkStatus.getPicInfo().get(0).setType(parkStatusReq.getType());
        parkStatus.getPicInfo().get(0).setSize(12);
        parkStatus.getPicInfo().get(0).setData("");
        parkStatus.getStatusInfo().setArea(parkStatusReq.getArea());
        parkStatus.getStatusInfo().setId(parkStatusReq.getId());
        parkStatus.getStatusInfo().setStatus(parkStatusReq.getStatus());
        parkStatus.getStatusInfo().setPlateNo(parkStatusReq.getPlateNo());
        parkStatus.getStatusInfo().setConfidence(parkStatusReq.getConfidence());
        parkStatus.getStatusInfo().setVehicleType(parkStatusReq.getVehicleType());
        parkStatus.getStatusInfo().setVehicleColor(parkStatusReq.getVehicleColor());
        parkStatus.getStatusInfo().setPlateType(parkStatusReq.getPlateType());
        parkStatus.getStatusInfo().setPlateColor(parkStatusReq.getPlateColor());
        parkStatus.getStatusInfo().setLedMode(parkStatusReq.getLedMode());
        parkStatus.getStatusInfo().setLedColor(parkStatusReq.getLedColor());
        return sendMsg(url, parkStatus);
    }

    /**
     * 透明通道
     */
    @RequestMapping("/transChannel")
    @ResponseBody
    public ResultMap<String> transChannel(String data) {
        String url = AddressUtil.getAddress() + "/api/upark/transchannel";
        Transchannel transchannel = new Transchannel();
        transchannel.setData(data);
        transchannel.setSize(data.length());
        return sendMsg(url, transchannel);
    }

    public ResultMap<String> sendMsg(String url, Object msgData)
    {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("version", PropertiesUtils.readValue(constant, "version"));
            jsonObject.put("parkId", PropertiesUtils.readValue(constant, "parkId"));
            jsonObject.put("deviceId", PropertiesUtils.readValue(constant, "deviceId"));
            jsonObject.put("params",msgData);
            HttpPost httpPost = new HttpPost(url);
            System.out.println("url" + jsonObject.toJSONString());
            String strResponse = ohHttp.sendHttpPostLive(jsonObject.toJSONString(), "application/json", httpPost);
            JSONObject requestJson = JSONObject.parseObject(strResponse);
            if (200 != requestJson.getInteger("code")) {
                return ResultMap.genErrorMap("服务端响应失败");
            }
            else {
                return ResultMap.genSuccessMap();
            }
        } catch (Exception e) {
            return ResultMap.genErrorMap("发送失败");
        }
    }

    public void writeProperties(BasicInfoReq basicInfoReq)
    {
        PropertiesUtils.updateProperties(constant, "serverIp", basicInfoReq.getServerIp());
        PropertiesUtils.updateProperties(constant, "serverPort", basicInfoReq.getServerPort());
        PropertiesUtils.updateProperties(constant, "version", basicInfoReq.getVersion());
        PropertiesUtils.updateProperties(constant, "parkId", basicInfoReq.getParkId());
        PropertiesUtils.updateProperties(constant, "deviceId", basicInfoReq.getDeviceId());
        PropertiesUtils.updateProperties(constant, "serialNum", basicInfoReq.getSerialNum());
        PropertiesUtils.updateProperties(constant, "senceType", basicInfoReq.getSenceType().toString());
        PropertiesUtils.updateProperties(constant, "softwareVersion", basicInfoReq.getSoftwareVersion());
        PropertiesUtils.updateProperties(constant, "keepalive", basicInfoReq.getKeepalive().toString());
        PropertiesUtils.updateProperties(constant, "deviceType", basicInfoReq.getDeviceType().toString());
        PropertiesUtils.updateProperties(constant, "resolution", basicInfoReq.getResolution());
        PropertiesUtils.updateProperties(constant, "serialNum", basicInfoReq.getSerialNum());
        PropertiesUtils.updateProperties(constant, "deviceName", basicInfoReq.getDeviceName());
        PropertiesUtils.updateProperties(constant, "shootPosition", basicInfoReq.getShootPosition().toString());
        PropertiesUtils.updateProperties(constant, "isSupportLamp", basicInfoReq.getIsSupportLamp().toString());
        PropertiesUtils.updateProperties(constant, "isSupportGate", basicInfoReq.getIsSupportGate().toString());
        PropertiesUtils.updateProperties(constant, "isSupprotCoil", basicInfoReq.getIsSupprotCoil().toString());
        PropertiesUtils.updateProperties(constant, "isSupportRadar", basicInfoReq.getIsSupportRadar().toString());
        PropertiesUtils.updateProperties(constant, "isSupportLED", basicInfoReq.getIsSupportLED().toString());
        PropertiesUtils.updateProperties(constant, "isSupportStore", basicInfoReq.getIsSupportStore().toString());
        PropertiesUtils.updateProperties(constant, "isSupportParkDetection", basicInfoReq.getIsSupportParkDetection().toString());
        PropertiesUtils.updateProperties(constant, "totalParkNum", basicInfoReq.getTotalParkNum().toString());
        PropertiesUtils.updateProperties(constant, "area", basicInfoReq.getArea());
        PropertiesUtils.updateProperties(constant, "id", basicInfoReq.getId());
        PropertiesUtils.updateProperties(constant, "type", basicInfoReq.getType().toString());
        PropertiesUtils.updateProperties(constant, "mode", basicInfoReq.getMode().toString());
        PropertiesUtils.updateProperties(constant, "color", basicInfoReq.getColor().toString());
    }


}
