package Client.Bean;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * json请求返回的数据结果
 *
 * @param <T> 返回结果带的数据
 */
public class ResultMap<T> {
    private String code;
    private String msg;
    private boolean result;
    private T data;

    public ResultMap() {
    }

    public ResultMap(String code, String msg, boolean result) {
        this.code = code;
        this.msg = msg;
        this.result = result;
    }

    public ResultMap(String code, String msg, boolean result, T data) {
        this.code = code;
        this.msg = msg;
        this.result = result;
        this.data = data;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public boolean isResult() {
        return result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }


    @JsonIgnore
    public static ResultMap<String> genSuccessMap() {
        return new ResultMap<String>(ResultCodeMsg.SUCCESS.getCode(), "成功", true, "");
    }

    @JsonIgnore
    public static ResultMap<String> genErrorMap(String msg) {
        return new ResultMap<String>(ResultCodeMsg.FAIL.getCode(), msg, false, "");
    }




}
