package Client.Service;

import Client.Util.PropertiesUtils;
import com.alibaba.fastjson.JSONObject;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Created by l05826 on 2020/7/30.
 * 下行消息接收处理  暂不处理
 */
public class DownwardMsgService
{
    public static String constant = System.getProperty("user.dir") + "/config/constant.properties";
    public static String capture = System.getProperty("user.dir") + "/config/captureResponse.properties";
    public static String reboot = System.getProperty("user.dir") + "/config/reboot.properties";
    public static String setLamp = System.getProperty("user.dir") + "/config/setLamp.properties";
    public static String list = System.getProperty("user.dir") + "/config/list.properties";
    public static String openGate = System.getProperty("user.dir") + "/config/openGate.properties";
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public void run(String topic, String msg, String defaultTopic)
    {
        if (!defaultTopic.equals(topic))
        {
            System.out.println("非订阅消息");
        }

        JSONObject jsonObject = JSONObject.parseObject(msg);
        String deviceId = jsonObject.getString("deviceId");
        String propertiesDeviceId = PropertiesUtils.readValue(constant, "deviceId");

        if(!"all".equals(deviceId) && !propertiesDeviceId.equals(deviceId))
        {
            System.out.println("非所有设备或当前设备处理消息");
        }

        int type = jsonObject.getInteger("type");

        switch (type)
        {
            case 1:  //1-手动抓拍；2-设备重启；3-设置车位灯；4-黑白名单同步；5-抬杆放行；6-透明通道
            {
                PropertiesUtils.writeProperties(capture, sdf.format(new Date()), msg);
                System.out.println("抓拍消息处理");
                break;
            }
            case 2:
            {
                PropertiesUtils.writeProperties(reboot, sdf.format(new Date()), msg);
                System.out.println("重启消息处理");
                break;
            }
            case 3:
            {
                PropertiesUtils.writeProperties(setLamp, sdf.format(new Date()), msg);
                System.out.println("车位灯消息处理");
                break;
            }
            case 4:
            {
                PropertiesUtils.writeProperties(list, sdf.format(new Date()), msg);
                System.out.println("名单消息处理");
                break;
            }
            case 5:
            {
                PropertiesUtils.writeProperties(openGate, sdf.format(new Date()), msg);
                System.out.println("开闸消息处理");
                break;
            }
            case 6:
            {
                System.out.println("透明通道消息处理");
                break;
            }
            default:
            {
                System.out.println("消息类型异常：" + type);
                break;
            }

        }


    }





}
