package Client.Service;

import Client.Bean.ResultCodeMsg;
import Client.Bean.request.KeepAliveInfo;
import Client.Util.AddressUtil;
import Client.Util.HttpClientUtil;
import Client.Util.PropertiesUtils;
import com.alibaba.fastjson.JSONObject;
import org.apache.http.client.methods.HttpPost;
import org.springframework.stereotype.Service;

/**
 * Created by l05826 on 2020/8/10.
 */
@Service
public class KeepAliveService implements Runnable {

    public static String constant = System.getProperty("user.dir") + "/config/constant.properties";
    HttpClientUtil ohHttp = HttpClientUtil.getInstance();

    @Override
    public void run() {
        //发送消息
        String url = AddressUtil.getAddress() + "/api/upark/keepalive";
        String result= sendMsg(url, new KeepAliveInfo());
        if ("200".equals(result)) {
            System.out.println("保活消息响应成功");
        } else {
            System.out.println("保活消息响应失败");
        }
    }


    public String sendMsg(String url, Object msgData) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("version", PropertiesUtils.readValue(constant, "version"));
            jsonObject.put("parkId", PropertiesUtils.readValue(constant, "parkId"));
            jsonObject.put("deviceId", PropertiesUtils.readValue(constant, "deviceId"));
            jsonObject.put("params", msgData);
            HttpPost httpPost = new HttpPost(url);
            String strResponse = ohHttp.sendHttpPostLive(jsonObject.toJSONString(), "application/json", httpPost);
            System.out.println("保活响应消息：" + strResponse);
            JSONObject requestJson = JSONObject.parseObject(strResponse);
            if (200 != requestJson.getInteger("code")) {
                return ResultCodeMsg.FAIL.getCode();
            } else {
                return ResultCodeMsg.SUCCESS.getCode();
            }
        } catch (Exception e) {
            return ResultCodeMsg.FAIL.getCode();
        }
    }
}

