package Server.Action;

import Server.Util.PropertiesUtils;
import Server.Util.RequestIdUtil;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.HashMap;

/**
 * Created by l05826 on 2020/7/29.
 * 界面获取后台数据接口
 */
@Controller
public class DemoWebMsg
{
    public static String strKeepAliveRecord = System.getProperty("user.dir") + "/Record/keepAlive.properties";
    public static String strBasicinfoRecord = System.getProperty("user.dir") + "/Record/basicInfo.properties";
    public static String strParkalarmRecord = System.getProperty("user.dir") + "/Record/parkAlarm.properties";
    public static String strTranschannelRecord = System.getProperty("user.dir") + "/Record/transChannel.properties";
    public static String strCaptureRecord = System.getProperty("user.dir") + "/Record/capture.properties";
    public static String strParkstatusRecord = System.getProperty("user.dir") + "/Record/parkStatus.properties";
    public static String strManualCapturePark = System.getProperty("user.dir") + "/Record/manualCapturePark.properties";
    public static String strManualCaptureCommon = System.getProperty("user.dir") + "/Record/manualCaptureCommon.properties";
    public static String strReboot = System.getProperty("user.dir") + "/Record/reboot.properties";
    public static String strLamp = System.getProperty("user.dir") + "/Record/lamp.properties";
    public static String strList = System.getProperty("user.dir") + "/Record/list.properties";
    public static String strGatecontrol = System.getProperty("user.dir") + "/Record/gatecontrol.properties";

    /**************************************************上行 Start*******************************/
    @RequestMapping("/index")
    public String index() {
        return "explain";
    }

    @RequestMapping("/uplink")
    public String uplink() {
        return "uplink";
    }

    @RequestMapping("/keepAlive")
    public String keepAlive(Model model) {
        HashMap<String,String> keepAlive= PropertiesUtils.readProperties(strKeepAliveRecord);
        model.addAttribute("mapKeepAliveRecord", keepAlive);
        return "keepAlive";
    }

    @RequestMapping("/basicInfo")
    public String basicInfo(Model model) {
        HashMap<String,String> basicInfo= PropertiesUtils.readProperties(strBasicinfoRecord);
        model.addAttribute("mapBasicinfoRecord", basicInfo);
        return "basicInfo";
    }

    @RequestMapping("/parkAlarm")
    public String parkAlarm(Model model) {
        HashMap<String,String> parkAlarm= PropertiesUtils.readProperties(strParkalarmRecord);
        model.addAttribute("mapParkAlarmRecord", parkAlarm);
        return "parkAlarm";
    }

    @RequestMapping("/capture")
    public String capture(Model model) {
        HashMap<String,String> capture= PropertiesUtils.readProperties(strCaptureRecord);
        model.addAttribute("mapCaptureRecord", capture);
        return "capture";
    }

    @RequestMapping("/parkStatus")
    public String parkStatus(Model model) {
        HashMap<String,String> parkStatus= PropertiesUtils.readProperties(strParkstatusRecord);
        model.addAttribute("mapParkStatusRecord", parkStatus);
        return "parkStatus";
    }
    @RequestMapping("/transChannel")
    public String transChannel(Model model) {
        HashMap<String,String> transChannel= PropertiesUtils.readProperties(strTranschannelRecord);
        model.addAttribute("mapTransChannelRecord", transChannel);
        return "transChannel";
    }

    /**************************************************上行 End*******************************/

    /**************************************************下行 Start*******************************/
    @RequestMapping("/downward")
    public String downwardExplain() {
        return "downward";
    }

    @RequestMapping("/downward/constant")
    public String downwardConstant(Model model) {
        model.addAttribute("requestId", RequestIdUtil.getRequestId());
        return "downwardConstant";
    }

    @RequestMapping("/downward/setLamp")
    public String downwardSetLamp(Model model) {
        model.addAttribute("requestId", RequestIdUtil.getRequestId());
        return "downwardSetLamp";
    }

    @RequestMapping("/downward/setVehicleList")
    public String downwardSetVehicleList(Model model) {
        model.addAttribute("requestId", RequestIdUtil.getRequestId());
        return "downwardSetVehicleList";
    }

    @RequestMapping("/downward/transChannel")
    public String downwardTransChannel(Model model) {
        model.addAttribute("requestId", RequestIdUtil.getRequestId());
        return "downwardTransChannel";
    }

    /**************************************************下行 End*******************************/

   /**************************************************下行 异步消息接收 End*******************************/

   @RequestMapping("/downwardResponse")
   public String downwardResponse() {
       return "downwardResponse";
   }


    @RequestMapping("/downwardResponse/park")
    public String downwardResponsePark(Model model) {
        HashMap<String,String> map = PropertiesUtils.readProperties(strManualCapturePark);
        model.addAttribute("mapManualCapturePark", map);
        return "downwardResponsePark";
    }

    @RequestMapping("/downwardResponse/common")
    public String downwardResponseCommon(Model model) {
        HashMap<String,String> map= PropertiesUtils.readProperties(strManualCaptureCommon);
        model.addAttribute("mapManualCaptureCommon", map);
        return "downwardResponseCommon";
    }


    @RequestMapping("/downwardResponse/reboot")
    public String downwardResponseReboot(Model model) {
        HashMap<String,String> map = PropertiesUtils.readProperties(strReboot);
        model.addAttribute("mapReboot", map);
        return "downwardResponseReboot";
    }

    @RequestMapping("/downwardResponse/lamp")
    public String downwardResponseLamp(Model model) {
        HashMap<String,String> map= PropertiesUtils.readProperties(strLamp);
        model.addAttribute("mapLamp", map);
        return "downwardResponseLamp";
    }

    @RequestMapping("/downwardResponse/list")
    public String downwardResponseList(Model model) {
        HashMap<String,String> map= PropertiesUtils.readProperties(strList);
        model.addAttribute("mapList", map);
        return "downwardResponseList";
    }

    @RequestMapping("/downwardResponse/gatecontrol")
    public String downwardResponseGatecontrol(Model model) {
        HashMap<String,String> map= PropertiesUtils.readProperties(strGatecontrol);
        model.addAttribute("mapGatecontrol", map);
        return "downwardResponseGatecontrol";
    }
}
