package Server.Action;

import Server.Util.HttpMsgUtils;
import Server.Util.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Created by l05826 on 2020/7/30.
 * 下行接口接收http异步响应
 */
@Controller
@RequestMapping("/api/upark/notifyresult")
public class DownwardRecvMsg {

    protected static Logger logger = LoggerFactory.getLogger(DownwardRecvMsg.class);
    public static String strManualCapturePark = System.getProperty("user.dir") + "/Record/manualCapturePark.properties";
    public static String strManualCaptureCommon = System.getProperty("user.dir") + "/Record/manualCaptureCommon.properties";
    public static String strReboot = System.getProperty("user.dir") + "/Record/reboot.properties";
    public static String strLamp = System.getProperty("user.dir") + "/Record/lamp.properties";
    public static String strList = System.getProperty("user.dir") + "/Record/list.properties";
    public static String strGatecontrol = System.getProperty("user.dir") + "/Record/gatecontrol.properties";
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    /**
     * 手动抓拍异步上报(车位)
     */
    @RequestMapping("/notifyresult/manualcapture/park")
    public void notifyresultManualCapturePark(HttpServletRequest request)
    {
        logger.info("接收到手动抓拍异步上报(车位)消息");
        try {
            String temp = HttpMsgUtils.getHttpBodyMsg(request.getInputStream());
            System.out.println(temp);
            PropertiesUtils.writeProperties(strManualCapturePark, sdf.format(new Date()), temp);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 手动抓拍异步上报(出入口)
     */
    @RequestMapping("/notifyresult/manualcapture/common")
    public void notifyresultManualCaptureCommon(HttpServletRequest request)
    {
        logger.info("接收到手动抓拍异步上报(出入口)消息");
        try {
            String temp = HttpMsgUtils.getHttpBodyMsg(request.getInputStream());
            System.out.println(temp);
            PropertiesUtils.writeProperties(strManualCaptureCommon, sdf.format(new Date()), temp);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 重启上报
     */
    @RequestMapping("/notifyresult/reboot")
    public void notifyresultReboot(HttpServletRequest request)
    {
        logger.info("接收到重启结果消息");
        try {
            String temp = HttpMsgUtils.getHttpBodyMsg(request.getInputStream());
            System.out.println(temp);
            PropertiesUtils.writeProperties(strReboot, sdf.format(new Date()), temp);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 车位灯异步上报
     */
    @RequestMapping("/notifyresult/lamp")
    public void notifyresultLamp(HttpServletRequest request)
    {
        logger.info("接收到车位灯异步上报消息");
        try {
            String temp = HttpMsgUtils.getHttpBodyMsg(request.getInputStream());
            System.out.println(temp);
            PropertiesUtils.writeProperties(strLamp, sdf.format(new Date()), temp);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 名单异步上报
     */
    @RequestMapping("/notifyresult/list")
    public void notifyresultList(HttpServletRequest request)
    {
        logger.info("接收到名单异步上报消息");
        try {
            String temp = HttpMsgUtils.getHttpBodyMsg(request.getInputStream());
            System.out.println(temp);
            PropertiesUtils.writeProperties(strList, sdf.format(new Date()), temp);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 开闸放行异步上报
     */
    @RequestMapping("/notifyresult/gatecontrol")
    public void notifyresultGatecontrol(HttpServletRequest request)
    {
        logger.info("接收到开闸放行异步上报上报消息");
        try {
            String temp = HttpMsgUtils.getHttpBodyMsg(request.getInputStream());
            System.out.println(temp);
            PropertiesUtils.writeProperties(strGatecontrol, sdf.format(new Date()), temp);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
