package Server.Action;

import Server.Bean.Downward.*;
import Server.Bean.ResultMap;
import Server.IService.MqttGateway;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * Created by l05826 on 2020/7/28.
 * 下行消息发送Mqtt
 */

@RestController
public class DownwardSendMsg
{
    protected static Logger logger = LoggerFactory.getLogger(UplinkMsg.class);

    @Autowired
    private MqttGateway mqttGateway;

    /**
     * 手动抓拍车位
     */
    @RequestMapping("/sendCapturePark")
    @ResponseBody
    public ResultMap<String> capturePark(DowmwardRequestHeadMsg headMsg) {
        String topic = "request_" + headMsg.getParkId();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("requestId" , headMsg.getRequestId());
        jsonObject.put("version" , headMsg.getVersion());
        jsonObject.put("parkId" , headMsg.getParkId());
        jsonObject.put("deviceId" , headMsg.getDeviceId());
        jsonObject.put("type", 1); //1-手动抓拍；2-设备重启；3-设置车位灯；4-黑白名单同步；5-抬杆放行；6-透明通道
        jsonObject.put("params" , new Object());
        mqttGateway.sendToMqtt(jsonObject.toJSONString(), topic);
        System.out.println(topic + "send message : " + jsonObject.toJSONString());
        return ResultMap.genSuccessMap();
    }


    /**
     * 手动抓拍出入口
     */
    @RequestMapping("/sendCaptureCommon")
    @ResponseBody
    public ResultMap<String> captureCommon(DowmwardRequestHeadMsg headMsg) {
        String topic = "request_" + headMsg.getParkId();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("requestId" , headMsg.getRequestId());
        jsonObject.put("version" , headMsg.getVersion());
        jsonObject.put("parkId" , headMsg.getParkId());
        jsonObject.put("deviceId" , headMsg.getDeviceId());
        jsonObject.put("type", 1); //1-手动抓拍；2-设备重启；3-设置车位灯；4-黑白名单同步；5-抬杆放行；6-透明通道
        jsonObject.put("params" , new Object());
        mqttGateway.sendToMqtt(jsonObject.toJSONString(), topic);
        System.out.println(topic + "send message : " + jsonObject.toJSONString());
        return ResultMap.genSuccessMap();
    }


    /**
     * 设备重启
     */
    @RequestMapping("/sendReboot")
    @ResponseBody
    public ResultMap<String> reboot(DowmwardRequestHeadMsg headMsg) {
        String topic = "request_" + headMsg.getParkId();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("requestId" , headMsg.getRequestId());
        jsonObject.put("version" , headMsg.getVersion());
        jsonObject.put("parkId" , headMsg.getParkId());
        jsonObject.put("deviceId" , headMsg.getDeviceId());
        jsonObject.put("type", 2); //1-手动抓拍；2-设备重启；3-设置车位灯；4-黑白名单同步；5-抬杆放行；6-透明通道
        jsonObject.put("params" , new Object());
        mqttGateway.sendToMqtt(jsonObject.toJSONString(), topic);
        System.out.println(topic + "send message : " + jsonObject.toJSONString());
        return ResultMap.genSuccessMap();
    }

    /**
     * 开闸放行
     */
    @RequestMapping("/sendOpenGate")
    @ResponseBody
    public ResultMap<String> openGate(DowmwardRequestHeadMsg headMsg) {
        String topic = "request_" + headMsg.getParkId();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("requestId" , headMsg.getRequestId());
        jsonObject.put("version" , headMsg.getVersion());
        jsonObject.put("parkId" , headMsg.getParkId());
        jsonObject.put("deviceId" , headMsg.getDeviceId());
        jsonObject.put("type", 5); //1-手动抓拍；2-设备重启；3-设置车位灯；4-黑白名单同步；5-抬杆放行；6-透明通道
        jsonObject.put("params" , new Object());
        mqttGateway.sendToMqtt(jsonObject.toJSONString(), topic);
        System.out.println(topic + "send message : " + jsonObject.toJSONString());
        return ResultMap.genSuccessMap();
    }

    /**
     * 设置车位灯
     */
    @RequestMapping("/sendSetLamp")
    @ResponseBody
    public ResultMap<String> setLamp(IampParam headMsg) {
        String topic = "request_" + headMsg.getParkId();
        IampControllerReq iampControllerReq = new IampControllerReq();
        iampControllerReq.setNum(1);
        iampControllerReq.setLampCtrlMode(headMsg.getLampCtrlMode());
        iampControllerReq.getIampInfo().get(0).setId(headMsg.getSpaceId());
        iampControllerReq.getIampInfo().get(0).setColor(headMsg.getColor());
        iampControllerReq.getIampInfo().get(0).setMode(headMsg.getMode());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("requestId" , headMsg.getRequestId());
        jsonObject.put("version" , headMsg.getVersion());
        jsonObject.put("parkId" , headMsg.getParkId());
        jsonObject.put("deviceId" , headMsg.getDeviceId());
        jsonObject.put("type", 3); //1-手动抓拍；2-设备重启；3-设置车位灯；4-黑白名单同步；5-抬杆放行；6-透明通道
        jsonObject.put("params" ,iampControllerReq);
        mqttGateway.sendToMqtt(jsonObject.toJSONString(), topic);
        System.out.println(topic + "send message : " + jsonObject.toJSONString());
        return ResultMap.genSuccessMap();
    }

    /**
     * 黑名单同步
     */
    @RequestMapping("/sendVehicleList")
    @ResponseBody
    public ResultMap<String> setVehicleList(VehicleListSyncParam headMsg) {
        String topic = "request_" + headMsg.getParkId();
        VehicleListSync vehicleListSync = new VehicleListSync();
        vehicleListSync.setListType(headMsg.getListType());
        vehicleListSync.setNum(1);
        vehicleListSync.setMode(headMsg.getMode());
        vehicleListSync.getListInfo().get(0).setStartTime(headMsg.getStartTime());
        vehicleListSync.getListInfo().get(0).setEndTime(headMsg.getEndTime());
        vehicleListSync.getListInfo().get(0).setPlateNo(headMsg.getPlateNo());

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("requestId" , headMsg.getRequestId());
        jsonObject.put("version" , headMsg.getVersion());
        jsonObject.put("parkId" , headMsg.getParkId());
        jsonObject.put("deviceId" , headMsg.getDeviceId());
        jsonObject.put("type", 4); //1-手动抓拍；2-设备重启；3-设置车位灯；4-黑白名单同步；5-抬杆放行；6-透明通道
        jsonObject.put("params" ,vehicleListSync);
        mqttGateway.sendToMqtt(jsonObject.toJSONString(), topic);
        System.out.println(topic + "send message : " + jsonObject.toJSONString());
        return ResultMap.genSuccessMap();
    }

    /**
     * 透明通道
     */
    @RequestMapping("/sendTransChannel")
    @ResponseBody
    public ResultMap<String> transChannel(TranschannelParam headMsg) {
        String topic = "request_" + headMsg.getParkId();
        TranschannelParam transchannelParam =new TranschannelParam();
        transchannelParam.setData(headMsg.getData());
        transchannelParam.setType(headMsg.getType());
        transchannelParam.setSize(headMsg.getData().length());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("requestId" , headMsg.getRequestId());
        jsonObject.put("version" , headMsg.getVersion());
        jsonObject.put("parkId" , headMsg.getParkId());
        jsonObject.put("deviceId" , headMsg.getDeviceId());
        jsonObject.put("type", 6); //1-手动抓拍；2-设备重启；3-设置车位灯；4-黑白名单同步；5-抬杆放行；6-透明通道
        jsonObject.put("params" ,transchannelParam);
        mqttGateway.sendToMqtt(jsonObject.toJSONString(), topic);
        System.out.println(topic + "send message : " + jsonObject.toJSONString());
        return ResultMap.genSuccessMap();
    }
}
