package Server.Action;

import Server.Bean.Uplink.*;
import Server.Util.HttpMsgUtils;
import Server.Util.PropertiesUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;

/**
 * Created by l05826 on 2020/7/28.
 * 上行接口接收及响应
 */
@Controller
@RequestMapping("/api/upark")
public class UplinkMsg {

    protected static Logger logger = LoggerFactory.getLogger(UplinkMsg.class);

    public static String strKeepAliveRecord = System.getProperty("user.dir") + "/Record/keepAlive.properties";
    public static String strBasicinfoRecord = System.getProperty("user.dir") + "/Record/basicInfo.properties";
    public static String strParkalarmRecord = System.getProperty("user.dir") + "/Record/parkAlarm.properties";
    public static String strTranschannelRecord = System.getProperty("user.dir") + "/Record/transchannel.properties";
    public static String strCaptureRecord = System.getProperty("user.dir") + "/Record/capture.properties";
    public static String strParkstatusRecord = System.getProperty("user.dir") + "/Record/parkStatus.properties";
    public static String strPicPath = System.getProperty("user.dir") + "/Pic";


    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    static int count =1;

    /**
     * 相机上报基础数据
     */
    @RequestMapping("/basicinfo")
    @ResponseBody
    public String basicInfo(HttpServletRequest request)
    {
        logger.info("接收到基础消息:");
        try {
            String strBasicInfo = HttpMsgUtils.getHttpBodyMsg(request.getInputStream());
            logger.info(strBasicInfo);
            PropertiesUtils.writeProperties(strBasicinfoRecord, sdf.format(new Date()), strBasicInfo);
            //接收数据平台根据业务处理
            return responseBuild(200, "success");
        } catch (IOException e) {
            e.printStackTrace();
            return responseBuild(101, "common error");
        }

    }


    /**
     *  相机上报保活消息
     */
    @RequestMapping("/keepalive")
    @ResponseBody
    public String keepAlive(HttpServletRequest request)
    {
        logger.info("接收到保活消息");
        try {
            String strKeepAlive = HttpMsgUtils.getHttpBodyMsg(request.getInputStream());
            System.out.println(strKeepAlive);
            PropertiesUtils.writeProperties(strKeepAliveRecord, sdf.format(new Date()), strKeepAlive);
            return keepAliveMsgResponseBuild(200, "success");
        } catch (Exception e) {
            logger.error("保活消息异常" + e);
            return responseBuild(101, "common error");
        }
    }


    /**
     * 相机上报车位告警
     */
    @RequestMapping("/parkalarm")
    @ResponseBody
    public String parkAlarm(HttpServletRequest request)
    {
        logger.info("接收到车位告警消息");
        try {
            String strParkalarm = HttpMsgUtils.getHttpBodyMsg(request.getInputStream());
            System.out.println(strParkalarm);
            PropertiesUtils.writeProperties(strParkalarmRecord, sdf.format(new Date()), strParkalarm);
            return responseBuild(200, "success");
        } catch (IOException e) {
            e.printStackTrace();
            return responseBuild(101, "common error");
        }
    }

    /**
     * 相机上报透明通道
     */
    @RequestMapping("/transchannel")
    @ResponseBody
    public String transChannel(HttpServletRequest request)
    {
        logger.info("接收到透明通道消息");
        try {
            String strTranschannel = HttpMsgUtils.getHttpBodyMsg(request.getInputStream());
            System.out.println(strTranschannel);
            PropertiesUtils.writeProperties(strTranschannelRecord, sdf.format(new Date()), strTranschannel);
            return responseBuild(200, "success");
        } catch (IOException e) {
            e.printStackTrace();
            return responseBuild(101, "common error");
        }
    }

    /**
     *  相机上报过车抓拍
     */
    @RequestMapping("/capture")
    @ResponseBody
    public String capture(HttpServletRequest request) {
        logger.info("接收到过车抓拍消息");
        try {
            String strCapture = HttpMsgUtils.getHttpBodyMsg(request.getInputStream());

            System.out.println(strCapture);
            PropertiesUtils.writeProperties(strCaptureRecord, sdf.format(new Date()), strCapture);

            JSONObject data = (JSONObject) JSONObject.parseObject(strCapture).get("params");
            //上报的数据默认已同步该停车场数据
            JSONArray jsonArray = data.getJSONArray("picInfo");

            for (int i = 0; i < (Integer) data.get("picNum"); i++) {
                JSONObject dataPicInfo = (JSONObject) jsonArray.get(i);
                String picData = dataPicInfo.getString("data");

                Base64.Decoder decoder = Base64.getDecoder();
                byte[] bytes = decoder.decode(picData);
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream("E:\\pic" + count + ".jpg");
                    count++;
                    fos.write(bytes);
                    System.out.println("成功");

                } catch (IOException e) {
                    e.printStackTrace();
                    return responseBuild(101, "common error");
                } finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            return responseBuild(200, "success");
        } catch (IOException e) {
            e.printStackTrace();
            return responseBuild(101, "common error");
        }
    }


    /**
     * 相机上报车位状态
     */
    @RequestMapping("/parkstatus")
    @ResponseBody
    public String parkStatus(HttpServletRequest request)
    {
        logger.info("接收到车位状态消息");
        try {
            String strParkstatus = HttpMsgUtils.getHttpBodyMsg(request.getInputStream());
            System.out.println(strParkstatus);
            PropertiesUtils.writeProperties(strParkstatusRecord, sdf.format(new Date()), strParkstatus);
            return responseBuild(200, "success");
        } catch (IOException e) {
            e.printStackTrace();
            return responseBuild(101, "common error");
        }
    }



    /**
     * 保活消息
     */
    public String keepAliveMsgResponseBuild(int errorCode, String message)
    {
        UplinkResponseHeadMsg responseHeadMsg = new UplinkResponseHeadMsg();
        KeepAliveInfoRes keepAliveInfoRes = new KeepAliveInfoRes();
        responseHeadMsg.setCode(errorCode);
        responseHeadMsg.setMessage(message);
        keepAliveInfoRes.setSvrTime((int) (System.currentTimeMillis() / 1000));      //时间戳为秒级
        responseHeadMsg.setData(keepAliveInfoRes);
        System.out.println("保活消息发送" + responseHeadMsg.toJsonString());
        return responseHeadMsg.toJsonString();
    }

    public String responseBuild(int errorCode, String message)
    {
        ResponseDataString data = new ResponseDataString();
        UplinkResponseHeadMsg<ResponseDataString> responseHeadMsg = new UplinkResponseHeadMsg(data);
        responseHeadMsg.setCode(errorCode);
        responseHeadMsg.setMessage(message);
        return responseHeadMsg.toJsonString();
    }


}
