package Server.Bean;

import com.alibaba.fastjson.JSON;

import java.lang.reflect.Field;

public abstract class IProtocolAccessData {
    public String toJsonString() {
        return JSON.toJSONString(this);
    }

    public void parseJson(String json) throws Exception{
        Object newInstance = JSON.parseObject(json, this.getClass());
        copyNotNullProperties(newInstance, this);
        return ;
    }

    public static void copyNotNullProperties(Object source, Object target) throws Exception{
        Class sourceClass = source.getClass();
        Class targetClass = target.getClass();
        for (Field field : sourceClass.getDeclaredFields()) {
            field.setAccessible(true);
            if (null != field.get(source)) {
                try {
                    Field targetField = targetClass.getDeclaredField(field.getName());
                    targetField.setAccessible(true);
                    targetField.set(target,field.get(source));
                }catch (Exception e){

                }
            }
        }
    }
}
