package Server.Bean;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * json请求返回的数据结果
 *
 * @param <T> 返回结果带的数据
 */
public class ResultMap<T> {
    private String code;
    private String msg;
    private boolean result;
    private T data;

    public ResultMap() {
    }

    public ResultMap(String code, String msg, boolean result) {
        this.code = code;
        this.msg = msg;
        this.result = result;
    }

    public ResultMap(String code, String msg, boolean result, T data) {
        this.code = code;
        this.msg = msg;
        this.result = result;
        this.data = data;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public boolean isResult() {
        return result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    /**
     * @Author : 眭世亮
     * @Description : 简单返回成功resultMap
     * @Date : 2019/1/22 10:06
     */
    @JsonIgnore
    public static ResultMap<String> genSuccessMap() {
        return new ResultMap<String>(ResultCodeMsg.SUCCESS.getCode(), "操作成功", true, "");
    }

    /**
     * @Author : 眭世亮
     * @Description : 简单返回失败resultMap
     * @Param : msg ： 错误提示信息
     * @Date : 2019/1/22 10:07
     */
    @JsonIgnore
    public static ResultMap<String> genErrorMap(String msg) {
        return new ResultMap<String>(ResultCodeMsg.FAIL.getCode(), msg, false, "");
    }

    /**
     * @Author : wangliming
     * @Description : 简单返回失败resultMap
     * @Param : msg ： 错误提示信息
     * @Date : 2019/1/22 11:44
     */
    @JsonIgnore
    public static <T> ResultMap<T> genErrorObjectMap(String msg) {
        return ResultMap.genErrorObjectMap(msg, null);
    }

    @JsonIgnore
    public static <T> ResultMap<T> genErrorObjectMap(String msg, T t) {
        return new ResultMap<T>(ResultCodeMsg.FAIL.getCode(), msg, false, t);
    }


    /**
     * @Author : wangliming
     * @Description : 返回成功时所带参数Data，其他固定
     * @Param :
     * @Date : 2019/1/22 11:44
     */
    @JsonIgnore
    public static <T> ResultMap<T> genSuccessObjectMap(T t) {
        return new ResultMap<T>(ResultCodeMsg.SUCCESS.getCode(), "操作成功", true, t);
    }

    /**
     * @Author : wangliming
     * @Description : 分页操作所需的要包装给页面组件的工具方法
     * @Param :
     * @Date : 2019/1/22 11:44
     */
  /*  @JsonIgnore
    public static ResultMap<Map<String, Object>> genSuccessMap(Page page,String draw) {
        ResultMap<Map<String, Object>> resultMap = new ResultMap<Map<String, Object>>();
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("data", page.getList());
        map.put("draw", draw);
        map.put("recordsTotal", page.getList().size());
        map.put("recordsFiltered", page.getTotalRow());
        return new ResultMap<Map<String, Object>>(ResultCodeMsg.SUCCESS.getCode(), "操作成功", true, map);
    }*/
}
