package Server.Bean.Uplink;

import Server.Bean.IProtocolAccessData;
import com.alibaba.fastjson.JSONObject;

/**
 * Created by l05826 on 2020/7/28.
 * 请求头参数
 */
public class UplinkRequestHeadMsg<T extends IProtocolAccessData> extends IProtocolAccessData {
    private String version;              //协议版本号，默认“1.0”
    private String parkId;               //停车场编号，由平台统一提供
    private String deviceId;             //设备编码，用以区分同一车场下不同设备
    private String params;              //具体的参数
    private T msgData;

    public UplinkRequestHeadMsg(){
    }
    public UplinkRequestHeadMsg(T data){
        msgData = data;
    }

    @Override
    public void parseJson(String json) throws Exception{
        super.parseJson(json);
        JSONObject dataJson = JSONObject.parseObject(getParams());
        msgData.parseJson(dataJson.getString("params"));
        return ;
    }

    @Override
    public String toJsonString() {
        String dataStr = msgData.toJsonString();
        JSONObject json = new JSONObject();
        json.put("params", dataStr);
        String jsonStr = super.toJsonString();
        return jsonStr;
    }
    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getParkId() {
        return parkId;
    }

    public void setParkId(String parkId) {
        this.parkId = parkId;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getParams() {
        return params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public T getMsgData() {
        return msgData;
    }

    public void setMsgData(T msgData) {
        this.msgData = msgData;
    }

    @Override
    public String toString() {
        return "RequestMsg{" +
                "version='" + version + '\'' +
                ", parkId='" + parkId + '\'' +
                ", deviceId='" + deviceId + '\'' +
                ", params=" + params +
                '}';
    }
}
