package Server.Util;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

/**
 * @Auther: wangliming
 * @Date: 2019/2/27 15
 * @Description:
 */
@Component
public class ApplicationContextProviderUtil implements ApplicationContextAware {

    private static ApplicationContext applicationContext;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    /**
     *  通过类名获取Bean
     * @param:
     * @return:
     * @auther: wangliming
     * @date: 2019/2/27 15:30
     */
    public static Object getBean(String name)throws Exception{
        return getApplicationContext().getBean(name);
    }

    /**
     *  通过class获取Bean
     * @param:
     * @return:
     * @auther: wangliming
     * @date: 2019/2/27 15:30
     */
    public static <T> T getBean(Class<T> clazz)throws Exception{
        return getApplicationContext().getBean(clazz);
    }

    /**
     * 通过类名,以及Clazz返回指定的Bean
     * @param name
     * @param clazz
     * @param <T>
     * @return
     */
    public static <T> T getBean(String name,Class<T> clazz){
        return getApplicationContext().getBean(name, clazz);
    }

}
