var objApp = WizExplorerApp;
var objCommon = objApp.CreateWizObject("WizKMControls.WizCommonUI");
//
var objSrcDatabase = objApp.Database;
//

var appGUID = objApp.CurPluginAppGUID;
//

function jsAlert(msg) {
    objApp.Window.ShowMessage(msg, "{p}", 0x00000040);
}

function pathFileExists(path) {
    return objCommon.PathFileExists(path);
}
function deleteFile(fileName) {
    objCommon.DeletePathFile(fileName);
}
function ensurePathExists(path) {
    objCommon.CreatePath(path);
}
function copyFile(src, dest) {
    objCommon.CopyFile(src, dest);
}

function extractFileName(path) {
    var index = path.lastIndexOf("\\");
    if (index != -1)
        return path.substr(index + 1, path.length - index - 1);
    return path;
}
function extractFilePath(path) {
    var index = path.lastIndexOf("\\");
    if (index != -1)
        return path.substr(0, index + 1);
    return path;
}
function extractFileExt(path) {
    var name = extractFileName(path);
    var index = name.lastIndexOf(".");
    if (index != -1)
        return name.substr(index, path.length - index);
    return "";
}
function extractFileTitle(path) {
    var name = extractFileName(path);
    var index = name.lastIndexOf(".");
    if (index != -1)
        return name.substr(0, index);
    return name;
}


function getNextFileName(filename) {
    if (!pathFileExists(filename))
        return filename;
    var path = extractFilePath(filename);
    var title = extractFileTitle(filename);
    var ext = extractFileExt(filename);
    //
    for (var i = 1; ; i++) {
        var newName = path + title + "(" + i + ")" + ext;
        if (!pathFileExists(newName))
            return newName;
    }
}
//
//
//

function copyDocuments(documents) {
    var objDestDatabase = objApp.CreateWizObject("WizKMCore.WizDatabase");
    try {
        objDestDatabase.Open("*");
        //
        if (objDestDatabase.DatabasePath == objSrcDatabase.DatabasePath) {
            jsAlert(objApp.LoadPluginString(appGUID, "strSelectOtherAccount"));
            return;

        }
        //
        var prompt = objApp.LoadPluginString(appGUID, "strSelectFolder");
        var objDestFolder = objCommon.SelectWizFolder2(objDestDatabase.DatabasePath, objDestDatabase.GetUserPassword(), prompt);
        if (!objDestFolder)
            return;
        //
        var destPath = objDestFolder.FullPath;
        //
        var objProgress = objApp.CreateWizObject("WizKMControls.WizProgressWindow");
        objProgress.Title = objApp.LoadPluginString(appGUID, "strCopying");
        objProgress.Max = documents.Count;
        objProgress.Show();
        //
        try {
            for (var i = 0; i < documents.Count; i++) {
                var docSrc = documents.Item(i);
                var docDest = docSrc.CopyTo(objDestFolder);
                //
                objProgress.Pos = i + 1;
            }
        }
        finally {
            objProgress.Hide();
            objProgress.Destroy();
        }
    }
    catch (err) {
        alert(err.message);
    }
}

function init() {
    var documents = objApp.Window.DocumentsCtrl.SelectedDocuments;
    if (documents == null || documents.Count == 0) {
        var msg = objApp.LoadPluginString(appGUID, "strNoDocumentsSelected");
        jsAlert(msg);
        return;
    }
    //
    copyDocuments(documents);
}

init();

