function GetFolderSEO(objFolder) {
    var path = objFolder.FullPath;
    var inifilename = path + "wizfolder.ini";
    //
    var seo = "";
    try {
        seo = objCommon.GetValueFromIni(inifilename, "Common", "SEO");
    }
    catch (err) {
    }
    //
    if (seo == null
        || seo.length == 0) {
        return objFolder.GetDisplayName(0);
    }
    //
    return seo;
}
//
function SetFolderSEO(objFolder, seo) {
    var path = objFolder.FullPath;
    var inifilename = path + "wizfolder.ini";
    //
    objCommon.SetValueToIni(inifilename, "Common", "SEO", seo);
}
//
function GetGroupFolderSEO (objGroupFolder) {

    var seo = "";
    try {
        var seos = objDatabase.GetMeta("Common", "WizGroupFolderSeo");
        var arraySeos = seos.split('*');
        //
        if (arraySeos && arraySeos.length > 0) {
            var guid = objGroupFolder.GUID;
            //
            for (var i = 0; i < arraySeos.length; i ++) {
                var keyvalue = arraySeos[i];
                //
                if (keyvalue && -1 != keyvalue.indexOf(guid)) {
                    seo = keyvalue.substr(keyvalue.indexOf('=') + 1);
                    break;
                }
            }
        }
    }
    catch (err) {
    }
    if (seo == null
        || seo.length == "") {
        seo = objGroupFolder.Name;
    }
    //
    return seo;
}
//
function SetGroupFolderSEO (objGroupFolder, seo) {
    
    try {
        var seos = objDatabase.GetMeta("Common", "WizGroupFolderSeo");
        var arraySeos = !!seos ? seos.split('*') : [];
        //
        if (arraySeos && arraySeos.length > 0) {
            var guid = objGroupFolder.GUID;
            //
            for (var i = 0; i < arraySeos.length; i ++) {
                var keyvalue = arraySeos[i];
                //
                if (keyvalue && -1 != keyvalue.indexOf(guid)) {
                    arraySeos[i] = guid + "=" + seo;
                    break;
                }
            }
            if (i == arraySeos.length) {
                arraySeos.push(objGroupFolder.GUID + "=" + seo);
            }
        }
        else {
            arraySeos.push(objGroupFolder.GUID + "=" + seo);
        }
        //
        var keyvalue = arraySeos.join('*');
        objDatabase.SetMeta("Common", "WizGroupFolderSeo", keyvalue);
    }
    catch (err) {
    }        
}