var objApp = WizExplorerApp;
var objCommon = objApp.CreateWizObject("WizKMControls.WizCommonUI");
var objSettings = objApp.CreateWizObject("WizKMCore.WizSettings");

objSettings.Open(objApp.SettingsFileName);

function GetVoiceName() {
    return objSettings.GetStringValue("Plugin_Speech", "VocieName");
}

function CallWizTTS(text, voiceName) {
    var tmpfilename = objCommon.GetATempFileName(".txt");
    objCommon.SaveTextToFile(tmpfilename, text, "unicode");
    //
    var exefilename = objApp.AppPath + "Wiz.exe";
    var params = "\"" + objApp.AppPath + "WizTools.dll" + "\" WizTTSSpeech2 /VoiceName=" + voiceName + " /TextFileName=" + tmpfilename;
    //
    objCommon.RunExe(exefilename, params, false);
}

var objWindow = objApp.Window;
var objCurrentBrowserObject = objWindow.CurrentDocumentBrowserObject;
//
var voiceName = GetVoiceName();
//

function SpeakDocument(browserObject, sel) {
    //
    var path = objApp.CurPluginAppPath;
    var jsFileName = path + "GetText.js";
    //
    browserObject.ExecuteScript("__wizSel = " + (sel ? "true" : "false") + ";", function () {
        browserObject.ExecuteScriptFile(jsFileName, function (text) {
            if (text && text.length > 0) {
                CallWizTTS(text, voiceName);
            }
        });
    }); 
}

SpeakDocument(objCurrentBrowserObject, false);
