function getSelectionText() {
    var sel = document.getSelection();
    var rgnCount = sel.rangeCount;
    var container = document.createElement("DIV");
    for (var i = 0; i < rgnCount; i++) {
        var rgn = sel.getRangeAt(i);
        var contents = rgn.cloneContents();
        container.appendChild(contents);
    }
    document.body.appendChild(container);
    var text = container.innerText;
    document.body.removeChild(container);
    return text;
}

function processTab(tabHtml, prev) {
    var selElem = document.getSelection().focusNode;
    if (!selElem)
        return false;
    if (selElem.nodeType == 3) {
        selElem = selElem.parentElement;
    }
    //
    var tagName = selElem.tagName;
    if (prev) {
        if (tagName == "TD") {
            return false;
        }
        //
        document.execCommand("outdent");
        return true;
    }
    //
    var textSelected = false;
    var text = getSelectionText();
    if (text && text != "")
        textSelected = true;
    //
    if (textSelected || tagName == "UL" || tagName == "OL" || tagName == "LI") {
        document.execCommand("indent");
        return true;
    } else if (tagName == "TD") {
        WizOldEditor.switchNextCell(document);
        return true;
    } else if (tagName == "U"
                    || tagName == "I"
                    || tagName == "STRONG"
                    || tagName == "B"
                    || tagName == "A"
                    || tagName == "SPAN"
                    || tagName == "FONT"
                    || tagName == "DIV"
                    || tagName == "P"
                    || tagName == "BODY"
                    || tagName == "HTML") {
        document.execCommand("insertHTML", false, tabHtml);
        return true;
    }
    //
    return false;
}

processTab('__tabHtml', __prev);

