
////////////////////////////////////////////////////////////////////////////////////////////////

function TP_alert(msg) {
    return window.external.ShowMessage(msg, 0);
}

function TP_indexOfArray(arr, item) {
    for (var i = 0; i < arr.length; i++) {
        if (arr[i] == item)
            return i;
    }
    return -1;
}
function TP_indexOfArrayNoCase(arr, item) {
    item = item.toLowerCase();
    for (var i = 0; i < arr.length; i++) {
        if (arr[i].toLowerCase() == item)
            return i;
    }
    return -1;
}

function TP_getParents(node, parentsTagName) {
    if (!node)
        return null;
    var arrTagNames = parentsTagName.toUpperCase().split(",");
    while (node) {
        var tagName = node.tagName;
        if (-1 != TP_indexOfArrayNoCase(arrTagNames, tagName)) {
            return node;
        }
        node = node.parentElement;
    }
    //
    return null;
}


var TP_Selection = {
    startCell: null,
    endCell: null,
    grid: null
};


var TP_startCell = null;
var TP_startTable = null;
var TP_startSelectedTable = null;


function TP_getCellData(cell) {
    if (!TP_Selection.grid) {
        var table = TP_getParents(cell, "table");
        TP_buildGrid(table);
    }
    //
    var grid = TP_Selection.grid;
    for (var y = 0; y < grid.length; y++) {
        var line = grid[y];
        for (var x = 0; x < line.length; x++) {
            var data = grid[y][x];
            if (data.cell == cell)
                return data;
        }
    }
    //
    return null;
}
function TP_getCellPosMin(cell) {
    var data = TP_getCellData(cell);
    return { x: data.x, y: data.y };
}
function TP_getCellPosMax(cell) {
    var data = TP_getCellData(cell);
    return { x: data.x + cell.colSpan - 1, y: data.y + cell.rowSpan - 1};
}

function TP_buildGrid(table) {
    if (TP_Selection.grid)
        return;
    //
    if (!table)
        return;
    var ret = [];
    //
    function getNextPos(line) {
        var pos = 0;
        while (true) {
            if (!line[pos])
                return pos;
            pos++;
        }
    }
    //
    var rows = table.rows;
    for (var iRow = 0; iRow < rows.length; iRow++) {
        var row = rows[iRow];
        var cells = row.cells;

        //
        if (!ret[iRow])
            ret[iRow] = [];
        //
        for (var iCell = 0; iCell < cells.length; iCell++) {
            var cell = cells[iCell];
            //
            var colSpan = cell.colSpan;
            var rowSpan = cell.rowSpan;
            //
            var startCol = getNextPos(ret[iRow]);
            //
            for (var r = 0; r < rowSpan; r++) {
                if (!ret[iRow + r])
                    ret[iRow + r] = [];
                //
                for (var c = 0; c < colSpan; c++) {
                    var y = iRow + r;
                    var x = startCol + c;
                    //
                    var real = false;
                    //
                    if (y == iRow && x == startCol) {
                        real = true;
                    }
                    //
                    if (!cell.getAttribute('wiz_tag_attr_bk_color')) {
                        cell.setAttribute('wiz_tag_attr_bk_color', cell.style.backgroundColor);
                    }
                    //
                    var data = { cell: cell, x: x, y: y, real: real, backgroundColor: cell.style.backgroundColor };
                    //
                    if (!ret[iRow + r])
                        ret[iRow + r] = [];
                    //
                    ret[y][x] = data;
                }
            }
        }
    }
    //
    TP_Selection.grid = ret;
}
function TP_getCellOrgbackgroundColor(cell) {
    if (!TP_Selection.grid)
        return "";
    var data = TP_getCellData(cell);
    //
    var bg = (data && data.backgroundColor) ? data.backgroundColor : cell.getAttribute('wiz_tag_attr_bk_color');
    //
    if (!bg)
        return "";
    if (bg == "#b8dbff" || bg == "rgb(184, 219, 255)")
        return "";
    return bg;
}



function TP_cleanup() {
    var table = TP_startSelectedTable;
    //
    if (table) {
        var rows = table.rows;
        for (var iRow = 0; iRow < rows.length; iRow++) {
            var row = rows[iRow];
            var cells = row.cells;
            for (var iCell = 0; iCell < cells.length; iCell++) {
                var cell = cells[iCell];
                //
                if (TP_isCellSelected(cell)) {
                    TP_cancelSelectCell(cell);
                }
            }
        }
    }
    TP_Selection.startCell = null;
    TP_Selection.endCell = null;
    TP_Selection.grid = null;
}

function TP_documentOnMouseDown(e) {
    try {
        if (e.button != 2) {
            TP_cleanup();

            TP_startCell = TP_getParents(e.srcElement, 'td,th');
            TP_startTable = TP_getParents(TP_startCell, 'table');
            TP_startSelectedTable = TP_startTable;
        }
    }
    catch (err) {
        TP_alert(err.message);
    }
}

function TP_selectCell(cell) {
    cell.style.backgroundColor = "#b8dbff";
    cell.setAttribute("wizTPCellSelected", "1");
}
function TP_cancelSelectCell(cell) {
    cell.style.backgroundColor = TP_getCellOrgbackgroundColor(cell);

    // cell.style.removeProperty("background-color");
    
    cell.removeAttribute("wizTPCellSelected");
}
function TP_isCellSelected(cell) {
    if (cell.getAttribute("wizTPCellSelected", 0) == "1")
        return true;
    //
    var color = cell.style.backgroundColor;
    if (!color)
        return false;
    if (0 == color.length)
        return false;
    //
    return color == "rgb(184, 219, 255)" || color == "#b8dbff";
}

function TP_setStartCell(cell) {
    if (TP_Selection.startCell)
        return;
    TP_Selection.startCell = cell;
    //
    var table = TP_getParents(cell, "table");
    TP_buildGrid(table);
}

function TP_getCellRange(startCell, endCell) {
    var start = TP_getCellPosMin(startCell);
    var end = TP_getCellPosMin(endCell);
    //
    if (start.x > end.x || start.y > end.y) {
        start = TP_getCellPosMin(endCell);
        end = TP_getCellPosMax(startCell);
    }
    else {
        start = TP_getCellPosMin(startCell);
        end = TP_getCellPosMax(endCell);
    }
    //
    //
    var xMin = Math.min(start.x, end.x);
    var yMin = Math.min(start.y, end.y);
    var xMax = Math.max(start.x, end.x);
    var yMax = Math.max(start.y, end.y);
    //
    return { xMin: xMin, yMin: yMin, xMax: xMax, yMax: yMax };
}
function TP_setEndCell(cell) {
    TP_Selection.endCell = cell;
    //
    var range = TP_getCellRange(TP_Selection.startCell, TP_Selection.endCell);
    //
    var xMin = range.xMin;
    var yMin = range.yMin;
    var xMax = range.xMax;
    var yMax = range.yMax;
    //
    var table = TP_getParents(cell, "table");

    var rows = table.rows;
    for (var iRow = 0; iRow < rows.length; iRow++) {
        var row = rows[iRow];
        var cells = row.cells;
        for (var iCell = 0; iCell < cells.length; iCell++) {
            var item = cells[iCell];
            //
            var pos = TP_getCellPosMin(item);
            if (pos.x >= xMin && pos.x <= xMax && pos.y >= yMin && pos.y <= yMax) {
                TP_selectCell(item);
            }
            else {
                TP_cancelSelectCell(item);
            }
        }
    }
}

function TP_documentOnMouseOver(e) {
    try {
        var target = e.srcElement;

        if (TP_startCell && (target != TP_startCell) && (target.tagName == 'TD' || target.tagName == 'TH')) {
            var table = TP_getParents(target, 'table');
            if (table == TP_startTable) {
                TP_setStartCell(TP_startCell);
                TP_setEndCell(target);
            }
            // Remove current selection
            var sel = document.getSelection();
            sel.empty();

            e.returnValue = false;
        }
    }
    catch (err) {
        TP_alert(err.message);
    }
}

function TP_documentOnMouseUp() {
    TP_startCell = null;
    TP_startTable = null;
}


document.addEventListener("mousedown", TP_documentOnMouseDown);
document.addEventListener("mouseover", TP_documentOnMouseOver);
document.addEventListener("mouseup", TP_documentOnMouseUp);

function TP_insertAfter(node, reference_node) {
    var parent = reference_node.parentNode;
    var nextSibling = reference_node.nextSibling;
    if (nextSibling)
        parent.insertBefore(node, nextSibling);
    else
        parent.appendChild(node);

    return node;
}



function TP_cloneCell(cell) {
    var newCell = document.createElement(cell.tagName);
    newCell.style.cssText = cell.style.cssText;
    //
    if (newCell.style.backgroundColor == "#b8dbff" || 
        newCell.style.backgroundColor == "rgb(184, 219, 255)") {
        newCell.style.backgroundColor = cell.getAttribute('wiz_tag_attr_bk_color');
    }
    newCell.innerHTML = "<br />";
    return newCell;
}

function TP_fillLeftDown(x, y, rows, cols) {
    if (rows == 0) {
        return;
    }
    var grid = TP_Selection.grid;
    //
    var table = TP_getParents(TP_Selection.startCell, "table");

    for (var r = 1; r <= rows; r++) {
        var row = table.rows[y + r];

        if (row) {

            var cellBefore = null;
            var cellAfter = null;
            for (var x2 = 0; x2 < grid[r].length; x2++) {
                var data = grid[y + r][x2];
                //
                if (data.real) {
                    if (x2 < x) {
                        cellBefore = data.cell;
                    }
                    else if (x2 > x) {
                        if (!cellAfter) {
                            cellAfter = data.cell;
                        }
                    }
                }
            }
            //
            if (cellBefore) {
                for (var x3 = 0; x3 < cols; x3++) {
                    TP_insertAfter(TP_cloneCell(cellBefore), cellBefore);
                }
            }
            else if (cellAfter) {
                for (var x3 = 0; x3 < cols; x3++) {
                    cellAfter.parentElement.insertBefore(TP_cloneCell(cellAfter), cellAfter);
                }
            }
            else {
                TP_alert("error!");
            }
        }
    }
}

function TP_getCurrentCell() {
    try {
        var sel = document.getSelection();
        var elem = sel.focusNode;
        if (elem.nodeType == 3) {
            elem = elem.parentElement;
        }
        return TP_getParents(elem, "td,th");
    }
    catch (err) {
        return null;
    }
}
function TP_getSelectedCells() {
    if (!TP_Selection.startCell)
        return null;
    if (!TP_Selection.endCell)
        return null;
    if (!TP_Selection.grid)
        return null;
    //
    var table = TP_getParents(TP_Selection.startCell, "table");
    if (!table)
        return null;
    //
    var range = TP_getCellRange(TP_Selection.startCell, TP_Selection.endCell);
    //
    var startX = range.xMin;
    var startY = range.yMin;
    var endX = range.xMax;
    var endY = range.yMax;
    //
    var grid = TP_Selection.grid;
    //
    var cells = [];
    for (var y = startY; y <= endY; y++) {
        for (var x = startX; x <= endX; x++) {
            var data = grid[y][x];
            if (data) {
                cells.push(data.cell);
            }
        }
    }
    //
    return cells;
}


function TP_canSplit() {
    if (!TP_Selection.startCell || !TP_Selection.endCell || !TP_Selection.grid) {
        var cell = TP_getCurrentCell();
        if (!cell)
            return false;
        //
        if (cell.colSpan == 1 && cell.rowSpan == 1)
            return false;
        //
        return true;
    }
    //
    var cells = TP_getSelectedCells();
    if (!cells)
        return false;
    //
    for (var i = 0; i < cells.length; i++) {
        var cell = cells[i];
        //
        if (!cell)
            continue;
        //
        if (cell.colSpan > 1 || cell.rowSpan > 1)
            return true;
    }
    return false;
}

function TP_splitCore() {
    //
    if (!TP_Selection.startCell || !TP_Selection.endCell || !TP_Selection.grid) {
        return;
    }
    //
    var grid = TP_Selection.grid;
    for (var y = 0; y < grid.length; y++) {
        var row = grid[y];
        //
        for (var x = 0; x < row.length; x++) {
            var data = row[x];
            var cell = data.cell;
            if (data.real && TP_isCellSelected(cell)) {
                var colSpan = cell.colSpan;
                var rowSpan = cell.rowSpan;
                //
                if (colSpan > 1 || rowSpan > 1) {
                    cell.colSpan = 1;
                    cell.rowSpan = 1;
                    //
                    for (var i = 0; i < colSpan - 1; i++) {
                        TP_insertAfter(TP_cloneCell(cell), cell);
                    }
                    //
                    TP_fillLeftDown(x, y, rowSpan - 1, colSpan);
                }
            }
        }
    }
}

function TP_prepareSelectedCell() {
    if (TP_Selection.startCell && TP_Selection.endCell && TP_Selection.grid)
        return true;  
    var cell = TP_getCurrentCell();
    if (!cell)
        return false;
    //
    TP_setStartCell(cell);
    TP_setEndCell(cell);
    //
    return true;
}

function TP_split() {
    if (!TP_canSplit()) {
        TP_alert("can not split cells!");
        return;
    }
    if (!TP_prepareSelectedCell())
        return;
    //
    TP_splitCore();
    //
    TP_cleanup();
}

function TP_canMerge() {
    if (!TP_Selection.startCell)
        return false;
    if (!TP_Selection.endCell)
        return false;
    if (!TP_Selection.grid)
        return false;
    //
    var table = TP_getParents(TP_Selection.startCell, "table");
    if (!table)
        return false;
    //
    var range = TP_getCellRange(TP_Selection.startCell, TP_Selection.endCell);
    //
    var startX = range.xMin;
    var startY = range.yMin;
    var endX = range.xMax;
    var endY = range.yMax;
    //
    var grid = TP_Selection.grid;
    //
    var cells = TP_getSelectedCells();
    //
    var borders = [];
    //
    if (startX > 0) {
        for (var y = startY; y <= endY; y++) {
            var data = grid[y][startX - 1];
            if (data) {
                var cell = data.cell;
                if (cell) {
                    borders.push(cell);
                }
            }
        }
    }
    if (endX < grid[0].length - 1) {
        for (var y = startY; y <= endY; y++) {
            var data = grid[y][endX + 1];
            if (data) {
                var cell = data.cell;
                if (cell) {
                    borders.push(cell);
                }
            }
        }
    }
    //
    if (startY > 0) {
        for (var x = startX; x <= endX; x++) {
            var data = grid[startY - 1][x];
            if (data) {
                var cell = data.cell;
                if (cell) {
                    borders.push(cell);
                }
            }
        }
    }
    if (endY < grid.length - 1) {
        for (var x = startX; x <= endX; x++) {
            var data = grid[endY + 1][x];
            if (data) {
                var cell = data.cell;
                if (cell) {
                    borders.push(cell);
                }
            }
        }
    }
    //
    for (var i = 0; i < borders.length; i++) {
        if (TP_indexOfArray(cells, borders[i]) != -1) {
            return false;
        }
    }
    //
    return true;
}


function TP_merge() {
    if (!TP_canMerge()) {
        TP_alert("can not merge cells");
        return;
    }
    if (!TP_Selection.startCell)
        return;
    if (!TP_Selection.endCell)
        return;
    //
    var table = TP_getParents(TP_Selection.startCell, "table");
    //
    var range = TP_getCellRange(TP_Selection.startCell, TP_Selection.endCell);
    //
    var startX = range.xMin;
    var startY = range.yMin;
    var endX = range.xMax;
    var endY = range.yMax;

    if (TP_Selection.startCell.parentElement.tagName == TP_Selection.endCell.parentElement.tagName) {
        TP_splitCore();
        //
        TP_Selection.grid = null;
        TP_buildGrid(table);
        //
        var grid = TP_Selection.grid;
        if (!grid) {
            TP_alert("error");
        }

        var startCell = grid[startY][startX].cell;
        startCell.colSpan = (endX - startX) + 1;
        startCell.rowSpan = (endY - startY) + 1;

        for (y = startY; y <= endY; y++) {
            for (x = startX; x <= endX; x++) {
                cell = grid[y][x].cell;

                if (cell != startCell) {
                    var children = cell.childNodes;
                    for (var i = 0; i < children.length; i++) {
                        startCell.appendChild(children[i]);
                    }

                    cell.parentNode.removeChild(cell);
                }
            }
        }

        TP_cleanup();
    }
}

function TP_each(o, cb) {
	if (!o)
		return 0;

	for (var n = 0; n < o.length; n++) {
		if (cb(o[n], n) == false)
			return 0;
	}

	return 1;
}

function TP_cloneNode(node, children) {
    node = node.cloneNode(children);
    node.removeAttribute('id');

    return node;
}

function TP_insertRowCore(before) {
    if (!TP_prepareSelectedCell())
        return;
    //
    var grid = TP_Selection.grid;
        
    var posY, cell, lastCell, x, rowElm, newRow, newCell, otherCell;

    // Find first/last row
    TP_each(grid, function(row, y) {
        TP_each(row, function(data, x) {
            cell = data.cell;
            if (TP_isCellSelected(cell)) {
                rowElm = cell.parentNode;
                newRow = TP_cloneNode(rowElm, false);
                posY = y;

                if (before)
                    return false;
            }
        });

        if (before)
            return !posY;
    });
    //
    for (x = 0; x < grid[0].length; x++) {
        cell = grid[posY][x].cell;

        if (cell != lastCell) {
            if (!before) {
                rowSpan = cell.rowSpan;
                if (rowSpan > 1) {
                    cell.rowSpan = rowSpan + 1;
                    continue;
                }
            } else {
                // Check if cell above can be expanded
                if (posY > 0 && grid[posY - 1][x]) {
                    otherCell = grid[posY - 1][x].cell;
                    rowSpan = otherCell.rowSpan;
                    if (rowSpan > 1) {
                        otherCell.rowSpan = rowSpan + 1;
                        continue;
                    }
                }
            }

            // Insert new cell into new row
            newCell = TP_cloneCell(cell)
            newCell.colSpan = cell.colSpan;
            newRow.appendChild(newCell);

            lastCell = cell;
        }
    }

    if (newRow.hasChildNodes()) {
        if (!before)
            TP_insertAfter(newRow, rowElm);
        else
            rowElm.parentNode.insertBefore(newRow, rowElm);
    }
    //
    TP_cleanup();
};

function TP_insertRowAbove() {
    TP_insertRowCore(true);
}
function TP_insertRowBelow() {
    TP_insertRowCore(false);
}

function TP_insertColCore(before) {
    if (!TP_prepareSelectedCell())
        return;
    //
    var grid = TP_Selection.grid;
    var newWidth = 100 / (grid[0].length + 1) + "%";

    var posX, lastCell;

    // Find first/last column
    TP_each(grid, function(row, y) {
        TP_each(row, function(data, x) {
            if (TP_isCellSelected(data.cell)) {
                posX = x;

                if (before)
                    return false;
            }
        });

        if (before)
            return !posX;
    });

    TP_each(grid, function(row, y) {
        var cell = row[posX].cell, rowSpan, colSpan;

        if (cell != lastCell) {
            colSpan = cell.colSpan;
            rowSpan = cell.rowSpan;

            if (colSpan == 1) {
                var newCell = TP_cloneCell(cell);
                if (newCell.style && newCell.style.width != '') { 
                    newCell.style.width = newWidth;
                }
                //
                if (!before) {
                    TP_insertAfter(newCell, cell);
                    TP_fillLeftDown(posX, y, rowSpan - 1, colSpan);
                } else {
                    cell.parentNode.insertBefore(newCell, cell);
                    TP_fillLeftDown(posX, y, rowSpan - 1, colSpan);
                }
            } else
                cell.colSpan++;

            lastCell = cell;
        }
    });
    // only for fixed table
    if (grid[0][0].cell && grid[0][0].cell.style && grid[0][0].cell.style.width != '') {
        TP_each(grid, function(row, y) {
            TP_each(row, function(data, x) {
                var cell = data.cell;
                cell.style.width = newWidth;
            });
        });
    }
    //
    TP_cleanup();
};

function TP_insertColLeft() {
    return TP_insertColCore(true);
}
function TP_insertColRight() {
    return TP_insertColCore(false);
}

function TP_getSelectedRows() {
    //
    var rows = [];
    //
    var table = TP_getParents(TP_Selection.startCell, "table");

    TP_each(table.rows, function(row) {
        if (TP_indexOfArray(rows, row) == -1) {
            TP_each(row.cells, function(cell) {
                if (TP_isCellSelected(cell)) {
                    rows.push(row);
                    return false;
                }
            });
        }
    });

    return rows;
};


function TP_deleteRows() {
    if (!TP_prepareSelectedCell())
        return;
    //
    var grid = TP_Selection.grid;
    //
    var table = TP_getParents(grid[0][0].cell, "table");

    var rows;

    function deleteRow(tr) {
        var nextTr, pos, lastCell;

        nextTr = table.rows[tr.rowIndex + 1];

        // Move down row spanned cells
        TP_each(tr.cells, function(cell) {
            var rowSpan = cell.rowSpan;

            if (rowSpan > 1) {
                cell.rowSpan = rowSpan - 1;
                pos = TP_getCellPosMin(cell);
                TP_fillLeftDown(pos.x, pos.y, 1, 1);
            }
        });

        // Delete cells
        pos = TP_getCellPosMin(tr.cells[0]);
        TP_each(grid[pos.y], function(data) {
            var rowSpan;

            var cell = data.cell;

            if (cell != lastCell) {
                rowSpan = cell.rowSpan;

                if (rowSpan <= 1) {
                    //cell.removeNode(true);
                }
                else {
                    cell.rowSpan = rowSpan - 1;
                }

                lastCell = cell;
            }
        });
        //
        table.deleteRow(tr.rowIndex);
    };

    // Get selected rows and move selection out of scope
    rows = TP_getSelectedRows();

    // Delete all selected rows
    TP_each(rows.reverse(), function(tr) {
        deleteRow(tr);
    });

    TP_cleanup();
};


function TP_deleteCols() {
    if (!TP_prepareSelectedCell())
        return;
    //
    var grid = TP_Selection.grid;
    //
    var cols = [];

    // Get selected column indexes
    TP_each(grid, function(row, y) {
        TP_each(row, function(data, x) {
            var cell = data.cell;
            if (TP_isCellSelected(cell) && TP_indexOfArray(cols, x) == -1) {
                TP_each(grid, function(row) {
                    var cell = row[x].cell;
                    if (cell) {
                        var colSpan = cell.colSpan;

                        if (colSpan > 1)
                            cell.colSpan = colSpan - 1;
                        else
                            cell.remove(true);
                    }
                });

                cols.push(x);
            }
        });
    });

    TP_cleanup();
};

function TP_isSelectedCells() {
    if (TP_Selection.startCell && TP_Selection.endCell && TP_Selection.grid)
        return true;
    var cell = TP_getCurrentCell();
    if (cell)
        return true;
    return false;
}

function TP_canInsertCol() {
    return TP_isSelectedCells();
}
function TP_canInsertRow() {
    return TP_isSelectedCells();
}
function TP_canDeleteCols() {
    return TP_isSelectedCells();
}
function TP_canDeleteRows() {
    return TP_isSelectedCells();
}
function TP_canDistributeTable() {
    return TP_isSelectedCells();
}

function TP_distributeCols() {
    if (!TP_prepareSelectedCell())
        return;
    //
    var grid = TP_Selection.grid;
    //
    var row = grid[0];
    var colCount = row.length;
    if (0 == colCount)
        return;
    //
    var width = 100 / colCount;
    width = "" + width;
    if (width.length > 4) {
        width = width.substr(0, 4);
    }
    //
    for (var i = 0; i < colCount; i++) {
        var data = row[i];
        //
        var cell = data.cell;
        //
        var cellWidth = cell.colSpan * width;
        //
        cell.style.width = cellWidth + "%";
    }
    //
    TP_cleanup();
}

function TP_distributeRows() {
    if (!TP_prepareSelectedCell())
        return;
    //
    var grid = TP_Selection.grid;
    //
    var rowCount = grid.length;
    if (0 == rowCount)
        return;
    //
    var height = 100 / rowCount;
    height = "" + height;
    if (height.length > 4) {
        height = height.substr(0, 4);
    }
    //
    for (var i = 0; i < rowCount; i++) {
        var data = grid[i][0];
        //
        var cell = data.cell;
        //
        var cellHeight = cell.rowSpan * height;
        //
        cell.style.height = cellHeight + "%";
    }
    //
    TP_cleanup();
}

function TP_getTableCommandStatus() {
    if (!TP_isSelectedCells())
        return "";
    //
    var bCanMerge = TP_canMerge();
    var bCanSplit = TP_canSplit();
    var bCanInsertRow = TP_canInsertRow();
    var bCanInsertColumn = bCanInsertRow;
    var bCanDeleteRow = bCanInsertRow;
    var bCanDeleteColumn = bCanInsertRow;
    var bCanDistribute = bCanInsertRow;
    //
    var ret = "CanMerge=" + (bCanMerge ? "1" : "0")
     + " \nCanSplit=" + (bCanSplit ? "1" : "0")
     + "\nCanInsertRow=" + (bCanInsertRow ? "1" : "0")
     + "\nCanInsertCol=" + (bCanInsertColumn ? "1" : "0")
     + "\nCanDeleteRows=" + (bCanDeleteRow ? "1" : "0")
     + "\nCanDeleteCols=" + (bCanDeleteColumn ? "1" : "0")
     + "\nCanDistributeTable=" + (bCanDistribute ? "1" : "0")
     ;
    return ret;
}
