(function(){

    function getSource(doc) {
        //
        var html = doc.documentElement.outerHTML;
        //
        var first = doc.firstChild;
        if (!first)
            return html;
        //
        var name = first.nodeName;
        if (!name)
            return html;
        if (name != "html")
            return html;
        //
        var publicId = first.publicId;
        var systemId = first.systemId;
        //
        if (!publicId || publicId == "") {
            return "<!DOCTYPE " + name + ">" + html;
        } else {
            return "<!DOCTYPE " + name + " PUBLIC \"" + publicId + "\" \"" + systemId + "\">" + html;
        }
    }
    function getAllFramesData(doc) {
        //
        var retData = "";
        var frames = doc.getElementsByTagName("iframe");
        if (!frames)
            return null;
        for (var i = 0; i < frames.length; i++) {
            var frame = frames[i];
            //
            var src = frame.getAttribute("src");
            var id = frame.getAttribute("id");
            var name = frame.getAttribute("name");
            var html = getSource(frame.contentDocument);
            if (!html)
                continue;
            //
            if (!src)
                src = "";
            if (!id)
                id = "";
            if (!name)
                name = "";
            //
            retData = retData + "<!--WizFrameURLStart-->" + src + "<!--WizFrameURLEnd--><!--WizFrameIdStart-->" + id + "<!--WizFrameIdEnd--><!--WizFrameNameStart-->" + name + "<!--WizFrameNameEnd--><!--WizFrameHtmlStart-->" + html + "<!--WizFrameHtmlEnd-->";
        }
        return retData;
    }
    //
    return getAllFramesData(document);
})();

