(function(){

    function getSource(doc) {
        //
        var html = doc.documentElement.outerHTML;
        //
        var first = doc.firstChild;
        if (!first)
            return html;
        //
        var name = first.nodeName;
        if (!name)
            return html;
        if (name != "html")
            return html;
        //
        var publicId = first.publicId;
        var systemId = first.systemId;
        //
        if (!publicId || publicId == "") {
            return "<!DOCTYPE " + name + ">" + html;
        } else {
            return "<!DOCTYPE " + name + " PUBLIC \"" + publicId + "\" \"" + systemId + "\">" + html;
        }
    }

    function getFrameSource(doc, idOrName) {
        var f = doc.getElementById(idOrName);
        if (!f) {
            var fs = doc.getElementsByName(idOrName);
            if (!fs)
                return null;
            if (fs.length != 1)
                return null;
            f = fs[0];
            if (!f)
                return null;
        }
        //
        return getSource(f.contentDocument);
    }
    //
    return getFrameSource(document, '__idOrName');
})();

