/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.scanning;

import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import li.cil.scannable.api.prefab.AbstractScanResultProvider;
import li.cil.scannable.api.scanning.ScanResult;
import li.cil.scannable.common.Scannable;
import li.cil.scannable.common.config.Settings;
import li.cil.scannable.common.init.Items;
import li.cil.scannable.common.item.ItemScannerModuleBlockConfigurable;
import li.cil.scannable.util.ItemStackUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public final class ScanResultProviderBlock
extends AbstractScanResultProvider {
    public static final ScanResultProviderBlock INSTANCE = new ScanResultProviderBlock();
    private static final int DEFAULT_COLOR = 0x4466CC;
    private static final float BASE_ALPHA = 0.25f;
    private static final float STATE_SCANNED_ALPHA = 0.7f;
    private final TIntIntMap blockColors = new TIntIntHashMap();
    private final BitSet oresCommon = new BitSet();
    private final BitSet oresRare = new BitSet();
    private final BitSet fluids = new BitSet();
    private boolean scanCommon;
    private boolean scanRare;
    private boolean scanFluids;
    @Nullable
    private IBlockState scanState;
    private final List<IProperty> stateComparator = new ArrayList<IProperty>();
    private float sqRadius;
    private float sqOreRadius;
    private BlockPos min;
    private BlockPos max;
    private int blocksPerTick;
    private int x;
    private int y;
    private int z;
    private Map<BlockPos, ScanResultOre> resultClusters = new HashMap<BlockPos, ScanResultOre>();
    private List<ScanResultOre> nonCulledResults = new ArrayList<ScanResultOre>();

    private ScanResultProviderBlock() {
    }

    @SideOnly(value=Side.CLIENT)
    public void rebuildOreCache() {
        this.blockColors.clear();
        this.oresCommon.clear();
        this.oresRare.clear();
        this.fluids.clear();
        this.buildOreCache();
    }

    @Override
    public int getEnergyCost(EntityPlayer player, ItemStack module) {
        if (Items.isModuleOreCommon(module)) {
            return Settings.getEnergyCostModuleOreCommon();
        }
        if (Items.isModuleOreRare(module)) {
            return Settings.getEnergyCostModuleOreRare();
        }
        if (Items.isModuleBlock(module)) {
            return Settings.getEnergyCostModuleBlock();
        }
        if (Items.isModuleFluid(module)) {
            return Settings.getEnergyCostModuleFluid();
        }
        throw new IllegalArgumentException(String.format("Module not supported by this provider: %s", module));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initialize(EntityPlayer player, Collection<ItemStack> modules, Vec3d center, float radius, int scanTicks) {
        super.initialize(player, modules, center, ScanResultProviderBlock.computeRadius(modules, radius), scanTicks);
        this.scanCommon = false;
        this.scanRare = false;
        this.scanFluids = false;
        this.scanState = null;
        this.stateComparator.clear();
        for (ItemStack module : modules) {
            this.scanCommon |= Items.isModuleOreCommon(module);
            this.scanRare |= Items.isModuleOreRare(module);
            this.scanFluids |= Items.isModuleFluid(module);
            if (!Items.isModuleBlock(module)) continue;
            this.scanState = ItemScannerModuleBlockConfigurable.getBlockState(module);
            if (this.scanState == null) continue;
            for (IProperty property : this.scanState.func_177227_a()) {
                if (!Objects.equals(property.func_177701_a(), "variant") && !Objects.equals(property.func_177701_a(), "type")) continue;
                this.stateComparator.add(property);
            }
        }
        this.sqRadius = this.radius * this.radius;
        this.sqOreRadius = radius * 0.25f;
        this.sqOreRadius *= this.sqOreRadius;
        this.min = new BlockPos(center).func_177963_a((double)(-this.radius), (double)(-this.radius), (double)(-this.radius));
        this.max = new BlockPos(center).func_177963_a((double)this.radius, (double)this.radius, (double)this.radius);
        this.x = this.min.func_177958_n();
        this.y = this.min.func_177956_o() - 1;
        this.z = this.min.func_177952_p();
        BlockPos size = this.max.func_177973_b((Vec3i)this.min);
        int count = (size.func_177958_n() + 1) * (size.func_177956_o() + 1) * (size.func_177952_p() + 1);
        this.blocksPerTick = MathHelper.func_76123_f((float)((float)count / (float)scanTicks));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void computeScanResults(Consumer<ScanResult> callback) {
        World world = this.player.func_130014_f_();
        Set<Block> blacklist = Settings.getBlockBlacklistSet();
        for (int i = 0; i < this.blocksPerTick; ++i) {
            boolean matches;
            BlockPos pos;
            IBlockState state;
            if (!this.moveNext(world)) {
                return;
            }
            if (this.center.func_186679_c((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5) > (double)this.sqRadius || blacklist.contains((state = world.func_180495_p(pos = new BlockPos(this.x, this.y, this.z))).func_177230_c())) continue;
            int stateId = Block.func_176210_f((IBlockState)state);
            if (this.scanState != null && this.stateMatches(state) && !this.tryAddToCluster(pos, stateId)) {
                ScanResultOre result = new ScanResultOre(stateId, pos, 0.7f);
                callback.accept(result);
                this.resultClusters.put(pos, result);
                continue;
            }
            if (!this.scanCommon && !this.scanRare && !this.scanFluids || this.center.func_186679_c((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5) > (double)this.sqOreRadius) continue;
            boolean bl = matches = this.scanCommon && this.oresCommon.get(stateId) || this.scanRare && this.oresRare.get(stateId) || this.scanFluids && this.fluids.get(stateId);
            if (!matches || this.tryAddToCluster(pos, stateId)) continue;
            ScanResultOre result = new ScanResultOre(stateId, pos);
            callback.accept(result);
            this.resultClusters.put(pos, result);
        }
    }

    private boolean stateMatches(IBlockState state) {
        assert (this.scanState != null);
        if (this.scanState.func_177230_c() != state.func_177230_c()) {
            return false;
        }
        if (this.stateComparator.isEmpty()) {
            return true;
        }
        for (IProperty property : this.stateComparator) {
            if (Objects.equals(state.func_177229_b(property), this.scanState.func_177229_b(property))) continue;
            return false;
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isValid(ScanResult result) {
        return ((ScanResultOre)result).isRoot();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(Entity entity, List<ScanResult> results, float partialTicks) {
        double posX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double posY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double posZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        Vec3d lookVec = entity.func_70676_i(partialTicks).func_72432_b();
        Vec3d viewerEyes = entity.func_174824_e(partialTicks);
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-posX), (double)(-posY), (double)(-posZ));
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        float colorNormalizer = 0.003921569f;
        for (ScanResult result : results) {
            ScanResultOre resultOre = (ScanResultOre)result;
            if (resultOre.bounds.func_72318_a(viewerEyes)) {
                this.nonCulledResults.add(resultOre);
                continue;
            }
            Vec3d toResult = resultOre.getPosition().func_178788_d(viewerEyes);
            float lookDirDot = (float)lookVec.func_72430_b(toResult.func_72432_b());
            float sqLookDirDot = lookDirDot * lookDirDot;
            float sq2LookDirDot = sqLookDirDot * sqLookDirDot;
            float focusScale = MathHelper.func_76131_a((float)(sq2LookDirDot * sq2LookDirDot + 0.005f), (float)0.5f, (float)1.0f);
            int color = this.blockColors.containsKey(resultOre.stateId) ? this.blockColors.get(resultOre.stateId) : 0x4466CC;
            float r = (float)(color >> 16 & 0xFF) * 0.003921569f;
            float g = (float)(color >> 8 & 0xFF) * 0.003921569f;
            float b = (float)(color & 0xFF) * 0.003921569f;
            float a = Math.max(0.25f, resultOre.getAlphaOverride()) * focusScale;
            ScanResultProviderBlock.drawCube(((ScanResultOre)resultOre).bounds.field_72340_a, ((ScanResultOre)resultOre).bounds.field_72338_b, ((ScanResultOre)resultOre).bounds.field_72339_c, ((ScanResultOre)resultOre).bounds.field_72336_d, ((ScanResultOre)resultOre).bounds.field_72337_e, ((ScanResultOre)resultOre).bounds.field_72334_f, r, g, b, a, buffer);
        }
        tessellator.func_78381_a();
        if (!this.nonCulledResults.isEmpty()) {
            GlStateManager.func_179129_p();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            for (ScanResultOre resultOre : this.nonCulledResults) {
                Vec3d toResult = resultOre.getPosition().func_178788_d(viewerEyes);
                float lookDirDot = (float)lookVec.func_72430_b(toResult.func_72432_b());
                float sqLookDirDot = lookDirDot * lookDirDot;
                float sq2LookDirDot = sqLookDirDot * sqLookDirDot;
                float focusScale = MathHelper.func_76131_a((float)(sq2LookDirDot * sq2LookDirDot + 0.005f), (float)0.5f, (float)1.0f);
                int color = this.blockColors.containsKey(resultOre.stateId) ? this.blockColors.get(resultOre.stateId) : 0x4466CC;
                float r = (float)(color >> 16 & 0xFF) * 0.003921569f;
                float g = (float)(color >> 8 & 0xFF) * 0.003921569f;
                float b = (float)(color & 0xFF) * 0.003921569f;
                float a = Math.max(0.25f, resultOre.getAlphaOverride()) * focusScale;
                ScanResultProviderBlock.drawCube(((ScanResultOre)resultOre).bounds.field_72340_a, ((ScanResultOre)resultOre).bounds.field_72338_b, ((ScanResultOre)resultOre).bounds.field_72339_c, ((ScanResultOre)resultOre).bounds.field_72336_d, ((ScanResultOre)resultOre).bounds.field_72337_e, ((ScanResultOre)resultOre).bounds.field_72334_f, r, g, b, a, buffer);
            }
            tessellator.func_78381_a();
            GlStateManager.func_179089_o();
        }
        this.nonCulledResults.clear();
        GlStateManager.func_179121_F();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void reset() {
        super.reset();
        this.scanFluids = false;
        this.scanRare = false;
        this.scanCommon = false;
        this.scanState = null;
        this.stateComparator.clear();
        this.sqOreRadius = 0.0f;
        this.sqRadius = 0.0f;
        this.max = null;
        this.min = null;
        this.blocksPerTick = 0;
        this.z = 0;
        this.y = 0;
        this.x = 0;
        this.resultClusters.clear();
    }

    @SideOnly(value=Side.CLIENT)
    private static float computeRadius(Collection<ItemStack> modules, float radius) {
        boolean scanOres = false;
        boolean scanState = false;
        for (ItemStack module : modules) {
            scanOres |= Items.isModuleOreCommon(module);
            scanOres |= Items.isModuleOreRare(module);
            scanState |= Items.isModuleBlock(module);
        }
        if (scanOres && scanState) {
            return radius * Math.max(0.25f, 0.5f);
        }
        if (scanOres) {
            return radius * 0.25f;
        }
        assert (scanState);
        return radius * 0.5f;
    }

    @SideOnly(value=Side.CLIENT)
    private boolean tryAddToCluster(BlockPos pos, int stateId) {
        BlockPos min = pos.func_177982_a(-1, -1, -1);
        BlockPos max = pos.func_177982_a(1, 1, 1);
        ScanResultOre root = null;
        for (int y = min.func_177956_o(); y <= max.func_177956_o(); ++y) {
            for (int x = min.func_177958_n(); x <= max.func_177958_n(); ++x) {
                for (int z = min.func_177952_p(); z <= max.func_177952_p(); ++z) {
                    BlockPos clusterPos = new BlockPos(x, y, z);
                    ScanResultOre cluster = this.resultClusters.get(clusterPos);
                    if (cluster == null || stateId != cluster.stateId) continue;
                    if (root == null) {
                        root = cluster.getRoot();
                        root.add(pos);
                        this.resultClusters.put(pos, root);
                        continue;
                    }
                    cluster.setRoot(root);
                }
            }
        }
        return root != null;
    }

    @SideOnly(value=Side.CLIENT)
    private boolean moveNext(World world) {
        ++this.y;
        if (this.y > this.max.func_177956_o() || this.y >= world.func_72800_K()) {
            this.y = this.min.func_177956_o();
            ++this.x;
            if (this.x > this.max.func_177958_n()) {
                this.x = this.min.func_177958_n();
                ++this.z;
                if (this.z > this.max.func_177952_p()) {
                    this.blocksPerTick = 0;
                    return false;
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void buildOreCache() {
        Scannable.getLog().info("Building block state lookup table...");
        long start = System.currentTimeMillis();
        TObjectIntMap<String> oreColorsByOreName = ScanResultProviderBlock.buildColorTable(Settings.oreColors);
        TObjectIntMap<String> fluidColorsByFluidName = ScanResultProviderBlock.buildColorTable(Settings.fluidColors);
        HashSet<String> oreNamesBlacklist = new HashSet<String>(Arrays.asList(Settings.getOreBlacklist()));
        HashSet<String> oreNamesCommon = new HashSet<String>(Arrays.asList(Settings.getCommonOres()));
        HashSet<String> oreNamesRare = new HashSet<String>(Arrays.asList(Settings.getRareOres()));
        HashSet<String> fluidBlacklist = new HashSet<String>(Arrays.asList(Settings.getFluidBlacklist()));
        Pattern pattern = Pattern.compile("^ore[A-Z].*$");
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            for (IBlockState state : block.func_176194_O().func_177619_a()) {
                int stateId = Block.func_176210_f((IBlockState)state);
                ItemStack stack = new ItemStack(block, 1, block.func_180651_a(state));
                if (ItemStackUtils.isEmpty(stack)) continue;
                int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
                boolean isRare = false;
                boolean isCommon = false;
                for (int id : ids) {
                    String name = OreDictionary.getOreName((int)id);
                    if (oreNamesBlacklist.contains(name)) {
                        isRare = false;
                        isCommon = false;
                        break;
                    }
                    if (oreNamesCommon.contains(name)) {
                        isCommon = true;
                    } else {
                        if (!oreNamesRare.contains(name) && !pattern.matcher(name).matches()) continue;
                        isRare = true;
                    }
                    if (!oreColorsByOreName.containsKey((Object)name)) continue;
                    this.blockColors.put(stateId, oreColorsByOreName.get((Object)name));
                }
                if (isCommon) {
                    this.oresCommon.set(stateId);
                    continue;
                }
                if (!isRare) continue;
                this.oresRare.set(stateId);
            }
        }
        for (Map.Entry entry : FluidRegistry.getRegisteredFluids().entrySet()) {
            Fluid fluid;
            Block block;
            String fluidName = (String)entry.getKey();
            if (fluidBlacklist.contains(fluidName) || (block = (fluid = (Fluid)entry.getValue()).getBlock()) == null) continue;
            IBlockState state = block.func_176223_P();
            int stateId = Block.func_176210_f((IBlockState)state);
            if (fluidColorsByFluidName.containsKey((Object)fluidName)) {
                this.blockColors.put(stateId, fluidColorsByFluidName.get((Object)fluidName));
            } else {
                this.blockColors.put(stateId, fluid.getColor());
            }
            this.fluids.set(stateId);
        }
        Scannable.getLog().info("Built    block state lookup table in {} ms.", new Object[]{System.currentTimeMillis() - start});
    }

    @SideOnly(value=Side.CLIENT)
    private static TObjectIntMap<String> buildColorTable(String[] colorConfigs) {
        TObjectIntHashMap colors = new TObjectIntHashMap();
        Pattern pattern = Pattern.compile("^(?<name>[^\\s=]+)\\s*=\\s*0x(?<color>[a-fA-F0-9]+)$");
        for (String colorConfig : colorConfigs) {
            Matcher matcher = pattern.matcher(colorConfig.trim());
            if (!matcher.matches()) {
                Scannable.getLog().warn("Illegal color entry in settings: '{}'", new Object[]{colorConfig.trim()});
                continue;
            }
            String name = matcher.group("name");
            int color = Integer.parseInt(matcher.group("color"), 16);
            colors.put((Object)name, color);
        }
        return colors;
    }

    private class ScanResultOre
    implements ScanResult {
        private final int stateId;
        private AxisAlignedBB bounds;
        @Nullable
        private ScanResultOre parent;
        private float alphaOverride;

        ScanResultOre(int stateId, BlockPos pos, float alphaOverride) {
            this.bounds = new AxisAlignedBB(pos);
            this.stateId = stateId;
            this.alphaOverride = alphaOverride;
        }

        ScanResultOre(int stateId, BlockPos pos) {
            this(stateId, pos, 0.0f);
        }

        float getAlphaOverride() {
            return this.alphaOverride;
        }

        boolean isRoot() {
            return this.parent == null;
        }

        ScanResultOre getRoot() {
            if (this.parent != null) {
                return this.parent.getRoot();
            }
            return this;
        }

        void setRoot(ScanResultOre root) {
            if (this.parent != null) {
                this.parent.setRoot(root);
                return;
            }
            if (root == this) {
                return;
            }
            root.bounds = root.bounds.func_111270_a(this.bounds);
            this.parent = root;
        }

        void add(BlockPos pos) {
            assert (this.parent == null) : "Trying to add to non-root node.";
            this.bounds = this.bounds.func_111270_a(new AxisAlignedBB(pos));
        }

        @Override
        @Nullable
        public AxisAlignedBB getRenderBounds() {
            return this.bounds;
        }

        @Override
        public Vec3d getPosition() {
            return this.bounds.func_189972_c();
        }
    }
}

