/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.config;

import li.cil.scannable.common.config.Settings;
import net.minecraft.network.PacketBuffer;

public final class ServerSettings {
    final boolean useEnergy;
    final int energyCapacityScanner;
    final int energyCostModuleRange;
    final int energyCostModuleAnimal;
    final int energyCostModuleMonster;
    final int energyCostModuleOreCommon;
    final int energyCostModuleOreRare;
    final int energyCostModuleBlock;
    final int energyCostModuleFluid;
    final int energyCostModuleEntity;
    final int baseScanRadius;
    final String[] blockBlacklist;
    final String[] oresBlacklist;
    final String[] oresCommon;
    final String[] oresRare;
    final String[] fluidBlacklist;

    public ServerSettings(PacketBuffer packet) {
        this.useEnergy = packet.readBoolean();
        this.energyCapacityScanner = packet.readInt();
        this.energyCostModuleRange = packet.readInt();
        this.energyCostModuleAnimal = packet.readInt();
        this.energyCostModuleMonster = packet.readInt();
        this.energyCostModuleOreCommon = packet.readInt();
        this.energyCostModuleOreRare = packet.readInt();
        this.energyCostModuleBlock = packet.readInt();
        this.energyCostModuleFluid = packet.readInt();
        this.energyCostModuleEntity = packet.readInt();
        this.baseScanRadius = packet.readInt();
        this.blockBlacklist = this.readStringArray(packet);
        this.oresBlacklist = this.readStringArray(packet);
        this.oresCommon = this.readStringArray(packet);
        this.oresRare = this.readStringArray(packet);
        this.fluidBlacklist = this.readStringArray(packet);
    }

    public ServerSettings() {
        this.useEnergy = Settings.useEnergy;
        this.energyCapacityScanner = Settings.energyCapacityScanner;
        this.energyCostModuleRange = Settings.energyCostModuleRange;
        this.energyCostModuleAnimal = Settings.energyCostModuleAnimal;
        this.energyCostModuleMonster = Settings.energyCostModuleMonster;
        this.energyCostModuleOreCommon = Settings.energyCostModuleOreCommon;
        this.energyCostModuleOreRare = Settings.energyCostModuleOreRare;
        this.energyCostModuleBlock = Settings.energyCostModuleBlock;
        this.energyCostModuleFluid = Settings.energyCostModuleFluid;
        this.energyCostModuleEntity = Settings.energyCostModuleEntity;
        this.baseScanRadius = Settings.baseScanRadius;
        this.blockBlacklist = Settings.blockBlacklist;
        this.oresBlacklist = Settings.oreBlacklist;
        this.oresCommon = Settings.oresCommon;
        this.oresRare = Settings.oresRare;
        this.fluidBlacklist = Settings.fluidBlacklist;
    }

    public void writeToBuffer(PacketBuffer packet) {
        packet.writeBoolean(this.useEnergy);
        packet.writeInt(this.energyCapacityScanner);
        packet.writeInt(this.energyCostModuleRange);
        packet.writeInt(this.energyCostModuleAnimal);
        packet.writeInt(this.energyCostModuleMonster);
        packet.writeInt(this.energyCostModuleOreCommon);
        packet.writeInt(this.energyCostModuleOreRare);
        packet.writeInt(this.energyCostModuleBlock);
        packet.writeInt(this.energyCostModuleFluid);
        packet.writeInt(this.energyCostModuleEntity);
        packet.writeInt(this.baseScanRadius);
        ServerSettings.writeStringArray(packet, this.blockBlacklist);
        ServerSettings.writeStringArray(packet, this.oresBlacklist);
        ServerSettings.writeStringArray(packet, this.oresCommon);
        ServerSettings.writeStringArray(packet, this.oresRare);
        ServerSettings.writeStringArray(packet, this.fluidBlacklist);
    }

    private String[] readStringArray(PacketBuffer packet) {
        int length = packet.readInt();
        String[] array = new String[length];
        for (int i = 0; i < length; ++i) {
            array[i] = packet.func_150789_c(256);
        }
        return array;
    }

    private static void writeStringArray(PacketBuffer buffer, String[] array) {
        buffer.writeInt(array.length);
        for (String element : array) {
            buffer.func_180714_a(element);
        }
    }
}

