/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.config;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import li.cil.scannable.client.scanning.ScanResultProviderBlock;
import li.cil.scannable.common.config.ServerSettings;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Config(modid="scannable")
public final class Settings {
    @Config.LangKey(value="config.scannable.useEnergy")
    @Config.Comment(value={"Whether to consume energy when performing a scan.\nWill make the scanner a chargeable item."})
    public static boolean useEnergy = true;
    @Config.LangKey(value="config.scannable.energyCapacityScanner")
    @Config.Comment(value={"Amount of energy that can be stored in a scanner."})
    @Config.RangeInt(min=0, max=1000000)
    public static int energyCapacityScanner = 5000;
    @Config.LangKey(value="config.scannable.energyCostModuleRange")
    @Config.Comment(value={"Amount of energy used by the range module per scan."})
    @Config.RangeInt(min=0, max=5000)
    public static int energyCostModuleRange = 100;
    @Config.LangKey(value="config.scannable.energyCostModuleAnimal")
    @Config.Comment(value={"Amount of energy used by the animal module per scan."})
    @Config.RangeInt(min=0, max=5000)
    public static int energyCostModuleAnimal = 25;
    @Config.LangKey(value="config.scannable.energyCostModuleMonster")
    @Config.Comment(value={"Amount of energy used by the monster module per scan."})
    @Config.RangeInt(min=0, max=5000)
    public static int energyCostModuleMonster = 50;
    @Config.LangKey(value="config.scannable.energyCostModuleOreCommon")
    @Config.Comment(value={"Amount of energy used by the common ore module per scan."})
    @Config.RangeInt(min=0, max=5000)
    public static int energyCostModuleOreCommon = 75;
    @Config.LangKey(value="config.scannable.energyCostModuleOreRare")
    @Config.Comment(value={"Amount of energy used by the rare ore module per scan."})
    @Config.RangeInt(min=0, max=5000)
    public static int energyCostModuleOreRare = 100;
    @Config.LangKey(value="config.scannable.energyCostModuleBlock")
    @Config.Comment(value={"Amount of energy used by the block module per scan."})
    @Config.RangeInt(min=0, max=5000)
    public static int energyCostModuleBlock = 100;
    @Config.LangKey(value="config.scannable.energyCostModuleFluid")
    @Config.Comment(value={"Amount of energy used by the fluid module per scan."})
    @Config.RangeInt(min=0, max=5000)
    public static int energyCostModuleFluid = 50;
    @Config.LangKey(value="config.scannable.energyCostModuleEntity")
    @Config.Comment(value={"Amount of energy used by the entity module per scan."})
    @Config.RangeInt(min=0, max=5000)
    public static int energyCostModuleEntity = 75;
    @Config.LangKey(value="config.scannable.baseScanRadius")
    @Config.Comment(value={"The basic scan radius without range modules.\nIMPORTANT: some modules such as the block and ore scanner modules will already use\na reduced radius based on this value. Specifically, the ore scanners multiply this\nvalue by 0.25, and the block scanner multiplies it by 0.5.\nRange modules will boost the range by half this value."})
    @Config.RangeInt(min=16, max=128)
    public static int baseScanRadius = 64;
    @Config.LangKey(value="config.scannable.blockBlacklist")
    @Config.Comment(value={"Ore dictionary entries that match the common ore pattern but should be ignored."})
    public static String[] oreBlacklist = new String[0];
    @Config.LangKey(value="config.scannable.oreBlacklist")
    @Config.Comment(value={"Registry names of blocks that will never be scanned."})
    public static String[] blockBlacklist = new String[]{"minecraft:command_block"};
    @Config.LangKey(value="config.scannable.oresCommon")
    @Config.Comment(value={"Ore dictionary entries considered common ores, requiring the common ore scanner module.\nUse this to mark ores as common, as opposed to rare (see oresRare)."})
    public static String[] oresCommon = new String[]{"oreCoal", "oreIron", "oreRedstone", "glowstone", "oreCopper", "oreTin", "oreLead", "oreAluminum", "oreAluminium", "oreCinnabar"};
    @Config.LangKey(value="config.scannable.oresRare")
    @Config.Comment(value={"Ore dictionary names of ores considered 'rare', requiring the rare ore scanner module.\nAnything matching /ore[A-Z].*/ that isn't in the common ore list is\nautomatically considered a rare ore (as opposed to the other way around,\nto make missing entries less likely be a problem). Use this to add rare\nores that do follow this pattern."})
    public static String[] oresRare = new String[0];
    @Config.LangKey(value="config.scannable.oreColors")
    @Config.Comment(value={"The colors for ores used when rendering their result bounding box.\nEach entry must be a key-value pair separated by a `=`, with the.\nkey being the ore dictionary name and the value being the hexadecimal\nRGB value of the color."})
    public static String[] oreColors = new String[]{"oreCoal=0x433E3B", "oreIron=0xA17951", "oreGold=0xF4F71F", "oreLapis=0x4863F0", "oreDiamond=0x48E2F0", "oreRedstone=0xE61E1E", "oreEmerald=0x12BA16", "oreQuartz=0xB3D9D2", "glowstone=0xE9E68E", "oreCopper=0xE4A020", "oreLead=0x8187C3", "oreMithril=0x97D5FE", "oreNickel=0xD0D3AC", "orePlatinum=0x7AC0FD", "oreSilver=0xE8F2FB", "oreTin=0xCCE4FE", "oreAluminum=0xCBE4E2", "oreAluminium=0xCBE4E2", "orePlutonium=0x9DE054", "oreUranium=0x9DE054", "oreYellorium=0xD8E054", "oreArdite=0xB77E11", "oreCobalt=0x413BB8", "oreCinnabar=0xF5DA25", "oreInfusedAir=0xF7E677", "oreInfusedFire=0xDC7248", "oreInfusedWater=0x9595D5", "oreInfusedEarth=0x49B45A", "oreInfusedOrder=0x9FF2DE", "oreInfusedEntropy=0x545476"};
    @Config.LangKey(value="config.scannable.fluidBlacklist")
    @Config.Comment(value={"Fluid names of fluids that should be ignored."})
    public static String[] fluidBlacklist = new String[0];
    @Config.LangKey(value="config.scannable.fluidColors")
    @Config.Comment(value={"The colors for fluids used when rendering their result bounding box.\nSee `oreColors` for format entries have to be in."})
    public static String[] fluidColors = new String[]{"water=0x4275DC", "lava=0xE26723"};
    @Config.LangKey(value="config.scannable.injectDepthTexture")
    @Config.Comment(value={"Whether to try to inject a depth texture into Minecraft's FBO when rendering the\nscan wave effect. This is much faster as it will not have to re-render the world\ngeometry to retrieve the depth information required for the effect. However, it\nappears that on some systems this doesn't work. The mod tries to detect that and\nwill fall back to re-rendering automatically, but you can force re-rendering by\nsetting this to false, e.g. for debugging or just to avoid the one logged warning."})
    public static boolean injectDepthTexture = true;
    private static ServerSettings serverSettings;
    private static final Set<Block> blockBlacklistSet;

    public static void setServerSettings(@Nullable ServerSettings serverSettings) {
        Settings.serverSettings = serverSettings;
        ScanResultProviderBlock.INSTANCE.rebuildOreCache();
        blockBlacklistSet.clear();
        for (String blockName : Settings.getBlockBlacklist()) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
            if (block == null || block == Blocks.field_150350_a) continue;
            blockBlacklistSet.add(block);
        }
    }

    public static Set<Block> getBlockBlacklistSet() {
        return blockBlacklistSet;
    }

    public static boolean useEnergy() {
        return serverSettings != null ? Settings.serverSettings.useEnergy : useEnergy;
    }

    public static int getEnergyCapacityScanner() {
        return serverSettings != null ? Settings.serverSettings.energyCapacityScanner : energyCapacityScanner;
    }

    public static int getEnergyCostModuleRange() {
        return serverSettings != null ? Settings.serverSettings.energyCostModuleRange : energyCostModuleRange;
    }

    public static int getEnergyCostModuleAnimal() {
        return serverSettings != null ? Settings.serverSettings.energyCostModuleAnimal : energyCostModuleAnimal;
    }

    public static int getEnergyCostModuleMonster() {
        return serverSettings != null ? Settings.serverSettings.energyCostModuleMonster : energyCostModuleMonster;
    }

    public static int getEnergyCostModuleOreCommon() {
        return serverSettings != null ? Settings.serverSettings.energyCostModuleOreCommon : energyCostModuleOreCommon;
    }

    public static int getEnergyCostModuleOreRare() {
        return serverSettings != null ? Settings.serverSettings.energyCostModuleOreRare : energyCostModuleOreRare;
    }

    public static int getEnergyCostModuleBlock() {
        return serverSettings != null ? Settings.serverSettings.energyCostModuleBlock : energyCostModuleBlock;
    }

    public static int getEnergyCostModuleFluid() {
        return serverSettings != null ? Settings.serverSettings.energyCostModuleFluid : energyCostModuleFluid;
    }

    public static int getEnergyCostModuleEntity() {
        return serverSettings != null ? Settings.serverSettings.energyCostModuleEntity : energyCostModuleEntity;
    }

    public static int getBaseScanRadius() {
        return serverSettings != null ? Settings.serverSettings.baseScanRadius : baseScanRadius;
    }

    public static String[] getBlockBlacklist() {
        return serverSettings != null ? Settings.serverSettings.blockBlacklist : blockBlacklist;
    }

    public static String[] getOreBlacklist() {
        return serverSettings != null ? Settings.serverSettings.oresBlacklist : oreBlacklist;
    }

    public static String[] getCommonOres() {
        return serverSettings != null ? Settings.serverSettings.oresCommon : oresCommon;
    }

    public static String[] getRareOres() {
        return serverSettings != null ? Settings.serverSettings.oresRare : oresRare;
    }

    public static String[] getFluidBlacklist() {
        return serverSettings != null ? Settings.serverSettings.fluidBlacklist : fluidBlacklist;
    }

    private Settings() {
    }

    static {
        blockBlacklistSet = new HashSet<Block>();
    }
}

