/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.energy;

import li.cil.scannable.common.config.Settings;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.EnergyStorage;

public final class EnergyStorageScanner
extends EnergyStorage
implements INBTSerializable<NBTTagInt> {
    private static final String TAG_ENERGY = "energy";
    private final ItemStack container;

    public EnergyStorageScanner(ItemStack container) {
        super(Settings.getEnergyCapacityScanner());
        this.container = container;
    }

    public void updateFromNBT() {
        NBTTagCompound nbt = this.container.func_77978_p();
        if (nbt != null && nbt.func_150297_b(TAG_ENERGY, 3)) {
            this.deserializeNBT((NBTTagInt)nbt.func_74781_a(TAG_ENERGY));
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = super.receiveEnergy(maxReceive, simulate);
        if (!simulate && energyReceived != 0) {
            this.container.func_77983_a(TAG_ENERGY, (NBTBase)this.serializeNBT());
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int energyExtracted = super.extractEnergy(maxExtract, simulate);
        if (!simulate && energyExtracted != 0) {
            this.container.func_77983_a(TAG_ENERGY, (NBTBase)this.serializeNBT());
        }
        return energyExtracted;
    }

    public NBTTagInt serializeNBT() {
        return new NBTTagInt(this.energy);
    }

    public void deserializeNBT(NBTTagInt nbt) {
        this.energy = nbt.func_150287_d();
    }
}

