/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import li.cil.scannable.api.scanning.ScanResultProvider;
import li.cil.scannable.client.ScanManager;
import li.cil.scannable.common.Scannable;
import li.cil.scannable.common.capabilities.CapabilityProviderItemScanner;
import li.cil.scannable.common.capabilities.CapabilityScanResultProvider;
import li.cil.scannable.common.config.Constants;
import li.cil.scannable.common.config.Settings;
import li.cil.scannable.common.gui.GuiId;
import li.cil.scannable.common.init.Items;
import li.cil.scannable.util.SoundManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public final class ItemScanner
extends Item {
    public ItemScanner() {
        this.func_77625_d(1);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new CapabilityProviderItemScanner(stack);
    }

    public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        super.func_150895_a(item, tab, subItems);
        ItemStack stack = new ItemStack(item);
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (energyStorage == null) {
            return;
        }
        energyStorage.receiveEnergy(energyStorage.getMaxEnergyStored(), false);
        subItems.add((Object)stack);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"tooltip.scannable.scanner", (Object[])new Object[0]));
        if (!Settings.useEnergy()) {
            return;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (energyStorage == null) {
            return;
        }
        tooltip.add(I18n.func_135052_a((String)"tooltip.scannable.scanner.energy", (Object[])new Object[]{energyStorage.getEnergyStored(), energyStorage.getMaxEnergyStored()}));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return Settings.useEnergy();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (!Settings.useEnergy()) {
            return 0.0;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (energyStorage == null) {
            return 1.0;
        }
        return 1.0f - (float)energyStorage.getEnergyStored() / (float)energyStorage.getMaxEnergyStored();
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            player.openGui((Object)Scannable.instance, GuiId.SCANNER.id, world, hand.ordinal(), 0, 0);
        } else {
            ArrayList<ItemStack> modules = new ArrayList<ItemStack>();
            if (!ItemScanner.collectModules(stack, modules)) {
                if (world.field_72995_K) {
                    Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146234_a((ITextComponent)new TextComponentTranslation("message.scannable.no_scan_modules", new Object[0]), Constants.CHAT_LINE_ID);
                }
                player.func_184811_cZ().func_185145_a((Item)this, 10);
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            if (!ItemScanner.tryConsumeEnergy(player, stack, modules, true)) {
                if (world.field_72995_K) {
                    Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146234_a((ITextComponent)new TextComponentTranslation("message.scannable.not_enough_energy", new Object[0]), Constants.CHAT_LINE_ID);
                }
                player.func_184811_cZ().func_185145_a((Item)this, 10);
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            player.func_184598_c(hand);
            if (world.field_72995_K) {
                ScanManager.INSTANCE.beginScan(player, modules);
                SoundManager.INSTANCE.playChargingSound();
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b() || slotChanged;
    }

    public int func_77626_a(ItemStack stack) {
        return 40;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entity, int count) {
        if (entity.func_130014_f_().field_72995_K) {
            ScanManager.INSTANCE.updateScan((Entity)entity, false);
        }
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        if (world.field_72995_K) {
            ScanManager.INSTANCE.cancelScan();
            SoundManager.INSTANCE.stopChargingSound();
        }
        super.func_77615_a(stack, world, entity, timeLeft);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entity) {
        if (!(entity instanceof EntityPlayer)) {
            return stack;
        }
        MinecraftForge.EVENT_BUS.register((Object)SoundCanceler.INSTANCE);
        ArrayList<ItemStack> modules = new ArrayList<ItemStack>();
        if (!ItemScanner.collectModules(stack, modules)) {
            return stack;
        }
        boolean hasEnergy = ItemScanner.tryConsumeEnergy((EntityPlayer)entity, stack, modules, false);
        if (world.field_72995_K) {
            SoundManager.INSTANCE.stopChargingSound();
            if (hasEnergy) {
                ScanManager.INSTANCE.updateScan((Entity)entity, true);
                SoundManager.INSTANCE.playActivateSound();
            } else {
                ScanManager.INSTANCE.cancelScan();
            }
        }
        EntityPlayer player = (EntityPlayer)entity;
        player.func_184811_cZ().func_185145_a((Item)this, 40);
        return stack;
    }

    static int getModuleEnergyCost(EntityPlayer player, ItemStack module) {
        ScanResultProvider provider = (ScanResultProvider)module.getCapability(CapabilityScanResultProvider.SCAN_RESULT_PROVIDER_CAPABILITY, null);
        if (provider != null) {
            return provider.getEnergyCost(player, module);
        }
        if (Items.isModuleRange(module)) {
            return Settings.getEnergyCostModuleRange();
        }
        return 0;
    }

    private static boolean tryConsumeEnergy(EntityPlayer player, ItemStack stack, List<ItemStack> modules, boolean simulate) {
        if (!Settings.useEnergy()) {
            return true;
        }
        if (player.func_184812_l_()) {
            return true;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (energyStorage == null) {
            return false;
        }
        int totalCost = 0;
        for (ItemStack module : modules) {
            totalCost += ItemScanner.getModuleEnergyCost(player, module);
        }
        int extracted = energyStorage.extractEnergy(totalCost, simulate);
        return extracted >= totalCost;
    }

    private static boolean collectModules(ItemStack stack, List<ItemStack> modules) {
        boolean hasProvider = false;
        IItemHandler scannerInventory = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        assert (scannerInventory != null);
        for (int slot = 0; slot < scannerInventory.getSlots(); ++slot) {
            ItemStack module = scannerInventory.getStackInSlot(slot);
            if (module.func_190926_b()) continue;
            modules.add(module);
            if (!module.hasCapability(CapabilityScanResultProvider.SCAN_RESULT_PROVIDER_CAPABILITY, null)) continue;
            hasProvider = true;
        }
        return hasProvider;
    }

    private static enum SoundCanceler {
        INSTANCE;


        @SubscribeEvent
        public void onPlaySoundAtEntityEvent(PlaySoundAtEntityEvent event) {
            if (event.getSound() == SoundEvents.field_187719_p) {
                event.setCanceled(true);
            }
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }
}

