/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.item;

import java.util.List;
import javax.annotation.Nullable;
import li.cil.scannable.common.config.Constants;
import li.cil.scannable.common.config.Settings;
import li.cil.scannable.common.item.AbstractItemScannerModuleBlock;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public final class ItemScannerModuleBlockConfigurable
extends AbstractItemScannerModuleBlock {
    private static final String TAG_BLOCK = "block";
    private static final String TAG_METADATA = "meta";

    @Nullable
    public static IBlockState getBlockState(ItemStack stack) {
        if (!li.cil.scannable.common.init.Items.isModuleBlock(stack)) {
            return null;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b(TAG_BLOCK, 8) || !nbt.func_150297_b(TAG_METADATA, 3)) {
            return null;
        }
        ResourceLocation blockName = new ResourceLocation(nbt.func_74779_i(TAG_BLOCK));
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockName);
        if (block == null || block == Blocks.field_150350_a) {
            return null;
        }
        int blockMeta = nbt.func_74762_e(TAG_METADATA);
        return block.func_176203_a(blockMeta);
    }

    private static void setBlockState(ItemStack stack, IBlockState state) {
        NBTTagCompound nbt;
        if (!stack.func_77942_o()) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        } else {
            nbt = stack.func_77978_p();
        }
        assert (nbt != null);
        ResourceLocation blockName = state.func_177230_c().getRegistryName();
        if (blockName == null) {
            return;
        }
        nbt.func_74778_a(TAG_BLOCK, blockName.toString());
        nbt.func_74768_a(TAG_METADATA, state.func_177230_c().func_176201_c(state));
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        IBlockState state = ItemScannerModuleBlockConfigurable.getBlockState(stack);
        if (state == null) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.scannable.module_block", (Object[])new Object[0]));
        } else {
            Item item = Item.func_150898_a((Block)state.func_177230_c());
            if (item != Items.field_190931_a) {
                ItemStack blockStack = new ItemStack(item, 1, state.func_177230_c().func_180651_a(state));
                tooltip.add(I18n.func_135052_a((String)"tooltip.scannable.module_block.name", (Object[])new Object[]{blockStack.func_82833_r()}));
            } else {
                tooltip.add(I18n.func_135052_a((String)"tooltip.scannable.module_block.name", (Object[])new Object[]{state.func_177230_c().func_149732_F()}));
            }
        }
        super.func_77624_a(stack, player, tooltip, advanced);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.func_175667_e(pos)) {
            return EnumActionResult.PASS;
        }
        if (world.func_175623_d(pos)) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        IBlockState state = world.func_180495_p(pos);
        if (Settings.getBlockBlacklistSet().contains(state.func_177230_c())) {
            if (world.field_72995_K) {
                Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146234_a((ITextComponent)new TextComponentTranslation("message.scannable.block_blacklisted", new Object[0]), Constants.CHAT_LINE_ID);
            }
            player.func_184811_cZ().func_185145_a((Item)this, 10);
            return EnumActionResult.SUCCESS;
        }
        ItemScannerModuleBlockConfigurable.setBlockState(stack, state);
        return EnumActionResult.SUCCESS;
    }
}

