/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.network;

import li.cil.scannable.client.network.handler.MessageHandlerConfig;
import li.cil.scannable.client.network.handler.MessageHandlerStructureResponse;
import li.cil.scannable.common.config.Settings;
import li.cil.scannable.common.network.handler.MessageHandlerStructureRequest;
import li.cil.scannable.common.network.message.MessageConfig;
import li.cil.scannable.common.network.message.MessageStructureRequest;
import li.cil.scannable.common.network.message.MessageStructureResponse;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public enum Network {
    INSTANCE;

    private SimpleNetworkWrapper wrapper;

    public void init() {
        this.wrapper = NetworkRegistry.INSTANCE.newSimpleChannel("scannable");
        this.wrapper.registerMessage(MessageHandlerConfig.class, MessageConfig.class, Messages.Config.ordinal(), Side.CLIENT);
        this.wrapper.registerMessage(MessageHandlerStructureRequest.class, MessageStructureRequest.class, Messages.StructureRequest.ordinal(), Side.SERVER);
        this.wrapper.registerMessage(MessageHandlerStructureResponse.class, MessageStructureResponse.class, Messages.StructureResponse.ordinal(), Side.CLIENT);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public SimpleNetworkWrapper getWrapper() {
        return this.wrapper;
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            this.getWrapper().sendTo((IMessage)new MessageConfig(), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onClientDisconnectionFromServer(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        Settings.setServerSettings(null);
    }

    private static enum Messages {
        Config,
        StructureRequest,
        StructureResponse;

    }
}

