/**
 * @date 12-12-12
 * @describe: 简单实现 CommonJS 的 Modules/1.1.1
 *
 * 定义模块
 * math.js
 * define('math', function(require, exports, module) {
 *     exports.add = function(a, b){
 *          return a+b;
 *     }
 * });
 *
 * 调用模块
 * init.js
 * define('init',function(require, exports, module) {
 *     console.log(require('math').add(1,2,));
 * });
 * @author: KnightWu
 * @version: 0.0.1
 */

var offline_query_timeout_id;

(function (window, undefined) {

    var STATUS = {
        "DEFINED": "The module is just DEFINED",
        "INITIALIZED": "The module is compiled and module.exports is available."
    };

    if (window.define) {
        return;
    }

    function isFunction(obj) {
        return Object.prototype.toString.call(obj) === '[object Function]';
    }

    var moduleCache = {}; //所有模块的集合
    var parent; //记录当前运行模块
    var entryModuleIdentifier = null; //初始化模块的名称
    var scripts = document.getElementsByTagName('script');   //获取script节点

    for (var i = 0, l = scripts.length; i < l && !entryModuleIdentifier; i++) {
        entryModuleIdentifier = scripts[i].getAttribute('data-main');   //获取初始化模块的名称 即程序入口
    }

    if (!entryModuleIdentifier) {   //入口不存在则抛出异常
        throw new Error('No data-main attribute in script tag.');
    }
    /**
     * require 的实现
     * @param identifier
     * @return {*}
     */
    function require(identifier) {
        if (!moduleCache[identifier]) { //不存在该模块，则抛出异常
            throw new Error('Module ' + identifier + ' is not defined.');
        }
        var foreign = moduleCache[identifier]; //否则，取出该模块
        if (foreign.module.status !== STATUS.INITIALIZED) {  //未初始化
            initializeModule(identifier);   //初始化该模块
        }
        return foreign.module.exports;  //返回模块的exports或其他
    }

    /**
     * 初始化模块
     * @param identifier 模块名
     */
    function initializeModule(identifier) {
        var current = moduleCache[identifier], //获取模块
            module = current.module,
            exports = module.exports,
            factory = module.factory;
        module.parent = parent;//指向初始化时调用当前模块的模块。根据该属性，可以得到模块初始化时的 Call Stack.
        parent = current;
        if (isFunction(factory)) {  //检测模块的工厂方法是否函数
            var ret = factory(
                require,
                exports, //定义模块的exports
                module
            );
            if (ret !== undefined) {
                module.exports = ret;
            }
        } else {  //不是函数 直接返回factory 可以是对象
            module.exports = moduleCache[identifier].factory;
        }
        module.status = STATUS.INITIALIZED;
    }

    /**
     * define ，用来定义模块
     * @param identifier 模块名
     * @param dependencies 依赖模块名
     * @param factory  模块的实现
     */
    function define(identifier, dependencies, factory) {
        if (moduleCache[identifier]) {  //存在相同名称，抛出错误
            throw new Error('Module ' + identifier + ' has been defined already.');
        }
        if (typeof factory === 'undefined') {
            factory = dependencies;
        }
        if (isFunction(factory) || factory === Object(factory)) { //factory不是函数或者对象，抛出异常
            /**
             *
             * @type {{factory: *, module: {id: *, exports: {}}, uri: string, dependencies: Array, parent: {}, factory: *, status: null}}
             */
            moduleCache[identifier] = {  //模块的module属性，记录本模块的重要属性和方法
                module: {
                    id: identifier,
                    exports: {},
                    uri: '',
                    dependencies: [],
                    parent: undefined,
                    factory: factory,
                    status: STATUS.DEFINED
                }
            };
            if (identifier === entryModuleIdentifier) {   //如果此模块名称和初始化名称相同，表明是入口函数，直接执行
                initializeModule(identifier);
            }
        } else {
            throw new Error('factory of module ' + identifier + ' must be an object or a function.');
        }
    }

    window.define = define;
})(window);
/*!
 * jQuery JavaScript Library v2.1.0
 * http://jquery.com/
 *
 * Includes Sizzle.js
 * http://sizzlejs.com/
 *
 * Copyright 2005, 2014 jQuery Foundation, Inc. and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2014-01-23T21:10Z
 */
(function(global, factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        // For CommonJS and CommonJS-like environments where a proper window is present,
        // execute the factory and get jQuery
        // For environments that do not inherently posses a window with a document
        // (such as Node.js), expose a jQuery-making factory as module.exports
        // This accentuates the need for the creation of a real window
        // e.g. var jQuery = require("jquery")(window);
        // See ticket #14549 for more info
        module.exports = global.document ? factory(global, true) : function(w) {
            if (!w.document) {
                throw new Error("jQuery requires a window with a document");
            }
            return factory(w);
        };
    } else {
        factory(global);
    }
})(typeof window !== "undefined" ? window : this, function(window, noGlobal) {
    // Can't do this because several apps including ASP.NET trace
    // the stack via arguments.caller.callee and Firefox dies if
    // you try to trace through "use strict" call chains. (#13335)
    // Support: Firefox 18+
    //
    var arr = [];
    var slice = arr.slice;
    var concat = arr.concat;
    var push = arr.push;
    var indexOf = arr.indexOf;
    var class2type = {};
    var toString = class2type.toString;
    var hasOwn = class2type.hasOwnProperty;
    var trim = "".trim;
    var support = {};
    var // Use the correct document accordingly with window argument (sandbox)
    document = window.document, version = "2.1.0", // Define a local copy of jQuery
    jQuery = function(selector, context) {
        // The jQuery object is actually just the init constructor 'enhanced'
        // Need init if jQuery is called (just allow error to be thrown if not included)
        return new jQuery.fn.init(selector, context);
    }, // Matches dashed string for camelizing
    rmsPrefix = /^-ms-/, rdashAlpha = /-([\da-z])/gi, // Used by jQuery.camelCase as callback to replace()
    fcamelCase = function(all, letter) {
        return letter.toUpperCase();
    };
    jQuery.fn = jQuery.prototype = {
        // The current version of jQuery being used
        "jquery": version,
        "constructor": jQuery,
        // Start with an empty selector
        "selector": "",
        // The default length of a jQuery object is 0
        "length": 0,
        "toArray": function() {
            return slice.call(this);
        },
        // Get the Nth element in the matched element set OR
        // Get the whole matched element set as a clean array
        "get": function(num) {
            // Return a 'clean' array
            // Return just the object
            return num != null ? num < 0 ? this[num + this.length] : this[num] : slice.call(this);
        },
        // Take an array of elements and push it onto the stack
        // (returning the new matched element set)
        "pushStack": function(elems) {
            // Build a new jQuery matched element set
            var ret = jQuery.merge(this.constructor(), elems);
            // Add the old object onto the stack (as a reference)
            ret.prevObject = this;
            ret.context = this.context;
            // Return the newly-formed element set
            return ret;
        },
        // Execute a callback for every element in the matched set.
        // (You can seed the arguments with an array of args, but this is
        // only used internally.)
        "each": function(callback, args) {
            return jQuery.each(this, callback, args);
        },
        "map": function(callback) {
            return this.pushStack(jQuery.map(this, function(elem, i) {
                return callback.call(elem, i, elem);
            }));
        },
        "slice": function() {
            return this.pushStack(slice.apply(this, arguments));
        },
        "first": function() {
            return this.eq(0);
        },
        "last": function() {
            return this.eq(-1);
        },
        "eq": function(i) {
            var len = this.length, j = +i + (i < 0 ? len : 0);
            return this.pushStack(j >= 0 && j < len ? [ this[j] ] : []);
        },
        "end": function() {
            return this.prevObject || this.constructor(null);
        },
        // For internal use only.
        // Behaves like an Array's method, not like a jQuery method.
        "push": push,
        "sort": arr.sort,
        "splice": arr.splice
    };
    jQuery.extend = jQuery.fn.extend = function() {
        var options, name, src, copy, copyIsArray, clone, target = arguments[0] || {}, i = 1, length = arguments.length, deep = false;
        // Handle a deep copy situation
        if (typeof target === "boolean") {
            deep = target;
            // skip the boolean and the target
            target = arguments[i] || {};
            i++;
        }
        // Handle case when target is a string or something (possible in deep copy)
        if (typeof target !== "object" && !jQuery.isFunction(target)) {
            target = {};
        }
        // extend jQuery itself if only one argument is passed
        if (i === length) {
            target = this;
            i--;
        }
        for (;i < length; i++) {
            // Only deal with non-null/undefined values
            if ((options = arguments[i]) != null) {
                // Extend the base object
                for (name in options) {
                    src = target[name];
                    copy = options[name];
                    // Prevent never-ending loop
                    if (target === copy) {
                        continue;
                    }
                    // Recurse if we're merging plain objects or arrays
                    if (deep && copy && (jQuery.isPlainObject(copy) || (copyIsArray = jQuery.isArray(copy)))) {
                        if (copyIsArray) {
                            copyIsArray = false;
                            clone = src && jQuery.isArray(src) ? src : [];
                        } else {
                            clone = src && jQuery.isPlainObject(src) ? src : {};
                        }
                        // Never move original objects, clone them
                        target[name] = jQuery.extend(deep, clone, copy);
                    } else if (copy !== undefined) {
                        target[name] = copy;
                    }
                }
            }
        }
        // Return the modified object
        return target;
    };
    jQuery.extend({
        // Unique for each copy of jQuery on the page
        "expando": "jQuery" + (version + Math.random()).replace(/\D/g, ""),
        // Assume jQuery is ready without the ready module
        "isReady": true,
        "error": function(msg) {
            throw new Error(msg);
        },
        "noop": function() {},
        // See test/unit/core.js for details concerning isFunction.
        // Since version 1.3, DOM methods and functions like alert
        // aren't supported. They return false on IE (#2968).
        "isFunction": function(obj) {
            return jQuery.type(obj) === "function";
        },
        "isArray": Array.isArray,
        "isWindow": function(obj) {
            return obj != null && obj === obj.window;
        },
        "isNumeric": function(obj) {
            // parseFloat NaNs numeric-cast false positives (null|true|false|"")
            // ...but misinterprets leading-number strings, particularly hex literals ("0x...")
            // subtraction forces infinities to NaN
            return obj - parseFloat(obj) >= 0;
        },
        "isPlainObject": function(obj) {
            // Not plain objects:
            // - Any object or value whose internal [[Class]] property is not "[object Object]"
            // - DOM nodes
            // - window
            if (jQuery.type(obj) !== "object" || obj.nodeType || jQuery.isWindow(obj)) {
                return false;
            }
            // Support: Firefox <20
            // The try/catch suppresses exceptions thrown when attempting to access
            // the "constructor" property of certain host objects, ie. |window.location|
            // https://bugzilla.mozilla.org/show_bug.cgi?id=814622
            try {
                if (obj.constructor && !hasOwn.call(obj.constructor.prototype, "isPrototypeOf")) {
                    return false;
                }
            } catch (e) {
                return false;
            }
            // If the function hasn't returned already, we're confident that
            // |obj| is a plain object, created by {} or constructed with new Object
            return true;
        },
        "isEmptyObject": function(obj) {
            var name;
            for (name in obj) {
                return false;
            }
            return true;
        },
        "type": function(obj) {
            if (obj == null) {
                return obj + "";
            }
            // Support: Android < 4.0, iOS < 6 (functionish RegExp)
            return typeof obj === "object" || typeof obj === "function" ? class2type[toString.call(obj)] || "object" : typeof obj;
        },
        // Evaluates a script in a global context
        "globalEval": function(code) {
            var script, indirect = eval;
            code = jQuery.trim(code);
            if (code) {
                // If the code includes a valid, prologue position
                // strict mode pragma, execute code by injecting a
                // script tag into the document.
                if (code.indexOf("use strict") === 1) {
                    script = document.createElement("script");
                    script.text = code;
                    document.head.appendChild(script).parentNode.removeChild(script);
                } else {
                    // Otherwise, avoid the DOM node creation, insertion
                    // and removal by using an indirect global eval
                    indirect(code);
                }
            }
        },
        // Convert dashed to camelCase; used by the css and data modules
        // Microsoft forgot to hump their vendor prefix (#9572)
        "camelCase": function(string) {
            return string.replace(rmsPrefix, "ms-").replace(rdashAlpha, fcamelCase);
        },
        "nodeName": function(elem, name) {
            return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();
        },
        // args is for internal usage only
        "each": function(obj, callback, args) {
            var value, i = 0, length = obj.length, isArray = isArraylike(obj);
            if (args) {
                if (isArray) {
                    for (;i < length; i++) {
                        value = callback.apply(obj[i], args);
                        if (value === false) {
                            break;
                        }
                    }
                } else {
                    for (i in obj) {
                        value = callback.apply(obj[i], args);
                        if (value === false) {
                            break;
                        }
                    }
                }
            } else {
                if (isArray) {
                    for (;i < length; i++) {
                        value = callback.call(obj[i], i, obj[i]);
                        if (value === false) {
                            break;
                        }
                    }
                } else {
                    for (i in obj) {
                        value = callback.call(obj[i], i, obj[i]);
                        if (value === false) {
                            break;
                        }
                    }
                }
            }
            return obj;
        },
        "trim": function(text) {
            return text == null ? "" : trim.call(text);
        },
        // results is for internal usage only
        "makeArray": function(arr, results) {
            var ret = results || [];
            if (arr != null) {
                if (isArraylike(Object(arr))) {
                    jQuery.merge(ret, typeof arr === "string" ? [ arr ] : arr);
                } else {
                    push.call(ret, arr);
                }
            }
            return ret;
        },
        "inArray": function(elem, arr, i) {
            return arr == null ? -1 : indexOf.call(arr, elem, i);
        },
        "merge": function(first, second) {
            var len = +second.length, j = 0, i = first.length;
            for (;j < len; j++) {
                first[i++] = second[j];
            }
            first.length = i;
            return first;
        },
        "grep": function(elems, callback, invert) {
            var callbackInverse, matches = [], i = 0, length = elems.length, callbackExpect = !invert;
            // Go through the array, only saving the items
            // that pass the validator function
            for (;i < length; i++) {
                callbackInverse = !callback(elems[i], i);
                if (callbackInverse !== callbackExpect) {
                    matches.push(elems[i]);
                }
            }
            return matches;
        },
        // arg is for internal usage only
        "map": function(elems, callback, arg) {
            var value, i = 0, length = elems.length, isArray = isArraylike(elems), ret = [];
            // Go through the array, translating each of the items to their new values
            if (isArray) {
                for (;i < length; i++) {
                    value = callback(elems[i], i, arg);
                    if (value != null) {
                        ret.push(value);
                    }
                }
            } else {
                for (i in elems) {
                    value = callback(elems[i], i, arg);
                    if (value != null) {
                        ret.push(value);
                    }
                }
            }
            // Flatten any nested arrays
            return concat.apply([], ret);
        },
        // A global GUID counter for objects
        "guid": 1,
        // Bind a function to a context, optionally partially applying any
        // arguments.
        "proxy": function(fn, context) {
            var tmp, args, proxy;
            if (typeof context === "string") {
                tmp = fn[context];
                context = fn;
                fn = tmp;
            }
            // Quick check to determine if target is callable, in the spec
            // this throws a TypeError, but we will just return undefined.
            if (!jQuery.isFunction(fn)) {
                return undefined;
            }
            // Simulated bind
            args = slice.call(arguments, 2);
            proxy = function() {
                return fn.apply(context || this, args.concat(slice.call(arguments)));
            };
            // Set the guid of unique handler to the same of original handler, so it can be removed
            proxy.guid = fn.guid = fn.guid || jQuery.guid++;
            return proxy;
        },
        "now": Date.now,
        // jQuery.support is not used in Core but other projects attach their
        // properties to it so it needs to exist.
        "support": support
    });
    // Populate the class2type map
    jQuery.each("Boolean Number String Function Array Date RegExp Object Error".split(" "), function(i, name) {
        class2type["[object " + name + "]"] = name.toLowerCase();
    });
    function isArraylike(obj) {
        var length = obj.length, type = jQuery.type(obj);
        if (type === "function" || jQuery.isWindow(obj)) {
            return false;
        }
        if (obj.nodeType === 1 && length) {
            return true;
        }
        return type === "array" || length === 0 || typeof length === "number" && length > 0 && length - 1 in obj;
    }
    /*!
     * Sizzle CSS Selector Engine v1.10.16
     * http://sizzlejs.com/
     *
     * Copyright 2013 jQuery Foundation, Inc. and other contributors
     * Released under the MIT license
     * http://jquery.org/license
     *
     * Date: 2014-01-13
     */
    var Sizzle = function(window) {
        var i, support, Expr, getText, isXML, compile, outermostContext, sortInput, hasDuplicate, // Local document vars
        setDocument, document, docElem, documentIsHTML, rbuggyQSA, rbuggyMatches, matches, contains, // Instance-specific data
        expando = "sizzle" + -new Date(), preferredDoc = window.document, dirruns = 0, done = 0, classCache = createCache(), tokenCache = createCache(), compilerCache = createCache(), sortOrder = function(a, b) {
            if (a === b) {
                hasDuplicate = true;
            }
            return 0;
        }, // General-purpose constants
        strundefined = typeof undefined, MAX_NEGATIVE = 1 << 31, // Instance methods
        hasOwn = {}.hasOwnProperty, arr = [], pop = arr.pop, push_native = arr.push, push = arr.push, slice = arr.slice, // Use a stripped-down indexOf if we can't use a native one
        indexOf = arr.indexOf || function(elem) {
            var i = 0, len = this.length;
            for (;i < len; i++) {
                if (this[i] === elem) {
                    return i;
                }
            }
            return -1;
        }, booleans = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped", // Regular expressions
        // Whitespace characters http://www.w3.org/TR/css3-selectors/#whitespace
        whitespace = "[\\x20\\t\\r\\n\\f]", // http://www.w3.org/TR/css3-syntax/#characters
        characterEncoding = "(?:\\\\.|[\\w-]|[^\\x00-\\xa0])+", // Loosely modeled on CSS identifier characters
        // An unquoted value should be a CSS identifier http://www.w3.org/TR/css3-selectors/#attribute-selectors
        // Proper syntax: http://www.w3.org/TR/CSS21/syndata.html#value-def-identifier
        identifier = characterEncoding.replace("w", "w#"), // Acceptable operators http://www.w3.org/TR/selectors/#attribute-selectors
        attributes = "\\[" + whitespace + "*(" + characterEncoding + ")" + whitespace + "*(?:([*^$|!~]?=)" + whitespace + "*(?:(['\"])((?:\\\\.|[^\\\\])*?)\\3|(" + identifier + ")|)|)" + whitespace + "*\\]", // Prefer arguments quoted,
        //   then not containing pseudos/brackets,
        //   then attribute selectors/non-parenthetical expressions,
        //   then anything else
        // These preferences are here to reduce the number of selectors
        //   needing tokenize in the PSEUDO preFilter
        pseudos = ":(" + characterEncoding + ")(?:\\(((['\"])((?:\\\\.|[^\\\\])*?)\\3|((?:\\\\.|[^\\\\()[\\]]|" + attributes.replace(3, 8) + ")*)|.*)\\)|)", // Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter
        rtrim = new RegExp("^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" + whitespace + "+$", "g"), rcomma = new RegExp("^" + whitespace + "*," + whitespace + "*"), rcombinators = new RegExp("^" + whitespace + "*([>+~]|" + whitespace + ")" + whitespace + "*"), rattributeQuotes = new RegExp("=" + whitespace + "*([^\\]'\"]*?)" + whitespace + "*\\]", "g"), rpseudo = new RegExp(pseudos), ridentifier = new RegExp("^" + identifier + "$"), matchExpr = {
            "ID": new RegExp("^#(" + characterEncoding + ")"),
            "CLASS": new RegExp("^\\.(" + characterEncoding + ")"),
            "TAG": new RegExp("^(" + characterEncoding.replace("w", "w*") + ")"),
            "ATTR": new RegExp("^" + attributes),
            "PSEUDO": new RegExp("^" + pseudos),
            "CHILD": new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" + whitespace + "*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" + whitespace + "*(\\d+)|))" + whitespace + "*\\)|)", "i"),
            "bool": new RegExp("^(?:" + booleans + ")$", "i"),
            // For use in libraries implementing .is()
            // We use this for POS matching in `select`
            "needsContext": new RegExp("^" + whitespace + "*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + whitespace + "*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)", "i")
        }, rinputs = /^(?:input|select|textarea|button)$/i, rheader = /^h\d$/i, rnative = /^[^{]+\{\s*\[native \w/, // Easily-parseable/retrievable ID or TAG or CLASS selectors
        rquickExpr = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/, rsibling = /[+~]/, rescape = /'|\\/g, // CSS escapes http://www.w3.org/TR/CSS21/syndata.html#escaped-characters
        runescape = new RegExp("\\\\([\\da-f]{1,6}" + whitespace + "?|(" + whitespace + ")|.)", "ig"), funescape = function(_, escaped, escapedWhitespace) {
            var high = "0x" + escaped - 65536;
            // NaN means non-codepoint
            // Support: Firefox
            // Workaround erroneous numeric interpretation of +"0x"
            // BMP codepoint
            // Supplemental Plane codepoint (surrogate pair)
            return high !== high || escapedWhitespace ? escaped : high < 0 ? String.fromCharCode(high + 65536) : String.fromCharCode(high >> 10 | 55296, high & 1023 | 56320);
        };
        // Optimize for push.apply( _, NodeList )
        try {
            push.apply(arr = slice.call(preferredDoc.childNodes), preferredDoc.childNodes);
            // Support: Android<4.0
            // Detect silently failing push.apply
            arr[preferredDoc.childNodes.length].nodeType;
        } catch (e) {
            push = {
                "apply": arr.length ? // Leverage slice if possible
                function(target, els) {
                    push_native.apply(target, slice.call(els));
                } : // Support: IE<9
                // Otherwise append directly
                function(target, els) {
                    var j = target.length, i = 0;
                    // Can't trust NodeList.length
                    while (target[j++] = els[i++]) {}
                    target.length = j - 1;
                }
            };
        }
        function Sizzle(selector, context, results, seed) {
            var match, elem, m, nodeType, // QSA vars
            i, groups, old, nid, newContext, newSelector;
            if ((context ? context.ownerDocument || context : preferredDoc) !== document) {
                setDocument(context);
            }
            context = context || document;
            results = results || [];
            if (!selector || typeof selector !== "string") {
                return results;
            }
            if ((nodeType = context.nodeType) !== 1 && nodeType !== 9) {
                return [];
            }
            if (documentIsHTML && !seed) {
                // Shortcuts
                if (match = rquickExpr.exec(selector)) {
                    // Speed-up: Sizzle("#ID")
                    if (m = match[1]) {
                        if (nodeType === 9) {
                            elem = context.getElementById(m);
                            // Check parentNode to catch when Blackberry 4.6 returns
                            // nodes that are no longer in the document (jQuery #6963)
                            if (elem && elem.parentNode) {
                                // Handle the case where IE, Opera, and Webkit return items
                                // by name instead of ID
                                if (elem.id === m) {
                                    results.push(elem);
                                    return results;
                                }
                            } else {
                                return results;
                            }
                        } else {
                            // Context is not a document
                            if (context.ownerDocument && (elem = context.ownerDocument.getElementById(m)) && contains(context, elem) && elem.id === m) {
                                results.push(elem);
                                return results;
                            }
                        }
                    } else if (match[2]) {
                        push.apply(results, context.getElementsByTagName(selector));
                        return results;
                    } else if ((m = match[3]) && support.getElementsByClassName && context.getElementsByClassName) {
                        push.apply(results, context.getElementsByClassName(m));
                        return results;
                    }
                }
                // QSA path
                if (support.qsa && (!rbuggyQSA || !rbuggyQSA.test(selector))) {
                    nid = old = expando;
                    newContext = context;
                    newSelector = nodeType === 9 && selector;
                    // qSA works strangely on Element-rooted queries
                    // We can work around this by specifying an extra ID on the root
                    // and working up from there (Thanks to Andrew Dupont for the technique)
                    // IE 8 doesn't work on object elements
                    if (nodeType === 1 && context.nodeName.toLowerCase() !== "object") {
                        groups = tokenize(selector);
                        if (old = context.getAttribute("id")) {
                            nid = old.replace(rescape, "\\$&");
                        } else {
                            context.setAttribute("id", nid);
                        }
                        nid = "[id='" + nid + "'] ";
                        i = groups.length;
                        while (i--) {
                            groups[i] = nid + toSelector(groups[i]);
                        }
                        newContext = rsibling.test(selector) && testContext(context.parentNode) || context;
                        newSelector = groups.join(",");
                    }
                    if (newSelector) {
                        try {
                            push.apply(results, newContext.querySelectorAll(newSelector));
                            return results;
                        } catch (qsaError) {} finally {
                            if (!old) {
                                context.removeAttribute("id");
                            }
                        }
                    }
                }
            }
            // All others
            return select(selector.replace(rtrim, "$1"), context, results, seed);
        }
        /**
       * Create key-value caches of limited size
       * @returns {Function(string, Object)} Returns the Object data after storing it on itself with
       *	property name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)
       *	deleting the oldest entry
       */
        function createCache() {
            var keys = [];
            function cache(key, value) {
                // Use (key + " ") to avoid collision with native prototype properties (see Issue #157)
                if (keys.push(key + " ") > Expr.cacheLength) {
                    // Only keep the most recent entries
                    delete cache[keys.shift()];
                }
                return cache[key + " "] = value;
            }
            return cache;
        }
        /**
       * Mark a function for special use by Sizzle
       * @param {Function} fn The function to mark
       */
        function markFunction(fn) {
            fn[expando] = true;
            return fn;
        }
        /**
       * Support testing using an element
       * @param {Function} fn Passed the created div and expects a boolean result
       */
        function assert(fn) {
            var div = document.createElement("div");
            try {
                return !!fn(div);
            } catch (e) {
                return false;
            } finally {
                // Remove from its parent by default
                if (div.parentNode) {
                    div.parentNode.removeChild(div);
                }
                // release memory in IE
                div = null;
            }
        }
        /**
       * Adds the same handler for all of the specified attrs
       * @param {String} attrs Pipe-separated list of attributes
       * @param {Function} handler The method that will be applied
       */
        function addHandle(attrs, handler) {
            var arr = attrs.split("|"), i = attrs.length;
            while (i--) {
                Expr.attrHandle[arr[i]] = handler;
            }
        }
        /**
       * Checks document order of two siblings
       * @param {Element} a
       * @param {Element} b
       * @returns {Number} Returns less than 0 if a precedes b, greater than 0 if a follows b
       */
        function siblingCheck(a, b) {
            var cur = b && a, diff = cur && a.nodeType === 1 && b.nodeType === 1 && (~b.sourceIndex || MAX_NEGATIVE) - (~a.sourceIndex || MAX_NEGATIVE);
            // Use IE sourceIndex if available on both nodes
            if (diff) {
                return diff;
            }
            // Check if b follows a
            if (cur) {
                while (cur = cur.nextSibling) {
                    if (cur === b) {
                        return -1;
                    }
                }
            }
            return a ? 1 : -1;
        }
        /**
       * Returns a function to use in pseudos for input types
       * @param {String} type
       */
        function createInputPseudo(type) {
            return function(elem) {
                var name = elem.nodeName.toLowerCase();
                return name === "input" && elem.type === type;
            };
        }
        /**
       * Returns a function to use in pseudos for buttons
       * @param {String} type
       */
        function createButtonPseudo(type) {
            return function(elem) {
                var name = elem.nodeName.toLowerCase();
                return (name === "input" || name === "button") && elem.type === type;
            };
        }
        /**
       * Returns a function to use in pseudos for positionals
       * @param {Function} fn
       */
        function createPositionalPseudo(fn) {
            return markFunction(function(argument) {
                argument = +argument;
                return markFunction(function(seed, matches) {
                    var j, matchIndexes = fn([], seed.length, argument), i = matchIndexes.length;
                    // Match elements found at the specified indexes
                    while (i--) {
                        if (seed[j = matchIndexes[i]]) {
                            seed[j] = !(matches[j] = seed[j]);
                        }
                    }
                });
            });
        }
        /**
       * Checks a node for validity as a Sizzle context
       * @param {Element|Object=} context
       * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value
       */
        function testContext(context) {
            return context && typeof context.getElementsByTagName !== strundefined && context;
        }
        // Expose support vars for convenience
        support = Sizzle.support = {};
        /**
       * Detects XML nodes
       * @param {Element|Object} elem An element or a document
       * @returns {Boolean} True iff elem is a non-HTML XML node
       */
        isXML = Sizzle.isXML = function(elem) {
            // documentElement is verified for cases where it doesn't yet exist
            // (such as loading iframes in IE - #4833)
            var documentElement = elem && (elem.ownerDocument || elem).documentElement;
            return documentElement ? documentElement.nodeName !== "HTML" : false;
        };
        /**
       * Sets document-related variables once based on the current document
       * @param {Element|Object} [doc] An element or document object to use to set the document
       * @returns {Object} Returns the current document
       */
        setDocument = Sizzle.setDocument = function(node) {
            var hasCompare, doc = node ? node.ownerDocument || node : preferredDoc, parent = doc.defaultView;
            // If no document and documentElement is available, return
            if (doc === document || doc.nodeType !== 9 || !doc.documentElement) {
                return document;
            }
            // Set our document
            document = doc;
            docElem = doc.documentElement;
            // Support tests
            documentIsHTML = !isXML(doc);
            // Support: IE>8
            // If iframe document is assigned to "document" variable and if iframe has been reloaded,
            // IE will throw "permission denied" error when accessing "document" variable, see jQuery #13936
            // IE6-8 do not support the defaultView property so parent will be undefined
            if (parent && parent !== parent.top) {
                // IE11 does not have attachEvent, so all must suffer
                if (parent.addEventListener) {
                    parent.addEventListener("unload", function() {
                        setDocument();
                    }, false);
                } else if (parent.attachEvent) {
                    parent.attachEvent("onunload", function() {
                        setDocument();
                    });
                }
            }
            /* Attributes
         ---------------------------------------------------------------------- */
            // Support: IE<8
            // Verify that getAttribute really returns attributes and not properties (excepting IE8 booleans)
            support.attributes = assert(function(div) {
                div.className = "i";
                return !div.getAttribute("className");
            });
            /* getElement(s)By*
         ---------------------------------------------------------------------- */
            // Check if getElementsByTagName("*") returns only elements
            support.getElementsByTagName = assert(function(div) {
                div.appendChild(doc.createComment(""));
                return !div.getElementsByTagName("*").length;
            });
            // Check if getElementsByClassName can be trusted
            support.getElementsByClassName = rnative.test(doc.getElementsByClassName) && assert(function(div) {
                div.innerHTML = "<div class='a'></div><div class='a i'></div>";
                // Support: Safari<4
                // Catch class over-caching
                div.firstChild.className = "i";
                // Support: Opera<10
                // Catch gEBCN failure to find non-leading classes
                return div.getElementsByClassName("i").length === 2;
            });
            // Support: IE<10
            // Check if getElementById returns elements by name
            // The broken getElementById methods don't pick up programatically-set names,
            // so use a roundabout getElementsByName test
            support.getById = assert(function(div) {
                docElem.appendChild(div).id = expando;
                return !doc.getElementsByName || !doc.getElementsByName(expando).length;
            });
            // ID find and filter
            if (support.getById) {
                Expr.find["ID"] = function(id, context) {
                    if (typeof context.getElementById !== strundefined && documentIsHTML) {
                        var m = context.getElementById(id);
                        // Check parentNode to catch when Blackberry 4.6 returns
                        // nodes that are no longer in the document #6963
                        return m && m.parentNode ? [ m ] : [];
                    }
                };
                Expr.filter["ID"] = function(id) {
                    var attrId = id.replace(runescape, funescape);
                    return function(elem) {
                        return elem.getAttribute("id") === attrId;
                    };
                };
            } else {
                // Support: IE6/7
                // getElementById is not reliable as a find shortcut
                delete Expr.find["ID"];
                Expr.filter["ID"] = function(id) {
                    var attrId = id.replace(runescape, funescape);
                    return function(elem) {
                        var node = typeof elem.getAttributeNode !== strundefined && elem.getAttributeNode("id");
                        return node && node.value === attrId;
                    };
                };
            }
            // Tag
            Expr.find["TAG"] = support.getElementsByTagName ? function(tag, context) {
                if (typeof context.getElementsByTagName !== strundefined) {
                    return context.getElementsByTagName(tag);
                }
            } : function(tag, context) {
                var elem, tmp = [], i = 0, results = context.getElementsByTagName(tag);
                // Filter out possible comments
                if (tag === "*") {
                    while (elem = results[i++]) {
                        if (elem.nodeType === 1) {
                            tmp.push(elem);
                        }
                    }
                    return tmp;
                }
                return results;
            };
            // Class
            Expr.find["CLASS"] = support.getElementsByClassName && function(className, context) {
                if (typeof context.getElementsByClassName !== strundefined && documentIsHTML) {
                    return context.getElementsByClassName(className);
                }
            };
            /* QSA/matchesSelector
         ---------------------------------------------------------------------- */
            // QSA and matchesSelector support
            // matchesSelector(:active) reports false when true (IE9/Opera 11.5)
            rbuggyMatches = [];
            // qSa(:focus) reports false when true (Chrome 21)
            // We allow this because of a bug in IE8/9 that throws an error
            // whenever `document.activeElement` is accessed on an iframe
            // So, we allow :focus to pass through QSA all the time to avoid the IE error
            // See http://bugs.jquery.com/ticket/13378
            rbuggyQSA = [];
            if (support.qsa = rnative.test(doc.querySelectorAll)) {
                // Build QSA regex
                // Regex strategy adopted from Diego Perini
                assert(function(div) {
                    // Select is set to empty string on purpose
                    // This is to test IE's treatment of not explicitly
                    // setting a boolean content attribute,
                    // since its presence should be enough
                    // http://bugs.jquery.com/ticket/12359
                    div.innerHTML = "<select t=''><option selected=''></option></select>";
                    // Support: IE8, Opera 10-12
                    // Nothing should be selected when empty strings follow ^= or $= or *=
                    if (div.querySelectorAll("[t^='']").length) {
                        rbuggyQSA.push("[*^$]=" + whitespace + "*(?:''|\"\")");
                    }
                    // Support: IE8
                    // Boolean attributes and "value" are not treated correctly
                    if (!div.querySelectorAll("[selected]").length) {
                        rbuggyQSA.push("\\[" + whitespace + "*(?:value|" + booleans + ")");
                    }
                    // Webkit/Opera - :checked should return selected option elements
                    // http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
                    // IE8 throws error here and will not see later tests
                    if (!div.querySelectorAll(":checked").length) {
                        rbuggyQSA.push(":checked");
                    }
                });
                assert(function(div) {
                    // Support: Windows 8 Native Apps
                    // The type and name attributes are restricted during .innerHTML assignment
                    var input = doc.createElement("input");
                    input.setAttribute("type", "hidden");
                    div.appendChild(input).setAttribute("name", "D");
                    // Support: IE8
                    // Enforce case-sensitivity of name attribute
                    if (div.querySelectorAll("[name=d]").length) {
                        rbuggyQSA.push("name" + whitespace + "*[*^$|!~]?=");
                    }
                    // FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)
                    // IE8 throws error here and will not see later tests
                    if (!div.querySelectorAll(":enabled").length) {
                        rbuggyQSA.push(":enabled", ":disabled");
                    }
                    // Opera 10-11 does not throw on post-comma invalid pseudos
                    div.querySelectorAll("*,:x");
                    rbuggyQSA.push(",.*:");
                });
            }
            if (support.matchesSelector = rnative.test(matches = docElem.webkitMatchesSelector || docElem.mozMatchesSelector || docElem.oMatchesSelector || docElem.msMatchesSelector)) {
                assert(function(div) {
                    // Check to see if it's possible to do matchesSelector
                    // on a disconnected node (IE 9)
                    support.disconnectedMatch = matches.call(div, "div");
                    // This should fail with an exception
                    // Gecko does not error, returns false instead
                    matches.call(div, "[s!='']:x");
                    rbuggyMatches.push("!=", pseudos);
                });
            }
            rbuggyQSA = rbuggyQSA.length && new RegExp(rbuggyQSA.join("|"));
            rbuggyMatches = rbuggyMatches.length && new RegExp(rbuggyMatches.join("|"));
            /* Contains
         ---------------------------------------------------------------------- */
            hasCompare = rnative.test(docElem.compareDocumentPosition);
            // Element contains another
            // Purposefully does not implement inclusive descendent
            // As in, an element does not contain itself
            contains = hasCompare || rnative.test(docElem.contains) ? function(a, b) {
                var adown = a.nodeType === 9 ? a.documentElement : a, bup = b && b.parentNode;
                return a === bup || !!(bup && bup.nodeType === 1 && (adown.contains ? adown.contains(bup) : a.compareDocumentPosition && a.compareDocumentPosition(bup) & 16));
            } : function(a, b) {
                if (b) {
                    while (b = b.parentNode) {
                        if (b === a) {
                            return true;
                        }
                    }
                }
                return false;
            };
            /* Sorting
         ---------------------------------------------------------------------- */
            // Document order sorting
            sortOrder = hasCompare ? function(a, b) {
                // Flag for duplicate removal
                if (a === b) {
                    hasDuplicate = true;
                    return 0;
                }
                // Sort on method existence if only one input has compareDocumentPosition
                var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;
                if (compare) {
                    return compare;
                }
                // Calculate position if both inputs belong to the same document
                compare = (a.ownerDocument || a) === (b.ownerDocument || b) ? a.compareDocumentPosition(b) : // Otherwise we know they are disconnected
                1;
                // Disconnected nodes
                if (compare & 1 || !support.sortDetached && b.compareDocumentPosition(a) === compare) {
                    // Choose the first element that is related to our preferred document
                    if (a === doc || a.ownerDocument === preferredDoc && contains(preferredDoc, a)) {
                        return -1;
                    }
                    if (b === doc || b.ownerDocument === preferredDoc && contains(preferredDoc, b)) {
                        return 1;
                    }
                    // Maintain original order
                    return sortInput ? indexOf.call(sortInput, a) - indexOf.call(sortInput, b) : 0;
                }
                return compare & 4 ? -1 : 1;
            } : function(a, b) {
                // Exit early if the nodes are identical
                if (a === b) {
                    hasDuplicate = true;
                    return 0;
                }
                var cur, i = 0, aup = a.parentNode, bup = b.parentNode, ap = [ a ], bp = [ b ];
                // Parentless nodes are either documents or disconnected
                if (!aup || !bup) {
                    return a === doc ? -1 : b === doc ? 1 : aup ? -1 : bup ? 1 : sortInput ? indexOf.call(sortInput, a) - indexOf.call(sortInput, b) : 0;
                } else if (aup === bup) {
                    return siblingCheck(a, b);
                }
                // Otherwise we need full lists of their ancestors for comparison
                cur = a;
                while (cur = cur.parentNode) {
                    ap.unshift(cur);
                }
                cur = b;
                while (cur = cur.parentNode) {
                    bp.unshift(cur);
                }
                // Walk down the tree looking for a discrepancy
                while (ap[i] === bp[i]) {
                    i++;
                }
                // Do a sibling check if the nodes have a common ancestor
                // Otherwise nodes in our document sort first
                return i ? siblingCheck(ap[i], bp[i]) : ap[i] === preferredDoc ? -1 : bp[i] === preferredDoc ? 1 : 0;
            };
            return doc;
        };
        Sizzle.matches = function(expr, elements) {
            return Sizzle(expr, null, null, elements);
        };
        Sizzle.matchesSelector = function(elem, expr) {
            // Set document vars if needed
            if ((elem.ownerDocument || elem) !== document) {
                setDocument(elem);
            }
            // Make sure that attribute selectors are quoted
            expr = expr.replace(rattributeQuotes, "='$1']");
            if (support.matchesSelector && documentIsHTML && (!rbuggyMatches || !rbuggyMatches.test(expr)) && (!rbuggyQSA || !rbuggyQSA.test(expr))) {
                try {
                    var ret = matches.call(elem, expr);
                    // IE 9's matchesSelector returns false on disconnected nodes
                    if (ret || support.disconnectedMatch || // As well, disconnected nodes are said to be in a document
                    // fragment in IE 9
                    elem.document && elem.document.nodeType !== 11) {
                        return ret;
                    }
                } catch (e) {}
            }
            return Sizzle(expr, document, null, [ elem ]).length > 0;
        };
        Sizzle.contains = function(context, elem) {
            // Set document vars if needed
            if ((context.ownerDocument || context) !== document) {
                setDocument(context);
            }
            return contains(context, elem);
        };
        Sizzle.attr = function(elem, name) {
            // Set document vars if needed
            if ((elem.ownerDocument || elem) !== document) {
                setDocument(elem);
            }
            var fn = Expr.attrHandle[name.toLowerCase()], // Don't get fooled by Object.prototype properties (jQuery #13807)
            val = fn && hasOwn.call(Expr.attrHandle, name.toLowerCase()) ? fn(elem, name, !documentIsHTML) : undefined;
            return val !== undefined ? val : support.attributes || !documentIsHTML ? elem.getAttribute(name) : (val = elem.getAttributeNode(name)) && val.specified ? val.value : null;
        };
        Sizzle.error = function(msg) {
            throw new Error("Syntax error, unrecognized expression: " + msg);
        };
        /**
       * Document sorting and removing duplicates
       * @param {ArrayLike} results
       */
        Sizzle.uniqueSort = function(results) {
            var elem, duplicates = [], j = 0, i = 0;
            // Unless we *know* we can detect duplicates, assume their presence
            hasDuplicate = !support.detectDuplicates;
            sortInput = !support.sortStable && results.slice(0);
            results.sort(sortOrder);
            if (hasDuplicate) {
                while (elem = results[i++]) {
                    if (elem === results[i]) {
                        j = duplicates.push(i);
                    }
                }
                while (j--) {
                    results.splice(duplicates[j], 1);
                }
            }
            // Clear input after sorting to release objects
            // See https://github.com/jquery/sizzle/pull/225
            sortInput = null;
            return results;
        };
        /**
       * Utility function for retrieving the text value of an array of DOM nodes
       * @param {Array|Element} elem
       */
        getText = Sizzle.getText = function(elem) {
            var node, ret = "", i = 0, nodeType = elem.nodeType;
            if (!nodeType) {
                // If no nodeType, this is expected to be an array
                while (node = elem[i++]) {
                    // Do not traverse comment nodes
                    ret += getText(node);
                }
            } else if (nodeType === 1 || nodeType === 9 || nodeType === 11) {
                // Use textContent for elements
                // innerText usage removed for consistency of new lines (jQuery #11153)
                if (typeof elem.textContent === "string") {
                    return elem.textContent;
                } else {
                    // Traverse its children
                    for (elem = elem.firstChild; elem; elem = elem.nextSibling) {
                        ret += getText(elem);
                    }
                }
            } else if (nodeType === 3 || nodeType === 4) {
                return elem.nodeValue;
            }
            // Do not include comment or processing instruction nodes
            return ret;
        };
        Expr = Sizzle.selectors = {
            // Can be adjusted by the user
            "cacheLength": 50,
            "createPseudo": markFunction,
            "match": matchExpr,
            "attrHandle": {},
            "find": {},
            "relative": {
                ">": {
                    "dir": "parentNode",
                    "first": true
                },
                " ": {
                    "dir": "parentNode"
                },
                "+": {
                    "dir": "previousSibling",
                    "first": true
                },
                "~": {
                    "dir": "previousSibling"
                }
            },
            "preFilter": {
                "ATTR": function(match) {
                    match[1] = match[1].replace(runescape, funescape);
                    // Move the given value to match[3] whether quoted or unquoted
                    match[3] = (match[4] || match[5] || "").replace(runescape, funescape);
                    if (match[2] === "~=") {
                        match[3] = " " + match[3] + " ";
                    }
                    return match.slice(0, 4);
                },
                "CHILD": function(match) {
                    /* matches from matchExpr["CHILD"]
             1 type (only|nth|...)
             2 what (child|of-type)
             3 argument (even|odd|\d*|\d*n([+-]\d+)?|...)
             4 xn-component of xn+y argument ([+-]?\d*n|)
             5 sign of xn-component
             6 x of xn-component
             7 sign of y-component
             8 y of y-component
             */
                    match[1] = match[1].toLowerCase();
                    if (match[1].slice(0, 3) === "nth") {
                        // nth-* requires argument
                        if (!match[3]) {
                            Sizzle.error(match[0]);
                        }
                        // numeric x and y parameters for Expr.filter.CHILD
                        // remember that false/true cast respectively to 0/1
                        match[4] = +(match[4] ? match[5] + (match[6] || 1) : 2 * (match[3] === "even" || match[3] === "odd"));
                        match[5] = +(match[7] + match[8] || match[3] === "odd");
                    } else if (match[3]) {
                        Sizzle.error(match[0]);
                    }
                    return match;
                },
                "PSEUDO": function(match) {
                    var excess, unquoted = !match[5] && match[2];
                    if (matchExpr["CHILD"].test(match[0])) {
                        return null;
                    }
                    // Accept quoted arguments as-is
                    if (match[3] && match[4] !== undefined) {
                        match[2] = match[4];
                    } else if (unquoted && rpseudo.test(unquoted) && (// Get excess from tokenize (recursively)
                    excess = tokenize(unquoted, true)) && (// advance to the next closing parenthesis
                    excess = unquoted.indexOf(")", unquoted.length - excess) - unquoted.length)) {
                        // excess is a negative index
                        match[0] = match[0].slice(0, excess);
                        match[2] = unquoted.slice(0, excess);
                    }
                    // Return only captures needed by the pseudo filter method (type and argument)
                    return match.slice(0, 3);
                }
            },
            "filter": {
                "TAG": function(nodeNameSelector) {
                    var nodeName = nodeNameSelector.replace(runescape, funescape).toLowerCase();
                    return nodeNameSelector === "*" ? function() {
                        return true;
                    } : function(elem) {
                        return elem.nodeName && elem.nodeName.toLowerCase() === nodeName;
                    };
                },
                "CLASS": function(className) {
                    var pattern = classCache[className + " "];
                    return pattern || (pattern = new RegExp("(^|" + whitespace + ")" + className + "(" + whitespace + "|$)")) && classCache(className, function(elem) {
                        return pattern.test(typeof elem.className === "string" && elem.className || typeof elem.getAttribute !== strundefined && elem.getAttribute("class") || "");
                    });
                },
                "ATTR": function(name, operator, check) {
                    return function(elem) {
                        var result = Sizzle.attr(elem, name);
                        if (result == null) {
                            return operator === "!=";
                        }
                        if (!operator) {
                            return true;
                        }
                        result += "";
                        return operator === "=" ? result === check : operator === "!=" ? result !== check : operator === "^=" ? check && result.indexOf(check) === 0 : operator === "*=" ? check && result.indexOf(check) > -1 : operator === "$=" ? check && result.slice(-check.length) === check : operator === "~=" ? (" " + result + " ").indexOf(check) > -1 : operator === "|=" ? result === check || result.slice(0, check.length + 1) === check + "-" : false;
                    };
                },
                "CHILD": function(type, what, argument, first, last) {
                    var simple = type.slice(0, 3) !== "nth", forward = type.slice(-4) !== "last", ofType = what === "of-type";
                    // Shortcut for :nth-*(n)
                    return first === 1 && last === 0 ? function(elem) {
                        return !!elem.parentNode;
                    } : function(elem, context, xml) {
                        var cache, outerCache, node, diff, nodeIndex, start, dir = simple !== forward ? "nextSibling" : "previousSibling", parent = elem.parentNode, name = ofType && elem.nodeName.toLowerCase(), useCache = !xml && !ofType;
                        if (parent) {
                            // :(first|last|only)-(child|of-type)
                            if (simple) {
                                while (dir) {
                                    node = elem;
                                    while (node = node[dir]) {
                                        if (ofType ? node.nodeName.toLowerCase() === name : node.nodeType === 1) {
                                            return false;
                                        }
                                    }
                                    // Reverse direction for :only-* (if we haven't yet done so)
                                    start = dir = type === "only" && !start && "nextSibling";
                                }
                                return true;
                            }
                            start = [ forward ? parent.firstChild : parent.lastChild ];
                            // non-xml :nth-child(...) stores cache data on `parent`
                            if (forward && useCache) {
                                // Seek `elem` from a previously-cached index
                                outerCache = parent[expando] || (parent[expando] = {});
                                cache = outerCache[type] || [];
                                nodeIndex = cache[0] === dirruns && cache[1];
                                diff = cache[0] === dirruns && cache[2];
                                node = nodeIndex && parent.childNodes[nodeIndex];
                                while (node = ++nodeIndex && node && node[dir] || (// Fallback to seeking `elem` from the start
                                diff = nodeIndex = 0) || start.pop()) {
                                    // When found, cache indexes on `parent` and break
                                    if (node.nodeType === 1 && ++diff && node === elem) {
                                        outerCache[type] = [ dirruns, nodeIndex, diff ];
                                        break;
                                    }
                                }
                            } else if (useCache && (cache = (elem[expando] || (elem[expando] = {}))[type]) && cache[0] === dirruns) {
                                diff = cache[1];
                            } else {
                                // Use the same loop as above to seek `elem` from the start
                                while (node = ++nodeIndex && node && node[dir] || (diff = nodeIndex = 0) || start.pop()) {
                                    if ((ofType ? node.nodeName.toLowerCase() === name : node.nodeType === 1) && ++diff) {
                                        // Cache the index of each encountered element
                                        if (useCache) {
                                            (node[expando] || (node[expando] = {}))[type] = [ dirruns, diff ];
                                        }
                                        if (node === elem) {
                                            break;
                                        }
                                    }
                                }
                            }
                            // Incorporate the offset, then check against cycle size
                            diff -= last;
                            return diff === first || diff % first === 0 && diff / first >= 0;
                        }
                    };
                },
                "PSEUDO": function(pseudo, argument) {
                    // pseudo-class names are case-insensitive
                    // http://www.w3.org/TR/selectors/#pseudo-classes
                    // Prioritize by case sensitivity in case custom pseudos are added with uppercase letters
                    // Remember that setFilters inherits from pseudos
                    var args, fn = Expr.pseudos[pseudo] || Expr.setFilters[pseudo.toLowerCase()] || Sizzle.error("unsupported pseudo: " + pseudo);
                    // The user may use createPseudo to indicate that
                    // arguments are needed to create the filter function
                    // just as Sizzle does
                    if (fn[expando]) {
                        return fn(argument);
                    }
                    // But maintain support for old signatures
                    if (fn.length > 1) {
                        args = [ pseudo, pseudo, "", argument ];
                        return Expr.setFilters.hasOwnProperty(pseudo.toLowerCase()) ? markFunction(function(seed, matches) {
                            var idx, matched = fn(seed, argument), i = matched.length;
                            while (i--) {
                                idx = indexOf.call(seed, matched[i]);
                                seed[idx] = !(matches[idx] = matched[i]);
                            }
                        }) : function(elem) {
                            return fn(elem, 0, args);
                        };
                    }
                    return fn;
                }
            },
            "pseudos": {
                // Potentially complex pseudos
                "not": markFunction(function(selector) {
                    // Trim the selector passed to compile
                    // to avoid treating leading and trailing
                    // spaces as combinators
                    var input = [], results = [], matcher = compile(selector.replace(rtrim, "$1"));
                    return matcher[expando] ? markFunction(function(seed, matches, context, xml) {
                        var elem, unmatched = matcher(seed, null, xml, []), i = seed.length;
                        // Match elements unmatched by `matcher`
                        while (i--) {
                            if (elem = unmatched[i]) {
                                seed[i] = !(matches[i] = elem);
                            }
                        }
                    }) : function(elem, context, xml) {
                        input[0] = elem;
                        matcher(input, null, xml, results);
                        return !results.pop();
                    };
                }),
                "has": markFunction(function(selector) {
                    return function(elem) {
                        return Sizzle(selector, elem).length > 0;
                    };
                }),
                "contains": markFunction(function(text) {
                    return function(elem) {
                        return (elem.textContent || elem.innerText || getText(elem)).indexOf(text) > -1;
                    };
                }),
                // "Whether an element is represented by a :lang() selector
                // is based solely on the element's language value
                // being equal to the identifier C,
                // or beginning with the identifier C immediately followed by "-".
                // The matching of C against the element's language value is performed case-insensitively.
                // The identifier C does not have to be a valid language name."
                // http://www.w3.org/TR/selectors/#lang-pseudo
                "lang": markFunction(function(lang) {
                    // lang value must be a valid identifier
                    if (!ridentifier.test(lang || "")) {
                        Sizzle.error("unsupported lang: " + lang);
                    }
                    lang = lang.replace(runescape, funescape).toLowerCase();
                    return function(elem) {
                        var elemLang;
                        do {
                            if (elemLang = documentIsHTML ? elem.lang : elem.getAttribute("xml:lang") || elem.getAttribute("lang")) {
                                elemLang = elemLang.toLowerCase();
                                return elemLang === lang || elemLang.indexOf(lang + "-") === 0;
                            }
                        } while ((elem = elem.parentNode) && elem.nodeType === 1);
                        return false;
                    };
                }),
                // Miscellaneous
                "target": function(elem) {
                    var hash = window.location && window.location.hash;
                    return hash && hash.slice(1) === elem.id;
                },
                "root": function(elem) {
                    return elem === docElem;
                },
                "focus": function(elem) {
                    return elem === document.activeElement && (!document.hasFocus || document.hasFocus()) && !!(elem.type || elem.href || ~elem.tabIndex);
                },
                // Boolean properties
                "enabled": function(elem) {
                    return elem.disabled === false;
                },
                "disabled": function(elem) {
                    return elem.disabled === true;
                },
                "checked": function(elem) {
                    // In CSS3, :checked should return both checked and selected elements
                    // http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
                    var nodeName = elem.nodeName.toLowerCase();
                    return nodeName === "input" && !!elem.checked || nodeName === "option" && !!elem.selected;
                },
                "selected": function(elem) {
                    // Accessing this property makes selected-by-default
                    // options in Safari work properly
                    if (elem.parentNode) {
                        elem.parentNode.selectedIndex;
                    }
                    return elem.selected === true;
                },
                // Contents
                "empty": function(elem) {
                    // http://www.w3.org/TR/selectors/#empty-pseudo
                    // :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),
                    //   but not by others (comment: 8; processing instruction: 7; etc.)
                    // nodeType < 6 works because attributes (2) do not appear as children
                    for (elem = elem.firstChild; elem; elem = elem.nextSibling) {
                        if (elem.nodeType < 6) {
                            return false;
                        }
                    }
                    return true;
                },
                "parent": function(elem) {
                    return !Expr.pseudos["empty"](elem);
                },
                // Element/input types
                "header": function(elem) {
                    return rheader.test(elem.nodeName);
                },
                "input": function(elem) {
                    return rinputs.test(elem.nodeName);
                },
                "button": function(elem) {
                    var name = elem.nodeName.toLowerCase();
                    return name === "input" && elem.type === "button" || name === "button";
                },
                "text": function(elem) {
                    var attr;
                    // Support: IE<8
                    // New HTML5 attribute values (e.g., "search") appear with elem.type === "text"
                    return elem.nodeName.toLowerCase() === "input" && elem.type === "text" && ((attr = elem.getAttribute("type")) == null || attr.toLowerCase() === "text");
                },
                // Position-in-collection
                "first": createPositionalPseudo(function() {
                    return [ 0 ];
                }),
                "last": createPositionalPseudo(function(matchIndexes, length) {
                    return [ length - 1 ];
                }),
                "eq": createPositionalPseudo(function(matchIndexes, length, argument) {
                    return [ argument < 0 ? argument + length : argument ];
                }),
                "even": createPositionalPseudo(function(matchIndexes, length) {
                    var i = 0;
                    for (;i < length; i += 2) {
                        matchIndexes.push(i);
                    }
                    return matchIndexes;
                }),
                "odd": createPositionalPseudo(function(matchIndexes, length) {
                    var i = 1;
                    for (;i < length; i += 2) {
                        matchIndexes.push(i);
                    }
                    return matchIndexes;
                }),
                "lt": createPositionalPseudo(function(matchIndexes, length, argument) {
                    var i = argument < 0 ? argument + length : argument;
                    for (;--i >= 0; ) {
                        matchIndexes.push(i);
                    }
                    return matchIndexes;
                }),
                "gt": createPositionalPseudo(function(matchIndexes, length, argument) {
                    var i = argument < 0 ? argument + length : argument;
                    for (;++i < length; ) {
                        matchIndexes.push(i);
                    }
                    return matchIndexes;
                })
            }
        };
        Expr.pseudos["nth"] = Expr.pseudos["eq"];
        // Add button/input type pseudos
        for (i in {
            "radio": true,
            "checkbox": true,
            "file": true,
            "password": true,
            "image": true
        }) {
            Expr.pseudos[i] = createInputPseudo(i);
        }
        for (i in {
            "submit": true,
            "reset": true
        }) {
            Expr.pseudos[i] = createButtonPseudo(i);
        }
        // Easy API for creating new setFilters
        function setFilters() {}
        setFilters.prototype = Expr.filters = Expr.pseudos;
        Expr.setFilters = new setFilters();
        function tokenize(selector, parseOnly) {
            var matched, match, tokens, type, soFar, groups, preFilters, cached = tokenCache[selector + " "];
            if (cached) {
                return parseOnly ? 0 : cached.slice(0);
            }
            soFar = selector;
            groups = [];
            preFilters = Expr.preFilter;
            while (soFar) {
                // Comma and first run
                if (!matched || (match = rcomma.exec(soFar))) {
                    if (match) {
                        // Don't consume trailing commas as valid
                        soFar = soFar.slice(match[0].length) || soFar;
                    }
                    groups.push(tokens = []);
                }
                matched = false;
                // Combinators
                if (match = rcombinators.exec(soFar)) {
                    matched = match.shift();
                    tokens.push({
                        "value": matched,
                        // Cast descendant combinators to space
                        "type": match[0].replace(rtrim, " ")
                    });
                    soFar = soFar.slice(matched.length);
                }
                // Filters
                for (type in Expr.filter) {
                    if ((match = matchExpr[type].exec(soFar)) && (!preFilters[type] || (match = preFilters[type](match)))) {
                        matched = match.shift();
                        tokens.push({
                            "value": matched,
                            "type": type,
                            "matches": match
                        });
                        soFar = soFar.slice(matched.length);
                    }
                }
                if (!matched) {
                    break;
                }
            }
            // Return the length of the invalid excess
            // if we're just parsing
            // Otherwise, throw an error or return tokens
            // Cache the tokens
            return parseOnly ? soFar.length : soFar ? Sizzle.error(selector) : tokenCache(selector, groups).slice(0);
        }
        function toSelector(tokens) {
            var i = 0, len = tokens.length, selector = "";
            for (;i < len; i++) {
                selector += tokens[i].value;
            }
            return selector;
        }
        function addCombinator(matcher, combinator, base) {
            var dir = combinator.dir, checkNonElements = base && dir === "parentNode", doneName = done++;
            // Check against closest ancestor/preceding element
            // Check against all ancestor/preceding elements
            return combinator.first ? function(elem, context, xml) {
                while (elem = elem[dir]) {
                    if (elem.nodeType === 1 || checkNonElements) {
                        return matcher(elem, context, xml);
                    }
                }
            } : function(elem, context, xml) {
                var oldCache, outerCache, newCache = [ dirruns, doneName ];
                // We can't set arbitrary data on XML nodes, so they don't benefit from dir caching
                if (xml) {
                    while (elem = elem[dir]) {
                        if (elem.nodeType === 1 || checkNonElements) {
                            if (matcher(elem, context, xml)) {
                                return true;
                            }
                        }
                    }
                } else {
                    while (elem = elem[dir]) {
                        if (elem.nodeType === 1 || checkNonElements) {
                            outerCache = elem[expando] || (elem[expando] = {});
                            if ((oldCache = outerCache[dir]) && oldCache[0] === dirruns && oldCache[1] === doneName) {
                                // Assign to newCache so results back-propagate to previous elements
                                return newCache[2] = oldCache[2];
                            } else {
                                // Reuse newcache so results back-propagate to previous elements
                                outerCache[dir] = newCache;
                                // A match means we're done; a fail means we have to keep checking
                                if (newCache[2] = matcher(elem, context, xml)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            };
        }
        function elementMatcher(matchers) {
            return matchers.length > 1 ? function(elem, context, xml) {
                var i = matchers.length;
                while (i--) {
                    if (!matchers[i](elem, context, xml)) {
                        return false;
                    }
                }
                return true;
            } : matchers[0];
        }
        function condense(unmatched, map, filter, context, xml) {
            var elem, newUnmatched = [], i = 0, len = unmatched.length, mapped = map != null;
            for (;i < len; i++) {
                if (elem = unmatched[i]) {
                    if (!filter || filter(elem, context, xml)) {
                        newUnmatched.push(elem);
                        if (mapped) {
                            map.push(i);
                        }
                    }
                }
            }
            return newUnmatched;
        }
        function setMatcher(preFilter, selector, matcher, postFilter, postFinder, postSelector) {
            if (postFilter && !postFilter[expando]) {
                postFilter = setMatcher(postFilter);
            }
            if (postFinder && !postFinder[expando]) {
                postFinder = setMatcher(postFinder, postSelector);
            }
            return markFunction(function(seed, results, context, xml) {
                var temp, i, elem, preMap = [], postMap = [], preexisting = results.length, // Get initial elements from seed or context
                elems = seed || multipleContexts(selector || "*", context.nodeType ? [ context ] : context, []), // Prefilter to get matcher input, preserving a map for seed-results synchronization
                matcherIn = preFilter && (seed || !selector) ? condense(elems, preMap, preFilter, context, xml) : elems, matcherOut = matcher ? // If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,
                postFinder || (seed ? preFilter : preexisting || postFilter) ? // ...intermediate processing is necessary
                [] : // ...otherwise use results directly
                results : matcherIn;
                // Find primary matches
                if (matcher) {
                    matcher(matcherIn, matcherOut, context, xml);
                }
                // Apply postFilter
                if (postFilter) {
                    temp = condense(matcherOut, postMap);
                    postFilter(temp, [], context, xml);
                    // Un-match failing elements by moving them back to matcherIn
                    i = temp.length;
                    while (i--) {
                        if (elem = temp[i]) {
                            matcherOut[postMap[i]] = !(matcherIn[postMap[i]] = elem);
                        }
                    }
                }
                if (seed) {
                    if (postFinder || preFilter) {
                        if (postFinder) {
                            // Get the final matcherOut by condensing this intermediate into postFinder contexts
                            temp = [];
                            i = matcherOut.length;
                            while (i--) {
                                if (elem = matcherOut[i]) {
                                    // Restore matcherIn since elem is not yet a final match
                                    temp.push(matcherIn[i] = elem);
                                }
                            }
                            postFinder(null, matcherOut = [], temp, xml);
                        }
                        // Move matched elements from seed to results to keep them synchronized
                        i = matcherOut.length;
                        while (i--) {
                            if ((elem = matcherOut[i]) && (temp = postFinder ? indexOf.call(seed, elem) : preMap[i]) > -1) {
                                seed[temp] = !(results[temp] = elem);
                            }
                        }
                    }
                } else {
                    matcherOut = condense(matcherOut === results ? matcherOut.splice(preexisting, matcherOut.length) : matcherOut);
                    if (postFinder) {
                        postFinder(null, results, matcherOut, xml);
                    } else {
                        push.apply(results, matcherOut);
                    }
                }
            });
        }
        function matcherFromTokens(tokens) {
            var checkContext, matcher, j, len = tokens.length, leadingRelative = Expr.relative[tokens[0].type], implicitRelative = leadingRelative || Expr.relative[" "], i = leadingRelative ? 1 : 0, // The foundational matcher ensures that elements are reachable from top-level context(s)
            matchContext = addCombinator(function(elem) {
                return elem === checkContext;
            }, implicitRelative, true), matchAnyContext = addCombinator(function(elem) {
                return indexOf.call(checkContext, elem) > -1;
            }, implicitRelative, true), matchers = [ function(elem, context, xml) {
                return !leadingRelative && (xml || context !== outermostContext) || ((checkContext = context).nodeType ? matchContext(elem, context, xml) : matchAnyContext(elem, context, xml));
            } ];
            for (;i < len; i++) {
                if (matcher = Expr.relative[tokens[i].type]) {
                    matchers = [ addCombinator(elementMatcher(matchers), matcher) ];
                } else {
                    matcher = Expr.filter[tokens[i].type].apply(null, tokens[i].matches);
                    // Return special upon seeing a positional matcher
                    if (matcher[expando]) {
                        // Find the next relative operator (if any) for proper handling
                        j = ++i;
                        for (;j < len; j++) {
                            if (Expr.relative[tokens[j].type]) {
                                break;
                            }
                        }
                        // If the preceding token was a descendant combinator, insert an implicit any-element `*`
                        return setMatcher(i > 1 && elementMatcher(matchers), i > 1 && toSelector(tokens.slice(0, i - 1).concat({
                            "value": tokens[i - 2].type === " " ? "*" : ""
                        })).replace(rtrim, "$1"), matcher, i < j && matcherFromTokens(tokens.slice(i, j)), j < len && matcherFromTokens(tokens = tokens.slice(j)), j < len && toSelector(tokens));
                    }
                    matchers.push(matcher);
                }
            }
            return elementMatcher(matchers);
        }
        function matcherFromGroupMatchers(elementMatchers, setMatchers) {
            var bySet = setMatchers.length > 0, byElement = elementMatchers.length > 0, superMatcher = function(seed, context, xml, results, outermost) {
                var elem, j, matcher, matchedCount = 0, i = "0", unmatched = seed && [], setMatched = [], contextBackup = outermostContext, // We must always have either seed elements or outermost context
                elems = seed || byElement && Expr.find["TAG"]("*", outermost), // Use integer dirruns iff this is the outermost matcher
                dirrunsUnique = dirruns += contextBackup == null ? 1 : Math.random() || .1, len = elems.length;
                if (outermost) {
                    outermostContext = context !== document && context;
                }
                // Add elements passing elementMatchers directly to results
                // Keep `i` a string if there are no elements so `matchedCount` will be "00" below
                // Support: IE<9, Safari
                // Tolerate NodeList properties (IE: "length"; Safari: <number>) matching elements by id
                for (;i !== len && (elem = elems[i]) != null; i++) {
                    if (byElement && elem) {
                        j = 0;
                        while (matcher = elementMatchers[j++]) {
                            if (matcher(elem, context, xml)) {
                                results.push(elem);
                                break;
                            }
                        }
                        if (outermost) {
                            dirruns = dirrunsUnique;
                        }
                    }
                    // Track unmatched elements for set filters
                    if (bySet) {
                        // They will have gone through all possible matchers
                        if (elem = !matcher && elem) {
                            matchedCount--;
                        }
                        // Lengthen the array for every element, matched or not
                        if (seed) {
                            unmatched.push(elem);
                        }
                    }
                }
                // Apply set filters to unmatched elements
                matchedCount += i;
                if (bySet && i !== matchedCount) {
                    j = 0;
                    while (matcher = setMatchers[j++]) {
                        matcher(unmatched, setMatched, context, xml);
                    }
                    if (seed) {
                        // Reintegrate element matches to eliminate the need for sorting
                        if (matchedCount > 0) {
                            while (i--) {
                                if (!(unmatched[i] || setMatched[i])) {
                                    setMatched[i] = pop.call(results);
                                }
                            }
                        }
                        // Discard index placeholder values to get only actual matches
                        setMatched = condense(setMatched);
                    }
                    // Add matches to results
                    push.apply(results, setMatched);
                    // Seedless set matches succeeding multiple successful matchers stipulate sorting
                    if (outermost && !seed && setMatched.length > 0 && matchedCount + setMatchers.length > 1) {
                        Sizzle.uniqueSort(results);
                    }
                }
                // Override manipulation of globals by nested matchers
                if (outermost) {
                    dirruns = dirrunsUnique;
                    outermostContext = contextBackup;
                }
                return unmatched;
            };
            return bySet ? markFunction(superMatcher) : superMatcher;
        }
        compile = Sizzle.compile = function(selector, group) {
            var i, setMatchers = [], elementMatchers = [], cached = compilerCache[selector + " "];
            if (!cached) {
                // Generate a function of recursive functions that can be used to check each element
                if (!group) {
                    group = tokenize(selector);
                }
                i = group.length;
                while (i--) {
                    cached = matcherFromTokens(group[i]);
                    if (cached[expando]) {
                        setMatchers.push(cached);
                    } else {
                        elementMatchers.push(cached);
                    }
                }
                // Cache the compiled function
                cached = compilerCache(selector, matcherFromGroupMatchers(elementMatchers, setMatchers));
            }
            return cached;
        };
        function multipleContexts(selector, contexts, results) {
            var i = 0, len = contexts.length;
            for (;i < len; i++) {
                Sizzle(selector, contexts[i], results);
            }
            return results;
        }
        function select(selector, context, results, seed) {
            var i, tokens, token, type, find, match = tokenize(selector);
            if (!seed) {
                // Try to minimize operations if there is only one group
                if (match.length === 1) {
                    // Take a shortcut and set the context if the root selector is an ID
                    tokens = match[0] = match[0].slice(0);
                    if (tokens.length > 2 && (token = tokens[0]).type === "ID" && support.getById && context.nodeType === 9 && documentIsHTML && Expr.relative[tokens[1].type]) {
                        context = (Expr.find["ID"](token.matches[0].replace(runescape, funescape), context) || [])[0];
                        if (!context) {
                            return results;
                        }
                        selector = selector.slice(tokens.shift().value.length);
                    }
                    // Fetch a seed set for right-to-left matching
                    i = matchExpr["needsContext"].test(selector) ? 0 : tokens.length;
                    while (i--) {
                        token = tokens[i];
                        // Abort if we hit a combinator
                        if (Expr.relative[type = token.type]) {
                            break;
                        }
                        if (find = Expr.find[type]) {
                            // Search, expanding context for leading sibling combinators
                            if (seed = find(token.matches[0].replace(runescape, funescape), rsibling.test(tokens[0].type) && testContext(context.parentNode) || context)) {
                                // If seed is empty or no tokens remain, we can return early
                                tokens.splice(i, 1);
                                selector = seed.length && toSelector(tokens);
                                if (!selector) {
                                    push.apply(results, seed);
                                    return results;
                                }
                                break;
                            }
                        }
                    }
                }
            }
            // Compile and execute a filtering function
            // Provide `match` to avoid retokenization if we modified the selector above
            compile(selector, match)(seed, context, !documentIsHTML, results, rsibling.test(selector) && testContext(context.parentNode) || context);
            return results;
        }
        // One-time assignments
        // Sort stability
        support.sortStable = expando.split("").sort(sortOrder).join("") === expando;
        // Support: Chrome<14
        // Always assume duplicates if they aren't passed to the comparison function
        support.detectDuplicates = !!hasDuplicate;
        // Initialize against the default document
        setDocument();
        // Support: Webkit<537.32 - Safari 6.0.3/Chrome 25 (fixed in Chrome 27)
        // Detached nodes confoundingly follow *each other*
        support.sortDetached = assert(function(div1) {
            // Should return 1, but returns 4 (following)
            return div1.compareDocumentPosition(document.createElement("div")) & 1;
        });
        // Support: IE<8
        // Prevent attribute/property "interpolation"
        // http://msdn.microsoft.com/en-us/library/ms536429%28VS.85%29.aspx
        if (!assert(function(div) {
            div.innerHTML = "<a href='#'></a>";
            return div.firstChild.getAttribute("href") === "#";
        })) {
            addHandle("type|href|height|width", function(elem, name, isXML) {
                if (!isXML) {
                    return elem.getAttribute(name, name.toLowerCase() === "type" ? 1 : 2);
                }
            });
        }
        // Support: IE<9
        // Use defaultValue in place of getAttribute("value")
        if (!support.attributes || !assert(function(div) {
            div.innerHTML = "<input/>";
            div.firstChild.setAttribute("value", "");
            return div.firstChild.getAttribute("value") === "";
        })) {
            addHandle("value", function(elem, name, isXML) {
                if (!isXML && elem.nodeName.toLowerCase() === "input") {
                    return elem.defaultValue;
                }
            });
        }
        // Support: IE<9
        // Use getAttributeNode to fetch booleans when getAttribute lies
        if (!assert(function(div) {
            return div.getAttribute("disabled") == null;
        })) {
            addHandle(booleans, function(elem, name, isXML) {
                var val;
                if (!isXML) {
                    return elem[name] === true ? name.toLowerCase() : (val = elem.getAttributeNode(name)) && val.specified ? val.value : null;
                }
            });
        }
        return Sizzle;
    }(window);
    jQuery.find = Sizzle;
    jQuery.expr = Sizzle.selectors;
    jQuery.expr[":"] = jQuery.expr.pseudos;
    jQuery.unique = Sizzle.uniqueSort;
    jQuery.text = Sizzle.getText;
    jQuery.isXMLDoc = Sizzle.isXML;
    jQuery.contains = Sizzle.contains;
    var rneedsContext = jQuery.expr.match.needsContext;
    var rsingleTag = /^<(\w+)\s*\/?>(?:<\/\1>|)$/;
    var risSimple = /^.[^:#\[\.,]*$/;
    // Implement the identical functionality for filter and not
    function winnow(elements, qualifier, not) {
        if (jQuery.isFunction(qualifier)) {
            return jQuery.grep(elements, function(elem, i) {
                /* jshint -W018 */
                return !!qualifier.call(elem, i, elem) !== not;
            });
        }
        if (qualifier.nodeType) {
            return jQuery.grep(elements, function(elem) {
                return elem === qualifier !== not;
            });
        }
        if (typeof qualifier === "string") {
            if (risSimple.test(qualifier)) {
                return jQuery.filter(qualifier, elements, not);
            }
            qualifier = jQuery.filter(qualifier, elements);
        }
        return jQuery.grep(elements, function(elem) {
            return indexOf.call(qualifier, elem) >= 0 !== not;
        });
    }
    jQuery.filter = function(expr, elems, not) {
        var elem = elems[0];
        if (not) {
            expr = ":not(" + expr + ")";
        }
        return elems.length === 1 && elem.nodeType === 1 ? jQuery.find.matchesSelector(elem, expr) ? [ elem ] : [] : jQuery.find.matches(expr, jQuery.grep(elems, function(elem) {
            return elem.nodeType === 1;
        }));
    };
    jQuery.fn.extend({
        "find": function(selector) {
            var i, len = this.length, ret = [], self = this;
            if (typeof selector !== "string") {
                return this.pushStack(jQuery(selector).filter(function() {
                    for (i = 0; i < len; i++) {
                        if (jQuery.contains(self[i], this)) {
                            return true;
                        }
                    }
                }));
            }
            for (i = 0; i < len; i++) {
                jQuery.find(selector, self[i], ret);
            }
            // Needed because $( selector, context ) becomes $( context ).find( selector )
            ret = this.pushStack(len > 1 ? jQuery.unique(ret) : ret);
            ret.selector = this.selector ? this.selector + " " + selector : selector;
            return ret;
        },
        "filter": function(selector) {
            return this.pushStack(winnow(this, selector || [], false));
        },
        "not": function(selector) {
            return this.pushStack(winnow(this, selector || [], true));
        },
        "is": function(selector) {
            // If this is a positional/relative selector, check membership in the returned set
            // so $("p:first").is("p:last") won't return true for a doc with two "p".
            return !!winnow(this, typeof selector === "string" && rneedsContext.test(selector) ? jQuery(selector) : selector || [], false).length;
        }
    });
    // Initialize a jQuery object
    // A central reference to the root jQuery(document)
    var rootjQuery, // A simple way to check for HTML strings
    // Prioritize #id over <tag> to avoid XSS via location.hash (#9521)
    // Strict HTML recognition (#11290: must start with <)
    rquickExpr = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]*))$/, init = jQuery.fn.init = function(selector, context) {
        var match, elem;
        // HANDLE: $(""), $(null), $(undefined), $(false)
        if (!selector) {
            return this;
        }
        // Handle HTML strings
        if (typeof selector === "string") {
            if (selector[0] === "<" && selector[selector.length - 1] === ">" && selector.length >= 3) {
                // Assume that strings that start and end with <> are HTML and skip the regex check
                match = [ null, selector, null ];
            } else {
                match = rquickExpr.exec(selector);
            }
            // Match html or make sure no context is specified for #id
            if (match && (match[1] || !context)) {
                // HANDLE: $(html) -> $(array)
                if (match[1]) {
                    context = context instanceof jQuery ? context[0] : context;
                    // scripts is true for back-compat
                    // Intentionally let the error be thrown if parseHTML is not present
                    jQuery.merge(this, jQuery.parseHTML(match[1], context && context.nodeType ? context.ownerDocument || context : document, true));
                    // HANDLE: $(html, props)
                    if (rsingleTag.test(match[1]) && jQuery.isPlainObject(context)) {
                        for (match in context) {
                            // Properties of context are called as methods if possible
                            if (jQuery.isFunction(this[match])) {
                                this[match](context[match]);
                            } else {
                                this.attr(match, context[match]);
                            }
                        }
                    }
                    return this;
                } else {
                    elem = document.getElementById(match[2]);
                    // Check parentNode to catch when Blackberry 4.6 returns
                    // nodes that are no longer in the document #6963
                    if (elem && elem.parentNode) {
                        // Inject the element directly into the jQuery object
                        this.length = 1;
                        this[0] = elem;
                    }
                    this.context = document;
                    this.selector = selector;
                    return this;
                }
            } else if (!context || context.jquery) {
                return (context || rootjQuery).find(selector);
            } else {
                return this.constructor(context).find(selector);
            }
        } else if (selector.nodeType) {
            this.context = this[0] = selector;
            this.length = 1;
            return this;
        } else if (jQuery.isFunction(selector)) {
            // Execute immediately if ready is not present
            return typeof rootjQuery.ready !== "undefined" ? rootjQuery.ready(selector) : selector(jQuery);
        }
        if (selector.selector !== undefined) {
            this.selector = selector.selector;
            this.context = selector.context;
        }
        return jQuery.makeArray(selector, this);
    };
    // Give the init function the jQuery prototype for later instantiation
    init.prototype = jQuery.fn;
    // Initialize central reference
    rootjQuery = jQuery(document);
    var rparentsprev = /^(?:parents|prev(?:Until|All))/, // methods guaranteed to produce a unique set when starting from a unique set
    guaranteedUnique = {
        "children": true,
        "contents": true,
        "next": true,
        "prev": true
    };
    jQuery.extend({
        "dir": function(elem, dir, until) {
            var matched = [], truncate = until !== undefined;
            while ((elem = elem[dir]) && elem.nodeType !== 9) {
                if (elem.nodeType === 1) {
                    if (truncate && jQuery(elem).is(until)) {
                        break;
                    }
                    matched.push(elem);
                }
            }
            return matched;
        },
        "sibling": function(n, elem) {
            var matched = [];
            for (;n; n = n.nextSibling) {
                if (n.nodeType === 1 && n !== elem) {
                    matched.push(n);
                }
            }
            return matched;
        }
    });
    jQuery.fn.extend({
        "has": function(target) {
            var targets = jQuery(target, this), l = targets.length;
            return this.filter(function() {
                var i = 0;
                for (;i < l; i++) {
                    if (jQuery.contains(this, targets[i])) {
                        return true;
                    }
                }
            });
        },
        "closest": function(selectors, context) {
            var cur, i = 0, l = this.length, matched = [], pos = rneedsContext.test(selectors) || typeof selectors !== "string" ? jQuery(selectors, context || this.context) : 0;
            for (;i < l; i++) {
                for (cur = this[i]; cur && cur !== context; cur = cur.parentNode) {
                    // Always skip document fragments
                    if (cur.nodeType < 11 && (pos ? pos.index(cur) > -1 : // Don't pass non-elements to Sizzle
                    cur.nodeType === 1 && jQuery.find.matchesSelector(cur, selectors))) {
                        matched.push(cur);
                        break;
                    }
                }
            }
            return this.pushStack(matched.length > 1 ? jQuery.unique(matched) : matched);
        },
        // Determine the position of an element within
        // the matched set of elements
        "index": function(elem) {
            // No argument, return index in parent
            if (!elem) {
                return this[0] && this[0].parentNode ? this.first().prevAll().length : -1;
            }
            // index in selector
            if (typeof elem === "string") {
                return indexOf.call(jQuery(elem), this[0]);
            }
            // Locate the position of the desired element
            // If it receives a jQuery object, the first element is used
            return indexOf.call(this, elem.jquery ? elem[0] : elem);
        },
        "add": function(selector, context) {
            return this.pushStack(jQuery.unique(jQuery.merge(this.get(), jQuery(selector, context))));
        },
        "addBack": function(selector) {
            return this.add(selector == null ? this.prevObject : this.prevObject.filter(selector));
        }
    });
    function sibling(cur, dir) {
        while ((cur = cur[dir]) && cur.nodeType !== 1) {}
        return cur;
    }
    jQuery.each({
        "parent": function(elem) {
            var parent = elem.parentNode;
            return parent && parent.nodeType !== 11 ? parent : null;
        },
        "parents": function(elem) {
            return jQuery.dir(elem, "parentNode");
        },
        "parentsUntil": function(elem, i, until) {
            return jQuery.dir(elem, "parentNode", until);
        },
        "next": function(elem) {
            return sibling(elem, "nextSibling");
        },
        "prev": function(elem) {
            return sibling(elem, "previousSibling");
        },
        "nextAll": function(elem) {
            return jQuery.dir(elem, "nextSibling");
        },
        "prevAll": function(elem) {
            return jQuery.dir(elem, "previousSibling");
        },
        "nextUntil": function(elem, i, until) {
            return jQuery.dir(elem, "nextSibling", until);
        },
        "prevUntil": function(elem, i, until) {
            return jQuery.dir(elem, "previousSibling", until);
        },
        "siblings": function(elem) {
            return jQuery.sibling((elem.parentNode || {}).firstChild, elem);
        },
        "children": function(elem) {
            return jQuery.sibling(elem.firstChild);
        },
        "contents": function(elem) {
            return elem.contentDocument || jQuery.merge([], elem.childNodes);
        }
    }, function(name, fn) {
        jQuery.fn[name] = function(until, selector) {
            var matched = jQuery.map(this, fn, until);
            if (name.slice(-5) !== "Until") {
                selector = until;
            }
            if (selector && typeof selector === "string") {
                matched = jQuery.filter(selector, matched);
            }
            if (this.length > 1) {
                // Remove duplicates
                if (!guaranteedUnique[name]) {
                    jQuery.unique(matched);
                }
                // Reverse order for parents* and prev-derivatives
                if (rparentsprev.test(name)) {
                    matched.reverse();
                }
            }
            return this.pushStack(matched);
        };
    });
    var rnotwhite = /\S+/g;
    // String to Object options format cache
    var optionsCache = {};
    // Convert String-formatted options into Object-formatted ones and store in cache
    function createOptions(options) {
        var object = optionsCache[options] = {};
        jQuery.each(options.match(rnotwhite) || [], function(_, flag) {
            object[flag] = true;
        });
        return object;
    }
    /*
   * Create a callback list using the following parameters:
   *
   *	options: an optional list of space-separated options that will change how
   *			the callback list behaves or a more traditional option object
   *
   * By default a callback list will act like an event callback list and can be
   * "fired" multiple times.
   *
   * Possible options:
   *
   *	once:			will ensure the callback list can only be fired once (like a Deferred)
   *
   *	memory:			will keep track of previous values and will call any callback added
   *					after the list has been fired right away with the latest "memorized"
   *					values (like a Deferred)
   *
   *	unique:			will ensure a callback can only be added once (no duplicate in the list)
   *
   *	stopOnFalse:	interrupt callings when a callback returns false
   *
   */
    jQuery.Callbacks = function(options) {
        // Convert options from String-formatted to Object-formatted if needed
        // (we check in cache first)
        options = typeof options === "string" ? optionsCache[options] || createOptions(options) : jQuery.extend({}, options);
        var // Last fire value (for non-forgettable lists)
        memory, // Flag to know if list was already fired
        fired, // Flag to know if list is currently firing
        firing, // First callback to fire (used internally by add and fireWith)
        firingStart, // End of the loop when firing
        firingLength, // Index of currently firing callback (modified by remove if needed)
        firingIndex, // Actual callback list
        list = [], // Stack of fire calls for repeatable lists
        stack = !options.once && [], // Fire callbacks
        fire = function(data) {
            memory = options.memory && data;
            fired = true;
            firingIndex = firingStart || 0;
            firingStart = 0;
            firingLength = list.length;
            firing = true;
            for (;list && firingIndex < firingLength; firingIndex++) {
                if (list[firingIndex].apply(data[0], data[1]) === false && options.stopOnFalse) {
                    memory = false;
                    // To prevent further calls using add
                    break;
                }
            }
            firing = false;
            if (list) {
                if (stack) {
                    if (stack.length) {
                        fire(stack.shift());
                    }
                } else if (memory) {
                    list = [];
                } else {
                    self.disable();
                }
            }
        }, // Actual Callbacks object
        self = {
            // Add a callback or a collection of callbacks to the list
            "add": function() {
                if (list) {
                    // First, we save the current length
                    var start = list.length;
                    (function add(args) {
                        jQuery.each(args, function(_, arg) {
                            var type = jQuery.type(arg);
                            if (type === "function") {
                                if (!options.unique || !self.has(arg)) {
                                    list.push(arg);
                                }
                            } else if (arg && arg.length && type !== "string") {
                                // Inspect recursively
                                add(arg);
                            }
                        });
                    })(arguments);
                    // Do we need to add the callbacks to the
                    // current firing batch?
                    if (firing) {
                        firingLength = list.length;
                    } else if (memory) {
                        firingStart = start;
                        fire(memory);
                    }
                }
                return this;
            },
            // Remove a callback from the list
            "remove": function() {
                if (list) {
                    jQuery.each(arguments, function(_, arg) {
                        var index;
                        while ((index = jQuery.inArray(arg, list, index)) > -1) {
                            list.splice(index, 1);
                            // Handle firing indexes
                            if (firing) {
                                if (index <= firingLength) {
                                    firingLength--;
                                }
                                if (index <= firingIndex) {
                                    firingIndex--;
                                }
                            }
                        }
                    });
                }
                return this;
            },
            // Check if a given callback is in the list.
            // If no argument is given, return whether or not list has callbacks attached.
            "has": function(fn) {
                return fn ? jQuery.inArray(fn, list) > -1 : !!(list && list.length);
            },
            // Remove all callbacks from the list
            "empty": function() {
                list = [];
                firingLength = 0;
                return this;
            },
            // Have the list do nothing anymore
            "disable": function() {
                list = stack = memory = undefined;
                return this;
            },
            // Is it disabled?
            "disabled": function() {
                return !list;
            },
            // Lock the list in its current state
            "lock": function() {
                stack = undefined;
                if (!memory) {
                    self.disable();
                }
                return this;
            },
            // Is it locked?
            "locked": function() {
                return !stack;
            },
            // Call all callbacks with the given context and arguments
            "fireWith": function(context, args) {
                if (list && (!fired || stack)) {
                    args = args || [];
                    args = [ context, args.slice ? args.slice() : args ];
                    if (firing) {
                        stack.push(args);
                    } else {
                        fire(args);
                    }
                }
                return this;
            },
            // Call all the callbacks with the given arguments
            "fire": function() {
                self.fireWith(this, arguments);
                return this;
            },
            // To know if the callbacks have already been called at least once
            "fired": function() {
                return !!fired;
            }
        };
        return self;
    };
    jQuery.extend({
        "Deferred": function(func) {
            var tuples = [ // action, add listener, listener list, final state
            [ "resolve", "done", jQuery.Callbacks("once memory"), "resolved" ], [ "reject", "fail", jQuery.Callbacks("once memory"), "rejected" ], [ "notify", "progress", jQuery.Callbacks("memory") ] ], state = "pending", promise = {
                "state": function() {
                    return state;
                },
                "always": function() {
                    deferred.done(arguments).fail(arguments);
                    return this;
                },
                "then": function() {
                    var fns = arguments;
                    return jQuery.Deferred(function(newDefer) {
                        jQuery.each(tuples, function(i, tuple) {
                            var fn = jQuery.isFunction(fns[i]) && fns[i];
                            // deferred[ done | fail | progress ] for forwarding actions to newDefer
                            deferred[tuple[1]](function() {
                                var returned = fn && fn.apply(this, arguments);
                                if (returned && jQuery.isFunction(returned.promise)) {
                                    returned.promise().done(newDefer.resolve).fail(newDefer.reject).progress(newDefer.notify);
                                } else {
                                    newDefer[tuple[0] + "With"](this === promise ? newDefer.promise() : this, fn ? [ returned ] : arguments);
                                }
                            });
                        });
                        fns = null;
                    }).promise();
                },
                // Get a promise for this deferred
                // If obj is provided, the promise aspect is added to the object
                "promise": function(obj) {
                    return obj != null ? jQuery.extend(obj, promise) : promise;
                }
            }, deferred = {};
            // Keep pipe for back-compat
            promise.pipe = promise.then;
            // Add list-specific methods
            jQuery.each(tuples, function(i, tuple) {
                var list = tuple[2], stateString = tuple[3];
                // promise[ done | fail | progress ] = list.add
                promise[tuple[1]] = list.add;
                // Handle state
                if (stateString) {
                    list.add(function() {
                        // state = [ resolved | rejected ]
                        state = stateString;
                    }, tuples[i ^ 1][2].disable, tuples[2][2].lock);
                }
                // deferred[ resolve | reject | notify ]
                deferred[tuple[0]] = function() {
                    deferred[tuple[0] + "With"](this === deferred ? promise : this, arguments);
                    return this;
                };
                deferred[tuple[0] + "With"] = list.fireWith;
            });
            // Make the deferred a promise
            promise.promise(deferred);
            // Call given func if any
            if (func) {
                func.call(deferred, deferred);
            }
            // All done!
            return deferred;
        },
        // Deferred helper
        "when": function(subordinate) {
            var i = 0, resolveValues = slice.call(arguments), length = resolveValues.length, // the count of uncompleted subordinates
            remaining = length !== 1 || subordinate && jQuery.isFunction(subordinate.promise) ? length : 0, // the master Deferred. If resolveValues consist of only a single Deferred, just use that.
            deferred = remaining === 1 ? subordinate : jQuery.Deferred(), // Update function for both resolve and progress values
            updateFunc = function(i, contexts, values) {
                return function(value) {
                    contexts[i] = this;
                    values[i] = arguments.length > 1 ? slice.call(arguments) : value;
                    if (values === progressValues) {
                        deferred.notifyWith(contexts, values);
                    } else if (!--remaining) {
                        deferred.resolveWith(contexts, values);
                    }
                };
            }, progressValues, progressContexts, resolveContexts;
            // add listeners to Deferred subordinates; treat others as resolved
            if (length > 1) {
                progressValues = new Array(length);
                progressContexts = new Array(length);
                resolveContexts = new Array(length);
                for (;i < length; i++) {
                    if (resolveValues[i] && jQuery.isFunction(resolveValues[i].promise)) {
                        resolveValues[i].promise().done(updateFunc(i, resolveContexts, resolveValues)).fail(deferred.reject).progress(updateFunc(i, progressContexts, progressValues));
                    } else {
                        --remaining;
                    }
                }
            }
            // if we're not waiting on anything, resolve the master
            if (!remaining) {
                deferred.resolveWith(resolveContexts, resolveValues);
            }
            return deferred.promise();
        }
    });
    // The deferred used on DOM ready
    var readyList;
    jQuery.fn.ready = function(fn) {
        // Add the callback
        jQuery.ready.promise().done(fn);
        return this;
    };
    jQuery.extend({
        // Is the DOM ready to be used? Set to true once it occurs.
        "isReady": false,
        // A counter to track how many items to wait for before
        // the ready event fires. See #6781
        "readyWait": 1,
        // Hold (or release) the ready event
        "holdReady": function(hold) {
            if (hold) {
                jQuery.readyWait++;
            } else {
                jQuery.ready(true);
            }
        },
        // Handle when the DOM is ready
        "ready": function(wait) {
            // Abort if there are pending holds or we're already ready
            if (wait === true ? --jQuery.readyWait : jQuery.isReady) {
                return;
            }
            // Remember that the DOM is ready
            jQuery.isReady = true;
            // If a normal DOM Ready event fired, decrement, and wait if need be
            if (wait !== true && --jQuery.readyWait > 0) {
                return;
            }
            // If there are functions bound, to execute
            readyList.resolveWith(document, [ jQuery ]);
            // Trigger any bound ready events
            if (jQuery.fn.trigger) {
                jQuery(document).trigger("ready").off("ready");
            }
        }
    });
    /**
   * The ready event handler and self cleanup method
   */
    function completed() {
        document.removeEventListener("DOMContentLoaded", completed, false);
        window.removeEventListener("load", completed, false);
        jQuery.ready();
    }
    jQuery.ready.promise = function(obj) {
        if (!readyList) {
            readyList = jQuery.Deferred();
            // Catch cases where $(document).ready() is called after the browser event has already occurred.
            // we once tried to use readyState "interactive" here, but it caused issues like the one
            // discovered by ChrisS here: http://bugs.jquery.com/ticket/12282#comment:15
            if (document.readyState === "complete") {
                // Handle it asynchronously to allow scripts the opportunity to delay ready
                setTimeout(jQuery.ready);
            } else {
                // Use the handy event callback
                document.addEventListener("DOMContentLoaded", completed, false);
                // A fallback to window.onload, that will always work
                window.addEventListener("load", completed, false);
            }
        }
        return readyList.promise(obj);
    };
    // Kick off the DOM ready check even if the user does not
    jQuery.ready.promise();
    // Multifunctional method to get and set values of a collection
    // The value/s can optionally be executed if it's a function
    var access = jQuery.access = function(elems, fn, key, value, chainable, emptyGet, raw) {
        var i = 0, len = elems.length, bulk = key == null;
        // Sets many values
        if (jQuery.type(key) === "object") {
            chainable = true;
            for (i in key) {
                jQuery.access(elems, fn, i, key[i], true, emptyGet, raw);
            }
        } else if (value !== undefined) {
            chainable = true;
            if (!jQuery.isFunction(value)) {
                raw = true;
            }
            if (bulk) {
                // Bulk operations run against the entire set
                if (raw) {
                    fn.call(elems, value);
                    fn = null;
                } else {
                    bulk = fn;
                    fn = function(elem, key, value) {
                        return bulk.call(jQuery(elem), value);
                    };
                }
            }
            if (fn) {
                for (;i < len; i++) {
                    fn(elems[i], key, raw ? value : value.call(elems[i], i, fn(elems[i], key)));
                }
            }
        }
        // Gets
        return chainable ? elems : bulk ? fn.call(elems) : len ? fn(elems[0], key) : emptyGet;
    };
    /**
   * Determines whether an object can have data
   */
    jQuery.acceptData = function(owner) {
        // Accepts only:
        //  - Node
        //    - Node.ELEMENT_NODE
        //    - Node.DOCUMENT_NODE
        //  - Object
        //    - Any
        /* jshint -W018 */
        return owner.nodeType === 1 || owner.nodeType === 9 || !+owner.nodeType;
    };
    function Data() {
        // Support: Android < 4,
        // Old WebKit does not have Object.preventExtensions/freeze method,
        // return new empty object instead with no [[set]] accessor
        Object.defineProperty(this.cache = {}, 0, {
            "get": function() {
                return {};
            }
        });
        this.expando = jQuery.expando + Math.random();
    }
    Data.uid = 1;
    Data.accepts = jQuery.acceptData;
    Data.prototype = {
        "key": function(owner) {
            // We can accept data for non-element nodes in modern browsers,
            // but we should not, see #8335.
            // Always return the key for a frozen object.
            if (!Data.accepts(owner)) {
                return 0;
            }
            var descriptor = {}, // Check if the owner object already has a cache key
            unlock = owner[this.expando];
            // If not, create one
            if (!unlock) {
                unlock = Data.uid++;
                // Secure it in a non-enumerable, non-writable property
                try {
                    descriptor[this.expando] = {
                        "value": unlock
                    };
                    Object.defineProperties(owner, descriptor);
                } catch (e) {
                    descriptor[this.expando] = unlock;
                    jQuery.extend(owner, descriptor);
                }
            }
            // Ensure the cache object
            if (!this.cache[unlock]) {
                this.cache[unlock] = {};
            }
            return unlock;
        },
        "set": function(owner, data, value) {
            var prop, // There may be an unlock assigned to this node,
            // if there is no entry for this "owner", create one inline
            // and set the unlock as though an owner entry had always existed
            unlock = this.key(owner), cache = this.cache[unlock];
            // Handle: [ owner, key, value ] args
            if (typeof data === "string") {
                cache[data] = value;
            } else {
                // Fresh assignments by object are shallow copied
                if (jQuery.isEmptyObject(cache)) {
                    jQuery.extend(this.cache[unlock], data);
                } else {
                    for (prop in data) {
                        cache[prop] = data[prop];
                    }
                }
            }
            return cache;
        },
        "get": function(owner, key) {
            // Either a valid cache is found, or will be created.
            // New caches will be created and the unlock returned,
            // allowing direct access to the newly created
            // empty data object. A valid owner object must be provided.
            var cache = this.cache[this.key(owner)];
            return key === undefined ? cache : cache[key];
        },
        "access": function(owner, key, value) {
            var stored;
            // In cases where either:
            //
            //   1. No key was specified
            //   2. A string key was specified, but no value provided
            //
            // Take the "read" path and allow the get method to determine
            // which value to return, respectively either:
            //
            //   1. The entire cache object
            //   2. The data stored at the key
            //
            if (key === undefined || key && typeof key === "string" && value === undefined) {
                stored = this.get(owner, key);
                return stored !== undefined ? stored : this.get(owner, jQuery.camelCase(key));
            }
            // [*]When the key is not a string, or both a key and value
            // are specified, set or extend (existing objects) with either:
            //
            //   1. An object of properties
            //   2. A key and value
            //
            this.set(owner, key, value);
            // Since the "set" path can have two possible entry points
            // return the expected data based on which path was taken[*]
            return value !== undefined ? value : key;
        },
        "remove": function(owner, key) {
            var i, name, camel, unlock = this.key(owner), cache = this.cache[unlock];
            if (key === undefined) {
                this.cache[unlock] = {};
            } else {
                // Support array or space separated string of keys
                if (jQuery.isArray(key)) {
                    // If "name" is an array of keys...
                    // When data is initially created, via ("key", "val") signature,
                    // keys will be converted to camelCase.
                    // Since there is no way to tell _how_ a key was added, remove
                    // both plain key and camelCase key. #12786
                    // This will only penalize the array argument path.
                    name = key.concat(key.map(jQuery.camelCase));
                } else {
                    camel = jQuery.camelCase(key);
                    // Try the string as a key before any manipulation
                    if (key in cache) {
                        name = [ key, camel ];
                    } else {
                        // If a key with the spaces exists, use it.
                        // Otherwise, create an array by matching non-whitespace
                        name = camel;
                        name = name in cache ? [ name ] : name.match(rnotwhite) || [];
                    }
                }
                i = name.length;
                while (i--) {
                    delete cache[name[i]];
                }
            }
        },
        "hasData": function(owner) {
            return !jQuery.isEmptyObject(this.cache[owner[this.expando]] || {});
        },
        "discard": function(owner) {
            if (owner[this.expando]) {
                delete this.cache[owner[this.expando]];
            }
        }
    };
    var data_priv = new Data();
    var data_user = new Data();
    /*
   Implementation Summary

   1. Enforce API surface and semantic compatibility with 1.9.x branch
   2. Improve the module's maintainability by reducing the storage
   paths to a single mechanism.
   3. Use the same single mechanism to support "private" and "user" data.
   4. _Never_ expose "private" data to user code (TODO: Drop _data, _removeData)
   5. Avoid exposing implementation details on user objects (eg. expando properties)
   6. Provide a clear path for implementation upgrade to WeakMap in 2014
   */
    var rbrace = /^(?:\{[\w\W]*\}|\[[\w\W]*\])$/, rmultiDash = /([A-Z])/g;
    function dataAttr(elem, key, data) {
        var name;
        // If nothing was found internally, try to fetch any
        // data from the HTML5 data-* attribute
        if (data === undefined && elem.nodeType === 1) {
            name = "data-" + key.replace(rmultiDash, "-$1").toLowerCase();
            data = elem.getAttribute(name);
            if (typeof data === "string") {
                try {
                    data = data === "true" ? true : data === "false" ? false : data === "null" ? null : // Only convert to a number if it doesn't change the string
                    +data + "" === data ? +data : rbrace.test(data) ? jQuery.parseJSON(data) : data;
                } catch (e) {}
                // Make sure we set the data so it isn't changed later
                data_user.set(elem, key, data);
            } else {
                data = undefined;
            }
        }
        return data;
    }
    jQuery.extend({
        "hasData": function(elem) {
            return data_user.hasData(elem) || data_priv.hasData(elem);
        },
        "data": function(elem, name, data) {
            return data_user.access(elem, name, data);
        },
        "removeData": function(elem, name) {
            data_user.remove(elem, name);
        },
        // TODO: Now that all calls to _data and _removeData have been replaced
        // with direct calls to data_priv methods, these can be deprecated.
        "_data": function(elem, name, data) {
            return data_priv.access(elem, name, data);
        },
        "_removeData": function(elem, name) {
            data_priv.remove(elem, name);
        }
    });
    jQuery.fn.extend({
        "data": function(key, value) {
            var i, name, data, elem = this[0], attrs = elem && elem.attributes;
            // Gets all values
            if (key === undefined) {
                if (this.length) {
                    data = data_user.get(elem);
                    if (elem.nodeType === 1 && !data_priv.get(elem, "hasDataAttrs")) {
                        i = attrs.length;
                        while (i--) {
                            name = attrs[i].name;
                            if (name.indexOf("data-") === 0) {
                                name = jQuery.camelCase(name.slice(5));
                                dataAttr(elem, name, data[name]);
                            }
                        }
                        data_priv.set(elem, "hasDataAttrs", true);
                    }
                }
                return data;
            }
            // Sets multiple values
            if (typeof key === "object") {
                return this.each(function() {
                    data_user.set(this, key);
                });
            }
            return access(this, function(value) {
                var data, camelKey = jQuery.camelCase(key);
                // The calling jQuery object (element matches) is not empty
                // (and therefore has an element appears at this[ 0 ]) and the
                // `value` parameter was not undefined. An empty jQuery object
                // will result in `undefined` for elem = this[ 0 ] which will
                // throw an exception if an attempt to read a data cache is made.
                if (elem && value === undefined) {
                    // Attempt to get data from the cache
                    // with the key as-is
                    data = data_user.get(elem, key);
                    if (data !== undefined) {
                        return data;
                    }
                    // Attempt to get data from the cache
                    // with the key camelized
                    data = data_user.get(elem, camelKey);
                    if (data !== undefined) {
                        return data;
                    }
                    // Attempt to "discover" the data in
                    // HTML5 custom data-* attrs
                    data = dataAttr(elem, camelKey, undefined);
                    if (data !== undefined) {
                        return data;
                    }
                    // We tried really hard, but the data doesn't exist.
                    return;
                }
                // Set the data...
                this.each(function() {
                    // First, attempt to store a copy or reference of any
                    // data that might've been store with a camelCased key.
                    var data = data_user.get(this, camelKey);
                    // For HTML5 data-* attribute interop, we have to
                    // store property names with dashes in a camelCase form.
                    // This might not apply to all properties...*
                    data_user.set(this, camelKey, value);
                    // *... In the case of properties that might _actually_
                    // have dashes, we need to also store a copy of that
                    // unchanged property.
                    if (key.indexOf("-") !== -1 && data !== undefined) {
                        data_user.set(this, key, value);
                    }
                });
            }, null, value, arguments.length > 1, null, true);
        },
        "removeData": function(key) {
            return this.each(function() {
                data_user.remove(this, key);
            });
        }
    });
    jQuery.extend({
        "queue": function(elem, type, data) {
            var queue;
            if (elem) {
                type = (type || "fx") + "queue";
                queue = data_priv.get(elem, type);
                // Speed up dequeue by getting out quickly if this is just a lookup
                if (data) {
                    if (!queue || jQuery.isArray(data)) {
                        queue = data_priv.access(elem, type, jQuery.makeArray(data));
                    } else {
                        queue.push(data);
                    }
                }
                return queue || [];
            }
        },
        "dequeue": function(elem, type) {
            type = type || "fx";
            var queue = jQuery.queue(elem, type), startLength = queue.length, fn = queue.shift(), hooks = jQuery._queueHooks(elem, type), next = function() {
                jQuery.dequeue(elem, type);
            };
            // If the fx queue is dequeued, always remove the progress sentinel
            if (fn === "inprogress") {
                fn = queue.shift();
                startLength--;
            }
            if (fn) {
                // Add a progress sentinel to prevent the fx queue from being
                // automatically dequeued
                if (type === "fx") {
                    queue.unshift("inprogress");
                }
                // clear up the last queue stop function
                delete hooks.stop;
                fn.call(elem, next, hooks);
            }
            if (!startLength && hooks) {
                hooks.empty.fire();
            }
        },
        // not intended for public consumption - generates a queueHooks object, or returns the current one
        "_queueHooks": function(elem, type) {
            var key = type + "queueHooks";
            return data_priv.get(elem, key) || data_priv.access(elem, key, {
                "empty": jQuery.Callbacks("once memory").add(function() {
                    data_priv.remove(elem, [ type + "queue", key ]);
                })
            });
        }
    });
    jQuery.fn.extend({
        "queue": function(type, data) {
            var setter = 2;
            if (typeof type !== "string") {
                data = type;
                type = "fx";
                setter--;
            }
            if (arguments.length < setter) {
                return jQuery.queue(this[0], type);
            }
            return data === undefined ? this : this.each(function() {
                var queue = jQuery.queue(this, type, data);
                // ensure a hooks for this queue
                jQuery._queueHooks(this, type);
                if (type === "fx" && queue[0] !== "inprogress") {
                    jQuery.dequeue(this, type);
                }
            });
        },
        "dequeue": function(type) {
            return this.each(function() {
                jQuery.dequeue(this, type);
            });
        },
        "clearQueue": function(type) {
            return this.queue(type || "fx", []);
        },
        // Get a promise resolved when queues of a certain type
        // are emptied (fx is the type by default)
        "promise": function(type, obj) {
            var tmp, count = 1, defer = jQuery.Deferred(), elements = this, i = this.length, resolve = function() {
                if (!--count) {
                    defer.resolveWith(elements, [ elements ]);
                }
            };
            if (typeof type !== "string") {
                obj = type;
                type = undefined;
            }
            type = type || "fx";
            while (i--) {
                tmp = data_priv.get(elements[i], type + "queueHooks");
                if (tmp && tmp.empty) {
                    count++;
                    tmp.empty.add(resolve);
                }
            }
            resolve();
            return defer.promise(obj);
        }
    });
    var pnum = /[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source;
    var cssExpand = [ "Top", "Right", "Bottom", "Left" ];
    var isHidden = function(elem, el) {
        // isHidden might be called from jQuery#filter function;
        // in that case, element will be second argument
        elem = el || elem;
        return jQuery.css(elem, "display") === "none" || !jQuery.contains(elem.ownerDocument, elem);
    };
    var rcheckableType = /^(?:checkbox|radio)$/i;
    (function() {
        var fragment = document.createDocumentFragment(), div = fragment.appendChild(document.createElement("div"));
        // #11217 - WebKit loses check when the name is after the checked attribute
        div.innerHTML = "<input type='radio' checked='checked' name='t'/>";
        // Support: Safari 5.1, iOS 5.1, Android 4.x, Android 2.3
        // old WebKit doesn't clone checked state correctly in fragments
        support.checkClone = div.cloneNode(true).cloneNode(true).lastChild.checked;
        // Make sure textarea (and checkbox) defaultValue is properly cloned
        // Support: IE9-IE11+
        div.innerHTML = "<textarea>x</textarea>";
        support.noCloneChecked = !!div.cloneNode(true).lastChild.defaultValue;
    })();
    var strundefined = typeof undefined;
    support.focusinBubbles = "onfocusin" in window;
    var rkeyEvent = /^key/, rmouseEvent = /^(?:mouse|contextmenu)|click/, rfocusMorph = /^(?:focusinfocus|focusoutblur)$/, rtypenamespace = /^([^.]*)(?:\.(.+)|)$/;
    function returnTrue() {
        return true;
    }
    function returnFalse() {
        return false;
    }
    function safeActiveElement() {
        try {
            return document.activeElement;
        } catch (err) {}
    }
    /*
   * Helper functions for managing events -- not part of the public interface.
   * Props to Dean Edwards' addEvent library for many of the ideas.
   */
    jQuery.event = {
        "global": {},
        "add": function(elem, types, handler, data, selector) {
            var handleObjIn, eventHandle, tmp, events, t, handleObj, special, handlers, type, namespaces, origType, elemData = data_priv.get(elem);
            // Don't attach events to noData or text/comment nodes (but allow plain objects)
            if (!elemData) {
                return;
            }
            // Caller can pass in an object of custom data in lieu of the handler
            if (handler.handler) {
                handleObjIn = handler;
                handler = handleObjIn.handler;
                selector = handleObjIn.selector;
            }
            // Make sure that the handler has a unique ID, used to find/remove it later
            if (!handler.guid) {
                handler.guid = jQuery.guid++;
            }
            // Init the element's event structure and main handler, if this is the first
            if (!(events = elemData.events)) {
                events = elemData.events = {};
            }
            if (!(eventHandle = elemData.handle)) {
                eventHandle = elemData.handle = function(e) {
                    // Discard the second event of a jQuery.event.trigger() and
                    // when an event is called after a page has unloaded
                    return typeof jQuery !== strundefined && jQuery.event.triggered !== e.type ? jQuery.event.dispatch.apply(elem, arguments) : undefined;
                };
            }
            // Handle multiple events separated by a space
            types = (types || "").match(rnotwhite) || [ "" ];
            t = types.length;
            while (t--) {
                tmp = rtypenamespace.exec(types[t]) || [];
                type = origType = tmp[1];
                namespaces = (tmp[2] || "").split(".").sort();
                // There *must* be a type, no attaching namespace-only handlers
                if (!type) {
                    continue;
                }
                // If event changes its type, use the special event handlers for the changed type
                special = jQuery.event.special[type] || {};
                // If selector defined, determine special event api type, otherwise given type
                type = (selector ? special.delegateType : special.bindType) || type;
                // Update special based on newly reset type
                special = jQuery.event.special[type] || {};
                // handleObj is passed to all event handlers
                handleObj = jQuery.extend({
                    "type": type,
                    "origType": origType,
                    "data": data,
                    "handler": handler,
                    "guid": handler.guid,
                    "selector": selector,
                    "needsContext": selector && jQuery.expr.match.needsContext.test(selector),
                    "namespace": namespaces.join(".")
                }, handleObjIn);
                // Init the event handler queue if we're the first
                if (!(handlers = events[type])) {
                    handlers = events[type] = [];
                    handlers.delegateCount = 0;
                    // Only use addEventListener if the special events handler returns false
                    if (!special.setup || special.setup.call(elem, data, namespaces, eventHandle) === false) {
                        if (elem.addEventListener) {
                            elem.addEventListener(type, eventHandle, false);
                        }
                    }
                }
                if (special.add) {
                    special.add.call(elem, handleObj);
                    if (!handleObj.handler.guid) {
                        handleObj.handler.guid = handler.guid;
                    }
                }
                // Add to the element's handler list, delegates in front
                if (selector) {
                    handlers.splice(handlers.delegateCount++, 0, handleObj);
                } else {
                    handlers.push(handleObj);
                }
                // Keep track of which events have ever been used, for event optimization
                jQuery.event.global[type] = true;
            }
        },
        // Detach an event or set of events from an element
        "remove": function(elem, types, handler, selector, mappedTypes) {
            var j, origCount, tmp, events, t, handleObj, special, handlers, type, namespaces, origType, elemData = data_priv.hasData(elem) && data_priv.get(elem);
            if (!elemData || !(events = elemData.events)) {
                return;
            }
            // Once for each type.namespace in types; type may be omitted
            types = (types || "").match(rnotwhite) || [ "" ];
            t = types.length;
            while (t--) {
                tmp = rtypenamespace.exec(types[t]) || [];
                type = origType = tmp[1];
                namespaces = (tmp[2] || "").split(".").sort();
                // Unbind all events (on this namespace, if provided) for the element
                if (!type) {
                    for (type in events) {
                        jQuery.event.remove(elem, type + types[t], handler, selector, true);
                    }
                    continue;
                }
                special = jQuery.event.special[type] || {};
                type = (selector ? special.delegateType : special.bindType) || type;
                handlers = events[type] || [];
                tmp = tmp[2] && new RegExp("(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)");
                // Remove matching events
                origCount = j = handlers.length;
                while (j--) {
                    handleObj = handlers[j];
                    if ((mappedTypes || origType === handleObj.origType) && (!handler || handler.guid === handleObj.guid) && (!tmp || tmp.test(handleObj.namespace)) && (!selector || selector === handleObj.selector || selector === "**" && handleObj.selector)) {
                        handlers.splice(j, 1);
                        if (handleObj.selector) {
                            handlers.delegateCount--;
                        }
                        if (special.remove) {
                            special.remove.call(elem, handleObj);
                        }
                    }
                }
                // Remove generic event handler if we removed something and no more handlers exist
                // (avoids potential for endless recursion during removal of special event handlers)
                if (origCount && !handlers.length) {
                    if (!special.teardown || special.teardown.call(elem, namespaces, elemData.handle) === false) {
                        jQuery.removeEvent(elem, type, elemData.handle);
                    }
                    delete events[type];
                }
            }
            // Remove the expando if it's no longer used
            if (jQuery.isEmptyObject(events)) {
                delete elemData.handle;
                data_priv.remove(elem, "events");
            }
        },
        "trigger": function(event, data, elem, onlyHandlers) {
            var i, cur, tmp, bubbleType, ontype, handle, special, eventPath = [ elem || document ], type = hasOwn.call(event, "type") ? event.type : event, namespaces = hasOwn.call(event, "namespace") ? event.namespace.split(".") : [];
            cur = tmp = elem = elem || document;
            // Don't do events on text and comment nodes
            if (elem.nodeType === 3 || elem.nodeType === 8) {
                return;
            }
            // focus/blur morphs to focusin/out; ensure we're not firing them right now
            if (rfocusMorph.test(type + jQuery.event.triggered)) {
                return;
            }
            if (type.indexOf(".") >= 0) {
                // Namespaced trigger; create a regexp to match event type in handle()
                namespaces = type.split(".");
                type = namespaces.shift();
                namespaces.sort();
            }
            ontype = type.indexOf(":") < 0 && "on" + type;
            // Caller can pass in a jQuery.Event object, Object, or just an event type string
            event = event[jQuery.expando] ? event : new jQuery.Event(type, typeof event === "object" && event);
            // Trigger bitmask: & 1 for native handlers; & 2 for jQuery (always true)
            event.isTrigger = onlyHandlers ? 2 : 3;
            event.namespace = namespaces.join(".");
            event.namespace_re = event.namespace ? new RegExp("(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)") : null;
            // Clean up the event in case it is being reused
            event.result = undefined;
            if (!event.target) {
                event.target = elem;
            }
            // Clone any incoming data and prepend the event, creating the handler arg list
            data = data == null ? [ event ] : jQuery.makeArray(data, [ event ]);
            // Allow special events to draw outside the lines
            special = jQuery.event.special[type] || {};
            if (!onlyHandlers && special.trigger && special.trigger.apply(elem, data) === false) {
                return;
            }
            // Determine event propagation path in advance, per W3C events spec (#9951)
            // Bubble up to document, then to window; watch for a global ownerDocument var (#9724)
            if (!onlyHandlers && !special.noBubble && !jQuery.isWindow(elem)) {
                bubbleType = special.delegateType || type;
                if (!rfocusMorph.test(bubbleType + type)) {
                    cur = cur.parentNode;
                }
                for (;cur; cur = cur.parentNode) {
                    eventPath.push(cur);
                    tmp = cur;
                }
                // Only add window if we got to document (e.g., not plain obj or detached DOM)
                if (tmp === (elem.ownerDocument || document)) {
                    eventPath.push(tmp.defaultView || tmp.parentWindow || window);
                }
            }
            // Fire handlers on the event path
            i = 0;
            while ((cur = eventPath[i++]) && !event.isPropagationStopped()) {
                event.type = i > 1 ? bubbleType : special.bindType || type;
                // jQuery handler
                handle = (data_priv.get(cur, "events") || {})[event.type] && data_priv.get(cur, "handle");
                if (handle) {
                    handle.apply(cur, data);
                }
                // Native handler
                handle = ontype && cur[ontype];
                if (handle && handle.apply && jQuery.acceptData(cur)) {
                    event.result = handle.apply(cur, data);
                    if (event.result === false) {
                        event.preventDefault();
                    }
                }
            }
            event.type = type;
            // If nobody prevented the default action, do it now
            if (!onlyHandlers && !event.isDefaultPrevented()) {
                if ((!special._default || special._default.apply(eventPath.pop(), data) === false) && jQuery.acceptData(elem)) {
                    // Call a native DOM method on the target with the same name name as the event.
                    // Don't do default actions on window, that's where global variables be (#6170)
                    if (ontype && jQuery.isFunction(elem[type]) && !jQuery.isWindow(elem)) {
                        // Don't re-trigger an onFOO event when we call its FOO() method
                        tmp = elem[ontype];
                        if (tmp) {
                            elem[ontype] = null;
                        }
                        // Prevent re-triggering of the same event, since we already bubbled it above
                        jQuery.event.triggered = type;
                        elem[type]();
                        jQuery.event.triggered = undefined;
                        if (tmp) {
                            elem[ontype] = tmp;
                        }
                    }
                }
            }
            return event.result;
        },
        "dispatch": function(event) {
            // Make a writable jQuery.Event from the native event object
            event = jQuery.event.fix(event);
            var i, j, ret, matched, handleObj, handlerQueue = [], args = slice.call(arguments), handlers = (data_priv.get(this, "events") || {})[event.type] || [], special = jQuery.event.special[event.type] || {};
            // Use the fix-ed jQuery.Event rather than the (read-only) native event
            args[0] = event;
            event.delegateTarget = this;
            // Call the preDispatch hook for the mapped type, and let it bail if desired
            if (special.preDispatch && special.preDispatch.call(this, event) === false) {
                return;
            }
            // Determine handlers
            handlerQueue = jQuery.event.handlers.call(this, event, handlers);
            // Run delegates first; they may want to stop propagation beneath us
            i = 0;
            while ((matched = handlerQueue[i++]) && !event.isPropagationStopped()) {
                event.currentTarget = matched.elem;
                j = 0;
                while ((handleObj = matched.handlers[j++]) && !event.isImmediatePropagationStopped()) {
                    // Triggered event must either 1) have no namespace, or
                    // 2) have namespace(s) a subset or equal to those in the bound event (both can have no namespace).
                    if (!event.namespace_re || event.namespace_re.test(handleObj.namespace)) {
                        event.handleObj = handleObj;
                        event.data = handleObj.data;
                        ret = ((jQuery.event.special[handleObj.origType] || {}).handle || handleObj.handler).apply(matched.elem, args);
                        if (ret !== undefined) {
                            if ((event.result = ret) === false) {
                                event.preventDefault();
                                event.stopPropagation();
                            }
                        }
                    }
                }
            }
            // Call the postDispatch hook for the mapped type
            if (special.postDispatch) {
                special.postDispatch.call(this, event);
            }
            return event.result;
        },
        "handlers": function(event, handlers) {
            var i, matches, sel, handleObj, handlerQueue = [], delegateCount = handlers.delegateCount, cur = event.target;
            // Find delegate handlers
            // Black-hole SVG <use> instance trees (#13180)
            // Avoid non-left-click bubbling in Firefox (#3861)
            if (delegateCount && cur.nodeType && (!event.button || event.type !== "click")) {
                for (;cur !== this; cur = cur.parentNode || this) {
                    // Don't process clicks on disabled elements (#6911, #8165, #11382, #11764)
                    if (cur.disabled !== true || event.type !== "click") {
                        matches = [];
                        for (i = 0; i < delegateCount; i++) {
                            handleObj = handlers[i];
                            // Don't conflict with Object.prototype properties (#13203)
                            sel = handleObj.selector + " ";
                            if (matches[sel] === undefined) {
                                matches[sel] = handleObj.needsContext ? jQuery(sel, this).index(cur) >= 0 : jQuery.find(sel, this, null, [ cur ]).length;
                            }
                            if (matches[sel]) {
                                matches.push(handleObj);
                            }
                        }
                        if (matches.length) {
                            handlerQueue.push({
                                "elem": cur,
                                "handlers": matches
                            });
                        }
                    }
                }
            }
            // Add the remaining (directly-bound) handlers
            if (delegateCount < handlers.length) {
                handlerQueue.push({
                    "elem": this,
                    "handlers": handlers.slice(delegateCount)
                });
            }
            return handlerQueue;
        },
        // Includes some event props shared by KeyEvent and MouseEvent
        "props": "altKey bubbles cancelable ctrlKey currentTarget eventPhase metaKey relatedTarget shiftKey target timeStamp view which".split(" "),
        "fixHooks": {},
        "keyHooks": {
            "props": "char charCode key keyCode".split(" "),
            "filter": function(event, original) {
                // Add which for key events
                if (event.which == null) {
                    event.which = original.charCode != null ? original.charCode : original.keyCode;
                }
                return event;
            }
        },
        "mouseHooks": {
            "props": "button buttons clientX clientY offsetX offsetY pageX pageY screenX screenY toElement".split(" "),
            "filter": function(event, original) {
                var eventDoc, doc, body, button = original.button;
                // Calculate pageX/Y if missing and clientX/Y available
                if (event.pageX == null && original.clientX != null) {
                    eventDoc = event.target.ownerDocument || document;
                    doc = eventDoc.documentElement;
                    body = eventDoc.body;
                    event.pageX = original.clientX + (doc && doc.scrollLeft || body && body.scrollLeft || 0) - (doc && doc.clientLeft || body && body.clientLeft || 0);
                    event.pageY = original.clientY + (doc && doc.scrollTop || body && body.scrollTop || 0) - (doc && doc.clientTop || body && body.clientTop || 0);
                }
                // Add which for click: 1 === left; 2 === middle; 3 === right
                // Note: button is not normalized, so don't use it
                if (!event.which && button !== undefined) {
                    event.which = button & 1 ? 1 : button & 2 ? 3 : button & 4 ? 2 : 0;
                }
                return event;
            }
        },
        "fix": function(event) {
            if (event[jQuery.expando]) {
                return event;
            }
            // Create a writable copy of the event object and normalize some properties
            var i, prop, copy, type = event.type, originalEvent = event, fixHook = this.fixHooks[type];
            if (!fixHook) {
                this.fixHooks[type] = fixHook = rmouseEvent.test(type) ? this.mouseHooks : rkeyEvent.test(type) ? this.keyHooks : {};
            }
            copy = fixHook.props ? this.props.concat(fixHook.props) : this.props;
            event = new jQuery.Event(originalEvent);
            i = copy.length;
            while (i--) {
                prop = copy[i];
                event[prop] = originalEvent[prop];
            }
            // Support: Cordova 2.5 (WebKit) (#13255)
            // All events should have a target; Cordova deviceready doesn't
            if (!event.target) {
                event.target = document;
            }
            // Support: Safari 6.0+, Chrome < 28
            // Target should not be a text node (#504, #13143)
            if (event.target.nodeType === 3) {
                event.target = event.target.parentNode;
            }
            return fixHook.filter ? fixHook.filter(event, originalEvent) : event;
        },
        "special": {
            "load": {
                // Prevent triggered image.load events from bubbling to window.load
                "noBubble": true
            },
            "focus": {
                // Fire native event if possible so blur/focus sequence is correct
                "trigger": function() {
                    if (this !== safeActiveElement() && this.focus) {
                        this.focus();
                        return false;
                    }
                },
                "delegateType": "focusin"
            },
            "blur": {
                "trigger": function() {
                    if (this === safeActiveElement() && this.blur) {
                        this.blur();
                        return false;
                    }
                },
                "delegateType": "focusout"
            },
            "click": {
                // For checkbox, fire native event so checked state will be right
                "trigger": function() {
                    if (this.type === "checkbox" && this.click && jQuery.nodeName(this, "input")) {
                        this.click();
                        return false;
                    }
                },
                // For cross-browser consistency, don't fire native .click() on links
                "_default": function(event) {
                    return jQuery.nodeName(event.target, "a");
                }
            },
            "beforeunload": {
                "postDispatch": function(event) {
                    // Support: Firefox 20+
                    // Firefox doesn't alert if the returnValue field is not set.
                    if (event.result !== undefined) {
                        event.originalEvent.returnValue = event.result;
                    }
                }
            }
        },
        "simulate": function(type, elem, event, bubble) {
            // Piggyback on a donor event to simulate a different one.
            // Fake originalEvent to avoid donor's stopPropagation, but if the
            // simulated event prevents default then we do the same on the donor.
            var e = jQuery.extend(new jQuery.Event(), event, {
                "type": type,
                "isSimulated": true,
                "originalEvent": {}
            });
            if (bubble) {
                jQuery.event.trigger(e, null, elem);
            } else {
                jQuery.event.dispatch.call(elem, e);
            }
            if (e.isDefaultPrevented()) {
                event.preventDefault();
            }
        }
    };
    jQuery.removeEvent = function(elem, type, handle) {
        if (elem.removeEventListener) {
            elem.removeEventListener(type, handle, false);
        }
    };
    jQuery.Event = function(src, props) {
        // Allow instantiation without the 'new' keyword
        if (!(this instanceof jQuery.Event)) {
            return new jQuery.Event(src, props);
        }
        // Event object
        if (src && src.type) {
            this.originalEvent = src;
            this.type = src.type;
            // Events bubbling up the document may have been marked as prevented
            // by a handler lower down the tree; reflect the correct value.
            this.isDefaultPrevented = src.defaultPrevented || // Support: Android < 4.0
            src.defaultPrevented === undefined && src.getPreventDefault && src.getPreventDefault() ? returnTrue : returnFalse;
        } else {
            this.type = src;
        }
        // Put explicitly provided properties onto the event object
        if (props) {
            jQuery.extend(this, props);
        }
        // Create a timestamp if incoming event doesn't have one
        this.timeStamp = src && src.timeStamp || jQuery.now();
        // Mark it as fixed
        this[jQuery.expando] = true;
    };
    // jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding
    // http://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html
    jQuery.Event.prototype = {
        "isDefaultPrevented": returnFalse,
        "isPropagationStopped": returnFalse,
        "isImmediatePropagationStopped": returnFalse,
        "preventDefault": function() {
            var e = this.originalEvent;
            this.isDefaultPrevented = returnTrue;
            if (e && e.preventDefault) {
                e.preventDefault();
            }
        },
        "stopPropagation": function() {
            var e = this.originalEvent;
            this.isPropagationStopped = returnTrue;
            if (e && e.stopPropagation) {
                e.stopPropagation();
            }
        },
        "stopImmediatePropagation": function() {
            this.isImmediatePropagationStopped = returnTrue;
            this.stopPropagation();
        }
    };
    // Create mouseenter/leave events using mouseover/out and event-time checks
    // Support: Chrome 15+
    jQuery.each({
        "mouseenter": "mouseover",
        "mouseleave": "mouseout"
    }, function(orig, fix) {
        jQuery.event.special[orig] = {
            "delegateType": fix,
            "bindType": fix,
            "handle": function(event) {
                var ret, target = this, related = event.relatedTarget, handleObj = event.handleObj;
                // For mousenter/leave call the handler if related is outside the target.
                // NB: No relatedTarget if the mouse left/entered the browser window
                if (!related || related !== target && !jQuery.contains(target, related)) {
                    event.type = handleObj.origType;
                    ret = handleObj.handler.apply(this, arguments);
                    event.type = fix;
                }
                return ret;
            }
        };
    });
    // Create "bubbling" focus and blur events
    // Support: Firefox, Chrome, Safari
    if (!support.focusinBubbles) {
        jQuery.each({
            "focus": "focusin",
            "blur": "focusout"
        }, function(orig, fix) {
            // Attach a single capturing handler on the document while someone wants focusin/focusout
            var handler = function(event) {
                jQuery.event.simulate(fix, event.target, jQuery.event.fix(event), true);
            };
            jQuery.event.special[fix] = {
                "setup": function() {
                    var doc = this.ownerDocument || this, attaches = data_priv.access(doc, fix);
                    if (!attaches) {
                        doc.addEventListener(orig, handler, true);
                    }
                    data_priv.access(doc, fix, (attaches || 0) + 1);
                },
                "teardown": function() {
                    var doc = this.ownerDocument || this, attaches = data_priv.access(doc, fix) - 1;
                    if (!attaches) {
                        doc.removeEventListener(orig, handler, true);
                        data_priv.remove(doc, fix);
                    } else {
                        data_priv.access(doc, fix, attaches);
                    }
                }
            };
        });
    }
    jQuery.fn.extend({
        "on": function(types, selector, data, fn, /*INTERNAL*/ one) {
            var origFn, type;
            // Types can be a map of types/handlers
            if (typeof types === "object") {
                // ( types-Object, selector, data )
                if (typeof selector !== "string") {
                    // ( types-Object, data )
                    data = data || selector;
                    selector = undefined;
                }
                for (type in types) {
                    this.on(type, selector, data, types[type], one);
                }
                return this;
            }
            if (data == null && fn == null) {
                // ( types, fn )
                fn = selector;
                data = selector = undefined;
            } else if (fn == null) {
                if (typeof selector === "string") {
                    // ( types, selector, fn )
                    fn = data;
                    data = undefined;
                } else {
                    // ( types, data, fn )
                    fn = data;
                    data = selector;
                    selector = undefined;
                }
            }
            if (fn === false) {
                fn = returnFalse;
            } else if (!fn) {
                return this;
            }
            if (one === 1) {
                origFn = fn;
                fn = function(event) {
                    // Can use an empty set, since event contains the info
                    jQuery().off(event);
                    return origFn.apply(this, arguments);
                };
                // Use same guid so caller can remove using origFn
                fn.guid = origFn.guid || (origFn.guid = jQuery.guid++);
            }
            return this.each(function() {
                jQuery.event.add(this, types, fn, data, selector);
            });
        },
        "one": function(types, selector, data, fn) {
            return this.on(types, selector, data, fn, 1);
        },
        "off": function(types, selector, fn) {
            var handleObj, type;
            if (types && types.preventDefault && types.handleObj) {
                // ( event )  dispatched jQuery.Event
                handleObj = types.handleObj;
                jQuery(types.delegateTarget).off(handleObj.namespace ? handleObj.origType + "." + handleObj.namespace : handleObj.origType, handleObj.selector, handleObj.handler);
                return this;
            }
            if (typeof types === "object") {
                // ( types-object [, selector] )
                for (type in types) {
                    this.off(type, selector, types[type]);
                }
                return this;
            }
            if (selector === false || typeof selector === "function") {
                // ( types [, fn] )
                fn = selector;
                selector = undefined;
            }
            if (fn === false) {
                fn = returnFalse;
            }
            return this.each(function() {
                jQuery.event.remove(this, types, fn, selector);
            });
        },
        "trigger": function(type, data) {
            return this.each(function() {
                jQuery.event.trigger(type, data, this);
            });
        },
        "triggerHandler": function(type, data) {
            var elem = this[0];
            if (elem) {
                return jQuery.event.trigger(type, data, elem, true);
            }
        }
    });
    var rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi, rtagName = /<([\w:]+)/, rhtml = /<|&#?\w+;/, rnoInnerhtml = /<(?:script|style|link)/i, // checked="checked" or checked
    rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i, rscriptType = /^$|\/(?:java|ecma)script/i, rscriptTypeMasked = /^true\/(.*)/, rcleanScript = /^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g, // We have to close these tags to support XHTML (#13200)
    wrapMap = {
        // Support: IE 9
        "option": [ 1, "<select multiple='multiple'>", "</select>" ],
        "thead": [ 1, "<table>", "</table>" ],
        "col": [ 2, "<table><colgroup>", "</colgroup></table>" ],
        "tr": [ 2, "<table><tbody>", "</tbody></table>" ],
        "td": [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ],
        "_default": [ 0, "", "" ]
    };
    // Support: IE 9
    wrapMap.optgroup = wrapMap.option;
    wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;
    wrapMap.th = wrapMap.td;
    // Support: 1.x compatibility
    // Manipulating tables requires a tbody
    function manipulationTarget(elem, content) {
        return jQuery.nodeName(elem, "table") && jQuery.nodeName(content.nodeType !== 11 ? content : content.firstChild, "tr") ? elem.getElementsByTagName("tbody")[0] || elem.appendChild(elem.ownerDocument.createElement("tbody")) : elem;
    }
    // Replace/restore the type attribute of script elements for safe DOM manipulation
    function disableScript(elem) {
        elem.type = (elem.getAttribute("type") !== null) + "/" + elem.type;
        return elem;
    }
    function restoreScript(elem) {
        var match = rscriptTypeMasked.exec(elem.type);
        if (match) {
            elem.type = match[1];
        } else {
            elem.removeAttribute("type");
        }
        return elem;
    }
    // Mark scripts as having already been evaluated
    function setGlobalEval(elems, refElements) {
        var i = 0, l = elems.length;
        for (;i < l; i++) {
            data_priv.set(elems[i], "globalEval", !refElements || data_priv.get(refElements[i], "globalEval"));
        }
    }
    function cloneCopyEvent(src, dest) {
        var i, l, type, pdataOld, pdataCur, udataOld, udataCur, events;
        if (dest.nodeType !== 1) {
            return;
        }
        // 1. Copy private data: events, handlers, etc.
        if (data_priv.hasData(src)) {
            pdataOld = data_priv.access(src);
            pdataCur = data_priv.set(dest, pdataOld);
            events = pdataOld.events;
            if (events) {
                delete pdataCur.handle;
                pdataCur.events = {};
                for (type in events) {
                    for (i = 0, l = events[type].length; i < l; i++) {
                        jQuery.event.add(dest, type, events[type][i]);
                    }
                }
            }
        }
        // 2. Copy user data
        if (data_user.hasData(src)) {
            udataOld = data_user.access(src);
            udataCur = jQuery.extend({}, udataOld);
            data_user.set(dest, udataCur);
        }
    }
    function getAll(context, tag) {
        var ret = context.getElementsByTagName ? context.getElementsByTagName(tag || "*") : context.querySelectorAll ? context.querySelectorAll(tag || "*") : [];
        return tag === undefined || tag && jQuery.nodeName(context, tag) ? jQuery.merge([ context ], ret) : ret;
    }
    // Support: IE >= 9
    function fixInput(src, dest) {
        var nodeName = dest.nodeName.toLowerCase();
        // Fails to persist the checked state of a cloned checkbox or radio button.
        if (nodeName === "input" && rcheckableType.test(src.type)) {
            dest.checked = src.checked;
        } else if (nodeName === "input" || nodeName === "textarea") {
            dest.defaultValue = src.defaultValue;
        }
    }
    jQuery.extend({
        "clone": function(elem, dataAndEvents, deepDataAndEvents) {
            var i, l, srcElements, destElements, clone = elem.cloneNode(true), inPage = jQuery.contains(elem.ownerDocument, elem);
            // Support: IE >= 9
            // Fix Cloning issues
            if (!support.noCloneChecked && (elem.nodeType === 1 || elem.nodeType === 11) && !jQuery.isXMLDoc(elem)) {
                // We eschew Sizzle here for performance reasons: http://jsperf.com/getall-vs-sizzle/2
                destElements = getAll(clone);
                srcElements = getAll(elem);
                for (i = 0, l = srcElements.length; i < l; i++) {
                    fixInput(srcElements[i], destElements[i]);
                }
            }
            // Copy the events from the original to the clone
            if (dataAndEvents) {
                if (deepDataAndEvents) {
                    srcElements = srcElements || getAll(elem);
                    destElements = destElements || getAll(clone);
                    for (i = 0, l = srcElements.length; i < l; i++) {
                        cloneCopyEvent(srcElements[i], destElements[i]);
                    }
                } else {
                    cloneCopyEvent(elem, clone);
                }
            }
            // Preserve script evaluation history
            destElements = getAll(clone, "script");
            if (destElements.length > 0) {
                setGlobalEval(destElements, !inPage && getAll(elem, "script"));
            }
            // Return the cloned set
            return clone;
        },
        "buildFragment": function(elems, context, scripts, selection) {
            var elem, tmp, tag, wrap, contains, j, fragment = context.createDocumentFragment(), nodes = [], i = 0, l = elems.length;
            for (;i < l; i++) {
                elem = elems[i];
                if (elem || elem === 0) {
                    // Add nodes directly
                    if (jQuery.type(elem) === "object") {
                        // Support: QtWebKit
                        // jQuery.merge because push.apply(_, arraylike) throws
                        jQuery.merge(nodes, elem.nodeType ? [ elem ] : elem);
                    } else if (!rhtml.test(elem)) {
                        nodes.push(context.createTextNode(elem));
                    } else {
                        tmp = tmp || fragment.appendChild(context.createElement("div"));
                        // Deserialize a standard representation
                        tag = (rtagName.exec(elem) || [ "", "" ])[1].toLowerCase();
                        wrap = wrapMap[tag] || wrapMap._default;
                        tmp.innerHTML = wrap[1] + elem.replace(rxhtmlTag, "<$1></$2>") + wrap[2];
                        // Descend through wrappers to the right content
                        j = wrap[0];
                        while (j--) {
                            tmp = tmp.lastChild;
                        }
                        // Support: QtWebKit
                        // jQuery.merge because push.apply(_, arraylike) throws
                        jQuery.merge(nodes, tmp.childNodes);
                        // Remember the top-level container
                        tmp = fragment.firstChild;
                        // Fixes #12346
                        // Support: Webkit, IE
                        tmp.textContent = "";
                    }
                }
            }
            // Remove wrapper from fragment
            fragment.textContent = "";
            i = 0;
            while (elem = nodes[i++]) {
                // #4087 - If origin and destination elements are the same, and this is
                // that element, do not do anything
                if (selection && jQuery.inArray(elem, selection) !== -1) {
                    continue;
                }
                contains = jQuery.contains(elem.ownerDocument, elem);
                // Append to fragment
                tmp = getAll(fragment.appendChild(elem), "script");
                // Preserve script evaluation history
                if (contains) {
                    setGlobalEval(tmp);
                }
                // Capture executables
                if (scripts) {
                    j = 0;
                    while (elem = tmp[j++]) {
                        if (rscriptType.test(elem.type || "")) {
                            scripts.push(elem);
                        }
                    }
                }
            }
            return fragment;
        },
        "cleanData": function(elems) {
            var data, elem, events, type, key, j, special = jQuery.event.special, i = 0;
            for (;(elem = elems[i]) !== undefined; i++) {
                if (jQuery.acceptData(elem)) {
                    key = elem[data_priv.expando];
                    if (key && (data = data_priv.cache[key])) {
                        events = Object.keys(data.events || {});
                        if (events.length) {
                            for (j = 0; (type = events[j]) !== undefined; j++) {
                                if (special[type]) {
                                    jQuery.event.remove(elem, type);
                                } else {
                                    jQuery.removeEvent(elem, type, data.handle);
                                }
                            }
                        }
                        if (data_priv.cache[key]) {
                            // Discard any remaining `private` data
                            delete data_priv.cache[key];
                        }
                    }
                }
                // Discard any remaining `user` data
                delete data_user.cache[elem[data_user.expando]];
            }
        }
    });
    jQuery.fn.extend({
        "text": function(value) {
            return access(this, function(value) {
                return value === undefined ? jQuery.text(this) : this.empty().each(function() {
                    if (this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9) {
                        this.textContent = value;
                    }
                });
            }, null, value, arguments.length);
        },
        "append": function() {
            return this.domManip(arguments, function(elem) {
                if (this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9) {
                    var target = manipulationTarget(this, elem);
                    target.appendChild(elem);
                }
            });
        },
        "prepend": function() {
            return this.domManip(arguments, function(elem) {
                if (this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9) {
                    var target = manipulationTarget(this, elem);
                    target.insertBefore(elem, target.firstChild);
                }
            });
        },
        "before": function() {
            return this.domManip(arguments, function(elem) {
                if (this.parentNode) {
                    this.parentNode.insertBefore(elem, this);
                }
            });
        },
        "after": function() {
            return this.domManip(arguments, function(elem) {
                if (this.parentNode) {
                    this.parentNode.insertBefore(elem, this.nextSibling);
                }
            });
        },
        "remove": function(selector, keepData) {
            var elem, elems = selector ? jQuery.filter(selector, this) : this, i = 0;
            for (;(elem = elems[i]) != null; i++) {
                if (!keepData && elem.nodeType === 1) {
                    jQuery.cleanData(getAll(elem));
                }
                if (elem.parentNode) {
                    if (keepData && jQuery.contains(elem.ownerDocument, elem)) {
                        setGlobalEval(getAll(elem, "script"));
                    }
                    elem.parentNode.removeChild(elem);
                }
            }
            return this;
        },
        "empty": function() {
            var elem, i = 0;
            for (;(elem = this[i]) != null; i++) {
                if (elem.nodeType === 1) {
                    // Prevent memory leaks
                    jQuery.cleanData(getAll(elem, false));
                    // Remove any remaining nodes
                    elem.textContent = "";
                }
            }
            return this;
        },
        "clone": function(dataAndEvents, deepDataAndEvents) {
            dataAndEvents = dataAndEvents == null ? false : dataAndEvents;
            deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;
            return this.map(function() {
                return jQuery.clone(this, dataAndEvents, deepDataAndEvents);
            });
        },
        "html": function(value) {
            return access(this, function(value) {
                var elem = this[0] || {}, i = 0, l = this.length;
                if (value === undefined && elem.nodeType === 1) {
                    return elem.innerHTML;
                }
                // See if we can take a shortcut and just use innerHTML
                if (typeof value === "string" && !rnoInnerhtml.test(value) && !wrapMap[(rtagName.exec(value) || [ "", "" ])[1].toLowerCase()]) {
                    value = value.replace(rxhtmlTag, "<$1></$2>");
                    try {
                        for (;i < l; i++) {
                            elem = this[i] || {};
                            // Remove element nodes and prevent memory leaks
                            if (elem.nodeType === 1) {
                                jQuery.cleanData(getAll(elem, false));
                                elem.innerHTML = value;
                            }
                        }
                        elem = 0;
                    } catch (e) {}
                }
                if (elem) {
                    this.empty().append(value);
                }
            }, null, value, arguments.length);
        },
        "replaceWith": function() {
            var arg = arguments[0];
            // Make the changes, replacing each context element with the new content
            this.domManip(arguments, function(elem) {
                arg = this.parentNode;
                jQuery.cleanData(getAll(this));
                if (arg) {
                    arg.replaceChild(elem, this);
                }
            });
            // Force removal if there was no new content (e.g., from empty arguments)
            return arg && (arg.length || arg.nodeType) ? this : this.remove();
        },
        "detach": function(selector) {
            return this.remove(selector, true);
        },
        "domManip": function(args, callback) {
            // Flatten any nested arrays
            args = concat.apply([], args);
            var fragment, first, scripts, hasScripts, node, doc, i = 0, l = this.length, set = this, iNoClone = l - 1, value = args[0], isFunction = jQuery.isFunction(value);
            // We can't cloneNode fragments that contain checked, in WebKit
            if (isFunction || l > 1 && typeof value === "string" && !support.checkClone && rchecked.test(value)) {
                return this.each(function(index) {
                    var self = set.eq(index);
                    if (isFunction) {
                        args[0] = value.call(this, index, self.html());
                    }
                    self.domManip(args, callback);
                });
            }
            if (l) {
                fragment = jQuery.buildFragment(args, this[0].ownerDocument, false, this);
                first = fragment.firstChild;
                if (fragment.childNodes.length === 1) {
                    fragment = first;
                }
                if (first) {
                    scripts = jQuery.map(getAll(fragment, "script"), disableScript);
                    hasScripts = scripts.length;
                    // Use the original fragment for the last item instead of the first because it can end up
                    // being emptied incorrectly in certain situations (#8070).
                    for (;i < l; i++) {
                        node = fragment;
                        if (i !== iNoClone) {
                            node = jQuery.clone(node, true, true);
                            // Keep references to cloned scripts for later restoration
                            if (hasScripts) {
                                // Support: QtWebKit
                                // jQuery.merge because push.apply(_, arraylike) throws
                                jQuery.merge(scripts, getAll(node, "script"));
                            }
                        }
                        callback.call(this[i], node, i);
                    }
                    if (hasScripts) {
                        doc = scripts[scripts.length - 1].ownerDocument;
                        // Reenable scripts
                        jQuery.map(scripts, restoreScript);
                        // Evaluate executable scripts on first document insertion
                        for (i = 0; i < hasScripts; i++) {
                            node = scripts[i];
                            if (rscriptType.test(node.type || "") && !data_priv.access(node, "globalEval") && jQuery.contains(doc, node)) {
                                if (node.src) {
                                    // Optional AJAX dependency, but won't run scripts if not present
                                    if (jQuery._evalUrl) {
                                        jQuery._evalUrl(node.src);
                                    }
                                } else {
                                    jQuery.globalEval(node.textContent.replace(rcleanScript, ""));
                                }
                            }
                        }
                    }
                }
            }
            return this;
        }
    });
    jQuery.each({
        "appendTo": "append",
        "prependTo": "prepend",
        "insertBefore": "before",
        "insertAfter": "after",
        "replaceAll": "replaceWith"
    }, function(name, original) {
        jQuery.fn[name] = function(selector) {
            var elems, ret = [], insert = jQuery(selector), last = insert.length - 1, i = 0;
            for (;i <= last; i++) {
                elems = i === last ? this : this.clone(true);
                jQuery(insert[i])[original](elems);
                // Support: QtWebKit
                // .get() because push.apply(_, arraylike) throws
                push.apply(ret, elems.get());
            }
            return this.pushStack(ret);
        };
    });
    var iframe, elemdisplay = {};
    /**
   * Retrieve the actual display of a element
   * @param {String} name nodeName of the element
   * @param {Object} doc Document object
   */
    // Called only from within defaultDisplay
    function actualDisplay(name, doc) {
        var elem = jQuery(doc.createElement(name)).appendTo(doc.body), // getDefaultComputedStyle might be reliably used only on attached element
        display = window.getDefaultComputedStyle ? // Use of this method is a temporary fix (more like optmization) until something better comes along,
        // since it was removed from specification and supported only in FF
        window.getDefaultComputedStyle(elem[0]).display : jQuery.css(elem[0], "display");
        // We don't have any data stored on the element,
        // so use "detach" method as fast way to get rid of the element
        elem.detach();
        return display;
    }
    /**
   * Try to determine the default display value of an element
   * @param {String} nodeName
   */
    function defaultDisplay(nodeName) {
        var doc = document, display = elemdisplay[nodeName];
        if (!display) {
            display = actualDisplay(nodeName, doc);
            // If the simple way fails, read from inside an iframe
            if (display === "none" || !display) {
                // Use the already-created iframe if possible
                iframe = (iframe || jQuery("<iframe frameborder='0' width='0' height='0'/>")).appendTo(doc.documentElement);
                // Always write a new HTML skeleton so Webkit and Firefox don't choke on reuse
                doc = iframe[0].contentDocument;
                // Support: IE
                doc.write();
                doc.close();
                display = actualDisplay(nodeName, doc);
                iframe.detach();
            }
            // Store the correct default display
            elemdisplay[nodeName] = display;
        }
        return display;
    }
    var rmargin = /^margin/;
    var rnumnonpx = new RegExp("^(" + pnum + ")(?!px)[a-z%]+$", "i");
    var getStyles = function(elem) {
        return elem.ownerDocument.defaultView.getComputedStyle(elem, null);
    };
    function curCSS(elem, name, computed) {
        var width, minWidth, maxWidth, ret, style = elem.style;
        computed = computed || getStyles(elem);
        // Support: IE9
        // getPropertyValue is only needed for .css('filter') in IE9, see #12537
        if (computed) {
            ret = computed.getPropertyValue(name) || computed[name];
        }
        if (computed) {
            if (ret === "" && !jQuery.contains(elem.ownerDocument, elem)) {
                ret = jQuery.style(elem, name);
            }
            // Support: iOS < 6
            // A tribute to the "awesome hack by Dean Edwards"
            // iOS < 6 (at least) returns percentage for a larger set of values, but width seems to be reliably pixels
            // this is against the CSSOM draft spec: http://dev.w3.org/csswg/cssom/#resolved-values
            if (rnumnonpx.test(ret) && rmargin.test(name)) {
                // Remember the original values
                width = style.width;
                minWidth = style.minWidth;
                maxWidth = style.maxWidth;
                // Put in the new values to get a computed value out
                style.minWidth = style.maxWidth = style.width = ret;
                ret = computed.width;
                // Revert the changed values
                style.width = width;
                style.minWidth = minWidth;
                style.maxWidth = maxWidth;
            }
        }
        // Support: IE
        // IE returns zIndex value as an integer.
        return ret !== undefined ? ret + "" : ret;
    }
    function addGetHookIf(conditionFn, hookFn) {
        // Define the hook, we'll check on the first run if it's really needed.
        return {
            "get": function() {
                if (conditionFn()) {
                    // Hook not needed (or it's not possible to use it due to missing dependency),
                    // remove it.
                    // Since there are no other hooks for marginRight, remove the whole object.
                    delete this.get;
                    return;
                }
                // Hook needed; redefine it so that the support test is not executed again.
                return (this.get = hookFn).apply(this, arguments);
            }
        };
    }
    (function() {
        var pixelPositionVal, boxSizingReliableVal, // Support: Firefox, Android 2.3 (Prefixed box-sizing versions).
        divReset = "padding:0;margin:0;border:0;display:block;-webkit-box-sizing:content-box;" + "-moz-box-sizing:content-box;box-sizing:content-box", docElem = document.documentElement, container = document.createElement("div"), div = document.createElement("div");
        div.style.backgroundClip = "content-box";
        div.cloneNode(true).style.backgroundClip = "";
        support.clearCloneStyle = div.style.backgroundClip === "content-box";
        container.style.cssText = "border:0;width:0;height:0;position:absolute;top:0;left:-9999px;" + "margin-top:1px";
        container.appendChild(div);
        // Executing both pixelPosition & boxSizingReliable tests require only one layout
        // so they're executed at the same time to save the second computation.
        function computePixelPositionAndBoxSizingReliable() {
            // Support: Firefox, Android 2.3 (Prefixed box-sizing versions).
            div.style.cssText = "-webkit-box-sizing:border-box;-moz-box-sizing:border-box;" + "box-sizing:border-box;padding:1px;border:1px;display:block;width:4px;margin-top:1%;" + "position:absolute;top:1%";
            docElem.appendChild(container);
            var divStyle = window.getComputedStyle(div, null);
            pixelPositionVal = divStyle.top !== "1%";
            boxSizingReliableVal = divStyle.width === "4px";
            docElem.removeChild(container);
        }
        // Use window.getComputedStyle because jsdom on node.js will break without it.
        if (window.getComputedStyle) {
            jQuery.extend(support, {
                "pixelPosition": function() {
                    // This test is executed only once but we still do memoizing
                    // since we can use the boxSizingReliable pre-computing.
                    // No need to check if the test was already performed, though.
                    computePixelPositionAndBoxSizingReliable();
                    return pixelPositionVal;
                },
                "boxSizingReliable": function() {
                    if (boxSizingReliableVal == null) {
                        computePixelPositionAndBoxSizingReliable();
                    }
                    return boxSizingReliableVal;
                },
                "reliableMarginRight": function() {
                    // Support: Android 2.3
                    // Check if div with explicit width and no margin-right incorrectly
                    // gets computed margin-right based on width of container. (#3333)
                    // WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right
                    // This support function is only executed once so no memoizing is needed.
                    var ret, marginDiv = div.appendChild(document.createElement("div"));
                    marginDiv.style.cssText = div.style.cssText = divReset;
                    marginDiv.style.marginRight = marginDiv.style.width = "0";
                    div.style.width = "1px";
                    docElem.appendChild(container);
                    ret = !parseFloat(window.getComputedStyle(marginDiv, null).marginRight);
                    docElem.removeChild(container);
                    // Clean up the div for other support tests.
                    div.innerHTML = "";
                    return ret;
                }
            });
        }
    })();
    // A method for quickly swapping in/out CSS properties to get correct calculations.
    jQuery.swap = function(elem, options, callback, args) {
        var ret, name, old = {};
        // Remember the old values, and insert the new ones
        for (name in options) {
            old[name] = elem.style[name];
            elem.style[name] = options[name];
        }
        ret = callback.apply(elem, args || []);
        // Revert the old values
        for (name in options) {
            elem.style[name] = old[name];
        }
        return ret;
    };
    var // swappable if display is none or starts with table except "table", "table-cell", or "table-caption"
    // see here for display values: https://developer.mozilla.org/en-US/docs/CSS/display
    rdisplayswap = /^(none|table(?!-c[ea]).+)/, rnumsplit = new RegExp("^(" + pnum + ")(.*)$", "i"), rrelNum = new RegExp("^([+-])=(" + pnum + ")", "i"), cssShow = {
        "position": "absolute",
        "visibility": "hidden",
        "display": "block"
    }, cssNormalTransform = {
        "letterSpacing": 0,
        "fontWeight": 400
    }, cssPrefixes = [ "Webkit", "O", "Moz", "ms" ];
    // return a css property mapped to a potentially vendor prefixed property
    function vendorPropName(style, name) {
        // shortcut for names that are not vendor prefixed
        if (name in style) {
            return name;
        }
        // check for vendor prefixed names
        var capName = name[0].toUpperCase() + name.slice(1), origName = name, i = cssPrefixes.length;
        while (i--) {
            name = cssPrefixes[i] + capName;
            if (name in style) {
                return name;
            }
        }
        return origName;
    }
    function setPositiveNumber(elem, value, subtract) {
        var matches = rnumsplit.exec(value);
        // Guard against undefined "subtract", e.g., when used as in cssHooks
        return matches ? Math.max(0, matches[1] - (subtract || 0)) + (matches[2] || "px") : value;
    }
    function augmentWidthOrHeight(elem, name, extra, isBorderBox, styles) {
        var i = extra === (isBorderBox ? "border" : "content") ? // If we already have the right measurement, avoid augmentation
        4 : // Otherwise initialize for horizontal or vertical properties
        name === "width" ? 1 : 0, val = 0;
        for (;i < 4; i += 2) {
            // both box models exclude margin, so add it if we want it
            if (extra === "margin") {
                val += jQuery.css(elem, extra + cssExpand[i], true, styles);
            }
            if (isBorderBox) {
                // border-box includes padding, so remove it if we want content
                if (extra === "content") {
                    val -= jQuery.css(elem, "padding" + cssExpand[i], true, styles);
                }
                // at this point, extra isn't border nor margin, so remove border
                if (extra !== "margin") {
                    val -= jQuery.css(elem, "border" + cssExpand[i] + "Width", true, styles);
                }
            } else {
                // at this point, extra isn't content, so add padding
                val += jQuery.css(elem, "padding" + cssExpand[i], true, styles);
                // at this point, extra isn't content nor padding, so add border
                if (extra !== "padding") {
                    val += jQuery.css(elem, "border" + cssExpand[i] + "Width", true, styles);
                }
            }
        }
        return val;
    }
    function getWidthOrHeight(elem, name, extra) {
        // Start with offset property, which is equivalent to the border-box value
        var valueIsBorderBox = true, val = name === "width" ? elem.offsetWidth : elem.offsetHeight, styles = getStyles(elem), isBorderBox = jQuery.css(elem, "boxSizing", false, styles) === "border-box";
        // some non-html elements return undefined for offsetWidth, so check for null/undefined
        // svg - https://bugzilla.mozilla.org/show_bug.cgi?id=649285
        // MathML - https://bugzilla.mozilla.org/show_bug.cgi?id=491668
        if (val <= 0 || val == null) {
            // Fall back to computed then uncomputed css if necessary
            val = curCSS(elem, name, styles);
            if (val < 0 || val == null) {
                val = elem.style[name];
            }
            // Computed unit is not pixels. Stop here and return.
            if (rnumnonpx.test(val)) {
                return val;
            }
            // we need the check for style in case a browser which returns unreliable values
            // for getComputedStyle silently falls back to the reliable elem.style
            valueIsBorderBox = isBorderBox && (support.boxSizingReliable() || val === elem.style[name]);
            // Normalize "", auto, and prepare for extra
            val = parseFloat(val) || 0;
        }
        // use the active box-sizing model to add/subtract irrelevant styles
        return val + augmentWidthOrHeight(elem, name, extra || (isBorderBox ? "border" : "content"), valueIsBorderBox, styles) + "px";
    }
    function showHide(elements, show) {
        var display, elem, hidden, values = [], index = 0, length = elements.length;
        for (;index < length; index++) {
            elem = elements[index];
            if (!elem.style) {
                continue;
            }
            values[index] = data_priv.get(elem, "olddisplay");
            display = elem.style.display;
            if (show) {
                // Reset the inline display of this element to learn if it is
                // being hidden by cascaded rules or not
                if (!values[index] && display === "none") {
                    elem.style.display = "";
                }
                // Set elements which have been overridden with display: none
                // in a stylesheet to whatever the default browser style is
                // for such an element
                if (elem.style.display === "" && isHidden(elem)) {
                    values[index] = data_priv.access(elem, "olddisplay", defaultDisplay(elem.nodeName));
                }
            } else {
                if (!values[index]) {
                    hidden = isHidden(elem);
                    if (display && display !== "none" || !hidden) {
                        data_priv.set(elem, "olddisplay", hidden ? display : jQuery.css(elem, "display"));
                    }
                }
            }
        }
        // Set the display of most of the elements in a second loop
        // to avoid the constant reflow
        for (index = 0; index < length; index++) {
            elem = elements[index];
            if (!elem.style) {
                continue;
            }
            if (!show || elem.style.display === "none" || elem.style.display === "") {
                elem.style.display = show ? values[index] || "" : "none";
            }
        }
        return elements;
    }
    jQuery.extend({
        // Add in style property hooks for overriding the default
        // behavior of getting and setting a style property
        "cssHooks": {
            "opacity": {
                "get": function(elem, computed) {
                    if (computed) {
                        // We should always get a number back from opacity
                        var ret = curCSS(elem, "opacity");
                        return ret === "" ? "1" : ret;
                    }
                }
            }
        },
        // Don't automatically add "px" to these possibly-unitless properties
        "cssNumber": {
            "columnCount": true,
            "fillOpacity": true,
            "fontWeight": true,
            "lineHeight": true,
            "opacity": true,
            "order": true,
            "orphans": true,
            "widows": true,
            "zIndex": true,
            "zoom": true
        },
        // Add in properties whose names you wish to fix before
        // setting or getting the value
        "cssProps": {
            // normalize float css property
            "float": "cssFloat"
        },
        // Get and set the style property on a DOM Node
        "style": function(elem, name, value, extra) {
            // Don't set styles on text and comment nodes
            if (!elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style) {
                return;
            }
            // Make sure that we're working with the right name
            var ret, type, hooks, origName = jQuery.camelCase(name), style = elem.style;
            name = jQuery.cssProps[origName] || (jQuery.cssProps[origName] = vendorPropName(style, origName));
            // gets hook for the prefixed version
            // followed by the unprefixed version
            hooks = jQuery.cssHooks[name] || jQuery.cssHooks[origName];
            // Check if we're setting a value
            if (value !== undefined) {
                type = typeof value;
                // convert relative number strings (+= or -=) to relative numbers. #7345
                if (type === "string" && (ret = rrelNum.exec(value))) {
                    value = (ret[1] + 1) * ret[2] + parseFloat(jQuery.css(elem, name));
                    // Fixes bug #9237
                    type = "number";
                }
                // Make sure that null and NaN values aren't set. See: #7116
                if (value == null || value !== value) {
                    return;
                }
                // If a number was passed in, add 'px' to the (except for certain CSS properties)
                if (type === "number" && !jQuery.cssNumber[origName]) {
                    value += "px";
                }
                // Fixes #8908, it can be done more correctly by specifying setters in cssHooks,
                // but it would mean to define eight (for every problematic property) identical functions
                if (!support.clearCloneStyle && value === "" && name.indexOf("background") === 0) {
                    style[name] = "inherit";
                }
                // If a hook was provided, use that value, otherwise just set the specified value
                if (!hooks || !("set" in hooks) || (value = hooks.set(elem, value, extra)) !== undefined) {
                    // Support: Chrome, Safari
                    // Setting style to blank string required to delete "style: x !important;"
                    style[name] = "";
                    style[name] = value;
                }
            } else {
                // If a hook was provided get the non-computed value from there
                if (hooks && "get" in hooks && (ret = hooks.get(elem, false, extra)) !== undefined) {
                    return ret;
                }
                // Otherwise just get the value from the style object
                return style[name];
            }
        },
        "css": function(elem, name, extra, styles) {
            var val, num, hooks, origName = jQuery.camelCase(name);
            // Make sure that we're working with the right name
            name = jQuery.cssProps[origName] || (jQuery.cssProps[origName] = vendorPropName(elem.style, origName));
            // gets hook for the prefixed version
            // followed by the unprefixed version
            hooks = jQuery.cssHooks[name] || jQuery.cssHooks[origName];
            // If a hook was provided get the computed value from there
            if (hooks && "get" in hooks) {
                val = hooks.get(elem, true, extra);
            }
            // Otherwise, if a way to get the computed value exists, use that
            if (val === undefined) {
                val = curCSS(elem, name, styles);
            }
            //convert "normal" to computed value
            if (val === "normal" && name in cssNormalTransform) {
                val = cssNormalTransform[name];
            }
            // Return, converting to number if forced or a qualifier was provided and val looks numeric
            if (extra === "" || extra) {
                num = parseFloat(val);
                return extra === true || jQuery.isNumeric(num) ? num || 0 : val;
            }
            return val;
        }
    });
    jQuery.each([ "height", "width" ], function(i, name) {
        jQuery.cssHooks[name] = {
            "get": function(elem, computed, extra) {
                if (computed) {
                    // certain elements can have dimension info if we invisibly show them
                    // however, it must have a current display style that would benefit from this
                    return elem.offsetWidth === 0 && rdisplayswap.test(jQuery.css(elem, "display")) ? jQuery.swap(elem, cssShow, function() {
                        return getWidthOrHeight(elem, name, extra);
                    }) : getWidthOrHeight(elem, name, extra);
                }
            },
            "set": function(elem, value, extra) {
                var styles = extra && getStyles(elem);
                return setPositiveNumber(elem, value, extra ? augmentWidthOrHeight(elem, name, extra, jQuery.css(elem, "boxSizing", false, styles) === "border-box", styles) : 0);
            }
        };
    });
    // Support: Android 2.3
    jQuery.cssHooks.marginRight = addGetHookIf(support.reliableMarginRight, function(elem, computed) {
        if (computed) {
            // WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right
            // Work around by temporarily setting element display to inline-block
            return jQuery.swap(elem, {
                "display": "inline-block"
            }, curCSS, [ elem, "marginRight" ]);
        }
    });
    // These hooks are used by animate to expand properties
    jQuery.each({
        "margin": "",
        "padding": "",
        "border": "Width"
    }, function(prefix, suffix) {
        jQuery.cssHooks[prefix + suffix] = {
            "expand": function(value) {
                var i = 0, expanded = {}, // assumes a single number if not a string
                parts = typeof value === "string" ? value.split(" ") : [ value ];
                for (;i < 4; i++) {
                    expanded[prefix + cssExpand[i] + suffix] = parts[i] || parts[i - 2] || parts[0];
                }
                return expanded;
            }
        };
        if (!rmargin.test(prefix)) {
            jQuery.cssHooks[prefix + suffix].set = setPositiveNumber;
        }
    });
    jQuery.fn.extend({
        "css": function(name, value) {
            return access(this, function(elem, name, value) {
                var styles, len, map = {}, i = 0;
                if (jQuery.isArray(name)) {
                    styles = getStyles(elem);
                    len = name.length;
                    for (;i < len; i++) {
                        map[name[i]] = jQuery.css(elem, name[i], false, styles);
                    }
                    return map;
                }
                return value !== undefined ? jQuery.style(elem, name, value) : jQuery.css(elem, name);
            }, name, value, arguments.length > 1);
        },
        "show": function() {
            return showHide(this, true);
        },
        "hide": function() {
            return showHide(this);
        },
        "toggle": function(state) {
            if (typeof state === "boolean") {
                return state ? this.show() : this.hide();
            }
            return this.each(function() {
                if (isHidden(this)) {
                    jQuery(this).show();
                } else {
                    jQuery(this).hide();
                }
            });
        }
    });
    function Tween(elem, options, prop, end, easing) {
        return new Tween.prototype.init(elem, options, prop, end, easing);
    }
    jQuery.Tween = Tween;
    Tween.prototype = {
        "constructor": Tween,
        "init": function(elem, options, prop, end, easing, unit) {
            this.elem = elem;
            this.prop = prop;
            this.easing = easing || "swing";
            this.options = options;
            this.start = this.now = this.cur();
            this.end = end;
            this.unit = unit || (jQuery.cssNumber[prop] ? "" : "px");
        },
        "cur": function() {
            var hooks = Tween.propHooks[this.prop];
            return hooks && hooks.get ? hooks.get(this) : Tween.propHooks._default.get(this);
        },
        "run": function(percent) {
            var eased, hooks = Tween.propHooks[this.prop];
            if (this.options.duration) {
                this.pos = eased = jQuery.easing[this.easing](percent, this.options.duration * percent, 0, 1, this.options.duration);
            } else {
                this.pos = eased = percent;
            }
            this.now = (this.end - this.start) * eased + this.start;
            if (this.options.step) {
                this.options.step.call(this.elem, this.now, this);
            }
            if (hooks && hooks.set) {
                hooks.set(this);
            } else {
                Tween.propHooks._default.set(this);
            }
            return this;
        }
    };
    Tween.prototype.init.prototype = Tween.prototype;
    Tween.propHooks = {
        "_default": {
            "get": function(tween) {
                var result;
                if (tween.elem[tween.prop] != null && (!tween.elem.style || tween.elem.style[tween.prop] == null)) {
                    return tween.elem[tween.prop];
                }
                // passing an empty string as a 3rd parameter to .css will automatically
                // attempt a parseFloat and fallback to a string if the parse fails
                // so, simple values such as "10px" are parsed to Float.
                // complex values such as "rotate(1rad)" are returned as is.
                result = jQuery.css(tween.elem, tween.prop, "");
                // Empty strings, null, undefined and "auto" are converted to 0.
                return !result || result === "auto" ? 0 : result;
            },
            "set": function(tween) {
                // use step hook for back compat - use cssHook if its there - use .style if its
                // available and use plain properties where available
                if (jQuery.fx.step[tween.prop]) {
                    jQuery.fx.step[tween.prop](tween);
                } else if (tween.elem.style && (tween.elem.style[jQuery.cssProps[tween.prop]] != null || jQuery.cssHooks[tween.prop])) {
                    jQuery.style(tween.elem, tween.prop, tween.now + tween.unit);
                } else {
                    tween.elem[tween.prop] = tween.now;
                }
            }
        }
    };
    // Support: IE9
    // Panic based approach to setting things on disconnected nodes
    Tween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {
        "set": function(tween) {
            if (tween.elem.nodeType && tween.elem.parentNode) {
                tween.elem[tween.prop] = tween.now;
            }
        }
    };
    jQuery.easing = {
        "linear": function(p) {
            return p;
        },
        "swing": function(p) {
            return .5 - Math.cos(p * Math.PI) / 2;
        }
    };
    jQuery.fx = Tween.prototype.init;
    // Back Compat <1.8 extension point
    jQuery.fx.step = {};
    var fxNow, timerId, rfxtypes = /^(?:toggle|show|hide)$/, rfxnum = new RegExp("^(?:([+-])=|)(" + pnum + ")([a-z%]*)$", "i"), rrun = /queueHooks$/, animationPrefilters = [ defaultPrefilter ], tweeners = {
        "*": [ function(prop, value) {
            var tween = this.createTween(prop, value), target = tween.cur(), parts = rfxnum.exec(value), unit = parts && parts[3] || (jQuery.cssNumber[prop] ? "" : "px"), // Starting value computation is required for potential unit mismatches
            start = (jQuery.cssNumber[prop] || unit !== "px" && +target) && rfxnum.exec(jQuery.css(tween.elem, prop)), scale = 1, maxIterations = 20;
            if (start && start[3] !== unit) {
                // Trust units reported by jQuery.css
                unit = unit || start[3];
                // Make sure we update the tween properties later on
                parts = parts || [];
                // Iteratively approximate from a nonzero starting point
                start = +target || 1;
                do {
                    // If previous iteration zeroed out, double until we get *something*
                    // Use a string for doubling factor so we don't accidentally see scale as unchanged below
                    scale = scale || ".5";
                    // Adjust and apply
                    start = start / scale;
                    jQuery.style(tween.elem, prop, start + unit);
                } while (scale !== (scale = tween.cur() / target) && scale !== 1 && --maxIterations);
            }
            // Update tween properties
            if (parts) {
                start = tween.start = +start || +target || 0;
                tween.unit = unit;
                // If a +=/-= token was provided, we're doing a relative animation
                tween.end = parts[1] ? start + (parts[1] + 1) * parts[2] : +parts[2];
            }
            return tween;
        } ]
    };
    // Animations created synchronously will run synchronously
    function createFxNow() {
        setTimeout(function() {
            fxNow = undefined;
        });
        return fxNow = jQuery.now();
    }
    // Generate parameters to create a standard animation
    function genFx(type, includeWidth) {
        var which, i = 0, attrs = {
            "height": type
        };
        // if we include width, step value is 1 to do all cssExpand values,
        // if we don't include width, step value is 2 to skip over Left and Right
        includeWidth = includeWidth ? 1 : 0;
        for (;i < 4; i += 2 - includeWidth) {
            which = cssExpand[i];
            attrs["margin" + which] = attrs["padding" + which] = type;
        }
        if (includeWidth) {
            attrs.opacity = attrs.width = type;
        }
        return attrs;
    }
    function createTween(value, prop, animation) {
        var tween, collection = (tweeners[prop] || []).concat(tweeners["*"]), index = 0, length = collection.length;
        for (;index < length; index++) {
            if (tween = collection[index].call(animation, prop, value)) {
                // we're done with this property
                return tween;
            }
        }
    }
    function defaultPrefilter(elem, props, opts) {
        /* jshint validthis: true */
        var prop, value, toggle, tween, hooks, oldfire, display, anim = this, orig = {}, style = elem.style, hidden = elem.nodeType && isHidden(elem), dataShow = data_priv.get(elem, "fxshow");
        // handle queue: false promises
        if (!opts.queue) {
            hooks = jQuery._queueHooks(elem, "fx");
            if (hooks.unqueued == null) {
                hooks.unqueued = 0;
                oldfire = hooks.empty.fire;
                hooks.empty.fire = function() {
                    if (!hooks.unqueued) {
                        oldfire();
                    }
                };
            }
            hooks.unqueued++;
            anim.always(function() {
                // doing this makes sure that the complete handler will be called
                // before this completes
                anim.always(function() {
                    hooks.unqueued--;
                    if (!jQuery.queue(elem, "fx").length) {
                        hooks.empty.fire();
                    }
                });
            });
        }
        // height/width overflow pass
        if (elem.nodeType === 1 && ("height" in props || "width" in props)) {
            // Make sure that nothing sneaks out
            // Record all 3 overflow attributes because IE9-10 do not
            // change the overflow attribute when overflowX and
            // overflowY are set to the same value
            opts.overflow = [ style.overflow, style.overflowX, style.overflowY ];
            // Set display property to inline-block for height/width
            // animations on inline elements that are having width/height animated
            display = jQuery.css(elem, "display");
            // Get default display if display is currently "none"
            if (display === "none") {
                display = defaultDisplay(elem.nodeName);
            }
            if (display === "inline" && jQuery.css(elem, "float") === "none") {
                style.display = "inline-block";
            }
        }
        if (opts.overflow) {
            style.overflow = "hidden";
            anim.always(function() {
                style.overflow = opts.overflow[0];
                style.overflowX = opts.overflow[1];
                style.overflowY = opts.overflow[2];
            });
        }
        // show/hide pass
        for (prop in props) {
            value = props[prop];
            if (rfxtypes.exec(value)) {
                delete props[prop];
                toggle = toggle || value === "toggle";
                if (value === (hidden ? "hide" : "show")) {
                    // If there is dataShow left over from a stopped hide or show and we are going to proceed with show, we should pretend to be hidden
                    if (value === "show" && dataShow && dataShow[prop] !== undefined) {
                        hidden = true;
                    } else {
                        continue;
                    }
                }
                orig[prop] = dataShow && dataShow[prop] || jQuery.style(elem, prop);
            }
        }
        if (!jQuery.isEmptyObject(orig)) {
            if (dataShow) {
                if ("hidden" in dataShow) {
                    hidden = dataShow.hidden;
                }
            } else {
                dataShow = data_priv.access(elem, "fxshow", {});
            }
            // store state if its toggle - enables .stop().toggle() to "reverse"
            if (toggle) {
                dataShow.hidden = !hidden;
            }
            if (hidden) {
                jQuery(elem).show();
            } else {
                anim.done(function() {
                    jQuery(elem).hide();
                });
            }
            anim.done(function() {
                var prop;
                data_priv.remove(elem, "fxshow");
                for (prop in orig) {
                    jQuery.style(elem, prop, orig[prop]);
                }
            });
            for (prop in orig) {
                tween = createTween(hidden ? dataShow[prop] : 0, prop, anim);
                if (!(prop in dataShow)) {
                    dataShow[prop] = tween.start;
                    if (hidden) {
                        tween.end = tween.start;
                        tween.start = prop === "width" || prop === "height" ? 1 : 0;
                    }
                }
            }
        }
    }
    function propFilter(props, specialEasing) {
        var index, name, easing, value, hooks;
        // camelCase, specialEasing and expand cssHook pass
        for (index in props) {
            name = jQuery.camelCase(index);
            easing = specialEasing[name];
            value = props[index];
            if (jQuery.isArray(value)) {
                easing = value[1];
                value = props[index] = value[0];
            }
            if (index !== name) {
                props[name] = value;
                delete props[index];
            }
            hooks = jQuery.cssHooks[name];
            if (hooks && "expand" in hooks) {
                value = hooks.expand(value);
                delete props[name];
                // not quite $.extend, this wont overwrite keys already present.
                // also - reusing 'index' from above because we have the correct "name"
                for (index in value) {
                    if (!(index in props)) {
                        props[index] = value[index];
                        specialEasing[index] = easing;
                    }
                }
            } else {
                specialEasing[name] = easing;
            }
        }
    }
    function Animation(elem, properties, options) {
        var result, stopped, index = 0, length = animationPrefilters.length, deferred = jQuery.Deferred().always(function() {
            // don't match elem in the :animated selector
            delete tick.elem;
        }), tick = function() {
            if (stopped) {
                return false;
            }
            var currentTime = fxNow || createFxNow(), remaining = Math.max(0, animation.startTime + animation.duration - currentTime), // archaic crash bug won't allow us to use 1 - ( 0.5 || 0 ) (#12497)
            temp = remaining / animation.duration || 0, percent = 1 - temp, index = 0, length = animation.tweens.length;
            for (;index < length; index++) {
                animation.tweens[index].run(percent);
            }
            deferred.notifyWith(elem, [ animation, percent, remaining ]);
            if (percent < 1 && length) {
                return remaining;
            } else {
                deferred.resolveWith(elem, [ animation ]);
                return false;
            }
        }, animation = deferred.promise({
            "elem": elem,
            "props": jQuery.extend({}, properties),
            "opts": jQuery.extend(true, {
                "specialEasing": {}
            }, options),
            "originalProperties": properties,
            "originalOptions": options,
            "startTime": fxNow || createFxNow(),
            "duration": options.duration,
            "tweens": [],
            "createTween": function(prop, end) {
                var tween = jQuery.Tween(elem, animation.opts, prop, end, animation.opts.specialEasing[prop] || animation.opts.easing);
                animation.tweens.push(tween);
                return tween;
            },
            "stop": function(gotoEnd) {
                var index = 0, // if we are going to the end, we want to run all the tweens
                // otherwise we skip this part
                length = gotoEnd ? animation.tweens.length : 0;
                if (stopped) {
                    return this;
                }
                stopped = true;
                for (;index < length; index++) {
                    animation.tweens[index].run(1);
                }
                // resolve when we played the last frame
                // otherwise, reject
                if (gotoEnd) {
                    deferred.resolveWith(elem, [ animation, gotoEnd ]);
                } else {
                    deferred.rejectWith(elem, [ animation, gotoEnd ]);
                }
                return this;
            }
        }), props = animation.props;
        propFilter(props, animation.opts.specialEasing);
        for (;index < length; index++) {
            result = animationPrefilters[index].call(animation, elem, props, animation.opts);
            if (result) {
                return result;
            }
        }
        jQuery.map(props, createTween, animation);
        if (jQuery.isFunction(animation.opts.start)) {
            animation.opts.start.call(elem, animation);
        }
        jQuery.fx.timer(jQuery.extend(tick, {
            "elem": elem,
            "anim": animation,
            "queue": animation.opts.queue
        }));
        // attach callbacks from options
        return animation.progress(animation.opts.progress).done(animation.opts.done, animation.opts.complete).fail(animation.opts.fail).always(animation.opts.always);
    }
    jQuery.Animation = jQuery.extend(Animation, {
        "tweener": function(props, callback) {
            if (jQuery.isFunction(props)) {
                callback = props;
                props = [ "*" ];
            } else {
                props = props.split(" ");
            }
            var prop, index = 0, length = props.length;
            for (;index < length; index++) {
                prop = props[index];
                tweeners[prop] = tweeners[prop] || [];
                tweeners[prop].unshift(callback);
            }
        },
        "prefilter": function(callback, prepend) {
            if (prepend) {
                animationPrefilters.unshift(callback);
            } else {
                animationPrefilters.push(callback);
            }
        }
    });
    jQuery.speed = function(speed, easing, fn) {
        var opt = speed && typeof speed === "object" ? jQuery.extend({}, speed) : {
            "complete": fn || !fn && easing || jQuery.isFunction(speed) && speed,
            "duration": speed,
            "easing": fn && easing || easing && !jQuery.isFunction(easing) && easing
        };
        opt.duration = jQuery.fx.off ? 0 : typeof opt.duration === "number" ? opt.duration : opt.duration in jQuery.fx.speeds ? jQuery.fx.speeds[opt.duration] : jQuery.fx.speeds._default;
        // normalize opt.queue - true/undefined/null -> "fx"
        if (opt.queue == null || opt.queue === true) {
            opt.queue = "fx";
        }
        // Queueing
        opt.old = opt.complete;
        opt.complete = function() {
            if (jQuery.isFunction(opt.old)) {
                opt.old.call(this);
            }
            if (opt.queue) {
                jQuery.dequeue(this, opt.queue);
            }
        };
        return opt;
    };
    jQuery.fn.extend({
        "fadeTo": function(speed, to, easing, callback) {
            // show any hidden elements after setting opacity to 0
            return this.filter(isHidden).css("opacity", 0).show().end().animate({
                "opacity": to
            }, speed, easing, callback);
        },
        "animate": function(prop, speed, easing, callback) {
            var empty = jQuery.isEmptyObject(prop), optall = jQuery.speed(speed, easing, callback), doAnimation = function() {
                // Operate on a copy of prop so per-property easing won't be lost
                var anim = Animation(this, jQuery.extend({}, prop), optall);
                // Empty animations, or finishing resolves immediately
                if (empty || data_priv.get(this, "finish")) {
                    anim.stop(true);
                }
            };
            doAnimation.finish = doAnimation;
            return empty || optall.queue === false ? this.each(doAnimation) : this.queue(optall.queue, doAnimation);
        },
        "stop": function(type, clearQueue, gotoEnd) {
            var stopQueue = function(hooks) {
                var stop = hooks.stop;
                delete hooks.stop;
                stop(gotoEnd);
            };
            if (typeof type !== "string") {
                gotoEnd = clearQueue;
                clearQueue = type;
                type = undefined;
            }
            if (clearQueue && type !== false) {
                this.queue(type || "fx", []);
            }
            return this.each(function() {
                var dequeue = true, index = type != null && type + "queueHooks", timers = jQuery.timers, data = data_priv.get(this);
                if (index) {
                    if (data[index] && data[index].stop) {
                        stopQueue(data[index]);
                    }
                } else {
                    for (index in data) {
                        if (data[index] && data[index].stop && rrun.test(index)) {
                            stopQueue(data[index]);
                        }
                    }
                }
                for (index = timers.length; index--; ) {
                    if (timers[index].elem === this && (type == null || timers[index].queue === type)) {
                        timers[index].anim.stop(gotoEnd);
                        dequeue = false;
                        timers.splice(index, 1);
                    }
                }
                // start the next in the queue if the last step wasn't forced
                // timers currently will call their complete callbacks, which will dequeue
                // but only if they were gotoEnd
                if (dequeue || !gotoEnd) {
                    jQuery.dequeue(this, type);
                }
            });
        },
        "finish": function(type) {
            if (type !== false) {
                type = type || "fx";
            }
            return this.each(function() {
                var index, data = data_priv.get(this), queue = data[type + "queue"], hooks = data[type + "queueHooks"], timers = jQuery.timers, length = queue ? queue.length : 0;
                // enable finishing flag on private data
                data.finish = true;
                // empty the queue first
                jQuery.queue(this, type, []);
                if (hooks && hooks.stop) {
                    hooks.stop.call(this, true);
                }
                // look for any active animations, and finish them
                for (index = timers.length; index--; ) {
                    if (timers[index].elem === this && timers[index].queue === type) {
                        timers[index].anim.stop(true);
                        timers.splice(index, 1);
                    }
                }
                // look for any animations in the old queue and finish them
                for (index = 0; index < length; index++) {
                    if (queue[index] && queue[index].finish) {
                        queue[index].finish.call(this);
                    }
                }
                // turn off finishing flag
                delete data.finish;
            });
        }
    });
    jQuery.each([ "toggle", "show", "hide" ], function(i, name) {
        var cssFn = jQuery.fn[name];
        jQuery.fn[name] = function(speed, easing, callback) {
            return speed == null || typeof speed === "boolean" ? cssFn.apply(this, arguments) : this.animate(genFx(name, true), speed, easing, callback);
        };
    });
    // Generate shortcuts for custom animations
    jQuery.each({
        "slideDown": genFx("show"),
        "slideUp": genFx("hide"),
        "slideToggle": genFx("toggle"),
        "fadeIn": {
            "opacity": "show"
        },
        "fadeOut": {
            "opacity": "hide"
        },
        "fadeToggle": {
            "opacity": "toggle"
        }
    }, function(name, props) {
        jQuery.fn[name] = function(speed, easing, callback) {
            return this.animate(props, speed, easing, callback);
        };
    });
    jQuery.timers = [];
    jQuery.fx.tick = function() {
        var timer, i = 0, timers = jQuery.timers;
        fxNow = jQuery.now();
        for (;i < timers.length; i++) {
            timer = timers[i];
            // Checks the timer has not already been removed
            if (!timer() && timers[i] === timer) {
                timers.splice(i--, 1);
            }
        }
        if (!timers.length) {
            jQuery.fx.stop();
        }
        fxNow = undefined;
    };
    jQuery.fx.timer = function(timer) {
        jQuery.timers.push(timer);
        if (timer()) {
            jQuery.fx.start();
        } else {
            jQuery.timers.pop();
        }
    };
    jQuery.fx.interval = 13;
    jQuery.fx.start = function() {
        if (!timerId) {
            timerId = setInterval(jQuery.fx.tick, jQuery.fx.interval);
        }
    };
    jQuery.fx.stop = function() {
        clearInterval(timerId);
        timerId = null;
    };
    jQuery.fx.speeds = {
        "slow": 600,
        "fast": 200,
        // Default speed
        "_default": 400
    };
    // Based off of the plugin by Clint Helfers, with permission.
    // http://blindsignals.com/index.php/2009/07/jquery-delay/
    jQuery.fn.delay = function(time, type) {
        time = jQuery.fx ? jQuery.fx.speeds[time] || time : time;
        type = type || "fx";
        return this.queue(type, function(next, hooks) {
            var timeout = setTimeout(next, time);
            hooks.stop = function() {
                clearTimeout(timeout);
            };
        });
    };
    (function() {
        var input = document.createElement("input"), select = document.createElement("select"), opt = select.appendChild(document.createElement("option"));
        input.type = "checkbox";
        // Support: iOS 5.1, Android 4.x, Android 2.3
        // Check the default checkbox/radio value ("" on old WebKit; "on" elsewhere)
        support.checkOn = input.value !== "";
        // Must access the parent to make an option select properly
        // Support: IE9, IE10
        support.optSelected = opt.selected;
        // Make sure that the options inside disabled selects aren't marked as disabled
        // (WebKit marks them as disabled)
        select.disabled = true;
        support.optDisabled = !opt.disabled;
        // Check if an input maintains its value after becoming a radio
        // Support: IE9, IE10
        input = document.createElement("input");
        input.value = "t";
        input.type = "radio";
        support.radioValue = input.value === "t";
    })();
    var nodeHook, boolHook, attrHandle = jQuery.expr.attrHandle;
    jQuery.fn.extend({
        "attr": function(name, value) {
            return access(this, jQuery.attr, name, value, arguments.length > 1);
        },
        "removeAttr": function(name) {
            return this.each(function() {
                jQuery.removeAttr(this, name);
            });
        }
    });
    jQuery.extend({
        "attr": function(elem, name, value) {
            var hooks, ret, nType = elem.nodeType;
            // don't get/set attributes on text, comment and attribute nodes
            if (!elem || nType === 3 || nType === 8 || nType === 2) {
                return;
            }
            // Fallback to prop when attributes are not supported
            if (typeof elem.getAttribute === strundefined) {
                return jQuery.prop(elem, name, value);
            }
            // All attributes are lowercase
            // Grab necessary hook if one is defined
            if (nType !== 1 || !jQuery.isXMLDoc(elem)) {
                name = name.toLowerCase();
                hooks = jQuery.attrHooks[name] || (jQuery.expr.match.bool.test(name) ? boolHook : nodeHook);
            }
            if (value !== undefined) {
                if (value === null) {
                    jQuery.removeAttr(elem, name);
                } else if (hooks && "set" in hooks && (ret = hooks.set(elem, value, name)) !== undefined) {
                    return ret;
                } else {
                    elem.setAttribute(name, value + "");
                    return value;
                }
            } else if (hooks && "get" in hooks && (ret = hooks.get(elem, name)) !== null) {
                return ret;
            } else {
                ret = jQuery.find.attr(elem, name);
                // Non-existent attributes return null, we normalize to undefined
                return ret == null ? undefined : ret;
            }
        },
        "removeAttr": function(elem, value) {
            var name, propName, i = 0, attrNames = value && value.match(rnotwhite);
            if (attrNames && elem.nodeType === 1) {
                while (name = attrNames[i++]) {
                    propName = jQuery.propFix[name] || name;
                    // Boolean attributes get special treatment (#10870)
                    if (jQuery.expr.match.bool.test(name)) {
                        // Set corresponding property to false
                        elem[propName] = false;
                    }
                    elem.removeAttribute(name);
                }
            }
        },
        "attrHooks": {
            "type": {
                "set": function(elem, value) {
                    if (!support.radioValue && value === "radio" && jQuery.nodeName(elem, "input")) {
                        // Setting the type on a radio button after the value resets the value in IE6-9
                        // Reset value to default in case type is set after value during creation
                        var val = elem.value;
                        elem.setAttribute("type", value);
                        if (val) {
                            elem.value = val;
                        }
                        return value;
                    }
                }
            }
        }
    });
    // Hooks for boolean attributes
    boolHook = {
        "set": function(elem, value, name) {
            if (value === false) {
                // Remove boolean attributes when set to false
                jQuery.removeAttr(elem, name);
            } else {
                elem.setAttribute(name, name);
            }
            return name;
        }
    };
    jQuery.each(jQuery.expr.match.bool.source.match(/\w+/g), function(i, name) {
        var getter = attrHandle[name] || jQuery.find.attr;
        attrHandle[name] = function(elem, name, isXML) {
            var ret, handle;
            if (!isXML) {
                // Avoid an infinite loop by temporarily removing this function from the getter
                handle = attrHandle[name];
                attrHandle[name] = ret;
                ret = getter(elem, name, isXML) != null ? name.toLowerCase() : null;
                attrHandle[name] = handle;
            }
            return ret;
        };
    });
    var rfocusable = /^(?:input|select|textarea|button)$/i;
    jQuery.fn.extend({
        "prop": function(name, value) {
            return access(this, jQuery.prop, name, value, arguments.length > 1);
        },
        "removeProp": function(name) {
            return this.each(function() {
                delete this[jQuery.propFix[name] || name];
            });
        }
    });
    jQuery.extend({
        "propFix": {
            "for": "htmlFor",
            "class": "className"
        },
        "prop": function(elem, name, value) {
            var ret, hooks, notxml, nType = elem.nodeType;
            // don't get/set properties on text, comment and attribute nodes
            if (!elem || nType === 3 || nType === 8 || nType === 2) {
                return;
            }
            notxml = nType !== 1 || !jQuery.isXMLDoc(elem);
            if (notxml) {
                // Fix name and attach hooks
                name = jQuery.propFix[name] || name;
                hooks = jQuery.propHooks[name];
            }
            if (value !== undefined) {
                return hooks && "set" in hooks && (ret = hooks.set(elem, value, name)) !== undefined ? ret : elem[name] = value;
            } else {
                return hooks && "get" in hooks && (ret = hooks.get(elem, name)) !== null ? ret : elem[name];
            }
        },
        "propHooks": {
            "tabIndex": {
                "get": function(elem) {
                    return elem.hasAttribute("tabindex") || rfocusable.test(elem.nodeName) || elem.href ? elem.tabIndex : -1;
                }
            }
        }
    });
    // Support: IE9+
    // Selectedness for an option in an optgroup can be inaccurate
    if (!support.optSelected) {
        jQuery.propHooks.selected = {
            "get": function(elem) {
                var parent = elem.parentNode;
                if (parent && parent.parentNode) {
                    parent.parentNode.selectedIndex;
                }
                return null;
            }
        };
    }
    jQuery.each([ "tabIndex", "readOnly", "maxLength", "cellSpacing", "cellPadding", "rowSpan", "colSpan", "useMap", "frameBorder", "contentEditable" ], function() {
        jQuery.propFix[this.toLowerCase()] = this;
    });
    var rclass = /[\t\r\n\f]/g;
    jQuery.fn.extend({
        "addClass": function(value) {
            var classes, elem, cur, clazz, j, finalValue, proceed = typeof value === "string" && value, i = 0, len = this.length;
            if (jQuery.isFunction(value)) {
                return this.each(function(j) {
                    jQuery(this).addClass(value.call(this, j, this.className));
                });
            }
            if (proceed) {
                // The disjunction here is for better compressibility (see removeClass)
                classes = (value || "").match(rnotwhite) || [];
                for (;i < len; i++) {
                    elem = this[i];
                    cur = elem.nodeType === 1 && (elem.className ? (" " + elem.className + " ").replace(rclass, " ") : " ");
                    if (cur) {
                        j = 0;
                        while (clazz = classes[j++]) {
                            if (cur.indexOf(" " + clazz + " ") < 0) {
                                cur += clazz + " ";
                            }
                        }
                        // only assign if different to avoid unneeded rendering.
                        finalValue = jQuery.trim(cur);
                        if (elem.className !== finalValue) {
                            elem.className = finalValue;
                        }
                    }
                }
            }
            return this;
        },
        "removeClass": function(value) {
            var classes, elem, cur, clazz, j, finalValue, proceed = arguments.length === 0 || typeof value === "string" && value, i = 0, len = this.length;
            if (jQuery.isFunction(value)) {
                return this.each(function(j) {
                    jQuery(this).removeClass(value.call(this, j, this.className));
                });
            }
            if (proceed) {
                classes = (value || "").match(rnotwhite) || [];
                for (;i < len; i++) {
                    elem = this[i];
                    // This expression is here for better compressibility (see addClass)
                    cur = elem.nodeType === 1 && (elem.className ? (" " + elem.className + " ").replace(rclass, " ") : "");
                    if (cur) {
                        j = 0;
                        while (clazz = classes[j++]) {
                            // Remove *all* instances
                            while (cur.indexOf(" " + clazz + " ") >= 0) {
                                cur = cur.replace(" " + clazz + " ", " ");
                            }
                        }
                        // only assign if different to avoid unneeded rendering.
                        finalValue = value ? jQuery.trim(cur) : "";
                        if (elem.className !== finalValue) {
                            elem.className = finalValue;
                        }
                    }
                }
            }
            return this;
        },
        "toggleClass": function(value, stateVal) {
            var type = typeof value;
            if (typeof stateVal === "boolean" && type === "string") {
                return stateVal ? this.addClass(value) : this.removeClass(value);
            }
            if (jQuery.isFunction(value)) {
                return this.each(function(i) {
                    jQuery(this).toggleClass(value.call(this, i, this.className, stateVal), stateVal);
                });
            }
            return this.each(function() {
                if (type === "string") {
                    // toggle individual class names
                    var className, i = 0, self = jQuery(this), classNames = value.match(rnotwhite) || [];
                    while (className = classNames[i++]) {
                        // check each className given, space separated list
                        if (self.hasClass(className)) {
                            self.removeClass(className);
                        } else {
                            self.addClass(className);
                        }
                    }
                } else if (type === strundefined || type === "boolean") {
                    if (this.className) {
                        // store className if set
                        data_priv.set(this, "__className__", this.className);
                    }
                    // If the element has a class name or if we're passed "false",
                    // then remove the whole classname (if there was one, the above saved it).
                    // Otherwise bring back whatever was previously saved (if anything),
                    // falling back to the empty string if nothing was stored.
                    this.className = this.className || value === false ? "" : data_priv.get(this, "__className__") || "";
                }
            });
        },
        "hasClass": function(selector) {
            var className = " " + selector + " ", i = 0, l = this.length;
            for (;i < l; i++) {
                if (this[i].nodeType === 1 && (" " + this[i].className + " ").replace(rclass, " ").indexOf(className) >= 0) {
                    return true;
                }
            }
            return false;
        }
    });
    var rreturn = /\r/g;
    jQuery.fn.extend({
        "val": function(value) {
            var hooks, ret, isFunction, elem = this[0];
            if (!arguments.length) {
                if (elem) {
                    hooks = jQuery.valHooks[elem.type] || jQuery.valHooks[elem.nodeName.toLowerCase()];
                    if (hooks && "get" in hooks && (ret = hooks.get(elem, "value")) !== undefined) {
                        return ret;
                    }
                    ret = elem.value;
                    // handle most common string cases
                    // handle cases where value is null/undef or number
                    return typeof ret === "string" ? ret.replace(rreturn, "") : ret == null ? "" : ret;
                }
                return;
            }
            isFunction = jQuery.isFunction(value);
            return this.each(function(i) {
                var val;
                if (this.nodeType !== 1) {
                    return;
                }
                if (isFunction) {
                    val = value.call(this, i, jQuery(this).val());
                } else {
                    val = value;
                }
                // Treat null/undefined as ""; convert numbers to string
                if (val == null) {
                    val = "";
                } else if (typeof val === "number") {
                    val += "";
                } else if (jQuery.isArray(val)) {
                    val = jQuery.map(val, function(value) {
                        return value == null ? "" : value + "";
                    });
                }
                hooks = jQuery.valHooks[this.type] || jQuery.valHooks[this.nodeName.toLowerCase()];
                // If set returns undefined, fall back to normal setting
                if (!hooks || !("set" in hooks) || hooks.set(this, val, "value") === undefined) {
                    this.value = val;
                }
            });
        }
    });
    jQuery.extend({
        "valHooks": {
            "select": {
                "get": function(elem) {
                    var value, option, options = elem.options, index = elem.selectedIndex, one = elem.type === "select-one" || index < 0, values = one ? null : [], max = one ? index + 1 : options.length, i = index < 0 ? max : one ? index : 0;
                    // Loop through all the selected options
                    for (;i < max; i++) {
                        option = options[i];
                        // IE6-9 doesn't update selected after form reset (#2551)
                        if ((option.selected || i === index) && (// Don't return options that are disabled or in a disabled optgroup
                        support.optDisabled ? !option.disabled : option.getAttribute("disabled") === null) && (!option.parentNode.disabled || !jQuery.nodeName(option.parentNode, "optgroup"))) {
                            // Get the specific value for the option
                            value = jQuery(option).val();
                            // We don't need an array for one selects
                            if (one) {
                                return value;
                            }
                            // Multi-Selects return an array
                            values.push(value);
                        }
                    }
                    return values;
                },
                "set": function(elem, value) {
                    var optionSet, option, options = elem.options, values = jQuery.makeArray(value), i = options.length;
                    while (i--) {
                        option = options[i];
                        if (option.selected = jQuery.inArray(jQuery(option).val(), values) >= 0) {
                            optionSet = true;
                        }
                    }
                    // force browsers to behave consistently when non-matching value is set
                    if (!optionSet) {
                        elem.selectedIndex = -1;
                    }
                    return values;
                }
            }
        }
    });
    // Radios and checkboxes getter/setter
    jQuery.each([ "radio", "checkbox" ], function() {
        jQuery.valHooks[this] = {
            "set": function(elem, value) {
                if (jQuery.isArray(value)) {
                    return elem.checked = jQuery.inArray(jQuery(elem).val(), value) >= 0;
                }
            }
        };
        if (!support.checkOn) {
            jQuery.valHooks[this].get = function(elem) {
                // Support: Webkit
                // "" is returned instead of "on" if a value isn't specified
                return elem.getAttribute("value") === null ? "on" : elem.value;
            };
        }
    });
    // Return jQuery for attributes-only inclusion
    jQuery.each(("blur focus focusin focusout load resize scroll unload click dblclick " + "mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave " + "change select submit keydown keypress keyup error contextmenu").split(" "), function(i, name) {
        // Handle event binding
        jQuery.fn[name] = function(data, fn) {
            return arguments.length > 0 ? this.on(name, null, data, fn) : this.trigger(name);
        };
    });
    jQuery.fn.extend({
        "hover": function(fnOver, fnOut) {
            return this.mouseenter(fnOver).mouseleave(fnOut || fnOver);
        },
        "bind": function(types, data, fn) {
            return this.on(types, null, data, fn);
        },
        "unbind": function(types, fn) {
            return this.off(types, null, fn);
        },
        "delegate": function(selector, types, data, fn) {
            return this.on(types, selector, data, fn);
        },
        "undelegate": function(selector, types, fn) {
            // ( namespace ) or ( selector, types [, fn] )
            return arguments.length === 1 ? this.off(selector, "**") : this.off(types, selector || "**", fn);
        }
    });
    var nonce = jQuery.now();
    var rquery = /\?/;
    // Support: Android 2.3
    // Workaround failure to string-cast null input
    jQuery.parseJSON = function(data) {
        return JSON.parse(data + "");
    };
    // Cross-browser xml parsing
    jQuery.parseXML = function(data) {
        var xml, tmp;
        if (!data || typeof data !== "string") {
            return null;
        }
        // Support: IE9
        try {
            tmp = new DOMParser();
            xml = tmp.parseFromString(data, "text/xml");
        } catch (e) {
            xml = undefined;
        }
        if (!xml || xml.getElementsByTagName("parsererror").length) {
            jQuery.error("Invalid XML: " + data);
        }
        return xml;
    };
    var // Document location
    ajaxLocParts, ajaxLocation, rhash = /#.*$/, rts = /([?&])_=[^&]*/, rheaders = /^(.*?):[ \t]*([^\r\n]*)$/gm, // #7653, #8125, #8152: local protocol detection
    rlocalProtocol = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/, rnoContent = /^(?:GET|HEAD)$/, rprotocol = /^\/\//, rurl = /^([\w.+-]+:)(?:\/\/(?:[^\/?#]*@|)([^\/?#:]*)(?::(\d+)|)|)/, /* Prefilters
   * 1) They are useful to introduce custom dataTypes (see ajax/jsonp.js for an example)
   * 2) These are called:
   *    - BEFORE asking for a transport
   *    - AFTER param serialization (s.data is a string if s.processData is true)
   * 3) key is the dataType
   * 4) the catchall symbol "*" can be used
   * 5) execution will start with transport dataType and THEN continue down to "*" if needed
   */
    prefilters = {}, /* Transports bindings
   * 1) key is the dataType
   * 2) the catchall symbol "*" can be used
   * 3) selection will start with transport dataType and THEN go to "*" if needed
   */
    transports = {}, // Avoid comment-prolog char sequence (#10098); must appease lint and evade compression
    allTypes = "*/".concat("*");
    // #8138, IE may throw an exception when accessing
    // a field from window.location if document.domain has been set
    try {
        ajaxLocation = location.href;
    } catch (e) {
        // Use the href attribute of an A element
        // since IE will modify it given document.location
        ajaxLocation = document.createElement("a");
        ajaxLocation.href = "";
        ajaxLocation = ajaxLocation.href;
    }
    // Segment location into parts
    ajaxLocParts = rurl.exec(ajaxLocation.toLowerCase()) || [];
    // Base "constructor" for jQuery.ajaxPrefilter and jQuery.ajaxTransport
    function addToPrefiltersOrTransports(structure) {
        // dataTypeExpression is optional and defaults to "*"
        return function(dataTypeExpression, func) {
            if (typeof dataTypeExpression !== "string") {
                func = dataTypeExpression;
                dataTypeExpression = "*";
            }
            var dataType, i = 0, dataTypes = dataTypeExpression.toLowerCase().match(rnotwhite) || [];
            if (jQuery.isFunction(func)) {
                // For each dataType in the dataTypeExpression
                while (dataType = dataTypes[i++]) {
                    // Prepend if requested
                    if (dataType[0] === "+") {
                        dataType = dataType.slice(1) || "*";
                        (structure[dataType] = structure[dataType] || []).unshift(func);
                    } else {
                        (structure[dataType] = structure[dataType] || []).push(func);
                    }
                }
            }
        };
    }
    // Base inspection function for prefilters and transports
    function inspectPrefiltersOrTransports(structure, options, originalOptions, jqXHR) {
        var inspected = {}, seekingTransport = structure === transports;
        function inspect(dataType) {
            var selected;
            inspected[dataType] = true;
            jQuery.each(structure[dataType] || [], function(_, prefilterOrFactory) {
                var dataTypeOrTransport = prefilterOrFactory(options, originalOptions, jqXHR);
                if (typeof dataTypeOrTransport === "string" && !seekingTransport && !inspected[dataTypeOrTransport]) {
                    options.dataTypes.unshift(dataTypeOrTransport);
                    inspect(dataTypeOrTransport);
                    return false;
                } else if (seekingTransport) {
                    return !(selected = dataTypeOrTransport);
                }
            });
            return selected;
        }
        return inspect(options.dataTypes[0]) || !inspected["*"] && inspect("*");
    }
    // A special extend for ajax options
    // that takes "flat" options (not to be deep extended)
    // Fixes #9887
    function ajaxExtend(target, src) {
        var key, deep, flatOptions = jQuery.ajaxSettings.flatOptions || {};
        for (key in src) {
            if (src[key] !== undefined) {
                (flatOptions[key] ? target : deep || (deep = {}))[key] = src[key];
            }
        }
        if (deep) {
            jQuery.extend(true, target, deep);
        }
        return target;
    }
    /* Handles responses to an ajax request:
   * - finds the right dataType (mediates between content-type and expected dataType)
   * - returns the corresponding response
   */
    function ajaxHandleResponses(s, jqXHR, responses) {
        var ct, type, finalDataType, firstDataType, contents = s.contents, dataTypes = s.dataTypes;
        // Remove auto dataType and get content-type in the process
        while (dataTypes[0] === "*") {
            dataTypes.shift();
            if (ct === undefined) {
                ct = s.mimeType || jqXHR.getResponseHeader("Content-Type");
            }
        }
        // Check if we're dealing with a known content-type
        if (ct) {
            for (type in contents) {
                if (contents[type] && contents[type].test(ct)) {
                    dataTypes.unshift(type);
                    break;
                }
            }
        }
        // Check to see if we have a response for the expected dataType
        if (dataTypes[0] in responses) {
            finalDataType = dataTypes[0];
        } else {
            // Try convertible dataTypes
            for (type in responses) {
                if (!dataTypes[0] || s.converters[type + " " + dataTypes[0]]) {
                    finalDataType = type;
                    break;
                }
                if (!firstDataType) {
                    firstDataType = type;
                }
            }
            // Or just use first one
            finalDataType = finalDataType || firstDataType;
        }
        // If we found a dataType
        // We add the dataType to the list if needed
        // and return the corresponding response
        if (finalDataType) {
            if (finalDataType !== dataTypes[0]) {
                dataTypes.unshift(finalDataType);
            }
            return responses[finalDataType];
        }
    }
    /* Chain conversions given the request and the original response
   * Also sets the responseXXX fields on the jqXHR instance
   */
    function ajaxConvert(s, response, jqXHR, isSuccess) {
        var conv2, current, conv, tmp, prev, converters = {}, // Work with a copy of dataTypes in case we need to modify it for conversion
        dataTypes = s.dataTypes.slice();
        // Create converters map with lowercased keys
        if (dataTypes[1]) {
            for (conv in s.converters) {
                converters[conv.toLowerCase()] = s.converters[conv];
            }
        }
        current = dataTypes.shift();
        // Convert to each sequential dataType
        while (current) {
            if (s.responseFields[current]) {
                jqXHR[s.responseFields[current]] = response;
            }
            // Apply the dataFilter if provided
            if (!prev && isSuccess && s.dataFilter) {
                response = s.dataFilter(response, s.dataType);
            }
            prev = current;
            current = dataTypes.shift();
            if (current) {
                // There's only work to do if current dataType is non-auto
                if (current === "*") {
                    current = prev;
                } else if (prev !== "*" && prev !== current) {
                    // Seek a direct converter
                    conv = converters[prev + " " + current] || converters["* " + current];
                    // If none found, seek a pair
                    if (!conv) {
                        for (conv2 in converters) {
                            // If conv2 outputs current
                            tmp = conv2.split(" ");
                            if (tmp[1] === current) {
                                // If prev can be converted to accepted input
                                conv = converters[prev + " " + tmp[0]] || converters["* " + tmp[0]];
                                if (conv) {
                                    // Condense equivalence converters
                                    if (conv === true) {
                                        conv = converters[conv2];
                                    } else if (converters[conv2] !== true) {
                                        current = tmp[0];
                                        dataTypes.unshift(tmp[1]);
                                    }
                                    break;
                                }
                            }
                        }
                    }
                    // Apply converter (if not an equivalence)
                    if (conv !== true) {
                        // Unless errors are allowed to bubble, catch and return them
                        if (conv && s["throws"]) {
                            response = conv(response);
                        } else {
                            try {
                                response = conv(response);
                            } catch (e) {
                                return {
                                    "state": "parsererror",
                                    "error": conv ? e : "No conversion from " + prev + " to " + current
                                };
                            }
                        }
                    }
                }
            }
        }
        return {
            "state": "success",
            "data": response
        };
    }
    jQuery.extend({
        // Counter for holding the number of active queries
        "active": 0,
        // Last-Modified header cache for next request
        "lastModified": {},
        "etag": {},
        "ajaxSettings": {
            "url": ajaxLocation,
            "type": "GET",
            "isLocal": rlocalProtocol.test(ajaxLocParts[1]),
            "global": true,
            "processData": true,
            "async": true,
            "contentType": "application/x-www-form-urlencoded; charset=UTF-8",
            /*
       timeout: 0,
       data: null,
       dataType: null,
       username: null,
       password: null,
       cache: null,
       throws: false,
       traditional: false,
       headers: {},
       */
            "accepts": {
                "*": allTypes,
                "text": "text/plain",
                "html": "text/html",
                "xml": "application/xml, text/xml",
                "json": "application/json, text/javascript"
            },
            "contents": {
                "xml": /xml/,
                "html": /html/,
                "json": /json/
            },
            "responseFields": {
                "xml": "responseXML",
                "text": "responseText",
                "json": "responseJSON"
            },
            // Data converters
            // Keys separate source (or catchall "*") and destination types with a single space
            "converters": {
                // Convert anything to text
                "* text": String,
                // Text to html (true = no transformation)
                "text html": true,
                // Evaluate text as a json expression
                "text json": jQuery.parseJSON,
                // Parse text as xml
                "text xml": jQuery.parseXML
            },
            // For options that shouldn't be deep extended:
            // you can add your own custom options here if
            // and when you create one that shouldn't be
            // deep extended (see ajaxExtend)
            "flatOptions": {
                "url": true,
                "context": true
            }
        },
        // Creates a full fledged settings object into target
        // with both ajaxSettings and settings fields.
        // If target is omitted, writes into ajaxSettings.
        "ajaxSetup": function(target, settings) {
            // Building a settings object
            // Extending ajaxSettings
            return settings ? ajaxExtend(ajaxExtend(target, jQuery.ajaxSettings), settings) : ajaxExtend(jQuery.ajaxSettings, target);
        },
        "ajaxPrefilter": addToPrefiltersOrTransports(prefilters),
        "ajaxTransport": addToPrefiltersOrTransports(transports),
        // Main method
        "ajax": function(url, options) {
            // If url is an object, simulate pre-1.5 signature
            if (typeof url === "object") {
                options = url;
                url = undefined;
            }
            // Force options to be an object
            options = options || {};
            var transport, // URL without anti-cache param
            cacheURL, // Response headers
            responseHeadersString, responseHeaders, // timeout handle
            timeoutTimer, // Cross-domain detection vars
            parts, // To know if global events are to be dispatched
            fireGlobals, // Loop variable
            i, // Create the final options object
            s = jQuery.ajaxSetup({}, options), // Callbacks context
            callbackContext = s.context || s, // Context for global events is callbackContext if it is a DOM node or jQuery collection
            globalEventContext = s.context && (callbackContext.nodeType || callbackContext.jquery) ? jQuery(callbackContext) : jQuery.event, // Deferreds
            deferred = jQuery.Deferred(), completeDeferred = jQuery.Callbacks("once memory"), // Status-dependent callbacks
            statusCode = s.statusCode || {}, // Headers (they are sent all at once)
            requestHeaders = {}, requestHeadersNames = {}, // The jqXHR state
            state = 0, // Default abort message
            strAbort = "canceled", // Fake xhr
            jqXHR = {
                "readyState": 0,
                // Builds headers hashtable if needed
                "getResponseHeader": function(key) {
                    var match;
                    if (state === 2) {
                        if (!responseHeaders) {
                            responseHeaders = {};
                            while (match = rheaders.exec(responseHeadersString)) {
                                responseHeaders[match[1].toLowerCase()] = match[2];
                            }
                        }
                        match = responseHeaders[key.toLowerCase()];
                    }
                    return match == null ? null : match;
                },
                // Raw string
                "getAllResponseHeaders": function() {
                    return state === 2 ? responseHeadersString : null;
                },
                // Caches the header
                "setRequestHeader": function(name, value) {
                    var lname = name.toLowerCase();
                    if (!state) {
                        name = requestHeadersNames[lname] = requestHeadersNames[lname] || name;
                        requestHeaders[name] = value;
                    }
                    return this;
                },
                // Overrides response content-type header
                "overrideMimeType": function(type) {
                    if (!state) {
                        s.mimeType = type;
                    }
                    return this;
                },
                // Status-dependent callbacks
                "statusCode": function(map) {
                    var code;
                    if (map) {
                        if (state < 2) {
                            for (code in map) {
                                // Lazy-add the new callback in a way that preserves old ones
                                statusCode[code] = [ statusCode[code], map[code] ];
                            }
                        } else {
                            // Execute the appropriate callbacks
                            jqXHR.always(map[jqXHR.status]);
                        }
                    }
                    return this;
                },
                // Cancel the request
                "abort": function(statusText) {
                    var finalText = statusText || strAbort;
                    if (transport) {
                        transport.abort(finalText);
                    }
                    done(0, finalText);
                    return this;
                }
            };
            // Attach deferreds
            deferred.promise(jqXHR).complete = completeDeferred.add;
            jqXHR.success = jqXHR.done;
            jqXHR.error = jqXHR.fail;
            // Remove hash character (#7531: and string promotion)
            // Add protocol if not provided (prefilters might expect it)
            // Handle falsy url in the settings object (#10093: consistency with old signature)
            // We also use the url parameter if available
            s.url = ((url || s.url || ajaxLocation) + "").replace(rhash, "").replace(rprotocol, ajaxLocParts[1] + "//");
            // Alias method option to type as per ticket #12004
            s.type = options.method || options.type || s.method || s.type;
            // Extract dataTypes list
            s.dataTypes = jQuery.trim(s.dataType || "*").toLowerCase().match(rnotwhite) || [ "" ];
            // A cross-domain request is in order when we have a protocol:host:port mismatch
            if (s.crossDomain == null) {
                parts = rurl.exec(s.url.toLowerCase());
                s.crossDomain = !!(parts && (parts[1] !== ajaxLocParts[1] || parts[2] !== ajaxLocParts[2] || (parts[3] || (parts[1] === "http:" ? "80" : "443")) !== (ajaxLocParts[3] || (ajaxLocParts[1] === "http:" ? "80" : "443"))));
            }
            // Convert data if not already a string
            if (s.data && s.processData && typeof s.data !== "string") {
                s.data = jQuery.param(s.data, s.traditional);
            }
            // Apply prefilters
            inspectPrefiltersOrTransports(prefilters, s, options, jqXHR);
            // If request was aborted inside a prefilter, stop there
            if (state === 2) {
                return jqXHR;
            }
            // We can fire global events as of now if asked to
            fireGlobals = s.global;
            // Watch for a new set of requests
            if (fireGlobals && jQuery.active++ === 0) {
                jQuery.event.trigger("ajaxStart");
            }
            // Uppercase the type
            s.type = s.type.toUpperCase();
            // Determine if request has content
            s.hasContent = !rnoContent.test(s.type);
            // Save the URL in case we're toying with the If-Modified-Since
            // and/or If-None-Match header later on
            cacheURL = s.url;
            // More options handling for requests with no content
            if (!s.hasContent) {
                // If data is available, append data to url
                if (s.data) {
                    cacheURL = s.url += (rquery.test(cacheURL) ? "&" : "?") + s.data;
                    // #9682: remove data so that it's not used in an eventual retry
                    delete s.data;
                }
                // Add anti-cache in url if needed
                if (s.cache === false) {
                    s.url = rts.test(cacheURL) ? // If there is already a '_' parameter, set its value
                    cacheURL.replace(rts, "$1_=" + nonce++) : // Otherwise add one to the end
                    cacheURL + (rquery.test(cacheURL) ? "&" : "?") + "_=" + nonce++;
                }
            }
            // Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
            if (s.ifModified) {
                if (jQuery.lastModified[cacheURL]) {
                    jqXHR.setRequestHeader("If-Modified-Since", jQuery.lastModified[cacheURL]);
                }
                if (jQuery.etag[cacheURL]) {
                    jqXHR.setRequestHeader("If-None-Match", jQuery.etag[cacheURL]);
                }
            }
            // Set the correct header, if data is being sent
            if (s.data && s.hasContent && s.contentType !== false || options.contentType) {
                jqXHR.setRequestHeader("Content-Type", s.contentType);
            }
            // Set the Accepts header for the server, depending on the dataType
            jqXHR.setRequestHeader("Accept", s.dataTypes[0] && s.accepts[s.dataTypes[0]] ? s.accepts[s.dataTypes[0]] + (s.dataTypes[0] !== "*" ? ", " + allTypes + "; q=0.01" : "") : s.accepts["*"]);
            // Check for headers option
            for (i in s.headers) {
                jqXHR.setRequestHeader(i, s.headers[i]);
            }
            // Allow custom headers/mimetypes and early abort
            if (s.beforeSend && (s.beforeSend.call(callbackContext, jqXHR, s) === false || state === 2)) {
                // Abort if not done already and return
                return jqXHR.abort();
            }
            // aborting is no longer a cancellation
            strAbort = "abort";
            // Install callbacks on deferreds
            for (i in {
                "success": 1,
                "error": 1,
                "complete": 1
            }) {
                jqXHR[i](s[i]);
            }
            // Get transport
            transport = inspectPrefiltersOrTransports(transports, s, options, jqXHR);
            // If no transport, we auto-abort
            if (!transport) {
                done(-1, "No Transport");
            } else {
                jqXHR.readyState = 1;
                // Send global event
                if (fireGlobals) {
                    globalEventContext.trigger("ajaxSend", [ jqXHR, s ]);
                }
                // Timeout
                if (s.async && s.timeout > 0) {
                    timeoutTimer = setTimeout(function() {
                        jqXHR.abort("timeout");
                    }, s.timeout);
                }
                try {
                    state = 1;
                    transport.send(requestHeaders, done);
                } catch (e) {
                    // Propagate exception as error if not done
                    if (state < 2) {
                        done(-1, e);
                    } else {
                        throw e;
                    }
                }
            }
            // Callback for when everything is done
            function done(status, nativeStatusText, responses, headers) {
                var isSuccess, success, error, response, modified, statusText = nativeStatusText;
                // Called once
                if (state === 2) {
                    return;
                }
                // State is "done" now
                state = 2;
                // Clear timeout if it exists
                if (timeoutTimer) {
                    clearTimeout(timeoutTimer);
                }
                // Dereference transport for early garbage collection
                // (no matter how long the jqXHR object will be used)
                transport = undefined;
                // Cache response headers
                responseHeadersString = headers || "";
                // Set readyState
                jqXHR.readyState = status > 0 ? 4 : 0;
                // Determine if successful
                isSuccess = status >= 200 && status < 300 || status === 304;
                // Get response data
                if (responses) {
                    response = ajaxHandleResponses(s, jqXHR, responses);
                }
                // Convert no matter what (that way responseXXX fields are always set)
                response = ajaxConvert(s, response, jqXHR, isSuccess);
                // If successful, handle type chaining
                if (isSuccess) {
                    // Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
                    if (s.ifModified) {
                        modified = jqXHR.getResponseHeader("Last-Modified");
                        if (modified) {
                            jQuery.lastModified[cacheURL] = modified;
                        }
                        modified = jqXHR.getResponseHeader("etag");
                        if (modified) {
                            jQuery.etag[cacheURL] = modified;
                        }
                    }
                    // if no content
                    if (status === 204 || s.type === "HEAD") {
                        statusText = "nocontent";
                    } else if (status === 304) {
                        statusText = "notmodified";
                    } else {
                        statusText = response.state;
                        success = response.data;
                        error = response.error;
                        isSuccess = !error;
                    }
                } else {
                    // We extract error from statusText
                    // then normalize statusText and status for non-aborts
                    error = statusText;
                    if (status || !statusText) {
                        statusText = "error";
                        if (status < 0) {
                            status = 0;
                        }
                    }
                }
                // Set data for the fake xhr object
                jqXHR.status = status;
                jqXHR.statusText = (nativeStatusText || statusText) + "";
                // Success/Error
                if (isSuccess) {
                    deferred.resolveWith(callbackContext, [ success, statusText, jqXHR ]);
                } else {
                    deferred.rejectWith(callbackContext, [ jqXHR, statusText, error ]);
                }
                // Status-dependent callbacks
                jqXHR.statusCode(statusCode);
                statusCode = undefined;
                if (fireGlobals) {
                    globalEventContext.trigger(isSuccess ? "ajaxSuccess" : "ajaxError", [ jqXHR, s, isSuccess ? success : error ]);
                }
                // Complete
                completeDeferred.fireWith(callbackContext, [ jqXHR, statusText ]);
                if (fireGlobals) {
                    globalEventContext.trigger("ajaxComplete", [ jqXHR, s ]);
                    // Handle the global AJAX counter
                    if (!--jQuery.active) {
                        jQuery.event.trigger("ajaxStop");
                    }
                }
            }
            return jqXHR;
        },
        "getJSON": function(url, data, callback) {
            return jQuery.get(url, data, callback, "json");
        },
        "getScript": function(url, callback) {
            return jQuery.get(url, undefined, callback, "script");
        }
    });
    jQuery.each([ "get", "post" ], function(i, method) {
        jQuery[method] = function(url, data, callback, type) {
            // shift arguments if data argument was omitted
            if (jQuery.isFunction(data)) {
                type = type || callback;
                callback = data;
                data = undefined;
            }
            return jQuery.ajax({
                "url": url,
                "type": method,
                "dataType": type,
                "data": data,
                "success": callback
            });
        };
    });
    // Attach a bunch of functions for handling common AJAX events
    jQuery.each([ "ajaxStart", "ajaxStop", "ajaxComplete", "ajaxError", "ajaxSuccess", "ajaxSend" ], function(i, type) {
        jQuery.fn[type] = function(fn) {
            return this.on(type, fn);
        };
    });
    jQuery._evalUrl = function(url) {
        return jQuery.ajax({
            "url": url,
            "type": "GET",
            "dataType": "script",
            "async": false,
            "global": false,
            "throws": true
        });
    };
    jQuery.fn.extend({
        "wrapAll": function(html) {
            var wrap;
            if (jQuery.isFunction(html)) {
                return this.each(function(i) {
                    jQuery(this).wrapAll(html.call(this, i));
                });
            }
            if (this[0]) {
                // The elements to wrap the target around
                wrap = jQuery(html, this[0].ownerDocument).eq(0).clone(true);
                if (this[0].parentNode) {
                    wrap.insertBefore(this[0]);
                }
                wrap.map(function() {
                    var elem = this;
                    while (elem.firstElementChild) {
                        elem = elem.firstElementChild;
                    }
                    return elem;
                }).append(this);
            }
            return this;
        },
        "wrapInner": function(html) {
            if (jQuery.isFunction(html)) {
                return this.each(function(i) {
                    jQuery(this).wrapInner(html.call(this, i));
                });
            }
            return this.each(function() {
                var self = jQuery(this), contents = self.contents();
                if (contents.length) {
                    contents.wrapAll(html);
                } else {
                    self.append(html);
                }
            });
        },
        "wrap": function(html) {
            var isFunction = jQuery.isFunction(html);
            return this.each(function(i) {
                jQuery(this).wrapAll(isFunction ? html.call(this, i) : html);
            });
        },
        "unwrap": function() {
            return this.parent().each(function() {
                if (!jQuery.nodeName(this, "body")) {
                    jQuery(this).replaceWith(this.childNodes);
                }
            }).end();
        }
    });
    jQuery.expr.filters.hidden = function(elem) {
        // Support: Opera <= 12.12
        // Opera reports offsetWidths and offsetHeights less than zero on some elements
        return elem.offsetWidth <= 0 && elem.offsetHeight <= 0;
    };
    jQuery.expr.filters.visible = function(elem) {
        return !jQuery.expr.filters.hidden(elem);
    };
    var r20 = /%20/g, rbracket = /\[\]$/, rCRLF = /\r?\n/g, rsubmitterTypes = /^(?:submit|button|image|reset|file)$/i, rsubmittable = /^(?:input|select|textarea|keygen)/i;
    function buildParams(prefix, obj, traditional, add) {
        var name;
        if (jQuery.isArray(obj)) {
            // Serialize array item.
            jQuery.each(obj, function(i, v) {
                if (traditional || rbracket.test(prefix)) {
                    // Treat each array item as a scalar.
                    add(prefix, v);
                } else {
                    // Item is non-scalar (array or object), encode its numeric index.
                    buildParams(prefix + "[" + (typeof v === "object" ? i : "") + "]", v, traditional, add);
                }
            });
        } else if (!traditional && jQuery.type(obj) === "object") {
            // Serialize object item.
            for (name in obj) {
                buildParams(prefix + "[" + name + "]", obj[name], traditional, add);
            }
        } else {
            // Serialize scalar item.
            add(prefix, obj);
        }
    }
    // Serialize an array of form elements or a set of
    // key/values into a query string
    jQuery.param = function(a, traditional) {
        var prefix, s = [], add = function(key, value) {
            // If value is a function, invoke it and return its value
            value = jQuery.isFunction(value) ? value() : value == null ? "" : value;
            s[s.length] = encodeURIComponent(key) + "=" + encodeURIComponent(value);
        };
        // Set traditional to true for jQuery <= 1.3.2 behavior.
        if (traditional === undefined) {
            traditional = jQuery.ajaxSettings && jQuery.ajaxSettings.traditional;
        }
        // If an array was passed in, assume that it is an array of form elements.
        if (jQuery.isArray(a) || a.jquery && !jQuery.isPlainObject(a)) {
            // Serialize the form elements
            jQuery.each(a, function() {
                add(this.name, this.value);
            });
        } else {
            // If traditional, encode the "old" way (the way 1.3.2 or older
            // did it), otherwise encode params recursively.
            for (prefix in a) {
                buildParams(prefix, a[prefix], traditional, add);
            }
        }
        // Return the resulting serialization
        return s.join("&").replace(r20, "+");
    };
    jQuery.fn.extend({
        "serialize": function() {
            return jQuery.param(this.serializeArray());
        },
        "serializeArray": function() {
            return this.map(function() {
                // Can add propHook for "elements" to filter or add form elements
                var elements = jQuery.prop(this, "elements");
                return elements ? jQuery.makeArray(elements) : this;
            }).filter(function() {
                var type = this.type;
                // Use .is( ":disabled" ) so that fieldset[disabled] works
                return this.name && !jQuery(this).is(":disabled") && rsubmittable.test(this.nodeName) && !rsubmitterTypes.test(type) && (this.checked || !rcheckableType.test(type));
            }).map(function(i, elem) {
                var val = jQuery(this).val();
                return val == null ? null : jQuery.isArray(val) ? jQuery.map(val, function(val) {
                    return {
                        "name": elem.name,
                        "value": val.replace(rCRLF, "\r\n")
                    };
                }) : {
                    "name": elem.name,
                    "value": val.replace(rCRLF, "\r\n")
                };
            }).get();
        }
    });
    jQuery.ajaxSettings.xhr = function() {
        try {
            return new XMLHttpRequest();
        } catch (e) {}
    };
    var xhrId = 0, xhrCallbacks = {}, xhrSuccessStatus = {
        // file protocol always yields status code 0, assume 200
        "0": 200,
        // Support: IE9
        // #1450: sometimes IE returns 1223 when it should be 204
        "1223": 204
    }, xhrSupported = jQuery.ajaxSettings.xhr();
    // Support: IE9
    // Open requests must be manually aborted on unload (#5280)
    if (window.ActiveXObject) {
        jQuery(window).on("unload", function() {
            for (var key in xhrCallbacks) {
                xhrCallbacks[key]();
            }
        });
    }
    support.cors = !!xhrSupported && "withCredentials" in xhrSupported;
    support.ajax = xhrSupported = !!xhrSupported;
    jQuery.ajaxTransport(function(options) {
        var callback;
        // Cross domain only allowed if supported through XMLHttpRequest
        if (support.cors || xhrSupported && !options.crossDomain) {
            return {
                "send": function(headers, complete) {
                    var i, xhr = options.xhr(), id = ++xhrId;
                    xhr.open(options.type, options.url, options.async, options.username, options.password);
                    // Apply custom fields if provided
                    if (options.xhrFields) {
                        for (i in options.xhrFields) {
                            xhr[i] = options.xhrFields[i];
                        }
                    }
                    // Override mime type if needed
                    if (options.mimeType && xhr.overrideMimeType) {
                        xhr.overrideMimeType(options.mimeType);
                    }
                    // X-Requested-With header
                    // For cross-domain requests, seeing as conditions for a preflight are
                    // akin to a jigsaw puzzle, we simply never set it to be sure.
                    // (it can always be set on a per-request basis or even using ajaxSetup)
                    // For same-domain requests, won't change header if already provided.
                    if (!options.crossDomain && !headers["X-Requested-With"]) {
                        headers["X-Requested-With"] = "XMLHttpRequest";
                    }
                    // Set headers
                    for (i in headers) {
                        xhr.setRequestHeader(i, headers[i]);
                    }
                    // Callback
                    callback = function(type) {
                        return function() {
                            if (callback) {
                                delete xhrCallbacks[id];
                                callback = xhr.onload = xhr.onerror = null;
                                if (type === "abort") {
                                    xhr.abort();
                                } else if (type === "error") {
                                    complete(// file: protocol always yields status 0; see #8605, #14207
                                    xhr.status, xhr.statusText);
                                } else {
                                    complete(xhrSuccessStatus[xhr.status] || xhr.status, xhr.statusText, // Support: IE9
                                    // Accessing binary-data responseText throws an exception
                                    // (#11426)
                                    typeof xhr.responseText === "string" ? {
                                        "text": xhr.responseText
                                    } : undefined, xhr.getAllResponseHeaders());
                                }
                            }
                        };
                    };
                    // Listen to events
                    xhr.onload = callback();
                    xhr.onerror = callback("error");
                    // Create the abort callback
                    callback = xhrCallbacks[id] = callback("abort");
                    // Do send the request
                    // This may raise an exception which is actually
                    // handled in jQuery.ajax (so no try/catch here)
                    xhr.send(options.hasContent && options.data || null);
                },
                "abort": function() {
                    if (callback) {
                        callback();
                    }
                }
            };
        }
    });
    // Install script dataType
    jQuery.ajaxSetup({
        "accepts": {
            "script": "text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"
        },
        "contents": {
            "script": /(?:java|ecma)script/
        },
        "converters": {
            "text script": function(text) {
                jQuery.globalEval(text);
                return text;
            }
        }
    });
    // Handle cache's special case and crossDomain
    jQuery.ajaxPrefilter("script", function(s) {
        if (s.cache === undefined) {
            s.cache = false;
        }
        if (s.crossDomain) {
            s.type = "GET";
        }
    });
    // Bind script tag hack transport
    jQuery.ajaxTransport("script", function(s) {
        // This transport only deals with cross domain requests
        if (s.crossDomain) {
            var script, callback;
            return {
                "send": function(_, complete) {
                    script = jQuery("<script>").prop({
                        "async": true,
                        "charset": s.scriptCharset,
                        "src": s.url
                    }).on("load error", callback = function(evt) {
                        script.remove();
                        callback = null;
                        if (evt) {
                            complete(evt.type === "error" ? 404 : 200, evt.type);
                        }
                    });
                    document.head.appendChild(script[0]);
                },
                "abort": function() {
                    if (callback) {
                        callback();
                    }
                }
            };
        }
    });
    var oldCallbacks = [], rjsonp = /(=)\?(?=&|$)|\?\?/;
    // Default jsonp settings
    jQuery.ajaxSetup({
        "jsonp": "callback",
        "jsonpCallback": function() {
            var callback = oldCallbacks.pop() || jQuery.expando + "_" + nonce++;
            this[callback] = true;
            return callback;
        }
    });
    // Detect, normalize options and install callbacks for jsonp requests
    jQuery.ajaxPrefilter("json jsonp", function(s, originalSettings, jqXHR) {
        var callbackName, overwritten, responseContainer, jsonProp = s.jsonp !== false && (rjsonp.test(s.url) ? "url" : typeof s.data === "string" && !(s.contentType || "").indexOf("application/x-www-form-urlencoded") && rjsonp.test(s.data) && "data");
        // Handle iff the expected data type is "jsonp" or we have a parameter to set
        if (jsonProp || s.dataTypes[0] === "jsonp") {
            // Get callback name, remembering preexisting value associated with it
            callbackName = s.jsonpCallback = jQuery.isFunction(s.jsonpCallback) ? s.jsonpCallback() : s.jsonpCallback;
            // Insert callback into url or form data
            if (jsonProp) {
                s[jsonProp] = s[jsonProp].replace(rjsonp, "$1" + callbackName);
            } else if (s.jsonp !== false) {
                s.url += (rquery.test(s.url) ? "&" : "?") + s.jsonp + "=" + callbackName;
            }
            // Use data converter to retrieve json after script execution
            s.converters["script json"] = function() {
                if (!responseContainer) {
                    jQuery.error(callbackName + " was not called");
                }
                return responseContainer[0];
            };
            // force json dataType
            s.dataTypes[0] = "json";
            // Install callback
            overwritten = window[callbackName];
            window[callbackName] = function() {
                responseContainer = arguments;
            };
            // Clean-up function (fires after converters)
            jqXHR.always(function() {
                // Restore preexisting value
                window[callbackName] = overwritten;
                // Save back as free
                if (s[callbackName]) {
                    // make sure that re-using the options doesn't screw things around
                    s.jsonpCallback = originalSettings.jsonpCallback;
                    // save the callback name for future use
                    oldCallbacks.push(callbackName);
                }
                // Call if it was a function and we have a response
                if (responseContainer && jQuery.isFunction(overwritten)) {
                    overwritten(responseContainer[0]);
                }
                responseContainer = overwritten = undefined;
            });
            // Delegate to script
            return "script";
        }
    });
    // data: string of html
    // context (optional): If specified, the fragment will be created in this context, defaults to document
    // keepScripts (optional): If true, will include scripts passed in the html string
    jQuery.parseHTML = function(data, context, keepScripts) {
        if (!data || typeof data !== "string") {
            return null;
        }
        if (typeof context === "boolean") {
            keepScripts = context;
            context = false;
        }
        context = context || document;
        var parsed = rsingleTag.exec(data), scripts = !keepScripts && [];
        // Single tag
        if (parsed) {
            return [ context.createElement(parsed[1]) ];
        }
        parsed = jQuery.buildFragment([ data ], context, scripts);
        if (scripts && scripts.length) {
            jQuery(scripts).remove();
        }
        return jQuery.merge([], parsed.childNodes);
    };
    // Keep a copy of the old load method
    var _load = jQuery.fn.load;
    /**
   * Load a url into a page
   */
    jQuery.fn.load = function(url, params, callback) {
        if (typeof url !== "string" && _load) {
            return _load.apply(this, arguments);
        }
        var selector, type, response, self = this, off = url.indexOf(" ");
        if (off >= 0) {
            selector = url.slice(off);
            url = url.slice(0, off);
        }
        // If it's a function
        if (jQuery.isFunction(params)) {
            // We assume that it's the callback
            callback = params;
            params = undefined;
        } else if (params && typeof params === "object") {
            type = "POST";
        }
        // If we have elements to modify, make the request
        if (self.length > 0) {
            jQuery.ajax({
                "url": url,
                // if "type" variable is undefined, then "GET" method will be used
                "type": type,
                "dataType": "html",
                "data": params
            }).done(function(responseText) {
                // Save response for use in complete callback
                response = arguments;
                self.html(selector ? // If a selector was specified, locate the right elements in a dummy div
                // Exclude scripts to avoid IE 'Permission Denied' errors
                jQuery("<div>").append(jQuery.parseHTML(responseText)).find(selector) : // Otherwise use the full result
                responseText);
            }).complete(callback && function(jqXHR, status) {
                self.each(callback, response || [ jqXHR.responseText, status, jqXHR ]);
            });
        }
        return this;
    };
    jQuery.expr.filters.animated = function(elem) {
        return jQuery.grep(jQuery.timers, function(fn) {
            return elem === fn.elem;
        }).length;
    };
    var docElem = window.document.documentElement;
    /**
   * Gets a window from an element
   */
    function getWindow(elem) {
        return jQuery.isWindow(elem) ? elem : elem.nodeType === 9 && elem.defaultView;
    }
    jQuery.offset = {
        "setOffset": function(elem, options, i) {
            var curPosition, curLeft, curCSSTop, curTop, curOffset, curCSSLeft, calculatePosition, position = jQuery.css(elem, "position"), curElem = jQuery(elem), props = {};
            // Set position first, in-case top/left are set even on static elem
            if (position === "static") {
                elem.style.position = "relative";
            }
            curOffset = curElem.offset();
            curCSSTop = jQuery.css(elem, "top");
            curCSSLeft = jQuery.css(elem, "left");
            calculatePosition = (position === "absolute" || position === "fixed") && (curCSSTop + curCSSLeft).indexOf("auto") > -1;
            // Need to be able to calculate position if either top or left is auto and position is either absolute or fixed
            if (calculatePosition) {
                curPosition = curElem.position();
                curTop = curPosition.top;
                curLeft = curPosition.left;
            } else {
                curTop = parseFloat(curCSSTop) || 0;
                curLeft = parseFloat(curCSSLeft) || 0;
            }
            if (jQuery.isFunction(options)) {
                options = options.call(elem, i, curOffset);
            }
            if (options.top != null) {
                props.top = options.top - curOffset.top + curTop;
            }
            if (options.left != null) {
                props.left = options.left - curOffset.left + curLeft;
            }
            if ("using" in options) {
                options.using.call(elem, props);
            } else {
                curElem.css(props);
            }
        }
    };
    jQuery.fn.extend({
        "offset": function(options) {
            if (arguments.length) {
                return options === undefined ? this : this.each(function(i) {
                    jQuery.offset.setOffset(this, options, i);
                });
            }
            var docElem, win, elem = this[0], box = {
                "top": 0,
                "left": 0
            }, doc = elem && elem.ownerDocument;
            if (!doc) {
                return;
            }
            docElem = doc.documentElement;
            // Make sure it's not a disconnected DOM node
            if (!jQuery.contains(docElem, elem)) {
                return box;
            }
            // If we don't have gBCR, just use 0,0 rather than error
            // BlackBerry 5, iOS 3 (original iPhone)
            if (typeof elem.getBoundingClientRect !== strundefined) {
                box = elem.getBoundingClientRect();
            }
            win = getWindow(doc);
            return {
                "top": box.top + win.pageYOffset - docElem.clientTop,
                "left": box.left + win.pageXOffset - docElem.clientLeft
            };
        },
        "position": function() {
            if (!this[0]) {
                return;
            }
            var offsetParent, offset, elem = this[0], parentOffset = {
                "top": 0,
                "left": 0
            };
            // Fixed elements are offset from window (parentOffset = {top:0, left: 0}, because it is its only offset parent
            if (jQuery.css(elem, "position") === "fixed") {
                // We assume that getBoundingClientRect is available when computed position is fixed
                offset = elem.getBoundingClientRect();
            } else {
                // Get *real* offsetParent
                offsetParent = this.offsetParent();
                // Get correct offsets
                offset = this.offset();
                if (!jQuery.nodeName(offsetParent[0], "html")) {
                    parentOffset = offsetParent.offset();
                }
                // Add offsetParent borders
                parentOffset.top += jQuery.css(offsetParent[0], "borderTopWidth", true);
                parentOffset.left += jQuery.css(offsetParent[0], "borderLeftWidth", true);
            }
            // Subtract parent offsets and element margins
            return {
                "top": offset.top - parentOffset.top - jQuery.css(elem, "marginTop", true),
                "left": offset.left - parentOffset.left - jQuery.css(elem, "marginLeft", true)
            };
        },
        "offsetParent": function() {
            return this.map(function() {
                var offsetParent = this.offsetParent || docElem;
                while (offsetParent && (!jQuery.nodeName(offsetParent, "html") && jQuery.css(offsetParent, "position") === "static")) {
                    offsetParent = offsetParent.offsetParent;
                }
                return offsetParent || docElem;
            });
        }
    });
    // Create scrollLeft and scrollTop methods
    jQuery.each({
        "scrollLeft": "pageXOffset",
        "scrollTop": "pageYOffset"
    }, function(method, prop) {
        var top = "pageYOffset" === prop;
        jQuery.fn[method] = function(val) {
            return access(this, function(elem, method, val) {
                var win = getWindow(elem);
                if (val === undefined) {
                    return win ? win[prop] : elem[method];
                }
                if (win) {
                    win.scrollTo(!top ? val : window.pageXOffset, top ? val : window.pageYOffset);
                } else {
                    elem[method] = val;
                }
            }, method, val, arguments.length, null);
        };
    });
    // Add the top/left cssHooks using jQuery.fn.position
    // Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084
    // getComputedStyle returns percent when specified for top/left/bottom/right
    // rather than make the css module depend on the offset module, we just check for it here
    jQuery.each([ "top", "left" ], function(i, prop) {
        jQuery.cssHooks[prop] = addGetHookIf(support.pixelPosition, function(elem, computed) {
            if (computed) {
                computed = curCSS(elem, prop);
                // if curCSS returns percentage, fallback to offset
                return rnumnonpx.test(computed) ? jQuery(elem).position()[prop] + "px" : computed;
            }
        });
    });
    // Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods
    jQuery.each({
        "Height": "height",
        "Width": "width"
    }, function(name, type) {
        jQuery.each({
            "padding": "inner" + name,
            "content": type,
            "": "outer" + name
        }, function(defaultExtra, funcName) {
            // margin is only for outerHeight, outerWidth
            jQuery.fn[funcName] = function(margin, value) {
                var chainable = arguments.length && (defaultExtra || typeof margin !== "boolean"), extra = defaultExtra || (margin === true || value === true ? "margin" : "border");
                return access(this, function(elem, type, value) {
                    var doc;
                    if (jQuery.isWindow(elem)) {
                        // As of 5/8/2012 this will yield incorrect results for Mobile Safari, but there
                        // isn't a whole lot we can do. See pull request at this URL for discussion:
                        // https://github.com/jquery/jquery/pull/764
                        return elem.document.documentElement["client" + name];
                    }
                    // Get document width or height
                    if (elem.nodeType === 9) {
                        doc = elem.documentElement;
                        // Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height],
                        // whichever is greatest
                        return Math.max(elem.body["scroll" + name], doc["scroll" + name], elem.body["offset" + name], doc["offset" + name], doc["client" + name]);
                    }
                    // Get width or height on the element, requesting but not forcing parseFloat
                    // Set width or height on the element
                    return value === undefined ? jQuery.css(elem, type, extra) : jQuery.style(elem, type, value, extra);
                }, type, chainable ? margin : undefined, chainable, null);
            };
        });
    });
    // The number of elements contained in the matched element set
    jQuery.fn.size = function() {
        return this.length;
    };
    jQuery.fn.andSelf = jQuery.fn.addBack;
    // Register as a named AMD module, since jQuery can be concatenated with other
    // files that may use define, but not via a proper concatenation script that
    // understands anonymous AMD modules. A named AMD is safest and most robust
    // way to register. Lowercase jquery is used because AMD module names are
    // derived from file names, and jQuery is normally delivered in a lowercase
    // file name. Do this after creating the global so that if an AMD module wants
    // to call noConflict to hide this version of jQuery, it will work.
    if (typeof define === "function") {
        define("/lib/jquery", function() {
            return jQuery;
        });
    }
    var // Map over jQuery in case of overwrite
    _jQuery = window.jQuery, // Map over the $ in case of overwrite
    _$ = window.$;
    jQuery.noConflict = function(deep) {
        if (window.$ === jQuery) {
            window.$ = _$;
        }
        if (deep && window.jQuery === jQuery) {
            window.jQuery = _jQuery;
        }
        return jQuery;
    };
    // Expose jQuery and $ identifiers, even in
    // AMD (#7102#comment:10, https://github.com/jquery/jquery/pull/557)
    // and CommonJS for browser emulators (#13566)
    if (typeof noGlobal === strundefined) {
        window.jQuery = window.$ = jQuery;
    }
    return jQuery;
});/**
 * @date 12-2-13
 * @describe: 实现简单的观察者模式（事件） 具备以下功能：
 * 1. 基本的观察者模式
 * 2. 可方便的移除某个通知
 * 3. 可控制通知观察者的顺序
 * 4. 异步
 * @author: wulj
 * @version: 1.0
 */
(function(window) {
    var KEvent = function() {
        this.mudules = {};
        this.listeners = {};
    };
    var handleTypeAndNs = function(typeAndNs) {
        var type = typeAndNs.split(".");
        var tns = {};
        tns.etype = type[0];
        if (type.length === 2) {
            tns.ns = type[1];
        }
        return tns;
    };
    var eidx = 0;
    KEvent.prototype = {
        "constructor": KEvent,
        /**
         * on('pageLoad.indexPage',function(){});
         * @param type      观察类型
         * @param listener  观察者
         */
        "on": function(type, listener) {
            var tns = handleTypeAndNs(type);
            //将类型和命名空间分割开
            var etype = tns.etype, ns = tns.ns;
            if (typeof this.listeners[etype] === "undefined") {
                this.listeners[etype] = {};
            }
            this.listeners[etype]["__eidx_" + eidx] = listener;
            listener.eidx = "__eidx_" + eidx;
            if (ns !== undefined) {
                //相同命名空间下的 listener 的索引，放到以 ns为 key 的数组中
                if (typeof this.mudules[ns] === "undefined") {
                    this.mudules[ns] = [];
                }
                this.mudules[ns].push("__eidx_" + eidx);
            }
            eidx++;
        },
        /**
         * 解除以下通知
         * @param type
         * @param listener
         */
        "un": function(type, listener) {
            if (typeof type === "undefined") {
                this.listeners = {};
                this.mudules = {};
                return;
            }
            var tns = handleTypeAndNs(type);
            var etype = tns.etype, ns = tns.ns;
            if (this.listeners[etype] !== undefined) {
                var listeners = this.listeners[etype];
                var listenerIdxInNs = this.mudules[ns];
                for (var i = 0, len = listenerIdxInNs.length; i < len; i++) {
                    listeners[listenerIdxInNs[i]] = null;
                }
                if (!!listener && !!listener.eidx) {
                    listeners[listener.eidx] = null;
                }
            }
        },
        /**
         * 触发事件
         * @param event
         */
        "fire": function(event) {
            if (typeof event === "string") {
                event = {
                    "type": event
                };
            }
            if (!event.target) {
                event.target = this;
            }
            if (!event.type) {
                throw new Error("Event Object missing type property");
            }
            if (this.listeners[event.type] !== null) {
                var listeners = this.listeners[event.type];
                for (var idx in listeners) {
                    if (listeners.hasOwnProperty(idx) && listeners[idx] !== null) {
                        listeners[idx].apply(this, Array.prototype.slice.call(arguments, 1));
                    }
                }
            }
        }
    };
    var ke = function(id) {
        /**
         * 创建一个ID号为{id}的事件对象
         * @param id 事件对象的id
         */
        if (typeof KEvent[id] === "undefined") {
            KEvent[id] = new KEvent(id);
        }
        return KEvent[id];
    };
    if (typeof module !== "undefined" && module.exports !== "undefined") {
        module.exports = ke;
    } else if (typeof define === "function") {
        define("/src/scripts/utils/event/kEvent", function() {
            return ke;
        });
    }
    window.ke = ke;
})(this);/**
 * 回到顶部
 * @author: yuanzhen
 */
define("/src/scripts/utils/component/goTop", function(require, exports, module) {
    var $ = require("/lib/jquery"), goTopNav = $(".js-go-start-top"), scrollTop = 0;
    /**
   *  初始化
   */
    module.exports = function() {
        $("body").delegate(".js-go-top", "click", function(e) {
            $("#results-content").scrollTop(0);
            $("#startContent").scrollTop(0);
            e.preventDefault();
        });
        $(".go-top-start-sec").scroll(function(e) {
            if (this.scrollTop > 170 && scrollTop > this.scrollTop) {
                goTopNav.show();
            } else {
                goTopNav.hide();
            }
            scrollTop = this.scrollTop;
        });
    };
});/**
 * tab
 * author: yuanzhen
 * date:12-12-12
 */
define("/src/scripts/utils/component/tab", function(require, exports, module) {
    var $ = require("/lib/jquery"), Tab;
    /**
     * 通用tab 对象, 当 tabMenus被触发时，显示tabContent
     * @ tabMenus
     * @ tabContent
     * @ tabs  tab的集合
     * @ currentTab 当前的tab
     */
    Tab = function(tabMenus, tabContents, options) {
        this.tabs = [];
        this.currentTab = null;
        this.options = {
            "currentClassName": "current",
            "defaultTabIndex": 0,
            "defaultEventTrigger": "click",
            "container": "",
            "callBack": function() {}
        };
        if (tabMenus && tabContents) {
            this.addGroup(tabMenus, tabContents);
        }
        this.init(options);
    };
    /**
     * Tab 原型方法
     */
    $.extend(Tab.prototype, {
        /**
         * 增加 一个tab，包括索引和其对应的content
         * @param tabMenu
         * @param tabContent
         */
        "add": function(tabMenu, tabContent) {
            if (tabMenu && tabContent) {
                this.tabs.push({
                    "tabMenu": tabMenu,
                    "tabContent": tabContent
                });
            }
        },
        /**
         * 增加一个tab组合，包括多个索引和其对应的content
         * @param tabMenus
         * @param tabContents
         */
        "addGroup": function(tabMenus, tabContents) {
            var haventCurrentTab = true;
            if (!tabMenus && !tabContents) {
                return;
            }
            if (tabMenus.length && tabContents.length && tabMenus.length === tabContents.length) {
                for (var i = 0, len = tabMenus.length; i < len; i++) {
                    var tabmemu = $(tabMenus[i]);
                    if (tabmemu.hasClass("current")) {
                        //记录当前tab
                        this.currentTab = {
                            "tabMenu": tabMenus[i],
                            "tabContent": tabContents[i]
                        };
                        haventCurrentTab = false;
                    }
                    this.add(tabMenus[i], tabContents[i]);
                }
            }
            if (haventCurrentTab) {
                this.select({
                    "tabMenu": tabMenus[0],
                    "tabContent": tabContents[0]
                });
            }
        },
        /**
         * 显示当前的tabContent
         */
        "showContent": function() {
            $(this.currentTab.tabMenu).addClass(this.options.currentClassName);
            $(this.currentTab.tabContent).show();
        },
        /**
         * 设置当前 tab,并显现当前tabContent
         */
        "select": function(tab) {
            var that = this;
            if (!tab || tab == this.currentTab) {
                return;
            }
            if (this.currentTab) {
                $(this.currentTab.tabMenu).removeClass(this.options.currentClassName);
                $(this.currentTab.tabContent).hide();
            }
            this.currentTab = tab;
            that.showContent();
        },
        /**
         * 初始化tab
         * @param {object} options 配置项
         */
        "init": function(options) {
            var opts = $.extend({}, this.options, options), that = this, tabs = that.tabs, container = opts.container;
            $.each(tabs, function(index, tab) {
                $(this.tabMenu).bind(opts.defaultEventTrigger, function(e) {
                    that.select(tab);
                    opts.callBack();
                    e.preventDefault();
                });
            });
        }
    });
    module.exports = function(tabMenus, tabContents, options) {
        return new Tab(tabMenus, tabContents, options);
    };
});/**
 * User: yuanzhen
 * Date: 12-12-17
 * Time: pm 3:35
 */
define("/src/scripts/utils/component/toggle", function(require, exports, module) {
    var $ = require("/lib/jquery"), Toggle;
    /**
     * 通用 Toggle对象，当trigger被触发时，sheet显示||隐藏
     * @param options  配置条件
     */
    Toggle = function(options) {
        this.options = {
            "trigger": null,
            "sheet": null,
            "isOpen": function() {},
            "open": function() {},
            "close": function() {}
        };
        this.opts = $.extend(this.options, options);
    };
    $.extend(Toggle.prototype, {
        "constructor": Toggle,
        /**
         * 初始化Toggle
         */
        "init": function() {
            var that = this, trigger = that.options.trigger;
            trigger.click(function(e) {
                if (that.options.isOpen()) {
                    that.open();
                } else {
                    that.close();
                }
                e.preventDefault();
            });
        },
        /**
         * open
         * @param callBack
         */
        "open": function(callBack) {
            this.options.open();
            if (this.options.sheet !== null) {
                var sheet = this.options.sheet;
                window.requestAnimationFrame(function() {
                    sheet.slideDown(100);
                });
            }
            if ($.isFunction(callBack)) {
                callBack();
            }
        },
        /**
         * close
         * @param callBack
         */
        "close": function(callBack) {
            this.options.close();
            if (this.options.sheet !== null) {
                var sheet = this.options.sheet;
                window.requestAnimationFrame(function() {
                    sheet.slideUp(100);
                });
            }
            if ($.isFunction(callBack)) {
                callBack();
            }
        }
    });
    module.exports = function(config) {
        return new Toggle(config);
    };
});/**
 * 发音
 * author: yuanzhen
 * Date: 12-12-18
 * Time: 上午10:56
 */
define("/src/scripts/utils/component/speech", function(require, exports) {
    var $ = require("/lib/jquery");
    var external = require("/src/scripts/external");
    /**
     *播放音頻
     */
    var playAudio = function() {
        
        var url = arguments[0];
        stopVideo();
        external.playSound(url);
    };
    var stopAudio = function() {
        external.stopSound();
    };
    $("body").delegate('[role="dict_audio_js"]', "click", function(e) {
        playAudio($(this).data("rel"));
        ke("window").fire("stopSpokenPlay");
        ke("window").fire("stopRecord");
        e.preventDefault();
    });
    $("body").delegate('[role="stop_dict_audio_js"]', "click", function(e) {
        stopAudio();
        e.preventDefault();
    });
    $("body").delegate('[role="dict_audio_js"]', "mouseover", function(e) {
        if (!$(this).hasClass("word-speech")) return;
        stopAudio();
        playAudio($(this).data("rel"));
        e.preventDefault();
    });
    var stopVideo = function() {
        $("#simplayer").siblings('[role="dict_video_js_close"]').click();
    };
    /**
     * 视频播放器
     */
    var swfObject = function(path, width, height) {
        return $('<object width="' + width + '" wmode="opaque" height= "' + height + '" type="application/x-shockwave-flash" ' + 'id="simplayer" name="simplayer" data="' + path + '">' + '<param value="wmode" name="transparent"/>' + '<param name="src" value="' + path + '"/>' + '<param name="quality" value="high"/>' + '<param name="allowScriptAccess" value="always">' + "</object>");
    };
    $("#dict").delegate('[role="dict_video_js_play"]', "click", function(e) {
        ke("window").fire("stopSpokenPlay");
        ke("window").fire("stopRecord");
        stopAudio();
        $("#simplayer").siblings('[role="dict_video_js_close"]').click();
        var self = $(this);
        //self.hide().parent().append(swfObject(self.attr("href"), 320, 240));
        self.siblings('[role="dict_video_js_close"]').show();
        e.preventDefault();
    });
    $("body").delegate('[role="dict_video_js_play_spoken"]', "click", function(e) {
        ke("window").fire("stopSpokenPlay");
        ke("window").fire("stopRecord");
        stopAudio();
        var self = $(this);
        self.closest(".content").append(swfObject(self.data("rel"), 1, 1));
        e.preventDefault();
    });
    $("#dict").delegate('[role="dict_video_js_close"]', "click", function(e) {
        var self = $(this);
        $("#simplayer").remove();
        self.siblings('[role="dict_video_js_play"]').show();
        self.hide();
        e.preventDefault();
    });
    var stopVideoAndVoice = function() {
        stopAudio();
        stopVideo();
    };
    return {
        "stopVideoAndVoice": stopVideoAndVoice
    };
});/**
 * Created with IntelliJ IDEA.
 * User: yuanzhen
 * Date: 12-12-17
 * Time: ����3:53
 * To change this template use File | Settings | File Templates.
 */
define("/src/scripts/utils/component/group", function(require, exports, module) {
    var $ = require("/lib/jquery"), tab = require("/src/scripts/utils/component/tab"), toggle = require("/src/scripts/utils/component/toggle"), speech = require("/src/scripts/utils/component/speech");
    var tgConfig = function(id) {
        var trigger = $("#" + id + " a.toggle"), sheet = $(trigger.data("rel")), container = $("#" + id);
        return {
            "container": container,
            "trigger": trigger,
            "sheet": sheet,
            "isOpen": function() {
                return container.hasClass("toggleClose");
            },
            "open": function() {
                container.removeClass("toggleClose");
                ke("group").fire("toggleChange", id, "open");
            },
            "close": function() {
                container.addClass("toggleClose");
                ke("group").fire("toggleChange", id, "close");
            }
        };
    };
    /**
     * dict group组合
     * @param id group标识
     */
    var Group = function(id) {
        this.id = id;
        var dictGroup = null;
        if (typeof id === "string") {
            if (Group._instance[id]) {
                dictGroup = Group._instance[id];
            } else {
                dictGroup = this;
                Group._instance[id] = this;
            }
        } else {
            throw "Id must be a String";
        }
        return dictGroup;
    };
    Group._instance = {};
    $.extend(Group.prototype, {
        /**
         * 初始化 gruop open状态
         */
        "open": function() {
            this.formatToggle.open();
        },
        /**
         * 初始化 gruop close状态
         */
        "close": function() {
            this.formatToggle.close();
        },
        /**
         * 初始化 group
         */
        "init": function() {
            var self = this;
            tab($("#" + this.id + " .tab-menu"), $("#" + this.id + " .tab-content"), {
                "container": $("#" + self.id),
                "callBack": function() {
                    self.open();
                    speech.stopVideoAndVoice();
                }
            });
            self.formatToggle = toggle(tgConfig(self.id));
            self.formatToggle.init();
        }
    });
    var createOne = function(id) {
        var dictGroup;
        dictGroup = new Group(id);
        dictGroup.init();
        return dictGroup;
    };
    module.exports = function(id) {
        if (typeof id === "string") {
            return createOne(id);
        } else {
            var instances = [];
            for (var single in id) {
                if (id.hasOwnProperty(single) && id[single].type === "dictGroup") {
                    instances.push(createOne(single));
                }
            }
            return instances;
        }
    };
});/**
 * @date 11-11-18
 * @describe:
 * @author: wulj
 * @version: 1.0
 */
define("/src/scripts/utils/component/lightips", function(require, exports) {
    var $ = require("/lib/jquery");
    /**
     * 获取窗口的尺寸
     */
    var getPageSize = function() {
        var xScroll, yScroll;
        if (window.innerHeight && window.scrollMaxY) {
            xScroll = document.body.scrollWidth;
            yScroll = window.innerHeight + window.scrollMaxY;
        } else {
            // all but Explorer Mac
            xScroll = Math.max(document.body.scrollWidth, document.body.offsetWidth);
            yScroll = Math.max(document.body.scrollHeight, document.body.offsetHeight);
        }
        var windowWidth, windowHeight;
        windowWidth = document.documentElement.clientWidth || document.body.clientWidth;
        windowHeight = document.documentElement.clientHeight || document.body.clientHeight;
        var pageHeight = Math.max(yScroll, windowHeight);
        var pageWidth = Math.max(xScroll, windowWidth);

        return {
            "page": {
                "width": pageWidth,
                "height": pageHeight
            },
            "window": {
                "width": windowWidth,
                "height": windowHeight
            }
        };
    };
    /**
     * 使元素根据浏览器可见窗口居中
     * @param elem
     */
    var centerElement = function(elem) {
        var height = $(window).height();
        var width = $(window).width();
        var scrollTop = document.body.scrollTop || document.documentElement.scrollTop;
        var scrollLeft = document.body.scrollLeft || document.documentElement.scrollLeft;
        elem.css({
            "top": parseInt((height - elem.height()) / 2, 10) + scrollTop,
            "left": parseInt((width - elem.width()) / 2, 10) + scrollLeft
        });
    };
    /**
     * 光线盒子
     * 需添加以下CSS
     .light-box {
     position: absolute;
     top: 0;
     left: 0;
     bottom: 0;
     right: 0;
     width: 100%;
     background-color: black;
     opacity: 0.5;
     filter: Alpha(opacity = 50);
     display: none;
     z-index: 5;
     }
     用法：
     var lbox = $('XXX').lightBox();
     */
    var lightBox = function(content, config) {
        var box;
        if ($(".light-box").size() === 0) {
            box = $('<div class="light-box"></div>').appendTo("body");
        }
        var setBoxHeight = function() {
            box.css({
                "height": getPageSize().page.height,
                "width": getPageSize().page.width
            });
        };
        setBoxHeight();
        var outerInterface = {
            "open": function() {
                box.show();
                centerElement(content);
                content.show();
            },
            "close": function(callback) {
                box.hide();
                content.fadeOut(function() {
                    if ($.isFunction(callback)) {
                        callback();
                    } else if (!!config && $.isFunction(config.onclose)) {
                        config.onclose();
                    }
                });
            }
        };
        centerElement(content);
        $(window).resize(function() {
            centerElement(content);
            setBoxHeight();
        });
        $(window).scroll(function() {
            setBoxHeight();
            centerElement(content);
        });
        content.mousedown(function(ev) {
            ev.stopPropagation();
        });
        content.delegate("a.close", "click", function() {
            // 如果窗口有定时器，先取消掉
            if (typeof countDownTimer !== "undefined") {
                clearInterval(countDownTimer);
            }
            lbox.close();
        });
        return outerInterface;
    };
    var lbox = null;
    var messageContainer;
    /**
     * 绑定模态窗口形态
     * @param isModel
     */
    var bindModel = function(isModel) {
        if (isModel === undefined) {
            return;
        }
        $(document).unbind("mousedown.lboxClose");
        if (!isModel) {
            $(document).bind("mousedown.lboxClose", function(e) {
                lbox.close();
                e.stopPropagation();
            });
        }
    };
    /**
     * 设置消息弹出窗口
     * @param container 消息弹出窗口
     */
    exports.msgContainer = function(container) {
        if ($(container).size() > 0) {
            messageContainer = $(container);
        }
        return messageContainer;
    };
    /**
     * 在lightbox中显示信息
     * @param msg      消息内容
     * @param initMsg  初始化消息窗口
     * @param isModel  是否模态窗口
     * @param config   配置
     */
    exports.open = function(msg, initMsg, isModel, config) {
        if (!messageContainer) {
            messageContainer = $('<div class="message-container"></div>').appendTo("body");
        }
        // todo: 自动适应的函数参数可抽出为公共函数
        if (!$.isFunction(initMsg) && typeof initMsg !== "boolean" && typeof initMsg === "object") {
            config = initMsg;
        } else if (typeof isModel !== "boolean" && typeof isModel === "object") {
            config = isModel;
        }
        if (!lbox) {
            lbox = lightBox(messageContainer, config);
        }
        exports.updateMsg(msg, initMsg, isModel);
        lbox.open();
        return exports;
    };
    /**
     * 更新内容信息，并更新是否模态状态
     * @param msg      消息内容
     * @param initMsg  初始化消息窗口
     * @param isModel  是否模态窗口
     */
    exports.updateMsg = function(msg, initMsg, isModel) {
        if (typeof msg !== "undefined" && !!msg.size) {
            messageContainer.empty();
            messageContainer.append(msg);
        } else if (typeof msg === "string") {
            messageContainer.empty();
            messageContainer.html(msg);
        }
        if ($.isFunction(msg)) {
            initMsg = msg;
        }
        if (typeof msg === "boolean") {
            isModel = msg;
        }
        if (typeof initMsg === "boolean") {
            isModel = initMsg;
        }
        if ($.isFunction(initMsg)) {
            initMsg(messageContainer);
        }
        if (typeof isModel === "boolean") {
            bindModel(isModel);
        }
        return exports;
    };
    var countDownTimer;
    /**
     * 关闭消息窗口
     */
    exports.closeMsg = function(callback) {
        if (typeof countDownTimer !== "undefined") {
            clearInterval(countDownTimer);
        }
        if (!!lbox) {
            lbox.close(callback);
        }
        return exports;
    };
    /**
     * todo: 放到utils中去
     * @param func
     */
    var once = function(func) {
        func();
        once = function() {};
    };
    /**
     * 倒计时
     */
    exports.countDownMsg = function(msg, m, updateCallback) {
        exports.open(msg, function() {}, true);
        countDownTimer = setInterval(function() {
            m--;
            if (m === 0) {
                clearInterval(countDownTimer);
                lbox.close();
            } else if (m > 0) {
                updateCallback(m);
            }
        }, 1e3);
    };
});/**
 * User: yuanzhen
 * Date: 13-3-21
 */
define("/src/scripts/utils/component/tg", function(require, exports, module) {
    var $ = require("/lib/jquery");
    module.exports = function(container, trigger, toggleClassName) {
        $(container).each(function() {
            var self = $(this);
            var $triggerTarget = self.find(trigger);
            $triggerTarget.css("cursor", "pointer").click(function(e) {
                if ($triggerTarget.index($(this)) === 0) {
                    $(this).addClass();
                }
                self.toggleClass(toggleClassName);
                $triggerTarget.blur();
                e.preventDefault();
            });
        });
    };
});/**
 * @date 13-3-5
 * @describe:
 * @author: wulj
 * @version: 1.0
 */
define("/src/scripts/utils/component/submitContent", function(require, exports, module) {
    var external = require("/src/scripts/external");
    return function(content, keyfrom, email, ctype, callback) {
        var data = {
            "comments": content,
            "email": email,
            "reporter": "",
            "keyfrom": keyfrom,
            "label": ctype,
            "id": external.getAppID(),
            "ver": external.getAppVersionString()
        };
        $.post("http://dict.youdao.com/feedback/open/feedback/add", data, function() {
            if ($.isFunction(callback)) {
                callback();
            }
        });
    };
});/**
 * @date 13-3-4
 * @describe: 数据校验工具类
 * 简单的数据校验
 * @param configSet
 * var checkError = new CheckData({
 *         callback: function() {
 *         reportErrorCallback();
 *    },
 *     configs:[
 *         {elem:'#reportError .trans-content' 只能选择器，为了保证
 *         ,validate:[
 *              {msg:'不能为空',ck:'null'}
 *         ,...]}  其中ck的value可以是function
 *     ]
 * });
 * checkError.run();
 *
 * @author: KnightWu
 * @version: 1.0
 */
define("/src/scripts/utils/component/validator", function(require, exports, module) {
    var $ = require("/lib/jquery");
    /**
     * 检测规则
     */
    var chunkers = {
        "mobile": /^0*(13|15|18)(\d{9}|\d-\d{3}-\d{5}|\d-\d{4}-\d{4}|\d{2}-\d{3}-\d{4}|\d{2}-\d{4}-\d{3})$/,
        "phone": /^((0*\d{1,4}|\+\d{1,4}|\(\d{1,4}\))[ -]?)?(\d{2,4}[ -]?)?\d{3,4}[ -]?\d{3,4}([ -]\d{1,5})?$/,
        "email": /^([a-z0-9_][a-z0-9_.-]*)?[a-z0-9_]@([a-z0-9-]+\.){0,4}([a-z0-9][a-z0-9-]{0,61})?[a-z0-9]\.[a-z]{2,6}$/i,
        "qq": /^[1-9]\d{4,14}$/,
        "empty": /^$/,
        "null": /.+/
    };
    /**
     * 执行 chunk
     * @param chunk 配置中的chunk，可能是函数或者正则表达式
     * @param value
     * @param fail chunk未通过的回调
     * @param pass chunk通过的回调
     */
    var doChunk = function(chunk, value, fail, pass) {
        if ($.isFunction(pass) && $.isFunction(fail)) {
            if ($.isFunction(chunk)) {
                if (chunk(value)) {
                    pass();
                } else {
                    fail();
                }
            } else {
                // 此处为判断非正则或默认类型时的错误，所以，给出默认类型程序会出错
                chunk = !!chunk.exec ? chunk : chunkers[chunk];
                if (!!chunk.exec) {
                    chunk.exec("");
                    // 重置正则表达式
                    if (chunk.exec(value) !== null) {
                        pass();
                    } else {
                        fail();
                    }
                } else {
                    throw Error("Wrong regular expression.");
                }
            }
        } else {
            throw Error("The rightHandle or wrongHandle must be functions.");
        }
    };
    /**
     * 检测数据是否符合规则
     * @param xor  各条件之间用 {xor} 连接， 注意，xor 如果是 'and'，所有校验的 msg 字段都不能为undefined，否则错误提示会不准确
     * 如果为 'or'，在所有校验都失败的时候，不想显示的错误提示，可以不定义 msg 字段。 例如，某个 input 框的数据校验要求是可以为空，或者是2-8个数字，或者2-8个汉字，
     *
     * @param validate  检测类型
     * @param value  input 中的值
     * @return {Array} 所有的验证失败的错误信息在此数组中，另外，此数组用 isValid 属性标识是否可以通过校验。xor 为 and 时，
     * 任何一个校验失败 isValid 属性都会为 false，所有都成功时，isValid 属性为 true；
     * 当 xor 为 or 时，任何一个校验成功 isValid 属性都会是 true，所有都校验失败时， isValid 属性才会为 false。
     */
    var isRight = function(xor, validate, value) {
        var errorMsg = [];
        errorMsg.isValid = xor === "and";
        // 初始化
        for (var i = 0, length = validate.length; i < length; i++) {
            var check = validate[i];
            doChunk(check.ck, value, function() {
                // fail
                if (check.msg !== undefined) {
                    errorMsg.push(check.msg);
                }
                if (xor === "and") {
                    errorMsg.isValid = false;
                }
                if ($.isFunction(check.fail)) {
                    check.fail(check.msg);
                }
            }, function() {
                // pass
                if (xor === "or") {
                    errorMsg.isValid = true;
                }
                if ($.isFunction(check.pass)) {
                    check.pass();
                }
            });
        }
        return errorMsg;
    };
    /**
     * 错误信息模板
     * @param msg 校验结果信息
     * @param tagName 需要展示错误信息的标签类型
     * @param className 错误样式
     * @return {String}
     */
    var msgTmpl = function(msg, tagName, className) {
        return "<" + (tagName || "i") + ' class="' + (className || "") + ' error-message">' + msg + "</" + (tagName || "i") + ">";
    };
    /**
     * 错误处理
     * @param xor 连接方式
     * @param checkResult 错误检测结果
     * @param config 配置信息中的错误信息容器等
     */
    var onError = function(xor, checkResult, config) {
        $(config.elem).addClass("data-error");
        if ($.isFunction(config.error)) {
            // 执行自定义错误处理函数
            config.error(checkResult);
        } else {
            var msg = xor === "and" ? checkResult[0] : checkResult.join("，或");
            if (config.errorBox) {
                $(config.errorBox).html(msg);
            } else {
                $(config.elem).after(msgTmpl(msg, config.tagName, config.className));
            }
        }
    };
    /**
     * 重置错误信息
     * @param config
     */
    var resetError = function(config) {
        $(config.elem).removeClass("data-error");
        if ($.isFunction(config.errorReset)) {
            // 执行自定义错误重置函数
            config.errorReset();
        } else {
            if (config.errorBox) {
                $(config.errorBox).html("");
            } else {
                $($(config.elem).parent()).find("i.error-message").remove();
            }
        }
    };
    /**
     * 根据规则检测值是否符合，若元素不存在，或满足附加规则，则直接返回true
     * @param config
     */
    var isValid = function(config) {
        // 若元素不存在，或满足附加规则，则直接返回true
        if ($(config.elem).size() === 0 || !!config.backDoor && config.backDoor()) {
            return true;
        }
        resetError(config);
        // 重置 error 消息
        var xor = config.xor || "or";
        var value = $.isFunction(config.val) ? config.val() : $(config.elem).val();
        // val()方法存在，则优先取这个值
        var checkResult = isRight(xor, config.validate, $.trim(value));
        if (!checkResult.isValid) {
            onError(xor, checkResult, config);
        }
        return checkResult.isValid;
    };
    /**
     * 检查对象值是否符合所有规则
     * @param configSet
     */
    var checkAll = function(configSet) {
        var isAllValid = true;
        walkConfigs(configSet, function(conf) {
            if (!isValid(conf)) {
                isAllValid = false;
            }
        });
        if (isAllValid) {
            configSet.callback();
        }
    };
    /**
     * 注册一组检查类型到元素上
     * @param configSet
     */
    var configElem = function(configSet) {
        walkConfigs(configSet, function(conf) {
            $(document).off("blur.dataCheck focus.dataCheck", conf.elem);
            // 自动检测的在blur时会检查
            if (conf.autoCheck) {
                $(document).on("blur.dataCheck", conf.elem, function() {
                    isValid(conf);
                });
            }
            $(document).on("focus.dataCheck", conf.elem, function() {
                resetError(conf);
            });
        });
    };
    var walkConfigs = function(configSet, handle) {
        var configs = configSet.configs;
        for (var i = 0; i < configs.length; i++) {
            (function(idx) {
                var conf = configs[idx];
                if ($.isFunction(configSet.error) && !$.isFunction(conf.error)) {
                    // 设置全局的error函数
                    conf.error = configSet.error;
                }
                if ($.isFunction(configSet.errorReset) && !$.isFunction(conf.errorReset)) {
                    // 设置全局的errorReset函数
                    conf.errorReset = configSet.errorReset;
                }
                // 是否自动检查（在blur时）, 默认为true. 优先级：个体>全局>默认
                if (typeof conf.autoCheck === "undefined") {
                    var autoCheck = typeof configSet.autoCheck === "undefined" ? true : configSet.autoCheck;
                    conf.autoCheck = autoCheck;
                }
                handle(conf);
            })(i);
        }
    };
    /**
     * 数据校验类
     * @param configSet 数据校验参数设置
     * {
     * configs:  [
     * {                         `
     *    elem: 检测值所属对象
     *    backDoor:   //附加规则，若满足，直接返回true，可以是函数或者是值
     *    validate:    //检测规则类型数组，一个元素可检测多种
     *    xor:   //以上多种检测类型间'与或'关系
     * },
     * ...
     * ]
     * callback: 以上检测通过后执行该回调
     * }
     */
    var CheckData = function(configSet) {
        this.configSet = configSet;
        this.config();
    };
    /**
     * 原型
     */
    CheckData.prototype = {
        "constructor": CheckData,
        "config": function() {
            configElem(this.configSet);
        },
        "run": function() {
            checkAll(this.configSet);
        }
    };
    module.exports = function(configSet) {
        return new CheckData(configSet);
    };
});define("/src/scripts/utils/component/align", function(require, exports, module) {
    var getAlignedHtml = function(sent, align, lang, sent_id, profix) {
        var chars = [];
        if (align["chars"] && align["chars"].length != undefined) chars = align["chars"];
        var q = [];
        if (align["q"] && align["q"].length != undefined) q = align["q"];
        for (var i in chars) {
            if (chars[i]["@id"] == undefined || chars[i]["@s"] == undefined || chars[i]["@e"] == undefined) return sent;
        }
        for (var i in q) {
            if (q[i]["@s"] == undefined || q[i]["@e"] == undefined) return sent;
        }
        var pChars = 0, pQ = 0, pS = 0;
        var html = "";
        while (true) {
            if (pChars == chars.length && pQ == q.length) {
                html += sent.substring(pS);
                break;
            } else if (pChars == chars.length || pQ < q.length && Number(chars[pChars]["@s"]) > Number(q[pQ]["@s"])) {
                // use q
                var s = Number(q[pQ]["@s"]), e = Number(q[pQ]["@e"]);
                if (s == NaN || s <= 0 || s > sent.length || e == NaN || e <= 0 || e > sent.length) return sent;
                //error
                --s, --e;
                html += sent.substring(pS, s) + "<b>" + sent.substring(s, e) + "</b>";
                pS = e;
                ++pQ;
            } else if (pQ == q.length || pChars < chars.length && Number(q[pQ]["@s"]) > Number(chars[pChars]["@s"])) {
                // use chars
                var id = profix + "_" + lang + "_" + sent_id + "_" + chars[pChars]["@id"];
                var data_aligning = "";
                var align_src = [], align_tran = [];
                if (chars[pChars]["aligns"] != undefined) {
                    if (chars[pChars]["aligns"]["sc"] && chars[pChars]["aligns"]["sc"].length != undefined) align_src = chars[pChars]["aligns"]["sc"];
                    if (chars[pChars]["aligns"]["tc"] && chars[pChars]["aligns"]["tc"].length != undefined) align_tran = chars[pChars]["aligns"]["tc"];
                }
                for (var i in align_src) {
                    if (align_src[i]["@id"] != undefined) {
                        if (data_aligning != "") {
                            data_aligning += ",";
                        }
                        data_aligning += "#" + profix + "_src_" + sent_id + "_" + align_src[i]["@id"];
                    }
                }
                for (var i in align_tran) {
                    if (align_tran[i]["@id"] != undefined) {
                        if (data_aligning != "") {
                            data_aligning += ",";
                        }
                        data_aligning += "#" + profix + "_tran_" + sent_id + "_" + align_tran[i]["@id"];
                    }
                }
                var s = Number(chars[pChars]["@s"]), e = Number(chars[pChars]["@e"]);
                if (s == NaN || s <= 0 || s > sent.length || e == NaN || e <= 0 || e > sent.length) return sent;
                //error
                --s, --e;
                html += sent.substring(pS, s) + '<span id="' + id + '" data-aligning="' + data_aligning + '">';
                var char_q = [];
                if (chars[pChars]["q"] && chars[pChars]["q"].length != undefined) {
                    char_q = chars[pChars]["q"];
                }
                var p = s;
                for (var i in char_q) {
                    if (char_q[i]["@s"] == undefined || char_q[i]["@e"] == undefined) return sent;
                    //error
                    var qs = Number(char_q[i]["@s"]), qe = Number(char_q[i]["@e"]);
                    if (qs == NaN || qs <= 0 || qs > sent.length || qe == NaN || qe <= 0 || qe > sent.length) return sent;
                    --qs, --qe;
                    html += sent.substring(p, qs) + "<b>" + sent.substring(qs, qe) + "</b>";
                    p = qe;
                }
                html += sent.substring(p, e) + "</span>";
                pS = e;
                ++pChars;
            } else {
                return sent;
            }
        }
        return html;
    };
    module.exports = function(pair, index, profix) {
        if (!pair["sentence"] || !pair["sentence-translation"] || !pair["aligned-words"] || !pair["aligned-words"]["src"] || !pair["aligned-words"]["tran"]) {
            return [];
        } else {
            return [ getAlignedHtml(pair["sentence"], pair["aligned-words"]["src"], "src", index, profix), getAlignedHtml(pair["sentence-translation"], pair["aligned-words"]["tran"], "tran", index, profix) ];
        }
    };
});/**
 * 扩展现有 Date 对象
 * @author: wulj
 * @date: 11-7-13
 * @version: 1.0
 */
define("/src/scripts/utils/component/kDate", function() {
    var KDate = function() {
        this.init.apply(this, arguments);
    };
    KDate.template = {
        "-": "y%-m%-d%",
        "-0": "y%-m%-d%"
    };
    var i18n = {
        "months": {
            "num": {
                "0": "1",
                "1": "2",
                "2": "3",
                "3": "4",
                "4": "5",
                "5": "6",
                "6": "7",
                "7": "8",
                "8": "9",
                "9": "10",
                "10": "11",
                "11": "12"
            },
            "en": {
                "0": "January",
                "1": "February",
                "2": "March",
                "3": "April",
                "4": "May",
                "5": "June",
                "6": "July",
                "7": "August",
                "8": "September",
                "9": "October",
                "10": "November",
                "11": "December"
            },
            "ch": {
                "0": "一月",
                "1": "二月",
                "2": "三月",
                "3": "四月",
                "4": "五月",
                "5": "六月",
                "6": "七月",
                "7": "八月",
                "8": "九月",
                "9": "十月",
                "10": "十一月",
                "11": "十二月"
            }
        },
        "weeks": {
            "num": {
                "0": "7",
                "1": "1",
                "2": "2",
                "3": "3",
                "4": "4",
                "5": "5",
                "6": "6"
            },
            "en": {
                "0": "Sunday",
                "1": "Monday",
                "2": "Tuesday",
                "3": "Wednesday",
                "4": "Thursday",
                "5": "Friday",
                "6": "Saturday"
            },
            "ch": {
                "0": "周日",
                "1": "周一",
                "2": "周二",
                "3": "周三",
                "4": "周四",
                "5": "周五",
                "6": "周六"
            }
        }
    };
    KDate.prototype = {
        "constructor": KDate,
        /**
         * 初始化日期对象
         */
        "init": function() {
            var date = {};
            if (arguments.length > 1) {
                date = eval("new Date(" + $.makeArray(arguments).join(",") + ")");
            } else if (arguments.length === 0) {
                date = new Date();
            } else if (arguments.length === 1 && typeof arguments[0] === "string" && arguments[0].indexOf("-") >= 0) {
                date = arguments[0].replace(/\-|\-0/g, "/");
                date = new Date(date);
            } else {
                date = arguments[0];
            }
            this.date = date;
        },
        /**
         * 创建日期对象
         * @param days 向前或向后几天
         */
        "create": function(years, months, days) {
            return new Date(this.date.getFullYear() + years, this.date.getMonth() + months, this.date.getDate() + days);
        },
        "getDate": function(years, months, days) {
            this.date = this.create(years, months, days);
            return this;
        },
        /**
         * 得到后一天
         */
        "getNextDay": function() {
            return this.getDate(0, 0, 1);
        },
        /**
         * 得到前一天
         */
        "getPreDay": function() {
            return this.getDate(0, 0, -1);
        },
        "jumpTo": function(years, months, days) {
            this.date = this.create(years, months, days);
            return this.date;
        },
        "jump": function(years, months, days) {
            return new this.constructor(this.create(years, months, days));
        },
        /**
         * 得到后一天
         */
        "nextDay": function() {
            return this.jump(0, 0, 1);
        },
        /**
         * 得到前一天
         */
        "preDay": function() {
            return this.jump(0, 0, -1);
        },
        /**
         * 获取今天的日期对象
         */
        "inSameMonthWith": function(dateB) {
            return this.date.getMonth() === dateB.date.getMonth();
        },
        /**
         * 对象日期是否早于{dateB}
         * @param dateB
         */
        "earlyThan": function(dateB) {
            return this.date < dateB.date;
        },
        /**
         * 判断当前日期是否处于{a}--->{b}日期区间内
         * @param a 日期 a
         * @param b 日期 b
         */
        "isBetween": function(a, b) {
            return a.date <= this.date && this.date <= b.date;
        },
        /**
         * 当前日期所处周的第一天
         * @param location 中，美国
         */
        "getWeekFirstDate": function(location) {
            return this.create(0, 0, -this.date.getDay() + {
                "ch": 1,
                "en": 0
            }[location || "en"]);
        },
        /**
         * 当前日期所处周的最后一天
         * @param location 中，美国
         */
        "getWeekLastDate": function(location) {
            return this.create(0, 0, -this.date.getDay() + {
                "ch": 1,
                "en": 0
            }[location || "en"] + 6);
        },
        /**
         * 是否等于 {dateB}
         * @param dateB
         */
        "equals": function(dateB) {
            return this.toString("-") === dateB.toString("-");
        },
        /**
         * 获取完整字符串，小于 10 的，补 0
         */
        "fullStr": function(num) {
            return parseInt(num, 10) < 10 ? "0" + num : num + "";
        },
        /**
         * 国际化
         * @param type
         * @param lang
         * @param str
         */
        "internationalization": function(type, lang, str) {
            var i18nObj = i18n;
            if (typeof lang !== "string") {
                i18nObj = lang;
            }
            return i18nObj[type][lang][str];
        },
        /**
         * 根据模板，输出日期
         * @param template
         * @param lang
         * @param full
         */
        "toString": function(template, lang, full) {
            if (!template) {
                template = "-";
            }
            if (!lang) {
                lang = "num";
            }
            if (template === "-0") {
                full = true;
            } else if (template === "-") {
                full = false;
            }
            if (KDate.template[template] !== undefined) {
                template = KDate.template[template];
            }
            var date = this.date;
            var year = date.getFullYear();
            var month = this.internationalization("months", lang, date.getMonth());
            if (full) {
                month = this.fullStr(month);
            }
            var day = full ? this.fullStr(date.getDate()) : date.getDate();
            var hour = full ? this.fullStr(date.getHours()) : date.getHours();
            var minute = full ? this.fullStr(date.getMinutes()) : date.getMinutes();
            var second = full ? this.fullStr(date.getSeconds()) : date.getSeconds();
            var week = this.internationalization("weeks", lang, date.getDay());
            var replace = function(all, str, reStr) {
                if (all.indexOf(str) >= 0) {
                    return all.replace(str, reStr);
                }
                return all;
            };
            template = replace(template, "y%", year);
            template = replace(template, "m%", month);
            template = replace(template, "d%", day);
            template = replace(template, "h%", hour);
            template = replace(template, "m%", minute);
            template = replace(template, "s%", second);
            template = replace(template, "w%", week);
            return template;
        }
    };
    KDate.TODAY = new KDate();
    return KDate;
});
/*!
 * jQuery TextChange Plugin
 * http://www.zurb.com/playground/jquery-text-change-custom-event
 *
 * Origin:
 * Copyright 2010, ZURB
 * Released under the MIT License
 */
define("/src/scripts/utils/component/jquery-textchange", function(require, exports, module) {
    var $ = require("/lib/jquery");
    $.fn.hasContentEditable = function() {
        return this[0].contentEditable === "true";
    };
    $.event.special.textchange = {
        "setup": function(data, namespaces) {
            var $this = $(this);
            $this.data("lastValue", $this.hasContentEditable() ? $this.html() : $this.val()).on("keyup.textchange", $.event.special.textchange.handler).on("cut.textchange paste.textchange input.textchange", $.event.special.textchange.delayedHandler).on("focus.suggest", function() {
                // 重新获取焦点，textchange 更新存储值
                $(this).data("lastValue", $this.hasContentEditable() ? $this.html() : $this.val());
            });
        },
        "teardown": function(namespaces) {
            $(this).off("textchange");
        },
        "handler": function(event) {
            $.event.special.textchange.triggerIfChanged($(this));
        },
        "delayedHandler": function(event) {
            var $this = $(this);
            setTimeout(function() {
                $.event.special.textchange.triggerIfChanged($this);
            }, 25);
        },
        "triggerIfChanged": function(element) {
            var current = element.hasContentEditable() ? element.html() : element.val();
            if (current !== element.data("lastValue")) {
                element.trigger("textchange", [ element.data("lastValue") ]);
                element.data("lastValue", current);
            }
        }
    };
    $.event.special.hastext = {
        "setup": function(data, namespaces) {
            $(this).on("textchange", $.event.special.hastext.handler);
        },
        "teardown": function(namespaces) {
            $(this).off("textchange", $.event.special.hastext.handler);
        },
        "handler": function(event, lastValue) {
            var $this = $(this);
            if (lastValue === "" && lastValue !== $this.val()) {
                $this.trigger("hastext");
            }
        }
    };
    $.event.special.notext = {
        "setup": function(data, namespaces) {
            $(this).on("textchange", $.event.special.notext.handler);
        },
        "teardown": function(namespaces) {
            $(this).off("textchange", $.event.special.notext.handler);
        },
        "handler": function(event, lastValue) {
            var $this = $(this), value = $this.val();
            if (value === "" && value !== lastValue) {
                $this.trigger("notext");
            }
        }
    };
});/**
 * @require Jquery
 * @author  wulj
 * @time: 11-11-15
 * todo:1.快速输入处理，前一次处理中断，不再处理，只处理最新的请求
 * todo:2.无结果处理
 * todo:3.关闭menu和打开menu状态管理
 */
define("/src/scripts/utils/component/suggest/suggest", function(require, exports, module) {
    var $ = require("/lib/jquery");
    require("/src/scripts/utils/component/jquery-textchange");
    var $s = {
        "newid": 0
    };
    var sugCount = 0;
    // suggest 的使用次数
    var current$s = 0;
    var yourChoice = false;
    //是否人为选择的suggest项，如果suggest某项和输入框中的内容相等，会自动被设置成选中状态，一般会在第一个。
    /**
     * 更新suggest的唯一标识
     */
    var updateId = function() {
        return $s.newid = sugCount++ + +new Date();
    };
    /**
     * 主函数，
     * @param el 绑定到元素
     * @param config
     * {
     *   id: suggest的 id
     *   data: {Object|function(callback){callback(data);}}, 直接是数据，或者带有回调处理的匿名函数
     *   dataProcessing：{function Array|Map(data, val){}}  对<data>进行处理的函数,
     *       data：
     *       val： 用户输入的数据
     *   item: {function String(val, el, index){}} html代码片段,
     *   onEnter:  {function String(el){}} 回车键回调,
     *   userInit  {function String(el){}}  初始化用户自定义事件
     * }
     */
    var Suggest = function(el, config) {
        if ($(el).length === 0) {
            throw new Error("绑定元素为空！！");
        }
        this.el = el;
        this.init(config);
    };
    var key = {
        "UP": 38,
        "DOWN": 40,
        "RIGHT": 37,
        "LEFT": 39,
        "ENTER": 13,
        "TAB": 9
    };
    /**
     * 更新提示框的位置
     */
    var position = function(elem, target) {
        if (!elem) {
            return;
        }
        var x = target.offset().left;
        var y = target.offset().top + target.outerHeight();
        var borderWidth = 2;
        var minWidth = target.outerWidth() - borderWidth;
        elem.css({
            "top": y + 3,
            "left": x,
            "width": minWidth
        });
    };
    var actionStatus = null;
    //当前动作状态
    Suggest.prototype = {
        /**
         * 入口，初始化后缀名称
         * @param config
         */
        "init": function(config) {
            this.suggestContainerId = config.id || "auto-suggest";
            this.mouseover = false;
            this.initDataProvider(config);
            //初始化数据提供者
            this.initDataProcessing(config);
            //初始化数据处理函数
            this.initItemCreater(config);
            //初始化单条信息生成方式
            this.initContainer(config);
            //初始化内容区域
            this.initInput(config);
            //初始化输入区
            if ($.isFunction(config.userInit)) {
                //用户自定义初始化
                config.userInit(this);
            }
        },
        /**
         * 初始化数据提供者
         * @param config
         */
        "initDataProvider": function(config) {
            if ($.isFunction(config.data)) {
                //data（数据提供者）是函数
                this.dataProvider = function(val, callback) {
                    config.data(val, callback);
                };
            } else if (config.data.length > 0) {
                // 数据提供者是直接的数据
                this.dataProvider = function(val, callback) {
                    if ($.isFunction(callback)) {
                        callback(config.data, val);
                    }
                };
            } else {
                this.dataProvider = function(val, callback) {
                    callback();
                };
            }
        },
        /**
         * 初始化数据处理函数
         * @param config
         */
        "initDataProcessing": function(config) {
            this.dataProcessing = $.isFunction(config.dataProcessing) ? config.dataProcessing : function(data, val) {
                return data;
            };
        },
        /**
         * 初始化单条信息生成方式
         * @param config
         */
        "initItemCreater": function(config) {
            this.item = $.isFunction(config.item) ? config.item : function(val, data, index) {
                return data;
            };
        },
        /**
         * 初始化选择后的动作
         */
        "onSelected": function(config) {
            var currentItem = $("#" + this.suggestContainerId + " li").eq(this.curSuggest);
            //第一个选中的元素比较特殊，有两种可能，一，跟输入框中相同，不需要回填，二，跟输入框不同（数据回来的慢，尚未更新状态），不需要回填
            // 因此，在发现选中元素是第一个元素时，不进行回填操作。
            if (currentItem.length !== 0 && (yourChoice ? true : this.curSuggest !== 0)) {
                //存在选中的元素，并且不是第一个
                var fillBackVal = config.fillVal($s.co[this.curSuggest], currentItem);
                if (fillBackVal) {
                    if ($(this.el).val() !== fillBackVal) {
                        //不重复设置值
                        $(this.el).val(fillBackVal);
                    }
                    $(this.el).focus();
                    if ($.isFunction(config.afterSelected)) {
                        config.afterSelected($s.co[this.curSuggest], currentItem);
                    }
                }
            }
            actionStatus = "ONSELECTED";
        },
        /**
         * 初始化信息容器
         */
        "initContainer": function(config) {
            var self = this;
            if ($("#" + this.suggestContainerId + "").size() === 0) {
                this.suggestContainer = $('<ul id="' + this.suggestContainerId + '"></ul>').appendTo("body").hide().addClass("auto-suggest");
            } else {
                this.suggestContainer = $("#" + this.suggestContainerId);
            }
            //点击文档，隐藏suggest
            $(document).mousedown(function() {
                if (self.suggestContainer.is(":visible")) {
                    //suggest正在展示
                    $(self.el).val($s.ci);
                    //修正中文输入法问题，点击其他地方，关闭，中文输入法会清空原英文输入
                    self.close();
                }
            });
            //点击suggest内容区域，不隐藏suggest
            this.suggestContainer.mousedown(function(e) {
                e.stopPropagation();
            });
            //点击选中条目，将结果填到目标文本框中
            this.suggestContainer.delegate("li", "click", function() {
                self.setSelectedStatusOn($(this));
                self.onSelected(config);
                if ($.isFunction(config.clickItem)) {
                    config.clickItem($s.co[this.curSuggest], $(this));
                }
                self.close();
            });
            //鼠标移动后才相应hover事件
            this.suggestContainer.mousemove(function() {
                self.mousemoved = true;
            });
            //hover 选中条目
            this.suggestContainer.delegate("li", "mouseover", function() {
                if (!self.mousemoved) {
                    return;
                }
                self.mouseover = true;
                yourChoice = true;
                self.setSelectedStatusOn($(this));
            });
            //hover 选中条目
            this.suggestContainer.delegate("li", "mouseout", function() {
                self.mouseover = false;
            });
            position(this.suggestContainer, $(this.el));
        },
        "changeSelect": function(config, direction) {
            var self = this;
            if (this.suggestContainer.is(":visible")) {
                yourChoice = true;
                this.setSelectedStatusOn((this.curSuggest + direction + this.suggests.length) % this.suggests.length);
                this.onSelected(config);
            } else {}
        },
        /**
         * 当按键输入内容时，更新提示内容
         */
        "initInput": function(config) {
            var self = this;
            $(this.el).bind("keyup.suggest", function(e) {
                var direction = e.which === key.UP ? -1 : 1;
                switch (e.which) {
                  case 16:
                  // shift
                    case 17:
                  // ctrl
                    case 18:
                    // alt
                    break;

                  case 9:
                  // tab
                    case key.UP:
                    //在按下“上、下”键时，高亮选中的提示
                    if (self.curSuggest === null) {
                        self.curSuggest = 0;
                    }
                    self.changeSelect(config, direction);
                    return false;

                  //阻止上下键影响光标位置
                    case key.DOWN:
                    if (self.curSuggest === null) {
                        self.curSuggest = -1;
                    }
                    self.changeSelect(config, direction);
                    return false;

                  //阻止上下键影响光标位置
                    case key.ENTER:
                    if (self.curSuggest !== null && self.suggestContainer.is(":visible")) {
                        self.onSelected(config);
                    }
                    self.close();
                    break;

                  case 27:
                    // escape
                    self.close();
                    break;

                  case key.LEFT:
                  case key.RIGHT:
                    break;
                }
            });
            $(this.el).bind("blur.suggest", function(e) {
                if (!self.mouseover) {
                    self.close();
                }
                e.stopPropagation();
            });
            $(this.el).on("focus.suggest", function() {
                $s.ci = $(this).val();
            });
            $(this.el).on("textchange", function(e) {
                if (actionStatus === "ONSELECTED") {
                    //不干扰选中后用户自定义事件
                    actionStatus = null;
                    return;
                }
                self.fetchData(function(data, inputValue) {
                    self.showSuggestDataInContainer(data, inputValue, config);
                });
                e.stopPropagation();
            });
        },
        /**
         * 获取数据，自带缓存
         * @param callback 获取数据后的回调函数
         */
        "fetchData": function() {
            var responseTime = 50;
            //ms
            return function(callback) {
                var self = this;
                window.clearTimeout(self.delay);
                current$s = updateId();
                //有新的请求，则更新当前 suggestid 号
                self.delay = window.setTimeout(function() {
                    yourChoice = false;
                    //无论是否更新suggest选项，重置 yourChoice 选项
                    var inputValue = $(self.el).val();
                    if (inputValue === $s.ci) {
                        // input无变化，不发起查询
                        return;
                    }
                    $s.sh.unshift(inputValue);
                    $s.ci = inputValue;
                    if (inputValue === "") {
                        //空字符串 隐藏
                        self.close();
                    } else {
                        self.dataProvider(inputValue, function(data, inputValue) {
                            if (current$s !== $s.newid) {
                                //对比 current$s 和 $s.newid,如果不相同则证明current$s 已经被关闭，那么就不渲染数据
                                return;
                            }
                            if (typeof data === "undefined" || data.length === 0) {
                                data = $s.co;
                            }
                            if (data === null) {
                                return;
                            }
                            $s.co = data;
                            callback(data, inputValue);
                        });
                    }
                }, responseTime);
            };
        }(),
        /**
         * 处理需要展示的数据，生成html代码，展示到页面上
         * @param suggestData 需展示数据
         * @param inputValue  输入值
         * @param config  输入值
         */
        "showSuggestDataInContainer": function(suggestData, inputValue, config) {
            var fragment = $("<div></div>");
            var self = this;
            this.mousemoved = false;
            $.each(this.dataProcessing(suggestData, inputValue), function(index, data) {
                $('<li class="item"></li>').html(self.item(inputValue, data, index)).appendTo(fragment);
            });
            self.rePosition();
            //每次展示之前重新计算位置和宽度
            this.suggestContainer.html(fragment.html()).show();
            this.suggests = $("#" + this.suggestContainerId + " li");
            if ($.isFunction(config.equal1st) && config.equal1st(inputValue, suggestData[0] || {})) {
                this.setSelectedStatusOn(0);
            } else {
                this.curSuggest = null;
            }
        },
        "close": function() {
            updateId();
            //关闭本次suggest后，更新$s.id 但不更新 currentSuggest
            this.suggestContainer.hide();
            $s.co = null;
            actionStatus = null;
        },
        "rePosition": function() {
            if ($(this.el).is(":visible")) {
                position(this.suggestContainer, $(this.el));
            }
        },
        /**
         * 给元素设置选中状态，并记录当前选中提示的索引值
         * @param suggest 选中提示的索引或者选中提示的DOM对象
         */
        "setSelectedStatusOn": function(suggest) {
            this.suggests.removeClass("selected");
            if (typeof suggest === "number") {
                this.suggests.eq(suggest).addClass("selected");
                this.curSuggest = suggest;
            } else {
                $(suggest).addClass("selected");
                this.curSuggest = this.suggests.index($(suggest));
            }
        }
    };
    $s.position = position;
    $s.sh = [];
    //search history
    $s.getSh = function() {
        return $s.sh;
    };
    $s.co = null;
    //current output
    $s.getCo = function() {
        return $s.co;
    };
    $s.ci = null;
    //current input
    $s.getCi = function() {
        return $s.ci;
    };
    module.exports = function(el, config) {
        $(el).attr("autoComplete", "off");
        return new Suggest(el, config);
    };
    $.extend(module.exports, $s);
});/**
 * @date 13-2-21
 * @describe: 状态的存储，暂时分local和session
 * local   ：存储到用户本机
 * session ：在用户本次打开词典到关闭位置数据有效
 *
 * 使用：
 *  require('./store')('status').local.val = {current : 'hi'};
 *  require('./store')('status').local.val
 *  require('./store')('status').local.valmix = {current : 'hi'};
 *  require('./store')('status').val = {current : 'hi'};
 *  require('./store')('status').session.val={value:'hello'}
 * @author: wulj
 * @version: 1.0
 */
define("/src/scripts/utils/store", function(require, exports, module) {
    var $ = require("/lib/jquery"), external = require("/src/scripts/external");
    var databases = {
        "local": function(storeKey, group) {
            return {
                get value() {
                    return JSON.parse(external.loadString(storeKey, group || "global") || "{}");
                },
                set val(data) {
                    external.saveString(storeKey, JSON.stringify(data), group || "global");
                },
                set valmix(data) {
                    external.saveString(storeKey, JSON.stringify($.extend(true, this.value, data)), group || "global");
                },
                "add": function(key, value) {
                    var data = {};
                    data[key] = value;
                    external.saveString(storeKey, JSON.stringify($.extend(true, this.value, data)), group || "global");
                }
            };
        },
        "session": function(storeKey, group) {
            return {};
        }
    };
    var Data = function(storeKey, group) {
        this.key = storeKey;
        var self = this;
        //切换存储类型
        return {
            get session() {
                self.database = databases.session(storeKey, group);
                return self.database;
            },
            get local() {
                //值的指针指向localStorage对象中取到的值
                self.database = databases.local(storeKey, group);
                return self.database;
            }
        };
    };
    module.exports = function(storeKey, group) {
        return new Data(storeKey, group || "global");
    };
});/**
 * User: yuanzhen
 * Date: 13-4-2
 */
define("/src/scripts/utils/component/languageSelect", function(require, exports, module) {
    var $ = require("/lib/jquery"), external = require("/src/scripts/external");
    var langSel = $("#langSel"), langOpts = $("#langOpts"), langType = $("#customSelectVal"), currentLangType = "eng", status = require("/src/scripts/utils/store")("langStatus").local;
    var LangTypeInStatus = status.value.lang || "eng";
    /**
     * 快捷鍵
     * @param e
     * @returns {*}
     */
    var keyDown = function(e) {
        var self, menuItems, isActive, index;
        if (!/(38|40|27)/.test(e.keyCode)) {
            return;
        }
        self = $(this);
        if (self.is(".disabled, :disabled")) {
            return;
        }
        isActive = langSel.hasClass("lang-sel-open");
        if (!isActive || isActive && e.keyCode === 27) {
            if (e.which === 27) {
                langSel.find(langType).focus();
            }
            langOpts.hide();
        }
        menuItems = $(".js-lang", langSel);
        if (!menuItems.length) {
            return;
        }
        index = menuItems.index(menuItems.filter(":focus"));
        if (e.keyCode === 38) {
            if (index <= 0) {
                index = menuItems.length - 1;
            } else {
                index--;
            }
        }
        if (e.keyCode === 40) {
            if (index < menuItems.length - 1) {
                index++;
            } else {
                index = 0;
            }
        }
        if (!~index) {
            index = 0;
        }
        menuItems.eq(index).focus();
    };
    ke("window").on("openStatus", function(currentItem) {
        if (currentItem !== "langOpts") {
            $("#langOpts").hide();
        }
    });
    /**
     * 显示和隐藏语言选择栏，并获取焦点
     */
    langType.bind("click", function() {
        ke("window").fire("openStatus", "langOpts");
        langOpts.slideToggle(100);
        langType.focus();
        return false;
    });
    var setLangType = function(lang) {
        langType.removeClass("lang-" + currentLangType);
        langType.addClass("lang-" + lang).text($(".le-" + lang).text());
        $(".js-lang-type").data("lang", lang);
        status.val = {
            "lang": lang
        };
        currentLangType = lang;
    };
    /**
     * hover  获取焦点
     */
    $(".js-lang").hover(function() {
        $(this).focus();
    }, function() {
        $(this).blur();
    });
    var init = function() {
        $(document).on("keydown.lang-sel", langType, keyDown);
        $(".js-lang").bind("click", function() {
            setLangType($(this).data("lang"));
            langOpts.hide();
            return false;
        });
        $(document).bind("click", function() {
            langOpts.hide();
        });
        langOpts.find(".le-" + LangTypeInStatus).trigger("click");
    };
    init();
    module.exports.changeLang = function(lang) {
        setLangType(lang);
    };
    external.on("langChange", function(lang) {
        langOpts.find(".le-" + lang).click();
    });
});/**
 * 分享
 * @author: wulj
 * @date: 11-7-28
 * @version: 1.0
 */
define("/src/scripts/utils/component/share", function() {
    var ec = encodeURIComponent;
    var site = "http://cidian.yuodao.com/beta";
    var types = {
        "sina": function(data) {
            var params = [ "appkey=", data.appKey, "&title=", ec(data.title || document.title), "&content=", data.charset || "gb2312", "ralateUid=", data.uid, //关联用户的UID，分享微博会@该用户(可选)
            "&pic=", ec(data.imgUrl || ""), //分享图片的路径(可选)
            "&c=srp_h_youdao_cidian_fs00_null" ];
            return "http://v.t.sina.com.cn/share/share.php?" + params.join("");
        },
        "tencent": function(data) {
            var params = [ "appkey=", data.appKey, "&assname=", data.uid, //关联用户的UID，分享微博会@该用户(可选)
            "&url=", ec(data.location || site), "&pic=", ec(data.imgUrl || ""), "&title=", ec(data.title || document.title) ];
            return "http://share.v.t.qq.com/index.php?c=share&a=index&" + params.join("");
        },
        "netease": function(data) {
            var params = [ "appkey=", data.appKey, "&link=", ec(data.location || site), "&info=", ec(data.title), "&images=", ec(data.imgUrl), "&source=", ec("每日英语") ];
            return "http://t.163.com/article/user/checkLogin.do?" + params.join("");
        },
        "kaixin": function(data) {
            var params = [ "appkey=", data.appKey, "&rurl=", ec(data.location || site), "&rtitle=", ec(document.title), "&rcontent=", ec(data.title), "&rpic=", ec(data.imgUrl || "") ];
            return "http://www.kaixin001.com/repaste/bshare.php?" + params.join("");
        },
        "renren": function(data) {
            var params = [ "api_key=", data.api_key || "", "&title=", ec(data.title || ""), "&pic=", ec(data.imgUrl || ""), "&description=", ec(data.title || ""), "&resourceUrl=", ec(data.location || site), "&images=", ec(data.imgUrl || ""), "&charset=", data.charset || "UTF-8" ];
            return "http://widget.renren.com/dialog/share?" + params.join("");
        },
        "qZone": function(data) {
            var params = [ "url=", ec(data.location || site), "&title=", ec(document.title), "&summary=", ec(data.title), "&pics=", ec(data.imgUrl || "") ];
            return "http://sns.qzone.qq.com/cgi-bin/qzshare/cgi_qzshare_onekey?" + params.join("");
        }
    };
    var titles = {
        "sina": "分享到新浪微博",
        "qZone": "分享到QQ空间"
    };
    return {
        /**
         * 根据类型创建分享按钮
         * @param type 类型
         * @param data 社交网站数据
         */
        "open": function(type, data) {
            DAE.browse(types[type](data));
            // window.open(types[type](data), titles[type], [ "toolbar=0,status=0,resizable=1,width=" + data.width + ",height=" + data.height + ",left=", (screen.width - data.width) / 2, ",top=", (screen.height - data.height) / 2 ].join(""));
        }
    };
});/**
 * @date 13-5-13
 * @describe:
 * @author: wulj
 * @version: 1.0
 */
/*! Copyright (c) 2013 Brandon Aaron (http://brandonaaron.net)
 * Licensed under the MIT License (LICENSE.txt).
 *
 * Thanks to: http://adomas.org/javascript-mouse-wheel/ for some pointers.
 * Thanks to: Mathias Bank(http://www.mathias-bank.de) for a scope bug fix.
 * Thanks to: Seamus Leahy for adding deltaX and deltaY
 *
 * Version: 3.1.3
 *
 * Requires: 1.2.2+
 */
define("/src/scripts/utils/component/jquery-mousewheel", function(require, exports, module) {
    var toFix = [ "wheel", "mousewheel", "DOMMouseScroll", "MozMousePixelScroll" ];
    var toBind = "onwheel" in document || document.documentMode >= 9 ? [ "wheel" ] : [ "mousewheel", "DomMouseScroll", "MozMousePixelScroll" ];
    var lowestDelta, lowestDeltaXY;
    if ($.event.fixHooks) {
        for (var i = toFix.length; i; ) {
            $.event.fixHooks[toFix[--i]] = $.event.mouseHooks;
        }
    }
    $.event.special.mousewheel = {
        "setup": function() {
            if (this.addEventListener) {
                for (var i = toBind.length; i; ) {
                    this.addEventListener(toBind[--i], handler, false);
                }
            } else {
                this.onmousewheel = handler;
            }
        },
        "teardown": function() {
            if (this.removeEventListener) {
                for (var i = toBind.length; i; ) {
                    this.removeEventListener(toBind[--i], handler, false);
                }
            } else {
                this.onmousewheel = null;
            }
        }
    };
    $.fn.extend({
        "mousewheel": function(fn) {
            return fn ? this.bind("mousewheel", fn) : this.trigger("mousewheel");
        },
        "unmousewheel": function(fn) {
            return this.unbind("mousewheel", fn);
        }
    });
    function handler(event) {
        var orgEvent = event || window.event, args = [].slice.call(arguments, 1), delta = 0, deltaX = 0, deltaY = 0, absDelta = 0, absDeltaXY = 0, fn;
        event = $.event.fix(orgEvent);
        event.type = "mousewheel";
        // Old school scrollwheel delta
        if (orgEvent.wheelDelta) {
            delta = orgEvent.wheelDelta / 120;
        }
        if (orgEvent.detail) {
            delta = orgEvent.detail * -1;
        }
        // New school wheel delta (wheel event)
        if (orgEvent.deltaY) {
            deltaY = orgEvent.deltaY * -1;
            delta = deltaY;
        }
        if (orgEvent.deltaX) {
            deltaX = orgEvent.deltaX;
            delta = deltaX * -1;
        }
        // Webkit
        if (orgEvent.wheelDeltaY !== undefined) {
            deltaY = orgEvent.wheelDeltaY;
        }
        if (orgEvent.wheelDeltaX !== undefined) {
            deltaX = orgEvent.wheelDeltaX * -1;
        }
        // Look for lowest delta to normalize the delta values
        absDelta = Math.abs(delta);
        if (!lowestDelta || absDelta < lowestDelta) {
            lowestDelta = absDelta;
        }
        absDeltaXY = Math.max(Math.abs(deltaY), Math.abs(deltaX));
        if (!lowestDeltaXY || absDeltaXY < lowestDeltaXY) {
            lowestDeltaXY = absDeltaXY;
        }
        // Get a whole value for the deltas
        fn = delta > 0 ? "floor" : "ceil";
        delta = Math[fn](delta / lowestDelta);
        deltaX = Math[fn](deltaX / lowestDeltaXY);
        deltaY = Math[fn](deltaY / lowestDeltaXY);
        // Add event and delta to the front of the arguments
        args.unshift(event, delta, deltaX, deltaY);
        return ($.event.dispatch || $.event.handle).apply(this, args);
    }
});/**
 * @describe: 工具类 函数类工具集
 * @author: wulj
 */
define("/src/scripts/utils/utils", function(require, exports, module) {
    module.exports = {
        "goTop": require("/src/scripts/utils/component/goTop"),
        "group": require("/src/scripts/utils/component/group"),
        "lightips": require("/src/scripts/utils/component/lightips"),
        "speech": require("/src/scripts/utils/component/speech"),
        "tab": require("/src/scripts/utils/component/tab"),
        "toggle": require("/src/scripts/utils/component/toggle"),
        "tg": require("/src/scripts/utils/component/tg"),
        "submitContent": require("/src/scripts/utils/component/submitContent"),
        "validator": require("/src/scripts/utils/component/validator"),
        "align": require("/src/scripts/utils/component/align"),
        "kDate": require("/src/scripts/utils/component/kDate"),
        "suggest": require("/src/scripts/utils/component/suggest/suggest"),
        "langSelect": require("/src/scripts/utils/component/languageSelect"),
        "shareTo": require("/src/scripts/utils/component/share"),
        "mousewheel": require("/src/scripts/utils/component/jquery-mousewheel"),
        "textchange": require("/src/scripts/utils/component/jquery-textchange"),
        "loadStyle": function(stylePath) {
            var container = document.getElementsByTagName("head")[0];
            var addStyle = document.createElement("link");
            addStyle.rel = "stylesheet";
            addStyle.type = "text/css";
            addStyle.media = "screen";
            addStyle.href = stylePath;
            container.appendChild(addStyle);
        },
        "val": function _val(obj, keyStrings) {
            var keys = keyStrings.split(".");
            if (keys.length === 1) {
                if (obj[keys[0]]) {
                    return obj[keys[0]];
                } else {
                    return;
                }
            }
            var curKey = keys[0];
            for (var k in obj) {
                if (k == curKey) {
                    return _val(obj[curKey], keyStrings.substring(keyStrings.indexOf(".") + 1));
                }
            }
        },
        "_foreach": {
            get count() {
                return this.first++;
            },
            "start": function(x) {
                this.first = x;
                return "";
            },
            "first": 1
        },
        /**
     * 事件托管，间隔{time}毫秒后执行{func}
     * @param func  被托管函数
     * @param time  时间间隔
     */
        "timero": function(func, time) {
            var Proxy = function(func, time) {
                this.func = func;
                this.time = time;
            };
            Proxy.prototype = {
                "run": function() {
                    var self = this;
                    this.clear();
                    this.timeout = setTimeout(function() {
                        if ($.isFunction(self.func)) {
                            self.func();
                        }
                    }, self.time);
                },
                "clear": function() {
                    clearTimeout(this.timeout);
                }
            };
            return new Proxy(func, time);
        },
        "timerProxy": function() {
            var clearProxy = function() {
                if (!!window.timerProxyTimeout) {
                    window.clearTimeout(window.timerProxyTimeout);
                }
            };
            return function timer(func, time) {
                this.timerProxy.clearProxy = timer.clearProxy = clearProxy;
                // 直接将清除代理的方法挂在函数上，IE对timer.proxy支持的不好，直接挂到目标对象上
                clearProxy();
                window.timerProxyTimeout = window.setTimeout(function() {
                    if ($.isFunction(func)) {
                        func();
                    }
                }, time);
            };
        }(),
        /**
     * 可中断的 interval
     * iInterval(startDoIt[, doTime])
     * @param startDoIt 默认的执行函数
     * @param doTime  默认的执行间隔时间
     * @return {Object}  生成可控制的对象
     */
        "iInterval": function() {
            var broad = {};
            var currentKey = 0;
            /**
       * 暂停 interval
       * @param iname interVal 名称
       */
            var stopInterval = function(iname) {
                if (typeof broad[iname] !== undefined) {
                    clearInterval(broad[iname]);
                }
            };
            /**
       * 开始 interval
       * @param iname  interVal 名称
       * @param startDo 执行函数
       * @param time  间隔
       */
            var startInterval = function(iname, startDo, time) {
                stopInterval(iname);
                broad[iname] = setInterval(function() {
                    if ($.isFunction(startDo)) {
                        startDo();
                    }
                }, time);
            };
            return function(startDoIt, doTime) {
                var curryingStart = Function.prototype.bind.apply(startInterval, [ undefined, currentKey ].concat(Array.prototype.slice.call(arguments)));
                var curryingStop = stopInterval.bind(undefined, currentKey);
                currentKey += 1;
                return {
                    "start": curryingStart,
                    "stop": curryingStop
                };
            };
        }(),
        /**
     * 将一个浏览器中的collection（包括NodeList等）转化为一个数组
     * @param obj collection对象
     */
        "makeArray": function(obj) {
            return Array.prototype.slice.call(obj, 0);
        },
        /**
     * 安全锁，保证在所有逻辑执行完之前不会受理新请求
     * @param func 包裹函数，是函数具有线程锁，注意，必须在函数执行完毕后，执行最后一个参数（解锁函数）
     * var synchFunc = ISee.util.synchronize(function(arg1,arg2...) {
         *     var openLock = arguments[arguments.length - 1];
         *     ... 函数本身逻辑 ...
         *     ... 必要的时候解锁 openLock(); ...
         * });
     */
        "synchronize": function(func) {
            var self = this;
            func.synchronizeed = false;
            var openLock = function() {
                func.synchronizeed = false;
            };
            return function() {
                if (func.synchronizeed) {
                    return;
                }
                func.synchronizeed = true;
                var args = self.makeArray(arguments);
                args.push(openLock);
                func.apply(this, args);
            };
        },
        "spaceTrim": function() {
            /**
       * 将val由s分割，同时对val中的s去头去尾去重，再由l连接
       * @param val
       * @param s
       * @param l
       */
            var trimAndReplace = function(val, s, l) {
                //
                var noSpace = val.split(s);
                val = "";
                for (var i = 0; i < noSpace.length; i++) {
                    if (noSpace[i].length > 0) {
                        if (val != "" && i > 0 && i <= noSpace.length - 1) {
                            val += l;
                        }
                        val += noSpace[i];
                    }
                }
                return val;
            };
            /**
       * 空格去重去头去尾，全角空格将转为半角
       * @param val
       */
            return function(val) {
                val = trimAndReplace(trimAndReplace(val, " ", " "), "　", " ");
                return trimAndReplace(trimAndReplace(val, " 　", " "), "　 ", " ");
            };
        }(),
        "isAlpha": function(str) {
            return /[a-zA-Z']+/.test(str);
        },
        "isChinese": function(unicodeChar) {
            var re = /[^\u4e00-\u9fa5]/;
            if (re.test(unicodeChar)) {
                return false;
            }
            return true;
        },
        "selectContentAt": function(node) {
            var range = document.createRange();
            range.selectNodeContents(node);
            var selObj = window.getSelection();
            selObj.removeAllRanges();
            selObj.addRange(range);
        },
        /**
     * 加 log
     * @param url  人工翻译等外链
     * @param q    查询词
     * @param pos  位置  0  1
     * @param keyfrom  deskdict.main
     * @param action  CLICK  SHOW
     * @param ctype   log的类型
     * @returns {boolean}
     */
        "ctlog": function(url, q, pos, keyfrom, action, ctype) {
            // var dateTime = new Date();
            // var rnd = "&rnd=" + dateTime.getTime();
            // var appVer = "";
            // var appId = "";
            // var appVendor = "";
            // var abTest = "";
            // try {
            //     abTest = require("/src/scripts/utils/store")("userConfig").local.value.abtest || "0";
            //     appVer = window.external.cppCall("getAppVersionString");
            //     appId = window.external.cppCall("getAppID");
            //     appVendor = window.external.cppCall("getVendor");
            // } catch (e) {}
            // var i = new Image();
            // i.src = "http://cidian.youdao.com/apps/log.html?q=" + encodeURIComponent(q) + "&url=" + encodeURIComponent(url) + "&pos=" + pos + "&id=" + appId + "&keyfrom=" + keyfrom + "&appVer=" + appVer + "&vendor=" + appVendor + "&abTest=" + abTest + "&action=" + action + "&ctype=" + ctype + rnd;
            return true;
        },
        /**
     * 图片转base64编码，支持html5 canvas 的浏览器可用
     * @param img
     */
        "img2base64": function(img) {
            var defer = new $.Deferred();
            img.onload = function() {
                if (img.complete) {
                    var canvas = document.createElement("canvas");
                    canvas.width = img.width;
                    canvas.height = img.height;
                    // Copy the image contents to the canvas
                    var ctx = canvas.getContext("2d");
                    ctx.drawImage(img, 0, 0);
                    defer.resolve(ctx.canvas.toDataURL("image/png"));
                }
            };
            return defer;
        }
    };
});/**
 * 获取查询参数
 */
define("/src/scripts/render/params", function(require, exports, module) {
    var utils = require("/src/scripts/utils/utils");
    var _keyFrom = "";
    var realLang;
    module.exports = {
        set q(val) {
            $("#queryinput").val((val || "").trim() || "");
        },
        get q() {
            return $("#queryinput").val() || "";
        },
        set le(val) {
            if (typeof val !== "undefined") {
                utils.langSelect.changeLang(val);
                require("/src/scripts/external").langChange(val);
            }
        },
        get le() {
            return $(".js-lang-type").data("lang") || "eng";
        },
        set rle(val) {
            realLang = val;
        },
        get rle() {
            return realLang;
        },
        get keyfrom() {
            return _keyFrom || "deskdict_deepin";
        },
        set keyfrom(from) {
            _keyFrom = from;
        },
        "reset": function(q, le) {
            this.q = q;
            this.le = le;
        }
    };
});/**
 * @date 13-2-27
 * @describe: 对客户端接口
 * @author: wulj
 * @version: 1.0
 */
/*jslint browser:true, vars:true, nomen:true, indent:4, maxlen:80*/
/*jslint plusplus:true, sloppy:true, todo:true, unparam:true, regexp:true*/
/*global define:true, $:true , ke:true*/
define("/src/scripts/external", function(require, exports, module) {
    var toArray = function(arr) {
        var args = Array.prototype.slice.call(arr, 0);
        for (var i = 0; i < args.length; i++) {
            if (typeof args[i] === "function") {
                args[i] = "匿名函数";
            }
        }
        return args;
    };
    var audioPlayer, audioPlayerHtml;
    /**
   * 音频播放器
   * @type {*}
   */
    audioPlayer = function() {
        return $('<audio id="dictVoice" style="display: none;"></audio>').appendTo("body").get(0);
    };
    audioPlayerHtml = audioPlayer();
    if (!window.external) {
        window.external = {};
    }
    /**
   * C++ 端API描述，以及前端debug实现
   */
    var externalAPI = {
        "on": function(eventName, func) {
            youdao_api.addEvent(eventName, func);
        },
        "saveString": function(key, value, group) {
            localStorage.setItem(key, value);
        },
        "loadString": function(key, group) {
            //            console.log('cppCall [loadString] and arguments: ' + toArray(arguments).join(', '));
            return localStorage.getItem(key);
        },
        "getAppVersionString": function() {
            console.log("cppCall [getAppVersionString] and arguments: " + toArray(arguments).join(", "));
            return "6.0.0.1";
        },
        "getAppID": function() {
            console.log("cppCall [getAppID] and arguments: " + toArray(arguments).join(", "));
            return "123456";
        },
        "getAppVersion": function() {
            console.log("cppCall [getAppVersion] and arguments: " + toArray(arguments).join(", "));
            return 60000000001;
        },
        "getInstallerName": function() {
            console.log("cppCall [getInstallerName] and arguments: " + toArray(arguments).join(", "));
            return "YoudaoDict";
        },
        "getZengqiangFlag": function() {
            console.log("cppCall [getZengqiangFlag] and arguments: " + toArray(arguments).join(", "));
            return 2;
        },
        /**
     *
     * @param result 结果
     * [
     *    word:
     *    isAdded:
     * ]
     */
        "checkWordBook": function(result) {
            // console.log("asyncCall [checkWord] and arguments: " + toArray(arguments).join(", "));
        },
        /* 查询接口 ------------------------------------------------------------------------------*/
        "mainQuery": function(keyfrom, type, keyword, optional, func) {
            var params = require("/src/scripts/render/params");
            keyword = encodeURIComponent(keyword);
            if (type == 0) {
                $.ajax("http://dict.youdao.com/jsonapi?client=deskdict_deepin&le=" + JSON.parse(optional).lang + "&q=" + keyword + "&" + encodeURIComponent("dicts={%22count%22:9,%22dicts%22:[[%22ce%22],[%22ec%22],[%22cj%22],[%22jc%22],[%22cf%22],[%22fc%22],[%22ck%22],[%22kc%22],[%22pic_dict%22]]}"), {
                    "crossDomain": true
                }).done(function(data, status, additional) {
                    func([ 0, JSON.stringify(data), JSON.stringify({
                        "isNewSearch": true,
                        "isFinish": false
                    })]);
                }).error(function(){
                    //alert(1);
                    console.log("offline dict query: " + keyword);
                    var text = decodeURIComponent(keyword);
                    var offline_result = youdao_api.getMainQuery(text);
                    var data = {};
                    if (offline_result){
                        // offline_result = JSON.parse(offline_result);
                        var trans = offline_result['trans'];
                        var sm = offline_result['sm'];
                        var dict_type = offline_result['dict_type'] == 0 ? "ce" : "ec";
                        
                        data["simple"] = { "query": text };
                        data["error"] = "network_error";
                        data[dict_type] = {}
                        data[dict_type]['source'] = {}
                        data[dict_type]['source']['name'] = "基本释义";
                        data[dict_type]['source']['url'] = "http://dict.youdao.com";
                        data[dict_type]['word'] = [{}];
                        data[dict_type]['word'][0]["trs"] = [];
                        data[dict_type]['word'][0]["return-phrase"] = { "l": { "i": text } };
                        data[dict_type]['word'][0]["usspeech"] = text + "&type=2";
                        data[dict_type]['word'][0]["usphone"] = sm;
                        for(var i in trans){
                            var item = { "tr": [ { "l": { "i": [ trans[i] ] } } ] };
                            data[dict_type]['word'][0]["trs"].push(item);
                        }
                    }
                    
                    func([ 0, JSON.stringify(data), JSON.stringify({
                        "isNewSearch": true,
                         "isFinish": true
                    })]);
                });
                $.ajax("http://dict.youdao.com/jsonapi?client=deskdict_deepin&le=" + JSON.parse(optional).lang + "&q=" + keyword + "&" + encodeURIComponent("dicts={%22count%22:5,%22dicts%22:[[%22web_trans%22],[%22collins%22],[%22phrs%22],[%22blng_sents_part%22],[%22baike%22]]}"), {
                    "crossDomain": true
                }).done(function(data, status, additional) {
                    func([ 0, JSON.stringify(data), JSON.stringify({
                        "isNewSearch": false,
                        "isFinish": false
                    }) ]);
                });
                $.ajax("http://dict.youdao.com/jsonapi?client=deskdict_deepin&le=" + JSON.parse(optional).lang + "&q=" + keyword + "&" + encodeURIComponent("dicts={%22count%22:14,%22dicts%22:[[%22special%22],[%22ee%22],[%22hh%22],[%22ec21%22],[%22ce_new%22]," + "[%22syno%22],[%22rel_word%22],[%22media_sents_part%22],[%22auth_sents_part%22],[%22fanyi%22]" + ",[%22fanyi%22],[%22web_search%22],[%22typos%22],[%22collins_part%22]]}"), {
                    "crossDomain": true
                }).done(function(data, status, additional) {
                    data.isFinish = true;
                    func([ 0, JSON.stringify(data), JSON.stringify({
                        "isNewSearch": false,
                        "isFinish": true
                    }) ]);
                });
                youdao_api.emitDictQueryLog();
            } else {
               // alert(type)
                $.ajax("http://dict.youdao.com/jsonresult?q=" + keyword + "&type=1&client=deskdict_deepin&keyfrom=deskdict_deepin&pos=-1&le=" + JSON.parse(optional).lang , {
                    "crossDomain": true
                }).done(function(data, status, additional) {
                    func([ 0, JSON.stringify(data), JSON.stringify({}) ]);
                }).error(function(){
                    var text = decodeURIComponent(keyword);
                    var offline_result = youdao_api.getMainQuery(text);        
                    var data = {};
                    if (offline_result)
                    {
                        var trans = offline_result['trans'];
                        var sm = offline_result['sm'];
                        var dict_type = offline_result['dict_type'] == 0 ? "ce" : "ec";
                        var basic = [];
                        data["lang"] = "eng";
                        data["sm"] = sm;
                        data["uksm"] = sm;
                        data["ltype"] = dict_type;
                        data["oq"] = text;
                        data["rq"] = text.toUpperCase();
                        for(var i in trans){ 
                              basic.push(trans[i]); 
                         }
                        data["basic"] = basic;
                    }
                   func([ 0, JSON.stringify(data), JSON.stringify({}) ]);
                });
            }
        },
        "exampleQuery": function(keyfrom, type, keyword, optional, func) {
            var params = require("/src/scripts/render/params");
            var optional_obj = {};
            var tmp_a = optional.split("&");
            for(var i=0; i<tmp_a.length; i++){
                var tmp_ai = tmp_a[i].split("=");
                if(tmp_ai.length == 2){
                    optional_obj[tmp_ai[0]] = tmp_ai[1];
                }
            }
            var req_data = {
                "q": keyword,
                "keyfrom": "deskdict_deepin",
                "dogVersion": 1.0,
                "dogui": "json",
                "client": "deskdict_deepin",
                "id": "92dc50aa4970fb72d",
                "vendor": "YoudaoDict.neokylin",
                "in": "YoudaoDict",
                "appVer": "1.0",
                "appZengqiang": 0,
                "abTest": 5,
                "le": params.le
            };
            if(optional_obj.hasOwnProperty("ljtype")){
                switch (optional_obj["ljtype"]){
                    case "blng":
                    req_data["dicts"] = JSON.stringify({"count":1, "dicts":[["blng_sents"]]});
                    req_data["ljblngcont"] = parseInt(optional_obj["ljblngcont"]);
                    break;
                    case "mdia":
                    req_data["dicts"] = JSON.stringify({"count":1, "dicts":[["media_sents"]]});
                    req_data["ljmdia"] = parseInt(optional_obj["ljmdia"]);
                    break;
                    case "auth":
                    req_data["dicts"] = JSON.stringify({"count":1, "dicts":[["auth_sents"]]});
                    break;
                    default:
                    req_data["dicts"] = JSON.stringify({"count":1, "dicts":[["blng_sents"]]});
                    req_data["ljblngcont"] = 0;
                }
            }
            else{
                req_data["dicts"] = JSON.stringify({"count":1, "dicts":[["blng_sents"]]});
                req_data["ljblngcont"] = 0;
            }
            $.ajax("http://dict.youdao.com/jsonapi", {
                "data": req_data,
                "crossDomain": true
            }).done(function(data) {
                func([ 0, JSON.stringify(data), JSON.stringify({}) ]);
            }).error(function(e) {
                console.log(e);
            });
        },
        "wikiQuery": function(keyfrom, type, keyword, optional, func) {
            var params = require("/src/scripts/render/params");
            keyword = encodeURIComponent(keyword);
            $.ajax("http://dict.youdao.com/jsonapi?nocache=ture&client=deskdict_deepin&keyfrom=deskdict_deepin&q=" + keyword + optional, {
                "crossDomain": true
            }).done(function(data) {
                func([ 0, JSON.stringify(data), JSON.stringify({}) ]);
            }).error(function() {
                $.ajax("http://dict.youdao.com/jsonapi?nocache=ture&client=deskdict_deepin&keyfrom=deskdict_deepin&q=" + keyword + "&" + encodeURIComponent("dicts={%22dicts%22:[[%22baike_relative%22]]}"), {
                    "crossDomain": true
                }).done(function(data) {
                    func([ JSON.stringify(data) ]);
                }).error(function() {});
            });
        },
        "transQuery": function(keyfrom, type, keyword, optional, lang, func) {
            data = youdao_api.fanyi(keyword, keyfrom, lang);
            func([data]);
            // url = "http://fanyi.youdao.com/translate?keyfrom=deskdict.main";
            // url += "&dogVersion=1.0&ue=utf8&doctype=json&xmlVersion=1.6&client=deskdict&id=92dc50aa4970fb72d&vendor=kingsoft.gj&in=youdaodict_kingsoft.gj_6.2.54.2064&appVer=6.3.65.9029&appZengqiang=0&abTest=5&smartresult=dict&smartresult=rule";
            // url += "&type=" + lang;
            // url += "&i=" + keyword;
            // $.ajax({
            //     "url": url,
            //     "type": "get",
            //     "dataType": "json"
            // }).done(function(data) {
            //     data = [JSON.stringify(data)];
            //     func(data);
            // }).error(function() {
            //     console.log("[error] transQuery: " + keyword);
            // });
            // console.log("asyncCall [transQuery] and arguments: " + toArray(arguments).join(", "));
        },
        "wikiSuggest": function(keyword, num, func) {
            $.ajax({
                "url": "http://dict.youdao.com/wikisuggest/suggest/tbsuggest.s?type=DESKDICT&num=4&q=" + keyword,
                "type": "get",
                "dataType": "xml"
            }).done(function(xmlData) {
                var lang = $(xmlData).find("type").text();
                var lists = $(xmlData).find("item").map(function(indx, val) {
                    return '{"trans":"' + $(val).find("explain").text() + '", "word":"' + $(val).find("title").text() + '", "lang": "' + lang + '"}';
                });
                func([ "[" + Array.prototype.join.call(lists, ",") + "]" ]);
            }).error(function() {
                func([ "[]" ]);
            });
        },
        "mainSuggest": function(keyword, num, func) {
            var select_lang = $(".js-lang-type").data("lang");
            $.ajax({
                "url": "http://dict.youdao.com/suggest?type=DESKDICT&client=deskdict_deepin&keyfrom=deskdict_deepin&num=4&q=" + keyword + "&ver=2.0&le=" + select_lang,
                "type": "get",
                "dataType": "xml"
            }).done(function(xmlData) {
                var lang = $(xmlData).find("type").text();
                var lists = $(xmlData).find("item").map(function(indx, val) {
                    return '{"trans":"' + $(val).find("explain").text() + '", "word":"' + $(val).find("title").text() + '", "lang": "' + lang + '"}';
                });
                func([ "[" + Array.prototype.join.call(lists, ",") + "]" ]);
            }).error(function() {
                if (offline_query_timeout_id) clearTimeout(offline_query_timeout_id);
                offline_query_timeout_id = setTimeout(function() {
                    var origin_results = youdao_api.getSuggest(keyword, num);
                    var results = [];
                    for(var i in origin_results){
                        var item = origin_results[i];
                        results.push({"trans": item["explain"], "word": item["title"], "lang": "eng"});
                    }
                    func([ JSON.stringify(results) ]);
                }, 200);
            });
        },
        "quit": function() {
            console.log("cppCall [quit] and arguments: " + toArray(arguments).join(", "));
        },
        "closeWindow": function() {
            if(youdao_config.get_basic_option("close_to_tray")){
                DAE.app.hide();
            }else{
                DAE.app.quit();
                if(youdao_indicator.isExists()){
                    youdao_indicator.Quit();
                }
            }
        },
        "min": function() {
            DAE.app.minimize();
        },
        "max": function() {
            if(DAE.app.isMaximized()){
                DAE.app.normalize();
            }
            else{
                DAE.app.maximize();
            }
        },
        "popSysMenu": function() {
            console.log("cppCall [popSysMenu] and arguments: " + toArray(arguments).join(", "));
        },
        "captionMouseDown": function() {
            console.log("cppCall [captionMouseDown] and arguments: " + toArray(arguments).join(", "));
        },
        //  direct参数取值对应四个方向：
        //      "NESW" -- /
        //      "NWSE" -- \
        //      "NS"   -- |
        //      "WE"   -- -
        "sizingMouseDown": function(direct) {
            console.log("cppCall [sizingMouseDown] and arguments: " + toArray(arguments).join(", "));
        },
        "debug": function() {
            console.log("cppCall [debug] and arguments: " + toArray(arguments).join(", "));
        },
        "loginout": function() {
            console.log("cppCall [loginout] and arguments: " + toArray(arguments).join(", "));
        },
        "checkUpdate": function() {
            console.log("cppCall [checkUpdate] and arguments: " + toArray(arguments).join(", "));
        },
        "option": function() {
            console.log("cppCall [option] and arguments: " + toArray(arguments).join(", "));
        },
        "guide": function() {
            console.log("cppCall [guide] and arguments: " + toArray(arguments).join(", "));
        },
        "plugins": function() {
            console.log("cppCall [plugins] and arguments: " + toArray(arguments).join(", "));
        },
        "toggleTopMost": function() {
            // youdao_api.initTopMost();
        },
        "aboutDlg": function() {
            console.log("cppCall [aboutDlg] and arguments: " + toArray(arguments).join(", "));
        },
        "openMini": function() {
            console.log("cppCall [openMini] and arguments: " + toArray(arguments).join(", "));
        },
        "openWordbook": function() {
            console.log("cppCall [openWordbook] and arguments: " + toArray(arguments).join(", "));
        },
        "openStudy": function() {
            console.log("cppCall [openStudy] and arguments: " + toArray(arguments).join(", "));
        },
        "openZFanyi": function() {
            console.log("cppCall [openZFanyi] and arguments: " + toArray(arguments).join(", "));
        },
        "openMobile": function() {
            console.log("cppCall [openMobile] and arguments: " + toArray(arguments).join(", "));
        },
        "openPictDict": function(word, id) {
            console.log("cppCall [openPictDict] and arguments: " + toArray(arguments).join(", "));
        },
        "openBbs": function(word, id) {
            console.log("cppCall [openBbs] and arguments: " + toArray(arguments).join(", "));
        },
        "openNewWnd": function(url, height, width, id, title) {
            DAE.browse(url);
            console.log("cppCall [openNewWnd] and arguments: " + toArray(arguments).join(", "));
        },
        "screenTrans": function() {
            console.log("cppCall [switchScreenTrans] and arguments: " + toArray(arguments).join(", "));
        },
        "strokeTrans": function() {
            console.log("cppCall [switchStrokeTrans] and arguments: " + toArray(arguments).join(", "));
        },
        "showSimiSent": function() {
            console.log("cppCall [showSimiSent] and arguments: " + toArray(arguments).join(", "));
        },
        "langChange": function(lang) {
            console.log("cppCall [langChange] and arguments: " + toArray(arguments).join(", "));
        },
        "setCurFanyiType": function(type) {
            console.log("cppCall [setCurFanyiType] and arguments: " + toArray(arguments).join(", "));
        },
        "verify": function(imageUrl, submitUrl, productName, redirectUrl, func) {
            console.log("cppCall [verify] and arguments: " + toArray(arguments).join(", "));
        },
        "requestData": function(url, func) {
            $.ajax(url).done(function(data) {
                func([ JSON.stringify(data) ]);
            });
        },
        "downloadFile": function(list, down, func) {
            var keys = Object.keys(list);
            for (var key in keys) {
                func([ list[keys[key]]["index"], list[keys[key]]["url"] ]);
            }
        },
        "clearFirstPage": function(list) {
            // console.log("cppCall [clearFirstPage] and arguments: " + toArray(arguments).join(", "));
        },
        "addWord": function(word, phonetic, trans) {
            console.log("cppCall [addWord] and arguments: " + toArray(arguments).join(", "));
        },
        "modWord": function(word) {
            console.log("cppCall [modWord] and arguments: " + toArray(arguments).join(", "));
        },
        // 发音接口，参数url:字符串，音频数据地址
        "playSound": function(url) {
            externalAPI.stopSound();
            $(audioPlayerHtml).attr("src", url);
            audioPlayerHtml.play();
            console.log("cppCall [playSound] and arguments: " + toArray(arguments).join(", "));
        },
        // 停止发音
        "stopSound": function() {
            if ($.isFunction(audioPlayerHtml.pause)) {
                audioPlayerHtml.pause();
                if (audioPlayerHtml.currentTime > 0) {
                    audioPlayerHtml.currentTime = 0;
                }
            }
            console.log("cppCall [stopSound] and arguments: " + toArray(arguments).join(", "));
        },
        /**
     *
     * @param block
     */
        "blockCharInput": function(block) {
            // console.log("cppCall [blockCharInput] and arguments: " + toArray(arguments).join(", "));
        },
        /**
     * 开始录音
     *
     * callback 参数
     *
     * type: begin_success ||  begin_error || end ||  get_ampl
     * data: 音量大小
     *
     * function (type, data) {
            //	alert("in BeginRecord callback:" + data);
            //	t = this;
                if (type=="get_ampl") {
                    document.getElementById("record_ampl").innerHTML = data;
                }
            });
     */
        "WaveRecorder_BeginRecord": function(callback) {
            console.log("cppCall [WaveRecorder_BeginRecord] and arguments: " + toArray(arguments).join(", "));
            callback("end");
        },
        /**
     *
     */
        "WaveRecorder_EndRecord": function() {
            console.log("cppCall [WaveRecorder_EndRecord] and arguments: " + toArray(arguments).join(", "));
        },
        /**
     * 开始播放
     * callback 参数
     * type: begin_success ||  begin_error || end
     */
        "WaveRecorder_BeginPlay": function(callback) {
            console.log("cppCall [WaveRecorder_BeginPlay] and arguments: " + toArray(arguments).join(", "));
            callback("end");
        },
        "WaveRecorder_EndPlay": function() {
            console.log("cppCall [WaveRecorder_EndPlay] and arguments: " + toArray(arguments).join(", "));
        },
        /**
     * 获取音频数据
     * @param callback
     *
     * callback 参数
     * type: begin_success ||  begin_error || end
     */
        "WaveRecorder_GetWaveData": function(callback) {
            console.log("cppCall [WaveRecorder_GetWaveData] and arguments: " + toArray(arguments).join(", "));
            callback([ 1, 2, 3, 4, 5, 6 ]);
        },
        "copyText": function(text) {
            console.log("cppCall [copyText] and arguments: " + toArray(arguments).join(", "));
        },
        "setSimiData": function(text) {
            // console.log("cppCall [setSimiData] and arguments: " + toArray(arguments).join(", "));
        },
        "showHandInput": function() {
            console.log("cppCall [showHandInput] and arguments: " + toArray(arguments).join(", "));
        },
        "hideHandInput": function() {
            console.log("cppCall [hideHandInput] and arguments: " + toArray(arguments).join(", "));
        },
        /**
     * 广告接口
     */
        "changeFrameAdv": function() {
            console.log("cppCall [changeFrameAdv] and arguments: " + toArray(arguments).join(", "));
        },
        "closeFrameAdv": function() {
            console.log("cppCall [closeFrameAdv] and arguments: " + toArray(arguments).join(", "));
        },
        "showPopAdv": function(url) {
            console.log("cppCall [showPopAdv] and arguments: " + toArray(arguments).join(", "));
        },
        "getVendor": function(url) {
            console.log("cppCall [getVendor] and arguments: " + toArray(arguments).join(", "));
        },
        "onDOMContentLoaded": function() {
            console.log("cppCall [onDOMContentLoaded] and arguments: " + toArray(arguments).join(", "));
        },
        "showUserSettting": function() {
            console.log("cppCall [showUserSettting] and arguments: " + toArray(arguments).join(", "));
        }
    };
    /**
   * 调用C++接口
   * @returns {{}}
   */

    var cppCall = function(){
        var funcName = arguments[0];
        var realArguments = [];
        if(arguments.length > 1){
            for(var i=1; i<arguments.length; i++){
                realArguments.push(arguments[i]);
            }
        }
        var externalFunction = eval("youdao_api." + funcName);
        // 如果
        if (externalFunction !== undefined) {
            externalFunction.apply(null, realArguments);
        }
        else{
            externalAPI[funcName].apply(null, realArguments);
        }
    }
    var cppCallExternalAPI = function() {
        var callCppAPI = {};
        for (var funcName in externalAPI) {
            callCppAPI[funcName] = cppCall.bind(youdao_api, funcName);
        }
        return callCppAPI;
    };

    module.exports = cppCallExternalAPI();
});/**
 * Created by DELL on 2014/5/30.
 */
/*jslint browser:true, vars:true, nomen:true, indent:4, maxlen:80*/
/*jslint plusplus:true, sloppy:true, todo:true, unparam:true, regexp:true*/
/*global define:true, $:true , ke:true, kDate:true */
define("/src/scripts/render/dict/start/clearUpLocal", function(require, exports, module) {
    var kDate = require("/src/scripts/utils/component/kDate");
    var store = require("/src/scripts/utils/store"), external = require("/src/scripts/external");
    var firstPageData = store("waterfallData").local;
    var storedImage = store("storedImage").local;
    var everydayenglishData = store("everydayenglishData").local;
    var clearupImageCache = function(days) {
        var pre15 = new kDate().getDate(0, 0, -1 * days).toString("-0");
        var remainImageList = [];
        var remainImageKeyList = [];
        //更新首页瀑布流数据本地存储
        var firstPd = firstPageData.value;
        for (var date in firstPd) {
            if (date > pre15) {
                firstPd[date].forEach(function(val) {
                    var path = val["image-desk2"];
                    if (path !== undefined) {
                        remainImageKeyList[path] = true;
                        //中文目录会被encode，所以，如果不decode，C++端会错误删除本应保留的图片
                        remainImageList.push(decodeURIComponent(path.slice(0, path.lastIndexOf("/") + 1)));
                    }
                });
            } else {
                delete firstPd[date];
            }
        }
        firstPageData.val = firstPd;
        //更新everydayenglishData本地存储
        var latestdays = Object.keys(everydayenglishData.value).sort().reverse();
        var everyPd = Object.create(everydayenglishData.value);
        everydayenglishData.val = {};
        latestdays.forEach(function(date, idx) {
            if (idx === 0) {
                everydayenglishData.add(date, everyPd[date]);
                var path = everyPd[date][0]["image-desk2"];
                remainImageKeyList[path] = true;
                //中文目录会被encode，所以，如果不decode，C++端会错误删除本应保留的图片
                remainImageList.push(decodeURIComponent(path.slice(0, path.lastIndexOf("/") + 1)));
            }
        });
        //更新图片本地存储
        var stored = storedImage.value;
        for (var imageurl in stored) {
            if (!remainImageKeyList[stored[imageurl]]) {
                delete stored[imageurl];
            }
        }
        storedImage.val = stored;
        //删除多余图片
        external.clearFirstPage(remainImageList);
    };
    var cleartime;
    module.exports = function(days) {
        if (!cleartime) {
            //启动后一分钟，清理本地存储
            cleartime = setTimeout(function() {
                clearupImageCache(days);
            }, 60 * 1e3);
        }
    };
});/*jslint browser:true, vars:true, nomen:true, indent:4, maxlen:80*/
/*jslint plusplus:true, sloppy:true, todo:true, unparam:true, regexp:true*/
/*global define:true, $:true , ke:true*/
define("/src/scripts/render/dict/start/defaultData", function(require, exports, module) {
    var everydayenglish = {
        "2014-05-02": [ {
            "id": 9018,
            "type": "每日一句",
            "version": 2,
            "client": "deskdict_deepin",
            "image-desk2": "src/images/index/TT.jpg",
            "voice": "http://dict.youdao.com/dictvoice?audio=Marriage+changes+you+as+a+person+in+ways+that+you+can%27t+imagine.",
            "voice_size": 11,
            "title": "Marriage changes you as a person in ways that you can't imagine.",
            "summary": "婚姻会用一种你想象不到的方式改变你。",
            "style": "head"
        } ]
    };
    var yesterdayenglish = {
        "2014-05-01": [ {
            "id": 9523,
            "type": "每日一句",
            "version": 2,
            "client": "deskdict_deepin",
            "image-desk2": "src/images/index/TT.jpg",
            "voice": "http://dict.youdao.com/dictvoice?audio=Progress+is+not+created+by+contented+people.",
            "voice_size": 11,
            "title": "Progress is not created by contented people.",
            "summary": "进步不是由满足的人所创造。",
            "style": "head"
        } ]
    };
    return {
        "yesterdayenglish": yesterdayenglish,
        "everydayenglish": everydayenglish
    };
});/**
 * 数据获取和管理
 */
/*jslint browser:true, vars:true, nomen:true, indent:4, maxlen:80*/
/*jslint plusplus:true, sloppy:true, todo:true, unparam:true, regexp:true*/
/*global define:true, $:true , ke:true*/
define("/src/scripts/render/dict/start/fetchData", function(require, exports, module) {
    var abTest = require("/src/scripts/utils/store")("userConfig").local.value.abtest || "0";
    var sever = "http://dict.youdao.com/infoline?apiversion=3.0&client=deskdict_deepin&abtest=" + abTest;
    var kDate = require("/src/scripts/utils/component/kDate");
    var curDay;
    var store = require("/src/scripts/utils/store"), external = require("/src/scripts/external");
    var firstPageData = store("waterfallData").local;
    var storedImage = store("storedImage").local;
    var everydayenglishData = store("everydayenglishData").local;
    var yesterdayenglishData = store("yesterdayenglishData").local;
    var daysData;
    var daycount = 0;
    var maxDays = 15;
    var firstStarted = true;
    /**
   * 下载到本地包裹函数
   * downloadFile本身有缺陷，当页面上使用两个downloadfile时，后一个的callback会覆盖前一个，当下载完成回调时，
   * 会出现错误的回调
   */
    external.downFiles = function() {
        var callbacks = {};
        return function(fileArr, callback) {
            var downType = !!fileArr[0] ? JSON.parse(fileArr[0].index).type : "head";
            //从下载数据中取出下载类别
            callbacks[downType] = callback;
            external.downloadFile(fileArr, false, function(ret) {
                callbacks[JSON.parse(ret[0]).type](ret);
            });
        };
    }();
    /**
   * 后端方法支持的数据格式，需要下载的图片需要给出以下字段
   * @param date 日期
   * @param data 数据
   * @param type 下载类型 区分匿名函数
   * @returns {{url: *, md5: string, type: string, index: *}}
   */
    var downImageList = function(date, data, type) {
        return data.map(function(_data) {
            return {
                "url": _data["image-desk2"],
                "md5": "",
                "type": "image",
                "index": JSON.stringify({
                    "type": type,
                    "date": date,
                    "id": _data.id,
                    "timestamp": $.now()
                })
            };
        });
    };
    /**
   * 更新离线数据和图片map
   * @param ret 下载后的返回值
   * @param date 日期
   * @param data 日期对应数据
   */
    var refreshDB = function(ret, date, data) {
        if (encodeURI(ret[1]) !== "") {
            var index = JSON.parse(ret[0] || {});
            for (var idx = 0, length = data.length; idx < length; idx++) {
                if (data[idx]["id"] === index["id"]) {
                    //存储到本地的数据，直接是本地的图片地址
                    storedImage.add(data[idx]["image-desk2"], encodeURI(ret[1]));
                    //维护一个 imgUrl --> 本地图片地址的列表
                    break;
                }
            }
        }
    };
    /**
   * 重置缓存
   */
    exports.reset = function() {
        daycount = 0;
        curDay = undefined;
    };

    /**
   * 下载图片到客户端指定的目录 deskdick/firstPage
   * cardsData 一天的数据
   * @param cardsData
   */
    exports.downImages = function(cardsData) {
        var directRun = new $.Deferred();
        var downloads = [];
        var curIdx = 0;
        var dataArr = cardsData.data;
        var imgMaps = storedImage.value;
        var undownloadeds = dataArr.filter(function(data) {
            //过滤出需要下载图片的数据
            if (data["image-desk2"] !== undefined && data["image-desk2"].indexOf("file:///") !== 0 && data["image-desk2"].indexOf("src/images/index/") !== 0 && imgMaps[data["image-desk2"]] === undefined) {
                downloads.push(new $.Deferred());
                return true;
            }
        });
        if (undownloadeds.length === 0) {
            //不需要下载图片，直接返回
            directRun.resolve();
            return directRun;
        } else {
            external.downFiles(downImageList(cardsData.date, undownloadeds, "info"), function(ret) {
                //此回调会被调用 cardsData.data.length 次
                refreshDB(ret, cardsData.date, dataArr);
                if (downloads[curIdx] !== undefined) {
                    downloads[curIdx].resolve();
                    curIdx += 1;
                }
            });
            return $.when.apply($, downloads);
        }
    };
    exports.getDataBetween = function(start, end) {
        return $.ajax(sever + "&startDate=" + start.toString("-0") + "&endDate=" + end.toString("-0"));
    };
    var isOffline = 1;
    var holdoffline;
    /**
   * 获取数据集合，取15天的，默认从今天开始，向前15天的数据
   * @_date 需要数据的日期
   *
   * 如果今天是 5.28 用户从 5.26 一直开着词典，如果仅仅检查daysData是否存在，数据会一直不更新，所以，需要检查daysData存在的同时，检查是否
   * 存在需要的那天的数据，如果这两个条件都满足，那么，直接返回此数据
   *
   * 否则，检查是不是离线了，如果是，则直接拒绝提供数据，并在30秒后重启服务端查询
   *
   * 前两个都不满足的情况下，从网络中请求从今天开始向前15天内的数据，并缓存到 daysData，取到的数据会过滤掉无效数据 {"2014-05-01":[]} 数组
   * 为空是无效数据。过滤掉无效数据后，检查是否存在合理的数据，如果存在，返回，如果不存在，拒绝提供数据。如果ajax请求失败，则拒绝提供数据，并记录
   * 一次offline；数据请求只要有一次成功，则视为网络是通的。
   *
   * 一般请求数据是先请求比较临近的日期，然后是前一天，所以，基本网络在正常的情况下，会只请求一次服务端数据就够用户一天的刷新首页使用了。
   *
   * 这种方式会在每次启动和日期变化（一般是新的一天）的时候更新一次页面缓存，然后会间接的更新本地存储，使缓存中的数据保持最新
   *
   * 另外，只有请求到新的数据，才会有可能下载图片，图片才可能增多，所以，在有新数据的时候，会根据数据删除多余图片。
   *
   */
    var getFromDataSets = function(_date) {
        var daydefer = new $.Deferred();
        if (daysData !== undefined && daysData[_date] !== undefined) {
            daydefer.resolve(daysData[_date]);
        } else if (isOffline % 3 === 0) {
            //累计三次为离线，暂时认为是离线状态，直接reject，30秒后恢复
            if (holdoffline === undefined) {
                holdoffline = setTimeout(function() {
                    isOffline = 1;
                    holdoffline = undefined;
                }, 30 * 1e3);
            }
            daydefer.reject();
        } else {
            var today = new kDate();
            var earlyDays = new kDate().getDate(0, 0, -1 * maxDays);
            exports.getDataBetween(earlyDays, today).then(function(data) {
                isOffline = 1;
                for (var date in data) {
                    //过滤掉空数据，坏数据
                    if (data[date].length === 0) {
                        delete data[date];
                    } else {
                        data[date] = data[date].filter(function(val, idx) {
                            //过滤掉坏的数据
                            return val["image-desk2"] !== undefined;
                        });
                    }
                }
                daysData = data;
                if (data[_date] !== undefined) {
                    daydefer.resolve(data[_date]);
                } else {
                    daydefer.reject();
                }
                require("/src/scripts/render/dict/start/clearUpLocal")(maxDays);
            }).fail(function() {
                daydefer.reject();
                isOffline++;
            });
        }
        return daydefer;
    };

    /**
   * 获取数据
   * 如果 date 不传递，则获取当天的数据
   * 第一次获取数据，会返回本地存储的数据，如果没有，返回安装包中的数据
   * 以后再访问，会先请求今天的数据，然后，下次会向前请求一天，以此类推
   * 如果请求天数已经大于15天，自动返回空值，告诉首页已经没有数据了
   * 如果不是空，那么，先从服务端获取当次天的数据，获取不到，尝试从本地缓存中获取。
   * @returns {*}
   */
    exports.getData = function() {
       
        var resultData = $.Deferred();
       
        return resultData;
    };

    /**
   * 获取默认数据，每次打开词典时，取出首先取出此数据
   * @returns {*}
   */
    exports.getDefaultyesterdayHeadData = function() {
        var dataDefer = $.Deferred();
        if (Object.keys(yesterdayenglishData.value).length === 0) {
            //没数据
            dataDefer.resolve(require("/src/scripts/render/dict/start/defaultData").yesterdayenglish["2014-05-01"][0]);
        } else {
            dataDefer.resolve(yesterdayenglishData.value[Object.keys(yesterdayenglishData.value).sort().reverse()[0]][0]);
        }
        return dataDefer;
    };

    /**
   * 获取默认数据，每次打开词典时，取出首先取出此数据
   * @returns {*}
   */
    exports.getDefaultHeadData = function() {
        var dataDefer = $.Deferred();
        if (Object.keys(everydayenglishData.value).length === 0) {
            //没数据
            dataDefer.resolve(require("/src/scripts/render/dict/start/defaultData").everydayenglish["2014-05-02"][0]);
        } else {
            dataDefer.resolve(everydayenglishData.value[Object.keys(everydayenglishData.value).sort().reverse()[0]][0]);
        }
        return dataDefer;
    };

    /**
   * 获取昨天的头图数据
   * @returns {*}
   */
    exports.getyesterdayHeadData = function(){
        var dataDefer = $.Deferred();
        var date = new kDate().preDay();
        $.ajax(sever + "&date=" + date).then(function(data) {  
            var cards = data["cards"];
            for (var i = 0; i < cards.length; i++) {
                if(cards[i]["style"] === "daily"){
                    var _data = cards[i];
                    yesterdayenglishData.add(date, _data);
                   
                    dataDefer.resolve(_data);
                } 
            }    
        }).fail(function() {
            dataDefer.reject();
        });
        return dataDefer;
    };

    /**
   * 获取当前天的头图数据
   * @returns {*}
   */
    exports.getHeadData = function() {
        var dataDefer = $.Deferred();
        var date = new kDate().toString("-0");
        $.ajax(sever + "&date=" + date).then(function(data) {  
            var cards = data["cards"];
            for (var i = 0; i < cards.length; i++) {
                if(cards[i]["style"] === "daily"){
                    var _data = cards[i];
                    everydayenglishData.add(date, _data);
                    dataDefer.resolve(_data);
                } 
            }    
        }).fail(function() {
            dataDefer.reject();
        });
        return dataDefer;
    };
});
/**
 * author: yuanzhen
 * date: 13-08-19
 */
define("/src/scripts/render/dict/shareTo", function(require) {
    var utils = require("/src/scripts/utils/utils");
    return function() {
        var uid = {
            "sina": "1699451730",
            "tencent": "youdaodict"
        };
        var appkey = {
            "sina": "1222576039",
            "tencent": "801063699"
        };
        var topic = {
            "word": "#每日一句#",
            "spoken": "#有道词典练口语#",
            "spokenProm": "#明星口语大PK#"
        };
        var atU = " @有道词典";
        /**
         * 获取包含标签字符串的纯文本内容
         * @param html
         */
        var getText = function(html) {
            return $("<span>" + html + "</span>").text();
        };
        /**
         * 分享数据{"word":"", "des":"", "detail":"", "date": ""}
         * @type {{WORD: Function}}
         * @param data {object} 分享的数据
         * @param lineb {string} 换行符
         * @param type {string} 分享类型
         */
        var shareTitle = {
            "word": function(data, lineb) {
                var summary = getText(data.summary) !== undefined ? "--" + getText(data.summary) + "】" : "】";
                return topic[data.category] + "【" + getText(data.title) + summary + lineb + data.url + atU;
            },
            "spoken": function(data, lineb) {
                return topic[data.category] + "我在" + atU + "  练习口语，得到了" + data.level + "分，击败了全球" + data.rank + "%的人，你也来试试吧！" + data.url;
            },
            "spokenProm": function(data, lineb) {
                return topic[data.category] + "我在" + atU + "  和" + data.starName + "PK口语,我们的口语相似度高达" + data.score + "%!但和我口语最相近的明星竟然是" + data.similarStarName + "!快来有道词典，和明星pk口语!" + data.url;
            }
        };
        /**
         * 分享到某个微博
         * @param type 类型
         * currentData {title:分享的内容,imgUrl:分享的图片地址,location:分享的url地址,}
         */
        return function(type, currentData) {
            var lineBreak = "\n";
            setTimeout(function() {
                utils.shareTo.open(type, {
                    "appKey": appkey[type] || "dict",
                    "uid": uid[type],
                    "title": shareTitle[currentData.category](currentData, lineBreak),
                    "imgUrl": currentData.img || "",
                    "location": currentData.url,
                    "charset": "utf-8",
                    "width": 620,
                    "height": 600
                });
            }, 0);
        };
    }();
});//     Underscore.js 1.4.4
//     http://underscorejs.org
//     (c) 2009-2013 Jeremy Ashkenas, DocumentCloud Inc.
//     Underscore may be freely distributed under the MIT license.
(function() {
    // Baseline setup
    // --------------
    // Establish the root object, `window` in the browser, or `global` on the server.
    var root = this;
    // Save the previous value of the `_` variable.
    var previousUnderscore = root._;
    // Establish the object that gets returned to break out of a loop iteration.
    var breaker = {};
    // Save bytes in the minified (but not gzipped) version:
    var ArrayProto = Array.prototype, ObjProto = Object.prototype, FuncProto = Function.prototype;
    // Create quick reference variables for speed access to core prototypes.
    var push = ArrayProto.push, slice = ArrayProto.slice, concat = ArrayProto.concat, toString = ObjProto.toString, hasOwnProperty = ObjProto.hasOwnProperty;
    // All **ECMAScript 5** native function implementations that we hope to use
    // are declared here.
    var nativeForEach = ArrayProto.forEach, nativeMap = ArrayProto.map, nativeReduce = ArrayProto.reduce, nativeReduceRight = ArrayProto.reduceRight, nativeFilter = ArrayProto.filter, nativeEvery = ArrayProto.every, nativeSome = ArrayProto.some, nativeIndexOf = ArrayProto.indexOf, nativeLastIndexOf = ArrayProto.lastIndexOf, nativeIsArray = Array.isArray, nativeKeys = Object.keys, nativeBind = FuncProto.bind;
    // Create a safe reference to the Underscore object for use below.
    var _ = function(obj) {
        if (obj instanceof _) return obj;
        if (!(this instanceof _)) return new _(obj);
        this._wrapped = obj;
    };
    // Export the Underscore object for **Node.js**, with
    // backwards-compatibility for the old `require()` API. If we're in
    // the browser, add `_` as a global object via a string identifier,
    // for Closure Compiler "advanced" mode.
    if (typeof exports !== "undefined") {
        if (typeof module !== "undefined" && module.exports) {
            exports = module.exports = _;
        }
        exports._ = _;
    } else {
        root._ = _;
    }
    // Current version.
    _.VERSION = "1.4.4";
    // Collection Functions
    // --------------------
    // The cornerstone, an `each` implementation, aka `forEach`.
    // Handles objects with the built-in `forEach`, arrays, and raw objects.
    // Delegates to **ECMAScript 5**'s native `forEach` if available.
    var each = _.each = _.forEach = function(obj, iterator, context) {
        if (obj == null) return;
        if (nativeForEach && obj.forEach === nativeForEach) {
            obj.forEach(iterator, context);
        } else if (obj.length === +obj.length) {
            for (var i = 0, l = obj.length; i < l; i++) {
                if (iterator.call(context, obj[i], i, obj) === breaker) return;
            }
        } else {
            for (var key in obj) {
                if (_.has(obj, key)) {
                    if (iterator.call(context, obj[key], key, obj) === breaker) return;
                }
            }
        }
    };
    // Return the results of applying the iterator to each element.
    // Delegates to **ECMAScript 5**'s native `map` if available.
    _.map = _.collect = function(obj, iterator, context) {
        var results = [];
        if (obj == null) return results;
        if (nativeMap && obj.map === nativeMap) return obj.map(iterator, context);
        each(obj, function(value, index, list) {
            results[results.length] = iterator.call(context, value, index, list);
        });
        return results;
    };
    var reduceError = "Reduce of empty array with no initial value";
    // **Reduce** builds up a single result from a list of values, aka `inject`,
    // or `foldl`. Delegates to **ECMAScript 5**'s native `reduce` if available.
    _.reduce = _.foldl = _.inject = function(obj, iterator, memo, context) {
        var initial = arguments.length > 2;
        if (obj == null) obj = [];
        if (nativeReduce && obj.reduce === nativeReduce) {
            if (context) iterator = _.bind(iterator, context);
            return initial ? obj.reduce(iterator, memo) : obj.reduce(iterator);
        }
        each(obj, function(value, index, list) {
            if (!initial) {
                memo = value;
                initial = true;
            } else {
                memo = iterator.call(context, memo, value, index, list);
            }
        });
        if (!initial) throw new TypeError(reduceError);
        return memo;
    };
    // The right-associative version of reduce, also known as `foldr`.
    // Delegates to **ECMAScript 5**'s native `reduceRight` if available.
    _.reduceRight = _.foldr = function(obj, iterator, memo, context) {
        var initial = arguments.length > 2;
        if (obj == null) obj = [];
        if (nativeReduceRight && obj.reduceRight === nativeReduceRight) {
            if (context) iterator = _.bind(iterator, context);
            return initial ? obj.reduceRight(iterator, memo) : obj.reduceRight(iterator);
        }
        var length = obj.length;
        if (length !== +length) {
            var keys = _.keys(obj);
            length = keys.length;
        }
        each(obj, function(value, index, list) {
            index = keys ? keys[--length] : --length;
            if (!initial) {
                memo = obj[index];
                initial = true;
            } else {
                memo = iterator.call(context, memo, obj[index], index, list);
            }
        });
        if (!initial) throw new TypeError(reduceError);
        return memo;
    };
    // Return the first value which passes a truth test. Aliased as `detect`.
    _.find = _.detect = function(obj, iterator, context) {
        var result;
        any(obj, function(value, index, list) {
            if (iterator.call(context, value, index, list)) {
                result = value;
                return true;
            }
        });
        return result;
    };
    // Return all the elements that pass a truth test.
    // Delegates to **ECMAScript 5**'s native `filter` if available.
    // Aliased as `select`.
    _.filter = _.select = function(obj, iterator, context) {
        var results = [];
        if (obj == null) return results;
        if (nativeFilter && obj.filter === nativeFilter) return obj.filter(iterator, context);
        each(obj, function(value, index, list) {
            if (iterator.call(context, value, index, list)) results[results.length] = value;
        });
        return results;
    };
    // Return all the elements for which a truth test fails.
    _.reject = function(obj, iterator, context) {
        return _.filter(obj, function(value, index, list) {
            return !iterator.call(context, value, index, list);
        }, context);
    };
    // Determine whether all of the elements match a truth test.
    // Delegates to **ECMAScript 5**'s native `every` if available.
    // Aliased as `all`.
    _.every = _.all = function(obj, iterator, context) {
        iterator || (iterator = _.identity);
        var result = true;
        if (obj == null) return result;
        if (nativeEvery && obj.every === nativeEvery) return obj.every(iterator, context);
        each(obj, function(value, index, list) {
            if (!(result = result && iterator.call(context, value, index, list))) return breaker;
        });
        return !!result;
    };
    // Determine if at least one element in the object matches a truth test.
    // Delegates to **ECMAScript 5**'s native `some` if available.
    // Aliased as `any`.
    var any = _.some = _.any = function(obj, iterator, context) {
        iterator || (iterator = _.identity);
        var result = false;
        if (obj == null) return result;
        if (nativeSome && obj.some === nativeSome) return obj.some(iterator, context);
        each(obj, function(value, index, list) {
            if (result || (result = iterator.call(context, value, index, list))) return breaker;
        });
        return !!result;
    };
    // Determine if the array or object contains a given value (using `===`).
    // Aliased as `include`.
    _.contains = _.include = function(obj, target) {
        if (obj == null) return false;
        if (nativeIndexOf && obj.indexOf === nativeIndexOf) return obj.indexOf(target) != -1;
        return any(obj, function(value) {
            return value === target;
        });
    };
    // Invoke a method (with arguments) on every item in a collection.
    _.invoke = function(obj, method) {
        var args = slice.call(arguments, 2);
        var isFunc = _.isFunction(method);
        return _.map(obj, function(value) {
            return (isFunc ? method : value[method]).apply(value, args);
        });
    };
    // Convenience version of a common use case of `map`: fetching a property.
    _.pluck = function(obj, key) {
        return _.map(obj, function(value) {
            return value[key];
        });
    };
    // Convenience version of a common use case of `filter`: selecting only objects
    // containing specific `key:value` pairs.
    _.where = function(obj, attrs, first) {
        if (_.isEmpty(attrs)) return first ? void 0 : [];
        return _[first ? "find" : "filter"](obj, function(value) {
            for (var key in attrs) {
                if (attrs[key] !== value[key]) return false;
            }
            return true;
        });
    };
    // Convenience version of a common use case of `find`: getting the first object
    // containing specific `key:value` pairs.
    _.findWhere = function(obj, attrs) {
        return _.where(obj, attrs, true);
    };
    // Return the maximum element or (element-based computation).
    // Can't optimize arrays of integers longer than 65,535 elements.
    // See: https://bugs.webkit.org/show_bug.cgi?id=80797
    _.max = function(obj, iterator, context) {
        if (!iterator && _.isArray(obj) && obj[0] === +obj[0] && obj.length < 65535) {
            return Math.max.apply(Math, obj);
        }
        if (!iterator && _.isEmpty(obj)) return -Infinity;
        var result = {
            "computed": -Infinity,
            "value": -Infinity
        };
        each(obj, function(value, index, list) {
            var computed = iterator ? iterator.call(context, value, index, list) : value;
            computed >= result.computed && (result = {
                "value": value,
                "computed": computed
            });
        });
        return result.value;
    };
    // Return the minimum element (or element-based computation).
    _.min = function(obj, iterator, context) {
        if (!iterator && _.isArray(obj) && obj[0] === +obj[0] && obj.length < 65535) {
            return Math.min.apply(Math, obj);
        }
        if (!iterator && _.isEmpty(obj)) return Infinity;
        var result = {
            "computed": Infinity,
            "value": Infinity
        };
        each(obj, function(value, index, list) {
            var computed = iterator ? iterator.call(context, value, index, list) : value;
            computed < result.computed && (result = {
                "value": value,
                "computed": computed
            });
        });
        return result.value;
    };
    // Shuffle an array.
    _.shuffle = function(obj) {
        var rand;
        var index = 0;
        var shuffled = [];
        each(obj, function(value) {
            rand = _.random(index++);
            shuffled[index - 1] = shuffled[rand];
            shuffled[rand] = value;
        });
        return shuffled;
    };
    // An internal function to generate lookup iterators.
    var lookupIterator = function(value) {
        return _.isFunction(value) ? value : function(obj) {
            return obj[value];
        };
    };
    // Sort the object's values by a criterion produced by an iterator.
    _.sortBy = function(obj, value, context) {
        var iterator = lookupIterator(value);
        return _.pluck(_.map(obj, function(value, index, list) {
            return {
                "value": value,
                "index": index,
                "criteria": iterator.call(context, value, index, list)
            };
        }).sort(function(left, right) {
            var a = left.criteria;
            var b = right.criteria;
            if (a !== b) {
                if (a > b || a === void 0) return 1;
                if (a < b || b === void 0) return -1;
            }
            return left.index < right.index ? -1 : 1;
        }), "value");
    };
    // An internal function used for aggregate "group by" operations.
    var group = function(obj, value, context, behavior) {
        var result = {};
        var iterator = lookupIterator(value == null ? _.identity : value);
        each(obj, function(value, index) {
            var key = iterator.call(context, value, index, obj);
            behavior(result, key, value);
        });
        return result;
    };
    // Groups the object's values by a criterion. Pass either a string attribute
    // to group by, or a function that returns the criterion.
    _.groupBy = function(obj, value, context) {
        return group(obj, value, context, function(result, key, value) {
            (_.has(result, key) ? result[key] : result[key] = []).push(value);
        });
    };
    // Counts instances of an object that group by a certain criterion. Pass
    // either a string attribute to count by, or a function that returns the
    // criterion.
    _.countBy = function(obj, value, context) {
        return group(obj, value, context, function(result, key) {
            if (!_.has(result, key)) result[key] = 0;
            result[key]++;
        });
    };
    // Use a comparator function to figure out the smallest index at which
    // an object should be inserted so as to maintain order. Uses binary search.
    _.sortedIndex = function(array, obj, iterator, context) {
        iterator = iterator == null ? _.identity : lookupIterator(iterator);
        var value = iterator.call(context, obj);
        var low = 0, high = array.length;
        while (low < high) {
            var mid = low + high >>> 1;
            iterator.call(context, array[mid]) < value ? low = mid + 1 : high = mid;
        }
        return low;
    };
    // Safely convert anything iterable into a real, live array.
    _.toArray = function(obj) {
        if (!obj) return [];
        if (_.isArray(obj)) return slice.call(obj);
        if (obj.length === +obj.length) return _.map(obj, _.identity);
        return _.values(obj);
    };
    // Return the number of elements in an object.
    _.size = function(obj) {
        if (obj == null) return 0;
        return obj.length === +obj.length ? obj.length : _.keys(obj).length;
    };
    // Array Functions
    // ---------------
    // Get the first element of an array. Passing **n** will return the first N
    // values in the array. Aliased as `head` and `take`. The **guard** check
    // allows it to work with `_.map`.
    _.first = _.head = _.take = function(array, n, guard) {
        if (array == null) return void 0;
        return n != null && !guard ? slice.call(array, 0, n) : array[0];
    };
    // Returns everything but the last entry of the array. Especially useful on
    // the arguments object. Passing **n** will return all the values in
    // the array, excluding the last N. The **guard** check allows it to work with
    // `_.map`.
    _.initial = function(array, n, guard) {
        return slice.call(array, 0, array.length - (n == null || guard ? 1 : n));
    };
    // Get the last element of an array. Passing **n** will return the last N
    // values in the array. The **guard** check allows it to work with `_.map`.
    _.last = function(array, n, guard) {
        if (array == null) return void 0;
        if (n != null && !guard) {
            return slice.call(array, Math.max(array.length - n, 0));
        } else {
            return array[array.length - 1];
        }
    };
    // Returns everything but the first entry of the array. Aliased as `tail` and `drop`.
    // Especially useful on the arguments object. Passing an **n** will return
    // the rest N values in the array. The **guard**
    // check allows it to work with `_.map`.
    _.rest = _.tail = _.drop = function(array, n, guard) {
        return slice.call(array, n == null || guard ? 1 : n);
    };
    // Trim out all falsy values from an array.
    _.compact = function(array) {
        return _.filter(array, _.identity);
    };
    // Internal implementation of a recursive `flatten` function.
    var flatten = function(input, shallow, output) {
        each(input, function(value) {
            if (_.isArray(value)) {
                shallow ? push.apply(output, value) : flatten(value, shallow, output);
            } else {
                output.push(value);
            }
        });
        return output;
    };
    // Return a completely flattened version of an array.
    _.flatten = function(array, shallow) {
        return flatten(array, shallow, []);
    };
    // Return a version of the array that does not contain the specified value(s).
    _.without = function(array) {
        return _.difference(array, slice.call(arguments, 1));
    };
    // Produce a duplicate-free version of the array. If the array has already
    // been sorted, you have the option of using a faster algorithm.
    // Aliased as `unique`.
    _.uniq = _.unique = function(array, isSorted, iterator, context) {
        if (_.isFunction(isSorted)) {
            context = iterator;
            iterator = isSorted;
            isSorted = false;
        }
        var initial = iterator ? _.map(array, iterator, context) : array;
        var results = [];
        var seen = [];
        each(initial, function(value, index) {
            if (isSorted ? !index || seen[seen.length - 1] !== value : !_.contains(seen, value)) {
                seen.push(value);
                results.push(array[index]);
            }
        });
        return results;
    };
    // Produce an array that contains the union: each distinct element from all of
    // the passed-in arrays.
    _.union = function() {
        return _.uniq(concat.apply(ArrayProto, arguments));
    };
    // Produce an array that contains every item shared between all the
    // passed-in arrays.
    _.intersection = function(array) {
        var rest = slice.call(arguments, 1);
        return _.filter(_.uniq(array), function(item) {
            return _.every(rest, function(other) {
                return _.indexOf(other, item) >= 0;
            });
        });
    };
    // Take the difference between one array and a number of other arrays.
    // Only the elements present in just the first array will remain.
    _.difference = function(array) {
        var rest = concat.apply(ArrayProto, slice.call(arguments, 1));
        return _.filter(array, function(value) {
            return !_.contains(rest, value);
        });
    };
    // Zip together multiple lists into a single array -- elements that share
    // an index go together.
    _.zip = function() {
        var args = slice.call(arguments);
        var length = _.max(_.pluck(args, "length"));
        var results = new Array(length);
        for (var i = 0; i < length; i++) {
            results[i] = _.pluck(args, "" + i);
        }
        return results;
    };
    // Converts lists into objects. Pass either a single array of `[key, value]`
    // pairs, or two parallel arrays of the same length -- one of keys, and one of
    // the corresponding values.
    _.object = function(list, values) {
        if (list == null) return {};
        var result = {};
        for (var i = 0, l = list.length; i < l; i++) {
            if (values) {
                result[list[i]] = values[i];
            } else {
                result[list[i][0]] = list[i][1];
            }
        }
        return result;
    };
    // If the browser doesn't supply us with indexOf (I'm looking at you, **MSIE**),
    // we need this function. Return the position of the first occurrence of an
    // item in an array, or -1 if the item is not included in the array.
    // Delegates to **ECMAScript 5**'s native `indexOf` if available.
    // If the array is large and already in sort order, pass `true`
    // for **isSorted** to use binary search.
    _.indexOf = function(array, item, isSorted) {
        if (array == null) return -1;
        var i = 0, l = array.length;
        if (isSorted) {
            if (typeof isSorted == "number") {
                i = isSorted < 0 ? Math.max(0, l + isSorted) : isSorted;
            } else {
                i = _.sortedIndex(array, item);
                return array[i] === item ? i : -1;
            }
        }
        if (nativeIndexOf && array.indexOf === nativeIndexOf) return array.indexOf(item, isSorted);
        for (;i < l; i++) if (array[i] === item) return i;
        return -1;
    };
    // Delegates to **ECMAScript 5**'s native `lastIndexOf` if available.
    _.lastIndexOf = function(array, item, from) {
        if (array == null) return -1;
        var hasIndex = from != null;
        if (nativeLastIndexOf && array.lastIndexOf === nativeLastIndexOf) {
            return hasIndex ? array.lastIndexOf(item, from) : array.lastIndexOf(item);
        }
        var i = hasIndex ? from : array.length;
        while (i--) if (array[i] === item) return i;
        return -1;
    };
    // Generate an integer Array containing an arithmetic progression. A port of
    // the native Python `range()` function. See
    // [the Python documentation](http://docs.python.org/library/functions.html#range).
    _.range = function(start, stop, step) {
        if (arguments.length <= 1) {
            stop = start || 0;
            start = 0;
        }
        step = arguments[2] || 1;
        var len = Math.max(Math.ceil((stop - start) / step), 0);
        var idx = 0;
        var range = new Array(len);
        while (idx < len) {
            range[idx++] = start;
            start += step;
        }
        return range;
    };
    // Function (ahem) Functions
    // ------------------
    // Reusable constructor function for prototype setting.
    var ctor = function() {};
    // Create a function bound to a given object (assigning `this`, and arguments,
    // optionally). Delegates to **ECMAScript 5**'s native `Function.bind` if
    // available.
    _.bind = function(func, context) {
        var args, bound;
        if (func.bind === nativeBind && nativeBind) return nativeBind.apply(func, slice.call(arguments, 1));
        if (!_.isFunction(func)) throw new TypeError();
        args = slice.call(arguments, 2);
        return bound = function() {
            if (!(this instanceof bound)) return func.apply(context, args.concat(slice.call(arguments)));
            ctor.prototype = func.prototype;
            var self = new ctor();
            ctor.prototype = null;
            var result = func.apply(self, args.concat(slice.call(arguments)));
            if (Object(result) === result) return result;
            return self;
        };
    };
    // Partially apply a function by creating a version that has had some of its
    // arguments pre-filled, without changing its dynamic `this` context.
    _.partial = function(func) {
        var args = slice.call(arguments, 1);
        return function() {
            return func.apply(this, args.concat(slice.call(arguments)));
        };
    };
    // Bind all of an object's methods to that object. Useful for ensuring that
    // all callbacks defined on an object belong to it.
    _.bindAll = function(obj) {
        var funcs = slice.call(arguments, 1);
        if (funcs.length === 0) throw new Error("bindAll must be passed function names");
        each(funcs, function(f) {
            obj[f] = _.bind(obj[f], obj);
        });
        return obj;
    };
    // Memoize an expensive function by storing its results.
    _.memoize = function(func, hasher) {
        var memo = {};
        hasher || (hasher = _.identity);
        return function() {
            var key = hasher.apply(this, arguments);
            return _.has(memo, key) ? memo[key] : memo[key] = func.apply(this, arguments);
        };
    };
    // Delays a function for the given number of milliseconds, and then calls
    // it with the arguments supplied.
    _.delay = function(func, wait) {
        var args = slice.call(arguments, 2);
        return setTimeout(function() {
            return func.apply(null, args);
        }, wait);
    };
    // Defers a function, scheduling it to run after the current call stack has
    // cleared.
    _.defer = function(func) {
        return _.delay.apply(_, [ func, 1 ].concat(slice.call(arguments, 1)));
    };
    // Returns a function, that, when invoked, will only be triggered at most once
    // during a given window of time.
    _.throttle = function(func, wait) {
        var context, args, timeout, result;
        var previous = 0;
        var later = function() {
            previous = new Date();
            timeout = null;
            result = func.apply(context, args);
        };
        return function() {
            var now = new Date();
            var remaining = wait - (now - previous);
            context = this;
            args = arguments;
            if (remaining <= 0) {
                clearTimeout(timeout);
                timeout = null;
                previous = now;
                result = func.apply(context, args);
            } else if (!timeout) {
                timeout = setTimeout(later, remaining);
            }
            return result;
        };
    };
    // Returns a function, that, as long as it continues to be invoked, will not
    // be triggered. The function will be called after it stops being called for
    // N milliseconds. If `immediate` is passed, trigger the function on the
    // leading edge, instead of the trailing.
    _.debounce = function(func, wait, immediate) {
        var timeout, result;
        return function() {
            var context = this, args = arguments;
            var later = function() {
                timeout = null;
                if (!immediate) result = func.apply(context, args);
            };
            var callNow = immediate && !timeout;
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
            if (callNow) result = func.apply(context, args);
            return result;
        };
    };
    // Returns a function that will be executed at most one time, no matter how
    // often you call it. Useful for lazy initialization.
    _.once = function(func) {
        var ran = false, memo;
        return function() {
            if (ran) return memo;
            ran = true;
            memo = func.apply(this, arguments);
            func = null;
            return memo;
        };
    };
    // Returns the first function passed as an argument to the second,
    // allowing you to adjust arguments, run code before and after, and
    // conditionally execute the original function.
    _.wrap = function(func, wrapper) {
        return function() {
            var args = [ func ];
            push.apply(args, arguments);
            return wrapper.apply(this, args);
        };
    };
    // Returns a function that is the composition of a list of functions, each
    // consuming the return value of the function that follows.
    _.compose = function() {
        var funcs = arguments;
        return function() {
            var args = arguments;
            for (var i = funcs.length - 1; i >= 0; i--) {
                args = [ funcs[i].apply(this, args) ];
            }
            return args[0];
        };
    };
    // Returns a function that will only be executed after being called N times.
    _.after = function(times, func) {
        if (times <= 0) return func();
        return function() {
            if (--times < 1) {
                return func.apply(this, arguments);
            }
        };
    };
    // Object Functions
    // ----------------
    // Retrieve the names of an object's properties.
    // Delegates to **ECMAScript 5**'s native `Object.keys`
    _.keys = nativeKeys || function(obj) {
        if (obj !== Object(obj)) throw new TypeError("Invalid object");
        var keys = [];
        for (var key in obj) if (_.has(obj, key)) keys[keys.length] = key;
        return keys;
    };
    // Retrieve the values of an object's properties.
    _.values = function(obj) {
        var values = [];
        for (var key in obj) if (_.has(obj, key)) values.push(obj[key]);
        return values;
    };
    // Convert an object into a list of `[key, value]` pairs.
    _.pairs = function(obj) {
        var pairs = [];
        for (var key in obj) if (_.has(obj, key)) pairs.push([ key, obj[key] ]);
        return pairs;
    };
    // Invert the keys and values of an object. The values must be serializable.
    _.invert = function(obj) {
        var result = {};
        for (var key in obj) if (_.has(obj, key)) result[obj[key]] = key;
        return result;
    };
    // Return a sorted list of the function names available on the object.
    // Aliased as `methods`
    _.functions = _.methods = function(obj) {
        var names = [];
        for (var key in obj) {
            if (_.isFunction(obj[key])) names.push(key);
        }
        return names.sort();
    };
    // Extend a given object with all the properties in passed-in object(s).
    _.extend = function(obj) {
        each(slice.call(arguments, 1), function(source) {
            if (source) {
                for (var prop in source) {
                    obj[prop] = source[prop];
                }
            }
        });
        return obj;
    };
    // Return a copy of the object only containing the whitelisted properties.
    _.pick = function(obj) {
        var copy = {};
        var keys = concat.apply(ArrayProto, slice.call(arguments, 1));
        each(keys, function(key) {
            if (key in obj) copy[key] = obj[key];
        });
        return copy;
    };
    // Return a copy of the object without the blacklisted properties.
    _.omit = function(obj) {
        var copy = {};
        var keys = concat.apply(ArrayProto, slice.call(arguments, 1));
        for (var key in obj) {
            if (!_.contains(keys, key)) copy[key] = obj[key];
        }
        return copy;
    };
    // Fill in a given object with default properties.
    _.defaults = function(obj) {
        each(slice.call(arguments, 1), function(source) {
            if (source) {
                for (var prop in source) {
                    if (obj[prop] === void 0) obj[prop] = source[prop];
                }
            }
        });
        return obj;
    };
    // Create a (shallow-cloned) duplicate of an object.
    _.clone = function(obj) {
        if (!_.isObject(obj)) return obj;
        return _.isArray(obj) ? obj.slice() : _.extend({}, obj);
    };
    // Invokes interceptor with the obj, and then returns obj.
    // The primary purpose of this method is to "tap into" a method chain, in
    // order to perform operations on intermediate results within the chain.
    _.tap = function(obj, interceptor) {
        interceptor(obj);
        return obj;
    };
    // Internal recursive comparison function for `isEqual`.
    var eq = function(a, b, aStack, bStack) {
        // Identical objects are equal. `0 === -0`, but they aren't identical.
        // See the Harmony `egal` proposal: http://wiki.ecmascript.org/doku.php?id=harmony:egal.
        if (a === b) return a !== 0 || 1 / a == 1 / b;
        // A strict comparison is necessary because `null == undefined`.
        if (a == null || b == null) return a === b;
        // Unwrap any wrapped objects.
        if (a instanceof _) a = a._wrapped;
        if (b instanceof _) b = b._wrapped;
        // Compare `[[Class]]` names.
        var className = toString.call(a);
        if (className != toString.call(b)) return false;
        switch (className) {
          // Strings, numbers, dates, and booleans are compared by value.
            case "[object String]":
            // Primitives and their corresponding object wrappers are equivalent; thus, `"5"` is
            // equivalent to `new String("5")`.
            return a == String(b);

          case "[object Number]":
            // `NaN`s are equivalent, but non-reflexive. An `egal` comparison is performed for
            // other numeric values.
            return a != +a ? b != +b : a == 0 ? 1 / a == 1 / b : a == +b;

          case "[object Date]":
          case "[object Boolean]":
            // Coerce dates and booleans to numeric primitive values. Dates are compared by their
            // millisecond representations. Note that invalid dates with millisecond representations
            // of `NaN` are not equivalent.
            return +a == +b;

          // RegExps are compared by their source patterns and flags.
            case "[object RegExp]":
            return a.source == b.source && a.global == b.global && a.multiline == b.multiline && a.ignoreCase == b.ignoreCase;
        }
        if (typeof a != "object" || typeof b != "object") return false;
        // Assume equality for cyclic structures. The algorithm for detecting cyclic
        // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.
        var length = aStack.length;
        while (length--) {
            // Linear search. Performance is inversely proportional to the number of
            // unique nested structures.
            if (aStack[length] == a) return bStack[length] == b;
        }
        // Add the first object to the stack of traversed objects.
        aStack.push(a);
        bStack.push(b);
        var size = 0, result = true;
        // Recursively compare objects and arrays.
        if (className == "[object Array]") {
            // Compare array lengths to determine if a deep comparison is necessary.
            size = a.length;
            result = size == b.length;
            if (result) {
                // Deep compare the contents, ignoring non-numeric properties.
                while (size--) {
                    if (!(result = eq(a[size], b[size], aStack, bStack))) break;
                }
            }
        } else {
            // Objects with different constructors are not equivalent, but `Object`s
            // from different frames are.
            var aCtor = a.constructor, bCtor = b.constructor;
            if (aCtor !== bCtor && !(_.isFunction(aCtor) && aCtor instanceof aCtor && _.isFunction(bCtor) && bCtor instanceof bCtor)) {
                return false;
            }
            // Deep compare objects.
            for (var key in a) {
                if (_.has(a, key)) {
                    // Count the expected number of properties.
                    size++;
                    // Deep compare each member.
                    if (!(result = _.has(b, key) && eq(a[key], b[key], aStack, bStack))) break;
                }
            }
            // Ensure that both objects contain the same number of properties.
            if (result) {
                for (key in b) {
                    if (_.has(b, key) && !size--) break;
                }
                result = !size;
            }
        }
        // Remove the first object from the stack of traversed objects.
        aStack.pop();
        bStack.pop();
        return result;
    };
    // Perform a deep comparison to check if two objects are equal.
    _.isEqual = function(a, b) {
        return eq(a, b, [], []);
    };
    // Is a given array, string, or object empty?
    // An "empty" object has no enumerable own-properties.
    _.isEmpty = function(obj) {
        if (obj == null) return true;
        if (_.isArray(obj) || _.isString(obj)) return obj.length === 0;
        for (var key in obj) if (_.has(obj, key)) return false;
        return true;
    };
    // Is a given value a DOM element?
    _.isElement = function(obj) {
        return !!(obj && obj.nodeType === 1);
    };
    // Is a given value an array?
    // Delegates to ECMA5's native Array.isArray
    _.isArray = nativeIsArray || function(obj) {
        return toString.call(obj) == "[object Array]";
    };
    // Is a given variable an object?
    _.isObject = function(obj) {
        return obj === Object(obj);
    };
    // Add some isType methods: isArguments, isFunction, isString, isNumber, isDate, isRegExp.
    each([ "Arguments", "Function", "String", "Number", "Date", "RegExp" ], function(name) {
        _["is" + name] = function(obj) {
            return toString.call(obj) == "[object " + name + "]";
        };
    });
    // Define a fallback version of the method in browsers (ahem, IE), where
    // there isn't any inspectable "Arguments" type.
    if (!_.isArguments(arguments)) {
        _.isArguments = function(obj) {
            return !!(obj && _.has(obj, "callee"));
        };
    }
    // Optimize `isFunction` if appropriate.
    if (typeof /./ !== "function") {
        _.isFunction = function(obj) {
            return typeof obj === "function";
        };
    }
    // Is a given object a finite number?
    _.isFinite = function(obj) {
        return isFinite(obj) && !isNaN(parseFloat(obj));
    };
    // Is the given value `NaN`? (NaN is the only number which does not equal itself).
    _.isNaN = function(obj) {
        return _.isNumber(obj) && obj != +obj;
    };
    // Is a given value a boolean?
    _.isBoolean = function(obj) {
        return obj === true || obj === false || toString.call(obj) == "[object Boolean]";
    };
    // Is a given value equal to null?
    _.isNull = function(obj) {
        return obj === null;
    };
    // Is a given variable undefined?
    _.isUndefined = function(obj) {
        return obj === void 0;
    };
    // Shortcut function for checking if an object has a given property directly
    // on itself (in other words, not on a prototype).
    _.has = function(obj, key) {
        return hasOwnProperty.call(obj, key);
    };
    // Utility Functions
    // -----------------
    // Run Underscore.js in *noConflict* mode, returning the `_` variable to its
    // previous owner. Returns a reference to the Underscore object.
    _.noConflict = function() {
        root._ = previousUnderscore;
        return this;
    };
    // Keep the identity function around for default iterators.
    _.identity = function(value) {
        return value;
    };
    // Run a function **n** times.
    _.times = function(n, iterator, context) {
        var accum = Array(n);
        for (var i = 0; i < n; i++) accum[i] = iterator.call(context, i);
        return accum;
    };
    // Return a random integer between min and max (inclusive).
    _.random = function(min, max) {
        if (max == null) {
            max = min;
            min = 0;
        }
        return min + Math.floor(Math.random() * (max - min + 1));
    };
    // List of HTML entities for escaping.
    var entityMap = {
        "escape": {
            "&": "&amp;",
            "<": "&lt;",
            ">": "&gt;",
            '"': "&quot;",
            "'": "&#x27;",
            "/": "&#x2F;"
        }
    };
    entityMap.unescape = _.invert(entityMap.escape);
    // Regexes containing the keys and values listed immediately above.
    var entityRegexes = {
        "escape": new RegExp("[" + _.keys(entityMap.escape).join("") + "]", "g"),
        "unescape": new RegExp("(" + _.keys(entityMap.unescape).join("|") + ")", "g")
    };
    // Functions for escaping and unescaping strings to/from HTML interpolation.
    _.each([ "escape", "unescape" ], function(method) {
        _[method] = function(string) {
            if (string == null) return "";
            return ("" + string).replace(entityRegexes[method], function(match) {
                return entityMap[method][match];
            });
        };
    });
    // If the value of the named property is a function then invoke it;
    // otherwise, return it.
    _.result = function(object, property) {
        if (object == null) return void 0;
        var value = object[property];
        return _.isFunction(value) ? value.call(object) : value;
    };
    // Add your own custom functions to the Underscore object.
    _.mixin = function(obj) {
        each(_.functions(obj), function(name) {
            var func = _[name] = obj[name];
            _.prototype[name] = function() {
                var args = [ this._wrapped ];
                push.apply(args, arguments);
                return result.call(this, func.apply(_, args));
            };
        });
    };
    // Generate a unique integer id (unique within the entire client session).
    // Useful for temporary DOM ids.
    var idCounter = 0;
    _.uniqueId = function(prefix) {
        var id = ++idCounter + "";
        return prefix ? prefix + id : id;
    };
    // By default, Underscore uses ERB-style template delimiters, change the
    // following template settings to use alternative delimiters.
    _.templateSettings = {
        "evaluate": /<%([\s\S]+?)%>/g,
        "interpolate": /<%=([\s\S]+?)%>/g,
        "escape": /<%-([\s\S]+?)%>/g
    };
    // When customizing `templateSettings`, if you don't want to define an
    // interpolation, evaluation or escaping regex, we need one that is
    // guaranteed not to match.
    var noMatch = /(.)^/;
    // Certain characters need to be escaped so that they can be put into a
    // string literal.
    var escapes = {
        "'": "'",
        "\\": "\\",
        "\r": "r",
        "\n": "n",
        "	": "t",
        "\u2028": "u2028",
        "\u2029": "u2029"
    };
    var escaper = /\\|'|\r|\n|\t|\u2028|\u2029/g;
    // JavaScript micro-templating, similar to John Resig's implementation.
    // Underscore templating handles arbitrary delimiters, preserves whitespace,
    // and correctly escapes quotes within interpolated code.
    _.template = function(text, data, settings) {
        var render;
        settings = _.defaults({}, settings, _.templateSettings);
        // Combine delimiters into one regular expression via alternation.
        var matcher = new RegExp([ (settings.escape || noMatch).source, (settings.interpolate || noMatch).source, (settings.evaluate || noMatch).source ].join("|") + "|$", "g");
        // Compile the template source, escaping string literals appropriately.
        var index = 0;
        var source = "__p+='";
        text.replace(matcher, function(match, escape, interpolate, evaluate, offset) {
            source += text.slice(index, offset).replace(escaper, function(match) {
                return "\\" + escapes[match];
            });
            if (escape) {
                source += "'+\n((__t=(" + escape + "))==null?'':_.escape(__t))+\n'";
            }
            if (interpolate) {
                source += "'+\n((__t=(" + interpolate + "))==null?'':__t)+\n'";
            }
            if (evaluate) {
                source += "';\n" + evaluate + "\n__p+='";
            }
            index = offset + match.length;
            return match;
        });
        source += "';\n";
        // If a variable is not specified, place data values in local scope.
        if (!settings.variable) source = "with(obj||{}){\n" + source + "}\n";
        source = "var __t,__p='',__j=Array.prototype.join," + "print=function(){__p+=__j.call(arguments,'');};\n" + source + "return __p;\n";
        try {
            render = new Function(settings.variable || "obj", "_", source);
        } catch (e) {
            e.source = source;
            throw e;
        }
        if (data) return render(data, _);
        var template = function(data) {
            return render.call(this, data, _);
        };
        // Provide the compiled function source as a convenience for precompilation.
        template.source = "function(" + (settings.variable || "obj") + "){\n" + source + "}";
        return template;
    };
    // Add a "chain" function, which will delegate to the wrapper.
    _.chain = function(obj) {
        return _(obj).chain();
    };
    // OOP
    // ---------------
    // If Underscore is called as a function, it returns a wrapped object that
    // can be used OO-style. This wrapper holds altered versions of all the
    // underscore functions. Wrapped objects may be chained.
    // Helper function to continue chaining intermediate results.
    var result = function(obj) {
        return this._chain ? _(obj).chain() : obj;
    };
    // Add all of the Underscore functions to the wrapper object.
    _.mixin(_);
    // Add all mutator Array functions to the wrapper.
    each([ "pop", "push", "reverse", "shift", "sort", "splice", "unshift" ], function(name) {
        var method = ArrayProto[name];
        _.prototype[name] = function() {
            var obj = this._wrapped;
            method.apply(obj, arguments);
            if ((name == "shift" || name == "splice") && obj.length === 0) delete obj[0];
            return result.call(this, obj);
        };
    });
    // Add all accessor Array functions to the wrapper.
    each([ "concat", "join", "slice" ], function(name) {
        var method = ArrayProto[name];
        _.prototype[name] = function() {
            return result.call(this, method.apply(this._wrapped, arguments));
        };
    });
    _.extend(_.prototype, {
        // Start chaining a wrapped Underscore object.
        "chain": function() {
            this._chain = true;
            return this;
        },
        // Extracts the result from a wrapped and chained object.
        "value": function() {
            return this._wrapped;
        }
    });
    if (typeof define === "function") {
        define("/lib/underscore", function() {
            return _;
        });
    }
}).call(this);/*! Copyright (c) 2011, Lloyd Hilaiel, ISC License */
/*
 * This is the JSONSelect reference implementation, in javascript.  This
 * code is designed to run under node.js or in a browser.  In the former
 * case, the "public API" is exposed as properties on the `export` object,
 * in the latter, as properties on `window.JSONSelect`.  That API is thus:
 *
 * Selector formating and parameter escaping:
 *
 * Anywhere where a string selector is selected, it may be followed by an
 * optional array of values.  When provided, they will be escaped and
 * inserted into the selector string properly escaped.  i.e.:
 *
 *   .match(':has(?)', [ 'foo' ], {})
 *
 * would result in the seclector ':has("foo")' being matched against {}.
 *
 * This feature makes dynamically generated selectors more readable.
 *
 * .match(selector, [ values ], object)
 *
 *   Parses and "compiles" the selector, then matches it against the object
 *   argument.  Matches are returned in an array.  Throws an error when
 *   there's a problem parsing the selector.
 *
 * .forEach(selector, [ values ], object, callback)
 *
 *   Like match, but rather than returning an array, invokes the provided
 *   callback once per match as the matches are discovered.
 *
 * .compile(selector, [ values ])
 *
 *   Parses the selector and compiles it to an internal form, and returns
 *   an object which contains the compiled selector and has two properties:
 *   `match` and `forEach`.  These two functions work identically to the
 *   above, except they do not take a selector as an argument and instead
 *   use the compiled selector.
 *
 *   For cases where a complex selector is repeatedly used, this method
 *   should be faster as it will avoid recompiling the selector each time.
 */
(function(window) {
    var exports = {};
    var // localize references
    toString = Object.prototype.toString;
    function jsonParse(str) {
        try {
            if (JSON && JSON.parse) {
                return JSON.parse(str);
            }
            return new Function("return " + str)();
        } catch (e) {
            te("ijs", e.message);
        }
    }
    // emitted error codes.
    var errorCodes = {
        "bop": "binary operator expected",
        "ee": "expression expected",
        "epex": "closing paren expected ')'",
        "ijs": "invalid json string",
        "mcp": "missing closing paren",
        "mepf": "malformed expression in pseudo-function",
        "mexp": "multiple expressions not allowed",
        "mpc": "multiple pseudo classes (:xxx) not allowed",
        "nmi": "multiple ids not allowed",
        "pex": "opening paren expected '('",
        "se": "selector expected",
        "sex": "string expected",
        "sra": "string required after '.'",
        "uc": "unrecognized char",
        "ucp": "unexpected closing paren",
        "ujs": "unclosed json string",
        "upc": "unrecognized pseudo class"
    };
    // throw an error message
    function te(ec, context) {
        throw new Error(errorCodes[ec] + (context && " in '" + context + "'"));
    }
    // THE LEXER
    var toks = {
        "psc": 1,
        // pseudo class
        "psf": 2,
        // pseudo class function
        "typ": 3,
        // type
        "str": 4,
        // string
        "ide": 5
    };
    // The primary lexing regular expression in jsonselect
    var pat = new RegExp("^(?:" + // (1) whitespace
    "([\\r\\n\\t\\ ]+)|" + // (2) one-char ops
    "([~*,>\\)\\(])|" + // (3) types names
    "(string|boolean|null|array|object|number)|" + // (4) pseudo classes
    "(:(?:root|first-child|last-child|only-child))|" + // (5) pseudo functions
    "(:(?:nth-child|nth-last-child|has|expr|val|contains))|" + // (6) bogusly named pseudo something or others
    "(:\\w+)|" + // (7 & 8) identifiers and JSON strings
    '(?:(\\.)?(\\"(?:[^\\\\\\"]|\\\\[^\\"])*\\"))|' + // (8) bogus JSON strings missing a trailing quote
    '(\\")|' + // (9) identifiers (unquoted)
    "\\.((?:[_a-zA-Z]|[^\\0-\\0177]|\\\\[^\\r\\n\\f0-9a-fA-F])(?:[$_a-zA-Z0-9\\-]|[^\\u0000-\\u0177]|(?:\\\\[^\\r\\n\\f0-9a-fA-F]))*)" + ")");
    // A regular expression for matching "nth expressions" (see grammar, what :nth-child() eats)
    var nthPat = /^\s*\(\s*(?:([+\-]?)([0-9]*)n\s*(?:([+\-])\s*([0-9]))?|(odd|even)|([+\-]?[0-9]+))\s*\)/;
    function lex(str, off) {
        if (!off) off = 0;
        var m = pat.exec(str.substr(off));
        if (!m) return undefined;
        off += m[0].length;
        var a;
        if (m[1]) a = [ off, " " ]; else if (m[2]) a = [ off, m[0] ]; else if (m[3]) a = [ off, toks.typ, m[0] ]; else if (m[4]) a = [ off, toks.psc, m[0] ]; else if (m[5]) a = [ off, toks.psf, m[0] ]; else if (m[6]) te("upc", str); else if (m[8]) a = [ off, m[7] ? toks.ide : toks.str, jsonParse(m[8]) ]; else if (m[9]) te("ujs", str); else if (m[10]) a = [ off, toks.ide, m[10].replace(/\\([^\r\n\f0-9a-fA-F])/g, "$1") ];
        return a;
    }
    // THE EXPRESSION SUBSYSTEM
    var exprPat = new RegExp(// skip and don't capture leading whitespace
    "^\\s*(?:" + // (1) simple vals
    "(true|false|null)|" + // (2) numbers
    "(-?\\d+(?:\\.\\d*)?(?:[eE][+\\-]?\\d+)?)|" + // (3) strings
    '("(?:[^\\]|\\[^"])*")|' + // (4) the 'x' value placeholder
    "(x)|" + // (5) binops
    "(&&|\\|\\||[\\$\\^<>!\\*]=|[=+\\-*/%<>])|" + // (6) parens
    "([\\(\\)])" + ")");
    function is(o, t) {
        return typeof o === t;
    }
    var operators = {
        "*": [ 9, function(lhs, rhs) {
            return lhs * rhs;
        } ],
        "/": [ 9, function(lhs, rhs) {
            return lhs / rhs;
        } ],
        "%": [ 9, function(lhs, rhs) {
            return lhs % rhs;
        } ],
        "+": [ 7, function(lhs, rhs) {
            return lhs + rhs;
        } ],
        "-": [ 7, function(lhs, rhs) {
            return lhs - rhs;
        } ],
        "<=": [ 5, function(lhs, rhs) {
            return is(lhs, "number") && is(rhs, "number") && lhs <= rhs || is(lhs, "string") && is(rhs, "string") && lhs <= rhs;
        } ],
        ">=": [ 5, function(lhs, rhs) {
            return is(lhs, "number") && is(rhs, "number") && lhs >= rhs || is(lhs, "string") && is(rhs, "string") && lhs >= rhs;
        } ],
        "$=": [ 5, function(lhs, rhs) {
            return is(lhs, "string") && is(rhs, "string") && lhs.lastIndexOf(rhs) === lhs.length - rhs.length;
        } ],
        "^=": [ 5, function(lhs, rhs) {
            return is(lhs, "string") && is(rhs, "string") && lhs.indexOf(rhs) === 0;
        } ],
        "*=": [ 5, function(lhs, rhs) {
            return is(lhs, "string") && is(rhs, "string") && lhs.indexOf(rhs) !== -1;
        } ],
        ">": [ 5, function(lhs, rhs) {
            return is(lhs, "number") && is(rhs, "number") && lhs > rhs || is(lhs, "string") && is(rhs, "string") && lhs > rhs;
        } ],
        "<": [ 5, function(lhs, rhs) {
            return is(lhs, "number") && is(rhs, "number") && lhs < rhs || is(lhs, "string") && is(rhs, "string") && lhs < rhs;
        } ],
        "=": [ 3, function(lhs, rhs) {
            return lhs === rhs;
        } ],
        "!=": [ 3, function(lhs, rhs) {
            return lhs !== rhs;
        } ],
        "&&": [ 2, function(lhs, rhs) {
            return lhs && rhs;
        } ],
        "||": [ 1, function(lhs, rhs) {
            return lhs || rhs;
        } ]
    };
    function exprLex(str, off) {
        var v, m = exprPat.exec(str.substr(off));
        if (m) {
            off += m[0].length;
            v = m[1] || m[2] || m[3] || m[5] || m[6];
            if (m[1] || m[2] || m[3]) return [ off, 0, jsonParse(v) ]; else if (m[4]) return [ off, 0, undefined ];
            return [ off, v ];
        }
    }
    function exprParse2(str, off) {
        if (!off) off = 0;
        // first we expect a value or a '('
        var l = exprLex(str, off), lhs;
        if (l && l[1] === "(") {
            lhs = exprParse2(str, l[0]);
            var p = exprLex(str, lhs[0]);
            if (!p || p[1] !== ")") te("epex", str);
            off = p[0];
            lhs = [ "(", lhs[1] ];
        } else if (!l || l[1] && l[1] != "x") {
            te("ee", str + " - " + (l[1] && l[1]));
        } else {
            lhs = l[1] === "x" ? undefined : l[2];
            off = l[0];
        }
        // now we expect a binary operator or a ')'
        var op = exprLex(str, off);
        if (!op || op[1] == ")") return [ off, lhs ]; else if (op[1] == "x" || !op[1]) {
            te("bop", str + " - " + (op[1] && op[1]));
        }
        // tail recursion to fetch the rhs expression
        var rhs = exprParse2(str, op[0]);
        off = rhs[0];
        rhs = rhs[1];
        // and now precedence!  how shall we put everything together?
        var v;
        if (typeof rhs !== "object" || rhs[0] === "(" || operators[op[1]][0] < operators[rhs[1]][0]) {
            v = [ lhs, op[1], rhs ];
        } else {
            v = rhs;
            while (typeof rhs[0] === "object" && rhs[0][0] != "(" && operators[op[1]][0] >= operators[rhs[0][1]][0]) {
                rhs = rhs[0];
            }
            rhs[0] = [ lhs, op[1], rhs[0] ];
        }
        return [ off, v ];
    }
    function exprParse(str, off) {
        function deparen(v) {
            if (typeof v !== "object" || v === null) return v; else if (v[0] === "(") return deparen(v[1]); else return [ deparen(v[0]), v[1], deparen(v[2]) ];
        }
        var e = exprParse2(str, off ? off : 0);
        return [ e[0], deparen(e[1]) ];
    }
    function exprEval(expr, x) {
        if (expr === undefined) return x; else if (expr === null || typeof expr !== "object") {
            return expr;
        }
        var lhs = exprEval(expr[0], x), rhs = exprEval(expr[2], x);
        return operators[expr[1]][1](lhs, rhs);
    }
    // THE PARSER
    function parse(str, off, nested, hints) {
        if (!nested) hints = {};
        var a = [], am, readParen;
        if (!off) off = 0;
        while (true) {
            var s = parse_selector(str, off, hints);
            a.push(s[1]);
            s = lex(str, off = s[0]);
            if (s && s[1] === " ") s = lex(str, off = s[0]);
            if (!s) break;
            // now we've parsed a selector, and have something else...
            if (s[1] === ">" || s[1] === "~") {
                if (s[1] === "~") hints.usesSiblingOp = true;
                a.push(s[1]);
                off = s[0];
            } else if (s[1] === ",") {
                if (am === undefined) am = [ ",", a ]; else am.push(a);
                a = [];
                off = s[0];
            } else if (s[1] === ")") {
                if (!nested) te("ucp", s[1]);
                readParen = 1;
                off = s[0];
                break;
            }
        }
        if (nested && !readParen) te("mcp", str);
        if (am) am.push(a);
        var rv;
        if (!nested && hints.usesSiblingOp) {
            rv = normalize(am ? am : a);
        } else {
            rv = am ? am : a;
        }
        return [ off, rv ];
    }
    function normalizeOne(sel) {
        var sels = [], s;
        for (var i = 0; i < sel.length; i++) {
            if (sel[i] === "~") {
                // `A ~ B` maps to `:has(:root > A) > B`
                // `Z A ~ B` maps to `Z :has(:root > A) > B, Z:has(:root > A) > B`
                // This first clause, takes care of the first case, and the first half of the latter case.
                if (i < 2 || sel[i - 2] != ">") {
                    s = sel.slice(0, i - 1);
                    s = s.concat([ {
                        "has": [ [ {
                            "pc": ":root"
                        }, ">", sel[i - 1] ] ]
                    }, ">" ]);
                    s = s.concat(sel.slice(i + 1));
                    sels.push(s);
                }
                // here we take care of the second half of above:
                // (`Z A ~ B` maps to `Z :has(:root > A) > B, Z :has(:root > A) > B`)
                // and a new case:
                // Z > A ~ B maps to Z:has(:root > A) > B
                if (i > 1) {
                    var at = sel[i - 2] === ">" ? i - 3 : i - 2;
                    s = sel.slice(0, at);
                    var z = {};
                    for (var k in sel[at]) if (sel[at].hasOwnProperty(k)) z[k] = sel[at][k];
                    if (!z.has) z.has = [];
                    z.has.push([ {
                        "pc": ":root"
                    }, ">", sel[i - 1] ]);
                    s = s.concat(z, ">", sel.slice(i + 1));
                    sels.push(s);
                }
                break;
            }
        }
        if (i == sel.length) return sel;
        return sels.length > 1 ? [ "," ].concat(sels) : sels[0];
    }
    function normalize(sels) {
        if (sels[0] === ",") {
            var r = [ "," ];
            for (var i = i; i < sels.length; i++) {
                var s = normalizeOne(s[i]);
                r = r.concat(s[0] === "," ? s.slice(1) : s);
            }
            return r;
        } else {
            return normalizeOne(sels);
        }
    }
    function parse_selector(str, off, hints) {
        var soff = off;
        var s = {};
        var l = lex(str, off);
        // skip space
        if (l && l[1] === " ") {
            soff = off = l[0];
            l = lex(str, off);
        }
        if (l && l[1] === toks.typ) {
            s.type = l[2];
            l = lex(str, off = l[0]);
        } else if (l && l[1] === "*") {
            // don't bother representing the universal sel, '*' in the
            // parse tree, cause it's the default
            l = lex(str, off = l[0]);
        }
        // now support either an id or a pc
        while (true) {
            if (l === undefined) {
                break;
            } else if (l[1] === toks.ide) {
                if (s.id) te("nmi", l[1]);
                s.id = l[2];
            } else if (l[1] === toks.psc) {
                if (s.pc || s.pf) te("mpc", l[1]);
                // collapse first-child and last-child into nth-child expressions
                if (l[2] === ":first-child") {
                    s.pf = ":nth-child";
                    s.a = 0;
                    s.b = 1;
                } else if (l[2] === ":last-child") {
                    s.pf = ":nth-last-child";
                    s.a = 0;
                    s.b = 1;
                } else {
                    s.pc = l[2];
                }
            } else if (l[1] === toks.psf) {
                if (l[2] === ":val" || l[2] === ":contains") {
                    s.expr = [ undefined, l[2] === ":val" ? "=" : "*=", undefined ];
                    // any amount of whitespace, followed by paren, string, paren
                    l = lex(str, off = l[0]);
                    if (l && l[1] === " ") l = lex(str, off = l[0]);
                    if (!l || l[1] !== "(") te("pex", str);
                    l = lex(str, off = l[0]);
                    if (l && l[1] === " ") l = lex(str, off = l[0]);
                    if (!l || l[1] !== toks.str) te("sex", str);
                    s.expr[2] = l[2];
                    l = lex(str, off = l[0]);
                    if (l && l[1] === " ") l = lex(str, off = l[0]);
                    if (!l || l[1] !== ")") te("epex", str);
                } else if (l[2] === ":has") {
                    // any amount of whitespace, followed by paren
                    l = lex(str, off = l[0]);
                    if (l && l[1] === " ") l = lex(str, off = l[0]);
                    if (!l || l[1] !== "(") te("pex", str);
                    var h = parse(str, l[0], true);
                    l[0] = h[0];
                    if (!s.has) s.has = [];
                    s.has.push(h[1]);
                } else if (l[2] === ":expr") {
                    if (s.expr) te("mexp", str);
                    var e = exprParse(str, l[0]);
                    l[0] = e[0];
                    s.expr = e[1];
                } else {
                    if (s.pc || s.pf) te("mpc", str);
                    s.pf = l[2];
                    var m = nthPat.exec(str.substr(l[0]));
                    if (!m) te("mepf", str);
                    if (m[5]) {
                        s.a = 2;
                        s.b = m[5] === "odd" ? 1 : 0;
                    } else if (m[6]) {
                        s.a = 0;
                        s.b = parseInt(m[6], 10);
                    } else {
                        s.a = parseInt((m[1] ? m[1] : "+") + (m[2] ? m[2] : "1"), 10);
                        s.b = m[3] ? parseInt(m[3] + m[4], 10) : 0;
                    }
                    l[0] += m[0].length;
                }
            } else {
                break;
            }
            l = lex(str, off = l[0]);
        }
        // now if we didn't actually parse anything it's an error
        if (soff === off) te("se", str);
        return [ off, s ];
    }
    // THE EVALUATOR
    function isArray(o) {
        return Array.isArray ? Array.isArray(o) : toString.call(o) === "[object Array]";
    }
    function mytypeof(o) {
        if (o === null) return "null";
        var to = typeof o;
        if (to === "object" && isArray(o)) to = "array";
        return to;
    }
    function mn(node, sel, id, num, tot) {
        var sels = [];
        var cs = sel[0] === ">" ? sel[1] : sel[0];
        var m = true, mod;
        if (cs.type) m = m && cs.type === mytypeof(node);
        if (cs.id) m = m && cs.id === id;
        if (m && cs.pf) {
            if (cs.pf === ":nth-last-child") num = tot - num; else num++;
            if (cs.a === 0) {
                m = cs.b === num;
            } else {
                mod = (num - cs.b) % cs.a;
                m = !mod && num * cs.a + cs.b >= 0;
            }
        }
        if (m && cs.has) {
            // perhaps we should augment forEach to handle a return value
            // that indicates "client cancels traversal"?
            var bail = function() {
                throw 42;
            };
            for (var i = 0; i < cs.has.length; i++) {
                try {
                    forEach(cs.has[i], node, bail);
                } catch (e) {
                    if (e === 42) continue;
                }
                m = false;
                break;
            }
        }
        if (m && cs.expr) {
            m = exprEval(cs.expr, node);
        }
        // should we repeat this selector for descendants?
        if (sel[0] !== ">" && sel[0].pc !== ":root") sels.push(sel);
        if (m) {
            // is there a fragment that we should pass down?
            if (sel[0] === ">") {
                if (sel.length > 2) {
                    m = false;
                    sels.push(sel.slice(2));
                }
            } else if (sel.length > 1) {
                m = false;
                sels.push(sel.slice(1));
            }
        }
        return [ m, sels ];
    }
    function forEach(sel, obj, fun, id, num, tot) {
        var a = sel[0] === "," ? sel.slice(1) : [ sel ], a0 = [], call = false, i = 0, j = 0, k, x;
        for (i = 0; i < a.length; i++) {
            x = mn(obj, a[i], id, num, tot);
            if (x[0]) {
                call = true;
            }
            for (j = 0; j < x[1].length; j++) {
                a0.push(x[1][j]);
            }
        }
        if (a0.length && typeof obj === "object") {
            if (a0.length >= 1) {
                a0.unshift(",");
            }
            if (isArray(obj)) {
                for (i = 0; i < obj.length; i++) {
                    forEach(a0, obj[i], fun, undefined, i, obj.length);
                }
            } else {
                for (k in obj) {
                    if (obj.hasOwnProperty(k)) {
                        forEach(a0, obj[k], fun, k);
                    }
                }
            }
        }
        if (call && fun) {
            fun(obj);
        }
    }
    function match(sel, obj) {
        var a = [];
        forEach(sel, obj, function(x) {
            a.push(x);
        });
        return a;
    }
    function format(sel, arr) {
        sel = sel.replace(/\?/g, function() {
            if (arr.length === 0) throw "too few parameters given";
            var p = arr.shift();
            return typeof p === "string" ? JSON.stringify(p) : p;
        });
        if (arr.length) throw "too many parameters supplied";
        return sel;
    }
    function compile(sel, arr) {
        if (arr) sel = format(sel, arr);
        return {
            "sel": parse(sel)[1],
            "match": function(obj) {
                return match(this.sel, obj);
            },
            "forEach": function(obj, fun) {
                return forEach(this.sel, obj, fun);
            }
        };
    }
    exports._lex = lex;
    exports._parse = parse;
    exports.match = function(sel, arr, obj) {
        if (!obj) {
            obj = arr;
            arr = undefined;
        }
        return compile(sel, arr).match(obj);
    };
    exports.forEach = function(sel, arr, obj, fun) {
        if (!fun) {
            fun = obj;
            obj = arr;
            arr = undefined;
        }
        return compile(sel, arr).forEach(obj, fun);
    };
    exports.compile = compile;
    define("/lib/jsonselect", function() {
        return exports;
    });
})(window);define("/lib/tpHelper/hogan", function(require, exports, module) {
    /*
 *  Copyright 2011 Twitter, Inc.
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
    var Hogan = {};
    (function(Hogan, useArrayBuffer) {
        Hogan.Template = function(renderFunc, text, compiler, options) {
            this.r = renderFunc || this.r;
            this.c = compiler;
            this.options = options;
            this.text = text || "";
            this.buf = useArrayBuffer ? [] : "";
        };
        Hogan.Template.prototype = {
            // render: replaced by generated code.
            "r": function(context, partials, indent) {
                return "";
            },
            // variable escaping
            "v": hoganEscape,
            // triple stache
            "t": coerceToString,
            "render": function render(context, partials, indent) {
                return this.ri([ context ], partials || {}, indent);
            },
            // render internal -- a hook for overrides that catches partials too
            "ri": function(context, partials, indent) {
                return this.r(context, partials, indent);
            },
            // tries to find a partial in the curent scope and render it
            "rp": function(name, context, partials, indent) {
                var partial = partials[name];
                if (!partial) {
                    return "";
                }
                if (this.c && typeof partial == "string") {
                    partial = this.c.compile(partial, this.options);
                }
                return partial.ri(context, partials, indent);
            },
            // render a section
            "rs": function(context, partials, section) {
                var tail = context[context.length - 1];
                if (!isArray(tail)) {
                    section(context, partials, this);
                    return;
                }
                for (var i = 0; i < tail.length; i++) {
                    context.push(tail[i]);
                    section(context, partials, this);
                    context.pop();
                }
            },
            // maybe start a section
            "s": function(val, ctx, partials, inverted, start, end, tags) {
                var pass;
                if (isArray(val) && val.length === 0) {
                    return false;
                }
                if (typeof val == "function") {
                    val = this.ls(val, ctx, partials, inverted, start, end, tags);
                }
                pass = val === "" || !!val;
                if (!inverted && pass && ctx) {
                    ctx.push(typeof val == "object" ? val : ctx[ctx.length - 1]);
                }
                return pass;
            },
            // find values with dotted names
            "d": function(key, ctx, partials, returnFound) {
                var names = key.split("."), val = this.f(names[0], ctx, partials, returnFound), cx = null;
                if (key === "." && isArray(ctx[ctx.length - 2])) {
                    return ctx[ctx.length - 1];
                }
                for (var i = 1; i < names.length; i++) {
                    if (val && typeof val == "object" && names[i] in val) {
                        cx = val;
                        val = val[names[i]];
                    } else {
                        val = "";
                    }
                }
                if (returnFound && !val) {
                    return false;
                }
                if (!returnFound && typeof val == "function") {
                    ctx.push(cx);
                    val = this.lv(val, ctx, partials);
                    ctx.pop();
                }
                return val;
            },
            // find values with normal names
            "f": function(key, ctx, partials, returnFound) {
                var val = false, v = null, found = false;
                for (var i = ctx.length - 1; i >= 0; i--) {
                    v = ctx[i];
                    if (v && typeof v == "object" && key in v) {
                        val = v[key];
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    return returnFound ? false : "";
                }
                if (!returnFound && typeof val == "function") {
                    val = this.lv(val, ctx, partials);
                }
                return val;
            },
            // higher order templates
            "ho": function(val, cx, partials, text, tags) {
                var compiler = this.c;
                var options = this.options;
                options.delimiters = tags;
                var text = val.call(cx, text);
                text = text == null ? String(text) : text.toString();
                this.b(compiler.compile(text, options).render(cx, partials));
                return false;
            },
            // template result buffering
            "b": useArrayBuffer ? function(s) {
                this.buf.push(s);
            } : function(s) {
                this.buf += s;
            },
            "fl": useArrayBuffer ? function() {
                var r = this.buf.join("");
                this.buf = [];
                return r;
            } : function() {
                var r = this.buf;
                this.buf = "";
                return r;
            },
            // lambda replace section
            "ls": function(val, ctx, partials, inverted, start, end, tags) {
                var cx = ctx[ctx.length - 1], t = null;
                if (!inverted && this.c && val.length > 0) {
                    return this.ho(val, cx, partials, this.text.substring(start, end), tags);
                }
                t = val.call(cx);
                if (typeof t == "function") {
                    if (inverted) {
                        return true;
                    } else if (this.c) {
                        return this.ho(t, cx, partials, this.text.substring(start, end), tags);
                    }
                }
                return t;
            },
            // lambda replace variable
            "lv": function(val, ctx, partials) {
                var cx = ctx[ctx.length - 1];
                var result = val.call(cx);
                if (typeof result == "function") {
                    result = coerceToString(result.call(cx));
                    if (this.c && ~result.indexOf("{{")) {
                        return this.c.compile(result, this.options).render(cx, partials);
                    }
                }
                return coerceToString(result);
            }
        };
        var rAmp = /&/g, rLt = /</g, rGt = />/g, rApos = /\'/g, rQuot = /\"/g, hChars = /[&<>\"\']/;
        function coerceToString(val) {
            return String(val === null || val === undefined ? "" : val);
        }
        function hoganEscape(str) {
            str = coerceToString(str);
            return hChars.test(str) ? str.replace(rAmp, "&amp;").replace(rLt, "&lt;").replace(rGt, "&gt;").replace(rApos, "&#39;").replace(rQuot, "&quot;") : str;
        }
        var isArray = Array.isArray || function(a) {
            return Object.prototype.toString.call(a) === "[object Array]";
        };
    })(typeof exports !== "undefined" ? exports : Hogan);
});/**
 * ktemplate 模板公用函数
 * @author: Knight
 * @version: 0.0.1
 */
define("/lib/tpHelper/html", function(require, exports, module) {
    var rAmp = /&/g, rLt = /</g, rGt = />/g, rApos = /\'/g, rQuot = /\"/g, hChars = /[&<>\"\']/;
    var coerceToString = function(val) {
        return String(val === null || val === undefined ? "" : val);
    };
    /**
     * 编码 html , KTemplate中用到
     * @param str
     * @return {String|XML}
     */
    exports.escape = function(str) {
        str = coerceToString(str);
        return hChars.test(str) ? str.replace(rAmp, "&amp;").replace(rLt, "&lt;").replace(rGt, "&gt;").replace(rApos, "&#39;").replace(rQuot, "&quot;") : str;
    };
    var utils = {};
    [ "forEach", "some", "every", "filter", "map" ].forEach(function(fnName) {
        utils[fnName] = function(arr, fn, context) {
            if (!arr || typeof arr == "string") return arr;
            context = context || this;
            if (arr[fnName]) {
                return arr[fnName](fn, context);
            } else {
                var keys = Object.keys(arr);
                return keys[fnName](function(key) {
                    return fn.call(context, arr[key], key, arr);
                }, context);
            }
        };
    });
    exports.mixin = function mixin(to, from) {
        utils.forEach(from, function(val, key) {
            var toString = {}.toString.call(val);
            if (toString == "[object Array]" || toString == "[object Object]") {
                to[key] = mixin(val, to[key] || {});
            } else {
                to[key] = val;
            }
        });
        return to;
    };
});define("/lib/tpHelper/jade", function(require, exports, module) {
    var jade = function(exports) {
        /*!
 * Jade - runtime
 * Copyright(c) 2010 TJ Holowaychuk <tj@vision-media.ca>
 * MIT Licensed
 */
        /**
 * Lame Array.isArray() polyfill for now.
 */
        if (!Array.isArray) {
            Array.isArray = function(arr) {
                return "[object Array]" == Object.prototype.toString.call(arr);
            };
        }
        /**
 * Lame Object.keys() polyfill for now.
 */
        if (!Object.keys) {
            Object.keys = function(obj) {
                var arr = [];
                for (var key in obj) {
                    if (obj.hasOwnProperty(key)) {
                        arr.push(key);
                    }
                }
                return arr;
            };
        }
        /**
 * Merge two attribute objects giving precedence
 * to values in object `b`. Classes are special-cased
 * allowing for arrays and merging/joining appropriately
 * resulting in a string.
 *
 * @param {Object} a
 * @param {Object} b
 * @return {Object} a
 * @api private
 */
        exports.merge = function merge(a, b) {
            var ac = a["class"];
            var bc = b["class"];
            if (ac || bc) {
                ac = ac || [];
                bc = bc || [];
                if (!Array.isArray(ac)) ac = [ ac ];
                if (!Array.isArray(bc)) bc = [ bc ];
                ac = ac.filter(nulls);
                bc = bc.filter(nulls);
                a["class"] = ac.concat(bc).join(" ");
            }
            for (var key in b) {
                if (key != "class") {
                    a[key] = b[key];
                }
            }
            return a;
        };
        /**
 * Filter null `val`s.
 *
 * @param {Mixed} val
 * @return {Mixed}
 * @api private
 */
        function nulls(val) {
            return val != null;
        }
        /**
 * Render the given attributes object.
 *
 * @param {Object} obj
 * @param {Object} escaped
 * @return {String}
 * @api private
 */
        exports.attrs = function attrs(obj, escaped) {
            var buf = [], terse = obj.terse;
            delete obj.terse;
            var keys = Object.keys(obj), len = keys.length;
            if (len) {
                buf.push("");
                for (var i = 0; i < len; ++i) {
                    var key = keys[i], val = obj[key];
                    if ("boolean" == typeof val || null == val) {
                        if (val) {
                            terse ? buf.push(key) : buf.push(key + '="' + key + '"');
                        }
                    } else if (0 == key.indexOf("data") && "string" != typeof val) {
                        buf.push(key + "='" + JSON.stringify(val) + "'");
                    } else if ("class" == key && Array.isArray(val)) {
                        buf.push(key + '="' + exports.escape(val.join(" ")) + '"');
                    } else if (escaped && escaped[key]) {
                        buf.push(key + '="' + exports.escape(val) + '"');
                    } else {
                        buf.push(key + '="' + val + '"');
                    }
                }
            }
            return buf.join(" ");
        };
        /**
 * Escape the given string of `html`.
 *
 * @param {String} html
 * @return {String}
 * @api private
 */
        exports.escape = function escape(html) {
            return String(html).replace(/&(?!(\w+|\#\d+);)/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
        };
        /**
 * Re-throw the given `err` in context to the
 * the jade in `filename` at the given `lineno`.
 *
 * @param {Error} err
 * @param {String} filename
 * @param {String} lineno
 * @api private
 */
        exports.rethrow = function rethrow(err, filename, lineno) {
            if (!filename) throw err;
            var context = 3, str = require("fs").readFileSync(filename, "utf8"), lines = str.split("\n"), start = Math.max(lineno - context, 0), end = Math.min(lines.length, lineno + context);
            // Error context
            var context = lines.slice(start, end).map(function(line, i) {
                var curr = i + start + 1;
                return (curr == lineno ? "  > " : "    ") + curr + "| " + line;
            }).join("\n");
            // Alter exception message
            err.path = filename;
            err.message = (filename || "Jade") + ":" + lineno + "\n" + context + "\n\n" + err.message;
            throw err;
        };
        return exports;
    }({});
    module.exports = jade;
});/**
 * @describe:
 * @time: 上午11:42
 * @author: Knight
 * @version: 0.0.1
 */
define("/lib/tpHelper/vm", function(require, exports, module) {
    var Velocity = function(asts) {
        this.asts = asts;
        this.init();
    };
    Velocity.Helper = {};
    Velocity.prototype = {
        "constructor": Velocity
    };
    var hasEnumBug = !{
        "toString": 1
    }.propertyIsEnumerable("toString");
    var keys = Object.keys || function(o) {
        var result = [], p, i;
        for (p in o) {
            result.push(p);
        }
        if (hasEnumBug) {
            for (i = enumProperties.length - 1; i >= 0; i--) {
                p = enumProperties[i];
                if (o.hasOwnProperty(p)) {
                    result.push(p);
                }
            }
        }
        return result;
    };
    //api map
    "use strict";
    var utils = {
        "noop": function noop() {
            var arg = arguments;
            return function() {
                return arg;
            };
        }
    };
    [ "forEach", "some", "every", "filter", "map" ].forEach(function(fnName) {
        utils[fnName] = function(arr, fn, context) {
            if (!arr || typeof arr == "string") return arr;
            context = context || this;
            if (arr[fnName]) {
                return arr[fnName](fn, context);
            } else {
                var keys = Object.keys(arr);
                return keys[fnName](function(key) {
                    return fn.call(context, arr[key], key, arr);
                }, context);
            }
        };
    });
    var num = 0;
    utils.guid = function() {
        return num++;
    };
    utils.walks = function walks(arr, fn, callback) {
        var rets = [];
        var num = 0;
        var len = arr.length;
        this.forEach(arr, function(val, i) {
            fn(val, cb);
            function cb(err, ret) {
                if (num === len) return;
                if (err) {
                    callback(err, rets);
                    num = len;
                } else {
                    num++;
                    rets[i] = ret;
                    if (num === len) callback(null, rets);
                }
            }
        });
    };
    utils.mixin = function(to, from) {
        utils.forEach(from, function(val, key) {
            var toString = {}.toString.call(val);
            if (toString == "[object Array]" || toString == "[object Object]") {
                to[key] = utils.mixin(val, to[key] || {});
            } else {
                to[key] = val;
            }
        });
        return to;
    };
    utils.isArray = function(obj) {
        return {}.toString.call(obj) === "[object Array]";
    };
    utils.indexOf = function(elem, arr) {
        if (utils.isArray(arr)) {
            return arr.indexOf(elem);
        }
    };
    utils.keys = Object.keys;
    utils.now = Date.now;
    !function(Helper, utils) {
        /**
     * 获取引用文本，当引用自身不存在的情况下，需要返回原来的模板字符串
     */
        function getRefText(ast) {
            var ret = ast.leader;
            var isFn = ast.args !== undefined;
            if (ast.isWraped) ret += "{";
            if (isFn) {
                ret += getMethodText(ast);
            } else {
                ret += ast.id;
            }
            utils.forEach(ast.path, function(ref) {
                //不支持method并且传递参数
                if (ref.type == "method") {
                    ret += "." + getMethodText(ref);
                } else if (ref.type == "index") {
                    var text = "";
                    var id = ref.id;
                    if (id.type === "integer") {
                        text = id.value;
                    } else if (id.type === "string") {
                        var sign = id.isEval ? '"' : "'";
                        text = sign + id.value + sign;
                    } else {
                        text = getRefText(id);
                    }
                    ret += "[" + text + "]";
                } else if (ref.type == "property") {
                    ret += "." + ref.id;
                }
            }, this);
            if (ast.isWraped) ret += "}";
            return ret;
        }
        function getMethodText(ref) {
            var args = [];
            var ret = "";
            utils.forEach(ref.args, function(arg) {
                args.push(getLiteral(arg));
            });
            ret += ref.id + "(" + args.join(",") + ")";
            return ret;
        }
        function getLiteral(ast) {
            var ret = "";
            switch (ast.type) {
              case "string":
                {
                    var sign = ast.isEval ? '"' : "'";
                    ret = sign + ast.value + sign;
                    break;
                }

              case "integer":
              case "bool":
                {
                    ret = ast.value;
                    break;
                }

              case "array":
                {
                    ret = "[";
                    var len = ast.value.length - 1;
                    utils.forEach(ast.value, function(arg, i) {
                        ret += getLiteral(arg);
                        if (i !== len) ret += ", ";
                    });
                    ret += "]";
                    break;
                }

              default:
                ret = getRefText(ast);
            }
            return ret;
        }
        Helper.getRefText = getRefText;
    }(Velocity.Helper, utils);
    /** file: ./src/compile/blocks.js*/
    !function(Velocity, utils) {
        /**
     * blocks语法处理
     */
        utils.mixin(Velocity.prototype, {
            /**
       * 处理代码库: if foreach macro
       */
            "getBlock": function(block) {
                var ast = block[0];
                var ret = "";
                var _block = [ ast ];
                var _inBlock = [];
                var index = 0;
                var blockTypes = [ "if", "foreach", "macro", "noescape", "define" ];
                /**
         * 处理block嵌套，重新构造_block，把block中有嵌套的放入数组_inBlock,
         * _inBlock 最后成为_block的一个元素，_inBlock数组作为一个block数组，求值
         * 过程中，可以通过递归求值，进入下一层嵌套
         */
                utils.forEach(block, function(ast, i) {
                    if (i) {
                        if (utils.indexOf(ast.type, blockTypes) !== -1) {
                            index++;
                            _inBlock.push(ast);
                        } else if (ast.type === "end") {
                            index--;
                            if (index) {
                                _inBlock.push(ast);
                            } else {
                                _block.push(_inBlock.slice());
                                _inBlock = [];
                            }
                        } else {
                            index ? _inBlock.push(ast) : _block.push(ast);
                        }
                    }
                });
                if (ast.type === "if") {
                    ret = this.getBlockIf(_block);
                } else if (ast.type === "foreach") {
                    ret = this.getBlockEach(_block);
                } else if (ast.type === "macro") {
                    this.setBlockMacro(_block);
                } else if (ast.type === "noescape") {
                    ret = this._render(_block.slice(1));
                }
                return ret;
            },
            /**
       * define macro
       */
            "setBlockMacro": function(block) {
                var ast = block[0];
                var _block = block.slice(1);
                var macros = this.macros;
                macros[ast.id] = {
                    "asts": _block,
                    "args": ast.args
                };
            },
            /**
       * parse macro call
       */
            "getMacro": function(ast) {
                var macro = this.macros[ast.id];
                var ret = "";
                if (!macro) {
                    var jsmacros = this.jsmacros;
                    macro = jsmacros[ast.id];
                    var jsArgs = [];
                    if (macro && macro.apply) {
                        utils.forEach(ast.args, function(a) {
                            jsArgs.push(this.getLiteral(a));
                        }, this);
                        ret = macro.apply(this, jsArgs);
                    }
                } else {
                    var asts = macro.asts;
                    var args = macro.args;
                    var _call_args = ast.args;
                    var local = {};
                    var localKey = [];
                    var guid = utils.guid();
                    var contextId = ast.id + ":" + guid;
                    utils.forEach(args, function(ref, i) {
                        if (_call_args[i]) {
                            local[ref.id] = this.getLiteral(_call_args[i]);
                        } else {
                            local[ref.id] = undefined;
                        }
                    }, this);
                    ret = this.eval(asts, local, contextId);
                }
                return ret;
            },
            /**
       * eval
       * @param str {array|string} 需要解析的字符串
       * @param local {object} 局部变量
       * @param contextId {string}
       * @return {string}
       */
            "eval": function(str, local, contextId) {
                if (!local) {
                    if (utils.isArray(str)) {
                        return this._render(str);
                    } else {
                        return this.evalStr(str);
                    }
                } else {
                    var asts = [];
                    var Parser = Velocity.Parser;
                    contextId = contextId || "eval:" + utils.guid();
                    if (utils.isArray(str)) {
                        asts = str;
                    } else if (Parser) {
                        asts = Parser.parse(str);
                    }
                    if (asts.length) {
                        this.local[contextId] = local;
                        var ret = this._render(asts, contextId);
                        this.local[contextId] = {};
                        this.conditions.pop();
                        this.condition = "";
                        return ret;
                    }
                }
            },
            /**
       * parse #foreach
       */
            "getBlockEach": function(block) {
                var ast = block[0];
                var _from = this.getLiteral(ast.from);
                var _block = block.slice(1);
                var _to = ast.to;
                var local = {
                    "foreach": {
                        "count": 0
                    }
                };
                var ret = "";
                var guid = utils.guid();
                var contextId = "foreach:" + guid;
                var type = {}.toString.call(_from);
                if (!_from || type !== "[object Array]" && type !== "[object Object]") return;
                var len = utils.isArray(_from) ? _from.length : utils.keys(_from).length;
                utils.forEach(_from, function(val, i) {
                    if (this.setBreak) return;
                    //构造临时变量
                    local[_to] = val;
                    //TODO: here, the foreach variable give to local, when _from is not an
                    //array, count and hasNext would be undefined, also i is not the
                    //index.
                    local["foreach"]["count"] = i + 1;
                    local["foreach"]["index"] = i;
                    local["foreach"]["hasNext"] = i + 1 < len;
                    local["velocityCount"] = i + 1;
                    this.local[contextId] = local;
                    ret += this._render(_block, contextId);
                }, this);
                this.setBreak = false;
                //删除临时变量
                this.local[contextId] = {};
                this.conditions.pop();
                this.condition = "";
                return ret;
            },
            /**
       * parse #if
       */
            "getBlockIf": function(block) {
                var str = "";
                var received = false;
                var asts = [];
                utils.some(block, function(ast) {
                    if (ast.condition) {
                        if (received) return true;
                        received = this.getExpression(ast.condition);
                    } else if (ast.type === "else") {
                        if (received) return true;
                        received = true;
                    } else if (received) {
                        asts.push(ast);
                    }
                    return false;
                }, this);
                return this._render(asts);
            }
        });
    }(Velocity, utils);
    /** file: ./src/compile/compile.js*/
    !function(Velocity, utils) {
        var BLOCK_TYPES = [ "if", "foreach", "macro", "noescape", "define" ];
        /**
     * compile
     */
        utils.mixin(Velocity.prototype, {
            "init": function() {
                this.context = {};
                this.macros = {};
                this.conditions = [];
                this.local = {};
                this.silence = false;
                utils.forEach(this.asts, this._init, this);
            },
            "_init": function(ast, i) {
                if (!ast.type || ast.type !== "references") {
                    this._trim(i + 1);
                }
            },
            /**
       * 删除多余的换行符，规则，所有非references的指令后面的换行符，都去除接下来的
       * 换行符
       */
            "_trim": function(i) {
                var asts = this.asts;
                var _ast = asts[i];
                if (typeof _ast === "string" && _ast.slice(0, 1) === "\n") {
                    asts[i] = _ast.slice(1);
                }
            },
            /**
       * @param context {object} 上下文环境，数据对象
       * @param macro   {object} self defined #macro
       * @param silent {bool} 如果是true，$foo变量将原样输出
       * @return str
       */
            "render": function(context, macros, silence) {
                this.silence = !!silence;
                this.context = context || {};
                this.jsmacros = macros || {};
                var t1 = utils.now();
                var str = this._render();
                var t2 = utils.now();
                var cost = t2 - t1;
                this.cost = cost;
                return str;
            },
            /**
       * 解析入口函数
       * @param ast {array} 模板结构数组
       * @param contextId {number} 执行环境id，对于macro有局部作用域，变量的设置和
       * 取值，都放在一个this.local下，通过contextId查找
       * @return {string}解析后的字符串
       */
            "_render": function(asts, contextId) {
                var str = "";
                var block = [];
                var index = 0;
                asts = asts || this.asts;
                if (contextId) {
                    if (contextId !== this.condition) this.conditions.push(contextId);
                    this.condition = contextId;
                } else {
                    this.condition = null;
                }
                utils.forEach(asts, function(ast) {
                    var type = ast.type;
                    //foreach if macro时，index加一
                    if (utils.indexOf(type, BLOCK_TYPES) > -1) index++;
                    if (type === "comment") return;
                    if (index) {
                        type === "end" && index--;
                        if (index) {
                            block.push(ast);
                            return;
                        }
                    }
                    switch (type) {
                      case "references":
                        str += this.getReferences(ast, true);
                        break;

                      case "set":
                        this.setValue(ast);
                        break;

                      case "break":
                        this.setBreak = true;
                        break;

                      case "macro_call":
                        str += this.getMacro(ast);
                        break;

                      case "end":
                        //使用slide获取block的拷贝
                        str += this.getBlock(block.slice());
                        block = [];
                        break;

                      default:
                        if (utils.isArray(ast)) {
                            str += this.getBlock(ast);
                        } else {
                            str += ast;
                        }
                        break;
                    }
                }, this);
                return str;
            }
        });
    }(Velocity, utils);
    /** file: ./src/compile/expression.js*/
    !function(Velocity, utils) {
        /**
     * expression运算
     */
        utils.mixin(Velocity.prototype, {
            /**
       * 表达式求值，表达式主要是数学表达式，逻辑运算和比较运算，到最底层数据结构，
       * 基本数据类型，使用 getLiteral求值，getLiteral遇到是引用的时候，使用
       * getReferences求值
       */
            "getExpression": function(ast) {
                var exp = ast.expression;
                var ret;
                if (ast.type === "math") {
                    switch (ast.operator) {
                      case "+":
                        ret = this.getExpression(exp[0]) + this.getExpression(exp[1]);
                        break;

                      case "-":
                        ret = this.getExpression(exp[0]) - this.getExpression(exp[1]);
                        break;

                      case "/":
                        ret = this.getExpression(exp[0]) / this.getExpression(exp[1]);
                        break;

                      case "%":
                        ret = this.getExpression(exp[0]) % this.getExpression(exp[1]);
                        break;

                      case "*":
                        ret = this.getExpression(exp[0]) * this.getExpression(exp[1]);
                        break;

                      case "||":
                        ret = this.getExpression(exp[0]) || this.getExpression(exp[1]);
                        break;

                      case "&&":
                        ret = this.getExpression(exp[0]) && this.getExpression(exp[1]);
                        break;

                      case ">":
                        ret = this.getExpression(exp[0]) > this.getExpression(exp[1]);
                        break;

                      case "<":
                        ret = this.getExpression(exp[0]) < this.getExpression(exp[1]);
                        break;

                      case "==":
                        ret = this.getExpression(exp[0]) == this.getExpression(exp[1]);
                        break;

                      case ">=":
                        ret = this.getExpression(exp[0]) >= this.getExpression(exp[1]);
                        break;

                      case "<=":
                        ret = this.getExpression(exp[0]) <= this.getExpression(exp[1]);
                        break;

                      case "!=":
                        ret = this.getExpression(exp[0]) != this.getExpression(exp[1]);
                        break;

                      case "minus":
                        ret = -this.getExpression(exp[0]);
                        break;

                      case "not":
                        ret = !this.getExpression(exp[0]);
                        break;

                      case "parenthesis":
                        ret = this.getExpression(exp[0]);
                        break;

                      default:
                        return;
                    }
                    return ret;
                } else {
                    return this.getLiteral(ast);
                }
            }
        });
    }(Velocity, utils);
    /** file: ./src/compile/literal.js*/
    !function(Velocity, utils) {
        /**
     * literal解释模块
     * @require {method} getReferences
     */
        utils.mixin(Velocity.prototype, {
            /**
       * 字面量求值，主要包括string, integer, array, map四种数据结构
       * @param literal {object} 定义于velocity.yy文件，type描述数据类型，value属性
       * 是literal值描述
       * @return {object|string|number|array}返回对应的js变量
       */
            "getLiteral": function(literal) {
                var type = literal.type;
                var ret = "";
                if (type == "string") {
                    ret = this.getString(literal);
                } else if (type == "integer") {
                    ret = parseInt(literal.value, 10);
                } else if (type == "array") {
                    ret = this.getArray(literal);
                } else if (type == "map") {
                    ret = {};
                    var map = literal.value;
                    utils.forEach(map, function(exp, key) {
                        ret[key] = this.getLiteral(exp);
                    }, this);
                } else if (type == "bool") {
                    if (literal.value === "null") {
                        ret = null;
                    } else if (literal.value === "false") {
                        ret = false;
                    } else if (literal.value === "true") {
                        ret = true;
                    }
                } else {
                    return this.getReferences(literal);
                }
                return ret;
            },
            /**
       * 对字符串求值，对已双引号字符串，需要做变量替换
       */
            "getString": function(literal) {
                var val = literal.value;
                var ret = val;
                if (literal.isEval && (val.indexOf("#") !== -1 || val.indexOf("$") !== -1)) {
                    ret = this.evalStr(val);
                }
                return ret;
            },
            /**
       * 对array字面量求值，比如[1, 2]=> [1,2]，[1..5] => [1,2,3,4,5]
       * @param literal {object} array字面量的描述对象，分为普通数组和range数组两种
       * ，和js基本一致
       * @return {array} 求值得到的数组
       */
            "getArray": function(literal) {
                var ret = [];
                if (literal.isRange) {
                    var begin = literal.value[0];
                    if (begin.type === "references") {
                        begin = this.getReferences(begin);
                    }
                    var end = literal.value[1];
                    if (end.type === "references") {
                        end = this.getReferences(end);
                    }
                    end = parseInt(end, 10);
                    begin = parseInt(begin, 10);
                    var i;
                    if (!isNaN(begin) && !isNaN(end)) {
                        if (begin < end) {
                            for (i = begin; i <= end; i++) ret.push(i);
                        } else {
                            for (i = begin; i >= end; i--) ret.push(i);
                        }
                    }
                } else {
                    utils.forEach(literal.value, function(exp) {
                        ret.push(this.getLiteral(exp));
                    }, this);
                }
                return ret;
            },
            /**
       * 对双引号字符串进行eval求值，替换其中的变量，只支持最基本的变量类型替换
       */
            "evalStr": function(str) {
                // 如果是Broswer环境，使用正则执行evalStr，如果是node环境，或者自行设置
                // Velocity.Parser = Parser，可以对evalStr完整支持
                if (Velocity.Parser) {
                    var asts = Velocity.Parser.parse(str);
                    ret = this._render(asts);
                } else {
                    var ret = str;
                    var reg = /\$\{{0,1}([_a-z][a-z_\-0-9.]*)\}{0,1}/gi;
                    var self = this;
                    ret = ret.replace(reg, function() {
                        return self._getFromVarname(arguments[1]);
                    });
                }
                return ret;
            },
            /**
       * 通过变量名获取变量的值
       * @param varname {string} 变量名，比如$name.name，只支持一种形式，变量和属性
       * 的取值，index和method不支持，在字符处理中，只处理"$varname1 $foo.bar" 类似
       * 的变量，对于复杂类型不支持
       * @return ret {string} 变量对应的值
       */
            "_getFromVarname": function(varname) {
                var varPath = varname.split(".");
                var ast = {
                    "type": "references",
                    "id": varPath[0],
                    "leader": "$"
                };
                var path = [];
                for (var i = 1; i < varPath.length; i++) {
                    path.push({
                        "type": "property",
                        "id": varPath[i]
                    });
                }
                if (path.length) ast.path = path;
                return this.getReferences(ast);
            }
        });
    }(Velocity, utils);
    /** file: ./src/compile/references.js*/
    !function(Velocity, utils) {
        function getSize(obj) {
            if (utils.isArray(obj)) {
                return obj.length;
            } else if (typeof obj === "string") {
                return utils.keys(obj).length;
            }
            return undefined;
        }
        utils.mixin(Velocity.prototype, {
            /**
       * 引用求值
       * @param {object} ast 结构来自velocity.yy
       * @param {bool} isVal 取值还是获取字符串，两者的区别在于，求值返回结果，求
       * 字符串，如果没有返回变量自身，比如$foo
       */
            "getReferences": function(ast, isVal) {
                var isSilent = this.silence || ast.leader === "$!";
                var isfn = ast.args !== undefined;
                var context = this.context;
                var ret = context[ast.id];
                var local = this.getLocal(ast);
                if (ret !== undefined && isfn) {
                    ret = this.getPropMethod(ast, context);
                }
                if (local.isLocaled) ret = local["value"];
                // 如果是$page.setTitle('xx')类似的方法，需要设置page为对象
                var isSet = this.hasSetMethod(ast, ret);
                if (isSet !== false) {
                    if (!context[ast.id]) context[ast.id] = {};
                    utils.mixin(context[ast.id], isSet);
                    return "";
                }
                if (ast.path && ret !== undefined) {
                    utils.some(ast.path, function(property, i) {
                        ret = this.getAttributes(property, ret);
                        return ret === undefined;
                    }, this);
                }
                if (isVal && ret === undefined) ret = isSilent ? "" : Velocity.Helper.getRefText(ast);
                return ret;
            },
            /**
       * set方法需要单独处理，假设set只在references最后$page.setTitle('')
       * 对于set连缀的情况$page.setTitle('sd').setName('haha')
       */
            "hasSetMethod": function(ast, context) {
                var len = ast.path && ast.path.length;
                if (!len) return false;
                var lastId = "" + ast.path[len - 1].id;
                if (lastId.indexOf("set") !== 0) {
                    return false;
                } else {
                    context = context || {};
                    utils.forEach(ast.path, function(ast) {
                        if (ast.type === "method" && ast.id.indexOf("set") === 0) {
                            context[ast.id.slice(3)] = this.getLiteral(ast.args[0]);
                        } else {
                            context[ast.id] = context[ast.id] || {};
                        }
                    }, this);
                    return context;
                }
            },
            /**
       * 获取局部变量，在macro和foreach循环中使用
       */
            "getLocal": function(ast) {
                var id = ast.id;
                var local = this.local;
                var ret = false;
                var isLocaled = utils.some(this.conditions, function(contextId) {
                    var _local = local[contextId];
                    if (id in _local) {
                        ret = _local[id];
                        return true;
                    }
                    return false;
                }, this);
                return {
                    "value": ret,
                    "isLocaled": isLocaled
                };
            },
            /**
       * $foo.bar 属性求值
       */
            "getAttributes": function(property, baseRef) {
                /**
         * type对应着velocity.yy中的attribute，三种类型: method, index, property
         */
                var type = property.type;
                var ret;
                var id = property.id;
                if (type === "method") {
                    ret = this.getPropMethod(property, baseRef);
                } else if (type === "property") {
                    ret = baseRef[id];
                } else {
                    ret = this.getPropIndex(property, baseRef);
                }
                return ret;
            },
            /**
       * $foo.bar[1] index求值
       */
            "getPropIndex": function(property, baseRef) {
                var ast = property.id;
                var key;
                if (ast.type === "references") {
                    key = this.getReferences(ast);
                } else if (ast.type === "integer") {
                    key = ast.value;
                } else {
                    key = ast.value;
                }
                return baseRef[key];
            },
            /**
       * $foo.bar()求值
       */
            "getPropMethod": function(property, baseRef) {
                var id = property.id;
                var ret = "";
                var _id = id.slice(3);
                if (id.indexOf("get") === 0 && !(id in baseRef)) {
                    if (_id) {
                        ret = baseRef[_id];
                    } else {
                        //map 对应的get方法
                        _id = this.getLiteral(property.args[0]);
                        ret = baseRef[_id];
                    }
                    return ret;
                } else if (id.indexOf("is") === 0 && !(id in baseRef)) {
                    _id = id.slice(2);
                    ret = baseRef[_id];
                    return ret;
                } else if (id === "keySet") {
                    return utils.keys(baseRef);
                } else if (id === "entrySet") {
                    ret = [];
                    utils.forEach(baseRef, function(value, key) {
                        ret.push({
                            "key": key,
                            "value": value
                        });
                    });
                    return ret;
                } else if (id === "size") {
                    return getSize(baseRef);
                } else {
                    ret = baseRef[id];
                    var args = [];
                    utils.forEach(property.args, function(exp) {
                        args.push(this.getLiteral(exp));
                    }, this);
                    if (ret && ret.call) {
                        ret = ret.apply(baseRef, args);
                    } else {
                        ret = undefined;
                    }
                }
                return ret;
            }
        });
    }(Velocity, utils);
    /** file: ./src/compile/set.js*/
    !function(Velocity, utils) {
        /**
     * 变量设置
     */
        utils.mixin(Velocity.prototype, {
            /**
       * 获取执行环境，对于macro中定义的变量，为局部变量，不贮存在全局中，执行后销毁
       */
            "getContext": function() {
                var condition = this.condition;
                var local = this.local;
                if (condition) {
                    return local[condition];
                } else {
                    return this.context;
                }
            },
            /**
       * parse #set
       */
            "setValue": function(ast) {
                var ref = ast.equal[0];
                var context = this.getContext();
                var valAst = ast.equal[1];
                var val;
                if (valAst.type === "math") {
                    val = this.getExpression(valAst);
                } else {
                    val = this.getLiteral(ast.equal[1]);
                }
                if (!ref.path) {
                    context[ref.id] = val;
                } else {
                    var baseRef = context[ref.id];
                    if (typeof baseRef != "object") {
                        baseRef = {};
                    }
                    context[ref.id] = baseRef;
                    var len = ref.path ? ref.path.length : 0;
                    //console.log(val);
                    utils.forEach(ref.path, function(exp, i) {
                        var isEnd = len === i + 1;
                        var key = exp.id;
                        if (exp.type === "index") key = key.value;
                        baseRef[key] = isEnd ? val : {};
                        baseRef = baseRef[key];
                    });
                }
            }
        });
    }(Velocity, utils);
    module.exports = function(ast) {
        return new Velocity(ast);
    };
});/**
 * @describe: 模版公用方法
 * @time: 上午11:42
 * @author: KnightWu
 */
define("/lib/tpHelper", function(require, exports, module) {
    var utils = {};
    [ "forEach", "some", "every", "filter", "map" ].forEach(function(fnName) {
        utils[fnName] = function(arr, fn, context) {
            if (!arr || typeof arr == "string") return arr;
            context = context || this;
            if (arr[fnName]) {
                return arr[fnName](fn, context);
            } else {
                var keys = Object.keys(arr);
                return keys[fnName](function(key) {
                    return fn.call(context, arr[key], key, arr);
                }, context);
            }
        };
    });
    exports.mixin = function mixin(to, from) {
        utils.forEach(from, function(val, key) {
            var toString = {}.toString.call(val);
            if (toString == "[object Array]" || toString == "[object Object]") {
                to[key] = mixin(val, to[key] || {});
            } else {
                to[key] = val;
            }
        });
        return to;
    };
    exports.hogan = require("/lib/tpHelper/hogan");
    exports.html = require("/lib/tpHelper/html");
    exports.jade = require("/lib/tpHelper/jade");
    exports.vm = require("/lib/tpHelper/vm");
});
define("/output/everydayEnglish/everydayEnglish", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
         //alert(JSON.stringify(_data));
            var htmlCode = "";
            with (_data || {}) {
                htmlCode += '<div class="info-content info-content-a">\n         <div class="info-list">\n        <div class="sentence-example user-selected js-contextmenu-free">\n            ';
                if (_data.title) {
                    htmlCode += '\n            <p class="list1">';
                    htmlCode += _data.title;
                    htmlCode += "</p>\n            ";
                }
                htmlCode += '\n            <p class="list2">\n                ';
                htmlCode += _data.summary ? _data.summary + "<ins></ins>" : "";
                htmlCode += '  </p>\n        </div>\n       </div>\n                   \n</div>\n';
            }
            return htmlCode;
        },
        "init": function init() {}
    };
});/**
 * @date 13-2-20
 * @describe: 起始页
 * @version: 1.0
 */
/*jslint browser:true, vars:true, nomen:true, indent:4, maxlen:80*/
/*jslint plusplus:true, sloppy:true, todo:true, unparam:true, regexp:true*/
/*global define:true, $:true , ke:true*/
define("/src/scripts/render/dict/start/everydayEnglish", function(require, exports, module) {
    var store = require("/src/scripts/utils/store");
    var utils = require("/src/scripts/utils/utils"), fdata = require("/src/scripts/render/dict/start/fetchData"), external = require("/src/scripts/external"), shareto = require("/src/scripts/render/dict/shareTo");

    var curDate = new utils.kDate();
    setInterval(function() {
        if (!curDate.equals(new utils.kDate())) {
            curDate = new utils.kDate();
            module.exports.render();
        }
    }, 1e3 * 60 * (60 + Math.random() * 30));
    module.exports.resize = function(width) {
        if (width < 597) {
            //4列时的宽度
            $("#startContent").addClass("small");
        }
        $(".everyDayEnglish").animate({
            "width": width
        }, 500, function() {
            if (width >= 597) {
                //4列时的宽度
                $("#startContent").removeClass("small");
            }
        });
    };
    module.exports.render = function() {
        //今日一句
        fdata.getDefaultHeadData().then(function(data) { 
            //使用本地数据渲染每日一句
          $("#start .everyDayEnglish .startpage-type-word").html(require("/output/everydayEnglish/everydayEnglish").render(data));
       });
        module.exports.render = function() {
            fdata.getHeadData().then(function(data) {
                //尝试获取在线数据，如果获取成功，会刷新头图
                $("#start .everyDayEnglish .startpage-type-word").html(require("/output/everydayEnglish/everydayEnglish").render(data));
            });
            //昨日一句
            fdata.getDefaultyesterdayHeadData().then(function(data) { 
                //使用本地数据渲染每日一句
               $("#start .yesterdayEnglish .startpage-type-word-yesterday").html(require("/output/everydayEnglish/everydayEnglish").render(data));
            });
            fdata.getyesterdayHeadData().then(function(data) {
                //尝试获取在线数据，如果获取成功，会刷新头图
                $("#start .yesterdayEnglish .startpage-type-word-yesterday").html(require("/output/everydayEnglish/everydayEnglish").render(data));
            });
        };

    };
});/**
 * js模版的生成，以此为模版
 */
define("/output/ads_link/ads_link", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    // 工具类
    var _$ = require("/lib/jsonselect");
    // 工具类
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    // 用于模版模块生成的工具类
    module.exports = {
        "render": function anonymous(_data) {
            var htmlCode = "";
            with (_data || {}) {
                if (_data.rtype === "outer") {
                    htmlCode += "\n";
                    (function(_data) {
                        for (var i = 0; i < _data.length; i = i + 1) {
                            htmlCode += '\n<li class="js-index-outer-ads">\n    <span class="ads-order"></span>\n    <p><a href="';
                            htmlCode += _data[i].url;
                            htmlCode += '" target="_blank" title="';
                            htmlCode += _data[i].desc;
                            htmlCode += '">';
                            htmlCode += _data[i].title;
                            htmlCode += '</a></p>\n    <p class="additional">';
                            htmlCode += _data[i].desc;
                            htmlCode += "</p>\n</li>\n";
                        }
                    })(_data);
                    htmlCode += "\n";
                } else {
                    htmlCode += "\n";
                    (function(_data) {
                        for (var i = 0; i < _data.length; i = i + 1) {
                            htmlCode += '\n<li class="js-index-inner-ads">\n    <span class="ads-order"></span>\n    <p>\n        <a target="_blank" href="';
                            htmlCode += _data[i].url;
                            htmlCode += '" class="js-inner-ads-link js-ctlog" data-ctype="firstPageInnerAd" title="';
                            htmlCode += _data[i].desc;
                            htmlCode += '">';
                            htmlCode += _data[i].title;
                            htmlCode += "</a>\n        ";
                            if (_data[i].isnew === "true") {
                                htmlCode += '\n        	<sup class="new-inner-ad"></sup>\n        ';
                            }
                            htmlCode += "\n    </p>\n</li>\n";
                        }
                    })(_data);
                    htmlCode += "\n";
                }
            }
            return htmlCode;
        },
        "init": function init() {}
    };
});define("/output/auth_sents/auth_sents", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            _data = tpHelper.mixin(_data, {
                "_getSpokenSens": function(sentences) {
                    return sentences.replace("</b>", "").replace("<b>", "").replace(/\"|\"/g, "&quot;").replace(/\'|\'/g, "&apos;");
                }
            });
            return tpHelper.vm([ '<div class="trans-container auth_sents">\n    <ul>\n        ', [ {
                "type": "foreach",
                "to": "sentence",
                "from": {
                    "type": "references",
                    "id": "sent",
                    "leader": "$"
                }
            }, '\n            <li class="cols-layout">\n                <span class="col1 order">', {
                "type": "references",
                "id": "foreach",
                "path": [ {
                    "type": "property",
                    "id": "count"
                } ],
                "isWraped": true,
                "leader": "$",
                "prue": true
            }, '.</span>\n\n                <div class="col2">\n                    <p>', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "foreign"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '\n                        <span class="pronounce">\n                             <a class="sp dictvoice js-ctlog" data-ctype="例句发音_TTS" role="dict_audio_js"  title="点击发音"\n                                data-rel="http://dict.youdao.com/dictvoice?audio=', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "speech"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '"></a>\n                        </span>\n                        <a href="javascript:;" title="口语练习" class="js-record spoken-record sentences_record js-ctlog"\n                           data-ctype="跟读_例句_权威"  data-format="audio"\n                           data-sentences="', {
                "type": "references",
                "id": "_getSpokenSens",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "property",
                        "id": "foreign"
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, '"', '\n                        data-rel="http://dict.youdao.com/dictvoice?audio=', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "speech"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '" >跟读</a>\n                    </p>\n                    <p><a class="source"\n                          href="', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "url"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '"\n                          target="_blank" rel="nofollow">', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "source"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "</a></p>\n                </div>\n            </li>\n        " ], "\n    </ul>\n</div>" ]).render(_data);
        },
        "init": function init() {}
    };
});define("/output/auth_sents_part/auth_sents_part", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            _data = tpHelper.mixin(_data, {
                "_getSpokenSens": function(sentences) {
                    return sentences.replace("</b>", "").replace("<b>", "").replace(/\"|\"/g, "&quot;").replace(/\'|\'/g, "&apos;");
                }
            });
            return tpHelper.vm([ '<div class="trans-container auth_sents_part">\n    <ul>\n        ', [ {
                "type": "foreach",
                "to": "sentence",
                "from": {
                    "type": "references",
                    "id": "sent",
                    "leader": "$"
                }
            }, '\n            <li class="cols-layout">\n                <span class="col1 order">', {
                "type": "references",
                "id": "foreach",
                "path": [ {
                    "type": "property",
                    "id": "count"
                } ],
                "isWraped": true,
                "leader": "$",
                "prue": true
            }, '.</span>\n                <span class="col2">\n                    <p>', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "foreign"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '\n                        <span class="pronounce">\n                            <a class="sp dictvoice js-ctlog" data-ctype="例句发音_TTS" role=\'dict_audio_js\' title="点击发音"\n                           data-rel="http://dict.youdao.com/dictvoice?audio=', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "speech"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '">voice</a>\n                        </span>\n                        <a href="javascript:;" title="口语练习"\n                           class="js-record spoken-record sentences_record js-ctlog"\n                           data-ctype="跟读_例句_权威"   data-format="audio"\n                           data-sentences="', {
                "type": "references",
                "id": "_getSpokenSens",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "property",
                        "id": "foreign"
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, '"', '\n                          data-rel="http://dict.youdao.com/dictvoice?audio=', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "speech"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '">跟读</a>\n                    </p>\n                    <p><a class="source"\n                          href="', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "url"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '"\n                          target="_blank" rel="nofollow">', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "source"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "</a></p>\n                </span>\n            </li>\n        " ], "\n    </ul>\n    ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "more",
                    "leader": "$"
                }
            }, '\n        <a href="" class="more clickable js-ctlog" data-ctype="点击更多权威例句" data-example-type="auth">更多权威例句</a>\n    ' ], "\n</div>" ]).render(_data);
        },
        "init": function init() {}
    };
});define("/output/baike/baike", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            return tpHelper.vm([ '<div class="trans-container baike">\n    <ul>\n    ', [ {
                "type": "foreach",
                "to": "perSummary",
                "from": {
                    "type": "references",
                    "id": "summarys",
                    "leader": "$"
                }
            }, "\n        <li>\n        ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perSummary",
                    "path": [ {
                        "type": "property",
                        "id": "image"
                    } ],
                    "leader": "$"
                }
            }, '\n            <span class="hasImg">\n                <img src="', {
                "type": "references",
                "id": "perSummary",
                "path": [ {
                    "type": "property",
                    "id": "image"
                } ],
                "leader": "$",
                "prue": true
            }, '"', ' alt="', {
                "type": "references",
                "id": "perSummary",
                "path": [ {
                    "type": "property",
                    "id": "title"
                } ],
                "leader": "$",
                "prue": true
            }, '"', "/>\n            </span>\n        " ], "\n        ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perSummary",
                    "path": [ {
                        "type": "property",
                        "id": "image"
                    } ],
                    "leader": "$"
                }
            }, '\n            <div class="has-right-img">\n        ', {
                "type": "else"
            }, " \n            <div>\n        " ], '\n            <h4>\n                <a href="', "#", '"  class="title clickable js-go-baike" data-key="', {
                "type": "references",
                "id": "perSummary",
                "path": [ {
                    "type": "property",
                    "id": "key"
                } ],
                "leader": "$",
                "prue": true
            }, '"', ' data-type="baike_detail">', {
                "type": "references",
                "id": "perSummary",
                "path": [ {
                    "type": "property",
                    "id": "key"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/a>\n            </h4>\n            <p>", {
                "type": "references",
                "id": "perSummary",
                "path": [ {
                    "type": "property",
                    "id": "summary"
                } ],
                "leader": "$",
                "prue": true
            }, "<", '/p>\n            <a href="', "#", '" class="clickable js-go-baike js-ctlog" data-ctype="点击百科详细内容" data-key="', {
                "type": "references",
                "id": "perSummary",
                "path": [ {
                    "type": "property",
                    "id": "key"
                } ],
                "leader": "$",
                "prue": true
            }, '"', ' data-type="baike_detail">详细内容</a>\n            <p>\n                <a href="', "#", '" class="clickable js-go-baike js-ctlog" data-ctype="点击更多百科相关词条"\n                   data-key="', {
                "type": "references",
                "id": "perSummary",
                "path": [ {
                    "type": "property",
                    "id": "key"
                } ],
                "leader": "$",
                "prue": true
            }, '"', ' data-type="baike_relative">更多与"', {
                "type": "references",
                "id": "perSummary",
                "path": [ {
                    "type": "property",
                    "id": "key"
                } ],
                "leader": "$",
                "prue": true
            }, '"', "相关的百科词条>> </a>\n            </p>\n            </div>\n        </li>\n    " ], "\n    </ul>\n</div>" ]).render(_data);
        },
        "init": function init() {
            var adjustNav = function() {
                var target = document.getElementById("target"), nav = document.getElementById("go-detail");
                if (target) {
                    var offsetX = target.offsetWidth;
                    var offsetY = target.offsetHeight;
                    nav.style.left = offsetX - 20 + "px";
                    nav.style.top = offsetY / 2 + "px";
                }
            };
            adjustNav();
            window.onresize = function() {
                adjustNav();
            };
        }
    };
});define("/output/baike_detail/baike_detail", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            return tpHelper.vm([ '<div class="trans-container baike_detail">\n    ', [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "source",
                    "path": [ {
                        "type": "property",
                        "id": "logo"
                    } ],
                    "leader": "$"
                }
            }, '\n    <p class="secondary source">\n        百科内容来自于: <a class="clickable" target="_blank" href="', {
                "type": "references",
                "id": "source",
                "path": [ {
                    "type": "property",
                    "id": "url"
                } ],
                "leader": "$",
                "prue": true
            }, '"', ' rel="nofollow">\n            <img src="', {
                "type": "references",
                "id": "source",
                "path": [ {
                    "type": "property",
                    "id": "logo"
                } ],
                "leader": "$",
                "prue": true
            }, '"', ' id="baikelogo"/>\n        </a>\n    </p>\n    ' ], "\n    <h3>", {
                "type": "references",
                "id": "title",
                "leader": "$",
                "prue": true
            }, "<", '/h3>\n    <div class="content">\n        <p>', {
                "type": "references",
                "id": "headSection",
                "leader": "$",
                "prue": true
            }, "<", "/p>\n        <ul>\n            ", [ {
                "type": "foreach",
                "to": "sec",
                "from": {
                    "type": "references",
                    "id": "sections",
                    "path": [ {
                        "type": "property",
                        "id": "section"
                    } ],
                    "leader": "$"
                }
            }, "\n                <li>\n                    <h4>", {
                "type": "references",
                "id": "sec",
                "path": [ {
                    "type": "property",
                    "id": "subtitle"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/h4>\n                    ", {
                "type": "references",
                "id": "sec",
                "path": [ {
                    "type": "property",
                    "id": "content"
                } ],
                "leader": "$",
                "prue": true
            }, "\n                ", "</li>\n            " ], "\n        </ul>\n    </div>\n</div>" ]).render(_data);
        },
        "init": function init() {}
    };
});define("/output/baike_nomatch/baike_nomatch", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            _data = tpHelper.mixin(_data, {
                "_getInput": function(input) {
                    return tpHelper.html.escape(input.replace(/^bk:/g, ""));
                }
            });
            var htmlCode = "";
            with (_data || {}) {
                htmlCode += '<div class="trans-container baike_nomatch">\n    <h5>抱歉，没有找到与您查询的"<b>';
                htmlCode += _getInput(input);
                htmlCode += '</b>"相关的百科结果。</h5>\n    <ul>\n        <li>请查看输入的字词是否有错误</li>\n        <li>请在网页搜索中搜索"<a target="_blank" href="http://www.youdao.com/search?keyfrom=deskdict_deepin&ue=utf8&q=';
                htmlCode += _getInput(input);
                htmlCode += '">';
                htmlCode += _getInput(input);
                htmlCode += '</a>" </li>\n        <li>请阅读<a target="_blank" href="http://cidian.youdao.com/help.jsp">帮助</a></li>\n    </ul>\n</div>\n';
            }
            return htmlCode;
        },
        "init": function init() {}
    };
});define("/output/baike_nomatch_with_typo/baike_nomatch_with_typo", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            _data = tpHelper.mixin(_data, {
                "_getInput": function(input) {
                    return tpHelper.html.escape(input.replace(/^bk:/g, ""));
                }
            });
            var htmlCode = "";
            with (_data || {}) {
                htmlCode += '<div class="trans-container baike_nomatch typos">\n    <div class="error-typo">\n        <h4>您是不是要找：</h4>\n        ';
                for (var i = 0; i < _data.typos.typo.length; i++) {
                    htmlCode += '\n            <p class="typo-rel">\n                <a class="title" href="app:bk:';
                    htmlCode += _data.typos.typo[i].word;
                    htmlCode += '">';
                    htmlCode += _data.typos.typo[i].word;
                    htmlCode += "</a> ：";
                    htmlCode += !_data.typos.typo[i].trans ? "" : _data.typos.typo[i].trans;
                    htmlCode += "\n            </p>\n        ";
                }
                htmlCode += '\n\n    </div>\n    <h5>抱歉，没有找到与您查询的"<b>';
                htmlCode += _getInput(input);
                htmlCode += '</b>"相关的百科结果。</h5>\n    <ul>\n        <li>请查看输入的字词是否有错误</li>\n        <li>请在网页搜索中搜索"<a target="_blank" href="http://www.youdao.com/search?keyfrom=deskdict_deepin&ue=utf8&q=';
                htmlCode += _getInput(input);
                htmlCode += '">';
                htmlCode += _getInput(input);
                htmlCode += '</a>" </li>\n        <li>请阅读<a target="_blank" href="http://cidian.youdao.com/help.jsp">帮助</a></li>\n    </ul>\n</div>\n';
            }
            return htmlCode;
        },
        "init": function init() {}
    };
});define("/output/baike_offline_noResult/baike_offline_noResult", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            var htmlCode = "";
            with (_data || {}) {
                htmlCode += '<div class="trans-container offline-noResult baike-offline-noResult" >\n    <img src="./src/images/offline_noResult.png">\n    <p>抱歉离线模式下不能使用百科功能，请查看您的网络连接或代理设置。</p>\n</div>\n';
            }
            return htmlCode;
        },
        "init": function init() {}
    };
});define("/output/baike_relative/baike_relative", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            return tpHelper.vm([ '<div class="trans-container baike_relative">\n    ', [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "source",
                    "path": [ {
                        "type": "property",
                        "id": "logo"
                    } ],
                    "leader": "$"
                }
            }, '\n        <p class="secondary source">\n            百科内容来自于: <a class="clickable" target="_blank" href="', {
                "type": "references",
                "id": "source",
                "path": [ {
                    "type": "property",
                    "id": "url"
                } ],
                "leader": "$",
                "prue": true
            }, '"', ' rel="nofollow">\n                <img src="', {
                "type": "references",
                "id": "source",
                "path": [ {
                    "type": "property",
                    "id": "logo"
                } ],
                "leader": "$",
                "prue": true
            }, '"', ' id="baikelogo"/>\n            </a>\n        </p>\n    ' ], "\n    <ul>\n    ", [ {
                "type": "foreach",
                "to": "perItem",
                "from": {
                    "type": "references",
                    "id": "items",
                    "leader": "$"
                }
            }, "\n        <li>\n        ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perItem",
                    "path": [ {
                        "type": "property",
                        "id": "image"
                    } ],
                    "leader": "$"
                }
            }, '\n            <div class="has-right-img">\n        ', {
                "type": "else"
            }, " \n            <div>\n        " ], '\n                <h4>\n                    <a data-rel="', {
                "type": "references",
                "id": "perItem",
                "path": [ {
                    "type": "property",
                    "id": "title"
                } ],
                "leader": "$",
                "prue": true
            }, '"', ' href="javascript:;" class="js-go-detail title clickable">', {
                "type": "references",
                "id": "perItem",
                "path": [ {
                    "type": "property",
                    "id": "title"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/a>\n                </h4>\n                <p>", {
                "type": "references",
                "id": "perItem",
                "path": [ {
                    "type": "property",
                    "id": "summary"
                } ],
                "leader": "$",
                "prue": true
            }, "<", '/p>\n                <a  data-rel="', {
                "type": "references",
                "id": "perItem",
                "path": [ {
                    "type": "property",
                    "id": "title"
                } ],
                "leader": "$",
                "prue": true
            }, '"', ' href="javascript:;" class="js-go-detail clickable">详细内容&gt;&gt;</a>\n            </div>\n            ', [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perItem",
                    "path": [ {
                        "type": "property",
                        "id": "image"
                    } ],
                    "leader": "$"
                }
            }, '\n                <span class="hasImg">\n                    <img src="', {
                "type": "references",
                "id": "perItem",
                "path": [ {
                    "type": "property",
                    "id": "image"
                } ],
                "leader": "$",
                "prue": true
            }, '"', ' alt="', {
                "type": "references",
                "id": "perItem",
                "path": [ {
                    "type": "property",
                    "id": "title"
                } ],
                "leader": "$",
                "prue": true
            }, '"', "/>\n                </span>\n            " ], "\n        </li>\n    " ], "\n    </ul>\n</div>" ]).render(_data);
        },
        "init": function init() {}
    };
});define("/output/baike_welcome/baike_welcome", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            var htmlCode = "";
            with (_data || {}) {
                htmlCode += '<div class="baike-startpage">\n    <img src="./src/images/baike-welcome.png">\n</div>';
            }
            return htmlCode;
        },
        "init": function init() {}
    };
});define("/output/blng_sents/blng_sents", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            _data = tpHelper.mixin(_data, {
                "_getHtmlPair": function(pair, index) {
                    return utils.align(pair, index, "blng");
                },
                "_getSpokenSens": function(sentences) {
                    return sentences.replace("</b>", "").replace("<b>", "").replace(/\"|\"/g, "&quot;").replace(/\'|\'/g, "&apos;");
                },
                "_getUrl": function(url) {
                    return url.split("/")[2];
                }
            });
            return tpHelper.vm([ '<div class="trans-container blng_sents">\n    ', [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "trans",
                    "leader": "$"
                }
            }, '\n        <div class="content_title js-example-item-title">\n            ', [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "showAllExplanation",
                    "leader": "$"
                }
            }, '\n                <a class="clickable allExplanation show-all-explanation js-ctlog" data-ctype="点击全部释义_双语">全部释义例句&gt;&gt;</a>\n            ', {
                "type": "else"
            }, '\n                <a class="clickable allExplanation js-ctlog" data-ctype="点击全部释义_双语">全部释义例句</a>\n            ' ], '\n            <span class="type-list">\n                <span class="list-input">', {
                "type": "references",
                "id": "trans",
                "path": [ {
                    "type": "property",
                    "id": "displayWord"
                } ],
                "leader": "$",
                "prue": true
            }, ":", " </span>\n                ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "allTrans",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "trans",
                    "path": [ {
                        "type": "property",
                        "id": "tran"
                    } ],
                    "leader": "$"
                } ]
            }, "\n                ", [ {
                "type": "foreach",
                "to": "perTran",
                "from": {
                    "type": "references",
                    "id": "allTrans",
                    "leader": "$"
                }
            }, "\n                    ", [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "foreach",
                        "path": [ {
                            "type": "property",
                            "id": "count"
                        } ],
                        "isWraped": true,
                        "leader": "$"
                    }, {
                        "type": "math",
                        "expression": [ {
                            "type": "references",
                            "id": "index",
                            "leader": "$"
                        }, {
                            "type": "integer",
                            "value": "1"
                        } ],
                        "operator": "+"
                    } ],
                    "operator": "=="
                }
            }, '\n                        <a class="clickable per-type cur js-ctlog" data-ctype="点击释义_双语" href="', "#", '" data-element="', {
                "type": "references",
                "id": "perTran",
                "leader": "$",
                "prue": true
            }, '"', "> ", {
                "type": "references",
                "id": "perTran",
                "leader": "$",
                "prue": true
            }, " ", "</a>\n                    ", {
                "type": "else"
            }, '\n                        <a class="clickable per-type js-ctlog" data-ctype="点击释义_双语" href="', "#", '" data-element="', {
                "type": "references",
                "id": "perTran",
                "leader": "$",
                "prue": true
            }, '"', "> ", {
                "type": "references",
                "id": "perTran",
                "leader": "$",
                "prue": true
            }, " ", "</a>\n                    " ], "\n                    ", [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "foreach",
                        "path": [ {
                            "type": "property",
                            "id": "count"
                        } ],
                        "isWraped": true,
                        "leader": "$"
                    }, {
                        "type": "references",
                        "id": "allTrans",
                        "path": [ {
                            "type": "property",
                            "id": "length"
                        } ],
                        "leader": "$"
                    } ],
                    "operator": "!="
                }
            }, "\n                        <ins>|</ins>\n                    " ], "\n                " ], "\n                </span>\n        </div>\n    " ], '\n\n    <ul id="blng_sents_content_list">\n        ', [ {
                "type": "foreach",
                "to": "sentence",
                "from": {
                    "type": "references",
                    "id": "sentence-pair",
                    "isWraped": true,
                    "leader": "$"
                }
            }, "\n            ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "order",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "foreach",
                    "path": [ {
                        "type": "property",
                        "id": "count"
                    } ],
                    "isWraped": true,
                    "leader": "$"
                } ]
            }, '\n            <li class="cols-layout">\n                <span class="col1 order">', {
                "type": "references",
                "id": "order",
                "leader": "$",
                "prue": true
            }, ".", '</span>\n\n                <div class="col2 align">\n                    ', [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "property",
                        "id": "aligned-words"
                    } ],
                    "leader": "$"
                }
            }, '\n                        <p class="src">', {
                "type": "references",
                "id": "_getHtmlPair",
                "path": [ {
                    "type": "index",
                    "id": {
                        "type": "integer",
                        "value": "0"
                    }
                } ],
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "sentence",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "order",
                    "leader": "$"
                } ],
                "prue": true
            }, "\n                            ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "property",
                        "id": "sentence-speech"
                    } ],
                    "leader": "$"
                }
            }, '\n                                <span class="pronounce">\n                                <a title="点击发音" class="sp dictvoice js-ctlog" data-ctype="例句发音_TTS" role="dict_audio_js"\n                                   data-rel="http://dict.youdao.com/dictvoice?audio=', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "sentence-speech"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '"></a>\n                                </span>\n                                ', [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "lang",
                        "leader": "$"
                    }, {
                        "type": "math",
                        "expression": [ {
                            "type": "references",
                            "id": "lang",
                            "leader": "$"
                        }, {
                            "type": "string",
                            "value": "eng",
                            "isEval": true
                        } ],
                        "operator": "=="
                    } ],
                    "operator": "&&"
                }
            }, '\n                                    <a href="javascript:;" title="口语练习"\n                                       class="js-record spoken-record sentences_record js-ctlog"\n                                       data-ctype="跟读_例句_双语" data-format="audio"\n                                       data-rel="http://dict.youdao.com/dictvoice?audio=', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "sentence-speech"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '"\n                                       data-sentences="', {
                "type": "references",
                "id": "_getSpokenSens",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "property",
                        "id": "sentence"
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, '"', ">跟读</a>\n                                " ], "\n                            " ], '\n                        </p>\n\n                        <p class="tran">', {
                "type": "references",
                "id": "_getHtmlPair",
                "path": [ {
                    "type": "index",
                    "id": {
                        "type": "integer",
                        "value": "1"
                    }
                } ],
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "sentence",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "order",
                    "leader": "$"
                } ],
                "prue": true
            }, "\n                            ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "property",
                        "id": "sentence-translation-speech"
                    } ],
                    "leader": "$"
                }
            }, '\n                                <span class="pronounce">\n                                <a title="点击发音" class="sp dictvoice js-ctlog" data-ctype="例句发音_TTS" role="dict_audio_js"\n                                   data-rel="http://dict.youdao.com/dictvoice?audio=', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "sentence-translation-speech"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '"></a>\n                            </span>\n                                ', [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "lang",
                        "leader": "$"
                    }, {
                        "type": "math",
                        "expression": [ {
                            "type": "references",
                            "id": "lang",
                            "leader": "$"
                        }, {
                            "type": "string",
                            "value": "eng",
                            "isEval": true
                        } ],
                        "operator": "=="
                    } ],
                    "operator": "&&"
                }
            }, '\n                                    <a href="javascript:;" title="口语练习"\n                                       class="js-record spoken-record sentences_record js-ctlog"\n                                       data-ctype="跟读_例句_双语"   data-format="audio"\n                                       data-sentences="', {
                "type": "references",
                "id": "_getSpokenSens",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "index",
                        "id": {
                            "type": "string",
                            "value": "sentence-translation"
                        }
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, '"', '\n                                       data-rel="http://dict.youdao.com/dictvoice?audio=', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "sentence-translation-speech"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '">跟读</a>\n                                ' ], "\n                            " ], "\n                        </p>\n                    ", {
                "type": "else"
            }, "\n                        <p>", {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "sentence"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "\n                            ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "property",
                        "id": "sentence-speech"
                    } ],
                    "leader": "$"
                }
            }, '\n                                <span class="pronounce">\n                                <a title="点击发音" class="sp dictvoice js-ctlog" data-ctype="例句发音_TTS" role="dict_audio_js"\n                                   data-rel="http://dict.youdao.com/dictvoice?audio=', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "sentence-speech"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '"></a>\n                                </span>\n                                ', [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "lang",
                        "leader": "$"
                    }, {
                        "type": "math",
                        "expression": [ {
                            "type": "references",
                            "id": "lang",
                            "leader": "$"
                        }, {
                            "type": "string",
                            "value": "eng",
                            "isEval": true
                        } ],
                        "operator": "=="
                    } ],
                    "operator": "&&"
                }
            }, '\n                                    <a href="javascript:;" title="口语练习"\n                                       class="js-record spoken-record sentences_record js-ctlog"\n                                       data-ctype="跟读_例句_双语"  data-format="audio"\n                                       data-sentences="', {
                "type": "references",
                "id": "_getSpokenSens",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "property",
                        "id": "sentence"
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, '"', ">跟读</a>\n                                " ], "\n                            " ], "\n                            </p>\n                        <p>", {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "sentence-translation"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "\n                            ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "property",
                        "id": "sentence-translation-speech"
                    } ],
                    "leader": "$"
                }
            }, '\n                                <span class="pronounce">\n                                <a title="点击发音" class="sp dictvoice js-ctlog" data-ctype="例句发音_TTS" role="dict_audio_js"\n                                   data-rel="http://dict.youdao.com/dictvoice?audio=', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "sentence-translation-speech"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '"></a>\n                            </span>\n                                ', [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "lang",
                        "leader": "$"
                    }, {
                        "type": "math",
                        "expression": [ {
                            "type": "references",
                            "id": "lang",
                            "leader": "$"
                        }, {
                            "type": "string",
                            "value": "eng",
                            "isEval": true
                        } ],
                        "operator": "=="
                    } ],
                    "operator": "&&"
                }
            }, '\n                                    <a href="javascript:;" title="口语练习"\n                                       class=" js-record spoken-record sentences_record js-ctlog"\n                                       data-ctype="跟读_例句_双语" data-format="audio"\n                                       data-sentences="', {
                "type": "references",
                "id": "_getSpokenSens",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "index",
                        "id": {
                            "type": "string",
                            "value": "sentence-translation"
                        }
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, '"', ">跟读</a>\n                                " ], "\n                            " ], "\n                        </p>\n                    " ], "\n                    ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "property",
                        "id": "source"
                    } ],
                    "leader": "$"
                }
            }, '\n                        <p class="secondary">', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "source"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "</p>\n                    ", {
                "type": "elseif",
                "condition": {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "property",
                        "id": "url"
                    } ],
                    "leader": "$"
                }
            }, '\n                        <p class="secondary"><a class="secondary" title="来源" target="_blank" href="', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "url"
                } ],
                "leader": "$",
                "prue": true
            }, '"', ">", {
                "type": "references",
                "id": "_getUrl",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "property",
                        "id": "url"
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, "<", "/a></p>\n                    " ], "\n                </div>\n            </li>\n        " ], "\n    </ul>\n</div>\n\n\n\n" ]).render(_data);
        },
        "init": function init() {
            $("body").delegate(".align span:not(.pronounce)", "mouseenter", function() {
                var alignEle = $(this).data("aligning").split(",");
                for (var i = 0, len = alignEle.length; i < len; i++) {
                    $(alignEle[i]).addClass("highLight");
                }
            });
            $("body").delegate(".align span:not(.pronounce)", "mouseleave", function() {
                var alignEle = $(this).data("aligning").split(",");
                for (var i = 0, len = alignEle.length; i < len; i++) {
                    $(alignEle[i]).removeClass("highLight");
                }
            });
        }
    };
});define("/output/blng_sents_part/blng_sents_part", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            _data = tpHelper.mixin(_data, {
                "_getHtmlPair": function(pair, index) {
                    return utils.align(pair, index, "blng_part");
                },
                "_getSpokenSens": function(sentences) {
                    return sentences.replace("</b>", "").replace("<b>", "").replace(/\"|\"/g, "&quot;").replace(/\'|\'/g, "&apos;");
                },
                "_getUrl": function(url) {
                    return url.split("/")[2];
                }
            });
            return tpHelper.vm([ '<div class="trans-container blng_sents_part">\n    <ul>\n        ', [ {
                "type": "foreach",
                "to": "sentence",
                "from": {
                    "type": "references",
                    "id": "sentence-pair",
                    "isWraped": true,
                    "leader": "$"
                }
            }, "\n            ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "order",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "foreach",
                    "path": [ {
                        "type": "property",
                        "id": "count"
                    } ],
                    "isWraped": true,
                    "leader": "$"
                } ]
            }, '\n            <li class="cols-layout ">\n                <span class="col1 order"> ', {
                "type": "references",
                "id": "order",
                "leader": "$",
                "prue": true
            }, ".", '</span>\n\n                <div class="col2 align">\n                    ', [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "property",
                        "id": "aligned-words"
                    } ],
                    "leader": "$"
                }
            }, '\n                        <p class="src">', {
                "type": "references",
                "id": "_getHtmlPair",
                "path": [ {
                    "type": "index",
                    "id": {
                        "type": "integer",
                        "value": "0"
                    }
                } ],
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "sentence",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "order",
                    "leader": "$"
                } ],
                "prue": true
            }, "\n                            ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "property",
                        "id": "sentence-speech"
                    } ],
                    "leader": "$"
                }
            }, '\n                                <span class="pronounce">\n                                <a title="点击发音" class="sp dictvoice js-ctlog" data-ctype="例句发音_TTS" role="dict_audio_js"\n                                   data-rel="http://dict.youdao.com/dictvoice?audio=', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "sentence-speech"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '"></a>\n                                </span>\n                                ', [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "lang",
                        "leader": "$"
                    }, {
                        "type": "math",
                        "expression": [ {
                            "type": "references",
                            "id": "lang",
                            "leader": "$"
                        }, {
                            "type": "string",
                            "value": "eng",
                            "isEval": true
                        } ],
                        "operator": "=="
                    } ],
                    "operator": "&&"
                }
            }, '\n                                    <a href="javascript:;" title="口语练习"\n                                       class="js-record spoken-record sentences_record js-ctlog"\n                                       data-ctype="跟读_例句_双语" data-format="audio"\n                                       data-rel="http://dict.youdao.com/dictvoice?audio=', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "sentence-speech"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '"\n                                       data-sentences="', {
                "type": "references",
                "id": "_getSpokenSens",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "property",
                        "id": "sentence"
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, '"', ">跟读</a>\n                                " ], "\n                            " ], '\n                        </p>\n\n                        <p class="tran">', {
                "type": "references",
                "id": "_getHtmlPair",
                "path": [ {
                    "type": "index",
                    "id": {
                        "type": "integer",
                        "value": "1"
                    }
                } ],
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "sentence",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "order",
                    "leader": "$"
                } ],
                "prue": true
            }, "\n                            ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "property",
                        "id": "sentence-translation-speech"
                    } ],
                    "leader": "$"
                }
            }, '\n                                <span class="pronounce">\n                                <a title="点击发音" class="sp dictvoice js-ctlog" data-ctype="例句发音_TTS" role="dict_audio_js"\n                                   data-rel="http://dict.youdao.com/dictvoice?audio=', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "sentence-translation-speech"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '"></a>\n                            </span>\n                                ', [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "lang",
                        "leader": "$"
                    }, {
                        "type": "math",
                        "expression": [ {
                            "type": "references",
                            "id": "lang",
                            "leader": "$"
                        }, {
                            "type": "string",
                            "value": "eng",
                            "isEval": true
                        } ],
                        "operator": "=="
                    } ],
                    "operator": "&&"
                }
            }, '\n                                <a href="javascript:;" title="口语练习"\n                                   class="js-record spoken-record sentences_record js-ctlog"\n                                   data-ctype="跟读_例句_双语"  data-format="audio"\n                                   data-sentences="', {
                "type": "references",
                "id": "_getSpokenSens",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "index",
                        "id": {
                            "type": "string",
                            "value": "sentence-translation"
                        }
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, '"', '\n                                   data-rel="http://dict.youdao.com/dictvoice?audio=', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "sentence-translation-speech"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '">跟读</a>\n                                    ' ], "\n                            " ], "\n                        </p>\n                    ", {
                "type": "else"
            }, "\n                        <p>", {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "sentence"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "\n                            ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "property",
                        "id": "sentence-speech"
                    } ],
                    "leader": "$"
                }
            }, '\n                                <span class="pronounce">\n                                <a title="点击发音" class="sp dictvoice js-ctlog" data-ctype="例句发音_TTS" role="dict_audio_js"\n                                   data-rel="http://dict.youdao.com/dictvoice?audio=', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "sentence-speech"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '"></a>\n                                </span>\n                                ', [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "lang",
                        "leader": "$"
                    }, {
                        "type": "math",
                        "expression": [ {
                            "type": "references",
                            "id": "lang",
                            "leader": "$"
                        }, {
                            "type": "string",
                            "value": "eng",
                            "isEval": true
                        } ],
                        "operator": "=="
                    } ],
                    "operator": "&&"
                }
            }, '\n                                    <a href="javascript:;" title="口语练习"\n                                       class="js-record spoken-record sentences_record js-ctlog"\n                                       data-ctype="跟读_例句_双语"  data-format="audio"\n                                       data-sentences="', {
                "type": "references",
                "id": "_getSpokenSens",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "property",
                        "id": "sentence"
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, '"', ">跟读</a>\n                                " ], "\n                            " ], "\n                        </p>\n                        <p>", {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "sentence-translation"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "\n                            ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "property",
                        "id": "sentence-translation-speech"
                    } ],
                    "leader": "$"
                }
            }, '\n                                <span class="pronounce">\n                                <a title="点击发音" class="sp dictvoice js-ctlog" data-ctype="例句发音_TTS" role="dict_audio_js"\n                                   data-rel="http://dict.youdao.com/dictvoice?audio=', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "sentence-translation-speech"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '"></a>\n                            </span>\n                                ', [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "lang",
                        "leader": "$"
                    }, {
                        "type": "math",
                        "expression": [ {
                            "type": "references",
                            "id": "lang",
                            "leader": "$"
                        }, {
                            "type": "string",
                            "value": "eng",
                            "isEval": true
                        } ],
                        "operator": "=="
                    } ],
                    "operator": "&&"
                }
            }, '\n                                    <a href="javascript:;" title="口语练习"\n                                       class="js-record spoken-record sentences_record js-ctlog"\n                                       data-ctype="跟读_例句_双语"  data-format="audio"\n                                       data-sentences="', {
                "type": "references",
                "id": "_getSpokenSens",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "index",
                        "id": {
                            "type": "string",
                            "value": "sentence-translation"
                        }
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, '"', ">跟读</a>\n                                " ], "\n                            " ], "\n                        </p>\n                    " ], "\n                    ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "property",
                        "id": "source"
                    } ],
                    "leader": "$"
                }
            }, '\n                        <p class="secondary">', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "source"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "</p>\n                    ", {
                "type": "elseif",
                "condition": {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "property",
                        "id": "url"
                    } ],
                    "leader": "$"
                }
            }, '\n                        <p class="secondary"><a class="secondary" title="来源" target="_blank" href="', {
                "type": "references",
                "id": "sentence",
                "path": [ {
                    "type": "property",
                    "id": "url"
                } ],
                "leader": "$",
                "prue": true
            }, '"', ">", {
                "type": "references",
                "id": "_getUrl",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "sentence",
                    "path": [ {
                        "type": "property",
                        "id": "url"
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, "<", "/a></p>\n                    " ], "\n                </div>\n            </li>\n        " ], "\n    </ul>\n    ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "more",
                    "leader": "$"
                }
            }, '\n        <a href="" class="more clickable js-ctlog" data-ctype="点击更多双语例句" data-example-type="blng">更多双语例句</a>\n    ' ], "\n</div>" ]).render(_data);
        },
        "init": function init() {
            $("body").delegate(".align span:not(.pronounce)", "mouseenter", function() {
                var alignEle = $(this).data("aligning").split(",");
                for (var i = 0, len = alignEle.length; i < len; i++) {
                    $(alignEle[i]).addClass("highLight");
                }
            });
            $("body").delegate(".align span:not(.pronounce)", "mouseleave", function() {
                var alignEle = $(this).data("aligning").split(",");
                for (var i = 0, len = alignEle.length; i < len; i++) {
                    $(alignEle[i]).removeClass("highLight");
                }
            });
        }
    };
});define("/output/ce/ce", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            _data = tpHelper.mixin(_data, {
                "isObject": function(obj) {
                    return _.isObject(obj);
                },
                "getOnlineStatus": function() {
                    return global.status.online;
                }
            });
            return tpHelper.vm([ '<div class="trans-container ce">\n  ', [ {
                "type": "foreach",
                "to": "_word",
                "from": {
                    "type": "references",
                    "id": "word",
                    "leader": "$"
                }
            }, '\n        <h2>\n            <span class="keyword">\n                ', {
                "type": "references",
                "id": "_word",
                "path": [ {
                    "type": "property",
                    "id": "return-phrase"
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '\n            </span>\n            <span class="pronounce">\n                ', [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "_word",
                    "path": [ {
                        "type": "property",
                        "id": "phone"
                    } ],
                    "leader": "$"
                }
            }, '\n                    <span class="phonetic">[', {
                "type": "references",
                "id": "_word",
                "path": [ {
                    "type": "property",
                    "id": "phone"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "]</span>\n                " ], "\n            </span>\n            ", {
                "type": "comment",
                "value": '## <span class="phonetic">[$!{_word.phone}]</span>'
            }, '', [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "getOnlineStatus",
                    "leader": "$",
                    "args": false
                }
            }, '\n                      ' ], "\n        </h2>\n        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "allTrs",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "_word",
                    "path": [ {
                        "type": "property",
                        "id": "trs"
                    } ],
                    "leader": "$"
                } ]
            }, "\n        <ul>\n            ", [ {
                "type": "foreach",
                "to": "perTr",
                "from": {
                    "type": "references",
                    "id": "allTrs",
                    "leader": "$"
                }
            }, "\n                ", [ {
                "type": "foreach",
                "to": "_tr",
                "from": {
                    "type": "references",
                    "id": "perTr",
                    "leader": "$"
                }
            }, "\n                    <li>\n                    ", [ {
                "type": "foreach",
                "to": "_perTr",
                "from": {
                    "type": "references",
                    "id": "_tr",
                    "leader": "$"
                }
            }, "\n                        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "perLi",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "_perTr",
                    "path": [ {
                        "type": "property",
                        "id": "l"
                    }, {
                        "type": "property",
                        "id": "i"
                    } ],
                    "leader": "$"
                } ]
            }, "\n                        ", [ {
                "type": "foreach",
                "to": "perWord",
                "from": {
                    "type": "references",
                    "id": "perLi",
                    "leader": "$"
                }
            }, "\n                            ", [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "isObject",
                        "leader": "$",
                        "args": [ {
                            "type": "references",
                            "id": "perWord",
                            "leader": "$"
                        } ]
                    }, {
                        "type": "math",
                        "expression": [ {
                            "type": "math",
                            "expression": [ {
                                "type": "references",
                                "id": "perWord",
                                "path": [ {
                                    "type": "index",
                                    "id": {
                                        "type": "string",
                                        "value": "@action"
                                    }
                                } ],
                                "leader": "$"
                            } ],
                            "operator": "not"
                        } ],
                        "operator": "not"
                    } ],
                    "operator": "&&"
                }
            }, '\n                                <a class="clickable js-inline-clickable" href="javascript:void(0);">', {
                "type": "references",
                "id": "perWord",
                "path": [ {
                    "type": "index",
                    "id": {
                        "type": "string",
                        "value": "#text"
                    }
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/a>\n                            ", {
                "type": "else"
            }, "\n                                ", {
                "type": "references",
                "id": "perWord",
                "leader": "$",
                "prue": true
            }, "\n                            " ], "\n                        " ], "\n                    " ], "\n                    </li>\n                " ], "\n            " ], "\n        </ul>\n    " ], "\n</div>" ]).render(_data);
        },
        "init": function init() {}
    };
});define("/output/ce_new/ce_new", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            _data = tpHelper.mixin(_data, {
                "_foreachPos": Object.create(utils._foreach),
                "_foreachEtr": Object.create(utils._foreach),
                "_foreachExam": Object.create(utils._foreach)
            });
            return tpHelper.vm([ [ {
                "type": "macro",
                "id": "list"
            }, "\n    ", [ {
                "type": "foreach",
                "to": "perWord",
                "from": {
                    "type": "references",
                    "id": "word",
                    "leader": "$"
                }
            }, "\n    <h4>\n        ", {
                "type": "references",
                "id": "perWord",
                "path": [ {
                    "type": "index",
                    "id": {
                        "type": "string",
                        "value": "return-phrase"
                    }
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "\n        ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perWord",
                    "path": [ {
                        "type": "property",
                        "id": "phone"
                    } ],
                    "leader": "$"
                }
            }, "\n            <small>[", {
                "type": "references",
                "id": "perWord",
                "path": [ {
                    "type": "property",
                    "id": "phone"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "]</small>\n        " ], "\n    </h4>\n        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "allTrs",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "perWord",
                    "path": [ {
                        "type": "property",
                        "id": "trs"
                    } ],
                    "leader": "$"
                } ]
            }, "\n        ", {
                "type": "references",
                "id": "_foreachPos",
                "path": [ {
                    "type": "method",
                    "id": "start",
                    "args": [ {
                        "type": "integer",
                        "value": "1"
                    } ]
                } ],
                "leader": "$",
                "prue": true
            }, "\n    ", "<ul>\n        ", [ {
                "type": "foreach",
                "to": "perTr",
                "from": {
                    "type": "references",
                    "id": "allTrs",
                    "leader": "$"
                }
            }, "\n            ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "orderPos",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "_foreachPos",
                    "path": [ {
                        "type": "property",
                        "id": "count"
                    } ],
                    "isWraped": true,
                    "leader": "$"
                } ]
            }, "\n            <li>\n                <span>", {
                "type": "references",
                "id": "perTr",
                "path": [ {
                    "type": "property",
                    "id": "pos"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "</span>\n                ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "allEtrs",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "perTr",
                    "path": [ {
                        "type": "property",
                        "id": "tr"
                    } ],
                    "leader": "$"
                } ]
            }, "\n                ", {
                "type": "references",
                "id": "_foreachEtr",
                "path": [ {
                    "type": "method",
                    "id": "start",
                    "args": [ {
                        "type": "integer",
                        "value": "1"
                    } ]
                } ],
                "leader": "$",
                "prue": true
            }, "\n                ", "<ul>\n                    ", [ {
                "type": "foreach",
                "to": "perEtr",
                "from": {
                    "type": "references",
                    "id": "allEtrs",
                    "leader": "$"
                }
            }, "\n                        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "orderEtr",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "_foreachEtr",
                    "path": [ {
                        "type": "property",
                        "id": "count"
                    } ],
                    "isWraped": true,
                    "leader": "$"
                } ]
            }, '\n                        <li class="cols-layout">\n                            <span class="col1 order">', {
                "type": "references",
                "id": "orderEtr",
                "leader": "$",
                "prue": true
            }, ".", '</span>\n\n                            <div class="col2">\n                                <span>', {
                "type": "references",
                "id": "perEtr",
                "path": [ {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "</span>\n                                ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perEtr",
                    "path": [ {
                        "type": "property",
                        "id": "exam"
                    } ],
                    "leader": "$"
                }
            }, "\n                                    ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "allExams",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "perEtr",
                    "path": [ {
                        "type": "property",
                        "id": "exam"
                    } ],
                    "leader": "$"
                } ]
            }, "\n                                    ", {
                "type": "references",
                "id": "_foreachExam",
                "path": [ {
                    "type": "method",
                    "id": "start",
                    "args": [ {
                        "type": "integer",
                        "value": "1"
                    } ]
                } ],
                "leader": "$",
                "prue": true
            }, "\n                                    ", [ {
                "type": "foreach",
                "to": "perExam",
                "from": {
                    "type": "references",
                    "id": "allExams",
                    "leader": "$"
                }
            }, "\n                                        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "orderExam",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "_foreachExam",
                    "path": [ {
                        "type": "property",
                        "id": "count"
                    } ],
                    "isWraped": true,
                    "leader": "$"
                } ]
            }, "\n                                        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "perExamItem",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "perExam",
                    "path": [ {
                        "type": "property",
                        "id": "i"
                    } ],
                    "leader": "$"
                } ]
            }, '\n                                        <p class="secondary">\n                                                            <span>\n                                                                ', [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perExamItem",
                    "path": [ {
                        "type": "property",
                        "id": "f"
                    } ],
                    "leader": "$"
                }
            }, "\n                                                                    ", {
                "type": "references",
                "id": "perExamItem",
                "path": [ {
                    "type": "property",
                    "id": "f"
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "leader": "$",
                "prue": true
            }, "\n                                                                " ], "\n                                                            </span>\n                                                            <span>\n                                                                ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perExamItem",
                    "path": [ {
                        "type": "property",
                        "id": "n"
                    } ],
                    "leader": "$"
                }
            }, "\n                                                               ", {
                "type": "references",
                "id": "perExamItem",
                "path": [ {
                    "type": "property",
                    "id": "n"
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "leader": "$",
                "prue": true
            }, "\n                                                            " ], "\n                                                            </span>\n                                        </p>\n                                    " ], "\n                                " ], "\n                            </div>\n                        </li>\n                    " ], "\n                </ul>\n            </li>\n        " ], "\n    </ul>\n    " ], "\n" ], '\n<div class="trans-container ce_new">\n    ', {
                "type": "macro_call",
                "id": "list"
            }, "\n    ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "source",
                    "leader": "$"
                }
            }, '\n        <p class="secondary source">以上来源于：', {
                "type": "references",
                "id": "source",
                "path": [ {
                    "type": "property",
                    "id": "name"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/p>\n    " ], "\n</div>" ]).render(_data);
        },
        "init": function init() {}
    };
});define("/output/cf/cf", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            _data = tpHelper.mixin(_data, {
                "joinArray": function(type) {
                    return type.join(" ");
                },
                "_foreach": Object.create(utils._foreach),
                "getOnlineStatus": function() {
                    return global.status.online;
                }
            });
            return tpHelper.vm([ '<div class="trans-container cf">\n  ', [ {
                "type": "foreach",
                "to": "_word",
                "from": {
                    "type": "references",
                    "id": "word",
                    "leader": "$"
                }
            }, '\n        <h2>\n            <span class="keyword">\n                ', {
                "type": "references",
                "id": "_word",
                "path": [ {
                    "type": "property",
                    "id": "return-phrase"
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "\n            </span>\n            ", {
                "type": "comment",
                "value": '## <span class="phonetic">[$!{_word.phone}]</span>'
            }, '', [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "getOnlineStatus",
                    "leader": "$",
                    "args": false
                }
            }, '\n                       ' ], "\n        </h2>\n        <h4>", {
                "type": "references",
                "id": "_word",
                "path": [ {
                    "type": "property",
                    "id": "return-phrase"
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "</h4>\n        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "allTrs",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "_word",
                    "path": [ {
                        "type": "property",
                        "id": "trs"
                    } ],
                    "leader": "$"
                } ]
            }, "\n        <ul>\n            ", [ {
                "type": "foreach",
                "to": "perTr",
                "from": {
                    "type": "references",
                    "id": "allTrs",
                    "leader": "$"
                }
            }, "\n                ", [ {
                "type": "foreach",
                "to": "_tr",
                "from": {
                    "type": "references",
                    "id": "perTr",
                    "leader": "$"
                }
            }, "\n                    ", [ {
                "type": "foreach",
                "to": "_perTr",
                "from": {
                    "type": "references",
                    "id": "_tr",
                    "leader": "$"
                }
            }, "\n                    <li>\n                         ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "order",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "_foreach",
                    "path": [ {
                        "type": "property",
                        "id": "count"
                    } ],
                    "isWraped": true,
                    "leader": "$!"
                } ]
            }, '\n                        <span class="col1 order">', {
                "type": "references",
                "id": "order",
                "leader": "$",
                "prue": true
            }, ".", "</span>\n                        <span>", {
                "type": "references",
                "id": "_perTr",
                "path": [ {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                }, {
                    "type": "index",
                    "id": {
                        "type": "integer",
                        "value": "0"
                    }
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "</span>\n                    </li>\n                    " ], "\n                " ], "\n            " ], "\n        </ul>\n    " ], "\n</div>" ]).render(_data);
        },
        "init": function init() {}
    };
});define("/output/cj/cj", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            _data = tpHelper.mixin(_data, {
                "_foreach": Object.create(utils._foreach),
                "_isObjectPro": function(obj) {
                    return obj === Object(obj);
                },
                "_getExam": function(exams) {
                    var ret = "";
                    for (var i = 0; i < exams.length; i++) {
                        if (this._isObjectPro(exams[i]) && (exams[i]["#text"] || exams[i]["@action"])) {
                            ret += "<strong>" + exams[i]["#text"].toString() + "</strong>";
                        } else {
                            if (exams[i] === null) {
                                ret += "";
                            } else {
                                ret += exams[i];
                            }
                        }
                    }
                    return ret;
                },
                "getOnlineStatus": function() {
                    return global.status.online;
                }
            });
            return tpHelper.vm([ '<div class="trans-container  cj">\n    <h2>\n        <span class="keyword">\n            ', {
                "type": "references",
                "id": "word",
                "path": [ {
                    "type": "index",
                    "id": {
                        "type": "integer",
                        "value": "0"
                    }
                }, {
                    "type": "property",
                    "id": "return-phrase"
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '', [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "getOnlineStatus",
                    "leader": "$",
                    "args": false
                }
            }, '\n                  ' ], "\n    </h2>\n    ", [ {
                "type": "foreach",
                "to": "perWord",
                "from": {
                    "type": "references",
                    "id": "word",
                    "leader": "$"
                }
            }, "\n        <h4>", {
                "type": "references",
                "id": "perWord",
                "path": [ {
                    "type": "index",
                    "id": {
                        "type": "string",
                        "value": "return-phrase"
                    }
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "leader": "$",
                "prue": true
            }, "\n            ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perWord",
                    "path": [ {
                        "type": "property",
                        "id": "phone"
                    } ],
                    "leader": "$"
                }
            }, "\n                <small>[", {
                "type": "references",
                "id": "perWord",
                "path": [ {
                    "type": "property",
                    "id": "phone"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "]</small>\n            " ], "\n        </h4>\n        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "allTrs",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "perWord",
                    "path": [ {
                        "type": "property",
                        "id": "trs"
                    } ],
                    "leader": "$"
                } ]
            }, "\n        ", {
                "type": "references",
                "id": "_foreach",
                "path": [ {
                    "type": "method",
                    "id": "start",
                    "args": [ {
                        "type": "integer",
                        "value": "1"
                    } ]
                } ],
                "leader": "$",
                "prue": true
            }, "\n        ", "<ul>\n            ", [ {
                "type": "foreach",
                "to": "perTr",
                "from": {
                    "type": "references",
                    "id": "allTrs",
                    "leader": "$"
                }
            }, '\n                <li class="cols-layout">\n                    ', [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "allTrs",
                        "path": [ {
                            "type": "property",
                            "id": "length"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "integer",
                        "value": "1"
                    } ],
                    "operator": ">"
                }
            }, "\n                        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "order",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "_foreach",
                    "path": [ {
                        "type": "property",
                        "id": "count"
                    } ],
                    "isWraped": true,
                    "leader": "$!"
                } ]
            }, '\n                        <span class="col1 order">', {
                "type": "references",
                "id": "order",
                "leader": "$",
                "prue": true
            }, ".", "</span>\n                    " ], "\n                    ", [ {
                "type": "foreach",
                "to": "_trl",
                "from": {
                    "type": "references",
                    "id": "perTr",
                    "path": [ {
                        "type": "property",
                        "id": "tr"
                    } ],
                    "leader": "$"
                }
            }, '\n                    <div class="col2">\n                        <p>', {
                "type": "references",
                "id": "_trl",
                "path": [ {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/p>\n                        ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "_trl",
                    "path": [ {
                        "type": "property",
                        "id": "exam"
                    } ],
                    "leader": "$"
                }
            }, "\n                            <ul>\n                                ", [ {
                "type": "foreach",
                "to": "perExam",
                "from": {
                    "type": "references",
                    "id": "_trl",
                    "path": [ {
                        "type": "property",
                        "id": "exam"
                    }, {
                        "type": "property",
                        "id": "i"
                    } ],
                    "leader": "$"
                }
            }, '\n                                    <li class="secondary cols-layout">\n                                        <span class="col1 colExam">例证：</span>\n\n                                        <div class="col2">\n                                            <p>\n                                            ', [ {
                "type": "foreach",
                "to": "exm",
                "from": {
                    "type": "references",
                    "id": "perExam",
                    "path": [ {
                        "type": "property",
                        "id": "f"
                    }, {
                        "type": "property",
                        "id": "l"
                    }, {
                        "type": "property",
                        "id": "i"
                    } ],
                    "leader": "$"
                }
            }, "\n\n                                                ", [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "exm",
                        "path": [ {
                            "type": "index",
                            "id": {
                                "type": "string",
                                "value": "#text",
                                "isEval": true
                            }
                        } ],
                        "leader": "$"
                    }, {
                        "type": "bool",
                        "value": "null"
                    } ],
                    "operator": "!="
                }
            }, "\n                                                    <strong>", {
                "type": "references",
                "id": "exm",
                "path": [ {
                    "type": "index",
                    "id": {
                        "type": "string",
                        "value": "#text",
                        "isEval": true
                    }
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/strong>\n                                                ", {
                "type": "else"
            }, " \n                                                    ", {
                "type": "references",
                "id": "exm",
                "leader": "$",
                "prue": true
            }, "\n                                                " ], "\n                                            " ], "\n                                            </p>\n                                            <p>", {
                "type": "references",
                "id": "perExam",
                "path": [ {
                    "type": "property",
                    "id": "n"
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/p>\n                                        </div>\n                                    </li>\n                                " ], "\n                            </ul>\n                        " ], "\n                    </div>\n                    " ], "\n                </li>\n            " ], "\n        </ul>\n    " ], "\n</div>" ]).render(_data);
        },
        "init": function init() {}
    };
});define("/output/ck/ck", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            _data = tpHelper.mixin(_data, {
                "_foreach": Object.create(utils._foreach),
                "_foreachTr": Object.create(utils._foreach),
                "joinArray": function(type) {
                    return type.join(" ");
                },
                "_isObjectPro": function(obj) {
                    return obj === Object(obj);
                },
                "_getExam": function(exams) {
                    var ret = "";
                    for (var i = 0; i < exams.length; i++) {
                        if (this._isObjectPro(exams[i]) && (exams[i]["#text"] || exams[i]["@action"])) {
                            ret += "<strong>" + exams[i]["#text"].toString() + "</strong>";
                        } else {
                            if (exams[i] === null) {
                                ret += "";
                            } else {
                                ret += exams[i];
                            }
                        }
                    }
                    return ret;
                },
                "getOnlineStatus": function() {
                    return global.status.online;
                }
            });
            return tpHelper.vm([ '<div class="trans-container  ck">  \n    <h2>\n        <span class="keyword">\n            ', {
                "type": "references",
                "id": "word",
                "path": [ {
                    "type": "index",
                    "id": {
                        "type": "integer",
                        "value": "0"
                    }
                }, {
                    "type": "property",
                    "id": "return-phrase"
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '', [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "getOnlineStatus",
                    "leader": "$",
                    "args": false
                }
            }, '\n                 ' ], "\n    </h2>\n     ", [ {
                "type": "foreach",
                "to": "perWord",
                "from": {
                    "type": "references",
                    "id": "word",
                    "leader": "$"
                }
            }, "\n        <h4>", {
                "type": "references",
                "id": "perWord",
                "path": [ {
                    "type": "index",
                    "id": {
                        "type": "string",
                        "value": "return-phrase"
                    }
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "leader": "$",
                "prue": true
            }, "\n            ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perWord",
                    "path": [ {
                        "type": "property",
                        "id": "phone"
                    } ],
                    "leader": "$"
                }
            }, "\n                <small>[", {
                "type": "references",
                "id": "perWord",
                "path": [ {
                    "type": "property",
                    "id": "phone"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "]</small>\n            " ], "\n        </h4>\n        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "allTrs",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "perWord",
                    "path": [ {
                        "type": "property",
                        "id": "trs"
                    } ],
                    "leader": "$"
                } ]
            }, "\n        ", [ {
                "type": "foreach",
                "to": "perTr",
                "from": {
                    "type": "references",
                    "id": "allTrs",
                    "leader": "$"
                }
            }, "\n            ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "etrs",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "perTr",
                    "path": [ {
                        "type": "property",
                        "id": "tr"
                    } ],
                    "leader": "$"
                } ]
            }, "\n            ", {
                "type": "references",
                "id": "_foreach",
                "path": [ {
                    "type": "method",
                    "id": "start",
                    "args": [ {
                        "type": "integer",
                        "value": "1"
                    } ]
                } ],
                "leader": "$",
                "prue": true
            }, "\n            ", "<ul>\n                ", [ {
                "type": "foreach",
                "to": "perEtr",
                "from": {
                    "type": "references",
                    "id": "etrs",
                    "leader": "$"
                }
            }, '\n                    <li class="cols-layout">\n                        ', [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "etrs",
                        "path": [ {
                            "type": "property",
                            "id": "length"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "integer",
                        "value": "1"
                    } ],
                    "operator": ">"
                }
            }, "\n                            ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "order",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "_foreach",
                    "path": [ {
                        "type": "property",
                        "id": "count"
                    } ],
                    "isWraped": true,
                    "leader": "$!"
                } ]
            }, '\n                            <span class="col1 order">', {
                "type": "references",
                "id": "order",
                "leader": "$",
                "prue": true
            }, ".", "</span>\n                        " ], '\n                        <div class="col2">\n                            <p>', {
                "type": "references",
                "id": "perEtr",
                "path": [ {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/p>\n                            ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perEtr",
                    "path": [ {
                        "type": "property",
                        "id": "exam"
                    } ],
                    "leader": "$"
                }
            }, "\n                                <ul>\n                                    ", [ {
                "type": "foreach",
                "to": "perExam",
                "from": {
                    "type": "references",
                    "id": "perEtr",
                    "path": [ {
                        "type": "property",
                        "id": "exam"
                    }, {
                        "type": "property",
                        "id": "i"
                    } ],
                    "leader": "$"
                }
            }, '\n                                        <li class="secondary">\n                                            <span>', {
                "type": "references",
                "id": "perExam",
                "path": [ {
                    "type": "property",
                    "id": "f"
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/span> / <span>", {
                "type": "references",
                "id": "perExam",
                "path": [ {
                    "type": "property",
                    "id": "n"
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/span>   \n                                        </li>\n                                    " ], "\n                                </ul>\n                            " ], "\n                        </div>\n                    </li>\n                " ], "\n            </ul>\n        " ], "\n    " ], "\n</div>" ]).render(_data);
        },
        "init": function init() {}
    };
});define("/output/collins/collins", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            _data = tpHelper.mixin(_data, {
                "_foreach": Object.create(utils._foreach),
                "_foreachSee": Object.create(utils._foreach),
                "_foreachSeeAlso": Object.create(utils._foreach),
                "_foreachHeadSee": Object.create(utils._foreach),
                "_getWordForms": function(wordForms, dotWord) {
                    var wordForm = wordForms.map(function(element) {
                        return element[dotWord];
                    });
                    return {
                        "wordFormString": wordForm.join(","),
                        "wordFormArray": wordForm
                    };
                }
            });
            return tpHelper.vm([ {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "collinsEntries",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "collins_entries",
                    "leader": "$"
                } ]
            }, "\n", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "super_headwords",
                    "leader": "$"
                }
            }, "\n    ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "superHead",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "super_headwords",
                    "leader": "$"
                } ]
            }, "\n" ], "\n\n", [ {
                "type": "macro",
                "id": "withoutHeadword",
                "args": [ {
                    "type": "references",
                    "id": "allEnties",
                    "leader": "$"
                } ]
            }, "\n<ul>\n    ", {
                "type": "references",
                "id": "_foreach",
                "path": [ {
                    "type": "method",
                    "id": "start",
                    "args": [ {
                        "type": "integer",
                        "value": "1"
                    } ]
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "\n    ", [ {
                "type": "foreach",
                "to": "perEntry",
                "from": {
                    "type": "references",
                    "id": "allEnties",
                    "leader": "$"
                }
            }, "\n        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "allTransEntries",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "perEntry",
                    "path": [ {
                        "type": "property",
                        "id": "tran_entry"
                    } ],
                    "leader": "$"
                } ]
            }, "\n        ", [ {
                "type": "foreach",
                "to": "perTransEntry",
                "from": {
                    "type": "references",
                    "id": "allTransEntries",
                    "leader": "$"
                }
            }, "\n            ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "order",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "_foreach",
                    "path": [ {
                        "type": "property",
                        "id": "count"
                    } ],
                    "isWraped": true,
                    "leader": "$!"
                } ]
            }, '\n            <li>\n                <p class="paraphrase cols-layout">\n                    <span class="col1 order">', {
                "type": "references",
                "id": "order",
                "leader": "$",
                "prue": true
            }, ".", '</span>\n                    <span class="paraphrase-term col2">\n                         ', [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perTransEntry",
                    "path": [ {
                        "type": "property",
                        "id": "pos_entry"
                    } ],
                    "leader": "$"
                }
            }, '\n                        <span title="', {
                "type": "references",
                "id": "perTransEntry",
                "path": [ {
                    "type": "property",
                    "id": "pos_entry"
                }, {
                    "type": "property",
                    "id": "pos_tips"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '">', {
                "type": "references",
                "id": "perTransEntry",
                "path": [ {
                    "type": "property",
                    "id": "pos_entry"
                }, {
                    "type": "property",
                    "id": "pos"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "</span>\n                        " ], "\n                        ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perTransEntry",
                    "path": [ {
                        "type": "property",
                        "id": "tran"
                    } ],
                    "leader": "$"
                }
            }, "\n                            ", {
                "type": "references",
                "id": "perTransEntry",
                "path": [ {
                    "type": "property",
                    "id": "tran"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, {
                "type": "references",
                "id": "perTransEntry",
                "path": [ {
                    "type": "property",
                    "id": "box_extra"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "\n                        " ], "\n                        ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perTransEntry",
                    "path": [ {
                        "type": "property",
                        "id": "headword"
                    } ],
                    "leader": "$"
                }
            }, "\n                            ", {
                "type": "references",
                "id": "perTransEntry",
                "path": [ {
                    "type": "property",
                    "id": "headword"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "\n                        " ], "\n                        ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perTransEntry",
                    "path": [ {
                        "type": "property",
                        "id": "sees"
                    } ],
                    "leader": "$"
                }
            }, "\n                            →see&nbsp;&nbsp;\n                            ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "seeWords",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "_getWordForms",
                    "path": [ {
                        "type": "property",
                        "id": "wordFormArray"
                    } ],
                    "leader": "$",
                    "args": [ {
                        "type": "references",
                        "id": "perTransEntry",
                        "path": [ {
                            "type": "property",
                            "id": "sees"
                        }, {
                            "type": "property",
                            "id": "see"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "string",
                        "value": "seeword",
                        "isEval": true
                    } ]
                } ]
            }, "\n                            ", {
                "type": "references",
                "id": "_foreachSee",
                "path": [ {
                    "type": "method",
                    "id": "start",
                    "args": [ {
                        "type": "integer",
                        "value": "1"
                    } ]
                } ],
                "leader": "$",
                "prue": true
            }, "\n                            ", [ {
                "type": "foreach",
                "to": "perSeeWord",
                "from": {
                    "type": "references",
                    "id": "seeWords",
                    "leader": "$"
                }
            }, '\n                                <span class="grey">\n                                        <a class="clickable js-inline-clickable">', {
                "type": "references",
                "id": "perSeeWord",
                "leader": "$",
                "prue": true
            }, "<", "/a>\n                                    ", [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "_foreachSee",
                        "path": [ {
                            "type": "property",
                            "id": "count"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "references",
                        "id": "seeWords",
                        "path": [ {
                            "type": "property",
                            "id": "length"
                        } ],
                        "leader": "$"
                    } ],
                    "operator": "!="
                }
            }, "\n                                        &nbsp;,&nbsp;\n                                    " ], "\n                                </span>\n                            " ], "\n                        " ], "\n                        ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perTransEntry",
                    "path": [ {
                        "type": "property",
                        "id": "seeAlsos"
                    } ],
                    "leader": "$"
                }
            }, "\n                            →", {
                "type": "references",
                "id": "perTransEntry",
                "path": [ {
                    "type": "property",
                    "id": "seeAlsos"
                }, {
                    "type": "property",
                    "id": "seealso"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "&nbsp;&nbsp;\n                            ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "seeAlsoWords",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "_getWordForms",
                    "path": [ {
                        "type": "property",
                        "id": "wordFormArray"
                    } ],
                    "leader": "$",
                    "args": [ {
                        "type": "references",
                        "id": "perTransEntry",
                        "path": [ {
                            "type": "property",
                            "id": "seeAlsos"
                        }, {
                            "type": "property",
                            "id": "seeAlso"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "string",
                        "value": "seeword",
                        "isEval": true
                    } ]
                } ]
            }, "\n                            ", {
                "type": "references",
                "id": "_foreachSeeAlso",
                "path": [ {
                    "type": "method",
                    "id": "start",
                    "args": [ {
                        "type": "integer",
                        "value": "1"
                    } ]
                } ],
                "leader": "$",
                "prue": true
            }, "\n                            ", [ {
                "type": "foreach",
                "to": "perSeeAlsoWord",
                "from": {
                    "type": "references",
                    "id": "seeAlsoWords",
                    "leader": "$"
                }
            }, '\n                                <span class="grey">\n                                    <a class="clickable js-inline-clickable" >', {
                "type": "references",
                "id": "perSeeAlsoWord",
                "leader": "$",
                "prue": true
            }, "<", "/a>\n                                    ", [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "_foreachSeeAlso",
                        "path": [ {
                            "type": "property",
                            "id": "count"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "references",
                        "id": "seeAlsoWords",
                        "path": [ {
                            "type": "property",
                            "id": "length"
                        } ],
                        "leader": "$"
                    } ],
                    "operator": "!="
                }
            }, "\n                                        &nbsp;,&nbsp;\n                                    " ], "\n                                </span>\n                            " ], "\n                        " ], "\n                    </span>\n                </p>\n                     ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perTransEntry",
                    "path": [ {
                        "type": "property",
                        "id": "exam_sents"
                    } ],
                    "leader": "$"
                }
            }, '\n                    <div class="cols-layout ex-wrap">\n                        <span class="col1 order">例：</span>\n                        ', {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "allExamSents",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "perTransEntry",
                    "path": [ {
                        "type": "property",
                        "id": "exam_sents"
                    }, {
                        "type": "property",
                        "id": "sent"
                    } ],
                    "leader": "$"
                } ]
            }, '\n                            <div class="col2">\n                            ', [ {
                "type": "foreach",
                "to": "perExamSent",
                "from": {
                    "type": "references",
                    "id": "allExamSents",
                    "leader": "$"
                }
            }, "\n                                <p>", {
                "type": "references",
                "id": "perExamSent",
                "path": [ {
                    "type": "property",
                    "id": "eng_sent"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/p>\n                                <p>", {
                "type": "references",
                "id": "perExamSent",
                "path": [ {
                    "type": "property",
                    "id": "chn_sent"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/p>\n                            " ], "\n                            </div>\n                    </div>\n                     " ], "\n            </li>\n        " ], "\n    " ], "\n</ul>\n\n" ], "\n\n", [ {
                "type": "macro",
                "id": "getTitle",
                "args": [ {
                    "type": "references",
                    "id": "perCollinsEntry",
                    "leader": "$"
                } ]
            }, "\n    ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "basicEntries",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "perCollinsEntry",
                    "path": [ {
                        "type": "property",
                        "id": "basic_entries"
                    }, {
                        "type": "property",
                        "id": "basic_entry"
                    } ],
                    "leader": "$"
                } ]
            }, '\n<h4>\n    <span class="key">', {
                "type": "references",
                "id": "perCollinsEntry",
                "path": [ {
                    "type": "property",
                    "id": "headword"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "</span>\n    ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perCollinsEntry",
                    "path": [ {
                        "type": "property",
                        "id": "phonetic"
                    } ],
                    "leader": "$"
                }
            }, "\n        <em>/", {
                "type": "references",
                "id": "perCollinsEntry",
                "path": [ {
                    "type": "property",
                    "id": "phonetic"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "/</em>\n    " ], "\n    ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perCollinsEntry",
                    "path": [ {
                        "type": "property",
                        "id": "star"
                    } ],
                    "leader": "$"
                }
            }, '\n    <span class="star star', {
                "type": "references",
                "id": "perCollinsEntry",
                "path": [ {
                    "type": "property",
                    "id": "star"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '" title="使用频率"></span>\n    ' ], "\n    ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perCollinsEntry",
                    "path": [ {
                        "type": "property",
                        "id": "basic_entries"
                    } ],
                    "leader": "$"
                }
            }, "\n        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "basicEntries",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "perCollinsEntry",
                    "path": [ {
                        "type": "property",
                        "id": "basic_entries"
                    }, {
                        "type": "property",
                        "id": "basic_entry"
                    } ],
                    "leader": "$"
                } ]
            }, "\n        ", [ {
                "type": "foreach",
                "to": "basicEntry",
                "from": {
                    "type": "references",
                    "id": "basicEntries",
                    "leader": "$"
                }
            }, "\n            ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "basicEntry",
                    "path": [ {
                        "type": "property",
                        "id": "cet"
                    } ],
                    "leader": "$"
                }
            }, "\n            <span>", {
                "type": "references",
                "id": "basicEntry",
                "path": [ {
                    "type": "property",
                    "id": "cet"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "</span>\n            " ], "\n            ", [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "basicEntry",
                        "path": [ {
                            "type": "property",
                            "id": "wordforms"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "references",
                        "id": "basicEntry",
                        "path": [ {
                            "type": "property",
                            "id": "wordforms"
                        }, {
                            "type": "property",
                            "id": "wordform"
                        } ],
                        "leader": "$"
                    } ],
                    "operator": "&&"
                }
            }, "\n                ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "words",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "basicEntry",
                    "path": [ {
                        "type": "property",
                        "id": "wordforms"
                    }, {
                        "type": "property",
                        "id": "wordform"
                    } ],
                    "leader": "$"
                } ]
            }, '\n            <em class="additional ">(', {
                "type": "references",
                "id": "_getWordForms",
                "path": [ {
                    "type": "property",
                    "id": "wordFormString"
                } ],
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "words",
                    "leader": "$"
                }, {
                    "type": "string",
                    "value": "word",
                    "isEval": true
                } ],
                "prue": true
            }, ")", "</em>\n            " ], "\n            ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "basicEntry",
                    "path": [ {
                        "type": "property",
                        "id": "box_comms"
                    } ],
                    "leader": "$"
                }
            }, "\n                ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "boxInfo",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "basicEntry",
                    "path": [ {
                        "type": "property",
                        "id": "box_comms"
                    }, {
                        "type": "property",
                        "id": "box_com"
                    } ],
                    "leader": "$"
                } ]
            }, '\n                <p class="secondary">', {
                "type": "references",
                "id": "boxInfo",
                "path": [ {
                    "type": "index",
                    "id": {
                        "type": "integer",
                        "value": "0"
                    }
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/p>\n            " ], "\n            ", [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "basicEntry",
                        "path": [ {
                            "type": "property",
                            "id": "sees"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "references",
                        "id": "basicEntry",
                        "path": [ {
                            "type": "property",
                            "id": "sees"
                        }, {
                            "type": "property",
                            "id": "see"
                        } ],
                        "leader": "$"
                    } ],
                    "operator": "&&"
                }
            }, '\n                <p class="secondary">\n                    →see\n                    ', {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "seeHeadWords",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "_getWordForms",
                    "path": [ {
                        "type": "property",
                        "id": "wordFormArray"
                    } ],
                    "leader": "$",
                    "args": [ {
                        "type": "references",
                        "id": "basicEntry",
                        "path": [ {
                            "type": "property",
                            "id": "sees"
                        }, {
                            "type": "property",
                            "id": "see"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "string",
                        "value": "seeword",
                        "isEval": true
                    } ]
                } ]
            }, "\n                    ", {
                "type": "references",
                "id": "_foreachHeadSee",
                "path": [ {
                    "type": "method",
                    "id": "start",
                    "args": [ {
                        "type": "integer",
                        "value": "1"
                    } ]
                } ],
                "leader": "$",
                "prue": true
            }, "\n                    ", [ {
                "type": "foreach",
                "to": "perSeeWord",
                "from": {
                    "type": "references",
                    "id": "seeHeadWords",
                    "leader": "$"
                }
            }, '\n                        <span class="grey">\n                            <a class="clickable" href="link:', {
                "type": "references",
                "id": "perSeeWord",
                "leader": "$",
                "prue": true
            }, '"', ">", {
                "type": "references",
                "id": "perSeeWord",
                "leader": "$",
                "prue": true
            }, "<", "/a>\n                            ", [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "_foreachHeadSee",
                        "path": [ {
                            "type": "property",
                            "id": "count"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "references",
                        "id": "seeHeadWords",
                        "path": [ {
                            "type": "property",
                            "id": "length"
                        } ],
                        "leader": "$"
                    } ],
                    "operator": "!="
                }
            }, "\n                                &nbsp;,&nbsp;\n                            " ], "\n                    </span>\n                    " ], "\n                </p>\n            " ], "\n        " ], "\n    " ], "\n</h4>\n\n" ], "\n\n", [ {
                "type": "macro",
                "id": "collinsEntries"
            }, "\n    ", [ {
                "type": "foreach",
                "to": "perCollinsEntry",
                "from": {
                    "type": "references",
                    "id": "collinsEntries",
                    "leader": "$"
                }
            }, '\n    <div class="perCollinsEntry" id="perCollinsEntry', {
                "type": "references",
                "id": "foreach",
                "path": [ {
                    "type": "property",
                    "id": "count"
                } ],
                "leader": "$",
                "prue": true
            }, '"', ">\n        ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "superHead",
                    "leader": "$"
                }
            }, '\n            <a class="collapse-tips" data-toggle="yd_collapse_dict_collins">\n                <span class="show-detail"></span>\n                ', {
                "type": "references",
                "id": "perCollinsEntry",
                "path": [ {
                    "type": "property",
                    "id": "super_headword"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "\n            </a>\n        " ], '\n        <div role="yd_collapse_dict_collins">\n            ', {
                "type": "macro_call",
                "id": "getTitle",
                "args": [ {
                    "type": "references",
                    "id": "perCollinsEntry",
                    "leader": "$"
                } ]
            }, "\n            ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perCollinsEntry",
                    "path": [ {
                        "type": "property",
                        "id": "entries"
                    } ],
                    "leader": "$"
                }
            }, "\n                ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "allEnties",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "perCollinsEntry",
                    "path": [ {
                        "type": "property",
                        "id": "entries"
                    }, {
                        "type": "property",
                        "id": "entry"
                    } ],
                    "leader": "$"
                } ]
            }, "\n                ", {
                "type": "macro_call",
                "id": "withoutHeadword",
                "args": [ {
                    "type": "references",
                    "id": "allEnties",
                    "leader": "$"
                } ]
            }, "\n            " ], "\n        </div>\n    </div>\n    " ], "\n" ], '\n\n<!--所有释义的入口，if有头词-->\n<div class="trans-container collins">\n    ', [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "super_headwords",
                    "leader": "$"
                }
            }, '\n        <div class="super_head">\n            ', [ {
                "type": "foreach",
                "to": "perSuperHead",
                "from": {
                    "type": "references",
                    "id": "super_headwords",
                    "path": [ {
                        "type": "property",
                        "id": "super_headword"
                    } ],
                    "leader": "$"
                }
            }, '\n                <p>\n                    <span class="secondary">', {
                "type": "references",
                "id": "foreach",
                "path": [ {
                    "type": "property",
                    "id": "count"
                } ],
                "leader": "$",
                "prue": true
            }, ".", '&nbsp;</span>\n                    <a class="clickable" href="', "#p", "erCollinsEntry", {
                "type": "references",
                "id": "foreach",
                "path": [ {
                    "type": "property",
                    "id": "count"
                } ],
                "leader": "$",
                "prue": true
            }, '"', ' rel="', "#p", "erCollinsEntry", {
                "type": "references",
                "id": "foreach",
                "path": [ {
                    "type": "property",
                    "id": "count"
                } ],
                "leader": "$",
                "prue": true
            }, '"', ">", {
                "type": "references",
                "id": "perSuperHead",
                "leader": "$",
                "prue": true
            }, "<", "/a>\n                </p>\n            " ], "\n        </div>\n    " ], "\n    ", {
                "type": "macro_call",
                "id": "collinsEntries"
            }, "\n</div>\n\n\n\n\n\n\n\n\n" ]).render(_data);
        },
        "init": function init() {
            utils.tg(".perCollinsEntry", '[data-toggle = "yd_collapse_dict_collins"]', "yd_dict_toggleClose");
            $(".super_head a.clickable").click(function() {
                var itemId = $(this).attr("rel");
                $(".perCollinsEntry").addClass("yd_dict_toggleClose");
                $(itemId).removeClass("yd_dict_toggleClose");
            });
        }
    };
});
define("/output/copyright/copyright", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            var htmlCode = "";
            with (_data || {}) {
                htmlCode += '                  \n<ul class="copyright">\n                  \n    ';
                var simple = _data.ec || _data.ce;
                htmlCode += "\n    ";
                if (simple !== undefined) {
                    htmlCode += "                \n    <li>\n        ";
                    if (!!simple.source.url) {
                        htmlCode += '\n        <span class="middot">&#183;</span>简明翻译结果来源于: <a href="';
                        htmlCode += simple.source.url;
                        htmlCode += '" class="clickable js-ctlog" target="_blank">';
                        htmlCode += simple.source.name;
                        htmlCode += "</a>\n        ";
                    } else {
                        htmlCode += "\n        ";
                        htmlCode += simple.source.name;
                        htmlCode += "\n        ";
                    }
                    htmlCode += '\n    </li>\n    <li>\n        <span class="middot">&#183;</span>基本释义中，单词采用国际音标(IPA)进行注音，详见\n        <a class="clickable js-ctlog" target="_blank"\n           href="http://cidian.youdao.com/help.jsp?page=phonetic">音标示例</a>\n    </li>\n    ';
                }
                htmlCode += "\n\n                \n    ";
                var basic;
                htmlCode += "\n    ";
                var nameof = {
                    "cj": "汉日翻译",
                    "jc": "日汉翻译",
                    "ck": "汉韩翻译",
                    "kc": "韩汉翻译",
                    "cf": "汉法翻译",
                    "fc": "法汉翻译"
                };
                htmlCode += "\n    ";
                for (var basicTrans in _data) {
                    htmlCode += "\n        ";
                    if (!!nameof[basicTrans] && _data[basicTrans]) {
                        htmlCode += "\n            ";
                        basic = _data[basicTrans];
                        htmlCode += "\n            ";
                        basic.name = nameof[basicTrans];
                        htmlCode += "\n        ";
                    }
                    htmlCode += "\n    ";
                }
                htmlCode += "\n    ";
                if (!!basic) {
                    htmlCode += '\n    <li>\n        <span class="middot">&#183;</span>';
                    htmlCode += basic.name;
                    htmlCode += "来源于:\n        ";
                    htmlCode += basic.source.name;
                    htmlCode += "\n    </li>\n    ";
                }
                htmlCode += "\n\n                      \n    ";
                if (!!_data.hh) {
                    htmlCode += '\n        <li>\n            <span class="middot">&#183;</span>汉语词典来源于:\n            ';
                    htmlCode += _data.hh.source.name;
                    htmlCode += "\n        </li>\n    ";
                }
                htmlCode += "\n                      \n    ";
                if (!!_data.baike) {
                    htmlCode += '\n        <li>\n            <span class="middot">&#183;</span>百科内容来源于:\n            <a href="';
                    htmlCode += _data.baike.source.url;
                    htmlCode += '" class="clickable js-ctlog" target="_blank">\n            ';
                    htmlCode += _data.baike.source.name;
                    htmlCode += "</a>\n        </li>\n    ";
                }
                htmlCode += "\n\n    ";
                if (!!_data["media_sents_part"] && !!_data["media_sents_part"]["sent"]) {
                    htmlCode += '\n        <li>\n           <span class="middot">&#183;</span>部分原声例句来源于\n            <a class="clickable" target="_blank" href="http://yyets.com">人人影视</a>、\n            <a class="clickable" target="_blank" href="http://bbs.uuniao.com">悠悠鸟</a>等 对外免费发布的字幕素材\n        </li>\n    ';
                }
                htmlCode += "\n\n    ";
                if (!!_data.collins) {
                    htmlCode += '\n        <li>\n            <span class="middot">&#183;</span>《柯林斯英汉双解大词典》来自于哈珀·柯林斯出版集团，使用说明详见\n            <a class="js-ctlog clickable" target="_blank"\n               href="http://cidian.youdao.com/help.jsp?page=collins">柯林斯词典使用说明</a>\n        </li>\n    ';
                }
                htmlCode += '\n    <li id="copyRightOfGlobalVoice">\n        <span class="middot">&#183;</span>全球发音数据来源于：\n        <a class="js-ctlog clickable" target="_blank"\n           href="http://zh.forvo.com/">Forvo</a>\n    </li>\n</ul>';
            }
            return htmlCode;
        },
        "init": function init() {}
    };
});
define("/output/ec/ec", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            _data = tpHelper.mixin(_data, {
                "getOnlineStatus": function() {
                    return global.status.online;
                }
            });
            var tp = [  "<div class=\"trans-container  ec\">\r\n    ",
              [
                {
                  "type": "foreach",
                  "to": "_word",
                  "from": {
                    "type": "references",
                    "id": "word",
                    "leader": "$"
                  },
                  "pos": {
                    "first_line": 2,
                    "last_line": 2,
                    "first_column": 4,
                    "last_column": 29
                  }
                },
                "\r\n        <h2>\r\n            <span class=\"keyword\">\r\n            ",
                {
                  "type": "references",
                  "id": "_word",
                  "path": [
                    {
                      "type": "property",
                      "id": "return-phrase"
                    },
                    {
                      "type": "property",
                      "id": "l"
                    },
                    {
                      "type": "property",
                      "id": "i"
                    }
                  ],
                  "isWraped": true,
                  "leader": "$!",
                  "prue": true,
                  "pos": {
                    "first_line": 5,
                    "last_line": 5,
                    "first_column": 12,
                    "last_column": 39
                  }
                },
                "\r\n        </span>\r\n            ",
                [
                  {
                    "type": "if",
                    "condition": {
                      "type": "references",
                      "id": "getOnlineStatus",
                      "leader": "$",
                      "args": false
                    },
                    "pos": {
                      "first_line": 7,
                      "last_line": 7,
                      "first_column": 12,
                      "last_column": 35
                    }
                  },
                  "\r\n                       "
                ],
                "\r\n            <div class=\"baav\">\r\n                ",
                [
                  {
                    "type": "if",
                    "condition": {
                      "type": "math",
                      "expression": [
                        {
                          "type": "references",
                          "id": "_word",
                          "path": [
                            {
                              "type": "property",
                              "id": "ukphone"
                            }
                          ],
                          "leader": "$"
                        },
                        {
                          "type": "references",
                          "id": "_word",
                          "path": [
                            {
                              "type": "property",
                              "id": "ukspeech"
                            }
                          ],
                          "leader": "$"
                        }
                      ],
                      "operator": "||"
                    },
                    "pos": {
                      "first_line": 11,
                      "last_line": 11,
                      "first_column": 16,
                      "last_column": 54
                    }
                  },
                  "\r\n                    <span class=\"pronounce\">\r\n                        ",
                  [
                    {
                      "type": "if",
                      "condition": {
                        "type": "math",
                        "expression": [
                          {
                            "type": "references",
                            "id": "_word",
                            "path": [
                              {
                                "type": "property",
                                "id": "ukspeech"
                              }
                            ],
                            "leader": "$"
                          },
                          {
                            "type": "references",
                            "id": "getOnlineStatus",
                            "leader": "$",
                            "args": false
                          }
                        ],
                        "operator": "&&"
                      },
                      "pos": {
                        "first_line": 13,
                        "last_line": 13,
                        "first_column": 24,
                        "last_column": 66
                      }
                    },
                    "\r\n                            <a href=\"",
                    "#",
                    "\" title=\"\u771f\u4eba\u53d1\u97f3\" role='dict_audio_js'\r\n                               data-rel=\"http://dict.youdao.com/dictvoice?audio=",
                    {
                      "type": "references",
                      "id": "_word",
                      "path": [
                        {
                          "type": "property",
                          "id": "ukspeech"
                        }
                      ],
                      "isWraped": true,
                      "leader": "$!",
                      "prue": true,
                      "pos": {
                        "first_line": 15,
                        "last_line": 15,
                        "first_column": 80,
                        "last_column": 98
                      }
                    },
                    "\"\r\n                               class=\"dictvoice word-speech voice-js js-ctlog js-hover-ctlog\"\r\n                               data-chtype=\"dict.basic.ec.uk.hover.voice\" data-ctype=\"dict.basic.ec.uk.voice\"></a>\r\n                        "
                  ],
                  "\r\n                        \u82f1\r\n                        ",
                  [
                    {
                      "type": "if",
                      "condition": {
                        "type": "references",
                        "id": "_word",
                        "path": [
                          {
                            "type": "property",
                            "id": "ukphone"
                          }
                        ],
                        "leader": "$"
                      },
                      "pos": {
                        "first_line": 20,
                        "last_line": 20,
                        "first_column": 24,
                        "last_column": 43
                      }
                    },
                    "\r\n                            <span class=\"phonetic\">[",
                    {
                      "type": "references",
                      "id": "_word",
                      "path": [
                        {
                          "type": "property",
                          "id": "ukphone"
                        }
                      ],
                      "isWraped": true,
                      "leader": "$!",
                      "prue": true,
                      "pos": {
                        "first_line": 21,
                        "last_line": 21,
                        "first_column": 52,
                        "last_column": 69
                      }
                    },
                    "]</span>\r\n                        "
                  ],
                  "\r\n                    </span>\r\n                "
                ],
                "\r\n                ",
                [
                  {
                    "type": "if",
                    "condition": {
                      "type": "math",
                      "expression": [
                        {
                          "type": "references",
                          "id": "_word",
                          "path": [
                            {
                              "type": "property",
                              "id": "usphone"
                            }
                          ],
                          "leader": "$"
                        },
                        {
                          "type": "references",
                          "id": "_word",
                          "path": [
                            {
                              "type": "property",
                              "id": "usspeech"
                            }
                          ],
                          "leader": "$"
                        }
                      ],
                      "operator": "||"
                    },
                    "pos": {
                      "first_line": 25,
                      "last_line": 25,
                      "first_column": 16,
                      "last_column": 54
                    }
                  },
                  "\r\n                    <span class=\"pronounce\">\r\n                        ",
                  [
                    {
                      "type": "if",
                      "condition": {
                        "type": "math",
                        "expression": [
                          {
                            "type": "references",
                            "id": "_word",
                            "path": [
                              {
                                "type": "property",
                                "id": "usspeech"
                              }
                            ],
                            "leader": "$"
                          },
                          {
                            "type": "references",
                            "id": "getOnlineStatus",
                            "leader": "$",
                            "args": false
                          }
                        ],
                        "operator": "&&"
                      },
                      "pos": {
                        "first_line": 27,
                        "last_line": 27,
                        "first_column": 24,
                        "last_column": 67
                      }
                    },
                    "\r\n                            <a href=\"",
                    "#",
                    "\" title=\"\u771f\u4eba\u53d1\u97f3\" role='dict_audio_js'\r\n                               data-rel=\"http://dict.youdao.com/dictvoice?audio=",
                    {
                      "type": "references",
                      "id": "_word",
                      "path": [
                        {
                          "type": "property",
                          "id": "usspeech"
                        }
                      ],
                      "isWraped": true,
                      "leader": "$!",
                      "prue": true,
                      "pos": {
                        "first_line": 29,
                        "last_line": 29,
                        "first_column": 80,
                        "last_column": 98
                      }
                    },
                    "\"\r\n                               class='dictvoice word-speech voice-js js-ctlog js-hover-ctlog'\r\n                               data-chtype=\"dict.basic.ec.us.hover.voice\" data-ctype=\"dict.basic.ec.us.voice\"></a>\r\n                        "
                  ],
                  "\r\n                         \u7f8e\r\n                        ",
                  [
                    {
                      "type": "if",
                      "condition": {
                        "type": "references",
                        "id": "_word",
                        "path": [
                          {
                            "type": "property",
                            "id": "usphone"
                          }
                        ],
                        "leader": "$"
                      },
                      "pos": {
                        "first_line": 34,
                        "last_line": 34,
                        "first_column": 24,
                        "last_column": 43
                      }
                    },
                    "\r\n                            <span class=\"phonetic\">[",
                    {
                      "type": "references",
                      "id": "_word",
                      "path": [
                        {
                          "type": "property",
                          "id": "usphone"
                        }
                      ],
                      "leader": "$",
                      "prue": true,
                      "pos": {
                        "first_line": 35,
                        "last_line": 35,
                        "first_column": 52,
                        "last_column": 66
                      }
                    },
                    "]",
                    "</span>\r\n                        "
                  ],
                  "\r\n                    </span>\r\n                "
                ],
                "\r\n                ",
                [
                  {
                    "type": "if",
                    "condition": {
                      "type": "math",
                      "expression": [
                        {
                          "type": "references",
                          "id": "_word",
                          "path": [
                            {
                              "type": "property",
                              "id": "phone"
                            }
                          ],
                          "leader": "$"
                        },
                        {
                          "type": "references",
                          "id": "_word",
                          "path": [
                            {
                              "type": "property",
                              "id": "speech"
                            }
                          ],
                          "leader": "$"
                        }
                      ],
                      "operator": "||"
                    },
                    "pos": {
                      "first_line": 39,
                      "last_line": 39,
                      "first_column": 16,
                      "last_column": 50
                    }
                  },
                  "\r\n                    <span class=\"pronounce\">\r\n                        ",
                  [
                    {
                      "type": "if",
                      "condition": {
                        "type": "math",
                        "expression": [
                          {
                            "type": "references",
                            "id": "_word",
                            "path": [
                              {
                                "type": "property",
                                "id": "speech"
                              }
                            ],
                            "leader": "$"
                          },
                          {
                            "type": "references",
                            "id": "getOnlineStatus",
                            "leader": "$",
                            "args": false
                          }
                        ],
                        "operator": "&&"
                      },
                      "pos": {
                        "first_line": 41,
                        "last_line": 41,
                        "first_column": 24,
                        "last_column": 64
                      }
                    },
                    "\r\n                            <a href=\"",
                    "#",
                    "\" title=\"\u53d1\u97f3\" role='dict_audio_js'\r\n                               data-rel=\"http://dict.youdao.com/dictvoice?audio=",
                    [
                      {
                        "type": "if",
                        "condition": {
                          "type": "references",
                          "id": "_word",
                          "path": [
                            {
                              "type": "property",
                              "id": "speech"
                            }
                          ],
                          "leader": "$"
                        },
                        "pos": {
                          "first_line": 43,
                          "last_line": 43,
                          "first_column": 80,
                          "last_column": 98
                        }
                      },
                      {
                        "type": "references",
                        "id": "_word",
                        "path": [
                          {
                            "type": "property",
                            "id": "speech"
                          }
                        ],
                        "leader": "$",
                        "prue": true,
                        "pos": {
                          "first_line": 43,
                          "last_line": 43,
                          "first_column": 98,
                          "last_column": 111
                        }
                      },
                      {
                        "type": "else",
                        "pos": {
                          "first_line": 43,
                          "last_line": 43,
                          "first_column": 111,
                          "last_column": 116
                        }
                      },
                      {
                        "type": "references",
                        "id": "_word",
                        "path": [
                          {
                            "type": "property",
                            "id": "return-phrase"
                          },
                          {
                            "type": "property",
                            "id": "l"
                          },
                          {
                            "type": "property",
                            "id": "i"
                          }
                        ],
                        "isWraped": true,
                        "leader": "$!",
                        "prue": true,
                        "pos": {
                          "first_line": 43,
                          "last_line": 43,
                          "first_column": 116,
                          "last_column": 143
                        }
                      }
                    ],
                    "\"\r\n                               class='dictvoice voice-js js-ctlog js-hover-ctlog'\r\n                               data-chtype=\"dict.basic.ec.tts.hover.voice\" data-ctype=\"dict.basic.ec.tts.voice\"></a>\r\n                        "
                  ],
                  "\r\n                        ",
                  [
                    {
                      "type": "if",
                      "condition": {
                        "type": "references",
                        "id": "_word",
                        "path": [
                          {
                            "type": "property",
                            "id": "phone"
                          }
                        ],
                        "leader": "$"
                      },
                      "pos": {
                        "first_line": 47,
                        "last_line": 47,
                        "first_column": 24,
                        "last_column": 41
                      }
                    },
                    "\r\n                            <span class=\"phonetic\">[",
                    {
                      "type": "references",
                      "id": "_word",
                      "path": [
                        {
                          "type": "property",
                          "id": "phone"
                        }
                      ],
                      "leader": "$",
                      "prue": true,
                      "pos": {
                        "first_line": 48,
                        "last_line": 48,
                        "first_column": 52,
                        "last_column": 64
                      }
                    },
                    "]",
                    "</span>\r\n                        "
                  ],
                  "\r\n                    </span>\r\n                "
                ],
                "\r\n                ",
                [
                  {
                    "type": "if",
                    "condition": {
                      "type": "references",
                      "id": "getOnlineStatus",
                      "leader": "$",
                      "args": false
                    },
                    "pos": {
                      "first_line": 52,
                      "last_line": 52,
                      "first_column": 16,
                      "last_column": 39
                    }
                  },
                  "\r\n                    <span class=\"global_voice\" id=\"global_voice_span\">\r\n                    <a id=\"global_voice\" href=\"javascript:void(0)\" title=\"\u5168\u7403\u53d1\u97f3\"\r\n                       class=\"global-voice-icon js-ctlog\" data-word=\"",
                  {
                    "type": "references",
                    "id": "_word",
                    "path": [
                      {
                        "type": "property",
                        "id": "return-phrase"
                      },
                      {
                        "type": "property",
                        "id": "l"
                      },
                      {
                        "type": "property",
                        "id": "i"
                      }
                    ],
                    "isWraped": true,
                    "leader": "$!",
                    "prue": true,
                    "pos": {
                      "first_line": 55,
                      "last_line": 55,
                      "first_column": 69,
                      "last_column": 96
                    }
                  },
                  "\"\r\n                       data-ctype=\"global_voice_button\"></a>&nbsp;\u5168\u7403\u53d1\u97f3\r\n                    </span>\r\n                "
                ],
                "\r\n            </div>\r\n        </h2>\r\n        <ul>\r\n            ",
                [
                  {
                    "type": "foreach",
                    "to": "trsArr",
                    "from": {
                      "type": "references",
                      "id": "_word",
                      "path": [
                        {
                          "type": "property",
                          "id": "trs"
                        }
                      ],
                      "leader": "$"
                    },
                    "pos": {
                      "first_line": 62,
                      "last_line": 62,
                      "first_column": 12,
                      "last_column": 43
                    }
                  },
                  "\r\n                ",
                  [
                    {
                      "type": "foreach",
                      "to": "_tr",
                      "from": {
                        "type": "references",
                        "id": "trsArr",
                        "path": [
                          {
                            "type": "property",
                            "id": "tr"
                          }
                        ],
                        "leader": "$"
                      },
                      "pos": {
                        "first_line": 63,
                        "last_line": 63,
                        "first_column": 16,
                        "last_column": 44
                      }
                    },
                    "\r\n                    <li>",
                    {
                      "type": "references",
                      "id": "_tr",
                      "path": [
                        {
                          "type": "property",
                          "id": "l"
                        },
                        {
                          "type": "property",
                          "id": "i"
                        }
                      ],
                      "isWraped": true,
                      "leader": "$!",
                      "prue": true,
                      "pos": {
                        "first_line": 64,
                        "last_line": 64,
                        "first_column": 24,
                        "last_column": 35
                      }
                    },
                    "</li>\r\n                "
                  ],
                  "\r\n            "
                ],
                "\r\n        </ul>\r\n        ",
                [
                  {
                    "type": "if",
                    "condition": {
                      "type": "references",
                      "id": "_word",
                      "path": [
                        {
                          "type": "property",
                          "id": "wfs"
                        }
                      ],
                      "leader": "$"
                    },
                    "pos": {
                      "first_line": 68,
                      "last_line": 68,
                      "first_column": 8,
                      "last_column": 23
                    }
                  },
                  "\r\n            <p class=\"additional\">[\r\n                ",
                  [
                    {
                      "type": "foreach",
                      "to": "sub",
                      "from": {
                        "type": "references",
                        "id": "_word",
                        "path": [
                          {
                            "type": "property",
                            "id": "wfs"
                          }
                        ],
                        "leader": "$"
                      },
                      "pos": {
                        "first_line": 70,
                        "last_line": 70,
                        "first_column": 16,
                        "last_column": 44
                      }
                    },
                    "\r\n                    ",
                    {
                      "type": "references",
                      "id": "sub",
                      "path": [
                        {
                          "type": "property",
                          "id": "wf"
                        },
                        {
                          "type": "property",
                          "id": "name"
                        }
                      ],
                      "isWraped": true,
                      "leader": "$",
                      "prue": true,
                      "pos": {
                        "first_line": 71,
                        "last_line": 71,
                        "first_column": 20,
                        "last_column": 34
                      }
                    },
                    "\r\n                    ",
                    {
                      "type": "references",
                      "id": "sub",
                      "path": [
                        {
                          "type": "property",
                          "id": "wf"
                        },
                        {
                          "type": "property",
                          "id": "value"
                        }
                      ],
                      "isWraped": true,
                      "leader": "$",
                      "prue": true,
                      "pos": {
                        "first_line": 72,
                        "last_line": 72,
                        "first_column": 20,
                        "last_column": 35
                      }
                    },
                    "\r\n                "
                  ],
                  "\r\n                ] </p>\r\n        "
                ],
                "\r\n    "
              ],
              "\r\n</div>\r\n"];
            return tpHelper.vm(tp).render(_data);
        },
        "init": function init() {}
    };
});
define("/output/ec21/ec21", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            _data = tpHelper.mixin(_data, {
                "_foreach": Object.create(utils._foreach),
                "_foreachExam": Object.create(utils._foreach),
                "_getallExam": function(obj) {
                    var engDataString = "", chnDataString = "";
                    return obj.map(function(exam) {
                        engDataString = exam.i.f.l.i;
                        chnDataString = exam.i.n.l.i;
                        return {
                            "eng": engDataString,
                            "chn": chnDataString
                        };
                    });
                },
                "_getptrans": function(trandata) {
                    if (Array.isArray(trandata)) {
                        var td = trandata.map(function(obj) {
                            if (typeof obj !== "string") {
                                return "<sup>" + obj["#text"] + "</sup>";
                            } else {
                                return obj;
                            }
                        });
                        return [ td.join("") ];
                    } else {
                        return trandata;
                    }
                },
                "_isSup": function(str, tgt) {
                    return str == tgt;
                },
                "_handleMore": function() {}
            });
            return tpHelper.vm([ [ {
                "type": "macro",
                "id": "list"
            }, "\n<!--释义-->\n", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "trs",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "pWord",
                    "path": [ {
                        "type": "property",
                        "id": "trs"
                    } ],
                    "leader": "$"
                } ]
            }, '\n<ul class="posType">\n    ', [ {
                "type": "foreach",
                "to": "pTr",
                "from": {
                    "type": "references",
                    "id": "trs",
                    "leader": "$"
                }
            }, "\n        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "orderType",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "_foreachType",
                    "path": [ {
                        "type": "property",
                        "id": "count"
                    } ],
                    "isWraped": true,
                    "leader": "$!"
                } ]
            }, '\n        <li>\n            <span class="title">', {
                "type": "references",
                "id": "pTr",
                "path": [ {
                    "type": "property",
                    "id": "pos"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "</span>\n            <ul>\n                ", {
                "type": "references",
                "id": "_foreach",
                "path": [ {
                    "type": "method",
                    "id": "start",
                    "args": [ {
                        "type": "integer",
                        "value": "1"
                    } ]
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "\n                ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "allSenTrans",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "pTr",
                    "path": [ {
                        "type": "property",
                        "id": "tr"
                    } ],
                    "leader": "$"
                } ]
            }, "\n                ", [ {
                "type": "foreach",
                "to": "pTrans",
                "from": {
                    "type": "references",
                    "id": "allSenTrans",
                    "leader": "$"
                }
            }, "\n                    ", [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "allSenTrans",
                        "path": [ {
                            "type": "property",
                            "id": "length"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "integer",
                        "value": "1"
                    } ],
                    "operator": "=="
                }
            }, "\n                        <span>", {
                "type": "references",
                "id": "_getptrans",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "pTrans",
                    "path": [ {
                        "type": "property",
                        "id": "l"
                    }, {
                        "type": "property",
                        "id": "i"
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, "<", "/span>\n                    ", {
                "type": "else"
            }, "\n                        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "order",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "_foreach",
                    "path": [ {
                        "type": "property",
                        "id": "count"
                    } ],
                    "isWraped": true,
                    "leader": "$!"
                } ]
            }, '\n                        <li class="cols-layout">\n                            <span class="col1 order">', {
                "type": "references",
                "id": "order",
                "leader": "$",
                "prue": true
            }, ".", '</span>\n                            <div class="col2">\n                                <span>', {
                "type": "references",
                "id": "_getptrans",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "pTrans",
                    "path": [ {
                        "type": "property",
                        "id": "l"
                    }, {
                        "type": "property",
                        "id": "i"
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, "<", "/span>\n                                ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "pTrans",
                    "path": [ {
                        "type": "property",
                        "id": "tr"
                    } ],
                    "leader": "$"
                }
            }, "\n                                    ", {
                "type": "references",
                "id": "_foreachExam",
                "path": [ {
                    "type": "method",
                    "id": "start",
                    "args": [ {
                        "type": "integer",
                        "value": "1"
                    } ]
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "\n                                    <ul>\n                                        ", [ {
                "type": "foreach",
                "to": "item",
                "from": {
                    "type": "references",
                    "id": "pTrans",
                    "path": [ {
                        "type": "property",
                        "id": "tr"
                    } ],
                    "leader": "$"
                }
            }, "\n                                            ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "orderExam",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "_foreachExam",
                    "path": [ {
                        "type": "property",
                        "id": "count"
                    } ],
                    "isWraped": true,
                    "leader": "$!"
                } ]
            }, '\n                                            <li class="cols-layout">\n                                                <span class="col1 order">', {
                "type": "references",
                "id": "orderExam",
                "leader": "$",
                "prue": true
            }, ".", '</span>\n                                                <div class="col2">\n                                                    <p>', {
                "type": "references",
                "id": "_getptrans",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "item",
                    "path": [ {
                        "type": "property",
                        "id": "l"
                    }, {
                        "type": "property",
                        "id": "i"
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, "<", "/p>\n                                                    ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "item",
                    "path": [ {
                        "type": "property",
                        "id": "exam"
                    } ],
                    "leader": "$"
                }
            }, "\n                                                        ", [ {
                "type": "foreach",
                "to": "perItemExam",
                "from": {
                    "type": "references",
                    "id": "_getallExam",
                    "leader": "$",
                    "args": [ {
                        "type": "references",
                        "id": "item",
                        "path": [ {
                            "type": "property",
                            "id": "exam"
                        } ],
                        "leader": "$"
                    } ]
                }
            }, "\n                                                            ", [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "perItemExam",
                        "path": [ {
                            "type": "property",
                            "id": "eng"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "references",
                        "id": "perItemExam",
                        "path": [ {
                            "type": "property",
                            "id": "chn"
                        } ],
                        "leader": "$"
                    } ],
                    "operator": "||"
                }
            }, '\n                                                                <p class="secondary">', {
                "type": "references",
                "id": "perItemExam",
                "path": [ {
                    "type": "property",
                    "id": "eng"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '</p>\n                                                                <p class="secondary">', {
                "type": "references",
                "id": "perItemExam",
                "path": [ {
                    "type": "property",
                    "id": "chn"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "</p>\n                                                            " ], "\n                                                        " ], "\n                                                    " ], "\n                                                </div>\n                                            </li>\n                                        " ], "\n                                    </ul>\n                                " ], "\n                                ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "pTrans",
                    "path": [ {
                        "type": "property",
                        "id": "exam"
                    } ],
                    "leader": "$"
                }
            }, "\n                                    ", [ {
                "type": "foreach",
                "to": "perExam",
                "from": {
                    "type": "references",
                    "id": "_getallExam",
                    "leader": "$",
                    "args": [ {
                        "type": "references",
                        "id": "pTrans",
                        "path": [ {
                            "type": "property",
                            "id": "exam"
                        } ],
                        "leader": "$"
                    } ]
                }
            }, "\n                                        ", [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "perExam",
                        "path": [ {
                            "type": "property",
                            "id": "eng"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "references",
                        "id": "perExam",
                        "path": [ {
                            "type": "property",
                            "id": "chn"
                        } ],
                        "leader": "$"
                    } ],
                    "operator": "||"
                }
            }, '\n                                            <p class="secondary">', {
                "type": "references",
                "id": "perExam",
                "path": [ {
                    "type": "property",
                    "id": "eng"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '</p>\n                                            <p class="secondary">', {
                "type": "references",
                "id": "perExam",
                "path": [ {
                    "type": "property",
                    "id": "chn"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "</p>\n                                        " ], "\n                                    " ], "\n                                " ], "\n                            </div>\n                        </li>\n                    " ], "\n                " ], "\n            </ul>\n        </li>\n    " ], "\n</ul>\n<!--短语-->\n", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "pWord",
                    "path": [ {
                        "type": "property",
                        "id": "phrs"
                    } ],
                    "leader": "$"
                }
            }, '\n<div class="phrs">\n    <span class="title">短语</span>\n    ', {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "phrs",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "pWord",
                    "path": [ {
                        "type": "property",
                        "id": "phrs"
                    } ],
                    "leader": "$"
                } ]
            }, "\n    ", [ {
                "type": "foreach",
                "to": "phr",
                "from": {
                    "type": "references",
                    "id": "phrs",
                    "leader": "$"
                }
            }, "\n        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "iPhrs",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "phr",
                    "path": [ {
                        "type": "property",
                        "id": "i"
                    } ],
                    "leader": "$"
                } ]
            }, "\n        ", {
                "type": "references",
                "id": "_foreach",
                "path": [ {
                    "type": "method",
                    "id": "start",
                    "args": [ {
                        "type": "integer",
                        "value": "1"
                    } ]
                } ],
                "leader": "$",
                "prue": true
            }, "\n        ", [ {
                "type": "foreach",
                "to": "pi",
                "from": {
                    "type": "references",
                    "id": "iPhrs",
                    "leader": "$"
                }
            }, "\n            ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "order",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "_foreach",
                    "path": [ {
                        "type": "property",
                        "id": "count"
                    } ],
                    "isWraped": true,
                    "leader": "$!"
                } ]
            }, '\n            <div class="cols-layout">\n                <span class="col1 order">', {
                "type": "references",
                "id": "order",
                "leader": "$",
                "prue": true
            }, ".", '</span>\n                <div class="col2">\n                    <p>', {
                "type": "references",
                "id": "pi",
                "path": [ {
                    "type": "property",
                    "id": "phr"
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, " ", {
                "type": "references",
                "id": "pi",
                "path": [ {
                    "type": "property",
                    "id": "des"
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "</p>\n                    ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "pi",
                    "path": [ {
                        "type": "property",
                        "id": "tr"
                    } ],
                    "leader": "$"
                }
            }, "\n                        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "wordTrans",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "pi",
                    "path": [ {
                        "type": "property",
                        "id": "tr"
                    } ],
                    "leader": "$"
                } ]
            }, "\n                        ", [ {
                "type": "foreach",
                "to": "perWordTrans",
                "from": {
                    "type": "references",
                    "id": "wordTrans",
                    "leader": "$"
                }
            }, '\n                            <p class="secondary">', {
                "type": "references",
                "id": "perWordTrans",
                "path": [ {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "</p>\n                        " ], "\n                    " ], "\n                </div>\n            </div>\n        " ], "\n    " ], "\n</div>\n" ], "\n\n", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "pWord",
                    "path": [ {
                        "type": "property",
                        "id": "syno"
                    } ],
                    "leader": "$"
                }
            }, '\n<div class="syno">\n    <span class="title">近义词</span>\n    ', {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "allSynos",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "pWord",
                    "path": [ {
                        "type": "property",
                        "id": "syno"
                    } ],
                    "leader": "$"
                } ]
            }, "\n    ", [ {
                "type": "foreach",
                "to": "syno",
                "from": {
                    "type": "references",
                    "id": "allSynos",
                    "leader": "$"
                }
            }, "\n        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "psyno",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "syno",
                    "path": [ {
                        "type": "property",
                        "id": "i"
                    } ],
                    "leader": "$"
                } ]
            }, "\n        <p>\n            ", [ {
                "type": "foreach",
                "to": "ipsyno",
                "from": {
                    "type": "references",
                    "id": "psyno",
                    "leader": "$"
                }
            }, '\n                <a class="clickable js-inline-clickable" href="javascript:void(0);">', {
                "type": "references",
                "id": "ipsyno",
                "leader": "$",
                "prue": true
            }, "<", "/a>\n            " ], "\n        </p>\n    " ], "\n</div>\n" ], "\n\n<!--变形-->\n", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "pWord",
                    "path": [ {
                        "type": "property",
                        "id": "wfs"
                    } ],
                    "leader": "$"
                }
            }, '\n<div class="wfs">\n    <span class="title">变形</span>\n    ', {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "allWfs",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "pWord",
                    "path": [ {
                        "type": "property",
                        "id": "wfs"
                    } ],
                    "leader": "$"
                } ]
            }, "\n    ", [ {
                "type": "foreach",
                "to": "wf",
                "from": {
                    "type": "references",
                    "id": "allWfs",
                    "leader": "$"
                }
            }, "\n        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "pwf",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "wf",
                    "path": [ {
                        "type": "property",
                        "id": "wf"
                    } ],
                    "leader": "$"
                } ]
            }, "\n        ", [ {
                "type": "foreach",
                "to": "ipwf",
                "from": {
                    "type": "references",
                    "id": "pwf",
                    "leader": "$"
                }
            }, "\n            <p>", {
                "type": "references",
                "id": "ipwf",
                "path": [ {
                    "type": "property",
                    "id": "pos"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "\n            ", [ {
                "type": "foreach",
                "to": "wfi",
                "from": {
                    "type": "references",
                    "id": "ipwf",
                    "path": [ {
                        "type": "property",
                        "id": "i"
                    } ],
                    "leader": "$"
                }
            }, '\n            <a  class="clickable js-inline-clickable" href="javascript:void(0);">\n            ', {
                "type": "references",
                "id": "wfi",
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "\n            </a>\n            " ], "\n            </p>\n        " ], "\n    " ], "\n</div>\n" ], "\n" ], '\n\n<div class="trans-container ec21">\n    ', [ {
                "type": "foreach",
                "to": "pWord",
                "from": {
                    "type": "references",
                    "id": "word",
                    "leader": "$"
                }
            }, "\n        <h4>\n            ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "returnPhrase",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "pWord",
                    "path": [ {
                        "type": "property",
                        "id": "return-phrase"
                    }, {
                        "type": "property",
                        "id": "l"
                    }, {
                        "type": "property",
                        "id": "i"
                    } ],
                    "leader": "$"
                } ]
            }, "\n            ", [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "returnPhrase",
                        "path": [ {
                            "type": "index",
                            "id": {
                                "type": "integer",
                                "value": "0"
                            }
                        } ],
                        "leader": "$"
                    }, {
                        "type": "math",
                        "expression": [ {
                            "type": "references",
                            "id": "returnPhrase",
                            "path": [ {
                                "type": "index",
                                "id": {
                                    "type": "integer",
                                    "value": "0"
                                }
                            } ],
                            "leader": "$"
                        }, {
                            "type": "bool",
                            "value": "null"
                        } ],
                        "operator": "!="
                    } ],
                    "operator": "||"
                }
            }, "\n                ", {
                "type": "references",
                "id": "returnPhrase",
                "path": [ {
                    "type": "index",
                    "id": {
                        "type": "integer",
                        "value": "0"
                    }
                } ],
                "leader": "$",
                "prue": true
            }, "\n            " ], "\n            ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "returnPhrase",
                    "path": [ {
                        "type": "index",
                        "id": {
                            "type": "integer",
                            "value": "1"
                        }
                    } ],
                    "leader": "$"
                }
            }, "\n                ", [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "returnPhrase",
                        "path": [ {
                            "type": "index",
                            "id": {
                                "type": "integer",
                                "value": "1"
                            }
                        }, {
                            "type": "index",
                            "id": {
                                "type": "string",
                                "value": "@action"
                            }
                        } ],
                        "leader": "$"
                    }, {
                        "type": "references",
                        "id": "_isSup",
                        "leader": "$",
                        "args": [ {
                            "type": "references",
                            "id": "returnPhrase",
                            "path": [ {
                                "type": "index",
                                "id": {
                                    "type": "integer",
                                    "value": "1"
                                }
                            }, {
                                "type": "index",
                                "id": {
                                    "type": "string",
                                    "value": "@action"
                                }
                            } ],
                            "leader": "$"
                        }, {
                            "type": "string",
                            "value": "sup",
                            "isEval": true
                        } ]
                    } ],
                    "operator": "&&"
                }
            }, "\n                    <sup>", {
                "type": "references",
                "id": "returnPhrase",
                "path": [ {
                    "type": "index",
                    "id": {
                        "type": "integer",
                        "value": "1"
                    }
                }, {
                    "type": "index",
                    "id": {
                        "type": "string",
                        "value": "#text"
                    }
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/sup>\n                " ], "\n            " ], "\n            ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "pWord",
                    "path": [ {
                        "type": "property",
                        "id": "phone"
                    } ],
                    "leader": "$"
                }
            }, '\n                <span class="secondary">&nbsp;&nbsp;[', {
                "type": "references",
                "id": "pWord",
                "path": [ {
                    "type": "property",
                    "id": "phone"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "]</span>\n            " ], "\n        </h4>\n        ", {
                "type": "macro_call",
                "id": "list"
            }, "\n    " ], '\n    <p class="secondary source">\n        以上来源于:', {
                "type": "references",
                "id": "source",
                "path": [ {
                    "type": "property",
                    "id": "name"
                } ],
                "leader": "$",
                "prue": true
            }, "\n    ", "</p>\n</div>" ]).render(_data);
        },
        "init": function init() {}
    };
});
define("/output/ee/ee", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            _data = tpHelper.mixin(_data, {
                "_foreach": Object.create(utils._foreach),
                "_foreachSimilar": Object.create(utils._foreach),
                "_foreachExam": Object.create(utils._foreach),
                "word": {
                    "_getHeadword": function() {
                        return this["return-phrase"]["l"]["i"];
                    },
                    "_getHTMLValidText": function(dataString) {
                        return tpHelper.html.escape(dataString);
                    }
                }
            });
            return tpHelper.vm([ [ {
                "type": "macro",
                "id": "everyTR",
                "args": [ {
                    "type": "references",
                    "id": "perTr",
                    "leader": "$"
                } ]
            }, "\n<span>", {
                "type": "references",
                "id": "perTr",
                "path": [ {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "</span>\n", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perTr",
                    "path": [ {
                        "type": "property",
                        "id": "exam"
                    } ],
                    "leader": "$"
                }
            }, "\n    ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "exams",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "perTr",
                    "path": [ {
                        "type": "property",
                        "id": "exam"
                    }, {
                        "type": "property",
                        "id": "i"
                    }, {
                        "type": "property",
                        "id": "f"
                    }, {
                        "type": "property",
                        "id": "l"
                    } ],
                    "leader": "$"
                } ]
            }, "\n    ", {
                "type": "references",
                "id": "_foreachExam",
                "path": [ {
                    "type": "method",
                    "id": "start",
                    "args": [ {
                        "type": "integer",
                        "value": "1"
                    } ]
                } ],
                "leader": "$",
                "prue": true
            }, "\n    ", '<p class="secondary">\n    ', [ {
                "type": "foreach",
                "to": "perExam",
                "from": {
                    "type": "references",
                    "id": "exams",
                    "leader": "$"
                }
            }, "\n        ", {
                "type": "references",
                "id": "perExam",
                "path": [ {
                    "type": "property",
                    "id": "i"
                } ],
                "leader": "$",
                "prue": true
            }, "\n        ", [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "_foreachExam",
                        "path": [ {
                            "type": "property",
                            "id": "count"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "references",
                        "id": "exams",
                        "path": [ {
                            "type": "property",
                            "id": "length"
                        } ],
                        "leader": "$"
                    } ],
                    "operator": "!="
                }
            }, "\n            &nbsp;&nbsp;;&nbsp;&nbsp;\n        " ], "\n    " ], "\n    </p>\n" ], "\n", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perTr",
                    "path": [ {
                        "type": "property",
                        "id": "similar-words"
                    } ],
                    "leader": "$"
                }
            }, '\n    <p class="secondary">同义词：\n        ', {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "similarWords",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "perTr",
                    "path": [ {
                        "type": "property",
                        "id": "similar-words"
                    } ],
                    "leader": "$"
                } ]
            }, "\n        ", {
                "type": "references",
                "id": "_foreachSimilar",
                "path": [ {
                    "type": "method",
                    "id": "start",
                    "args": [ {
                        "type": "integer",
                        "value": "1"
                    } ]
                } ],
                "leader": "$",
                "prue": true
            }, "\n        ", [ {
                "type": "foreach",
                "to": "perSimilarWord",
                "from": {
                    "type": "references",
                    "id": "similarWords",
                    "leader": "$"
                }
            }, '\n            <a class="clickable js-inline-clickable" href="javascript:void(0);">', {
                "type": "references",
                "id": "perSimilarWord",
                "path": [ {
                    "type": "property",
                    "id": "similar"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/a>\n            ", [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "_foreachSimilar",
                        "path": [ {
                            "type": "property",
                            "id": "count"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "references",
                        "id": "similarWords",
                        "path": [ {
                            "type": "property",
                            "id": "length"
                        } ],
                        "leader": "$"
                    } ],
                    "operator": "!="
                }
            }, '\n                <span class="grey">&nbsp;&nbsp;/&nbsp;&nbsp;</span>\n            ' ], "\n        " ], "\n    </p>\n" ], "\n" ], "\n\n", [ {
                "type": "macro",
                "id": "list"
            }, "\n<ul>\n    ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "allTrsArr",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "word",
                    "path": [ {
                        "type": "method",
                        "id": "gettrs",
                        "args": false
                    } ],
                    "leader": "$"
                } ]
            }, "\n    ", [ {
                "type": "foreach",
                "to": "trsArr",
                "from": {
                    "type": "references",
                    "id": "allTrsArr",
                    "leader": "$"
                }
            }, "\n        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "perTrs",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "trsArr",
                    "path": [ {
                        "type": "property",
                        "id": "tr"
                    } ],
                    "leader": "$"
                } ]
            }, "\n        <li>\n            ", [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "math",
                        "expression": [ {
                            "type": "math",
                            "expression": [ {
                                "type": "references",
                                "id": "trsArr",
                                "path": [ {
                                    "type": "property",
                                    "id": "pos"
                                } ],
                                "leader": "$"
                            } ],
                            "operator": "not"
                        } ],
                        "operator": "not"
                    }, {
                        "type": "math",
                        "expression": [ {
                            "type": "references",
                            "id": "trsArr",
                            "path": [ {
                                "type": "property",
                                "id": "pos"
                            } ],
                            "leader": "$"
                        }, {
                            "type": "string",
                            "value": ""
                        } ],
                        "operator": "!="
                    } ],
                    "operator": "&&"
                }
            }, '\n                <span class="title">', {
                "type": "references",
                "id": "trsArr",
                "path": [ {
                    "type": "property",
                    "id": "pos"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/span>\n            " ], "\n            <ul>\n                ", {
                "type": "references",
                "id": "_foreach",
                "path": [ {
                    "type": "method",
                    "id": "start",
                    "args": [ {
                        "type": "integer",
                        "value": "1"
                    } ]
                } ],
                "leader": "$",
                "prue": true
            }, "\n                ", [ {
                "type": "foreach",
                "to": "perTr",
                "from": {
                    "type": "references",
                    "id": "perTrs",
                    "leader": "$"
                }
            }, '\n                    <li class="cols-layout">\n                        ', [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "perTrs",
                        "path": [ {
                            "type": "property",
                            "id": "length"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "integer",
                        "value": "1"
                    } ],
                    "operator": "<="
                }
            }, '\n                            <div class="col2">\n                                ', {
                "type": "macro_call",
                "id": "everyTR",
                "args": [ {
                    "type": "references",
                    "id": "perTr",
                    "leader": "$"
                } ]
            }, "\n                            </div>\n                        ", {
                "type": "else"
            }, "\n                            ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "order",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "_foreach",
                    "path": [ {
                        "type": "property",
                        "id": "count"
                    } ],
                    "isWraped": true,
                    "leader": "$"
                } ]
            }, '\n                            <span class="col1 order">', {
                "type": "references",
                "id": "order",
                "leader": "$",
                "prue": true
            }, ".", '</span>\n                            <div class="col2">\n                                ', {
                "type": "macro_call",
                "id": "everyTR",
                "args": [ {
                    "type": "references",
                    "id": "perTr",
                    "leader": "$"
                } ]
            }, "\n                            </div>\n                        " ], "\n                    </li>\n                " ], "\n            </ul>\n        </li>\n    " ], "\n</ul>\n" ], '\n\n<div class="trans-container ee">\n    ', {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "eng",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "word",
                    "path": [ {
                        "type": "method",
                        "id": "_getHeadword",
                        "args": false
                    } ],
                    "leader": "$"
                } ]
            }, "\n    <h4>\n        ", {
                "type": "references",
                "id": "word",
                "path": [ {
                    "type": "method",
                    "id": "_getHTMLValidText",
                    "args": [ {
                        "type": "references",
                        "id": "eng",
                        "leader": "$"
                    } ]
                } ],
                "leader": "$",
                "prue": true
            }, "\n        ", [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "word",
                        "path": [ {
                            "type": "property",
                            "id": "phone"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "math",
                        "expression": [ {
                            "type": "references",
                            "id": "word",
                            "path": [ {
                                "type": "property",
                                "id": "phone"
                            } ],
                            "leader": "$"
                        }, {
                            "type": "string",
                            "value": "",
                            "isEval": true
                        } ],
                        "operator": "!="
                    } ],
                    "operator": "&&"
                }
            }, '\n            <span class= "phonetic">[', {
                "type": "references",
                "id": "word",
                "path": [ {
                    "type": "property",
                    "id": "phone"
                } ],
                "leader": "$",
                "prue": true
            }, "]", "</span>\n        " ], "\n    </h4>\n    ", {
                "type": "macro_call",
                "id": "list"
            }, '\n    <p class="secondary source">\n        以上来源于:\n        <a class="clickable" data-4log="', {
                "type": "references",
                "id": "source",
                "path": [ {
                    "type": "property",
                    "id": "name"
                } ],
                "leader": "$",
                "prue": true
            }, '"', ' target="_blank" href="', {
                "type": "references",
                "id": "source",
                "path": [ {
                    "type": "property",
                    "id": "url"
                } ],
                "leader": "$",
                "prue": true
            }, '"', ' rel="nofollow">', {
                "type": "references",
                "id": "source",
                "path": [ {
                    "type": "property",
                    "id": "name"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/a>\n    </p>\n    <!-- 英英翻译结束 -->\n</div>\n" ]).render(_data);
        },
        "init": function init() {}
    };
});
define("/output/example-typos/example-typos", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            return tpHelper.vm([ '<div class="trans-container typos">\n    <div class="error-typo">\n        <h4>您是不是要找：</h4>\n        ', [ {
                "type": "foreach",
                "to": "_typo",
                "from": {
                    "type": "references",
                    "id": "typo",
                    "leader": "$"
                }
            }, '\n            <p class="typo-rel">\n                <a class="title js-lj-inline-word" data-query="', {
                "type": "references",
                "id": "_typo",
                "path": [ {
                    "type": "property",
                    "id": "word"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '">', {
                "type": "references",
                "id": "_typo",
                "path": [ {
                    "type": "property",
                    "id": "word"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "</a> ：\n                ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "_typo",
                    "path": [ {
                        "type": "property",
                        "id": "trans"
                    } ],
                    "isWraped": true,
                    "leader": "$!"
                }
            }, "\n                    ", {
                "type": "references",
                "id": "_typo",
                "path": [ {
                    "type": "property",
                    "id": "trans"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "\n                " ], "\n            </p>\n        " ], "\n    </div>\n</div>\n\n" ]).render(_data);
        },
        "init": function init() {}
    };
});
define("/output/example-typos-tip/example-typos-tip", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            return tpHelper.vm([ '<div class="trans-container typos">\n    <div class="error-typo">\n        <h4>您是不是要找：</h4>\n        ', [ {
                "type": "foreach",
                "to": "_typo",
                "from": {
                    "type": "references",
                    "id": "typo",
                    "leader": "$"
                }
            }, '\n          <p class="typo-rel">\n              <a class="title js-lj-inline-word" data-query="', {
                "type": "references",
                "id": "_typo",
                "path": [ {
                    "type": "property",
                    "id": "word"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '" >', {
                "type": "references",
                "id": "_typo",
                "path": [ {
                    "type": "property",
                    "id": "word"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "</a> ：", {
                "type": "references",
                "id": "_typo",
                "path": [ {
                    "type": "property",
                    "id": "trans"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "\n          </p>\n        " ], "\n    </div>\n</div>\n" ]).render(_data);
        },
        "init": function init() {}
    };
});
define("/output/example_correction_type/example_correction_type", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            var htmlCode = "";
            with (_data || {}) {
                htmlCode += '<a href="#" class="js-example-type typos-tip" data-type="';
                htmlCode += _data.type;
                htmlCode += '">\n    <span class="';
                htmlCode += _data.type;
                htmlCode += '-typos-title">';
                htmlCode += _data.chrInput;
                htmlCode += '</span>\n    <p class="description">';
                htmlCode += _data.description;
                htmlCode += "</p>\n</a>\n\n";
            }
            return htmlCode;
        },
        "init": function init() {}
    };
});
define("/output/example_local_noresult/example_local_noresult", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            var htmlCode = "";
            with (_data || {}) {
                htmlCode += '<div class="trans-container offline-noResult example-offline-noResult" >\n    <img src="./src/images/offline_noResult.png">\n    <ul>\n        <li>抱歉离线模式下不能使用例句功能，请查看您的网络连接或代理设置。</li>\n    </ul>\n</div>\n';
            }
            return htmlCode;
        },
        "init": function init() {}
    };
});
define("/output/example_local_result/example_local_result", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            var htmlCode = "";
            with (_data || {}) {
                htmlCode += '<div class="trans-container example-offline" >\n    ';
                if (_data.error) {
                    htmlCode += '\n    <p class="net-error">目前无法连接服务器，请检查您的网络连接或者查看 <a class="clickable" href="http://cidian.youdao.com/help.jsp" target="_blank">FAQ页面</a> 。 </p>\n    ';
                }
                htmlCode += "\n</div>\n";
            }
            return htmlCode;
        },
        "init": function init() {}
    };
});
define("/output/example_network_error/example_network_error", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            var htmlCode = "";
            with (_data || {}) {
                htmlCode += '<div class="trans-container offline-noResult example-offline-noResult" >\n    <img src="./src/images/offline_noResult.png">\n    <ul>\n        <li>抱歉离线模式下不能使用例句功能，请查看您的网络连接或代理设置。</li>\n        <li>离线使用例句功能，请下载有道词典本地增强版<br><a class="clickable" target="_blank" href="http://cidian.youdao.com/zengqiang">点击下载&gt;&gt;</a></li>\n    </ul>\n</div>\n';
            }
            return htmlCode;
        },
        "init": function init() {}
    };
});
define("/output/example_welcome/example_welcome", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            var htmlCode = "";
            with (_data || {}) {
                htmlCode += '<div class="example-startpage">\n    <img src="./src/images/example-welcome.png">\n</div>';
            }
            return htmlCode;
        },
        "init": function init() {}
    };
});
define("/output/fanyi/fanyi", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            _data = tpHelper.mixin(_data, {
                "_foreach": Object.create(utils._foreach)
            });
            var htmlCode = "";
            with (_data || {}) {
                htmlCode += '<div class="trans-container fanyi">\n    <p id="r-orgin-t">';
                htmlCode += tpHelper.html.escape(_data["input"] || "");
                htmlCode += "</p>\n    <p>";
                htmlCode += _data["tran"] || "";
                htmlCode += '</p>\n    <p class="additional">以上翻译结果来自<a class="clickable" href="javascript:;" id="goTrans">机器翻译</a>，仅供参考。<a href="http://i.youdao.com/?p=4263/" title="了解机器翻译" target="_blank" class="need-help sp"></a></p>\n    <p class="additional">快速获取精准、人工翻译服务，建议选择有道 <a class="doctor-trans" href="http://f.youdao.com/?vendor=YoudaoDict.neokylin" target="_blank">专业翻译</a></p>\n</div>';
            }
            return htmlCode;
        },
        "init": function init() {
            $("#goTrans").click(function() {
                var text = $("#r-orgin-t").text();
                window.search("trans", [ text, 0 ], "deskdict.app_link");
            });
        }
    };
});
define("/output/fc/fc", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            _data = tpHelper.mixin(_data, {
                "_foreach": Object.create(utils._foreach),
                "getOnlineStatus": function() {
                    return global.status.online;
                }
            });
            return tpHelper.vm([ '<div class="trans-container fc">\n    ', [ {
                "type": "foreach",
                "to": "perWord",
                "from": {
                    "type": "references",
                    "id": "word",
                    "leader": "$"
                }
            }, "\n        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "allTrs",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "perWord",
                    "path": [ {
                        "type": "property",
                        "id": "trs"
                    } ],
                    "leader": "$"
                } ]
            }, '\n        <h2 class="wordbook-js">\n            <span class="keyword">\n                ', {
                "type": "references",
                "id": "perWord",
                "path": [ {
                    "type": "property",
                    "id": "return-phrase"
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '', [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "getOnlineStatus",
                    "leader": "$",
                    "args": false
                }
            }, '\n                           ' ], '\n            <div class="baav">\n                  ', [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "perWord",
                        "path": [ {
                            "type": "property",
                            "id": "phone"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "references",
                        "id": "getOnlineStatus",
                        "leader": "$",
                        "args": false
                    } ],
                    "operator": "&&"
                }
            }, '\n                      <span class="pronounce">\n                          ', {
                "type": "references",
                "id": "perWord",
                "path": [ {
                    "type": "property",
                    "id": "return-phrase"
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '<span class="phonetic">[', {
                "type": "references",
                "id": "perWord",
                "path": [ {
                    "type": "property",
                    "id": "phone"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, ']</span>\n                          <a href="', "#", '" title="真人发音"  role="dict_audio_js" class=" word-speech sp dictvoice voice-js js-ctlog"\n                             data-rel="http://dict.youdao.com/dictvoice?audio=', {
                "type": "references",
                "id": "perWord",
                "path": [ {
                    "type": "property",
                    "id": "speech"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '" data-ctype="dict.basic.fc.voice"></a>\n                      </span>\n                  ' ], "\n                  ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "getOnlineStatus",
                    "leader": "$",
                    "args": false
                }
            }, '\n                      <span class="global_voice" id="global_voice_span">\n                      <a id="global_voice" href="javascript:void(0)" title="全球发音"\n                       class="global-voice-icon js-ctlog" data-word="', {
                "type": "references",
                "id": "_word",
                "path": [ {
                    "type": "property",
                    "id": "return-phrase"
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '"\n                       data-ctype="target=global_voice_button"></a>&nbsp;全球发音\n                      </span>\n                  ' ], "\n             </div>\n        </h2>\n        <ul>\n            ", [ {
                "type": "foreach",
                "to": "perTr",
                "from": {
                    "type": "references",
                    "id": "allTrs",
                    "leader": "$"
                }
            }, "\n                ", [ {
                "type": "foreach",
                "to": "eTr",
                "from": {
                    "type": "references",
                    "id": "perTr",
                    "path": [ {
                        "type": "property",
                        "id": "tr"
                    } ],
                    "leader": "$"
                }
            }, "\n                    <li>\n                        ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perTr",
                    "path": [ {
                        "type": "property",
                        "id": "pos"
                    } ],
                    "leader": "$"
                }
            }, "\n                            <span>[", {
                "type": "references",
                "id": "perTr",
                "path": [ {
                    "type": "property",
                    "id": "pos"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "]</span>\n                        " ], "\n                        ", {
                "type": "references",
                "id": "eTr",
                "path": [ {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "leader": "$",
                "prue": true
            }, "\n                        ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perTr",
                    "path": [ {
                        "type": "property",
                        "id": "pluriel"
                    } ],
                    "leader": "$"
                }
            }, '\n                            <p class="secondary">复数形式：', {
                "type": "references",
                "id": "perTr",
                "path": [ {
                    "type": "property",
                    "id": "pluriel"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/p>\n                        " ], "\n                    </li>\n                " ], "\n            " ], "\n        </ul>\n    " ], "\n</div>" ]).render(_data);
        },
        "init": function init() {}
    };
});
define("/output/global_voice/global_voice", function(require, exports, module) {

});
define("/output/hh/hh", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            _data = tpHelper.mixin(_data, {
                "_foreach": Object.create(utils._foreach),
                "_foreachWord": Object.create(utils._foreach),
                "_getExam": function(exams) {
                    var examItem = exams.map(function(element) {
                        return typeof element == "object" ? "<b>" + element["#text"] + "</b>" : element;
                    });
                    return examItem.join("");
                }
            });
            return tpHelper.vm([ [ {
                "type": "macro",
                "id": "list"
            }, "\n    ", [ {
                "type": "foreach",
                "to": "perWord",
                "from": {
                    "type": "references",
                    "id": "word",
                    "leader": "$"
                }
            }, "\n        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "orderWord",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "_foreachWord",
                    "path": [ {
                        "type": "property",
                        "id": "count"
                    } ],
                    "leader": "$"
                } ]
            }, "\n    <h4>\n        ", {
                "type": "references",
                "id": "perWord",
                "path": [ {
                    "type": "property",
                    "id": "key"
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "\n        ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perWord",
                    "path": [ {
                        "type": "property",
                        "id": "phone"
                    } ],
                    "leader": "$"
                }
            }, "\n            <small>[", {
                "type": "references",
                "id": "perWord",
                "path": [ {
                    "type": "property",
                    "id": "phone"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "]</small>\n        " ], "\n    </h4>\n        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "allTrs",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "perWord",
                    "path": [ {
                        "type": "property",
                        "id": "trs"
                    }, {
                        "type": "property",
                        "id": "tr"
                    } ],
                    "leader": "$"
                } ]
            }, "\n        ", {
                "type": "references",
                "id": "_foreach",
                "path": [ {
                    "type": "method",
                    "id": "start",
                    "args": [ {
                        "type": "integer",
                        "value": "1"
                    } ]
                } ],
                "leader": "$",
                "prue": true
            }, "\n    ", "<ul>\n        ", [ {
                "type": "foreach",
                "to": "perTr",
                "from": {
                    "type": "references",
                    "id": "allTrs",
                    "leader": "$"
                }
            }, "\n            ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "order",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "_foreach",
                    "path": [ {
                        "type": "property",
                        "id": "count"
                    } ],
                    "leader": "$"
                } ]
            }, '\n            <li class="cols-layout">\n                <span class="col1 order">', {
                "type": "references",
                "id": "order",
                "leader": "$",
                "prue": true
            }, ".", '</span>\n\n                <div class="col2">\n                    <p>', {
                "type": "references",
                "id": "perTr",
                "path": [ {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/p>\n                    ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perTr",
                    "path": [ {
                        "type": "property",
                        "id": "exam"
                    } ],
                    "leader": "$"
                }
            }, "\n                        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "allExams",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "perTr",
                    "path": [ {
                        "type": "property",
                        "id": "exam"
                    }, {
                        "type": "property",
                        "id": "i"
                    } ],
                    "leader": "$"
                } ]
            }, "\n                        ", [ {
                "type": "foreach",
                "to": "perExam",
                "from": {
                    "type": "references",
                    "id": "allExams",
                    "leader": "$"
                }
            }, "\n                            ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "perExamItem",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "perExam",
                    "path": [ {
                        "type": "property",
                        "id": "n"
                    }, {
                        "type": "property",
                        "id": "l"
                    }, {
                        "type": "property",
                        "id": "i"
                    } ],
                    "leader": "$"
                } ]
            }, '\n                            <p class="secondary">', {
                "type": "references",
                "id": "_getExam",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "perExamItem",
                    "leader": "$"
                } ],
                "prue": true
            }, "<", "/p>\n                        " ], "\n                    " ], "\n                </div>\n            </li>\n        " ], "\n    </ul>\n    " ], "\n" ], '\n\n<div class="trans-container hh">\n    ', {
                "type": "macro_call",
                "id": "list"
            }, "\n    ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "source",
                    "leader": "$"
                }
            }, '\n        <p class="secondary source">以上来源于：', {
                "type": "references",
                "id": "source",
                "path": [ {
                    "type": "property",
                    "id": "name"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/p>\n    " ], "\n</div>" ]).render(_data);
        },
        "init": function init() {}
    };
});
define("/output/indexpageAds/indexpageAds", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            var htmlCode = "";
            with (_data || {}) {
                htmlCode += '<a href="';
                htmlCode += _data.link;
                htmlCode += '" target="_blank">\n';
                if (_data.mimeType == "jpg" || _data.mimeType == "jpeg" || _data.mimeType == "gif" || _data.mimeType == "png" || _data.mimeType == "image/jpg" || _data.mimeType == "image/gif" || _data.mimeType == "image/png") {
                    htmlCode += '\n<p class="list1">';
                    htmlCode += _data.title;
                    htmlCode += '</p>\n<p class="list2">';
                    htmlCode += _data.desc;
                    htmlCode += '<ins></ins><a class="more-info" href="';
                    htmlCode += _data.link;
                    htmlCode += '" target="_blank">去了解更多<span></span></a></p>\n';
                } else if (_data.mimeType == "swf" || _data.mimeType == "application/x-shockwave-flash") {
                    htmlCode += "\n                                      \n                                                                                                                                                                                  \n                                                          \n             \n                                                         \n";
                }
                htmlCode += "\n</a>\n\n\n";
            }
            return htmlCode;
        },
        "init": function init() {}
    };
});
define("/output/infomation_stream/infomation_stream", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            _data = tpHelper.mixin(_data, {
                "_getCurrentData": function(searchAllItem, searchPerNum, curPage) {
                    var curData = [];
                    var group = curPage * searchPerNum - 1;
                    var startPage = searchPerNum * (curPage - 1);
                    for (var i = startPage; i < searchAllItem.length; i++) {
                        if (i <= group) {
                            curData.push(searchAllItem[i]);
                        }
                    }
                    return curData;
                },
                "_isFirstPage": function(curPage) {
                    if (curPage == 1) {
                        return true;
                    }
                },
                "_isLastPage": function(curPage, allPage) {
                    if (curPage == allPage) {
                        return true;
                    }
                },
                "_isOnlyOnePage": function(allPage) {
                    if (allPage == 1) {
                        return true;
                    }
                },
                "_getTopData": function(data) {
                    var date = data[data.length - 1].newDate || data[data.length - 1].curDate;
                    for (var i in data) {
                        if (data[i].style === "oral-pk") {
                            return [ data[i], date ];
                        }
                    }
                    return null;
                }
            });
            var htmlCode = "";
            with (_data || {}) {
                (function(_data) {
                    var styles = [ "business", "trend", "science", "travel", "study", "cet", "zhihu", "movie", "image", "tofel", "tech", "joke", "micro", "music", "oral", "life", "article", "daily", "bilingual", "card", "huihui", "media", "oral-practice", "overseas", "news", "activites", "other", "test", "activities", "youngcrop", "try"];
                    htmlCode += "\n";
                    if (styles.indexOf(_data.style) !== -1) {
                        htmlCode += "\n    ";
                        if (_data.id) {
                            htmlCode += '\n        <div id="item-';
                            htmlCode += _data.id;
                            htmlCode += '" class="style-';
                            htmlCode += _data.style;
                            htmlCode += ' water-card">\n            <a class="info_log_js" target="_blank" data-type="';
                            htmlCode += _data.style;
                            htmlCode += '"\n               href="';
                            htmlCode += _data.style === "daily" ? "http://xue.youdao.com/w" : _data.url || "http://xue.youdao.com/sw/";
                            htmlCode += '" >\n                <div class="img-mod card-default">\n                    ';
                            var imgDesk = _data["image-desk2"] || "";
                            htmlCode += '\n                    <img class="stream-img" src="';
                            htmlCode += imgDesk;
                            htmlCode += '">\n                    <span class="';
                            htmlCode += _data.style;
                            htmlCode += "-card text";
                            htmlCode += _data.type.length;
                            htmlCode += ' card-title">';
                            htmlCode += _data.type;
                            htmlCode += '</span>\n                </div>\n                <div class="content-mod">\n                    <p class="list-part p1  js-contextmenu-free">\n                        <span data-type="';
                            htmlCode += _data.style;
                            htmlCode += '" >\n                            ';
                            htmlCode += _data.title ? _data.title : "";
                            htmlCode += '\n                        </span>\n                    </p>\n                    <p class="list-part p2 js-contextmenu-free">\n                        ';
                            htmlCode += _data.summary ? _data.summary : "";
                            htmlCode += '\n                    </p>\n                    <p class="list-part p3">\n                        ';
                            if (_data.showlike) {
                                htmlCode += '\n                            <span class="card-like"></span><span class="count">';
                                htmlCode += _data.like || 0;
                                htmlCode += "</span>\n                        ";
                            }
                            htmlCode += "\n                        ";
                            if (_data.showcomment) {
                                htmlCode += '\n                             <span class="card-comment"></span><span class="count">';
                                htmlCode += _data.comment || 0;
                                htmlCode += "</span>\n                        ";
                            }
                            htmlCode += "\n                    </p>\n                </div>\n            </a>\n        </div>\n    ";
                        }
                        htmlCode += "\n";

                    }
                })(_data);
            }
            return htmlCode;
        },
        "init": function init() {}
    };
});
define("/output/jc/jc", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            _data = tpHelper.mixin(_data, {
                "_foreach": Object.create(utils._foreach),
                "_foreachTr": Object.create(utils._foreach),
                "_isObjectPro": function(obj) {
                    return obj === Object(obj);
                },
                "_getExam": function(exams) {
                    var ret = "";
                    for (var i = 0; i < exams.length; i++) {
                        if (this._isObjectPro(exams[i]) && (exams[i]["#text"] || exams[i]["@action"])) {
                            ret += "<strong>" + exams[i]["#text"].toString() + "</strong>";
                        } else {
                            if (exams[i] === null) {
                                ret += "";
                            } else {
                                ret += exams[i];
                            }
                        }
                    }
                    return ret;
                },
                "getOnlineStatus": function() {
                    return global.status.online;
                }
            });
            return tpHelper.vm([ [ {
                "type": "macro",
                "id": "showPerTrs",
                "args": [ {
                    "type": "references",
                    "id": "perTr",
                    "leader": "$"
                } ]
            }, "\n    ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perTr",
                    "path": [ {
                        "type": "property",
                        "id": "pos"
                    } ],
                    "leader": "$"
                }
            }, "\n    <span>[", {
                "type": "references",
                "id": "perTr",
                "path": [ {
                    "type": "property",
                    "id": "pos"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "]</span>\n    " ], "\n<ul>\n    ", {
                "type": "references",
                "id": "_foreachTr",
                "path": [ {
                    "type": "method",
                    "id": "start",
                    "args": [ {
                        "type": "integer",
                        "value": "1"
                    } ]
                } ],
                "leader": "$",
                "prue": true
            }, "\n    ", [ {
                "type": "foreach",
                "to": "eTr",
                "from": {
                    "type": "references",
                    "id": "perTr",
                    "path": [ {
                        "type": "property",
                        "id": "tr"
                    } ],
                    "leader": "$"
                }
            }, '\n        <li class="cols-layout">\n            ', [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "perTr",
                        "path": [ {
                            "type": "property",
                            "id": "tr"
                        }, {
                            "type": "property",
                            "id": "length"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "integer",
                        "value": "1"
                    } ],
                    "operator": ">"
                }
            }, '\n                <span class="col1">', {
                "type": "references",
                "id": "_foreachTr",
                "path": [ {
                    "type": "property",
                    "id": "count"
                } ],
                "leader": "$",
                "prue": true
            }, ".", "</span>\n            " ], '\n            <div class="col2">\n                <p>', {
                "type": "references",
                "id": "eTr",
                "path": [ {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/p>\n                ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "eTr",
                    "path": [ {
                        "type": "property",
                        "id": "exam"
                    } ],
                    "leader": "$"
                }
            }, '\n                    <div class="col2 cols-layout">\n                        <span class="col1 colExam">例证：</span>\n                        <ul  class=" col2 secondary">\n                            ', [ {
                "type": "foreach",
                "to": "perExam",
                "from": {
                    "type": "references",
                    "id": "eTr",
                    "path": [ {
                        "type": "property",
                        "id": "exam"
                    }, {
                        "type": "property",
                        "id": "i"
                    } ],
                    "leader": "$"
                }
            }, "\n                                <li>\n                                    <span>", {
                "type": "references",
                "id": "_getExam",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "perExam",
                    "path": [ {
                        "type": "property",
                        "id": "f"
                    }, {
                        "type": "property",
                        "id": "l"
                    }, {
                        "type": "property",
                        "id": "i"
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, "<", "/span> / <span>", {
                "type": "references",
                "id": "perExam",
                "path": [ {
                    "type": "property",
                    "id": "n"
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/span>\n                                </li>\n                            " ], "\n                        </ul>\n                    </div>\n                " ], "\n            </div>\n        </li>\n    " ], "\n</ul>\n" ], '\n<div class="trans-container jc">\n    <h2>\n        <span class="keyword">\n            ', {
                "type": "references",
                "id": "word",
                "path": [ {
                    "type": "index",
                    "id": {
                        "type": "integer",
                        "value": "0"
                    }
                }, {
                    "type": "property",
                    "id": "return-phrase"
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '', [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "getOnlineStatus",
                    "leader": "$",
                    "args": false
                }
            }, '\n                ' ], "\n    </h2>\n    ", [ {
                "type": "foreach",
                "to": "perWord",
                "from": {
                    "type": "references",
                    "id": "word",
                    "leader": "$"
                }
            }, "\n        <h4>", {
                "type": "references",
                "id": "perWord",
                "path": [ {
                    "type": "index",
                    "id": {
                        "type": "string",
                        "value": "return-phrase"
                    }
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "leader": "$",
                "prue": true
            }, "\n            ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perWord",
                    "path": [ {
                        "type": "property",
                        "id": "phonesup"
                    } ],
                    "leader": "$"
                }
            }, "\n                <sup>", {
                "type": "references",
                "id": "perWord",
                "path": [ {
                    "type": "property",
                    "id": "phonesup"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "</sup>\n            " ], "\n            ", [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "perWord",
                        "path": [ {
                            "type": "property",
                            "id": "speech"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "references",
                        "id": "getOnlineStatus",
                        "leader": "$",
                        "args": false
                    } ],
                    "operator": "&&"
                }
            }, '\n                <span class="pronounce">\n                    <a href="', "#", '" title="真人发音" role=\'dict_audio_js\'\n                           data-rel="http://dict.youdao.com/dictvoice?audio=', {
                "type": "references",
                "id": "perWord",
                "path": [ {
                    "type": "property",
                    "id": "speech"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '"\n                           class="dictvoice  word-speech voice-js js-ctlog" data-ctype="dict.basic.jc.voice"></a>\n                </span>\n            ' ], "\n            ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perWord",
                    "path": [ {
                        "type": "property",
                        "id": "origin"
                    } ],
                    "leader": "$"
                }
            }, '\n                <span class="origin">【', {
                "type": "references",
                "id": "perWord",
                "path": [ {
                    "type": "property",
                    "id": "origin"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "】</span>\n            " ], "\n        </h4>\n        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "allTrs",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "perWord",
                    "path": [ {
                        "type": "property",
                        "id": "trs"
                    } ],
                    "leader": "$"
                } ]
            }, "\n        ", {
                "type": "references",
                "id": "_foreach",
                "path": [ {
                    "type": "method",
                    "id": "start",
                    "args": [ {
                        "type": "integer",
                        "value": "1"
                    } ]
                } ],
                "leader": "$",
                "prue": true
            }, "\n        ", [ {
                "type": "foreach",
                "to": "perTr",
                "from": {
                    "type": "references",
                    "id": "allTrs",
                    "leader": "$"
                }
            }, '\n            <ul>\n                <li class="cols-layout">\n                    ', [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "allTrs",
                        "path": [ {
                            "type": "property",
                            "id": "length"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "integer",
                        "value": "1"
                    } ],
                    "operator": ">"
                }
            }, "\n                        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "order",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "_foreach",
                    "path": [ {
                        "type": "property",
                        "id": "count"
                    } ],
                    "isWraped": true,
                    "leader": "$!"
                } ]
            }, '\n                        <span class="col1">', {
                "type": "references",
                "id": "order",
                "leader": "$",
                "prue": true
            }, ".", "</span>\n                    " ], '\n                        <div class="col2">', {
                "type": "macro_call",
                "id": "showPerTrs",
                "args": [ {
                    "type": "references",
                    "id": "perTr",
                    "leader": "$"
                } ]
            }, "</div>\n                </li>\n            </ul>\n        " ], "\n    " ], "\n</div>" ]).render(_data);
        },
        "init": function init() {}
    };
});
define("/output/kc/kc", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            _data = tpHelper.mixin(_data, {
                "_foreach": Object.create(utils._foreach),
                "_foreachTr": Object.create(utils._foreach),
                "joinArray": function(type) {
                    return type.join(" ");
                },
                "_isObjectPro": function(obj) {
                    return obj === Object(obj);
                },
                "_getExam": function(exams) {
                    var ret = "";
                    for (var i = 0; i < exams.length; i++) {
                        if (this._isObjectPro(exams[i]) && (exams[i]["#text"] || exams[i]["@action"])) {
                            ret += "<strong>" + exams[i]["#text"].toString() + "</strong>";
                        } else {
                            if (exams[i] === null) {
                                ret += "";
                            } else {
                                ret += exams[i];
                            }
                        }
                    }
                    return ret;
                },
                "getOnlineStatus": function() {
                    return global.status.online;
                }
            });
            return tpHelper.vm([ [ {
                "type": "macro",
                "id": "showPerTrs",
                "args": [ {
                    "type": "references",
                    "id": "perTr",
                    "leader": "$"
                } ]
            }, "\n", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perTr",
                    "path": [ {
                        "type": "property",
                        "id": "pos"
                    } ],
                    "leader": "$"
                }
            }, "\n<span>[", {
                "type": "references",
                "id": "perTr",
                "path": [ {
                    "type": "property",
                    "id": "pos"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "]</span>\n" ], "\n<ul>\n    ", {
                "type": "references",
                "id": "_foreachTr",
                "path": [ {
                    "type": "method",
                    "id": "start",
                    "args": [ {
                        "type": "integer",
                        "value": "1"
                    } ]
                } ],
                "leader": "$",
                "prue": true
            }, "\n    ", [ {
                "type": "foreach",
                "to": "eTr",
                "from": {
                    "type": "references",
                    "id": "perTr",
                    "path": [ {
                        "type": "property",
                        "id": "tr"
                    } ],
                    "leader": "$"
                }
            }, '\n        <li class="cols-layout">\n            ', [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "perTr",
                        "path": [ {
                            "type": "property",
                            "id": "tr"
                        }, {
                            "type": "property",
                            "id": "length"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "integer",
                        "value": "1"
                    } ],
                    "operator": ">"
                }
            }, '\n                <span class="col1 order">', {
                "type": "references",
                "id": "_foreachTr",
                "path": [ {
                    "type": "property",
                    "id": "count"
                } ],
                "leader": "$",
                "prue": true
            }, ".", "</span>\n            " ], '\n            <div class="col2">\n                <p>', {
                "type": "references",
                "id": "eTr",
                "path": [ {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/p>\n                ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "eTr",
                    "path": [ {
                        "type": "property",
                        "id": "exam"
                    } ],
                    "leader": "$"
                }
            }, "\n                    <ul>\n                        ", [ {
                "type": "foreach",
                "to": "perExam",
                "from": {
                    "type": "references",
                    "id": "eTr",
                    "path": [ {
                        "type": "property",
                        "id": "exam"
                    }, {
                        "type": "property",
                        "id": "i"
                    } ],
                    "leader": "$"
                }
            }, '\n                            <li class="secondary cols-layout">\n                                <span class="col1 colExam">用例：</span>\n                                <div class="col2">\n                                    <p>\n                                      ', {
                "type": "references",
                "id": "_getExam",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "perExam",
                    "path": [ {
                        "type": "property",
                        "id": "f"
                    }, {
                        "type": "property",
                        "id": "l"
                    }, {
                        "type": "property",
                        "id": "i"
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, "\n                                    ", "</p>\n                                    <p>", {
                "type": "references",
                "id": "perExam",
                "path": [ {
                    "type": "property",
                    "id": "n"
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/p>\n                                </div>\n                            </li>\n                        " ], "\n                    </ul>\n                " ], "\n            </div>\n        </li>\n    " ], "\n</ul>\n" ], '\n<div class="trans-container kc">\n    <h2 class="wordbook-js">\n        <span class="keyword">\n            ', {
                "type": "references",
                "id": "word",
                "path": [ {
                    "type": "index",
                    "id": {
                        "type": "integer",
                        "value": "0"
                    }
                }, {
                    "type": "property",
                    "id": "return-phrase"
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '', [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "getOnlineStatus",
                    "leader": "$",
                    "args": false
                }
            }, '\n                 ' ], "\n    </h2>\n    ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "counts",
                    "leader": "$"
                }, {
                    "type": "integer",
                    "value": "1"
                } ]
            }, "\n    ", [ {
                "type": "foreach",
                "to": "perWord",
                "from": {
                    "type": "references",
                    "id": "word",
                    "leader": "$"
                }
            }, "\n        <h4>", {
                "type": "references",
                "id": "perWord",
                "path": [ {
                    "type": "index",
                    "id": {
                        "type": "string",
                        "value": "return-phrase"
                    }
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "leader": "$",
                "prue": true
            }, "\n            ", [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "counts",
                        "leader": "$"
                    }, {
                        "type": "integer",
                        "value": "1"
                    } ],
                    "operator": "=="
                }
            }, "\n                ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "getOnlineStatus",
                    "leader": "$",
                    "args": false
                }
            }, '\n                    <span class="pronounce">\n                      <a href="', "#", '" title="真人发音" role="dict_audio_js"\n                         class="sp  word-speech dictvoice voice-js js-ctlog"\n                         data-rel="http://dict.youdao.com/dictvoice?audio=', {
                "type": "references",
                "id": "perWord",
                "path": [ {
                    "type": "property",
                    "id": "speech"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '"\n                         data-ctype="dict.basic.kc.voice"></a>\n                    </span>\n                 ' ], "\n            " ], "\n        </h4>\n        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "counts",
                    "leader": "$"
                }, {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "counts",
                        "leader": "$"
                    }, {
                        "type": "integer",
                        "value": "1"
                    } ],
                    "operator": "+"
                } ]
            }, "\n        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "allTrs",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "perWord",
                    "path": [ {
                        "type": "property",
                        "id": "trs"
                    } ],
                    "leader": "$"
                } ]
            }, "\n        ", {
                "type": "references",
                "id": "_foreach",
                "path": [ {
                    "type": "method",
                    "id": "start",
                    "args": [ {
                        "type": "integer",
                        "value": "1"
                    } ]
                } ],
                "leader": "$",
                "prue": true
            }, "\n        ", [ {
                "type": "foreach",
                "to": "perTr",
                "from": {
                    "type": "references",
                    "id": "allTrs",
                    "leader": "$"
                }
            }, '\n            <ul>\n                <li class="cols-layout">\n                    ', [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "allTrs",
                        "path": [ {
                            "type": "property",
                            "id": "length"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "integer",
                        "value": "1"
                    } ],
                    "operator": ">"
                }
            }, "\n                        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "order",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "_foreach",
                    "path": [ {
                        "type": "property",
                        "id": "count"
                    } ],
                    "isWraped": true,
                    "leader": "$!"
                } ]
            }, '\n                        <span class="col1 order">', {
                "type": "references",
                "id": "order",
                "leader": "$",
                "prue": true
            }, ".", "</span>\n                    " ], '\n                    <div class="col2">', {
                "type": "macro_call",
                "id": "showPerTrs",
                "args": [ {
                    "type": "references",
                    "id": "perTr",
                    "leader": "$"
                } ]
            }, "</div>\n                </li>\n            </ul>\n        " ], "\n        ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perWord",
                    "path": [ {
                        "type": "property",
                        "id": "syno"
                    } ],
                    "leader": "$"
                }
            }, '\n            <p class="secondary">同义词： ', {
                "type": "references",
                "id": "joinArray",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "perWord",
                    "path": [ {
                        "type": "property",
                        "id": "syno"
                    }, {
                        "type": "property",
                        "id": "i"
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, "<", "/p>\n        " ], "\n        ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perWord",
                    "path": [ {
                        "type": "property",
                        "id": "deri"
                    } ],
                    "leader": "$"
                }
            }, '\n            <p class="secondary">衍生词： ', {
                "type": "references",
                "id": "joinArray",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "perWord",
                    "path": [ {
                        "type": "property",
                        "id": "deri"
                    }, {
                        "type": "property",
                        "id": "i"
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, "<", "/p>\n        " ], "\n    " ], "\n</div>" ]).render(_data);
        },
        "init": function init() {}
    };
});
define("/output/lang_err/lang_err", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            return tpHelper.vm([ '<div class="trans-container lang_err"><div class="error-typo">\n    <h4>您的查询在<span class="js-typo-lang" data-lang="', {
                "type": "references",
                "id": "lang",
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '"></span>下没有结果，以下为<span class="js-typo-tarLang" data-tarlang="', {
                "type": "references",
                "id": "tarLang",
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '"></span>结果\n    </h4>\n    </div>\n</div>' ]).render(_data);
        },
        "init": function init() {
            /**
 * 语种typo
 */
            (function() {
                var lang = $(".js-typo-lang").data("lang"), tarLang = $(".js-typo-tarLang").data("tarlang");
                var abbr2Chinese = function(abbr) {
                    switch (abbr) {
                      case "fr":
                        return "汉法互译";

                      case "ko":
                        return "汉韩互译";

                      case "jap":
                        return "汉日互译";

                      case "eng":
                        return "汉英互译";
                    }
                };
                $(".js-typo-lang").text(abbr2Chinese(lang));
                $(".js-typo-tarLang").text(abbr2Chinese(tarLang));
                return false;
            })();
        }
    };
});
define("/output/media_sents/media_sents", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            _data = tpHelper.mixin(_data, {
                "_getSpokenSens": function(sentences) {
                    return sentences.replace("</b>", "").replace("<b>", "").replace("<br>", "").replace("<br/>", "").replace(/\"|\"/g, "&quot;").replace(/\'|\'/g, "&apos;");
                },
                "_getEng": function(sentences) {
                    var sen = sentences.replace("<br>", "").replace("<br/>", "");
                    return sen;
                }
            });
            return tpHelper.vm([ '<div class="trans-container media_sents">\n    <ul>\n        ', [ {
                "type": "foreach",
                "to": "perSent",
                "from": {
                    "type": "references",
                    "id": "sent",
                    "leader": "$"
                }
            }, '\n            <li class="cols-layout">\n                <span class="col1 order">', {
                "type": "references",
                "id": "foreach",
                "path": [ {
                    "type": "property",
                    "id": "count"
                } ],
                "isWraped": true,
                "leader": "$",
                "prue": true
            }, '.</span>\n                <div class="col2">\n                    ', [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "perSent",
                        "path": [ {
                            "type": "index",
                            "id": {
                                "type": "string",
                                "value": "@mediatype"
                            }
                        } ],
                        "leader": "$"
                    }, {
                        "type": "string",
                        "value": "audio"
                    } ],
                    "operator": "=="
                }
            }, "\n                        <p>\n                            ", {
                "type": "references",
                "id": "_getEng",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "perSent",
                    "path": [ {
                        "type": "property",
                        "id": "eng"
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, "\n                            ", '<a class="sp humanvoice humanvoice-js js-ctlog" data-ctype="例句发音_真人"  role="dict_audio_js"  title="点击发音"\n                               href="javascript:;" data-rel="', {
                "type": "references",
                "id": "perSent",
                "path": [ {
                    "type": "property",
                    "id": "snippets"
                }, {
                    "type": "property",
                    "id": "snippet"
                }, {
                    "type": "index",
                    "id": {
                        "type": "integer",
                        "value": "0"
                    }
                }, {
                    "type": "property",
                    "id": "streamUrl"
                } ],
                "leader": "$",
                "prue": true
            }, '"', '\n                            ></a>\n                            <a href="javascript:;" title="口语练习"\n                                data-rel="', {
                "type": "references",
                "id": "perSent",
                "path": [ {
                    "type": "property",
                    "id": "snippets"
                }, {
                    "type": "property",
                    "id": "snippet"
                }, {
                    "type": "index",
                    "id": {
                        "type": "integer",
                        "value": "0"
                    }
                }, {
                    "type": "property",
                    "id": "streamUrl"
                } ],
                "leader": "$",
                "prue": true
            }, '"', '\n                                class="js-record spoken-record sentences_record js-ctlog"\n                                data-ctype="跟读_例句_原声例句"  data-format="audio"\n                                data-sentences="', {
                "type": "references",
                "id": "_getSpokenSens",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "perSent",
                    "path": [ {
                        "type": "property",
                        "id": "eng"
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, '"', ">跟读</a>\n                        </p>\n\n                        ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perSent",
                    "path": [ {
                        "type": "property",
                        "id": "chn"
                    } ],
                    "leader": "$"
                }
            }, "\n                            <p>", {
                "type": "references",
                "id": "perSent",
                "path": [ {
                    "type": "property",
                    "id": "chn"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "p>\n                        " ], "\n\n                    ", {
                "type": "elseif",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "perSent",
                        "path": [ {
                            "type": "index",
                            "id": {
                                "type": "string",
                                "value": "@mediatype"
                            }
                        } ],
                        "leader": "$"
                    }, {
                        "type": "string",
                        "value": "video"
                    } ],
                    "operator": "=="
                }
            }, "\n                        <p>", {
                "type": "references",
                "id": "_getEng",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "perSent",
                    "path": [ {
                        "type": "property",
                        "id": "eng"
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, "\n                            ", '<a href="javascript:;" title="口语练习"\n                               data-rel="', {
                "type": "references",
                "id": "perSent",
                "path": [ {
                    "type": "property",
                    "id": "snippets"
                }, {
                    "type": "property",
                    "id": "snippet"
                }, {
                    "type": "index",
                    "id": {
                        "type": "integer",
                        "value": "0"
                    }
                }, {
                    "type": "property",
                    "id": "swf"
                } ],
                "leader": "$",
                "prue": true
            }, "?", {
                "type": "references",
                "id": "perSent",
                "path": [ {
                    "type": "property",
                    "id": "snippets"
                }, {
                    "type": "property",
                    "id": "snippet"
                }, {
                    "type": "index",
                    "id": {
                        "type": "integer",
                        "value": "0"
                    }
                }, {
                    "type": "property",
                    "id": "streamUrl"
                } ],
                "leader": "$",
                "prue": true
            }, '"', '\n                               class="js-record spoken-record sentences_record js-ctlog"\n                               data-ctype="跟读_例句_视频"  data-format="video"\n                               data-sentences="', {
                "type": "references",
                "id": "_getSpokenSens",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "perSent",
                    "path": [ {
                        "type": "property",
                        "id": "eng"
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, '"', ">跟读</a>\n                        </p>\n                        ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perSent",
                    "path": [ {
                        "type": "property",
                        "id": "chn"
                    } ],
                    "leader": "$"
                }
            }, "\n                            <p>", {
                "type": "references",
                "id": "perSent",
                "path": [ {
                    "type": "property",
                    "id": "chn"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "p>\n                        " ], '\n\n                          ' ], '\n                    <p class="secondary">\n                        ', {
                "type": "references",
                "id": "perSent",
                "path": [ {
                    "type": "property",
                    "id": "snippets"
                }, {
                    "type": "property",
                    "id": "snippet"
                }, {
                    "type": "index",
                    "id": {
                        "type": "integer",
                        "value": "0"
                    }
                }, {
                    "type": "property",
                    "id": "source"
                } ],
                "leader": "$",
                "prue": true
            }, " ", {
                "type": "references",
                "id": "perSent",
                "path": [ {
                    "type": "property",
                    "id": "snippets"
                }, {
                    "type": "property",
                    "id": "snippet"
                }, {
                    "type": "index",
                    "id": {
                        "type": "integer",
                        "value": "0"
                    }
                }, {
                    "type": "property",
                    "id": "name"
                } ],
                "leader": "$",
                "prue": true
            }, "\n                    ", "</p>\n                </div>\n            </li>\n        " ], "\n    </ul>\n</div>" ]).render(_data);
        },
        "init": function init() {}
    };
});
define("/output/media_sents_part/media_sents_part", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            _data = tpHelper.mixin(_data, {
                "_getSpokenSens": function(sentences) {
                    var sen = sentences.replace("<br>", "").replace("<br/>", "").replace("</b>", "").replace("<b>", "").replace(/\"|\"/g, "&quot;").replace(/\'|\'/g, "&apos;");
                    return sen;
                },
                "_getEng": function(sentences) {
                    var sen = sentences.replace("<br>", "").replace("<br/>", "");
                    return sen;
                }
            });
            return tpHelper.vm([ '<div class="trans-container media_sents_part">\n    <ul>\n        ', [ {
                "type": "foreach",
                "to": "perSent",
                "from": {
                    "type": "references",
                    "id": "sent",
                    "leader": "$"
                }
            }, '\n            <li class="cols-layout">\n                <span class="col1 order">', {
                "type": "references",
                "id": "foreach",
                "path": [ {
                    "type": "property",
                    "id": "count"
                } ],
                "isWraped": true,
                "leader": "$",
                "prue": true
            }, '.</span>\n                <div class="col2">\n                    ', [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "perSent",
                        "path": [ {
                            "type": "index",
                            "id": {
                                "type": "string",
                                "value": "@mediatype"
                            }
                        } ],
                        "leader": "$"
                    }, {
                        "type": "string",
                        "value": "audio"
                    } ],
                    "operator": "=="
                }
            }, "\n                        <p>\n                            ", {
                "type": "references",
                "id": "_getEng",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "perSent",
                    "path": [ {
                        "type": "property",
                        "id": "eng"
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, "\n                            ", '<a class="sp humanvoice humanvoice-js js-ctlog" data-ctype="例句发音_真人" role="dict_audio_js"  title="点击发音"\n                               href="', "#", '" data-rel="', {
                "type": "references",
                "id": "perSent",
                "path": [ {
                    "type": "property",
                    "id": "snippets"
                }, {
                    "type": "property",
                    "id": "snippet"
                }, {
                    "type": "index",
                    "id": {
                        "type": "integer",
                        "value": "0"
                    }
                }, {
                    "type": "property",
                    "id": "streamUrl"
                } ],
                "leader": "$",
                "prue": true
            }, '"', "\n                            ></a>\n                            ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "spoken",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "_getSpokenSens",
                    "leader": "$",
                    "args": [ {
                        "type": "references",
                        "id": "perSent",
                        "path": [ {
                            "type": "property",
                            "id": "eng"
                        } ],
                        "leader": "$"
                    } ]
                } ]
            }, '\n                            <a href="javascript:;" title="口语练习"\n                                data-rel="', {
                "type": "references",
                "id": "perSent",
                "path": [ {
                    "type": "property",
                    "id": "snippets"
                }, {
                    "type": "property",
                    "id": "snippet"
                }, {
                    "type": "index",
                    "id": {
                        "type": "integer",
                        "value": "0"
                    }
                }, {
                    "type": "property",
                    "id": "streamUrl"
                } ],
                "leader": "$",
                "prue": true
            }, '"', '\n                                class="js-record spoken-record sentences_record js-ctlog"\n                                data-ctype="跟读_例句_原声例句"  data-format="audio"\n                                data-sentences="', {
                "type": "references",
                "id": "spoken",
                "leader": "$",
                "prue": true
            }, '"', ">跟读</a>\n                        </p>\n\n                        ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perSent",
                    "path": [ {
                        "type": "property",
                        "id": "chn"
                    } ],
                    "leader": "$"
                }
            }, "\n                            <p>", {
                "type": "references",
                "id": "perSent",
                "path": [ {
                    "type": "property",
                    "id": "chn"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "p>\n                        " ], "\n                        \n                    ", {
                "type": "elseif",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "perSent",
                        "path": [ {
                            "type": "index",
                            "id": {
                                "type": "string",
                                "value": "@mediatype"
                            }
                        } ],
                        "leader": "$"
                    }, {
                        "type": "string",
                        "value": "video"
                    } ],
                    "operator": "=="
                }
            }, "\n                        <p>", {
                "type": "references",
                "id": "_getEng",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "perSent",
                    "path": [ {
                        "type": "property",
                        "id": "eng"
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, "\n                            ", '<a href="javascript:;" title="口语练习"\n                               data-rel="', {
                "type": "references",
                "id": "perSent",
                "path": [ {
                    "type": "property",
                    "id": "snippets"
                }, {
                    "type": "property",
                    "id": "snippet"
                }, {
                    "type": "index",
                    "id": {
                        "type": "integer",
                        "value": "0"
                    }
                }, {
                    "type": "property",
                    "id": "swf"
                } ],
                "leader": "$",
                "prue": true
            }, "?", {
                "type": "references",
                "id": "perSent",
                "path": [ {
                    "type": "property",
                    "id": "snippets"
                }, {
                    "type": "property",
                    "id": "snippet"
                }, {
                    "type": "index",
                    "id": {
                        "type": "integer",
                        "value": "0"
                    }
                }, {
                    "type": "property",
                    "id": "streamUrl"
                } ],
                "leader": "$",
                "prue": true
            }, '"', '\n                               class="js-record spoken-record sentences_record js-ctlog"\n                               data-ctype="跟读_例句_视频" data-format="video"\n                               data-sentences="', {
                "type": "references",
                "id": "_getSpokenSens",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "perSent",
                    "path": [ {
                        "type": "property",
                        "id": "eng"
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, '"', ">跟读</a>\n                        </p>\n                        ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "perSent",
                    "path": [ {
                        "type": "property",
                        "id": "chn"
                    } ],
                    "leader": "$"
                }
            }, "\n                            <p>", {
                "type": "references",
                "id": "perSent",
                "path": [ {
                    "type": "property",
                    "id": "chn"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "p>\n                        " ], '\n                        \n                                    ' ], '\n                    <p class="secondary">\n                        ', {
                "type": "references",
                "id": "perSent",
                "path": [ {
                    "type": "property",
                    "id": "snippets"
                }, {
                    "type": "property",
                    "id": "snippet"
                }, {
                    "type": "index",
                    "id": {
                        "type": "integer",
                        "value": "0"
                    }
                }, {
                    "type": "property",
                    "id": "source"
                } ],
                "leader": "$",
                "prue": true
            }, " ", {
                "type": "references",
                "id": "perSent",
                "path": [ {
                    "type": "property",
                    "id": "snippets"
                }, {
                    "type": "property",
                    "id": "snippet"
                }, {
                    "type": "index",
                    "id": {
                        "type": "integer",
                        "value": "0"
                    }
                }, {
                    "type": "property",
                    "id": "name"
                } ],
                "leader": "$",
                "prue": true
            }, "\n                    ", "</p> \n                </div>\n            </li>\n        " ], '\n    </ul>\n    <a href="" class="more clickable js-ctlog" data-ctype="点击更多原声例句" data-example-type="mdia">更多原声例句</a>\n</div>' ]).render(_data);
        },
        "init": function init() {}
    };
});
define("/output/netError/netError", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            var htmlCode = "";
            with (_data || {}) {
                htmlCode += '<div class="trans-container netError" >\n    ';
                if (_data.error) {
                    htmlCode += '\n    	<p class="net-error">目前无法连接服务器，请检查您的网络连接或者查看 <a href="../../res/faq.html" target="_blank">FAQ页面</a> 。 </p>\n    ';
                }
                htmlCode += "\n</div>\n";
            }
            return htmlCode;
        },
        "init": function init() {}
    };
});
define("/output/noresult/noresult", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            var htmlCode = "";
            with (_data || {}) {
                htmlCode += '<div class="trans-container noresult" >\n    ';
                if (_data.showWord) {
                    htmlCode += '\n	    <h2>\n	        <span class="keyword">';
                    htmlCode += tpHelper.html.escape(_data.input);
                    htmlCode += '';
                }
                htmlCode += "\n    ";
                if (_data.showNoResultTips) {
                    htmlCode += "\n	    <p>没有找到“<span>";
                    htmlCode += tpHelper.html.escape(_data.input);
                    htmlCode += "</span>”相关的\n			";
                    if (_data.lang == "eng") {
                        htmlCode += "英汉互译\n			";
                    } else if (_data.lang == "jap") {
                        htmlCode += "日汉互译\n			";
                    } else if (_data.lang == "fr") {
                        htmlCode += "法汉互译\n			";
                    } else if (_data.lang == "ko") {
                        htmlCode += "韩汉互译\n			";
                    }
                    htmlCode += "结果</p>\n    ";
                }
                htmlCode += "\n</div>\n";
            }
            return htmlCode;
        },
        "init": function init() {}
    };
});
define("/output/phrs/phrs", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            _data = tpHelper.mixin(_data, {
                "_getTr": function(dataArray) {
                    var dataString = "";
                    dataArray.forEach(function(element, index) {
                        dataString += element.tr.l.i;
                    });
                    return dataString;
                }
            });
            return tpHelper.vm([ [ {
                "type": "macro",
                "id": "items",
                "args": [ {
                    "type": "references",
                    "id": "count",
                    "leader": "$"
                } ]
            }, "\n    ", [ {
                "type": "foreach",
                "to": "phr",
                "from": {
                    "type": "references",
                    "id": "phrs",
                    "leader": "$"
                }
            }, "\n        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "tphr",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "phr",
                    "path": [ {
                        "type": "property",
                        "id": "phr"
                    } ],
                    "leader": "$"
                } ]
            }, "\n        ", [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "foreach",
                        "path": [ {
                            "type": "property",
                            "id": "count"
                        } ],
                        "isWraped": true,
                        "leader": "$"
                    }, {
                        "type": "references",
                        "id": "count",
                        "leader": "$"
                    } ],
                    "operator": "<"
                }
            }, '\n        <p><a class="clickable serial js-inline-clickable" href="javascript:void(0);">', {
                "type": "references",
                "id": "tphr",
                "path": [ {
                    "type": "property",
                    "id": "headword"
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/a>", {
                "type": "references",
                "id": "_getTr",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "tphr",
                    "path": [ {
                        "type": "property",
                        "id": "trs"
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, "<", "/p>\n        ", {
                "type": "else"
            }, '\n        <p role="yd_collapse_dict_phrs"><a class="clickable serial js-inline-clickable" href="javascript:void(0);">', {
                "type": "references",
                "id": "tphr",
                "path": [ {
                    "type": "property",
                    "id": "headword"
                }, {
                    "type": "property",
                    "id": "l"
                }, {
                    "type": "property",
                    "id": "i"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/a>", {
                "type": "references",
                "id": "_getTr",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "tphr",
                    "path": [ {
                        "type": "property",
                        "id": "trs"
                    } ],
                    "leader": "$"
                } ],
                "prue": true
            }, "<", "/p>\n        " ], "\n    " ], "\n" ], '\n<div class="trans-container phrs yd_dict_toggleClose" id="phrsWordGroup">\n    ', {
                "type": "macro_call",
                "id": "items",
                "args": [ {
                    "type": "integer",
                    "value": "4"
                } ]
            }, "\n    ", [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "phrs",
                        "path": [ {
                            "type": "property",
                            "id": "length"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "integer",
                        "value": "3"
                    } ],
                    "operator": ">"
                }
            }, '\n        <a href="', "#", '" data-toggle="yd_collapse_dict_phrs" class="more-tips clickable">\n            <span href="', "#", '" class="yd_icon yd_icon_more">&nbsp;</span><span class="show_more">更多</span><span\n                class="show_less">收起</span>词组短语\n        </a>\n    ' ], "\n</div>" ]).render(_data);
        },
        "init": function init() {
            /**
 *toggle configs
 * @param id
 * @returns {{container: (*|jQuery|HTMLElement), trigger: (*|jQuery|HTMLElement), sheet: (*|jQuery|HTMLElement), isOpen: Function, open: Function, close: Function}}
 */
            var tgConfig = function(id) {
                var trigger = $('[data-toggle = "yd_collapse_dict_phrs"]'), sheet = $('[role="yd_collapse_dict_phrs"]'), container = $("#" + id);
                return {
                    "container": container,
                    "trigger": trigger,
                    "sheet": sheet,
                    "isOpen": function() {
                        return container.hasClass("yd_dict_toggleClose");
                    },
                    "open": function() {
                        container.removeClass("yd_dict_toggleClose");
                    },
                    "close": function() {
                        container.addClass("yd_dict_toggleClose");
                    }
                };
            };
            var gruopToggle = utils.toggle(tgConfig("phrsWordGroup"));
            gruopToggle.init();
        }
    };
});
define("/output/pic_dict/pic_dict", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            var htmlCode = "";
            with (_data || {}) {
                var param = require("/src/scripts/render/params");
                htmlCode += "\n";
                var store = require("/src/scripts/utils/store");
                htmlCode += "\n";
                var selectedPic = store("picDict").local;
                htmlCode += "\n";
                var selected = selectedPic.value[param.q] || 1;
                htmlCode += "\n";
                var pic = _data.pic || [];
                htmlCode += "\n";
                var bisheng = JSON.parse(_data.bisheng || "[]");
                htmlCode += "\n";
                var picDictObj = {
                    "word": "",
                    "picurl": ""
                };
                htmlCode += "\n";
                if (bisheng.length > 0 && !!bisheng[0] && !!bisheng[0][1]) {
                    htmlCode += "\n";
                    picDictObj = bisheng[0][1];
                    htmlCode += "\n";
                }
                htmlCode += "\n";
                if (pic.length === 0) {
                    return "";
                }
                htmlCode += '\n<div class="selected-container">\n    <div class="selected_img sp" href="" hidefocus="true">\n        ';
                if (!!picDictObj && (!!picDictObj.word || !!picDictObj.picurl || !!picDictObj.picId)) {
                    htmlCode += '\n            <a id="pic_to_bisheng" class="to-bisheng" data-word="';
                    htmlCode += picDictObj.word;
                    htmlCode += '"\n               data-picurl="';
                    htmlCode += picDictObj.picurl;
                    htmlCode += '"></a>\n        ';
                }
                htmlCode += '\n        <img src="';
                htmlCode += _$.match(":nth-child(" + selected + ") .image", pic);
                htmlCode += '" alt=""/>\n        <div class="msg-toggle">\n            <a  href="javascript:void(0)">点击更换图片</a>\n        </div>\n    </div>\n</div>\n<div class="img-list">\n    <div class="img-content img-container">\n        <span class="select-just">\n            <span>点击选择您觉得符合这个词条的图片</span>\n            <a class="close-img sp" href="#">关闭</a>\n        </span>\n        <ul class="all-img">\n            ';
                pic.forEach(function(val, idx) {
                    htmlCode += '\n            <li class="';
                    htmlCode += idx + 1 === selected ? "selected" : "";
                    htmlCode += '">\n                <a href="#"><span><img src="" data-img="';
                    htmlCode += val.image;
                    htmlCode += '" alt="" data-link="';
                    htmlCode += val.host;
                    htmlCode += '"></span></a>\n            </li>\n            ';
                });
                htmlCode += '\n        </ul>\n        <div class="full-content">\n            <img src="';
                htmlCode += _$.match(":nth-child(" + selected + ") .image", pic);
                htmlCode += '" alt=""/>\n            <a class="source-link" href="';
                htmlCode += _$.match(":nth-child(" + selected + ") .host", pic);
                htmlCode += '" target="_blank">';
                htmlCode += _$.match(":nth-child(" + selected + ") .host", pic);
                htmlCode += '</a>\n        </div>\n        <div class="img-guide">\n            <span class="selected_pic">\n                <span>▲<span>▲</span></span>\n                <span><span></span>选择图片</span>\n            </span>\n            <a class="selected_for_bisheng" data-word="';
                htmlCode += picDictObj.word;
                htmlCode += '"\n               data-picurl="';
                htmlCode += picDictObj.picurl;
                htmlCode += '">\n                 <span></span>去图解词典<ins></ins>\n            </a>\n        </div>\n\n    </div>\n</div>';
            }
            return htmlCode;
        },
        "init": function init() {
            var isMove = false;
            var store = require("/src/scripts/utils/store");
            var param = require("/src/scripts/render/params");
            //var queryWord = $('queryinput').val();
            var selectedPic = store("picDict").local;
            var currentHoverIndex = 0;
            var notShowPicTip = store("notShowPicTip").local;
            var ShowPicTip = function() {
                var picTip = '<div class="pic-tip">' + '<a class="pic-tip-close"></a>' + "</div>";
                if (!store("notShowPicTip").local.value.notShowPicTip) {
                    if ($("#pic_to_bisheng").size() !== 0) {
                        $(picTip).appendTo($(".selected_img")).show().fadeOut(5e3, "linear", function() {
                            $(this).remove();
                        });
                    }
                    $(".pic-tip-close").click(function(e) {
                        $(".pic-tip").remove();
                        e.stopPropagation();
                    });
                    store("notShowPicTip").local.val = {
                        "notShowPicTip": true
                    };
                }
            };
            ShowPicTip();
            /**
 * 关闭并显示选中图片
 */
            var closeSelectListAndShowImg = function() {
                $(".img-list").fadeOut(function() {
                    $(".selected_img .img-content").show();
                });
                isMove = false;
            };
            /**
 * 重置大图展示页面样式
 */
            var resetFull = function() {
                var fullImg = $(".full-content img");
                fullImg.stop();
                fullImg.attr("src", "");
                fullImg.removeAttr("style");
                $(".full-content").removeAttr("style");
            };
            var resetSelectedImg = function() {
                $(".selected_img .msg-toggle").removeAttr("style");
                $(".selected-container .selected_img img").removeAttr("style");
            };
            /**
 * 选中图片
 * @param currentLi 当前图片容器
 * @param src  图片地址
 */
            var selectImg = function(currentLi, src) {
                $(".img-list .selected").removeClass("selected");
                currentLi.addClass("selected");
                $(".selected_img img").attr("src", src);
                var wordIndex = {};
                wordIndex[param.q] = $("ul.all-img li").index(currentLi) + 1;
                selectedPic.valmix = wordIndex;
                $(".img-list").removeAttr("style");
            };
            /**
 * 初始化容器背景高度
 */
            var initContainerBgHeight = function() {
                var liSize = $(".img-list li").size();
                if (liSize > 3 && liSize <= 6) {
                    $(".img-list .content").height(182);
                } else if (liSize <= 3) {
                    $(".img-list .content").height(106);
                }
            };
            initContainerBgHeight();
            /**
 * 点击当前图片区域显示选择图片列表
 */
            $(".selected_img").click(function(e) {
                if ($(".img-list .selected img").attr("src") === "") {
                    var allimg = $(".img-list img");
                    $.each(allimg, function(idx, val) {
                        var img = new Image();
                        img.onload = function() {
                            if (img.clientWidth >= img.clientHeight) {
                                img.style.height = "66px";
                            } else {
                                img.style.width = "66px";
                            }
                        };
                        img.src = $(val).data("img");
                        $(val).parent().empty().append(img);
                    });
                }
                $(".img-list").fadeIn("slow", function() {
                    resetSelectedImg();
                });
                resetFull();
                /**
     * 鼠标移入单元格，展示大图。
     */
                $(".img-list").one("mousemove", function() {
                    window.setTimeout(function() {
                        isMove = true;
                    }, 500);
                });
                return false;
            });
            $(".selected-container .to-bisheng").mouseenter(function(e) {
                utils.timerProxy.clearProxy();
                e.stopPropagation();
            });
            $(".selected-container .to-bisheng, .img-guide .selected_for_bisheng").click(function(e) {
                $(".pic-tip").remove();
                external.openPictDict(JSON.stringify({
                    "word": $(this).data("word"),
                    "id": $(this).data("picurl")
                }));
                //打开图解词典相关条目
                e.stopPropagation();
            });
            $(".selected-container .selected_img img").bind("mouseenter", function() {
                var img = $(this);
                $(".pic-tip").remove();
                $(".selected-container").width(img.width() + 4);
                $(".selected-container .selected_img").addClass("selected_hover_img");
                utils.timerProxy(function() {
                    //            ctlog_pic_dict(queryWord, img.attr('src'), 'picDictHover', '-1');
                    var msg = $(".selected_img .msg-toggle");
                    img.animate({
                        "height": "161px"
                    }, 200, function() {
                        msg.show();
                        //宽度设置为了兼容IE6
                        $(".msg-toggle").addClass("msg-hover-toggle");
                        img.addClass("img-in-hover-stauts");
                        $(".selected-container .to-bisheng").css("bottom", "28px");
                    });
                }, 500);
            });
            $(".selected-container .selected_img img").mouseleave(function() {
                $(".selected-container .selected_img").removeClass("selected_hover_img");
                $(".msg-toggle").removeClass("msg-hover-toggle");
                $(this).find("img").removeClass("img-in-hover-stauts");
                $(".selected-container").removeAttr("style");
                utils.timerProxy.clearProxy();
                $(this).find("img").stop();
                resetSelectedImg();
                $(".selected-container .to-bisheng").css("bottom", "1px");
            });
            $(".img-list li").bind("mouseenter.showFullSize", function() {
                if (!isMove) {
                    return;
                }
                var self = $(this);
                if (self.hasClass("selected") || self.find("img").size() === 0) {
                    return;
                }
                resetFull();
                var fullWidth = 285;
                var liWidth = 74;
                var fullImg = $(".full-content img");
                var hoverImg = self.find("img");
                fullImg.attr("src", hoverImg.attr("src"));
                utils.timerProxy(function() {
                    currentHoverIndex = $(".img-list li").index(self);
                    //            ctlog_pic_dict(queryWord, hoverImg.attr('src'), 'picDictHoverCandidate', currentHoverIndex);
                    fullImg.parent().data("currentLi", self);
                    $(".full-content .source-link").attr("href", hoverImg.data("link"));
                    $(".full-content .source-link").html(hoverImg.data("site"));
                    fullImg.parent().show().css({
                        "top": self.position().top,
                        "right": fullWidth - liWidth - self.position().left
                    });
                    fullImg.animate({
                        "height": "161px"
                    }, 100);
                }, 500);
            });
            /**
 * 移出则不显示此大图
 */
            $(".img-list li").mouseleave(function() {
                utils.timerProxy.clearProxy();
            });
            /**
 * 点击单元格选中该图片
 */
            $(".img-list li a").click(function(e) {
                if ($(this).parent().hasClass("selected") || $(this).find("img").size() === 0) {
                    e.preventDefault();
                    return;
                }
                utils.timerProxy.clearProxy();
                var src = $(this).find("img").attr("src");
                //        ctlog_pic_dict(queryWord, src, 'picDictSelect', $('.all-img li img').index($(this).find('img')));
                selectImg($(this).parent(), src);
                resetFull();
                e.preventDefault();
            });
            $(".full-content").mouseleave(function() {
                resetFull();
            });
            /**
 * 点击选中图片并隐藏图片列表
 */
            $(".full-content").click(function(e) {
                var content = $(this);
                var src = $(content.find("img")).attr("src");
                resetFull();
                selectImg(content.data("currentLi"), src);
                closeSelectListAndShowImg();
                //        ctlog_pic_dict(queryWord, src, 'picDictSelect', currentHoverIndex);
                e.stopPropagation();
            });
            /**
 * 点击除去图片列表的区域隐藏图片列表   屏蔽了所有的A点击事件
 */
            $(".close-img").click(function(e) {
                closeSelectListAndShowImg();
                e.preventDefault();
            });
            /**
 * 点击img-list，不关闭
 */
            $(".img-list").click(function(e) {
                e.stopPropagation();
            });
            /**
 * 点击文档，关闭图片选择列表
 */
            $(document).click(function() {
                closeSelectListAndShowImg();
            });
        }
    };
});
define("/output/queryresult/queryresult", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            var htmlCode = "";
            with (_data || {}) {
                htmlCode += '<aside id="result_navigator" class="result_navigator nav-list dict_navigator">\n    ';
                (function(_data) {
                    htmlCode += '<nav class="sub-catalog" role="yd_collapse_dict_query_layout">\n    ';
                    var finished = {};
                    htmlCode += "\n    ";
                    for (var group in _data) {
                        htmlCode += "\n    ";
                        if (!!_data[group].navList) {
                            htmlCode += "\n    ";
                            if (finished[_data[group].navList.id]) {
                                continue;
                            }
                            htmlCode += "\n    ";
                            finished[_data[group].navList.id] = true;
                            htmlCode += "\n    ";
                            var origin = [ "释义", "用法", "权威词典", "百科", "例句", "翻译结果" ];
                            htmlCode += "\n    ";
                            if (origin.indexOf(_data[group].navList.name) === -1) {
                                htmlCode += '\n    <a id="';
                                htmlCode += _data[group].navList.id;
                                htmlCode += '" class="sub1_all js-empty js-ctlog" title="';
                                htmlCode += _data[group].navList.name;
                                htmlCode += '" data-ctype="';
                                htmlCode += _data[group].navList.name;
                                htmlCode += '" data-nav2="';
                                htmlCode += _data[group].navList.navTo.join(" ");
                                htmlCode += '"><span>';
                                htmlCode += _data[group].navList.name;
                                htmlCode += "</span></a>\n    ";
                            } else {
                                htmlCode += '\n    <a id="';
                                htmlCode += _data[group].navList.id;
                                htmlCode += '" class="sub1_all js-empty js-ctlog" data-ctype="';
                                htmlCode += _data[group].navList.name;
                                htmlCode += '" data-nav2="';
                                htmlCode += _data[group].navList.navTo.join(" ");
                                htmlCode += '"><span>';
                                htmlCode += _data[group].navList.name;
                                htmlCode += "</span></a>\n    ";
                            }
                            htmlCode += "\n    ";
                        }
                        htmlCode += "\n    ";
                    }
                    htmlCode += '\n</nav>\n<!--<div class="split group_1" style="display: block; "></div>-->\n<!--<h3 class="main-catalog"><a class="lable add-nav" href="#collins" hidefocus="true"></a></h3>-->';
                })(_data);
                htmlCode += '\n    <a class="nav-button js-ctlog" id="toggleNav" data-ctype="点击收起或展开结果页导航" data-toggle="yd_collapse_dict_query_layout" href="javascript:void(0)"><span></span></a>\n</aside>\n<div id="toollist">\n    <a href="#" id="goIndex" class="go-index js-ctlog js-go-index" title="回到首页" data-ctype="goindex"></a>\n    <a href="" id="goTop" class="go-top js-ctlog js-go-top" title="回到顶部" data-ctype="gotop"></a>\n</div>\n<div id="results-content" class="result-content user-selected control-height go-top-dict-sec">\n    <section id="result">\n        ';
                (function(_data) {
                    for (var group in _data) {
                        htmlCode += "\n";
                        if (_data[group].type === "dictGroup") {
                            htmlCode += '\n<article class="dict-group tab js-empty trans-wrapper ';
                            htmlCode += _data[group].status === "close" ? "toggleClose" : "";
                            htmlCode += '" id="';
                            htmlCode += group;
                            htmlCode += '" ';
                            htmlCode += !!_data[group].navList ? 'data-nav="' + _data[group].navList.id + '"' : "";
                            htmlCode += ">\n    ";
                            var dicts = _data[group].children, currentDict = _data[group].current;
                            htmlCode += '\n    <nav class="tab-nav">\n        ';
                            for (var dict in dicts) {
                                htmlCode += '\n        <a id="';
                                htmlCode += dict;
                                htmlCode += '_tab" class="js-ctlog tab-menu js-empty ';
                                htmlCode += currentDict == dict ? "current" : "";
                                htmlCode += ' "  data-ctype="TAB';
                                htmlCode += dicts[dict].name;
                                htmlCode += '" data-rel="';
                                htmlCode += dict;
                                htmlCode += '">';
                                htmlCode += dicts[dict].name;
                                htmlCode += "</a>\n        ";
                            }
                            htmlCode += '\n        <a id="';
                            htmlCode += group;
                            htmlCode += '_toggle" data-rel="#';
                            htmlCode += group;
                            htmlCode += '_content" class="toggle js-ctlog" data-ctype="点击展开或收起词典组_';
                            htmlCode += group;
                            htmlCode += '"></a>\n    </nav>\n    <div id="';
                            htmlCode += group;
                            htmlCode += '_content" class="toggleContent">\n        ';
                            for (var dict in dicts) {
                                htmlCode += '\n        <div id="';
                                htmlCode += dict;
                                htmlCode += '" class="tab-content" data-group="';
                                htmlCode += group;
                                htmlCode += '"></div>\n        ';
                            }
                            htmlCode += "\n    </div>\n</article>\n";
                        } else {
                            htmlCode += '\n<article id="';
                            htmlCode += group;
                            htmlCode += '" ';
                            htmlCode += !!_data[group].navList ? 'data-nav="' + _data[group].navList.id + '"' : "";
                            htmlCode += " >\n    ";
                            var dicts = _data[group].children;
                            htmlCode += "\n    ";
                            for (var dict in dicts) {
                                htmlCode += '\n    <div id="';
                                htmlCode += dict;
                                htmlCode += '" data-group="';
                                htmlCode += group;
                                htmlCode += '"></div>\n    ';
                            }
                            htmlCode += "\n</article>\n";
                        }
                        htmlCode += "\n";
                    }
                })(_data);
                htmlCode += "\n    </section>\n</div>\n";
            }
            return htmlCode;
        },
        "init": function init() {
            var group = require("/src/scripts/utils/component/group");
            var toggle = require("/src/scripts/utils/component/toggle");
            /**
 * nav toggle
 */
            setTimeout(function() {
                toggle({
                    "trigger": $("#toggleNav"),
                    "open": function() {
                        $("#dict").removeClass("open");
                    },
                    "isOpen": function() {
                        return $("#dict").hasClass("open");
                    },
                    "close": function() {
                        $("#dict").addClass("open");
                    }
                }).init();
            }, 0);
            /**
 * 绑定导航栏锚点跳转滑动效果
 */
            $(".dict_navigator nav a").on("click", function(e) {
                var nav2 = $(this).data("nav2").split(" ");
                var target;
                if (nav2[0] && $("#" + nav2[0]).size() > 0) {
                    target = $("#" + nav2[0]);
                } else if (nav2[1] && $("#" + nav2[1]).size() > 0) {
                    target = $("#" + nav2[1]);
                }
                if (target && target.size() > 0) {
                    var tOffset = target[0].offsetTop;
                    $("#results-content").animate({
                        "scrollTop": tOffset
                    }, "fast");
                }
                e.preventDefault();
            });
            $(".go-top-dict-sec").scroll(function() {
                if ($(".go-top-dict-sec").scrollTop() > 0) {
                    $(".js-go-top").show();
                } else {
                    $(".js-go-top").hide();
                }
            });
            $("a.js-go-index").show();
        }
    };
});
define("/output/quick/quick", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            _data = tpHelper.mixin(_data, {
                "getOnlineStatus": function() {
                    return global.status.online;
                }
            });
            var htmlCode = "";
            with (_data || {}) {
                htmlCode += '<div class="trans-container quick-content user-selected">\n    <h2>\n        <span class="keyword">';
                htmlCode += _data.rq;
                htmlCode += '</span>\n        <span class="pronounce">\n        	';
                if (_data.sm) {
                    htmlCode += '\n          		<span class="phonetic">[';
                    htmlCode += _data.sm;
                    htmlCode += "]</span>\n        	";
                }
                htmlCode += "\n            ";
                if (global.status.online && _data.speach !== "" && [ "ce", "cj", "ck", "cf" ].indexOf(_data.ltype) === -1) {
                    htmlCode += '\n          		<a href="#" title="真人发音"  role=\'dict_audio_js\'\n                   data-rel="http://dict.youdao.com/dictvoice?audio=';
                    htmlCode += _data.speach;
                    htmlCode += '" class="dictvoice voice-js log-js" data-4log="dict.quick.voice"></a>\n            ';
                }
                htmlCode += '';
                if (_data.basic) {
                    htmlCode += "\n  <ul>\n    ";
                    for (var tran in _data.basic) {
                        htmlCode += "\n            <li>";
                        htmlCode += _data.basic[tran];
                        htmlCode += "</li>\n     	";
                    }
                    htmlCode += "\n	";
                } else if (_data.web) {
                    htmlCode += "\n      ";
                    for (var tranS in _data.web) {
                        htmlCode += "\n           <li>\n            ";
                        for (var s in _data.web[tranS]) {
                            htmlCode += "\n                ";
                            htmlCode += s;
                            htmlCode += " ：\n                ";
                            htmlCode += _data.web[tranS][s];
                            htmlCode += " ；\n            ";
                        }
                        htmlCode += "\n          </li>";
                    }
                    htmlCode += '\n      <li class="resource-web">以上结果来自网络释义</li>\n    </ul>\n  ';
                }
                htmlCode += '\n    <p class="enter-tips">按Enter键查看\n	';
                if (_data.curLang && _data.curLang !== _data.lang) {
                    htmlCode += "\n		";
                    if (_data.lang = "eng") {
                        htmlCode += "英汉翻译\n		";
                    } else if (_data.lang = "jap") {
                        htmlCode += "日汉翻译\n		";
                    } else if (_data.lang == "fr") {
                        htmlCode += "法汉翻译\n		";
                    } else if (_data.lang == "ko") {
                        htmlCode += "韩汉翻译\n		";
                    }
                    htmlCode += "的";
                }
                htmlCode += '完整结果<span class="enter-icon"></span></p>\n</div>\n';
            }
            return htmlCode;
        },
        "init": function init() {}
    };
});
define("/output/rel_word/rel_word", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            return tpHelper.vm([ '<div class="trans-container rel_word">\n    <p>词根：', {
                "type": "references",
                "id": "stem",
                "isWraped": true,
                "leader": "$",
                "prue": true
            }, "</p>\n    <ul>\n        ", [ {
                "type": "foreach",
                "to": "perRel",
                "from": {
                    "type": "references",
                    "id": "rels",
                    "leader": "$"
                }
            }, "\n            ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "rel",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "perRel",
                    "path": [ {
                        "type": "property",
                        "id": "rel"
                    } ],
                    "leader": "$"
                } ]
            }, "\n        <li>\n            <p>", {
                "type": "references",
                "id": "rel",
                "path": [ {
                    "type": "property",
                    "id": "pos"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/p>\n            <div>\n                ", [ {
                "type": "foreach",
                "to": "perWord",
                "from": {
                    "type": "references",
                    "id": "rel",
                    "path": [ {
                        "type": "property",
                        "id": "words"
                    } ],
                    "leader": "$"
                }
            }, '\n                    <p><a class="clickable js-inline-clickable" href="javascript:void(0);" >', {
                "type": "references",
                "id": "perWord",
                "path": [ {
                    "type": "property",
                    "id": "word"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/a>", {
                "type": "references",
                "id": "perWord",
                "path": [ {
                    "type": "property",
                    "id": "tran"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/p>\n                " ], "\n            </div>\n        </li>\n        " ], "\n    </ul>\n</div>" ]).render(_data);
        },
        "init": function init() {}
    };
});
define("/output/report_error/report_error", function(require, exports, module) {
 
});
define("/output/search_history/search_history", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            _data = tpHelper.mixin(_data, {
                "_decodeHtml": function(input) {
                    return tpHelper.html.escape(input);
                }
            });
            var htmlCode = "";
            with (_data || {}) {
                htmlCode += "<div>\n    ";
                var curPage = _data["curPage"];
                htmlCode += "\n    ";
                var allPage = _data["allPage"];
                htmlCode += "\n    ";
                var curData = _data["search_history"];
                htmlCode += "\n    ";
                if (curData.length !== 0) {
                    htmlCode += "\n    <ul>\n        ";
                    for (var i = 0; i < curData.length; i++) {
                        htmlCode += '\n        <li class="item" data-lang="';
                        htmlCode += curData[i].lang;
                        htmlCode += '" data-source="';
                        htmlCode += encodeURIComponent(curData[i].word);
                        htmlCode += '">\n            <strong>';
                        htmlCode += _data["_decodeHtml"](curData[i].word);
                        htmlCode += "</strong>\n            ";
                        //alert(curData[i].trans);
                        if (curData[i].trans && $.trim(curData[i].trans) !== "") {
                            htmlCode += "\n            &nbsp;&nbsp;&nbsp;&nbsp;";
                            htmlCode += curData[i].trans;
                            htmlCode += "\n            ";
                        }
                        htmlCode += '\n            <span class="del">x</span>\n        </li>\n        ';
                    }
                    htmlCode += '\n    </ul>\n    <div class="control">\n        <span class="prev ';
                    htmlCode += curPage === 1 || allPage === 1 ? "dis" : "";
                    htmlCode += '">←</span>\n        <span class="current">';
                    htmlCode += curPage;
                    htmlCode += "/";
                    htmlCode += allPage;
                    htmlCode += '</span>\n        <span class="next ';
                    htmlCode += curPage === allPage || allPage === 1 ? "dis" : "";
                    htmlCode += '">→</span>\n        <span class="clear" title="清空记录">█</span>\n    </div>\n    ';
                }
                htmlCode += "\n</div>";
            }
            return htmlCode;
        },
        "init": function init() {}
    };
});
define("/output/special/special", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            _data = tpHelper.mixin(_data, {
                "_getLists": function(entries) {
                    var ret = '<span class="title">专业：</span>';
                    for (var i = 0, len = entries.length; i < len; i++) {
                        var typo = entries[i].entry.major;
                        if (i === len - 1) {
                            ret += '<a class="clickable" href="#" data-tab-special="yd_tab_dict_special">' + typo + "</a>";
                        } else {
                            if (i === 0) {
                                ret += '<a class="clickable" href="#" data-tab-special="yd_tab_dict_special">' + typo + "</a><ins>|</ins>";
                            } else {
                                ret += '<a class="clickable" href="#" data-tab-special="yd_tab_dict_special">' + typo + "</a><ins>|</ins>";
                            }
                        }
                    }
                    return ret;
                }
            });
            return tpHelper.vm([ [ {
                "type": "macro",
                "id": "speLists"
            }, "\n<ul>\n    ", [ {
                "type": "foreach",
                "to": "perEntrie",
                "from": {
                    "type": "references",
                    "id": "entries",
                    "leader": "$"
                }
            }, "\n        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "pEntry",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "perEntrie",
                    "path": [ {
                        "type": "property",
                        "id": "entry"
                    } ],
                    "leader": "$"
                } ]
            }, '\n        <li class="yd_tab_dict_special" role="yd_tab_dict_special">\n            ', {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "ptrs",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "pEntry",
                    "path": [ {
                        "type": "property",
                        "id": "trs"
                    } ],
                    "leader": "$"
                } ]
            }, "\n            <ul>\n                ", [ {
                "type": "foreach",
                "to": "pertr",
                "from": {
                    "type": "references",
                    "id": "ptrs",
                    "leader": "$"
                }
            }, "\n                    ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "ptr",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "pertr",
                    "path": [ {
                        "type": "property",
                        "id": "tr"
                    } ],
                    "leader": "$"
                } ]
            }, '\n                    <li>\n                        <p><span class="title">', {
                "type": "references",
                "id": "ptr",
                "path": [ {
                    "type": "property",
                    "id": "nat"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/span>\n                            ", [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "ptr",
                        "path": [ {
                            "type": "property",
                            "id": "cite"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "math",
                        "expression": [ {
                            "type": "references",
                            "id": "ptr",
                            "path": [ {
                                "type": "property",
                                "id": "cite"
                            } ],
                            "leader": "$"
                        }, {
                            "type": "integer",
                            "value": "0"
                        } ],
                        "operator": "!="
                    } ],
                    "operator": "&&"
                }
            }, '\n                                <span class="secondary">-引用次数：', {
                "type": "references",
                "id": "ptr",
                "path": [ {
                    "type": "property",
                    "id": "cite"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/span>\n                            " ], "\n                        </p>\n                        <p>", {
                "type": "references",
                "id": "ptr",
                "path": [ {
                    "type": "property",
                    "id": "engSent"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "</p>\n                        <p>", {
                "type": "references",
                "id": "ptr",
                "path": [ {
                    "type": "property",
                    "id": "chnSent"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "</p>\n                        ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "ptr",
                    "path": [ {
                        "type": "property",
                        "id": "docTitle"
                    } ],
                    "leader": "$"
                }
            }, '\n                            <p class="secondary">参考来源 - <a class="clickable" target="_blank" href="', {
                "type": "references",
                "id": "ptr",
                "path": [ {
                    "type": "property",
                    "id": "url"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '">', {
                "type": "references",
                "id": "ptr",
                "path": [ {
                    "type": "property",
                    "id": "docTitle"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "</a></p>\n                        " ], "\n                    </li>\n                " ], "\n            </ul>\n        </li>\n    " ], "\n</ul>\n" ], '\n\n<div class="trans-container special">\n    <p class="types">', {
                "type": "references",
                "id": "_getLists",
                "leader": "$",
                "args": [ {
                    "type": "references",
                    "id": "entries",
                    "leader": "$"
                } ],
                "prue": true
            }, "<", "/p>\n    ", {
                "type": "macro_call",
                "id": "speLists"
            }, '\n    <p class="secondary source">\n        ', {
                "type": "references",
                "id": "summary",
                "path": [ {
                    "type": "property",
                    "id": "text"
                } ],
                "isWraped": true,
                "leader": "$",
                "prue": true
            }, '：\n        <a class="clickable" target="_blank" href="', {
                "type": "references",
                "id": "summary",
                "path": [ {
                    "type": "property",
                    "id": "sources"
                }, {
                    "type": "property",
                    "id": "source"
                }, {
                    "type": "property",
                    "id": "url"
                } ],
                "leader": "$",
                "prue": true
            }, '"', ">", {
                "type": "references",
                "id": "summary",
                "path": [ {
                    "type": "property",
                    "id": "sources"
                }, {
                    "type": "property",
                    "id": "source"
                }, {
                    "type": "property",
                    "id": "site"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/a>\n    </p>\n</div>\n\n" ]).render(_data);
        },
        "init": function init() {
            var typoTab = utils.tab($("#special [data-tab-special]"), $("#special .yd_tab_dict_special"));
        }
    };
});
define("/output/spoken/spoken", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            _data = tpHelper.mixin(_data, {
                "_updateError": function(error, sentenceNodes, type) {
                    for (var i = 0; i < error.length; i++) {
                        var errorWord = error[i].word, pos = error[i].pos, phonetic = error[i].phonetic.replace(/\(/g, "<span>").replace(/\)/g, "</span>");
                        for (var j = 0; j < sentenceNodes.length; j++) {
                            if (pos == j) {
                                if (type == "e") {
                                    sentenceNodes[j] = '<span class="miss">' + errorWord + '<span class="phonetic">' + '<span class="tri-outer">◆<span class="tri-inner">◆</span></span>[' + phonetic + "]</span></span>";
                                } else if (type == "c") {
                                    sentenceNodes[j] = '<span class="confusion">' + errorWord + '<span class="phonetic">' + '<span class="tri-outer">◆<span class="tri-inner">◆</span></span>[' + phonetic + "]</span></span>";
                                }
                            }
                        }
                    }
                },
                "_getSentences": function(error, confusion, sentence) {
                    var errorLength = (error || []).length, confusionLength = (confusion || []).length;
                    var sentenceNodes = $.trim(sentence).replace(/(\u3000|\s|\t)/g, " ").split(" ");
                    if (errorLength > 0) {
                        this._updateError(error, sentenceNodes, "e");
                    }
                    if (confusionLength > 0) {
                        this._updateError(confusion, sentenceNodes, "c");
                    }
                    return sentenceNodes.join(" ");
                },
                "_decodeHtml": function(input) {
                    return tpHelper.html.escape(input);
                }
            });
            var htmlCode = "";
            with (_data || {}) {
                htmlCode += '<div id="spoken" class="trans-container spoken-read ';
                htmlCode += _data.word ? "word-read-spoken-container" : "sents-read-spoken-container";
                htmlCode += '">\n    <p class="title">口语练习<a class="dict-icon-close js-spoken-close">X</a></p>\n    ';
                if (_data["status"] == "reset") {
                    htmlCode += '\n    <div class="wrapper">\n        ';
                    (function(_data) {
                        htmlCode += '<div class="spoken-reset">\n    ';
                        if (_data["word"]) {
                            htmlCode += '\n    <div class="wrap">\n        <div class="word-spoken">\n            <div class="content">\n                <span class="key" data-word="';
                            htmlCode += _decodeHtml(_data["word"].word);
                            htmlCode += '">';
                            htmlCode += _decodeHtml(_data["word"].word);
                            htmlCode += "</span>\n                ";
                            if (!!_data["word"].phonetic) {
                                htmlCode += '\n                <span class="phonetic" data-phonetic="';
                                htmlCode += _data["word"].phonetic;
                                htmlCode += '">';
                                htmlCode += _data["word"].phonetic;
                                htmlCode += "</span>\n                ";
                            }
                            htmlCode += "\n                ";
                            if (!!_data.word.speech) {
                                htmlCode += '\n                <a href="javascript:;" role="dict_audio_js" class="speech word-speech dictvoice voice-js"\n                   data-rel="';
                                htmlCode += _data.word.speech;
                                htmlCode += '"></a>\n                ';
                            }
                            htmlCode += '\n            </div>\n        </div>\n        <span class="decorate-tip  word-d"></span>\n        \n    </div>\n    ';
                        } else if (_data["sentences"]) {
                            htmlCode += '\n    <div class="wrap">\n        <div class="sentences-spoken">\n            <div class="inner-scroll">\n                <p class="content" data-sentences="';
                            htmlCode += _decodeHtml(_data["sentences"]["sen"]);
                            htmlCode += '">';
                            htmlCode += _data["sentences"]["sen"];
                            htmlCode += '\n                  <a href="javascript:;" role="';
                            htmlCode += _data.sentences.isVideo === "video" ? "dict_video_js_play_spoken" : "dict_audio_js";
                            htmlCode += '" class="speech dictvoice voice-js js-ctlog"\n                     data-ctype="发音_跟读"\n                     data-rel="';
                            htmlCode += _data.sentences.speech === undefined ? "" : _data.sentences.speech;
                            htmlCode += '"></a>\n               </p>\n            </div>\n        </div>\n        <span class="decorate-tip"></span>\n    </div>\n';
                        }
                        htmlCode += '\n<div class="recording-stauts">\n    <span class="volume-status"></span>\n    <span class="mask"></span>\n    <a class="recording">点击朗读</a>\n</div>\n<p class="recording-tip">录音中，请对麦克风读出此句</p>\n<p class="finish">\n    <a href="#" class="readend js-ctlog" data-ctype="跟读_完成" data-type="';
                        htmlCode += _data.word ? "word" : "sentences";
                        htmlCode += '"></a>\n    <a href="#" class="readstart js-ctlog" data-ctype="跟读_开始" role="stop_dict_audio_js" data-type="';
                        htmlCode += _data.word ? "word" : "sentences";
                        htmlCode += '"></a>\n</p>\n</div>';
                    })(_data);
                    htmlCode += "\n    </div>\n    ";
                }
                htmlCode += "\n    ";
                if (_data["status"] == "wait") {
                    htmlCode += '\n    <div class="wrapper">\n        ';
                    (function(_data) {
                        htmlCode += '<div class="spoken-wait">\n    <p class="waiting">\n        <a>进度</a>\n    </p>\n    <p class="waiting-tip">评分中</p>\n</div>';
                    })(_data);
                    htmlCode += "\n    </div>\n    ";
                }
                htmlCode += "\n    ";
                if (_data["status"] == "result") {
                    htmlCode += '\n    <div class="wrapper">\n        ';
                    (function(_data) {
                        htmlCode += '<div class="spoken-result">\n    ';
                        if (_data.word) {
                            htmlCode += "\n        ";
                            if (_data.history.length !== 0) {
                                htmlCode += '\n            <p class="try-more">来试试更多练习：\n                ';
                                for (var l = 0; l < _data.history.length; l++) {
                                    htmlCode += '\n                    <span data-phone="';
                                    htmlCode += _data.history[l].phone;
                                    htmlCode += '">';
                                    htmlCode += _data.history[l].word !== undefined ? _decodeHtml(_data.history[l].word) : "";
                                    htmlCode += "</span>\n                ";
                                }
                                htmlCode += "\n            </p>\n        ";
                            }
                            htmlCode += '\n        <div class="wrap">\n            <div class="word-spoken">\n                <div class="content">\n                    <span class="key" data-word="';
                            htmlCode += _decodeHtml(_data["word"].word);
                            htmlCode += '">';
                            htmlCode += _decodeHtml(_data["word"].word);
                            htmlCode += '</span>\n                    <span class="phonetic" data-phonetic="';
                            htmlCode += _data["word"].phonetic;
                            htmlCode += '">';
                            htmlCode += _data.word.phonetic === undefined ? "" : _data.word.phonetic;
                            htmlCode += "</span>\n                    ";
                            if (!!_data.word.speech) {
                                htmlCode += '\n                    <a href="javascript:;" role="dict_audio_js" class="speech word-speech dictvoice voice-js"\n                       data-rel="';
                                htmlCode += _data.word.speech;
                                htmlCode += '"></a>\n                    ';
                            }
                            htmlCode += '\n                </div>\n            </div>\n            <span class="decorate-tip  word-d"></span>\n        </div>\n    ';
                        } else if (_data.sentences) {
                            htmlCode += '\n        <div class="wrap">\n            <div>\n                <div class="inner-scroll">\n                    <p class="content sentences-spoken" data-sentences ="';
                            htmlCode += _decodeHtml(_data["sentences"]["sen"]);
                            htmlCode += '">';
                            htmlCode += _getSentences(_data.error, _data.confusion, _data.sentences["sen"]);
                            htmlCode += '\n                        <a href="javascript:;"  role="';
                            htmlCode += _data.sentences.isVideo === "video" ? "dict_video_js_play_spoken" : "dict_audio_js";
                            htmlCode += '" class="speech dictvoice voice-js" data-rel="';
                            htmlCode += _data.sentences.speech === undefined ? "" : _data.sentences.speech;
                            htmlCode += '"></a>\n                    </p>\n                </div>\n            </div>\n            <span class="decorate-tip"></span>\n        </div>\n    ';
                        }
                        htmlCode += "\n    ";
                        if (_data.sentences && !_data["networkError"] && $.trim(_data["feedback"]) === "") {
                            htmlCode += '\n        <div class="spoken-share-part">\n            <a href="#" class="js_open_spoken_share spoken-to-share js-ctlog" data-ctype="跟读评分_分享"></a>\n            <ul class="select-options share-options spoken-share-options">\n                <li><a id="sina" class="js-share-spoken-to share-to sina js-ctlog" data-ctype="跟读评分_分享到新浪微博" data-keyfrom="deskdict_deepin" data-share-type="sina" data-category-type="spoken" href="#"><span class="bar"></span>新浪微博</a></li>\n        <li><a id="qZone" class="js-share-spoken-to share-to qZone js-ctlog"  data-ctype="跟读评分_分享到QQ空间" data-keyfrom="deskdict_deepin" data-share-type="qZone" data-category-type="spoken" href="#"><span class="bar"></span>QQ空间</a></li>\n            </ul>\n        </div>\n    ';
                        }
                        htmlCode += "\n    ";
                        if (_data["level"]) {
                            htmlCode += "\n        ";
                            if (_data.word) {
                                htmlCode += '\n            <p class="score">得分：<span class="level">';
                                htmlCode += _data["level"];
                                htmlCode += "</span></p>\n        ";
                            } else if (_data.sentences) {
                                htmlCode += '\n            <p class="score">得分：<span class="level">';
                                htmlCode += _data["level"];
                                htmlCode += '<strong>分</strong></span>你击败了全球的<span class="rank">';
                                htmlCode += _data["rank"];
                                htmlCode += "%</span>的用户！</p>\n        ";
                            }
                            htmlCode += "\n    ";
                        }
                        htmlCode += "\n    ";
                        if ($.trim(_data["feedback"]) !== "" && (!_data.error && !_data.confusion || _data.error.length == 0 && _data.confusion.length == 0)) {
                            htmlCode += '\n    <p class="feedback">';
                            htmlCode += _data["feedback"];
                            htmlCode += "</p>\n    ";
                        }
                        htmlCode += "\n    ";
                        if (!!_data["networkError"]) {
                            htmlCode += '\n    <p class="networkError">目前无法连接服务器，请检查您的网络连接</p>\n    ';
                        }
                        htmlCode += '\n    <div class="restart">\n        <a class="replay js-ctlog" data-ctype="跟读_回放">回放</a>\n        <ins>/</ins>\n        <a class="respoke js-ctlog" data-ctype="跟读_重读" data-type="';
                        htmlCode += _data.word ? "word" : "sentences";
                        htmlCode += '">重读</a>\n    </div>\n    ';
                        if (_data.sentences && !_data["networkError"]) {
                            htmlCode += '\n        <a id="gotoSpokenPk" class="gotoSpokenPk" href="#">与明星pk口语&gt;&gt;</a>\n    ';
                        }
                        htmlCode += '\n    <a class="more-spoken" href="http://xue.youdao.com/voiceIndex.a" target="_blank">更多口语练习&gt;&gt;</a>\n</div>';
                    })(_data);
                    htmlCode += "\n    </div>\n    ";
                }
                htmlCode += "\n</div>";
            }
            return htmlCode;
        },
        "init": function init() {
            /*鼠标hover显示错误提示*/
            $("body").delegate(".miss, .confusion", "mouseover", function(eve) {
                var target = eve.target;
                var top = $(target).offset().top;
                var left = $(target).offset().left;
                var containerTop = $("#spoken").offset().top;
                var containerLeft = $("#spoken").offset().left;
                var height = $(target).find(".phonetic").eq(0).css("display", "inline-block").show().outerHeight();
                $(".phonetic").hide();
                var posY = top - containerTop - height;
                var posX = left - containerLeft;
                $(target).find(".phonetic").eq(0).css({
                    "top": posY,
                    "left": posX - 10
                }).show();
            });
            $("body").delegate(".miss,.confusion", " mouseout", function() {
                $(".phonetic").hide();
            });
            $("body").delegate(".spoken-reset .voice-js", "click", function() {
                $(".spoken-reset .finish").addClass("begin");
            });
            $("body").delegate(".spoken-reset .finish .readstart", "click", function() {
                $(".spoken-reset .finish").removeClass("begin");
            });
        }
    };
});
define("/output/spoken_panel/spoken_panel", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            _data = tpHelper.mixin(_data, {
                "_decodeHtml": function(input) {
                    return tpHelper.html.escape(input);
                }
            });
            var htmlCode = "";
            with (_data || {}) {
                htmlCode += '<div id="spoken_panel" class="spoken-read sents-read-spoken-container">\n    <p class="title">口语练习<a class="dict-icon-close js-pk-close" role="stop_dict_audio_js">X</a></p>\n    <div class="spoken-reset">\n        <div class="wrap">\n            <div class="sentences-spoken">\n                <div class="inner-scroll">\n                    <p class="content" data-sentences="';
                htmlCode += _decodeHtml(_data["sentences"]["sen"]);
                htmlCode += '">\n                        ';
                htmlCode += _data["sentences"]["sen"];
                htmlCode += '\n                        <a href="javascript:;"\n                           role="dict_audio_js"\n                           class="speech dictvoice voice-js js-ctlog"\n                           data-from="spokenpkread"\n                           data-ctype="发音_跟读"\n                           data-rel="';
                htmlCode += _data.sentences.speech === undefined ? "" : _data.sentences.speech;
                htmlCode += '"></a>\n                    </p>\n                </div>\n            </div>\n            <span class="decorate-tip"></span>\n        </div>\n        <div class="recording-stauts">\n            <span class="volume-status"></span>\n            <span class="mask"></span>\n            <a class="recording">点击朗读</a>\n        </div>\n        <p class="recording-tip">录音中，请对麦克风读出此句</p>\n        <p class="finish">\n            <a href="#" id="pk_readend" class="readend js-ctlog" data-ctype="跟读_完成" data-starId="" data-from="spokenpkread" role="stop_dict_audio_js"></a>\n            <a href="#" class="readstart js-ctlog" data-ctype="跟读_开始" role="stop_dict_audio_js" data-type="';
                htmlCode += _data.word ? "word" : "sentences";
                htmlCode += '"></a>\n        </p>\n    </div>    \n</div>';
            }
            return htmlCode;
        },
        "init": function init() {
            $("body").delegate(".spoken-reset .voice-js", "click", function() {
                $(".spoken-reset .finish").addClass("begin");
            });
            $("body").delegate(".spoken-reset .finish .readstart", "click", function() {
                $(".spoken-reset .finish").removeClass("begin");
            });
        }
    };
});
define("/output/spoken_panel_result/spoken_panel_result", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            _data = tpHelper.mixin(_data, {
                "_decodeHtml": function(input) {
                    return tpHelper.html.escape(input);
                }
            });
            var htmlCode = "";
            with (_data || {}) {
                htmlCode += '<div class="spoken-read sents-read-spoken-container">\n    <p class="title">口语练习<a class="dict-icon-close js-pk-close" role="stop_dict_audio_js">X</a></p>\n    <div class="spoken-result">\n        <div class="wrap">\n            <div class="sentences-spoken">\n                <div class="inner-scroll">\n                    <p class="content" data-sentences="';
                htmlCode += _decodeHtml(_data["sentences"]["sen"]);
                htmlCode += '">\n                    ';
                htmlCode += _data["sentences"]["sen"];
                htmlCode += '\n                    <a href="javascript:;"\n                       role="dict_audio_js"\n                       class="speech dictvoice voice-js js-ctlog"\n                       data-from="spokenpkread"\n                       data-ctype="发音_跟读"\n                       data-rel="';
                htmlCode += _data.sentences.speech === undefined ? "" : _data.sentences.speech;
                htmlCode += '"></a>\n                    </p>\n                </div>\n            </div>\n            <span class="decorate-tip"></span>\n        </div>\n        <p class="networkError">无法获取评分数据，请重新朗读</p>\n        <div class="restart">\n            <a class="replay js-replay-pk js-ctlog" data-ctype="跟读_回放">回放</a>\n            <ins>/</ins>\n            <a class="respoke js-ctlog js-redo-pk" data-ctype="跟读_重读" data-type="';
                htmlCode += _data.word ? "word" : "sentences";
                htmlCode += '">重读</a>\n        </div>\n        <a class="more-spoken" href="http://xue.youdao.com/voiceIndex.a" target="_blank">更多口语练习>></a>\n    </div>\n</div>\n';
            }
            return htmlCode;
        },
        "init": function init() {}
    };
});
define("/output/spoken_panel_wait/spoken_panel_wait", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            var htmlCode = "";
            with (_data || {}) {
                htmlCode += '<div id="spoken" class="spoken-read sents-read-spoken-container">\n    <p class="title">口语练习<a class="dict-icon-close js-pk-close">X</a></p>\n    <div class="spoken-wait">\n        <p class="waiting">\n            <a>进度</a>\n        </p>\n        <p class="waiting-tip">评分中</p>\n    </div>\n</div>';
            }
            return htmlCode;
        },
        "init": function init() {}
    };
});
define("/output/spoken_pk/spoken_pk", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            var htmlCode = "";
            with (_data || {}) {
                var starinfo;
                try {
                    starinfo = JSON.parse(_data.url);
                } catch (e) {
                    starinfo = {};
                }
                htmlCode += '\n<div class="spoken-pk-content">\n    <div class="star">\n        ';
                var image = starinfo.image || "src/images/head-4.jpg";
                htmlCode += '\n        <img src="';
                htmlCode += image;
                htmlCode += '" alt="star"/>\n        <a href="#" class="voice js-ctlog" role="dict_audio_js" data-from="spokenpkindex" data-ctype="明星_发音" data-rel="';
                htmlCode += starinfo.voice;
                htmlCode += '">明星原声</a>\n        <span>';
                htmlCode += starinfo.name;
                htmlCode += '</span>\n    </div>\n    <div class="spoken-pk-sentences user-selected">\n        <p class="title">';
                htmlCode += _data.title;
                htmlCode += '</p>\n        <p class="summary">';
                htmlCode += _data.summary;
                htmlCode += "</p>\n    </div>\n</div>";
            }
            return htmlCode;
        },
        "init": function init() {}
    };
});
define("/output/spoken_pk_result/spoken_pk_result", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            var htmlCode = "";
            with (_data || {}) {
                var given = _data.similarity.given;
                htmlCode += "\n";
                var simiLists = _data.similarity.simiList;
                htmlCode += '\n<div class="pk-result-wrapper">\n    <div class="spoken_pk_result">\n        <div class="similarity">\n            <div class="star">\n                <img src="';
                htmlCode += given.head;
                htmlCode += '">\n                <a href="#" class="voice js-ctlog"\n                   data-from="spokenpkresult"\n                   data-ctype="PK明星发音"\n                   role="dict_audio_js"\n                   data-rel="';
                htmlCode += given.voice;
                htmlCode += '">voice</a>\n                <span>';
                htmlCode += given.name;
                htmlCode += '</span>\n            </div>\n            <div class="star_info">\n                <p class="des">';
                htmlCode += given.des;
                htmlCode += '</p>\n                <span class="value">相似度 : <strong>';
                htmlCode += given.value;
                htmlCode += "%</strong></span>\n            </div>\n        </div>\n        ";
                if (given.value > simiLists[0].value) {
                    htmlCode += '\n            <p class="also_similar">你和TA的口音也很像</p> \n        ';
                } else {
                    htmlCode += '\n            <p class="most_similar">你的口音还是和TA最像</p>\n        ';
                }
                htmlCode += '\n        <div class="simiList similarity">\n            ';
                var simiLists = _data.similarity.simiList;
                htmlCode += '\n            <div class="star">\n                <img src="';
                htmlCode += simiLists[0].head;
                htmlCode += '">\n                <a href="#"\n                   class="voice js-ctlog"\n                   role="dict_audio_js"\n                   data-from="spokenpkresult"\n                   data-ctype="相似明星发音"\n                   data-rel="';
                htmlCode += simiLists[0].voice;
                htmlCode += '">voice</a>\n                <span>';
                htmlCode += simiLists[0].name;
                htmlCode += '</span>\n            </div>\n            <div class="star_info">\n                <span class="value">相似度 : <strong>';
                htmlCode += simiLists[0].value;
                htmlCode += '%</strong></span>\n            </div>\n        </div> \n    </div>\n</div>\n<div class="restart">\n    <a class="replay-pk js-replay-pk js-ctlog" data-from="spokenpkresult" data-ctype="replay" role="stop_dict_audio_js">回放</a>\n    <ins>/</ins>\n    <a class="redo-pk js-redo-pk js-ctlog" data-from="spokenpkresult" data-ctype="reread" role="stop_dict_audio_js">重读</a>\n</div>\n<div class="share_pk">\n    <p>快来分享你的成绩吧~</p>\n    <a href="#" class="sina js-share-spokenProm-to js-ctlog" data-from="spokenpkresult"\n       data-ctype="shareToSina" data-category-type="spokenProm" data-share-type="sina" role="stop_dict_audio_js">sina</a>\n    <a href="#" class="tencent js-share-spokenProm-to js-ctlog" data-from="spokenpkresult"\n       data-ctype="shareToTencent"  data-category-type="spokenProm" data-share-type="tencent" role="stop_dict_audio_js">tencent</a>\n    <a href="#" class="netease js-share-spokenProm-to js-ctlog" data-from="spokenpkresult"\n       data-ctype="shareToNetease"  data-category-type="spokenProm" data-share-type="netease" role="stop_dict_audio_js">netease</a>\n    <a href="#" class="renren js-share-spokenProm-to js-ctlog" data-from="spokenpkresult"\n       data-ctype="shareToRenren" data-category-type="spokenProm" data-share-type="renren" role="stop_dict_audio_js">renren</a>\n    <a href="#" class="zQone js-share-spokenProm-to js-ctlog" data-from="spokenpkresult"\n       data-ctype="shareToQzon" data-category-type="spokenProm" data-share-type="qZone" role="stop_dict_audio_js">zQone</a>\n</div>\n';
            }
            return htmlCode;
        },
        "init": function init() {}
    };
});
define("/output/syno/syno", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            _data = tpHelper.mixin(_data, {
                "_foreach": Object.create(utils._foreach)
            });
            return tpHelper.vm([ '<div class="syno trans-container">\n    <ul>\n        ', [ {
                "type": "foreach",
                "to": "perSyno",
                "from": {
                    "type": "references",
                    "id": "synos",
                    "leader": "$"
                }
            }, '\n            <li>\n                <p><span class="serial">', {
                "type": "references",
                "id": "perSyno",
                "path": [ {
                    "type": "property",
                    "id": "syno"
                }, {
                    "type": "property",
                    "id": "pos"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/span>", {
                "type": "references",
                "id": "perSyno",
                "path": [ {
                    "type": "property",
                    "id": "syno"
                }, {
                    "type": "property",
                    "id": "tran"
                } ],
                "leader": "$",
                "prue": true
            }, "<", '/p>\n                <p class="clickable secondaryFont">\n                    ', {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "ws",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "perSyno",
                    "path": [ {
                        "type": "property",
                        "id": "syno"
                    }, {
                        "type": "property",
                        "id": "ws"
                    } ],
                    "leader": "$"
                } ]
            }, "\n                    ", {
                "type": "references",
                "id": "_foreach",
                "path": [ {
                    "type": "method",
                    "id": "start",
                    "args": [ {
                        "type": "integer",
                        "value": "1"
                    } ]
                } ],
                "leader": "$",
                "prue": true
            }, "\n                    ", [ {
                "type": "foreach",
                "to": "pWs",
                "from": {
                    "type": "references",
                    "id": "ws",
                    "leader": "$"
                }
            }, '\n                        <a class="clickable js-inline-clickable" href="javascript:void(0);">', {
                "type": "references",
                "id": "pWs",
                "path": [ {
                    "type": "property",
                    "id": "w"
                } ],
                "leader": "$",
                "prue": true
            }, "<", "/a>\n                        ", [ {
                "type": "if",
                "condition": {
                    "type": "math",
                    "expression": [ {
                        "type": "references",
                        "id": "_foreach",
                        "path": [ {
                            "type": "property",
                            "id": "count"
                        } ],
                        "leader": "$"
                    }, {
                        "type": "references",
                        "id": "ws",
                        "path": [ {
                            "type": "property",
                            "id": "length"
                        } ],
                        "leader": "$"
                    } ],
                    "operator": "!="
                }
            }, '\n                            <ins class="secondary">/</ins>\n                        ' ], "\n                    " ], "\n                </p>\n            </li>\n        " ], "\n    </ul>\n</div>\n" ]).render(_data);
        },
        "init": function init() {}
    };
});
define("/output/trans_devotion_content/trans_devotion_content", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            _data = tpHelper.mixin(_data, {
                "_decodeHtml": function(input) {
                    return tpHelper.html.escape(input);
                }
            });
            var htmlCode = "";
            with (_data || {}) {
                htmlCode += '<p id="ugcCotent">\n    ';
                htmlCode += _data["_decodeHtml"](_data.para || "");
                htmlCode += '\n</p>\n\n<p class="additional">\n    <a href="javascript:void(0);" class="returnEdit clickable">返回编辑</a>\n</p>\n';
            }
            return htmlCode;
        },
        "init": function init() {}
    };
});
define("/output/trans_devotion_edit/trans_devotion_edit", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            _data = tpHelper.mixin(_data, {
                "_decodeHtml": function(input) {
                    return tpHelper.html.escape(input);
                }
            });
            var htmlCode = "";
            with (_data || {}) {
                htmlCode += '<form class="trans-container edit">\n    <p>\n        <label for="currentWord">当前词条：</label>\n        <strong id="currentWord">';
                htmlCode += _data["_decodeHtml"](_data.word || "");
                htmlCode += '</strong>\n    </p>\n\n    <p>\n        <label for="inputTrans" class="center">\n            输入释义：<span class="required">*</span>\n        </label>\n        <textarea id="inputTrans" class="trans-content" name="inputTrans">';
                htmlCode += _data["_decodeHtml"](_data.para || "");
                htmlCode += '</textarea>\n        <span class="error-message"></span>\n    </p>\n\n    <p>\n        <label for="source">来源参考：</label>\n        <span class="clear_area">\n           <input type="text" id="source" name="source" class="trans-message" placeholder="请输入释义来源"\n                  value="';
                htmlCode += _data["_decodeHtml"](_data.ref || "");
                htmlCode += '">\n             <a href="javascript:;" class="js-devotion-close devotion-close"></a>\n        </span>\n    </p>\n\n    <p>\n        <label for="domain">所属专业：</label>\n        <span class="clear_area">\n           <input type="text" id="domain" name="domain" class="trans-message" placeholder="请输入词条所属专业"\n                  value="';
                htmlCode += _data["_decodeHtml"](_data.domain || "");
                htmlCode += '">\n        <a href="javascript:;" class="js-devotion-close devotion-close"></a>\n        </span>\n\n    </p>\n\n    <p>\n        <label for="contact">联系方式：</label>\n        <span class="clear_area">\n          <input type="text" id="contact" name="contact" class="trans-message" placeholder="请输入Email"\n                 value="';
                htmlCode += _data["_decodeHtml"](_data.contact || "");
                htmlCode += '">\n        <a href="javascript:;" class="js-devotion-close devotion-close"></a>\n        </span>\n\n    </p>\n\n    <p class="submitTip">\n        <a class="ensure devotion-ensure js-ensure" href="javascript:void(0);" title="确定">确定</a>\n        <a class="cancel devotion-cancel js-cancel" href="javascript:void(0)" title="取消">取消</a>\n    </p>\n</form>';
            }
            return htmlCode;
        },
        "init": function init() {}
    };
});
define("/output/trans_devotion_tip/trans_devotion_tip", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function anonymous(_data) {
            var htmlCode = "";
            with (_data || {}) {
                htmlCode += '<div id="ugcReportButton">\n    <p class="devotionTip">\n        <span class="wordTrans contributeBtn"></span>\n        <a href="javascript:void(0);" class="tipDevotion contributeBtn">如果你找到了答案，请贡献本词条释义，利人利己</a>\n    </p>\n</div>\n';
            }
            return htmlCode;
        },
        "init": function init() {}
    };
});
define("/output/typos/typos", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            _data = tpHelper.mixin(_data, {
                "_getWord": function(word) {
                    return encodeURIComponent(word);
                }
            });
            return tpHelper.vm([ '<div class="trans-container typos">\n    <div class="error-typo">\n        <h4>您是不是要找：</h4>\n        ', [ {
                "type": "foreach",
                "to": "_typo",
                "from": {
                    "type": "references",
                    "id": "typo",
                    "leader": "$"
                }
            }, '\n            <p class="typo-rel">\n                <a class="title js-inline-clickable" >', {
                "type": "references",
                "id": "_typo",
                "path": [ {
                    "type": "property",
                    "id": "word"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "</a> ：\n                ", [ {
                "type": "if",
                "condition": {
                    "type": "references",
                    "id": "_typo",
                    "path": [ {
                        "type": "property",
                        "id": "trans"
                    } ],
                    "isWraped": true,
                    "leader": "$!"
                }
            }, "\n                    ", {
                "type": "references",
                "id": "_typo",
                "path": [ {
                    "type": "property",
                    "id": "trans"
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, "\n                " ], "\n            </p>\n        " ], "\n    </div>\n</div>\n" ]).render(_data);
        },
        "init": function init() {}
    };
});
define("/output/user_dict/user_dict", function(require, exports, module) {
    var $ = require("/lib/jquery");
    var _ = require("/lib/underscore");
    var _$ = require("/lib/jsonselect");
    var utils = require("/src/scripts/utils/utils");
    var external = require("/src/scripts/external");
    var tpHelper = require("/lib/tpHelper");
    module.exports = {
        "render": function TvmT(_data) {
            _data = tpHelper.mixin(_data, {
                "_foreach": Object.create(utils._foreach),
                "_foreachType": Object.create(utils._foreach),
                "_getallExam": function(obj) {
                    var engDataString = "", chnDataString = "";
                    if (obj.exam) {
                        return obj["exam"].map(function(exam) {
                            engDataString = exam.i.f.l.i;
                            chnDataString = exam.i.n.l.i;
                            return {
                                "eng": engDataString,
                                "chn": chnDataString
                            };
                        });
                    } else {
                        return {
                            "eng": "",
                            "chn": ""
                        };
                    }
                },
                "_isSup": function(str, tgt) {
                    return str == tgt;
                },
                "_handleMore": function() {}
            });
            return tpHelper.vm([ [ {
                "type": "macro",
                "id": "list"
            }, "\n<!--释义-->\n    ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "trs",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "pWord",
                    "path": [ {
                        "type": "property",
                        "id": "trs"
                    } ],
                    "leader": "$"
                } ]
            }, "\n    ", {
                "type": "references",
                "id": "_foreachType",
                "path": [ {
                    "type": "method",
                    "id": "start",
                    "args": [ {
                        "type": "integer",
                        "value": "1"
                    } ]
                } ],
                "isWraped": true,
                "leader": "$!",
                "prue": true
            }, '\n<ul class="posType">\n    ', [ {
                "type": "foreach",
                "to": "pTr",
                "from": {
                    "type": "references",
                    "id": "trs",
                    "leader": "$"
                }
            }, "\n        ", {
                "type": "set",
                "equal": [ {
                    "type": "references",
                    "id": "orderType",
                    "leader": "$"
                }, {
                    "type": "references",
                    "id": "_foreachType",
                    "path": [ {
                        "type": "property",
                        "id": "count"
                    } ],
                    "isWraped": true,
                    "leader": "$!"
                } ]
            }, '\n        <li>\n            <span class="title">', {
                "type": "references",
                "id": "pTr",
      