/****************************************************************************
**
**  Copyright (C) 2011~2014 Deepin, Inc.
**                2011~2014 Kaisheng Ye
**
**  Author:     Kaisheng Ye <kaisheng.ye@gmail.com>
**  Maintainer: Kaisheng Ye <kaisheng.ye@gmail.com>
**
**  This program is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

import QtQuick 2.1

Item {
    id: ocrResultWindow
    width: 326
    height: 200

    property var constant: Constant {}

    property int contentHeight: topToolBarBox.height + resultBox.height
    onContentHeightChanged: {
        //heightChangedTimer.restart()
        ocrResultWindow.height = contentHeight
        mainView.setHeight(contentHeight)
    }

    Timer{
        id: heightChangedTimer
        interval: 200
        onTriggered: {
            ocrResultWindow.height = contentHeight
            mainView.setHeight(contentHeight)
        }
    }

    function isPinned(){
        return false
    }

    function hideWindow(){
        topToolBarBox.visible = false
        ocrResultWindow.height = contentHeight
        mainView.setHeight(contentHeight)
        mainView.hide()
    }

    property int cursorX: 0
    property int cursorY: 0
    property int showCursorX: 0
    property int showCursorY: 0

    property bool ctrlKeyHold: false
    property bool altKeyHold: false
    property bool shiftKeyHold: false

    function handle_modifier_keys_released(ocr_mode){
        if(!mainView.visible && settingConfig.get_getword("ocr")){
            if(settingConfig.get_getword("ocr_mode") == ocr_mode){
                getwordDaemon.EmitOcr(cursorX, cursorY)
            }
        }
    }

    Timer{
        id: cursorPauseTimer
        interval: 1000
        onTriggered: {
            if(!mainView.visible && settingConfig.get_getword("ocr")){
                var ocr_mode = settingConfig.get_getword("ocr_mode")
                if (ocr_mode == "0" || (ocr_mode == "1" && ctrlKeyHold) || (ocr_mode == "4" && altKeyHold) || (ocr_mode == "2" && shiftKeyHold)){ 
                   getwordDaemon.EmitOcr(cursorX, cursorY)
                }
            }
        }
    }

    Connections {
        target: getwordDaemon
        onCursorPositionChanged: {
            cursorX = x
            cursorY = y
            if(mainView.visible){
                var distance = Math.sqrt(Math.pow(cursorY - showCursorY, 2) + Math.pow(cursorX - showCursorX, 2))
                if(distance > 50 && !mainView.in_translate_area()){
                    if(!pinButton.active){
                        hideWindow()
                    }
                }
                if(mainView.in_translate_area()){
                    topToolBarBox.visible = true
                    ocrResultWindow.height = contentHeight
                    mainView.setHeight(contentHeight)
                }
            }
            else {
                if(cursorPauseTimer.running){
                    cursorPauseTimer.stop()
                }
                cursorPauseTimer.start()
            }
        }
        onOcrRecognized: {
            mainView.startTranslate(x, y, text)
        }
        onHide: {
            if(!pinButton.active){
                mainView.hideHandler()
            }
        }
        onCtrlPressed: {
            ctrlKeyHold = true
        }
        onCtrlReleased: {
            ctrlKeyHold = false
            handle_modifier_keys_released("1")
        }
        onAltPressed: {
            altKeyHold = true
        }
        onAltReleased: {
            altKeyHold = false
            handle_modifier_keys_released("4")
        }
        onShiftPressed: {
            shiftKeyHold = true
        }
        onShiftReleased: {
            shiftKeyHold = false
            handle_modifier_keys_released("2")
        }
        onWheelKeyReleased: {
            handle_modifier_keys_released("3")
        }
    }

    Connections {
        target: mainView
        onVisibleChanged: {
            if(mainView.visible){
                showCursorX = cursorX
                showCursorY = cursorY
                mainView.adjustPosition()
            }
            else{
                topToolBarBox.visible = false
                ocrResultWindow.height = contentHeight
                mainView.setHeight(contentHeight)
            }
        }
    }

    Item {
        id: topToolBarBox
        width: parent.width
        height: visible ? 26 : 0
        visible: false

        Image {
             id: logoImage
             anchors.verticalCenter: parent.verticalCenter
             anchors.left: parent.left
             source: "images/ocr_tools/ocr_title_bg.png"
        }

        DragableArea {
            id: dragableArea
            anchors.fill: parent
            window: mainView
            property bool hasDrag: false

            onDragFinished: {
                if (!hasDrag){
                    pinButton.active = true
                    hasDrag = true
                    }
                 }
        }
         ImageButton{
              id:copyButton
              anchors.right: settingButton.left
              anchors.rightMargin: 8
              anchors.verticalCenter: parent.verticalCenter
              normal_image: "images/ocr_tools/ocr_copy_normal.png"
              hover_image: "images/ocr_tools/ocr_copy_hover.png"
              press_image: "images/ocr_tools/ocr_copy_normal.png"
              onClicked: windowApi.copyText(contentColumn.getResultContent())
         }
         ImageButton{
              id:settingButton
              anchors.right: pinButton.left
              anchors.rightMargin: 8
              anchors.verticalCenter: parent.verticalCenter
              normal_image: "images/ocr_tools/ocr_setting_normal.png"
              hover_image: "images/ocr_tools/ocr_setting_hover.png"
              press_image: "images/ocr_tools/ocr_setting_normal.png"
              onClicked: {
                    if(!isPinned()){
                        hideWindow()
                    }
                    windowApi.option(1)
              }
          }
          ImageCheckButton {
             id: pinButton
             anchors.right: closeButton.left
             anchors.rightMargin: 8
             anchors.verticalCenter: parent.verticalCenter
             inactivatedNormalImage: "images/ocr_tools/ocr_pin_normal.png"
             inactivatedHoverImage: "images/ocr_tools/ocr_pin_hover.png"
             inactivatedPressImage: "images/ocr_tools/ocr_pin_normal.png"

             activatedNormalImage: "images/ocr_tools/ocr_unpin_normal.png"
             activatedHoverImage: "images/ocr_tools/ocr_unpin_hover.png"
             activatedPressImage: "images/ocr_tools/ocr_unpin_normal.png"
          }
          ImageButton{
             id: closeButton
             anchors.verticalCenter: parent.verticalCenter
             anchors.right: parent.right
             anchors.rightMargin: 8
             normal_image: "images/ocr_tools/ocr_close_normal.png"
             hover_image: "images/ocr_tools/ocr_close_hover.png"
             press_image: "images/ocr_tools/ocr_close_normal.png"
             onClicked: hideWindow()
          }
    }


    Rectangle {
        id: resultBox
        anchors.top: topToolBarBox.bottom
        width: parent.width
        height: contentFlickable.height + 4
        border.width: 2
        border.color: constant.blueColor

        DFlickable {
            id: contentFlickable
            width: parent.width
            height: 290
            clip: true

            TranslateContent{
                id: contentColumn
            }

            contentWidth: parent.width
            contentHeight: contentColumn.height

            onContentHeightChanged: {
                if(contentHeight < 290 && contentHeight > 0 ){
                    contentFlickable.height = contentHeight + 2
                }
                else{
                    contentFlickable.height = 290
                }
            }

        }
    }
}
