import QtQuick 2.2

Column {
    id: contentColumn
    property int textMargin: 8

    width: parent.width
    height: childrenRect.height

    anchors.left: parent.left
    anchors.right: parent.right
    anchors.leftMargin: textMargin
    anchors.rightMargin: textMargin

    property color contentFontColor: "#333"

    function queryDetail(){
        windowApi.showMainWindow()
        windowApi.emitDictQuery(translateInfo.text, translateInfo.lang)
    }

    function getResultContent(){
        var copyTextContent = translateInfo.text
        if(translateInfo.phonetic != ""){
            copyTextContent += " [%1]\n".arg(translateInfo.phonetic)
        }
        copyTextContent += "基本翻译\n"
        copyTextContent += "%1\n".arg(translateInfo.trans)
        copyTextContent += "网络释义\n"
        copyTextContent += "%1\n".arg(translateInfo.webtrans)
        return copyTextContent
    }

    // word tool line
    Row {
        id: wordToolLine
        width: parent.width
        height:keywordsText.height +12
        spacing:6

        TextEdit{
            id: keywordsText
            anchors.verticalCenter: parent.verticalCenter
            selectByMouse: true
            readOnly: true
            text: translateInfo.phonetic != "" ? translateInfo.text +"[%1]".arg(translateInfo.phonetic) : translateInfo.text 
            font.pixelSize: 13
            font.bold: true
            wrapMode: TextEdit.WordWrap
        }

        ImageButton{
            id: soundButton
            anchors.verticalCenter: parent.verticalCenter
            normal_image: (translateInfo.text != "" &&  translateInfo.phonetic != "") ? "images/sound-production-normal.png" : ""
            hover_image: (translateInfo.text != "" &&  translateInfo.phonetic != "")  ? "images/sound-production-hover.png" : ""
            press_image: hover_image
            pointingHandEnabled: true
            onClicked: {
                windowApi.playSound(translateInfo.voices[0])
            }
        }

        TextEdit {
            id: detailsText
            anchors.verticalCenter: parent.verticalCenter
            selectByMouse: true
            readOnly: true
            text: translateInfo.text != "" ? "详情>>" : ""
            font.pixelSize: 12
            color: "#2699eb"          

            MouseArea {
                anchors.fill: parent
                hoverEnabled: true

                onEntered: {
                    cursorShape = Qt.PointingHandCursor
                }
                onExited: {
                    cursorShape = Qt.ArrowCursor
                }
                onClicked: {
                    queryDetail()
                }
            }
        }
    }

    TextEdit {
        id: trans
        text:translateInfo.text != "" ? translateInfo.trans : "译文："  + translateInfo.trans
        width: parent.width
        wrapMode: TextEdit.WordWrap
        selectByMouse: true
        font { pixelSize: 14 }
        readOnly: true
        color: contentFontColor
        font.family: "WenQuanYi Micro Hei"
    }

    Item {
        width: parent.width
        height: 10
    }
}
