cr.define('options', function () {
  var OptionsPage = options.OptionsPage;
  function PrivacySecurity() {
    OptionsPage.call(
      this,
      'privacySecurity',
      '隐私安全设置' /*templateData.privacySecurityTabTitle*/,
      'privacySecurityPage'
    );
  }

  cr.addSingletonGetter(PrivacySecurity);
  var iTime = 0; //发送gif打点，节流 监听多次触发
  var tabDivArr = []; // 数过长，tabs宽度数组集合
  PrivacySecurity.prototype = {
    __proto__: options.OptionsPage.prototype,

    initializePage: function () {
      OptionsPage.prototype.initializePage.call(this);
      Preferences.getInstance().addEventListener(
        'prviacy_protection.enabled',
        function (e) {
          // 启用防追踪隐私保护模式
          if (!e.value.value) {
            $('.privacy-tips-open').classList.remove('hide');
            $('.privacy-main-show-no').classList.remove('hide');
          } else {
            $('.privacy-tips-open').classList.add('hide');
            $('.privacy-main-show-no').classList.add('hide');
            var ele = document.querySelector(
              '[pref="prviacy_protection.incognito_enabled"]'
            );
            !ele.checked && (ele.checked = true);
          }
        }
      );

      document.querySelector(
        '[pref="prviacy_protection.enabled"]'
      ).onclick = function (params) {
        console.log('2222', params.srcElement.checked);
        if (params.srcElement.checked) {
          //开启
          gifTime(150, '打开');
        } else {
          //关闭
          gifTime(150, '关闭');
        }
      };

      Preferences.getInstance().addEventListener(
        'prviacy_protection.new',
        function (e) {
          // new 出现与否  表示 用户是否打开过
          if (!e.value.value) {
            $('.privacy-new').classList.remove('hide');
          }
        }
      );
      $('#navbar-container').addEventListener(
        'click',
        function (e) {
          //导航到 隐私设置页
          if (e.srcElement.id === 'privacySecurityPageNav') {
            trendsWid(obj_trends); // tabs根据拦截次数动态调整样式

            if ($('.privacy-new').className.indexOf('hide') === -1) {
              // 说明当前new 标识出现
              $('.privacy-new').classList.add('hide');
              var _obj = ['prviacy_protection.new', true];
              chrome.send('setBooleanPref', _obj);
            }
          }
        },
        false
      );

      window._onFetchCount = function (prefs) {
        // 柱状图渲染
        barData(prefs);
      };
      chrome.send('fetchPrefs', ['_onFetchCount', 'prviacy_protection.count']);

      window._onFetchIgList = function (prefs) {
        // 白名单地址
        whiteList(prefs);
      };
      chrome.send('fetchPrefs', [
        '_onFetchIgList',
        'prviacy_protection.ignore_list',
      ]);
    },

    /**
     * onShowPage
     */
    didShowPage: function () {
      if (!this.tabsInited) {
          this.tabsInited = true;
          setTimeout(() => {
            //DOM 准备就绪后执行
            $('#aKc').click(); //tabs初始点击
          }, 0);
        }
    }
  };
  function gifTime(timeLong, title) {
    //因addEventListener监听改变一次会触发几十次，故设置150ms内只打一次点
    clearTimeout(iTime);
    iTime = setTimeout(function () {
      gif('1158.9042.gif', {
        _referer: title,
      });
    }, timeLong);
  }
  /**
   * 柱状图处理
   */
  var obj_trends = [
    {
      cls: '.aKcData',
      line: '.line-1',
      id: '#kc',
    },
    {
      cls: '.xxData',
      line: '.line-2',
      id: '#xx',
    },
    {
      cls: '.jnData',
      line: '.line-3',
      id: '#jn',
    },
    {
      cls: '.wjnData',
      line: '.line-4',
      id: '#wjn',
    },
  ];
  function barData(data) {
    //星期模块 start
    var weeks = [];
    var curDateArr = [];
    for (let i = 0; i < 7; i++) {
      var date = GetDateStr(-i);
      curDateArr.push(date.split('-').join(''));
      var day = new Date(date).getDay();
      var hml = '';
      var nowuse = i === 0 ? '今日' : getWeekDate(day);
      hml = '<li>' + nowuse + '</li>';
      weeks.unshift(hml);
    }
    $('.bar-date').innerHTML = weeks.join('');
    //星期模块 end
    var use_count = data.prviacy_protection.count.value;
    var clearedArr = []; // 挑出来最近7天的数据
    curDateArr.forEach((item) => {
      use_count[item]
        ? clearedArr.unshift(use_count[item])
        : clearedArr.unshift({});
    });

    // 柱状图高度计算 start
    var sumArr = []; //所有情况每天出现总次数
    var tabsUsePr = 0,
      tabsUseSo = 0,
      tabsUseCr = 0,
      tabsUseFi = 0;
    clearedArr.forEach((item) => {
      var tempArr = Object.values(item);
      item.pr && (tabsUsePr += item.pr);
      item.so && (tabsUseSo += item.so);
      item.cr && (tabsUseCr += item.cr);
      item.fi && (tabsUseFi += item.fi);
      var sum = tempArr.reduce(function (prev, cur) {
        return prev + cur;
      }, 0);
      sumArr.push(sum);
    });
    $('.privacy-main-show-total').innerText =
      tabsUseSo + tabsUsePr + tabsUseFi + tabsUseCr;
    $('.aKcData').innerText = tabsUseSo;
    $('.xxData').innerText = tabsUsePr;
    $('.jnData').innerText = tabsUseFi;
    $('.wjnData').innerText = tabsUseCr;

    if (
      $('#privacySecurityPageNav').className.indexOf('navbar-item-selected') >
      -1
    ) {
      trendsWid(obj_trends); // tabs根据拦截次数动态调整样式
    }
    // $('#navbar-container').addEventListener("click", function (e) {
    //   if (e.srcElement.id === 'privacySecurityPageNav') {
    //     trendsWid(obj_trends) // tabs根据拦截次数动态调整样式
    //   }
    // }, false)

    var maxValueBar = Math.max(...sumArr); // 找出最大值
    var barHml = [];
    clearedArr.forEach((item, i) => {
      var bar_str = '';
      var _hei = ''; //按照最高定柱状图高度，单位为px
      if (maxValueBar < 200) {
        _hei = 50;
      } else if (maxValueBar >= 200) {
        _hei = 100;
      }
      var one_hei = '',
        two_hei = '',
        three_hei = '',
        four_hei = ''; // 实际占柱状图所占高度
      one_hei = (!item.so ? 0 : item.so / maxValueBar) * _hei;
      two_hei = (!item.pr ? 0 : item.pr / maxValueBar) * _hei;
      three_hei = (!item.fi ? 0 : item.fi / maxValueBar) * _hei;
      four_hei = (!item.cr ? 0 : item.cr / maxValueBar) * _hei;
      bar_str = `<li>
                  <p class="bar-one" style="height:${one_hei}px;bottom:0;"></p>
                  <p class="bar-two" style="height:${two_hei}px;bottom:${one_hei}px;"></p>
                  <p class="bar-three" style="height:${three_hei}px;bottom:${
        one_hei + two_hei
      }px;"></p>
                  <p class="bar-four" style="height:${four_hei}px;bottom:${
        one_hei + two_hei + three_hei
      }px;"></p>
                  <span style="bottom:${
                    one_hei + two_hei + three_hei + four_hei + 5
                  }px;">${sumArr[i] ? sumArr[i] : 0}</span>
                </li>`;
      barHml.push(bar_str);
    });
    $('.show-bar-status').querySelector('.bar-height').innerHTML = barHml.join(
      ''
    );
    // 柱状图高度计算 end
  }
  /**
   * 白名单数据收集
   */
  function whiteList(data) {
    data = data.prviacy_protection.ignore_list.value;
    listGet(arraySortByName(data));
    $('.privacy-white-list').onclick = function (e) {
      if (e.srcElement.localName === 'span') {
        //删除该条记录
        var index = Number(e.srcElement.getAttribute('data-index'));
        data.splice(index, 1);
        listGet(data);
        var obj = ['prviacy_protection.ignore_list', JSON.stringify(data)];
        chrome.send('setListPref', obj);
      }
    };

    return; //本期需求不需要添加和网站可编辑

    $('.privacy-white-list').onkeypress = function (e) {
      if (e.keyCode === 13) {
        checkData(e.srcElement.innerText);
        e.preventDefault();
      }
    };
    $('.privacy-white-list').onclick = function (e) {
      const srcEle = e.srcElement;
      if (srcEle.localName === 'p') {
        srcEle.contentEditable = true;
        srcEle.focus();
        srcEle.onblur = function (e) {
          // div 失去焦点的动作
          console.log('eeee', srcEle.innerText);

          if (srcEle.className === 'new-input') {
            //新添加
            checkData(srcEle.innerText);
          } else {
            //修改本条数据
          }
        };
      } else if (e.srcElement.localName === 'span') {
        //删除该条记录
        console.log('eee', e.srcElement.getAttribute('data-index'));
        var index = Number(e.srcElement.getAttribute('data-index'));
        allData.splice(index, 1);

        listGet(allData);
        // $('.privacy-white-ul').innerHTML = listGet(allData)
      }
    };
  }

  function checkData(text) {
    if (text.trim() && !allData.includes(text)) {
      // 输入有效且去重
      if (/.*[\u4e00-\u9fa5]+.*$/.test(text)) {
        //输入了中文
        var idn = new idnMapping();
        text = idn.toASCII(text);
      } else if (
        myIsNaN(text) ||
        (!hasLetter(text) && text.split('.').length > 1)
      ) {
        //输入的是数字 或者是 数字加.
        text = inputToIp(text);
      } else if (jageCharacter(text)) {
        //输入了特殊字符
        text = escape(text);
      }
      text && allData.push(text);
      listGet(arraySortByName(allData));
      var li_height = $('.privacy-white-list').offsetHeight;
      var inner_li_height = $('.privacy-white-ul').offsetHeight;
      console.log('inner_li_height - li_height', li_height - inner_li_height);
      var diffH = inner_li_height - li_height;
      diffH > -20 && ($('.privacy-white-list').scrollTop = diffH + 36);
    }
    $('.new-input').innerText = '';
  }

  // 转ip
  function inputToIp(number) {
    var rightIp = '';
    var initArr = number.split('.');
    if (initArr.length === 2) {
      //输入了ip地址的两位 要补全
      initArr.splice(1, 0, '0');
      initArr.splice(2, 0, '0');
      rightIp = initArr.join('.');
    } else if (initArr.length === 3) {
      //输入了ip地址的三位 要补全
      initArr.splice(2, 0, '0');
      console.log('2', initArr);
      rightIp = initArr.join('.');
    } else if (initArr.length > 3) {
      //输入ip 超过三位
      rightIp = number;
    } else {
      number = Number(number);
      var ip =
        Math.floor(number / (256 * 256 * 256)) +
        '.' +
        Math.floor((number % (256 * 256 * 256)) / (256 * 256)) +
        '.' +
        Math.floor((number % (256 * 256)) / 256) +
        '.' +
        Math.floor(number % 256);
      var ipArr = ip.split('.');
      var useArr = ipArr.filter((el) => {
        //ip地址不能大于256
        return el < 256;
      });
      rightIp = useArr.length < 4 ? false : ip;
    }
    return rightIp;
  }

  /***************************** 以下均为工具函数 无实际逻辑 ***********************************************************************/
  /**
   * 因数字过长 动态调整tabs
   * @param {*} obj
   */
  function trendsWid(obj) {
    obj.forEach(function (item, i) {
      var wid = $(item.cls).offsetWidth;
      $(item.line).style.width = 22 + wid + 'px'; // 22为次数过长时候，动态调整的校验值
      if (wid > 30) {
        // 30为tabs宽度校验值
        wid = wid - 30;
        var xxx = 80 + wid;
        tabDivArr.push(xxx);

        $(item.line).parentElement.style.width = xxx + 'px'; //80为tabs初始宽度
        if (obj[i + 1]) {
          var id = obj[i + 1].id;
          var totalNum = tabDivArr.reduce(function (prev, cur) {
            return prev + cur;
          }, 0);

          $(id).style.marginLeft = -totalNum + 'px';
        }
      }
    });
  }

  /**
   * 获取指定天数的日期
   * @param {*} 数组 可以为正负 ，代表当前前后日期
   */
  function GetDateStr(AddDayCount) {
    var dd = new Date();
    dd.setDate(dd.getDate() + AddDayCount); //获取AddDayCount天前的日期
    var y = dd.getFullYear();
    var m = dd.getMonth() + 1; //获取当前月份的日期
    m = m < 10 ? '0' + m : m;
    var d = dd.getDate();
    d = d < 10 ? '0' + d : d;
    return y + '-' + m + '-' + d;
  }
  /**
   * 获取是周几
   * @param {day} 周几的数字表示
   */
  function getWeekDate(day) {
    var now = new Date();
    var weeks = new Array(
      '周日',
      '周一',
      '周二',
      '周三',
      '周四',
      '周五',
      '周六'
    );
    var week = weeks[day];
    return week;
  }

  /**
   * $ 工具函数
   * @param {*} id
   */
  function $(id) {
    if (id.indexOf('.') > -1) {
      return document.querySelector(id);
    } else if (id.indexOf('#') > -1) {
      id = id.substr(1);
      return document.getElementById(id);
    } else {
      return document.getElementsByTagName(id)[0];
    }
  }

  function listGet(data) {
    var hml = [];
    data.forEach((ele, i) => {
      var str = `<li class="privacy-li">
            <p>${ele}</p>
            <span data-index='${i}'></span>
          </li>`;
      hml.push(str);
    });
    $('.privacy-white-ul').innerHTML = hml.join('');
  }

  /**
   *NaN 判断
   * @param {*} value
   * @returns
   */
  function myIsNaN(value) {
    value = Number(value);
    return typeof value === 'number' && !isNaN(value);
  }

  /**
   *是否有特殊字符
   *
   * @param {*} str
   * @returns
   */
  function jageCharacter(str) {
    var containSpecial = RegExp(
      /[(\ )(\~)(\!)(\@)(\#)(\$)(\%)(\^)(\&)(\*)(\()(\))(\-)(\_)(\+)(\=)(\[)(\])(\{)(\})(\|)(\\)(\;)(\:)(\')(\")(\,)(\.)(\/)(\<)(\>)(\?)(\)]+/
    );
    return containSpecial.test(str);
  }

  /**
   *数字、字母排序
   *
   * @param {*} list
   * @returns
   */
  function arraySortByName(list) {
    if (list === undefined || list === null) return [];
    list.sort((a, b) => {
      let strA = a;
      let strB = b;
      if (
        strA === undefined ||
        strA === null ||
        strA === '' ||
        strA === ' ' ||
        strA === '　'
      ) {
        return -1;
      }
      if (
        strB === undefined ||
        strB === null ||
        strB === '' ||
        strB === ' ' ||
        strB === '　'
      ) {
        return 1;
      }
      if (
        (strA.split('').every((char) => notChinese(char)) &&
          strB.split('').every((char) => notChinese(char))) ||
        (strA.split('').every((char) => !notChinese(char)) &&
          strB.split('').every((char) => !notChinese(char)))
      ) {
        return strA.localeCompare(strB);
      } else {
        const charAry = strA.split('');
        for (const i in charAry) {
          if (charCompare(strA[i], strB[i]) !== 0) {
            return charCompare(strA[i], strB[i]);
          }
        }
        // 如果通过上面的循环对比还比不出来，就无解了，直接返回-1
        return -1;
      }
    });
    return list;
  }

  function charCompare(charA, charB) {
    if (
      charA === undefined ||
      charA === null ||
      charA === '' ||
      charA === ' ' ||
      charA === '　'
    ) {
      return -1;
    }
    if (
      charB === undefined ||
      charB === null ||
      charB === '' ||
      charB === ' ' ||
      charB === '　'
    ) {
      return 1;
    }
    // 如果都为英文或者都为汉字则直接对比
    if (
      (notChinese(charA) && notChinese(charB)) ||
      (!notChinese(charA) && !notChinese(charB))
    ) {
      return charA.localeCompare(charB);
    } else {
      // 如果不都为英文或者汉字，就肯定有一个是英文，如果a是英文，返回-1，a在前，否则就是b是英文，b在前
      if (notChinese(charA)) {
        return -1;
      } else {
        return 1;
      }
    }
  }

  /**
   *判断是否有中文
   * @param {*} char
   * @returns
   */
  function notChinese(char) {
    const charCode = char.charCodeAt(0);
    return charCode >= 0 && charCode <= 128;
  }

  /**
   *判断是否包含字母
   *
   * @param {*} str
   * @returns
   */
  function hasLetter(str) {
    for (var i in str) {
      var asc = str.charCodeAt(i);
      if ((asc >= 65 && asc <= 90) || (asc >= 97 && asc <= 122)) {
        return true;
      }
    }
    return false;
  }

  /**
   *  中文转 punyCode
   */
  (function (w) {
    var PunycodeModule = function () {
      function IdnMapping() {
        this.utf16 = {
          decode: function (input) {
            var output = [],
              i = 0,
              len = input.length,
              value,
              extra;
            while (i < len) {
              value = input.charCodeAt(i++);
              if ((value & 0xf800) === 0xd800) {
                extra = input.charCodeAt(i++);
                if (
                  (value & 0xfc00) !== 0xd800 ||
                  (extra & 0xfc00) !== 0xdc00
                ) {
                  throw new RangeError(
                    'UTF-16(decode): Illegal UTF-16 sequence'
                  );
                }
                value = ((value & 0x3ff) << 10) + (extra & 0x3ff) + 0x10000;
              }
              output.push(value);
            }
            return output;
          },
          encode: function (input) {
            var output = [],
              i = 0,
              len = input.length,
              value;
            while (i < len) {
              value = input[i++];
              if ((value & 0xf800) === 0xd800) {
                throw new RangeError('UTF-16(encode): Illegal UTF-16 value');
              }
              if (value > 0xffff) {
                value -= 0x10000;
                output.push(
                  String.fromCharCode(((value >>> 10) & 0x3ff) | 0xd800)
                );
                value = 0xdc00 | (value & 0x3ff);
              }
              output.push(String.fromCharCode(value));
            }
            return output.join('');
          },
        };

        var initial_n = 0x80;
        var initial_bias = 72;
        var delimiter = '\x2D';
        var base = 36;
        var damp = 700;
        var tmin = 1;
        var tmax = 26;
        var skew = 38;
        var maxint = 0x7fffffff;

        function decode_digit(cp) {
          return cp - 48 < 10
            ? cp - 22
            : cp - 65 < 26
            ? cp - 65
            : cp - 97 < 26
            ? cp - 97
            : base;
        }

        function encode_digit(d, flag) {
          return d + 22 + 75 * (d < 26) - ((flag != 0) << 5);
        }

        function adapt(delta, numpoints, firsttime) {
          var k;
          delta = firsttime ? Math.floor(delta / damp) : delta >> 1;
          delta += Math.floor(delta / numpoints);

          for (k = 0; delta > ((base - tmin) * tmax) >> 1; k += base) {
            delta = Math.floor(delta / (base - tmin));
          }
          return Math.floor(k + ((base - tmin + 1) * delta) / (delta + skew));
        }

        function encode_basic(bcp, flag) {
          bcp -= (bcp - 97 < 26) << 5;
          return bcp + ((!flag && bcp - 65 < 26) << 5);
        }

        this.decode = function (input, preserveCase) {
          // Dont use utf16
          var output = [];
          var case_flags = [];
          var input_length = input.length;

          var n, out, i, bias, basic, j, ic, oldi, w, k, digit, t, len;

          // Initialize the state:

          n = initial_n;
          i = 0;
          bias = initial_bias;

          // Handle the basic code points: Let basic be the number of input code
          // points before the last delimiter, or 0 if there is none, then
          // copy the first basic code points to the output.

          basic = input.lastIndexOf(delimiter);
          if (basic < 0) basic = 0;

          for (j = 0; j < basic; ++j) {
            if (preserveCase)
              case_flags[output.length] = input.charCodeAt(j) - 65 < 26;
            if (input.charCodeAt(j) >= 0x80) {
              throw new RangeError('Illegal input >= 0x80');
            }
            output.push(input.charCodeAt(j));
          }

          // Main decoding loop: Start just after the last delimiter if any
          // basic code points were copied; start at the beginning otherwise.

          for (ic = basic > 0 ? basic + 1 : 0; ic < input_length; ) {
            // ic is the index of the next character to be consumed,

            // Decode a generalized variable-length integer into delta,
            // which gets added to i. The overflow checking is easier
            // if we increase i as we go, then subtract off its starting
            // value at the end to obtain delta.
            for (oldi = i, w = 1, k = base; ; k += base) {
              if (ic >= input_length) {
                throw RangeError('punycode_bad_input(1)');
              }
              digit = decode_digit(input.charCodeAt(ic++));

              if (digit >= base) {
                throw RangeError('punycode_bad_input(2)');
              }
              if (digit > Math.floor((maxint - i) / w)) {
                throw RangeError('punycode_overflow(1)');
              }
              i += digit * w;
              t = k <= bias ? tmin : k >= bias + tmax ? tmax : k - bias;
              if (digit < t) {
                break;
              }
              if (w > Math.floor(maxint / (base - t))) {
                throw RangeError('punycode_overflow(2)');
              }
              w *= base - t;
            }

            out = output.length + 1;
            bias = adapt(i - oldi, out, oldi === 0);

            // i was supposed to wrap around from out to 0,
            // incrementing n each time, so we'll fix that now:
            if (Math.floor(i / out) > maxint - n) {
              throw RangeError('punycode_overflow(3)');
            }
            n += Math.floor(i / out);
            i %= out;

            // Insert n at position i of the output:
            // Case of last character determines uppercase flag:
            if (preserveCase) {
              case_flags.splice(i, 0, input.charCodeAt(ic - 1) - 65 < 26);
            }

            output.splice(i, 0, n);
            i++;
          }
          if (preserveCase) {
            for (i = 0, len = output.length; i < len; i++) {
              if (case_flags[i]) {
                output[i] = String.fromCharCode(output[i])
                  .toUpperCase()
                  .charCodeAt(0);
              }
            }
          }
          return this.utf16.encode(output);
        };

        this.encode = function (input, preserveCase) {
          //** Bias adaptation function **

          var n, delta, h, b, bias, j, m, q, k, t, ijv, case_flags;

          if (preserveCase) {
            // Preserve case, step1 of 2: Get a list of the unaltered string
            case_flags = this.utf16.decode(input);
          }
          // Converts the input in UTF-16 to Unicode
          input = this.utf16.decode(input.toLowerCase());

          var input_length = input.length; // Cache the length

          if (preserveCase) {
            // Preserve case, step2 of 2: Modify the list to true/false
            for (j = 0; j < input_length; j++) {
              case_flags[j] = input[j] != case_flags[j];
            }
          }

          var output = [];

          // Initialize the state:
          n = initial_n;
          delta = 0;
          bias = initial_bias;

          // Handle the basic code points:
          for (j = 0; j < input_length; ++j) {
            if (input[j] < 0x80) {
              output.push(
                String.fromCharCode(
                  case_flags ? encode_basic(input[j], case_flags[j]) : input[j]
                )
              );
            }
          }

          h = b = output.length;

          // h is the number of code points that have been handled, b is the
          // number of basic code points

          if (b > 0) output.push(delimiter);

          // Main encoding loop:
          //
          while (h < input_length) {
            // All non-basic code points < n have been
            // handled already. Find the next larger one:

            for (m = maxint, j = 0; j < input_length; ++j) {
              ijv = input[j];
              if (ijv >= n && ijv < m) m = ijv;
            }

            // Increase delta enough to advance the decoder's
            // <n,i> state to <m,0>, but guard against overflow:

            if (m - n > Math.floor((maxint - delta) / (h + 1))) {
              throw RangeError('punycode_overflow (1)');
            }
            delta += (m - n) * (h + 1);
            n = m;

            for (j = 0; j < input_length; ++j) {
              ijv = input[j];

              if (ijv < n) {
                if (++delta > maxint) return Error('punycode_overflow(2)');
              }

              if (ijv == n) {
                // Represent delta as a generalized variable-length integer:
                for (q = delta, k = base; ; k += base) {
                  t = k <= bias ? tmin : k >= bias + tmax ? tmax : k - bias;
                  if (q < t) break;
                  output.push(
                    String.fromCharCode(
                      encode_digit(t + ((q - t) % (base - t)), 0)
                    )
                  );
                  q = Math.floor((q - t) / (base - t));
                }
                output.push(
                  String.fromCharCode(
                    encode_digit(q, preserveCase && case_flags[j] ? 1 : 0)
                  )
                );
                bias = adapt(delta, h + 1, h == b);
                delta = 0;
                ++h;
              }
            }

            ++delta, ++n;
          }
          return output.join('');
        };
      }

      this.toASCII = function (domain) {
        var idn = new IdnMapping();
        var domainarray = domain.split('.');
        var out = [];
        for (var i = 0; i < domainarray.length; ++i) {
          var s = domainarray[i];
          out.push(s.match(/[^A-Za-z0-9-]/) ? 'xn--' + idn.encode(s) : s);
        }
        return out.join('.');
      };

      this.toUnicode = function (domain) {
        var idn = new IdnMapping();
        var domainarray = domain.split('.');
        var out = [];
        for (var i = 0; i < domainarray.length; ++i) {
          var s = domainarray[i];
          out.push(s.match(/^xn--/) ? idn.decode(s.slice(4)) : s);
        }
        return out.join('.');
      };
    };

    w.idnMapping = PunycodeModule;
  })(window);

  return {
    PrivacySecurity: PrivacySecurity,
  };
});
