(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["IMKITModule"] = factory();
	else
		root["IMKITModule"] = factory();
})(this, function() {
return webpackJsonpIMKITModule([0],[
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__(1);


/***/ },
/* 1 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$IMSDKRoot = __webpack_require__(2);

	var _$IMSDKRoot2 = _interopRequireDefault(_$IMSDKRoot);

	var _$BaseRoot = __webpack_require__(3);

	var _$BaseRoot2 = _interopRequireDefault(_$BaseRoot);

	var _$FileListRoot = __webpack_require__(4);

	__webpack_require__(45);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	window.addEventListener('DOMContentLoaded', function () {
	  _$FileListRoot.Win.container = document.getElementById('J_fileListWrap');
	  _$FileListRoot.Plugin.init({ container: _$FileListRoot.Win.container });
	  _$FileListRoot.Action.start.action();
	}); // 全局IMSDK引入， 使用fie babel时请注释

/***/ },
/* 2 */,
/* 3 */,
/* 4 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _actions = __webpack_require__(5);

	var _actions2 = _interopRequireDefault(_actions);

	var _constants = __webpack_require__(8);

	var _constants2 = _interopRequireDefault(_constants);

	var _plugins = __webpack_require__(36);

	var _plugins2 = _interopRequireDefault(_plugins);

	var _sdk = __webpack_require__(7);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _template = __webpack_require__(17);

	var _template2 = _interopRequireDefault(_template);

	var _window = __webpack_require__(13);

	var _window2 = _interopRequireDefault(_window);

	var _coms = __webpack_require__(43);

	var _coms2 = _interopRequireDefault(_coms);

	var _event = __webpack_require__(32);

	var _event2 = _interopRequireDefault(_event);

	__webpack_require__(44);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	exports.default = {
	  Action: _actions2.default,
	  Constant: _constants2.default,
	  Plugin: _plugins2.default,
	  SDK: _sdk2.default,
	  Template: _template2.default,
	  Coms: _coms2.default,
	  Win: _window2.default,
	  Event: _event2.default
	};
	module.exports = exports['default'];

/***/ },
/* 5 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _getFileList = __webpack_require__(6);

	var _getFileList2 = _interopRequireDefault(_getFileList);

	var _searchFileList = __webpack_require__(14);

	var _searchFileList2 = _interopRequireDefault(_searchFileList);

	var _renderFileList = __webpack_require__(15);

	var _renderFileList2 = _interopRequireDefault(_renderFileList);

	var _setMsgReadStatus = __webpack_require__(28);

	var _setMsgReadStatus2 = _interopRequireDefault(_setMsgReadStatus);

	var _getCurrentConversationID = __webpack_require__(29);

	var _getCurrentConversationID2 = _interopRequireDefault(_getCurrentConversationID);

	var _getCurrentLoginID = __webpack_require__(30);

	var _getCurrentLoginID2 = _interopRequireDefault(_getCurrentLoginID);

	var _bindEvents = __webpack_require__(31);

	var _bindEvents2 = _interopRequireDefault(_bindEvents);

	var _start = __webpack_require__(34);

	var _start2 = _interopRequireDefault(_start);

	var _fileRecall = __webpack_require__(35);

	var _fileRecall2 = _interopRequireDefault(_fileRecall);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	exports.default = {
	  getFileList: _getFileList2.default,
	  searchFileList: _searchFileList2.default,
	  renderFileList: _renderFileList2.default,
	  setMsgReadState: _setMsgReadStatus2.default,
	  getCurrentConversationID: _getCurrentConversationID2.default,
	  getCurrentLoginID: _getCurrentLoginID2.default,
	  bindEvents: _bindEvents2.default,
	  start: _start2.default,
	  fileRecall: _fileRecall2.default
	};
	module.exports = exports['default'];

/***/ },
/* 6 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _index = __webpack_require__(5);

	var _index2 = _interopRequireDefault(_index);

	var _sdk = __webpack_require__(7);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _window = __webpack_require__(13);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	function _toConsumableArray(arr) {
	  if (Array.isArray(arr)) {
	    for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
	      arr2[i] = arr[i];
	    }return arr2;
	  } else {
	    return Array.from(arr);
	  }
	} /**
	   * Created by neitherzhu on 2017/5/8.
	   */

	var Util = _$BaseRoot.Base.Util,
	    ActionCreator = _$BaseRoot.Base.ActionCreator;

	var getFileList = new ActionCreator();

	getFileList.actionType = 'async';
	getFileList.count = 20;
	getFileList.hasNextPage = true;

	getFileList.before(function (context, param) {
	  if (param && param.reset) {
	    this.hasNextPage = true;

	    _window2.default.fileList = [];
	  }
	  if (!this.hasNextPage) return false;
	});

	getFileList.before(function (context, param) {

	  !param && (param = {});
	  !param.cid && (param.cid = Util.getCid(_window2.default.conversationID));
	  typeof param.nextkey === 'undefined' && (param.nextkey = this.nextkey || '');
	  !param.count && (param.count = this.count);

	  context.param = param;
	});

	getFileList.doAsync = function (context) {
	  var _this = this;

	  return new Promise(function (resolve, reject) {
	    _sdk2.default.getFileList(context.param).then(function (data) {
	      _this.hasNextPage = !!data.nextkey;
	      _this.nextkey = data.nextkey;
	      resolve(data);
	    }).catch(function (e) {
	      _this.hasNextPage = false;
	      _index2.default.renderFileList.action();
	      reject(e);
	    });
	  });
	};

	getFileList.after(function (context, data) {
	  var fileList = data && data.filesList;

	  fileList && (_window2.default.fileList = [].concat(_toConsumableArray(_window2.default.fileList), _toConsumableArray(fileList)));

	  _index2.default.renderFileList.action({
	    action: 'getFileList', reset: context.param.reset
	  }, fileList && fileList.length ? fileList : null, true);
	});

	exports.default = getFileList;
	module.exports = exports['default'];

/***/ },
/* 7 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _$IMSDKRoot = __webpack_require__(2);

	var _$IMSDKRoot2 = _interopRequireDefault(_$IMSDKRoot);

	var _constants = __webpack_require__(8);

	var _constants2 = _interopRequireDefault(_constants);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	var Log = _$BaseRoot.Base.Log;

	var nativeSDK = _$IMSDKRoot2.default.invoke;
	var ONE_DAY_MS = 24 * 60 * 60 * 1000;
	var NOW = +new Date();
	var d = 0;
	var DATA = {
	  'filesList': [{
	    'fileInfo': {
	      'id': '4402',
	      'md5': '62f156d03cf16ac6c5bd4cb42dd8cee0',
	      'nodeName': '模板(23).txt',
	      'nodeSize': '16584',
	      'nodeType': 'file',
	      'parentId': '2803'
	    }, 'transferInfo': { 'filePath': '', 'progress': 0, 'status': 5, 'type': 1 }
	  }, {
	    'fileInfo': {
	      'id': '3606',
	      'md5': '62f156d03cf16ac6c5bd4cb42dd8cee0',
	      'nodeName': '模板(22).txt',
	      'nodeSize': '16584',
	      'nodeType': 'file',
	      'parentId': '2803'
	    }, 'transferInfo': { 'filePath': '', 'progress': 0, 'status': 5, 'type': 1 }
	  }, {
	    'fileInfo': {
	      'id': '3604',
	      'md5': '62f156d03cf16ac6c5bd4cb42dd8cee0',
	      'nodeName': '模板(21).txt',
	      'nodeSize': '16584',
	      'nodeType': 'file',
	      'parentId': '2803'
	    }, 'transferInfo': { 'filePath': '', 'progress': 0, 'status': 5, 'type': 1 }
	  }, {
	    'fileInfo': {
	      'id': '3602',
	      'md5': '62f156d03cf16ac6c5bd4cb42dd8cee0',
	      'nodeName': '模板(20).txt',
	      'nodeSize': '16584',
	      'nodeType': 'file',
	      'parentId': '2803'
	    }, 'transferInfo': { 'filePath': '', 'progress': 0, 'status': 5, 'type': 1 }
	  }, {
	    'fileInfo': {
	      'id': '3600',
	      'md5': '62f156d03cf16ac6c5bd4cb42dd8cee0',
	      'nodeName': '模板(19).txt',
	      'nodeSize': '16584',
	      'nodeType': 'file',
	      'parentId': '2803'
	    }, 'transferInfo': { 'filePath': '', 'progress': 0, 'status': 5, 'type': 1 }
	  }, {
	    'fileInfo': {
	      'id': '3462',
	      'md5': '62f156d03cf16ac6c5bd4cb42dd8cee0',
	      'nodeName': '模板(13)(1)(3).txt',
	      'nodeSize': '16584',
	      'nodeType': 'file',
	      'parentId': '2803'
	    }, 'transferInfo': { 'filePath': '', 'progress': 0, 'status': 5, 'type': 1 }
	  }, {
	    'fileInfo': {
	      'id': '3460',
	      'md5': '62f156d03cf16ac6c5bd4cb42dd8cee0',
	      'nodeName': '模板(13)(1)(2).txt',
	      'nodeSize': '16584',
	      'nodeType': 'file',
	      'parentId': '2803'
	    }, 'transferInfo': { 'filePath': '', 'progress': 0, 'status': 5, 'type': 1 }
	  }, {
	    'fileInfo': {
	      'id': '3453',
	      'md5': '62f156d03cf16ac6c5bd4cb42dd8cee0',
	      'nodeName': '模板(13)(1)(1).txt',
	      'nodeSize': '16584',
	      'nodeType': 'file',
	      'parentId': '2803'
	    }, 'transferInfo': { 'filePath': '', 'progress': 0, 'status': 5, 'type': 1 }
	  }, {
	    'fileInfo': {
	      'id': '3429',
	      'md5': '62f156d03cf16ac6c5bd4cb42dd8cee0',
	      'nodeName': '模板(13)(1).txt',
	      'nodeSize': '16584',
	      'nodeType': 'file',
	      'parentId': '2803'
	    }, 'transferInfo': { 'filePath': '', 'progress': 0, 'status': 5, 'type': 1 }
	  }, {
	    'fileInfo': {
	      'id': '3427',
	      'md5': '62f156d03cf16ac6c5bd4cb42dd8cee0',
	      'nodeName': '模板(18).txt',
	      'nodeSize': '16584',
	      'nodeType': 'file',
	      'parentId': '2803'
	    }, 'transferInfo': { 'filePath': '', 'progress': 0, 'status': 5, 'type': 1 }
	  }, {
	    'fileInfo': {
	      'id': '3425',
	      'md5': '62f156d03cf16ac6c5bd4cb42dd8cee0',
	      'nodeName': '模板(17).txt',
	      'nodeSize': '16584',
	      'nodeType': 'file',
	      'parentId': '2803'
	    }, 'transferInfo': { 'filePath': '', 'progress': 0, 'status': 5, 'type': 1 }
	  }, {
	    'fileInfo': {
	      'id': '3423',
	      'md5': '62f156d03cf16ac6c5bd4cb42dd8cee0',
	      'nodeName': '模板(16).txt',
	      'nodeSize': '16584',
	      'nodeType': 'file',
	      'parentId': '2803'
	    }, 'transferInfo': { 'filePath': '', 'progress': 0, 'status': 5, 'type': 1 }
	  }, {
	    'fileInfo': {
	      'id': '3421',
	      'md5': '62f156d03cf16ac6c5bd4cb42dd8cee0',
	      'nodeName': '模板(15).txt',
	      'nodeSize': '16584',
	      'nodeType': 'file',
	      'parentId': '2803'
	    }, 'transferInfo': { 'filePath': '', 'progress': 0, 'status': 5, 'type': 1 }
	  }, {
	    'fileInfo': {
	      'id': '3419',
	      'md5': '62f156d03cf16ac6c5bd4cb42dd8cee0',
	      'nodeName': '模板(14).txt',
	      'nodeSize': '16584',
	      'nodeType': 'file',
	      'parentId': '2803'
	    }, 'transferInfo': { 'filePath': '', 'progress': 0, 'status': 5, 'type': 1 }
	  }, {
	    'fileInfo': {
	      'id': '3417',
	      'md5': '62f156d03cf16ac6c5bd4cb42dd8cee0',
	      'nodeName': '模板(13).txt',
	      'nodeSize': '16584',
	      'nodeType': 'file',
	      'parentId': '2803'
	    }, 'transferInfo': { 'filePath': '', 'progress': 0, 'status': 5, 'type': 1 }
	  }, {
	    'fileInfo': {
	      'id': '3415',
	      'md5': '62f156d03cf16ac6c5bd4cb42dd8cee0',
	      'nodeName': '模板(12).txt',
	      'nodeSize': '16584',
	      'nodeType': 'file',
	      'parentId': '2803'
	    }, 'transferInfo': { 'filePath': '', 'progress': 0, 'status': 5, 'type': 1 }
	  }, {
	    'fileInfo': {
	      'id': '3413',
	      'md5': '62f156d03cf16ac6c5bd4cb42dd8cee0',
	      'nodeName': '模板(11).txt',
	      'nodeSize': '16584',
	      'nodeType': 'file',
	      'parentId': '2803'
	    }, 'transferInfo': { 'filePath': '', 'progress': 0, 'status': 5, 'type': 1 }
	  }, {
	    'fileInfo': {
	      'id': '3411',
	      'md5': '62f156d03cf16ac6c5bd4cb42dd8cee0',
	      'nodeName': '模板(10).txt',
	      'nodeSize': '16584',
	      'nodeType': 'file',
	      'parentId': '2803'
	    }, 'transferInfo': { 'filePath': '', 'progress': 0, 'status': 5, 'type': 1 }
	  }, {
	    'fileInfo': {
	      'id': '3409',
	      'md5': '62f156d03cf16ac6c5bd4cb42dd8cee0',
	      'nodeName': '模板(9).txt',
	      'nodeSize': '16584',
	      'nodeType': 'file',
	      'parentId': '2803'
	    }, 'transferInfo': { 'filePath': '', 'progress': 0, 'status': 5, 'type': 1 }
	  }, {
	    'fileInfo': {
	      'id': '3407',
	      'md5': '62f156d03cf16ac6c5bd4cb42dd8cee0',
	      'nodeName': '模板(8).txt',
	      'nodeSize': '16584',
	      'nodeType': 'file',
	      'parentId': '2803'
	    }, 'transferInfo': { 'filePath': '', 'progress': 0, 'status': 5, 'type': 1 }
	  }], 'nextkey': '{"gmt_create":1490965084000,"id":3407}'
	};
	var DATA1 = { filesList: [] };
	DATA.filesList.forEach(function (file) {
	  file.time = NOW - d * Math.random().toFixed(2) * ONE_DAY_MS;
	  d++;
	  var nfile = Object.assign({}, file);
	  nfile.fileInfo = Object.assign({}, nfile.fileInfo);
	  nfile.fileInfo.nodeName = 'search_' + nfile.fileInfo.nodeName;
	  DATA1.filesList.push(nfile);
	});

	DATA.filesList.sort(function (a, b) {
	  return b.time - a.time;
	});
	DATA1.filesList.sort(function (a, b) {
	  return b.time - a.time;
	});

	_$IMSDKRoot2.default.invoke = function () {
	  var _arguments = arguments;

	  Log.blue('SDK invoke: ', arguments);

	  return new Promise(function (resolve, reject) {
	    var args = Array.prototype.slice.call(_arguments);
	    nativeSDK.apply(null, args).then(function (data) {
	      Log.green('SDK ' + args[0] + ' RESULT: ', data);
	      resolve(data && data.result ? data.result : data);
	    }).catch(function (e) {
	      Log.red('SDK ' + args[0] + ' ERROR: ', e);
	      reject(e);
	    });
	  });
	};

	exports.default = {

	  /**
	   * 获取当前登录的ID
	   * @param param
	   * @returns {Promise}
	   */
	  getCurrentLoginID: function getCurrentLoginID(param) {

	    return new Promise(function (resolve, reject) {
	      _$IMSDKRoot2.default.invoke(_constants2.default.SDK.GET_CURRENT_LOGIN_ID, param).then(function (data) {
	        resolve(data);
	      }).catch(function (err) {
	        reject(err);
	      });
	    });
	  },

	  /**
	   * 获取当前聊天的对象ID
	   * @param param
	   * @returns {Promise}
	   */
	  getCurrentConversationID: function getCurrentConversationID(param) {
	    return new Promise(function (resolve, reject) {
	      _$IMSDKRoot2.default.invoke(_constants2.default.SDK.GET_CURRENT_CONVERSATION_ID, param).then(function (data) {
	        resolve(data);
	      }).catch(function (err) {
	        reject(err);
	      });
	    });
	  },
	  getFileList: function getFileList(param) {

	    //return new Promise(resolve => {
	    //  setTimeout(function() {
	    //    resolve(DATA);
	    //  }, 1500);
	    //});
	    return _$IMSDKRoot2.default.invoke(_constants2.default.SDK.GET_FILE_LIST, param);
	  },
	  searchFileList: function searchFileList(param) {
	    //return new Promise(resolve => {
	    //  setTimeout(function() {
	    //    resolve(DATA1);
	    //  }, 1500);
	    //});

	    return _$IMSDKRoot2.default.invoke(_constants2.default.SDK.SEARCH_FILE_LIST, param);
	  },

	  /**
	   * 设置单聊消息已读
	   * @param param
	   */
	  setSingleMsgReadStatus: function setSingleMsgReadStatus(param) {
	    return _$IMSDKRoot2.default.invoke(_constants2.default.SDK.SET_SINGLE_MSG_READ_STATUS, param);
	  },
	  downloadCloudFile: function downloadCloudFile(param) {
	    return _$IMSDKRoot2.default.invoke(_constants2.default.SDK.DOWNLOAD_CLOUD_FILE, param);
	  },
	  cancelDownloadCloudFile: function cancelDownloadCloudFile(param) {
	    return _$IMSDKRoot2.default.invoke(_constants2.default.SDK.CANCEL_DOWNLOAD_CLOUD_FILE, param);
	  },
	  cancelUploadCloudFile: function cancelUploadCloudFile(param) {
	    return _$IMSDKRoot2.default.invoke(_constants2.default.SDK.CANCEL_UPLOAD_CLOUD_FILE, param);
	  },
	  previewCloudFile: function previewCloudFile(param) {
	    return _$IMSDKRoot2.default.invoke(_constants2.default.SDK.PREVIEW_CLOUD_FILE, param);
	  },
	  openFolder: function openFolder(param) {
	    return _$IMSDKRoot2.default.invoke(_constants2.default.SDK.OPEN_FOLDER, param);
	  },
	  deleteCloudFile: function deleteCloudFile(param) {
	    return _$IMSDKRoot2.default.invoke(_constants2.default.SDK.DELETE_CLOUD_FILE, param);
	  },
	  forwardMsg: function forwardMsg(param) {
	    _$IMSDKRoot2.default.invoke(_constants2.default.SDK.FORWARD_MSG, param);
	  }
	};
	module.exports = exports['default'];

/***/ },
/* 8 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _event = __webpack_require__(9);

	var _event2 = _interopRequireDefault(_event);

	var _sdk = __webpack_require__(10);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _language = __webpack_require__(11);

	var _language2 = _interopRequireDefault(_language);

	var _i18n = __webpack_require__(12);

	var _i18n2 = _interopRequireDefault(_i18n);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	var SINGLE = 1;
	var TRIBE = 2;
	var DISCUSSION = 2;
	var TYPE = {
	  SINGLE: SINGLE,
	  TRIBE: TRIBE,
	  DISCUSSION: DISCUSSION
	};

	exports.default = {
	  TYPE: TYPE,
	  Event: _event2.default,
	  SDK: _sdk2.default,
	  FILE_MAX_LEN: 24,
	  SDK_PREFIX_MAP: {
	    1: _sdk2.default.SINGLE_SDK_PREFIX,
	    2: _sdk2.default.TRIBE_SDK_PREFIX,
	    3: _sdk2.default.TRIBE_SDK_PREFIX
	  },
	  CLS: {
	    PREVIEW_FILE: 'J_previewFile',
	    // 打开文件夹
	    OPEN_FILE_FOLDER: 'J_openFolder',
	    // 取消上传
	    CANCEL_UPLOAD_FILE: 'J_cancelUpload',
	    // 取消下载
	    CANCEL_DOWNLOAD_FILE: 'J_cancelDownload',
	    // 下载
	    DOWNLOAD_FILE: 'J_downloadFile',
	    FORWARD_MSG: 'J_forwardMsg'
	  },

	  LANGUAGE: _language2.default,
	  I18N: _i18n2.default,
	  FILE_MSG_TYPE: 65649
	};
	module.exports = exports['default'];

/***/ },
/* 9 */
/***/ function(module, exports) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = {
	  // 文件传输状态变更
	  UPDATE_FILE_TRANSFER_INFO: 'im.filetransfer.onUpdateTransferInfo',
	  // 文件信息变更
	  UPDATE_FILE_INFO: 'im.filetransfer.onUpdateCloudFileMeta',

	  // 单聊消息撤回事件
	  CHAT_MSG_RECALLED: 'im.singlemsg.onMsgWithdrawNty',
	  // 群聊/讨论组消息撤回事件
	  TRIBE_MSG_RECALLED: 'im.tribemsg.onMsgWithdrawNty',

	  // 收到单聊消息
	  CHAT_RECEIVE_MSG: 'im.singlemsg.onReceiveNewMsg',
	  // 收到群聊/讨论组消息
	  TRIBE_RECEIVE_MSG: 'im.tribemsg.onReceiveNewMsg',
	  // 发送的单聊消息状态变更
	  CHAT_SEND_MSG_STATUS_CHANGE: 'im.singlemsg.onSendMsgStatus',
	  // 发送的群聊/讨论组消息状态变更
	  TRIBE_SEND_MSG_STATUS_CHANGE: 'im.tribemsg.onSendMsgStatus'

	};
	module.exports = exports['default'];

/***/ },
/* 10 */
/***/ function(module, exports) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = {
	  SINGLE_SDK_PREFIX: 'im.singlemsg.',
	  TRIBE_SDK_PREFIX: 'im.tribemsg.',
	  FILE_TRANSFER_PREFIX: 'im.filetransfer.',

	  FORWARD_MSG: 'im.bizutil.ForwardChatMsg',
	  DOWNLOAD_CLOUD_FILE: 'im.filetransfer.DownloadCloudFile',
	  PREVIEW_CLOUD_FILE: 'im.filetransfer.PreviewCloudFile',

	  CANCEL_DOWNLOAD_CLOUD_FILE: 'im.filetransfer.CancelDownloadCloudFile',
	  CANCEL_UPLOAD_CLOUD_FILE: 'im.filetransfer.CancelUploadFile',
	  OPEN_FOLDER: 'im.filetransfer.OpenFolder',
	  DELETE_CLOUD_FILE: 'im.filetransfer.DeleteCloudFile',

	  // 获取当前登录用户
	  GET_CURRENT_LOGIN_ID: 'im.login.GetCurrentLoginID',
	  // 获取当前聊天对象
	  GET_CURRENT_CONVERSATION_ID: 'im.uiutil.GetCurrentConversationID',
	  GET_FILE_LIST: 'im.filetransfer.GetCloudFileList',
	  SEARCH_FILE_LIST: 'im.filetransfer.SearchCloudFiles',
	  // 设置单聊消息已读
	  SET_SINGLE_MSG_READ_STATUS: 'im.singlemsg.SetFlagsPeerMsgReaded'
	};
	module.exports = exports['default'];

/***/ },
/* 11 */
/***/ function(module, exports) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	/**
	 * Created by neitherzhu on 2017/5/25.
	 */
	exports.default = 'CN';
	module.exports = exports['default'];

/***/ },
/* 12 */
/***/ function(module, exports) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	/**
	 * Created by neitherzhu on 2017/5/25.
	 */
	exports.default = {
	  CN: {
	    TODAY: '今天',
	    YESTERDAY: '昨天',
	    THIS_WEEK: '本周'
	  },

	  EN: {}
	};
	module.exports = exports['default'];

/***/ },
/* 13 */
/***/ function(module, exports) {

	"use strict";

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	/**
	 * Created by neitherzhu on 2017/5/8.
	 */
	exports.default = {
	  container: null,
	  loginID: null,
	  conversationID: null,
	  fileList: [],
	  searchFileList: []
	};
	module.exports = exports["default"];

/***/ },
/* 14 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _index = __webpack_require__(5);

	var _index2 = _interopRequireDefault(_index);

	var _sdk = __webpack_require__(7);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _window = __webpack_require__(13);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	function _toConsumableArray(arr) {
	  if (Array.isArray(arr)) {
	    for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
	      arr2[i] = arr[i];
	    }return arr2;
	  } else {
	    return Array.from(arr);
	  }
	} /**
	   * Created by neitherzhu on 2017/5/8.
	   */

	var Util = _$BaseRoot.Base.Util,
	    Log = _$BaseRoot.Base.Log,
	    ActionCreator = _$BaseRoot.Base.ActionCreator;

	var searchFileList = new ActionCreator();

	searchFileList.actionType = 'async';
	searchFileList.count = 20;

	searchFileList.before(function (context, param) {
	  if (param && param.reset) {
	    this.hasNextPage = true;
	    _window2.default.searchFileList = [];
	  }

	  if (!this.hasNextPage) return false;
	});

	searchFileList.before(function (context, param) {
	  if (!param && !this.keywords) return false;

	  if (!param) {
	    param = {};
	  }
	  !param.keywords && (param.keywords = this.keywords);

	  if (param.reset) {
	    this.nextkey = '';
	    this.keywords = param.keywords;
	  }

	  !param.cid && (param.cid = Util.getCid(_window2.default.conversationID));
	  typeof param.nextkey === 'undefined' && (param.nextkey = this.nextkey || '');
	  !param.count && (param.count = this.count);

	  context.param = param;
	});

	searchFileList.doAsync = function (context) {
	  var _this = this;

	  Log.blue('search keywords', context.param);

	  context.param.searchKey = context.param.keywords;
	  return new Promise(function (resolve, reject) {

	    _sdk2.default.searchFileList(context.param).then(function (data) {
	      if (context.param.reset) {
	        _window2.default.container.innerHTML = '';
	      }
	      _this.nextkey = data.nextkey;
	      _this.hasNextPage = !!data.nextkey;
	      resolve(data);
	    }).catch(function (e) {
	      _this.hasNextPage = false;
	      _index2.default.renderFileList.action();
	      reject(e);
	    });
	  });
	};

	searchFileList.after(function (context, data) {
	  var fileList = data && data.filesList;

	  fileList && (_window2.default.searchFileList = [].concat(_toConsumableArray(_window2.default.searchFileList), _toConsumableArray(fileList)));

	  _index2.default.renderFileList.action({
	    action: 'searchFileList',
	    reset: context.param.reset
	  }, fileList && fileList.length ? fileList : null);
	});

	exports.default = searchFileList;
	module.exports = exports['default'];

/***/ },
/* 15 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _$JuicerRoot = __webpack_require__(16);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _window = __webpack_require__(13);

	var _window2 = _interopRequireDefault(_window);

	var _template = __webpack_require__(17);

	var _template2 = _interopRequireDefault(_template);

	var _fileParser = __webpack_require__(22);

	var _fileParser2 = _interopRequireDefault(_fileParser);

	var _loading = __webpack_require__(25);

	var _loading2 = _interopRequireDefault(_loading);

	var _constants = __webpack_require__(8);

	var _constants2 = _interopRequireDefault(_constants);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	var Util = _$BaseRoot.Base.Util,
	    ActionCreator = _$BaseRoot.Base.ActionCreator; /**
	                                                    * Created by neitherzhu on 2017/5/8.
	                                                    */

	var __NOW = new Date();
	__NOW.setHours(0);
	__NOW.setMinutes(0);
	__NOW.setSeconds(0);
	__NOW.setMilliseconds(0);

	var __ONE_DAY_MS = 24 * 60 * 60 * 1000;
	var __TODAY_START_MS = +__NOW;
	var __THIS_WEEK_START_MS = __TODAY_START_MS - 7 * __ONE_DAY_MS;

	var renderFileList = new ActionCreator();

	renderFileList.dateCache = {};
	renderFileList.before(function (context, action) {
	  if (action && action.reset) {
	    delete this.dateCache[action.action];
	  }
	});

	renderFileList.doSync = function (context, action, fileList, needDateSplit) {
	  if (!fileList) {
	    _window2.default.container.innerHTML = _template2.default.empty;
	    return;
	  }

	  _loading2.default.hide();

	  var html = '';
	  var dateCache = this.dateCache[action.action] || '';
	  var date = '';
	  var time = void 0;
	  var msgInfo = void 0;
	  var hasNewDate = false;
	  var isSearch = action.action === 'searchFileList';

	  fileList.forEach(function (file) {
	    msgInfo = file.fileInfo && file.fileInfo.msginfo;
	    time = msgInfo && msgInfo.localtime;

	    if (needDateSplit && time) {
	      time = parseInt(time);
	      date = new Date(time).__getOnleYearMonth();
	      if (time > __TODAY_START_MS) {
	        date = _constants2.default.I18N[_constants2.default.LANGUAGE].TODAY;
	      } else if (time > __THIS_WEEK_START_MS) {
	        date = _constants2.default.I18N[_constants2.default.LANGUAGE].THIS_WEEK;
	      }
	      if (date !== dateCache) {
	        dateCache = date;
	        hasNewDate = true;
	        html += (0, _$JuicerRoot2.default)(_template2.default.dateSplit, { date: date });
	      }
	    }

	    file.fileInfo.time = time;
	    file.fileInfo.sender = msgInfo && msgInfo.from && (msgInfo.from.display || msgInfo.from.nick) || '';
	    file.fileInfo.msgid = msgInfo && msgInfo.msgid || '0';
	    file.fileInfo.isSearch = isSearch;
	    html += (0, _fileParser2.default)(file);
	  });

	  needDateSplit && (this.dateCache[action.action] = dateCache);

	  if (!action.way || action.way === 'appendChild') {
	    _window2.default.container.appendChild(Util.createFragment(html));
	  } else if (action.way === 'insertBefore') {
	    if (hasNewDate) {
	      _window2.default.container.insertBefore(Util.createFragment(html), _window2.default.container.firstChild);
	    } else {
	      _window2.default.container.insertBefore(Util.createFragment(html), _window2.default.container.querySelector('.file'));
	    }
	  }
	};

	exports.default = renderFileList;
	module.exports = exports['default'];

/***/ },
/* 16 */,
/* 17 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _dateSplit = __webpack_require__(18);

	var _dateSplit2 = _interopRequireDefault(_dateSplit);

	var _file = __webpack_require__(19);

	var _file2 = _interopRequireDefault(_file);

	var _fileOperation = __webpack_require__(20);

	var _fileOperation2 = _interopRequireDefault(_fileOperation);

	var _empty = __webpack_require__(21);

	var _empty2 = _interopRequireDefault(_empty);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	exports.default = {
	  dateSplit: _dateSplit2.default,
	  file: _file2.default,
	  fileOperation: _fileOperation2.default,
	  empty: _empty2.default
	};
	module.exports = exports['default'];

/***/ },
/* 18 */
/***/ function(module, exports) {

	module.exports = "<div class=\"file-list-date\">${date}</div>\n";

/***/ },
/* 19 */
/***/ function(module, exports) {

	module.exports = "<div class=\"file J_previewFile J_msgid_${msgid}{@if isSelf} ignore-read{@/if}\" id=\"J_file${id}\" data-id=\"${id}\">\n  <div class=\"file-suffix ${cls}\">${suffix}</div>\n  <div class=\"file-info\">\n    <div class=\"file-name\" title=\"${nodeName}\">${name}</div>\n    <div class=\"file-i\">\n      {@if time}\n      {@if !isSearch}\n      <span class=\"file-date\">${time | dateSPFormatter, '/'}</span>\n      {@else}\n      <span class=\"file-date\">${time | dateFormatter, '/'}</span>\n      {@/if}\n      {@/if}\n      <span class=\"file-size\">${size}</span>\n      {@if sender}<span class=\"file-uploader\" title=\"${sender}\">${sender}</span>{@/if}\n    </div>\n  </div>\n  <div class=\"file-operation\">\n    {@if optionsData}{@include fileOperation, optionsData}{@/if}\n  </div>\n  <div class=\"file-progress{@if !progress} hidden{@/if}\"><i style=\"{@if progress}width:${progress}%{@/if}\"></i></div>\n</div>\n";

/***/ },
/* 20 */
/***/ function(module, exports) {

	module.exports = "{@if status == 0}\n<a href=\"javascript:;\" class=\"forward-file J_forwardMsg\">转发</a>\n<a href=\"javascript:;\" class=\"open-folder J_openFolder\" data-path=\"${path}\">打开</a>\n{@else if status == 1}\n<a href=\"javascript:;\" class=\"cancel-upload J_cancelUpload\">取消</a>\n{@else if status == 2}\n<a href=\"javascript:;\" class=\"forward-file J_forwardMsg\">转发</a>\n<a href=\"javascript:;\" class=\"cancel-download J_cancelDownload\">取消</a>\n{@else if status == 3}\n<a href=\"javascript:;\" class=\"forward-file J_forwardMsg\">转发</a>\n<a href=\"javascript:;\" class=\"download-file J_downloadFile\">下载</a>\n{@else if status == 4}\n<a href=\"javascript:;\" class=\"forward-file J_forwardMsg\">转发</a>\n<a href=\"javascript:;\" class=\"download-file J_downloadFile\">下载</a>\n{@else if status == 5}\n<a href=\"javascript:;\" class=\"open-folder J_openFolder\" data-path=\"${path}\">打开</a>\n{@/if}\n";

/***/ },
/* 21 */
/***/ function(module, exports) {

	module.exports = "<div class=\"empty\">暂无相关结果</div>\n";

/***/ },
/* 22 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(16);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _template = __webpack_require__(17);

	var _template2 = _interopRequireDefault(_template);

	var _util = __webpack_require__(23);

	var _util2 = _interopRequireDefault(_util);

	var _constants = __webpack_require__(8);

	var _constants2 = _interopRequireDefault(_constants);

	var _operationParser = __webpack_require__(24);

	var _operationParser2 = _interopRequireDefault(_operationParser);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	var file = _template2.default.file,
	    fileOperation = _template2.default.fileOperation; /**
	                                                       * Created by neitherzhu on 2017/5/8.
	                                                       */

	var FILE_SUFFIX_CLS_MAP = {
	  PDF: { suffix: 'PDF', cls: 'suffix-red' },
	  AI: { suffix: 'AI', cls: 'suffix-orange' },
	  PAGES: { suffix: 'PGS', cls: 'suffix-orange' },
	  SKETCH: { suffix: 'SKE', cls: 'suffix-orange' },
	  PPTX: { suffix: 'PPT', cls: 'suffix-orange' },
	  PPT: { suffix: 'PPT', cls: 'suffix-orange' },
	  PSD: { suffix: 'PS', cls: 'suffix-blue' },
	  DOC: { suffix: 'DOC', cls: 'suffix-blue' },
	  NUMBERS: { suffix: 'NUM', cls: 'suffix-green' },
	  XLSX: { suffix: 'EXC', cls: 'suffix-green' },
	  MP4: { suffix: 'MP4', cls: 'suffix-green' },
	  TXT: { suffix: 'TXT', cls: 'suffix-gray' },
	  UNKNOWN: { suffix: '', cls: 'suffix-default' },
	  ZIP: { suffix: '', cls: 'suffix-zip' },
	  RAR: { suffix: '', cls: 'suffix-zip' },
	  '7Z': { suffix: '', cls: 'suffix-zip' }
	};

	exports.default = function (fileData) {

	  var suffix = '';
	  var suffixLen = 0;
	  var fileInfo = fileData.fileInfo;
	  var transInfo = fileData.transferInfo;
	  var moreData = {};

	  moreData.size = _util2.default.getFileSize(fileInfo.nodeSize);

	  var s = fileInfo.nodeName.split('.');

	  if (s.length <= 1) {
	    Object.assign(moreData, FILE_SUFFIX_CLS_MAP.UNKNOWN);
	  } else {
	    suffix = s.pop();
	    suffixLen = _util2.default.getStrLen(suffix) + 1;
	    Object.assign(moreData, FILE_SUFFIX_CLS_MAP[suffix.toUpperCase()] || FILE_SUFFIX_CLS_MAP.UNKNOWN);
	    suffix = '.' + suffix;
	  }

	  moreData.name = _util2.default.getStrByLen(s.join(''), _constants2.default.FILE_MAX_LEN - suffixLen, 2) + suffix;

	  if (transInfo) {
	    fileInfo.optionsData = (0, _operationParser2.default)(transInfo);
	    //fileInfo.optionsData.isSelf = mb.isSelf;
	    //fileInfo.optionsData.isRead = (msg.readflag == 1);
	    fileInfo.fileOperation = fileOperation;

	    (transInfo.status == 0 || transInfo.status == 1) && (fileInfo.progress = transInfo.progress);
	  }

	  return (0, _$JuicerRoot2.default)(file, Object.assign(moreData, fileInfo));
	};

	module.exports = exports['default'];

/***/ },
/* 23 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _constants = __webpack_require__(8);

	var _constants2 = _interopRequireDefault(_constants);

	var _window = __webpack_require__(13);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	var Util = _$BaseRoot.Base.Util; /**
	                                  * Created by neitherzhu on 2017/5/10.
	                                  */

	var __NOW = new Date();
	__NOW.setHours(0);
	__NOW.setMinutes(0);
	__NOW.setSeconds(0);
	__NOW.setMilliseconds(0);

	var __ONE_DAY_MS = 24 * 60 * 60 * 1000;
	var __TODAY_START_MS = +__NOW;
	var __TDOAY_END_MS = __TODAY_START_MS + __ONE_DAY_MS;
	var __YESTERDAY_START_MS = __TODAY_START_MS - __ONE_DAY_MS;
	var __YESTERDAY_END_MS = __TODAY_START_MS - 1;

	function numberify(n) {
	  return n > 9 ? n : '0' + n;
	}

	Date.prototype.__getFormatTime = function () {
	  return numberify(this.getHours()) + ':' + numberify(this.getMinutes()) + ':' + numberify(this.getSeconds());
	};

	Date.prototype.__getFormatOnlyTime = function () {
	  return numberify(this.getHours()) + ':' + numberify(this.getMinutes());
	};

	Date.prototype.__getFormatFullDate = function (spliter) {
	  spliter = spliter || '-';
	  return this.getFullYear() + spliter + (this.getMonth() + 1) + spliter + this.getDate() + ' ' + this.__getFormatTime();
	};

	Date.prototype.__getOnlyDate = function (spliter) {
	  spliter = spliter || '-';
	  return this.getFullYear() + spliter + (this.getMonth() + 1) + spliter + this.getDate();
	};

	Date.prototype.__getOnleYearMonth = function () {
	  return this.getFullYear() + '年' + (this.getMonth() + 1) + '月';
	};

	/**
	 * 格式化日期
	 * @param  {Number} ms 毫秒数
	 * @param  {String} spliter 分隔符
	 * @return {String}
	 */
	Util.dateFormatter = function (ms) {
	  ms = parseInt(ms, 10);

	  return new Date(ms).__getFormatFullDate();
	};

	Util.dateSPFormatter = function (ms, spliter) {
	  ms = parseInt(ms, 10);

	  if (ms > __TODAY_START_MS) {
	    return new Date(ms).__getFormatOnlyTime(spliter);
	  } else if (ms > __YESTERDAY_START_MS) {
	    return _constants2.default.I18N[_constants2.default.LANGUAGE].YESTERDAY;
	  } else {
	    return new Date(ms).__getOnlyDate(spliter);
	  }
	};

	Util.timeFormatter = function (ms) {
	  ms = parseInt(ms, 10);
	  return new Date(ms).__getFormatTime();
	};

	Util.getOnlyDate = function (ms, spliter) {
	  ms = parseInt(ms, 10);

	  return new Date(ms).__getOnlyDate(spliter);
	};

	var SIZE_SUFFIX = {
	  0: 'B',
	  1: 'KB',
	  2: 'MB',
	  3: 'GB'
	};

	Util.getFileSize = function (s) {
	  var r = parseInt(s);
	  var c = 0;

	  while (r > 1024) {
	    r = r / 1024;
	    c++;
	  }

	  return r.toFixed(1) + SIZE_SUFFIX[c];
	};

	var isCN = /[\u4e00-\u9fa5]/;

	Util.getStrLen = function (s) {

	  var len = 0;
	  for (var i = 0, l = s.length; i < l; i++) {
	    len += isCN.test(s.charAt[i]) ? 2 : 1;
	  }

	  return len;
	};

	Util.getStrByLen = function (s, maxLen, dur) {
	  dur || (dur = 2);
	  var len = 0;
	  var goLast = false;
	  var l = s.length;
	  var ellipsisLen = 3; // ...的长度
	  var i = 0;
	  var result = '';
	  var lastStr = s.substring(l - dur, l);
	  // 获取最后2个字符的长度
	  var last2StrLen = Util.getStrLen(lastStr);

	  for (; i < l; i++) {
	    len += isCN.test(s.charAt[i]) ? 2 : 1;

	    if (len >= maxLen - last2StrLen - ellipsisLen) {

	      if (len > maxLen - last2StrLen - ellipsisLen) {
	        i--;
	      }

	      // 如果还有更多的字符需要遍历, 则不再遍历
	      if (i < l - 2) {
	        goLast = true;
	      }
	      break;
	    }
	  }

	  if (goLast) {
	    result = s.substring(0, i) + '...' + lastStr;
	  } else {
	    result = s;
	  }

	  return result;
	};

	Util.generatorFileMeta = function (id) {
	  if (!id) return {};

	  var list = _window2.default[_window2.default.search ? 'searchFileList' : 'fileList'];
	  var len = list.length;
	  var item = void 0;
	  var i = 0;

	  for (; i < len; i++) {
	    if (list[i].fileInfo.id == id) {
	      item = list[i];
	      break;
	    }
	  }

	  if (!item) return {};

	  return item;
	};

	Util.getCid = function (conversation) {
	  if (!conversation) return null;

	  var result = {};

	  if (conversation.type === _constants2.default.TYPE.SINGLE) {
	    result.uid = conversation;
	  } else {
	    result.tid = conversation;
	  }

	  result.type = conversation.type;

	  return result;
	};

	Util.getUidByCid = function (cid) {
	  if (cid.type === _constants2.default.TYPE.SINGLE) {
	    return cid.uid && cid.uid.appkey + cid.uid.nick;
	  } else {
	    return cid.tid && cid.tid.tribeid;
	  }
	};

	exports.default = Util;
	module.exports = exports['default'];

/***/ },
/* 24 */
/***/ function(module, exports) {

	"use strict";

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	/**
	 * Created by neitherzhu on 2017/5/8.
	 */
	exports.default = function (data) {

	  var result = {};

	  if (!data) return result;

	  if (data.status == 0) {
	    // 上传/下载初始化状态

	    if (data.type == 0) {
	      // 上传中
	      // 显示取消上传
	      result.status = 1;
	    } else {
	      // 显示空
	      result.status = -1;
	    }
	  } else if (data.status == 1) {
	    // 上传/下载中

	    if (data.type == 0) {
	      // 上传中
	      // 显示取消上传
	      result.status = 1;
	    } else if (data.type == 1) {
	      // 下载中
	      // 显示预览 取消下载
	      result.status = 2;
	    }
	  } else if (data.status == 2) {
	    // 上传/下载 错误

	    if (data.type == 0) {
	      // 上传中
	      // 如果有本地路径
	      if (data.filePath) {
	        // 显示打开文件夹
	        result.status = 5;
	        result.path = data.filePath;
	      } else {
	        // 如果没有本地路径
	        // 不显示
	        result.status = -1;
	      }
	    } else if (data.type == 1) {
	      // 下载中
	      // 显示预览 重新下载
	      result.status = 4;
	    }
	  } else if (data.status == 3) {
	    // 上传/下载 取消

	    if (data.type == 0) {
	      // 如果是上传

	      if (data.filePath) {
	        // 如果有本地路径
	        // 显示打开文件夹
	        result.status = 5;
	        result.path = data.filePath;
	      } else {
	        // 如果没有本地路径
	        // 显示空
	        result.status = -1;
	      }
	    } else {
	      // 如果是下载
	      // 显示预览 下载文件
	      result.status = 3;
	    }
	  } else if (data.status == 4 || data.status == 5) {
	    // 上传/下载 成功 或者 未知状态

	    if (data.filePath) {
	      // 如果有本地路径
	      // 显示预览 打开文件夹
	      result.status = 0;
	      result.path = data.filePath;
	    } else {
	      // 显示预览 下载文件
	      result.status = 3;
	    }
	  }

	  return result;
	};

	module.exports = exports["default"];

/***/ },
/* 25 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _window = __webpack_require__(13);

	var _window2 = _interopRequireDefault(_window);

	var _index = __webpack_require__(26);

	var _index2 = _interopRequireDefault(_index);

	__webpack_require__(27);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	exports.default = {
	  show: function show() {
	    var loading = document.getElementById('J_searchLoading');

	    if (loading) return;

	    _window2.default.container.innerHTML = _index2.default;
	  },
	  hide: function hide() {

	    var loading = document.getElementById('J_searchLoading');

	    if (!loading) return;

	    loading.parentNode.removeChild(loading);
	  }
	}; /**
	    * Created by neitherzhu on 2017/5/8.
	    */

	module.exports = exports['default'];

/***/ },
/* 26 */
/***/ function(module, exports) {

	module.exports = "<div id=\"J_searchLoading\" class=\"search-loading\">努力加载中...</div>\n";

/***/ },
/* 27 */
/***/ function(module, exports) {

	// removed by extract-text-webpack-plugin

/***/ },
/* 28 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _sdk = __webpack_require__(7);

	var _sdk2 = _interopRequireDefault(_sdk);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/2/15.
	 */
	var ActionCreator = _$BaseRoot.Base.ActionCreator;

	var setMsgReadState = new ActionCreator();

	setMsgReadState.doSync = function (context, cid, list) {
	  if (list && list.length) {
	    _sdk2.default.setSingleMsgReadStatus({
	      cid: cid,
	      items: list
	    }).catch(function () {});
	  }
	};

	setMsgReadState.error = function (err) {
	  console.error('Action setMsgReadState Error', err);
	};

	exports.default = setMsgReadState;
	module.exports = exports['default'];

/***/ },
/* 29 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _sdk = __webpack_require__(7);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _index = __webpack_require__(5);

	var _index2 = _interopRequireDefault(_index);

	var _window = __webpack_require__(13);

	var _window2 = _interopRequireDefault(_window);

	var _loading = __webpack_require__(25);

	var _loading2 = _interopRequireDefault(_loading);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	var Util = _$BaseRoot.Base.Util; /**
	                                  * Created by neitherzhu on 2016/12/5.
	                                  * 获取当前聊天的对象
	                                  */

	var getCurrentConversationID = new _$BaseRoot.Base.ActionCreator();

	getCurrentConversationID.actionType = 'async';
	getCurrentConversationID.doAsync = function () {
	  return _sdk2.default.getCurrentConversationID();
	};

	getCurrentConversationID.after(function (context, data) {
	  _window2.default.conversationID = Util.setCidType(data);
	});

	getCurrentConversationID.after(function () {

	  _loading2.default.show();
	  _index2.default.getFileList.action({ cid: Util.getCid(_window2.default.conversationID) });
	});

	getCurrentConversationID.error = function (err) {
	  console.error('Action getCurrentConversationID Error', err);
	};

	exports.default = getCurrentConversationID;
	module.exports = exports['default'];

/***/ },
/* 30 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _sdk = __webpack_require__(7);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _window = __webpack_require__(13);

	var _window2 = _interopRequireDefault(_window);

	var _index = __webpack_require__(5);

	var _index2 = _interopRequireDefault(_index);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2016/12/5.
	 * 获取当前登录的用户
	 */
	var getCurrentLoginID = new _$BaseRoot.Base.ActionCreator();

	getCurrentLoginID.actionType = 'async';
	getCurrentLoginID.doAsync = function () {
	  return _sdk2.default.getCurrentLoginID();
	};

	getCurrentLoginID.after(function (context, data) {
	  _window2.default.loginID = data;
	}).after(function (context, data) {
	  _index2.default.bindEvents.action(data);
	});

	getCurrentLoginID.error = function (err) {
	  console.error('Action getCurrentLoginID Error', err);
	};

	exports.default = getCurrentLoginID;
	module.exports = exports['default'];

/***/ },
/* 31 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _$IMSDKRoot = __webpack_require__(2);

	var _$IMSDKRoot2 = _interopRequireDefault(_$IMSDKRoot);

	var _$JuicerRoot = __webpack_require__(16);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _index = __webpack_require__(5);

	var _index2 = _interopRequireDefault(_index);

	var _sdk = __webpack_require__(7);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _window = __webpack_require__(13);

	var _window2 = _interopRequireDefault(_window);

	var _constants = __webpack_require__(8);

	var _constants2 = _interopRequireDefault(_constants);

	var _event = __webpack_require__(32);

	var _event2 = _interopRequireDefault(_event);

	var _update = __webpack_require__(33);

	var _update2 = _interopRequireDefault(_update);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	var Util = _$BaseRoot.Base.Util,
	    ActionCreator = _$BaseRoot.Base.ActionCreator; /**
	                                                    * Created by neitherzhu on 2017/5/9.
	                                                    */

	var FILE_LIST = [];

	var bindEvents = new ActionCreator();
	var pending = false;

	bindEvents.before(function () {
	  _$JuicerRoot2.default.register('dateFormatter', Util.getOnlyDate);
	  _$JuicerRoot2.default.register('dateSPFormatter', Util.dateSPFormatter);
	});

	bindEvents.doSync = function () {

	  _event2.default.on('ACTION_RESET', function () {
	    pending = false;
	  });

	  _window2.default.container.addEventListener('scroll', function (ev) {

	    if (!_window2.default.containerHeight) {
	      _window2.default.containerHeight = _window2.default.container.clientHeight;
	    }

	    if (_window2.default.containerHeight + ev.target.scrollTop + 5 >= ev.target.scrollHeight) {

	      if (!pending) {

	        var action = _index2.default[!_window2.default.search ? 'getFileList' : 'searchFileList'];
	        action.spliceAfterOnce(0, 0, function () {
	          pending = false;
	        });
	        action.action();
	        pending = true;
	      }
	    }
	  });

	  window.addEventListener('resize', function () {
	    _window2.default.containerHeight = _window2.default.container.clientHeight;

	    // 如果没有滚动条了, 尝试再获取一页
	    if (_window2.default.containerHeight >= _window2.default.container.scrollHeight) {
	      var action = _index2.default[!_window2.default.search ? 'getFileList' : 'searchFileList'];
	      action.action();
	    }
	  });

	  _window2.default.container.addEventListener('click', function (ev) {
	    var target = ev.target;

	    if (Util.parents(target, 'J_previewFile')) {

	      var parent = Util.parents(target, 'file');
	      if (!parent) return;

	      var id = parent.dataset.id;
	      var param = {};

	      param.cid = Util.getCid(_window2.default.conversationID);
	      param.fileInfo = Util.generatorFileMeta(id).fileInfo;

	      _sdk2.default.previewCloudFile(param);

	      // 只需要设置单聊的,群聊的还不支持
	      if (_window2.default.conversationID.type !== _constants2.default.TYPE.SINGLE) return;

	      if (parent.classList.contains('ignore-read')) return;

	      var msgInfo = param.fileInfo && param.fileInfo.msginfo;

	      if (!msgInfo || msgInfo.msgid === '0' || Util.getUid(msgInfo.from) === Util.getUid(_window2.default.loginID)) return;

	      parent.classList.add('ignore-read');

	      _index2.default.setMsgReadState.action(_window2.default.conversationID, [{
	        svrtime: msgInfo.svrtime,
	        msgtime: msgInfo.localtime,
	        msgid: msgInfo.msgid
	      }]);
	    }
	  }, false);

	  /**
	   * 文件传输过程
	   */
	  _$IMSDKRoot2.default.on(_constants2.default.Event.UPDATE_FILE_TRANSFER_INFO, function (data) {
	    if (!data || !data.cid) return;

	    // let uid = Util.getUidByCid(data.cid);
	    // 如果不是当前联系对象, 需要缓存
	    //if (uid !== Util.getUid(Win.conversationID)) {
	    //
	    //  let unResolveEvents = Cache.get(uid).unResolveEvents;
	    //
	    //  if (unResolveEvents && unResolveEvents.length) {
	    //    Object.assign(unResolveEvents[0].data, data);
	    //    return;
	    //  }
	    //
	    //  data.event = Constant.Event.UPDATE_FILE_TRANSFER_INFO;
	    //  return Action.cacheEvent.action(uid, data);
	    //}

	    (0, _update2.default)(data.id, data.transferInfo);
	  });

	  // 消息撤回
	  _$IMSDKRoot2.default.on(_constants2.default.Event.TRIBE_MSG_RECALLED + ' ' + _constants2.default.Event.CHAT_MSG_RECALLED, function (data) {
	    if (!data || !data.cid || !data.withdraws || !data.withdraws.length) return;

	    var uid = Util.getUid(data.cid);
	    // 如果不是当前联系对象, 需要缓存
	    if (uid === Util.getUid(_window2.default.conversationID)) {
	      _index2.default.fileRecall.action(data.withdraws);
	    }
	  });

	  /** 处理实时文件上屏 **/
	  //  IMSDK.on(Constant.Event.UPDATE_FILE_INFO, data => {
	  //    if(!data || !data.cid) return;
	  //
	  //    // 如果在搜索模式,则不用处理, 回到列表模式的时候会从服务端获取到
	  //    if(Win.search) return;
	  //
	  //    // 只处理当前选中的用户的消息
	  //    if(Util.getUidByCid(data.cid) !== Util.getUid(Win.conversationID)) return;
	  //
	  //    // 先缓存文件内容, 等收到消息发送成功的事件后上屏
	  //    FILE_LIST.push(data);
	  //  });
	  //
	  //  // 自己发送的文件处理
	  //  IMSDK.on(Constant.Event.CHAT_SEND_MSG_STATUS_CHANGE + ' ' + Constant.Event.TRIBE_SEND_MSG_STATUS_CHANGE, data => {
	  //    if(!data || !data.cid) return;
	  //
	  //    if(Win.search) return;
	  //    // 只处理当前选中的用户的消息
	  //    if(Util.getUid(data.cid) !== Util.getUid(Win.conversationID)) return;
	  //    // 只处理文件消息
	  //    if(data.msgtype !== Constant.FILE_MSG_TYPE) return;
	  //
	  //    const file = FILE_LIST.filter(file => {
	  //      return file.id === data.msgid;
	  //    });
	  //
	  //    if(!file || !file.length) return;
	  //
	  //    // 成功上屏
	  //    if(data.code === 0) {
	  //      Action.renderFileList.action({
	  //        action: 'getFileList',
	  //        way: 'insertBefore'
	  //      }, file, true);
	  //    }
	  //    // 失败清除缓存
	  //    else {
	  //      for(let i = 0; i < FILE_LIST.length; i++) {
	  //        if(FILE_LIST[i].id === data.msgid) {
	  //          FILE_LIST.splice(i, 1);
	  //        }
	  //      }
	  //    }
	  //
	  //  });
	  //
	  //  // 收到的文件处理
	  //  IMSDK.on(Constant.Event.CHAT_RECEIVE_MSG + ' ' + Constant.Event.TRIBE_RECEIVE_MSG, data => {
	  //console.log(data);
	  //  });
	};

	bindEvents.after(function () {
	  _index2.default.getCurrentConversationID.action();
	});

	exports.default = bindEvents;
	module.exports = exports['default'];

/***/ },
/* 32 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	                                          value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var Event = new _$BaseRoot.Base.Event(); /**
	                                          * Created by neitherzhu on 2017/5/23.
	                                          */
	exports.default = Event;
	module.exports = exports['default'];

/***/ },
/* 33 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(16);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _template = __webpack_require__(17);

	var _template2 = _interopRequireDefault(_template);

	var _operationParser = __webpack_require__(24);

	var _operationParser2 = _interopRequireDefault(_operationParser);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	var file = _template2.default.file,
	    fileOperation = _template2.default.fileOperation; /**
	                                                       * Created by neitherzhu on 2017/5/11.
	                                                       */

	exports.default = function (id, data) {
	  if (!id || !data) return;

	  var fileMsg = document.getElementById('J_file' + id);

	  if (!fileMsg) return;

	  var operationData = (0, _operationParser2.default)(data);

	  // 未开始上传/下载
	  // 上传/下载中
	  if (data.status == 0 || data.status == 1) {

	    var progressEl = fileMsg.querySelector('.file-progress');
	    if (!progressEl) return;

	    var innerProgressEl = progressEl.querySelector('i');
	    if (!innerProgressEl) return;
	    if (progressEl.classList.contains('hidden')) {
	      innerProgressEl.classList.remove('animation-width');
	      progressEl.classList.remove('hidden');
	    }
	    innerProgressEl.style.width = data.progress + '%';

	    // 针对大文件进行动画处理,小文件动画效果不明显
	    if (data.progress > 1 && data.progress < 4) {
	      innerProgressEl.classList.add('animation-width');
	    }
	  } else if (data.status == 2) {
	    // 上传/下载错误
	    var _progressEl = fileMsg.querySelector('.file-progress');
	    _progressEl && _progressEl.classList.add('hidden');
	  } else if (data.status == 3) {
	    // 上传/下载被取消
	    if (data.type == 0) {
	      var msgEl = document.getElementById(id);
	      msgEl && msgEl.parentNode.removeChild(msgEl);
	    } else {
	      var _progressEl2 = fileMsg.querySelector('.file-progress');
	      _progressEl2 && _progressEl2.classList.add('hidden');
	    }
	  } else if (data.status == 4) {
	    // 上传/下载成功
	    var _progressEl3 = fileMsg.querySelector('.file-progress');
	    if (!_progressEl3) return;

	    var _innerProgressEl = _progressEl3.querySelector('i');

	    if (data.type == 1) {
	      _progressEl3.classList.add('hidden');
	    }

	    _innerProgressEl && (_innerProgressEl.style.width = data.progress + '%');
	  } else if (data.status == 5) {
	    // 未知状态
	    var _progressEl4 = fileMsg.querySelector('.file-progress');
	    _progressEl4 && _progressEl4.classList.add('hidden');
	  }

	  if (data.type == 0) {
	    operationData.isSelf = true;
	  }

	  fileMsg.querySelector('.file-operation').innerHTML = (0, _$JuicerRoot2.default)(fileOperation, operationData);
	};

	module.exports = exports['default'];

/***/ },
/* 34 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _index = __webpack_require__(5);

	var _index2 = _interopRequireDefault(_index);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/5/8.
	 */
	var ActionCreator = _$BaseRoot.Base.ActionCreator;

	var start = new ActionCreator();

	start.doSync = function () {
	  _index2.default.getCurrentLoginID.action();
	};

	exports.default = start;
	module.exports = exports['default'];

/***/ },
/* 35 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _index = __webpack_require__(5);

	var _index2 = _interopRequireDefault(_index);

	var _window = __webpack_require__(13);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	var ActionCreator = _$BaseRoot.Base.ActionCreator; /**
	                                                    * Created by neitherzhu on 2017/5/23.
	                                                    */

	var fileRecall = new ActionCreator();

	fileRecall.before(function (context, list) {
	  if (!list || !list.length) return false;
	});

	fileRecall.doSync = function (context, list) {
	  var cls = '.J_msgid_';
	  var hasScrollBar = _window2.default.container.scrollHeight > _window2.default.container.clientHeight;
	  var el = void 0;
	  list.forEach(function (m) {
	    el = document.querySelector(cls + m.msgid);

	    if (!el) return;

	    var prev = el.previousElementSibling;
	    var next = el.nextElementSibling;

	    if (prev && prev.classList && prev.classList.contains('file-list-date')) {
	      if (!next || next && next.classList && next.classList.contains('file-list-date')) {
	        prev.parentNode.removeChild(prev);
	      }
	    }

	    el.parentNode.removeChild(el);

	    // 如果之前是有滚动条的, 删除了消息之后没有滚动条了, 则需要再获取一次
	    if (hasScrollBar && _window2.default.container.scrollHeight <= _window2.default.container.clientHeight) {
	      var action = _index2.default[!_window2.default.search ? 'getFileList' : 'searchFileList'];
	      action.action();
	    }
	  });
	};

	exports.default = fileRecall;
	module.exports = exports['default'];

/***/ },
/* 36 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _createPlugin = __webpack_require__(37);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	__webpack_require__(38);

	__webpack_require__(39);

	__webpack_require__(40);

	__webpack_require__(41);

	__webpack_require__(42);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	//import './eventPlugins/previewFile';

	exports.default = _createPlugin2.default;
	module.exports = exports['default'];

/***/ },
/* 37 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var Plugin = new _$BaseRoot.Base.Plugin();

	exports.default = Plugin;
	module.exports = exports['default'];

/***/ },
/* 38 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _createPlugin = __webpack_require__(37);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _actions = __webpack_require__(5);

	var _actions2 = _interopRequireDefault(_actions);

	var _loading = __webpack_require__(25);

	var _loading2 = _interopRequireDefault(_loading);

	var _window = __webpack_require__(13);

	var _window2 = _interopRequireDefault(_window);

	var _event = __webpack_require__(32);

	var _event2 = _interopRequireDefault(_event);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	var searchFileList = _actions2.default.searchFileList,
	    getFileList = _actions2.default.getFileList; /**
	                                                  * Created by neitherzhu on 2017/5/8.
	                                                  */

	var Search = {
	  init: function init() {
	    this.input = document.getElementById('J_searchInput');
	    this.clearBtn = document.getElementById('J_clearSearchValue');

	    this.events();
	  },

	  __keyUpTimer: null,

	  __cacheKeyword: '',

	  events: function events() {
	    var _this = this;

	    this.input.addEventListener('keyup', function (ev) {
	      var target = ev.target;
	      var val = target.value.trim();

	      _this[val ? 'showClearBtn' : 'hideClearBtn']();

	      if (val === _this.__cacheKeyword) return;

	      _this.__cacheKeyword = val;

	      clearTimeout(_this.__keyUpTimer);

	      _this.__keyUpTimer = setTimeout(function () {
	        _loading2.default.show();
	        _event2.default.emit('ACTION_RESET');
	        if (!val) {
	          _window2.default.search = 0;
	          getFileList.action({ nextkey: '', reset: true });
	        } else {
	          _window2.default.search = 1;
	          searchFileList.action({
	            keywords: val,
	            reset: true
	          });
	        }
	      }, 600);
	    });

	    this.clearBtn && this.clearBtn.addEventListener('click', function () {
	      _this.input.value = '';
	      _this.hideClearBtn();
	      _this.input.focus();
	      _window2.default.search = 0;
	      _window2.default.container.innerHTML = '';
	      _event2.default.emit('ACTION_RESET');
	      getFileList.action({ nextkey: '', reset: true });
	    });
	  },
	  hideClearBtn: function hideClearBtn() {
	    this.clearBtn && this.clearBtn.classList.add('hidden');
	  },
	  showClearBtn: function showClearBtn() {
	    this.clearBtn && this.clearBtn.classList.remove('hidden');
	  }
	};

	_createPlugin2.default.addPlugin('search', Search);

	exports.default = Search;
	module.exports = exports['default'];

/***/ },
/* 39 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _constants = __webpack_require__(8);

	var _constants2 = _interopRequireDefault(_constants);

	var _createPlugin = __webpack_require__(37);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _sdk = __webpack_require__(7);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _util = __webpack_require__(23);

	var _util2 = _interopRequireDefault(_util);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/5/8.
	 */
	_createPlugin2.default.addEventPlugin('click', _constants2.default.CLS.CANCEL_DOWNLOAD_FILE, function (ev) {
	  ev.preventDefault();
	  ev.stopPropagation();
	  ev.stopImmediatePropagation();

	  var target = ev.target;
	  var parent = _util2.default.parents(target, 'file');
	  if (!parent) return;

	  var id = parent.dataset.id;
	  var param = _util2.default.generatorFileMeta(id).fileInfo;

	  _sdk2.default.cancelDownloadCloudFile(param);
	});

/***/ },
/* 40 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _constants = __webpack_require__(8);

	var _constants2 = _interopRequireDefault(_constants);

	var _createPlugin = __webpack_require__(37);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _sdk = __webpack_require__(7);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _window = __webpack_require__(13);

	var _window2 = _interopRequireDefault(_window);

	var _actions = __webpack_require__(5);

	var _actions2 = _interopRequireDefault(_actions);

	var _util = __webpack_require__(23);

	var _util2 = _interopRequireDefault(_util);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/5/8.
	 */
	_createPlugin2.default.addEventPlugin('click', _constants2.default.CLS.DOWNLOAD_FILE, function (ev) {

	  ev.preventDefault();
	  ev.stopPropagation();
	  ev.stopImmediatePropagation();

	  var target = ev.target;
	  var parent = _util2.default.parents(target, 'file');
	  if (!parent) return;

	  var id = parent.dataset.id;
	  var param = {};

	  param.cid = _util2.default.getCid(_window2.default.conversationID);
	  param.fileInfo = _util2.default.generatorFileMeta(id).fileInfo;

	  _sdk2.default.downloadCloudFile(param);

	  // 只需要设置单聊的,群聊的还不支持
	  if (_window2.default.conversationID.type !== _constants2.default.TYPE.SINGLE) return;

	  if (parent.classList.contains('ignore-read')) return;

	  var msgInfo = param.fileInfo && param.fileInfo.msginfo;

	  if (!msgInfo || msgInfo.msgid === '0' || _util2.default.getUid(msgInfo.from) === _util2.default.getUid(_window2.default.loginID)) return;

	  parent.classList.add('ignore-read');

	  _actions2.default.setMsgReadState.action(_window2.default.conversationID, [{
	    svrtime: msgInfo.svrtime,
	    msgtime: msgInfo.localtime,
	    msgid: msgInfo.msgid
	  }]);
	});

/***/ },
/* 41 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _constants = __webpack_require__(8);

	var _constants2 = _interopRequireDefault(_constants);

	var _createPlugin = __webpack_require__(37);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _sdk = __webpack_require__(7);

	var _sdk2 = _interopRequireDefault(_sdk);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	_createPlugin2.default.addEventPlugin('click', _constants2.default.CLS.OPEN_FILE_FOLDER, function (ev) {
	  ev.preventDefault();
	  ev.stopPropagation();
	  ev.stopImmediatePropagation();

	  var target = ev.target;

	  _sdk2.default.openFolder({
	    filePath: target.dataset.path
	  }).then(function (data) {
	    if (data.subcode === 0x01200004) {
	      target.outerHTML = '<a href="javascript:;" class="download-file J_downloadFile">下载</a>';
	    }
	  }).catch(function (e) {
	    target.outerHTML = '<a href="javascript:;" class="download-file J_downloadFile">下载</a>';
	  });
	}); /**
	     * Created by neitherzhu on 2017/5/8.
	     */

/***/ },
/* 42 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _constants = __webpack_require__(8);

	var _constants2 = _interopRequireDefault(_constants);

	var _createPlugin = __webpack_require__(37);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _sdk = __webpack_require__(7);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _util = __webpack_require__(23);

	var _util2 = _interopRequireDefault(_util);

	var _window = __webpack_require__(13);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	_createPlugin2.default.addEventPlugin('click', _constants2.default.CLS.FORWARD_MSG, function (ev) {
	  ev.preventDefault();
	  ev.stopPropagation();
	  ev.stopImmediatePropagation();

	  var target = ev.target;
	  var parent = _util2.default.parents(target, 'file');
	  if (!parent) return;

	  var param = {};
	  var id = parent.dataset.id;
	  var file = _util2.default.generatorFileMeta(id);

	  param.cid = _util2.default.getCid(_window2.default.conversationID);
	  param.msgid = file.fileInfo && file.fileInfo.msginfo && file.fileInfo.msginfo.msgid || '';
	  param.msgtype = 65649;
	  param.msgbody = [{
	    type: 113,
	    jvale: '',
	    value: JSON.stringify({
	      fileMeta: {
	        nodeName: file.fileInfo.nodeName,
	        nodeSize: parseInt(file.fileInfo.nodeSize),
	        md5: file.fileInfo.md5
	      }
	    })
	  }];

	  _sdk2.default.forwardMsg(param);
	}); /**
	     * Created by neitherzhu on 2017/5/8.
	     */

/***/ },
/* 43 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _loading = __webpack_require__(25);

	var _loading2 = _interopRequireDefault(_loading);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	exports.default = {
	  Loading: _loading2.default
	}; /**
	    * Created by neitherzhu on 2017/5/17.
	    */

	module.exports = exports['default'];

/***/ },
/* 44 */
/***/ function(module, exports) {

	// removed by extract-text-webpack-plugin

/***/ },
/* 45 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _createPlugin = __webpack_require__(46);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _tab = __webpack_require__(47);

	var _tab2 = _interopRequireDefault(_tab);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	_createPlugin2.default.addPlugin('tabPlugin', _tab2.default);
	_createPlugin2.default.init({
	  container: document.getElementById('J_msgtab'),
	  type: 1
	});

	exports.default = _createPlugin2.default;

/***/ },
/* 46 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var Plugin = new _$BaseRoot.Base.Plugin();

	exports.default = Plugin;

/***/ },
/* 47 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	__webpack_require__(48);

	var TABMAP = [{
	  name: '聊天消息',
	  url: './history.html' + (location && location.search)
	}, {
	  name: '聊天文件',
	  url: './file_list.html' + (location && location.search)
	}];

	exports.default = {
	  init: function init(config) {
	    var container = config.container;
	    if (!container) {
	      return;
	    }
	    container.className = 'msg-outer-head';
	    this.createHtmlNode(container, config.type || 0);
	  },
	  createHtmlNode: function createHtmlNode(container, type) {
	    var tpl = TABMAP.map(function (item, index) {
	      if (index === type) {
	        return '<a href="' + item.url + '" class="head_item active">' + item.name + '</a>';
	      }
	      return '<a href="' + item.url + '" class="head_item">' + item.name + '</a>';
	    }).join('');

	    container.innerHTML = tpl;
	  }
	};

/***/ },
/* 48 */
/***/ function(module, exports) {

	// removed by extract-text-webpack-plugin

/***/ }
])
});
;