/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.trax;

import com.sun.org.apache.xalan.internal.xsltc.StripFilter;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ErrorMsg;
import com.sun.org.apache.xalan.internal.xsltc.dom.DOMWSFilter;
import com.sun.org.apache.xalan.internal.xsltc.dom.SAXImpl;
import com.sun.org.apache.xalan.internal.xsltc.dom.XSLTCDTMManager;
import com.sun.org.apache.xalan.internal.xsltc.runtime.AbstractTranslet;
import com.sun.org.apache.xalan.internal.xsltc.trax.TransformerImpl;
import com.sun.org.apache.xml.internal.serializer.SerializationHandler;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class TransformerHandlerImpl
implements TransformerHandler,
DeclHandler {
    private TransformerImpl _transformer;
    private AbstractTranslet _translet = null;
    private String _systemId;
    private SAXImpl _dom = null;
    private ContentHandler _handler = null;
    private LexicalHandler _lexHandler = null;
    private DTDHandler _dtdHandler = null;
    private DeclHandler _declHandler = null;
    private Result _result = null;
    private Locator _locator = null;
    private boolean _done = false;
    private boolean _isIdentity = false;

    public TransformerHandlerImpl(TransformerImpl transformerImpl) {
        this._transformer = transformerImpl;
        if (transformerImpl.isIdentity()) {
            this._handler = new DefaultHandler();
            this._isIdentity = true;
        } else {
            this._translet = this._transformer.getTranslet();
        }
    }

    @Override
    public String getSystemId() {
        return this._systemId;
    }

    @Override
    public void setSystemId(String string) {
        this._systemId = string;
    }

    @Override
    public Transformer getTransformer() {
        return this._transformer;
    }

    @Override
    public void setResult(Result result) throws IllegalArgumentException {
        this._result = result;
        if (null == result) {
            ErrorMsg errorMsg = new ErrorMsg("ER_RESULT_NULL");
            throw new IllegalArgumentException(errorMsg.toString());
        }
        if (this._isIdentity) {
            try {
                SerializationHandler serializationHandler = this._transformer.getOutputHandler(result);
                this._transformer.transferOutputProperties(serializationHandler);
                this._handler = serializationHandler;
                this._lexHandler = serializationHandler;
            }
            catch (TransformerException transformerException) {
                this._result = null;
            }
        } else if (this._done) {
            try {
                this._transformer.setDOM(this._dom);
                this._transformer.transform(null, this._result);
            }
            catch (TransformerException transformerException) {
                throw new IllegalArgumentException(transformerException.getMessage());
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this._handler.characters(cArray, n, n2);
    }

    @Override
    public void startDocument() throws SAXException {
        if (this._result == null) {
            ErrorMsg errorMsg = new ErrorMsg("JAXP_SET_RESULT_ERR");
            throw new SAXException(errorMsg.toString());
        }
        if (!this._isIdentity) {
            boolean bl = this._translet != null ? this._translet.hasIdCall() : false;
            XSLTCDTMManager xSLTCDTMManager = null;
            try {
                xSLTCDTMManager = this._transformer.getTransformerFactory().createNewDTMManagerInstance();
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
            DOMWSFilter dOMWSFilter = this._translet != null && this._translet instanceof StripFilter ? new DOMWSFilter(this._translet) : null;
            this._dom = (SAXImpl)xSLTCDTMManager.getDTM(null, false, dOMWSFilter, true, false, bl);
            this._handler = this._dom.getBuilder();
            this._lexHandler = (LexicalHandler)((Object)this._handler);
            this._dtdHandler = (DTDHandler)((Object)this._handler);
            this._declHandler = (DeclHandler)((Object)this._handler);
            this._dom.setDocumentURI(this._systemId);
            if (this._locator != null) {
                this._handler.setDocumentLocator(this._locator);
            }
        }
        this._handler.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this._handler.endDocument();
        if (!this._isIdentity) {
            if (this._result != null) {
                try {
                    this._transformer.setDOM(this._dom);
                    this._transformer.transform(null, this._result);
                }
                catch (TransformerException transformerException) {
                    throw new SAXException(transformerException);
                }
            }
            this._done = true;
            this._transformer.setDOM(this._dom);
        }
        if (this._isIdentity && this._result instanceof DOMResult) {
            ((DOMResult)this._result).setNode(this._transformer.getTransletOutputHandlerFactory().getNode());
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this._handler.startElement(string, string2, string3, attributes);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this._handler.endElement(string, string2, string3);
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        this._handler.processingInstruction(string, string2);
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this._lexHandler != null) {
            this._lexHandler.startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this._lexHandler != null) {
            this._lexHandler.endCDATA();
        }
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this._lexHandler != null) {
            this._lexHandler.comment(cArray, n, n2);
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this._handler.ignorableWhitespace(cArray, n, n2);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
        if (this._handler != null) {
            this._handler.setDocumentLocator(locator);
        }
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
        this._handler.skippedEntity(string);
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        this._handler.startPrefixMapping(string, string2);
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
        this._handler.endPrefixMapping(string);
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        if (this._lexHandler != null) {
            this._lexHandler.startDTD(string, string2, string3);
        }
    }

    @Override
    public void endDTD() throws SAXException {
        if (this._lexHandler != null) {
            this._lexHandler.endDTD();
        }
    }

    @Override
    public void startEntity(String string) throws SAXException {
        if (this._lexHandler != null) {
            this._lexHandler.startEntity(string);
        }
    }

    @Override
    public void endEntity(String string) throws SAXException {
        if (this._lexHandler != null) {
            this._lexHandler.endEntity(string);
        }
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        if (this._dtdHandler != null) {
            this._dtdHandler.unparsedEntityDecl(string, string2, string3, string4);
        }
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
        if (this._dtdHandler != null) {
            this._dtdHandler.notationDecl(string, string2, string3);
        }
    }

    @Override
    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        if (this._declHandler != null) {
            this._declHandler.attributeDecl(string, string2, string3, string4, string5);
        }
    }

    @Override
    public void elementDecl(String string, String string2) throws SAXException {
        if (this._declHandler != null) {
            this._declHandler.elementDecl(string, string2);
        }
    }

    @Override
    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        if (this._declHandler != null) {
            this._declHandler.externalEntityDecl(string, string2, string3);
        }
    }

    @Override
    public void internalEntityDecl(String string, String string2) throws SAXException {
        if (this._declHandler != null) {
            this._declHandler.internalEntityDecl(string, string2);
        }
    }

    public void reset() {
        this._systemId = null;
        this._dom = null;
        this._handler = null;
        this._lexHandler = null;
        this._dtdHandler = null;
        this._declHandler = null;
        this._result = null;
        this._locator = null;
    }
}

