/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serialize;

import com.sun.org.apache.xerces.internal.utils.ObjectFactory;
import com.sun.org.apache.xerces.internal.utils.SecuritySupport;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.Serializer;
import com.sun.org.apache.xml.internal.serialize.SerializerFactoryImpl;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class SerializerFactory {
    public static final String FactoriesProperty = "com.sun.org.apache.xml.internal.serialize.factories";
    private static final Map<String, SerializerFactory> _factories = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSerializerFactory(SerializerFactory serializerFactory) {
        Map<String, SerializerFactory> map = _factories;
        synchronized (map) {
            String string = serializerFactory.getSupportedMethod();
            _factories.put(string, serializerFactory);
        }
    }

    public static SerializerFactory getSerializerFactory(String string) {
        return _factories.get(string);
    }

    protected abstract String getSupportedMethod();

    public abstract Serializer makeSerializer(OutputFormat var1);

    public abstract Serializer makeSerializer(Writer var1, OutputFormat var2);

    public abstract Serializer makeSerializer(OutputStream var1, OutputFormat var2) throws UnsupportedEncodingException;

    static {
        SerializerFactory serializerFactory = new SerializerFactoryImpl("xml");
        SerializerFactory.registerSerializerFactory(serializerFactory);
        serializerFactory = new SerializerFactoryImpl("html");
        SerializerFactory.registerSerializerFactory(serializerFactory);
        serializerFactory = new SerializerFactoryImpl("xhtml");
        SerializerFactory.registerSerializerFactory(serializerFactory);
        serializerFactory = new SerializerFactoryImpl("text");
        SerializerFactory.registerSerializerFactory(serializerFactory);
        String string = SecuritySupport.getSystemProperty(FactoriesProperty);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ;,:");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    serializerFactory = (SerializerFactory)ObjectFactory.newInstance(string2, true);
                    if (!_factories.containsKey(serializerFactory.getSupportedMethod())) continue;
                    _factories.put(serializerFactory.getSupportedMethod(), serializerFactory);
                }
                catch (Exception exception) {}
            }
        }
    }
}

