/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.pipe.helper;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Fiber;
import com.sun.xml.internal.ws.api.pipe.NextAction;
import com.sun.xml.internal.ws.api.pipe.Pipe;
import com.sun.xml.internal.ws.api.pipe.PipeCloner;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractPipeImpl;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractTubeImpl;

public class PipeAdapter
extends AbstractTubeImpl {
    private final Pipe next;

    public static Tube adapt(Pipe pipe) {
        if (pipe instanceof Tube) {
            return (Tube)((Object)pipe);
        }
        return new PipeAdapter(pipe);
    }

    public static Pipe adapt(Tube tube) {
        if (tube instanceof Pipe) {
            return (Pipe)((Object)tube);
        }
        class TubeAdapter
        extends AbstractPipeImpl {
            private final Tube t;

            public TubeAdapter(Tube tube) {
                this.t = tube;
            }

            private TubeAdapter(TubeAdapter tubeAdapter, PipeCloner pipeCloner) {
                super(tubeAdapter, pipeCloner);
                this.t = pipeCloner.copy(tubeAdapter.t);
            }

            @Override
            public Packet process(Packet packet) {
                return Fiber.current().runSync(this.t, packet);
            }

            @Override
            public Pipe copy(PipeCloner pipeCloner) {
                return new TubeAdapter(this, pipeCloner);
            }
        }
        return new TubeAdapter(tube);
    }

    private PipeAdapter(Pipe pipe) {
        this.next = pipe;
    }

    private PipeAdapter(PipeAdapter pipeAdapter, TubeCloner tubeCloner) {
        super(pipeAdapter, tubeCloner);
        this.next = ((PipeCloner)tubeCloner).copy(pipeAdapter.next);
    }

    @Override
    @NotNull
    public NextAction processRequest(@NotNull Packet packet) {
        return this.doReturnWith(this.next.process(packet));
    }

    @Override
    @NotNull
    public NextAction processResponse(@NotNull Packet packet) {
        throw new IllegalStateException();
    }

    @Override
    @NotNull
    public NextAction processException(@NotNull Throwable throwable) {
        throw new IllegalStateException();
    }

    @Override
    public void preDestroy() {
        this.next.preDestroy();
    }

    @Override
    public PipeAdapter copy(TubeCloner tubeCloner) {
        return new PipeAdapter(this, tubeCloner);
    }

    public String toString() {
        return super.toString() + "[" + this.next.toString() + "]";
    }
}

