/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.server;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.api.server.Invoker;
import com.sun.xml.internal.ws.server.provider.AsyncProviderInvokerTube;
import com.sun.xml.internal.ws.server.provider.ProviderArgumentsBuilder;
import com.sun.xml.internal.ws.server.provider.ProviderInvokerTube;
import com.sun.xml.internal.ws.server.provider.SyncProviderInvokerTube;
import com.sun.xml.internal.ws.util.ServiceFinder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ProviderInvokerTubeFactory<T> {
    private static final ProviderInvokerTubeFactory DEFAULT = new DefaultProviderInvokerTubeFactory();
    private static final Logger logger = Logger.getLogger(ProviderInvokerTubeFactory.class.getName());

    protected abstract ProviderInvokerTube<T> doCreate(@NotNull Class<T> var1, @NotNull Invoker var2, @NotNull ProviderArgumentsBuilder<?> var3, boolean var4);

    public static <T> ProviderInvokerTube<T> create(@Nullable ClassLoader classLoader, @NotNull Container container, @NotNull Class<T> clazz, @NotNull Invoker invoker, @NotNull ProviderArgumentsBuilder<?> providerArgumentsBuilder, boolean bl) {
        for (ProviderInvokerTubeFactory providerInvokerTubeFactory : ServiceFinder.find(ProviderInvokerTubeFactory.class, classLoader, container)) {
            ProviderInvokerTube<T> providerInvokerTube = providerInvokerTubeFactory.doCreate(clazz, invoker, providerArgumentsBuilder, bl);
            if (providerInvokerTube == null) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "{0} successfully created {1}", new Object[]{providerInvokerTubeFactory.getClass(), providerInvokerTube});
            }
            return providerInvokerTube;
        }
        return DEFAULT.createDefault(clazz, invoker, providerArgumentsBuilder, bl);
    }

    protected ProviderInvokerTube<T> createDefault(@NotNull Class<T> clazz, @NotNull Invoker invoker, @NotNull ProviderArgumentsBuilder<?> providerArgumentsBuilder, boolean bl) {
        return bl ? new AsyncProviderInvokerTube(invoker, providerArgumentsBuilder) : new SyncProviderInvokerTube(invoker, providerArgumentsBuilder);
    }

    private static class DefaultProviderInvokerTubeFactory<T>
    extends ProviderInvokerTubeFactory<T> {
        private DefaultProviderInvokerTubeFactory() {
        }

        @Override
        public ProviderInvokerTube<T> doCreate(@NotNull Class<T> clazz, @NotNull Invoker invoker, @NotNull ProviderArgumentsBuilder<?> providerArgumentsBuilder, boolean bl) {
            return this.createDefault(clazz, invoker, providerArgumentsBuilder, bl);
        }
    }
}

