/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.dump;

import java.util.logging.Level;
import java.util.logging.Logger;

final class MessageDumper {
    private final String tubeName;
    private final Logger logger;
    private Level loggingLevel;

    public MessageDumper(String string, Logger logger, Level level) {
        this.tubeName = string;
        this.logger = logger;
        this.loggingLevel = level;
    }

    final boolean isLoggable() {
        return this.logger.isLoggable(this.loggingLevel);
    }

    final void setLoggingLevel(Level level) {
        this.loggingLevel = level;
    }

    final String createLogMessage(MessageType messageType, ProcessingState processingState, int n, String string, String string2) {
        return String.format("%s %s in Tube [ %s ] Instance [ %d ] Engine [ %s ] Thread [ %s ]:%n%s", new Object[]{messageType, processingState, this.tubeName, n, string, Thread.currentThread().getName(), string2});
    }

    final String dump(MessageType messageType, ProcessingState processingState, String string, int n, String string2) {
        String string3 = this.createLogMessage(messageType, processingState, n, string2, string);
        this.logger.log(this.loggingLevel, string3);
        return string3;
    }

    static enum MessageType {
        Request("Request message"),
        Response("Response message"),
        Exception("Response exception");

        private final String name;

        private MessageType(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }

    static enum ProcessingState {
        Received("received"),
        Processed("processed");

        private final String name;

        private ProcessingState(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

