/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.lang.ref.SoftReference;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.spi.TimeZoneNameProvider;
import sun.util.calendar.ZoneInfo;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.LocaleServiceProviderPool;
import sun.util.locale.provider.TimeZoneNameProviderImpl;

public final class TimeZoneNameUtility {
    private static ConcurrentHashMap<Locale, SoftReference<String[][]>> cachedZoneData = new ConcurrentHashMap();
    private static final Map<String, SoftReference<Map<Locale, String[]>>> cachedDisplayNames = new ConcurrentHashMap<String, SoftReference<Map<Locale, String[]>>>();

    public static String[][] getZoneStrings(Locale locale) {
        String[][] stringArray;
        SoftReference<String[][]> softReference = cachedZoneData.get(locale);
        if (softReference == null || (stringArray = softReference.get()) == null) {
            stringArray = TimeZoneNameUtility.loadZoneStrings(locale);
            softReference = new SoftReference<String[][]>(stringArray);
            cachedZoneData.put(locale, softReference);
        }
        return stringArray;
    }

    private static String[][] loadZoneStrings(Locale locale) {
        LocaleProviderAdapter localeProviderAdapter = LocaleProviderAdapter.getAdapter(TimeZoneNameProvider.class, locale);
        TimeZoneNameProvider timeZoneNameProvider = localeProviderAdapter.getTimeZoneNameProvider();
        if (timeZoneNameProvider instanceof TimeZoneNameProviderImpl) {
            return ((TimeZoneNameProviderImpl)timeZoneNameProvider).getZoneStrings(locale);
        }
        Set<String> set = LocaleProviderAdapter.forJRE().getLocaleResources(locale).getZoneIDs();
        LinkedList<String[]> linkedList = new LinkedList<String[]>();
        for (String string : set) {
            String[] stringArray = TimeZoneNameUtility.retrieveDisplayNamesImpl(string, locale);
            if (stringArray == null) continue;
            linkedList.add(stringArray);
        }
        String[][] stringArrayArray = new String[linkedList.size()][];
        return (String[][])linkedList.toArray((T[])stringArrayArray);
    }

    public static String[] retrieveDisplayNames(String string, Locale locale) {
        Objects.requireNonNull(string);
        Objects.requireNonNull(locale);
        return TimeZoneNameUtility.retrieveDisplayNamesImpl(string, locale);
    }

    public static String retrieveGenericDisplayName(String string, int n, Locale locale) {
        String[] stringArray = TimeZoneNameUtility.retrieveDisplayNamesImpl(string, locale);
        if (Objects.nonNull(stringArray)) {
            return stringArray[6 - n];
        }
        return null;
    }

    public static String retrieveDisplayName(String string, boolean bl, int n, Locale locale) {
        String[] stringArray = TimeZoneNameUtility.retrieveDisplayNamesImpl(string, locale);
        if (Objects.nonNull(stringArray)) {
            return stringArray[(bl ? 4 : 2) - n];
        }
        return null;
    }

    private static String[] retrieveDisplayNamesImpl(String string, Locale locale) {
        String[] stringArray;
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(TimeZoneNameProvider.class);
        Map<Locale, String[]> map = null;
        SoftReference<Map<Locale, String[]>> softReference = cachedDisplayNames.get(string);
        if (Objects.nonNull(softReference) && Objects.nonNull(map = softReference.get()) && Objects.nonNull(stringArray = map.get(locale))) {
            return stringArray;
        }
        stringArray = new String[7];
        stringArray[0] = string;
        for (int i = 1; i <= 6; ++i) {
            stringArray[i] = localeServiceProviderPool.getLocalizedObject(TimeZoneNameGetter.INSTANCE, locale, i < 5 ? (i < 3 ? "std" : "dst") : "generic", i % 2, string);
        }
        if (Objects.isNull(map)) {
            map = new ConcurrentHashMap<Locale, String[]>();
        }
        map.put(locale, stringArray);
        softReference = new SoftReference<Map<Locale, String[]>>(map);
        cachedDisplayNames.put(string, softReference);
        return stringArray;
    }

    private TimeZoneNameUtility() {
    }

    private static class TimeZoneNameGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<TimeZoneNameProvider, String> {
        private static final TimeZoneNameGetter INSTANCE = new TimeZoneNameGetter();

        private TimeZoneNameGetter() {
        }

        @Override
        public String getObject(TimeZoneNameProvider timeZoneNameProvider, Locale locale, String string, Object ... objectArray) {
            Map<String, String> map;
            String string2;
            assert (objectArray.length == 2);
            int n = (Integer)objectArray[0];
            String string3 = TimeZoneNameGetter.getName(timeZoneNameProvider, locale, string, n, string2 = (String)objectArray[1]);
            if (string3 == null && (map = ZoneInfo.getAliasTable()) != null) {
                String string4 = map.get(string2);
                if (string4 != null) {
                    string3 = TimeZoneNameGetter.getName(timeZoneNameProvider, locale, string, n, string4);
                }
                if (string3 == null) {
                    string3 = TimeZoneNameGetter.examineAliases(timeZoneNameProvider, locale, string, string4 != null ? string4 : string2, n, map);
                }
            }
            return string3;
        }

        private static String examineAliases(TimeZoneNameProvider timeZoneNameProvider, Locale locale, String string, String string2, int n, Map<String, String> map) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (!entry.getValue().equals(string2)) continue;
                String string3 = entry.getKey();
                String string4 = TimeZoneNameGetter.getName(timeZoneNameProvider, locale, string, n, string3);
                if (string4 != null) {
                    return string4;
                }
                string4 = TimeZoneNameGetter.examineAliases(timeZoneNameProvider, locale, string, string3, n, map);
                if (string4 == null) continue;
                return string4;
            }
            return null;
        }

        private static String getName(TimeZoneNameProvider timeZoneNameProvider, Locale locale, String string, int n, String string2) {
            String string3 = null;
            switch (string) {
                case "std": {
                    string3 = timeZoneNameProvider.getDisplayName(string2, false, n, locale);
                    break;
                }
                case "dst": {
                    string3 = timeZoneNameProvider.getDisplayName(string2, true, n, locale);
                    break;
                }
                case "generic": {
                    string3 = timeZoneNameProvider.getGenericDisplayName(string2, n, locale);
                }
            }
            return string3;
        }
    }
}

