local ADDON, Addon = ...
local Locale = Addon:NewModule('Locale')

local default_locale = "enUS"
local current_locale = GetLocale()

local langs = {}
langs.enUS = {
	config_characterConfig = "Per-character configuration",
	config_progressTooltip = "Show progress each enemy gives on their tooltip",
	config_progressFormat = "Enemy Forces Format",
	config_progressFormat_1 = "24.19%",
	config_progressFormat_2 = "90/372",
	config_progressFormat_3 = "24.19% - 90/372",
	config_progressFormat_4 = "24.19% (75.81%)",
	config_progressFormat_5 = "90/372 (282)",
	config_progressFormat_6 = "24.19% (75.81%) - 90/372 (282)",
	config_splitsFormat = "Objective Splits Display",
	config_splitsFormat_1 = "Disabled",
	config_splitsFormat_2 = "Time from start",
	config_splitsFormat_3 = "Relative to previous",
	config_autoGossip = "Automatically select gossip entries during Mythic Keystone dungeons (ex: Odyn)",
	config_silverGoldTimer = "Show timer for both 2 and 3 bonus chests at same time",
	config_completionMessage = "Show message with final times on completion of a Mythic Keystone dungeon",
	config_showSplits = "Show split time for each objective in objective tracker",
	keystoneFormat = "[Keystone: %s - Level %d]",
	completion0 = "Timer expired for %s with %s, you were %s over the time limit.",
	completion1 = "Beat the timer for %s in %s. You were %s ahead of the timer, and missed +2 by %s.",
	completion2 = "Beat the timer for +2 %s in %s. You were %s ahead of the +2 timer, and missed +3 by %s.",
	completion3 = "Beat the timer for +3 %s in %s. You were %s ahead of the +3 timer.",
	completionSplits = "Split timings were: %s.",
	timeLost = "Time Lost",
	config_smallAffixes = "Reduce the size of affix icons on timer frame",
	config_deathTracker = "Show death tracker on timer frame",
	scheduleTitle = "Schedule",
	scheduleWeek1 = "This week",
	scheduleWeek2 = "Next week",
	scheduleWeek3 = "In two weeks",
	scheduleWeek4 = "In three weeks",
	scheduleMissingKeystone = "Requires a level 7+ Mythic Keystone in your inventory to display.",
	scheduleUnknown = "The updated affix schedule is currently unknown.",
	config_hideTalkingHead = "Hide Talking Head dialog during a Mythic Keystone dungeon",
	config_resetPopup = "Show popup to reset instances upon leaving a completed Mythic Keystone dungeon",
	partyKeysTitle = "Party Keystones",
	newKeystoneAnnounce = "New Keystone: %s",
	currentKeystoneText = "Current: |cFFFFFFFF%s|r",
	config_announceKeystones = "Announce newly acquired Mythic Keystones to your party",
}
langs.enGB = langs.enUS

langs.esES = {
	config_autoGossip = "Seleccionar opciones de diálogo automáticamente en mazmorras de piedra angular",
	config_characterConfig = "Configuración por personaje",
	config_completionMessage = "Mostrar mensaje con duración final al terminar una mazmorra de piedra angular",
	config_cosRumors = "Enviar pistas de los extienderrumores parlanchines de Corte de las Estrellas por el chat de grupo",
	config_deathTracker = "Mostrar resumen de muertes en el marco del temporizador",
	config_exclusiveTracker = "Ocultar seguimiento de misiones y logros durante mazmorras de piedra angular (requiere reiniciar la interfaz para que surta efecto)",
	config_hideTalkingHead = "Ocultar marcos de diálogo animados en mazmorras de piedra angular",
	config_persistTracker = "Mostrar seguimiento de objetivos tras finalizar una mazmorra de piedra angular (requiere reiniciar la interfaz para que surta efecto)",
	config_progressFormat = "Formato de tropas enemigas",
	config_progressTooltip = "Mostrar porcentaje de tropas enemigas de cada enemigo en su descripción emergente",
	config_resetPopup = "Mostrar ventana emergente de reinicio de estancias tras salir de una mazmorra de piedra angular completada",
	keystoneFormat = "[Piedra angular: %s - Nivel %d]",
	scheduleTitle = "Calendario",
	scheduleWeek1 = "Esta semana",
	scheduleWeek2 = "Semana que viene",
	scheduleWeek3 = "En dos semanas",
	scheduleWeek4 = "En tres semanas",
}
langs.esMX = langs.esES

langs.ruRU = {
	completion0 = "Вы завершили %s за %s, но вышли за лимит времени на %s.",
	completion1 = "Вы завершили %s за %s. Вы опередили время на %s, и не успели для +2 на %s.",
	completion2 = "Вы завершили %s на +2 за %s. Вы опередили время на %s, и не успели для +3 на %s.",
	completion3 = "Вы завершили %s на +3 за %s. Вы опередили время на %s.",
	completionSplits = "Разница во времени была: %s.",
	config_autoGossip = "Автоматически запускать диалоги во время Эпохального Ключа.",
	config_characterConfig = "Настройки для этого персонажа",
	config_completionMessage = "Показывать сообщение с итоговым временем прохождения Эпохального Ключа.",
	config_cosRumors = "Отправлять в групповой чат подсказки от \"Болтливого сплетника\" во время прохождения Квартала Звезд",
	config_deathTracker = "Показывать счётчик смертей в окне таймера",
	config_exclusiveTracker = "Скрывать отслеживаемые задания и достижения в Эпохальных Ключах\\n(требуется перезагрузка интерфейса).",
	config_hideTalkingHead = "Отключить диалоги «Говорящей головы» в Эпохальных ключах.",
	config_persistTracker = "Показать панель задач после прохождения Эпохального Ключа \\n(требуется перезагрузка интерфейса).",
	config_progressFormat = "Формат отображения прогресса",
	config_progressTooltip = "Показывать прогресс за каждого врага в подсказках",
	config_resetPopup = "Предлагать обновить подземелья после выхода из завершённого Эпохального Ключа.",
	config_showSplits = "Показывать разницу времени для каждого события в окне прогресса",
	config_silverGoldTimer = "Показывать таймер для +2 и +3 бонусных сундуков одновременно",
	config_smallAffixes = "Уменьшить значки усилений в окне таймера",
	config_splitsFormat = "Отслеживание достижения целей",
	config_splitsFormat_1 = "Отключено",
	config_splitsFormat_2 = "Время от начала",
	config_splitsFormat_3 = "Относительно предыдущих",
	forcesFormat = " - Войска противника %s",
	keystoneFormat = "[Ключ: %s - Уровень %d]",
	scheduleMissingKeystone = "Для отображения, требуется ключ 7+ уровня в вашем инвентаре.",
	scheduleTitle = "Расписание усилений",
	scheduleWeek1 = "Эта неделя",
	scheduleWeek2 = "Следующая неделя",
	scheduleWeek3 = "Через две недели",
	scheduleWeek4 = "Через три недели",
	timeLost = "Потерянное время",
}

langs.deDE = {
	completion0 = "Zeit abgelaufen für %s mit %s, ihr wart %s über dem Zeitlimit.",
	completion1 = "Zeit für %s in %s geschlagen. Ihr wart %s vor dem Zeitlimit, und habt +2 um %s verfehlt.",
	completion2 = "Zeit für +2 %s in %s geschlagen. Ihr wart %s vor dem Zeitlimit für +2, und habt +3 um %s verfehlt.",
	completion3 = "Zeit für +3 %s in %s geschlagen. Ihr wart %s vor dem Zeitlimit für +3.",
	completionSplits = "Zwischenzeiten waren: %s.",
	config_autoGossip = "Gesprächsoptionen während Mythisch+-Dungeons (z.B. Odyn) automatisch auswählen",
	config_characterConfig = "Charakterspezifische Konfiguration",
	config_completionMessage = "Nachricht mit finalen Zeiten am Ende des Dungeons anzeigen",
	config_cosRumors = "Hinweise von \"Geschwätzige Plaudertasche\" im Hof der Sterne im Gruppenchat ausgeben",
	config_deathTracker = "Todeszähler im Zeitfenster zeigen",
	config_exclusiveTracker = "Quest- und Erfolgsverfolgung während mythischen Schlüsselsteindungeons ausblenden (Erfordert UI neu laden)",
	config_hideTalkingHead = "Gesprächseinblendungen während eines mythischen Schlüsselsteindungeons ausblenden",
	config_persistTracker = "Zielverfolgung nach Abschluss eines mythischen Schlüsselsteins wieder zeigen (Erfordert UI neu laden)",
	config_progressFormat = "Format für \"Feindliche Streitkräfte\"",
	config_progressTooltip = "Fortschritt für \"Feindliche Streitkräfte\" im Tooltip von Feinden zeigen",
	config_resetPopup = "Zeige die Popup Meldung zum zurücksetzen der Instanz, nach der Beendigung einer mythischen Schlüsselstein Instanz.",
	config_showSplits = "Zwischenzeit für jedes Ziel in der Zielverfolgung anzeigen",
	config_silverGoldTimer = "Zeit für +2- und +3-Bonustruhen gleichzeitig zeigen",
	config_smallAffixes = "Die Größe der Affix-Symbole im Zeitfenster verringern",
	config_splitsFormat = "Zwischenzeitsanzeige der Ziele",
	config_splitsFormat_1 = "Deaktiviert",
	config_splitsFormat_2 = "Zeit ab Start",
	config_splitsFormat_3 = "Relativ zum vorherigen",
	forcesFormat = " - Feindliche Streitkräfte: %s",
	keystoneFormat = "[Schlüsselstein: %s - Stufe %d]",
	scheduleMissingKeystone = "Erfordert einen mythischen Schlüsselstein mit Stufe 7+ in deiner Tasche zur Anzeige.",
	scheduleTitle = "Zeitplan",
	scheduleWeek1 = "Diese Woche",
	scheduleWeek2 = "Nächste Woche",
	scheduleWeek3 = "In zwei Wochen",
	scheduleWeek4 = "In drei Wochen",
	timeLost = "Verlorene Zeit",
}

langs.koKR = {
	config_characterConfig = "캐릭터별 설정",
	config_progressTooltip = "각각의 적이 주는 진행도를 툴팁에 표시",
	config_progressFormat = "적 병력 표시 형식",
	config_splitsFormat = "공략 목표당 소요 시간",
	config_splitsFormat_1 = "사용하지 않음",
	config_splitsFormat_2 = "시작점부터 걸린 시간",
	config_splitsFormat_3 = "이전 목표부터 걸린 시간",
	config_autoGossip = "신화 쐐기돌 던전에서 자동으로 대화 넘김 (예: 오딘)",
	config_silverGoldTimer = "추가 상자 2와 3의 남은 시간을 함께 표시",
	config_completionMessage = "신화 쐐기돌 던전 완료시 소요 시간 메시지 표시",
	config_showSplits = "던전 목표에서 각 목표당 소요 시간 표시",
	keystoneFormat = "[쐐기돌: %s - %d 레벨]",
	completion0 = "%s|1이;가; %s만에 끝났습니다. 제한 시간을 %s 초과했습니다.",
	completion1 = "%s|1을;를; %s만에 완료했습니다. 제한 시간은 %s 남았으며 %s|1이;가; 모자라 2상자를 놓쳤습니다.",
	completion2 = "%s 2상자를 %s만에 완료했습니다. 2상자 제한 시간은 %s 남았으며 %s|1이;가; 모자라 3상자를 놓쳤습니다.",
	completion3 = "%s 3상자를 %s만에 완료했습니다. 3상자 제한 시간이 %s 남았습니다.",
	completionSplits = "분할된 시점: %s.",
	timeLost = "잃은 시간",
	config_smallAffixes = "타이머 프레임에 속성 아이콘 크기 축소",
	config_deathTracker = "타이머 프레임에 죽은 횟수 표시",
	scheduleTitle = "예정된 조합",
	scheduleWeek1 = "이번주",
	scheduleWeek2 = "다음주",
	scheduleWeek3 = "2주 뒤",
	scheduleWeek4 = "3주 뒤",
	scheduleMissingKeystone = "예정된 조합을 보려면 레벨 7 이상의 신화 쐐기돌이 가방에 있어야 합니다.",
	config_hideTalkingHead = "신화 쐐기돌 던전에서 팝업 대화창 숨김",
	config_resetPopup = "완료한 신화 쐐기돌 던전을 나가면 인스턴스 초기화 팝업창 표시",
	partyKeysTitle = "파티 쐐기돌",
	newKeystoneAnnounce = "새 쐐기돌: %s",
	currentKeystoneText = "현재 쐐기돌: |cFFFFFFFF%s|r",
	config_announceKeystones = "신화 쐐기돌을 새로 받으면 파티에 알림",
}

langs.zhCN = {
	config_characterConfig = "为角色进行独立的配置",
	config_progressTooltip = "聊天窗口的史诗钥石显示副本名称和等级",
	config_progressFormat = "敌方部队进度格式",
	config_splitsFormat = "进度分割显示方式",
	config_splitsFormat_1 = "禁用",
	config_splitsFormat_2 = "从头计时",
	config_splitsFormat_3 = "与之前关联",
	config_autoGossip = "在史诗钥石副本中自动对话交互（如奥丁）",
	config_silverGoldTimer = "同时显示2箱和3箱的计时",
	config_completionMessage = "副本完成时在聊天窗口显示总耗时",
	config_showSplits = "在任务列表的进度上显示单独的进度计时",
	keystoneFormat = "[%s（%d级）]",
	forcesFormat = " - 敌方部队 %s",
	completion0 = "你超时完成了 %s 的战斗。共耗时 %s，超出规定时间 %s。",
	completion1 = "你在规定时间内完成了 %s 的战斗！共耗时 %s，剩余时间 %s，2箱奖励超时 %s。",
	completion2 = "你在规定时间内获得了 %s 的2箱奖励！共耗时 %s，2箱奖励剩余时间 %s，3箱奖励超时 %s。",
	completion3 = "你在规定时间内获得了 %s 的3箱奖励！共耗时 %s，3箱奖励剩余时间 %s。",
	timeLost = "损失时间",
	config_smallAffixes = "缩小进度条上的光环图标大小",
	config_deathTracker = "在进度条上显示死亡统计",
	config_persistTracker = "副本完成后继续显示任务追踪（重载插件后生效）",
	scheduleTitle = "日程表",
	scheduleWeek1 = "本周",
	scheduleWeek2 = "下周",
	scheduleWeek3 = "两周后",
	scheduleWeek4 = "三周后",
	scheduleMissingKeystone = "你需要一把7级以上的钥石才可激活此项功能。",
	config_exclusiveTracker = "在副本中隐藏任务和成就追踪（重载插件后生效）",
	config_hideTalkingHead = "在史诗钥石副本中隐藏NPC情景对话窗口",
	config_resetPopup = "离开已完成的副本后提示是否重置",
	partyKeysTitle = "队伍钥石信息",
	newKeystoneAnnounce = "新钥石：%s",
	currentKeystoneText = "当前钥石：|cFFFFFFFF%s|r",
	config_announceKeystones = "在队伍里通报获得的新钥石",
}
langs.zhTW = {
	config_characterConfig = "為角色進行獨立的配置",
	config_progressTooltip = "聊天窗口的傳奇鑰石顯示副本名稱和等級",
	config_progressFormat = "敵方部隊進度格式",
	config_splitsFormat = "進度分割顯示方式",
	config_splitsFormat_1 = "禁用",
	config_splitsFormat_2 = "從頭計時",
	config_splitsFormat_3 = "與之前關聯",
	config_autoGossip = "在傳奇鑰石副本中自動進行對話互動（如歐丁）",
	config_silverGoldTimer = "同時顯示2箱及3箱的計時",
	config_completionMessage = "副本完成時在聊天窗口顯示總耗時",
	config_showSplits = "在任務列表的进度上顯示單獨的進度計時",
	keystoneFormat = "[%s（%d級）]",
	forcesFormat = " - 敵方部隊 %s",
	completion0 = "你超時完成了 %s 的戰鬥。共耗時 %s，超出規定時間 %s。",
	completion1 = "你在規定時間內完成了 %s 的戰鬥！共耗時 %s，剩餘時間 %s，2箱獎勵超時 %s。",
	completion2 = "你在規定時間內獲得了 %s 的2箱獎勵！共耗時 %s，2箱獎勵剩餘時間 %s，3箱獎勵超時 %s。",
	completion3 = "你在規定時間內獲得了 %s 的3箱獎勵！共耗時 %s，3箱獎勵剩餘時間 %s。",
	timeLost = "損失時間",
	config_smallAffixes = "縮小計時器上的光環圖標大小",
	config_deathTracker = "在計時器上顯示死亡統計",
	config_persistTracker = "副本完成後繼續顯示任務追蹤（重載插件後生效）",
	scheduleTitle = "日程表",
	scheduleWeek1 = "本周",
	scheduleWeek2 = "下周",
	scheduleWeek3 = "兩周後",
	scheduleWeek4 = "三周後",
	scheduleMissingKeystone = "你需要一把7級以上的鑰石來激活此項功能。",
	config_exclusiveTracker = "在副本中隱藏成就和任務追蹤（重裝插件後生效）",
	config_hideTalkingHead = "在傳奇鑰石副本中隱藏NPC情景對話窗口",
	config_resetPopup = "離開已完成的副本後提示是否重置",
	partyKeysTitle = "隊伍鑰石信息",
	newKeystoneAnnounce = "新鑰石：%s",
	currentKeystoneText = "當前鑰石：|cFFFFFFFF%s|r",
	config_announceKeystones = "在隊伍里通報獲得的新鑰石",
}
langs.ptBR = {
	completion0 = "Tempo expirado para %s com %s, você ficou %s acima do tempo limite.",
	completion1 = "Bateu o tempo para %s em %s. Você ficou %s à frente do tempo, e perdeu +2 por %s.",
	completion2 = "Bateu o tempo para +2 %s em %s. Você ficou %s à frente do tempo para +2, e perdeu +3 por %s.",
	completion3 = "Bateu o tempo para +3 %s em %s. Você ficou %s à frente do tempo da +3.",
	completionSplits = "Tempos separados foram: %s.",
	config_autoGossip = "Selecionar automaticamente opções de conversa durante masmorras de pedra-chave míticas (ex: Odyn)",
	config_characterConfig = "Configuração por personagem",
	config_completionMessage = "Mostrar mensagem com os tempos finais ao completar uma masmorra de pedra-chave mítica",
	config_cosRumors = "Enviar no chat do grupo as pistas para os \"Matraquis Boatante\" durante a Corte das Estrelas",
	config_deathTracker = "Mostrar mortes na janela de tempos",
	config_exclusiveTracker = "Esconder missões e conquistas rastreadas durante pedra-chave míticas (recarregue a IU para surtir efeito)",
	config_hideTalkingHead = "Esconder o diálogo da cabeça falante durante uma masmorra de pedra-chave mítica",
	config_persistTracker = "Mostrar o rastreador de objetivos depois de completar uma pedra-chave mítica (recarregue a IU para surtir efeito)",
	config_progressFormat = "Formato de forças inimigas",
	config_progressTooltip = "Mostrar o progresso que cada inimigo fornece, em sua ferramenta de dicas",
	config_resetPopup = "Mostrar popup para reiniciar instâncias após sair de uma masmorra de pedra-chave mítica concluída",
	config_showSplits = "Mostrar tempo separado pra cada objetivo no rastreador de objetivos",
	config_silverGoldTimer = "Mostrar tempo para ambos baús bônus 2 e 3 ao mesmo tempo",
	config_smallAffixes = "Reduzir o tamanho dos ícones dos afixos na janela de tempos",
	config_splitsFormat = "Mostrar objetivos separados",
	config_splitsFormat_1 = "Desabilitado",
	config_splitsFormat_2 = "Tempo do começo",
	config_splitsFormat_3 = "Relativo ao anterior",
	forcesFormat = "- Forças inimigas: %s",
	keystoneFormat = "[Pedra-chave: %s - Nível %d]",
	scheduleMissingKeystone = "Requer uma pedra-chave mítica 7+ no seu inventário para mostrar",
	scheduleTitle = "Programação",
	scheduleWeek1 = "Essa semana",
	scheduleWeek2 = "Próxima semana",
	scheduleWeek3 = "Em duas semanas",
	scheduleWeek4 = "Em três semanas",
	timeLost = "Tempo perdido",
}


function Locale:Get(key)
	if langs[current_locale] and langs[current_locale][key] ~= nil then
		return langs[current_locale][key]
	else
		return langs[default_locale][key]
	end
end

function Locale:Local(key)
	return langs[current_locale] and langs[current_locale][key]
end

function Locale:Exists(key)
	return langs[default_locale][key] ~= nil
end

setmetatable(Locale, {__index = Locale.Get})
