--
--	Grail Quests
--	Written by scott@mithrandir.com
--
--	Version History
--		001	Initial verison.
--		002	Added all the Lunar Festival and Harvest Festival quests.
--		003	Added the Love is in the Air quests except for the following which appear to have been removed from the game
--				[14488]='HA L075 A:38208 T:36296 P:24792,24793'
--				[24792]='HA FA L078 A:38066 T:38208'
--				[24793]='HA FH L078 A:37172 T:38208'
--		004	Added yearly markers to Lunar Festival quests.
--			Added Noblegarden quests, markers for Pilgrim's Bounty and Day of the Dead quests
--			Updated a couple starting Worgen quests.
--		005	Updated a bunch of quests.
--		006	Updated a bunch of quests.
--		007	Added a bunch of quests for the last remaining holidays.
--			Updated a bunch of quest information (primarily prerequisites) based on game play.
--			Started processing new quests added in game version 4.1.
--		008	Started putting in K codes.
--			Updated quest prerequisites, etc. based on game play.
--		009	Removed the cloth donation quests.
--			Updated a lot of Alliance Twilight Highlands based on game play.
--		010	More updates including some more level information.
--		011	Added more K codes for some low-level quests.
--			Put in some I:, P: and reputation requirements for Deepholm quests.
--			Converted A:0 to the Self alias NPCs that indicate probable zones for acceptance.
--			Added a bunch of Firelands quests.
--		012	Added a lot more K codes
--			Some updates to Firelands quests.
--		013	Updates to some Horde starting areas, Gilneas and a few tweaks to Firelands.
--		014 Put all the quests in numeric order instead of keeping some of the groups for processing purposes.
--			Many updates to zones noted in the Grail.lua file.
--			Horde cooking and fishing quests updated.
--			Converted the K codes for cooking/fishing/Brewfest quests to level 0 to indicate they are actually the level of the player accepting them.
--		015	Some minor updates after some massive ones previously.
--			Hallow's End updates.
--			Introduced a few new codes.
--		016	Switched out all the ++, +D, +W, +M and +Y codes for their "bitmap values".
--
--	Known issues
--		Not all quests are present.
--		Not all quest information is accurate.
--		Need to update the Horde Children's Week quests.
--
--	UTF-8 file
--
--	Each of the Midsummer torch tossing/catching quests is marked as incompatible with the other
--	faction's same quest.  This is because this is what happens in the runtime when playing, even
--	though nowadays one cannot get the quest at the other faction's questgiver.
--
--	Entries in the quest table:
--		0	localized name of the quest
--		1	code string
--		2	cached type bit value
--		3	cached holiday bit value
--		4	cached obtainers bit value
--		5	achievement "map areas"
--		6	table of reputation changes when quest turned in
--		7	realtime computed status
--		8	A codes (NPC IDs processed for faction)
--		9	T codes (NPC IDs processed for faction)
--		10	P codes
--		11	I codes
--		12	O codes
--		13	cached level bit value
--		14	reputation requirements from P codes	(a table of tables where the internal table has the reputation code and the amount (with amount negative meaning not to exceed))
--
--		SP, rep (V & W codes), OAC codes, OBC:, OCC:, OTC:, Y (alias quests), processed T codes, processed A codes, AK, AZ, PL, PLT, PH, PC, PCT, prof
--
--      Possible codes for prerequisite info:
--		(if no code present A assumed for P: and C is assumed for I: and B:)
--			A   quest must be turned in
--			a	world quest must be available
--			B   quest must be in log
--			C   quest must be in log or turned in
--			c	quest must NOT be in log and NOT turned in
--			D   quest must be completed in log
--			E   quest must be completed in log or turned in
--			e	quest must be in log but not completed or not turned in
--			Fx	must belong to faction x where A is Alliance and H is Horde
--			Gbbbbppp	building bbbb (with negative meaning any of that type) present in garrison, with optional ppp plot location required
--			H   quest has ever been completed
--			I   spell effect present
--			i	spell effect NOT present
--			J   achievement completed
--			j	achievement NOT completed
--			K	item possessed
--			k	item NOT possessed
--			Lxxx	player level must be >= xxx
--			lxxx	player level must be < xxx
--			M	quest has been abandoned at least once
--			m	quest has never been abandoned
--			Nx	where x is the key to a required class (see classMapping).
--			nx	where x is the key to a forbidden class (see classMapping).
--			O	quest must be accepted
--			Pxyyy	profession x (see professionMapping) must have a skill value of at least yyy
--			Qxxxx	the equipped iLvl must be >= xxxx
--			qxxxx	the equipped iLvl must be < xxxx
--			R	spell effect has ever been present
--			S	skill possessed (where the value is Blizzard's spell ID of the skill)
--			s	skill not possessed (where the value is Blizzard's spell ID of the skill)
--			Txxxyyyyy	reputation xxx must be at least yyyyy value
--			txxxyyyyy	reputation xxx must be under yyyyy value
--			Uxxxyyyyy	frienship reputation xxx must be at least yyyyy value -- used for withering
--			uxxxyyyyy	frienship reputation xxx must be under yyyyy value -- used for withering
--			Vxxxy	quest group xxx must have y quests accepted
--			vxxxxx	quest must have been turned in prior to the previous weekly reset
--			Wxxxy	quest group xxx must have y quests completed (turned in)
--			wxxxy	quest group xxx must have y quests completed in log or turned in
--			X	quest must not be turned in
--			xyy	artifact knowledge level must be at least yy
--			Y	achievement completed by this player
--			y	achievement NOT completed by this player
--			Z	spell has ever been cast by player
--			zbbbb	building bbbb (with negative meaning any of that type) needs a worker	[I will eventually unify the letters above properly to free one instead of using 'z']
--			=zzzzp	the current phase in zone zzzz must be phase p
--			>zzzzp	the current phase in zone zzzz must be more than phase p
--			<zzzzp	the current phase in zone zzzz must be less than phase p
--			!xxxx	the NPC represented by xxxx needs to be killed		*** implement this ***
--			?xxxx	when zone xxxx is entered	*** implement this ***
--			@yyyxxxx	artifact item ID xxxx must be >= level y	*** implement this ***
--			#xxx	the item represented by xxx needs to be available in a class hall mission
--			$xyy	renown with covenant x must be at least yy
--				0=any, 1=Kyrian, 2=Venthyr, 3=NightFae, 4=Necrolord
--			^	calling quest must be available
--			&xxx	Azerite level is at least
--			%xxxx	garrison (covenant) talent must be researched
--			*xyy	renown with covenant x must be less than yy
--
--		Note that garrison level is examined by using phase comparisons to zone 971 so, e.g., >09711 would mean a garrison of level 2 or higher.
--
--	The code string can indicate any of the following information and should not be localized:
--		A:list		where list (see below) is the list of NPCs that give this quest to anyone
--		AA:list		where list (see below) is the list of NPCs that give this quest to Alliance only
--		AH:list		where list (see below) is the list of NPCs that give this quest to Horde only
--		AK:list		where list (see below) is the list of NPCs that you can kill to automatically start the quest
--		AZ:zone		where zone is the zone ID of the zone that when entered automatically gives the quest
--		B:list		where list (see below) is the list of quests for which this quest is a breadcrumb quest	*** NO LONGER USED ***
--		Cx			where x is the key to a required class (see classMapping). if no Cx is present any class can accept the quest.  mutually exclusive with Xx codes.
--		Dxxx		where xx is the number of the group to which these daily quests belong
--		Exxxxx		where xxxxx is the Blizzard release version where this quest starts to exist
--		Fx			where x is the key to a permitted faction (A for Alliance and H for Horde).  if no Fx is present any faction can accept the quest
--		Gx			where x is the key to a permitted gender (M for male and F for female).  if no Gx is present any gender can accept the quest
--		Hx			where x is the key to a specific holiday (see holidayMapping) when this quest is available.  if no Hx is present it should be available all the time.
--		I:pat		where pat is a pattern (see below) of quests considered to invalidate the quest (they are mutually exclusive with this quest)  in other words, if the quest is in the Blizzard quest log or has ever been completed
--		J:pat		where pat is a pattern (see below) of quests considered to have caused this FLAG quest to be marked complete.  Used for UI to ignore FLAG quests and present to the user a nicer experience.
--		DEPRECATED Kxxxyyy		where xxx is the level of the quest (or 000 if the quest has a changing quest level the same as the player level) and
--		Kyyy
--			yyy is a number whose bits represent aspects of the quest:
--			1	repeatable
--			2	daily
--			4	weekly
--			8	monthly
--			16	yearly
--			32	escort
--			64	dungeon
--			128	raid
--			256	PVP
--			512	group
--			1024	heroic
--			2048	scenario
--			4096	legendary
--			8192	account-wide
--			16384	pet battle
--			32768	bonus objective
--			65536	rare mob
--			131072	treasure
--			262144	world quest
--			524288	biweekly (every two weeks)
--			1048576	threat quest
--			2097152	calling quest
--		DEPRECATED Lxxx		where xxx is the minimum level for the quest to be acceptable
--		Lxxxxxxx	where xxxxxxx is an integer value that represented three parts of a quest's level added together
--			The old K value * 65536
--			The old L value * 256
--			The old N value * 1
--		Mxxx		where xxx is the maximum level for the quest to be acceptable
--		Nxxx		where xxx is the scaled maximum level for the quest
--		O:pat		where pat is a pattern (see below) of quests that are optional prerequisites
--		OAC:list	where list (see below) is the list of quests that are marked complete once this quest is accepted (On Accept Complete)
--		OBC:list	where list (see below) is the list of quests that are marked "control" complete once this quest is abandoned
--		OCC:list	where list (see below) is the list of quests that are marked complete once this quest is marked complete in the quest log
--		ODC:list	where list (see below) is the list of quests that are marked complete once this quest is turned in
--		OEC:list	where list (see below) is the list of quests that are marked complete once this quest is turned in and OPC: rules are met
--		OPC:pat		where pat is a pattern (see below) of prerequisites that need to be met before other OxC: codes that use OPC: rules will do their actions
--		OTC:pat		where pat is a comma-separated list of plus-separated pairs where the first in the pair is an NPC ID and the second is the quest ID to complete
--		P:pat		where pat is a pattern (see below) of quests considered to be prerequisites
--		DEPRECATED	Pxyyy		where x is the key to a required profession and yyy is the minimum skill (see professionMapping).
--		Qx:QualifiedPattern	is completed when a Gossip number x is peformed with the first matching NPC from the QualifiedPattern
--		Rx			where x is the key to a permitted race (see raceMapping).  if no Rx is present any race can accept the quest
--		Sx			where x is the key to an excluded race (see raceMapping).  if no Sx is present, any race can accept the quest
--		SP			indicated the quest is a special one that never appears in the quest log
--		T:list		where list (see below) is the list of NPCs where the quest is turned in by anyone
--		TA:list		where list (see below) is the list of NPCs where the quest is turned in by Alliance only
--		TH:list		where list (see below) is the list of NPCs where the quest is turned in by Horde only
--		Ux			where x is the follower ID obtained when completing the quest
--		DEPRECATED	Vxxyyyyy	where xx is the key to the required reputation and yyyyy is the minimum number of earned points in it (see reputationMapping).  note that you add 42000 to earned value.
--			hated: 0   hostile: 35999   unfriendly: 38999
--			neutral: 41999   friendly: 44999   honored: 50999   revered: 62999   exalted: 83999
--			Acquaintance: 50399   Buddy: 58799   Friend: 67199
--			Good Friend: 75599   Best Friend: 83999 (just like exalted)
--		Wxxx		where xxx is the number of the group to which these weekly quests belong
--		Xx			where x is the key to an excluded class (see classMapping).  if no Xx is present any class can accept the quest.  mutually exclusive with Cx codes.
--		Y:questId	where questId represents the quest that this quest is an alias for
--		Zxxxxx		where xxxxx is the Blizzard release version past where this quest does not exist
--
--		Both A: and T: codes have a modification to AP: and TP: that allow a pattern to indicate a specific NPC is used when certain prequisites are matched and
--		allows a list of these NPCs.  The first NPC matching prerequisites is used.  An example:
--			AP:12345:H123+S345;23456:P12321+P45678
--			NPC 12345 is valid when H123+S345    and NPC 23456 is valid when P12321+P45678
--		Semicolon separates prerequisite phrases.  If there is no colon after the NPC id, then the NPC is always valid.
--
--		When an NPC phases, we make an alias NPC and use the AP:/TP: structure to handle this.  If we were to attempt to actually apply the prerequisite information on
--		the NPC itslef to represent the phasing we would lose the capability to map locations properly that are not in the current phase.  Therefore, alias NPCs are used
--		for the proper NPC for each quest part.
--
--	Patterns for prerequisites and invalidations is a comma-separated list of quests, any of which match.  Within the comma-separated list there
--	can be plus-separated values that indicate each of them must match.  For example, the following code:
--		123,456,789+1122,3344
--	means any of the following quests would match the pattern:
--		123
--		456
--		both 789 and 1122 (together)
--		3344
--
--	Lists are just comma-separated values.
--
Grail_Quests_File_Version = 016

if Grail.questsVersionNumber < Grail_Quests_File_Version then
Grail.questsVersionNumber = Grail_Quests_File_Version

Grail.dailyMaximums = {
	[001] = 3,	-- Anglers has 3 a day maximum
	[002] = 4,	-- Mistfall Village has 4 a day maximum (we are ignoring any perceived direct incompatibilities for now)
	[003] = 1,	-- Golden Pagoda from Kun Autumnlight
	[004] = 1,	-- Golden Pagoda from Sun Tenderheart
	[005] = 1,	-- Golden Pagoda from Anji Autumnlight (set one)
	[006] = 1,	-- Golden Pagoda from Anji Autumnlight (set two)
	[007] = 7,	-- Klaxxi Lake of Stars			(this and the other Klaxxi grouping is solely to allow detection of the right "hidden" daily based on the active group, that is why maximum count allowed)
	[008] = 7,	-- Klaxxi Terrace of Gurthan
	[009] = 7,	-- Klaxxi Clutches of Shek'zeer
	[010] = 7,	-- Klaxxi Zan'vess
	[011] = 3,	-- Ruins of Guo-Lai
	[012] = 0,	-- ***** ***** NOT USED ***** *****
	[013] = 1,	-- Whitepetal Lake one
	[014] = 1,	-- Whitepetal Lake two
	[015] = 1,	-- Whitepetal Lake three
	[016] = 1,	-- Whitepetal Lake four
	[017] = 2,	-- Cloud Serpent one [ Sweet As Honey | Pooped | Catch! ]
	[018] = 3,	-- Cloud Serpent two [ Restoring the Balance | Disarming the Enemy | Slitherscale Suppression ]
	[019] = 3,	-- Cloud Serpent three [ Thinning the Pack | On The Prowl | The Shoe Is On The Other Foot | Dark Huntress | Sprite Fright ]
	[020] = 3,	-- Cloud Serpent four [ Monkey Mischief | The Big Kah-Oona | The Big Brew-haha | Saving the Serpents ]
	[021] = 3,	-- Cloud Serpent five [ Lingering Doubt | Weeping Widows | The Seed of Doubt | A Tangled Web ]
	[022] = 3,	-- Jade Serpent
	[023] = 4,	-- Whitepetal Lake invasion
	[024] = 4,	-- Shado-Pan Master Snowdrift
	[025] = 1,	-- lead-in Jade Serpent
	[026] = 1,	-- lead-in Red Crane
	[027] = 1,	-- lead-in White Tiger
	[028] = 1,	-- lead-in Black Ox
	[029] = 2,	-- White Tiger one
	[030] = 2,	-- White Tiger two
	[031] = 3,	-- Red Crane
	[032] = 4,	-- Black Ox one
	[033] = 4,	-- Black Ox two
	[034] = 4,	-- Shado-Pan Ling
	[035] = 4,	-- Shado-Pan Ban one
	[036] = 3,	-- Cloud Serpent six [ The Sky Race | the five The Trainer's Challenge: quests ]
	[037] = 4,	-- Shado-Pan Ban two
	[038] = 4,	-- Shado-Pan Ban three
	[039] = 1,	-- Shado-Pan Challenges Ban
	[040] = 1,	-- Shado-Pan Challenges Ling
	[041] = 1,	-- Shado-Pan Challenges Snowdrift
	[042] = 1,	-- White Tiger non-brawl
	[043] = 5,	-- Ruins of Ogudei (Alliance)
	[044] = 5,	-- Dominance Point (Alliance)
	[045] = 1,	-- August Celestials
	[046] = 5,	-- Bilgewater Operations (Alliance)
	[047] = 5,	-- Lion's Landing (Horde)
	[048] = 5,	-- Bilgewater Operations (Horde)
	[049] = 3,	-- Dominance Point (Horde)
	[050] = 6,	-- Ruins of Ogudei (Horde)
	[051] = 5,	-- Lion's Landing (Alliance)
	[052] = 5,	-- Bilgewater Operations (Horde) two
	[053] = 4,	-- Za'Tual Horde
	[054] = 4,	-- Court of Bones Horde
	[055] = 4,	-- Za'Tual Alliance
	[056] = 4,	-- Court of Bones Alliance
	[057] = 4,	-- Ihgaluk Crag Alliance
	[058] = 4,	-- Ihgaluk Crag Horde
	[059] = 1,	-- Phase 1 Elite Alliance
	[060] = 1,	-- Phase 1 Elite Horde
	[061] = 11,	-- Phase 1 Starter Alliance
	[062] = 11,	-- Phase 1 Starter Horde
	[063] = 3,	-- Diremoor Alliance
	[064] = 3,	-- Diremoor Horde
	[065] = 11,	-- Phase 2 Starter Alliance
	[066] = 11,	-- Phase 2 Starter Horde
	[067] = 7,	-- Isle Of Thunder PvP Alliance
	[068] = 7,	-- Isle Of Thunder PvP Horde
	[069] = 8,	-- Phase 3 Starter Alliance
	[070] = 8,	-- Phase 3 Starter Horde
	[071] = 1,	-- Phase 3 Elite Alliance
	[072] = 1,	-- Phase 3 Elite Horde
	[073] = 3,	-- Beast Pen Alliance
	[074] = 3,	-- Beast Pen Horde
	[075] = 3,	-- Conqueror's Terrace Alliance
	[076] = 3,	-- Conqueror's Terrace Horde
	[077] = 6,	-- Phase 4 Starter Alliance
	[078] = 6,	-- Phase 4 Starter Horde
	[079] = 1,	-- Phase 4 Elite Alliance
	[080] = 1,	-- Phase 4 Elite Horde
	[081] = 1,	-- Lightning Vein Mine Alliance
	[082] = 1,	-- Lightning Vein Mine Horde
	[083] = 5,	-- Phase 5 Starter Alliance
	[084] = 5,	-- Phase 5 Starter Horde
	[085] = 1,	-- Phase 5 Extra Alliance
	[086] = 1,	-- Phase 5 Extra Horde
	[087] = 5,	-- [053] + leadin
	[088] = 5,	-- [054] + leadin
	[089] = 5,	-- [055] + leadin
	[090] = 5,	-- [056] + leadin
	[091] = 5,	-- [057] + leadin
	[092] = 5,	-- [058] + leadin
	[093] = 1,	-- Alliance Garrison Campaign quests (only the first random 8)
	[094] = 2,	-- Alliance Daily quests in garrison
	[095] = 1,	-- Alliance daily fishing garrison
	[096] = 1,	-- Nat Pagle Garrison fishing daily
	[097] = 1,	-- Horde daily fishing garrison
	[098] = 1,	-- Horde Garrison Campaign quests (only the first random 8)
	[099] = 2,	-- Horde Daily quests in garrison
	[100] = 2,	-- Inn quests
	[101] = 2,  -- Narasi Snowdawn	(Icecrown)
	[102] = 2,  -- Girana the Blooded	(Icecrown)
	[103] = 1,	-- Parvink (Lion's Watch Tanaan Jungle)
	[104] = 1,	-- Mission Table Lion's Watch Tanaan Jungle
	[105] = 1,	-- Mission Table Lion's Watch Tanaan Jungle Followon
	[106] = 1,	-- Nimi Brightcastle (Vol'mar Tanaan Jungle)
	[107] = 1,	-- Mission Table Vol'mar Tanaan Jungle
	[108] = 1,	-- Mission Table Vol'mar Tanaan Jungle Followon
	[109] = 1,	-- Mission Table Lunarfall
	[110] = 1,	-- Mission Table Frostwall
	[111] = 1,	-- Garrison weekend
	[112] = 1,	-- Alliance Talbuk training
	[113] = 1,	-- Alliance Clefthoof training
	[114] = 1,	-- Alliance Boar training
	[115] = 1,	-- Alliance Riverbeast training
	[116] = 1,	-- Alliance Elekk training
	[117] = 1,	-- Alliance Wolf training
	[118] = 1,	-- Horde Talbuk training
	[119] = 1,	-- Horde Clefthoof training
	[120] = 1,	-- Horde Boar training
	[121] = 1,	-- Horde Riverbeast training
	[122] = 1,	-- Horde Elekk training
	[123] = 1,	-- Horde Wolf training
	[124] = 1,	-- Tanaan Garrison campaign Alliance
	[125] = 1,	-- Tanaan Garrison campaign Horde
	[126] = 1,	-- Garrison Gem Boutique Jewelcrafting
	[127] = 1,	-- Druid Class Hall artifact completion quests
	[128] = 1,	-- Death Knight Class Hall artifact completion quests
	[129] = 1,	-- Hunter Class Hall artifact completion quests
	[130] = 1,	-- Mage Class Hall artifact completion quests
	[131] = 1,	-- Monk Class Hall artifact completion quests
	[132] = 1,	-- Paladin Class Hall artifact completion quests
	[133] = 1,	-- Priest Class Hall artifact completion quests
	[134] = 1,	-- Rogue Class Hall artifact completion quests
	[135] = 1,	-- Shaman Class Hall artifact completion quests
	[136] = 1,	-- Warlock Class Hall artifact completion quests
	[137] = 1,	-- Warrior Class Hall artifact completion quests
	[138] = 1,	-- Demon Hunter Class Hall artifact completion quests
	[139] = 1,	-- Pillars of Creation found quests
	[140] = 3,	-- Emissary World Quest
	[141] = 1,	-- Leyline Feed quests
	[142] = 1,	-- Dalaran archaeology quests
	[143] = 1,	-- Lunarfall weekly invasion quests
	[144] = 1,	-- Frostwall weekly invasion quests
	[145] = 1,	-- Alliance Warfront Mae Wagglewand
	[146] = 1,	-- Horde Warfront Uma'wi
	[147] = 1,	-- Alliance Warfront Norber Togglesprocket
	[148] = 3,	-- Alliance Warfront
	[149] = 3,	-- Horde Warfront
	[150] = 3,	-- Maw
	[151] = 2,	-- Venthyr Pridefall Hamlet
	}

Grail.weeklyMaximums = {
	[001] = 2,	-- Seal of Wartorn Fate
	[002] = 1,	-- Weekly Bonus Events
	[003] = 2,	-- Trading Favors/A Valuable Find weekly dungeon
	[004] = 2,	-- PVP weekly
	[005] = 1,	-- Kah-Toll weekly
	[006] = 2,	-- Ve'nari weekly
	}

--[3]=''
--[4]='K0900 L090 A:558646 P:3,i774'	-- need to know what rejuvenation is.  need to have another quest do ODC:3
--[4]='K0900 L090 A:558646 T:558646 P:R774+i774'	-- this would require the experience of Rejuvenation.  Once done, the quest becomes available. [appears in 4 winds]
--[4]='K0900 L090 A:59584 T:59584 P:W0013'	-- this quest becomes available when 3 Anglers quests are turned in

local _, release, _, interface = GetBuildInfo()
release = tonumber(release)
interface = tonumber(interface)

local G = Grail.questCodes

if release >= 0 and interface >= 80000 then
G[2]='FH L3936000 A:100016305 T:12696'
G[5]='L4372 E29297'
G[6]='L517 E32305'
G[7]='L258 E32305'
G[9]='L2063 E31961'
G[10]='L10032'
G[11]='FA L1 A:963 T:963 O:239'
G[12]='L2316 E31961'
G[13]='L2318 E31961'
G[14]='L2321 E31961'
G[15]='L259 E29297'
G[16]='fA K1 L1 A:255 T:255'
G[17]='L9770 E32305'
G[18]='L516 E31961'
G[19]='L4633 E31961'
G[20]='L4629 E31961'
G[21]='L261 E31961'
G[22]='L2316 E31961'
G[23]='FH L7 A:100016303 T:34559'
G[24]='FH L7 A:100016304 T:34359'
G[25]='L7 A:34559 T:34559'
G[27]='FH L4097 RT E32305'
G[29]='FA L4097 RE E32305'
G[33]='L258 E30993'
G[34]='L4632 E31961'
G[35]='FA L1 A:240 T:261 P:40'
G[36]='L2314 E31961'
G[37]='FA L1 A:261 T:1000055 P:35'
G[38]='L2317 E28768'
G[40]='FA L1 A:241 T:240'
G[45]='FA L1 A:1000055 T:1000056 P:37'
G[46]='FA L1 A:1203733 T:261'
G[47]='FA L1 A:241 T:241'
G[52]='FA L1 A:261 T:261'
G[54]='FA L1 A:197 T:240 P:26390'	-- TODO: Determine what is I: because Saab did not get this offered
G[56]='L4632 E31961'
G[57]='L4634 E32305'
G[58]='L4638 E31961'
G[59]='FA L1 A:261 T:278 P:71'
G[60]='FA L1 A:253 T:253'
G[61]='L775 E32305'
G[62]='FA L1 A:240 T:240'
G[64]='L2316 E29297'
G[65]='L3602 E31961'
G[67]='L5660 E31961'
G[69]='L5660 E31961'
G[70]='L5660 E32305'
G[71]='FA L1 A:1000056 T:261 P:45'
G[76]='FA L1 A:240 T:240 P:62'
G[82]='L10031 E31961'
G[83]='FA L1 A:278 T:278'
G[84]='FA L1 A:246 T:247 P:86'
G[85]='FA L1 A:246 T:247'
G[86]='FA L1 A:247 T:246 P:85'
G[87]='FA L1 A:247 T:246 P:84'
G[88]='FA L1 A:244 T:244'
G[89]='L3860 E31961'
G[90]='L4633 E32305'
G[91]='L4375 E31961'
G[92]='L3858 E31961'
G[93]='L4372 E31961'
G[94]='L5141 E31961'
G[95]='L5145 E31961'
G[98]='L5664 E32305'
G[99]='L2319 E32305'
G[101]='L4633 E31961'
G[102]='L2062 E31961'
G[103]='L7 E32305'
G[105]='L12860 E31961'
G[106]='FA L1 A:251 T:252 O:26150'
G[107]='FA L1 A:248 T:253 P:111'
G[109]='L2314 E32305'
G[111]='FA L1 A:252 T:248 P:106'
G[112]='FA L1 A:253 T:253 P:107'
G[114]='FA L1 A:253 T:251 P:112'
G[115]='L4631 E31961'
G[116]='L3087 E31961'
G[117]='L15 E32305'
G[118]='L3602 E32305'
G[119]='L3346 E31961'
G[120]='L14 E32305'
G[121]='L14 E31961'
G[122]='L3602 E31961'
G[123]='FA L1 A:100001307 T:42256'
G[124]='L3860 E31961'
G[125]='L3856 E32305'
G[126]='L3861 E31961'
G[127]='L4117 E31961'
G[128]='L5145 E31961'
G[129]='L3087 E32305'
G[130]='L3087 E31961'
G[131]='L7 E32305'
G[132]='L3602 E32305'
G[133]='L5147 E32305'
G[134]='L5150 E31961'
G[135]='L3602 E31961'
G[136]='L2576 E32305'
G[138]='L7 E31961'
G[141]='L3602 E31961'
G[142]='L3602 E31961'
G[143]='L14 E31961'
G[144]='L14 E32305'
G[145]='L18 E31961'
G[147]='FA L1 A:42256 T:42256 P:123'
G[148]='L5144 E32144'
G[149]='L5144 E32305'
G[150]='L20 E31961'
G[151]='L2318 E31961'
G[152]='L2579 E31961'
G[153]='L2575 E31961'
G[155]='L3602 E31961'
G[156]='L5144 E31961'
G[157]='L5144 E32305'
G[159]='L5144 E32305'
G[161]='L2578 E31961'
G[163]='L4372 E32305'
G[164]='L4375 E32305'
G[165]='L4377 E32305'
G[166]='L3606 E31961'
G[167]='L3860 E31961'
G[168]='L3602 E31961'
G[169]='L2842 E31961'
G[170]='L258 E32305'
G[171]='HC FA L7866880 A:14305 T:51988 P:29117+29119'
G[172]='HC FH L7866880 A:51989 T:14444'
G[173]='L5916 E31961'
G[174]='L5145 E31961'
G[175]='L10 E32305'
G[176]='FA L1 A:1000068,1156561 T:240'
G[177]='L5145 E32305'
G[178]='FA L3863 E32305'
G[179]='L1 E32305'
G[180]='L2842 E31961'
G[181]='L5150 E32305'
G[182]='FA L1 A:786 T:786 P:24487'
G[183]='L259 E32305'
G[184]='FA L5 A:1203734 T:42308'
G[185]='L10 A:717 T:717,-50 P:583'
G[186]='L10 A:-50,717 T:-50,717 P:185'
G[187]='L10 A:-50,717 T:-50,717 P:186'
G[188]='L10 A:-50,717 T:717 P:187'
G[189]='L7715 E31961'
G[190]='L10 A:718 T:718,-50 P:583'
G[191]='L10 A:-50,718 T:-50,718 P:190'
G[192]='L10 A:-50,718 T:-50,718 P:191'
G[193]='L10 A:-50,718 T:718 P:192'
G[194]='L10 A:715 T:-50,715 P:583'
G[195]='L10 A:-50,715 T:-50,715 P:194'
G[196]='L10 A:-50,715 T:-50,715 P:195'
G[197]='L10 A:-50,715 T:715 P:196'
G[198]='FA L7712 E32305'
G[200]='L7715 E32305'
G[201]='L7200 E31961'
G[202]='L7720 E31961'
G[203]='L7713 E32305'
G[204]='L7714 E32305'
G[205]='L7720 E31961'
G[206]='L7726 E32305'
G[207]='L7718 E31961'
G[208]='L10 A:715 T:715 P:188+193+197'
G[209]='L9514 E31961'
G[210]='L8229 E32305'
G[211]='L12860 E32305'
G[213]='L7972 E31961'
G[214]='L3601 E32305'
G[216]='L7 A:12757 T:12757'
G[218]='FA L1 A:786 T:786 P:24489'
G[221]='L5917 E32305'
G[222]='L5919 E32305'
G[224]='L2058 E31961'
G[226]='L4885 E32305'
G[228]='L6430 E31961'
G[231]='L15 E32305'
G[233]='L259 E32305'
G[235]='L20 E31961'
G[236]='FA K4 L25 A:31108 T:31108'
G[237]='L2575 E32305'
G[239]='L1 A:240 T:963 P:76'
G[240]='L4372 E32305'
G[241]='L7 E31961'
G[243]='L9774 E32305'
G[245]='L4373 E31961'
G[246]='L2833 E31961'
G[250]='L2578 E32305'
G[253]='L5150 E32305'
G[255]='L2579 E31961'
G[256]='L2326 A:1000256 T:1139 Z12213'
G[257]='FA L2318 Z12213'
G[261]='L8743 E31961'
G[263]='L2058 E32305'
G[264]='L5 A:5543 T:1024776'
G[267]='L2058 E31961'
G[269]='L5149 E32305'
G[270]='L5149 E32305'
G[271]='L2575 E31961'
G[272]='FA L4097 RE E31961'
G[273]='L5 A:1105 T:2057 P:302 Z12213'
G[274]='L7 E31961'
G[275]='L5146 E32305'
G[276]='L5141 E32305'
G[277]='L5143 E32305'
G[279]='L5142 E32305'
G[281]='L5145 E32305'
G[286]='L10 E32305'
G[287]='L1 A:1252 T:1252 Z12213'
G[288]='L5659 E32305'
G[289]='L5661 E32305'
G[290]='L5662 E32305'
G[291]='L1 A:1252 T:1274 P:287 Z12213'
G[294]='L5656 E32305'
G[295]='L5659 E31961'
G[296]='L5661 E32305'
G[297]='L2573 E32028'
G[298]='L5 A:1344 T:1105 Z12213'
G[299]='L6428 E32305'
G[301]='L5 E31961'
G[302]='L5 E32305'
G[303]='L6430 E31961'
G[304]='L6687 E32305'
G[305]='L5400 E31961'
G[307]='L2315 E31961'
G[309]='L5 A:2057 T:1344 P:13639'
G[310]='FA L1286 E32305'
G[311]='L519 E32305'
G[312]='L1 E32305'
G[313]='FA L1 A:40950 T:40950 P:25724'
G[314]='FA L1 A:1265 T:1265 P:25932'
G[315]='FA L1 A:1374 T:1374'
G[317]='L1 E31961'
G[318]='L1 E31961'
G[319]='L1 E32305'
G[320]='L1 E31961'
G[321]='L5149 E32305'
G[322]='L10 E32305'
G[323]='L5148 E32305'
G[325]='L5149 E31961'
G[328]='L7717 E32305'
G[332]='L1 A:1432 T:1431'	-- when level 55 got this, it is L1974015
G[333]='L1 A:1427 T:1428'
G[334]='L1 A:1428 T:1429'
G[335]='L6430 E31961'
G[337]='FA L5145 E32305'
G[338]='L7720 E31961'
G[339]='L7720 E31961'
G[340]='L7720 E31961'
G[341]='L7720 E31961'
G[342]='L7720 E32305'
G[343]='L10 E31961'
G[344]='L5144 E31961'
G[347]='L5144 E32305'
G[348]='L10285 E31961'
G[351]='L15 A:100008623 T:7784'
G[353]='L1 A:1416 T:1343 O:1097'
G[354]='L1803 E31961'
G[355]='L5 E32305'
G[356]='FH L1547 E31961'
G[357]='L1288 E31961'
G[358]='L1032 E31961'
G[359]='L1545 E31961'
G[361]='FH L1 E32305'
G[362]='L1802 E31961'
G[363]='FH L1 RU E31961'
G[364]='FH L258 E31961'
G[365]='L1031 E31961'
G[366]='L1288 E32305'
G[367]='L6 E31961'
G[368]='FH L1545 E31961'
G[369]='L1547 E32305'
G[370]='L1289 E31961'
G[371]='L1290 E31961'
G[372]='L1292 E31961'
G[373]='FA L4118 E31961'
G[374]='L1287 E31961'
G[375]='L1800 E31961'
G[377]='L5658 E31961'
G[378]='L5659 E31961'
G[380]='L516 E32305'
G[381]='L516 E31961'
G[382]='L517 E32305'
G[383]='L517 E31961'
G[384]='FA L1 A:1267 T:1267'
G[385]='L2574 E31961'
G[386]='L5657 E31961'
G[387]='L5658 E31961'
G[388]='L5658 E31961'
G[389]='L4118 E32305'
G[391]='L4125 E31961'
G[392]='L4125 E32305'
G[398]='L1034 E31961'
G[399]='L2575 E31961'
G[400]='L1 E31961'
G[404]='FH L1030 E31961'
G[405]='L1288 E31961'
G[408]='L1805 E31961'
G[411]='L1292 E32305'
G[412]='FA L1 A:1269 T:1269 P:313+25667'
G[413]='L2058 E31961'
G[414]='L2058 E32305'
G[416]='L2315 E31961'
G[418]='L2058 E31961'
G[419]='L2058 E32305'
G[421]='L2314 E31961'
G[422]='L2315 E31961'
G[423]='L2318 E31961'
G[424]='L2319 E31961'
G[426]='L1544 E31961'
G[427]='L1288 E31961'
G[428]='L2572 E31961'
G[429]='L2571 E31961'
G[430]='L2571 E31961'
G[432]='FA L1 A:1254 T:1254'
G[433]='FA L1 A:1977 T:1977'	-- reports of this being weekly, but Nimhfree cannot reproduce this
G[434]='L4127 E32305'
G[436]='L3346 E31961'
G[437]='L2574 E31961'
G[438]='L2576 E31961'
G[442]='L2580 E32305'
G[443]='L2577 E31961'
G[445]='FH L2314 E31961'
G[447]='L2316 E31961'
G[450]='L2319 E31961'
G[451]='L2322 E32305'
G[453]='L5145 E31961'
G[455]='L4885 E31961'
G[456]='L258 E32305'
G[457]='L259 E32305'
G[458]='L258 E32305'
G[459]='L259 E31961'
G[460]='FH L3089 E32305'
G[463]='L5141 E31961'
G[464]='L5914 E32305'
G[465]='L5914 E32305'
G[466]='L5142 E32305'
G[467]='L5143 E32305'
G[468]='L4885 E32305'
G[469]='L10 E31961'
G[470]='L4888 E32305'
G[471]='L4634 E31961'
G[472]='L25 E32305'
G[474]='L5914 E32305'
G[475]='FA L1 A:2078 T:2107'
G[476]='FA L1 A:2107 T:2078 P:475'
G[477]='L2574 E31961'
G[478]='L2574 E32305'
G[479]='L2576 E31961'
G[480]='L2582 E32305'
G[483]='FA L1 A:2078 T:2078 P:476'
G[484]='L4630 E32305'
G[485]='L10 A:100008704 T:7806'
G[486]='FA L1 A:2078 T:2078 P:483'
G[487]='FA L1 A:2151 T:2151 P:483'
G[488]='FA L1 A:2150 T:2150'
G[489]='FA L1 A:2083 T:2150 P:488'
G[493]='L4884 E31961'
G[495]='L8743 A:2227 T:2278 Z19033'
G[496]='L4886 E31961'
G[498]='L4374 E31961'
G[500]='L7716 E31961'
G[501]='L5400 E31961'
G[502]='L5400 E31961'
G[503]='L7460 E31961'
G[504]='L7720 E31961'
G[505]='L6689 E32305'
G[507]='L7466 E31961'
G[509]='L6172 E31961'
G[512]='L6692 E31961'
G[515]='L6174 E31961'
G[516]='L4117 E31961'
G[517]='L6174 E32305'
G[518]='L8743 E32305'
G[519]='L8745 E31961'
G[520]='L8747 E31961'
G[525]='L7714 E32305'
G[527]='L4888 E31961'
G[528]='L4889 E31961'
G[529]='L4890 E32305'
G[530]='L2580 E31961'
G[532]='L4890 E31961'
G[533]='L7458 E31961'
G[535]='L7458 E32305'
G[536]='L6430 E31961'
G[537]='L7720 E31961'
G[538]='L5158 E31961'
G[539]='L4892 E31961'
G[540]='L5158 E31961'
G[541]='L4894 E31961'
G[542]='L10 E31961'
G[543]='L7 A:2285 T:2285'
G[544]='L7714 E31961'
G[545]='L7715 E31961'
G[546]='L5145 E31961'
G[547]='L6686 E31961'
G[549]='L4374 E31961'
G[550]='L4896 E32305'
G[552]='L7457 E31961'
G[553]='L7457 E31961'
G[554]='L15 E32305'
G[555]='L7199 E32305'
G[556]='L7712 E31961'
G[557]='L7714 E31961'
G[559]='L6432 E32305'
G[562]='L6432 E32305'
G[563]='L6432 E31961'
G[564]='L7714 E31961'
G[565]='L7458 E31961'
G[566]='L4392 E31961'
G[567]='L4380 E31961'
G[568]='L8484 E31961'
G[569]='L8485 E32305'
G[570]='L8486 E31961'
G[572]='L8489 E31961'
G[573]='L8492 E31961'
G[574]='L7718 E32305'
G[575]='L6687 E32305'
G[576]='L9514 E31961'
G[577]='L7972 E32305'
G[578]='FA L8229 E31961'
G[580]='L10290 E31961'
G[581]='L7714 E31961'
G[582]='L7717 E31961'
G[583]='L10 A:716 T:715 O:26340'
G[584]='L7721 E31961'
G[585]='L7720 E32305'
G[586]='L7726 E31961'
G[587]='L9513 E31961'
G[591]='L7726 E31961'
G[594]='L42 E32305'
G[595]='L9513 E31961'
G[596]='L7717 E31961'
G[598]='L7722 E32305'
G[600]='L7721 E31961'
G[602]='FA L8229 E31961'
G[603]='FA L8229 E31961'
G[604]='L9514 E32305'
G[605]='L7715 E31961'
G[606]='L7721 E31961'
G[608]='L9514 E31961'
G[609]='L7724 E31961'
G[611]='FA L8232 E31961'
G[613]='L7724 E32305'
G[614]='L9002 E32305'
G[616]='FA L15 E27843'
G[617]='L9771 E31961'
G[621]='L9004 E31961'
G[623]='FA L9771 E32305'
G[624]='L9003 E31961'
G[627]='L8229 E32305'
G[628]='L7974 E32305'
G[629]='L7717 E31961'
G[630]='L25 E32305'
G[631]='L7199 E31961'
G[633]='L7199 E31961'
G[635]='L7715 E32305'
G[638]='FH L8229 E32305'
G[639]='FH L8229 E31961'
G[640]='FH L8232 E32305'
G[642]='L7717 E31961'
G[643]='FH L15 E32305'
G[644]='FH L15 E32305'
G[648]='L15 A:7784 T:7406 P:351'
G[650]='L10800 E31961'
G[652]='L7722 E31961'
G[654]='L10 E32305'
G[656]='L7730 E32305'
G[658]='L7716 E31961'
G[659]='L7713 E31961'
G[661]='L7717 E32305'
G[666]='L9000 E32305'
G[671]='FH L7713 E31961'
G[672]='FH L7458 E31961'
G[673]='FH L9000 E31961'
G[676]='L7712 E31961'
G[677]='L7712 E31961'
G[678]='L7718 E31961'
G[679]='L7720 E31961'
G[680]='L7720 E31961'
G[681]='L7711 E31961'
G[682]='L7717 E31961'
G[684]='L7463 E31961'
G[685]='L7464 E31961'
G[687]='L7720 E32305'
G[690]='L7712 E32305'
G[691]='L7716 E31961'
G[692]='L15 E31961'
G[693]='L7719 E32305'
G[694]='L7719 E31961'
G[696]='L15 E32305'
G[701]='FH L7461 E31961'
G[703]='L8488 E31961'
G[705]='L7717 E31961'
G[706]='L10285 E32305'
G[707]='L7717 E32305'
G[709]='L7720 E31961'
G[711]='L8999 E31961'
G[713]='L8997 E32305'
G[714]='L8997 E32305'
G[716]='L9002 E32305'
G[718]='L15 E32305'
G[719]='L15 E26365'
G[721]='L35 E32305'
G[729]='L3860 E31961'
G[731]='L3860 E31961'
G[738]='L7718 E32305'
G[741]='L3860 E32305'
G[742]='L20 E32305'
G[743]='FH L1 A:2985 T:2985'
G[744]='FH L1 A:2987 T:2987'
G[745]='L262 E31961'
G[746]='L1 E31961'
G[747]='L258 E32305'
G[748]='FH L1029 RT E31961'
G[749]='FH L1 A:2988 T:1002908 O:24459'
G[750]='L259 E31961'
G[751]='FH L1 A:1002908 T:2988 P:749'
G[752]='L258 E32305'
G[754]='L1030 E31961'
G[756]='FH L1031 RT E32305'
G[757]='L1 E31961'
G[759]='FH L1034 RT E31961'
G[761]='FH L1 A:2947 T:2947'
G[764]='L1 E31961'
G[765]='L1 E31961'
G[766]='L1288 E31961'
G[768]='L1 A:3050 T:3050 P:PS001'
G[769]='L1 A:3050 T:3050 P:PL010'
G[770]='FH L1 A:100004854 T:3052'
G[771]='L775 E31961'
G[772]='L775 E31961'
G[773]='FH L1 A:2984,3233 T:2994 P:20441'
G[775]='L1 E31961'
G[776]='L782 E32305'
G[782]='L10283 E31961'
G[783]='L1 E32305'
G[784]='L775 E31961'
G[786]='L1288 E31961'
G[788]='L258 E31961'
G[789]='L259 E32305'
G[790]='L261 E31961'
G[791]='L1 E31961'
G[792]='L516 E32305'
G[793]='L10290 E32305'
G[794]='L1 E31961'
G[805]='L1 E32305'
G[806]='L1036 E31961'
G[808]='L1033 E31961'
G[809]='L1037 E32305'
G[812]='L1801 E32305'
G[815]='L1544 E31961'
G[816]='L2059 E31961'
G[817]='L1288 E31961'
G[818]='L1287 E31961'
G[819]='FH L2831 E32305'
G[821]='L2831 E31961'
G[822]='L2840 A:3292 T:3292 Z16016'
G[823]='L1031 E31961'
G[824]='L7 A:12737 T:74408 P:1918'
G[825]='L776 E31961'
G[826]='L1034 E31961'
G[827]='L1 E32305'
G[828]='L1036 E32305'
G[830]='FH L1 E32305'
G[831]='L263 E31961'
G[833]='FH L1 A:3233 T:3233'
G[834]='FH L1 A:3293 T:3293'
G[835]='FH L1 A:3293 T:3293'
G[836]='L10 A:7806 T:7406 P:485'
G[837]='L1546 E31961'
G[840]='L5 A:3336 T:3337 P:X28494'
G[841]='L9774 E32305'
G[842]='FH L2572 E31961'
G[843]='L4375 E31961'
G[844]='FH L5 A:3338,34258 T:3338,34258'
G[845]='FH L5 A:3338 T:3338'
G[846]='L4378 E32305'
G[848]='FH L5 A:3390 T:3390'
G[849]='L4378 E32305'
G[850]='FH L5 A:3389,34841 T:3389,34841'
G[851]='FH L5 A:34638 T:34638 P:14072'
G[852]='FH L5 A:3389 T:3389 P:850+851 O:14073'
G[853]='L2575 E32305'
G[854]='FH L5 RT E31961'
G[855]='L5 A:3389 T:3389'
G[857]='L5662 E32305'
G[858]='FH L5 A:3439 T:3439'
G[860]='L7 E31961'
G[861]='L2058 A:3052 T:3052,3441 I:844 Z25549'
G[862]='L3863 E31961'
G[863]='FH K32 L5 A:3439 T:3442 P:858'
G[865]='L5 A:3446 T:3446'
G[866]='L5 A:3446 T:3446 P:PH040'
G[867]='FH L5 A:3449 T:-10,3449 O:29094,28877'
G[868]='L4374 E31961'
G[869]='FH K4 L5 A:-10,3464 T:-100010,3464 P:14066'
G[870]='FH L5 A:3448 T:3448'
G[871]='FH L5 A:3337,3429 T:3337,3429 O:840,26642,28494'
G[872]='FH L5 A:3337,3429 T:3337,3429 P:871'
G[873]='L2587 E31961'
G[874]='L2331 E31961'
G[875]='FH L5 A:3449 T:-10,3449 O:29094,28877'
G[876]='FH L5 A:-10,3449 T:3449 P:875'
G[877]='FH L5 A:3448,34626 T:3448 P:13988'
G[878]='L3605 E31961'
G[879]='L4377 E31961'
G[880]='FH L5 A:3448,34626 T:3448 P:13988'
G[881]='FH L5 A:3338 T:3338 P:845+903'
G[882]='L2579 E31961'
G[884]='FH L2584 E32305'
G[886]='L10 E32305'
G[887]='FH L5 A:3391,3453 T:3391,3453'
G[888]='L2320 E32305'
G[891]='FH L5 A:3339 T:3339'
G[893]='L4376 E31961'
G[894]='L2574 E31961'
G[895]='L5 A:1003972 T:3391'
G[896]='FH L2576 E31961'
G[899]='L5 A:3432 T:3432'
G[903]='FH L5 A:3338 T:3338'
G[905]='FH L5 A:3338 T:3338 P:881'
G[907]='L2578 E32305'
G[910]='FH L2561 E32305'
G[911]='FH L2561 E32305'
G[913]='L2580 E32305'
G[914]='L2582 E31961'
G[916]='L260 E32305'
G[917]='L261 E32305'
G[918]='FA L1 A:2080 T:2080 P:997'
G[919]='FA L1 A:2080 T:2080,502080 P:997'
G[922]='FA L1 A:2080 T:3517 P:918'
G[923]='FA L1 A:3517 T:3517 P:922'
G[924]='L2318 E31961'
G[927]='FA L1 A:100005179 T:2080'
G[928]='L1 E32305'
G[929]='L1 A:3515 T:3515 P:28731'
G[930]='FA L1 A:1006751 T:2080'
G[931]='FA L1 A:1006752 T:2080,502080'
G[932]='FA L1 A:3567 T:3567 P:489'
G[933]='FA L1 A:503515 T:1992 P:7383'
G[935]='FA L1 A:1992 T:503515 P:14005'
G[936]='L12082 E31961'
G[937]='FA L1 A:3519 T:3519 P:E7383'
G[938]='K32 L1 A:3568 T:3519'
G[939]='FA L20 E32305'
G[941]='L1 A:2080 T:1007923 P:927'
G[942]='L10 E32305'
G[943]='L3864 E32305'
G[944]='L3089 E32305'
G[945]='L7 E32305'
G[947]='L3089 E31961'
G[948]='L7 E31961'
G[951]='L3092 E31961'
G[952]='L1547 E31961'
G[953]='L2316 E32305'
G[954]='L1804 E31961'
G[955]='L1804 E31961'
G[956]='L5 E32305'
G[957]='L1805 E32305'
G[958]='L2316 E31961'
G[959]='L3602 E31961'
G[962]='L3602 E31961'
G[963]='L2832 E31961'
G[965]='L10 E31961'
G[966]='L3346 E31961'
G[967]='L3346 E32305'
G[968]='FA L7 E31961'
G[970]='L3349 E31961'
G[971]='FA L4887 E31961'
G[973]='L3352 E32305'
G[976]='L7 E31961'
G[978]='L30 E31961'
G[982]='L3345 E31961'
G[983]='L1802 E31961'
G[984]='L2574 E32305'
G[985]='L2574 E31961'
G[986]='L2580 E31961'
G[990]='L3859 E32305'
G[991]='FA L4885 E32305'
G[992]='L9774 E32305'
G[993]='L2580 E31961'
G[996]='L15 E31961'
G[997]='FA L1 A:2083 T:2080 P:486'
G[998]='L15 E31961'
G[1001]='L1804 E31961'
G[1002]='L1806 E31961'
G[1003]='L1808 E31961'
G[1004]='L30 E32305'
G[1008]='L3603 E32305'
G[1009]='L4886 E32305'
G[1010]='FA L4885 E32305'
G[1011]='L6173 E32305'
G[1012]='FA L4886 E32305'
G[1013]='L4122 E31961'
G[1014]='L4635 E31961'
G[1017]='L5145 E32305'
G[1019]='L30 E32305'
G[1021]='L4885 E32305'
G[1022]='L6430 E32305'
G[1024]='FA L5399 E32305'
G[1025]='L4632 E32305'
G[1026]='FA L5399 E31961'
G[1027]='FA L5399 E32305'
G[1030]='FA L4889 E32305'
G[1031]='L4886 E32305'
G[1034]='L5143 E32305'
G[1035]='L5150 E32305'
G[1036]='L14090 A:2545 T:2546 P:t01535999 I:9272'
G[1037]='L15 E32305'
G[1039]='L15 E32305'
G[1043]='L6430 E32305'
G[1048]='L7722 E31961'
G[1049]='FH L7206 RO RT RL RB E31961'
G[1050]='L7206 E31961'
G[1051]='L6433 E31961'
G[1052]='L8744 E32305'
G[1053]='L8744 E31961'
G[1054]='L4633 E31961'
G[1055]='L10 E32305'
G[1056]='L18 E32305'
G[1057]='L5147 E32305'
G[1058]='L5146 E31961'
G[1059]='L10 E31961'
G[1060]='L3860 E31961'
G[1061]='L3345 E31961'
G[1062]='L3347 E31961'
G[1063]='L3346 E32305'
G[1065]='L3346 E31961'
G[1066]='L3351 E32305'
G[1067]='L3351 E32305'
G[1068]='L3351 E31961'
G[1069]='L3860 E31961'
G[1070]='L4373 E32305'
G[1071]='L10 E32305'
G[1073]='L10 E32305'
G[1076]='L10 E32305'
G[1078]='L4378 E31961'
G[1083]='L5146 E32305'
G[1084]='L5660 E32305'
G[1087]='L5145 E31961'
G[1088]='L5149 E32305'
G[1089]='L5149 E32305'
G[1093]='L4117 E32305'
G[1094]='L4117 E32305'
G[1095]='L4123 E31961'
G[1096]='L4123 E31961'
G[1097]='L1 A:514 T:1416'
G[1098]='L4633 E31961'
G[1102]='L5915 E31961'
G[1104]='L7198 E32305'
G[1105]='L7198 E31961'
G[1106]='L6691 E31961'
G[1107]='L7203 E31961'
G[1108]='L7207 E31961'
G[1109]='L5658 E31961'
G[1110]='L15 E32305'
G[1112]='L7716 E31961'
G[1113]='L15 E32305'
G[1115]='L7716 E31961'
G[1116]='L7716 E31961'
G[1123]='L30 E32305'
G[1124]='L13879 E31961'
G[1130]='L5150 E31961'
G[1131]='L5150 E31961'
G[1132]='L4628 E31961'
G[1133]='L7 E31961'
G[1134]='L4629 E32305'
G[1136]='L6693 E31961'
G[1137]='L7206 E32305'
G[1138]='L3857 E31961'
G[1140]='L3356 E32305'
G[1141]='L2574 E31961'
G[1144]='L15 E31961'
G[1145]='L7457 E32305'
G[1146]='L7457 E31961'
G[1147]='L15 E32305'
G[1150]='L6430 E31961'
G[1151]='L15 E31961'
G[1152]='L15 E31961'
G[1153]='L6429 E31961'
G[1160]='L6436 E31961'
G[1164]='L6948 E31961'
G[1166]='L9513 E32305'
G[1167]='L3356 E32305'
G[1168]='FH L15 A:4502 T:4502'
G[1169]='L9513 E32305'
G[1172]='L9513 E32305'
G[1175]='L7201 E31961'
G[1176]='L15'
G[1177]='L8228 E32305'
G[1178]='L15 E31961'
G[1180]='L7461 E31961'
G[1182]='L7461 E31961'
G[1183]='L7461 E32305'
G[1187]='L7465 E31961'
G[1189]='L15 E31961'
G[1195]='L5145 E31961'
G[1197]='L5149 E32305'
G[1198]='FA L10 E31961'
G[1199]='FA L10 E31961'
G[1200]='FA L4635 E31961'
G[1201]='FH L15 A:4791 T:4791'
G[1202]='FH L15 A:4791 T:4791 P:1201'
G[1204]='L15 A:4794 T:4794'
G[1205]='L15 A:3441 T:3441'
G[1206]='L7715 E32305'
G[1218]='L7715 E31961'
G[1221]='L5146 E31961'
G[1222]='FA L15 A:4880 T:4794'
G[1239]='L15 E32305'
G[1240]='L7715 E32305'
G[1241]='L15 E31961'
G[1243]='L28 E32305'
G[1244]='L7198 E32305'
G[1258]='L15 A:4794 T:4794 P:1204'
G[1261]='L15 E32305'
G[1264]='L15 E31961'
G[1265]='L7203 E31961'
G[1270]='FH L15 A:4880 T:3446'
G[1271]='L15 A:1141 T:1141 P:1222'
G[1273]='L15 E32305'
G[1275]='L4632 E32305'
G[1282]='L15 E31961'
G[1286]='L15 E31961'
G[1302]='L7715 E31961'
G[1322]='L15 E32305'
G[1338]='L5 E31961'
G[1339]='L2319 E31961'
G[1358]='L2575 E31961'
G[1359]='L2575 E32305'
G[1360]='L8491 E31961'
G[1361]='L7712 E31961'
G[1362]='L7712 E32305'
G[1364]='L9513 E32305'
G[1365]='L7715 E32305'
G[1366]='L7711 E31961'
G[1367]='L7713 E32305'
G[1368]='L7713 E32305'
G[1370]='L15 E31961'
G[1373]='L7717 E31961'
G[1380]='L7722 E31961'
G[1382]='L15 E31961'
G[1384]='FA L15 E32305'
G[1385]='L7715 E31961'
G[1387]='L7711 E32305'
G[1392]='L15 E32305'
G[1395]='L10285 E32305'
G[1418]='L15 E31961'
G[1419]='L15 E32305'
G[1420]='L15 E32305'
G[1429]='L9772 E32305'
G[1430]='L9004 E31961'
G[1431]='L30 A:5639 T:5640 Z19033'
G[1432]='L30 A:5640 T:5641 P:1431 Z19033'
G[1433]='FH L15 A:5641 T:4498 Z19033'
G[1434]='L6433 A:5641 T:5641 Z19033'
G[1435]='L15 E31961'
G[1436]='L7713 A:5641 T:5640 Z19033'
G[1437]='L15 E31961'
G[1438]='L15 E32305'
G[1442]='L7 E31961'
G[1445]='L10 E31961'
G[1446]='L9781 E32305'
G[1448]='L10 E32305'
G[1449]='L10 E32305'
G[1452]='L10 E32305'
G[1453]='L10 A:5637 T:5638'
G[1454]='FA L10 A:5638 T:1035251 P:14354 O:1453'
G[1455]='FA L10 A:1035251 T:5638 P:1454'
G[1456]='FA L10 A:5638 T:5638 P:1455'
G[1459]='L15 E31961'
G[1467]='L10 E31961'
G[1468]='HC FA L7866880 A:51988 T:14305'
G[1475]='L10 E32305'
G[1476]='L10 E31961'
G[1477]='L10285 E32305'
G[1481]='L15 E31961'
G[1482]='L15 E32305'
G[1483]='L4117 E31961'
G[1486]='L3345 E31961'
G[1487]='L3861 E32305'
G[1488]='L6440 E32305'
G[1489]='L2576 E31961'
G[1491]='L3346 E31961'
G[1492]='L2315 E31961'
G[1502]='L7 E32305'
G[1503]='L7 E32305'
G[1505]='L7 E32305'
G[1513]='L10 E31961'
G[1514]='L15 E31961'
G[1516]='L4 E32305'
G[1520]='L1 E32305'
G[1524]='L2561 E31961'
G[1525]='L2561 E32305'
G[1558]='FA L2561 E32305'
G[1560]='L15 E31961'
G[1578]='L5 A:6031 T:6030 P:PB030'
G[1580]='L7 E32305'
G[1581]='fA L1 A:2083 T:2083 P:PA020'
G[1582]='L2066 A:6034 T:6034 P:PL070'
G[1598]='L1 E32305'
G[1599]='L1 E32305'
G[1618]='L7 A:6031 T:415 P:PB070'
G[1638]='L2561 E32305'
G[1650]='L5121 E32305'
G[1654]='L5142 E32305'
G[1655]='L5 E31961'
G[1658]='L6401 E31961'
G[1666]='L7 E32305'
G[1667]='L10 E32305'
G[1678]='L7 E32305'
G[1681]='L7 E32305'
G[1687]='FA L2561 E32305'
G[1688]='L7 E32305'
G[1690]='L10283 E32305'
G[1691]='L10284 E31961'
G[1698]='L10 E32305'
G[1701]='L5148 E31961'
G[1702]='L10 E32305'
G[1707]='L10284 E32305'
G[1712]='L15 E31961'
G[1716]='L5121 E31961'
G[1717]='L10 E32305'
G[1718]='L7681 E31961'
G[1740]='L5145 E32305'
G[1791]='L30 E31961'
G[1798]='L15 E31961'
G[1800]='L2561 E32305'
G[1804]='L15 E32305'
G[1823]='L10 E32305'
G[1825]='L10 E32305'
G[1838]='L5150 E32305'
G[1839]='L10 E32305'
G[1858]='FH L7 RO RL E32305'
G[1860]='L7 E32305'
G[1861]='L10 E32305'
G[1879]='L7 E32305'
G[1880]='L10 E32305'
G[1881]='L10 E32305'
G[1882]='L7 E32305'
G[1883]='L10 E32305'
G[1885]='FH L7 RU E31961'
G[1886]='FH L2573 RU E31961'
G[1918]='fH L7 A:100016408 T:12737'
G[1920]='L3856 E32305'
G[1921]='L10 E32305'
G[1938]='L6684 E32305'
G[1940]='L26 E32305'
G[1944]='L15 E31961'
G[1947]='L7718 E31961'
G[1948]='L7720 E31961'
G[1949]='L7718 E31961'
G[1951]='L7720 E31961'
G[1953]='L9000 E31961'
G[1954]='L9000 E32305'
G[1956]='L9000 E31961'
G[1959]='L15 E31961'
G[1960]='L10 E31961'
G[1963]='FH L2573 RO RL E32305'
G[2038]='L2058 E32305'
G[2039]='L5 A:6569 T:6577'
G[2040]='L3860 E31961'
G[2041]='L10 E31961'
G[2098]='L10 E32305'
G[2118]='L2574 E32305'
G[2138]='L2576 E31961'
G[2139]='L2578 E31961'
G[2158]='L1 A:6774 T:295 I:37112 Z18702'
G[2159]='FA L1 A:6780 T:6736'
G[2160]='L1 E32305'
G[2161]='L261 E32305'
G[2178]='L5 E31961'
G[2198]='FA L9513 E31961'
G[2199]='FA L9513 E31961'
G[2200]='FA L9514 E32305'
G[2201]='FA L10 E31961'
G[2202]='FH L9258 E31961'
G[2204]='FA L9516 E32305'
G[2206]='FA L1 E31961'
G[2238]='L7 E32305'
G[2240]='L9000 E31961'
G[2242]='FA L7 E32305'
G[2258]='FH L9255 E32305'
G[2260]='L10 E32305'
G[2278]='L15 A:1131474 T:1131474'
G[2279]='FA L10287 E31961'
G[2280]='L15 A:1131474 TA:46234 TH:3978,46236'
G[2281]='L10 E32305'
G[2283]='L9513 E32305'
G[2284]='L9513 E31961'
G[2342]='L8491 E31961'
G[2359]='L5121 E32305'
G[2360]='L5121 E32305'
G[2381]='FH L10 E32305'
G[2382]='L10 E31961'
G[2383]='FH L515 RO CW A:3143 T:3153 Z18505'
G[2398]='L15 E32305'
G[2399]='SP FA L1 A:1007510 T:1007510 P:931'	-- seems to be timed so the quest givers only remain for a limited time...then can not get quest at all
G[2418]='L7716 E31961'
G[2438]='FA K4 L1 A:3567 T:3567'
G[2458]='L10 E31961'
G[2459]='FA L1 A:3567 T:3567 P:2438'
G[2478]='L10 E32305'
G[2498]='L1033 E32305'
G[2499]='FA L1 A:2080,502080 T:2080 P:923'
G[2518]='FA L1 A:7313 T:7313 P:E7383'
G[2519]='L1290 E32305'
G[2521]='L10 E31961'
G[2522]='L10 E32305'
G[2523]='L15 E31961'
G[2541]='FA L1 A:7317 T:7317'
G[2561]='FA L1 A:7317 T:7317 P:2541'
G[2581]='L10 E31961'
G[2582]='L10 E32305'
G[2583]='L11570 E31961'
G[2585]='L10 E31961'
G[2601]='L11570 E31961'
G[2603]='L11570 E31961'
G[2605]='L11313 E31961'
G[2609]='L20 E32305'
G[2623]='L10 E31961'
G[2641]='L11313 E31961'
G[2681]='L11577 E32305'
G[2721]='L10 E32305'
G[2745]='L4127 E31961'
G[2746]='L10 E31961'
G[2751]='L15 A:7790 T:7790 P:PB140'
G[2752]='L15 A:7790 T:7790 P:2751+PB140'
G[2753]='L15 A:7790 T:7790 P:2752+PB140'
G[2754]='L15 A:7790 T:7790 P:2753+PB140'
G[2755]='L15 A:7790 T:7790 P:2754+PB140'
G[2766]='L10285 E32305'
G[2767]='L10285 E32305'
G[2768]='L10287 E31961'
G[2769]='L15 E31961'
G[2770]='L10290 E31961'
G[2781]='L9774 E31961'
G[2782]='L25 E31961'
G[2783]='FA L25 E32305'
G[2821]='L15 E32305'
G[2822]='L10286 E31961'
G[2841]='L6435 E31961'
G[2842]='L5155 E31961'
G[2844]='L10 E32305'
G[2846]='L10286 E31961'
G[2854]='L15 E32305'
G[2856]='L7725 E32305'
G[2861]='L10286 E31961'
G[2862]='L10026 E32305'
G[2864]='L10285 E31961'
G[2865]='L10285 E31961'
G[2870]='L15 E32305'
G[2872]='L10285 E31961'
G[2873]='L10285 E31961'
G[2874]='L10285 E32305'
G[2875]='L9773 E31961'
G[2877]='L15 E31961'
G[2878]='L15 E31961'
G[2879]='L25 E31961'
G[2880]='L15 E32305'
G[2882]='L10285 E32305'
G[2904]='L5150 E31961'
G[2922]='L5146 E31961'
G[2923]='L5146 E31961'
G[2924]='L6174 E31961'
G[2925]='L10 E32305'
G[2926]='L5147 E31961'
G[2927]='L5147 E31961'
G[2928]='L5150 E31961'
G[2929]='L6435 E31961'
G[2930]='L6430 E31961'
G[2931]='L15 E32305'
G[2932]='L9002 E31961'
G[2933]='L10283 E32305'
G[2936]='L15 E31961'
G[2939]='L25 E32305'
G[2941]='L25 E32305'
G[2944]='L10800 E32305'
G[2945]='L10 A:100009326 T:1142487'
G[2947]='FA L10 A:1142487 T:6826 P:2945'
G[2948]='L10 A:6826 T:6826 P:2947'
G[2949]='FH L10 A:1142487 T:3412 P:2945'
G[2950]='L10 A:3412 T:3412 P:2949'
G[2951]='L10 A:1142487 T:1142487 I:4601,4602'
G[2952]='L10 A:1142487 T:1142487 P:2951,4601,4602 I:4605,4606'
G[2953]='K1 L10 A:1142487 T:1142487 P:2952,4605,4606 I:4603,4604'
G[2962]='L5150 E31961'
G[2973]='L9773 E32305'
G[2974]='L9773 E31961'
G[2975]='L9771 E32305'
G[2976]='L10 E31961'
G[2977]='L10 E32305'
G[2980]='L10 E31961'
G[2981]='L9771 E31961'
G[2982]='L15 E32305'
G[2987]='L9771 E32305'
G[2988]='L10285 E32305'
G[2989]='L15 E31961'
G[2990]='L15 E32305'
G[2991]='L15 E32305'
G[2995]='L25 E32305'
G[2996]='L15 E31961'
G[3022]='FA L10799 E32305'
G[3042]='L10285 E31961'
G[3062]='L11570 E31961'
G[3063]='L11570 E31961'
G[3064]='L15 E31961'
G[3087]='FH L5 RO CH A:3143 T:39214 Z18505'
G[3088]='FH L5 RO CR A:3143 T:3155 Z18505'
G[3089]='FH L5 RO CS A:3143 T:3157 Z18505'
G[3090]='FH L5 RO CL A:3143 T:3156 Z18505'
G[3091]='FH L515 RT CW A:44927 T:3059 Z18505'
G[3092]='FH L5 RT CH A:44927 T:3061 Z18505'
G[3093]='FH L515 RT CS A:44927 T:3062 Z18505'
G[3094]='FH L5 RT CD A:44927 T:3060 Z18505'
G[3095]='FH L5 RU CW A:1569 T:2119 P:26801 Z18505'
G[3096]='FH L515 RU CR A:1569 T:2122 P:26801 Z18505'
G[3097]='FH L5 RU CT A:1569 T:2123 P:26801 Z18505'
G[3098]='FH L5 RU CM A:1569 T:2124 P:26801 Z18505'
G[3099]='FH L5 RU CL A:1569 T:2126 P:26801 Z18505'
G[3100]='FA L515 RH CW A:197 T:911 P:28774 Z18505'
G[3101]='FA L515 RH CP A:197 T:925 P:28770 Z18505'
G[3102]='FA L5 RH CR A:197 T:915 P:28772 Z18505'
G[3103]='FA L5 RH CT A:197 T:375 P:28771 Z18505'
G[3104]='FA L515 RH CM A:197 T:198 P:28769 Z18505'
G[3105]='FA L5 RH CL A:197 T:459 P:28773 Z18505'
G[3106]='FA L5 RF CW A:37087 T:912 Z18505'
G[3107]='FA L5 RF CP A:37087 T:926 Z18505'
G[3108]='FA L5 RF CH A:658,37087 T:895 Z18505'
G[3109]='FA L5 RF CR A:37087 T:916 P:24473 Z18505'
G[3110]='FA L5 RF CT A:37087 T:837 Z18505'
G[3114]='FA L1 RN E32305'
G[3115]='FA L5 RF RN CL A:658,37087 T:43455 Z18505'
G[3116]='FA L5 RE CW A:2077,502079 T:3593 P:28714+28715 Z22248'
G[3117]='FA L5 RE CH A:2077,502079 T:3596 P:28714+28715 Z22248'
G[3118]='FA L5 RE CR A:2077,502079 T:3594 P:28714+28715 Z22248'
G[3119]='FA L5 RE CT A:2077,502079 T:3595 P:28714+28715 Z22248'
G[3120]='FA L515 RE CD A:2077,502079 T:3597 P:28714+28715 Z22248'
G[3123]='L8998 E31961'
G[3128]='L15 E32305'
G[3161]='L11056 E31961'
G[3261]='L2578 E32305'
G[3281]='L2322 E31961'
G[3301]='L2575 E31961'
G[3341]='L8485 E31961'
G[3361]='L1 A:8416 T:8416 P:24487'
G[3362]='L11570 E31961'
G[3363]='L15 E31961'
G[3365]='L1 E32305'
G[3369]='FH L2585 E31961'
G[3371]='L10286 E32305'
G[3373]='L20 E32305'
G[3374]='L20 E32305'
G[3380]='L11827 E31961'
G[3441]='L15 E32305'
G[3442]='L15 E32305'
G[3443]='L15 E32305'
G[3444]='L15 E32305'
G[3445]='L11827 E31961'
G[3446]='L11827 E32305'
G[3447]='L11827 E32305'
G[3448]='L10 E32305'
G[3449]='L11572 E32305'
G[3452]='L15 E32305'
G[3501]='L10 E32305'
G[3502]='L10 E31961'
G[3504]='L11317 E31961'
G[3505]='L10 E32305'
G[3510]='L10 E31961'
G[3512]='L20 E32305'
G[3513]='L3865 E32305'
G[3514]='L3869 E32305'
G[3517]='L11572 E32305'
G[3518]='L10 E32305'
G[3519]='L5 E32305'
G[3520]='L10284 E31961'
G[3521]='L516 E31961'
G[3522]='L5 E32305'
G[3523]='L15 E31961'
G[3524]='L2829 E32305'
G[3525]='L8229 E31961'
G[3526]='FH L7 A:4586 T:8126 P:PN200'
G[3527]='L10287 E31961'
G[3541]='FH L11572 A:8587 T:8659 Z17644'
G[3542]='L11572 E32305'
G[3561]='L10 A:8587 T:8379 Z17644'
G[3563]='L10 A:8659 T:8587 Z17644'
G[3564]='L10 E32305'
G[3565]='FH L10 A:8379 T:8587 Z17644'
G[3566]='L15 E31961'
G[3568]='L10 E32305'
G[3601]='L15 E32305'
G[3626]='L10 E31961'
G[3627]='L10 E32305'
G[3629]='L7 E32305'
G[3630]='L2561 E31961'
G[3632]='L7 E32305'
G[3633]='L7 E31961'
G[3636]='L8229 E32305'
G[3639]='L7 E32305'
G[3641]='L7 E31961'
G[3661]='L10799 E32305'
G[3701]='L25 E32305'
G[3702]='L25 E32305'
G[3721]='L10 A:7406 T:7406 P:648+836+25476'
G[3741]='L7 E32305'
G[3761]='L12082 E32305'
G[3764]='L12082 E31961'
G[3765]='L10 E32305'
G[3783]='L13368 E31961'
G[3785]='L12082 E32305'
G[3786]='L15 E32305'
G[3787]='L15 E32305'
G[3789]='L15 E31961'
G[3801]='L12340 E31961'
G[3802]='L12340 E31961'
G[3821]='L20 E32305'
G[3823]='L20 E32305'
G[3824]='L12341 E31961'
G[3825]='L20 E32305'
G[3845]='L12084 E32305'
G[3861]='K1 L1 A:620 T:620'
G[3881]='L12341 E31961'
G[3882]='L12595 E32305'
G[3883]='L12340 E31961'
G[3884]='L20 E31961'
G[3902]='FH L515 E31961'
G[3903]='L5 E32305'
G[3906]='L20 E32305'
G[3908]='L12084 E32305'
G[3921]='FH L2574 E31961'
G[3922]='L2575 E31961'
G[3924]='L2579 E32305'
G[3981]='L12340 E31961'
G[4003]='L20 E31961'
G[4005]='L15 E32305'
G[4021]='FH K512 L5 A:3389 T:3389 P:852+855'	-- PM3 (recommended party members)
G[4022]='L30 E32305'
G[4024]='L13370 E32305'
G[4061]='L30 E32305'
G[4063]='L30 E32305'
G[4081]='L20 E32305'
G[4082]='L20 E31961'
G[4083]='SP L20 A:1164869 T:1164869 P:PM230'
G[4084]='L15 E32305'
G[4101]='FA L12343 E32305'
G[4102]='FH L20 E32305'
G[4103]='FA L15 E31961'
G[4113]='L15 E31961'
G[4114]='L15 E31961'
G[4115]='L15 E31961'
G[4116]='L15 E31961'
G[4117]='L15 E31961'
G[4118]='L15 E31961'
G[4119]='L15 E31961'
G[4120]='L12084 E32305'
G[4123]='L12855 E31961'
G[4125]='L10283 E32305'
G[4126]='L25 E32305'
G[4128]='L12855 E31961'
G[4131]='L10284 E32305'
G[4132]='L30 E32305'
G[4133]='L25 E32305'
G[4135]='L10286 E32305'
G[4136]='L12341 E32305'
G[4141]='L12084 E31961'
G[4142]='L12084 E32305'
G[4143]='L15 E32305'
G[4145]='L15 E32305'
G[4161]='L262 E32305'
G[4181]='L2561 E32305'
G[4182]='L12342 E32305'
G[4185]='L20 E32305'
G[4186]='L20 E32305'
G[4201]='L12854 E32305'
G[4221]='L15 E31961'
G[4222]='L15 E31961'
G[4241]='L20 E32305'
G[4242]='L20 E31961'
G[4243]='L20 E31961'
G[4244]='L12341 E32305'
G[4261]='L20 E32305'
G[4262]='L12340 E31961'
G[4263]='L12344 E31961'
G[4266]='L15 E32305'
G[4281]='L10284 E32305'
G[4282]='L25 E31961'
G[4283]='L12856 E31961'
G[4284]='L15 E31961'
G[4285]='L15 E32305'
G[4286]='L12856 E31961'
G[4287]='L15 E32305'
G[4288]='L15 E32305'
G[4289]='L15 E32305'
G[4290]='L12341 E32305'
G[4291]='L20 E32305'
G[4293]='L20 E32305'
G[4294]='L20 E32305'
G[4295]='SP K1 L20 A:9503 T:9503'
G[4296]='L25 E32305'
G[4300]='L12340 E32305'
G[4324]='L12341 E32305'
G[4343]='L15 E31961'
G[4362]='L25 E31961'
G[4401]='L15 E31961'
G[4402]='L1 E32305'
G[4403]='L15 E31961'
G[4421]='FA L20 E32305'
G[4441]='FA L12598 E32305'
G[4443]='L15 E31961'
G[4444]='L15 E31961'
G[4445]='L15 E31961'
G[4446]='L15 E31961'
G[4447]='L15 E31961'
G[4448]='L15 E31961'
G[4449]='L25 E32305'
G[4451]='L25 E32305'
G[4461]='L15 E31961'
G[4462]='L15 E31961'
G[4463]='L15 E31961'
G[4464]='L15 E31961'
G[4465]='L15 E31961'
G[4466]='L15 E31961'
G[4467]='L15 E31961'
G[4481]='L15 E31961'
G[4482]='L15 E31961'
G[4483]='L15 E31961'
G[4484]='L15 E31961'
G[4492]='L25 E32305'
G[4493]='L12853 E31961'
G[4494]='L12853 E32305'
G[4495]='L260 E32305'
G[4501]='L12087 E32305'
G[4502]='L12599 E32305'
G[4503]='L12595 E32305'
G[4504]='L12342 E31961'
G[4512]='fA L15 A:9616 T:9616'
G[4513]='L15 A:9616 T:9616 P:4512'
G[4521]='L30 E32305'
G[4542]='L5913 E32305'
G[4581]='L6173 E32305'
G[4601]='L10 A:1175084 T:1175084 I:2951,4602'
G[4602]='L10 A:1175085 T:1175085 I:2951,4601'
G[4603]='K1 L10 A:1175084 T:1175084 P:2952,4605,4606 I:2953,4604'
G[4604]='K1 L10 A:1175085 T:1175085 P:2952,4605,4606 I:2953,4603'
G[4605]='L10 A:1175084 T:1175084 P:2951,4601,4602 I:2952,4606'
G[4606]='L10 A:1175085 T:1175085 P:2951,4601,4602 I:2952,4605'
G[4621]='L10 A:2546 T:2546 P:t01535999 O:1036'
G[4681]='L7 E31961'
G[4701]='L14139 E32305'
G[4722]='L7 E32305'
G[4723]='L7 E32305'
G[4726]='L25 E32305'
G[4727]='L7 E32305'
G[4728]='L7 E32305'
G[4729]='L30 E32305'
G[4738]='L15 E31961'
G[4740]='L2322 E31961'
G[4742]='L14652 E31961'
G[4762]='L7 E31961'
G[4763]='L3858 E31961'
G[4764]='L14652 E32305'
G[4766]='L10 E32305'
G[4767]='L6429 E31961'
G[4769]='L10 E32305'
G[4787]='L15 E32305'
G[4808]='L12854 E32305'
G[4809]='L25 E32305'
G[4811]='L3086 E32305'
G[4812]='L3086 E32305'
G[4821]='L6170 E31961'
G[4841]='L5913 E31961'
G[4861]='L30 E32305'
G[4862]='L30 E32305'
G[4865]='L10 E31961'
G[4866]='L14140 E31961'
G[4867]='L14140 E32305'
G[4903]='L30 E31961'
G[4904]='L6429 E32305'
G[4906]='FA L12598 E32305'
G[4907]='L10 E31961'
G[4921]='L3604 E31961'
G[4968]='L15 E31961'
G[4970]='L14908 E32305'
G[4971]='L13624 E32305'
G[4973]='L13624 E32305'
G[4976]='L9000 E32305'
G[4981]='L30 E31961'
G[4982]='L14139 E32305'
G[5022]='FA L12852 E32305'
G[5041]='FH L5 A:3429,34258 T:3429,34258 P:871'
G[5047]='L14652 E32305'
G[5054]='L30 E32305'
G[5055]='L30 E32305'
G[5062]='L6171 E32305'
G[5064]='L10 E31961'
G[5066]='L50 E31961'
G[5081]='L14140 E32305'
G[5082]='L13368 E32305'
G[5084]='L13368 E32305'
G[5086]='L30 E32305'
G[5088]='L6172 E31961'
G[5097]='L12856 E32305'
G[5102]='L14140 E32305'
G[5124]='L30 E31961'
G[5141]='L15 E32305'
G[5142]='L12855 E32305'
G[5147]='FH L5149 E31961'
G[5151]='L6174 E32305'
G[5152]='L25 E32305'
G[5156]='L20 E32305'
G[5157]='L20 E32305'
G[5158]='L12340 E32305'
G[5160]='L10 E32305'
G[5165]='L12343 E32305'
G[5166]='L14652 E31961'
G[5168]='L12856 E32305'
G[5181]='L25 E32305'
G[5201]='L15 E31961'
G[5211]='L12855 E32305'
G[5212]='L14140 E31961'
G[5213]='L14140 E31961'
G[5214]='L14140 E31961'
G[5216]='L12853 E32305'
G[5219]='L25 E32305'
G[5222]='L25 E32305'
G[5225]='L12858 E32305'
G[5235]='L25 E32305'
G[5243]='L14140 E31961'
G[5245]='L20 E32305'
G[5246]='L30 E31961'
G[5249]='FA L13624 E32305'
G[5250]='L30 E31961'
G[5251]='L14140 E31961'
G[5261]='L1 E32305'
G[5263]='L30 E31961'
G[5281]='L14140 E31961'
G[5282]='L14140 E31961'
G[5284]='L15 E31961'
G[5341]='L13372 E31961'
G[5342]='L13372 E32305'
G[5343]='L13372 E31961'
G[5344]='L13372 E32305'
G[5361]='L15 E31961'
G[5381]='L15 E31961'
G[5382]='L14140 E31961'
G[5384]='L14140 E32305'
G[5386]='L8229 E31961'
G[5421]='FH K1 L10 A:11317 T:11317'
G[5461]='L10 E32305'
G[5481]='L5 E31961'
G[5482]='L1286 E31961'
G[5501]='L10 A:11438 T:11438'
G[5502]='HC FH L7866880 A:14444 T:51989 P:29190+29191'
G[5507]='L30 E32305'
G[5514]='L30 E31961'
G[5515]='L14140 E31961'
G[5526]='L30 E32305'
G[5527]='L30 E31961'
G[5529]='L14138 E31961'
G[5535]='L10 E31961'
G[5536]='L11567 E31961'
G[5538]='L14137 E32305'
G[5541]='L1 E31961'
G[5542]='L13368 E32305'
G[5543]='L13368 E32305'
G[5544]='L13368 E32305'
G[5545]='FA L1 A:10616 T:10616'
G[5561]='L10 A:11596 T:11596'
G[5581]='FH L10 A:5395 T:5395,11624'
G[5601]='L12855 E31961'
G[5623]='FA L5 RH E32305'
G[5650]='FH L1284 RU E31961'
G[5651]='FH L5 RU E31961'
G[5662]='FH L7 RU E32305'
G[5713]='L5 A:11711 T:11806'
G[5721]='L14140 E31961'
G[5722]='L2320 E32305'
G[5723]='L2319 E31961'
G[5724]='L2320 E31961'
G[5725]='L2320 E31961'
G[5726]='L2316 E31961'
G[5728]='L2320 E31961'
G[5741]='L10 E31961'
G[5761]='L2320 E31961'
G[5762]='L7199 E31961'
G[5763]='L15 E31961'
G[5802]='L30 E32305'
G[5805]='L1 E31961'
G[5821]='L10 A:11625 T:11596 Z16135'	-- once caravan moves quest cannot be obtained.  how to detect this?
G[5841]='L1 E31961'
G[5842]='L1 E31961'
G[5843]='L1 E31961'
G[5844]='L1 E31961'
G[5847]='L1 E31961'
G[5848]='L13372 E31961'
G[5862]='L30 E32305'
G[5863]='L11313 E31961'
G[5881]='L5916 E31961'
G[5882]='L15 E31961'
G[5885]='L15 E31961'
G[5886]='L15 E31961'
G[5892]='L1 A:12096 T:12096'
G[5893]='L1 A:12097 T:12097'
G[5902]='L20 E31961'
G[5903]='L12343 E32305'
G[5904]='L20 E32305'
G[5943]='L10 A:11626 T:11596 Z16135'	-- once caravan moves quest cannot be obtained.  how to detect this?
G[5961]='L30 E32305'
G[6001]='FA L7 RE E31961'
G[6021]='L12855 E32305'
G[6024]='L13884 E32305'
G[6026]='L13882 E32305'
G[6027]='L10 E31961'
G[6029]='FH L12852 E32305'
G[6030]='L12852 E32305'
G[6031]='L15 A:11557 T:11557 P:T24044999'	-- TODO: Determine whether this is no longer available when reached Honored with Timbermaw Hold.  No, at Honored it is still available.
G[6032]='L15 A:11557 T:11557 P:T24044999+PT280'
G[6103]='FA L2567 RE E31961'
G[6122]='FA L10 RE E32305'
G[6123]='FA L10 RE E31961'
G[6129]='FH L3585 RT E32305'
G[6132]='K32 L10 A:12277 T:6019'
G[6133]='L30 E32305'
G[6134]='L10 A:6019 T:6019'
G[6141]='L8743 E31961'
G[6142]='L10 A:12031 T:12031 Z19342'
G[6143]='L10 A:12340 T:12340 Z19342'
G[6161]='L7716 E32305'
G[6162]='L15 E32305'
G[6163]='L30 E31961'
G[6164]='L25 E32305'
G[6181]='FA L7 RH E32305'
G[6182]='L14396 E31961'
G[6184]='L14396 E32305'
G[6185]='L14396 E32305'
G[6187]='L14396 E31961'
G[6261]='L7 E32305'
G[6281]='L10 E32305'
G[6282]='L4634 E31961'
G[6283]='L4634 E31961'
G[6284]='FH L3093 E31961'
G[6301]='L4375 E31961'
G[6321]='FH L1 RU A:1745 T:43124'
G[6322]='L1 A:4556 T:4551 P:6323'
G[6323]='L1 A:43124 T:4556 P:6321'
G[6324]='L1 A:4551 T:1745 P:6322'
G[6341]='FA L1 RE A:40553 T:7316 P:6344'
G[6342]='L1 A:7316 T:40552 P:6341'
G[6343]='L1 A:40552 T:4265 P:6342'
G[6344]='FA L1 RE A:4265 T:40553'
G[6361]='FH L1 RT A:3079 T:40809'
G[6362]='L1 A:40809 T:8359 P:6361'
G[6363]='L1 A:8359 T:2995 P:6362'
G[6364]='L1 A:2995 T:3079 P:6363'
G[6365]='FH L1 RO RL A:3489,3881 T:3615,41140'
G[6381]='L4377 E31961'
G[6382]='L20 E32305'
G[6384]='L1 A:3615,41140 T:6929 P:6365'
G[6385]='L1 A:6929 T:3310 P:6384'
G[6386]='L1 A:3310 T:3881 P:6385'
G[6387]='FA L1 RF RN A:1699 T:43701'
G[6388]='L1 A:4256 T:1573 P:6391'
G[6391]='L1 A:1699 T:43701 P:6387'
G[6392]='L1 A:1573 T:1699 P:6388'
G[6393]='L4889 E31961'
G[6394]='L5 E31961'
G[6395]='FH L773 E31961'
G[6401]='L3090 E31961'
G[6421]='L3602 E32305'
G[6441]='FH L7 A:12724 T:12724 P:26449'
G[6442]='FH L7 A:12719 T:12719'	-- Can this still be gotten in 4.3.3?
G[6461]='L10 E32305'
G[6462]='L7 A:12721 T:12721'
G[6481]='L3604 E32305'
G[6482]='L7 A:12818 T:12837'
G[6502]='L12860 E31961'
G[6503]='L7 A:12867 T:12867'
G[6504]='L5918 E31961'
G[6521]='L7204 E31961'
G[6522]='L15 E32305'
G[6541]='L4371 E32305'
G[6542]='L4371 E32305'
G[6543]='L4371 E31961'
G[6544]='K32 L7 A:12858 T:12877'
G[6548]='L3090 E31961'
G[6561]='FH L4635 E31961'
G[6562]='L4886 E32305'
G[6563]='L10 A:12736 T:12736 Z18545'	-- How does this relate to 26890 because it seems this should be removed in 4.3.3?
G[6564]='L4374 E31961'
G[6565]='L4378 E31961'
G[6569]='L30 E32305'
G[6571]='L5659 E31961'
G[6604]='FA L30 E32305'
G[6607]='SP L15 A:12919 T:12919 P:PF225 O:6608,6609'
G[6608]='L8975 A:3332 T:12919 P:PF225'
G[6609]='L15 A:5161 T:12919 P:PF225 Z15640'	-- A:5161, but no longer in game (except if you already have it)
G[6610]='L15 A:40589 T:40589 P:PC225 O:6611 I:13825'
G[6611]='L15 A:3399 T:40589 P:PC225'
G[6612]='L15 A:5159 T:40589 P:PC225 Z17688'
G[6621]='L7 A:12696,12757 T:12696,12757 P:13967'
G[6622]='L10 A:12920 T:12920 P:PZ225 O:6623'
G[6623]='L10 XK A:45540 T:12920 P:PZ225'	-- assumption Z18291 is wrong based on comment in quest 6625
G[6624]='L15 A:12939 T:12939 P:PZ225 O:6625'
G[6625]='fA L15 XK A:5150 T:12939 P:PZ225'	-- Z18291 was wrong based on seeing quest on 2014-11-04
G[6626]='L7203 E31961'
G[6629]='L3090 E31961'
G[6641]='FH K512 L7 A:12717 T:12863'	-- PM2 (recommended party members)
G[6642]='K1 L30 A:12944 T:12944'
G[6643]='K1 L30 A:12944 T:12944'
G[6644]='K1 L30 A:12944 T:12944'
G[6645]='K1 L30 A:12944 T:12944'
G[6646]='K1 L30 A:12944 T:12944'
G[6661]='L1 A:12997 T:12997'
G[6662]='L1 A:12997 T:13018 P:6661'
G[6681]='L24 E31961'
G[6741]='K1 L1 A:13176 T:13176'
G[6761]='L30 E32305'
G[6762]='L30 E31961'
G[6781]='K1 L1 A:13257 T:13257'
G[6801]='K1 L1 A:13236 T:13236'
G[6821]='L30 E31961'
G[6822]='L30 E31961'
G[6824]='L14140 E32305'
G[6825]='K1 L1 A:13179 T:13179'
G[6826]='K1 L1 A:13180 T:13180'
G[6827]='K1 L1 A:13181 T:13181'
G[6847]='FH L10 E31961'
G[6848]='FA L1 E31961'
G[6861]='FH L1 E31961'
G[6862]='FA L1 E31961'
G[6881]='K1 L1 A:13442 T:13442'
G[6921]='L5403 E31961'
G[6922]='FH L10 A:100016782 T:12736 Z18545'
G[6941]='fA K1 L1 A:13439 T:13439'
G[6942]='K1 L1 A:13438 T:13438'
G[6943]='K1 L1 A:13437 T:13437'
G[6961]='HV FH L7866880 A:13418 T:13445 I:7021'
G[6962]='HV FH L7866880 A:13445 T:13445 O:6961,7021'
G[6963]='HV FH L7681 A:13418 T:13636 Z19243'
G[6964]='HV L7866880 A:9550 T:13417'
G[6981]='L3866 E31961'
G[6982]='L1 A:12096 T:12096'
G[6983]='HV FH K2 L7879680 A:13636 T:13418'	--  P:6963 appear incorrect
G[6984]='HV L7872000 A:13418 T:13445 P:6983'
G[6985]='K1 L1 A:12097 T:12097'
G[7001]='K1 L10 A:13616 T:13616'
G[7002]='L1'
G[7003]='L11568 E32305'
G[7021]='HV FH L7866880 A:13431 T:13445 I:6961'
G[7022]='HV FA L7866880 A:13433 T:13444 I:7023'
G[7023]='HV FA L7866880 A:13435,23010,96304 T:13444 I:7022'
G[7024]='HV FH L7866880 A:13429 T:13445'
G[7025]='HV FA L7866880 A:13444 T:13444'	-- note that the Alliance version does not have O codes.
G[7026]='L1 T:703979'
G[7027]='K1 L1 A:13617 T:13617'
G[7028]='L10543 E32305'
G[7041]='L20 E32305'
G[7042]='FA L7681 E31961'
G[7043]='HV FA K2 L7879680 A:13433,13636 T:13433'	-- P:7042 appears incorrect
G[7044]='L10545 E31961'
G[7045]='HV L7872000 A:13433 T:13444 P:7043'
G[7061]='HV L7866880 A:13417 T:36648 P:6964'
G[7062]='HV L7866880 A:1365 T:2916'
G[7063]='HV L7866880 A:2916 T:42928 P:7062'
G[7064]='FH L11571 E31961'
G[7065]='FA L11571 E31961'
G[7066]='L10035 E31961'
G[7067]='L10032 E32305'
G[7068]='L10026 E31961'
G[7070]='L15 E32305'
G[7081]='FA L1 A:13777 T:13777'
G[7082]='FH L1 A:13776 T:13776'
G[7101]='FH L1 A:13776 T:13776'
G[7102]='FA L1 A:13777 T:13777'
G[7121]='FA L1 A:13797 T:12096'
G[7122]='FA L1 A:13777 T:13777'
G[7123]='FH L1 A:13798 T:12097'
G[7124]='FH L1 A:12097,13776 T:13776'
G[7141]='FA L1 A:13816 T:13816'
G[7142]='FH L1 A:13817 T:13817'
G[7161]='FH L1 A:13840 T:13840'
G[7162]='FA L1 A:13841 T:13841'
G[7163]='FH L1 A:13840 T:13840 P:7161+T2D944999'
G[7164]='FH L1 A:13840 T:13840 P:7163+T2D950999'
G[7165]='FH L1 A:13840 T:13840 P:7164+T2D962999'
G[7166]='SP FH L1 A:13840 T:13840 P:7165+T2D983999'
G[7167]='SP FH L1 A:13840 T:13840 P:7166+T2D984998'
G[7168]='FA L1 A:13841 T:13841 P:7162+T2DA44999'
G[7169]='FA L1 A:13841 T:13841 P:7168+T2DA50999'
G[7170]='FA L1 A:13841 T:13841 P:7169+T2DA62999'
G[7171]='SP FA L1 A:13841 T:13841 P:7170+T2DA83999'
G[7172]='SP FA L1 A:13841 T:13841 P:7171+T2DA84998'
G[7181]='FH L10 E31961'
G[7201]='L20 E32305'
G[7202]='FA L1 E31961'
G[7223]='L1 A:13257 T:13257'
G[7224]='L1 A:13176 T:13176'
G[7241]='L13057 E31961'
G[7261]='L13057 E32305'
G[7281]='FH L1 E31961'
G[7282]='FA L1 E31961'
G[7301]='FA L1 E31961'
G[7302]='FH L1 E31961'
G[7321]='L7199 E31961'
G[7361]='FH L10 E32305'
G[7362]='FH L51260 E32305'
G[7364]='FA L51260 E32305'
G[7365]='FA L51260 E32305'
G[7367]='FA L1 E31961'
G[7368]='FH L1 E31961'
G[7381]='FH L10 E31961'
G[7382]='FA L1 E31961'
G[7383]='FA L1 A:3515 T:503515 P:918+919'
G[7385]='K1 L1 A:13236 T:13236'
G[7386]='K1 L1 A:13442 T:13442'
G[7402]='FA L10 E32305'
G[7441]='L30 E32305'
G[7461]='L14396 E32305'
G[7481]='L30 E31961'
G[7482]='L30 E31961'
G[7488]='L30 E31961'
G[7489]='L30 E31961'
G[7490]='L30 E31961'
G[7491]='L30 E31961'
G[7492]='L13881 E32305'
G[7493]='L30 A:14392 T:14392 P:24429+PL001'
G[7494]='L13881 E31961'
G[7495]='L30 E31961'
G[7496]='FA L30 E31961'
G[7497]='L30 A:14394 T:14394 P:24428+PL001'
G[7498]='L30 CR A:100018356 T:14383 Z13329'
G[7499]='L13884 CW A:100018357 T:14383 Z13329'
G[7500]='L13884 CM A:100018358 T:14383 Z13329'
G[7501]='L13884 CP A:100018359 T:14382 Z13329'
G[7502]='L13884 CL A:100018360 T:14382 Z13329'
G[7503]='L30 CH A:100018361 T:14382 Z13329'
G[7504]='L13884 CT A:100018362 T:14381 Z13329'
G[7505]='L30 CS A:100018363 Z13329'
G[7506]='L13884 CD A:100018364 T:14381 Z13329'
G[7581]='L20 E31961'
G[7582]='L20 E32305'
G[7602]='L12801 E32305'
G[7604]='L20 A:100018628 T:12944 P:K100017203'
G[7626]='L20 E32305'
G[7629]='L20 E32305'
G[7636]='L20 E32305'
G[7637]='L20'
G[7643]='L20 E32305'
G[7649]='L35 A:100018769 T:14368 Z13329'
G[7650]='L35 A:100018770 T:14368 Z13329'
G[7651]='L35 A:100018771 T:14368 Z13329'
G[7667]='L15 E31961'
G[7701]='L11570 E32305'
G[7702]='L7729 E32305'
G[7703]='L14366 E32305'
G[7721]='L11568 E32305'
G[7722]='L11570 E32305'
G[7723]='L10 E32305'
G[7724]='L11569 E32305'
G[7725]='L11575 E32305'
G[7726]='L11575 E32305'
G[7727]='L11569 E32305'
G[7728]='L11568 E32305'
G[7729]='L10 E32305'
G[7730]='L15 E31961'
G[7731]='L15 E31961'
G[7732]='L15 E32305'
G[7733]='L15 E32305'
G[7734]='L10288 E31961'
G[7737]='K1 L15 A:14624 T:14624 P:28064+t03B83999'
G[7761]='L20 A:100018987 T:1179880 Z20338'
G[7781]='fA L30 A:100019003 T:29611'
G[7782]='FA L30 A:29611 T:14721 P:7781'
G[7783]='L30 A:100019002 T:39605,45530'
G[7784]='L30 A:4949 T:14392 P:7783'
G[7785]='L30 A:100019016 T:14347 P:1'
G[7786]='L30 A:14347 T:14347 P:7785'
G[7787]='L30 A:100019018 T:14347 P:7786'
G[7789]='L10 E32305'
G[7810]='K256 L10 A:100018706 T:14508'
G[7815]='L11314 E32305'
G[7816]='L10 E32305'
G[7838]='K1 L10 A:14508 T:14508 P:7810'
G[7839]='L10 E32305'
G[7840]='L11313 E31961'
G[7841]='L10 E32305'
G[7842]='L11312 E31961'
G[7843]='L10 E32305'
G[7844]='L10 E32305'
G[7845]='L15 E32305'
G[7848]='L30 A:14387 T:14387'
G[7849]='L11826 E31961'
G[7850]='L11826 E32305'
G[7861]='L11315 E31961'
G[7862]='L11315 E31961'
G[7863]='FA L10 A:14753 T:14753 P:T37A44999'
G[7865]='L10 A:14753 T:14753 P:T37A44999'
G[7866]='L10 A:14754 T:14754 P:T37944999'
G[7868]='SP L10 A:14754 T:14754 P:T37944999'
G[7871]='L15 E31961'
G[7873]='L25 E32305'
G[7876]='L25 E32305'
G[7881]='L7864576 E32861'
G[7882]='L7866880 E32861'
G[7883]='L7869440 E32861'
G[7884]='L7872000 E32861'
G[7885]='L7874560 E32861'
G[7889]='L7864576 E32861'
G[7890]='L7866880 E32861'
G[7891]='L7869440 E32861'
G[7892]='L7872000 E32861'
G[7893]='L7874560 E32861'
G[7894]='L7864576 E32861'
G[7895]='L7866880 E32861'
G[7896]='L7869440 E32861'
G[7897]='L7872000 E32861'
G[7898]='L7874560 E32861'
G[7899]='L7864576 E32861'
G[7900]='L7866880 E32861'
G[7901]='L7869440 E32861'
G[7902]='L7872000 E32861'
G[7903]='L7874560 E32861'
G[7905]='HF fA L25 A:54334 T:14828 I:29601'
G[7907]='L7864576 A:100019228 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[7926]='HF L7864576 A:55382 T:14828 I:29601'
G[7927]='L7864576 A:100019277 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[7928]='L7864576 A:100019257 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[7929]='L7864576 A:100019267 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[7930]='L7864576 E31961'
G[7931]='L7866880 E31961'
G[7932]='L7872000 E31961'
G[7933]='L7874560 E31961'
G[7934]='L7864576 E31961'
G[7935]='L7869440 E31961'
G[7936]='L7874560 E31961'
G[7937]='L7866880 E31961'
G[7939]='L7874560 E31961'
G[7940]='L7877120 E31961'
G[7941]='L7874560 E31961'
G[7942]='L7874560 E31961'
G[7943]='L7874560 E31961'
G[7944]='L7866880 E31961'
G[7945]='L7866880 E31961'
G[7946]='SP HF K1 L7864576 A:14871 T:14871'
G[7981]='L7877120 E31961'
G[8026]='L1'
G[8041]='L15'	-- A:14902 T:14902
G[8042]='L15'	-- A:14902 T:14902
G[8043]='L15'	-- A:14902 T:14902
G[8044]='L15'	-- A:14902 T:14902
G[8045]='L15'	-- A:14902 T:14902
G[8046]='L15'	-- A:14902 T:14902
G[8047]='L15'	-- A:14902 T:14902
G[8048]='L15'	-- A:14902 T:14902
G[8049]='L15'	-- A:14903 T:14903
G[8050]='L15'	-- A:14903 T:14903
G[8051]='L15'	-- A:14903 T:14903
G[8052]='L15'	-- A:14903 T:14903
G[8053]='L14908'	-- A:14902 T:14902
G[8054]='L14908'	-- A:14902 T:14902
G[8055]='L14908'	-- A:14902 T:14902
G[8056]='L15'	-- A:14904 T:14904
G[8057]='L14908'	-- A:14904 T:14904
G[8058]='L15'	-- A:14902 T:14902
G[8059]='L14908'	-- A:14903 T:14903
G[8060]='L14908'	-- A:14903 T:14903
G[8061]='L14908'	-- A:14903 T:14903
G[8062]='L14908'	-- A:14905 T:14905
G[8063]='L15 E32305'
G[8064]='L14908'	-- A:14904 T:14904
G[8065]='L14908'	-- A:14904 T:14904
G[8066]='L14908'	-- A:14905 T:14905
G[8067]='L14908'	-- A:14905 T:14905
G[8068]='L15'	-- A:14903 T:14903
G[8069]='L14908'	-- A:14903
G[8070]='L14908'	-- A:14903 T:14903
G[8071]='L14908'	-- A:14903 T:14903
G[8072]='L15 E32305'
G[8073]='L14908'	-- A:14905 T:14905
G[8074]='L15'	-- A:14904 T:14904
G[8075]='L15'	-- A:14904 T:14904
G[8076]='L14908'	-- A:14903 T:14903
G[8077]='L14908'	-- A:14903 T:14903
G[8078]='L15'	-- A:14902 T:14902
G[8079]='L15'	-- A:14902 T:14902
G[8101]='L15'	-- A:14903 T:14903
G[8102]='L15'	-- A:14903 T:14903
G[8103]='L15'	-- A:14903 T:14903
G[8104]='FH L15'	-- A:14903 T:14903
G[8105]='L12855 A:14983 T:14983 Z15595'	-- arbitrary ending...not sure when it left
G[8106]='L15'	-- A:14903 T:14903
G[8107]='L15'	-- A:14903 T:14903
G[8108]='L15'	-- A:14903 T:14903
G[8109]='FH L15'	-- A:14903 T:14903
G[8110]='L15'	-- A:14904 T:14904
G[8111]='L15'	-- A:14904 T:14904
G[8112]='L15'	-- A:14904 T:14904
G[8113]='L15'	-- A:14904 T:14904
G[8114]='L60 A:14983 T:14983 Z16135'
G[8115]='FA L60 A:14983 T:14983 Z16135'
G[8116]='L15'	-- A:14904 T:14904
G[8117]='L15'	-- A:14904 T:14904
G[8118]='L15'	-- A:14904 T:14904
G[8119]='L15'	-- A:14904 T:14904
G[8120]='L12855 A:15021 T:15021 Z15595'	-- arbitrary ending...not sure when it left'
G[8121]='L20 A:15021 T:15021'
G[8122]='L20 A:15021 T:15021'
G[8141]='L15'	-- A:14905 T:14905
G[8142]='L15'	-- A:14905 T:14905
G[8143]='L15'	-- A:14905 T:14905
G[8144]='FH L15'	-- A:14905 T:14905
G[8145]='L15'	-- A:14905 T:14905
G[8146]='L15'	-- A:14905 T:14905
G[8147]='L15'	-- A:14905 T:14905
G[8148]='L15'	-- A:14905 T:14905
G[8149]='HH L7872000 A:15011 T:15011'
G[8150]='HH L7872000 A:15012 T:15012'
G[8151]='L25 E32305'
G[8166]='L3221549 A:14983 T:14983 Z15595'	-- arbitrary ending...not sure when it left
G[8167]='L2563619 A:14983 T:14983 Z15595'	-- arbitrary ending...not sure when it left
G[8168]='L1905689 A:14983 T:14983 Z15595'	-- arbitrary ending...not sure when it left
G[8169]='L3221549 A:15021 T:15021 Z15595'	-- arbitrary ending...not sure when it left
G[8170]='L2563619 A:15021 T:15021 Z15595'	-- arbitrary ending...not sure when it left
G[8171]='L1905689 A:15021 T:15021 Z15595'	-- arbitrary ending...not sure when it left
G[8183]='L14908'	-- A:100019802 T:14875
G[8184]='K1 L15 A:15042 T:15042 Z15595'	-- arbitrary ending...not sure when it left
G[8185]='K1 L15 A:15042 T:15042 Z15595'	-- arbitrary ending...not sure when it left
G[8186]='FH K1 L15 A:15042 T:15042 Z15595'	-- arbitrary ending...not sure when it left
G[8187]='K1 L15 A:15042 T:15042 Z15595'	-- arbitrary ending...not sure when it left
G[8188]='K1 L15 A:15042 T:15042 Z15595'	-- arbitrary ending...not sure when it left
G[8189]='K1 L15 A:15042 T:15042 Z15595'	-- arbitrary ending...not sure when it left
G[8190]='FH K1 L15 A:15042 T:15042 Z15595'	-- arbitrary ending...not sure when it left
G[8191]='K1 L15 A:15042 T:15042 Z15595'	-- arbitrary ending...not sure when it left
G[8192]='K1 L15 A:15042 T:15042 Z15595'	-- arbitrary ending...not sure when it left
G[8193]='HX K1 L1 A:15077 T:15077 P:PF001 I:8194'
G[8194]='HX K1 L1 A:15078 T:15078 P:PF001 I:8193'
G[8195]='K1 L15'	-- A:15070 T:15070
G[8196]='K1 L15'	-- A:14921 T:14921
G[8201]='L14908'	-- A:14910 T:14910
G[8221]='HX K1 L1 A:15079 T:15079 P:PF001'
G[8222]='L7874560 E32861'
G[8223]='L7874560 E31961'
G[8224]='HX K1 L1 A:15079 T:15079 P:PF001'
G[8225]='HX K1 L1 A:15079 T:15079 P:PF001'
G[8227]='L14908 A:1180366 T:12919'
G[8228]='SP HX FH K1 L15 A:15116 T:15116 P:PF175'
G[8229]='SP HX FA K1 L15 A:15119 T:15119 P:PF175'
G[8232]='L25 E32305'
G[8233]='L12852 E32305'
G[8237]='L0 T:95329'
G[8238]='K1 L15'	-- A:15070 T:15070
G[8239]='K1 L15'	-- A:15070 T:15070
G[8240]='L14908'	-- A:15070 T:15070
G[8243]='K1 L15'	-- A:14921 T:14921
G[8246]='K1 L15'	-- A:14921 T:14921
G[8249]='SP K1 L20 A:7323 T:7323'	-- interestingly, Blizzard reports this as classification Rogue which would make me put CR here, which is wrong
G[8250]='L25 E31961'
G[8254]='L25 E31961'
G[8260]='L10 E31961'
G[8261]='L10 E32305'
G[8262]='L10 A:15127 T:15127 P:T1FD44999'
G[8263]='L10 E32305'
G[8264]='L10 E31961'
G[8265]='L10 A:15126 T:15126 P:T1FE44999'
G[8271]='FA L1 A:13816 T:13816 P:7141'
G[8272]='FH L1 A:13817 T:13817 P:7142'
G[8276]='FH L13879 E31961'
G[8277]='L15 A:15189 T:15189'
G[8278]='L15 A:15189 T:15189 P:8277'
G[8279]='L15 A:15194 T:15194 P:8285'
G[8280]='L15 A:15191 T:15191 O:28527,28528,28856,28859'
G[8281]='L15 A:15191 T:15191 P:8280'
G[8282]='L15 A:15190 T:15190 P:8278'
G[8283]='L15 A:1180448 T:15182'
G[8284]='L15 A:15183 T:15183 P:8321'
G[8285]='L15 A:15183 T:15194 P:8284'
G[8286]='L60 E32305'
G[8287]='L15 A:15194 T:15181 P:8279'
G[8288]='L20 E32305'
G[8304]='L15 A:15181 T:-81,15181 P:8321'
G[8306]='L15 A:15181 T:15181 P:8304'
G[8307]='L15 A:15174 T:1180503 P:PC285'
G[8308]='L15 A:100020461 T:15170 P:8304'
G[8309]='L15 A:15170 T:15170 P:8304'
G[8310]='L15 A:15171 T:15171 P:8304'
G[8311]='HW fA L7866880 A:15310 T:15310 I:8312'
G[8312]='HW fH L7866880 A:15309 T:15309 I:8311'
G[8313]='L15 A:1180503 T:15174 P:8307'
G[8314]='L15 A:15170 T:15183 P:8309+8310'
G[8316]='L15 CW A:15183 T:15183 Z12213'
G[8317]='L15 A:15174 T:15174 P:8313'
G[8318]='L15 A:15306 T:15306'
G[8319]='K1 L15 A:15306 T:15306 P:8318+I255152'	-- TODO: Need to check low-level characters and how they interact in Silithus to see whether they need the time-travel.  It may be they just need not complete the quest that leads to the new Silithus
G[8320]='L15 A:15270 T:15270'
G[8321]='L15 A:15270 T:15270 P:8320'
G[8323]='L15 A:15194 T:15194 P:8279'
G[8324]='K1 L15 A:15194 T:15194 P:8323'
G[8325]='FH L1 RB A:15278 T:15278'
G[8326]='FH L1 RB A:15278 T:15278 P:8325'
G[8327]='FH L1 RB A:15278 T:15281 P:8326'
G[8328]='FH L5 RB CM A:15278 T:15279 P:8325 Z21691'
G[8329]='FH L515 RB CW A:15278 T:43010 P:8325 Z21691'
G[8330]='FH L1 RB A:15295 T:15295 Z19033'
G[8332]='L30 E32305'
G[8334]='FH L1 RB A:15281 T:15281 P:8326'
G[8335]='FH L1 RB A:15281 T:15281 P:8334'
G[8336]='FH L1 RB A:15296 T:15296 Z19033'
G[8338]='FH L1 RB A:100020483 T:15297'
G[8344]='FH L1 RB E32305'
G[8345]='FH L1 RB A:15295 T:15295 Z19033'
G[8346]='FH L1 RB A:15297 T:15297 Z19033'
G[8347]='FH L1 RB A:15281 T:15301 P:8335'
G[8350]='FH L1 A:15301 T:15433 P:9705'
G[8353]='HW L7866880 A:5111 T:5111 P:B8311'
G[8354]='HW L7866880 A:6741 T:6741 P:B8312'
G[8355]='HW L7866880 A:6826 T:6826 P:B8311'
G[8356]='HW L7866880 A:6740 T:6740 P:B8311'	-- note that this will still be available during the duration, even after completing
G[8357]='HW L7866880 A:6735 T:6735 P:B8311'
G[8358]='HW L7866880 A:11814 T:11814 P:B8312'
G[8359]='HW L7866880 A:6929 T:6929 P:B8312'
G[8360]='HW L7866880 A:6746 T:6746 P:B8312'
G[8361]='L13880 E31961'
G[8365]='L10285 E31961'
G[8366]='L10285 E31961'
G[8367]='L4603137 E31961'
G[8368]='L1247763 E31961'
G[8369]='L25 E31961'
G[8370]='L1905693 E32305'
G[8371]='L4603137 E31961'
G[8372]='L7 E31961'
G[8373]='L6401 E31961'
G[8374]='L10 E32305'
G[8375]='L25 E32305'
G[8376]='L15 CP A:15183 T:15183 Z12213'
G[8377]='L15 CH A:15183 T:15183 Z12213'
G[8378]='L15 CR A:15183 T:15183 Z12213'
G[8379]='L15 CT A:15183 T:15183 Z12213'
G[8380]='L15 CS A:15183 T:15183 Z12213'
G[8381]='L15 CM CL A:15183 T:15183 Z12213'
G[8382]='L30 CD A:15183 T:15183 Z12213'
G[8393]='L15 E32305'
G[8400]='L15 E32305'
G[8403]='L20 E32305'
G[8413]='L12852 E32305'
G[8415]='L25 E31961'
G[8416]='L25 E31961'
G[8417]='L25 E32305'
G[8421]='L12852 E32305'
G[8422]='L12852 E32305'
G[8425]='L25 E32305'
G[8426]='L10 E32305'
G[8430]='L20 E31961'
G[8436]='L15 E32305'
G[8446]='L30'	-- A:100020644 T:11832	-- item no longer drops since the four dragons are removed from the game
G[8447]='L30'	-- A:11832 T:11832 P:8446	--	(see above comment)
G[8461]='L11575 E32305'
G[8462]='L11575 E32305'
G[8463]='FH L1 A:15403 T:15403'
G[8464]='L11578 E31961'
G[8465]='L10 E32305'
G[8468]='FH L1 A:1180918 T:16924'
G[8470]='L15 A:100020741 T:11558'
G[8471]='L12856 E32305'
G[8472]='FH L1 A:15418 T:15418'
G[8473]='FH L1 A:15398 T:15398 O:9258'
G[8474]='FH L1 A:100023228 T:15398'
G[8475]='FH L1 A:15416 T:15416'
G[8476]='FH L1 A:15399 T:15399 O:9359'
G[8477]='FH L1 A:15400 T:15400'
G[8479]='FH L1 A:15406 T:15406'
G[8480]='FH L1 A:15404 T:15404'
G[8481]='L15 A:11555 T:11555 P:T24083999'
G[8482]='FH L1 A:100020765 T:15403'
G[8483]='FH L1 A:15403 T:15403 P:8482'
G[8486]='FH L1 A:15401 T:15401 P:9119'
G[8487]='FH L1 A:15402 T:15402 O:9254'
G[8488]='FH L1 A:15402 T:15402 P:8487'	-- 7 seconds later
G[8490]='FH L1 A:16362 T:16362 O:9253'
G[8491]='FH L1 A:15417 T:15417'
G[8492]='L30 E31961'
G[8494]='L30 E31961'
G[8499]='L30 E26231'
G[8500]='L30 E28153'
G[8501]='L15 E26367'
G[8502]='L15 E31961'
G[8503]='L30 E31961'
G[8505]='FA L30'
G[8509]='L30 E31961'
G[8511]='L30 E31961'
G[8513]='L30 E31961'
G[8515]='L30 E31961'
G[8517]='L30 E31961'
G[8520]='L30 E31961'
G[8522]='L30 E31961'
G[8524]='L30 E31961'
G[8526]='L30'
G[8527]='L1 E31961'
G[8528]='L30 E31961'
G[8532]='L30 E31961'
G[8534]='L30 E32305'
G[8537]='L30 E32305'
G[8538]='L30 E32305'
G[8539]='L15 E31961'
G[8542]='L30 E31961'
G[8544]='K1 L30 CW A:15502 T:15502'
G[8545]='L30 E28153'
G[8547]='FH L1 RB E31961'
G[8549]='L30 E31961'
G[8551]='L9002 E31961'
G[8554]='L15 E31961'
G[8556]='L30 CW A:15498 T:15498'
G[8557]='L30 CW A:15500 T:15500'
G[8558]='L30 CW A:15499 T:15499'
G[8559]='K1 L30 CW A:15503 T:15503'
G[8560]='K1 L30 CW A:15503 T:15503'
G[8561]='K1 L30 CW A:15502 T:15502'
G[8562]='K1 L30 CW A:15504 T:15504'
G[8563]='FH L5 RB CL A:15278 T:15283 P:8325 Z21691'
G[8564]='FH L5 RB CT A:15278 T:15284 P:8325 Z21691'
G[8572]='L30 E32305'
G[8574]='L30 E27843'
G[8579]='L30 A:15503 T:15503'
G[8580]='L30 E31961'
G[8582]='L30 E31961'
G[8588]='L30 E31961'
G[8590]='L30 E31961'
G[8592]='K1 L30 CT A:15502 T:15502'
G[8593]='K1 L30 CT A:15503 T:15503'
G[8594]='K1 L30 CT A:15502 T:15502'
G[8595]='SP K1 L30 A:15503 T:15503 P:8579'
G[8596]='K1 L30 CT A:15503 T:15503'
G[8600]='L30 E31961'
G[8602]='K1 L30 CS A:15502 T:15502'
G[8603]='K1 L30 CT A:15504 T:15504'
G[8604]='L30 E31961'
G[8607]='L30 E31961'
G[8609]='L30 E31961'
G[8611]='L30 E30993'
G[8613]='L30 E31961'
G[8615]='L30 E31961'
G[8619]='SP HL K16 L7864576 A:15549 T:15549'
G[8621]='K1 L30 CS A:15503 T:15503'
G[8622]='K1 L30 CS A:15504 T:15504'
G[8623]='K1 L30 CS A:15502 T:15502'
G[8624]='K1 L30 CS A:15503 T:15503'
G[8625]='K1 L30 CM A:15502 T:15502'
G[8626]='K1 L30 CH A:15503 T:15503'
G[8627]='K1 L30 CP A:15504 T:15504'
G[8628]='K1 L30 CP A:15502 T:15502'
G[8629]='K1 L30 CP A:15503 T:15503'
G[8630]='K1 L30 CP A:15502 T:15502'
G[8631]='K1 L30 CM A:15503 T:15503'
G[8632]='K1 L30 CM A:15502 T:15502'
G[8633]='K1 L30 CM A:15504 T:15504'
G[8634]='K1 L30 CM A:15503 T:15503'
G[8635]='SP HL K16 L7864576 A:15556 T:15556'
G[8636]='SP HL K16 L7864576 A:15557 T:15557'
G[8637]='K1 L30 CR A:15503 T:15503'
G[8638]='K1 L30 CR A:15504 T:15504'
G[8639]='K1 L30 CR A:15502 T:15502'
G[8640]='K1 L30 CR A:15503 T:15503'
G[8641]='K1 L30 CR A:15502 T:15502'
G[8642]='SP HL K16 L7864576 A:15558 T:15558'
G[8643]='SP HL K16 L7864576 A:15559 T:15559'
G[8644]='SP HL K16 L7864576 A:15560 T:15560'
G[8645]='SP HL K16 L7864576 A:15561 T:15561'
G[8646]='SP HL K16 L7864576 A:15562 T:15562'
G[8647]='SP HL K16 L7864576 A:15563 T:15563 P:600000'
G[8648]='SP HL K16 L7864576 A:15564 T:15564'
G[8649]='SP HL K16 L7864576 A:15565 T:15565'
G[8650]='SP HL K16 L7864576 A:15566 T:15566'
G[8651]='SP HL K16 L7864576 A:15567 T:15567'
G[8652]='SP HL K16 L7864576 A:15568 T:15568'
G[8653]='SP HL K16 L7864576 A:15569 T:15569'
G[8654]='SP HL K16 L7864576 A:15570 T:15570'
G[8655]='K1 L30 CP A:15503 T:15503'
G[8656]='K1 L30 CH A:15504 T:15504'
G[8657]='K1 L30 CH A:15502 T:15502'
G[8658]='K1 L30 CH A:15503 T:15503'
G[8659]='K1 L30 CH A:15502 T:15502'
G[8660]='K1 L30 CL A:15503 T:15503'
G[8661]='K1 L30 CL A:15504 T:15504'
G[8662]='K1 L30 CL A:15502 T:15502'
G[8663]='K1 L30 CL A:15503 T:15503'
G[8664]='K1 L30 CL A:15502 T:15502'
G[8665]='K1 L30 CD A:15503 T:15503'
G[8666]='K1 L30 CD A:15504 T:15504'
G[8667]='K1 L30 CD A:15502 T:15502'
G[8668]='K1 L30 CD A:15503 T:15503'
G[8669]='L30 CD A:15502 T:15502'
G[8670]='SP HL K16 L7864576 A:15572 T:15572'
G[8671]='SP HL K16 L7864576 A:15573 T:15573'
G[8672]='SP HL K16 L7864576 A:15574 T:15574'
G[8673]='SP HL K16 L7864576 A:15575 T:15575'
G[8674]='SP HL K16 L7864576 A:15576 T:15576'
G[8675]='SP HL K16 L7864576 A:15577 T:15577'
G[8676]='SP HL K16 L7864576 A:15578 T:15578'
G[8677]='SP HL K16 L7864576 A:15579 T:15579'
G[8678]='SP HL K16 L7864576 A:15580 T:15580'
G[8679]='SP HL K16 L7864576 A:15581 T:15581'
G[8680]='SP HL K16 L7864576 A:15582 T:15582'
G[8681]='SP HL K16 L7864576 A:15583 T:15583'
G[8682]='SP HL K16 L7864576 A:15584 T:15584'
G[8683]='SP HL K16 L7864576 A:15585 T:15585'
G[8684]='SP HL K16 L7864576 A:15586 T:15586'
G[8685]='SP HL K16 L7864576 A:15587 T:15587'
G[8686]='SP HL K16 L7864576 A:15588 T:15588'
G[8687]='L15 E31961'
G[8688]='SP HL K16 L7864576 A:15592 T:15592'
G[8689]='L30 CT A:15500 T:15500'
G[8690]='L30 CS A:15500 T:15500'
G[8691]='L30 CM A:15500 T:15500'
G[8692]='L30 CD A:15500 T:15500'
G[8693]='L30 CR A:15500 T:15500'
G[8694]='L30 CL A:15500 T:15500'
G[8695]='L30 CP A:15500 T:15500'
G[8696]='L30 CH A:15500 T:15500'
G[8697]='L30 CT A:15498 T:15498'
G[8698]='L30 CS A:15498 T:15498'
G[8699]='L30 CM A:15498 T:15498'
G[8700]='L30 CD A:15498 T:15498'
G[8701]='L30 CR A:15498 T:15498'
G[8702]='L30 CL A:15498 T:15498'
G[8703]='L30 CP A:15498 T:15498'
G[8704]='L30 CH A:15498 T:15498'
G[8705]='L30 CT A:15499 T:15499'
G[8706]='L30 CS A:15499 T:15499'
G[8707]='L30 CM A:15499 T:15499'
G[8708]='L30 CD A:15499 T:15499'
G[8709]='L30 CR A:15499 T:15499'
G[8710]='L30 CL A:15499 T:15499'
G[8711]='L30 CP A:15499 T:15499'
G[8712]='L30 CH A:15499 T:15499'
G[8713]='SP HL K16 L7864576 A:15593 T:15593'
G[8714]='SP HL K16 L7864576 A:15594 T:15594'
G[8715]='SP HL K16 L7864576 A:15595 T:15595'
G[8716]='SP HL K16 L7864576 A:15596 T:15596'
G[8717]='SP HL K16 L7864576 A:15597 T:15597'
G[8718]='SP HL K16 L7864576 A:15598 T:15598'
G[8719]='SP HL K16 L7864576 A:15599 T:15599'
G[8720]='SP HL K16 L7864576 A:15600 T:15600'
G[8721]='SP HL K16 L7864576 A:15601 T:15601'
G[8722]='SP HL K16 L7864576 A:15602 T:15602'
G[8723]='SP HL K16 L7864576 A:15603 T:15603'
G[8724]='SP HL K16 L7864576 A:15604 T:15604'
G[8725]='SP HL K16 L7864576 A:15605 T:15605'
G[8726]='SP HL K16 L7864576 A:15606 T:15606'
G[8727]='SP HL K16 L7864576 A:15607 T:15607'
G[8728]='L20 E32305'
G[8731]='FH L30 E32305'
G[8738]='L30 E32305'
G[8739]='L30 E32305'
G[8740]='L30 E32305'
G[8744]='SP HZ L7864576 A:1180743 T:1180743'
G[8746]='HV L10241 A:13418 T:13418 Z19243'
G[8747]='L30 A:15192 T:15192 P:T38E41999 I:8752,8757'
G[8748]='L30 A:15192 T:15192 P:8747'
G[8749]='L30 A:15192 T:15192 P:8748'
G[8750]='L30 A:15192 T:15192 P:8749'
G[8751]='L30 A:15192 T:15192 P:8750'
G[8752]='L30 A:15192 T:15192 P:T38E41999 I:8747,8757'
G[8753]='L30 A:15192 T:15192 P:8752'
G[8754]='L30 A:15192 T:15192 P:8753'
G[8755]='L30 A:15192 T:15192 P:8754'
G[8756]='L30 A:15192 T:15192 P:8755'
G[8757]='L30 A:15192 T:15192 P:T38E41999 I:8747,8752'
G[8758]='L30 A:15192 T:15192 P:8757'
G[8759]='L30 A:15192 T:15192 P:8758'
G[8760]='L30 A:15192 T:15192 P:8759'
G[8761]='L30 A:15192 T:15192 P:8760'
G[8762]='HV L10241 A:13433 T:13433 Z19243'
G[8763]='HV L10241 A:13433 T:1180715 Z19243'
G[8764]='L30 E31961'
G[8765]='L30 E31961'
G[8766]='L30 E31961'
G[8767]='SP HZ L7864576 CK CH CP CR CW A:1180746 T:1180746'
G[8768]='SP HZ L7869440 A:1180747 T:1180747'
G[8769]='SP HZ L7874560 A:1180748 T:1180748'
G[8770]='L15 E31961'
G[8771]='L15 E31961'
G[8772]='L15 E31961'
G[8773]='L15 E31961'
G[8774]='L15 E31961'
G[8775]='L15 E31961'
G[8776]='L15 E31961'
G[8777]='L15 E31961'
G[8784]='K1 L30 A:100021230 T:15502'
G[8785]='L30 E32305'
G[8788]='SP HZ L7864576 CD CM CO CT CS CL A:1180746 T:1180746'
G[8789]='K1 L30 A:15380 T:15380'
G[8790]='K1 L30 A:15378 T:15378'
G[8791]='L30 A:100021220 T:15181'
G[8792]='L316 E31961'
G[8793]='L1 E31961'
G[8794]='L316 E31961'
G[8795]='L1 E31961'
G[8796]='L316 E31961'
G[8797]='L316 E31961'
G[8798]='L30 A:10305 T:10305 P:28722+PN250 Z16139'
G[8799]='HV fH L10241 A:13418 T:1180715 Z19243'
G[8801]='L30 A:100021221 T:15379'
G[8802]='L30 A:15379 T:15192 P:8801'
G[8803]='SP HZ L7866880 A:1180793 T:1180793'
G[8810]='L30 E32305'
G[8811]='L30 E31961'
G[8812]='L30 E31961'
G[8813]='L30 E31961'
G[8814]='L30 E31961'
G[8815]='L30 E31961'
G[8816]='L30 E31961'
G[8817]='L30 E31961'
G[8818]='L30 E31961'
G[8819]='L30 E31961'
G[8820]='L30 E31961'
G[8821]='L30 E31961'
G[8822]='L30 E31961'
G[8823]='L30 E31961'
G[8824]='L30 E31961'
G[8825]='L30 E31961'
G[8826]='L30 E31961'
G[8827]='HZ FA L7864576 A:15732 T:13444'
G[8828]='HZ FH L7864576 A:515732 T:13445'
G[8830]='L30 E31961'
G[8831]='L30 E31961'
G[8832]='L1 E31961'
G[8833]='L1 E31961'
G[8834]='L30 E31961'
G[8835]='L30 E31961'
G[8836]='L30 E31961'
G[8837]='L30 E31961'
G[8838]='L30 E31961'
G[8839]='L30 E31961'
G[8840]='L1 E31961'
G[8841]='L1 E31961'
G[8842]='L1 E31961'
G[8843]='L1 E31961'
G[8844]='L1 E31961'
G[8845]='L1 E31961'
G[8850]='L30 E31961'
G[8855]='L25 E31961'
G[8860]='HU FA L1 A:15732 T:6740'
G[8861]='HU FH L1 A:515732 T:6746'
G[8862]='L7864576 E31961'
G[8863]='L7864576 E31961'
G[8864]='L7864576 E31961'
G[8865]='L7864576 E31961'
G[8866]='SP HL K16 L7864576 A:15871 T:15871'
G[8867]='HL K16 L7864576 A:15895 T:15895 O:8870,8871,8872,8873,8874,8875'
G[8868]='HL K16 L7864576 A:15864 T:15864'
G[8870]='HL FA K16 L7864576 A:15892 T:15895 I:8871,8872'
G[8871]='HL FA K16 L7864576 A:515892 T:15895 I:8870,8872'
G[8872]='HL FA K16 L7864576 A:500088 T:15895 I:8870,8871'
G[8873]='HL FH K16 L7864576 A:15891 T:15895 I:8874,8875'
G[8874]='HL FH K16 L7864576 A:15891 T:15895 I:8873,8875'
G[8875]='HL FH K16 L7864576 A:15891 T:15895 I:8873,8874'
G[8876]='L7864576 E31961'
G[8877]='L7864576 E31961'
G[8878]='L7864576 E31961'
G[8879]='L7864576 E31961'
G[8880]='L7864576 E31961'
G[8881]='L7864576 E31961'
G[8882]='L7864576 E31961'
G[8883]='HL K16 L7864576 A:15895 T:15864 P:8867'
G[8884]='FH L1 A:15920 T:15920'
G[8885]='FH L1 A:15920 T:15920 P:8884'
G[8886]='FH L1 A:15921 T:15921'
G[8887]='FH L1 A:100021776 T:15921'
G[8888]='FH L1 A:15951 T:15924'
G[8889]='FH L1 A:15924 T:15924 O:8888'
G[8890]='FH L1 A:15924 T:15951 P:8889'
G[8891]='FH L1 A:1181011 T:15951'
G[8892]='FH L1 A:15939 T:15939 O:9256'
G[8894]='FH L1 A:15969 T:15969 O:9394'
G[8895]='FH L1 A:15418 T:15405 P:8472'
G[8897]='FA L1 E31961'
G[8898]='FA L1 E31961'
G[8899]='FA L1'
G[8900]='L1 E31961'
G[8901]='L1 E31961'
G[8902]='L1 E31961'
G[8903]='FA L1 E31961'
G[8904]='FH L1 E31961'
G[8910]='FA L15 E26365'
G[8918]='FH L15 E31961'
G[8924]='L15 E32305'
G[8929]='FA L15 E32305'
G[8930]='FH L15 E32305'
G[8979]='L1 E31961'
G[8983]='L1 E32305'
G[8984]='L1 E31961'
G[8993]='FA L1 E31961'
G[8994]='L15 E31961'
G[9023]='L60 E32305'
G[9024]='L1'
G[9027]='L1 E31961'
G[9028]='L1 E29297'
G[9033]='L20 E32305'
G[9035]='FH L1 A:15941 T:15945'
G[9051]='L25 E32305'
G[9052]='L25 E32305'
G[9062]='FH L1 A:15945 T:15945 O:9035'
G[9064]='FH L1 A:15945 T:15970 P:9062'
G[9066]='FH L1 A:15970 T:15970 P:9064'
G[9067]='FH L1 A:16144 T:16144 O:9395'
G[9076]='FH L1 A:15404 T:15404 P:8480'
G[9085]='L21 E31961'
G[9119]='FH L1 A:15405 T:15401 P:8895'
G[9121]='L60 E32305'
G[9124]='L14140 E32305'
G[9126]='L14140 E31961'
G[9128]='L14140 E32305'
G[9130]='FH L1 RB A:16261 T:44036'
G[9131]='L14140 E32305'
G[9133]='FH L1 RB A:44036 T:16191 P:9130'
G[9134]='FH L1 RB A:16191 T:16192 P:9133'
G[9135]='FH L1 RB A:16192 T:16261 P:9134'
G[9136]='L14140 E32305'
G[9138]='FH L1 A:16197 T:16197 P:9758'
G[9139]='FH L1 A:16197 T:16197 P:9138'
G[9140]='FH L1 A:16197 T:16197 P:9139'
G[9141]='L14140 E32305'
G[9143]='FH L1 A:16219 T:16219 O:9145'
G[9144]='FH L1 A:16210 T:16183 I:28560'
G[9145]='FH L1 A:16213 T:16219 P:T39A44999'
G[9146]='FH L1 A:16219 T:16220 P:9143'
G[9147]='FH L1 A:16196 T:16196 O:9144,28560'
G[9148]='FH L1 A:16183 T:16197 P:9147'
G[9149]='FH L1 A:16198 T:16198 P:9327,9329'
G[9150]='FH L1 A:16199 T:16199 P:T39A44999'
G[9151]='FH L1 A:16199 T:16204'
G[9152]='FH L1 A:16224 T:16224 P:9327,9329'
G[9153]='L21 E31961'
G[9154]='L21 E31961'
G[9155]='FH L1 A:16200 T:16200 P:T39A44999'
G[9156]='FH K512 L1 A:1181147 T:16200'	-- PM3
G[9157]='FH L1 A:16201 T:16201 P:C9274'
G[9158]='FH L1 A:16202 T:16202'
G[9159]='FH L1 A:16202 T:16202 P:9158'
G[9160]='FH L1 A:16231 T:16231 P:T39A44999'
G[9161]='FH L1 A:16203 T:1181150 O:9282'
G[9162]='FH L1 A:1181150 T:16203 P:9161'
G[9163]='FH L1 A:16231 T:16231 P:9160'
G[9164]='FH L1 A:16198 T:16240'
G[9166]='FH L1 A:16231 T:16237 P:9163'
G[9167]='FH K512 L1 A:16239 T:16239 P:9176'	-- PM5
G[9169]='FH L1 A:16237 T:16237 P:9166'
G[9170]='FH L1 A:16204 T:16204 P:9220'
G[9171]='FH L1 A:16253 T:16253 P:T39A44999'
G[9172]='FH L1 A:16203 T:16239 P:9162'
G[9173]='FH L1 A:16252 T:16252 P:T39A50999'
G[9174]='FH L1 A:16201 T:16201 P:9157'
G[9175]='FH L1 A:100022597 T:16252'
G[9176]='FH L1 A:16239 T:16239 P:9172'
G[9177]='FH L1 RO RU RT RL RG RA RR RM RZ SB A:16252 T:10181 P:9175 Z18019'	-- arbitrary ending...not sure when it left
G[9180]='FH L1 RB A:16252 T:10181 P:9175'
G[9187]='L30 E32305'
G[9189]='FH L10 RB E32305'
G[9192]='FH L1 A:16251 T:16251 P:T39A44999'
G[9193]='FH L1 A:16289 T:16289'
G[9195]='L30 E32305'
G[9199]='FH L1 A:16251 T:16251'
G[9205]='L30 E32305'
G[9207]='FH L1 A:16293 T:16291 P:T39A44999'
G[9208]='K1 L14908 A:15042 T:15042 Z15595'	-- arbitrary ending...not sure when it left
G[9209]='K1 L14908 A:15042 T:15042 Z15595'	-- arbitrary ending...not sure when it left
G[9210]='K1 L14908 A:15042 T:15042 Z15595'	-- arbitrary ending...not sure when it left
G[9212]='FH L1 A:16295 T:16220'
G[9214]='FH L1 A:16220 T:16220'
G[9215]='FH K512 L1 A:1181153 T:16220'	-- PM2
G[9216]='FH L1 A:16205 T:16205'
G[9217]='FH K1 L1 A:16205 T:16205 P:9216'
G[9218]='FH L1 A:16205 T:16205'
G[9219]='FH K1 L1 A:16205 T:16205 P:9218'
G[9220]='FH L1 A:16204 T:16204 O:9151'
G[9221]='L14140 E32305'
G[9222]='L14140 E32305'
G[9226]='L14140 E32305'
G[9229]='L20 E32305'
G[9247]='L1 E31961'
G[9248]='L13880 E31961'
G[9249]='L7874560 E31961'
G[9250]='L20 A:100022727 T:15192 P:K100022727'
G[9251]='L30 A:15192 T:15192 P:9250+K100022733'
G[9252]='FH L1 A:15942 T:15942 O:9358'
G[9253]='FH L1 A:15942 T:16362 P:9252'
G[9254]='FH L1 A:16210 T:15402'
G[9255]='FH L1 A:15402 T:16210 P:8488'
G[9256]='FH L1 A:15403 T:15939 P:8483'
G[9257]='L20 CT A:15192 T:15192 P:9251'
G[9258]='FH L1 A:16397 T:15398'
G[9259]='K1 L1 A:16399 T:16399 P:t01541999'
G[9260]='FA L1 E31961'
G[9261]='FA L1 E31961'
G[9262]='FA L1 E31961'
G[9263]='FH L1 E31961'
G[9264]='FH L1 E31961'
G[9265]='FH L1 E31961'
G[9266]='K1 L1 A:16416 T:16416 P:t24141999'
G[9267]='K1 L1 A:16418 T:16418 P:t1D641999'
G[9268]='K1 L1 A:16417 T:16417 P:t17141999'
G[9269]='L30 CD A:15192 T:15192 P:9251'
G[9270]='L30 CM A:15192 T:15192 P:9251'
G[9271]='L20 CL A:15192 T:15192 P:9251'
G[9272]='L10 A:2546 T:2546 P:t01535999+T05741999 I:1036'
G[9274]='FH L1 A:16462 T:16462'
G[9275]='FH L1 A:16464 T:16464'
G[9276]='FH L1 A:16463 T:16463'
G[9277]='FH L1 A:16463 T:16463 P:9276'
G[9278]='FA L1 E31961'
G[9279]='FA L1 RD A:16475 T:16477'
G[9280]='FA L1 RD A:16477 T:16477 O:9279 I:9369'
G[9281]='FH L1 A:16480 T:16480'
G[9282]='FH L1 A:16239 T:16203'
G[9283]='FA L1 RD A:16502 T:16502 P:9409'
G[9287]='FA L5 RD CP A:16501 T:16501 P:9409 Z17688'
G[9288]='FA L5 RD CH A:16499 T:16499 P:9409 Z17688'
G[9289]='FA L5 RD CW A:16503 T:16503 P:9409 Z17688'
G[9290]='FA L5 RD CM A:16500 T:16500 P:9409 Z17688'
G[9291]='FA L5 RD CT A:16502 T:16502 P:9409 Z17688'
G[9292]='FA L1 E31961'
G[9293]='FA L1 A:16514 T:16514 P:10302'
G[9294]='FA L1 A:16514 T:16514 P:9293'
G[9295]='L20 E31961'
G[9299]='L20 E31961'
G[9300]='L20 E31961'
G[9301]='L20 E31961'
G[9302]='L20 E31961'
G[9303]='FA L1 A:16535 T:16535 P:10302 O:10304 I:37444'
G[9304]='L20 E31961'
G[9305]='FA L1 A:17071 T:17071 P:10302 Z18918'
G[9309]='FA L1 A:16535 T:16546 P:9303,37444 E10772'
G[9310]='FH L1 E26433'
G[9311]='FA L1 A:16546 T:16535 P:10303 E10958'
G[9312]='FA L1 A:16535 T:17071 P:9305|37445+9311 E10772'
G[9313]='FA L1 A:17071 T:16551 P:9312'
G[9314]='FA L1 A:16554 T:16553'
G[9315]='FH K512 L1 A:16601 T:16197 P:9327,9329'	-- PM2
G[9319]='L7877120 E31961'
G[9322]='L7864576 E31961'
G[9323]='L7864576 E31961'
G[9324]='HM FA L7864576 A:100023179 T:16817'
G[9325]='HM FA L7864576 A:100023180 T:16817'
G[9326]='HM FA L7864576 A:100023181 T:16817'
G[9327]='FH L1 RB A:16197 T:16252 O:9144,28560'
G[9328]='FH L1 RB A:16239 T:16802 P:9167'
G[9329]='FH L1 RO RU RT RL RG RA RR RM RZ SB A:16197 T:16252 O:9144,28560'
G[9330]='HM FH L7864576 A:100023182 T:16818'
G[9331]='HM FH L7864576 A:100023183 T:16818'
G[9332]='HM FH L7864576 A:100023184 T:16818'
G[9339]='SP HM L7864576 A:16818 T:16818 P:H9330+H9331+H9332+H11933'
G[9340]='FH L10 A:16789 T:16789 O:9498,9499'
G[9345]='FH L10 A:16858 T:16858'
G[9349]='L10 A:19344 T:19344'
G[9351]='L10 A:19367 T:19367 P:10161'
G[9352]='FH L1 A:15403 T:15401 P:8463'
G[9355]='FA L10 A:16837 T:16837 P:10143,10483'
G[9356]='L10 A:19344 T:19344 P:9361'
G[9358]='FH L1 A:15397 T:15942'
G[9359]='FH L1 A:15939 T:15399 P:8892'
G[9360]='FH L1 A:100023249 T:15399'
G[9361]='L10 A:19344 T:19344 P:9349'
G[9362]='L30 E31961'
G[9363]='FH L1 A:15399 T:15939 P:9360'
G[9364]='L30 E31961'
G[9365]='SP HM fA L7864576 A:16817 T:16817 P:H9324+H9325+H9326+H11935'
G[9366]='FH L10 A:16791 T:16791'
G[9367]='L7864576 E31961'
G[9368]='L7864576 E31961'
G[9369]='FA L1 RH RF RE RN RW RA RV RI RK SD A:16477 T:16477 I:9280'
G[9370]='FH L10 A:16791 T:16791 P:9366'
G[9371]='FA L1 A:16477 T:16514 P:9409'
G[9372]='L10 A:16991 T:16991 O:10442,10443'
G[9373]='L10 A:100023338 T:16991'
G[9374]='FH L10 A:16793 T:16793'
G[9375]='FH L10 A:16993 T:17015'
G[9376]='FH L10 A:17015 T:17015 P:9375'
G[9381]='FH L10 A:16790 T:16790'
G[9383]='FA L10 A:17006 T:17006'
G[9385]='FA L10 A:16850 T:16850'
G[9387]='FH L10 A:16794 T:16794'
G[9388]='L281 E31961'
G[9389]='L281 E31961'
G[9390]='FA L10 A:16834 T:16852'
G[9391]='FH L10 A:16789 T:16789 P:9340'
G[9392]='FH L5 RB CR A:15278 T:15285 P:8325 Z21691'
G[9393]='FH L515 RB CH A:15278 T:15513 P:8325 Z21691'
G[9394]='FH L1 A:15924 T:15969'
G[9395]='FH L1 A:16210 T:16144'
G[9396]='FH L10 A:16792 T:16792'
G[9397]='FH L10 A:16790 T:16790'
G[9398]='FA L10 A:16797 T:16797'
G[9399]='FA L10 A:16799 T:16799'
G[9400]='FH L10 A:3230 T:17062'
G[9401]='FH L10 A:17062 T:3230 P:9400'
G[9402]='FH L1 CM A:15970 T:15970'
G[9403]='FH L1 CM A:15970 T:15970 P:9402'
G[9404]='FH L1 CM A:15970 T:15970 P:9403'
G[9405]='FH L10 A:3230 T:16574 P:9401'
G[9406]='FH L10 A:16845 T:3230 P:9410'
G[9407]='FH L10 A:19254 T:19253 P:600002'
G[9408]='L10 E31961'
G[9409]='FA L1 A:16477 T:16502 P:9280,9369'
G[9410]='FH L10 A:16574 T:16845 P:9405'
G[9415]='FA L15 A:17082 T:17080'
G[9416]='FH L15 A:17081 T:17079'
G[9417]='FA L10 A:16850 T:16850 O:9558'
G[9418]='L10 A:100023580 T:17085'
G[9419]='K256 L13880 A:17080 T:17080 P:9415 Z27009'
G[9420]='FA L10 A:16851 T:16851 P:9563'
G[9421]='FA L5 RD CS A:17089 T:17089 P:9409 Z17688'
G[9422]='K256 L13880 A:17079 T:17079 P:9416 Z23835'
G[9423]='FA L10 A:16852 T:16834 P:9390'
G[9424]='FA L10 A:16833 T:16833 P:9423'
G[9425]='FH L4628 RB E32305'
G[9426]='FA L10 A:16796 T:16796'
G[9427]='FA L10 A:16796 T:16796 P:9426'
G[9428]='FH L10 RB E31961'
G[9429]='FA L4628 RD E31961'
G[9430]='FA L10 A:16796 T:16796 P:9543'
G[9431]='FH L6172 E31961'
G[9434]='FH L10 E32305'
G[9435]='FA L6429 E31961'
G[9436]='FH L10 A:17094 T:17094 P:26280'
G[9437]='FH L15 A:17095 T:17095'
G[9438]='FH L20 E32305'
G[9439]='FH L9256 E32305'
G[9441]='FH L20 E31961'
G[9442]='FH L10 A:17123 T:17123 Z13329'
G[9443]='FH L14138 E32305'
G[9444]='FH L30 E31961'
G[9447]='FH L10 A:17123 T:17123 P:9442 Z13329'
G[9452]='FA L1 A:17101 T:17101'
G[9453]='FA L1 A:17101 T:17110 P:9452'
G[9454]='FA L1 A:17110 T:17110'
G[9455]='L1 A:100023678 T:17116'
G[9456]='L1 A:17116 T:17116 P:9455'
G[9457]='FH L10 A:17094 T:17094 P:9436'
G[9462]='FA L7 RD E32305'
G[9463]='FA L1 RD A:17214 T:17214'
G[9464]='FA L7 RD E31961'
G[9466]='FH L10 A:1181638 T:16789'
G[9469]='FA L25 E32305'
G[9470]='FA L25 E32305'
G[9471]='FA L15 E32305'
G[9472]='FH L10 A:16793 T:16793 P:10287'
G[9473]='FA L1 RD A:17215 T:17215 P:9463'
G[9474]='FA L14138 E32305'
G[9483]='FH K1 L10 A:17226 T:17226'
G[9487]='FH L1 RB CM A:16197 T:16197'
G[9488]='FH L1 RB A:16197 T:16197 P:9487'
G[9490]='FA L10 A:16799 T:16799'
G[9491]='L10 E32305'
G[9492]='FA L30 E31961'
G[9493]='FA L20 E31961'
G[9494]='FA L30 E32305'
G[9495]='FH L17222 E31961'
G[9496]='FH L16966 E31961'
G[9498]='FH L10 RO RU RT RL RG RA RR RM RZ SB A:16577 T:16789'
G[9499]='FH L10 RB A:16577 T:16789'
G[9502]='FA L10 RD E32305'
G[9504]='FA L10 RD E32305'
G[9505]='FA L1 RD A:17215 T:17240 P:9473'
G[9506]='FA L1 A:17240 T:17240 O:9505'
G[9512]='FA L1 A:17246 T:17246'
G[9513]='FA L1 A:17241 T:17241 P:9506,9512'
G[9514]='L1 A:100023759 T:17241 P:C9506'
G[9515]='L1 A:17241 T:17241 P:9514'
G[9516]='FA L10 E32305'
G[9517]='FA L10 E32305'
G[9518]='FA L10 E32305'
G[9519]='FA L10 E32305'
G[9521]='FA L15 E32305'
G[9522]='FA L4886 E32305'
G[9523]='FA L1 A:17242 T:17242 P:9506,9512'
G[9524]='L30 E32305'
G[9525]='FH L17222 E28153'
G[9527]='FA L1 A:17311 T:17311 O:10428'
G[9528]='K544 L1 A:17312 T:17311'
G[9529]='FH L7 RB E32305'
G[9530]='FA L1 A:17240 T:17240 P:9506'
G[9531]='FA L1 A:17240 T:17240 P:9530'
G[9533]='FA L10 E32305'
G[9534]='FH L4885 E31961'
G[9536]='FH L4886 E32305'
G[9537]='FA L1 A:17240 T:17240 P:9531'
G[9538]='FA L1 A:17232 T:17360'
G[9539]='FA L1 A:17360 T:17361 P:9538'
G[9540]='FA L1 A:17361 T:17362 P:9539'
G[9541]='FA L1 A:17362 T:17363 P:9540'
G[9542]='FA L1 A:17363 T:17364 P:9541'
G[9543]='FA L10 A:16834 T:16796 P:9424'
G[9544]='FA L1 A:17364 T:17114 P:9542'
G[9545]='FA L10 A:16796 T:16796 P:9430'
G[9548]='FA L1 A:17421 T:17421'
G[9549]='FA L1 A:17421 T:17421 O:10063'
G[9550]='FA L1 A:100023837 T:1181756 P:9549'
G[9551]='FA L15 RD E32305'
G[9557]='FA L1 A:1181756 T:17424 P:9550'
G[9558]='FA L10 A:16826 T:16850 P:10143,10483'
G[9559]='FA L1 A:17114 T:17440 P:9544'
G[9560]='FA L1 A:17442 T:17442 P:9544'
G[9561]='FA L1 A:17424 T:1181758 P:9557'	-- about 10 second wait
G[9562]='FA L1 A:17441 T:17441 P:9544'
G[9563]='FA L10 A:16851 T:16851 P:T3B244999'
G[9564]='L1 A:100023850 T:17441 P:B9560,B9562'	-- reports actually P:9538
G[9565]='FA L1 A:17440 T:1181748 P:9560,9562'
G[9566]='FA L1 A:1181748 T:17440 P:9565'
G[9567]='FA L1 A:17433 T:17433'
G[9569]='FA L1 A:17433 T:17433 P:9567'	-- about a 15 second delay
G[9570]='FA L1 A:17443 T:17443 P:D9566,D9573'
G[9571]='FA L1 A:17443 T:17442 P:9570'
G[9572]='FH L15166 E31961'
G[9573]='FA L1 A:17445 T:17445 P:9560,9562'
G[9574]='FA L1 A:17434 T:17434 P:9629'
G[9575]='FA L15166 E31961'
G[9576]='FA L1 A:100023870 T:17434'
G[9578]='FA L1 A:17434 T:17508'
G[9579]='FA L1 A:17508 T:17434 P:9578'
G[9580]='FA L1 A:17642 T:17642'
G[9581]='FA L1 A:17423 T:17423'
G[9582]='FA L10 CW A:17480 T:17480'
G[9584]='FA L1 A:17423 T:17423 P:9628'
G[9585]='FA L1 A:17423 T:17423 P:9584'
G[9587]='FA L15166 E32305'
G[9588]='FH L15166 E32305'
G[9589]='FA L15167 E31961'
G[9590]='FH L15167 E32305'
G[9594]='FA L1 A:100023900 T:17433'
G[9595]='L10 E31961'
G[9602]='FA L1 A:17240 T:17116 P:9537'
G[9603]='FA L1 RD A:16553 T:43991,17554'
G[9604]='FA L1 A:43991,17554 T:16768 P:9603'
G[9605]='FA L1 A:16768 T:17555 P:9604'
G[9606]='FA L1 A:17555 T:16553 P:9605'
G[9607]='FA L15167 E31961'
G[9608]='FH L15167 E31961'
G[9612]='L1 RD A:17587 T:17116'
G[9616]='L1 A:100023910 T:17116'
G[9620]='FA L1 A:17423 T:17600 P:9581'
G[9621]='FH L1 RB A:16802 T:10181 P:9328'
G[9622]='FA L1 A:17440 T:17116 P:9566+9570+9573'
G[9623]='L1 A:17116 T:17584'
G[9624]='FA L1 A:17599 T:17599'
G[9625]='L1 A:17584 T:17586 P:9623 I:28559'
G[9626]='FH L1 RB A:10181 T:39605 P:9621'
G[9627]='FH L1 RB A:39605 T:16802 P:9626'
G[9628]='FA L1 A:17600 T:17423 P:9620'
G[9629]='FA L1 A:17434 T:17434'
G[9630]='L70 A:17613 T:16813 Z22248'
G[9631]='L1 A:17613 T:17636 P:9680'
G[9632]='FA L1 A:17424 T:17614'
G[9633]='FA L10 E32305'
G[9634]='FA L1 A:17586 T:17586 O:9625,28559'
G[9635]='FH L10 A:17637 T:17637 P:PN305'
G[9636]='FA L10 A:17634 T:17634 P:PN305'
G[9637]='L70 A:17636 T:17636 P:9631 Z22248'
G[9638]='L70 A:16813 T:16814 P:9630'
G[9639]='L1 A:16814 T:16815 P:9638'
G[9640]='L70 A:16815 T:16815 P:9639'
G[9641]='FA L1 A:17684 T:17684'
G[9642]='FA K1 L1 A:17684 T:17684 P:9641'
G[9643]='FA L1 A:17642 T:17642'
G[9644]='L1 A:17636 T:17613 P:9637 Z22248'
G[9645]='L70 A:16815 T:17613 P:9640'
G[9646]='FA L1 A:1181889 T:17423'
G[9647]='FA L1 A:17642 T:17642 P:9580,9643'
G[9648]='FA L1 A:17663 T:17663'
G[9649]='FA L1 A:17663 T:17663 P:9648'
G[9663]='FA L1 A:17649 T:17649'
G[9664]='FA L14140 E32305'
G[9665]='FH L30 E32305'
G[9666]='FA L1 A:17649 T:17649 P:9663'
G[9667]='L1 A:17682 T:18803 P:9559'
G[9668]='FA L1 A:17649 T:17658 P:9666'
G[9669]='L1 A:17676 T:17676'
G[9670]='L1 A:17686 T:17686'
G[9671]='SP FA L1 A:17703 T:17703 P:9506'
G[9672]='FA L1 A:100024132 T:17712 P:9671 I:9751'
G[9673]='FH L7 RB E32305'
G[9674]='FA L1 A:17712 T:17712 P:9672,9751'
G[9676]='FH L515 RB CP A:15278 T:15280 P:8325 Z21691'
G[9678]='FH L3073 RB E32305'
G[9680]='L1 A:17613 T:17613 P:9645'
G[9682]='FA L1 A:17712 T:17712 P:9674'
G[9683]='FA L1 A:17712 T:17712 P:9682'
G[9687]='FA L1 A:17674 T:17674'
G[9688]='FA L1 A:17674 T:17674 P:9687'
G[9689]='FA L1 A:17674 T:17674 P:9688'
G[9692]='FH L5143 RB E32305'
G[9693]='FA L1 A:17658 T:17684 O:9668'
G[9694]='FA L1 A:17684 T:17684 P:9693'
G[9695]='FA L1 E31961'
G[9696]='FA L1 A:17684 T:17825 P:9779'
G[9697]='L10 A:17834 T:17831 P:T3AE44999'
G[9698]='FA L1 A:17825 T:17468 P:9696'
G[9699]='FA L1 A:17468 T:17684 P:9698'
G[9700]='FA L1 A:17684 T:17684 P:9699'
G[9701]='L10 A:17831 T:17831 O:9697'
G[9702]='L10 A:17831 T:17831 P:9701'
G[9703]='FA L1 A:17843 T:17843 P:9700'
G[9704]='FH L1 A:15301 T:17849 O:8347'
G[9705]='FH L1 A:17849 T:15301 P:9704'
G[9706]='FA L1 A:1182032 T:17843 P:9779'
G[9708]='L10 A:17831 T:17831 P:9702'
G[9709]='L10 A:17831 T:17831 P:9708'
G[9711]='FA L1 A:17843 T:17843 P:9706'
G[9715]='L16193 E31961'
G[9716]='L10 A:17841 T:17841'
G[9717]='L16193 E31961'
G[9718]='L10 A:17841 T:17841 P:9716'
G[9719]='L16193 E31961'
G[9720]='L10 A:17841 T:17841 P:9718'
G[9723]='FH L20 RB E31961'
G[9724]='L10 A:17841 T:16885 P:9731'
G[9726]='L10 A:17856 T:17856 P:T3CA44999'
G[9727]='K1 L10 A:17856 T:17856 P:9726+T3CA44999'
G[9728]='L10 A:17858 T:17858 O:9778'
G[9729]='L10 A:17877 T:17856 P:T3CA50999'
G[9730]='L10 A:1182115 T:17858'
G[9731]='L10 A:100024330 T:17841 P:C9720'
G[9732]='L10 A:16885 T:17841 P:9724'
G[9738]='L15937 E31961'
G[9739]='L10 A:17923 T:17923 P:t3CA44999'
G[9740]='FA L1 A:17844 T:17844 P:9746'
G[9741]='FA L1 A:17926 T:17844'
G[9742]='SP K1 L10 A:17923 T:17923 P:9739+t3CA44999'
G[9743]='L10 A:17923 T:17923 P:t3CA44999'
G[9744]='SP K1 L10 A:17923 T:17923 P:9743+t3CA44999'
G[9746]='FA L1 A:17844 T:17844 P:9748'
G[9747]='L10 A:17956 T:17956'
G[9748]='FA L1 A:17844 T:17844 P:9703'
G[9749]='L1 E31961'
G[9751]='FA L1 A:17240 T:17712 P:9671 I:9672'
G[9752]='L10 A:17969 T:17841'
G[9753]='FA L1 A:17844 T:17658'
G[9756]='FA L1 A:17658 T:17658 P:9753'
G[9758]='FH L1 A:16252 T:16197 P:9327,9329'
G[9759]='FA L1 A:17982 T:17658 P:9753'
G[9760]='FA L1 A:17658 T:17986 P:9756'
G[9761]='FA L1 A:17986 T:17986 P:9760'
G[9762]='FA L1 RD A:17468 T:17468 P:9759'
G[9763]='L17222 E31961'
G[9764]='L17222 E32305'
G[9769]='FH L10 A:18016 T:18016'
G[9770]='FH L10 A:18012 T:18012'
G[9771]='FH L10 A:18011 T:18035 P:9774'
G[9772]='FH L10 A:18035 T:18011 P:9771'
G[9773]='FH K1 L10 A:18016 T:18016'
G[9774]='FH L10 A:18011 T:18011'
G[9775]='FH L10 A:18011 T:18013'
G[9776]='FA L10 A:18003 T:18008'
G[9777]='FA L10 A:18007 T:18007'
G[9778]='L10 A:17841 T:17858'
G[9779]='FA L1 A:17684 T:17684 P:9694'
G[9780]='FA L10 A:18006 T:18006 P:9791'
G[9781]='FA L10 A:18005 T:18005'
G[9782]='FA L10 A:18004 T:18004'
G[9783]='FA L10 A:18004 T:18004 P:9782'
G[9784]='SP K1 L10 A:17909 T:17909 P:9802+t3AE50999'
G[9785]='L10 A:18070 T:18070 P:T3AE44999'
G[9786]='FA L10 A:18003 T:18003'
G[9787]='FA L10 A:18003 T:18003 P:9786'
G[9788]='L10 A:17956 T:17956 P:9747'
G[9789]='L15 A:18180 T:18180 O:10113,10114'
G[9790]='FA L10 A:18005 T:18005 P:9781'
G[9791]='FA L10 A:18006 T:18006'
G[9792]='FA L15 A:18008 T:18408 P:T3D241999'
G[9793]='FA L15 A:18004 T:18252 I:10104'
G[9794]='FA L20 A:18019 T:18098'
G[9795]='FH L20 A:18013 T:18248'
G[9796]='FH L15 A:18011 T:18249 I:10105'
G[9797]='FH L15 A:18091 T:18090'
G[9798]='FA L1 A:100024414 T:16535 P:9309'
G[9799]='FA L1 A:20233 T:20233 P:10302'
G[9800]='L15 A:18073 T:18073'
G[9801]='FA L10 A:18003 T:18003 P:9787'
G[9802]='L10 A:17909 T:17909'
G[9803]='FA L10 A:18003 T:18003 P:9801'
G[9804]='L15 A:18073 T:18073 P:9800'
G[9805]='L15 A:18073 T:18073 P:9804'
G[9806]='L10 A:17925 T:17925 P:T3CA41999'
G[9807]='SP K1 L10 A:17925 T:17925 P:9806+T3CA41999'
G[9808]='L10 A:17924 T:17924 P:T3CA41999+t3CA44999'
G[9809]='SP K1 L10 A:17924 T:17924 P:9808+T3CA41999+t3CA44999'
G[9810]='L15 A:18073 T:18073 P:9805'
G[9811]='FH L1 RO RU RT RL RG RA RR RM RZ SB A:16239 T:16802 P:9167'
G[9812]='FH L1 RO RU RT RL RG RA RR RM RZ SB A:16802 T:10181 P:9811'
G[9813]='FH L1 RO RU RT RL RG RA RR RM RZ SB A:10181 T:39605 P:9812'
G[9814]='FH L10 A:18014 T:18014'
G[9815]='L15 A:18073 T:18073'
G[9816]='FH L10 A:18014 T:18014 P:9814'
G[9817]='L10 A:1182115 T:17858'
G[9818]='L15 A:18071 T:18099'
G[9819]='L15 A:18099 T:18099 P:9818'
G[9820]='FH L10 A:1182165 T:18013'
G[9821]='L15 A:18099 T:18099 P:9819'
G[9822]='FH L10 A:18013 T:18013 P:9820'
G[9823]='FH L10 A:18013 T:18013 P:9822'
G[9824]='L17478 A:17613 T:17613 Z22248'
G[9825]='L17478 A:17613 T:17613 P:9824 Z22248'
G[9826]='L17478 A:17613 T:18165 P:9824,9825 Z22248'
G[9827]='FA L10 A:100024483 T:18007 P:C9782'
G[9828]='FH L10 A:100024484 T:18012'
G[9829]='L35 A:18165 T:18166 P:9826 Z22248'
G[9830]='FA L10 A:18009 T:18009 P:T3D241999'
G[9831]='L17478 A:18166 T:18166 P:9829 Z22248'
G[9832]='K64 L17478 A:18166 T:18166 P:9831 Z22248'
G[9833]='FA L10 A:18009 T:18009 P:T3D241999'
G[9834]='FA L10 A:18010 T:18010 P:T3D241999'
G[9835]='FA L10 A:18008 T:18008'
G[9836]='L35 A:18166 T:15608 P:9832 Z22248'
G[9837]='L35 A:15608 T:18166 P:9836 Z22248'
G[9838]='L17478 A:18166 T:17613 P:9837 Z22248'
G[9839]='FA L10 A:18008 T:18008 P:9835'
G[9840]='L17478 A:17613 T:16388 P:9838 Z22248'
G[9841]='FH L10 A:18015 T:18015'
G[9842]='FH L10 A:18015 T:18015 P:9841'
G[9843]='L17478 A:16388 T:17613 P:9840 Z22248'
G[9844]='L17478 A:17613 T:17613 P:9843 Z22248'
G[9845]='FH L10 A:18018 T:18018'
G[9846]='FH L10 A:18017 T:18017'
G[9847]='FH L10 A:18017 T:18017 P:9846'
G[9848]='FA L10 A:18019 T:18019'
G[9849]='L15 A:18099 T:18099 P:9821'
G[9850]='L15 A:18180 T:18180 P:9789'
G[9851]='L15 A:18180 T:18180 P:9850'
G[9852]='L15 A:18180 T:18180 P:9856+9859+9851'
G[9853]='L15 A:18099 T:18099 P:9849'
G[9854]='L15 A:18200 T:18200 O:10113,10114'
G[9855]='L15 A:18200 T:18200 P:9854'
G[9856]='L15 A:18200 T:18200 P:9855'
G[9857]='L15 A:18218 T:18218 O:10113,10114'
G[9858]='L15 A:18218 T:18218 P:9857'
G[9859]='L15 A:18218 T:18218 P:9858'
G[9860]='L17478 A:17613 T:18165 P:9844'
G[9861]='L15 A:100024504 T:18074'
G[9862]='L15 A:18074 T:18074 P:9861'
G[9863]='FH L15 A:18066 T:18066'
G[9864]='FH L15 A:18067 T:18229'
G[9865]='FH L15 A:18229 T:18229 P:9864'
G[9866]='FH L15 A:18229 T:18067 P:9865'
G[9867]='FH L15 A:18068 T:18068'
G[9868]='FH L15 A:18210 T:18063'	-- Need to be neutral or higher with Mag'har so reports a player in http://us.battle.net/wow/en/forum/topic/10787819412
G[9869]='FA L15 A:18233 T:18072 P:T3D241999'
G[9870]='FH L15 A:18234 T:18072'
G[9871]='FA L15 A:100024559 T:18183'
G[9872]='L15 A:100024558 T:18063'
G[9873]='FA L15 A:18183 T:18183 P:9871'
G[9874]='FA L15 A:18222 T:18222 P:T3D241999'
G[9875]='K1 L10 A:100024407 T:17909 P:t3AE62999'
G[9876]='L15937 E31961'
G[9877]='FH L1 A:16240 T:16198 P:9220 Z25678'
G[9878]='FA L15 A:18224 T:18224 P:T3D241999'
G[9879]='FA L15 A:18209 T:18183'
G[9882]='L15 A:18265 T:18265 P:t3A544999 O:9913'
G[9883]='K1 L15 A:18265 T:18265'
G[9884]='SP L15 A:18265 T:18265'
G[9885]='SP L15 A:18265 T:18265'
G[9886]='SP L15 A:18265 T:18265'
G[9887]='SP L15 A:18265 T:18265'	-- Nimhfree gets this (exalted)
G[9888]='FH L15 A:18106 T:18273'
G[9889]='FH L15 A:18273 T:18262 P:9888'
G[9890]='FH L15 A:18262 T:18273 P:9889'
G[9891]='FH L15 A:18273 T:18106 P:9890'
G[9892]='K1 L15 A:18265 T:18265 P:9893'
G[9893]='L15 A:18265 T:18265 P:T3A544999'
G[9894]='L10 A:18070 T:18070 P:9747'
G[9895]='L10 A:17834 T:17834'
G[9896]='FA L10 A:18295 T:18295 P:9901'
G[9897]='L15 A:18294 T:18218'
G[9898]='FH L10 A:18012 T:18012 P:9770'
G[9899]='FH L10 A:18016 T:18016'
G[9900]='L15 A:18276 T:18276'
G[9901]='FA L10 A:18295 T:18295'
G[9902]='FA L10 A:18009 T:18009 P:T3D241999'
G[9903]='FH L10 A:18018 T:18018 P:9845'
G[9904]='FH L10 A:18018 T:18018'
G[9905]='FA L10 A:18010 T:18010 P:9834'
G[9906]='FH L15 A:18106 T:18106 P:9891'
G[9907]='FH L15 A:18106 T:18106 P:9906'
G[9910]='FH L15 A:18300 T:18300'
G[9911]='L10 A:100025459 T:17831'
G[9912]='L10 A:16885 T:17841 I:39180,39181'
G[9913]='L15 A:18335 T:18265'
G[9914]='L15 A:18333 T:18333 P:t3A544999'
G[9915]='K1 L15 A:18333 T:18333'
G[9916]='FH L15 A:18300 T:18300 P:9910'
G[9917]='FA L15 A:18353 T:18353'
G[9918]='FA L15 A:18353 T:18353 P:9917'
G[9919]='L10 A:17923 T:17924 P:T3CA41999'
G[9920]='FA L15 A:18353 T:18223 P:T3D241999,9918'
G[9921]='FA L15 A:18223 T:18223 P:9920'
G[9922]='FA L15 A:18223 T:18223 P:9921'
G[9923]='FA L15 A:18369 T:18183'
G[9924]='FA L15 A:18183 T:18183 P:9923'
G[9925]='L15 A:18276 T:18276'
G[9927]='L15 A:18261 T:18261 O:10108'
G[9928]='L15 A:18261 T:18261 O:10108'
G[9931]='L15 A:18261 T:18261 P:9928+9927'
G[9932]='L15 A:18261 T:18261 P:9928+9927'
G[9933]='FA L15 A:18261 T:18183 P:9932+9931'
G[9934]='FH L15 A:18261 T:18063'
G[9935]='FH L15 A:1182392 T:18407'
G[9936]='FA L15 A:1182393 T:18408 P:T3D241999'
G[9937]='FH L15 A:18407 T:18407'
G[9938]='FA L15 A:18408 T:18408 P:9936+9940'
G[9939]='FH L15 A:1182392 T:18407'
G[9940]='FA L15 A:1182393 T:18408 P:T3D241999'
G[9944]='FH L15 A:18302 T:18414'
G[9945]='FH L15 A:18414 T:18414 P:9944'
G[9946]='FH L15 A:18414 T:18414 P:9945'
G[9948]='FH L15 A:18415 T:18415'
G[9951]='L15 A:18424 T:18424'
G[9954]='FA L15 A:18183 T:18445 P:9924'
G[9955]='FA L15 A:18445 T:18183 P:9954'
G[9956]='L15 A:18416 T:18416'
G[9957]='L15 A:17834 T:18446 P:T3AE44999 I:9960,9961'
G[9960]='FH L15 A:18447 T:18446 I:9957,9961'
G[9961]='FA L15 A:18459 T:18446 I:9957,9960'
G[9962]='K512 L15 A:18471 T:22893'	-- PM5
G[9967]='K512 L15 A:18471 T:22893 P:9962'	-- PM5
G[9968]='L15 A:18446 T:18446 O:9957,9960,9961'
G[9970]='K512 L15 A:18471 T:22893 P:9967'	-- PM5
G[9971]='L15 A:18446 T:18446'
G[9972]='K512 L15 A:18471 T:22893 P:9970'	-- PM5
G[9973]='K512 L15 A:18471 T:22893 P:9972'	-- PM5
G[9977]='K512 L15 A:18471 T:22893 P:9973'	-- PM5
G[9978]='L15 A:18446 T:18482 P:9968,9971'
G[9979]='L15 A:18482 T:18484 P:9978'
G[9982]='L15 A:18416 T:18417'
G[9983]='L15 A:18301 T:18417'
G[9984]='FA L15 E31961'
G[9986]='FA L15 A:18389 T:18389'
G[9987]='FH L15 A:18386 T:18386'
G[9988]='FA L15 E31961'
G[9990]='L15 A:18484 T:18446 P:10112'
G[9991]='L15 A:18417 T:18417 O:9982,9983'
G[9992]='FA L15 A:18390 T:18390'
G[9993]='FH L15 A:18385 T:18385'
G[9994]='FA L15 A:18446 T:18459 P:9990'
G[9995]='FH L15 A:18446 T:18447 P:9990'
G[9996]='FA L15 A:21006 T:21006 P:10444'
G[9997]='FH L15 A:21007 T:21007 P:10448'
G[9998]='FA L15 A:18387 T:18565'
G[9999]='L15 A:18417 T:18417 P:9991'
G[10000]='FH L15 A:18383 T:18566'
G[10001]='L15 A:18417 T:18417 P:9999'
G[10002]='FA L15 A:18565 T:18565 P:9998'
G[10003]='FH L15 A:18566 T:18566 P:10000'
G[10004]='L15 A:18417 T:18584 P:10001'
G[10005]='FA L15 A:18459 T:18446 P:10446'
G[10006]='FH L15 A:18447 T:18446 P:10447'
G[10007]='FA L15 A:18565 T:18565 P:9998'
G[10008]='FH L15 A:18566 T:18566'
G[10009]='K64 L15 A:18584 T:18584 P:10004'
G[10010]='L15 A:18584 T:18417 P:10009'
G[10011]='L15 A:18417 T:18417 P:10010'
G[10012]='FA L15 A:1182549 T:18387 P:9998'
G[10013]='FH L15 A:1182549 T:18386'
G[10016]='FA L15 A:18387 T:18387'
G[10017]='L15 A:18597 T:18597 P:t3A441999+10551|10552'
G[10018]='FH L15 A:18384 T:18384'
G[10019]='K1 L15 A:18597 T:18597 P:10017+t3A441999'
G[10020]='K512 L15 A:18597 T:18597 P:10551+T3A441999,10552+T3A441999'
G[10021]='L15 A:18538 T:18538 P:10551+T3A441999'
G[10022]='FA L15 A:18387 T:18387 P:10016'
G[10023]='FH L15 A:18384 T:18384 P:10018'
G[10024]='L15 A:18596 T:18596 P:t3A641999+10551|10552'
G[10025]='K1 L15 A:18596 T:18596 P:10024+t3A641999'
G[10026]='FA L15 A:18252 T:18252'	-- needs checking regarding 10104 and/or 9793 P/O
G[10027]='FH L15 A:18383 T:18383'
G[10028]='FA L15 A:18390 T:18390 P:9992'
G[10030]='L15 A:18675 T:19417 P:10840+10842'
G[10031]='L15 A:19417 T:18675 P:10030'
G[10033]='FA L15 A:1182587 T:18704'
G[10034]='FH L15 A:1182588 T:18705'
G[10035]='FA L15 A:18704 T:18704 P:10033'
G[10036]='FH L15 A:18705 T:18705 P:10034'
G[10037]='L15 A:18653 T:18653'
G[10038]='FA L15 A:18713 T:18715'
G[10039]='FH L15 A:18712 T:18714'
G[10040]='FA L15 A:18715 T:18715 P:10038'
G[10041]='FH L15 A:18714 T:18714 P:10039'
G[10042]='FA L15 A:18715 T:18713 P:10040'
G[10043]='FH L15 A:18714 T:18712 P:10041'
G[10044]='FH L15 A:18063 T:18141 P:10011+9868'
G[10045]='FH L15 A:18141 T:18141 P:10044'
G[10047]='FA L10 A:16839 T:16839 P:10143,10483'
G[10050]='FA L10 A:16827 T:16827 P:10143,10483'
G[10051]='FA L15 A:18760 T:18745'
G[10052]='FH L15 A:18760 T:18712'
G[10055]='FA L10 A:21209 T:21209'
G[10057]='FA L10 A:16827 T:16827 P:10050'
G[10058]='FA L10 A:16825 T:16825 P:10143,10483'
G[10063]='FA L1 A:18804 T:17421'
G[10064]='FA L1 A:17423 T:17927'
G[10065]='FA L1 A:17927 T:17927'
G[10066]='FA L1 A:17986,18020,18024 T:17986'
G[10067]='FA L1 A:17986,18020,18024 T:17986'
G[10068]='FH L515 RB CM A:15279 T:15279 P:8328 Z21691'
G[10069]='FH L515 RB CP A:15280 T:15280 P:9676 Z21691'
G[10070]='FH L515 RB CH A:15513 T:15513 P:9393 Z21691'
G[10071]='FH L5 RB CR A:15285 T:15285 P:9392 Z21691'
G[10072]='FH L515 RB CT A:15284 T:15284 P:8564 Z21691'
G[10073]='FH L515 RB CL A:15283 T:15283 P:8563 Z21691'
G[10074]='L15 A:18816 T:18816'
G[10075]='K1 L15 A:18816 T:18816 P:10074'
G[10076]='K256 L15 A:18817 T:18817'
G[10077]='K1 L15 A:18817 T:18817 P:10076'
G[10078]='FA L10 A:21209 T:21209 P:10055'
G[10079]='FA L10 A:16837 T:16837 P:10143,10483'
G[10081]='FH L15 A:18141 T:18687 P:10045'
G[10082]='FH L15 A:18687 T:18687 P:10081'
G[10085]='FH L15 A:18687 T:18687 P:10082'
G[10086]='FH L10 A:21283 T:21283'
G[10087]='FH L10 A:21283 T:21283 P:10086'
G[10091]='L35 E32305'
G[10093]='FA L10 A:16839 T:16796 P:10047'
G[10094]='L35 E31961'
G[10095]='L35 E31961'
G[10096]='L10 A:17909 T:17909 P:9747'
G[10097]='L16709 E31961'
G[10098]='L16709 E31961'
G[10099]='FA L10 A:16837 T:16837 P:10079'
G[10101]='FH L15 A:18687 T:17545 P:10085'
G[10102]='FH L15 A:17545 T:18481 P:10101'
G[10103]='FH L10 A:16789 T:18011'
G[10104]='FA L15 A:18008 T:18252 I:9793'
G[10105]='FH L15 A:18013 T:18385 I:9796'
G[10106]='K258 L10 A:18266 T:18266 P:13408,13410'
G[10107]='FH L15 A:18106 T:18261 P:9907'
G[10108]='FA L15 A:18223 T:18261 P:9922'
G[10109]='L15 A:19035 T:19035'
G[10110]='K258 L10 A:18267 T:18267 P:13409,13411'
G[10111]='L15 A:19035 T:19035 P:10109'
G[10112]='L15 A:18484 T:18484 P:9979'
G[10113]='L15 A:19137 T:18180'
G[10114]='L15 A:19133 T:18200'
G[10115]='FA L10 A:18008 T:18008'
G[10116]='FA L10 A:1183284 T:18008'
G[10117]='FH L10 A:1182165 T:18013'
G[10118]='FH L10 A:18013 T:18013 P:9822'
G[10119]='FA L10 A:16841 T:19229 P:600001 I:28708'
G[10120]='FH L10 A:19253 T:18930 P:9407,28705'
G[10121]='FH L10 A:3230 T:19256 P:10291'
G[10122]='FA L10 E31961'
G[10123]='FH L10 A:19256 T:19256 P:10121'
G[10124]='FH L10 A:19256 T:19273 P:10123'
G[10129]='FH L10 A:19273 T:19273 P:10208'
G[10130]='FA L10 E31961'
G[10132]='L10 A:19293 T:19293'
G[10134]='L10 A:100029476 T:19293'
G[10136]='FH L10 A:3230 T:3230'
G[10140]='FA L10 A:18931 T:19308 P:10288'
G[10141]='FA L10 A:16819 T:19309 O:10254'
G[10142]='FA L10 A:19309 T:19309 P:10141'
G[10143]='FA L10 A:19309 T:19310 P:10142'
G[10144]='FA L10 A:19310 T:19310 P:10143'
G[10146]='FA L10 A:19310 T:19310 P:10144'
G[10159]='L10 A:16888 T:16888'
G[10160]='FA L10 A:16819 T:16820 O:10254'
G[10161]='L10 A:19367 T:19367'
G[10162]='FH L10 A:19273 T:19273 P:10129'
G[10163]='FA L10 A:20232 T:20232 P:10344'
G[10164]='L16451 E31961'
G[10165]='L16450'	-- A:19674 T:19674  this version was removed
G[10166]='L1 A:15398 T:19456 P:8474'
G[10167]='FH K64 L15 A:18481 T:19412 P:10102'
G[10168]='FH L15 A:19412 T:18687 P:10167'
G[10169]='L15 E32305'
G[10170]='FH L15 A:18687 T:18141 P:10168'
G[10171]='FH L15 A:18141 T:18063 P:10170'
G[10172]='FH L15 A:18063 T:18141 P:10171'
G[10173]='L25 A:19217 T:19217'
G[10174]='L25 A:19217 T:19644 P:10300'
G[10176]='L25 A:19644 T:19481 P:10209'
G[10177]='L17478 E31961'
G[10178]='L17478 E31961'
G[10179]='L25 E31961'
G[10180]='K64 L15 A:19045 T:54840'
G[10182]='L25 A:100029233 T:19488'
G[10183]='L25 A:19569 T:19570 I:11036,11037,11040,11042,11038,11039'
G[10184]='L25 A:19488 T:19488'
G[10185]='L25 A:19488 T:19488'
G[10186]='L25 A:19570 T:19570 O:10183,11036,11037,11040,11042'
G[10187]='L25 E31961'
G[10188]='L25 A:19644 T:19644 P:10174'
G[10189]='L25 A:19468 T:19468 P:10551+T3A641999,10552+T3A641999 O:11039'
G[10190]='L25 A:19578 T:19578'
G[10191]='K512 L25 A:19589 T:19578'	-- PM2
G[10192]='L25 A:19644 T:19644 P:10188'
G[10193]='L25 A:19468 T:19468 P:10189'
G[10194]='L25 A:19468 T:20162 P:10329'
G[10197]='L25 A:19840 T:19840 P:10652'
G[10198]='L25 A:19840 T:19840 P:10197'
G[10199]='L25 A:19617 T:19617 P:10342'
G[10200]='L25 A:19840 T:19468 P:10330'
G[10201]='FH L15 A:18385 T:18385 P:9993'
G[10202]='L25 A:19469 T:20920 P:10341'
G[10203]='L25 A:19570 T:19634'
G[10204]='L25 A:19469 T:19469 P:T3A641999'
G[10205]='L25 A:19880 T:19880'
G[10206]='L25 A:19645 T:19645'
G[10208]='FH L10 A:19273 T:19273 P:10124'
G[10209]='L25 A:19644 T:19644 P:10301'
G[10210]='L15 A:19684 T:18481'
G[10211]='L15 A:18166 T:18166 P:10210'
G[10213]='FH L10 A:16858 T:19367 P:9345'
G[10216]='L16450'	-- A:19670 T:1183877   this one is no longer present
G[10218]='L16450 A:19671 T:19674 Z20338'
G[10220]='FH L10 A:19682 T:19682'
G[10221]='L25 A:19634 T:19634'
G[10222]='L25 A:19488 T:19488'
G[10223]='L25 A:19488 T:19488 P:10222'
G[10224]='L25 A:19709 T:19709 P:10225'
G[10225]='L25 A:19570 T:19709'
G[10226]='L25 A:19709 T:19709 P:10224'
G[10227]='L15 A:19697 T:19417'
G[10228]='L15 A:19417 T:19715 P:10227'
G[10229]='FH L10 A:100028552 T:19736'
G[10230]='FH L10 A:19736 T:19736 P:10229'
G[10231]='L15 A:19715 T:19720 P:10228'
G[10232]='L25 A:19645 T:19645'
G[10233]='L25 A:19489 T:19489'
G[10234]='L25 A:19728 T:19728 P:10333'
G[10235]='L25 A:19728 T:19728 P:10234'
G[10236]='L10 A:16915 T:16915'
G[10237]='L25 A:19728 T:19570 P:10235'
G[10238]='L10 A:16915 T:16915 P:10236'
G[10239]='L25 A:19489 T:19489 P:10343'
G[10240]='L25 A:19489 T:19489 P:10239'
G[10241]='L25 A:19466 T:19466 P:10551+T3A441999,10552+T3A441999 O:11038'
G[10242]='FH L10 A:21257 T:21279'
G[10243]='L25 A:19467 T:1183770 P:T3A441999'
G[10245]='L25 A:1183770 T:19467 P:10243'
G[10246]='L25 A:19466 T:19466 P:10299+T3A441999'
G[10247]='K512 L25 A:19570 T:19832 P:10237'	-- PM3
G[10248]='K512 L25 A:19832 T:19832 P:10247'	-- PM3
G[10249]='L25 A:19832 T:19570 P:10248'
G[10250]='FH L10 A:19736 T:19736 P:10230'
G[10251]='L15 A:19720 T:19844 P:10231'
G[10252]='L15 A:19844 T:19844 P:10251'
G[10253]='L15 A:19844 T:19417 P:10252'
G[10254]='L10 A:19308 T:16819 P:10140'
G[10255]='L10 A:16991 T:16991 P:9372'
G[10256]='K512 L25 A:19481 T:19481'	-- PM2
G[10257]='K64 L25 A:19481 T:19481 P:10256'
G[10258]='FH L10 A:19736 T:19937 P:10250'
G[10259]='L30 E32305'
G[10261]='K512 L25 A:1183811 T:19645'	-- PM2
G[10262]='L25 A:19880 T:19880 P:10265'
G[10263]='L25 A:19467 T:19880 P:T3A441999'
G[10264]='L25 A:19468 T:19880 P:T3A641999'
G[10265]='L25 A:19880 T:19880 O:10263,10264'
G[10266]='L25 A:19880 T:20066 P:10205'
G[10267]='L25 A:20066 T:20066 P:10266'
G[10268]='L25 A:20066 T:20084 P:10267'
G[10269]='L25 A:20084 T:20092 P:10268'
G[10270]='L25 A:20071 T:20518'
G[10271]='L25 A:20518 T:20154 P:10270'
G[10272]='L25 A:20110 T:20110 P:10281'
G[10273]='L25 A:20110 T:20110 P:10272'
G[10274]='K512 L25 A:20110 T:20110 P:10273'	-- PM3
G[10275]='L25 A:20092 T:20112 P:10269'
G[10276]='K512 L25 A:20112 T:20084 P:10275'	-- PM2
G[10277]='L15 A:20130 T:20130 O:10279'
G[10278]='FH L10 A:19683 T:19683'
G[10279]='L15 A:20142 T:20130'
G[10280]='L25 A:20084 T:18481 P:10276'
G[10281]='L25 A:20154 T:20110 P:10271'
G[10282]='L15 A:20130 T:20130 P:10277'
G[10283]='L20 A:18723 T:17876 P:10282 Z15050'
G[10284]='L16964 A:17876 T:18723 P:10283 Z15050'
G[10285]='L16964 A:18723 T:20130 P:10284 Z15050'
G[10286]='FH L10 A:16793 T:20159 P:9374'
G[10287]='FH L10 A:20159 T:16793 P:10286'
G[10288]='FA L10 A:19229 T:18931 O:10119,28708'
G[10289]='FH L10 A:18930 T:19255 P:10120'
G[10290]='K512 L25 A:20067 T:20067'	-- PM2
G[10291]='L10 A:19255 T:3230 P:10289'
G[10293]='K512 L25 A:20067 T:20067 P:10290'	-- PM2
G[10294]='FH L10 A:19683 T:19683 P:10278'
G[10295]='FH L10 A:19683 T:19683 P:10294'
G[10296]='L25 A:20130 T:20201'
G[10297]='L25 A:20201 T:20201 O:10296'
G[10298]='L16966 A:20201 T:20130 P:10297 Z15050'
G[10299]='L25 A:19467 T:19467 P:10245'
G[10300]='L25 A:19217 T:19217 P:10173'
G[10301]='L25 A:19644 T:19644 P:10192'
G[10302]='L1 A:16514 T:16514 P:9280,9369 O:9371'
G[10303]='L1 A:16546 T:16546 P:9309'
G[10304]='L1 A:16514 T:16535 P:9294'
G[10305]='L25 A:100029234 T:19488'
G[10306]='L25 A:100029235 T:19488'
G[10307]='L25 A:100029236 T:19488'
G[10308]='K1 L25 A:19880 T:19880'
G[10309]='K512 L25 A:19690 T:19690'	-- PM3
G[10310]='L25 A:20281 T:20066 O:10311'
G[10311]='L25 A:20066 T:20281'
G[10312]='L25 A:19488 T:19488 P:10184'
G[10313]='L25 A:19466 T:19466 P:10241'
G[10314]='L25 A:1184300 T:19488 P:10316'	-- TODO: G55|Prerequisites|
G[10315]='L25 A:20341 T:20341'
G[10316]='L25 A:19488 T:1184300 P:10312'
G[10317]='L25 A:20112 T:20393'
G[10318]='L25 A:20393 T:20112 P:10317'	-- TODO: G55|Prerequisites|
G[10319]='L25 A:19488 T:19488 P:10314'
G[10320]='K512 L25 A:19488 T:19488 P:10319'	-- PM3
G[10321]='L25 A:19467 T:19467 P:10299'
G[10322]='L25 A:19467 T:19467 P:10321'
G[10323]='K512 L25 A:19467 T:19467 P:10322'	-- PM3
G[10324]='FA L1 A:17110 T:17110 P:9454'
G[10325]='L15 A:18537 T:18537 P:T3A441999+t3A450999+10551|10552'
G[10326]='K1 L15 A:18537 T:18537 P:10325+T3A441999+t3A450999'
G[10327]='K1 L15 A:18537 T:18537 P:10325+T3A441999+t3A450999'
G[10328]='L25 A:19466 T:19466 P:10321+T3A441999'
G[10329]='L25 A:19468 T:19468 P:10193'
G[10330]='L25 A:19840 T:19840 P:10198'
G[10331]='L25 A:20463 T:20463'
G[10332]='L25 A:20463 T:20463 P:10331'
G[10333]='L25 A:19645 T:19728'
G[10334]='L25 A:20464 T:20415'
G[10335]='L25 A:20470 T:20470'
G[10336]='L25 A:20471 T:20471'
G[10337]='K512 L25 A:20415 T:20464'	-- PM2
G[10338]='L25 A:19468 T:19468 P:10200'
G[10339]='L25 A:20448 T:20482'
G[10340]='FA L10 A:19310 T:20234 P:10146'
G[10341]='L25 A:19469 T:19469 P:10330+T3A641999'
G[10342]='L25 A:19617 T:19617'
G[10343]='L25 A:19489 T:19489'
G[10344]='FA L10 A:20234 T:20232 P:10340'
G[10345]='L25 A:20551 T:20551'
G[10346]='K1 L10 A:20235 T:20235 P:10163'
G[10347]='K1 L10 A:19401 T:19401'
G[10348]='L25 A:20810 T:20810'
G[10349]='L10 A:19293 T:19294 P:10134'
G[10350]='FA L1 CW A:17480 T:17120 P:9582'
G[10351]='L10 A:19294 T:19294 P:10349'
G[10353]='L25 A:20552 T:20448'
G[10355]='L10 A:18007 T:18007 P:9827'
G[10365]='K512 L25 A:19468 T:19468 P:10338'	-- PM3
G[10367]='L10 A:19361 T:19361 O:10403'
G[10368]='L10 A:19361 T:19361 P:10367'
G[10369]='L10 A:19361 T:19361 P:10368'
G[10380]='L25 A:20780 T:20780 P:10431'
G[10381]='L25 A:20780 T:19466 P:10380'
G[10382]='FA L10 A:20232 T:20793 P:10163'
G[10384]='L25 A:20482 T:20482 P:10339'
G[10385]='L25 A:20482 T:20482 P:10384'
G[10388]='FH L10 A:16576,19273 T:3230'
G[10389]='FH L10 A:21175 T:21175'
G[10390]='FH L10 A:3230 T:3230 P:10388'
G[10391]='FH L10 A:3230 T:3230 P:10390'
G[10392]='FH L10 A:3230 T:3230 P:10391'
G[10393]='FH L10 A:100029590 T:21175'
G[10394]='FA L10 A:20793 T:20793 P:10382'
G[10395]='FA L10 A:100029588 T:16839'
G[10396]='FA L10 A:20793 T:20793 P:10394'
G[10397]='FA L10 A:20793 T:20793 P:10396'
G[10399]='FA L10 A:16839 T:16839 P:10395'
G[10400]='FA L10 A:16819 T:16819 P:10395'
G[10403]='L10 A:20677,20678,20679 T:19361'
G[10405]='L25 A:20482 T:20482 P:10385'
G[10406]='L25 A:20482 T:20482 P:10405'
G[10407]='K512 L25 A:19467 T:19467 P:T3A441999'	-- PM2
G[10408]='K512 L25 A:20482 T:20482 P:10406'	-- PM5
G[10409]='K512 L25 A:18538 T:18538 P:10410'	-- PM5
G[10410]='L25 A:19467 T:18538 P:10407'
G[10411]='L25 A:20449 T:20449'
G[10412]='L15 A:18531 T:18531 P:T3A641999+t3A650999+10551|10552'
G[10413]='L25 A:100029738 T:20449'
G[10414]='K1 L15 A:18531 T:18531 P:10412+T3A641999+t3A650999'
G[10415]='K1 L15 A:18531 T:18531 P:10412+T3A641999+t3A650999'
G[10416]='L15 A:18530 T:18530 P:T3A641999'
G[10417]='L25 A:20810 T:20810'
G[10418]='L25 A:20810 T:20810 P:10417'
G[10419]='K1 L15 A:18530 T:18530 P:10416+T3A641999'
G[10420]='L15 A:18538 T:18538 P:T3A441999'
G[10421]='SP K1 L15 A:18538 T:18538 P:10420+T3A441999'
G[10422]='L25 A:20450 T:20450'
G[10423]='L25 A:20810 T:20811 P:10418'
G[10424]='L25 A:20811 T:20811 P:10423'
G[10425]='L25 A:20763 T:20448'
G[10426]='L25 A:20871 T:20871'
G[10427]='L25 A:20871 T:20871 P:10426'
G[10428]='L1 A:17488 T:17311'
G[10429]='L25 A:20871 T:20871 P:10427'
G[10430]='L25 A:20811 T:20913 P:10424'
G[10431]='L25 A:19466 T:20780 P:10328'
G[10432]='L25 A:20920 T:19468 P:10202'
G[10433]='L25 A:20921 T:20921'
G[10434]='L25 A:20921 T:20205 P:10433'
G[10435]='L25 A:20205 T:20205 P:10434'
G[10436]='L25 A:20913 T:20913 P:10430'
G[10437]='L25 A:20907 T:20907'
G[10438]='L25 A:20907 T:20907 P:10437'
G[10439]='K512 L25 A:20907 T:20907 P:10438'	-- PM5
G[10440]='L25 A:20913 T:20811 P:10436'
G[10441]='L25 E31961'
G[10442]='FH L10 A:16790 T:16991'
G[10443]='FA L10 A:16796 T:16991'
G[10444]='FA L15 A:18459 T:21006 P:9994'
G[10445]='L30 E31961'
G[10446]='FA L15 A:21006 T:18459 P:9996'
G[10447]='FH L15 A:21007 T:18447 P:9997'
G[10448]='FH L15 A:18447 T:21007 P:9995'
G[10449]='FH L10 A:21256 T:21257 P:10450'
G[10450]='FH L10 A:21256 T:21256'
G[10451]='K512 L25 A:21027 T:21024'	-- PM2
G[10455]='FA L20 A:21066 T:21066'
G[10456]='FA L20 A:21066 T:21066 P:10455'
G[10457]='FA L20 A:21066 T:21066 P:10456'
G[10458]='L25 A:21024 T:21024 P:10680,10681'
G[10459]='L10 E31961'
G[10460]='L30 A:19936 T:19935 TA:19936 P:1'
G[10461]='SP L30 A:19935 T:19935 P:1'
G[10462]='L30 A:19935 T:19935 P:1'
G[10463]='SP L30 A:19936 T:19935 TA:19936 P:1'
G[10464]='L30 A:19935,19936 T:19935 P:1'
G[10465]='L30 A:19935 T:19935 P:1'
G[10466]='L30 A:19935 AH:19936 T:19935 P:1'
G[10467]='L30 A:19935 AA:19936 T:19935 P:1'
G[10468]='L30 A:19935 AA:19936 T:19935 P:10464'
G[10469]='L30 A:19935 T:19935 P:10465'
G[10470]='L30 A:19935 AH:19936 T:19935 P:10466'
G[10471]='L30 A:19935 T:19935 P:10467'
G[10472]='L30 A:19935 AH:19936 T:19935 P:10468'
G[10473]='L30 A:19935 T:19935 P:10469'
G[10474]='L30 A:19935 T:19935 P:10470'
G[10475]='L30 A:19935 T:19935 P:10471'
G[10476]='L15 A:18408 T:18408 P:T3D241999'
G[10477]='K1 L15 A:18408 T:18408'
G[10478]='K1 L15 A:18407 T:18407'
G[10479]='L15 A:18407 T:18407'
G[10480]='L25 A:21024 T:21024 P:10458'
G[10481]='L25 A:21024 T:21024 P:10480'
G[10482]='FA L10 A:16820 T:16820 O:10160'
G[10483]='FA L10 A:16820 T:21133 P:10482'
G[10484]='FA L10 A:21133 T:21133 P:10483'
G[10485]='FA L10 A:21133 T:21133 P:10484'
G[10486]='FH L20 N30 A:21117 T:21117'
G[10487]='FH L20 N30 A:21117 T:21117 P:10486'
G[10488]='FH L20 N30 A:21117 T:21117 P:10487'
G[10489]='FH L20 N30 A:1184660 T:21147'
G[10500]='L316 E31961'
G[10501]='L316 E31961'
G[10502]='FA L20 A:21158 T:21158'
G[10503]='FH L20 N30 A:21147 T:21147'
G[10504]='FA L20 A:21158 T:21158 P:10502'
G[10505]='FH L20 N30 A:21147 T:21147 P:10503'
G[10506]='FA L20 A:21066 T:21066 P:10457'
G[10507]='K512 L25 A:18530 T:18530 P:10509'	-- PM5
G[10508]='K512 L25 A:19468 T:19468 P:10432'	-- PM2
G[10509]='L25 A:19468 T:18530 P:10508'
G[10510]='FA L20 A:21197 T:21197'
G[10511]='FA L20 A:21151 T:21151'
G[10512]='FA L20 A:21151 T:21151'
G[10513]='L25 A:21024 T:21183 P:10481'
G[10514]='L25 A:21183 T:21183 P:10513'
G[10515]='L25 A:21183 T:21183 P:10514'
G[10516]='FA L20 A:21277 T:21277'
G[10517]='FA L20 A:21277 T:21277 P:10516'
G[10518]='FA L20 A:21277 T:21158 P:10517'
G[10519]='L25 A:21183 T:21183 P:10515'
G[10521]='L25 A:21183 T:21291'
G[10522]='L25 A:21291 T:21291 P:10521'
G[10523]='L25 A:21291 T:21183 P:10522'
G[10524]='FH L20 A:100030431 T:21311'
G[10525]='FH L20 N30 A:21311 T:21311 P:10524'
G[10526]='FH L20 N30 A:21311 T:21311 P:10525'
G[10527]='L25 A:21183 T:21292'
G[10528]='L25 A:21292 T:21292 P:10527'
G[10537]='L25 A:21318 T:21318 P:0'	-- TODO: Yoshimo: no quest for my warrior
G[10538]='FH L10 A:21279 T:21279'
G[10540]='L25 A:21318 T:21318 P:10537'
G[10541]='L25 A:21318 T:21183 P:10540'
G[10542]='FH L20 N30 A:21349 T:21349'
G[10543]='FH L20 N30 A:21349 T:21349 P:10545'
G[10544]='FH L20 N30 A:21349 T:21349 P:10543'
G[10545]='FH L20 N30 A:21349 T:21349 P:10542'
G[10546]='L25 A:21183 T:21293'
G[10547]='L25 A:21293 T:21411 P:10546'
G[10548]='L4114 E32305'
G[10550]='L25 A:21411 T:21293 P:10547'
G[10551]='SP L15 A:18166 T:18166 P:10211'	-- TODO: This and 10552 are I: to each other, but we want to ensure we can record which one was completed because Blizzard records both done when one is done
G[10552]='SP L15 A:18166 T:18166 P:10211'	-- TODO:  See 10551
G[10553]='L15 A:18166 T:18530 P:10552+T3A641999'
G[10554]='L15 A:18166 T:18538 P:10551+T3A441999'
G[10555]='L20 A:21469 T:1184825'
G[10556]='L20 A:1184825 T:21469 P:10555'
G[10557]='FA L20 A:21460 T:21460'
G[10558]='L20 E31961'
G[10560]='L20 E31961'
G[10561]='L30 E31961'
G[10562]='FA L25 A:21357 T:21357 P:11044'
G[10563]='FA L25 A:21357 T:21357 P:10562'
G[10564]='FA L25 A:21357 T:21357 P:10572'
G[10565]='FH L20 N30 A:21496 T:21496'
G[10566]='FH L20 N30 A:21496 T:21496 P:10565'
G[10567]='L20 A:21782 T:21782'
G[10568]='L25 A:21402 T:21402'
G[10569]='FA L25 A:22042 T:22042'
G[10570]='L25 A:21293 T:21293 P:10550'
G[10571]='L25 A:21402 T:21402 P:10568,10683'
G[10572]='FA L25 A:21357 T:21357 P:10563'
G[10573]='FA L25 A:21357 T:21471 P:10564'
G[10574]='L25 A:21402 T:21402 P:10571,10684'
G[10575]='L25 A:21402 T:21826 P:10574,10685'
G[10576]='L25 A:21293 T:21293 P:10570'
G[10577]='L25 A:21293 T:21293 P:10576'
G[10578]='K512 L25 A:21293 T:21293 P:10577'	-- PM4
G[10579]='L25 A:21293 T:21183 P:10578'
G[10580]='FA L20 A:21158 T:21690 I:10584'
G[10581]='FA L20 A:21690 T:21691 P:10580'
G[10582]='FA L25 A:21471 T:21471 P:10573'
G[10583]='FA L25 A:21471 T:21471'
G[10584]='FA L20 A:21691 T:21691'
G[10585]='FA L25 A:21471 T:21471'
G[10586]='FA L25 A:21471 T:21357'
G[10587]='L25 A:21860 T:21860 P:T3A444999'
G[10588]='K512 L25 A:21183 T:21024 P:0'	-- PM5
G[10589]='FA L25 A:21357 T:21357 P:10586'
G[10590]='FH L25 RB E32305'
G[10594]='FA L20 A:21755 T:21755 P:10608'
G[10595]='FH L25 A:21359 T:21359 O:11048'
G[10596]='FH L25 A:21359 T:21359 P:10595'
G[10597]='FH L25 A:21359 T:21359 P:10596'
G[10598]='FH L25 A:21359 T:21359 P:10597'
G[10599]='FH L25 A:21359 T:21475 P:10598'
G[10600]='FH L25 A:21475 T:21475 P:10599'
G[10601]='FH L25 A:21475 T:21475'
G[10602]='FH L25 A:21475 T:21475'
G[10603]='FH L25 A:21475 T:21359 P:0'	--TODO : Yoshimo: only accept turnin of 10601, not offer the quest
G[10604]='FH L25 A:21359 T:21359 P:10603'
G[10606]='FA L25 A:21790 T:21790 P:10766'
G[10607]='L20 A:21782 T:21782 P:10567'
G[10608]='FA L20 A:21755 T:21755'
G[10609]='FA L20 A:21110 T:21110'
G[10611]='FH L25 A:21789 T:21789 P:10767'
G[10612]='FA L25 A:21790 T:21790 P:10606'
G[10613]='FH L25 A:21789 T:21789 P:10611'
G[10614]='FH L20 N30 A:21984 T:22004 P:10718'
G[10615]='FH L20 N30 A:21496 T:21782 P:10566'
G[10617]='L20 N30 A:21895 T:21895'
G[10618]='L20 N30 A:21896 T:21896'
G[10619]='L25 A:21822 T:21822 P:0'	-- Aldor version of 10807 TODO: Yoshimo: needs rep-check/prequests
G[10620]='FA L20 A:21824 T:21824'
G[10621]='FA L25 A:100030756 T:19370'
G[10622]='L25 A:21826 T:21826 P:10575,10686'
G[10623]='FH L25 A:100030579 T:19333'
G[10624]='FH L25 A:21772 T:21772 P:11046'
G[10625]='FH L25 A:21772 T:21772 P:10624'
G[10626]='FA K512 L25 A:19370 T:19370 P:10621'	-- PM3
G[10627]='FH K512 L25 A:19333 T:19333 P:10623'	-- PM3
G[10628]='L25 A:21826 T:21700 P:10622'
G[10629]='L10 A:16915 T:16915 P:10238'
G[10630]='L10 A:16915 T:16915 P:10629'
G[10632]='FA L20 A:21118 T:21118'
G[10633]='FH L25 A:21772 T:21797 P:10625 I:10644'
G[10634]='K512 L25 A:21797 T:21797 P:10633,10644'	-- PM5 TODO: Yoshimo: verify 10633 10644
G[10635]='L25 A:21797 T:21797 P:10633,10644'	-- TODO: Yoshimo: verify 10633 10644
G[10636]='K512 L25 A:21797 T:21797 P:10633,10644'	-- PM2 TODO: Yoshimo: verify 10633 10644
G[10637]='L25 A:21860 T:21860 P:10587'
G[10639]='FH L25 A:21797 T:21772 P:10634+10635+10636 I:10645'	-- TODO: Yoshimo: verify 10634 10635 10636
G[10640]='L25 A:21860 T:18417 P:10637'
G[10641]='L25 A:18417 T:18417 P:10640,10689'
G[10642]='FA L25 A:21774 T:21774 O:11045'
G[10643]='FA L25 A:21774 T:21774 P:10642'
G[10644]='FA L25 A:21774 T:21797 P:10643 I:10633'
G[10645]='FA L25 A:21797 T:21774 P:10634+10635+10636 I:10639'	-- TODO: Yoshimo: verify 10634 10635 10636
G[10646]='L25 A:18417 T:18417 P:10641+10668+10669'
G[10647]='K512 L25 A:1184945 T:21771 I:10648'	-- PM4
G[10648]='K512 L25 A:1184946 T:21775 I:10647'	-- PM4
G[10649]='K64 L25 A:18417 T:18417 P:10646'
G[10650]='L25 A:18417 T:21860 P:10649+T3A444999'
G[10651]='K512 L25 A:21860 T:21860 P:10650'	-- PM5
G[10652]='L25 A:20162 T:19840 P:10194'
G[10653]='L15 A:18537 T:18537 P:T3A441999+t3A483999+10551|10552'
G[10654]='SP K1 L15 A:18537 T:18537 P:10653+T3A441999+t3A483999'
G[10655]='SP K1 L15 A:18537 T:18537 P:10653+T3A441999+t3A483999'
G[10656]='L15 A:18531 T:18531 P:T3A641999+t3A683999+10551|10552 I:10824'
G[10657]='FA L20 A:21691 T:21691 P:10584'
G[10658]='K1 L15 A:18531 T:18531 P:T3A641999+t3A683999+10656|10824'
G[10659]='K1 L15 A:18531 T:18531 P:T3A641999+t3A683999+10656|10824'
G[10660]='FH L25 A:21770 T:21770'
G[10661]='FA L25 A:21777 T:21777'
G[10662]='FA L25 A:19370 T:21465 P:10626'
G[10663]='FH L25 A:19333 T:21465 P:10627'
G[10664]='L25 A:21465 T:21465 P:10662,10663'
G[10665]='K64 L25 A:21465 T:21465 P:10664'
G[10666]='K64 L25 A:21465 T:21465 P:10664'
G[10667]='K64 L25 A:21465 T:21465 P:10665+10666'
G[10668]='L25 A:18417 T:18417 P:10640,10689'
G[10669]='L25 A:18417 T:18417 P:10640,10689'
G[10670]='K64 L25 A:21465 T:21465 P:10665+10666'
G[10671]='FA L20 A:21824 T:21824'
G[10672]='FH L25 A:21770 T:21770 P:10660'
G[10673]='FH L25 A:21770 T:21770 P:10672'
G[10674]='FA L20 A:21691 T:21691 P:10657'
G[10675]='FA L20 A:21691 T:21691 P:10674'
G[10676]='L25 A:21465 T:21465 P:10667+10670'
G[10677]='FA L25 A:21777 T:21777 P:10661'
G[10678]='FA L25 A:21777 T:21777 P:10677'
G[10679]='L25 A:21465 T:21465 P:10676'
G[10680]='FA L25 A:21937 T:21024'
G[10681]='FH L25 A:21938 T:21024 P:10680'
G[10682]='L20 A:22007 T:22007'
G[10683]='L25 A:21955 T:21955 P:10568'
G[10684]='L25 A:21955 T:21955 P:10571'
G[10685]='L25 A:21955 T:21955 P:10574'
G[10686]='L25 A:21955 T:21826 P:10575'
G[10687]='L25 A:21954 T:21954 P:T3A644999'
G[10688]='L25 A:21954 T:21954 P:10687'
G[10689]='L25 A:21954 T:18417 P:10688'
G[10690]='FA L20 A:1185035 T:21158'
G[10691]='L25 A:18417 T:21954 P:10649+T3A644999'
G[10692]='K512 L25 A:21954 T:21954 P:10691'	-- PM5
G[10693]='L30 E31961'
G[10694]='L30 E31961'
G[10695]='L30 E31961'
G[10696]='L30 E31961'
G[10697]='L30 E31961'
G[10698]='L30 E31961'
G[10699]='L30 E31961'
G[10700]='L30 E31961'
G[10701]='K512 L25 A:1183811 T:19570'	-- PM2
G[10702]='L25 A:21769 T:21769'
G[10703]='L25 A:21773 T:21773 P:0'	-- TODO: Yoshimo: probably alliance only
G[10704]='L25 A:18481 T:18481 P:10280'
G[10705]='L25 A:21700 T:21962 P:10628'
G[10706]='L25 A:21962 T:21700 P:10705'
G[10707]='K512 L25 A:21700 T:21700 P:10706'	-- PM5
G[10708]='L25 E31961'
G[10709]='FH L20 N30 A:22004 T:21984 P:10614'
G[10710]='FA L20 A:21460 T:21460 P:10557'
G[10711]='FA L20 A:21460 T:21460'
G[10712]='FA L20 A:21460 T:22020'
G[10713]='L20 A:22007 T:22007 P:10682'
G[10714]='FH L20 N30 A:21984 T:21984 P:10709'
G[10715]='FH L20 A:22103 T:22103 P:10783'
G[10717]='L20 A:21983 T:21983 P:B10713'
G[10718]='FH L20 N30 A:21950 T:21984 P:10526'
G[10719]='L20 A:100031120 T:22007'
G[10720]='FH L20 A:21984 T:21984 P:10749'
G[10721]='FH L20 A:21984 T:22103 P:10720'
G[10722]='L20 A:22386 T:22007 P:10893'
G[10723]='FH L20 A:21984 T:21984 P:10785'
G[10724]='FH L20 A:21984 T:21984 P:10723'
G[10725]='L70 A:18253 T:18253 P:10738'
G[10726]='L70 A:18253 T:18253 P:10739'
G[10727]='L70 A:18253 T:18253 P:10740'
G[10728]='L1 A:18253 T:18253 P:10741'
G[10729]='L1 A:18253 T:18253 P:T3C744999 Z22900'
G[10730]='L1 A:18253 T:18253 P:T3C744999 Z22900'
G[10731]='L1 A:18253 T:18253 P:T3C744999 Z22900'
G[10732]='L1 A:18253 T:18253 P:T3C744999 Z22900'
G[10733]='L70 A:18253 T:18253 P:10729'
G[10734]='L70 A:18253 T:18253 P:10730'
G[10735]='L70 A:18253 T:18253 P:10731'
G[10736]='L70 A:18253 T:18253 P:10732'
G[10738]='L70 A:18253 T:18253 P:10733'
G[10739]='L1 A:18253 T:18253 P:10734'
G[10740]='L70 A:18253 T:18253 P:10735'
G[10741]='L70 A:18253 T:18253 P:10736'
G[10742]='FH L20 A:21984 T:21984 P:10724'
G[10744]='FA L25 A:21790 T:21330 P:10612'
G[10745]='FH L25 A:21789 T:21769 P:10613'
G[10747]='L20 A:21983 T:21983 P:10717'
G[10748]='L20 A:22007 T:22007 P:10722'
G[10749]='FH L20 A:22103 T:21984 P:10715'
G[10750]='FH K512 L25 A:21769 T:21998'	-- PM3
G[10751]='FH K512 L25 A:21998 T:21998 P:10750'	-- PM3
G[10752]='FA L10 E31961'
G[10753]='L20 A:22133 T:22133'
G[10754]='L20 E31961'
G[10755]='L20 E31961'
G[10756]='L20 E31961'
G[10757]='L20 E31961'
G[10758]='L20 E31961'
G[10759]='FA L25 A:22042 T:22024 P:10569,10760'
G[10760]='FH L25 A:22043 T:22043 P:10569'
G[10761]='FH L25 A:22043 T:22024 P:10759'
G[10762]='L20 E31961'
G[10763]='L20 E31961'
G[10764]='L20 E31961'
G[10765]='FH K512 L25 A:21998 T:21998 P:10751'	-- PM3
G[10766]='FA L25 A:21357 T:21790 P:10589'
G[10767]='FH L25 A:21359 T:21789 P:10604'
G[10768]='FH K512 L25 A:21998 T:21998 P:10765'	-- PM3
G[10769]='FH K512 L25 A:21998 T:21769 P:10768'	-- PM3
G[10770]='L20 A:22053 T:22053'
G[10771]='L20 A:22053 T:22053'
G[10772]='FA K512 L25 A:21773 T:22059'	-- PM3
G[10773]='FA K512 L25 A:22059 T:22059 P:10772'	-- PM3
G[10774]='FA K512 L25 A:22059 T:22059 P:10773'	-- PM3
G[10775]='FA K512 L25 A:22059 T:22059 P:10774'	-- PM3
G[10776]='FA K512 L25 A:22059 T:21773 P:10775'	-- PM3
G[10777]='L25 A:22024 T:22024 P:10759,10761'
G[10778]='L25 A:22024 T:22024 P:10777'
G[10780]='L25 A:22024 T:22024 P:10778'
G[10781]='K512 L25 A:1185126 T:18481 P:10793'	-- PM5
G[10782]='L25 A:22024 T:22024 P:10780'
G[10783]='FH L20 A:21984 T:22103 P:10714'
G[10784]='FH L20 A:21147 T:21147 P:10503+10749'
G[10785]='FH L20 A:22103 T:21984 P:10721'
G[10786]='FH L20 A:21147 T:21147 P:10503+10785'
G[10791]='FH L15 A:18384 T:18384 P:10023'
G[10792]='FH L10 A:22107 T:22107 P:10809'
G[10793]='K512 L25 A:100031345 T:1185126'	-- PM4
G[10795]='FA L20 A:22149 T:22149'
G[10796]='FA L20 A:22150 T:22150'
G[10797]='FA L20 A:100031363 T:22149'
G[10798]='FA L20 A:22149 T:22103 P:10797'
G[10799]='FA L20 A:22103 T:22103 P:10798'
G[10800]='FA L20 A:22103 T:22103 P:10799'
G[10801]='FA L20 A:22103 T:22149 P:10800'
G[10802]='FA L20 A:22149 T:22149 P:10801'
G[10803]='FA L20 A:22150 T:22150'
G[10804]='L25 A:22113 T:22113'
G[10805]='FA L20 A:22103 T:22103 P:10818'
G[10806]='FA L20 A:22103 T:22103 P:10805'
G[10807]='L25 A:21953 T:21953'
G[10808]='L25 A:22024 T:22024 P:10782'
G[10809]='FH L10 A:1185166 T:22107'
G[10810]='L20 A:100031384 T:22020'
G[10811]='L25 A:22113 T:21657 P:10804'
G[10812]='L20 A:22020 T:22127 P:10810'
G[10813]='FH L10 A:22231 T:22231 P:10809'
G[10814]='L25 A:21657 T:21657 P:10811'
G[10815]='L25 E31961'
G[10816]='L25 A:21822 T:21822 P:10619'
G[10817]='L25 A:21953 T:21953 P:10807'
G[10818]='FA L20 A:22149 T:22103 P:10802'
G[10819]='L20 A:22127 T:1185165 P:10812'
G[10820]='L20 A:1185165 T:1185165 P:10819'
G[10821]='L20 A:1185165 T:22127 P:10820'
G[10822]='K1 L25 A:22211 T:22211 P:T3A641999+t3A683999+10656|10824'
G[10823]='K1 L25 A:22211 T:22211 P:T3A641999+t3A683999+10656|10824'
G[10824]='L25 A:22211 T:22211 P:T3A641999+t3A683999+10551|10552 I:10656'
G[10825]='L20 A:100031489 T:22007'
G[10826]='L25 A:22214 T:22214 P:T3A441999+t3A483999+10551|10552'
G[10827]='SP K1 L25 A:22214 T:22214 P:10826+T3A441999+t3A483999'
G[10828]='SP K1 L25 A:22214 T:22214 P:10826+T3A441999+t3A483999'
G[10829]='L20 A:22007 T:22215 P:10825'
G[10830]='L20 A:22215 T:22215 P:10829'
G[10832]='L20 E32305'
G[10833]='L20 E32305'
G[10834]='FH L10 A:22231 T:22231 P:10813'
G[10835]='FH L10 A:21279 T:16588 P:10538'
G[10836]='L25 A:21657 T:21657 P:10814'
G[10837]='L25 A:21657 T:21657 P:10836'
G[10838]='FH L10 A:16588 T:16588 P:10864'
G[10839]='L15 A:22272 T:22272 P:10849'
G[10840]='L15 A:22278 T:22278 P:10852'
G[10842]='L15 A:22278 T:22278 P:10852'
G[10843]='FH L20 N30 A:22004 T:22004 P:10846'
G[10845]='FH L20 N30 A:22004 T:22004 P:10843'
G[10846]='FH L20 N30 A:22004 T:22004 P:10565'
G[10847]='L15 A:22292 T:22292 O:10862,10863,10908'
G[10848]='L15 A:22272 T:22272 P:10839'
G[10849]='L15 A:22292 T:22272 P:10847'
G[10850]='K1 L25 A:22293 T:22293'
G[10851]='FH L20 N30 A:22312 T:22312 P:10846'
G[10852]='L15 A:22365 T:22365 P:10849'
G[10853]='FH L20 A:22312 T:22312 P:10851'
G[10854]='L25 A:21657 T:21657 P:10837'
G[10855]='L25 A:20471 T:20471'
G[10856]='L25 A:20471 T:20471 P:10855'
G[10857]='L25 A:20471 T:20471 P:10856'
G[10858]='K512 L25 A:21657 T:22112 P:10854'	-- PM5
G[10859]='FH L20 A:22312 T:22312 P:10853'
G[10860]='FH L20 N30 A:21088 T:21088'
G[10861]='L15 A:22272 T:22272 P:10848'
G[10862]='FH L15 A:18386 T:22292 I:10863'	-- reported not I:10908
G[10863]='FA L15 A:15991 T:22292 I:10862'	-- reported not I:10908
G[10864]='FH L10 A:16588 T:16588 P:10835'
G[10865]='FH L20 A:22312 T:22004 P:10859'
G[10866]='K512 L25 A:22112 T:22112 P:10858'	-- PM5
G[10867]='FH L20 A:22004 T:22312 P:10865'
G[10868]='FH L15 A:18712 T:18712'
G[10869]='FA L15 A:18713 T:18713'
G[10870]='L25 A:22112 T:22113 P:10866'
G[10871]='FA L25 RH A:22112 T:22113'
G[10872]='FA K512 L25 RH A:22112 T:22112'	-- PM5
G[10873]='L15 A:22364 T:22364'
G[10874]='L15 A:22272 T:22272 P:10861'
G[10875]='FH L10 A:16588 T:3230 P:10838'
G[10876]='FH L10 A:3230 T:3230 P:10875'
G[10877]='L15 A:22456 T:22456'
G[10878]='L15 A:22370 T:22370'
G[10879]='L15 A:22373 T:22292 P:10889'
G[10880]='L15 A:100031707 T:22370'
G[10881]='L15 A:22370 T:22370 P:10880'
G[10882]='L17222 A:18481 T:18481 P:10704 Z15211'
G[10883]='L30 A:18166 T:18481 P:10588'
G[10884]='K64 L30 A:18481 T:18481 P:10588'
G[10885]='K64 L30 A:18481 T:18481 P:10588'
G[10886]='K64 L30 A:18481 T:18481 P:10588'
G[10887]='L15 A:22377 T:22370'
G[10888]='L30 E31961'
G[10889]='L15 A:22272 T:22292 P:10874'
G[10893]='L20 A:22386 T:22386 P:10894'
G[10894]='L20 A:22007 T:22386 P:10719'
G[10895]='L10 A:19409 T:19409'
G[10896]='L15 A:22420 T:22420'
G[10898]='L15 A:22424 T:22292'
G[10900]='FH L10 M070 A:22421 T:22421'
G[10901]='L30 E31961'
G[10902]='L35 E31961'
G[10903]='FA L10 A:21133 T:22430 P:10485'
G[10904]='L20 A:22423 T:22423 P:10910'
G[10908]='L15 A:22272 T:22292'	-- reported not I:10862,10863
G[10909]='FA L10 A:22430 T:22430 P:10903'
G[10910]='L20 A:22127 T:22423 P:10821'
G[10911]='L20 A:22423 T:22423 P:10904'
G[10912]='L20 A:22423 T:22127 P:10911'
G[10913]='L15 A:22446 T:22446'
G[10914]='L15 A:22446 T:22446 P:10913'
G[10915]='L15 A:22446 T:22446 P:10914'
G[10916]='FA L10 A:22430 T:22430 P:10903'
G[10917]='L15 A:22429 T:22429'
G[10918]='K1 L15 A:22429 T:22429 P:10917'
G[10919]='SP K1 L10 A:20206 T:20206 P:B10916'
G[10920]='L15 A:22462 T:22462'
G[10921]='L15 A:22462 T:22462 P:10920'
G[10922]='L15 A:22458 T:22481'
G[10923]='L15 A:22456 T:22456 P:10877'
G[10924]='L25 A:22479 T:22479'
G[10926]='L15 A:22462 T:22364 P:10921'
G[10927]='L20 A:22488 T:21158'
G[10928]='L20 A:22489 T:21147'
G[10929]='L15 A:22481 T:22481 P:10922'
G[10930]='L15 A:22481 T:22481 P:10929'
G[10935]='FA L10 A:22430 T:22430 P:10909+10916'
G[10936]='FA L10 A:22430 T:16819 P:10935'
G[10937]='FA L10 A:16819 T:16819 P:10936'
G[10938]='L326 A:100031890 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[10939]='L326 A:100031891 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[10940]='L326 A:100031907 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[10941]='L326 A:100031914 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[10942]='HC FH L15360 A:22819 T:22914'
G[10943]='HC FA L7879680 A:22819 T:22818'
G[10944]='L30 A:22820 T:21700'
G[10945]='HC FH L7879680 A:22914 T:22823 P:10942'
G[10946]='L30 A:21700 T:21700 P:10944'
G[10947]='L30 A:21700 T:21700 P:10946'
G[10948]='L30 A:21700 T:18481 P:10947'
G[10949]='L30 A:18481 T:18528 P:10948'
G[10950]='HC FA L7879680 A:22818 T:22818 P:10943'
G[10951]='HC FH L7879680 A:22914 T:22914 P:10942'
G[10952]='HC FA L7879680 A:22818 T:500013 P:10943'
G[10953]='HC FH L7879680 A:22914 T:18072 P:10942'
G[10954]='HC FA L7879680 A:22818 T:22836 P:10943'
G[10956]='HC FA L7879680 A:22818 T:17538 P:10950+10952+10954'
G[10957]='L30 A:23158 T:23158 P:10958'
G[10958]='L30 A:18528 T:23158 P:10985,13429'
G[10959]='L30 A:23158 T:23158 P:10957'
G[10962]='HC FA L7879680 A:22818 T:500014 P:10950+10952+10954'
G[10963]='HC FH L7879680 A:22914 T:22914 P:10945+10953+10951'
G[10966]='HC FA L7879680 A:22818 T:22819 P:10968+10962'
G[10967]='HC FH L7879680 A:22914 T:22819 P:10963+11975'
G[10968]='HC FA L15360 A:17538 T:17204 P:10956'
G[10969]='L25 A:22899 T:20448'
G[10970]='L25 A:20448 T:20448 O:10969'
G[10971]='L25 A:20448 T:20448'
G[10972]='L25 E31961'
G[10973]='L25 A:20448 T:20448'
G[10974]='L25 A:20448 T:22919 P:10973'
G[10975]='K1 L25 A:22919 T:22919'
G[10976]='L25 A:22919 T:22919'
G[10977]='L25 A:22919 T:22919 P:10976'
G[10981]='K1 L25 A:22919 T:22919'
G[10982]='L25 A:22919 T:22919'
G[10983]='L20 A:22940 T:22941 O:10984 I:10989'
G[10984]='L20 A:22497 T:22940'
G[10985]='L30 A:18528 T:18528 P:10949 I:13429'
G[10989]='L20 A:22995 T:22941 I:10983'
G[10995]='L20 A:22941 T:22941 P:10989'
G[10996]='L20 A:22941 T:22941 P:10989'
G[10997]='L20 A:22941 T:22941 P:10989'
G[10998]='L20 A:22941 T:22941 P:10995+10996+10997'	-- TODO: Verify requires 10995 10996
G[11000]='L20 A:22941 T:22941 P:10998'
G[11001]='L1 E32305'
G[11002]='fA L30 A:100032385 T:16819'
G[11003]='fH L30 A:100032386 T:3230'
G[11004]='L15 A:23042 T:23042'
G[11005]='L15 A:23038 T:23038 P:11004'
G[11006]='SP K1 L15 A:23042 T:23042 P:11005'
G[11007]='L30 A:100032405 T:18481'
G[11008]='K2 L15 A:23048 T:23048'
G[11009]='L20 A:22941 T:23233 P:11022'	-- TODO: G55|Invalidated, Prerequisites, Ancestor invalidated|
G[11010]='L20 A:23120 T:23120'
G[11012]='L25 A:22113 T:22113 P:T3F741999+PR300'
G[11013]='L25 A:22113 T:23139 P:11012'
G[11014]='L25 A:23139 T:23140 P:11013'
G[11015]='K2 L25 A:23140 T:23140 P:T3F741999'
G[11016]='K2 L25 A:23140 T:23140 P:T3F741999+PS350 I:11017,11018'
G[11017]='K2 L25 A:23140 T:23140 P:T3F741999+PH350 I:11016,11018'
G[11018]='K2 L25 A:23140 T:23140 P:T3F741999+PM350 I:11016,11017'
G[11019]='L25 A:23141 T:23141 P:0'	-- TODO: Yoshimo: needs conditions, not friendly for me
G[11020]='K2 L25 A:23141 T:23141 P:11019+T3F741999'
G[11021]='L15 A:100032523 T:23038'
G[11022]='L20 A:23053 T:22941 P:1'	-- this is not immediately available...no supplicant about
G[11023]='K2 L20 A:23120 T:23120 P:11010,11102'
G[11024]='L15 A:23038 T:22292 P:11021'
G[11025]='L20 A:23233 T:23233'
G[11026]='L20 A:23253 T:23253 P:T40E50999'
G[11028]='L15 A:22292 T:23038 P:11024'
G[11029]='L15 A:23306 T:23306 P:11056'
G[11030]='L20 A:23316 T:23316'
G[11031]='K1 L1 A:18253 T:18253 Z22900'
G[11035]='K2 L25 A:23141 T:23141 P:11019+T3F741999'
G[11036]='FH L25 A:19471 T:19570 I:10183,11037,11040,11042,11038,11039'
G[11037]='FH L25 A:23265 T:19570 I:10183,11036,11040,11042,11038,11039'
G[11038]='L25 A:23270,23271 T:19466 P:10551+T3A441999,10552+T3A441999 I:10183,11036,11037,11040,11042'
G[11039]='L25 A:23272,23273 T:19468 P:10551+T3A641999,10552+T3A641999 I:10183,11036,11037,11040,11042'
G[11040]='FA L25 A:21112 T:19570 I:10183,11036,11037,11042,11038,11039'
G[11041]='K512 L25 A:100032621 T:23139 P:11014+T3F741999'	-- PM2
G[11042]='FA L25 A:23268 T:19570 P:T3D241999 I:10183,11036,11037,11040,11038,11039'
G[11043]='FA L25 A:21107 T:20510'
G[11044]='FA L25 A:23268 T:21357 P:T3D241999'
G[11045]='FA L25 A:19678 T:21774'
G[11046]='FH L25 A:19678 T:21772 I:11047,11048'
G[11047]='FH L25 A:23280 T:20494 I:11046,11048'
G[11048]='FH L25 A:18090 T:21359 I:11046,11047'
G[11049]='L25 A:23141 T:23141 P:11019+T3F741999'
G[11050]='K1 L25 A:23141 T:23141 P:11049+T3F741999'
G[11051]='K2 L20 A:23253 T:23253'
G[11052]='L25 A:21700 T:18481 P:0'	-- TODO: Yoshimo: according to wowhead no longer in the game and replaced by 10708
G[11053]='L25 A:23140 T:23139 P:T3F744999'
G[11054]='L25 A:23291 T:23291 P:11053+T3F744999'
G[11055]='K2 L25 A:23291 T:23291 P:11054+T3F744999'
G[11056]='L15 A:23306 T:23306 P:11028'
G[11057]='L20 A:23233 T:22941'
G[11058]='L20 A:23233 T:23233 P:11025'
G[11059]='L20 A:23233 T:23233'
G[11060]='K1 L1 A:23300 T:23300'
G[11061]='L20 A:23316 T:23316 P:11030'
G[11062]='L20 A:23233 T:23334'
G[11063]='L25 A:22433 T:22433 P:T3F750999'
G[11064]='L25 A:23340 T:22433 P:11063+T3F750999'
G[11065]='L20 A:23335 T:23335'
G[11066]='K2 L20 A:23335 T:23335 P:11065'
G[11067]='L25 A:23342 T:22433 P:11064+T3F750999'
G[11068]='L25 A:23344 T:22433 P:11067+T3F750999'
G[11069]='L25 A:23345 T:22433 P:11068+T3F750999'
G[11070]='L25 A:23346 T:22433 P:11069+T3F750999'
G[11071]='L25 A:23348 T:22433 P:11070+T3F750999'
G[11072]='K512 L15'
G[11073]='K512 L15 A:23038 T:23038 P:11072'	-- PM5
G[11074]='L15 T:23306 E31961'
G[11075]='L25 A:23140 T:23149 P:11053+T3F744999'
G[11076]='K2 L25 A:23149 T:23149 P:11075+T3F744999'
G[11077]='K2 L25 A:23376 T:23376 P:11075+T3F744999'
G[11078]='L20 A:23334 T:23334'
G[11079]='L20 A:23300 T:23300'
G[11080]='K2 L20 A:23233 T:23233 P:11058'
G[11081]='L25 A:100032726 T:23149 P:11075+T3F744999'
G[11082]='L25 A:23149 T:23149 P:11081+T3F744999'
G[11083]='L25 A:23166 T:23166 P:11075+T3F744999'
G[11084]='L25 A:23140 T:23139 P:T3F750999'
G[11085]='K2 L15 A:23383 T:23048'
G[11086]='K2 L25 A:23139 T:23139 P:11084+T3F750999'
G[11089]='L25 A:23427 T:23427 P:T3F750999'
G[11090]='L25 A:23427 T:23427 P:11089+T3F750999'
G[11091]='L20 A:23233 T:23428 P:T40E44999'
G[11092]='L25 A:23140 T:23139 P:T3F762999'
G[11093]='L15 A:23415 T:23415'
G[11094]='L25 A:23139 T:21955 P:11092+T3F762999+T3A644999'
G[11095]='L25 A:21955 T:23434 P:11094+T3F762999+T3A644999'
G[11096]='L15 A:23449 T:23449'
G[11097]='K514 L25 A:23434 T:23139 P:11095+T3F762999+T3A644999'	-- PM3
G[11098]='L15 A:23449 T:23048 P:11096'
G[11099]='L25 A:23139 T:21402 P:11092+T3F762999+T3A444999'
G[11100]='L25 A:21402 T:23452 P:11099+T3F762999+T3A444999'
G[11101]='K514 L25 A:23452 T:23139 P:11100+T3F762999+T3A444999'	-- PM3
G[11102]='L20 CD A:23120 T:23120 P:11010'
G[11103]='K1 L30 A:19935 T:19935'
G[11104]='K1 L30 A:19935 T:19935 P:10473'
G[11105]='K1 L30 A:19935 T:19935'
G[11106]='K1 L30 A:19935 T:19935'
G[11107]='L25 A:23140 T:23139 P:T3F783999'
G[11108]='L25 A:23139 T:23433 P:11107+T3F783999'
G[11109]='L25 A:23462 T:23462 P:11108+T3F783999 I:11110,11111,11112,11113,11114'
G[11110]='L25 A:23464 T:23464 P:11108+T3F783999 I:11109,11111,11112,11113,11114'
G[11111]='L25 A:23463 T:23463 P:11108+T3F783999 I:11109,11110,11112,11113,11114'
G[11112]='L25 A:23461 T:23461 P:11108+T3F783999 I:11109,11110,11111,11113,11114'
G[11113]='L25 A:23466 T:23466 P:11108+T3F783999 I:11109,11110,11111,11112,11114'
G[11114]='L25 A:23465 T:23465 P:11108+T3F783999 I:11109,11110,11111,11112,11113'
G[11117]='HB fA K16 L7864576 A:23486 T:23486 I:11431'
G[11118]='HB K16 L7864576 A:23486 T:23486'	-- note that this is not I: with 11120 for some reason
G[11119]='L20 A:23334 T:23473'
G[11120]='HB K16 L7864576 A:24657 T:24657'
G[11122]='HB FA K2 L7864576 A:23558 T:23558 P:11318'
G[11123]='FA L7715 E31961'
G[11124]='FH L15 E32305'
G[11129]='FH L1 A:23618 T:23618'
G[11130]='L70 E31961'
G[11131]='HW K2 L7864576 A:24519 T:24519 I:12135'
G[11132]='L70 E32305'
G[11135]='HW L19280 Z18505'
G[11137]='FA L15 E32305'
G[11142]='FA L15 E32305'
G[11146]='FA L15 E32305'
G[11153]='FA K2 L10 A:23895 T:23895'
G[11154]='FA L10 A:24227 T:24227'
G[11155]='FA L10 A:23773 T:23773'
G[11157]='FA L10 A:23749 T:23749'
G[11164]='L1 E31961'
G[11165]='L70 E31961'
G[11166]='L1 E31961'
G[11167]='FH L10 A:24126 T:24126'
G[11168]='FH L10 A:24126 T:24126 P:11167'
G[11170]='FH L10 A:24126 T:24126 P:11168'
G[11171]='L70 E32305'
G[11175]='FA L10 A:23831 T:23891'
G[11176]='FA L10 A:23891 T:24399 O:11175'
G[11177]='FA L15 E32305'
G[11179]='FA L10 E31961'
G[11180]='L15 E31961'
G[11181]='L15 E32305'
G[11182]='L10 A:23870 T:23870'
G[11187]='FA L10 A:23749 T:23888 P:11157'
G[11188]='FA L10 A:23888 T:23888 P:11187'
G[11190]='FA L10 A:23770 T:23770'
G[11192]='FA L7715 E31961'
G[11196]='K64 L35 A:52924 T:552924'
G[11199]='FA L10 A:23749 T:23906 P:11188'
G[11202]='FA L10 A:23906 T:23906 P:11199'
G[11208]='L15 A:23797 T:23572 P:27348'
G[11209]='FA L15 E32305'
G[11211]='L15 A:6546 T:23572 I:11215'
G[11212]='FA L15 A:4921 T:6546'
G[11213]='FH L15 A:4791 T:6546'
G[11214]='FA L15 E32305'
G[11215]='FH L15 A:4791 T:23572 I:11211'
G[11216]='L17478 A:23948 T:17613 Z22248'
G[11218]='FA L10 A:23976 T:23976 P:11188'
G[11219]='HW K2 L7864576 A:23973 T:23973'
G[11220]='HW L19280 Z18505'
G[11221]='FH L10 A:23780 T:23780 P:11270'
G[11224]='FA L10 A:23978 T:23978 P:11188'
G[11225]='FH L15 E32305'
G[11227]='FH L10 A:23938 T:23938'
G[11228]='FA L10 A:23547 T:23546'
G[11229]='FH L10 A:23780 T:24037 P:11221'
G[11230]='FH L10 A:24037 T:24037 P:11229'
G[11231]='FA L10 A:24038 T:24038 P:11250'	-- TODO: is also 11249 needed?
G[11232]='FH L10 A:24037 T:23778 P:11230'
G[11233]='FH L10 A:23778 T:23778 P:11232'
G[11234]='FH L10 A:23778 T:23780 P:11233'
G[11235]='FA L10 A:23749 T:23749 P:11250'
G[11236]='FA L10 A:23749 T:23749 P:11235'
G[11237]='FA L10 A:100033289 T:23888'
G[11238]='FA L10 A:23888 T:23888 P:11237'
G[11239]='FA L10 A:24038 T:24038 P:11231'
G[11240]='FA L10 A:23976 T:23976 P:11218'
G[11241]='FH L10 A:23784 T:24126'
G[11242]='HW FA L7879680 A:23904 T:24519 Z18505'
G[11243]='FA L10 A:23546 T:23546 P:11228'
G[11244]='FA L10 A:23546 T:23546 P:11243'
G[11245]='FA L10 A:24060 T:24060 P:11248'
G[11246]='FA L10 A:24060 T:24060 P:11248'
G[11247]='FA L10 A:24060 T:24060 P:11248'
G[11248]='FA L10 A:23749 T:24060 P:11332'
G[11249]='FA L10 A:100033314 T:24038'
G[11250]='FA L10 A:24060 T:23749 P:11245+11246+11247'
G[11251]='L10 A:24106 T:24111'	-- something is not letting Nimhfree get this so I assume there is an I code needed here
G[11252]='L17479 A:24111 T:23546 P:11251 Z20338'
G[11253]='FH L10 A:23938 T:1186585 P:11227'
G[11254]='FH L10 A:1186585 T:23780 P:11253'
G[11255]='FA L10 A:23546 T:23546 P:11244'
G[11256]='FH L10 A:24129 T:24130 P:11281'
G[11257]='FH L10 A:24130 T:24130 P:11256'
G[11258]='FH L10 A:24130 T:24130 P:11256'
G[11259]='FH L10 A:24130 T:24130 P:11256'
G[11260]='FH L10 A:100033345 T:24135'
G[11261]='FH L10 A:24130 T:24129 P:11257+11258+11259'
G[11262]='FH L10 A:24137 T:23780'
G[11263]='FH L10 A:24129 T:24129 P:11261'
G[11264]='FH L10 A:24129 T:24129 P:11263'
G[11265]='FH L10 A:24135 T:24135 P:11261'
G[11266]='FH L10 A:100033347 T:24032'
G[11267]='FH L10 A:24032 T:24032 P:11266'
G[11268]='FH L10 A:24135 T:24135 P:11265'
G[11269]='FA L10 A:24139 T:24139'
G[11270]='FH L10 A:23780 T:23780'
G[11271]='FH L10 A:24127 T:24127'
G[11272]='L10 A:23780 T:23780'
G[11273]='FA L10 A:23548 T:24122 P:11244'
G[11274]='FA L10 A:24122 T:24145 P:11273'
G[11275]='FH L10 A:24123 T:24123'
G[11276]='FA L10 A:24145 T:24150 P:11274'
G[11277]='FA L10 A:24150 T:24150 P:11276'
G[11278]='FA L10 A:24150 T:23548 P:11300'
G[11279]='FH L10 A:24157 T:24157'
G[11280]='FH L10 A:24157 T:24157 P:11279'
G[11281]='FH L10 A:24123 T:24123 P:11275'
G[11282]='FH L10 A:24027 T:24027 P:11295'
G[11283]='FH L10 A:24027 T:24027 P:11282'
G[11284]='FA L10 A:24176 T:24176'
G[11285]='FH L10 A:24027 T:24027 P:11282'
G[11286]='FH L10 A:24186 T:24186 P:11287'
G[11287]='FH L10 A:24135 T:24186 P:11261'
G[11288]='FA L10 A:24189 T:24189'
G[11289]='FA L10 A:24189 T:24191 P:11288'
G[11290]='FA L10 A:23546 T:23546 P:11255'
G[11291]='FA L10 A:23546 T:23749 P:11290'
G[11292]='FA L10 A:24131 T:24131'
G[11293]='HB FA K2 L7864576 A:23627 T:23627 P:11318 I:11294'
G[11294]='HB FA K2 L7864576 A:23628 T:23628 P:11318 I:11293'
G[11295]='FH L10 A:23780 T:24027 P:11254'
G[11296]='FH L10 A:24209 T:24209'
G[11297]='FH L10 A:24234 T:24152 P:11271'
G[11298]='FH L10 A:24152 T:24152 P:11297'
G[11299]='FA L10 A:24150 T:24151 P:11277'
G[11300]='FA L10 A:24151 T:24150 P:11299'
G[11301]='FH L10 A:24218 T:24218'
G[11302]='FA L10 A:24282 T:24117 P:11329'
G[11303]='FH L10 A:24027 T:24458 P:11283+11285'	-- TODO: Verify requires 11283
G[11304]='FH L10 A:24126 T:24251 P:11170'
G[11305]='FH L10 A:24251 T:24251 P:11304'
G[11306]='FH L10 A:24251 T:24251 P:11305'
G[11307]='FH L10 A:24251 T:24251 P:11306'
G[11308]='FH L10 A:24251 T:24252 P:11307'
G[11309]='FH L10 A:24252 T:24252 P:11308'
G[11310]='FH L10 A:24252 T:24252 P:11309'
G[11311]='FH L10 A:24256 T:24256'
G[11312]='FH L10 A:24123 T:24117 P:11271'
G[11313]='L10 A:24117 T:24117 O:11302,11312'
G[11314]='L10 A:24117 T:24117 P:11313'
G[11315]='L10 A:24117 T:24117 P:11313'
G[11316]='L10 A:24117 T:24117 P:11314+11315'
G[11317]='FH L10 A:24186 T:24186 P:11286'
G[11318]='HB FA K16 L7864576 A:23558 T:23558'
G[11319]='L10 A:24117 T:24117 P:11314+11315'
G[11321]='FA L7864576 E32305'
G[11322]='FA L10 A:24273 T:24273'
G[11323]='FH L10 A:24186 T:24261 P:11317'
G[11324]='FH L10 A:24261 T:24186 P:11417'
G[11325]='FA L10 A:24273 T:24261 P:11322'
G[11326]='FA L10 A:24261 T:24273 P:11416'
G[11327]='FA L10 A:23906 T:23906 P:11202'
G[11328]='FA L10 A:23906 T:24283 P:11327'
G[11329]='FA L10 A:24056 T:24056'
G[11330]='FA L10 A:24283 T:24283 P:11328'
G[11331]='FA L10 A:24283 T:23749 P:11330'
G[11332]='FA L10 A:23749 T:23749 P:11331'
G[11333]='FA L10 A:23975 T:23975 P:11244'
G[11334]='L1 E31961'
G[11335]='FA L18177 E31961'
G[11336]='FA L18177 E31961'
G[11337]='FA L18177 E31961'
G[11338]='FA L18177 E31961'
G[11339]='FH L18177 E31961'
G[11340]='FH L18177 E31961'
G[11341]='FH L18177 E31961'
G[11342]='FH L18177 E21691'
G[11343]='FA L10 A:23975 T:23975 P:11333'
G[11344]='FA L10 A:23975 T:23975 P:11343'
G[11346]='FA L10 A:24328 T:24328 P:11329'
G[11348]='FA L10 A:24328 T:24328 P:11349 I:11352'
G[11349]='FA L10 A:24328 T:24328 P:11346'
G[11350]='FH L10 A:24362 T:24362 P:11271'
G[11351]='FH L10 A:24362 T:24362 P:11350'
G[11352]='FH L10 A:24362 T:24362 P:11351 I:11348'
G[11354]='K66 L30 A:24369 T:24369 I:11362,11363,11368,11369,11370,11372,11373,11374,11375,11378,11382,11384,11386,11388,11499 Z15595'
G[11355]='FA L10 A:24376 T:24376 P:11329'
G[11356]='HW FA L7864576 A:18927,518927,500091,500092,500093,500094,500095,19148,19171,19173,20102,520102,500106,500107,500108,500109,500110,500111,500112,500113,500114,500115,500116,500117,500118,500119,500120,500121,500122,500123,500124,500125,500126,500127,500128,500129,500130 T:24519'
G[11357]='HW FH L7864576 A:19169,519169,500099,500100,500101,500102,500103,500104,19175,519175,19176,519176,19177,519177,500105,19178,519178,20102,520102,500106,500107,500108,500109,500110,500111,500112,500113,500114,500115,500116,500117,500118,500119,500120,500121,500122,500123,500124,500125,500126,500127,500128,500129,500130 T:23973'
G[11358]='FA L10 A:24376 T:24376 P:11355'
G[11359]='FA L10 A:24376 T:24376 P:11358 I:11367'
G[11360]='HW L7864576 A:24519 T:24519 O:11356 I:11439,11440'
G[11361]='HW L7864576 A:23973 T:23973 I:11449,11450'
G[11362]='K66 L30 A:24369 T:24369 I:11354,11363,11368,11369,11370,11372,11373,11374,11375,11378,11382,11384,11386,11388,11499 Z15595'
G[11363]='K66 L30 A:24369 T:24369 I:11354,11362,11368,11369,11370,11372,11373,11374,11375,11378,11382,11384,11386,11388,11499 Z15595'
G[11364]='K66 L20 A:24370 T:24370 I:11371,11376,11383,11385,11387,11389,11500 Z15595'
G[11365]='FH L10 A:24390 T:24390 P:11271'
G[11366]='FH L10 A:24390 T:24390 P:11365'
G[11367]='FH L10 A:24390 T:24390 P:11366 I:11359'
G[11368]='K66 L30 A:24369 T:24369 I:11354,11362,11363,11369,11370,11372,11373,11374,11375,11378,11382,11384,11386,11388,11499 Z15595'
G[11369]='K66 L30 A:24369 T:24369 I:11354,11362,11363,11368,11370,11372,11373,11374,11375,11378,11382,11384,11386,11388,11499 Z15595'
G[11370]='K66 L30 A:24369 T:24369 I:11354,11362,11363,11368,11369,11372,11373,11374,11375,11378,11382,11384,11386,11388,11499 Z15595'
G[11371]='K66 L20 A:24370 T:24370 I:11364,11376,11383,11385,11387,11389,11500 Z15595'
G[11372]='K66 L30 A:24369 T:24369 I:11354,11362,11363,11368,11369,11370,11373,11374,11375,11378,11382,11384,11386,11388,11499 Z15595'
G[11373]='K66 L30 A:24369 T:24369 I:11354,11362,11363,11368,11369,11370,11372,11374,11375,11378,11382,11384,11386,11388,11499 Z15595'
G[11374]='K66 L30 A:24369 T:24369 I:11354,11362,11363,11368,11369,11370,11372,11373,11375,11378,11382,11384,11386,11388,11499 Z15595'
G[11375]='K66 L30 A:24369 T:24369 I:11354,11362,11363,11368,11369,11370,11372,11373,11374,11378,11382,11384,11386,11388,11499 Z15595'
G[11376]='K66 L20 A:24370 T:24370 I:11364,11371,11383,11385,11387,11389,11500 Z15595'
G[11377]='K2 L30 A:24393 T:24393 P:PC275 I:11379,11380,11381'
G[11378]='K66 L30 A:24369 T:24369 I:11354,11362,11363,11368,11369,11370,11372,11373,11374,11375,11382,11384,11386,11388,11499 Z15595'
G[11379]='K2 L30 A:24393 T:24393 P:PC275 I:11377,11380,11381'
G[11380]='K2 L30 A:24393 T:24393 P:PC275 I:11377,11379,11381'
G[11381]='K2 L30 A:24393 T:24393 P:PC275 I:11377,11379,11380'
G[11382]='K66 L30 A:24369 T:24369 I:11354,11362,11363,11368,11369,11370,11372,11373,11374,11375,11378,11384,11386,11388,11499 Z15595'
G[11383]='K66 L25 A:24370 T:24370 I:11364,11371,11376,11385,11387,11389,11500 Z15595'
G[11384]='K66 L30 A:24369 T:24369 I:11354,11362,11363,11368,11369,11370,11372,11373,11374,11375,11378,11382,11386,11388,11499 Z15595'
G[11385]='K66 L20 A:24370 T:24370 I:11364,11371,11376,11383,11387,11389,11500 Z15595'
G[11386]='K66 L30 A:24369 T:24369 I:11354,11362,11363,11368,11369,11370,11372,11373,11374,11375,11378,11382,11384,11388,11499 Z15595'
G[11387]='K66 L20 A:24370 T:24370 I:11364,11371,11376,11383,11385,11389,11500 Z15595'
G[11388]='K66 L30 A:24369 T:24369 I:11354,11362,11363,11368,11369,11370,11372,11373,11374,11375,11378,11382,11384,11386,11499 Z15595'
G[11389]='K66 L25 A:24370 T:24370 I:11364,11371,11376,11383,11385,11387,11500 Z15595'
G[11390]='FA L10 A:24399 T:24399 P:11176'
G[11391]='FA K2 L10 A:24399 T:24399 P:11390'
G[11392]='HW L19280 Z18505'
G[11393]='FA L10 A:23891 T:23833'
G[11394]='FA L10 A:23833 T:23833 O:11393'
G[11395]='FA L10 A:100033961 T:23833'
G[11396]='FA L10 A:23833 T:23833 P:11395'
G[11397]='FH L10 A:24359 T:24359'
G[11398]='FH L10 A:100033962 T:24359'
G[11399]='FH L10 A:24359 T:24359 P:11398'
G[11400]='FA L7869440 E31961'
G[11401]='HW K512 L7883520 Z18505'	-- PM5
G[11402]='L15684 E32305'
G[11403]='HW FH L7879680 A:23904 T:23973'
G[11404]='HW FA K512 L7883520 Z18505'	-- PM5
G[11405]='HW K512 L19200 Z18505'	-- PM5
G[11406]='FA L10 A:24494 T:24139 P:11332'
G[11407]='HB FH K2 L7864576 A:24498 T:24498 P:11409 I:11408'
G[11408]='HB FH K2 L7864576 A:24499 T:24499 P:11409 I:11407'
G[11409]='HB FH K16 L7864576 A:24497 T:24497'
G[11410]='FA L10 A:24056 T:24056 P:11329'
G[11411]='FH L10 A:24125 T:24129 Z25860'
G[11412]='HB FH K2 L7864576 A:24497 T:24497 P:11409'
G[11414]='FA L10 A:24261 T:24261 P:11325'
G[11415]='FH L10 A:24261 T:24261 P:11323'
G[11416]='FA L10 A:24261 T:24261 P:11414'
G[11417]='FH L10 A:24261 T:24261 P:11415'
G[11418]='FA L10 A:24139 T:24139 P:11269'
G[11419]='FH L7869440 E31961'
G[11420]='FA L10 A:23728 T:23728 P:11244'
G[11421]='FA L10 A:24634 T:24634 P:11430'
G[11422]='L10 A:24544 T:24544'
G[11423]='L10 A:24548 T:24548'
G[11424]='L10 A:24252 T:24252'
G[11426]='FA L10 A:23728 T:23728 P:11420'
G[11427]='FA L10 A:23728 T:24634 P:11426'
G[11428]='L10 A:24117 T:24117 P:11316'
G[11429]='FA L10 A:24634 T:24634 P:11427'
G[11430]='FA L10 A:24634 T:24634 P:11429'
G[11431]='HB FH K16 L7864576 A:24657 T:24657 I:11117'
G[11432]='FA L10 A:23888 T:23888 P:11231'
G[11433]='FH L10 A:24127 T:24127 P:11265'
G[11434]='L10 A:24537 T:24537 P:11509'
G[11436]='FA L10 A:24634 T:23728 P:11421'
G[11439]='HW L7864576 A:24519 T:24519 O:11356 I:11360,11440'
G[11440]='HW L7864576 A:24519 T:24519 O:11356 I:11360,11439'
G[11441]='HB FA K16 L7864576 A:18927,518927,500091,500092,500093,500094,500095,19148,19171,519171,500096,500097,500098,19172,19173 T:24710 I:11442,11446,11447'
G[11442]='SP HB FA K16 L7864576 A:24710 T:24710 I:11441,11446,11447'
G[11443]='L10 A:23730 T:23730'
G[11446]='HB FH K16 L7864576 A:19169,519169,500099,500100,500101,500102,500103,500104,19175,519175,19176,519176,19177,519177,500105,19178,519178,20102,520102,500106,500107,500108,500109,500110,500111,500112,500113,500114,500115,500116,500117,500118,500119,500120,500121,500122,500123,500124,500125,500126,500127,500128,500129,500130 T:24711 I:11441,11442,11447'
G[11447]='SP HB FH K16 L7864576 A:24711 T:24711 I:11441,11442,11446'
G[11448]='FA L10 A:23548 T:24717 P:11278 O:11478'
G[11449]='HW L7864576 A:23973 T:23973 I:11361,11450'
G[11450]='HW L7864576 A:23973 T:23973 I:11361,11449'
G[11451]='fA L15 A:24729 T:24727'
G[11452]='FA L10 A:100034090 T:23749'
G[11453]='FH L10 A:100034091 T:24129'
G[11454]='L12340 E31961'
G[11455]='L10 A:24537 T:24537 P:11434'
G[11456]='L10 A:24755 T:24755'
G[11457]='L10 A:24755 T:24755 P:11456'
G[11458]='L10 A:24755 T:24755 P:11457'
G[11459]='L10 A:24525 T:24537 P:11473'
G[11460]='FA L10 A:24750 T:24750'
G[11464]='L10 A:24541 T:24541 P:11434'
G[11465]='FA L10 A:24750 T:24750 P:11460'
G[11466]='L10 A:24541 T:24541 P:11464'
G[11467]='L10 A:24541 T:24541 P:11466'
G[11468]='FA L10 A:24750 T:24750 P:11465'
G[11469]='L10 A:24784 T:24784'	-- TODO: need to verify if 11509 needs to be done first
G[11470]='FA L10 A:24750 T:24750 P:11468'
G[11471]='L10 A:24741 T:24741 P:11480'
G[11472]='K2 L10 A:24810 T:24810 P:11469'
G[11473]='L10 A:24537 T:24525 P:11455'
G[11474]='L10 A:24717 T:24807 P:11448 I:11475'
G[11475]='FA L10 A:24807 T:24807 O:11474'	-- if one has 11474, this will not be available until that turned in
G[11476]='L10 A:24537 T:24525 P:11459'
G[11477]='FA L10 A:24811 T:24811'
G[11478]='L10 A:24811 T:24717'
G[11479]='L10 A:24525 T:24537 P:11476'
G[11480]='L10 A:24537 T:24741 P:11479'
G[11481]='L25 A:18537 T:24967 P:T3A441999'
G[11482]='L25 A:18594 T:24967 P:T3A641999'
G[11483]='FA L10 A:24807 T:24807 P:11475'
G[11484]='FA L10 A:24807 T:24807 P:11475'
G[11485]='FA L10 A:24807 T:24807 P:11484'	-- TODO: does this also require 11483?
G[11488]='L70 A:24813 T:24822 P:11481,11482 Z16135'
G[11489]='FA L10 A:24807 T:24807 P:11485'
G[11490]='L25 A:24822 T:24848 P:11488 Z16135'
G[11491]='FA L10 A:24807 T:24807 P:11489'
G[11492]='L70 A:24848 T:24813 P:11490 Z16135'
G[11494]='FA L10 A:24807 T:24807 P:11491'
G[11495]='FA L10 A:24807 T:24807 P:11491'
G[11496]='L25 E31961'
G[11497]='FA L25 E31961'
G[11498]='FH L25 E31961'
G[11499]='K66 L30 A:24369 T:24369 I:11354,11362,11363,11368,11369,11370,11372,11373,11374,11375,11378,11382,11384,11386,11388 Z15595'
G[11500]='K66 L25 A:24370 T:24370 I:11364,11371,11376,11383,11385,11387,11389 Z15595'
G[11501]='FA L10 A:24807 T:23749 P:11495'	-- TODO: does this also require 11494?
G[11502]='K258 L15 A:24866 T:24866 P:T3D241999'
G[11503]='K258 L15 A:24881 T:24881'
G[11504]='L10 A:23804 T:23804 O:11573'
G[11505]='K258 L16143 A:24885 T:24885'
G[11506]='K258 L16143 A:24886 T:24886'
G[11507]='L10 A:23804 T:24755 P:11504'
G[11508]='L10 A:24755 T:24643 P:11507'
G[11509]='L10 A:24643 T:24539 P:11508'
G[11510]='L10 A:24539 T:24539 P:11509'
G[11511]='L10 A:24539 T:23804 P:11510'
G[11512]='L10 A:24539 T:23804 P:11510'
G[11513]='K2 L25 A:24932 T:24932'	-- this is replaced by 11514 after the portal to the Sunwell opens
G[11514]='K2 L25 A:24932 T:24932'
G[11515]='K2 L25 A:24937 T:24937 P:11526'
G[11516]='K2 L25 A:24937 T:24937 P:11526'
G[11517]='L25 E31961'
G[11519]='L10 A:24539 T:24910 P:11510'
G[11520]='L25 E31961'
G[11521]='K2 L25 A:24975 T:24975'
G[11523]='K2 L25 A:24967 T:24967'
G[11524]='L25 E31961'
G[11525]='K2 L25 A:24965 T:24965'
G[11526]='L25 A:24967 T:24937'
G[11527]='L10 A:24910 T:24910 P:11519'
G[11528]='L7866880 E31961'
G[11529]='L10 A:24910 T:24910 P:11527'
G[11530]='L10 A:24910 T:23804 P:11529'
G[11531]='L10 A:100034469 T:17634 P:PF001'
G[11532]='K2 L25 E32305'
G[11533]='K2 L25 A:25057 T:25057'
G[11534]='L25 A:25034 T:24932'	-- probably no longer available after the portal to the Sunwell opens
G[11535]='L25 E32305'
G[11536]='K2 L25 A:25046 T:25046'
G[11537]='K2 L25 A:25061 T:25061'
G[11538]='K2 L1 E31961'
G[11539]='K2 L25 E32305'
G[11540]='K2 L25 A:25069 T:25069'
G[11541]='K2 L25 A:25088 T:25088'
G[11542]='K2 L25 E32305'
G[11543]='K2 L25 A:25108 T:25108'
G[11544]='K2 L25 A:25046 T:25046'
G[11546]='K2 L25 A:24975 T:24975'
G[11547]='K2 L25 A:25133 T:25133'
G[11548]='K2 L25 A:25112 T:25112'
G[11549]='L25 A:25163 T:25163 P:T43583999'
G[11550]='fA L30 E31961'
G[11554]='L25 A:25032 T:25032 P:T43544999'
G[11555]='L25 A:25032 T:25032 P:T43550999'
G[11556]='L25 A:25032 T:25032 P:T43562999'
G[11557]='L25 A:25032 T:25032 P:T43583999'
G[11558]='FH L1 E31961'
G[11559]='L10 A:25197 T:25206 P:11571'
G[11560]='L10 A:25197 T:25197 P:11559'
G[11561]='L10 A:25199 T:25199 P:11559'
G[11562]='L10 A:25197 T:25205 P:11560'
G[11563]='L10 A:25205 T:25205 P:11562'
G[11564]='L10 A:25211 T:25211 P:11562'
G[11565]='L10 A:25205 T:25197 P:11563'
G[11566]='L10 A:25197 T:25197 P:11565'
G[11567]='L10 A:24539 T:23804 P:11510'
G[11568]='L10 A:23804 T:23804 P:11530+11567+11512+11511'
G[11569]='L10 A:28375 T:28375'
G[11570]='L10 A:25208 T:25197'
G[11571]='L10 A:25197 T:25197 P:11702,11704'
G[11572]='L10 A:23804 T:24755 P:11568'
G[11573]='FA L10 A:25233 T:23804'
G[11574]='L10 A:25247 T:25262 P:11595,11596,11597'
G[11575]='L10 A:25249 T:25262 P:T41A44999'
G[11576]='L10 A:25291 T:25291'
G[11580]='SP HM FA L7864576 A:1187559 T:1187559'
G[11581]='SP HM FH L7864576 A:1187564'
G[11582]='L10 A:25291 T:25291 P:11576'
G[11583]='SP HM FA L7864576 A:25910 T:25910'
G[11584]='SP HM FH L7864576 A:25939 T:25939'
G[11585]='FH L10 A:25273 T:25237 O:28711'	-- troll druid
G[11586]='FH L10 A:25273 T:25237 P:1'
G[11587]='L10 A:25262 T:25262 O:11574,11575'
G[11590]='L10 A:25262 T:25262 P:11587'
G[11591]='FH L10 A:25326 T:25336'
G[11592]='FH L10 A:25335 T:25326'
G[11593]='FH L10 A:25336 T:25336'
G[11594]='FH L10 A:25336 T:25336 O:11591'
G[11595]='FH L10 A:25256 T:25279 P:1 I:11596,11597'
G[11596]='FH L10 A:25256 T:25279 P:11585 I:11595,11597'	-- troll druid
G[11597]='FH L10 A:25256 T:25279 P:1 I:11595,11596'
G[11598]='FH L10 A:25279 T:25279 P:11595,11596,11597'
G[11599]='FA L10 A:25251 T:25385 P:11927'
G[11600]='FA L10 A:25385 T:25251 P:11599'
G[11601]='FA L10 A:25251 T:25245 P:11600'
G[11602]='FH L10 A:25279 T:25279 P:11598'
G[11603]='FA L10 A:25245 T:25302 P:11601'
G[11604]='FA L10 A:25302 T:25395 P:11603'
G[11605]='L10 A:1187565 T:1187565'
G[11606]='L10 A:25327 T:25327 P:11595,11596,11597'
G[11607]='L10 A:1187565 T:1187565 P:11605'
G[11608]='L10 A:25327 T:25327 P:11606'
G[11609]='L10 A:1187565 T:1187565 P:11607'
G[11610]='L10 A:1187565 T:1187565 P:11609'
G[11611]='L10 A:25280 T:25280 P:11595,11596,11597'
G[11612]='L10 A:25292 T:25292'
G[11613]='L17418 A:25435 T:25435 O:12141'
G[11614]='FH L10 A:25394 T:25328 P:11598'
G[11615]='FH L10 A:25328 T:25394 P:11614'
G[11616]='FH L10 A:25394 T:25237 P:11615'
G[11617]='L10 A:25292 T:25292 P:11612'
G[11618]='FH L10 A:25237 T:25437 P:11616'
G[11619]='L10 A:25435 T:25435 P:11613'
G[11620]='L10 A:25435 T:25450 P:11619'
G[11621]='L10 E31961'
G[11622]='L10 E31961'
G[11623]='L10 A:25292 T:25292 P:11617'
G[11624]='FH L10 A:25339 T:25376 O:12486'
G[11625]='L10 A:25450 T:25450 P:11620'
G[11626]='L10 A:25450 T:25435 P:11625'
G[11627]='FH L10 A:25376 T:25376 P:11624'
G[11628]='FH L10 A:24703 T:24703 P:1'
G[11629]='FH L10 A:25376 T:25339 P:11649'
G[11630]='FH L10 A:24703 T:24703 P:11628'
G[11631]='FH L10 A:25339 T:25339 P:11629'
G[11632]='fH L10 A:100034777 T:25256'
G[11633]='FH L10 A:24703 T:24703 P:11630'
G[11634]='FH L10 A:25279 T:25289 P:11602'
G[11635]='FH L10 A:25339 T:25425 P:1'
G[11636]='FH L10 A:25289 T:25329 P:11634'
G[11637]='FH L10 A:25425 T:25425 P:11635'
G[11638]='FH L10 A:25425 T:25339 P:11637'
G[11639]='FH L10 A:25374 T:25374 P:1'
G[11640]='FH L10 A:24703 T:24703 P:11633'
G[11641]='FH L10 A:24706 T:24706 P:1'
G[11642]='FH L10 A:25329 T:25475 P:11636'
G[11643]='FH L10 A:25475 T:25475 P:11642'
G[11644]='FH L10 A:25475 T:25475 P:11642'
G[11645]='FA L10 A:25477 T:25477'
G[11646]='L10 A:25262 T:25480 P:11590'
G[11647]='FH L10 A:24709 T:24709 P:1'
G[11648]='L10 A:25480 T:25480 P:11646'
G[11649]='FH L10 A:25376 T:25376 P:11627'
G[11650]='FA L10 A:25477 T:25477 P:11645'
G[11651]='FH L10 A:25475 T:25329 P:11643+11644'	-- TODO: Verify requires 11643
G[11652]='FH L10 A:25329 T:25237 P:11651'
G[11653]='FA L10 A:25477 T:25477 P:11650'
G[11654]='FH L10 A:100034815 T:25516'
G[11655]='FH L10 A:25476 T:25476'
G[11656]='FH L10 A:25476 T:25476 P:11655'
G[11657]='HM L7864576 A:25975 T:25975 P:11731 I:11923'
G[11658]='FA L10 A:25477 T:25477 P:11653'
G[11659]='FH L10 A:25516 T:24733 P:11654'
G[11660]='FH L10 A:25476 T:25476'
G[11661]='L10 A:25476 T:25476 P:11660'
G[11662]='L10 A:25476 T:25435 P:1'
G[11663]='L10 A:25480 T:25262 P:11648'
G[11664]='L10 A:25504 T:25503'
G[11665]='K2 L30 A:25580 T:25580 I:11666,11667,11668,11669'
G[11666]='K2 L30 A:25580 T:25580 I:11665,11667,11668,11669'
G[11667]='K2 L30 A:25580 T:25580 I:11665,11666,11668,11669'
G[11668]='K2 L30 A:25580 T:25580 I:11665,11666,11667,11669'
G[11669]='K2 L30 A:25580 T:25580 I:11665,11666,11667,11668'
G[11670]='FA L10 A:25477 T:25477 P:11658'
G[11671]='L10 A:25262 T:25262 P:11663'
G[11672]='FA L10 A:25307 T:25250 O:28709'
G[11673]='FA L10 A:25589 T:25590'
G[11674]='FH L10 A:25602 T:25604'
G[11675]='FH L10 A:25604 T:25604 P:11674'
G[11676]='L10 A:25438 T:25438 P:11618'
G[11677]='FH L10 A:25604 T:25604 P:11675'
G[11678]='FH L10 A:25604 T:25658 P:1'
G[11679]='L10 A:25262 T:24795 P:11671'
G[11680]='L10 A:24795 T:25356 P:11679'
G[11681]='L10 A:25356 T:25785 P:11680'
G[11682]='L10 A:25785 T:24795 P:11681'
G[11683]='FH L10 A:25604 T:25604 P:1'
G[11684]='FH L10 A:24702 T:24702'
G[11685]='FH L10 A:24702 T:24730 P:11684'
G[11686]='FH L10 A:25437 T:25437 P:11618'
G[11687]='FH L10 A:25658 T:25604 P:11678'
G[11688]='L10 A:25607 T:25607'
G[11689]='FH L10 A:25604 T:25602 P:11687'
G[11690]='L10 A:25607 T:25607 P:11688'
G[11691]='HM K512 L16710 P:11696'	-- PM5
G[11692]='FA L10 A:25702 T:25705 P:11710'
G[11693]='FA L10 A:25705 T:25705 P:11692'
G[11694]='FA L10 A:25705 T:25705 P:11693'
G[11695]='FH L10 A:24730 T:24730 P:11685'
G[11696]='HM L16710'
G[11697]='FA L10 A:25705 T:25714 P:11694'
G[11698]='FA L10 A:25705 T:25705 P:11694'
G[11699]='FA L10 A:25714 T:25714 P:11697'
G[11700]='FA L10 A:25714 T:25705 P:11699'
G[11701]='FA L10 A:25705 T:25590 P:11700'
G[11702]='FH L10 A:25736 T:25197'
G[11703]='FH L10 A:25437 T:25729 P:11686'
G[11704]='FA L10 A:25702 T:25197 P:11708'
G[11705]='FH L10 A:25729 T:25237 P:11703'
G[11706]='FH L10 A:24730 T:24730 P:11695'
G[11707]='FA L10 A:25737 T:25590'
G[11708]='FA L10 A:25590 T:25747 P:11707'
G[11709]='FH L10 A:25237 T:25379 P:11705'
G[11710]='FA L10 A:25702 T:25702 P:11708'
G[11711]='FH L10 A:25379 T:25440 P:11709'
G[11712]='FA L10 A:25747 T:25747 P:11708'
G[11713]='FA L10 A:25780 T:25780'
G[11714]='L10 A:25440 T:25440 P:11711'
G[11715]='FA L10 A:25780 T:25780 P:11713'
G[11716]='FH L10 A:25381 T:25381'
G[11717]='FH L10 A:25381 T:25381 P:11716'
G[11718]='FA L10 A:25780 T:25780 P:11715'
G[11719]='FH L10 A:25381 T:25381 P:11717'
G[11720]='FH L10 A:25381 T:25380 P:11719'
G[11721]='FH L10 A:25380 T:25380 P:11720'
G[11722]='FH L10 A:25380 T:25237 P:11721'
G[11723]='FA L10 A:25780 T:25780 P:11718'
G[11724]='fH L10 A:1187905 T:25381'
G[11725]='FA L10 A:25590 T:25807 P:11712'
G[11726]='FA L10 A:25807 T:25807 P:11725'	-- should the P: be O: ?
G[11727]='FA L10 A:25250 T:25816 P:11672'
G[11728]='FA L10 A:25807 T:25807 P:11726'
G[11729]='FA L10 A:100034984 T:25477'
G[11730]='FA L10 A:25477 T:25477 P:11729'
G[11731]='HM fA L7864576 A:25975 T:25975 I:11922'
G[11732]='SP HM FH L7864576 A:1187914'
G[11733]='L10 A:24795 T:25314 P:11682'
G[11734]='SP HM FH L7864576 A:1187916 T:1187916'
G[11735]='SP HM FH L7864576 A:1187917 T:1187917'
G[11736]='SP HM FH L7864576 A:1187919 T:1187919'
G[11737]='SP HM FH L7864576 A:1187920 T:1187920 P:600002'
G[11738]='SP HM FH L7864576 A:1187921 T:1187921'
G[11739]='SP HM FH L7864576 A:1187922 T:1187922'
G[11740]='SP HM FH L7864576 A:1187923 T:1187923'
G[11741]='SP HM FH L7864576 A:1187924 T:1187924'
G[11742]='SP HM FH L7864576 A:1187925 T:1187925'
G[11743]='SP HM FH L7864576 A:1187926 T:1187926'
G[11744]='SP HM FH L7864576 A:1187927 T:1187927'
G[11745]='SP HM FH L7864576 A:1187928 T:1187928'
G[11746]='SP HM FH L7864576 A:1187929 T:1187929'
G[11747]='SP HM FH L7864576 A:1187930 T:1187930'
G[11749]='SP HM FH L7864576 A:1187932 T:1187932'
G[11750]='SP HM FH L7864576 A:1187933 T:1187933'
G[11751]='SP HM FH L7864576 A:1187934 T:1187934'
G[11752]='SP HM FH L7864576 A:1187935 T:1187935'
G[11753]='SP HM FH L7864576 A:1187936 T:1187936'
G[11754]='SP HM FH L7864576 A:1187937 T:1187937'
G[11755]='SP HM FH L7864576 A:1187938 T:1187938'
G[11756]='SP HM FH L7864576 A:1187939 T:1187939'
G[11757]='SP HM FH L7864576 A:1187940 T:1187940'
G[11758]='SP HM FH L7864576 A:1187941 T:1187941'
G[11759]='SP HM FH L7864576 A:1187942 T:1187942'
G[11760]='SP HM FH L7864576 A:1187943 T:1187943'
G[11761]='SP HM FH L7864576 A:1187944 T:1187944'
G[11762]='SP HM FH L7864576 A:1187945 T:1187945'
G[11763]='SP HM FH L7864576 A:1187946 T:1187946'
G[11764]='SP HM FA L7864576 A:1187947 T:1187947'
G[11765]='SP HM FA L7864576 A:1187948 T:1187948'
G[11766]='SP HM FA L7864576 A:1187954 T:1187954'
G[11767]='SP HM FA L7864576 A:1187955 T:1187955'
G[11768]='SP HM FA L7864576 A:1187956 T:1187956'
G[11769]='SP HM FA L7864576 A:1187957 T:1187957'
G[11770]='SP HM FA L7864576 A:1187958 T:1187958'
G[11771]='SP HM FA L7864576 A:1187959 T:1187959'
G[11772]='SP HM FA L7864576 A:1187960 T:1187960'
G[11773]='SP HM FA L7864576 A:1187961 T:1187961'
G[11774]='SP HM FA L7864576 A:1187962 T:1187962'
G[11775]='SP HM FA L7864576 A:1187963 T:1187963'
G[11776]='SP HM FA L7864576 A:1187964 T:1187964'
G[11777]='SP HM FA L7864576 A:1187965 T:1187965'
G[11778]='SP HM FA L7864576 A:1187966 T:1187966'
G[11779]='SP HM FA L7864576 A:1187967 T:1187967'
G[11780]='SP HM FA L7864576 A:1187968 T:1187968'
G[11781]='SP HM FA L7864576 A:1187969 T:1187969'
G[11782]='SP HM FA L7864576 A:1187970 T:1187970'
G[11783]='SP HM FA L7864576 A:1187971 T:1187971'
G[11784]='SP HM FA L7864576 A:1187972 T:1187972'
G[11785]='FA L7864576 E31961'
G[11786]='SP HM FA L7864576 A:1187974 T:1187974'
G[11787]='SP HM FA L7864576 A:1187975 T:1187975'
G[11788]='FA L10 A:25747 T:25747 P:11712'
G[11789]='FA L10 A:25825 T:25825'
G[11790]='FA L10 A:1187851 T:25298'
G[11791]='FA L10 A:25299 T:25250 P:11920'
G[11792]='FA L10 A:25285 T:25285 P:11791'
G[11793]='FA L10 A:25285 T:25826 P:11792'
G[11794]='FA L10 A:25826 T:25826 P:11793'
G[11795]='FA L10 A:25807 T:25807 P:11728'
G[11796]='FA L10 A:25807 T:25807 P:11795'
G[11797]='FA L10 A:25816 T:25816 P:11727'
G[11798]='FA L10 A:25747 T:25590 P:11788'
G[11799]='SP HM FA L7864576 A:1187949 T:1187949'
G[11800]='SP HM FA L7864576 A:1187950 T:1187950'
G[11801]='SP HM FA L7864576 A:1187951 T:1187951'
G[11802]='SP HM FA L7864576 A:1187952 T:1187952'
G[11803]='SP HM FA L7864576 A:1187953 T:1187953'
G[11804]='SP HM FA L7864576 A:25887 T:25887'
G[11805]='SP HM FA L7864576 A:25883 T:25883'
G[11806]='SP HM FA L7864576 A:25888 T:25888'
G[11807]='SP HM FA L7864576 A:25889 T:25889'
G[11808]='SP HM FA L7864576 A:25890 T:25890 P:600001'
G[11809]='SP HM FA L7864576 A:25891 T:25891'
G[11810]='SP HM FA L7864576 A:25892 T:25892'
G[11811]='SP HM FA L7864576 A:25893 T:25893'
G[11812]='SP HM FA L7864576 A:25894 T:25894'
G[11813]='SP HM FA L7864576 A:25895 T:25895'
G[11814]='SP HM FA L7864576 A:25896 T:25896'
G[11815]='SP HM FA L7864576 A:25897 T:25897'
G[11816]='SP HM FA L7864576 A:25898 T:25898'
G[11817]='SP HM FA L7864576 A:25899 T:25899'
G[11818]='SP HM FA L7864576 A:25900 T:25900'
G[11819]='FA L7864576 E31961'
G[11820]='SP HM FA L7864576 A:25902 T:25902'
G[11821]='SP HM FA L7864576 A:25903 T:25903'
G[11822]='SP HM FA L7864576 A:25904 T:25904'
G[11823]='SP HM FA L7864576 A:25905 T:25905'
G[11824]='SP HM FA L7864576 A:25906 T:25906'
G[11825]='SP HM FA L7864576 A:25907 T:25907'
G[11826]='SP HM FA L7864576 A:25908 T:25908'
G[11827]='SP HM FA L7864576 A:25909 T:25909'
G[11828]='SP HM FA L7864576 A:25911 T:25911'
G[11829]='SP HM FA L7864576 A:25912 T:25912'
G[11830]='SP HM FA L7864576 A:25913 T:25913'
G[11831]='SP HM FA L7864576 A:25914 T:25914'
G[11832]='SP HM FA L7864576 A:25915 T:25915'
G[11833]='SP HM FA L7864576 A:25916 T:25916'
G[11834]='SP HM FA L7864576 A:25917 T:25917 I:28761'
G[11835]='SP HM FH L7864576 A:25918 T:25918'
G[11836]='SP HM FH L7864576 A:25919 T:25919'
G[11837]='SP HM FH L7864576 A:25920 T:25920'
G[11838]='SP HM FH L7864576 A:25921 T:25921'
G[11839]='SP HM FH L7864576 A:25922 T:25922'
G[11840]='SP HM FH L7864576 A:25923 T:25923'
G[11841]='SP HM FH L7864576 A:25884 T:25884'
G[11842]='SP HM FH L7864576 A:25925 T:25925'
G[11843]='SP HM FH L7864576 A:25926 T:25926'
G[11844]='SP HM FH L7864576 A:25927 T:25927'
G[11845]='SP HM FH L7864576 A:25928 T:25928'
G[11846]='SP HM FH L7864576 A:25929 T:25929'
G[11847]='SP HM FH L7864576 A:25930 T:25930'
G[11848]='SP HM FH L7864576 A:25931 T:25931'
G[11849]='SP HM FH L7864576 A:25932 T:25932'
G[11850]='SP HM FH L7864576 A:25933 T:25933'
G[11851]='SP HM FH L7864576 A:25934 T:25934'
G[11852]='SP HM FH L7864576 A:25936 T:25936'
G[11853]='SP HM FH L7864576 A:25935 T:25935'
G[11854]='SP HM FH L7864576 A:25937 T:25937'
G[11855]='SP HM FH L7864576 A:25938 T:25938'
G[11856]='SP HM FH L7864576 A:25940 T:25940'
G[11857]='SP HM FH L7864576 A:25941 T:25941'
G[11858]='SP HM FH L7864576 A:25942 T:25942'
G[11859]='SP HM FH L7864576 A:25943 T:25943'
G[11860]='SP HM FH L7864576 A:25944 T:25944'
G[11862]='SP HM FH L7864576 A:25946 T:25946'
G[11863]='SP HM FH L7864576 A:25947 T:25947'
G[11864]='SP L10 A:25809 T:25809'
G[11865]='L10 A:25811 T:25811 P:11864'
G[11866]='L10 A:25809 T:25809 P:11864'
G[11867]='SP K1 L10 A:25809 T:25809 P:11866'
G[11868]='L10 A:25811 T:25811 P:11865'
G[11869]='L10 A:25810 T:25810 P:11864'
G[11870]='L10 A:25810 T:25838 P:11869'
G[11871]='L10 A:25838 T:25838 P:11870'
G[11872]='L10 A:25838 T:25810 P:11871'
G[11873]='FA L10 A:25807 T:25590 P:11796'
G[11875]='K2 L25 A:19202 T:19202 P:PH300,PM300,PS300'
G[11876]='L10 A:25809 T:25809 P:11864'
G[11877]='K2 L25 A:25140 T:25140'
G[11878]='L10 A:25809 T:25862 P:11876'
G[11879]='L10 A:25862 T:25809 P:11878'
G[11880]='K2 L25 A:19475 T:19475'
G[11881]='FH L10 A:25849 T:25849'
G[11882]='HM FA L7864576 A:25962 T:25975 P:600001'
G[11884]='L10 A:25812 T:25812 P:11864'
G[11885]='K512 L15 A:23306 T:23306 P:11029'	-- PM3
G[11886]='HM L7868416 A:26221 T:25324'	-- TODO: G64|Holiday fail|
G[11887]='FH L10 A:25984 T:25849'
G[11888]='FH L10 A:25978 T:25982 P:11595,11596,11597'
G[11889]='FA L10 A:25816 T:25816 P:11797'
G[11890]='FH L10 A:25982 T:25982 O:11888'
G[11891]='HM L7868416 A:25324 T:25324 P:11886'
G[11892]='L10 A:25809 T:25809 P:11879'
G[11893]='FH L10 A:25983 T:25983 P:1'
G[11894]='FH L10 A:25849 T:25849 P:1'
G[11895]='FH L10 A:25982 T:25982 P:11890'
G[11896]='FH L10 A:25982 T:25982 P:11895'
G[11897]='FA L10 A:25816 T:25816 P:11889'
G[11898]='FH L10 A:24703 T:24703 P:1'
G[11899]='FH L10 A:25602 T:25602 P:1'
G[11900]='L10 A:25314 T:25314'
G[11901]='FA L10 A:26083 T:1188085 O:11928'
G[11902]='FA L10 A:1188085 T:26083 P:11901'
G[11903]='FA L10 A:26083 T:26083 P:11902'
G[11904]='FA L10 A:26083 T:26083 P:11903'
G[11905]='L10 A:25314 T:25314 P:11900'
G[11906]='FH L10 A:26104 T:26104 P:1'
G[11907]='FH L10 A:25982 T:25982 P:11896'
G[11908]='FA L10 A:26084 T:26084 P:11902'
G[11909]='FH L10 A:25602 T:25602 P:1'
G[11910]='L10 A:25314 T:25314'
G[11911]='L10 A:25314 T:25314 P:11910'
G[11912]='L10 A:26110 T:26110'
G[11913]='FA L10 A:26085 T:26085 P:11902'
G[11914]='L10 A:26110 T:26110 P:11912'
G[11915]='HM FH L7864576 A:25994 T:26113 P:600002'
G[11916]='FH L10 A:25237 T:24703 P:1'
G[11917]='HM K2 L1839126 M028 AA:26221 AH:526221 TA:26221 TH:526221 P:29092,12012'
G[11918]='L10 A:26117 T:26117'
G[11919]='L10 A:26117 T:26117 P:11936'
G[11920]='fA L10 A:1187851 T:25298 P:B11789'
G[11921]='HM K2 L7864576 A:25975 T:25975 P:11657 I:11926'	-- TODO: G64|Holiday fail|
G[11922]='HM FH L7864576 A:26113 T:26113 I:11731'
G[11923]='HM FH L7864576 A:26113 T:26113 P:11922 I:11657'
G[11924]='HM K2 L7864576 A:25975 T:25975 P:11657 I:11925'	-- TODO: G64|Holiday fail|
G[11925]='HM FH K2 L7864576 A:26113 T:26113 P:11923 I:11924'
G[11926]='HM FH K2 L7864576 A:26113 T:26113 P:11923 I:11921'
G[11927]='L10 A:26155 T:25251 P:11897'
G[11928]='L10 A:25816 T:26083 P:11897'
G[11929]='FH L10 A:24703 T:26158 P:1'
G[11930]='FH L10 A:26158 T:26156 P:11929'
G[11931]='L10 A:26117 T:26117 P:11919'
G[11932]='FA L10 A:25395 T:26169 P:11604'
G[11933]='HM FH L7864576 A:100035569 T:16818'
G[11935]='HM FA L7864576 A:100035568 T:16817'
G[11936]='L10 A:26117 T:26117 P:11918'
G[11938]='FA L10 A:26170 T:26170 P:11956'
G[11939]='L10 E31961'
G[11940]='K2 L10 A:26117 T:26117 P:11919'
G[11941]='L10 A:100035648 T:26117'
G[11942]='FA L10 A:26170 T:26170 P:11938'
G[11943]='L10 A:26117 T:26117 P:11941'
G[11944]='FA L10 A:26187 T:26187 P:12086'
G[11945]='K2 L10 A:26213 T:26213'
G[11946]='L10 A:26206 T:26206 P:11943'
G[11947]='HM K2 L2497824 M038 AA:26221 AH:526221 TA:26221 TH:526221 P:29092,12012'
G[11948]='HM K2 L3155755 M048 AA:26221 AH:526221 TA:26221 TH:526221 P:29092,12012'
G[11949]='L10 A:26169 T:26169'
G[11950]='L10 A:26169 T:26218 P:11949'
G[11951]='L10 A:26206 T:26206 P:11946'
G[11952]='HM K2 L3617075 M055 AA:26221 AH:526221 TA:26221 TH:526221 P:29092,12012'
G[11953]='HM K2 L4143164 M063 AA:26221 AH:526221 TA:26221 TH:526221 P:29092,12012'
G[11954]='HM K2 L7880704 AA:26221 AH:526221 TA:26221 TH:526221 P:29092,12012'
G[11955]='HM L16710'
G[11956]='FA L10 A:26170 T:26170'
G[11957]='L10 A:26206 T:26206 P:11951'
G[11958]='L15 A:26194 T:26194 O:12117'
G[11959]='L15 A:26194 T:26194 P:11958'
G[11960]='K2 L15 A:26228 T:26228'
G[11961]='L10 A:26218 T:26218 P:11950'
G[11962]='FA L10 A:26083 T:25235 P:11904'
G[11963]='FA L10 A:25235 T:26083 P:11962'
G[11964]='HM FA L7864576 A:16817 T:26401'
G[11965]='FA L10 A:26083 T:26083 P:11963'
G[11966]='HM FH L7864576 A:16818 T:26520'
G[11967]='L10 A:26206 T:26117 P:11957'
G[11968]='L10 A:26218 T:26218 P:11961'
G[11969]='L10 A:26117 T:26117 P:11967'
G[11970]='HM FA L7864576 A:18927,518927,500091,500092,500093,500094,500095,19148,19171,519171,500096,500097,500098,19172,19173,20102,520102,500106,500107,500108,500109,500110,500111,500112,500113,500114,500115,500116,500117,500118,500119,500120,500121,500122,500123,500124,500125,500126,500127,500128,500129,500130 T:16817'
G[11971]='HM FH L7864576 A:19169,519169,500099,500100,500101,500102,500103,500104,19175,519175,19176,519176,19177,519177,500105,19178,519178,20102,520102,500106,500107,500108,500109,500110,500111,500112,500113,500114,500115,500116,500117,500118,500119,500120,500121,500122,500123,500124,500125,500126,500127,500128,500129,500130 T:16818'
G[11972]='HM L7864576 A:100035723 T:25697'
G[11973]='L10 A:26117 T:26117 P:11969'
G[11975]='HC FH L7879680 A:22914 T:22914 P:10945+10953+10951'
G[11976]='L0 T:133399'
G[11977]='L15 A:26156 T:26181 P:11930 I:11979'
G[11978]='FH L15 A:26181 T:26181 P:11977,11979'
G[11979]='L15 A:26415 T:26181 I:11977'
G[11980]='L15 A:26180 T:26180'
G[11981]='L15 A:26335 T:26260'
G[11982]='L15 A:26260 T:26260 O:11981'
G[11983]='FH L15 A:26181 T:26181 P:11978'
G[11984]='L15 A:26424 T:26424 O:12208,12210'	-- TODO: since 12210 only is available after 12212, must check if 11984 needs something like that too
G[11985]='L15 A:26260 T:26260 P:12070'
G[11986]='FA L15 A:1188261 T:26361'
G[11988]='FA L15 A:26361 T:26361 P:11986'
G[11989]='L15 A:26423 T:26423 P:11984'
G[11990]='L15 A:26423 T:26423 P:11989'
G[11991]='L15 A:26423 T:26500 P:11990'
G[11993]='FA L15 A:26361 T:26361 P:11988'
G[11995]='FA L15 A:26440 T:26673 I:12440,B12439'
G[11996]='FH L15 A:26441 T:26471'
G[11997]='L10 A:99415 T:90418 E21796'
G[11998]='FA L15 A:26212 T:26226'
G[11999]='FH L15 A:26471 T:26471 P:11996'
G[12000]='FA L15 A:26673 T:26673 O:11995,12439,12440,39204'
G[12002]='FA L15 A:26226 T:26226 P:11998'
G[12003]='FA L15 A:26226 T:26226 P:12002'
G[12004]='FA L15 A:26673 T:26673 P:12000'
G[12005]='FH L15 A:26471 T:26471 P:11999'
G[12006]='L15 A:26501 T:26501'
G[12007]='L15 A:26500 T:26543 P:11991'
G[12008]='FH L15 A:26181 T:26379 P:11983'
G[12009]='L15 A:26245 T:26245 P:11959'
G[12010]='FA L15 A:26226 T:26514 P:12003'
G[12011]='L15 A:1188364 T:26245'
G[12012]='HM FH L7868416 A:25324 T:26221 P:11891'
G[12013]='L15 A:26501 T:26501 P:12006'
G[12014]='FA L15 A:26514 T:26226 P:12010'
G[12016]='L15 A:26245 T:26245 P:12011'
G[12017]='L15 A:26245 T:26245 P:12016'
G[12019]='FA L10 A:26170 T:26170 P:11942'
G[12020]='HB FA K2 L7864576 A:1189989 T:27215'
G[12022]='HB FA K16 L7864576 A:27215 T:27215 I:12191'
G[12026]='FH L15 A:1188261 T:26584'
G[12027]='FA L15 A:26588 T:26371'
G[12028]='L15 A:26595 T:26595 P:11959'
G[12029]='L15 A:26604 T:26604 P:12484'
G[12030]='L15 A:26595 T:1188419 P:12028'
G[12031]='L15 A:1188419 T:1188419 P:12030'
G[12032]='L15 A:1188419 T:26595 P:12031'
G[12033]='fH L15 A:26649 T:26649'
G[12034]='FH L15 A:26379 T:26415'
G[12035]='FA L10 A:26084 T:26084 P:11908'
G[12036]='L15 A:26415 T:26415 P:12034'
G[12037]='K64 L15 A:26604 T:55677 P:12029'
G[12038]='K2 L15 A:26604 T:26604 P:12029'
G[12039]='fH L15 A:26564 T:26564'
G[12040]='FH L15 A:26653 T:26653'
G[12041]='L15 A:26653 T:26379 P:12040'
G[12042]='L15 A:26543 T:1188365 P:12007'
G[12043]='L15 A:26647 T:26647'
G[12044]='L15 A:26660 T:26660 O:12469'
G[12045]='L15 A:26661 T:26661'
G[12046]='L15 A:26661 T:26661 P:12045'
G[12047]='L15 A:26661 T:26661 P:12046'
G[12048]='L15 A:26564 T:26564 P:12039'
G[12049]='L15 A:26660 T:26660 P:12046'
G[12050]='L15 A:26660 T:26660 P:12047'
G[12051]='L15 E28153'
G[12052]='L15 A:26647 T:26647 P:12047'
G[12053]='FH L15 A:26415 T:26415 P:12036'
G[12054]='FH L15 A:26584 T:26584 P:12026'
G[12055]='FA L15 A:100036742 T:26673'
G[12056]='FH L15 A:26618 T:26618'
G[12057]='FH L15 A:100036744 T:26618'
G[12058]='FH L15 A:26584 T:26584'
G[12059]='FH L15 A:100036746 T:26471 P:12055'
G[12060]='FA L15 A:26673 T:26673 P:12055'
G[12061]='FH L15 A:26471 T:26471 P:12059'
G[12062]='L19280 E28153'
G[12063]='FH L15 A:26652 T:26733'
G[12064]='FH L15 A:26733 T:26733 P:12063'
G[12065]='FA L15 A:26673 T:26673 P:12060'
G[12066]='FH L15 A:26471 T:26471 P:12061'
G[12067]='FA L15 A:100036756 T:26459'
G[12068]='L15 A:26701 T:26787 P:12802'
G[12069]='FH L15 A:26733 T:26379 P:12064'
G[12070]='L15 A:26260 T:26260 P:11982'
G[12071]='FH L15 A:26415 T:26574 P:12053'	-- 4.2 has the extra space
G[12072]='FH L15 A:26574 T:26574 P:12071'
G[12073]='FH L15 A:26666 T:26666'
G[12074]='fH L15 A:26666 T:26260'
G[12075]='L15 A:26659 T:26659 O:12112'
G[12076]='L15 A:26659 T:26659 P:12075'
G[12077]='L15 A:26659 T:26473 P:12076'
G[12078]='L15 A:26659 T:26659 P:12077'
G[12079]='L15 A:26473 T:26473 P:12075'
G[12080]='L15 A:26473 T:26473 P:12077'
G[12081]='L15 A:26260 T:26420 P:11985'
G[12082]='L15 A:26814 T:26884'
G[12083]='FA L15 A:26673 T:26673 P:12065'
G[12084]='FH L15 A:26471 T:26471 P:12066'
G[12085]='FH L15 A:100036780 T:26379'
G[12086]='FA L10 A:26169 T:26187 P:11932'
G[12088]='FA L10 A:26187 T:26170 P:11944'
G[12089]='FH L15 A:1188418 T:26618'
G[12090]='FH L15 A:1188418 T:26618'
G[12091]='FH L15 A:1188418 T:26618'
G[12092]='FA L15 A:26837 T:26837'
G[12093]='L15 A:26420 T:26420 P:12081'
G[12094]='L15 A:26420 T:26420 P:12093'
G[12095]='fH L15 A:26618 T:26859'
G[12096]='FH L15 A:26854 T:26854'
G[12097]='L15 A:26859 T:26618 P:12095'
G[12098]='FA L15 A:26673 T:26873 P:12083'
G[12099]='L15 A:26420 T:26420 P:12094'
G[12100]='FH L15 A:26504 T:26504'
G[12101]='FH L15 A:26504 T:26505 P:12100'
G[12102]='FH L15 A:26505 T:26505 P:12101'
G[12103]='L10 CO A:98519 T:99181'
G[12104]='FH L15 A:26505 T:26504 P:12102'
G[12105]='FA L15 A:100036940 T:26875'
G[12106]='FH L15 A:26471 T:26873 P:12084'
G[12107]='FA L15 A:26873 T:26673 P:12098,12106'
G[12109]='FA L15 A:26875 T:26212 P:12105'
G[12110]='FH L15 A:26873 T:26471 P:12107'
G[12111]='FH L15 A:26504 T:26504 P:12104'
G[12112]='L15 A:26647 T:26659 P:12052'
G[12113]='L15 A:26884 T:26884'
G[12114]='L15 A:26884 T:26884'
G[12115]='FH L15 A:26618 T:26581 P:12057'
G[12116]='L15 A:26886 T:26886'
G[12117]='L15 A:28382 T:26194 P:11968'
G[12118]='L15 A:24810 T:26194'
G[12119]='FA L15 A:26673 T:26443 P:12107'
G[12120]='L15 A:26886 T:26886 P:12116'
G[12121]='L15 A:26886 T:26924 P:12120'
G[12122]='FH L15 A:26471 T:26443 P:12110'
G[12123]='FA L15 A:26443 T:26917 P:12768'
G[12124]='FH L15 A:26443 T:26917 P:12769'
G[12125]='FH L15 A:26581 T:26581'
G[12126]='FH L15 A:26581 T:26581'
G[12127]='FH L15 A:26581 T:26581'
G[12128]='FA L15 A:26226 T:26883 P:12014'
G[12129]='FA L15 A:26883 T:26883 P:12128'
G[12130]='FA L15 A:26883 T:26883 P:12129'
G[12131]='FA L15 A:26883 T:26883 P:12130'
G[12132]='FH L15 A:26581 T:26581'
G[12133]='HW FA K2 L7864576 A:1186887 T:24519'
G[12134]='L15 A:26935 T:26935 P:12329'
G[12135]='HW fA K2 L7864576 A:24519 T:24519 I:11131'
G[12136]='FH L15 A:26581 T:26618 P:12132'
G[12137]='L15 A:26924 T:26886 P:12121'
G[12138]='FA L15 A:26883 T:26883 P:12131'
G[12139]='HW K2 L7864576 A:23973 T:23973 P:11450'
G[12140]='FH L15 A:26379 T:26379 P:12069'
G[12141]='L10 A:25301 T:25435 P:11791'
G[12142]='FA L15 A:26978 T:26978'
G[12143]='FA L15 A:26978 T:26978 P:12142'
G[12144]='FH L15 A:26979 T:26979'
G[12145]='FH L15 A:26979 T:26979 P:12144'
G[12146]='FA L15 A:100036855 T:26983'
G[12147]='FH L15 A:100036856 T:26983'
G[12148]='L15 A:26983 T:26983 P:12146,12147'
G[12149]='L15 A:26983 T:26983 P:12148'
G[12150]='L15 A:26983 T:26983 P:12149'
G[12151]='L15 A:26983 T:26983 P:12150'
G[12152]='L15 A:26886 T:26886 P:12137'
G[12153]='FA L15 A:26883 T:26883 P:12138'
G[12154]='FA L15 A:26883 T:26883 P:12138'
G[12155]='HW FH K2 L7864576 A:1186887 T:23973'
G[12157]='fA L15 A:26186 T:27060 I:12297'
G[12158]='FA L15 A:26212 T:26932 P:12109'
G[12159]='FA L15 A:26932 T:26932 P:12158'
G[12160]='FA L15 A:26932 T:26212 P:12159'
G[12161]='FA L15 A:27582 T:27581 P:12160'
G[12164]='K512 L15 A:526935 T:26935 P:12411'	-- PM3
G[12165]='FH L15 A:27221 T:27227 P:12195'
G[12166]='FA L15 A:26973 T:26973'
G[12167]='FA L15 A:26973 T:26973 P:12166'
G[12168]='FA L15 A:100036958 T:26973'
G[12169]='FA L15 A:26973 T:26973 P:12168'	-- ensure we do not need P:12167 as well
G[12170]='FH K2 L15 A:27120 T:27120'
G[12171]='fA L15 A:27060 T:26881 O:12174 I:12297,12298'
G[12172]='FA L10 CM A:26673 T:26673'
G[12173]='FH L10 CM A:26471 T:26471'
G[12174]='L15 A:26881 T:27136 P:12171'
G[12175]='FH L15 A:27037 T:27037'
G[12176]='FH L15 A:27037 T:27037 P:12175'
G[12177]='FH L15 A:27037 T:27037 P:12176'
G[12178]='FH L15 A:27037 T:26860 P:12177'
G[12180]='FA L15 A:26885 T:26885 P:12014'
G[12181]='fH L15 A:24251 T:24155'
G[12182]='L15 A:24155 T:27172 P:12181'
G[12183]='FA L15 A:26885 T:26885 P:12180'
G[12184]='FA L15 A:26885 T:26885 P:12183'
G[12185]='FA L15 A:26885 T:26885 P:12184'
G[12188]='L15 A:27172 T:27172 P:12182,12189'
G[12189]='L15 A:26505 T:27172 P:12182'
G[12190]='L15 A:26519 T:26884 P:12483'
G[12191]='HB FH K16 L7864576 A:27216 T:27216 I:12022'
G[12192]='HB FH K2 L7864576 A:1189990 T:27216'
G[12193]='HB FA L7864576 A:24468 T:23710 Z17198'
G[12194]='HB FH L7864576 A:24510 T:24495 Z17198'
G[12195]='FH L15 A:27221 T:27221'
G[12196]='FH L15 A:27227 T:27227 P:12165'
G[12197]='FH L15 A:27227 T:27227 P:12196'
G[12198]='FH L15 A:27227 T:27227 P:12197'
G[12199]='FH L15 A:27227 T:27221 P:12198'
G[12200]='L15 A:27172 T:27172 P:12188'
G[12201]='FH L15 A:26666 T:26666 P:12204'
G[12202]='FH L15 A:26666 T:26666 P:12201'
G[12203]='FH L15 A:26666 T:26666 P:12202'
G[12204]='FH L15 A:26666 T:26666'
G[12205]='FH L15 A:1188649 T:27243'
G[12206]='FH L15 A:27248 T:27248'
G[12207]='FH L15 A:27262 T:27262'
G[12208]='fH L15 A:27266 T:26424'
G[12209]='FH L15 A:27267 T:27267'
G[12210]='L15 A:26875 T:26424 P:12212'
G[12211]='FH L15 A:27248 T:27248'
G[12212]='fA L15 A:27277 T:27277'
G[12213]='FH L15 A:27262 T:27262'
G[12214]='FH L15 A:27028 T:27028'
G[12215]='fA L15 A:27277 T:27277'
G[12216]='L15 A:27277 T:27277 P:12212'
G[12217]='FA L15 A:27277 T:27277 P:12215'
G[12218]='L15 A:27172 T:27172 P:12200'
G[12219]='FA L15 A:27295 T:27295 P:12310'
G[12220]='FA L15 A:27295 T:27295 P:12310'
G[12221]='L15 A:27172 T:26505 P:12218'
G[12222]='FA L15 A:27391 T:27391 P:12294'
G[12223]='FA L15 A:27391 T:27391 P:12294'
G[12224]='FH L15 A:26379 T:25257'
G[12225]='FA L15 A:1188667 T:27277'
G[12226]='L15 A:27277 T:27277 P:12225'
G[12227]='L15 A:27277 T:27277 P:12226'
G[12229]='FH L15 A:27262 T:27262'
G[12230]='FH L15 A:27320 T:27320'
G[12231]='FH L15 A:27262 T:27262'
G[12232]='FH L15 A:27320 T:27320 P:12230'
G[12233]='L15 E28153'
G[12234]='FH L15 A:27337 T:27337'
G[12235]='FA L15 A:27136 T:27317 P:12174,12298'	-- verify the P: really should not be O:
G[12236]='FH K512 L15 A:27262 T:27262'	-- PM3
G[12237]='FA L15 A:27317 T:27317 P:12235'
G[12238]='K64 L15 A:26787 T:28016 P:12068'
G[12239]='FH L15 A:27337 T:27350 P:12234'
G[12240]='FH L15 A:27248 T:27248'
G[12241]='FH L15 A:27262 T:27262'
G[12242]='FH L15 A:27262 T:27262'
G[12243]='FH L15 A:27248 T:27248 P:12240'
G[12244]='fA K2 L15 A:27371 T:27371'
G[12245]='FH L15 A:27337 T:27243'
G[12246]='FA L15 A:27295 T:27295 P:12219+12220'
G[12247]='FA L15 A:27295 T:27295 P:12219+12220'
G[12248]='FA L15 A:27295 T:27295 P:12246+12247'
G[12249]='FA K512 L15 A:27295 T:27295 P:12248+12250'	-- PM3
G[12250]='FA L15 A:27295 T:27295 P:12246+12247'
G[12251]='FA L15 A:27317 T:27136 P:12237'
G[12252]='FH L15 A:27243 T:27243 P:12245'
G[12253]='FA L15 A:27136 T:27136 P:12251'
G[12254]='FH L15 A:27350 T:27350 P:12239'
G[12255]='FA L15 A:27391 T:27391 P:12222+12223'
G[12256]='FH L15 A:27388 T:27388'
G[12257]='FH L15 A:27388 T:27388 P:12468'
G[12258]='L15 A:27155 T:27155 P:12251'
G[12259]='FH L15 A:27388 T:27388'
G[12260]='FH L15 A:27350 T:27350 P:12254'
G[12261]='L15 A:26593 T:26593 P:12447'
G[12262]='L15 A:26593 T:26593 P:12447'
G[12263]='L15 A:26593 T:26593 P:12261'
G[12264]='L15 A:26593 T:26593 P:12263'
G[12265]='L15 A:26593 T:26593 P:12263'
G[12266]='L15 A:26593 T:27765 P:12267'
G[12267]='L15 A:26593 T:26593 P:12265'
G[12268]='fA K2 L15 A:27416 T:27416'
G[12269]='L15 A:27156 T:27156 P:12275'
G[12270]='fH K2 L15 A:27423 T:27423'
G[12271]='FH L15 A:100037432 T:27243'
G[12272]='FA L15 A:27159 T:27159 P:12275'
G[12273]='FH L15 A:27243 T:27243 P:12271'
G[12274]='FH L15 A:27350 T:27350 P:12260'
G[12275]='FA L15 A:27136 T:27159 P:12251'
G[12276]='FA L15 A:27159 T:27412 P:12275'
G[12277]='FA L15 A:27412 T:27159 P:12276'
G[12278]='HB FA L7864576 A:100037571 T:27478 I:12420'
G[12279]='L15 A:26484 T:26484'
G[12280]='fH K2 L15 A:27422 T:27422'
G[12281]='FA L15 A:27159 T:27136 P:12277'	-- does this also require P:12272 ?
G[12282]='FA L15 A:27314 T:27314 P:12251'
G[12283]='FH L15 A:27350 T:27243 P:12274'
G[12284]='fH K2 L15 A:27451 T:27451'
G[12285]='FH L15 A:27243 T:27243 P:12283'
G[12286]='SP HW FA K16 L7864576 A:1189303 T:1189303'
G[12287]='FA L15 A:27314 T:27347 P:12282'
G[12288]='fH K2 L15 A:27464 T:27464'
G[12289]='fA K2 L15 A:27468 T:27468'
G[12290]='FA L15 A:27347 T:27347 P:12287'
G[12291]='FA L15 A:27347 T:27347 P:12290'
G[12292]='FA L15 A:26875 T:26875'
G[12293]='FA L15 A:26875 T:27469 P:12292'
G[12294]='FA L15 A:27469 T:26875 P:12293'
G[12295]='FA L15 A:26875 T:26821 P:12294'
G[12296]='K2 L15 A:27484 T:27484'
G[12297]='FA L15 A:23749 T:23859 P:11250 O:12298 I:12157,12171,12174'
G[12298]='FA L15 A:23859 T:27136 P:12297 I:12174'
G[12299]='FA L15 A:27486 T:27486 P:12295'
G[12300]='FA L15 A:27486 T:27497 P:12299+12307'
G[12301]='FA L15 A:27347 T:27347 P:12291'
G[12302]='FA L15 A:27497 T:27499 P:12300'
G[12303]='FH L15 A:27267 T:27267'
G[12304]='FH L15 A:32599 T:32599'
G[12305]='FA L15 A:27347 T:27314 P:12301'
G[12306]='HB FH L7864576 A:100037599 T:27489 I:12421'
G[12307]='FA L15 A:27545 T:27545'
G[12308]='FA L15 A:27499 T:26875 P:12302'
G[12309]='FA L15 A:27136 T:27318 P:12253'
G[12310]='FA L15 A:26875 T:26875 P:12308'
G[12311]='L15 A:27318 T:27318 P:12309'
G[12312]='FA L15 A:1189311 T:27318 P:12309'
G[12314]='FA K770 L15 A:27520 T:27520'	-- PM3
G[12315]='fH K770 L15 A:27532 T:27532'	-- PM3
G[12316]='fA K2 L15 A:27562 T:27562'
G[12317]='FH K2 L15 A:27563 T:27563'
G[12318]='L7869440 E28153'
G[12319]='FA L15 A:27318 T:27136 P:12312'
G[12320]='FA L15 A:27136 T:27316 P:12319'
G[12321]='FA L15 A:27316 T:27136 P:12320'
G[12323]='FA K258 L15 A:27602 T:27602'
G[12324]='FH K258 L15 A:27606 T:27606'
G[12325]='FA L15 A:27136 T:27157 P:12281'
G[12326]='FA L15 A:27157 T:1293 P:12325'
G[12327]='L15 A:27581 T:27581 P:12328'
G[12328]='L15 A:27581 T:27581 P:12161,12425'
G[12329]='L15 A:27581 T:26935 P:12327'
G[12330]='L15 A:26935 T:26935 P:12329'
G[12331]='SP HW FA K16 L7864576 A:1190034 T:1190034'
G[12332]='SP HW FA K16 L7864576 A:1190036 T:1190036'
G[12333]='SP HW FA K16 L7864576 A:1190037 T:1190037'
G[12334]='SP HW FA K16 L7864576 A:1190038 T:1190038'
G[12335]='SP HW FA K16 L7864576 A:1190039 T:1190039'
G[12336]='SP HW FA K16 L7864576 A:1190040 T:1190040'
G[12337]='SP HW FA K16 L7864576 A:1190041 T:1190041'
G[12338]='FA L7864576 E28153'
G[12339]='SP HW FA K16 L7864576 A:1190043 T:1190043'
G[12340]='SP HW FA K16 L7864576 AP:1190047:26322;500023:X26322 TP:1190047:26322;500023:X26322'
G[12341]='SP HW FA K16 L7864576 A:1190045 T:1190045'
G[12342]='SP HW FA K16 L7864576 A:1190046 T:1190046'
G[12343]='SP HW FA K16 L7864576 A:1190044 T:1190044'
G[12344]='SP HW FA K16 L7864576 A:1190048 T:1190048'
G[12345]='SP HW FA K16 L7864576 A:1190035 T:1190035'
G[12347]='SP HW FA K16 L7864576 A:1190050 T:1190050'
G[12348]='SP HW FA K16 L7864576 A:1190051 T:1190051'
G[12349]='FA L7864576 E28153'
G[12350]='SP HW FA K16 L7864576 A:1190053 T:1190053'
G[12351]='SP HW FA K16 L7864576 A:1190054 T:1190054'
G[12352]='SP HW FA K16 L7864576 A:1190055 T:1190055'
G[12353]='SP HW FA K16 L7864576 A:1190056 T:1190056'
G[12354]='SP HW FA K16 L7864576 A:1190057 T:1190057'
G[12355]='SP HW FA K16 L7864576 A:1190058 T:1190058'
G[12356]='SP HW FA K16 L7864576 A:1190059 T:1190059'
G[12357]='SP HW FA K16 L7864576 A:1190060 T:1190060'
G[12358]='SP HW FA K16 L7864576 A:1190061 T:1190061'
G[12359]='SP HW FA K16 L7864576 A:1190062 T:1190062'
G[12360]='SP HW FA K16 L7864576 A:1190063 T:1190063'
G[12361]='SP HW FH K16 L7864576 A:1190064 T:1190064'
G[12362]='SP HW FH K16 L7864576 A:1190065 T:1190065'
G[12363]='SP HW FH K16 L7864576 A:1190066 T:1190066'
G[12364]='SP HW FH K16 L7864576 A:1190067 T:1190067'
G[12365]='SP HW FH K16 L7864576 A:1190068 T:1190068'
G[12366]='SP HW FH K16 L7864576 A:1190069 T:1190069'
G[12367]='SP HW FH K16 L7864576 A:1190070 T:1190070'
G[12368]='SP HW FH K16 L7864576 A:1190071 T:1190071'
G[12369]='SP HW FH K16 L7864576 A:1190072 T:1190072'
G[12370]='SP HW FH K16 L7864576 A:1190073 T:1190073'
G[12371]='SP HW FH K16 L7864576 A:1190074 T:1190074'
G[12372]='K2 L15 A:27575 T:27575 P:12435'
G[12373]='SP HW FH K16 L7864576 A:1190075 T:1190075'
G[12374]='SP HW FH K16 L7864576 A:1190076 T:1190076'
G[12376]='SP HW FH K16 L7864576 A:1190078 T:1190078'
G[12377]='SP HW FH K16 L7864576 A:1190079 T:1190079'
G[12378]='SP HW FH K16 L7864576 A:1190080 T:1190080'
G[12380]='SP HW FH K16 L7864576 A:1190082 T:1190082'
G[12381]='SP HW FH K16 L7864576 A:1190083 T:1190083'
G[12382]='SP HW FH K16 L7864576 A:1190084 T:1190084'
G[12383]='SP HW FH K16 L7864576 A:1190085 T:1190085'
G[12384]='SP HW FH K16 L7864576 A:1190086 T:1190086'
G[12386]='SP HW FH K16 L7864576 A:1190088 T:1190088'
G[12387]='SP HW FH K16 L7864576 A:1190089 T:1190089'
G[12388]='SP HW FH K16 L7864576 A:1190090 T:1190090'
G[12389]='SP HW FH K16 L7864576 A:1190091 T:1190091'
G[12390]='SP HW FH K16 L7864576 A:1190096 T:1190096'
G[12391]='SP HW FH K16 L7864576 A:1190097 T:1190097'
G[12392]='SP HW FH K16 L7864576 A:1190098 T:1190098'
G[12393]='SP HW FH K16 L7864576 A:1190099 T:1190099'
G[12394]='SP HW FH K16 L7864576 A:1190100 T:1190100'
G[12395]='SP HW FH K16 L7864576 A:1190101 T:1190101'
G[12396]='SP HW K16 L7864576 A:1190102 T:1190102'
G[12397]='SP HW K16 L7864576 A:1190103 T:1190103'
G[12398]='SP HW K16 L7864576 A:1190104 T:1190104'
G[12399]='SP HW K16 L7864576 A:1190105 T:1190105'
G[12400]='SP HW K16 L7864576 A:1190106 T:1190106'
G[12401]='SP HW K16 L7864576 A:1190107 T:1190107'
G[12402]='SP HW K16 L7864576 A:1190108 T:1190108'
G[12403]='SP HW K16 L7864576 A:1190109 T:1190109'
G[12404]='SP HW K16 L7864576 AP:1190110:T3A441999;1190111:T3A641999 TP:1190110:T3A441999;1190111:T3A641999'
G[12405]='L7864576 E28153'
G[12406]='SP HW K16 L7864576 A:1190112 T:1190112'
G[12407]='SP HW K16 L7864576 A:1190113 T:1190113'
G[12408]='SP HW K16 L7864576 A:1190114 T:1190114'
G[12409]='SP HW K16 L7864576 AP:1190115:T3A441999;1190116:T3A641999 TP:1190115:T3A441999;1190116:T3A641999'
G[12410]='L7864576 E28153'
G[12411]='L15 A:26935 T:27646 P:12330'
G[12412]='FH L15 A:26860 T:26860'
G[12413]='FH L15 A:26860 T:26860 P:12412'
G[12414]='FA L15 A:26377 T:26377'
G[12415]='FH L15 A:26944 T:26944'
G[12416]='FA L15 A:27506 T:27506 P:12460'
G[12417]='FA L15 A:27506 T:27506 P:12416'
G[12418]='FA L15 A:27506 T:27506 P:12417'
G[12419]='L15 A:100037833 T:27990'
G[12420]='HB FA L7864576 A:100037736 T:27478 I:12278'
G[12421]='HB FH L256 A:100037737 T:27489 I:12306'
G[12422]='FH L15 A:27102 T:27497 P:12424'
G[12423]='FH L15 A:100037830 T:26860'
G[12424]='FH L15 A:26860 T:27102 P:12423'
G[12425]='FH L15 A:27102 T:27581'
G[12427]='FH K512 L15 A:27719 T:27720'	-- PM3
G[12428]='FH K512 L15 A:27719 T:27720 P:12427'	-- PM3
G[12429]='FH K512 L15 A:27719 T:27720 P:12428'	-- PM3
G[12430]='FH K512 L15 A:27719 T:27720 P:12429'	-- PM3
G[12431]='FH K512 L15 A:27719 T:27102 P:12430'	-- PM3
G[12432]='fH K2 L15 A:27708 T:27708'
G[12433]='fH L15 A:27565 T:27565'
G[12435]='L15 A:26917 T:27575 P:12123,12124'
G[12436]='fH L15 A:26868 T:26868'
G[12437]='fA K2 L15 A:27759 T:27759'
G[12438]='FA L15 A:1190020 T:27156'
G[12439]='fA L15 A:27158 T:26878 I:11995'
G[12440]='L15 A:26878 T:26673 P:12439 I:11995'
G[12441]='FA L15 A:1190020 T:27156'
G[12442]='FA L15 A:1190020 T:27156'
G[12443]='fA L15 A:27495 T:27495'
G[12444]='fA K258 L15 A:27783 T:27783'
G[12446]='L15 E28153'
G[12447]='L15 A:27765 T:26593'
G[12448]='FH L15 A:27763 T:27763 P:12461'
G[12449]='FH L15 A:27763 T:27763 P:12448'
G[12450]='FH L15 A:27763 T:27763 P:12449'
G[12451]='FH L15 A:27388 T:26666'
G[12453]='fH L15 A:27262 T:27262'
G[12454]='L15 A:27255 T:27255'
G[12455]='FA L15 A:1293 T:1293 P:12326'
G[12456]='L15 A:27255 T:27255 P:12454'
G[12457]='FA L15 A:1293 T:1293 P:12455'
G[12458]='L15 A:27785 T:27785'
G[12459]='L15 A:27785 T:27785 P:12458'
G[12460]='FA L15 A:27803 T:27506 P:12766'
G[12461]='FH L15 A:27804 T:27763 P:12767'
G[12462]='L15 A:27319 T:27319 P:12326'
G[12463]='FA L15 A:1293 T:27828 P:12457'
G[12464]='FA L15 A:27784 T:27784 P:12237'
G[12465]='FA L15 A:27828 T:1293 P:12463'
G[12466]='FA L15 A:1293 T:27844 P:12465'
G[12467]='FA L15 A:27844 T:27136 P:12466'
G[12468]='FH L15 A:26860 T:27388 P:12487'
G[12469]='L15 A:26896 T:26660'
G[12470]='L15 A:27856 T:27856'
G[12471]='L10 A:25636 T:25435'	-- you need to kill the thing fighting the Captured Tuskarr Prisoner and then it will offer the quest.  how to simulate?
G[12472]='FA L15 A:27136 T:27857 P:12467'
G[12473]='FA L15 A:27857 T:27136 P:12472'
G[12474]='FA L15 A:27136 T:27872 P:12473'
G[12475]='FA L15 A:27314 T:27314 P:12305'
G[12476]='L15 A:27155 T:27155 P:12305'
G[12477]='L15 A:27136 T:27136 P:12305'
G[12478]='FA L15 A:27314 T:27314 P:12475'
G[12479]='L10 E28153'
G[12480]='L10 E28153'
G[12481]='FH L10 A:24458 T:24458 P:11303'
G[12482]='fH L10 A:27922 T:27922'
G[12483]='L15 A:26519 T:26519 P:12484'
G[12484]='L15 A:26519 T:26604 P:11990'
G[12486]='L10 A:25272 T:25339 P:11595,11596,11597'
G[12487]='FH L15 A:27243 T:26860 P:12488'
G[12488]='FH L15 A:26415 T:27243'
G[12489]='L20 A:27987 T:27986 P:12521'
G[12490]='L10 E28153'
G[12491]='HB L7864576 A:100038280 T:24710'
G[12492]='HB L7864576 A:100038281 T:24711'
G[12495]='FA L15 A:27872 T:26917 P:12474'
G[12496]='FH L15 A:25257 T:26917 P:12224'
G[12497]='L15 A:26917 T:26949 P:12495,12496'
G[12498]='L15 A:26949 T:26917 P:12497'
G[12499]='FA L15 A:26917 T:27872 P:12498'
G[12500]='FH L15 A:26917 T:25257 P:12498'
G[12501]='K2 L20 A:28039 T:28039'
G[12502]='K2 L20 A:28042 T:28042'
G[12503]='L20 A:28059 T:28059 O:12795'
G[12504]='L20 A:28056 T:28056 P:12505'
G[12505]='L20 A:28039 T:28056 P:12740'
G[12506]='L20 A:28062 T:28062 P:12740'
G[12507]='L20 A:100038321 T:28062'
G[12508]='L20 A:28099 T:28099 P:12505'
G[12509]='K2 L20 A:28044 T:28044'
G[12510]='L20 A:28062 T:28062 P:12507'
G[12511]='fA L15 A:27317 T:26875'
G[12512]='L20 A:28125 T:28125'
G[12513]='FA L16911 RH RF RN RK A:28126 T:28126 I:12515'	-- L72 Human DK 2014-06-15
G[12514]='L20 A:28062 T:28062 P:12510'
G[12515]='L15 N30 A:28126 T:28126 I:12513'	-- L85 NE Hunter, Nimhfree marked complete, reports that Horde has gotten this one
G[12516]='L20 A:28062 T:28062 P:12514'
G[12517]='K1 L2575 A:100037163,100043039 T:30481'
G[12518]='L7715 A:100044148 T:30481'
G[12519]='K2 L20 A:28043 T:28043'
G[12520]='L20 A:27986 T:27986 P:12525+12523'
G[12521]='L20 A:28160 T:27987'
G[12522]='L20 A:28033 T:28033'
G[12523]='L20 A:28033 T:28033 P:12522'
G[12524]='L20 A:28032 T:28032'
G[12525]='L20 A:28032 T:28032 P:12524'
G[12526]='L20 A:27986 T:28191 P:12520'
G[12527]='L20 A:28204 T:28205 P:12510'
G[12528]='fA L20 A:28095 T:28082 O:12654'	-- TODO: Determine how to handle this.  Basically it becomes available when NPC 28097 is killed
G[12529]='L20 A:28082 T:28082 P:12528'
G[12530]='L20 A:28214 T:28082 P:12528'	-- before Whiterock input it was P:B12529
G[12531]='L20 A:28138 T:28082 P:12532'
G[12532]='L20 A:28138 T:28138 P:12533+12534'
G[12533]='L20 A:28082 T:28082 P:12529+12530'
G[12534]='L20 A:28138 T:28082 P:12529+12530'
G[12535]='L20 A:28082 T:28082 P:12532'
G[12536]='L20 A:28082 T:28216 P:12531+12535'
G[12537]='L20 A:28216 T:28216 P:12536'
G[12538]='L20 A:28216 T:28216 P:12536'
G[12539]='L20 A:28216 T:28082 P:12537+12538'
G[12540]='L20 A:28082 T:28217 P:12539'
G[12541]='K2 L20 A:28205 T:28205'
G[12542]='L15 A:27348 T:28228'
G[12543]='L20 A:28191 T:28191 P:12526'
G[12544]='L20 A:28191 T:27986 P:12543'
G[12545]='L15 A:28228 T:28228 O:12542'
G[12546]='L20 A:27801 T:27801 P:12797'
G[12547]='L20 A:28092 T:28092 P:12548'
G[12548]='L20 A:27801 T:28092 P:12613'
G[12549]='L20 A:28031 T:28031 P:12525+12523'
G[12550]='L20 A:28031 T:28031 P:12549'
G[12551]='L20 A:28032 T:28032 P:12520+12549'
G[12552]='L20 A:28283 T:28283 P:12598'
G[12553]='L20 A:28284 T:28284 P:12598'
G[12554]='L20 A:28283 T:28283 P:12552'
G[12555]='L20 A:28284 T:28284 P:12583'
G[12556]='L20 A:27986 T:27986 P:12544'
G[12557]='L20 A:28205 T:28205 P:B12596'
G[12558]='L20 A:28031 T:28031 P:12550'
G[12559]='L20 A:27801 T:27801 P:12621'
G[12560]='L20 A:28032 T:28032 P:12551'
G[12561]='L20 A:27801 T:27801 O:12803'
G[12562]='L20 A:28309 T:28309 P:1'	-- TODO: Determine real P:
G[12563]='K2 L20 A:28039 T:28039'
G[12564]='K2 L20 A:28042 T:28042'
G[12565]='L20 A:28062 T:1190535'
G[12566]='FH L10 A:28314 T:24129'
G[12567]='K1 L20 A:1190535 T:1190535 P:12565'
G[12568]='K2 L20 A:28044 T:28044'
G[12569]='L20 A:28032 T:28032 P:12560'
G[12570]='K32 L20 A:28217 T:28027 P:12540'
G[12571]='L20 A:28027 T:28027 P:12570'
G[12572]='L20 A:28120 T:28027 P:12570'	-- prior to Whiterock data this was  P:B12571
G[12573]='L20 A:28027 T:28027 P:12571'
G[12574]='L20 A:28027 T:28114 P:12573+12572'
G[12575]='L20 A:28114 T:28114 P:12574'
G[12576]='L20 A:28114 T:28114 P:12574'
G[12577]='L20 A:28114 T:28027 P:12575+12576'
G[12578]='L20 A:28027 T:28122 P:12577'
G[12579]='L20 A:28122 T:28122 P:12578'
G[12580]='L20 A:28122 T:28122 P:12578'
G[12581]='L20 A:28122 T:1190777 P:12579+12580'
G[12582]='SP K2 L20 A:28668 T:28668 P:12581'
G[12583]='L20 A:28284 T:28284 P:12553'
G[12584]='L20 A:28044 T:28244 P:12552'
G[12585]='K2 L20 A:28043 T:28043'
G[12587]='K2 L20 A:28039 T:28039 P:12596'
G[12588]='K2 L20 A:28042 T:28042'
G[12589]='L20 A:28328 T:28328 P:12525+12523'
G[12590]='L20 E28153'
G[12591]='K2 L20 A:28044 T:28044'
G[12592]='L20 A:28328 T:28328 P:12589'
G[12593]='L8 CK A:25462 T:28357'
G[12594]='K2 L20 A:28043 T:28043'
G[12595]='L20 A:27986 T:28376 P:12569+12556+12558'
G[12596]='L20 A:28039 T:28039 P:12740'
G[12597]='L20 A:28042 T:28042 P:B12596'
G[12598]='L20 A:28044 T:28044 P:B12596'
G[12599]='L20 A:28043 T:28043 P:B12596'
G[12603]='L20 A:28376 T:28376 P:12569+12556+12558'
G[12604]='K2 L20 A:28039 T:28039'
G[12605]='L20 A:28376 T:28376 P:12569+12556+12558'
G[12606]='L20 A:28044 T:28044 P:12598'
G[12607]='L20 A:28374 T:28374 P:12603+12605'
G[12608]='L20 A:28464 T:27801 P:12612'
G[12609]='L20 A:28045 T:28045 P:12799'
G[12610]='L20 A:28045 T:28045 P:12799'
G[12611]='L20 A:27801 T:27801 P:12561'
G[12612]='L20 A:27801 T:28464 P:12611'
G[12613]='L20 A:27801 T:27801 P:12559'
G[12614]='L20 A:28376 T:28376 P:12607'
G[12615]='L20 A:28479 T:1190602 P:1'
G[12616]='L30 E28153'
G[12617]='L20 A:27801 T:27801 P:12608'
G[12618]='SP K1 L20 A:1190602 T:1190602 P:12615'
G[12619]='L8 CK A:28357 T:28357 P:12593'
G[12620]='L20 A:27801 T:27801 P:12617+12660'
G[12621]='L20 A:27801 T:27801 P:12620'
G[12622]='L20 A:28484 T:28484 P:1'
G[12623]='L20 A:28062 T:28479 P:12516'
G[12624]='L20 A:28497 T:28497'
G[12627]='L20 A:28479 T:28479 P:12623'
G[12628]='L20 A:28479 T:28401 P:12627'
G[12629]='L20 A:28518 T:28518 P:12637'
G[12630]='L20 A:28518 T:28518 P:12884'
G[12631]='L20 A:100038660 T:28518 I:12633'	-- TODO: Determine the P:
G[12632]='L20 A:28401 T:28401 P:12628'
G[12633]='L20 A:100038673 T:28518 I:12631'	-- TODO: Determine the P: (seems you need to have gone through Drak'Tharon first, otherwise you get the other one)
G[12634]='L20 A:29157 T:29157 P:12520+12549'
G[12635]='L20 A:28527 T:28527 P:12627'
G[12636]='L8 CK A:28357 T:25462 P:12848'
G[12637]='L20 A:28518 T:28518 P:12631'
G[12638]='L20 A:28518 T:28518 P:12633'
G[12639]='L20 A:28480 T:28480 P:12622'
G[12640]='L20 A:28484 T:28484 P:12622'
G[12641]='L8 CK A:25462 T:25462 P:12636'
G[12642]='L20 A:28401 T:28561 P:12632'
G[12643]='L20 A:28518 T:28518 P:12638'
G[12644]='L20 A:29157 T:29157 P:12634'
G[12645]='L20 A:29157 T:29157 P:12644'
G[12646]='L20 A:28561 T:28561 P:12642'
G[12647]='L20 A:28561 T:28561 P:12646'
G[12648]='L20 A:28518 T:28518 P:12629'
G[12649]='L20 A:28518 T:28518 P:12643'
G[12650]='L20 A:28527 T:28527 P:12635'
G[12651]='L20 A:27986 T:28568 P:12560+12526+12550'
G[12652]='L20 A:28589 T:28589 P:B12648,B12649'
G[12653]='L20 A:28561 T:28401 P:12647'
G[12654]='L20 A:28568 T:28568 O:12651'
G[12655]='L20 A:28479 T:1190657 P:12632'
G[12656]='K1 L20 A:1190657 T:1190657 P:12655'
G[12657]='L8 CK A:25462 T:28444 P:12641'
G[12658]='L20 A:28374 T:28374 P:12603+12605'
G[12659]='L20 A:28484 T:28484 P:12640'
G[12660]='L20 A:27801 T:27801 P:12608'
G[12661]='L20 A:28518 T:528518 P:12648,12649'
G[12662]='L20 A:28480 T:28480 P:12640'
G[12663]='L20 A:28503 T:28503 I:12664'	-- perhaps P:12238	-- need to figure out the proper P for this
G[12664]='L20 A:28503 T:28503 P:B12661 I:12663'	-- perhaps I:12238	-- and this
G[12665]='L20 A:28401 T:28401 P:12653'
G[12666]='L20 A:28401 T:28401 P:12665'
G[12667]='L20 A:28401 T:28030 P:12666'
G[12668]='L20 A:28030 T:28030 P:12672'
G[12669]='L20 A:528518 T:528518 P:12661'
G[12670]='L8 CK A:28510 T:28377 P:12850'
G[12671]='L20 A:28746 T:28746 P:12699'
G[12672]='L20 A:28030 T:28030 P:12667'
G[12673]='L20 A:28503 T:28503 P:B12669'
G[12674]='L20 A:28030 T:28030 P:12668'
G[12675]='L20 A:28030 T:28401 P:12674'
G[12676]='L20 A:528518 T:528518 P:12677'
G[12677]='L20 A:528518 T:528518 P:12669'
G[12678]='L8 CK A:28377 T:28377 P:12670'
G[12679]='L8 CK A:28647 T:28647 P:12670'
G[12680]='L8 CK A:28653 T:28653 P:12670'
G[12681]='L20 A:28771 T:28771 P:12603+12605'
G[12683]='L20 A:28771 T:28771'
G[12684]='L20 A:28401 T:28401 P:12675'
G[12685]='L20 A:28401 T:28479 P:12684'
G[12686]='L20 A:28503 T:28503 P:B12677'
G[12687]='L8 CK A:28653 T:28653 P:12680'
G[12688]='K32 L20 A:28787 T:27986'
G[12689]='SP K2 L20 A:28667 T:28667 P:12581'
G[12690]='L20 A:28503 T:28503 P:B12676'
G[12691]='L20 A:1190768 T:1190768'
G[12692]='L20 A:28668 T:28138 P:12582'
G[12695]='L20 A:28667 T:28027 P:12689'
G[12696]='L20 A:28266 T:28746 P:12523'
G[12697]='L8 CK A:28377 T:28658 P:12678+12679+12687+12733'
G[12698]='L8 CK A:28658 T:28658 P:12697'
G[12699]='L20 A:28746 T:28746 P:12523'
G[12700]='L8 CK A:28658 T:28377 P:12698'
G[12701]='L8 CK A:28377 T:28377 P:12700'
G[12702]='K2 L20 A:28138 T:28138 P:12692+T45044999'
G[12703]='K2 L20 A:29146 T:28106 P:T45044999 I:12759,12760'
G[12704]='K2 L20 A:28027 T:28027 P:T45144999'
G[12705]='K2 L20 A:29149 T:28107 P:T45144999 I:12761,12762'
G[12706]='L8 CK A:28377 T:28444 P:12701'
G[12707]='L20 A:28484 T:28484 P:12685'
G[12708]='L20 A:28480 T:28480 P:12662+12685'
G[12709]='L20 A:28527 T:28527 P:12685+13549'
G[12710]='L20 A:28503 T:28503 P:12690'
G[12711]='SP L8 CK A:1190917 T:1190917 P:12670'
G[12712]='L20 A:528401 T:528401 P:12685'
G[12713]='L20 A:528518 T:528518 P:12676'
G[12714]='L8 CK A:28444 T:28907 P:12706'
G[12715]='L8 CK A:28907 T:28911 P:12714'
G[12716]='L8 CK A:28919 T:28919 P:12714'
G[12717]='L8 CK A:28919 T:28919 P:12716'
G[12718]='K1 L8 CK A:1190936 T:1190936 P:12717'
G[12719]='L8 CK A:28911 T:28911 P:12715'
G[12720]='L8 CK A:28911 T:28911 P:12719'
G[12721]='L20 A:28401 T:28479 P:12712'
G[12722]='L8 CK A:28910 T:28910 P:12715'
G[12723]='L8 CK A:28911 T:28914 P:12716+12722+12720'
G[12724]='L8 CK A:28914 T:28914 P:12723'
G[12725]='L8 CK A:28913 T:28912 P:12723'
G[12726]='K2 L20 A:29006 T:29006 P:T45144999 I:12735,12736,12737'
G[12727]='L8 CK A:28912 T:28913 P:12725'
G[12728]='L10 A:25291 T:25291 P:11582'
G[12729]='L20 A:28479 T:528401 P:12721'
G[12730]='L20 A:528401 T:528401 P:12729'
G[12732]='K2 L20 A:29043 T:29043 P:12692+T45044999 I:12734,12741,12758'
G[12733]='L8 CK A:29047 T:29047 P:12670'
G[12734]='K2 L20 A:29043 T:29043 P:T45044999 I:12732,12741,12758'
G[12735]='K2 L20 A:29006 T:29006 P:T45144999 I:12726,12736,12737'
G[12736]='K2 L20 A:29006 T:29006 P:T45144999 I:12726,12735,12737'
G[12737]='K2 L20 A:29006 T:29006 P:T45144999 I:12726,12735,12736'
G[12738]='L8 CK A:28913 T:29053 P:12727'
G[12739]='FH L8 RT CK A:29053 T:29053 P:12738'
G[12740]='L20 A:28059 T:28059'
G[12741]='K2 L20 A:29043 T:29043 P:T45044999 I:12732,12734,12758'
G[12742]='FA L8 RH RK CK A:29053 T:29053 P:12738'
G[12743]='FA L8 RE CK A:29053 T:29053 P:12738'
G[12744]='FA L8 RF CK A:29053 T:29053 P:12738'
G[12745]='FA L8 RN CK A:29053 T:29053 P:12738'
G[12746]='FA L8 RD CK A:29053 T:29053 P:12738'
G[12747]='FH L8 RB CK A:29053 T:29053 P:12738'
G[12748]='FH L8 RO CK A:29053 T:29053 P:12738'
G[12749]='FH L8 RL RZ CK A:29053 T:29053 P:12738'
G[12750]='FH L8 RU CK A:29053 T:29053 P:12738'
G[12751]='L8 CK A:29053 T:28913 P:12739,12742,12743,12744,12745,12746,12747,12748,12749,12750,28649,28650'
G[12752]='FH L10 RU E28153'
G[12753]='FA L20 RF E28153'
G[12754]='L8 CK A:28914 T:28914 P:12751+12724'
G[12755]='L8 CK A:28914 T:29077 P:12754'
G[12756]='L8 CK A:29077 T:28914 P:12755'
G[12757]='L8 CK A:28914 T:28444 P:12756'
G[12758]='K2 L20 A:29043 T:29043 P:T45044999 I:12732,12734,12741'
G[12759]='K2 L20 A:29146 T:28106 P:T45044999 I:12703,12760'
G[12760]='K2 L20 A:29146 T:28106 P:12692+T45044999 I:12703,12759'
G[12761]='K2 L20 A:29149 T:28107 P:T45144999 I:12705,12762'
G[12762]='K2 L20 A:29149 T:28107 P:T45144999 I:12705,12761'
G[12763]='fH L15 A:26666 T:29137'
G[12766]='FA L15 A:26443 T:27803 P:12119'
G[12767]='FH L15 A:26443 T:27804 P:12122'
G[12768]='FA L15 A:27506 T:26443 P:12418'
G[12769]='FH L15 A:27763 T:26443 P:12450'
G[12770]='fA L15 A:26212 T:29137'
G[12771]='FA L20 RF E32305'
G[12772]='FA L10 RE E28153'
G[12773]='FA L10 RE E28153'
G[12774]='FA L20 RH RK E28153'
G[12775]='FA L10 RH RK E28153'
G[12776]='FA L10 RD E28153'
G[12777]='FA L10 RD E28153'
G[12778]='L8 CK A:28444 T:29110 P:12757'
G[12779]='L8 CK A:25462 T:25462 P:12778'
G[12782]='FH L20 RB E28153'
G[12783]='FH L10 RO E28153'
G[12784]='FH L10 RT E28153'
G[12785]='FH L10 RO E28153'
G[12786]='FH L10 RT E28153'
G[12787]='FH L10 RU E28153'
G[12788]='FH L10 RB E28153'
G[12789]='L20 A:28228 T:29137 P:12545'
G[12790]='L10 A:29156 T:29156 O:12791,12794,12796'
G[12791]='FH L10 A:26471,29155,29159,29160,29162 T:29156 I:12794,12796'
G[12792]='L20 A:28039 T:29137 P:1'
G[12793]='L20 A:28479 T:29137 P:1'
G[12794]='FA L10 A:23729,26673,27158,29158,29161 T:29156 I:12791,12796'
G[12795]='L20 A:28532 T:28059 P:12630'
G[12796]='L10 A:29169 T:29156 I:12791,12794'
G[12797]='L20 A:28092 T:27801 P:12547'
G[12798]='L5145 A:100037164 T:30481'
G[12799]='L20 A:28045 T:28045'
G[12800]='L8 CK A:29110 T:31082 P:12779'
G[12801]='L8 CK A:31082 T:29173 P:12800'
G[12802]='L15 A:1188365 T:26701 P:12042'
G[12803]='L20 A:28746 T:27801'
G[12804]='L20 A:28046 T:28046 P:12520'
G[12805]='L20 A:27801 T:27801 P:12611'
G[12806]='L25 A:29343 T:29344'
G[12807]='L25 A:29344 T:29344 P:12806'
G[12808]='FA L20 RN E28153'
G[12809]='FA L20 RN E28153'
G[12810]='L25 A:29344 T:29344 P:12807'
G[12811]='FH L10 RL RZ E28153'
G[12812]='FH L10 RL RZ E28153'
G[12813]='K2 L25 A:29396 T:29396'
G[12814]='L25 A:29344 T:29405 P:12810'
G[12815]='K2 L25 A:29405 T:29405'
G[12816]='FH L1 E28153'
G[12817]='FA L1 E28153'
G[12818]='L25 A:29431 T:29431'
G[12819]='L25 A:29431 T:29431 P:12818'
G[12820]='L25 A:29428 T:29428 P:12826'
G[12821]='L25 A:29428 T:29428 P:12820+12832'
G[12822]='L25 A:29428 T:29428 P:12821'
G[12823]='L25 A:29432 T:29432 P:12821'
G[12824]='L25 A:29432 T:29428 P:12823'
G[12826]='L25 A:29431 T:29428 P:12819'
G[12827]='L25 A:29428 T:29428'
G[12828]='L25 A:29428 T:29428 P:12827+12836'
G[12829]='L25 A:29430 T:29430 P:12827+12836'
G[12830]='L25 A:29430 T:29430 P:12827+12836'
G[12831]='L25 A:29434 T:29434'
G[12832]='K32 L25 A:29434 T:29428 P:12831'
G[12833]='K2 L25 A:29428 T:29428 P:12824'
G[12836]='L25 A:29428 T:29428'
G[12838]='K2 L25 A:29456 T:29456'
G[12839]='L25 A:100040666 T:29344'
G[12840]='L25 A:29344 T:29344 P:12839'
G[12841]='L25 A:29481 T:29481 P:12846'
G[12842]='L8 CK A:28357 T:28357 P:12619'
G[12843]='L25 A:29473 T:29473'
G[12844]='L25 A:29473 T:29473'
G[12846]='L25 A:29473 T:29481 P:12843'
G[12847]='K512 L25 A:29344 T:29560 P:12840'	-- PM5
G[12848]='L8 CK A:28357 T:28357 P:12842'
G[12849]='SP L8 CK A:28472 T:28472 P:12657'
G[12850]='L8 CK A:28444 T:28510 P:12657'
G[12851]='L25 A:29592 T:29592 P:12972'
G[12852]='K512 L25 A:29560 T:29344 P:12847'	-- PM5
G[12853]='L25 A:30490 T:29431'
G[12854]='FA L25 A:29650 T:29650'
G[12855]='FA L25 A:29650 T:29579 P:12854'
G[12856]='L25 A:29592 T:29592 P:12851'
G[12857]='L20 A:1191728 T:29690'
G[12858]='FA L25 A:29579 T:29579 P:12855'
G[12859]='L20 A:29733 T:29733'
G[12860]='FA L25 A:29579 T:29579 P:12858'
G[12861]='L20 A:29690 T:29690'
G[12862]='FA L25 A:29428 T:29744 P:12822+12824'
G[12863]='FA L25 A:29743 T:29727'
G[12864]='FA L25 A:29727 T:29727 P:12863'
G[12865]='FA L25 A:29732 T:29732 P:12863'
G[12866]='FA L25 A:29727 T:29727 P:12864'
G[12867]='FA L25 A:29732 T:29732 P:12865'
G[12868]='FA L25 A:29727 T:29727 P:12866'
G[12869]='FA K2 L25 A:29732 T:29732'
G[12870]='FA L25 A:29744 T:29744'
G[12871]='FA L25 A:29579 T:29743 P:12872'
G[12872]='FA L25 A:1191760 T:29579 P:13415'
G[12873]='FA L25 A:29743 T:29593 P:12871'
G[12874]='FA L25 A:29593 T:29593 P:12873'
G[12875]='FA L25 A:29593 T:29751 P:12874'
G[12876]='FA L25 A:29732 T:29732 P:12874'
G[12877]='FA L25 A:29751 T:30052 P:12875'
G[12878]='FA L25 A:30052 T:30548 P:12986'
G[12879]='FA L25 A:30548 T:30082 P:12878'
G[12880]='FA L25 A:30082 T:30382 P:12879'
G[12882]='FH L25 A:30472 T:30472'
G[12883]='L20 A:1191766 T:29687 P:12902'
G[12884]='L20 A:29687 T:28518 P:12883'
G[12885]='FA L25 A:29579 T:29801 P:12872'
G[12886]='L25 A:29796 T:29445 P:13062'
G[12887]='FA L25 A:29799 T:29804'
G[12888]='L25 A:100041267 T:29806 P:PN415'
G[12889]='L25 A:29806 T:1191761 P:12888'
G[12891]='L25 A:29804 T:29804 P:12887,12892'
G[12892]='FH L25 A:29795 T:29804 P:12887'
G[12893]='L25 A:29804 T:29804 P:12891'
G[12894]='L20 A:29687 T:29689 P:12883'
G[12895]='FH L25 A:29651 T:29651'
G[12896]='FA L25 A:29804 T:29799'
G[12897]='FH L25 A:29804 T:29795 P:12896'
G[12898]='FA L25 A:29799 T:29343 P:12896,12897'
G[12899]='FH L25 A:29795 T:29343 P:12898'
G[12900]='L25 A:29839 T:29839 P:13063'
G[12901]='L20 A:29688 T:29688 P:12894'
G[12902]='L20 A:29687 T:1191766'
G[12903]='L20 A:29689 T:29689 P:12894'
G[12904]='L20 A:29455 T:29455 P:12894'
G[12905]='L25 A:29481 T:29885 P:12841'
G[12906]='L25 A:29885 T:29885 P:12905'
G[12907]='L25 A:29885 T:29885 P:12906'
G[12908]='L25 A:29885 T:29481 P:12907'
G[12909]='FH L25 A:29651 T:29855 P:12895'
G[12910]='FH L25 A:29855 T:29579 P:12909'
G[12912]='L20 A:29647 T:29688 P:12894'
G[12913]='FH L25 A:29579 T:29937 P:12910'
G[12914]='L20 A:29688 T:29688 P:12912'
G[12915]='L25 A:29445 T:29445 P:13064'
G[12916]='L20 A:29688 T:29647 P:12914'
G[12917]='FH L25 A:29937 T:29937 P:12913'
G[12919]='L20 A:29647 T:29689 P:12916'
G[12920]='FH L25 A:29651 T:29651 P:12917'
G[12921]='L25 A:29481 T:29975 P:12908'
G[12922]='L25 A:100041556 T:1192060 P:13064'
G[12924]='L25 A:29445 T:30127 P:12915+12956'
G[12925]='L25 A:30041 T:30041 P:12841'
G[12926]='FH L25 A:29651 T:29579 P:12920'
G[12927]='FH L25 A:29579 T:29579 P:12926'
G[12928]='FH L25 A:1191760 T:29579 P:13416'
G[12929]='FH L25 A:29579 T:29801 P:12928'
G[12930]='L25 A:29801 T:29801 O:12885,12929'
G[12931]='L25 A:29801 T:29801 P:12930'
G[12932]='K512 L20 A:30007 T:30009 P:X9977 O:12974'	-- PM5
G[12933]='K512 L20 A:30007 T:30009 P:12932,12954'	-- PM5
G[12934]='K512 L20 A:30007 T:30009 P:12933'	-- PM5
G[12935]='K512 L20 A:30007 T:30009 P:12934'	-- PM5
G[12936]='K512 L20 A:30007 T:30009 P:12935'	-- PM5
G[12937]='L25 A:29801 T:29801 P:12930'
G[12938]='L25 A:29343 T:30002 P:12898,12899'
G[12939]='L25 A:30002 T:30002 P:12938'
G[12940]='SP HW K16 L7864576 A:1191878 T:1191878'
G[12941]='SP HW K16 L7864576 A:1191879 T:1191879'
G[12942]='L25 A:29997 T:29997 P:12841'
G[12943]='L25 A:30002 T:30002 P:12939'
G[12944]='SP HW FA K16 L7864576 A:1191882 T:1191882'
G[12945]='SP HW FA K16 L7864576 A:1191883 T:1191883'
G[12946]='SP HW FH K16 L7864576 A:1191880 T:1191880'
G[12947]='SP HW FH K16 L7864576 A:1191881 T:1191881'
G[12948]='K512 L20 A:30007 T:30009 P:12936'	-- PM5
G[12949]='L25 A:30056 T:30056'
G[12950]='SP HW K16 L7864576 A:1192018 T:1192018'
G[12951]='L25 A:30056 T:29343 P:12949'
G[12953]='L25 A:1192072 T:29997 P:1'
G[12954]='K512 L20 A:30007 T:30009 P:9977 O:12974'	-- PM5
G[12955]='L25 A:30074 T:30074 P:12938'
G[12956]='L25 A:1192060 T:29445 P:12922'
G[12957]='L25 A:29801 T:29801 P:12931+12937'	-- TODO: Verify requires 12931
G[12958]='SP K2 L10 A:28701 T:28701 P:13041+PJ375 I:12959,12960,12961,12962,12963'
G[12959]='K2 L10 A:28701 T:28701 P:13041+PJ375 I:12958,12960,12961,12962,12963'
G[12960]='K2 L10 A:28701 T:28701 P:13041+PJ375 I:12958,12959,12961,12962,12963'
G[12961]='K2 L10 A:28701 T:28701 P:13041+PJ375 I:12958,12959,12960,12962,12963'
G[12962]='K2 L10 A:28701 T:28701 P:13041+PJ375 I:12958,12959,12960,12961,12963'
G[12963]='K2 L10 A:28701 T:28701 P:13041+PJ375 I:12958,12959,12960,12961,12962'
G[12964]='L25 A:29801 T:29801 P:12931+12937'	-- TODO: Verify requires 12931
G[12965]='L25 A:29801 T:29801 P:12957+12964'	-- TODO: Verify requires 12957
G[12966]='L25 A:30105 T:30099 P:T45F41999'
G[12967]='L25 A:30099 T:30099 P:12966'
G[12968]='L25 A:29997 T:29997 P:12841'
G[12969]='L25 A:29975 T:29975 P:12921'
G[12970]='L25 A:29975 T:29975 P:12969'
G[12971]='L25 A:29975 T:29975 P:12970'
G[12972]='L25 A:29975 T:29592 P:12971'
G[12973]='FA L25 A:30382 T:30401 P:12880'
G[12974]='L20 A:30137 T:30007'
G[12975]='L25 A:30105 T:30105 P:12924'
G[12976]='L25 A:30105 T:30127 P:12975'
G[12977]='K2 L25 A:1192078 T:1192078 P:12976'
G[12978]='L25 A:30152 T:30152 P:12957+12964'	-- TODO: Verify requires 12957
G[12979]='L25 A:100042203 T:30152 P:C12978'
G[12980]='L25 A:30152 T:30152 P:12979'
G[12981]='K2 L25 A:1192071 T:1192071 P:12967'
G[12982]='L25 A:30218 T:30218 P:13085'
G[12983]='L25 A:29839 T:29839 P:12900'
G[12984]='L25 A:29801 T:29801 P:12980'
G[12985]='L25 A:30127 T:30127 P:12967'
G[12986]='FA L25 A:30052 T:30052 P:12877'
G[12987]='L25 A:30127 T:30127 P:12985'
G[12988]='L25 A:29801 T:29801 P:12984'
G[12989]='L25 A:29839 T:29839 P:12900'
G[12991]='L25 A:30152 T:30152 P:12984'
G[12992]='L25 A:30216 T:30216'
G[12993]='L25 A:29801 T:29801 P:12988+12991'	-- TODO: Verify requires 12988
G[12994]='K2 L25 A:30294 T:30294 P:T45F50999'
G[12995]='K2 L25 A:29343 T:29343'
G[12996]='L25 A:29839 T:29839 P:12983'	-- note that 4.2 has the space at the end of the name
G[12997]='L25 A:29839 T:29839 P:12996'
G[12998]='L25 A:29801 T:29801 P:12993'
G[12999]='L25 A:30074 T:30232 P:12955'
G[13000]='fH L25 A:30247 T:30247'
G[13001]='L25 A:30252 T:30252 P:T45F41999'
G[13003]='K2 L25 A:1192079 T:1192079 P:13001'
G[13005]='L25 A:30295 T:30295 P:1'
G[13006]='K2 L25 A:1192080 T:1192080 P:12985'
G[13007]='L25 A:29801 T:29801 P:12998'
G[13008]='L25 A:30223 T:30223 P:13036'
G[13009]='L25 A:30127 T:29445 P:12924'
G[13010]='L25 A:29445 T:30390 P:13051'
G[13011]='L25 A:30105 T:30105 P:T45F41999'
G[13012]='SP HL K16 L7864576 A:30348 T:30348'
G[13013]='SP HL K16 L7864576 A:30357 T:30357'
G[13014]='SP HL K16 L7864576 A:30358 T:30358'
G[13015]='SP HL K16 L7864576 A:30359 T:30359'
G[13016]='SP HL K16 L7864576 A:30360 T:30360'
G[13017]='SP HL K16 L7864576 A:30531 T:30531'
G[13018]='SP HL K16 L7864576 A:30362 T:30362'
G[13019]='SP HL K16 L7864576 A:30363 T:30363'
G[13020]='SP HL K16 L7864576 A:30375 T:30375'
G[13021]='SP HL K16 L7864576 A:30536 T:30536'
G[13022]='SP HL K16 L7864576 A:30533 T:30533'
G[13023]='SP HL K16 L7864576 A:30534 T:30534'
G[13024]='SP HL K16 L7864576 A:30365 T:30365'
G[13025]='SP HL K16 L7864576 A:30367 T:30367'
G[13026]='SP HL K16 L7864576 A:30368 T:30368'
G[13027]='SP HL K16 L7864576 A:30369 T:30369'
G[13028]='SP HL K16 L7864576 A:30370 T:30370'
G[13029]='SP HL K16 L7864576 A:30371 T:30371'
G[13030]='SP HL K16 L7864576 A:30372 T:30372'
G[13031]='SP HL K16 L7864576 A:30373 T:30373'
G[13032]='SP HL K16 L7864576 A:30374 T:30374'
G[13033]='SP HL K16 L7864576 A:30364 T:30364'
G[13034]='FH L25 A:30381 T:30381 O:13426'
G[13035]='L25 A:30295 T:30295 P:1'
G[13036]='L25 A:28179 T:30223 O:13226,13227'
G[13037]='FH L25 A:30381 T:30381 P:13034'
G[13038]='FH L25 A:30395 T:30381 P:13037'
G[13039]='L25 A:30224 T:30224'
G[13040]='L25 A:30226 T:30226'
G[13041]='L10 A:28701 T:28701 P:PJ375'
G[13042]='L25 A:30232 T:30232 P:12999'
G[13043]='L25 A:100042772 T:30232'
G[13044]='L25 A:30223 T:30227 P:13008'
G[13045]='L25 A:30227 T:28179 P:13044'
G[13046]='K2 L25 A:1192524 T:1192524 P:T45F62999'
G[13047]='L25 A:30295 T:30105 P:1'
G[13048]='FH L25 A:30381 T:30381 P:1'
G[13049]='FH L25 A:30381 T:30381 P:1'
G[13050]='L25 A:29445 T:29445 P:13009'
G[13051]='L25 A:29445 T:29445 P:13050'
G[13054]='L25 A:30247 T:30469'
G[13055]='L25 A:30469 T:30469 P:13054'
G[13056]='L25 A:30469 T:30469 P:13055'
G[13057]='L25 A:30390 T:30295 P:13010'
G[13058]='FH L25 A:30381 T:30381 P:1'
G[13059]='L25 A:30406 T:30406 P:12999'
G[13060]='FH L25 A:29428 T:30472 P:12823'
G[13061]='L25 A:29839 T:29975 P:12997'
G[13062]='L25 A:29975 T:29796 P:13061'
G[13063]='L25 A:29592 T:29839 P:12856'
G[13064]='L25 A:29445 T:29445 P:12886'
G[13065]='SP HL K16 L7864576 A:30537 T:30537'
G[13066]='SP HL K16 L7864576 A:30535 T:30535'
G[13067]='SP HL K16 L7864576 A:30538 T:30538'
G[13068]='L25 A:31044 T:30562 P:13141'
G[13069]='K2 L25 A:30074 T:30074'
G[13070]='L25 A:28179 T:30657 P:13045'
G[13071]='K2 L25 A:30216 T:30216 P:12992'
G[13072]='L25 A:30562 T:31044 P:13068'
G[13073]='L25 A:31044 T:11832 P:13072'
G[13074]='L25 A:11832 T:11832 P:13073'
G[13075]='L25 A:11832 T:30562 P:13074'
G[13076]='L25 A:30562 T:31044 P:13075'
G[13077]='L25 A:31044 T:26917 P:13076'
G[13078]='L25 A:26917 T:26917 P:13077'
G[13079]='L25 A:26917 T:30562 P:13078'
G[13080]='L25 A:30562 T:31044 P:13079'
G[13081]='L25 A:31044 T:18481 P:13080'
G[13082]='L25 A:18481 T:30562 P:13081'
G[13083]='L25 A:1192833 T:31044 P:13082'
G[13084]='L25 A:30002 T:30002'
G[13085]='L25 A:29343 T:30218'
G[13086]='L25 A:30657 T:30657 P:13070'
G[13087]='L10 A:26905 T:26905 P:PC350 I:13088'
G[13088]='L10 A:26989 T:26989 P:PC350 I:13087'
G[13089]='L10 A:26953 T:26953 P:PC350 I:13090'
G[13090]='L10 A:26972 T:26972 P:PC350 I:13089'
G[13091]='L25 A:30232 T:30232 P:13043'
G[13092]='L25 A:30232 T:30232 P:12999'
G[13093]='K1 L25 A:30232 T:30232 P:13092'
G[13094]='L10 A:26110 T:26110'
G[13095]='L10 A:26110 T:26110 P:1'
G[13096]='L19022 E31961'
G[13097]='L1 A:28401 T:30671 P:12730 Z13329'
G[13098]='L19022 E31961'
G[13099]='L1 A:28527 T:30676 Z13329'
G[13100]='FA K2 L10 A:28705 T:29527 P:PC350 I:13101,13102,13103,13107'
G[13101]='FA K2 L10 A:28705 T:29049 P:PC350 I:13100,13102,13103,13107'
G[13102]='FA K2 L10 A:28705 T:29532 P:PC350 I:13100,13101,13103,13107'
G[13103]='FA K2 L10 A:28705 T:28718 P:PC350 I:13100,13101,13102,13107'
G[13104]='L25 XK A:30677 T:30596 P:13086'
G[13105]='L25 CK A:30677 T:30596 P:13086'
G[13106]='L25 A:29343 T:30631'
G[13107]='FA K2 L10 A:28705 T:28160 P:PC350 I:13100,13101,13102,13103'
G[13108]='L19792 A:30105 T:30105 P:13047 Z13329'
G[13109]='L19792 A:30105 T:30105 P:13047 Z13329'	-- should this be P:B13108 instead?
G[13110]='L25 A:30683 T:30683 P:13104,13105'
G[13111]='L19022 E31961'
G[13112]='FH K2 L10 A:29631 T:29527 P:PC350 I:13113,13114,13115,13116'
G[13113]='FH K2 L10 A:29631 T:29049 P:PC350 I:13112,13114,13115,13116'
G[13114]='FH K2 L10 A:29631 T:29532 P:PC350 I:13112,13113,13115,13116'
G[13115]='FH K2 L10 A:29631 T:28718 P:PC350 I:13112,13113,13114,13116'
G[13116]='FH K2 L10 A:29631 T:28160 P:PC350 I:13112,13113,13114,13115'
G[13117]='L25 A:30631 T:30631'
G[13118]='L25 A:30596 T:30596 P:13104,13105'
G[13119]='L25 A:30631 T:30631'
G[13120]='L25 A:30631 T:30631'
G[13121]='L25 A:30232 T:30232 P:13091'
G[13122]='L25 A:30596 T:30596 P:13104,13105'
G[13124]='L20 A:26117 T:27658 P:1'
G[13125]='L25 A:30596 T:30596 P:13118+13122'
G[13126]='L20 A:27658 T:28012 P:13124'
G[13127]='L20 A:28012 T:28012 P:13126'
G[13128]='L20 A:28012 T:26117 P:13127'
G[13129]='L15 A:55677 T:55677'
G[13130]='L25 A:30686 T:30686 P:13104,13105'
G[13131]='L20 A:30871 T:30871'
G[13132]='L20 A:30871 T:30871'
G[13133]='L25 A:30232 T:30232 P:13121'
G[13134]='L25 A:30631 T:30631'
G[13135]='L25 A:30714 T:30714 P:13104,13105'
G[13136]='L25 A:100043242 T:30708'
G[13137]='K512 L25 A:30232 T:30232 P:13133'	-- PM5
G[13138]='L25 A:30708 T:30708'
G[13139]='L25 A:30683 T:30677 P:13110+13124+13130+13135'
G[13140]='L25 A:30708 T:30708'
G[13141]='L25 A:30677 T:30683 P:13139'
G[13142]='K512 L25 A:30232 T:30232 P:13137'	-- PM5
G[13143]='L25 A:30944 T:30944 P:13155'
G[13144]='L25 A:30631 T:30631'
G[13145]='L25 A:30944 T:30944 P:13143'
G[13146]='L25 A:30944 T:30944'
G[13147]='L25 A:30944 T:30944'
G[13148]='K1 L10 A:100043297 T:28701 P:PJ375'
G[13149]='L25 A:26527 T:27915'
G[13151]='L25 A:27915 T:30997 P:13149'
G[13152]='L25 A:30631 T:30631'
G[13153]='FA K4 L25 A:31051 T:31051'
G[13154]='FA K4 L25 A:31052 T:31052'
G[13155]='L25 A:30946 T:30944'
G[13156]='FA K4 L25 A:31054 T:31054'
G[13157]='L25 A:30683 T:31044 P:13141'
G[13158]='L19277 E32305'
G[13159]='L19277 E31961'
G[13160]='L25 A:30944 T:30944'
G[13161]='K512 L25 A:30944 T:30944'	-- PM5
G[13162]='K512 L25 A:30944 T:30944'	-- PM5
G[13163]='K512 L25 A:30944 T:30944'	-- PM5
G[13164]='K512 L25 A:30944 T:30944'	-- PM5
G[13165]='L8 CK A:29173 T:31084 P:12801'
G[13166]='L8 CK A:31084 T:31084 P:13165'
G[13167]='L18506 A:26653 T:26653 Z20338'
G[13168]='L25 A:30946 T:30946'
G[13169]='L25 A:30946 T:30946'
G[13170]='L25 A:30946 T:30946'
G[13171]='L25 A:30946 T:30946'
G[13172]='L25 A:30946 T:30946'
G[13174]='L25 A:30946 T:30946'
G[13177]='FA K4 L25 A:31036 T:31036'
G[13178]='FH K4 L25 A:31091 T:31091'
G[13179]='FA K4 L25 A:31036 T:31036'
G[13180]='FH K4 L25 A:31091 T:31091'
G[13181]='FA K4 L25 A:31153 T:31153'
G[13182]='L18506 A:26653 T:26653 Z20338'
G[13183]='FH K4 L25 A:31151 T:31151'
G[13185]='FH K4 L25 A:31107 T:31107'
G[13186]='FA K4 L25 A:31109 T:31109'
G[13187]='L15 A:26653 T:26653'
G[13188]='FA L8 CK A:31084 T:29611 P:13166'
G[13189]='FH L8 CK A:31084 T:39605,45530 P:13166'
G[13190]='L80 E31961'
G[13191]='FH K4 L25 A:31106 T:31106'
G[13192]='FH K4 L25 A:31101 T:31101'
G[13193]='FH K4 L25 A:31102 T:31102'
G[13194]='FH K4 L25 A:31053 T:31053'
G[13195]='FA K4 L25 A:31054 T:31054'
G[13196]='FA K4 L25 A:31052 T:31052'
G[13197]='FA K4 L25 A:31108 T:31108'
G[13198]='FA K4 L25 A:31051 T:31051'
G[13199]='FH K4 L25 A:31102 T:31102'
G[13200]='FH K4 L25 A:31106 T:31106'
G[13201]='FH K4 L25 A:31053 T:31053'
G[13202]='FH K4 L25 A:31101 T:31101'
G[13203]='L7866880 E31961'
G[13204]='L18764 A:100043512 T:26653 Z20338'
G[13205]='L17479 A:24111 T:24111 Z20338'
G[13206]='L10 A:24137 T:23780 Z20338'
G[13207]='L20 A:28070 T:28070'
G[13211]='L25 A:30708 T:30708'
G[13212]='L25 A:30631 T:30631'
G[13213]='L25 A:30232 T:31135 P:13142'
G[13214]='K512 L25 A:31135 T:31154'	-- PM5
G[13215]='K512 L25 A:31135 T:31154'	-- PM5
G[13216]='K512 L25 A:31135 T:31154'	-- PM5
G[13217]='K512 L25 A:31135 T:31154'	-- PM5
G[13218]='K512 L25 A:31135 T:31154'	-- PM5
G[13219]='K512 L25 A:31135 T:31154'	-- PM5
G[13220]='L25 A:30631 T:30631 P:13212'
G[13221]='FA L25 A:31279 T:31259'
G[13222]='FA K4 L25 A:31109 T:31109'
G[13223]='FH K4 L25 A:31107 T:31107'
G[13224]='FH L25 A:31240 T:30824'
G[13225]='FA L25 A:31241 T:30344'
G[13226]='FA L25 A:31259 T:28179'
G[13227]='FH L25 A:31261 T:28179'
G[13228]='FH L25 A:30824 T:30824'
G[13229]='FH L25 A:31279 T:31261'
G[13230]='L25 A:31273 T:30824'
G[13231]='FA L25 A:30344 T:30344'
G[13232]='L25 A:31304 T:30344'
G[13233]='FA K258 L25 A:30344 T:30344'
G[13234]='K258 L25 A:30824 T:30824'
G[13235]='L25 A:30631 T:30631 P:13220'
G[13236]='FH L25 A:32404 T:32404 P:13305'
G[13237]='FH L25 A:29795 T:29795 P:13260,14447,14448'
G[13238]='L25 A:30824 T:30825'
G[13239]='L25 A:30825 T:30825 P:13238'
G[13240]='L20048 E31961'
G[13241]='L20048 E32305'
G[13242]='FH L1 E32305'
G[13243]='L20048 E31961'
G[13244]='L1 E32305'
G[13248]='L1 E31961'
G[13249]='L1 E32305'
G[13250]='L80 E32305'
G[13253]='L80 E32305'
G[13254]='L1 E32305'
G[13255]='L80 E32305'
G[13256]='L1 E32305'
G[13258]='FH L25 A:29795 T:31440'
G[13259]='FH L25 A:31440 T:31440 P:13258'
G[13260]='FH L25 A:30824 T:29795'
G[13261]='K2 L25 A:30825 T:30825'
G[13262]='FH L25 A:31440 T:1193400 P:13259'
G[13263]='FH L25 A:1193400 T:1193195 P:13262'
G[13264]='FH L25 A:29795 T:29795'
G[13265]='SP L1 A:27001 T:27001 P:PT325 I:13268,13269,13270,13272'
G[13268]='SP L1 A:26914 T:26914 P:PT325 I:13265,13269,13270,13272'
G[13269]='SP L1 A:26964 T:26964 P:PT325 I:13265,13268,13270,13272'
G[13270]='SP L1 A:26969 T:26969 P:PT325 I:13265,13268,13269,13272'
G[13271]='FH L25 A:1193195 T:31237 P:13263'
G[13272]='SP L1 A:28699 T:28699 P:PT325 I:13265,13268,13269,13270'
G[13273]='FH L25 A:29579 T:29579 P:12928'
G[13274]='FH L25 A:29579 T:29579 P:13273'
G[13275]='FH L25 A:31237 T:31237 P:13271'
G[13276]='K2 L25 A:29795 T:29795'
G[13277]='FH K512 L25 A:29795 T:29795'	-- PM3
G[13278]='FH L25 A:29795 T:29795'
G[13279]='FH K512 L25 A:29795 T:29795 P:13277'	-- PM5
G[13280]='FA K258 L25 A:31776 T:31776 P:13296'
G[13281]='FH K2 L25 A:29795 T:29795'
G[13282]='FH L25 A:31237 T:29795 P:13275'
G[13283]='FH K258 L25 A:31781 T:31781 P:13293'
G[13284]='K2 L25 A:31737 T:31808'
G[13285]='FH L25 A:29579 T:29651 P:13274'
G[13286]='FA L25 A:30344 T:29799'
G[13287]='FA L25 A:29799 T:29799 P:13286'
G[13288]='FA L25 A:29799 T:29799'
G[13289]='FA K2 L30 A:29799 T:29799'
G[13290]='FA L25 A:30344 T:30345'
G[13291]='FA L25 A:30345 T:30345 P:13290'
G[13292]='K2 L25 A:30345 T:30345'
G[13293]='FH L25 A:30825 T:31781'
G[13294]='FA K512 L25 A:29799 T:29799'	-- PM3
G[13295]='FA K512 L25 A:29799 T:29799 P:13294'	-- PM5
G[13296]='FA L25 A:30345 T:31776'
G[13297]='FA K2 L25 A:29799 T:29799'
G[13298]='FA L25 A:29799 T:29799'
G[13300]='FA K2 L25 A:31259 T:31259'
G[13301]='K2 L25 A:31833 T:31834'
G[13302]='FH K2 L25 A:31261 T:31261'
G[13304]='FH L25 A:29795 T:31868 P:13282'
G[13305]='FH L25 A:32408 T:32404'
G[13306]='FH L25 A:29795 T:29795'
G[13307]='FH L25 A:29795 T:29795'
G[13308]='K512 L25 A:31892 T:31892'	-- PM3
G[13309]='K2 L25 A:31808 T:31808'
G[13310]='K2 L25 A:31834 T:31834'
G[13311]='L10285 A:100044158 T:30481'
G[13312]='FH K512 L25 A:29795 T:29795'	-- PM5
G[13313]='FH L25 A:30824 T:30824'
G[13314]='FA L25 A:30344 T:30344'
G[13315]='FA L25 A:29799 T:29799'
G[13316]='FH K512 L25 A:29795 T:29795'	-- PM5
G[13318]='L25 A:29799 T:29799'
G[13319]='FA L25 A:29799 T:29799'
G[13320]='FA L25 A:29799 T:30345'
G[13321]='FA L25 A:30345 T:30345 P:13320'
G[13322]='K2 L25 A:30345 T:30345'
G[13323]='K2 L25 A:29799 T:29799'
G[13324]='L336 A:100044259 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[13325]='L336 A:100044276 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[13326]='L336 A:100044326 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[13327]='L336 A:100044294 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[13328]='FH K512 L25 A:29795 T:29795'	-- PM5
G[13329]='FH K512 L25 A:29795 T:29795'	-- PM5
G[13330]='K2 L25 A:32301 T:32301'
G[13331]='FH K2 L25 A:30824 T:30824'
G[13332]='FA L25 A:29799 T:29799'
G[13333]='FA K2 L25 A:30344 T:30344'
G[13334]='FA L25 A:29799 T:29799'
G[13335]='FA K512 L25 A:29799 T:29799'	-- PM5
G[13336]='K2 L25 A:32302 T:32302'
G[13337]='FA K512 L25 A:29799 T:29799'	-- PM5
G[13338]='FA K512 L25 A:29799 T:29799'	-- PM5
G[13339]='FA K512 L25 A:29799 T:29799'	-- PM5
G[13340]='L25 A:32301 T:31834'
G[13341]='L25 A:32302 T:31808'
G[13342]='FA L25 A:29799 T:29799'
G[13343]='L15 A:27856 T:27856'
G[13344]='K2 L25 A:29799 T:29799'
G[13345]='FA K512 L25 A:29799 T:29799'	-- PM3
G[13346]='FA K512 L25 A:29799 T:29799 P:13345'	-- PM5
G[13347]='FA L1 E32305'
G[13348]='FH L25 A:32404 T:29795 P:13236'
G[13349]='FH L25 A:29795 T:29795 P:13348'
G[13350]='K2 L25 A:29799 T:29799'
G[13351]='FH L25 A:29795 T:29795'
G[13352]='L25 A:29795 T:29795'
G[13353]='K2 L25 A:29795 T:29795'
G[13354]='FH L25 A:29795 T:29795'
G[13355]='FH L25 A:29795 T:30825'
G[13356]='FH L25 A:30825 T:30825 P:13355'
G[13357]='K2 L25 A:30825 T:30825'
G[13358]='FH L25 A:29795 T:29795'
G[13359]='FH L25 A:32423 T:32423'
G[13360]='FH L25 A:32423 T:32497'
G[13361]='FH L25 A:32497 T:32497 P:13360'
G[13362]='FH L25 A:32497 T:29795 P:13361'
G[13363]='FH L25 A:29795 T:31044'
G[13364]='FH L25 A:31044 T:31044 P:13363'
G[13365]='K2 L25 A:29795 T:29795'
G[13366]='FH K512 L25 A:29795 T:29795'	-- PM3
G[13367]='FH K512 L25 A:29795 T:29795 P:13366'	-- PM5
G[13368]='K2 L25 A:29795 T:29795'
G[13372]='L30 A:100044569 T:26917'
G[13373]='FH L1 A:32430 T:32430 P:13379 Z13329'
G[13374]='L25 E31961'
G[13375]='L30 A:100044577 T:26917'
G[13379]='L19792 A:30825 T:32430 Z25860'
G[13380]='L1 A:32444 T:32444 P:13383 Z13329'
G[13381]='L25 E31961'
G[13384]='L30 A:27990 T:27990'
G[13385]='L30 A:27990 T:27990'
G[13386]='FA L25 A:29799 T:31444'
G[13387]='FA L25 A:31444 T:31444 P:13386'
G[13388]='FA L25 A:31444 T:1193400 P:13387'
G[13389]='FA L25 A:1193400 T:1193195 P:13388'
G[13390]='FA L25 A:1193195 T:31237 P:13389'
G[13391]='FA L25 A:31237 T:31237 P:13390'
G[13392]='FA L25 A:31237 T:29799 P:13391'
G[13393]='FA L25 A:29799 T:31868 P:13392'
G[13394]='FA L25 A:32408 T:32404'
G[13395]='FA L25 A:32404 T:32404 P:13394'
G[13396]='FA L25 A:32404 T:29799 P:13395'
G[13397]='FA L25 A:29799 T:29799 P:13396'
G[13398]='FA L25 A:32423 T:32423'
G[13399]='FA L25 A:32423 T:32497 P:13398'
G[13400]='FA L25 A:32497 T:32497 P:13399'
G[13401]='FA L25 A:32497 T:29799 P:13400'
G[13402]='FA L25 A:29799 T:31044 P:13401'
G[13403]='FA L25 A:31044 T:31044 P:13402'
G[13404]='FA K2 L1 A:32444 T:32444 Z13329'
G[13405]='L18177 E31961'
G[13406]='FH K2 L1 A:32430 T:32430 Z13329'
G[13407]='L18177 E31961'
G[13408]='K256 L10 XK A:18266 T:18266 P:10143,10483'
G[13409]='K256 L10 XK A:18267 T:18267'
G[13410]='K256 L10 CK A:18266 T:18266 P:10143,10483'
G[13411]='K256 L10 CK A:18267 T:18267'
G[13412]='L30 A:26110 T:32548 P:11919'	-- P:11919 is incorrect as it is available upon arrival in Borean Tundra
G[13413]='L30 A:32548 T:32548 P:13412'
G[13414]='K2 L30 A:32548 T:32548 P:13413'
G[13415]='FA L25 A:29579 T:1191760 P:12860'
G[13416]='FH L25 A:29579 T:1191760 P:12927'
G[13418]='FA L25 A:31081 T:30344'
G[13419]='FH K1 L25 A:31085 T:30824'
G[13420]='L25 A:100044725 T:32594'
G[13421]='K1 L25 A:32594 T:32594 P:T45F44999'
G[13422]='K2 L25 A:29796 T:29796 P:13061 I:13423,13424,13425'
G[13423]='K2 L25 A:29796 T:29796 P:13061 I:13422,13424,13425'	-- P:13061 seems to be wrong since I am able to get the quest with in log: 12925,12851(complete but not turned in),12942 and 12968
G[13424]='K2 L25 A:29796 T:29796 P:13061 I:13422,13423,13425'
G[13425]='K2 L25 A:29796 T:29796 P:13061 I:13422,13423,13424'
G[13426]='FH L25 A:29651 T:30381 P:13285'
G[13427]='FA L25 E32305'
G[13428]='FH L15617 E31961'
G[13429]='L30 A:18528 T:18528 P:10949 I:10985'	-- just a copy of 10985
G[13430]='L30 A:18481 T:18481 P:10588'
G[13431]='L30 M070 A:22421 T:22421'
G[13432]='L30 A:19935,19936 T:19935'
G[13433]='SP HW FA K16 L7864576 A:1194056 T:1194056'
G[13434]='SP HW FA K16 L7864576 A:1194057 T:1194057'
G[13435]='SP HW FA K16 L7864576 A:1194058 T:1194058'
G[13436]='SP HW FA K16 L7864576 A:1194059 T:1194059'
G[13437]='SP HW FA K16 L7864576 A:1194060 T:1194060'
G[13438]='SP HW FA K16 L7864576 A:1194061 T:1194061'
G[13439]='SP HW FA K16 L7864576 A:1194062 T:1194062'
G[13440]='SP HM FH L7864576 A:1194032 T:1194032'
G[13441]='SP HM FA L7864576 A:1194033 T:1194033'
G[13442]='SP HM FH L7864576 A:1194035 T:1194035'
G[13443]='SP HM FH L7864576 A:1194036 T:1194036'
G[13444]='SP HM FH L7864576 A:1194038 T:1194038'
G[13445]='SP HM FH L7864576 A:1194041 T:1194041'
G[13446]='SP HM FH L7864576 A:1194044 T:1194044'
G[13447]='SP HM FH L7864576 A:1194045 T:1194045'
G[13448]='SP HW FA K16 L7864576 A:1194063 T:1194063'
G[13449]='SP HM FH L7864576 A:1194049 T:1194049'
G[13450]='SP HM FA L7864576 A:1194034 T:1194034'
G[13451]='SP HM FA L7864576 A:1194037 T:1194037'
G[13452]='SP HW K16 L7864576 A:1194065 T:1194065'
G[13453]='SP HM FA L7864576 A:1194039 T:1194039'
G[13454]='SP HM FA L7864576 A:1194042 T:1194042'
G[13455]='SP HM FA L7864576 A:1194043 T:1194043'
G[13456]='SP HW K16 L7864576 A:1194066 T:1194066'
G[13457]='SP HM FA L7864576 A:1194046 T:1194046'
G[13458]='SP HM FA L7864576 A:1194048 T:1194048'
G[13459]='SP HW K16 L7864576 A:1194067 T:1194067'
G[13460]='SP HW K16 L7864576 A:1194068 T:1194068'
G[13461]='SP HW K16 L7864576 A:1194069 T:1194069'
G[13462]='SP HW K16 L7864576 A:1194070 T:1194070'
G[13463]='SP HW K16 L7864576 A:1194071 T:1194071'
G[13464]='SP HW FH K16 L7864576 A:1194073 T:1194073'
G[13465]='SP HW FH K16 L7864576 A:1194074 T:1194074'
G[13466]='SP HW FH K16 L7864576 A:1194075 T:1194075'
G[13467]='SP HW FH K16 L7864576 A:1194076 T:1194076'
G[13468]='SP HW FH K16 L7864576 A:1194077 T:1194077'
G[13469]='SP HW FH K16 L7864576 A:1194078 T:1194078'
G[13470]='SP HW FH K16 L7864576 A:1194079 T:1194079'
G[13471]='SP HW FH K16 L7864576 A:1194080 T:1194080'
G[13472]='SP HW K16 L7864576 A:1194072 T:1194072'
G[13473]='SP HW FA K16 L7864576 A:1194064 T:1194064'
G[13474]='SP HW FH K16 L7864576 A:1194081 T:1194081'
G[13476]='L18177 E31961'
G[13478]='L18177 E31961'
G[13479]='HN K2 L7864576 A:32798 T:32798 O:13483'
G[13480]='HN K2 L7864576 A:32799 T:32799 O:13484'
G[13481]='FH L25 A:32800 T:31261'
G[13482]='FA L25 A:32800 T:31259'
G[13483]='HN FH K16 L7864576 A:19169,519169,500099,500100,500101,500102,500103,500104,19175,519175,19176,519176,19177,519177,500105,19178,519178,20102,520102,500106,500107,500108,500109,500110,500111,500112,500113,500114,500115,500116,500117,500118,500119,500120,500121,500122,500123,500124,500125,500126,500127,500128,500129,500130 T:32798'
G[13484]='HN FA K16 L7864576 A:18927,518927,500091,500092,500093,500094,500095,19148,19171,519171,500096,500097,500098,19172,19173,20102,520102,500106,500107,500108,500109,500110,500111,500112,500113,500114,500115,500116,500117,500118,500119,500120,500121,500122,500123,500124,500125,500126,500127,500128,500129,500130 T:32799'
G[13485]='SP HM FA L7864576 A:32801 T:32801'
G[13486]='SP HM FA L7864576 A:32802 T:32802'
G[13487]='SP HM FA L7864576 A:32803 T:32803'
G[13488]='SP HM FA L7864576 A:32804 T:32804'
G[13489]='SP HM FA L7864576 A:32805 T:32805'
G[13490]='SP HM FA L7864576 A:32806 T:32806'
G[13491]='SP HM FA L7864576 A:32807 T:32807'
G[13492]='SP HM FA L7864576 A:32808 T:32808'
G[13493]='SP HM FH L7864576 A:32809 T:32809'
G[13494]='SP HM FH L7864576 A:32810 T:32810'
G[13495]='SP HM FH L7864576 A:32811 T:32811'
G[13496]='SP HM FH L7864576 A:32812 T:32812'
G[13497]='SP HM FH L7864576 A:32813 T:32813'
G[13498]='SP HM FH L7864576 A:32814 T:32814'
G[13499]='SP HM FH L7864576 A:32815 T:32815'
G[13500]='SP HM FH L7864576 A:32816 T:32816'
G[13501]='SP HW FH K16 L7864576 A:1194084 T:1194084'
G[13502]='HN FA K16 L7864576 A:32836 T:32836'
G[13503]='HN FH K16 L7864576 A:32837 T:32837'
G[13504]='FA L5 A:32965 T:32965 P:13589'
G[13505]='FA L5 A:32966 T:32966 P:13589'
G[13506]='fA L5 A:100044979 T:32963'
G[13507]='FA L5 A:32965 T:32965 P:13505'
G[13508]='L5 A:32963 T:33055 P:13506'
G[13509]='FA L5 A:32963 T:32963 P:13504'
G[13510]='FA L5 A:32964 T:32963 P:K100045040'
G[13511]='L5 A:33055 T:32963 P:13508'
G[13512]='FA L5 A:32963 T:32963 P:13507+13509'
G[13513]='FA L5 A:32966 T:32966 P:13507+13509'
G[13514]='L5 A:33176 T:33176 P:B13590'
G[13515]='FA L5 A:33178 T:533178,33178 P:13590'
G[13518]='FA L5 A:32973 T:32973 O:26383,26385,28490'
G[13519]='L5 A:32912 T:32912 P:13591'
G[13520]='L5 A:32972 T:532972 P:13518+13522'
G[13521]='FA L5 A:32977 T:1194105 P:13518+13522'
G[13522]='FA L5 A:32971 T:32971'
G[13523]='L5 A:32932 T:32932'
G[13525]='FA L5 A:33250 T:32967'
G[13526]='FA L5 A:32967 T:32967 O:13525'
G[13527]='FA L5 A:1194105 T:32977 P:13521'
G[13528]='FA L5 A:32977 T:1194122 P:13527'
G[13529]='FA L5 A:32978 T:32978 P:13528'
G[13537]='L5 A:33175 T:33175 P:13518+13522+PF001'
G[13538]='FA K4 L25 A:31153 T:31153'
G[13539]='FH K4 L25 A:31151 T:31151'
G[13542]='FA L5 A:3694 T:3694'
G[13543]='FA L5 A:32987 T:32987'
G[13544]='FA L5 A:32967 T:32967 P:13526'
G[13545]='FA L5 A:32967 T:32967 P:13544'
G[13546]='FA L5 A:32967 T:32967 P:13545'
G[13547]='FA L5 A:6887 T:6887'
G[13548]='SP HW FH K16 L7864576 A:1194119 T:1194119'
G[13549]='L20 A:28527 T:28527 P:12635'
G[13554]='FA L5 A:1194122 T:32977 P:13528'
G[13556]='L20 A:33025 T:33025'
G[13557]='fA L5 A:100044927 T:32978'
G[13558]='FA L5 A:6887 T:32987 P:13547'
G[13559]='SP K1 L25 A:32540 T:32540 P:T45F41999'
G[13560]='L5 A:32979 T:32979 P:13569'
G[13561]='L5 A:33177 T:33177'
G[13562]='L5 A:32971 T:32971 P:13529'
G[13563]='L5 A:32959,532959 T:32959,532959 P:13529'
G[13564]='FA L5 A:32960 T:33048 P:13529'
G[13565]='FA L5 A:33126 T:33126 P:13564'
G[13566]='FA L5 A:33048 T:33048 P:13564'
G[13567]='SP L5 A:33133 T:-62 P:B13569 I:13568,13597'
G[13568]='SP L5 A:33131 T:-62 P:B13569 I:13567,13597'
G[13569]='FA L5 A:33048 T:33048 P:13565+13566+13598'
G[13570]='SP L5 A:532959 T:532959 P:13591'
G[13571]='L10 A:32516 T:32516 P:12645'
G[13572]='FA L5 A:32968 T:32968 P:13544'
G[13573]='L5 A:32987 T:33091'
G[13575]='FA L5 A:33091 T:33117'
G[13576]='FA L5 A:33117 T:33117 P:13575'
G[13577]='FA L5 A:33091 T:33119'
G[13578]='FA L5 A:33119 T:33119 P:13577'
G[13579]='FA L5 A:33091 T:33112'
G[13580]='FA L5 A:33117 T:33117 P:13576'
G[13581]='FA L5 A:33117 T:33091 P:13580'
G[13582]='FA L5 A:33119 T:33119 P:13578'
G[13583]='FA L5 A:33119 T:33091 P:13582'
G[13584]='FA L5 A:33112 T:33112 P:13579'
G[13585]='FA L5 A:33112 T:33091 P:13584'
G[13586]='FA L5 A:33091 T:33166 P:13581+13583+13585'
G[13587]='FA L5 A:33166 T:33166 P:13586'
G[13588]='FA L5 A:33091 T:33091 P:13940'
G[13589]='FA L5 A:32971 T:32963 P:13569'
G[13590]='FA L5 A:32963 T:33178 P:13512+13513'
G[13591]='FA L5 A:100046318 T:532971 P:C13515'
G[13592]='FA K2 L25 A:33222 T:33222 P:B13718'
G[13593]='FA L25 RF RE RN RD RW RV RI A:33225 T:33225 P:13732,13733,13734,13735 I:13684,B13714,B13715,B13716,B13717'
G[13594]='FA L7 A:33187 T:33187 O:26408,28492'
G[13595]='FA L7 A:33182 T:33182'
G[13596]='L5 A:32912 T:32912 P:13591'
G[13597]='SP L5 A:33132 T:-62 P:B13569 I:13567,13568'
G[13598]='FA L5 A:33048 T:33048 P:13564'
G[13599]='L5 A:33048 T:32972 P:13569'
G[13600]='K2 L25 A:33225 T:33225 P:B13718 I:13603,13616'
G[13601]='L5 A:32912 T:33107 P:13596'
G[13602]='FA L7 A:3845 T:3845'
G[13603]='K2 L25 A:33225 T:33225 P:B13718 I:13600,13616'
G[13604]='L30 A:100045506 T:1194555'
G[13605]='L5 A:33232 T:33231'
G[13606]='L30 A:33956 T:33956'
G[13607]='L30 A:33956 T:33956'
G[13609]='L30 A:33956 T:33956'
G[13610]='L30 A:33956 T:33956'
G[13611]='L30 A:33956 T:33956'
G[13612]='L7 A:8582 T:8582 O:13866,28493,28876'
G[13613]='L7 A:33263 T:33263'
G[13614]='L30 A:33956 T:1194555'
G[13615]='L7 A:33284 T:33284'
G[13616]='FA K2 L25 A:33225 T:33225 P:B13718 I:13600,13603'
G[13617]='FA L7 A:33187 T:3846 P:13594'
G[13618]='FH L7 A:8582 T:33294'
G[13619]='FH L7 A:33294 T:8582 P:13618'
G[13620]='FH L7 A:8582 T:33263 P:13619'
G[13621]='FH L7 A:33263 T:8582 P:13620'
G[13622]='L30 E31961'
G[13623]='FA L7 A:33204 T:3847 P:26473'
G[13624]='FA L7 A:11806 T:11806'
G[13625]='FA K2 L25 A:33647 T:33647 P:B13672'
G[13626]='FA L7 A:11806 T:11806 P:13624'
G[13627]='L25 E31961'
G[13628]='FH L7 A:33284 T:33421 P:13621'
G[13629]='L30 E31961'
G[13630]='FA L7 A:33276 T:33276'
G[13631]='L30 A:100046052 T:16128'
G[13632]='FA L7 A:11219 T:11219'
G[13633]='FA L25 A:33417 T:33417'
G[13634]='FH L25 A:33417 T:33417 P:13633'
G[13635]='L5 A:1960 T:1092 P:26855'
G[13636]='L5 A:1340 T:1343'
G[13639]='L5 A:1105 T:2057 P:26868'
G[13640]='FH L7 A:33421 T:33421 P:13628'
G[13641]='L25 A:33417 T:33417 P:13633,13634'
G[13642]='FA L7 A:3847 T:3847 P:13623'
G[13643]='L25 A:33417 T:33417 P:13641'
G[13644]='FA L7 A:33443 T:33443'
G[13645]='FA L7 A:3847 T:3691 P:26464'
G[13646]='FA L7 A:33445 T:33454 P:26464'
G[13647]='L5 A:1345 T:1154 P:13650+26961 I:257'	-- *** I picked the I: code because it seems to be true for older characters.  Basically newer characters can get this quest and there are no issues with any of the quests at Farstrider Lodge or even with the leadin from Ironforge.  Therefore, older characters that cannot get this are assumed to have completed a hunting quest before, and that is my force of the I: code. ***
G[13648]='FA L5 A:1000256 T:1139'
G[13650]='FA L5 A:1344 T:1344 P:309'
G[13651]='FH L7 A:33421 T:33421 P:13640'
G[13653]='FH L7 A:33421 T:8582 P:13651'
G[13654]='L25 A:33417 T:33417 P:13643'
G[13655]='fA L5 A:1194378 T:1153'
G[13656]='fA L5 A:1194387 T:1153'
G[13657]='fA L5 A:1194388 T:1153'
G[13658]='fA L5 A:1194389 T:1153'
G[13659]='fA L5 A:1194390 T:1153'
G[13660]='fA L5 A:1194391 T:1153'
G[13661]='SP L5 A:1153,-48 T:1153 P:13655+13656+13657+13658+13659+13660'
G[13662]='K1 L15 A:14624 T:14624 P:28064+t03B83999'
G[13663]='L25 A:33417 T:33417'
G[13664]='L25 A:33417 T:33417 P:13663+13702|13732|13733|13734|13735|13736|13737|13738|13739|13740'
G[13665]='FA K2 L25 A:33223 T:33223 P:B13718'
G[13666]='FA K2 L25 A:33625 T:33625 P:B13672 I:13669,13670'
G[13667]='FA L25 A:33817 T:33625'
G[13668]='FH L25 A:33817 T:33542'
G[13669]='FA K2 L25 A:33625 T:33625 P:B13672 I:13666,13670'
G[13670]='FA K2 L25 A:33625 T:33625 P:B13672 I:13666,13669'
G[13671]='FA K2 L25 A:33646 T:33646 P:B13672'
G[13672]='FA L25 A:33625 T:33625 P:13828+13835+13837'
G[13673]='FH K2 L25 A:33542 T:33542 P:B13678 I:13674,13675'
G[13674]='FH K2 L25 A:33542 T:33542 P:B13678 I:13673,13675'
G[13675]='FH K2 L25 A:33542 T:33542 P:B13678 I:13673,13674'
G[13676]='FH K2 L25 A:33658 T:33658 P:B13678'
G[13677]='FH K2 L25 A:33659 T:33659 P:B13678'
G[13678]='FH L25 A:33542 T:33542 P:13829+13838+13839'
G[13679]='FA L25 A:33625 T:33625 P:13672'
G[13680]='FH L25 A:33542 T:33542 P:13678'
G[13681]='L25 E31961'
G[13682]='FA K514 L25 XK A:33759 T:33759 P:J2773+13794'	-- PM3
G[13683]='FA L7 A:33727 T:33727 P:26468'
G[13684]='FA L25 RH RA RK A:33625 T:33225 P:13679 I:13593'	-- AS Is this where the Tushui Pandaren start their Tournament?
G[13685]='FA L25 RF A:33625 T:33312 P:13679 I:13703'
G[13688]='FA L25 RN A:33625 T:33335 P:13679 I:13704'
G[13689]='FA L25 RE RW RV A:33625 T:33592 P:13679 I:13706'
G[13690]='FA L25 RD RI A:33625 T:33593 P:13679 I:13705'
G[13691]='FH L25 RO RG RA RR RM RZ A:33542 T:33361 P:13680 I:13707'	-- AS Is this where the Huojin Pandaren start their Tournament?
G[13692]='L25 E31961'
G[13693]='FH L25 RL RZ A:33542 T:33372 P:13680 I:13708'
G[13694]='FH L25 RT A:33542 T:33403 P:13680 I:13709'
G[13695]='FH L25 RU A:33542 T:33373 P:13680 I:13710'
G[13696]='FH L25 RB A:33542 T:33379 P:13680 I:13711'
G[13697]='FH L25 A:33361 T:33361'
G[13698]='FA L7 A:17287 T:17287 P:26457'
G[13699]='FA L25 A:33225 T:33225 P:13718'
G[13702]='L25 A:33225 T:33817 P:13699'
G[13703]='FA L25 RH RE RN RD RW RA RV RI RK A:33312 T:33312 P:13702,13733,13734,13735 I:13685,B13715,B13716,B13717,B13718'
G[13704]='FA L25 RH RF RE RD RW RA RV RI RK A:33335 T:33335 P:13702,13732,13734,13735 I:13688,B13714,B13716,B13717,B13718'
G[13705]='FA L25 RH RF RE RN RW RA RV RK A:33593 T:33593 P:13702,13732,13733,13735 I:13690,B13714,B13715,B13717,B13718'
G[13706]='FA L25 RH RF RN RD RA RI RK A:33592 T:33592 P:13702,13732,13733,13734 I:13689,B13714,B13715,B13716,B13718'
G[13707]='FH L25 RU RT RL RG RB RA RR RM RZ A:33361 T:33361 P:13737,13738,13739,13740 I:13691,B13719,B13720,B13721,B13722'
G[13708]='FH L25 RO RU RT RG RB RA RR RM A:33372 T:33372 P:13736,13738,13739,13740 I:13693,B13697,B13720,B13721,B13722'
G[13709]='FH L25 RO RU RL RG RB RA RR RM RZ A:33403 T:33403 P:13736,13737,13739,13740 I:13694,B13697,B13719,B13721,B13722'
G[13710]='FH L25 RO RT RL RG RB RA RR RM RZ A:33373 T:33373 P:13736,13737,13738,13740 I:13695,B13697,B13719,B13720,B13722'
G[13711]='FH L25 RO RU RT RL RG RA RR RM RZ A:33379 T:33379 P:13736,13737,13738,13739 I:13696,B13697,B13719,B13720,B13721'
G[13712]='FH L7 A:8582 T:33837 P:13653'
G[13713]='FA L25 A:33312 T:33312 P:13714'
G[13714]='FA L25 A:33312 T:33312 P:13679 I:B13715,B13716,B13717,B13718'
G[13715]='FA L25 A:33335 T:33335 P:13679 I:B13714,B13716,B13717,B13718'
G[13716]='FA L25 A:33593 T:33593 P:13679 I:B13714,B13715,B13717,B13718'
G[13717]='FA L25 A:33592 T:33592 P:13679 I:B13714,B13715,B13716,B13718'
G[13718]='FA L25 A:33225 T:33225 P:13679 I:B13714,B13715,B13716,B13717'
G[13719]='FH L25 A:33372 T:33372'
G[13720]='FH L25 A:33403 T:33403'
G[13721]='FH L25 A:33373 T:33373'
G[13722]='FH L25 A:33379 T:33379'
G[13723]='FA L25 A:33335 T:33335 P:13715'
G[13724]='FA L25 A:33593 T:33593 P:13716'
G[13725]='FA L25 A:33592 T:33592 P:13717'
G[13726]='FH L25 A:33361 T:33361 P:13697'
G[13727]='FH L25 A:33372 T:33372 P:13719'
G[13728]='FH L25 A:33403 T:33403 P:13720'
G[13729]='FH L25 A:33373 T:33373 P:13721'
G[13730]='FH L7 A:33726 T:33726 P:13803'
G[13731]='FH L25 A:33379 T:33379 P:13722'
G[13732]='L25 A:33312 T:33817 P:13713'
G[13733]='FA L25 A:33335 T:33817 P:13723'
G[13734]='FA L25 A:33593 T:33817 P:13724'
G[13735]='L25 A:33592 T:33817 P:13725'
G[13736]='FH L25 A:33361 T:33817'
G[13737]='FH L25 A:33372 T:33817'
G[13738]='FH L25 A:33403 T:33817'
G[13739]='FH L25 A:33373 T:33817'
G[13740]='FH L25 A:33379 T:33817'
G[13741]='FA K2 L25 A:33312 T:33312 P:B13714 I:13742,13743'
G[13742]='FA K2 L25 A:33312 T:33312 P:B13714 I:13741,13743'
G[13743]='FA K2 L25 A:33312 T:33312 P:B13714 I:13741,13742'
G[13744]='FA K2 L25 A:33315 T:33315 P:B13714'
G[13745]='FA K2 L25 A:33309 T:33309 P:B13714'
G[13746]='K2 L25 A:33335 T:33335 P:B13715 I:13747,13748'
G[13747]='K2 L25 A:33335 T:33335 P:B13715 I:13746,13748'
G[13748]='FA K2 L25 A:33335 T:33335 P:B13715 I:13746,13747'
G[13749]='FA K2 L25 A:33648 T:33648 P:B13715'
G[13750]='FA K2 L25 A:33649 T:33649 P:B13715'
G[13751]='FH L7 A:33726 T:33760 P:13730'
G[13752]='K2 L25 A:33593 T:33593 P:B13716 I:13753,13754'
G[13753]='K2 L25 A:33593 T:33593 P:B13716 I:13752,13754'
G[13754]='FA K2 L25 A:33593 T:33593 P:B13716 I:13752,13753'
G[13755]='FA K2 L25 A:33655 T:33655 P:B13716'
G[13756]='FA K2 L25 A:33656 T:33656 P:B13716'
G[13757]='K2 L25 A:33592 T:33592 P:B13717 I:13758,13759'
G[13758]='K2 L25 A:33592 T:33592 P:B13717 I:13757,13759'
G[13759]='FA K2 L25 A:33592 T:33592 P:B13717 I:13757,13758'
G[13760]='FA K2 L25 A:33652 T:33652 P:B13717'
G[13761]='FA K2 L25 A:33654 T:33654 P:B13717'
G[13762]='FH K2 L25 A:33361 T:33361'
G[13763]='FH K2 L25 A:33361 T:33361'
G[13764]='FH K2 L25 A:33361 T:33361'
G[13765]='FH K2 L25 A:33405 T:33405'
G[13766]='FA L7 A:17310 T:17310 P:26446'
G[13767]='FH K2 L25 A:33544 T:33544'
G[13768]='FH K2 L25 A:33372 T:33372'
G[13769]='FH K2 L25 A:33372 T:33372'
G[13770]='FH K2 L25 A:33372 T:33372'
G[13771]='FH K2 L25 A:33540 T:33540'
G[13772]='FH K2 L25 A:33545 T:33545'
G[13773]='FH K2 L25 A:33403 T:33403'
G[13774]='FH K2 L25 A:33403 T:33403'
G[13775]='FH K2 L25 A:33403 T:33403'
G[13776]='FH K2 L25 A:33539 T:33539'
G[13777]='FH K2 L25 A:33549 T:33549'
G[13778]='FH K2 L25 A:33373 T:33373'
G[13779]='FH K2 L25 A:33373 T:33373'
G[13780]='FH K2 L25 A:33373 T:33373'
G[13781]='FH K2 L25 A:33541 T:33541'
G[13782]='FH K2 L25 A:33547 T:33547'
G[13783]='FH K2 L25 A:33379 T:33379'
G[13784]='FH K2 L25 A:33379 T:33379'
G[13785]='FH K2 L25 A:33379 T:33379'
G[13786]='FH K2 L25 A:33538 T:33538'
G[13787]='FH K2 L25 A:33548 T:33548'
G[13788]='FA K514 L25 CK A:33762 T:33762 P:J2773+13795'	-- PM3
G[13789]='FA K2 L25 XK A:33763 T:33763 P:13794'
G[13790]='FA K2 L25 XK A:33771 T:33771 P:13794'
G[13791]='FA K2 L25 CK A:33769 T:33769 P:13795'
G[13792]='FA L7 A:17310 T:33777 P:13766'
G[13793]='FA K2 L25 CK A:33770 T:33770 P:13795'
G[13794]='L25 XK A:33817 T:33759 P:13702,13732,13733,13734,13735,13736,13737,13738,13739,13740 I:13795'
G[13795]='L25 CK A:33817 T:33762 P:13702,13732,13733,13734,13735,13736,13737,13738,13739,13740 I:13794'
G[13796]='FA L7 A:33777 T:17310 P:13792'
G[13797]='FH L7 A:33760 T:33760 P:13751'
G[13798]='FH L7 A:33760 T:33977 P:13797'
G[13801]='L7 A:12724 T:12724 P:13803'
G[13803]='FH L7 A:33837 T:33760 P:13712'
G[13805]='FH L7 A:33760 T:33837 P:13803'
G[13806]='FH L7 A:11820 T:11820 P:26449'
G[13807]='E9626'	--FLAG: Tournament Invitation , Gets completed in SL when leaving oribos
G[13808]='FH L7 A:33837 T:33889 P:13805'
G[13809]='FH K514 L25 XK A:33759 T:33759 P:J2773+13794'	-- PM3
G[13810]='FH K2 L25 XK A:33763 T:33763 P:13794'
G[13811]='FH K2 L25 XK A:33771 T:33771 P:13794'
G[13812]='FH K514 L25 CK A:33762 T:33762 P:J2773+13795'	-- PM3
G[13813]='FH K2 L25 CK A:33769 T:33769 P:13795'
G[13814]='FH K2 L25 CK A:33770 T:33770 P:13795'
G[13815]='FH L7 A:33889 T:33889 P:13808'
G[13816]='L30 A:33957 T:33957'
G[13817]='L30 A:100045857 T:1194555'
G[13818]='L30 A:33957 T:1194555'
G[13819]='L30 A:100046053 T:16128'
G[13820]='L25 E31961'
G[13821]='L30 A:33957 T:33957'
G[13822]='L30 A:33957 T:33957'
G[13823]='L30 A:33957 T:33957'
G[13824]='L30 A:33957 T:33957'
G[13825]='SP L1 A:40589 T:40589 P:PC225 I:6610'
G[13826]='L1 A:12919 T:12919 P:6607+k100045858'
G[13828]='L25 A:33625 T:33625 P:13667'
G[13829]='FH L25 A:33542 T:33542 P:13668'
G[13830]='K2 L10 A:28742 T:28742 P:PF001 I:13832,13833,13834,13836'
G[13831]='L5 A:1194714 T:32978 P:13528'
G[13832]='K2 L10 A:28742 T:28742 P:PF001 I:13830,13833,13834,13836'
G[13833]='K2 L10 A:28742 T:28742 P:PF001 I:13830,13832,13834,13836'
G[13834]='K2 L10 A:28742 T:28742 P:PF001 I:13830,13832,13833,13836'
G[13835]='FA L25 A:33647 T:33647'
G[13836]='K2 L10 A:28742 T:28706 P:PF001 I:13830,13832,13833,13834'
G[13837]='FA L25 A:33646 T:33646'
G[13838]='FH L25 A:33659 T:33659'
G[13839]='FH L25 A:33658 T:33658'
G[13841]='FH L7 A:33726 T:86832 P:13798'
G[13842]='FH L7 A:39605 T:39605 P:13841'
G[13843]='L25 E32305'
G[13844]='L5 A:34041 T:34041 P:13507+13509'
G[13845]='L10 A:100046004 T:29535'
G[13846]='K2 L25 A:34210 T:34210'
G[13847]='FA K2 L25 A:33223 T:33223 P:B13718'
G[13848]='L7 A:33837 T:34122 P:13805'
G[13849]='FA L7 A:4079 T:4079'
G[13850]='FH L15 A:11701 T:11701'
G[13851]='FA K2 L25 A:33309 T:33309 P:B13714'
G[13852]='FA K2 L25 A:33649 T:33649 P:B13715'
G[13853]='FA L7 A:4079 T:4079 P:13849'
G[13854]='FA K2 L25 A:33656 T:33656 P:B13716'
G[13855]='FA K2 L25 A:33654 T:33654 P:B13717'
G[13856]='FH K2 L25 A:33544 T:33544'
G[13857]='FH K2 L25 A:33545 T:33545'
G[13858]='FH K2 L25 A:33549 T:33549'
G[13859]='FH K2 L25 A:33548 T:33548'
G[13860]='FH K2 L25 A:33547 T:33547'
G[13861]='FA K2 L25 XK A:33759 T:33759 P:13794'
G[13862]='FH K2 L25 XK A:33759 T:33759 P:13794'
G[13863]='FH K2 L25 CK A:33762 T:33762 P:13795'
G[13864]='FA K2 L25 CK A:33762 T:33762 P:13795'
G[13865]='FH L7 A:33889 T:33889 P:13808'
G[13866]='FH L7 A:34195 T:8582 P:24463 I:28493,28876'
G[13867]='FA L7 A:3691 T:3691'
G[13868]='FA L7 A:100046128 T:3691'
G[13869]='FA L7 A:17310 T:17310 P:26454'
G[13870]='FH L7 A:33889 T:17304 P:13815+13865'
G[13871]='FH L7 A:17304 T:17304 P:13870'
G[13872]='FA L7 A:3691 T:34239 P:13868'
G[13873]='FH L7 A:34233 T:34242 P:13871'
G[13874]='FA L7 A:34239 T:34239 P:13872'
G[13875]='L7 A:34242 T:33726'
G[13876]='L7 A:34251 T:34251 P:13868'
G[13877]='FA L7 A:34239 T:34283 P:13874'
G[13878]='FH L5 A:34284 T:34284'
G[13879]='FH L7 A:34510 T:34512 P:13947'
G[13880]='L7 A:34290 T:34290 P:13877,13879'
G[13881]='FA L5 A:34301 T:34301'
G[13882]='FA L5 A:34301 T:34301 P:13881'
G[13883]='FH L7 A:34303 T:34303'
G[13884]='L7 A:34292 T:34292 P:13877,13879'
G[13885]='FA L5 A:34301 T:34301 P:13925'
G[13886]='FA L7 A:34289 T:34283 P:13880+13884'
G[13887]='FH L15 A:11701 T:11701 P:13850'
G[13888]='FH L7 A:34289 T:34512 P:13880+13884'
G[13889]='FH K2 L15 A:34320 T:34320'
G[13890]='FH L7 A:34122 T:34122'
G[13891]='FA L5 A:34301 T:34301 P:13885'
G[13892]='FA L5 A:34402 T:34402'
G[13893]='FA L5 A:34340 T:34404 P:13896'
G[13895]='FA L5 A:33072 T:34446 P:13893'
G[13896]='FA L5 A:34404 T:34340 P:13948'
G[13897]='FA L5 A:34422 T:34402 P:13900'
G[13898]='L5 A:34403 T:34403 P:13953'
G[13899]='FA L5 A:34402 T:34423 P:13953'
G[13900]='FA L5 A:34423 T:34422 P:13899'
G[13901]='FH L7 A:12719 T:12719 P:6442'
G[13902]='L5 A:33091 T:34402 P:13588'
G[13903]='FH K2 L15 A:34320 T:34320'
G[13904]='FH K2 L15 A:34320 T:34320'
G[13905]='FH K2 L15 A:34320 T:34320'
G[13906]='FH L15 A:11701 T:11701 P:13887'
G[13907]='FA L5 A:34340 T:34340'
G[13909]='FA L5 A:34340 T:34340 P:13907'
G[13910]='FA L5 A:34340 T:34340 P:13909'
G[13911]='L5 A:34343 T:34342'
G[13912]='L5 A:34342 T:34342'
G[13913]='FA L10 A:34354 T:34354'
G[13914]='K2 L20 A:34320 T:34320'
G[13915]='FH K2 L20 A:34320 T:34320'
G[13916]='FH K2 L20 A:34320 T:34320'
G[13917]='FH K2 L20 A:34320 T:34320'
G[13918]='L5 A:34342 T:34342 P:13912'
G[13919]='FA L7 A:3894 T:-63 P:26475'	-- after about 5 seconds
G[13920]='FH L7 A:34122 T:34122 P:13890'
G[13921]='FA L7 A:-63 T:34335 P:13919 I:14018'	-- TODO: Research if this is gotten first is the other gotten after abandoning this?
G[13922]='FA L7 A:34335 T:34335 P:13921,14018'
G[13923]='L7 A:34122 T:34359 P:13920'
G[13924]='FA L7 A:34358 T:3894 P:13922'	-- after a few seconds
G[13925]='FA L5 A:34301 T:34301 P:13882'
G[13926]='HC L7879680 A:34365 T:33533 I:13927'
G[13927]='HC L7879680 A:34365 T:33532 I:13926'
G[13928]='FA L7 A:3880 T:34377'
G[13929]='HC L7879680 A:33533 T:500039 P:13926'
G[13930]='HC L7879680 A:33532 T:500010 P:13927'
G[13932]='FA L7864576 E31961'
G[13933]='HC L7879680 A:33533 T:500038 P:13926'
G[13934]='HC L7879680 A:33532 T:500009 P:13927'
G[13935]='FA L7 A:34377 T:3880 P:13928'
G[13936]='FH L7 A:34359 T:34395 O:13923'
G[13937]='HC L15360 A:33533 T:33533 P:13956+13954'
G[13938]='HC L7879680 A:33532 T:33532 P:13955+13957'
G[13940]='FA L5 A:33166 T:33091 P:13587'
G[13942]='FH L7 A:34395 T:34395 P:13936'
G[13943]='FH L7 A:34359 T:34359 P:13936'
G[13944]='FH L7 A:34395 T:34359 P:13942'
G[13945]='FA L1 A:2081 T:2081 P:476'
G[13946]='FA L1 A:2083 T:2083 P:489'
G[13947]='FH L7 A:34359 T:34359 P:13944'
G[13948]='FA L5 A:34402 T:34402 P:13892'
G[13949]='FH L5 A:34258 T:5907 P:872+5041'
G[13950]='HC L7879680 A:33533 T:533533 P:13926'
G[13951]='HC L7879680 A:33532 T:533532 P:13927'
G[13952]='HD FA K16 L7864576 RH RK A:34435 T:34435 I:14166,14167,14168,14169,14170,14171,14172,14173,14174,14175,14176,14177,27841,27846'
G[13953]='FA L5 A:34498 T:34402 P:13895'
G[13954]='HC L7879680 A:33533 T:500040 P:13929+13933+13950'
G[13955]='HC L7879680 A:33532 T:500011 P:13930+13934+13951'
G[13956]='HC L7879680 A:33533 T:500041 P:13929+13933+13950'
G[13957]='HC L7879680 A:33532 T:500012 P:13930+13934+13951'
G[13958]='FH L7 A:34359 T:34518 P:13947'
G[13959]='HC L7879680 A:33533 T:34365 P:13937+k100046545+s200033530'
G[13960]='HC L7879680 A:33532 T:34365 P:13938+k100046544+s200033529'
G[13961]='FH L5 A:34513 T:34513'
G[13962]='FH L7 A:34518 T:34518 P:13958'
G[13963]='FH L5 A:34513 T:34513 P:13961'
G[13964]='FA L7 A:4079 T:3885 P:26478'
G[13965]='FA L7 A:3996 T:24739 P:26478'
G[13966]='L7866880 E31961'
G[13967]='L7 A:12696 T:12696'
G[13968]='FH L5 A:34513 T:34513 P:13963'
G[13969]='FH L5 A:5907 T:34547 P:13963'
G[13970]='FH L5 A:34547 T:34547 P:13969'
G[13971]='FH L5 A:34547 T:5907 P:13970'
G[13973]='L5 A:34560 T:34560'
G[13974]='FH L7 A:34395 T:34569 P:13947'
G[13975]='FH L5 A:34578 T:3429 P:13949'
G[13976]='FA L7 A:24739 T:3698 O:13965'
G[13977]='FH L7 A:34569 T:34596 P:13974'
G[13979]='FA L7 A:34354 T:34354'
G[13980]='FH L7 A:34596 T:34596 P:13977'
G[13981]='FA L7 A:1195134 T:34354'
G[13982]='FA L7 A:3698 T:3698 P:13976'
G[13983]='FH L7 A:34596 T:34596 P:13977'
G[13985]='FA L7 A:34599 T:34604 P:13982'
G[13986]='L18249 E32305'
G[13987]='FA L7 A:34604 T:34604 P:13985'
G[13988]='FH L5 A:3448 T:34626 P:870'
G[13989]='FA L7 A:3897 T:3897 P:26480'
G[13991]='L5 A:3338 T:3464 P:905'
G[13992]='L5 A:34613 T:34613'
G[13995]='L5 A:34634 T:34638'
G[13998]='FH L5 A:3390 T:3390 P:848'
G[13999]='FH L5 A:3390 T:34651 P:13998'
G[14001]='FH L1 RG A:36600 T:35650 P:14239'
G[14003]='FH L5 A:3442 T:34674 P:29024'
G[14004]='FH L5 A:9316 T:3442 P:29027'
G[14005]='FA L1 A:1992 T:1992 P:933'
G[14006]='FH L5 A:3442 T:3442 P:14004'
G[14007]='FH L515 RG CH A:34673 T:34673 ODC:14137 Z18505'
G[14008]='FH L5 RG CM A:34689 T:34689 ODC:14137 Z18505'
G[14009]='FH L5 RG CT A:34692 T:34692 ODC:14137 Z18505'
G[14010]='FH L515 RG CR A:34693 T:34693 ODC:14137 Z18505'
G[14011]='FH L5 RG CS A:34695 T:34695 ODC:14137 Z18505'
G[14012]='FH L5 RG CL A:34696 T:34696 ODC:14137 Z18505'
G[14013]='FH L5 RG CW A:34697 T:34697 ODC:14137 Z18505'
G[14014]='FH L1 RG A:35650 T:35650 P:14001'
G[14016]='L25 A:33417 T:33417 P:13664'
G[14017]='L25 A:33417 T:33417 P:14016'
G[14018]='FA L10 A:-63 T:34335 P:13919 I:13921'
G[14019]='FH L1 RG A:35758 T:35758 P:14001'
G[14021]='FH L1 RG A:35769 T:35769 P:14248'
G[14022]='HY FA K16 L7864576 A:18927,518927,500091,500092,500093,500094,500095,19148,19171,519171,500096,500097,500098,19172,19173,20102,520102,500106,500107,500108,500109,500110,500111,500112,500113,500114,500115,500116,500117,500118,500119,500120,500121,500122,500123,500124,500125,500126,500127,500128,500129,500130 T:34675'
G[14023]='HY FA K16 L7864576 A:34675 T:34744'
G[14024]='HY FA L7864576 A:34744 T:34644 P:14023'
G[14028]='HY FA K16 L7864576 A:34644 T:34744 P:14024'
G[14030]='HY FA K16 L7864576 A:34744 T:34676 P:14028'
G[14031]='FH L1 RG A:35769 T:35650 P:14248'
G[14033]='HY FA K16 L7864576 A:34676 T:34675 P:14030'
G[14034]='FH L5 A:3391 T:3391'
G[14035]='HY FA K16 L7864576 A:34675 T:34676 P:14033'
G[14036]='HY FH L7864576 A:19169,519169,500099,500100,500101,500102,500103,500104,19175,519175,19176,519176,19177,519177,500105,19178,519178,20102,520102,500106,500107,500108,500109,500110,500111,500112,500113,500114,500115,500116,500117,500118,500119,500120,500121,500122,500123,500124,500125,500126,500127,500128,500129,500130 T:34677'
G[14037]='HY FH K16 L7864576 A:34677 T:34768'
G[14038]='FH K4 L5 A:3391 T:-10,3391 P:14034'
G[14039]='FA L1 A:503515 T:7999 P:935'
G[14040]='HY FH K16 L7864576 A:34768 T:34679 P:14037'	-- technically requires PC100, but one can obtain the quest prior to the skill being there, however, one can never complete the skill unless one knows the recipe which is skill 100 minimum
G[14041]='HY FH K16 L7864576 A:34679 T:34678 P:14040'	-- PC160 (see 14040)
G[14042]='FH L5 A:3391 T:3391 P:14038'
G[14043]='HY FH K16 L7864576 A:34678 T:34679 P:14041'	-- PC220 (see 14040)
G[14044]='HY FH K16 L7864576 A:34679 T:34677 P:14043'
G[14045]='FH L5 A:3391 T:3467'
G[14046]='FH K4 L5 A:3467 T:-10,3467 P:14045'
G[14047]='HY FH K16 L7864576 A:34677 T:34679 P:14044'	-- PC280 (see 14040)
G[14048]='HY FA K2 L7864576 A:34708 T:34708'
G[14049]='FH L5 A:3467 T:3391 P:14046'
G[14050]='FH L5 A:3391 T:3391 P:14049'
G[14051]='HY FA K2 L7864576 A:34708 T:34708'
G[14052]='FH L5 A:3453 T:34749'
G[14053]='HY FA K2 L7864576 A:34710 T:34710'
G[14054]='HY FA K2 L7864576 A:34711 T:34711'
G[14055]='HY FA K2 L7864576 A:34744 T:34744'
G[14056]='FH L5 A:34749 T:34749 P:14052'
G[14057]='FH L5 A:34749 T:34749 P:14056'
G[14058]='HY FH K2 L7864576 A:34768 T:34768'
G[14059]='HY FH K2 L7864576 A:34712 T:34712'
G[14060]='HY FH K2 L7864576 A:34714 T:34714'
G[14061]='HY FH K2 L7864576 A:34713 T:34713'
G[14062]='HY FH K2 L7864576 A:34713 T:34713'
G[14063]='FH L5 A:34749 T:3453 P:14057'
G[14064]='HY FA L7864576 A:34653 T:34653'
G[14065]='HY FH L7864576 A:34654 T:34654'
G[14066]='FH K4 L5 A:3464 T:-10,3464 O:13991'
G[14067]='FH L5 A:-100010,3464 T:3464 P:869'
G[14068]='L5 A:34828 T:34828'
G[14069]='FH L1 RG A:34872 T:34872 P:14138'
G[14070]='FH L1 RG A:34668 T:34668 P:14071'
G[14071]='FH L1 RG A:34874 T:34874 P:28349'
G[14072]='FH L5 A:34638 T:34638'
G[14073]='L5 A:3429 T:3389 P:850+851'
G[14074]='FA K2 L25 A:34880 T:34880 P:J3676 D101'
G[14075]='FH L1 RG A:34872 T:34872 P:14138'
G[14076]='FA K2 L25 A:34912 T:34912 P:J3676 I:14090,14112'
G[14077]='FA K2 L25 A:34880 T:34880 P:J3676 D101'
G[14078]='FA L1 RW A:34850 T:34863'
G[14079]='FA L10 RH RK E31961'
G[14080]='FA K2 L25 A:34880 T:34880 P:J3676 D101'
G[14081]='FH L10 RB E31961'
G[14082]='FA L10 RD E31961'
G[14083]='FA L10 RF E31961'
G[14084]='FA L10 RN E31961'
G[14085]='FA L10 RE E31961'
G[14086]='FH L10 RO E32305'
G[14087]='FH L10 RT E31961'
G[14088]='FH L10 RL RZ E31961'
G[14089]='FH L10 RU E31961'
G[14090]='FA K2 L25 A:34912 T:34912 P:J3676 I:14076,14112'
G[14091]='FA L1 RW A:34863 T:34913 P:14078'
G[14092]='FH K2 L25 A:34914 T:34914 P:J3677 I:14141,14145'
G[14093]='FA L1 RW A:34913 T:34913 P:14091'
G[14094]='FA L1 RW A:34936 T:34936 P:14078'
G[14095]='K2 L25 A:100046955 T:35094 P:B14108'
G[14096]='FA K2 L25 A:34880 T:34880 P:J3676 D101'
G[14098]='FA L1 RW A:34913 T:34913 P:14091'
G[14099]='FA L1 RW A:34913 T:35840 P:14094+14093+14098'
G[14101]='K2 L25 A:34882 T:34882 P:J2817,J2816'
G[14102]='K2 L25 A:34882 T:34882 P:J2817,J2816'
G[14103]='SP K1 L10 A:28701 T:28701 P:PJ001'	-- does this require possession of item 46849 (Titanium Powder)?
G[14104]='K2 L25 A:34882 T:34882 P:J2817,J2816'
G[14105]='K2 L25 A:34882 T:34882 P:J2817,J2816'
G[14107]='K2 L25 A:35094 T:35094 P:J2817,J2816'
G[14108]='K2 L25 A:35094 T:35094 P:J2817,J2816'
G[14109]='FH L1 RG GM A:35120,535120 T:35053 P:26712 ODC:14114'
G[14110]='FH L1 RG GF A:35120,535120 T:35054 P:26711 ODC:14114'
G[14112]='FA K2 L25 A:34912 T:34912 P:J3676 I:14076,14090'
G[14113]='FH L1 RG GM A:35053 T:34668 P:24520+14070+14109 ODC:14139'
G[14114]='L0 T:35054 J:A14109,A14110'
G[14115]='FH L1 RG A:34668 T:34668 P:14113,14153'
G[14116]='FH L1 RG A:34668 T:35222 P:14115'
G[14117]='L5 A:8576 T:8576'
G[14118]='L5 A:8576 T:8576'
G[14120]='FH L1 RG A:35222 T:534668 P:14116 ODC:14158'
G[14121]='FH L1 RG A:534874 T:34874 P:14120'
G[14122]='FH L1 RG A:534668 T:34668 P:14120'
G[14123]='FH L1 RG A:34693 T:34693 P:14120'
G[14124]='FH L1 RG A:534872 T:534872 P:14120'
G[14125]='FH L1 RG A:534668 T:37602 P:14121+14122+14123+14124'
G[14126]='FH L1 RG A:534668 T:535222 P:14125'
G[14127]='L5 A:100047039 T:8576'	-- there are reports that the NPC 35095 who drops the start quest item phase out at some point.  need to investigate this.
G[14128]='L5 A:8576 T:35087 P:14127'
G[14129]='FH L5 A:35086 T:-76,35086 O:25275,28496'
G[14130]='FH L5 A:35867 T:35142 P:14407'
G[14131]='FH L5 A:35142 T:35142 P:14130'
G[14132]='FH L5 A:35142 T:35142 P:14130'
G[14134]='FH L5 A:-76,35086 T:-76,35086 P:14129'
G[14135]='FH L5 A:-76,35086 T:-76,35086 P:14134'
G[14136]='K2 L25 A:34771 T:34771 P:J3677 D102'
G[14137]='L0 T:34695 J:14007,14008,14009,14010,14011,14012,14013'
G[14138]='FH L1 RG A:34668 T:34872'
G[14139]='L0 T:34668 J:A14113,A14153'
G[14140]='FH K2 L25 A:34771 T:34771 P:J3677 D102'
G[14141]='FH K2 L25 A:34914 T:34914 P:J3677 I:14092,14145'
G[14142]='FH K2 L25 A:34771 T:34771 P:J3677 D102'
G[14143]='FH K2 L25 A:34771 T:34771 P:J3677 D102'
G[14144]='FH K2 L25 A:34771 T:34771 P:J3677 D102'
G[14145]='FH K2 L25 A:34914 T:34914 P:J3677 I:14092,14141'
G[14146]='FH L5 A:-76 T:-76 P:14135'
G[14151]='K1 L10 A:28703 T:28703 P:PA450'
G[14152]='FA K2 L25 A:34880 T:34880 P:J3676 D101'
G[14153]='FH L1 RG GF A:35054 T:34668 P:24520+14070+14110 ODC:14139'
G[14154]='FA L1 RW A:35077 T:35077 P:28850'
G[14155]='FH L5 A:-76 T:35086 P:14146'
G[14157]='FA L1 RW A:35112 T:50371 P:14285,14286,14287,14288,14289,14290,14291'
G[14158]='L0 T:34668 J:A14120'
G[14159]='FA L1 RW A:35112 T:35369 P:24930+26129'
G[14160]='L10 E32305'
G[14161]='FH L5 A:35091 T:35091 P:14162'	-- TODO: Determine if this is an O:
G[14162]='L5 A:35086 T:35091 P:14155'	-- TODO: Determine whether this is available if 14165 is taken, or possibly 14161 as well
G[14163]='L18177 E31961'
G[14164]='L18177 E31961'
G[14165]='FH L5 A:35091 T:35091'
G[14166]='HD K16 L7864576 A:35256 T:35256 I:13952,14167,14168,14169,14170,14171,14172,14173,14174,14175,14176,14177,27841,27846'
G[14167]='HD FA K16 L256 RF A:34478 T:34478 I:13952,14166,14168,14169,14170,14171,14172,14173,14174,14175,14176,14177,27841,27846'
G[14168]='HD FA K16 L256 RN A:34481 T:34481 I:13952,14166,14167,14169,14170,14171,14172,14173,14174,14175,14176,14177,27841,27846'
G[14169]='HD FA K16 L7864576 RD RI A:34484 T:34484 I:13952,14166,14167,14168,14170,14171,14172,14173,14174,14175,14176,14177,27841,27846'
G[14170]='HD FA K16 L7864576 RE RV A:34479 T:34479 I:13952,14166,14167,14168,14169,14171,14172,14173,14174,14175,14176,14177,27841,27846'
G[14171]='HD FH K16 L256 RB A:34483 T:34483 I:13952,14166,14167,14168,14169,14170,14172,14173,14174,14175,14176,14177,27841,27846'
G[14172]='HD K16 L7864576 A:35260 T:35260 P:T3A444999 I:13952,14166,14167,14168,14169,14170,14171,14173,14174,14175,14176,14177,27841,27846'
G[14173]='HD K16 L7864576 A:35261 T:35261 P:T3A644999 I:13952,14166,14167,14168,14169,14170,14171,14172,14174,14175,14176,14177,27841,27846'
G[14174]='HD FH K16 L7864576 RU A:34476 T:34476 I:13952,14166,14167,14168,14169,14170,14171,14172,14173,14175,14176,14177,27841,27846'
G[14175]='HD FH K16 L256 RO A:34477 T:34477 I:13952,14166,14167,14168,14169,14170,14171,14172,14173,14174,14176,14177,27841,27846'
G[14176]='HD FH K16 L256 RT A:34480 T:34480 I:13952,14166,14167,14168,14169,14170,14171,14172,14173,14174,14175,14177,27841,27846'
G[14177]='HD FH K16 L7864576 RL RZ A:34482 T:34482 I:13952,14166,14167,14168,14169,14170,14171,14172,14173,14174,14175,14176,27841,27846'
G[14178]='FA L25 E31961'
G[14180]='FA L25 E31961'
G[14181]='FH L15617 E32305'
G[14182]='FH L25 E32305'
G[14183]='FH L15617 E32305'
G[14184]='L10 A:35286 T:35295 P:28548,26134'
G[14188]='FH L10 A:35295 T:35298 P:14184'
G[14189]='FH L10 A:35298 T:1195433 P:14188'
G[14190]='FH L5 A:35091 T:1195431 P:14165'
G[14191]='FH L10 A:1195433 T:1195433 P:14189'
G[14192]='FH L5 A:1195431 T:1195435 P:14190'
G[14193]='L10 A:1195438 T:-66'	-- T is correct, but at the location of the A code because of a ceremony performed there
G[14194]='FH L5 A:1195435 T:35091 P:14192'
G[14195]='FH L10 A:1195433 T:1195445 P:14360'
G[14196]='FH L10 A:1195445 T:1195445 P:14195'
G[14197]='FH L5 A:35085 T:35085'
G[14198]='FH L10 A:35506,35510,1195445 T:35295 P:14196'
G[14199]='L80 E31961'
G[14201]='FH L5 A:35087 T:35087 P:24453'
G[14202]='FH L5 A:35088 T:35088 P:24453'
G[14203]='K1 L10 A:100048679 T:32337 P:PF001'
G[14204]='FA L1 RW A:35378 T:35378 P:14159'
G[14209]='FH L5 A:35088 T:35088 P:14202'
G[14212]='FA L1 RW A:35552 T:35618 P:14294'
G[14213]='L10 A:1195497 T:1195497'
G[14214]='FA L1 RW A:35378 T:35550 P:14204'
G[14215]='FH L5 A:35087 T:-76,35087 P:14201'
G[14216]='FH L5 A:-76,35087 T:35087 P:14215'
G[14217]='K1 L10 A:1195497 T:1195497'
G[14218]='FA L1 RW A:35618 T:35618 P:14212'
G[14219]='FH L10 A:1195517 T:1195517'
G[14221]='FA L1 RW A:35618 T:35566 P:14218'
G[14222]='FA L1 RW A:35566 T:35566 P:14221'
G[14223]='FH L10 A:35298 T:35298 P:14198'
G[14225]='FH L10 A:35298 T:35298 P:14223'
G[14226]='FH L5 A:35187 T:35187 P:14249+14250+14263'
G[14227]='FH L10 A:35298 T:35298 P:14225'
G[14230]='FH L5 A:35756 T:35756 P:14249+14250+14263'
G[14232]='FH L10 A:100049010 T:35298'
G[14233]='FH L1 RG A:35837 T:35650 P:14248'
G[14234]='FH L1 RG A:35650 T:35875 P:14021+14031+14233'
G[14235]='FH L1 RG A:35875 T:35893 P:14234'
G[14236]='FH L1 RG A:35893 T:35893 P:14235'
G[14237]='FH L1 RG A:35875 T:35917 P:14303'
G[14238]='FH L1 RG A:35917 T:35917 P:14237'
G[14239]='SP FH L1 RG A:36608 T:36608 P:14126'
G[14240]='FH L1 RG A:35917 T:36112 P:14238'
G[14241]='FH L1 RG A:36112 T:36127 P:14240'
G[14242]='FH L1 RG A:36127 T:36145 P:14241'
G[14243]='FH L1 RG A:36161 T:36188 P:14326'
G[14244]='FH L1 RG A:36425 T:36470 P:14445'
G[14245]='FH L1 RG A:36470 T:36471 P:14244 OCC:26705'
G[14246]='L10 A:35661 T:35661'
G[14247]='L10 A:35661 T:1195600'
G[14248]='FH L1 RG A:35650 T:35769 P:14014+14019+14473'
G[14249]='FH L5 A:35648 T:35648 P:14340'
G[14250]='FH L5 A:35755 T:35755 P:14340'
G[14251]='L10 A:35757 T:35757'
G[14252]='L10 A:35757 T:35757'
G[14253]='L10 A:35757 T:35757'
G[14254]='L10 A:1195600 T:35757 P:14247'
G[14255]='L10 A:35295 T:35773 P:14191'
G[14256]='L10 A:35773 T:35773 O:14255,14365'
G[14257]='L10 A:35773 T:35773 P:14256'
G[14258]='FH L5 A:35817 T:35817'
G[14260]='L10 A:35773 T:35827 P:14257'
G[14261]='FH L5 A:37064 T:37064'
G[14262]='FH L5 A:35657 T:35657 P:14258'
G[14263]='FH L5 A:35754 T:35754 P:14340'
G[14264]='L10 A:35827 T:35827 P:14260'
G[14265]='FA L1 RW CW A:35840 T:35839 P:14099 ODC:14269,14273,14275,14277,14278,14280'	--	Worgen skill quests are also ODC:24464,24465,24466,24481,24485,26201,26904 if want to be crazy about it
G[14266]='L1 CW A:35839 T:35839 P:14265 ODC:14272,14274,14276,14279,14281,14283 Z21691'
G[14267]='FH L5 A:35657 T:1195642 P:14258'
G[14268]='L10 A:35827 T:-66,35773 P:14264'
G[14269]='FA L1 RW CR A:35840 T:35871 P:14099 ODC:14265,14273,14275,14277,14278,14280'
G[14270]='FH L5 A:1195642 T:1195642 P:14267'
G[14271]='FH L5 A:1195642 T:35657 P:14270'
G[14272]='L258 CR A:35871 T:35871 P:14269 ODC:14266,14274,14276,14279,14281,14283 Z21691'
G[14273]='FA L1 RW CL A:35840 T:35869 P:14099 ODC:14265,14269,14275,14277,14278,14280'
G[14274]='FA L1 RW CL A:35869 T:35869 P:14273 ODC:14266,14272,14276,14279,14281,14283 Z21691'
G[14275]='FA L1 RW CH A:35840 T:35874 P:14099 ODC:14265,14269,14273,14277,14278,14280'
G[14276]='FA L1 RW CH A:35874 T:35874 P:14275 ODC:14266,14272,14274,14279,14281,14283 Z21691'
G[14277]='FA L1 RW CM A:35840 T:35872 P:14099 ODC:14265,14269,14273,14275,14278,14280'
G[14278]='FA L1 RW CT A:35840 T:35870 P:14099 ODC:14265,14269,14273,14275,14277,14280'
G[14279]='FA L1 RW CT A:35870 T:35870 P:14278 ODC:14266,14272,14274,14276,14281,14283 Z21691'
G[14280]='FA L1 RW CD A:35840 T:35873 P:14099 ODC:14265,14269,14273,14275,14277,14278'
G[14281]='FA L1 RW CM A:35872 T:35872 P:14277 ODC:14266,14272,14274,14276,14279,14283 Z21691'
G[14282]='L10 A:-66,35773 T:35773 P:14268'
G[14283]='L1 CD A:35873 T:35873 P:14280 ODC:14266,14272,14274,14276,14279,14281 Z21691'
G[14284]='L10 A:35902 T:35902 P:14292'
G[14285]='FA L1 RW CR A:35871 T:35112 P:14269 ODC:14286,14287,14288,14289,14290,14291'
G[14286]='FA L1 RW CW A:35839 T:35112 P:14265 ODC:14285,14287,14288,14289,14290,14291'
G[14287]='FA L1 RW CL A:35869 T:35112 P:14273 ODC:14285,14286,14288,14289,14290,14291'
G[14288]='FA L1 RW CM A:35872 T:35112 P:14277 ODC:14285,14286,14287,14289,14290,14291'
G[14289]='FA L1 RW CT A:35870 T:35112 P:14278 ODC:14285,14286,14287,14288,14290,14291'
G[14290]='FA L1 RW CH A:35874 T:35112 P:14275 ODC:14285,14286,14287,14288,14289,14291'
G[14291]='FA L1 RW CD A:35873 T:35112 P:14280 ODC:14285,14286,14287,14288,14289,14290'
G[14292]='L10 A:35773 T:35902 P:14282'
G[14293]='FA L1 RW A:35550 T:35906 P:14214'
G[14294]='FA L1 RW A:35906 T:35911 P:14293'
G[14295]='FH L5 A:35657 T:35657 P:14271'
G[14296]='FH L5 A:36334 T:36361 P:14413'
G[14297]='FH L5 A:37061 T:37061'
G[14299]='FH L5 A:36361 T:36372 P:14300+24478+24479'
G[14300]='FH L5 A:36361 T:36335,36361 P:14296'
G[14301]='L10 A:35902 T:35773 P:14284'
G[14302]='L10 A:35773 T:36034 P:14301'
G[14303]='FH L1 RG A:35893 T:35875 P:14236'
G[14304]='L10 A:36048 T:36048'
G[14305]='L10 A:36060 T:36060'
G[14306]='L10 A:36060 T:36060'
G[14307]='L10 A:36034 T:36034'
G[14308]='FH L5 A:36077 T:1195676 O:14424'
G[14309]='L10 A:36048 T:36048 P:14304'
G[14310]='FH L5 A:1195676 T:36077 P:14308'
G[14311]='L10 A:36060 T:36060 P:14305'
G[14312]='L10 A:36052 T:36056 P:14311'
G[14313]='FA L1 RW A:36170 T:36132 P:14375'
G[14314]='L10 A:36056 T:36056 P:14312'
G[14316]='L10 A:36052 T:36052 P:14312'
G[14318]='L10 A:36056 T:36163 P:14314+14316'
G[14320]='FA L1 RW A:36132 T:1196394 P:14313'
G[14321]='FA L1 RW A:36205 T:34571 P:14320'
G[14322]='L5 A:36146 T:36146'
G[14323]='FH L5 A:35142 T:-76,35142 P:14130'
G[14324]='FH L5 A:-76,35142 T:35142 P:14323'
G[14325]='L10 A:36163,536163 T:536163 P:14318'
G[14326]='FH L1 RG A:36145 T:36161 P:14242'
G[14327]='L10 A:536163 T:36056 P:14325'
G[14328]='L10 A:36056 T:36185 P:14327'
G[14329]='L10 A:36185 T:-66,36185 P:14328'
G[14330]='L10 A:100038567 T:36196 P:14328'
G[14332]='L10 A:36196 T:36398 P:14330'
G[14333]='L10 A:1196393 T:-66,36185 P:14328'
G[14334]='FH L10 A:12031 T:12031'
G[14335]='FH L10 A:11624 T:11624'
G[14336]='FA L1 RW A:34571 T:36140 P:14321'
G[14337]='L10 A:36034 T:12031 P:14327 I:6142,14334'	-- guessed at possible quests that would invalidate this.  most likely either one of those will have an O of 14337 instead.  will need to test this.
G[14338]='L10 A:36034 T:4498 P:14311'
G[14339]='FH L10 A:4498 T:4498 O:14338'
G[14340]='FH L5 A:36210 T:35187 P:14345'
G[14341]='L10 A:11259 T:11596'
G[14342]='FH L10 A:5395 T:5395'
G[14343]='FH L10 A:4498 T:36034 P:14339'
G[14344]='L10 A:100049200 T:5395,-66'
G[14345]='FH L5 A:35142 T:36210 P:14131+14132+14324'
G[14346]='FH L10 A:36034 T:36034 P:14343,14379'
G[14347]='FA L1 RW A:36140 T:36140 P:14336'
G[14348]='FA L1 RW A:36140 T:36140 P:14336'
G[14354]='FA L10 A:5642 T:5642 P:14387'
G[14355]='L7722 E31961'
G[14356]='L2320 E31961'
G[14357]='FA L10 A:1195517 T:1195517'
G[14358]='L10 A:1195497 T:1195497'
G[14359]='K1 L10 A:1195497 T:1195497 P:14358'
G[14360]='FH L10 A:1195433 T:1195433 P:14191'
G[14361]='FA L10 A:5396 T:-66,5396 P:14354'
G[14362]='L10 A:100049203 T:5396'
G[14363]='FA L10 A:-66,5396 T:-66,5396 P:14361'
G[14364]='FA L10 A:-66,5396 T:5396 P:14363'
G[14365]='L10 A:5752 T:35773 P:14354'
G[14366]='FA L1 RW A:36140 T:34571 P:14347+14348'
G[14367]='FA L1 RW A:34571 T:36290 P:14366'
G[14368]='FA L1 RW A:36291 T:36291 P:14367'
G[14369]='FA L1 RW A:36290 T:36290 P:14367'
G[14370]='FH L5 A:36077 T:36077 P:14310'
G[14371]='FH L5 A:36077 T:36077 P:14310'
G[14372]='L10 A:36034 T:36329 P:14327'
G[14373]='FA L10 A:36329 T:36329 O:14372'
G[14374]='FA L10 A:36329 T:36329'
G[14375]='SP FA L1 RW A:36332 T:36332 P:14222'
G[14376]='L10 A:100049220 T:-66,36329'
G[14377]='FH L5 A:36077 T:36077 P:14370+14371'	-- 14371 required, guessing that 14370 is also required
G[14378]='FA L10 A:36329 T:36329 P:14373+14374'
G[14379]='FA L10 A:36378 T:36378 P:14373+14374'
G[14380]='FA L10 A:36329 T:36034 P:14378'
G[14381]='FA L10 A:36034 T:36034 P:14380'
G[14382]='FA L1 RW A:36290 T:36290 P:14367'
G[14383]='FH L5 A:36379 T:36379 P:14377'
G[14384]='FA L10 A:36410 T:5752 O:25938,28531'
G[14385]='FH L5 A:36077 T:36077 P:14377'
G[14386]='FA L1 RW A:36290 T:36290 P:14368+14369+14382'
G[14387]='FA L10 A:5396 T:5642 P:14384'
G[14388]='FH L5 A:36077 T:36077 P:14385'
G[14389]='FH L5 A:36372 T:-76,36436 P:14299'
G[14390]='FH L5 A:36436 T:-76,36436 P:14389'
G[14391]='FH L5 A:36436 T:535867 P:14390'
G[14392]='FH L5 A:36676 T:536210 P:14261+14297+24467'
G[14393]='L10 A:36398 T:36398 P:14332'
G[14394]='L10 A:36398 T:36444 P:14393'
G[14395]='FA L1 RW A:36451 T:36451 P:14396'
G[14396]='FA L1 RW A:36290 T:36451 P:14386'
G[14397]='FA L1 RW A:36451 T:36452 P:14395'
G[14398]='FA L1 RW A:36452 T:36458 P:14397'
G[14399]='FA L1 RW A:36458 T:36458 P:14398'
G[14400]='FA L1 RW A:36458 T:36458 P:14399'
G[14401]='FA L1 RW A:36458 T:36458 P:14400 ODC:25331'
G[14402]='FA L1 RW A:36458 T:36452 P:14401+14404+14412+14416 I:14405,14463'
G[14403]='FA L1 RW A:36452 T:36456 P:14397'
G[14404]='FA L1 RW A:36456 T:36456 P:14403'
G[14405]='FA L1 RW A:36456 T:36452 P:14401+14404+14412+14416 I:14402,14463'
G[14406]='FA L1 RW A:36452 T:36457 P:14397'
G[14407]='FH L5 A:36999 T:35867'	-- TODO: Determine the proper P code
G[14408]='FH L5 A:36500 T:36500 O:14442'
G[14409]='FA L18249 E31961'
G[14410]='FA L15 A:36487 T:40032 P:14381+14394 I:28511'
G[14411]='L15 A:11624 Z19342'
G[14412]='FA L1 RW A:36456 T:36456 P:14403'
G[14413]='FH L5 A:35187 T:36334 P:14226+14230'
G[14416]='FA L1 RW A:36457 T:36457 P:14406'
G[14422]='FH L5 A:36500 T:36500 P:14408'
G[14423]='FH L5 A:35088 T:35088 P:14209'
G[14424]='L5 A:35088 T:36077 P:14423'
G[14428]='L5 A:36596 T:1196832'
G[14429]='L5 A:1196832 T:1196833 P:14428'
G[14430]='L5 A:1196833 T:36596 P:14429'
G[14431]='L5 A:8586 T:8586'
G[14432]='L5 A:8586 T:8586 P:14431'
G[14433]='L5 A:8586 T:8586 P:14431'
G[14434]='SP FA L1 RW A:36616 T:36616 P:26706'
G[14435]='L5 A:8586 T:8586 P:14442+14433'
G[14436]='L1 E31961'
G[14438]='FH L1 A:36644 T:36644'
G[14442]='L5 A:36146 T:36500 P:14322'
G[14443]='FA L25 A:100050379 T:36624'
G[14444]='FA L25 A:36624 T:36669 P:14443'
G[14445]='FH L1 RG A:36188 T:36425 P:14243'
G[14446]='L30 E31961'
G[14447]='FH L25 A:30824 T:29795'	-- this just copy of 13260 because I do not know what is actually out there now
G[14448]='FH L25 A:30824 T:29795'	-- this just copy of 13260 because I do not know what is actually out there now
G[14449]='L1 A:2981 T:2980'
G[14452]='L1 A:2980 T:2980 P:14449'
G[14455]='L1 A:36694 T:36694 P:14458'
G[14456]='FH L1 A:36694 T:36694 P:14458'
G[14457]='FA L25 A:36669 T:36669 P:14444'
G[14458]='FH L1 A:2980 T:36694 P:24852'
G[14459]='L1 A:36694 T:36694 P:14455+14456'
G[14460]='L1 A:36694 T:2981 P:14459+14461'
G[14461]='L1 A:36694 T:36694 P:14455+14456'
G[14462]='FH L5 A:36730 T:36729'
G[14463]='FA L1 RW A:36457 T:36452 P:14401+14404+14412+14416 I:14402,14405'
G[14464]='FH L5 A:36729 T:36730 P:14462'
G[14465]='L1 A:36452 T:36606 P:14402,14405,14463'
G[14466]='FA L1 RW A:36606 T:36743 P:14465'
G[14467]='SP FA L1 RW A:36743 T:36743 P:14466'
G[14468]='FH L5 A:36752 T:36749 P:14194+14197+14161'
G[14469]='FH L5 A:36749 T:36749 P:14468'
G[14470]='FH L5 A:36744 T:36744 P:14468'
G[14471]='FH L5 A:36746 T:36746 P:14468'
G[14472]='FH L5 A:36744 T:36744 P:14469+14470+14471'
G[14473]='FH L1 RG A:35786 T:35786 P:14001'
G[14474]='FH L1 RG E31961'
G[14475]='FH L5 A:36728 T:36785'
G[14476]='FH L5 A:36785 T:36785 P:14475'
G[14477]='FH L5 A:36785 T:36728 P:14476'
G[14478]='FH L5 A:1201578,1203755 T:536749 P:24452'
G[14479]='FH L5 A:36956 T:36920 P:24455'
G[14480]='FH L5 A:36895 T:36895 P:24448'
G[14481]='FA L1 A:36674 T:36799 I:27724,28827'
G[14482]='FA L30 A:36799 T:36915 O:14481,27724,28827'
G[14483]='HA FH L7864576 A:100050320 T:37172'
G[14484]='FH L5 A:36895 T:36895 P:24448'
G[14485]='FH L5 A:36895 T:36895 P:24448'
G[14486]='FH L5 A:36894 T:36894 P:24448'
G[14487]='FH L5 A:36745 T:36745 P:24448'
G[14488]='L19280 E31961'
G[14491]='FH L1 A:36644 T:36644 P:14438'
G[20438]='FA L25 A:36669 T:36669 P:14457'
G[20439]='FA L25 A:36669 T:36669 P:20438'
G[20440]='FH L1 RT A:2948 T:2948'
G[20441]='FH L1 A:3054 T:37024 P:24457'
G[23733]='L1 A:2981 T:36803 P:24861'
G[24215]='L1 A:36803 T:36644 P:23733'
G[24216]='FH L5377 E32305'
G[24217]='FH L2817 E32305'
G[24218]='FA L15 E32305'
G[24219]='FA L2817 E32305'
G[24220]='FA L5377 E32305'
G[24221]='FH L5377 E32305'
G[24223]='FA L25 E32305'
G[24224]='FA L13057 E32305'
G[24225]='FH L25 E32305'
G[24426]='FH L25 E32305'
G[24427]='FA L25 E32305'
G[24428]='fA L30 A:100049644 T:1435'
G[24429]='L30 A:100049643 T:3216'
G[24430]='FH L5 A:36903 T:36903 P:14477+24433'
G[24431]='L10 A:100049667 T:32337 P:PF001'
G[24432]='FA L30 A:36915 T:36915 P:14482'
G[24433]='FH L5 A:36730 T:36730'
G[24434]='FH L5 A:36919 T:36918'
G[24435]='FH L5 A:36920 T:36920 P:14479'
G[24436]='FH L5 A:36921 T:36921'	-- need to determine proper P code
G[24437]='L5 A:36795 T:36795'
G[24438]='L1 A:36743 T:37065 P:14467'
G[24439]='FH L5 A:36730 T:36730 P:24430'
G[24440]='FH L1 RT A:2948 T:2948 P:20440'
G[24441]='FH L1 RT A:2948 T:2948 P:24440'
G[24442]='L25 A:100049676 T:33817 P:J3676,J3677'
G[24448]='FH L5 A:36920 T:36745 P:24435+24436'	-- 24436 is correct, and assuming 24435 also required
G[24449]='FH L5 A:36745 T:36959 P:14480+14484+14485+14486+14487'
G[24451]='FH L25 A:36670 T:36670 P:24556'
G[24452]='FH L5 A:36749 T:36749 P:14472'
G[24453]='FH L5 A:36749 T:36752 P:24452'
G[24454]='FA L25 A:36669 T:36624 P:20439'
G[24455]='FH L5 A:536749 T:36956 P:14478'
G[24456]='FH L1 RT A:2948 T:2948 P:24441'
G[24457]='L1 A:2948 T:3054 P:24456'
G[24458]='L5 A:36379 T:37009 P:14383+14388'	-- 14388 is correct, assuming also requires 14383
G[24459]='FH L1 A:36644 T:2988'
G[24460]='L1 E21655'
G[24461]='FA L25 A:36624 T:36624 P:24454'
G[24463]='L3936000 A:36728 T:34195 P:24439 I:13612,13866,28493,28876'
G[24467]='FH L5 A:535867 T:535867,36689 P:14391'
G[24468]='FA L1 RW A:37065 T:37065 P:E24438'
G[24469]='FA L1 A:37081 T:37081'	-- dwarf monk got this
G[24470]='FA L1 A:37081 T:37081 P:24469'
G[24471]='L1 A:658 T:658 P:24469'
G[24472]='FA L1 RW A:37065 T:37065 P:24468'
G[24473]='FA L1 A:37081 T:37087 P:24470+24471'
G[24474]='FA L1 A:37087 T:37087 P:24473'
G[24475]='FA L1 A:37087 T:37087 P:24474'
G[24476]='FA K64 L25 A:36624 T:36624 P:24461'
G[24477]='FA L1 A:1104 T:1104 P:24473'
G[24478]='FH L5 A:36361 T:36336,36361 P:14296'
G[24479]='FH L5 A:36361 T:36337,36361 P:14296'
G[24480]='FA L25 A:36624 T:36624 P:24476'
G[24483]='FA L1 RW A:37065 T:37102 P:24472'
G[24484]='FA L1 RW A:37102 T:37102 P:24483'
G[24486]='FA L1 A:1104 T:1104 P:24477'
G[24487]='FA L1 A:37087 T:786 P:24475+24486'
G[24488]='FH L1 RG A:37106 T:37106 P:24567'
G[24489]='FA L1 A:1354 T:1354 P:24487'
G[24490]='FA L1 A:786 T:6782 P:218'
G[24491]='FA L1 A:6782 T:37113 P:24490'
G[24492]='FA L1 A:37113 T:37113 P:24491'
G[24493]='FA L1 A:37087 T:1872 P:B24492'
G[24494]='FA L5 RF CS A:37087 T:37115 Z18505'
G[24495]='FA L1 RW A:37815 T:37815 P:24483'
G[24496]='FA L5 RF RE CM A:37087 T:37121 Z18505'
G[24497]='FH L5 A:37142 T:36730 P:14392'
G[24498]='L25 A:36993 T:37591 P:24683'
G[24499]='L25 A:37597 T:38160 O:24510'
G[24500]='L25 A:37582 T:36955'
G[24501]='FA L1 RW A:37102 T:37102 P:24484'
G[24502]='FH L1 RG A:37106 T:-605 P:24488'
G[24503]='FH L1 RG A:-605 T:37106 P:24502+m24503 I:28414'
G[24504]='FH L10 A:37135 T:37137 O:26069,28549'
G[24505]='FH L10 A:37137 T:37138 P:24504'
G[24506]='L25 A:37780 T:37596'
G[24507]='L25 A:36990 T:37592 P:24682'
G[24508]='L1 E21655'
G[24509]='L1 E21655'
G[24510]='L25 A:37776 T:37597'
G[24511]='L25 A:37596 T:38161 O:24506'
G[24512]='FH L10 A:37153 T:37153'
G[24513]='FH L10 A:37136 T:37136'
G[24514]='FH L10 A:37138 T:37138'
G[24515]='L10 A:37138 T:11857'
G[24517]='FH L10 A:37154 T:37154'
G[24518]='FH L10 A:100049776 T:37154'	-- carried by target of 24517
G[24519]='FH L10 A:37154 T:37154 P:24518'
G[24520]='FH L1 RG A:37106 T:34668 P:24503,28414'
G[24521]='L1 T:37106'
G[24522]='FA L25 A:36624 T:37527 P:24480'
G[24523]='FH L1 RT A:37024 T:37024 P:20441'
G[24524]='FH L1 RT A:37024 T:37024 P:24523'
G[24525]='FH L10 A:11857 T:11857'
G[24526]='FA L5 RF CM A:37121 T:37121 P:24496'
G[24527]='FA L5 RF CS A:37115 T:37115 P:24494'
G[24528]='FA L5 RF CP A:926 T:926 P:3107'
G[24529]='FH L10 A:11857 T:11857'
G[24530]='FA L515 RF CH A:895 T:895 Z18505'
G[24531]='L5 RF CW A:912 T:912 P:3106 Z18505'
G[24532]='L5 CR A:916 T:916 P:3109'
G[24533]='FA L5 RF CT A:837 T:837 P:3110'
G[24534]='FH L10 A:11857 T:11857 P:24529'
G[24535]='FA L25 A:37527 T:37527 P:24522'
G[24536]='HA L7864576 A:37172 T:37172 O:24805'
G[24539]='FH L10 A:37515 T:37515 P:24515'
G[24540]='FH L1 A:36648 T:36648 P:24550'
G[24541]='HA L7864576 A:37172 T:37172 P:24536'
G[24542]='FH L10 A:37515 T:37570 P:24539'
G[24543]='L10 A:37516 T:3418 P:24529'
G[24544]='L0 E21691'
G[24545]='L30 CW CP CK A:37120 T:1201742'
G[24546]='FH L10 A:3418 T:3418 P:24543'
G[24547]='L30 A:37120 T:37120 P:24743'
G[24548]='L30 A:37120 T:37120 P:24757'
G[24549]='L30 A:37120 T:37120 P:24548'
G[24550]='FH L1 A:37024 T:36648 P:24524'
G[24551]='FH L10 A:3433 T:37679'
G[24552]='FH L10 A:3387 T:3387'
G[24553]='FA L25 XD XT XS A:37527 T:36624 P:24535'
G[24554]='FH L25 A:100050380 T:36642'
G[24555]='FH L25 A:36642 T:36670 P:24554'
G[24556]='FH L25 A:36670 T:36670 P:24557'
G[24557]='FH L25 A:36670 T:36670 P:24555'
G[24558]='FH L25 A:36670 T:36642 P:24451'
G[24559]='FH L25 A:36642 T:36642 P:24558'
G[24560]='FH L25 A:36642 T:36642 P:24559'
G[24561]='FH L25 A:36642 T:36642 P:24560'
G[24562]='FH L25 A:36642 T:37527 P:24561'
G[24563]='FH L25 A:37527 T:37527 P:24562'
G[24564]='FH L25 RO RU RT RL RG RA RR RM RZ SB XD XT XS A:37527 T:36642 P:24563'
G[24565]='L10 A:37570 T:37570'
G[24566]='L10 A:38314 T:38314 P:24570+24571'
G[24567]='FH L1 RG A:34874 T:37106 P:14071 ODC:24521'
G[24569]='FH L10 A:37679 T:37679 P:24546+24551'
G[24570]='L10 A:38314 T:38314'
G[24571]='L10 A:38314 T:38314'
G[24572]='FH L10 A:37679 T:37679 P:24569'
G[24573]='FH L10 A:37717 T:37717 P:24569'
G[24574]='L10 A:37570 T:37570 P:24565'
G[24575]='FA L1 RW A:37783 T:37783 P:24677'
G[24576]='HA L7864576 A:38328 T:37172 P:24851 I:24657'
G[24577]='FH L10 A:-199,37679 T:37811 P:24572'
G[24578]='FA L1 RW A:37815 T:37822 P:24495+24501'
G[24579]='K4 L30 A:20735 T:20735'
G[24580]='K4 L30 A:20735 T:20735'
G[24581]='K4 L30 A:20735 T:20735'
G[24582]='K4 L30 A:20735 T:20735'
G[24583]='K4 L30 A:20735 T:20735'
G[24584]='K4 L30 A:20735 T:20735'
G[24585]='K4 L30 A:20735 T:20735'
G[24586]='K4 L30 A:20735 T:20735'
G[24587]='K4 L30 A:20735 T:20735'
G[24588]='K4 L30 A:20735 T:20735'
G[24589]='K4 L30 A:20735 T:20735'
G[24590]='K4 L30 A:20735 T:20735'
G[24591]='FH L10 A:37811 T:-199 P:24577'
G[24592]='FA L1 RW A:37874 T:37876 P:24672'
G[24593]='FA L1 RW A:37195 T:37195 P:24628+24646'
G[24594]='FH L25 RB XD XT XS A:37527 T:36642 P:24563'
G[24595]='FA L25 CD CT CS A:37527 T:36624 P:24535'
G[24596]='FH L25 RB CD CT CS A:37527 T:36642 P:24563'
G[24597]='HA FA K2 L7864576 A:37887 T:29611'
G[24598]='FH L25 RO RU RT RL RG RA RR RM RZ SB CD CT CS A:37527 T:36642 P:24563'
G[24601]='L10 A:37570 T:537570,37570 P:24574'
G[24602]='FA L1 RW A:38144 T:38144 P:24678'
G[24603]='FH L10 A:37847 T:37847 O:24604'
G[24604]='FH L10 A:37812 T:37847'
G[24606]='L10 A:100049932 T:37812'
G[24607]='FH L1 CW A:37951 T:38037'
G[24608]='FH L10 A:37847 T:37847 P:24603'
G[24609]='HA FA K2 L7864576 A:38041 T:42928'
G[24610]='HA FA K2 L7864576 A:38039 T:7999'
G[24611]='HA FA K2 L7864576 A:38040 T:17468'
G[24612]='HA FH K2 L7864576 A:38042 T:39605'
G[24613]='HA FH K2 L7864576 A:38045 T:10181'	-- TODO: G62|Holiday fail|
G[24614]='HA FH K2 L7864576 A:38044 T:36648'
G[24615]='HA FH K2 L7864576 A:38043 T:16802'	-- TODO: G62|Holiday fail|
G[24616]='FA L1 RW A:37822 T:37822 P:24578'
G[24617]='FA L1 RW A:37822 T:37195 P:24616'
G[24618]='FH L10 A:37837 T:37837 P:24591'
G[24619]='FH L10 A:37908 T:37908'
G[24620]='FH L10 A:37908 T:37908 P:24619'
G[24621]='FH L10 A:37908 T:37908 P:24620'
G[24622]='L1 A:38005 T:37969 P:25064'
G[24623]='L1 A:37969 T:37969 P:24622'
G[24624]='L1 A:37987 T:37987 P:24622'
G[24625]='L1 A:37987 T:37987 P:24622'
G[24626]='L1 A:37969 T:38005 P:24623+24624+24625'
G[24627]='FA L1 RW A:37195 T:37195 P:24617'
G[24628]='FA L1 RW A:37873 T:37873 P:24617'
G[24629]='HA K2 L7864576 GF AP:37675:FA;537675:FH TP:37675:FA;537675:FH I:24635,24636'
G[24631]='FH L10 A:37909 T:37909'
G[24632]='L10 A:37909 T:3341 P:24631'
G[24633]='FH L10 A:37812 T:37812 P:24653'
G[24634]='FH L10 A:37837 T:37837 P:24591'
G[24635]='HA K2 L7864576 GM AP:37675:FA;537675:FH TP:37675:FA;537675:FH I:24636,24629'
G[24636]='HA K2 L7864576 AP:37675:FA;537675:FH TP:37675:FA;537675:FH I:24635,24629'
G[24637]='FH L10 A:37837 T:37837 P:24634'
G[24638]='HA FH K2 L1280 M013 A:37172 T:37172 P:24576 I:24645,24647,24648,24649,24650,24651,24652,24658,24659,24660,24662,24663,24664,24665,24666,28934,28935'
G[24639]='L1 CW A:38037 T:38037 P:24607'
G[24640]='L1 CW A:38037 T:38037 P:24642 Z21691'
G[24641]='L1 CW A:38037 T:38037 P:24639'
G[24642]='L1 CW A:38037 T:38037 P:24641'
G[24643]='L1 CW A:38037 T:38966 P:24642'
G[24644]='L1 E21655'
G[24645]='HA K2 L7867904 M022 A:37172 T:37172 P:24576 I:24638,24647,24648,24649,24650,24651,24652,24658,24659,24660,24662,24663,24664,24665,24666,28934,28935'
G[24646]='FA L1 RW A:37195 T:37195 P:24627'
G[24647]='HA K2 L7870208 M031 A:37172 T:37172 P:24576 I:24638,24645,24648,24649,24650,24651,24652,24658,24659,24660,24662,24663,24664,24665,24666,28934,28935'
G[24648]='HA K2 L7872512 M040 A:37172 T:37172 P:24576 I:24638,24645,24647,24649,24650,24651,24652,24658,24659,24660,24662,24663,24664,24665,24666,28934,28935'
G[24649]='HA K2 L7874816 M050 A:37172 T:37172 P:24576 I:24638,24645,24647,24648,24650,24651,24652,24658,24659,24660,24662,24663,24664,24665,24666,28934,28935'
G[24650]='HA K2 L7877376 M060 A:37172 T:37172 P:24576 I:24638,24645,24647,24648,24649,24651,24652,24658,24659,24660,24662,24663,24664,24665,24666,28934,28935'
G[24651]='HA K2 L7879936 M070 A:37172 T:37172 P:24576 I:24638,24645,24647,24648,24649,24650,24652,24658,24659,24660,24662,24663,24664,24665,24666,28934,28935'
G[24652]='HA K2 L7882496 M080 A:37172 T:37172 P:24576 I:24638,24645,24647,24648,24649,24650,24651,24658,24659,24660,24662,24663,24664,24665,24666,28934,28935'
G[24653]='L10 A:37812 T:37812 P:24606'
G[24654]='FH L10 A:37910 T:37910'
G[24655]='HA L7864576 A:38066 T:38066 O:24804'
G[24656]='HA L7864576 A:38066 T:38066 P:24655'
G[24657]='HA L7864576 A:38325 T:38066 P:24849 I:24576'
G[24658]='HA K2 L7865600 M013 A:38066 T:38066 P:24657 I:24638,24645,24647,24648,24649,24650,24651,24652,24659,24660,24662,24663,24664,24665,24666,28934,28935'
G[24659]='HA K2 L7867904 M022 A:38066 T:38066 P:24657 I:24638,24645,24647,24648,24649,24650,24651,24652,24658,24660,24662,24663,24664,24665,24666,28934,28935'
G[24660]='HA K2 L7870208 M031 A:38066 T:38066 P:24657 I:24638,24645,24647,24648,24649,24650,24651,24652,24658,24659,24662,24663,24664,24665,24666,28934,28935'
G[24661]='L0 T:110024 E21655'
G[24662]='HA K2 L7872512 M040 A:38066 T:38066 P:24657 I:24638,24645,24647,24648,24649,24650,24651,24652,24658,24659,24660,24663,24664,24665,24666,28934,28935'
G[24663]='HA K2 L7874816 M050 A:38066 T:38066 P:24657 I:24638,24645,24647,24648,24649,24650,24651,24652,24658,24659,24660,24662,24664,24665,24666,28934,28935'
G[24664]='HA K2 L7877376 M060 A:38066 T:38066 P:24657 I:24638,24645,24647,24648,24649,24650,24651,24652,24658,24659,24660,24662,24663,24665,24666,28934,28935'
G[24665]='HA K2 L7879936 M070 A:38066 T:38066 P:24657 I:24638,24645,24647,24648,24649,24650,24651,24652,24658,24659,24660,24662,24663,24664,24666,28934,28935'
G[24666]='HA K2 L7882496 M080 A:38066 T:38066 P:24657 I:24638,24645,24647,24648,24649,24650,24651,24652,24658,24659,24660,24662,24663,24664,24665,28934,28935'
G[24667]='L10 A:37910 T:37834 P:24654'
G[24671]='FH L1 RG A:38120 T:38120 P:26705 O:27139'
G[24672]='FA L1 RW A:37102 T:37874 P:24673'
G[24673]='FA L1 RW A:37195 T:37102 P:24593'
G[24674]='FA L1 RW A:37803 T:37803 P:24438'
G[24675]='FA L1 RW A:38143 T:38143 P:24438'
G[24676]='FA L1 RW A:37783 T:37783 P:24575+24674+24675'
G[24677]='FA L1 RW A:37876 T:37783 P:24592'
G[24678]='FA L1 RW A:38539 T:38144 P:24920'
G[24679]='FA L1 RW A:38144 T:38144 P:24602'
G[24680]='FA L1 RW A:38144 T:38149 P:24679'
G[24681]='FA L1 RW A:38149 T:38149 P:24680'
G[24682]='L25 A:38161 T:36990 P:24511'
G[24683]='L25 A:38160 T:36993 P:24499'
G[24684]='FH L10 A:3341 T:38140 P:24632'
G[24685]='FH L10 A:38140 T:38140 P:24684'
G[24686]='L15 A:38274 T:38274 P:24719'
G[24687]='L15 A:38263 T:38263 P:24689'
G[24689]='L15 A:38274 T:38263 P:24686'
G[24690]='L15 A:9270 T:9270 P:24740'
G[24691]='L15 A:10977 T:10977 P:24690'
G[24692]='K512 L15 A:9271 T:9271 P:24690'	-- PM2
G[24693]='L15 A:10977 T:38275 P:24691'
G[24694]='L15 A:38504 T:38502 P:24721+24722+24723'
G[24695]='L15 A:38502 T:38502 P:24694'
G[24697]='L15 N30 A:38270 T:38270'
G[24698]='L15 A:38270 T:9272 P:24693'
G[24699]='L15 A:38276 T:38276 P:24737'
G[24700]='L15 A:38276 T:38276 P:24693'
G[24701]='L15 A:38277 T:38277 P:24693'
G[24702]='K1 L15 A:1202135 T:1202135'
G[24703]='L15 A:38237 T:38237'
G[24704]='L15 A:38237,38255 T:-78,38237,38255 P:24703'
G[24705]='L15 A:38237,38255 T:-78,38237,38255 P:24703'
G[24706]='L15 A:38237,38255 T:38237 P:24705'
G[24707]='L15 A:38237 AH:38343 T:-78,38237,38343 P:24706'
G[24708]='L15 A:9272 T:9272 P:24730'
G[24709]='L15 A:9272 T:9272 P:24708'
G[24710]='L25 A:37591 T:38188 P:24498'
G[24711]='L25 A:38188 T:37221 P:24710'
G[24712]='L25 A:37592 T:38189 P:24507'
G[24713]='L25 A:38189 T:37223 P:24712'
G[24714]='L15 A:9618 T:9623 P:24737+24700+24701'
G[24715]='L15 A:9623 T:9623 P:24714'
G[24717]='L15 A:38275 T:38275 P:C24737+C24700+C24701'
G[24718]='L15 A:-100078 T:38275 P:24737+24700+24701'
G[24719]='L15 A:38274 T:38274 O:24854'
G[24720]='L15 A:9117 T:9117'
G[24721]='L15 A:38263 T:9117 P:24855'	--	Note that with 24721, 24865 and 24911 in the quest log, the Marshall's Refuge has nothing in it except golems.
G[24722]='L15 A:38275 T:9117 P:24717'
G[24723]='L15 A:9272 T:9117 P:24709'
G[24724]='K1 L15 A:1164955 T:1164955 P:24720'
G[24725]='K1 L15 A:1164955 T:1164955 P:24720'
G[24726]='K1 L15 A:1164957 T:1164957 P:24720'
G[24727]='K1 L15 A:1164957 T:1164957 P:24720'
G[24728]='K1 L15 A:1164956 T:1164956 P:24720'
G[24729]='K1 L15 A:1164956 T:1164956 P:24720'
G[24730]='L15 A:9272 T:9272 O:24698'
G[24731]='L15 A:9619 T:9619'
G[24732]='L15 A:9619 T:9619 P:24731'
G[24733]='L15 A:9619 T:9619 P:24732'
G[24734]='L15 A:9997 T:1202264 P:24794 I:C24736'
G[24735]='L15 A:9999 T:9997 P:24734 I:C24736'
G[24736]='L15 A:9998 T:9998'
G[24737]='L15 A:38276 T:38276 P:24693'
G[24738]='L20 E21655'
G[24739]='L20 E21655'
G[24740]='L15 N30 A:9270 T:9270 O:24911,28525,28526'
G[24741]='FH L1 RG A:38122 T:38122 P:24671'
G[24742]='L15 N30 A:10302 T:10302'
G[24743]='L30 A:37120 T:37120 P:24545'
G[24744]='FH L1 RG A:38120 T:38120 P:24741'
G[24745]='HA FA L7864576 A:100050320 T:38066'
G[24746]='L1 E21655'
G[24747]='FH L10 A:38140 T:3341 P:24685'
G[24748]='L30 A:37120 T:37120 P:24549'
G[24749]='L30 CW CP CK A:37120 T:37120 P:24547'
G[24750]='FH L1 CM A:37951 T:38246'
G[24751]='L1 CM A:38246 T:38246 P:24750'
G[24752]='FH L1 CM A:38246 T:38246 P:24754 Z21691'
G[24753]='L1 CM A:38246 T:38246 P:24751'
G[24754]='L1 CM A:38246 T:38246 P:24753'
G[24755]='L1 CM A:38246 T:38966 P:24754'
G[24756]='L30 A:37120 T:37120 P:24749'
G[24757]='L30 A:37120 T:37120 P:24756'
G[24758]='FH L1 CS A:37951 T:38242'
G[24759]='L1 CS A:38242 T:38242 P:24758'
G[24760]='L5 CS A:38242 T:38242 P:24762 Z21691'
G[24761]='L1 CS A:38242 T:38242 P:24759'
G[24762]='L1 CS A:38242 T:538242,38242 P:24761'
G[24763]='L1 CS A:38242 T:38966 P:24762'
G[24764]='FH L1 CD A:37951 T:38243'
G[24765]='L1 CD A:38243 T:38243 P:24764'
G[24766]='L1 CD A:538243 T:38243 P:24768 Z21691'
G[24767]='L1 CD A:38243 T:38243 P:24765'
G[24768]='L1 CD A:38243 T:538243 P:24767'
G[24769]='L1 CD A:38243 T:38966 P:24768'
G[24770]='FH L1 CR A:37951 T:38244'
G[24771]='L1 CR A:38244 T:38244 P:24770'
G[24772]='L1 RU RL RB CR A:38244 T:38244 P:24774 Z21691'
G[24773]='L1 CR A:38244 T:38244 P:24771'
G[24774]='L1 CR A:38244 T:38244 P:24773'
G[24775]='L1 CR A:38244 T:38966 P:24774'
G[24776]='FH L1 CH A:37951 T:38247'
G[24777]='L1 CH A:38247 T:38247 P:24776'
G[24778]='L1 CH A:38247 T:38247 P:24780 Z21691'
G[24779]='L1 CH A:38247 T:38247 P:24777'
G[24780]='L1 CH A:38247 T:38247 P:24779'
G[24781]='L1 CH A:38247 T:38966 P:24780'
G[24782]='FH L1 CT A:37951 T:38245'
G[24783]='L1 CT A:38245 T:38245 P:24782'
G[24784]='L1 CT A:38245 T:38245 P:24786'
G[24785]='L1 CT A:38245 T:38245 P:24783'
G[24786]='L1 CT A:38245 T:38245 P:24785'
G[24787]='L1 CT A:38245 T:38966 P:24784'
G[24788]='L10 E21655'
G[24789]='L10 E21655'
G[24790]='L10 E21655'
G[24791]='L10 E21655'
G[24792]='FA L7884288 E32305'
G[24793]='FH L7884288 E32305'
G[24794]='L15 A:10302 T:9997 P:24742 I:C24736'
G[24795]='FA L25 CD CT CS A:36624 T:33817 P:24595'
G[24796]='FA L25 XD XT XS A:36624 T:30115 P:24553'
G[24798]='FH L25 RB CD CT CS A:36642 T:33817 P:24596'
G[24799]='FH L25 RO RU RT RL RG RA RR RM RZ SB CD CT CS A:36642 T:33817 P:24598'
G[24800]='FH L25 RB XD XT XS A:36642 T:30116 P:24594'
G[24801]='FH L25 RO RU RT RL RG RA RR RM RZ SB XD XT XS A:36642 T:30116 P:24564'
G[24802]='L25 A:37779 T:37554'
G[24803]='HK K1 L1 A:38294 T:38294 P:PF001 I:24806 E12213 Z16139'
G[24804]='HA FA L7864576 A:38293 T:38066'
G[24805]='HA FH L7864576 A:38295 T:37172'
G[24806]='HK K1 L1 A:38294 T:38294 P:PF001 I:24803 E12213 Z16139'
G[24807]='FH L10 A:537570,37570 T:37717 P:24601'
G[24808]='L0 E21655'
G[24809]='L0 E21655'
G[24810]='L0 T:92031 E21655'
G[24811]='L0 E21655'
G[24812]='L1 A:38442 T:38442 P:25035'
G[24813]='L1 A:38442 T:38442 P:25035'
G[24814]='L1 A:38442 T:38966 P:24812+24813'
G[24815]='L30 A:38316 T:38316'
G[24816]='FH L1 RG A:38120 T:38124 P:24744'
G[24817]='FH L1 RG A:38124 T:38120 P:24816'
G[24819]='K1 L30 A:39509 T:39509'
G[24820]='K1 L30 A:39509 T:39509'
G[24821]='K1 L30 A:39509 T:39509'
G[24822]='K1 L30 A:39509 T:39509'
G[24823]='L30 A:38316 T:38316'
G[24824]='L10 A:37834 T:37834'
G[24825]='L30 A:38316 T:38316'
G[24826]='L30 A:38316 T:38316'
G[24827]='L30 A:38316 T:38316'
G[24828]='L30 A:38316 T:38316'
G[24829]='L30 A:38316 T:38316'
G[24830]='L30 A:38316 T:38316'
G[24831]='L30 A:38316 T:38316'
G[24832]='L30 A:38316 T:38316'
G[24833]='L30 A:38316 T:38316'
G[24834]='L30 A:38316 T:38316'
G[24835]='L30 A:38316 T:38316'
G[24836]='K1 L30 A:39509 T:39509'
G[24837]='K1 L30 A:39509 T:39509'
G[24838]='K1 L30 A:39509 T:39509'
G[24839]='K1 L30 A:39509 T:39509'
G[24840]='K1 L30 A:39509 T:39509'
G[24841]='K1 L30 A:39509 T:39509'
G[24842]='K1 L30 A:39509 T:39509'
G[24843]='K1 L30 A:39509 T:39509'
G[24844]='K1 L30 A:39509 T:39509'
G[24845]='K1 L30 A:39509 T:39509'
G[24846]='K1 L30 A:39509 T:39509'
G[24847]='K1 L30 A:39509 T:39509'
G[24848]='HA FA L7864576 A:38066 T:38325 P:24656'
G[24849]='HA L7864576 A:38325 T:38325 P:24848'
G[24850]='HA FH L7864576 A:37172 T:38328 P:24541'
G[24851]='HA FH L7864576 A:38328 T:38328 P:24850'
G[24852]='L1 A:2980 T:2980 P:14452'
G[24854]='L15 A:38269 T:38274'
G[24855]='L15 A:38263 T:38263 P:24687'
G[24856]='FH L1 RG A:38120 T:38432 P:24817'
G[24857]='L1 E21655'
G[24858]='FH L1 RG A:38432 T:38432 P:24856'
G[24859]='FH L1 RG A:38381 T:38381 P:24856'
G[24861]='L1 A:2981 T:2981 P:14460'
G[24862]='FA L10 A:38378 T:38380 O:28550'
G[24863]='FA L10 A:38378 T:38380'
G[24864]='FH L1 RG A:38432 T:38432 P:24858+24859'
G[24865]='L15 A:1161526 T:9270'
G[24866]='L15 A:1161521 T:509271'
G[24868]='FH L1 RG A:38432 T:38432 P:24864'
G[24869]='L80 E32305'
G[24873]='L1 E32305'
G[24874]='L1 E32305'
G[24880]='L1 E32305'
G[24881]='L1 E21655'
G[24882]='L1 E21655'
G[24883]='L1 E21655'
G[24884]='L1 E21655'
G[24885]='L1 E21655'
G[24886]='L1 E21655'
G[24887]='L10 E21655'
G[24888]='L15 E21655'
G[24889]='L1 E21655'
G[24890]='L1 E21655'
G[24891]='L1 E21655'
G[24892]='L1 E21655'
G[24893]='L1 E21655'
G[24894]='L1 E21655'
G[24895]='L10 E21655'
G[24896]='L15 E21655'
G[24897]='FH L1 RG A:38432 T:38387 P:24868 OAC:26902'
G[24898]='L15 E21655'
G[24899]='L15 E21655'
G[24900]='L15 E21655'
G[24901]='FH L1 RG A:38387 T:38387 P:24897'
G[24902]='FA L1 RW A:38611 T:38611 P:24904'
G[24903]='FA L1 RW A:38611 T:38539 P:24902'
G[24904]='FA L1 RW A:37783 T:38611 P:24676'
G[24905]='FH L15 A:38706 T:38849 P:24953'
G[24906]='FH L15 A:38534 T:38534 O:27447'
G[24907]='FH L15 A:38534 T:38534'
G[24910]='FH L15 A:38534 T:38534 P:24906+24907'
G[24911]='L15 AA:38578 AH:44374 T:9270 I:28525,28526'
G[24912]='L30 A:37120 T:37120'
G[24913]='FA L15 A:17127 T:17127 P:27902'	-- removed +27904
G[24914]='L30 A:100051315 T:37120'
G[24915]='L30 A:37120 T:37120'
G[24916]='L30 A:38606 T:38606'
G[24917]='L30 A:38607 T:38607'
G[24918]='L30 A:38609 T:38609'
G[24919]='L30 A:38608 T:38608'
G[24920]='FA L1 RW A:38539 T:38539 P:24903'
G[24921]='L10 A:38623 T:38619 O:28551 I:25197'
G[24922]='L10 E21655'
G[24923]='L10 E21655'
G[24924]='FH L1 RG A:38387 T:38647 P:24901'
G[24925]='FH L1 RG A:38647 T:38647 P:24924'
G[24926]='L15 A:9623 T:9618 P:24715'
G[24927]='FH L15 A:38703 T:38703 P:24910'
G[24928]='FH L15 A:38703 T:38703 P:24910'
G[24929]='FH L1 RG A:38647 T:38647 P:24924'
G[24930]='FA L1 RW A:35115 T:35115 P:14285,14286,14287,14288,14289,14290,14291'
G[24931]='L15 A:11811 T:11811 P:25072'
G[24932]='L15 A:38706 T:38706 P:26889,25103'
G[24933]='L15 A:38706 T:38706 P:24932'
G[24934]='FA L10 A:38619 T:38622 O:24921,25197'
G[24937]='FH L1 RG A:38647 T:38387 P:24925+24929'
G[24938]='FA L10 A:38619 T:3454 P:24934'
G[24939]='FA L10 A:3454 T:3454 P:24938'
G[24940]='FH L1 RG A:38387 T:38738 P:24937'
G[24941]='FA L10 A:38620 T:1202335'
G[24942]='FH L1 RG A:38738 T:38738 P:24940'
G[24943]='FA L10 A:38620 T:38620 P:24941'
G[24944]='FA L10 A:38804 T:38804 P:24941'
G[24945]='FH L1 RG A:536471 T:536471 P:24940'
G[24946]='FH L1 RG A:538124 T:538124 P:24940'
G[24947]='L15 A:38534 T:38703 P:24910+24907'
G[24948]='FA L10 A:38620 T:38620 P:24943'
G[24949]='FH L15 A:38703 T:38703 P:24910'
G[24950]='FH L15 A:38703 T:38703 P:24928+25534+25541'
G[24951]='L15 A:38706 T:38706 P:24933'
G[24952]='FH L1 RG A:38738 T:538120 P:24942+24945+24946'
G[24953]='L15 A:38706 T:38706 P:24951'
G[24954]='FH L1 RG A:538120 T:538120 P:24952'
G[24955]='FH L15 A:38849 T:38849 O:24905'
G[24956]='FA L10 A:38804 T:38804 P:24944'
G[24957]='FH L15 A:38849 T:38849 P:24955'
G[24958]='FH L1 RG A:538120 T:38928 P:24954'
G[24959]='FH L1 RU A:49044 T:1568'
G[24960]='FH L1 RU A:2307 T:2307 P:28608 O:28652'
G[24961]='FH L1 A:1661 T:1661 P:26801 O:28651,31148'
G[24962]='FH L5 RU CH A:1569 T:38911 P:26801 Z18505'
G[24963]='FH L15 A:38849 T:38849 P:24957'
G[24964]='FH L5 RU CH A:38911 T:38911 P:24962 Z18505'
G[24965]='FH L5 RU CM A:2124 T:2124 P:3098 Z18505'
G[24966]='FH L5 RU CT A:2123 T:2123 P:3097 Z18505'
G[24967]='FH L5 RU CR A:2122 T:2122 P:3096 Z18505'
G[24968]='L5 RU CL A:2126 T:2126 P:3099 Z18505'
G[24969]='L5 RU CW A:2119 T:2119 P:3095 Z18505'
G[24970]='FH L1 A:1570 T:49425 P:24973'
G[24971]='FH L1 A:49425 T:1569 P:24970'
G[24972]='FH L1 A:1569 T:1519 P:24971'
G[24973]='FH L1 A:1570 T:1570 P:26802'
G[24974]='FH L1 A:38925 T:38925'
G[24975]='FH L1 A:1518 T:1518'
G[24976]='FH L1 A:1518 T:1518 P:24975'
G[24977]='FH L1 A:1518 T:1931 P:24976'
G[24978]='FH L1 A:1519 T:1519'
G[24979]='FH L1 A:100052079 T:1519'
G[24980]='FH L1 A:1519 T:1519 P:24978'
G[24981]='FH L1 A:1515 T:1515'
G[24982]='FH L1 A:1496 T:1499'
G[24983]='FH L1 A:1499 T:1495 O:24982'
G[24988]='FH L1 A:1521 T:1521 P:24983'
G[24989]='FH L1 A:1495 T:1499 P:24988'
G[24990]='FH L1 A:10665 T:10665 P:24977'
G[24991]='FH L1 A:10665 T:38977 P:24996'
G[24992]='FH L1 AK:1547,1548 T:1515 P:C24990 I:25039 OAC:25040'	-- this autoaccepts after the kill...I cannot remember if that is the case with all AK: codes *** there is a P: needed, but not sure what it is
G[24993]='FH L1 A:1515 T:1515 P:24992,25039'
G[24994]='FH L1 A:38977 T:38977 O:24991'
G[24995]='FH L1 A:38977 T:38977 P:24994'
G[24996]='FH L1 A:10665 T:2211 P:24990'
G[24997]='FH L1 A:38978 T:38978'
G[24998]='FH L1 A:38978 T:38978 P:24997'
G[24999]='FH L1 A:38978 T:38978 P:24994'
G[25000]='FA L10 A:38621 T:38873'
G[25001]='FH L15 A:38849 T:38849 P:24963'
G[25002]='FA L10 A:38878 T:38871'
G[25003]='FH L1 A:1500 T:1500 O:25031'
G[25004]='FH L1 A:1500 T:1500 P:25003'
G[25005]='FH L1 A:1500 T:1499 P:25004+25029'
G[25006]='FH L1 A:1499 T:1499 P:25005'
G[25007]='FH L1 A:1499 T:10837 P:25006'
G[25008]='FA L10 A:38873 T:38873'
G[25009]='FH L1 A:10837 T:10837 P:25007'
G[25010]='FH L1 A:10837 T:13158 P:25009'
G[25011]='FH L1 A:10837 T:37915 P:25046'
G[25012]='FH L1 A:37915 T:1515 P:25011'
G[25013]='FH L1 A:11057 T:11057 P:25056'
G[25014]='FH L15 A:1202407 T:38849 P:E25001'	--	TODO:	Assuming available once you kill Sandscaper (while on that quest)
G[25015]='FA L10 A:38871 T:38871'
G[25016]='L0 E21655'
G[25017]='FH L15 A:38922 T:38922 P:25019+25020'
G[25018]='L15 A:38849 T:38922 P:25014'
G[25019]='FH L15 A:38922 T:38922'
G[25020]='FH L15 A:38922 T:38922'
G[25021]='L15 A:38927 T:38927'
G[25022]='FA L10 A:38871 T:38871'
G[25023]='FH L1 RG A:38928 T:38935 P:24958'
G[25024]='FH L1 RG A:38935 T:38935 P:25023 OAC:28846'
G[25025]='L15 A:38927 T:38927 P:25021'
G[25026]='L15 A:38927 T:38927 P:25025'
G[25027]='FA L10 A:38871 T:38871 P:25015+25022'
G[25028]='FA L10 A:38876 T:37570 P:25015+25022'
G[25029]='FH L1 A:1500 T:1500 P:25003'
G[25030]='FH L1 A:100003082 T:1500'
G[25031]='FH L1 A:38977 T:1500 P:24995+24998+24999'
G[25032]='L15 A:38927 T:7804 P:25026'
G[25034]='L10 A:38871 T:38986 P:25027'
G[25035]='L1 A:38440 T:38442 P:24626'
G[25036]='L10 A:38620 T:38871 P:24948+24956'
G[25037]='L1 A:39007 T:39007 P:24643,24755,24763,24769,24775,24781,24787,26277,31163'
G[25038]='FH L1 A:10666 T:10665 P:24976'
G[25039]='FH L1 A:6785 T:1515 P:25040 I:24992'
G[25040]='L0 T:1548 J:O24992'
G[25041]='FA L10 A:39003 T:39003'
G[25042]='FA L10 A:39003 T:39003 P:25041'
G[25043]='FA L10 A:38323 T:38323'
G[25044]='FA L10 A:38986 T:38986 P:25022'
G[25045]='FA L10 A:38323 T:38323'
G[25046]='FH L1 A:13158 T:10837 P:25010'
G[25047]='L1 A:100052197 P:PJ475'
G[25048]='FA L15 A:38535 T:38535 O:27446,28507'
G[25049]='FA L15 A:38535 T:38535'
G[25050]='FA L15 A:38535 T:38535 P:25048+25049'
G[25051]='FH L15 A:4926 T:4926'
G[25052]='FA L15 A:38704 T:38704 P:25121'
G[25053]='FA L15 A:38704 T:38704 P:25050'
G[25054]='FA L15 A:38704 T:38704 P:25050'
G[25055]='L5 E21655'
G[25056]='FH L1 A:11057 T:11057'
G[25057]='FA L10 A:38323 T:38323 P:25043+25045'
G[25058]='FH L1 RG A:538387 T:538387 P:28846'
G[25059]='FA L10 A:38986 T:38986 P:25043+25045'
G[25060]='FA L15 A:39059 T:39059 P:25166 O:25061'
G[25061]='FA L15 A:11811 T:39059 P:24953'
G[25062]='FA L15 A:39059 T:39059 P:25166'
G[25063]='FA L15 A:39059 T:39059 P:25060+25062'
G[25064]='L1 A:38966 T:38005 P:24643,24755,24763,24769,24775,24781,24787,26277,31163'
G[25065]='FA L15 A:39059 T:39059 P:25063'
G[25066]='FH L1 RG A:538387 T:538387 P:25024+25058+25093'
G[25067]='K512 L15 A:39034 T:19860 O:26895,26896'	-- PM3
G[25068]='L15 A:38922 T:38922 P:25017'
G[25069]='FH L15 A:38922 T:1202474 P:25017'
G[25070]='L15 A:1202474 T:1202474 P:25069,25566'
G[25071]='L0 E21655'
G[25072]='L15 A:38706 T:38706 P:26889,25103'
G[25073]='L1 A:38966 T:3188 P:24814'
G[25074]='L10 A:38323 T:39083 P:25057'
G[25075]='FA L10 A:39084 T:39084'
G[25079]='FA L10 A:39084 T:39084 P:25075'
G[25080]='FA L10 A:39084 T:39084 P:25079'
G[25081]='FA L10 A:39083 T:39083'
G[25082]='FA L10 A:39085 T:39085'
G[25084]='FA L10 A:37835 T:37835'
G[25085]='FA L10 A:37835 T:37835 P:25084'
G[25086]='L10 A:39085 T:37835 P:25082'
G[25087]='FA L10 A:39083 T:39118 P:25081'
G[25089]='FH L1 RU A:2307 T:1740 P:24960'
G[25090]='FH L1 A:1496 T:1496'
G[25091]='L15 A:39178 T:7804 P:25115'
G[25092]='L5 E21655'
G[25093]='FH L1 RG A:39065 T:39065 P:28846'
G[25094]='K512 L15 A:39034 T:19860 P:25067'	-- PM3
G[25095]='K512 L15 A:39034 T:19860 P:25094'	-- PM3
G[25097]='L10 E21655'
G[25098]='FH L1 RG A:538387 T:38935 P:25066'
G[25099]='FH L1 RG A:38935 T:39066 P:25098'
G[25100]='FH L1 RG A:39066 T:38517 P:25099'
G[25101]='L10 E21655'
G[25102]='L10 A:39154 T:39154'
G[25103]='FH L15 A:38703 T:38706 P:24950'
G[25104]='FA L10 A:39118 T:39155'
G[25105]='K2 L1 A:50480 T:50480 P:PJ475 I:25154,25155,25156,25157'
G[25106]='FA L10 A:39155 T:39155 P:25104'
G[25107]='FH L15 A:1202474 T:38922 P:25070'
G[25108]='FA L10 A:39155 T:39155 P:25104'
G[25109]='FH L1 RG A:38517 T:500034 P:25100'
G[25110]='FH L1 RG A:500034 T:500034 P:25109'
G[25111]='L15 A:39178 T:39178 P:25112'
G[25112]='L15 A:39178 T:39178'
G[25115]='L15 A:39178 T:39178 P:25111'
G[25117]='L10 E21655'
G[25118]='FA L5 A:1777 T:1777'
G[25120]='FA L10 A:39155 T:39188 P:25106+25108'
G[25121]='L15 A:38535 T:38704 P:25050'
G[25122]='FH L1 RG A:39199 T:39199 P:25110'
G[25123]='FH L1 RG A:39199 T:39199 P:25110'
G[25125]='FH L1 RG A:39199 T:39341 P:25122+25123'
G[25126]='L1 A:3143 T:3143 P:25152'
G[25127]='L1 A:3143 T:3143 P:25172'
G[25128]='FH L1 A:5887 T:3287 P:25127'
G[25129]='L1 A:3287 T:3287 O:25128'
G[25130]='L1 A:3287 T:3143 P:25129'
G[25131]='L1 A:3145 T:3145 P:25127'
G[25132]='L1 A:3145 T:3145 P:25131+37446'
G[25133]='L1 A:3145 T:3188 P:25132'
G[25134]='L1 A:11378 T:11378 P:25172 Z19033'
G[25135]='L1 A:11378 T:11378 P:25131+37446'
G[25136]='L1 A:9796 T:9796 P:25126'
G[25138]='FH L5 RO CM A:3143 T:39206 Z18505'
G[25139]='FH L5 RO CH A:39214 T:39214 P:3087 Z18505'
G[25141]='FH L5 RO CR A:3155 T:3155 P:3088 Z18505'
G[25143]='FH L515 RO CS A:3157 T:3157 P:3089 Z18505'
G[25145]='FH L5 RO CL A:3156 T:3156 P:3090 Z18505'
G[25147]='FH L515 RO CW A:3153 T:3153 P:2383 Z18505'
G[25149]='L5 RO CM A:39206 T:39206 P:25138 Z18505'
G[25151]='FA L10 A:39188 T:39188 P:25120'
G[25152]='L1 A:10176 T:3143'
G[25153]='FA L10 A:39218 T:39218 P:25120'
G[25154]='fA K2 L1 A:50480 T:50480 P:PJ475 I:25105,25155,25156,25157'
G[25155]='K2 L1 A:50480 T:50480 P:PJ475 I:25105,25154,25156,25157'
G[25156]='fA K2 L1 A:50480 T:50480 P:PJ475 I:25105,25154,25155,25157'
G[25157]='K2 L1 A:50480 T:50480 P:PJ475 I:25105,25154,25155,25156'
G[25158]='K2 L1 A:50482 T:50482 P:PJ475 I:25159,25160,25161,25162'
G[25159]='K2 L1 A:50482 T:50482 P:PJ475 I:25158,25160,25161,25162'
G[25160]='K2 L1 A:50482 T:50482 P:PJ475 I:25158,25159,25161,25162'
G[25161]='K2 L1 A:50482 T:50482 P:PJ475 I:25158,25159,25160,25162'
G[25162]='K2 L1 A:50482 T:50482 P:PJ475 I:25158,25159,25160,25161'
G[25163]='FA L10 A:39220 T:38152 P:25120'
G[25164]='L30 A:39226 T:39226 P:25334'
G[25165]='FH L1 A:10578 T:10578 P:25170'
G[25166]='FA L15 A:38704 T:38704 P:25053+26886+26887'
G[25167]='FH L1 A:3188 T:3188 O:25073,25133'
G[25168]='FH L1 A:3188 T:3188 P:25167'
G[25169]='FH L1 A:3140 T:3140 P:25167'
G[25170]='FH L1 A:10578 T:10578'
G[25171]='FH L1 A:3188 T:3139 P:25168+25169'
G[25172]='L1 A:3143 T:3143 P:25126'
G[25173]='FH L1 A:3139 T:3139 P:25171'
G[25174]='FA L10 A:38152 T:39118 P:25163'
G[25175]='FA L10 A:39188 T:39118 P:25151'
G[25176]='FH L1 A:39423 T:39423 P:25171'
G[25177]='FH L1 A:3139 T:3139 P:25173'
G[25178]='FH L1 A:39423 T:39423 P:25173+25176'
G[25179]='FH L1 A:39270 T:3139 P:25173'
G[25180]='FA L30 E31961'
G[25181]='FH L30 E31961'
G[25182]='FA L10 A:39118 T:39118 P:25174'
G[25183]='FA L10 A:39118 T:1202598 P:25174'
G[25184]='FH L1 RG A:39341 T:500035 P:25125'
G[25185]='FA L10 A:1202598 T:39118 P:25183'
G[25186]='FA L10 A:38380 T:38379 P:24862+24863'
G[25187]='FH L1 A:39323 T:39323 O:25227'
G[25188]='FH L1 A:39323 T:39323 P:25187'
G[25189]='FH K32 L1032 A:39325 T:39326 P:B25188 Z20886'
G[25190]='FH L1 A:39326 T:39326 P:B25188'
G[25191]='L10 A:38383 T:39322'
G[25192]='FH L1 A:39326 T:39326 P:25190'
G[25193]='FH L1 A:3193 T:3193 P:B25188'
G[25194]='FH L1 A:39324 T:39324 P:B25188'
G[25195]='FH L1 A:39324 T:39324 P:25194'
G[25196]='FH L1 A:3142 T:39379 P:25232'
G[25197]='L10 A:39322 T:38619 P:25191 I:24921'
G[25199]='FA L30 E31961'
G[25200]='FH L1 RG A:500035 T:500035 P:25184'
G[25201]='FH L1 RG A:538738 T:538738 P:25184'
G[25202]='FH L1 RG GF A:538647 T:538647 P:25200+25201 ODC:25226'
G[25203]='FH L1 RG GM A:38441 T:38441 P:25200+25201'
G[25204]='FH L1 RG A:500035 T:1202613 P:25200+25201'
G[25205]='FH L1 A:39380 T:39380'
G[25206]='FH L1 A:39379 T:39379 P:25205'
G[25207]='FH L1 RG A:1202613 T:500035 P:25204'
G[25208]='FA L15 A:40052 T:39653 P:25403'
G[25209]='FH L15 A:39656 T:39656 O:25386'
G[25210]='FH L15 A:39377 T:39377 O:26589'
G[25211]='L10 A:41074 T:41074'
G[25212]='FA L30 E31961'
G[25213]='FH L1 RG A:500035 T:500036 P:25207+25226'
G[25214]='FH L1 RG A:500037 T:500037 P:25213'
G[25215]='L30 A:39876 T:39876 P:25222'
G[25216]='L30 A:39876 T:39882 P:25222'
G[25217]='L30 A:39882 T:39882 P:25218'
G[25218]='L30 A:39882 T:39882 P:25216'
G[25219]='L30 A:39875 T:39875 TH:49920 P:25222'
G[25220]='L30 A:39878 T:39878 P:25222'
G[25221]='L30 A:39877 T:539877 P:25164'
G[25222]='L30 A:539877 T:39876 P:25221'
G[25223]='L30 A:39442 T:39442 P:25276'
G[25224]='L30 A:39442 T:39442 P:25276'
G[25226]='FH L0 RG T:538647 J:25202'
G[25227]='FH L1 A:39423 T:39323 P:25178'
G[25228]='L5 E21655'
G[25229]='L30 E31961'
G[25230]='FH L15 A:39377 T:39377 P:25210'
G[25232]='FH L1 A:3142 T:3142'
G[25233]='L30 A:39427 T:39427 P:25584'
G[25234]='L30 A:39427 T:39427 P:25584'
G[25235]='FA L10 A:888 T:888'
G[25236]='FH L1 A:39379 T:39379 P:i312042'
G[25237]='FH L15 A:39377 T:39377 P:25230'
G[25238]='L0 E21655'
G[25239]='L30 A:38316 T:38316'
G[25240]='L30 A:38316 T:38316'
G[25241]='FH L15 A:39377 T:39377 P:25230'
G[25242]='L30 A:38316 T:38316'
G[25243]='FH L1 RG GM A:500036 T:500036 P:25213 ODC:25244,25245'
G[25244]='FH L1 RG GF A:500036 T:500036 P:25213 ODC:25243,25245'
G[25245]='L0 T:500036 J:A25243,A25244'
G[25246]='K1 L30 A:39509 T:39509'
G[25247]='K1 L30 A:39509 T:39509'
G[25248]='K1 L30 A:39509 T:39509'
G[25249]='K1 L30 A:39509 T:39509'
G[25250]='FH L15 A:39377 T:39377 P:25237,25241'
G[25251]='FH L1 RG A:500036 T:500036 P:25214+25245'
G[25252]='FH L15 A:39656 T:39656 P:25209'
G[25253]='FA L5 E31961'
G[25255]='L30 A:39429 T:39429 P:25584'
G[25256]='FH L1 A:39604 T:39590'
G[25257]='FH L1 A:39590 T:39590 P:25256'
G[25258]='FH L1 A:39590 T:39590 P:25256'
G[25259]='FH L1 A:39590 T:39590 P:25256'
G[25260]='FH L1 A:39379 T:39379 P:25196'
G[25261]='FH L1 A:39379 T:3208 P:25260'
G[25262]='FH L1 A:3208 T:3208 P:25261'
G[25263]='FH L1 A:3208 T:3216 P:25262'
G[25264]='L5 A:3216 T:3521 P:25263'
G[25265]='FH L1 RG A:500036 T:538935 P:25251'
G[25266]='FH L1 RG A:538935 T:39609 P:25265'
G[25267]='FH L1 RG A:39609 T:39605 O:25266'
G[25268]='FA L30 A:39427 T:39433 P:25233'
G[25269]='FH L30 A:39429 T:39432 P:25255'
G[25270]='FH L30 A:39432 T:39432 P:25269'
G[25271]='FA L30 A:39433 T:39433 P:25268'
G[25272]='FH L30 A:39432 T:39622 P:25270'
G[25273]='FA L30 A:39433 T:39627 P:25271'
G[25274]='L30 A:39621 T:39621 P:25597'
G[25275]='FH L5 RG A:39605 T:35086 P:25267 I:28496'
G[25276]='L30 A:39621 T:39442 P:25274'
G[25277]='FH L30 A:39432 T:39432 O:25279'
G[25278]='FA L30 A:39433 T:539433 O:25280'
G[25279]='FH L30 A:39622 T:39432'
G[25280]='FA L30 A:539627 T:539433 P:25273'
G[25281]='FA L30 A:36915 T:36915 P:24432'
G[25283]='FA L30 E31961'
G[25284]='FH L10 A:37153 T:37153'
G[25285]='L30 E31961'
G[25286]='FA L30 E31961'
G[25287]='FA L30 E31961'
G[25289]='L30 E31961'
G[25291]='L30 A:39442 T:39413 P:25223+25224+25330'	-- guessed at, done in order: 25224,25223,25330.  appeared after last
G[25292]='L15 A:39697 T:39144 P:24747'
G[25294]='L30 A:39406 T:39406 P:25291'
G[25295]='L30 E31961'
G[25296]='L30 A:1202701 T:1202701 P:25291'
G[25297]='L30 A:39434 T:1202706 P:25273'
G[25298]='L30 A:1202706 T:39434 P:25297'
G[25299]='L30 A:39413 T:39413 P:25499'
G[25300]='L30 A:39435 T:1202697 P:25273'
G[25301]='L30 A:1202697 T:1202712 P:25300'
G[25303]='L30 A:1202712 T:1202712 P:25301'
G[25304]='fA L15 A:3936 T:39723 O:26402'
G[25305]='L15 E21655'
G[25306]='L30 E21655'
G[25307]='L1 E21655'
G[25308]='L30 A:1202701 T:1202701 P:25296'
G[25309]='L30 A:39413 T:39413 P:25299'
G[25310]='L30 A:39413 T:39413 P:25309+25496'
G[25311]='L30 A:39413 T:39413 P:25309+25496'
G[25312]='L30 A:1202712 T:39435 P:25303'
G[25314]='L30 A:1202701 T:1202701 P:25308+25310+25311'
G[25315]='L30 A:39413 T:40619 P:25601'
G[25316]='L30 A:39865 T:40289 P:27721,27726'
G[25317]='L30 A:40289 T:39857 TH:45312 O:25316'
G[25318]='L1 E21655'
G[25319]='L30 A:39857 T:39857 P:25317'
G[25320]='L30 A:38917 T:40096 P:25430'
G[25321]='L30 A:40096 T:40096 P:25320'
G[25322]='L1 E21655'
G[25323]='L30 A:39857 T:39857 P:25472'
G[25324]='L30 A:38917 T:40139 P:25424'
G[25325]='L30 A:40139 T:40178 P:25324'
G[25326]='L1 E21655'
G[25327]='L1 E21655'
G[25328]='L30 A:39640 T:39640'
G[25329]='FH L15 A:39656 T:39656 P:25344'
G[25330]='L30 A:39451 T:39451 P:25276'
G[25331]='FA L1 RW T:36458'
G[25332]='K32 L30 A:39640 T:39435 P:25328'
G[25333]='FA L15 A:39653 T:39653 P:25208+25406'
G[25334]='L30 A:39226 T:40398 P:25471'
G[25335]='L15 E21655'
G[25336]='FH L15 A:39894 T:39894'
G[25337]='FH L15 A:39894 T:39894 P:25336'
G[25338]='FH L15 A:8115 T:8115 P:25641'
G[25339]='FH L15 A:7776 T:7776'
G[25340]='FH L15 A:7776 T:7776'
G[25341]='FH L15 A:39656 T:39656'
G[25342]='FH L15 A:39656 T:39840 P:25341'
G[25344]='FH L15 A:39840 T:39840 P:25342'
G[25345]='FH L15 A:8115 T:8115 P:25338'
G[25346]='FH L15 A:8115 T:8115 P:25345'
G[25349]='FH L15 A:39847 T:39847'
G[25350]='FA L15 A:40132 T:40129'
G[25352]='FA L30 A:539433 T:539433 P:25278'
G[25353]='FA L30 A:539433 T:500015 P:25278'
G[25354]='L30 A:39432 T:39432'
G[25355]='FH L30 A:39432 T:39622'	-- needs P:
G[25356]='FH L15 A:39893 T:39895 O:28504 I:25478'
G[25357]='FA L30 A:39887 T:39887 P:25405'
G[25358]='L30 A:40983 T:40983 P:25602'
G[25359]='L30 A:39876 T:40221 P:25456'
G[25360]='L30 A:40227 T:40227'
G[25361]='FH L15 A:4544 T:4544 P:25338'
G[25362]='FH L15 A:4544 T:4544 P:25361'
G[25363]='FH L15 A:7875 T:7875'
G[25364]='FH L15 A:7875 T:7875 P:25363'
G[25365]='FH L15 A:7875 T:1142195 P:25363'
G[25366]='FH L15 A:1142195 T:7875 P:25365'
G[25367]='FH L15 A:7875 T:7875 P:25364+25365'
G[25368]='L15 A:40131 T:40131 P:25422+25423'
G[25369]='FH L15 A:7875 T:7875 P:25364+25365'
G[25370]='L30 A:40278 T:40278'
G[25371]='L30 A:41248 T:41248 P:25477'
G[25372]='L30 A:41381 T:539858 P:25842'
G[25373]='FH L15 A:39847 T:39847'
G[25374]='FH L15 A:39847 T:39847 P:25373'
G[25375]='FH L15 A:39847 T:39847 P:25373'
G[25376]='L10 E21655'
G[25377]='L30 A:100053053 T:1202759'
G[25378]='FH L15 A:39847 T:39407 P:25349'
G[25379]='L15 A:39407 T:39407 P:25378,25437'
G[25381]='L30 A:39927 T:39927 P:25584 O:25630'
G[25382]='L30 A:39927 T:39927 P:25584'
G[25383]='FH L15 A:39407 T:39847 P:25379'
G[25384]='L30 E31961'
G[25385]='L30 A:39930 T:39930 P:25584'
G[25386]='L15 A:39377 T:39656 P:25250'
G[25387]='L15 A:39656 T:39847 P:25329'
G[25388]='L30 A:1202871 T:39883 P:25587'
G[25389]='L30 A:39883 T:39883 P:25388+25598'
G[25390]='L30 A:39883 T:39883 P:25388+25598'
G[25391]='FH L15 A:8115 T:8115 P:25346'
G[25392]='L30 A:39930 T:39930 P:25385'
G[25393]='L30 E31961'
G[25394]='FA L15 A:40032 T:40032 P:25447'
G[25395]='L10 A:41075 T:41075 O:26137,28565'
G[25396]='FA L15 A:40032 T:40032 P:25394'
G[25397]='FA L15 A:40032 T:40032 P:25394'
G[25398]='FA L15 A:40032 T:40032 P:25396+25397'
G[25399]='FA L15 A:39723 T:3936'
G[25400]='FA L15 A:39653 T:39653'
G[25401]='FA L15 A:39653 T:39653'
G[25402]='FA L15 A:39653 T:40052 P:25401'
G[25403]='FA L15 A:40052 T:40052 P:25402'
G[25404]='L30 A:39928 T:39933 P:25584'
G[25405]='FA L30 A:36915 T:39887 P:25281'
G[25406]='FA L15 A:39653 T:39653 P:25400'
G[25407]='FA L15 A:40078 T:40078'
G[25408]='L30 A:39933 T:39933 P:25404'
G[25409]='FA L15 A:40078 T:40078 P:25407'
G[25410]='FA L15 A:40078 T:40078 P:25409'
G[25411]='L30 A:39933 T:40093 P:25408'
G[25412]='L30 A:40093 T:39933 P:25411'
G[25413]='L30 E31961'
G[25419]='SP L30 A:100055186 T:0 P:25459'	-- added the prerequisite based on the wowhead comment
G[25420]='FA L15 A:40109 T:40109 O:28881'
G[25421]='FA L15 A:1202474 T:40109'
G[25422]='L15 A:40131 T:40131 P:25350,25643'
G[25423]='L15 A:40131 T:40131 P:25350,25643'
G[25424]='L30 A:40096 T:38917 P:25321'
G[25426]='FA L15 A:39725 T:39725'
G[25427]='FA L15 A:39725 T:39725 P:25426'
G[25428]='L30 A:39933 T:39933 P:25412'
G[25429]='FA L15 A:39725 T:39725 P:25427'
G[25430]='L30 A:39869 T:38917 P:25464'
G[25431]='L15 A:39725 T:39725 P:25427'
G[25432]='FA L15 A:39725 T:39725'
G[25433]='FA L15 A:39725 T:39725 P:25432'
G[25434]='FA L15 A:39725 T:39725 P:25432'
G[25435]='L30 E31961'
G[25436]='FA L15 A:39725 T:39725 P:25429'
G[25437]='FA L15 A:39725 T:39407 P:25436'
G[25438]='FA L15 A:39407 T:39725 P:25379'
G[25439]='L30 A:40221 T:40221 P:25359'
G[25440]='L30 A:40221 T:40221 P:25439'
G[25441]='L30 A:40221 T:40221'
G[25442]='L30 A:100054614 T:39875'
G[25444]='FH L30 E21655'
G[25445]='L30'
G[25446]='FH L1 E31961'
G[25447]='FA L15 A:40032 T:40032 O:14410,28511'
G[25448]='L15 A:40035 T:40035'
G[25449]='L15 A:40226 T:40226'
G[25450]='L15 A:40226 T:40226 P:25449'
G[25451]='FA L15 A:100055166 T:40226 P:25449'	-- TODO: Determine if this is in fact repeatable
G[25452]='L15 A:7854 T:7854'
G[25453]='L15 A:7854 T:7854 P:25452'
G[25454]='FH L15 A:100055167 T:7854 P:25452'
G[25456]='L30 A:39882 T:39876 P:25217'
G[25457]='L1 E21655'
G[25458]='FA L15 A:39723 T:3936'
G[25459]='L30 A:39883 T:39883 P:25602'
G[25460]='L30 A:39925 T:39925'
G[25461]='FH L1 E31961'
G[25462]='L30 A:39932 T:39932 P:25428+25382+25392 O:25940'
G[25463]='L15 A:3936 T:39653 P:25458'
G[25464]='L30 A:39857 T:39857 TH:45312 P:25323'
G[25465]='L15 A:14637 T:14637'
G[25466]='L15 A:14637 T:14637'
G[25467]='L30 A:100054345 T:1202859'
G[25468]='FA L15 A:40913 T:40913 P:25410'
G[25469]='FA L15 A:40913 T:40913 P:25410'
G[25470]='FH L30 E31961'
G[25471]='L30 A:41341 T:39226 P:27708'
G[25472]='L30 A:39869 T:39857 P:25317'
G[25473]='FH L1 RG A:34872 T:34668 P:14069+14075'
G[25474]='L30 E31961'
G[25475]='L15 A:100008705 T:7807'
G[25476]='L15 A:7807 T:7406 P:25475'
G[25477]='L30 A:41248 T:41248 P:25558,25949'
G[25478]='FH L15 A:40344 T:39895 O:28504 I:25356'
G[25479]='FA L15 A:40345 T:39946 I:25481,28503'
G[25480]='FH L30 E31961'
G[25481]='FA L15 A:40369 T:39946 I:25479,28503'
G[25482]='L1 E21655'
G[25483]='L1 E21655'
G[25484]='L1 E21655'
G[25485]='L1 E21655'
G[25486]='FA L15 A:39946 T:39992 O:25479,25481,28503'
G[25487]='FH L15 A:39895 T:39963 P:25356,25478'
G[25488]='FA L15 A:39992 T:40027 P:25486'
G[25489]='FH L15 A:39963 T:40028 P:25487'
G[25490]='L30 A:39932 T:39858 P:25462'
G[25491]='L30 A:39858 T:39858 P:25490'
G[25492]='L30 A:40331 T:40331 P:25490'
G[25493]='L30 A:39858 T:39858 P:25490'
G[25494]='L30 A:39406 T:39406 P:25294'
G[25495]='FH L30 E31961'
G[25496]='L30 A:39406 T:39406 P:25494'
G[25497]='L30 E31961'
G[25499]='L30 A:39413 T:39413 P:25509'
G[25500]='FA L30 E31961'
G[25501]='L10 E21655'
G[25502]='L30 A:40331 T:40331 P:25492'
G[25503]='L30 A:100054639 T:1202916'
G[25504]='FA L15 A:40027 T:40475 P:25488'
G[25505]='FH L15 A:40028 T:40487 P:25489'
G[25506]='L30 E31961'
G[25507]='L30 A:39858 T:39858 P:25493'
G[25509]='L30 A:39413 T:39413 P:25291'
G[25510]='L30 A:39858 T:40341 P:25507'
G[25513]='FA K512 L15 A:39034 T:19860 P:25095+25065|25018'	-- PM3
G[25514]='L30 A:40341 T:40341 P:25510'
G[25515]='FA L15 A:40475 T:40475 P:25504'
G[25516]='FH L15 A:40487 T:40487 P:25505'
G[25517]='FA L15 A:40554 T:40554 P:25488'
G[25518]='FH L15 A:40556 T:40556 P:25489'
G[25519]='L30 A:40341 T:40341 P:25510'
G[25520]='L30 A:40341 T:39858 P:25514+25519'
G[25521]='L15 A:40580 T:40580'
G[25522]='L15 A:40580 T:40580 P:25521'
G[25523]='L30 A:40578 T:40578 P:25810'
G[25524]='FA L15 A:1202975 T:1202975 P:25504'
G[25525]='L30 A:40578 T:40578 P:25523'
G[25526]='FH L15 A:1202975 T:1202975 P:25505'
G[25531]='L30 A:40619 T:40772 P:25315'
G[25532]='FA L15 A:40475 T:0 P:25515+25517+25524'
G[25533]='FH L15 A:40487 T:0 P:25516+25518+25526'
G[25534]='FH L15 A:38703 T:38703 P:24927'
G[25535]='FA L30 A:39881 T:40641,49408 P:25922'
G[25536]='FA L30 A:40642 T:40642 P:25922'
G[25537]='FA L30 A:40639 T:40639 P:25535'
G[25538]='FA L30 A:40639 T:40639 P:25537'
G[25539]='FA L30 A:40641 T:40641 P:25535'
G[25540]='FA L30 A:40641 T:39881 P:25538'
G[25541]='FH L15 A:38703 T:38703 P:24927+24949'	-- TODO: Verify requires 24927
G[25542]='FA L15 A:-64 T:40475 P:25532 I:25561,M25542'
G[25543]='FH L15 A:-64 T:40487 P:25533 I:25562,M25543'
G[25544]='L30 A:40578 T:40578 P:25525'
G[25545]='FA L30 A:39887 T:39887 P:25357+25546'
G[25546]='FA L30 A:39887 T:39887 P:25405'
G[25547]='FA L30 A:39887 T:40690 P:25545+25564'
G[25548]='L30 A:540772 T:540772 P:25608'
G[25549]='L30 A:540772 T:540772 P:25548'
G[25550]='L30 A:540772 T:540772 P:25549'
G[25551]='L30 A:40773 T:540772 P:25550+25553+25555'
G[25552]='L30 A:40816 T:40816 P:25644'
G[25553]='L30 A:40816 T:40816 P:25552'
G[25554]='L30 A:40773 T:40773 P:25608'
G[25555]='L30 A:40773 T:40773 P:25554'
G[25556]='L15 N30 A:7804 T:40712 P:25032'
G[25558]='FA L30 A:40690 T:40105 P:25547'
G[25559]='FA L15 A:40109 T:40109'
G[25560]='L30 A:40578 T:40578 P:25544'
G[25561]='FA L15 A:40475 T:40475 P:25532+M25542 I:25542'
G[25562]='FH L15 A:40487 T:40487 P:25533+M25543 I:25543'
G[25563]='L1 E32185'
G[25564]='FA L30 A:39887 T:39887 P:25357+25546'
G[25565]='FA L15 A:40109 T:40109'
G[25566]='FA L15 A:40109 T:1202474 P:25420'
G[25571]='L30 E31961'
G[25574]='L30 A:40278 T:40278 P:25370'
G[25575]='L30 A:40834 T:40834'
G[25576]='L30 A:40837 T:40837'
G[25577]='L30 A:40834 T:40834'
G[25578]='L30 A:40178 T:40289 P:25325'
G[25579]='FA L30 A:40643 T:40643 P:25536+25540'
G[25580]='FA L30 A:40642 T:40642 P:25536+25540'
G[25581]='FA L30 A:40644 T:40644 P:25536+25540'
G[25582]='FA L30 A:40643 T:40643 P:25536+25540'
G[25583]='FA L30 A:1202714 T:40643 O:27393'
G[25584]='L30 A:40289 T:39429 P:25578'
G[25585]='FA L15 A:40475 T:40475 P:25542,25561'
G[25586]='FH L15 A:40487 T:40487 P:25543,25562'
G[25587]='L30 A:39667 T:39883 P:25371 O:27685'
G[25588]='FA L15 A:40591 T:40591 P:25542,25561'
G[25589]='FH L15 A:40595 T:40595 P:25543,25562'
G[25590]='FA L15 A:40554 T:40885 P:25542,25561'
G[25591]='FH K512 L15 A:39034 T:19860'	-- PM3
G[25592]='FH L30 A:40917 T:40917'
G[25593]='FH L30 A:40916 T:40916'
G[25594]='FH L30 A:40918 T:40918'
G[25595]='FH L30 A:40919 T:40919'
G[25596]='FH L15 A:40556 T:40888 P:25543,25562'
G[25597]='L30 A:40289 T:39621 P:25653'
G[25598]='L30 A:39883 T:39883 P:25587'
G[25599]='L30 A:40834 T:40834 P:25575+25576+25577'
G[25600]='L30 A:40834 T:40834 P:25599'
G[25601]='L30 A:1202701 T:39413 P:25314'
G[25602]='L30 A:39884 T:39884 P:25598'
G[25607]='FA L10 A:40895 T:40895'
G[25608]='L30 A:40772 T:40772 P:25531'
G[25609]='FA L15 A:40885 T:40885 P:25590'
G[25610]='FH L15 A:40888 T:40888 P:25596'
G[25611]='FA L30 A:40834 T:539433 P:25600'
G[25612]='FH L30 A:40834 T:39432 P:25600'
G[25613]='FA L10 A:40894 T:39256 P:13913+25607+13979'
G[25614]='FA L10 A:39256 T:39256 P:25613'
G[25615]='FA L10 A:39256 T:34354 P:25614'
G[25616]='FA L10 A:34354 T:40973 P:25615'
G[25617]='FH L30 A:39622 T:40834 P:25355 I:25624'
G[25618]='FA L30 A:500015 T:40834 P:25353 I:25623'
G[25619]='L30 A:40978 T:40978 P:B25760'
G[25620]='L30 A:40978 T:40640 P:25619'
G[25621]='FA L10 A:40895 T:40895 P:25615'
G[25622]='FA L10 A:-65,40895 T:40895 P:25621'
G[25623]='FA L30 A:39433 T:40834 I:25618'
G[25624]='FH L30 A:39432 T:40834 I:25617'
G[25626]='FA L30 A:39881 T:39881 P:25911'
G[25627]='FA L15 A:40885 T:40885 P:25609'
G[25628]='FH L15 A:40888 T:40888 P:25610'
G[25629]='L30 A:42077 T:42077 P:B26135,B25626'
G[25630]='L30 A:39434 T:39927 P:25611'
G[25631]='L1 E21655'
G[25632]='L1 E21655'
G[25633]='L1 E21655'
G[25634]='L1 E21655'
G[25635]='L1 E21655'
G[25637]='L30 A:40640 T:41049 P:25620'
G[25638]='L30 A:1203128 T:40105 P:25459'
G[25639]='L1 E21655'
G[25640]='FA L10 A:40895 T:40879 P:25622'
G[25641]='FH L15 A:39894 T:8115 P:25337'
G[25642]='FA L10 A:40879 T:40879 P:25640'
G[25643]='FH L15 A:5390 T:1203134'
G[25644]='L30 A:1207359 T:40816 P:25608'
G[25645]='FH L15 A:1203134 T:5390 P:25368'
G[25646]='FA L10 A:40973 T:40973 P:25640'
G[25647]='FA L10 A:100055181 T:40879 P:25640'
G[25648]='FH L5 A:39379 T:8576 P:25206+25236 I:28496'
G[25649]='FA L10 A:40879 T:40881 P:25647'
G[25650]='FA L10 A:40881 T:40879 P:25649'
G[25651]='L30 A:46338 T:46338 P:25602'
G[25652]='FA L10 A:40879 T:40896 P:25650'
G[25653]='L30 A:41504 T:40289 P:25928'
G[25654]='FA L15 A:40035 T:40035'
G[25655]='L30 A:41006 T:41006 P:25578'
G[25656]='L30 A:41006 T:41006 P:25578'
G[25657]='L30 A:46338 T:0 P:25651'
G[25658]='L30 A:41050 T:41050 P:25620'
G[25659]='L30 A:41049 T:0 P:25637'
G[25660]='L15 A:41058 T:41060 P:25627,25628'
G[25661]='L15 A:41060 T:41060 P:25660'
G[25662]='FA L10 A:40896 T:41071 P:25652'
G[25663]='L30 A:41005 T:41068 O:25985,27874'
G[25664]='L30 A:41005 T:41005 P:25665'
G[25665]='L30 A:41068 T:41005 P:25663'
G[25666]='L30 E31961'
G[25667]='FA L1 A:40950 T:40950 P:25724'
G[25668]='FA L1 A:40951 T:40951 P:25724'
G[25669]='FA L10 A:41071 T:40896 P:25662'
G[25670]='L30 A:46338 T:46458 P:27699'
G[25671]='K2 L10 M030 A:40896 T:40896 P:t04583999'
G[25672]='L15 A:41060 T:41060 P:25661'
G[25673]='FA L10 A:40908 T:40908 P:25652'
G[25674]='FH L15 A:41124 T:41124 P:600002 O:28553,28671,28858,28865'
G[25675]='FH L15 A:41125 T:41125 P:600002'
G[25676]='FH L15 A:41124 T:41133 P:25674+600002'
G[25677]='FH L15 A:41133 T:41133 P:25676+600002'
G[25678]='FH L15 A:41133 T:41133 P:25676+600002'
G[25679]='FH L15 A:41133 T:41134 P:25677+25678+600002'
G[25680]='FH L15 A:41134 T:41134 P:25679+600002'
G[25681]='FH L15 A:41134 T:41134 P:25680+600002'
G[25682]='FH L15 A:41134 T:41124 P:25681+600002'
G[25683]='FH L15 A:41124 T:7506 P:25682+600002 I:26157'
G[25684]='FH L15 A:7506 T:7506 P:25683+600002 I:26158'
G[25685]='FH L15 A:7506 T:7506 P:25684+600002 I:26159'
G[25686]='FH L15 A:7506 T:7506 P:25685+25690+600002 I:26160'
G[25687]='FH L15 A:7506 T:7506 P:25686+600002 I:26161'
G[25688]='FH L15 A:7506 T:7783 P:25687+600002'
G[25689]='FH L15 A:7783 T:41159 P:25688+600002 I:26163'
G[25690]='FH L15 A:7505 T:7505 P:25684+600002 I:26172'
G[25691]='FH L15 A:41159 T:41159 P:25689+600002 I:26164'
G[25692]='FH L15 A:41159 T:41159 P:25689+600002 I:26165'
G[25693]='FH L15 A:41159 T:7783 P:25691+25692+600002 I:26166'
G[25694]='FH L15 A:19254 T:19254 P:600002 I:26173'
G[25695]='FH L15 A:19254 T:19254 P:25694+600002 I:26174'
G[25696]='FH L15 A:19254 T:42344 P:600002'
G[25697]='FH L15 A:7783 T:7506 P:25693+600002 I:26167'
G[25698]='FH L15 A:7783 T:7506 P:25693+600002 I:26168'
G[25699]='FH L15 A:7783 T:7506 P:25693+600002 I:26169'
G[25700]='FH L15 A:7506 T:7783 P:25697+25698+25699+600002 I:26170'
G[25701]='FH L15 A:7783 T:41159 P:25700+600002 I:26171'
G[25702]='L15 A:41265 T:41354 P:600000'
G[25703]='L15 A:41354 T:41354 P:600000 O:25702'
G[25704]='L15 A:41060 T:41060 P:25672'
G[25705]='L15 A:41354 T:41354 P:25703+600000'
G[25706]='L15 A:41354 T:41354 P:25703+600000'
G[25707]='L15 A:41402 T:0 P:25703+600000'
G[25708]='FA L15 A:9540 T:9540 P:25715+600001'
G[25709]='FA L15 A:9540 T:9540 P:25715+600001'
G[25710]='FA L15 A:5393 T:5393 P:600001 O:28673,28857,28867'
G[25711]='FA L15 A:5393 T:5393 P:25710+600001'
G[25712]='FA L15 A:42262 T:42262 P:25710+600001'
G[25713]='FA L15 A:42264 T:42264 P:25710+600001'
G[25714]='FA L15 A:5393,9540 T:5385 P:25708+25709+25711+600001'
G[25715]='FA L15 A:9540 T:9540 P:600001 O:27919'
G[25716]='FA L15 A:5385 T:5385 P:25714+600001'
G[25717]='FH L15 A:42344 T:42344 P:25696+600002 I:26184'
G[25718]='FH L15 A:42344 T:42348 P:25717+600002 I:26185'
G[25719]='FH L15 A:42348 T:42344 P:25718+600002 I:26186'
G[25720]='FH L15 A:42344 T:42344 P:25719+600002 I:26187'
G[25721]='FA L10 A:41086 T:41086 O:25770'
G[25722]='FA L10 A:41129 T:41129'
G[25723]='FA L10 A:41128 T:41128'
G[25724]='FA L1 A:40950 T:40950 O:26373'
G[25725]='FA L10 A:41128 T:41128 P:25723'
G[25726]='FA L10 A:41129 T:41129 P:25722'
G[25727]='FA L10 A:41086 T:41086 P:25721'
G[25728]='FA L10 A:40908 T:40896 P:25673'
G[25729]='FA L10 A:40895 T:40895,-63 P:25652'
G[25730]='FA K512 L10 A:1203186 T:41054'	-- PM2
G[25731]='L30 A:41006 T:41006 P:25655+25656'
G[25732]='L30 A:46458 T:46458 P:25670'
G[25733]='FA L10 A:41086 T:41086 P:25727'
G[25734]='FA L10 A:41129 T:41129 P:25726'
G[25735]='FA L10 A:41128 T:41128 P:25725'
G[25736]='FA L10 A:100055243 T:41086 P:K100055243'	-- technically the prerequisite is SOMEONE turns in 25734 so NPC 41167 spawns to drop the item when killed
G[25737]='L30 E31961'
G[25739]='FA L10 A:40897 T:40897 P:25669'
G[25740]='L30 A:40997 T:541006 P:25664+25731'
G[25741]='L10 A:40898 T:40898 P:25669'
G[25743]='L30 A:46458 T:46463 P:25732'
G[25744]='FA L15 A:40027 T:41190 P:25542,25561'
G[25745]='FH L15 A:40028 T:41184 P:25543,25562'
G[25746]='L30 A:541006 T:541006 P:25740'
G[25747]='FA L30 A:539881 T:540643 P:25760'
G[25748]='FA L30 A:540643 T:540643 P:25747'
G[25749]='FA L30 A:540642 T:540642 P:25747'
G[25751]='FA L30 A:540639 T:540639 P:25747'
G[25752]='FA L30 A:540643 T:500001 P:25748+25749+25751'
G[25753]='FA L30 A:500002 T:500002 P:25752 I:25964'
G[25754]='FA L30 A:500001 T:500001 P:25752 I:25965'
G[25755]='FA L30 A:500004 T:500005 P:25753+25754 I:25966'
G[25756]='FA L15 A:41190 T:41190 P:25744'
G[25757]='FH L15 A:41184 T:41184 P:25745'
G[25758]='L30 A:541006 T:541006 P:25740'
G[25760]='FA L30 A:500003 T:539881 P:25583'
G[25761]='L30 A:541006 T:541006 P:25758'
G[25762]='L15 A:40082 T:40082 P:25744,25745'
G[25763]='L30 A:1203207 T:541006 P:25740'
G[25764]='L30 A:541006 T:541006 P:25763'
G[25765]='FA L10 A:40897 T:41229 P:25739'
G[25766]='FA L10 A:40899 T:40899 P:25669'
G[25767]='FA L10 A:40900 T:40900 P:25669'
G[25768]='FA L10 A:40896 T:41233 P:25769'
G[25769]='FA L10 A:40899 T:40896 P:25766+25767'
G[25770]='L10 A:41075 T:41086 P:25395'
G[25771]='K1 L15 A:100010593 T:7363 P:600000'
G[25772]='K1 L15 A:100008244 T:7363 P:600000'
G[25773]='L30 E31961'
G[25774]='FA L15 A:41190 T:41190 P:25756'
G[25775]='FH L15 A:41184 T:41184 P:25757'
G[25776]='L30 A:541006 T:541006 P:25746+25761+25764'
G[25777]='L10 A:41086 T:2104 P:25733+25734+25735+25736'
G[25778]='FA L15 A:41190 T:41204 P:25774'
G[25779]='FH L15 A:41184 T:41205 P:25775'
G[25780]='FA L10 A:2104 T:2104 O:25777'
G[25787]='L1 E32305'
G[25789]='L1 E32305'
G[25790]='FA L15 A:41204 T:41190 P:25778'
G[25791]='FH L15 A:41205 T:41184 P:25779'
G[25792]='FA L1 A:40950 T:40950 P:313+25667'
G[25793]='FA L10 A:41229 T:41276 P:25765'
G[25794]='L30 A:40105 T:40105 P:25638'
G[25795]='L30 A:541006 T:41005 P:25776'
G[25796]='FA L15 A:41190 T:41190 P:25790'
G[25797]='FH L15 A:41184 T:41184 P:25791'
G[25798]='FA L15 A:41190 T:41190 P:25790'
G[25799]='FH L15 A:41184 T:41184 P:25791'
G[25800]='FA L10 A:41297 T:41297'
G[25801]='FA L10 A:41297 T:41297 P:25800'
G[25802]='FA L10 A:41297 T:1000261 P:25800'
G[25803]='FA L10 A:1000261 T:1142151 P:25802'
G[25804]='FA L10 A:1142151 T:1000259 P:25803'
G[25805]='FA L10 A:1000259 T:41297 P:25804'
G[25806]='FA L10 A:41277 T:41277 P:25793'
G[25807]='L30 A:41005 T:41308 P:25795'
G[25808]='FA L10 A:41277 T:41277 P:25806'
G[25809]='FA L10 A:41282 T:41282 P:25793'
G[25810]='L30 A:41003 T:40578 P:25807'
G[25811]='FA L10 A:41276 T:41276 P:25793'
G[25812]='FA L30 A:40105 T:41324 P:25794'
G[25813]='FA L15 A:41190 T:41190 P:25796+25798'
G[25814]='FH L15 A:41184 T:41184 P:25797+25799'
G[25815]='FA L10 A:1239 T:1239'
G[25816]='FA L10 A:1239 T:41307 P:25815'
G[25817]='FA L10 A:41307 T:41307 P:25816'
G[25818]='FA L10 A:41307 T:1112948 P:25817'
G[25819]='FA L10 A:1112948 T:1217 P:25818'
G[25820]='L10 A:1484 T:1484'
G[25821]='FA L10 A:41277 T:41229 P:25808+25809+25811'
G[25822]='FA L10 A:41229 T:41229 P:25845'
G[25823]='FA L10 A:41229 T:41229 P:25845'
G[25824]='FA L30 A:41341 T:41341 P:25812'
G[25825]='FA L15 A:41190 T:40027 P:25813'
G[25826]='FH L15 A:41184 T:40028 P:25814'
G[25829]='L0 E21655'
G[25830]='L30 A:40289,46987,46998,47002 T:41381 P:25807'
G[25832]='L30 A:40578 T:41308 P:25560'
G[25834]='FA L10 A:41229 T:41278 P:25821'
G[25835]='FA L15 A:40027 T:41392 P:25704+25825'
G[25836]='FH L15 A:40028 T:41446 P:25704+25826'
G[25837]='FA L10 A:41278 T:41278 P:25834'
G[25838]='FA L1 A:40950 T:41363 P:412+25792'
G[25839]='FA L1 A:41363 T:41298 P:25838'
G[25840]='FA L1 A:41298 T:41298 P:25839'
G[25841]='FA L1 A:41298 T:41298 P:25839'
G[25842]='L30 A:41381 T:41381 P:25830'
G[25843]='L30 A:539858 T:41504 P:25372'
G[25844]='FA L10 A:41278 T:41350 P:25837'
G[25845]='FA L10 A:41350 T:41229 P:25844'
G[25846]='FA L10 A:41229 T:11858 P:25822'
G[25847]='FA L10 A:11858 T:11858 P:25846'
G[25848]='FA L10 A:11858 T:11858 P:25847'
G[25849]='FA L10 A:41411 T:41411 O:26981'
G[25850]='FA L10 A:41412 T:41412'
G[25851]='FA L10 A:11858 T:41229 P:25848'
G[25852]='L10 A:41229 T:38378 P:25851'
G[25853]='FA L10 A:41413 T:41413'
G[25854]='FA L10 A:41435 T:41435'
G[25855]='FA L10 A:41435 T:41435 P:25854'
G[25856]='FA L10 A:41433 T:41433'
G[25857]='FA L10 A:41433 T:41433 P:25856'
G[25858]='L30 A:42076 T:42074 P:B25755'
G[25859]='L30 A:42074 T:42074 P:25858'
G[25860]='L30 A:41456 T:41456 P:25629+25896'
G[25861]='L30 A:41457 T:41457 P:25858'
G[25862]='L30 A:41476 T:1203305 P:25858'
G[25863]='L30 A:1203305 T:542076 P:25862'
G[25864]='FA L10 A:41415 T:41415 O:26980'
G[25865]='FA L10 A:41415 T:41415 P:25864'
G[25866]='FA L10 A:41415 T:41415 P:25865'
G[25867]='FA L10 A:41415 T:41415 P:25865'
G[25868]='FA L10 A:41415 T:41415 P:25866+25867'
G[25869]='FA L15 A:41392 T:41392 P:25835'
G[25870]='FH L15 A:41446 T:41446 P:25836'
G[25871]='FA L15 A:41444 T:41444 P:25835'
G[25872]='FH L15 A:41421 T:41421 P:25836'
G[25873]='FA L15 A:45271 T:41392 P:25835'
G[25874]='FH L15 A:45271 T:41446 P:25836'
G[25875]='FA L10 A:41233 T:41434 P:25768'
G[25876]='FA L10 A:41434 T:41434 P:25875'
G[25877]='FA L10 A:41434 T:41233 P:25876'
G[25878]='L10 A:41441 T:41441 P:25768'
G[25879]='L10 A:41441 T:41441 P:25768'
G[25880]='FA L10 A:41233 T:41482 P:25877'
G[25881]='L30 A:41507 T:41492 P:25372'
G[25882]='FA L1 A:41298 T:41578 P:25840+25841'
G[25883]='L30 A:1203301 T:0 P:25887'
G[25884]='L30 A:41344 T:0 P:25887'
G[25885]='FA L30 A:41340 T:41340 P:25887'
G[25886]='L30 A:41492 T:41492 P:25881'
G[25887]='L30 A:41341 T:41341 P:25824,26007'
G[25888]='FA L30 A:41347 T:41347 P:25887'
G[25889]='FA L10 A:41482 T:41482 P:25880'
G[25890]='L30 A:39875 T:41531'
G[25891]='FA L10 A:41482 T:41482 P:25889'
G[25892]='FA L30 A:500005 T:40642 P:25755 I:25967'
G[25893]='FA L30 A:40642 T:41535 P:25892 I:25968'
G[25894]='FA L30 A:40645 T:41535 P:25893'
G[25895]='FA L30 A:41535 T:41535 P:25893'
G[25896]='L30 A:41456 T:41456 P:B26135,B25626'
G[25897]='FA L30 A:41535 T:41535 P:25893'
G[25898]='FA L30 A:41535 T:540645 P:25894+25895+25897'
G[25899]='L30 A:41507 T:41492 P:25843'
G[25900]='L30 A:41531 T:41531 P:25890'
G[25901]='L30 A:41497 T:41497 P:25372'
G[25904]='L30 A:41504 T:41504 P:25843'
G[25905]='FA L1 A:1261 T:1261 P:25932'
G[25906]='L30 A:41504 T:41498 P:25904'
G[25907]='L30 A:41531 T:41531 P:25900'
G[25908]='L30 A:41531 T:41531 P:25900'
G[25909]='FA L30 A:41531 T:41531 P:25907+25908'
G[25910]='L30 A:41498 T:41498 P:25906'
G[25911]='FA L30 A:540645 T:40642 P:25898'
G[25912]='L10 A:41486 T:41486 P:25891'
G[25913]='L10 A:41488 T:41488 P:25891'
G[25914]='FA L10 A:41488 T:41488 P:25891'
G[25915]='L30 A:41498 T:41498 P:25906'
G[25916]='FA L30 A:41531 T:41531 P:25909'
G[25917]='FA L30 A:41531 T:41540 P:25916'
G[25918]='FA L30 A:41541 T:41541 P:25917'
G[25919]='FA L30 A:41540 T:41540 P:25917'
G[25920]='FA L30 A:41802 T:41802 P:25917'
G[25921]='FA L30 A:41540 T:41531 P:25918+25919+25920'
G[25922]='FA L30 A:41531 T:40642 P:25921'
G[25923]='L30 A:41498 T:41498 P:25915'
G[25924]='FH L30 A:41621 T:41618 O:27718,28816'
G[25925]='FA L10 A:41482 T:41487 P:25891'
G[25926]='FA L10 A:41503 T:41503'
G[25927]='FA L10 A:41503 T:41503 P:25926'
G[25928]='L30 A:41498 T:41504 P:25923'
G[25929]='FH L30 A:41618 T:41618 P:25924'
G[25930]='FA L10 A:41487 T:41487 P:25925'
G[25931]='FA L10 A:41487 T:41487 P:25930'
G[25932]='FA L1 A:41578 T:41578 O:25882'
G[25933]='FA L1 A:41578 T:1254 P:314+25905'
G[25934]='FA L10 A:41664 T:41664 P:25925'
G[25935]='FA L10 A:41638 T:41638 P:25925'
G[25936]='FH L30 A:41618 T:41618 P:25929'
G[25937]='FA L1 A:50631 T:50631'
G[25938]='L10 A:41487 T:36410 I:28531'
G[25939]='FA L10 A:41615 T:41615 P:25926'
G[25940]='L30 A:39927,39928 T:39932 P:25428+25382+25392'
G[25941]='FH L30 A:41618 T:41711 P:25936'
G[25942]='FH L30 A:41711 T:41711 P:27668'
G[25943]='FH L30 A:41711 T:41711'
G[25944]='FH L30 A:41711 T:41711 P:25942+25943+25946'
G[25945]='FH L10 A:41678 T:34341 O:28532'
G[25946]='FH L30 A:1203395 T:41711 O:27668'
G[25947]='FH L30 A:41711 T:41711 P:25942+25943+25946'
G[25948]='FH L30 A:41711 T:41750 P:25944+25947'
G[25949]='FH L30 A:41750,41769 T:40105 P:25948'
G[25950]='FA L30 A:41667 T:41667 P:26080'
G[25951]='L30 A:41456 T:542077 P:25860'
G[25952]='FH L30 A:40916 T:40916'
G[25953]='FH L30 A:40917 T:40917'
G[25954]='FH L30 A:40920 T:40920'
G[25955]='FH L30 A:40916 T:40916'
G[25956]='FH L30 A:1203140 T:40916 O:27394'
G[25957]='FH L30 A:40919 T:40919'
G[25958]='FH L30 A:40919 T:40916 P:25957'
G[25959]='FH L30 A:40916 T:40916 P:25958'
G[25960]='FH L30 A:40917 T:40917'
G[25962]='FH L30 A:40918 T:40918'
G[25963]='FH L30 A:40916 T:40916'
G[25964]='FH L30 A:40917 T:40917 I:25753'
G[25965]='FH L30 A:40916 T:40916 P:25963 I:25754'
G[25966]='FH L30 A:40919 T:40919 I:25755'
G[25967]='FH L30 A:40919 T:40917 P:25966 I:25892'
G[25968]='FH L30 A:40917 T:41770 P:25967 I:25893'
G[25969]='FH L30 A:40921 T:41770'
G[25970]='FH L30 A:41770 T:72841'
G[25971]='FH L30 A:41770 T:41770'
G[25972]='FH L30 A:41770 T:40921'
G[25973]='FH L30 A:40921 T:40917 P:25972'
G[25974]='FH L30 A:41670 T:41670'
G[25975]='FA L30 A:41665 T:41665 P:26080'
G[25976]='FH L30 A:41668 T:41668'
G[25977]='FA L30 A:41667 T:41667 P:26080'
G[25978]='FA L1 A:41786 T:41786 O:25986'
G[25979]='FA L1 A:41804 T:41804'
G[25980]='FH L30 A:41670 T:41670'
G[25981]='FA L30 A:41666 T:41666 P:26080'
G[25982]='FH L30 A:41669 T:41669'
G[25983]='FA L30 A:41666 T:41598 P:25987'
G[25984]='FH L30 A:41669 T:41636 P:25988'
G[25985]='L30 A:40833 T:41005 P:25578 I:27874'
G[25986]='FA L1 A:1977 T:41786 P:432+433+25937'
G[25987]='FA L30 A:41666 T:41666 P:25981'
G[25988]='FH L30 A:41669 T:41669 P:25982'
G[25989]='FH L30 A:41531 T:41531 P:25907,25908'
G[25990]='FH L30 A:41531 T:41531 P:25989'
G[25991]='FH L30 A:41531 T:41810 P:25990'
G[25992]='FH L30 A:41811 T:41811'
G[25993]='FH L30 A:41810 T:41810 P:25991'
G[25994]='FH L30 A:41813 T:41813'
G[25995]='FH L30 A:41810 T:41531'
G[25996]='FH L30 A:41531 T:40917 P:25995'
G[25997]='FA L1 A:41786 T:41786 P:25978+25979'
G[25998]='FA L1 A:41786 T:41853 P:25997'
G[25999]='FH L10 A:34341 T:34341 P:25945'
G[26000]='FH L30 A:40105 T:41863 P:25794'
G[26001]='FH L10 A:34341 T:40901 P:25999'
G[26002]='FH L10 A:40901 T:34341 P:26001'
G[26003]='L10 A:40926 T:40926 P:25999'
G[26004]='FH L10 A:34341 T:41023 P:26002'
G[26005]='FA L30 A:39881 T:42411 P:25626'
G[26006]='FH L30 A:40919 T:42410 P:26135'
G[26007]='FH L30 A:41341 T:41341 P:25824'
G[26008]='FH L30 A:41347 T:33536,41347'
G[26009]='K2 L10 M030 A:41023 T:41023 P:26004+t04C83999'
G[26010]='FH L10 A:41023 T:41023 P:26004'
G[26011]='FH L10 A:40903 T:40903 P:26004'
G[26012]='L30 A:16128 T:27990'
G[26013]='L30 A:27990 T:40429 P:26012'
G[26014]='FA L30 A:41662 T:41910 P:26106'
G[26015]='FA L30 A:41910 T:46592,41910 P:26014'
G[26016]='L10 A:100056474 T:41023 Z16030'	-- drops from the target of 26011
G[26017]='FA L30 A:41910 T:41910 P:26015'
G[26018]='FA L30 A:41910 T:41910 P:26015'
G[26019]='FA L30 A:100056571 T:41910'
G[26020]='FH L10 A:41023 T:40902 P:26010'
G[26021]='FA L30 A:41910 T:41910 P:26019'
G[26022]='FH L10 A:41949 T:41949 O:28572,28619'
G[26023]='L10 A:41949 T:41944 P:26022'
G[26024]='FA L10 A:1002713 T:2700'
G[26025]='FH L10 A:41949 T:41949 P:26022'
G[26026]='FH L10 A:40907 T:40907 P:26004'
G[26027]='FH L10 A:41966 T:41949 P:26053'
G[26028]='FH L10 A:40907 T:41023 P:26026'
G[26029]='FH L10 A:41966 T:41966 P:26025+26027'
G[26030]='FH L10 A:41944 T:41944 P:26023'
G[26031]='FH L10 A:41944 T:41944 P:26030'
G[26032]='FH L10 A:41944 T:41944 P:26031'
G[26033]='FH L10 A:41944 T:41944 P:26032'
G[26034]='L30 A:40429 T:27990 P:26013'
G[26035]='FA L10 A:2789 T:2789'
G[26036]='FA L10 A:2789 T:2789 P:26035'
G[26037]='FA L10 A:2789 T:41983 P:26036'
G[26038]='FA L10 A:41983 T:2789 P:26037'
G[26039]='L10 A:1138492 T:1002701 O:26341,26909'
G[26040]='FH L30 A:41863,41885 T:41885'
G[26041]='L10 A:1002701 T:1002702 P:26039'
G[26042]='L10 A:1002702 T:1002688 P:26041'
G[26043]='FH K512 L10 A:1203186 T:40903'	-- PM2
G[26044]='FH L10 A:40902 T:41991 P:26020'
G[26045]='FH L10 A:41991 T:41991 P:26044'
G[26046]='FH L10 A:41990 T:41990 P:26044'
G[26047]='FH L10 A:41992 T:41992 P:26044'
G[26048]='FH L10 A:41991 T:40902 P:26045+26046+26047'
G[26049]='FA K512 L10 A:2789 T:1138492 P:26346'	-- PM2
G[26050]='K32 L10 A:2768 T:2774'
G[26051]='L10 A:2774 T:2774 P:26050'
G[26052]='L10 A:2774 T:2610 P:26051'
G[26053]='FH L10 A:41966 T:41966'
G[26054]='FA L30 A:42443 T:466 Z13329'
G[26055]='L10 A:2769 T:2769'
G[26056]='FA L30 A:41598 T:41640'
G[26057]='FH L30 A:41636 T:41640'
G[26058]='FH L10 A:40902 T:41023 P:26048'
G[26059]='FH L10 A:41023 T:3995 P:26058'
G[26060]='FH L10 A:3995 T:3995 P:26059'
G[26061]='FH L10 A:3995 T:3995 P:26059'
G[26062]='FH L10 A:3995 T:3995 P:26060+26061'
G[26063]='L10 A:11821 T:11821'
G[26064]='L10 A:3411 T:3411 P:26059'
G[26065]='L30 A:41640 T:41640 O:26056,26057'
G[26066]='FH L10 A:42023 T:42023 P:26060+26061'
G[26067]='FH L10 A:3995 T:3995 P:26062'
G[26068]='FH L10 A:42023 T:42023 P:26066'
G[26069]='L10 A:3995 T:37135 I:28549'	-- this became available sometime after both 26060 and 26061 were accepted.  also accepted was 26064.  however, I did not see this available.  I may have missed it, or it became available after time or after one of these three mentioned was complete but not turned in.
G[26070]='FA L30 A:41598 T:41598 P:25983'
G[26071]='FH L30 A:41636 T:41636 P:25984'
G[26072]='L30 A:41600 T:41600'
G[26073]='FH L10 A:3995 T:41023 P:26067+26068'
G[26074]='FH L10 A:41023 T:42033 P:26073'
G[26075]='FH L10 A:42033 T:42033 P:26074'
G[26076]='FH L10 A:42033 T:42033 P:26075'
G[26077]='FH L10 A:42033 T:42050 P:26076'
G[26078]='FA L1 A:41853 T:41853 P:25998'
G[26079]='fA L10 A:1002713 T:2700'
G[26080]='FA L30 A:41910 T:41662 P:26017+26018'
G[26081]='FH L10 A:41944 T:41949 P:26033'
G[26082]='FH L10 A:42050 T:42050 P:26077'
G[26083]='FH L10 A:42088 T:2766 P:26081+T01541999'	-- TODO: Verify requires Neutral Booty Bay
G[26084]='L10 A:41949 T:42130 P:26081'
G[26085]='FA L1 A:41853 T:41853 P:26078'
G[26086]='FH L30 A:41663 T:41908'
G[26087]='FH L30 A:41908 T:41908 P:26086'
G[26088]='FH L30 A:41908 T:41908'
G[26089]='FH L30 A:41908 T:41908'
G[26090]='FH L30 A:100056812 T:41908'
G[26091]='FH L30 A:41908 T:41908 P:26090'
G[26092]='FH L30 A:41908 T:41663'
G[26093]='L10 A:2700 T:2700 O:26139,28573'
G[26094]='FA L1 A:41853 T:41853 P:26085'
G[26095]='FA L10 A:2700 T:2700 P:26093'
G[26096]='L30 A:41639 T:41639'
G[26097]='FH L10 A:42039 T:42091 P:26082'
G[26098]='FH L10 A:42091 T:42039 P:26097'
G[26099]='FH L10 A:42039 T:42047 P:26098'
G[26100]='FH L10 A:42047 T:41023 P:26099'
G[26101]='FH L10 A:41023 T:42106 P:26100'
G[26102]='FA L1 A:41853 T:41853 P:26094'
G[26103]='FA L30 A:41666 T:41666 P:26219'
G[26105]='FA L30 AK:42115 T:41665'
G[26106]='FA L30 A:41666 T:41666 P:26103'
G[26107]='FH L10 A:42130 T:42130'
G[26108]='FH L10 A:42130 T:42130 P:26107'
G[26109]='L15 E21655'
G[26110]='FA L10 A:2712 T:2712 O:26113'
G[26111]='L30 A:41600 T:41600 P:26072+26096'	-- does this also need 26070/26071 ?
G[26112]='FA L1 A:41853 T:42129 P:26102'
G[26113]='FA L10 A:2608 T:2712'
G[26114]='FA L10 A:2712 T:2713 P:26110'
G[26115]='FH L10 A:42106 T:542039 P:26101'
G[26116]='FA K32 L10 A:2713 T:2712 P:26114'
G[26117]='FA L10 A:2712 T:2608 P:26116'
G[26118]='FA L1 A:42129 T:42129 P:26112'
G[26119]='L1 E21655'
G[26120]='FA L10 A:41612 T:41612'
G[26121]='FA L30 E31961'
G[26122]='FH L30 A:41669 T:41669'
G[26123]='L1 E21655'
G[26124]='FH L30 AK:42114 T:41668 I:26125'
G[26125]='FH L30 A:41663 T:41668 I:26124'
G[26126]='FH L30 A:41669 T:41669 P:26122'
G[26127]='FA L10 A:42160 T:42160 O:26327'
G[26128]='FA L10 A:42160 T:-56,42160 P:26127'
G[26129]='FA L1 RW A:35077 T:35112 P:14154'
G[26130]='L30 A:41600 T:41600 P:26111'
G[26131]='FA L5 A:1959 T:1960 I:28567'
G[26132]='FA L30 A:41598 T:41598 P:26111'
G[26133]='FH L30 A:41636 T:41636'
G[26134]='L10 A:500030 T:35286 P:26115'
G[26135]='FH L30 A:40919 T:40919'
G[26136]='L0 E21655'
G[26137]='L10 A:1343 T:41075 I:28565'
G[26138]='L15 E21655'
G[26139]='L10 A:-56,42160 T:2700 P:26128 I:28573'
G[26140]='L30 A:41600 T:42197 P:26130'
G[26141]='L30 A:42197 T:42197 P:26140'
G[26142]='L30 A:42197 T:42197 P:26140'
G[26143]='L30 A:-204 T:42197 P:26154'
G[26144]='FA L30 A:100057102 T:-204'
G[26145]='FA L5 A:1089 T:1089 O:13635'
G[26146]='FA L5 A:1092 T:1092 O:13635'
G[26147]='FA L5 A:1090 T:1090 P:26146'
G[26148]='FA L5 A:1092 T:1092 P:26146'
G[26149]='FH L30 A:100057118 T:-204'
G[26150]='L1 A:253 T:251 P:60'
G[26152]='FA L1 A:1203733 T:42256'
G[26153]='K2 L10 A:42288 T:42288 P:PC001 I:26177,26183,26190,26192,29313,29314,29316,29318,29351,29352,29353,29355,29356,29357'
G[26154]='L30 A:42197 T:-204 P:26141+26142'
G[26157]='FA L15 A:5385 T:42298 P:25716+600001 I:25683'
G[26158]='FA L15 A:42298 T:42298 P:26157+600001 I:25684'
G[26159]='FA L15 A:42298 T:42298 P:26158+600001 I:25685'
G[26160]='FA L15 A:42298 T:42298 P:26159+600001 I:25686'
G[26161]='FA L15 A:42298 T:42298 P:26166+600001 I:25687'
G[26162]='FA L15 A:42298 T:7783 P:26161+600001'
G[26163]='FA L15 A:42298 T:42299 P:26167+26168+26169+600001 I:25689'
G[26164]='FA L15 A:42299 T:42299 P:26163+600001 I:25691'
G[26165]='FA L15 A:42299 T:42299 P:26163+600001 I:25692'
G[26166]='FA L15 A:42299 T:42298 P:26164+26165+600001 I:25693'
G[26167]='FA L15 A:42298 T:42298 P:26160+600001 I:25697'
G[26168]='FA L15 A:42298 T:42298 P:26160+600001 I:25698'
G[26169]='FA L15 A:42298 T:42298 P:26160+600001 I:25699'
G[26170]='FA L15 A:42298 T:7783 P:26162+600001 I:25700'
G[26171]='FA L15 A:7783 T:42299 P:26170+600001 I:25701'
G[26172]='FA L15 A:42298 T:42298 P:26158+600001 I:25690'
G[26173]='FA L15 A:16841 T:16841 P:600001 I:25694'
G[26174]='FA L15 A:16841 T:16841 P:26173+600001 I:25695'
G[26175]='FA L15 A:16841 T:42349 P:26174+600001'
G[26176]='L5 A:1092 T:1340 P:26148'
G[26177]='fA K2 L10 A:42288 T:42288 P:PC001 I:26153,26183,26190,26192,29313,29314,29316,29318,29351,29352,29353,29355,29356,29357'
G[26178]='L1 E21655'
G[26179]='FH L1 A:2988 T:2988 P:751'
G[26180]='FH L1 A:2988 T:2988 P:751'
G[26181]='FA L30 A:42197 T:541600 P:26143'
G[26182]='FH L30 A:42197 T:41600'
G[26183]='fA K2 L10 A:42288 T:42288 P:PC001 I:26153,26177,26190,26192,29313,29314,29316,29318,29351,29352,29353,29355,29356,29357'
G[26184]='FA L15 A:42349 T:42349 P:600001 O:26175 I:25717'
G[26185]='FA L15 A:42349 T:42352 P:26184+600001 I:25718'
G[26186]='FA L15 A:42352 T:42349 P:26185+600001 I:25719'
G[26187]='FA L15 A:42349 T:42349 P:26186+600001 I:25720'
G[26188]='FH L1 A:3055 T:3055'
G[26189]='FA L10 A:41411 T:41411 P:25849'
G[26190]='fA K2 L10 A:42288 T:42288 P:PC001 I:26153,26177,26183,26192,29313,29314,29316,29318,29351,29352,29353,29355,29356,29357'
G[26191]='SP L30 A:542076 T:0 P:25859+25863'
G[26192]='fA K2 L10 A:42288 T:42288 P:PC001 I:26153,26177,26183,26190,29313,29314,29316,29318,29351,29352,29353,29355,29356,29357'
G[26193]='FA L30 A:541600 T:44490 P:26181'
G[26194]='FH L30 A:41600 T:44540'
G[26195]='FA L10 A:41411 T:41615 P:25850+25853+26189'
G[26196]='FA L10 A:41615 T:1071 P:25939'
G[26197]='FA L1 CM A:42396 T:42331 P:27674'
G[26198]='L259 RN CM A:42331 T:42331 P:26197 Z21691'
G[26199]='FA L1 CT A:42396 T:42323 P:27674'
G[26200]='FA L5 CT A:42323 T:42323 P:26199 Z21691'
G[26201]='L515 RN CL A:460 T:460 P:26202 Z21691'
G[26202]='FA L1 CL A:42396 T:460 P:27674'
G[26203]='FA L1 CW A:42396 T:42324 P:27674'
G[26204]='FA L5 CW A:42324 T:42324 P:26203 Z21691'
G[26205]='FA L1 A:42553 T:42553 P:26222'
G[26206]='FA L1 CR A:42396 T:42366 P:27674'
G[26207]='FA L5 CR A:42366 T:42366 P:26206 Z21691'
G[26208]='FA L1 A:42317 T:42317 P:26421,26422,26423,26424,26425,31137,41218'
G[26209]='FA L5 A:42308 T:42308 O:26378,28562'
G[26210]='FH L10 A:14740 T:14740'
G[26211]='FH L10 A:14740 T:14740'
G[26212]='FH L10 A:14731 T:14731'
G[26213]='FA L5 A:42308 T:42308 P:26209'
G[26214]='FA L5 A:42308 T:42308 P:26209'
G[26215]='FA L5 A:42308 T:42405 P:26213+26214'
G[26219]='FA L30 A:42411 T:41662 P:26005'
G[26220]='K2 L10 A:42506 T:42506 P:PC001 I:26226,26227,26233,26234,26235,29315,29332,29333,29334,29358,29360,29362,29363,29364,29365'
G[26221]='FH L30 A:42410 T:41663'
G[26222]='FA L1 A:42553 T:42553 P:26566'
G[26223]='FH L10 A:14741 T:14741'
G[26224]='FH L10 A:14741 T:14741 P:26223'
G[26225]='FH L10 A:42464 T:42464'
G[26226]='K2 L10 A:42506 T:42506 P:PC001 I:26220,26227,26233,26234,26235,29315,29332,29333,29334,29358,29360,29362,29363,29364,29365'
G[26227]='K2 L10 A:42506 T:42506 P:PC001 I:26220,26226,26233,26234,26235,29315,29332,29333,29334,29358,29360,29362,29363,29364,29365'
G[26228]='FA L5 A:42405 T:42405 P:26215'
G[26229]='L5 A:42498 T:42498 P:26215'
G[26230]='L5 A:42497 T:42497 P:26215'
G[26232]='FA L5 A:42405 T:42558 P:26228'
G[26233]='FH K2 L10 RO RU RT RG RB RA RR RM SL A:42506 T:42506 P:PC001 I:26220,26226,26227,26234,26235,29315,29332,29333,29334,29358,29360,29362,29363,29364,29365'
G[26234]='FH K2 L10 RL RZ A:42506 T:42506 P:PC001 I:26220,26226,26227,26233,26235,29315,29332,29333,29334,29358,29360,29362,29363,29364,29365'
G[26235]='K2 L10 A:42506 T:42506 P:PC001 I:26220,26226,26227,26233,26234,29315,29332,29333,29334,29358,29360,29362,29363,29364,29365'
G[26236]='FA L5 A:42558 T:233 P:26232'
G[26237]='FA L5 A:233 T:233 P:26236'
G[26238]='FH L10 A:42613 T:42613'
G[26239]='L15 E21655'
G[26240]='FH L10 A:14739 T:14739'
G[26241]='FA L5 A:235 T:235 P:26236'
G[26242]='L1 E21655'
G[26243]='L30 E21655'
G[26244]='L30 A:43397 T:43397'
G[26245]='L30 A:43065 T:43065 O:27123'
G[26246]='L30 A:1204274 T:43065 P:B26245'
G[26247]='L30 A:43065 T:42684 P:26244+26246+26245'
G[26248]='L30 A:42684 T:42684 P:26247'
G[26249]='L30 A:42684 T:43082 P:26247'
G[26250]='L30 A:42684 T:42684 P:26248'
G[26251]='L30 A:42684 T:42684 P:26248'
G[26252]='L5 A:100057935 T:233 P:26236'
G[26254]='L30 A:42684 T:42684 P:26250'
G[26255]='L30 A:42684 T:43065 P:26254'
G[26256]='L30 A:-207,43065 T:0,43065 P:26258'
G[26257]='L5 A:233 T:233 P:26252'
G[26258]='L30 A:43065 T:0,43065 P:26255'
G[26259]='L30 A:43397 T:43397 P:26255'
G[26260]='L30 A:-207,43065 T:1205134 P:26261'
G[26261]='L30 A:-207,43065 T:0,43065 P:26256'
G[26262]='L1 E21655'
G[26263]='FH L10 A:42613 T:42613'
G[26264]='FA L1 A:42611 T:42611 P:26222'
G[26265]='FA L1 A:42630 T:42630 P:26222'	-- for some reason I commented that P:26222 was wrong, but I just checked and it was not available until I turned 26222 in.
G[26266]='FA L5 A:235 T:42575 P:26270'
G[26267]='FH L10 A:42613 T:42613 P:26263'
G[26268]='FH L10 A:42613 T:42613 P:26263'
G[26269]='L10 A:716 T:716 P:583'
G[26270]='FA L5 A:233 T:235 P:26237+26241'
G[26271]='FA L5 A:42575 T:42575 P:26266'
G[26272]='FH L1 CL A:37951 T:42618'
G[26273]='L1 CL A:42618 T:42618 P:26272'
G[26274]='L1 CL A:42618 T:42618 P:26276 Z21691'
G[26275]='L1 CL A:42618 T:42618 P:26273'
G[26276]='L1 CL A:42618 T:42618 P:26275'
G[26277]='L1 CL A:42618 T:38966 P:26276'
G[26278]='FH L10 A:2464 T:2464 O:26417,28688 OCC:28855'
G[26279]='FH L10 A:2464 T:2464 P:26278'
G[26280]='FH L10 A:2464 T:2464 P:26278'
G[26281]='FH L10 A:2464 T:2464 P:26280'
G[26282]='L15 E21655'
G[26283]='FH L10 A:42612 T:42612 P:26238+26263'	-- TODO: Verify requires 26238
G[26284]='FA L1 A:42708 T:42708 P:26316'
G[26285]='FA L1 A:42708 T:42708 P:26316'
G[26286]='FA L5 A:234 T:234 P:26266'
G[26287]='L5 A:821 T:821 P:26266'
G[26288]='L5 A:821 T:821 P:26287'
G[26289]='FA L5 A:234 T:7024 P:26286+26271'
G[26290]='FA L5 A:7024 T:7024 P:26289'
G[26291]='FA L5 A:7024 T:234 P:26290'
G[26292]='FA L5 A:234 T:42425 P:26291'
G[26293]='FH L30 A:86832 T:42672 P:28717'
G[26294]='FH L30 A:42672 T:39605 P:26293'
G[26295]='FA L5 A:42425 T:42425 P:26292'
G[26296]='L5 A:100058117 T:42425 P:26292'
G[26297]='FA L5 A:42425 T:42425 P:26295'
G[26298]='FH L10 A:2497 T:2497 P:26280'
G[26299]='FH L10 A:2497 T:2497 P:26298'
G[26300]='FH L10 A:2497 T:1002076 P:26299'
G[26301]='FH L10 A:1002076 T:1002076 P:26300'
G[26302]='FH L10 A:1002076 T:2519 P:26301'
G[26303]='FH L10 A:2519 T:2519 P:26302 I:26781'
G[26304]='FH L10 A:42813 T:42813 P:26359 I:26780'
G[26305]='FH L10 A:2519 T:2497 P:26303'
G[26306]='FH L10 A:42642 T:42642 P:26432,26496'
G[26307]='FH L10 A:42642 T:42642 P:26306'
G[26308]='FH L10 A:42642 T:42642 P:26307'
G[26309]='FH L10 A:42622 T:42622 P:26310'
G[26310]='FH L10 A:42622 T:42622'
G[26311]='FH L30 A:42637 T:42637 O:28909'
G[26312]='L30 A:42730 T:42730 P:26326'
G[26313]='L30 A:42731 T:42731 P:26326'
G[26314]='L30 A:42730 T:42730 P:26326'
G[26315]='L30 A:42731 T:42731 P:26312+26313+26314'
G[26316]='FA L1 A:42489 T:42708 P:26205'
G[26317]='FH L10 AP:-50:X26738;2465:26738 T:2465 P:28855'
G[26318]='FA L1 A:42708 T:42708 P:26284+26285'
G[26319]='FA L5 A:42425 T:42651 P:26297'
G[26320]='FA L5 A:42651 T:234 P:26319'
G[26321]='FH L10 A:2465 T:2465 P:26317 I:26739'
G[26322]='FA L5 A:234 T:29611 P:26320'
G[26323]='FH L10 A:42736 T:2497 P:26321'	-- there is most likely another requirement.  either of the two quests turned in after 26321 was done, or the presence of any of the three quests available once 26280 was completed
G[26324]='FH L30 A:39605 T:42641 P:26311'
G[26325]='FH L10 A:1002076 T:1002076 P:26323'
G[26326]='L30 A:43065 T:42730 P:27938+26876'
G[26327]='L10 A:1071 T:42160'
G[26328]='L30 A:42731 T:42467 P:26315'
G[26329]='FA L1 A:42708 T:42317 P:26318'
G[26330]='FH L10 A:1002076 T:1002076 P:26325'
G[26331]='FA L1 A:42317 T:42317 P:26329'
G[26332]='FH L10 A:1002076 T:1002076 P:26330'
G[26333]='FA L1 A:42224 AA:42491 T:42491 P:26329'
G[26334]='FH L10 A:542790 T:542790 P:26332'
G[26335]='FH L30 A:42641 T:1204050 P:26324'
G[26336]='FA L10 A:2789 T:2610'
G[26337]='FH L30 A:1204050 T:42641 P:26335'
G[26338]='FH L10 A:2465 T:2465 P:26325'
G[26339]='FA L1 A:42366 T:42353 P:26331+26333'
G[26340]='FH L10 A:17094 T:716 P:9457'
G[26341]='FA L10 A:2789 T:1138492'
G[26342]='FA L1 A:42353 T:42353 P:26339'
G[26343]='L10 A:2495 T:2495'
G[26344]='L10 A:2495 T:2495 P:26343'
G[26345]='L10 A:2495 T:2495 P:26344'
G[26346]='FA L10 A:1002702 T:2789 P:26042'	-- TODO: Determine how to conceptually put in P:26042 because the Rumbling Exile that spawns when it is turned in needs to die, allowing this quest to become available.
G[26347]='FA L5 A:392 T:392'
G[26348]='FA L5 A:392 T:392 O:26371'
G[26349]='FA L5 A:392 T:392'
G[26350]='FH L10 A:2497 T:42812 P:26334 I:26749'
G[26351]='FH L10 A:42812 T:42812 P:26350 I:26772'
G[26352]='FH L10 A:42813 T:42813 P:26399,26412'
G[26353]='L5 A:100001357 T:1000035'
G[26354]='L5 A:1000035 T:1000036 P:26353'
G[26355]='L5 A:1000036 T:1000034 P:26354'
G[26356]='L5 A:1000034 T:1000033 P:26355'
G[26357]='FH L10 A:42624 T:42624'
G[26358]='FH L30 A:42640 T:42643 P:26324'
G[26359]='FH L10 A:42812 T:42812 P:26351 I:26773'
G[26360]='FH L10 A:42812 T:42812 P:26359 I:26774'
G[26361]='FH L30 A:42643 T:42643 P:26358'
G[26362]='FH L10 A:42812 T:42812 P:26360 I:26775'
G[26363]='FH L10 A:42642 T:42642 P:26308+26367'	-- TODO: Verify requires 26308 (note that in testing ensure 26368 not turned in, because in this case it was)
G[26364]='FA L1 A:42353 T:42353 P:26342'
G[26365]='FA L7 A:1750,821,29611 T:464 I:28563'
G[26366]='FH L10 A:42642 T:42642'
G[26367]='FH L10 A:42642 T:42642 P:26307'
G[26368]='FH L10 A:42622 T:42622 P:26309'
G[26369]='FH L10 A:42642 T:42642 P:26363'
G[26370]='FA L5 A:29611 T:234 P:26322'
G[26371]='fA L5 A:878 T:392'
G[26372]='FH L30 A:42643 T:42640 P:26361'
G[26373]='FA L1 A:42353 T:40950 P:26364'
G[26374]='FH L30 A:42641 T:42641 P:26324'
G[26375]='L30 A:42899 T:42899 P:26328'
G[26376]='L30 A:42467 T:42467 P:26328'
G[26377]='L30 A:42467 T:42467 P:26328'
G[26378]='FA L5 M015 A:240,261,294,963,42256 T:42308 I:28562'
G[26379]='L5 E21655'
G[26380]='FA L1 A:42933 T:1247'
G[26381]='FH L10 A:42898 T:42898'
G[26382]='FH L10 A:42896 T:42896'
G[26383]='FA L5 RH RF RE RN RD RA RV RI RK A:42936 T:32973 I:26385,28490'
G[26384]='L10 A:42622 T:42898 P:26369'
G[26385]='FA L5 RW A:48736 T:32973 P:28517 I:26383,28490'
G[26386]='FH L10 A:42812 T:42811 P:26362 I:26776'
G[26387]='FH L10 A:42896 T:42896 P:26382'
G[26388]='FH L30 A:50367 T:42978 P:28849'
G[26389]='L1 A:197 T:197 P:28817,28818,28819,28820,28821,28822,28823,29083,31145'
G[26390]='L1 A:197 T:197 P:26389'
G[26391]='L1 A:9296 T:9296 P:28817,28818,28819,28820,28821,28822,28823,29083,31145'
G[26393]='FA L1 RH RK A:514 T:42983'
G[26394]='L1 A:42983,43000 T:1323 P:26393'
G[26395]='fA L1 A:1323 T:352 P:26394'
G[26396]='L1 A:352 T:514 P:26395'
G[26397]='FH L1 RT A:36648 T:39605 P:24540'	-- also marks 26398 complete (which is another version it seems)
G[26399]='FH L10 A:42814 T:42814 I:26412,26782,26783'
G[26400]='FH L10 A:42814 T:42814 P:26399,26412'
G[26401]='FA L15 A:1203134 T:40132 P:25368'
G[26402]='FA L15 A:40032 T:3936 P:25398'
G[26403]='FH L10 A:42814 T:42814 P:26399,26412 I:26763'
G[26404]='FH L10 A:42814 T:43095'
G[26405]='FH L10 A:42811 T:42811 P:26359 I:26779'
G[26406]='FH L10 A:42898 T:42898 P:26381'
G[26407]='FH L10 A:100058491 T:2465'
G[26408]='L7 A:34402 T:33187 P:13897 I:28492'
G[26409]='L30 A:42573 T:42574'
G[26410]='L30 A:42574 T:42574 P:26409'
G[26411]='L30 A:42574 T:42574 P:26410,27135'
G[26412]='FH L15 I:26399,26782,26783'	--  A:42814 T:42814 just a copy of 26399 because no idea what is live
G[26413]='L30 A:42574 T:42573 P:26411'
G[26414]='fA K2 L10 A:5494 T:5494 P:PF001 I:29321,29323,29324,29325,29342,29343,29344,29347,29350,29359,26420,26442,26488,26536'
G[26415]='L0 E21655'
G[26416]='FH L10 A:43063 T:43062'
G[26417]='FH L10 A:43062 T:2464 P:26416 I:28688'
G[26418]='FH L10 A:42898 T:42898 P:26406'
G[26419]='FH L10 A:43299 T:42898 P:26558'
G[26420]='fA K2 L10 A:5494 T:5494 P:PF001 I:29321,29323,29324,29325,29342,29343,29344,29347,29350,29359,26414,26442,26488,26536'
G[26421]='FA L1 RN CM A:42331 T:42317 P:26197 I:26422,26423,26424,26425,31137'
G[26422]='FA L1 RN CT A:42323 T:42317 P:26199 I:26421,26423,26424,26425,31137'
G[26423]='FA L1 RN CR A:42366 T:42317 P:26206 I:26421,26422,26424,26425,31137'
G[26424]='FA L1 RN CL A:460 T:42317 P:26202 I:26421,26422,26423,26425,31137'
G[26425]='FA L1 RN CW A:42324 T:42317 P:26203 I:26421,26422,26423,26424,31137'
G[26426]='L30 A:42467 T:0,42467 P:26375+26376+26377'
G[26427]='L30 A:43082 T:43082 P:26249'
G[26428]='L10 A:4486 T:4486'
G[26429]='L10 A:2771 T:2771'
G[26430]='L10 A:2771 T:42613'
G[26432]='L10 A:42613 T:42642 P:26267,26268,26491,26492'
G[26433]='FH L10 A:43096 T:43096 I:26590,26817'	-- who gets this?
G[26434]='FH L10 A:43096 T:43096 P:26433,26590 I:26818'
G[26435]='FH L10 A:43096 T:43849 P:26434,26592 I:26821'
G[26436]='L30 A:42467 T:42469 P:26871'
G[26437]='L30 A:42469 T:42469 P:26436'
G[26438]='L30 A:42469 T:42469 P:26436'
G[26439]='L30 A:43344 T:43344 P:26436'
G[26440]='L30 A:43116 T:43116 P:26439 O:28869'
G[26441]='L30 A:43116 T:42469 P:26440'
G[26442]='fA K2 L10 A:5494 T:5494 P:PF001 I:29321,29323,29324,29325,29342,29343,29344,29347,29350,29359,26414,26420,26488,26536'
G[26443]='FA L7 A:100023777 T:17303 P:B13766'	-- TODO: Verify that P:C13766 is not in fact the proper prerequisite.  Basically, turn in 13766 and see if the plans still drop
G[26444]='FA L7 A:17303 T:17303'
G[26445]='FA L7 A:17303 T:17303 P:26443'
G[26446]='FA L7 A:17310 T:17310'
G[26447]='FH L7 A:100023797 T:17355'
G[26448]='FH L7 A:17355 T:17355'
G[26449]='FH L7 A:17355 T:17355 P:26447'	-- was rumored to be gone, but may be back: http://us.battle.net/wow/en/forum/topic/6490460407
G[26450]='FH L10 A:43095 T:43095 O:26404 I:26820'
G[26451]='L1 A:43099 T:43099'
G[26452]='K258 L1 A:43099 T:43099 P:26451'
G[26453]='FA L7 A:17106 T:17291'
G[26454]='FA L7 A:17291 T:17310 O:26453'
G[26455]='FA L7 A:3848 T:3848'
G[26456]='FA L7 A:3880 T:14733 P:13935'
G[26457]='FA L7 A:17287 T:17287'
G[26459]='L10 E21655'
G[26462]='FA L10 A:43108 T:43108'
G[26463]='FA L7 A:3847 T:3891 P:13623'
G[26464]='FA L7 A:3891 T:3847 P:26463'
G[26465]='L7 A:3846 T:3846 O:13617'
G[26466]='L7 A:3846 T:3846 P:26465'
G[26467]='FA L7 A:3901 T:3920'
G[26468]='FA L7 A:3920 T:3901 P:26467'
G[26469]='FA L7 A:3901 T:3901 P:26468'
G[26470]='FA L7 A:3885 T:3885 O:13964'
G[26472]='FA L7 A:33777 T:33777 P:13792'
G[26473]='FA L7 A:33204 T:33204'
G[26474]='FA L7 A:3847 T:3894 P:13642'
G[26475]='FA L7 A:3894 T:3894 P:26474'	-- after about 10 seconds
G[26476]='FA L7 A:3691 T:3916 P:26475'
G[26477]='FA L7 A:3916 T:3916 P:26476'
G[26478]='FA L7 A:3916 T:3916 P:26477'
G[26479]='FA L7 A:3916 T:3691 P:26478'
G[26480]='FA L7 A:3691 T:3897 P:26479'
G[26481]='FA L7 A:3897 T:3897 P:13989'
G[26482]='FA L7 A:3897 T:3691 P:26481'
G[26483]='FA L10 A:43108 T:43108'
G[26484]='L30 A:42573 T:43071 P:26413'
G[26485]='FA L10 A:43109 T:43109'
G[26486]='FA L10 A:43109 T:43109'
G[26487]='FH L10 A:43095 T:43095 I:26819,26489'
G[26488]='K2 L10 A:5494 T:5494 P:PF001 I:29321,29323,29324,29325,29342,29343,29344,29347,29350,29359,26414,26420,26442,26536'
G[26489]='FH L10 RG A:43095 T:43095 I:26819,26487'
G[26490]='FA L10 A:43109 T:43109 P:26462+26483'
G[26491]='FA L10 A:43108 T:43108 P:26462+26483'
G[26492]='FA L10 A:43108 T:43108 P:26462+26483'
G[26493]='FH L10 A:43095 T:43095 P:26450+26487|26489 I:26822'	-- it seems 26487 required so verify 26450 is required
G[26494]='FH L10 A:43095 T:43097 P:26493'
G[26495]='FH L10 A:43095 T:43098 P:26493 I:26808'
G[26496]='FA L10 A:43108 T:43157 P:26491+26492'
G[26497]='FA L10 A:43157 T:43157 O:26496'
G[26498]='FA L10 A:43157 T:43157 P:26497'
G[26499]='L30 A:43071 T:43071 P:27935,27936'
G[26500]='L30 A:43160 T:43160 P:27935,27936'
G[26501]='L30 A:43071 T:43168 P:26499'
G[26502]='L30 A:43160 T:43169 P:26500'
G[26503]='FA L7 A:464 T:464 O:26365,28563'
G[26504]='FA L7 A:1204344 T:464'
G[26505]='FA L7 A:464 T:344 P:26503'
G[26506]='FA L7 A:379 T:379'
G[26507]='L30 A:42469 T:43116 P:26441'
G[26508]='FA L7 A:8965 T:8962'
G[26509]='FA L7 A:342 T:342'
G[26510]='FA L7 A:344 T:344'
G[26511]='FA L7 A:900 T:900'
G[26512]='FA L7 A:344 T:-100049,344 P:26510'
G[26513]='FA L7 A:382 T:382 P:26510'
G[26514]='FA L7 A:-49,344 T:-49,344 P:26512'
G[26515]='FA L10 A:43157 T:43157 P:26518'
G[26516]='FA L10 A:43157 T:43157 P:26498'
G[26517]='FA L10 A:43156 T:43156 P:26515'
G[26518]='FA L10 A:43157 T:43157'
G[26519]='FA L7 A:100058898 T:1204351 P:26512'	-- There is a P: because hunting tons beforehand dropped none, while afterwards item drops tons of times.  Assumption is this P:, but it could be another.
G[26520]='FA L7 N30 A:1204351 T:344 P:26519'
G[26521]='FA L10 A:43156 T:43156'
G[26522]='L15 E21655'
G[26523]='FA L10 A:43156 T:43156'
G[26524]='FA L10 A:43156 T:43156 P:26521+26523'
G[26525]='FA L10 A:43156 T:43156 P:26517'
G[26526]='FA L10 A:43156 T:43156 P:26517'
G[26528]='FA L10 A:43200 T:43200 P:27625+27626'
G[26529]='FA L10 A:43200 T:43200 P:26528'
G[26530]='FA L10 A:43200 T:43200 P:26529'
G[26531]='FA L10 A:43200 T:43298 P:26530'
G[26532]='FA L10 A:43298 T:5636 P:26531'
G[26533]='FH L10 A:43097 T:43097 P:26494 I:26815'
G[26534]='FH L10 A:43097 T:43097 P:26533'
G[26535]='FH L10 A:43097 T:43097 P:26534 I:26816'
G[26536]='fA K2 L10 A:5494 T:5494 P:PF001 I:29321,29323,29324,29325,29342,29343,29344,29347,29350,29359,26414,26420,26442,26488'
G[26537]='L30 A:43168 T:43168 P:26501'
G[26538]='FH L30 A:43193 T:43191 P:26388'
G[26539]='FH L30 A:42978 T:43187 P:26388'
G[26540]='FH L30 A:43191 T:43193 P:26538'
G[26542]='FA L10 M033 A:1,2700,1207320 T:5636'
G[26543]='K2 L10 A:43239 T:43239 P:PF001 I:26556,26557,26572,26588,29317,29319,29320,29322,29345,29346,29348,29349,29354,29361'
G[26544]='FA L7 A:-49,344 T:-49,344 P:26514'
G[26545]='FA L7 A:-49,344 T:344 P:26544'
G[26546]='FA L10 A:5636 T:5636'
G[26547]='FA L10 A:5636 T:5636'
G[26548]='FA L10 A:5636 T:43108 P:26546+26547'
G[26549]='FH L30 A:43187 T:43190 P:26539'
G[26550]='FH L10 A:43098 T:43098 P:26495 I:26809'
G[26551]='FH L10 A:43098 T:0 P:26550 I:26810'
G[26552]='FH L10 A:-210 T:0 P:26551 I:26811'
G[26553]='FH L10 A:-100050 T:-50 P:26552 I:26812'
G[26554]='FH L10 A:-50 T:-50 P:26553 I:26813'
G[26555]='FH L10 A:-50 T:43098 P:26554 I:26814'
G[26556]='K2 L10 A:43239 T:43239 P:PF001 I:26543,26557,26572,26588,29317,29319,29320,29322,29345,29346,29348,29349,29354,29361'
G[26557]='K2 L10 A:43239 T:43239 P:PF001 I:26543,26556,26572,26588,29317,29319,29320,29322,29345,29346,29348,29349,29354,29361'
G[26558]='FH L10 A:42898 T:43299 P:26418'
G[26559]='L10 E21655'
G[26560]='FA L7 A:43300 T:43272 P:26587'
G[26561]='FA L7 A:43305 T:43274 P:26560'
G[26562]='FA L7 A:43303 T:43275 P:26561'
G[26563]='FA L7 A:43302 T:43221 P:26562'
G[26564]='L30 A:43169 T:43169 P:26502'
G[26566]='FA L1 A:42317 T:42553 P:26208'
G[26567]='FA L7 A:43221 T:43184 P:26545'
G[26568]='FA L7 A:43184 T:43221 P:26567'
G[26569]='FA L7 A:43194 T:43194 P:26520+26568'
G[26570]='FA L7 A:500382 T:500382 P:26568'
G[26571]='FA L7 A:43221 T:-49,43221 P:26568'
G[26572]='K2 L10 A:43239 T:43239 P:PF001 I:26543,26556,26557,26588,29317,29319,29320,29322,29345,29346,29348,29349,29354,29361'
G[26573]='FA L7 A:-49,43221 T:43221 P:26571'
G[26574]='FA L15 A:39653 T:39725'
G[26575]='L30 A:42469 T:42469 P:26441'
G[26576]='L30 A:42469 T:42466 P:26575+26507'
G[26577]='L30 A:42469 T:42472 P:26575+26507'
G[26578]='L30 A:42472 T:42472 P:26577'
G[26579]='L30 A:42472 T:42472 P:26577'
G[26580]='L30 A:42472 T:43395 P:26577'
G[26581]='L30 A:43395 T:43395 P:26580'
G[26582]='L30 A:43395 T:42472 P:26581'
G[26583]='L30 A:43442 T:43442 P:26582'
G[26584]='L30 A:42472 T:42472 P:26582'
G[26585]='L30 A:42472 T:42472 P:26582'
G[26586]='FA L7 A:43221 T:43270 P:26568'
G[26587]='FA L7 A:43270 T:43270 P:26586'
G[26588]='K2 L10 A:43239 T:43239 P:PF001 I:26543,26556,26557,26572,29317,29319,29320,29322,29345,29346,29348,29349,29354,29361'
G[26589]='FH L15 A:36487 T:39377 P:14346+14394'
G[26590]='FH L10 A:43096 T:43096 I:26433,26817'	-- Belf Pally got this
G[26591]='L30 A:43319 T:43319 P:26502+26501'
G[26592]='FH L10 A:43096 T:43096 P:26433,26590'
G[26593]='L10 A:2501 T:2502'
G[26594]='L10 A:2502 T:2501 P:26593'
G[26595]='L10 A:2501 T:2501 P:26594'
G[26596]='FA L15 A:48808 T:3391'
G[26597]='L10 A:2486 T:2486'
G[26598]='SP K1 L10 A:1449 T:1449 P:B26597'
G[26599]='L10 A:2500 T:2500'
G[26600]='L10 A:2500 T:2500 P:26599'
G[26601]='L10 A:2500 T:2500 P:26602'
G[26602]='L10 A:2500 T:2500 P:26600'
G[26603]='L10 A:1204406 T:2634'
G[26604]='L10 A:2634 T:2634 P:26603'
G[26605]='L10 A:2634 T:2634 P:26604'
G[26606]='L10 A:2634 T:2634 P:26605'
G[26607]='FA L7 A:43221 T:43184 P:26563+26573'
G[26608]='FH L30 A:43190 T:42978 P:26549'
G[26609]='L10 A:2490 T:1002083 P:26595,26601,26606'
G[26610]='L10 A:1002083 T:2490 P:26609'
G[26611]='L10 A:2490 T:2496 P:26610'
G[26612]='L10 A:2496 T:2496 P:26611'
G[26613]='L10 A:2488 T:2488 P:26611'
G[26614]='L10 A:2493 T:2493 P:26611'
G[26616]='FA L7 A:43184 T:43458 P:26607'
G[26617]='L10 A:100059143 T:2487'
G[26618]='FA L10 A:264 T:264 O:26728,28564'
G[26619]='FH L30 A:43193 T:43581 P:26540+26608'
G[26620]='FA L10 A:272 T:272'
G[26621]='FH L30 A:43581 T:43581 P:26619'
G[26622]='FH L30 A:43581 T:43943 P:26621'
G[26623]='FA L10 A:272 T:272'
G[26624]='L10 A:2496 T:43504 P:26612'
G[26625]='L30 A:43168 T:43168 P:26537+26564+26591'
G[26627]='FA L10 A:264 T:289 P:26618'
G[26628]='L10 A:2610 T:2610 P:26052'
G[26629]='L10 A:43504 T:43504 P:26624'
G[26630]='L10 A:2487 T:2487 P:B26629'
G[26631]='L10 A:43504 T:2548 P:26629'
G[26632]='L30 A:45043 T:43897 P:27126'
G[26633]='L10 A:2548 T:2548 P:26631'
G[26634]='L10 A:2549 T:2549 P:26631'
G[26635]='L10 A:2545 T:2545 P:26631'
G[26636]='FA L7 A:43461 T:43461 P:26616'
G[26637]='FA L7 A:43459 T:43459 P:26616'
G[26638]='FA L7 A:43462 T:43462 P:26616'
G[26639]='FA L7 A:43458 T:43508 P:26616'
G[26640]='FA L7 A:43508 T:43458 P:26639'
G[26641]='FA L10 A:43200 T:43200 P:27625+27626'
G[26642]='fH L5 A:35068 T:3337 I:28494'	-- Z16826
G[26643]='FA L10 A:43200 T:43200 P:26641'
G[26644]='L10 A:2548 T:2546 P:26633+26634+26635'
G[26645]='FA L10 A:264 T:264 P:26618'
G[26646]='FA L7 A:43458 T:-49,43458 P:26636+26637+26638+26640'
G[26647]='L10 A:2547 T:2547 P:26644'
G[26648]='L10 A:43556 T:-210 P:26644'
G[26649]='L10 A:2547 T:2547 P:26647'
G[26650]='L10 A:2546 T:1204450 P:26648'
G[26651]='FA L7 A:-49,43458 T:43611 P:26646'
G[26652]='FA L10 A:265 T:302 P:26653'
G[26653]='FA L10 A:289 T:265 O:26627'
G[26654]='FA L10 A:302 T:265 P:26652'
G[26655]='FA L10 A:265 T:289 P:26654'
G[26656]='L30 A:42466 T:42466 P:26576'
G[26657]='L30 A:42466 T:42466 P:26656'
G[26658]='L30 A:42466 T:42466 P:26656'
G[26659]='L30 A:42466 T:542466 P:26657+26658'
G[26660]='FA L10 A:289 T:273 P:26655'
G[26661]='FA L10 A:273 T:273 P:26660'
G[26662]='L10 A:1204450 T:-210,1204450 P:26650'
G[26663]='L10 A:1204450 T:-210,1204450 P:26650'
G[26664]='L10 A:1204450 T:-210,1204450 P:26650'
G[26665]='L10 A:-210,1204450 T:2496 P:26662+26663+26664'
G[26666]='FA L10 A:43453 T:267'
G[26667]='FA L10 A:267 T:267 P:26666'
G[26668]='FA L7 A:43611 T:43611 P:26651'
G[26669]='FA L10 A:267 T:267 P:26667'
G[26670]='FA L10 A:267 T:267 P:26669'
G[26671]='FA L10 A:267 T:43453 P:26670'
G[26672]='FA L10 A:43453 T:265 P:26671'
G[26673]='L15'	-- this has a tooltip that shows that it does the same as 26672, but what triggers its completion?
G[26674]='FA L10 A:265 T:43453 P:26672'
G[26675]='L5 E21655'
G[26676]='FA L10 A:273 T:289 P:26661'
G[26677]='FA L10 A:289 T:289 P:26680'
G[26678]='L10 A:2496 T:1204578 P:26665'
G[26679]='L10 A:1204578 T:2496 P:26678'
G[26680]='FA L10 A:289 T:289 P:26676'
G[26681]='FA L10 A:289 T:263 P:26677'
G[26682]='FH L15 A:4926 T:4926'	-- P:26701 not correct
G[26683]='FA L10 A:276 T:302 P:26618'
G[26684]='FA L10 A:302 T:276 P:26683'
G[26685]='FA L10 A:276 T:276 P:26684'
G[26686]='FA L10 A:264 T:264 P:26645'
G[26687]='L15 A:39118 T:4944 P:25182'
G[26688]='FA L10 A:663 T:663'
G[26689]='FA L10 A:663 T:663 P:26688'
G[26690]='FA L10 A:663 T:663 P:26689'
G[26691]='FA L10 A:663 T:661 P:26690'
G[26692]='FA L7 A:43607 T:-49,43607 P:26668'
G[26693]='FA L7 A:43611 T:-49,43611 P:26668'
G[26694]='FA L7 A:-49,43611 T:43611 P:26693'
G[26695]='L10 A:2496 T:2496 P:26679'
G[26696]='FH L15 A:48797 T:3391'
G[26697]='L10 A:2496 T:2496 P:26695'
G[26698]='L10 A:2496 T:502487 P:26679'
G[26699]='L10 A:502487 T:2496 P:26698'
G[26700]='L10 A:502487 T:2496 P:26698'
G[26701]='FH L15 A:3391 T:4926 P:26696'	-- report of this not being available after completing 26696 (could it be related to 26682) -- once turned in 28554 this should still be available but if you accept 26682 it will not be; thus I think 26682 should have O:26701
G[26702]='FA L15 A:3391 T:23566 P:26596 I:28552'
G[26703]='L10 A:2496 T:2496 P:26697+26699+26700'
G[26705]='FH L0 RG T:36470'
G[26706]='FA L1 RW A:43727 T:43727 P:24681'
G[26707]='L10 A:43738 T:43738'
G[26708]='FA L7 A:43733 T:543733 P:26694'
G[26709]='L30 A:43792 T:42465 P:26971'
G[26710]='K2 L30 A:44945 T:44945 P:26709 I:27048,28488'
G[26711]='FH L1 RG GF A:35054 T:35120,535120 P:14071'	-- this also sets 26712
G[26712]='FH L1 RG GM A:35053 T:35120,535120 P:14071'	-- this also sets 26711
G[26713]='FA L7 A:543733 T:-49,543733 P:26708'
G[26714]='FA L7 A:-49,543733 T:543733 P:26713'
G[26715]='L5 E21655'
G[26717]='FA L10 A:43738 T:43738 O:26785'
G[26719]='FA L10 A:43738 T:43730 P:26717'
G[26720]='FA L10 A:43730 T:43730 P:26719'
G[26721]='FA L10 A:288 T:288'
G[26722]='FA L10 A:1204824 T:1204825 P:26753'
G[26723]='FA L10 A:43861 T:43861 P:26760'
G[26724]='FA L10 A:43861 T:43731 P:26723'
G[26725]='FA L10 A:43731 T:1204817 P:26724'
G[26726]='FA L7 A:543733 T:344 P:26714'
G[26727]='FA L10 A:263 T:263 P:26681'
G[26728]='FA L10 M023 A:900 T:264 I:28564'
G[26729]='FA L10 A:43885 T:543885 P:26736'	-- not PC code, but P code and required to leave the area before they appear
G[26730]='FA L10 A:543885 T:543885 P:26729'
G[26731]='FA L10 A:543885 T:543885 P:26730'
G[26732]='FA L10 A:739 T:739 OCC:28855'
G[26733]='FA L10 A:739 T:739 P:26732'
G[26734]='FA L10 A:739 T:739 P:26733'
G[26735]='FA L10 A:469 T:469 O:26838,28699'
G[26736]='FA L10 A:469 T:469 P:26735'
G[26737]='FA L10 A:469 T:469 P:26736'
G[26738]='FA L10 AP:-50:X26317;1422:26317 T:1422 P:28855'
G[26739]='FA L10 A:1422 T:1422 P:26738 I:26321'
G[26740]='FA L10 A:770 T:773'
G[26741]='FA L10 E31961'
G[26742]='FA L10 A:43886 T:43886 P:26736'
G[26743]='FA L10 A:43886 T:43886 P:26742'
G[26744]='FA L10 A:1422 T:1422 P:26739'
G[26745]='FA L10 A:42736 T:43884 P:26736+26739'
G[26746]='FA L10 A:43884 T:43884 P:26745'
G[26747]='FA L10 A:43884 T:43884 P:26746'
G[26748]='FA L10 A:42790 T:42790 P:26747'
G[26749]='FA L10 A:43884 T:44017 P:26748 I:26350'
G[26750]='L30 A:42472 T:42465 P:26584+26585+26659'
G[26751]='FA L10 A:733 T:733 P:26746'
G[26752]='L30 A:42465 T:43809 P:26750'
G[26753]='FA L10 A:1204817 T:1204824 P:26725'
G[26754]='FA L10 A:1204825 T:43861 P:26722'
G[26755]='L30 A:43897 T:43897 P:26632'
G[26760]='FA L10 A:43730 T:43730 P:26720'
G[26761]='L5 A:234 T:344 P:26370'
G[26762]='L30 A:43897 T:43897 P:26755'
G[26763]='FA L10 A:773 T:773 P:26740 I:26403'
G[26765]='FA L10 A:773 T:770 P:26763'
G[26766]='L30 A:44010 T:44010 P:27061'
G[26767]='L30 E21655'
G[26768]='L30 A:44010 T:44010 P:27061'
G[26769]='FH L5 A:3391 T:34698 P:14050'
G[26770]='L30 A:43898 T:43898 P:26755'
G[26771]='L30 A:44010 T:44010 P:26766+26768'
G[26772]='FA L10 A:44017 T:44017 P:26749 I:26351'
G[26773]='FA L10 A:44017 T:44017 P:26772 I:26359'
G[26774]='FA L10 A:44017 T:44017 P:26773 I:26360'
G[26775]='FA L10 A:44017 T:44017 P:26774 I:26362'
G[26776]='FA L10 A:44017 T:44021 P:26775 I:26386'
G[26777]='FA L10 A:43731 T:43731'
G[26778]='FA L10 A:43731 T:43731 P:26760'
G[26779]='FA L10 A:44021 T:44021 P:26773 I:26405'
G[26780]='FA L10 A:44043 T:44043 P:26773 I:26304'
G[26781]='FA L10 A:44019 T:44019 I:26303'
G[26782]='FA L10 A:44018 T:44018 I:26399,26412,26783'	-- L85 elf hunter got this one
G[26783]='FA L10 A:44018 T:44018 I:26399,26412,26782'	-- not sure why this exists with 26782 there...draenei hunter got 26782
G[26784]='FH L30 A:44024 T:44024 P:26786'
G[26785]='L10 A:43453 T:43738 P:26674'
G[26786]='FH L30 A:43943 T:44024 P:26622'
G[26787]='L10 A:288 T:288 P:26721'
G[26788]='FH L30 A:44042 T:44042 P:26622'
G[26789]='L1 E21655'
G[26791]='L30 A:44143 T:44143 P:26834'
G[26792]='L30 A:44143 T:44143 P:26834'
G[26793]='FA L10 A:1000061 T:268'
G[26794]='FA L10 A:268 T:264 P:26793'
G[26795]='FA K512 L10 A:264 T:264 P:26794'	-- PM3
G[26796]='FA L10 A:264 T:576 P:26795'
G[26797]='FA L10 A:576 T:1000061 P:26796'
G[26798]='FH L30 A:44024 T:39605 P:26784+26788'
G[26799]='FH L1 RU A:1568 T:1568 P:28608'
G[26800]='FH L1 A:1740 T:1740 P:25089'
G[26801]='FH L1 A:1569 T:1569 O:28653'
G[26802]='FH L1 A:1570 T:1570 P:28672'
G[26803]='FH L1 RG A:3144 T:3310'
G[26804]='L1 A:3310 T:3139 P:26803'
G[26805]='FA L10 A:44018 T:44082 I:28702'
G[26806]='FH L1 RG A:3139 T:41140 P:26804'
G[26807]='FH L1 RG A:41140 T:3144 P:26806'
G[26808]='FA L10 A:44083 T:44084 P:26819 I:26495'
G[26809]='FA L10 A:44084 T:44084 P:26808 I:26550'
G[26810]='FA L10 A:44084 T:-100210 P:26809 I:26551'
G[26811]='FA L10 A:-210 T:-100050 P:26810 I:26552'
G[26812]='FA L10 A:-100050 T:-50 P:26811 I:26553'
G[26813]='FA L10 A:-50 T:-50 P:26812 I:26554'	-- technically turned in after porting which is at 37:82.11,35.37 (for T:)
G[26814]='FA L10 A:-50 T:44084 P:26813 I:26555'	-- the A: location is really the T: from 26813
G[26815]='FA L10 A:44099 T:44099 P:26817 I:26533'
G[26816]='FA L10 A:44099 T:44099 P:26815 I:26535'
G[26817]='FA L10 A:44099 T:44099 P:26823 I:26433,26590'
G[26818]='FA L10 A:44083 T:44083 P:26823 I:26434'
G[26819]='FA L10 A:44083 T:44083 P:26823 I:26487,26489'
G[26820]='FA L10 A:44083 T:44083 P:26823 I:26450'
G[26821]='FA L10 A:44082 T:44112 P:26824 I:26435'
G[26822]='FA L10 A:44100 T:44100 I:26493'
G[26823]='FA L10 A:44099 T:44099 P:26825,26826'
G[26824]='FA L10 A:44099 T:44082 P:26815'
G[26825]='FA L10 A:44082 T:44099 O:28702 I:26826'	-- L85 elf hunter got this one
G[26826]='FA L10 A:44082 T:44099 I:26825'
G[26827]='L30 A:43809 T:43065 P:26752'
G[26828]='L30 A:43065 T:44025 P:26827'
G[26829]='L30 A:44025 T:44025 P:26828'
G[26830]='FH L30 A:39605 T:39605 P:26798'
G[26831]='L30 A:44080 T:44080,42614 P:26828'	-- yes, can be turned into either!
G[26832]='L30 A:44025 T:44025 P:26828'
G[26833]='L30 A:44025 T:43818 P:26829+26832+26831'
G[26834]='L30 A:43897 T:44143 P:26762+26770'
G[26835]='L30 A:44143 T:43897 P:26791+26792'
G[26836]='L30 A:43897 T:43897 P:26835'
G[26837]='FA L10 E31961'
G[26838]='FA L10 A:3885,43731 T:469 I:28699'
G[26839]='FA L10 E31961'
G[26840]='FH L30 A:39605 T:44169 P:26830'
G[26841]='FA L5 RE CM A:2077,502079 T:43006 P:28714+28715 Z22248'
G[26842]='FA L5 A:1340 T:1340 O:26176'
G[26843]='FA L5 A:1343 T:1343 O:13636'
G[26844]='FA L5 A:1343 T:1343 P:26843'
G[26845]='FA L5 A:1343 T:1343 P:26844'
G[26846]='L5 A:44200 T:44200 P:26844'
G[26847]='L1'
G[26848]='L1'
G[26849]='L1'
G[26850]='L1'
G[26851]='L1'
G[26852]='L1'
G[26853]='L1'
G[26854]='FA L5 A:1960 T:1002059'
G[26855]='FA L5 A:1002059 T:1960 P:26854'
G[26856]='L7 A:44217 T:44217 P:26865,26866,26867,28003 Z16016'
G[26857]='L30 A:44010 T:44010 P:26771'
G[26858]='L7 A:44217 T:44217 Z16016'
G[26859]='L5 E21655'
G[26860]='FA L5 A:1963 T:1963'
G[26861]='L30 A:44222 T:44222 P:26771'
G[26862]='L7 A:44216 T:44216 Z16016'
G[26863]='FA L5 A:1343 T:1343 P:26844'
G[26864]='FA L5 A:1343 T:1340 P:26845'
G[26865]='K64 L7 A:39605 T:44217 I:26866,26867,28003 Z16016'
G[26866]='K64 L7 A:36648 T:44217 I:26865,26867,28003 Z16016'
G[26867]='K64 L7 A:10181 T:44217 I:26865,26866,28003 Z16016'
G[26868]='FA L5 A:44345 T:44345 P:26928'
G[26869]='L30 A:-207,42467 T:1204959 P:26426'
G[26870]='L8 A:5768 T:5768'
G[26871]='L30 A:1204959 T:42467 P:26869'
G[26872]='L8 A:5767 T:5767'
G[26873]='L8 A:5767 T:5767'
G[26875]='L30 A:43818 T:0,43835 P:26833'
G[26876]='L30 A:44010 T:43065 P:26857+26861'
G[26877]='L1'
G[26878]='L8 A:3448 T:5767'
G[26879]='L10'
G[26880]='L0 E21655'
G[26881]='FA L10 A:33256 T:4787 Z18545'
G[26882]='FA L5148 A:4787 T:33256 P:26881 Z18545'
G[26883]='FA L5148 A:33260 T:33260 Z18545'
G[26884]='L5146 A:33258 T:33258 Z18545'
G[26885]='FA L5145 A:33261 T:33261 Z18545'
G[26886]='FA L15 A:38704 T:38704 P:25052'
G[26887]='FA L15 A:38704 T:38704 P:25054'
G[26888]='L5147 A:12736 T:12736 Z18545'
G[26889]='FA L15 A:38704 T:38706 P:25166'
G[26890]='FH L7 A:34303 T:34303'
G[26891]='L5146 A:12736 T:12736 Z18545'
G[26892]='L5146 A:44375 T:44375 Z18545'
G[26893]='L10'
G[26894]='L10 A:34122 T:74408'
G[26895]='FA L15 A:38578 T:39034'
G[26896]='FH L15 A:44374 T:39034'
G[26897]='L10 A:3845 T:75606 I:26898'
G[26898]='L10 A:3691 T:75606 I:26897'
G[26899]='FH L5148 A:44387 T:44387 Z18545'
G[26900]='L15 E21655'
G[26901]='L10 A:44402 T:544402'
G[26902]='L0 T:38432 J:O24897'
G[26903]='L7715 A:4508 T:504508 Z19033'
G[26904]='FA L5 RF CL A:43455 T:43455 Z27101'
G[26905]='L10 A:44415 T:544415 P:26906'
G[26906]='L10 A:44402 T:44415'
G[26907]='L10 A:44402 T:544402'
G[26908]='L10 A:37812 T:44402'
G[26909]='L10 A:2787 T:1138492'
G[26910]='FA L5 CH A:197 T:43278 P:28759 Z18505'
G[26911]='FH L10 A:1002702 T:2787 P:26042'	-- see comment in quest 26346
G[26912]='FH K512 L10 A:2787 T:1138492 P:26911'	-- PM2
G[26913]='FA L515 RH CW A:911 T:911 P:3100 Z18505'
G[26914]='FA L515 RH CL A:459 T:459 P:3105 Z18505'
G[26915]='FA L5 RH CR A:915 T:915 P:3102 Z18505'
G[26916]='FA L5 RH CM A:198 T:198 P:3104 Z18505'
G[26917]='FA L515 RH CH A:43278 T:43278 P:26910 Z18505'
G[26918]='FA L515 RH CP A:925 T:925 P:3101 Z18505'
G[26919]='FA L5 RH CT A:375 T:375 P:3103 Z18505'
G[26920]='FH L15 A:10837 T:44452 I:28508,28575,28750'
G[26921]='FH L15 A:44452 T:44452 O:26920,28508,28575,28750'
G[26922]='FH L15 A:44462 T:44462'
G[26923]='FH L15 A:44466 T:44466'
G[26924]='FH L15 A:44452 T:44452 P:26922+26923+26921'
G[26925]='FH L15 A:44462 T:44452 P:26922'
G[26926]='FH L15 A:44452 T:10837 P:26924+26925+27117'
G[26927]='FA L5 A:1340 T:44345 P:26864'
G[26928]='FA L5 A:44345 T:44345 P:26927'
G[26929]='FA L5 A:44345 T:44345 P:26927'
G[26930]='FH L15 A:10837 T:10837 P:26926'
G[26931]='FH L15 A:11055 T:11055'
G[26932]='FA L5 A:1340 T:1340 P:26927'
G[26933]='FH L15 A:11055 T:11055 P:26931'
G[26934]='FH L15 A:11057 T:11057'
G[26935]='L15 A:44454 T:11616 P:26999'
G[26936]='FH L15 A:10837 T:10837 P:26930+26978'
G[26937]='FH L15 A:44466 T:44466 P:26979'
G[26938]='FH L15 A:45098 AH:44466 T:44466 P:26937'
G[26939]='FA L10 A:44556 T:44560 O:26943,26944'
G[26940]='FA L515 RE CM A:43006 T:43006 P:26841 Z22248'
G[26941]='FA L10 A:44560 T:44561 P:26939'
G[26942]='FA L10 A:44561 T:44563 P:26941'
G[26943]='FA K64 L10 A:2789 T:44556 I:26944'
G[26944]='L10 A:44018 T:44556 I:26943'
G[26945]='L5 RE CW A:3593 T:3593 P:3116 Z22248'
G[26946]='FA L5 RE CR A:3594 T:3594 P:3118 Z22248'
G[26947]='FA L515 RE CH A:3596 T:3596 P:3117 Z22248'
G[26948]='FA L515 RE CD A:3597 T:3597 P:3120 Z22248'
G[26949]='L5 RE CT A:3595 T:3595 P:3119 Z22248'
G[26950]='L6686 A:44637 T:44637 Z15595'
G[26951]='L1 E21655'
G[26952]='FH L15 A:10839 T:44454 P:26933 I:27150'
G[26953]='L15 A:44456 T:44456'
G[26954]='L15 A:44456 T:44456 P:26953'
G[26955]='L15 A:44456 T:44456 P:27057'
G[26956]='L15 A:44457 T:44457'
G[26957]='L15 A:44905 T:44458'
G[26958]='FA L5 RD CW A:16503 T:16503 Z18505'
G[26959]='L7457 A:44660 T:44660 Z15595'
G[26960]='FA L84 A:29611 T:29611 O:28716 Z27009'
G[26961]='FA L5 A:1345 T:1345'
G[26962]='L8228 A:44690 T:44690 Z15595'
G[26963]='FA L5 RD CH A:16499 T:16499 Z18505'
G[26964]='FH L5 A:1515 T:44615 I:28568'
G[26965]='FH L5 A:44615 T:44615 O:26964,28568'
G[26966]='FA L515 RD CP A:16501 T:16501 Z18505'
G[26967]='L15 A:44706 T:44706 Z15595'
G[26968]='FA L5 RD CM A:16500 T:16500 Z18505'
G[26969]='FA L515 RD CS A:17089 T:17089 Z18505'
G[26970]='FA L515 RD CT A:16502 T:16502 Z18505'
G[26971]='L30 A:-207,43835 T:43835 P:26875'
G[26972]='L6686 A:44728 T:44728 Z15595'
G[26973]='L7457 A:44738 T:44738 Z15595'
G[26974]='L8228 A:44741 T:44741 Z15595'
G[26975]='FA L84 A:29611 T:44749 P:26960'
G[26976]='L8999 A:44746 T:44746 Z15595'
G[26977]='FA L84 A:29611 T:2439 P:26960'
G[26978]='FH L15 A:11057 T:11057 P:26934'
G[26979]='FH L15 A:10837 T:44466 P:26936+26978'
G[26980]='FA L10 A:2104 T:41415 P:25801+25819'
G[26981]='FA L10 A:41415 T:41411 P:25868'
G[26982]='K64 L15 A:2700 T:44728 Z15595'	-- an arbitrary date for removal
G[26983]='L15 A:39084 T:44738 Z15595'
G[26984]='L15 A:44019 T:44741 Z13329'
G[26985]='L10 A:3936 T:44746 Z13329'
G[26986]='L7198 A:12920 T:44637 Z15595'
G[26987]='fH L15 A:14741 T:44660 Z15595'
G[26988]='L15 A:14739 T:44690 Z15595'
G[26989]='FH L5 A:44615 T:44615 P:26965'
G[26990]='FH L30 A:42600 T:5769 Z13329'
G[26991]='K64 L9510 A:4791 T:44706 Z15595'	-- an arbitrary date for removal
G[26992]='FH L5 A:44778 T:44778 P:26965'
G[26993]='L7457 A:44800 T:44800 Z13329'
G[26994]='L8228 A:44804 T:44804 Z15595'
G[26995]='FH L5 A:44784 T:44784 P:26965'
G[26996]='L8999 A:44805 T:44805 Z15595'
G[26997]='L84 A:2439 T:44293 P:26977'
G[26998]='FH L5 A:44784 T:44784 P:26992+26995'
G[26999]='L15 A:44454 T:44454 O:26952,27150,27175,27233'
G[27000]='L15 A:11616 T:11616 O:26935'
G[27001]='L15 A:11616 T:11616 P:27000'
G[27002]='L15 A:11616 T:44441 P:27001'
G[27003]='L30 A:44833 T:46873 O:28295,28296,28557,28558'	-- this override exists because Blizzard no longer requires the leadins (at least for instant 90s), therefore P: is now O:
G[27004]='FA L30 A:44799 T:44799 O:27952'
G[27005]='FH L30 A:44823 T:44823 O:27953'
G[27006]='FA L30 A:44802 T:44802'
G[27007]='L30 A:-207,43065 T:0,43065 P:26260'
G[27008]='FH L30 A:44818 T:44818'
G[27009]='L10286 A:44837 T:44837 Z19033'
G[27010]='L30 A:-207,43065 T:0,43065 P:27007'
G[27011]='L15 A:44472 T:44472 P:27013'
G[27012]='L15 A:44472 T:44472 P:27013'
G[27013]='L15 A:44472 T:44472'
G[27014]='FH L5 RT CT A:44927 T:37724 Z18505'
G[27015]='FH L5 RT CP A:44927 T:37737 Z18505'
G[27016]='FA L5 A:1187 T:1187'
G[27017]='L15 A:44458 T:44458 P:26957'
G[27018]='L15 E21655'
G[27019]='L10284 A:8516 T:8516 Z19033'
G[27020]='FH L515 RT CW A:3059 T:3059 P:3091 Z18505'
G[27021]='FH L5 RT CH A:3061 T:3061 P:3092 Z18505'
G[27022]='L10285 A:8516 T:1152097 P:27019 Z19033'
G[27023]='FH L5 RT CP A:37737 T:37737 P:27015 Z18505'
G[27024]='L10284 A:44837 T:44837 Z19033'
G[27025]='FA L5 A:44859 T:44859'
G[27026]='FA L5 A:44859 T:44859 P:27025'
G[27027]='FH L5 RT CS A:3062 T:3062 P:3093 Z18505'
G[27028]='FA L5 A:1154 T:1154'
G[27029]='L10284 A:44837 T:44837 Z19033'
G[27030]='FA L5 A:1154 T:1154'
G[27031]='FA L5 A:6577 T:6577'
G[27032]='FA L5 A:6577 T:44618 P:27031'
G[27033]='FA L5 A:44618 T:6577 P:27032'
G[27034]='FA L5 A:6577 T:44870 P:27033'
G[27035]='FA L5 A:44870 T:44870 P:27034'
G[27036]='FA L5 A:1156 T:1187 P:27016'
G[27037]='FA L5 A:1187 T:1156 P:27036'
G[27038]='L84 A:44749 T:44806 P:26975'
G[27039]='FH L5 A:44789 T:1205143 P:26989+26998'
G[27040]='FA L30 A:44799 T:0 P:27004+27006'
G[27041]='FH L30 A:44823 T:0 P:27005+27008'
G[27042]='FA L30 A:44802 T:44802 P:27004+27006'
G[27043]='FH L30 A:44818 T:44818 P:27005+27008'
G[27044]='L84 A:44293 T:44807 P:26975'
G[27045]='FH L5 A:1205143 T:44789 P:27039'
G[27046]='K2 L30 A:43805 T:43805 P:26709'
G[27047]='K2 L30 A:43805 T:43805 P:26709'
G[27048]='K2 L30 A:44968 T:44968 P:26709 I:26710,28488'
G[27049]='K2 L30 A:43804 T:43804 P:26709'
G[27050]='K2 L30 A:43804 T:43804 P:26709'
G[27051]='K2 L30 A:44973 T:44973 P:26709'
G[27053]='L15 A:44454 T:1176392 P:27002'
G[27054]='L15 A:44454 T:-22,44454 P:27057'
G[27055]='L15 A:-22,44454 T:44454 P:27054'
G[27056]='FH L5 A:44789 T:44365 P:27045'
G[27057]='L15 A:1176392 T:44454 P:27053'
G[27058]='FA L30 A:-207 T:44799 P:27040'
G[27059]='FH L30 A:-207 T:44823 P:27041'
G[27060]='L84 A:44807 T:44293 P:27044'
G[27061]='L30 A:-207,43065 T:44010 P:27010'
G[27062]='L15 A:39895 T:74367'
G[27063]='L15 A:40032 T:74367'
G[27064]='L84 A:1747,44293 T:544293 P:27038'
G[27065]='FH L5 A:44365 T:44916 P:27056'
G[27066]='FH L5 RT CT A:37724 T:37724 P:27014 Z18505'
G[27067]='FH L515 RT CD A:3060 T:3060 P:3094 Z18505'
G[27068]='K64 L15 A:40712 T:40712 O:25556'
G[27069]='FH L5 A:44916 T:44916 P:27065'
G[27070]='K64 L15 A:7407 T:7407'
G[27071]='K64 L15 A:40712 T:40712'
G[27072]='L84 A:332 T:50049 P:28807'
G[27073]='FH L5 A:44917 T:44917 P:27065'
G[27074]='FA L5 A:44870 T:1073 P:27035'
G[27075]='FA L5 A:1073 T:1073 P:27074'
G[27076]='K64 L15 A:44929 T:44929'
G[27077]='FA L5 A:1073 T:1073 P:27074'
G[27078]='FA L5 A:1073 T:1073 P:27075+27077'
G[27079]='L1 E21655'
G[27080]='L1 E21655'
G[27081]='L25 E21655'
G[27082]='FH L5 A:44912 T:44912 P:27065'
G[27083]='FH L15 A:10837,45013 T:44452 P:26938+27150|26952'
G[27084]='FH L15 A:44452 T:44452 P:27083'
G[27085]='FH L15 A:44462 T:44462 P:27083'
G[27086]='FH L15 A:44452 T:44452 P:27084'
G[27087]='FH L15 A:44452 T:44466 P:27084,27086'
G[27088]='FH L5 A:44912 T:44912 P:27082'
G[27089]='FH L15 A:44451 T:45129 P:27087'
G[27090]='FH L15 A:45129 T:44451 P:27089'
G[27091]='FH L5 RB CW A:43010 T:43010 P:8329 Z21691'
G[27092]='L84 A:50049 T:1205198 P:27072'
G[27093]='FH L5 A:44916 T:44916 P:27069+27073'
G[27094]='FH L5 A:-21,44917 T:44917 P:27095'
G[27095]='L5 A:44917 T:-21,44917 P:27069+27073'
G[27096]='FH L5 A:44916 T:44365 P:27088+27093+27094'
G[27097]='FH L5 A:44365 T:-21,44365 P:27096'
G[27098]='FH L5 A:44365 T:544365 P:27099'
G[27099]='FH L5 A:-21,44365 T:44365 P:27097'
G[27100]='L30 A:100060816 T:0,43397'
G[27101]='L30 A:-207,43397 T:1205207 P:27100'
G[27102]='L30 A:1205207 T:0,43397 P:27101'
G[27103]='L15 A:44969 T:44969 O:27130'
G[27104]='L15 A:44969 T:44969 O:27130'
G[27105]='L15 A:44969 T:44969 O:27130'
G[27106]='L84 A:1205198 T:29611 P:27092'
G[27107]='K64 L15 A:44971 T:44971'
G[27108]='L15 A:44971 T:44971'
G[27109]='L15 A:44999 T:44999'
G[27110]='L15 A:14358 T:14358'
G[27111]='L15 A:14358 T:1179517 P:27110'
G[27112]='L15 A:44991 T:44991 O:27132'
G[27113]='L15 A:44991 T:14358 O:27132'
G[27114]='L15 A:14322 T:14322'
G[27115]='FA L5 A:1073 T:44870 P:27078'
G[27116]='FA L5 A:44870 T:1343 P:27115'
G[27117]='FH L15 A:44452 T:44452 P:26922'
G[27118]='K1 L15 A:1179485 T:1179485'
G[27119]='K1 L15 A:14338 T:14338'
G[27120]='K1 L15 A:14338 T:14338'
G[27122]='FA L30 E31961'
G[27123]='L30 A:45042 T:43065 P:27203'
G[27124]='L15 A:14325 T:14326'
G[27125]='L15 A:45040 T:45040 O:27133'
G[27126]='L30 A:43169 T:45043 P:26625'
G[27127]='FH L30 E21655'
G[27128]='L15 A:45052 T:45052 O:27134'
G[27129]='L15 A:40032 T:44969'
G[27130]='L15 A:7875 T:44969'
G[27131]='L15 A:40032 T:44991'
G[27132]='L15 A:7875 T:44991'
G[27133]='L15 A:3936 T:45040'
G[27134]='L15 A:39656 T:45052'
G[27135]='L30 A:42574 T:42574 P:26409'
G[27136]='L30 A:43397 T:43397'
G[27137]='L1 E21655'
G[27138]='L1 E21655'
G[27139]='FH L1 RG A:36471 T:38120 P:26705'
G[27140]='L10 E21655'
G[27141]='L30 A:44860 T:45180 P:27993'
G[27142]='L10 E21655'
G[27143]='L9771 E21655'
G[27144]='FH L15 A:44451 T:44451 P:27090'
G[27145]='L10 E21655'
G[27146]='L10 E21655'
G[27147]='L10 E21655'
G[27148]='L9772 E21655'
G[27149]='L15 E21655'
G[27150]='FH L15 T:44454 I:26952 Z19678'	-- TODO: Need the A: for this
G[27151]='L15 A:45147 T:-22,45147 P:27002'
G[27152]='L15 A:-22,45147 T:-22,45147 P:27151'
G[27153]='L15 A:-22,45147 T:-22,45147 P:27152'
G[27154]='L15 A:-22,45147 T:-22,45147 P:27153'
G[27155]='L15 A:-22,45147 T:44441 P:27154'
G[27156]='L15 A:45157 T:45157'
G[27157]='L15 A:45157 T:45157 P:27156'
G[27158]='FA L15 A:10838 T:44453 I:28505,28576,28749'
G[27159]='FA L15 A:44453 T:44453 O:27158,28505,28576,28749'
G[27160]='FA L15 A:44471 T:44471'
G[27161]='FA L15 A:44467 T:44467'
G[27162]='FA L15 A:44453 T:44453 P:27159+27160'
G[27163]='FA L15 A:44453 T:44453 P:27159+27160'
G[27164]='FA L15 A:44467 T:44453 P:27161'
G[27165]='FA L15 A:44453 T:10838 P:27162+27163+27164'
G[27166]='FA L15 A:10838 T:10838'
G[27167]='FA L15 A:45165 T:45165'
G[27168]='FA L15 A:11053 T:11053 P:27166+27167'
G[27169]='FA L15 A:10838 T:1854 P:27166+27167'
G[27170]='FA L15 A:1854 T:1205258 P:27169'
G[27171]='FA L15 A:1205258 T:10838 P:27170'
G[27172]='FA L15 A:10838 T:545165 P:27171'
G[27173]='FA L15 A:545165 T:545165 P:27172'
G[27174]='FA L15 A:545165 T:545165 P:27173'
G[27175]='FA L15 A:10840 T:44454 P:27168 I:27233'
G[27176]='L30 A:1205266 T:45180 P:27141'
G[27177]='FA L30 A:45170 T:45170 P:28599'
G[27178]='FA L30 A:45170 T:45170 P:28599'
G[27179]='L30 A:45186 T:45180 P:27141'
G[27180]='FH L5 A:544365 T:544365 P:27098'
G[27181]='FH L5 AK:45195 T:-21,544365 P:B27180'
G[27182]='FH L15 A:4501 T:4792'
G[27183]='L15 A:4792 T:4792 O:27182,27215'
G[27184]='L15 A:4792 T:4792 P:27183'
G[27185]='L15 A:45201 T:545201'
G[27186]='L15 A:4792 T:4792 P:27184'
G[27187]='L30 AK:45202 T:0 P:27141'
G[27188]='L15 A:23843 T:23843'
G[27189]='L15 A:23843 T:23843 P:27188'
G[27190]='L15 A:23843 T:23843 P:27189'
G[27191]='L15 A:4792 T:4792 P:27184'
G[27192]='L15 A:45323 T:545323'
G[27193]='FH L5 A:-21,544365 T:-21,544365 P:27181'
G[27194]='FH L5 A:-21,544365 T:45228 P:27193'
G[27195]='FH L5 A:45228 T:544365 P:27194'
G[27196]='L30 A:45180 T:45296 P:27176+27179'
G[27197]='FA L15 A:45012 T:544453 P:27175,27233'
G[27198]='FA L15 A:544467 T:544467 P:27197'
G[27199]='FA L15 A:544453 T:544453 P:27197'
G[27200]='FA L30 A:45171 T:45171'
G[27201]='FA L15 A:544453 T:544453 P:27205'
G[27202]='FA L15 A:500020 T:500020 P:27205'
G[27203]='L30 AA:45226 AH:45244 T:45042 O:27722,27727'
G[27204]='FA L15 A:544453 T:544453 P:27201+27202'
G[27205]='FA L15 A:544453 T:544453 P:27198+27199'
G[27206]='FA L15 A:544453 T:10838 P:27204'
G[27207]='FA L30 A:42443 T:466 Z13329'
G[27208]='L15 A:45200 T:545200'
G[27209]='FH L30 A:42600 T:5769 Z13329'
G[27210]='FA L15 A:23566 T:23566 O:26702,28552'
G[27211]='FA L15 A:23566 T:23566 P:27210'
G[27212]='FA L15 A:23566 T:23566 P:27211'
G[27213]='FA L15 A:23566 T:23566 P:27212'
G[27214]='FA L15 A:23951 T:5086 P:27213,27222'
G[27215]='FA L15 A:23835 T:4792 P:27213,27222'
G[27216]='FA L15 A:23835 T:23892'
G[27217]='FA L15 A:23892 T:23892 P:27216'
G[27218]='FA L15 A:23892 T:23896 P:27217'
G[27219]='FA L15 A:23896 T:12919 P:27218'
G[27220]='FA L15 A:12919 T:12919 P:27219'
G[27221]='FA L15 A:12919 T:23905 P:27220'
G[27222]='FA L15 A:23905 T:23905 P:27221'
G[27223]='L15 A:45200 T:545200'
G[27224]='L10 E21655'
G[27225]='FA L8 CW A:4087,17120 T:914'
G[27226]='FH L5 A:544917 T:544917 P:27098'
G[27227]='L15 A:45329 TP:545329:E35574;45329'
G[27228]='L15 A:45206 TP:545206:E35574;45206'
G[27229]='FH L15 A:1205332 T:4926'
G[27230]='L15 A:45331 TP:545331:E35574;45331'
G[27231]='FH L5 A:544916 T:1205350 P:27098'
G[27232]='FH L5 A:1205350 T:544916 P:27231'
G[27233]='FA L15 A:45165 T:44454 P:27174 I:27175'
G[27234]='FA L15 A:5086 T:5086 O:27214'
G[27235]='FA L15 A:5086 T:23569 P:27234'
G[27236]='FA L15 A:23569 T:23569 P:27235'
G[27237]='FA L15 A:23569 T:23569 P:27236'
G[27238]='FA L15 A:23569 T:4968 P:27237'
G[27239]='FA L15 A:4968 T:4968 P:27238'
G[27240]='FA L15 A:4968 T:29611 P:27239'	-- appears 40 seconds after completion of 27239
G[27241]='FA L15 A:29611 T:4968 P:27240'
G[27242]='FA L15 A:23723 T:23723'
G[27243]='FA L15 A:23723 T:23723 P:27242'
G[27244]='FH L15 A:1020985 T:4791'
G[27245]='FA L15 A:23723 T:23723 P:27242'
G[27246]='FA L15 A:1020985 T:23951'
G[27247]='FA L15 A:23951 T:4944 P:27246'
G[27248]='FA L15 A:23951 T:23572'
G[27249]='FA L15 A:4944 T:23567 O:27251'
G[27250]='L15 E21655'
G[27251]='FA L15 A:4921 T:4944'
G[27252]='FA L15 A:1020992 T:4944 P:27249'
G[27253]='FH L15 A:4926 T:23567'
G[27254]='FH L15 A:1020992 T:4926'
G[27255]='FH L15 A:4926 T:5087 P:27254'
G[27256]='FH L15 A:5087 T:5087 P:27255'
G[27257]='FH L15 A:5087 T:4926 P:27256'
G[27258]='FH L15 A:4926 T:4943 P:27257+27253+27259+27260+27306+27261'
G[27259]='FH L15 A:1187273 T:4926'
G[27260]='FH L15 A:1021042 T:4926'
G[27261]='FH L15 A:4983 T:4926 P:27306'
G[27262]='FA L15 A:1187273 T:4944 P:27249'
G[27263]='FA L15 A:1021042 T:4944 P:27249'
G[27264]='FA L15 A:4944 T:4948 P:27263'
G[27265]='FA L8 CP A:5147,16761,35281 T:928'
G[27266]='FA L8 CH A:4138,5115,17122 T:44247'
G[27267]='FA L8 CR A:4214,5165 T:164946'
G[27268]='FA L8 CT A:11401,11406,16756 T:376 I:27269,27362'
G[27269]='FA L8 RE CT A:11401,11406 T:7999 I:27268,27361'
G[27270]='FA L8 CS A:23127,52292 T:20407'
G[27271]='FA L8 CM A:5146,16749,50690 T:331'
G[27272]='FA L8 CL A:5173 T:461'
G[27273]='FA L8 CD A:4217,5504,16721,44395 T:12042'
G[27274]='FA L8 RN CT A:11406 T:45306'
G[27275]='FA L15 A:41444 T:45277 P:25871'
G[27276]='FH L15 A:41421 T:45278 P:25872'
G[27277]='FH L8 CM A:3047,4566,16653 T:47246'
G[27278]='FH L8 CH A:3039,16674,39116 T:3352'
G[27279]='FH L8 CR A:4584,16684 T:47233'
G[27280]='FH L8 CS A:3032,16661,51639 T:72839'
G[27281]='FH L8 CW A:3042,4593,43009 T:3353'
G[27282]='FH L8 CL A:4563,16648,43881 T:3326'
G[27283]='FH L8 CD A:3034,44726,44978,52319 T:12042'
G[27284]='FA L15 A:4944 T:4941 P:27252'
G[27285]='FA L15 A:4941 T:4944 P:27284'
G[27286]='FA L15 A:4948 T:4944 P:27264'
G[27287]='FA L15 A:4944 T:5089 P:27286'
G[27288]='FA L15 A:5089 T:4944 P:27287'
G[27289]='FA L15 E31961'
G[27290]='FH L5 A:544365 T:45312 P:27232+27180+27195+27226'	-- This is my guess at what the quest really should have as P codes because the above has one that does not exist in the database.
G[27291]='FA L15 A:4944 T:4944 P:27430'
G[27292]='FH L15 A:4943 T:4926 P:27258'
G[27293]='FH L15 A:4926 T:4926 P:27292'
G[27294]='FH L15 A:4926 T:4926 P:27292'
G[27295]='FH L15 A:4926 T:6546 P:27293+27294'
G[27296]='FH L15 A:6546 T:6546 P:27295'
G[27297]='FH L15 A:6546 T:4926 P:27296'
G[27298]='FH L8 RB CP A:16681,20406,43795 T:23128'
G[27299]='L30 A:45332 T:45332 P:27374,27375'
G[27300]='L30 A:45332 T:45332 P:27299'
G[27301]='L30 A:45391 T:45362 P:27299'
G[27302]='L30 A:45432 T:45432 P:27299'
G[27303]='L30 A:45362 T:45386 P:27301'
G[27304]='FH L8 RO RU RT RL RG RA RR RM RZ CP A:20406,43795 T:44725'
G[27305]='L15 A:45200 T:545200'
G[27306]='FH L15 A:4926 T:4983 P:27260'
G[27307]='FA L65280 E31961'
G[27308]='FH L65280 E21655'
G[27310]='FA L15 A:45277 T:545277 P:27275'
G[27311]='FH L15 A:45278 T:545278 P:27276'
G[27312]='FA L15 A:45277 T:545277 P:27275'
G[27313]='FH L15 A:45278 T:545278 P:27276'
G[27314]='FA L15 A:45277 T:545277 P:27275'
G[27315]='FH L15 A:45278 T:545278 P:27276'
G[27316]='FA L15 A:48208 T:545277 P:27275 O:28283'
G[27317]='FH L15 A:48208 T:545278 P:27276 O:28284'
G[27318]='FA L15 A:545277 T:545277 P:27314'
G[27319]='FH L15 A:545278 T:545278 P:27315'
G[27320]='FA L15 A:545277 T:545277 P:27316'
G[27321]='FH L15 A:545278 T:545278 P:27317'
G[27322]='FH L5 A:100060956 T:45315,44640'	-- TODO: Investigate when 45315 is dead so turn in must go to 44640 to transform the T: into proper TP:
G[27323]='FA L15 A:545277 T:545277 P:27318'
G[27324]='FH L15 A:545278 T:545278 P:27319'
G[27325]='FA L15 A:545277 T:545277 P:27316'
G[27326]='FH L15 A:545278 T:545278 P:27317'
G[27327]='FA L15 A:545277 T:545277 P:27323'
G[27328]='FH L15 A:545278 T:545278 P:27324'
G[27329]='FA L15 A:45442 T:45442 P:27357'
G[27330]='FH L15 A:45442 T:45442 P:27358'
G[27331]='FH L8 RT CT A:3045,4606,43870 T:44735'
G[27332]='FH L8 RL RZ CT A:3045,4606,16658 T:45137'
G[27333]='FH L5 A:45315 T:45315 P:27290'
G[27334]='FH L8 RU CT A:3045,4606,16658 T:45339'
G[27335]='FH L8 RB CT A:4606,16658,43870 T:45337'
G[27336]='L15 A:23601 T:23601'
G[27337]='FA K64 L8 CW A:914 T:5511 O:27225'
G[27338]='FA L30 A:45167 T:45169 P:28599'
G[27339]='L15 A:23601 T:23601'
G[27340]='L15 A:23600 T:23600'
G[27341]='FA L30 A:45169 T:45169 P:27338'
G[27342]='FH L5 A:45312 T:45312 P:27290'
G[27343]='FA K64 L8 CP A:928 T:5511 O:27265'
G[27344]='FA K64 L8 CH A:44247 T:1298 O:27266'
G[27345]='FH L5 A:45315 T:45315 P:27290'
G[27346]='L15 A:23600 T:23797'	-- TODO: This may be considered a breadcrumb for more than just 27347 as there are reports of not having taken 27347 and this is still not available.
G[27347]='L15 A:23797 T:23797 O:27346'
G[27348]='L15 A:23797 T:23797'	-- marks 11207 also complete, but we do not have that quest as no one can get it [also for some reason when I checked, 13807 is marked complete but that could have been from coming from SW]
G[27349]='FH L5 A:45315 T:45315 P:27333+27342+27345'
G[27350]='FH L5 A:-21,45315 T:45389 P:27349'
G[27351]='FA K64 L8 CR A:164946 T:5511 O:27267'
G[27352]='L15 A:45328 TP:545328:E35574;45328'
G[27353]='FA K64 L8 CS A:20407 T:5511 O:27270'
G[27354]='FA K64 L8 CM A:331 T:1317 O:27271'
G[27355]='FA K64 L8 CL A:461 T:1317 O:27272'
G[27356]='FA K64 L8 CD A:12042 T:12029 O:27273'
G[27357]='FA L15 A:545277 T:45442 P:27327+27325+27320'
G[27358]='FH L15 A:545278 T:45442 P:27328+27326+27321'
G[27359]='L15 A:45330 TP:545330:E35574;45330'
G[27360]='L5 A:45389 T:45389 P:27350'
G[27361]='FA K64 L8 CT A:376 T:1317 O:27268 I:27269,27362'
G[27362]='FA K64 L8 RE CT A:7999 T:1317 O:27269 I:27268,27361'
G[27363]='FA K64 L8 RN CT A:45306 T:1317 O:27274'
G[27364]='FH L5 A:-217,45315 T:-217,45315 P:27350'	-- auto accepted when accepting 27360
G[27365]='FH L8 CW A:3353 T:3355 O:27281'
G[27366]='FA L30 A:45169 T:45169 P:27338'
G[27367]='L15 A:45417 T:45428 O:27683'
G[27368]='L15 A:45428 T:45428 P:27367'
G[27369]='L15 A:45431 T:45417 P:27368'
G[27370]='L15 A:45417 T:45429'
G[27371]='L15 A:45429 T:-23,45429 P:27370'
G[27372]='L15 A:-23 T:45417 P:27371'
G[27373]='L15 A:45417 T:545417 P:27369+27372'
G[27374]='FA L30 A:49374 T:45332 P:28655'
G[27375]='FH L30 A:46324 T:45332 P:27945'
G[27376]='L30 A:45332 T:47991 P:27300+27302+27303'
G[27377]='L30 A:47991 T:-276,48051 P:27376'
G[27378]='L30 A:48051 T:48059 P:27377'
G[27379]='L30 A:48059 T:48059 P:27378'
G[27380]='L30 A:48059 T:45332 P:27379'
G[27381]='L15 A:545429 T:545429 P:27373'
G[27382]='L15 A:45451 T:45451'	--  P:B27381 was incorrect
G[27383]='L15 A:11063 T:10926'
G[27384]='L15 A:10926 T:10926 P:27383'
G[27385]='L15 A:10926 T:11063 P:27384+27392'
G[27386]='L15 A:11063 T:10667 P:27385'
G[27387]='L15 A:10667 T:10667 P:27386'
G[27388]='L15 A:10667 T:10667 P:27386'
G[27389]='L15 A:10667 T:10667 P:27386'
G[27390]='L15 A:10667 T:10926 P:27387+27388+27389'
G[27391]='L15 A:10926 T:1177544 P:27390'
G[27392]='L15 A:10926 T:10926 P:27383'
G[27393]='L30 A:39881 T:1202714 P:25580'
G[27394]='L30 A:40919 T:1203140 P:25953'
G[27395]='FH L8 CH A:3352 T:3355 O:27278'
G[27396]='FH L8 CR A:47233 T:3355 O:27279'
G[27397]='FH L8 CS A:72939 T:3355 O:27280'
G[27398]='FA L30 A:540772 T:45226 P:25551'
G[27399]='FH L30 A:540772 T:45244 P:25551'
G[27400]='FH L8 CM A:47246 T:3345 O:27277'
G[27401]='FH L5 A:-217,45315 T:-217,45315 P:27364'
G[27402]='FH L8 CL A:3326 T:3345 O:27282'
G[27403]='FH L8 RT CP A:44725 T:3355 O:27304'
G[27404]='FH L8 CD A:12042 T:12029 O:27283'
G[27405]='FH L5 A:-217,45315 T:545312 P:27401'
G[27406]='FH L5 A:545312 T:545474 P:27405'
G[27407]='L15 A:23579 T:23579'
G[27408]='L15 A:23579 T:23579 P:27407'
G[27409]='L15 A:23579 T:23579 P:27407'
G[27410]='L15 A:23579 T:23579 P:27408+27409'
G[27411]='L15 A:23579 T:23579 P:27410'
G[27412]='L15 A:1186426 T:23572'
G[27413]='L15 A:23570 T:23570'
G[27414]='FH L15 A:4501 T:4501'
G[27415]='FH L15 A:4501 T:4501'	-- P:27417 was incorrect.  it may be P:B or P:27416
G[27416]='FH L15 A:4501 T:4500 P:27414'	-- after a delay of 14 seconds after turnin of 27414
G[27417]='FH L15 A:4500 T:4501 P:27416'	-- this may need an SP...the acceptance was odd
G[27418]='FH K512 L15 A:4500 T:4501 P:27415'	-- PM2
G[27419]='L15 E21655'
G[27420]='L15 A:16135 T:16135 O:27544'
G[27421]='L15 A:16135 T:16135'
G[27422]='L15 A:45482 T:45323'
G[27423]='FH L5 A:-217 T:45474 P:B27406'
G[27424]='L15 A:4500 T:4500'
G[27425]='FA L15 A:4944 T:23568 P:27262+27285+27288'
G[27426]='FA L15 A:23568 T:23568 P:27425'
G[27427]='FA L15 A:23568 T:23568 P:27425'
G[27428]='FA L15 A:23568 T:6546 P:27426+27427'
G[27429]='FA L15 A:6546 T:6546 P:27428'
G[27430]='FA L15 A:6546 T:4944 P:27429'
G[27431]='L30 A:45296 T:45296 P:27549+27517,27549+28602'
G[27432]='L15 A:45500 T:45500'
G[27433]='FA L30 A:45168 T:45168 P:27338'
G[27434]='FH L8 RB CP A:23128 T:3355 O:27298'
G[27435]='FH L8 RT CT A:44735 T:3345 O:27331'
G[27436]='FH L8 RL RZ CT A:45137 T:3345 O:27332'
G[27437]='FH L8 RU CT A:45339 T:3345 O:27334'
G[27438]='FH L5 A:500026 T:45525 P:27406'
G[27439]='FH L8 RB CT A:45337 T:3345 O:27335'
G[27440]='L20 A:10299 T:10299'
G[27441]='FH L8 RG RA CT A:45347 T:3345 O:28164'
G[27442]='FH L30 A:45460 T:45244'
G[27443]='FA L30 A:45462 T:45226'
G[27444]='L14139 A:10299 T:10299 Z20338'
G[27445]='L14140 A:10299 T:10299 Z20338'
G[27446]='FA L15 A:40027 T:38535'	-- I:28507 no more
G[27447]='FH L15 A:40028 T:38534'
G[27448]='L15 A:545417 T:500045 P:27381+27382'
G[27449]='L15 A:45574 T:45574 P:27432'
G[27450]='L15 A:45575 T:45575'
G[27451]='L15 A:11035 T:-23,11035'
G[27452]='L15 A:11035 T:-23,11035'
G[27453]='L15 A:-23,11035 T:-23,11035 P:27451+27452'
G[27454]='L15 A:-23,11035 T:11035 P:27453'
G[27455]='L15 A:500045 T:45431 P:27448'
G[27456]='L15 A:16134 T:16134'
G[27457]='L15 A:16134 T:45417 P:27456+27465'
G[27458]='L15 A:11033 T:11033'
G[27459]='L15 A:11036 T:16116'
G[27460]='L15 A:16116 T:1205875 P:27459'
G[27461]='L15 A:1205875 T:16115 P:27460'
G[27462]='L15 A:1205875 T:16112 P:27460'
G[27463]='L15 A:45431 T:11034 P:27455'
G[27464]='L15 A:11034 T:11034 P:27463'
G[27465]='L15 A:11034 T:11034 P:27464'
G[27466]='L15 A:45729,545729 T:500047 P:27465'
G[27467]='L15 A:16365 T:16365 P:27464'
G[27468]='FA L30 A:45168 T:45168 P:27433'
G[27469]='L20 AA:56899 AH:9563 T:10299'	-- Note that both can give to both factions, but this is safer for players.	-- 2014-08-19 Updated to have quest given to other faction only based on feedback.
G[27470]='L20 A:14625,514625 T:10299'
G[27471]='fA K64 L20 A:9562 T:10299'
G[27472]='FH L5 A:45525 T:45617 P:27438'
G[27473]='FA L30 E31961'
G[27474]='FH L5 A:45617 T:45617 P:27472'
G[27475]='FH L5 A:45626 T:45626 P:27472'
G[27476]='FH L5 A:45617 T:1938 P:27474+27475'
G[27477]='L15 A:45735 T:45735'
G[27478]='FH L5 A:1938 T:1938 P:27476'
G[27479]='L15 A:45736 T:45736'
G[27480]='L5 A:100061310 T:1938 P:C27483'
G[27481]='L15 A:545574 T:-23,545574 P:27449'
G[27482]='L15 A:-23,545574 T:-23 P:27465+27481'
G[27483]='L5 A:1938 T:1938 P:27476'
G[27484]='FH L5 A:1938 T:45617 P:27478'
G[27485]='FA L30 A:48265 T:45528 P:27380 I:27486'
G[27486]='FH L30 A:48264 T:45528 P:27380 I:27485'
G[27487]='L15 A:545729 T:500047 P:27466'
G[27488]='L15 A:545729 T:545729 P:27487'
G[27489]='L15 A:545729 T:500049 P:27488'
G[27490]='FA L30 A:45669 T:45669 P:28248'
G[27491]='FH L30 A:45665 T:45665 P:28249'
G[27492]='FA L30 A:45668 T:45668 P:28248'
G[27493]='FH L30 A:45658 T:45658 P:28249'
G[27494]='FA L30 A:45668 T:0 P:27490+27492+27496'
G[27495]='FH L30 A:45658 T:0 P:27491+27493+27497'
G[27496]='FA L30 A:45669 T:45669 P:28248'
G[27497]='FH L30 A:45665 T:45665 P:28249'
G[27498]='FA L30 A:-241 T:0 P:27494'
G[27499]='FH L30 A:-241 T:0 P:27495'
G[27500]='FA L30 A:-241 T:45669 P:27498'
G[27501]='FH L30 A:-241 T:45665 P:27499'
G[27502]='FA L30 A:45669 T:0 P:27500'
G[27503]='FH L30 A:45665 T:0 P:27501'
G[27504]='L30 A:45528 T:45522 P:27485,27486'
G[27505]='L30 A:45522 T:45522 P:27504'
G[27506]='L30 A:45562 T:45562 P:27504'
G[27507]='L30 A:45528 T:45528 P:27564'
G[27508]='L30 A:45518 T:45518 P:27564'
G[27509]='L30 A:45528 T:45528 P:27564'
G[27510]='L5 A:45631,46125 T:45631,46125 P:27484'
G[27511]='L30 A:45296 T:0,45296 P:27196'
G[27512]='FH L5 A:45617 T:45752 P:27484'
G[27513]='FH L5 A:-21,45752 T:-21,45617 P:27512'
G[27514]='FA L30 A:45169 T:45172 P:27341,27366'
G[27515]='FA L30 A:45172 T:45172 P:27514'
G[27516]='FA L30 A:45172 T:45167 P:27515'
G[27517]='L30 A:1205540 T:45296 P:27196 I:28602'
G[27518]='FH L5 A:-21,45617 T:45617 P:27513'
G[27519]='L30 A:45772 T:45772 P:28135'
G[27520]='L30 A:45799 T:45799 P:28135'
G[27521]='L15 A:45826 T:45826'
G[27522]='L15 A:500049 T:500050 P:27489'
G[27523]='L15 A:45816 T:45816'
G[27524]='L15 A:500050 T:500051 P:27522'
G[27525]='L15 A:500051 T:45729 P:27524'
G[27526]='L15 A:500051 T:45730 P:27551'
G[27527]='L15 A:45730,545730 T:500052 P:27526'
G[27528]='L15 A:45831 T:45831'
G[27529]='L15 A:45831 T:45831'
G[27530]='L15 A:45831 T:45831 P:27528+27529+27539'
G[27531]='L15 A:45828 T:45828 O:27532'
G[27532]='L15 A:545451 T:45828 P:27522'
G[27533]='L15 A:12384 T:12384 O:27535'
G[27534]='L15 A:12384 T:12384'
G[27535]='L15 A:45828 T:12384'
G[27536]='L15 A:45786 T:45786 P:27587'
G[27537]='FA L30 A:45167 T:45173 P:27516'
G[27538]='FA L30 A:545172 T:45173 P:27516'
G[27539]='L15 A:45831 T:45831'
G[27540]='FA L30 E31961'
G[27541]='L30 A:45874 T:45296 P:27196'
G[27542]='SP FH L5 A:45617 T:45617 P:27518'
G[27543]='L10 E21655'
G[27544]='L15 A:45500 T:16135 P:27386'
G[27545]='FA L30 A:45173 T:45167 P:27537'
G[27546]='FA L30 E31961'
G[27547]='FH L5 A:45880 T:45880 P:27542'
G[27548]='FH L5 A:45879 T:45879 P:27542'
G[27549]='L30 A:45296 T:45296 P:27541'
G[27550]='FH L5 A:45878 T:45878 P:27542'
G[27551]='L15 A:100061378 T:500051 P:B27525'
G[27552]='L0 E21655'
G[27553]='L0 E21655'
G[27554]='L0 E21655'
G[27555]='SP K1 L15 AP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 TP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 P:27369'
G[27556]='SP K1 L15 AP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 TP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 P:27369'
G[27557]='SP K1 L15 AP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 TP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 P:27369'
G[27558]='SP K1 L15 AP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 TP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 P:27390'
G[27559]='SP K1 L15 AP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 TP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 P:27449'
G[27560]='SP K1 L15 AP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 TP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 P:27382'
G[27561]='SP K1 L15 AP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 TP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 P:27457'
G[27562]='SP K1 L15 AP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 TP:500053:27526;500048:E27489;500046:27465;500044:E27448;545400:E27373;45400 P:27563'
G[27563]='L0 T:46022 Q1:46022'	-- flag quest that completes when convincing Beezil Linkspanner to join Fiona's caravan
G[27564]='L30 A:45522 T:45528 P:27505+27506'
G[27565]='L20 A:45892 T:45898'
G[27566]='FA L30 E31961'
G[27567]='L20 A:45898 T:45898 P:27565'
G[27568]='L20 A:45891 T:45894'
G[27569]='L20 A:45894 T:45888 P:27568'
G[27570]='FH L30 E31961'
G[27571]='L20 A:45888 T:45899 P:27569'
G[27572]='FH L30 E31961'
G[27573]='L20 A:45899 T:45890 P:27571'
G[27574]='L5 A:100061505 T:-21,45878 P:27547+27548+27550'
G[27575]='L5 A:-21,45878 T:45878 P:27574'
G[27576]='FH L30 A:45528 T:47492 P:27507+27508+27509'
G[27577]='FH L5 A:45879 T:45879 P:27547+27548+27550'
G[27578]='L20 A:45890 T:45890 P:27573'
G[27579]='L20 A:45821 T:45818'
G[27580]='FH L5 A:45878 T:45878 P:27547+27548+27550'
G[27581]='L20 A:45818 T:45818 P:27579'
G[27582]='L20 A:45839 T:45820'
G[27583]='FH L30 A:44169 T:45982 P:26840'
G[27584]='FH L30 A:45982 T:45982 P:27583'
G[27585]='L20 A:45820 T:45817 P:27582'
G[27586]='FH L30 A:45983 T:45983 P:27583'
G[27587]='L15 A:45786 T:45786 O:28569,28570,28675,28677'
G[27588]='FA L30 E31961'
G[27589]='L20 A:45817 T:45824 P:27585'
G[27591]='L20 A:45824 T:45840 P:27589'
G[27592]='L15 A:46010 T:46010'
G[27593]='L20 A:45840 T:45840 P:27591'
G[27594]='FH L5 A:45878 T:45617 P:27577+27580'
G[27595]='L30 A:45772 T:46003 P:28135'
G[27596]='L20 A:45850 T:45850'
G[27597]='L15 A:45786 T:45948 P:27536+27656'
G[27598]='L15 A:45948 T:45948 P:27597'
G[27599]='L15 A:45948 T:45948 P:27597'
G[27600]='L15 A:45948 T:45948 P:27598+27599'
G[27601]='FH L5 A:45617 T:46124 P:27594'
G[27602]='L30 A:46003 T:1205874 P:27595'
G[27603]='L20 A:45849 T:45849'
G[27604]='L20 A:46077 T:46077 O:27915'
G[27605]='L20 A:46077 T:46077 O:27915'
G[27606]='FH L30 A:45983 T:45983 P:27584+27586'
G[27607]='FH L30 A:44169 T:46089 P:26840'
G[27608]='FA L30 E31961'
G[27609]='FH L30 E32305'
G[27610]='FH L30 A:46089 T:46089 P:27607'
G[27611]='FH L30 A:46089 T:46089 P:27607'
G[27612]='L15 A:16115 T:16115 P:27461'
G[27613]='L15 A:16115 T:16115 P:27461'
G[27614]='L15 A:16112 T:16112 P:27462'
G[27615]='L15 A:16112 T:16112 P:27462'
G[27616]='L15 A:16112 T:16112 P:27462'
G[27617]='L15 A:16115 T:516116 P:27612+27613'
G[27618]='L15 A:16112 T:516116 P:27614+27615+27616+27619'
G[27619]='L15 A:16112 T:16112 P:27462'
G[27620]='L15 A:516116 T:11036 P:27617+27618'
G[27621]='FA L30 A:545172 T:46804 P:27545'
G[27622]='FH L30 A:46090 T:46090 P:27610+27611'
G[27623]='L30 A:1205874 T:1205874 P:27602'
G[27624]='L30 A:45296 T:45296 P:27431'
G[27625]='FA L10 A:46475 T:46475 P:27725'
G[27626]='FA L10 A:46475 T:46475 P:27725'
G[27627]='L30 AK:46126,46127,46128,46129 T:-249 P:27431'
G[27628]='L30 A:45799 T:47684 P:27706'
G[27629]='L30 A:47959 T:46136 P:27628'
G[27630]='L30 A:47959 T:46135 P:27628'
G[27631]='L30 A:47959 T:46134 P:27628'
G[27632]='L30 A:46136 T:0,46136 P:27629'
G[27633]='L20 A:46077 T:46077 O:27915'
G[27635]='FA L1 RN A:46274 T:46255 P:28169'
G[27636]='FA L30 A:-241 T:45796 P:27502'
G[27637]='FA L5919744 E31961'
G[27638]='FH L30 A:-241 T:45675 P:27503'
G[27640]='FA L30 A:546804 T:46177 P:27817'
G[27641]='FA L30 A:46143 T:46143,46628 P:27640'	-- TODO: Verify T:46143 as well
G[27642]='FA L30 A:46143 T:46143,46628 P:27640'	-- TODO: Verify T:46143 as well
G[27643]='FA L30 A:46177 T:46176 P:27640'
G[27644]='FA L30 A:46177 T:46175 P:27640'
G[27645]='FA L30 A:46177 T:46174 P:27640'
G[27646]='FA L30 A:46176 T:46176 P:27643'
G[27647]='FA L30 A:46175 T:46583 P:27644'
G[27648]='FA K32 L30 A:46174 T:46174 P:27645'
G[27649]='FA L30 A:46583 T:46585,46627 P:27647'
G[27650]='FA L30 A:46176,46626,46627 T:46177 P:27646'
G[27651]='FA L30 A:46177 T:46177,46628 P:27650'	-- TODO: Verify T:46177 as well
G[27652]='FA L30 A:45796 T:45796 P:27636 I:27653'
G[27653]='FH L30 A:45675 T:45675 P:27638 I:27652'
G[27654]='FA L30 A:45796 T:45796 P:27636 I:27655'
G[27655]='FH L30 A:45675 T:45675 P:27638 I:27654'
G[27656]='L15 A:45786 T:45786 P:27587'
G[27657]='FA L30 A:45796 T:46242 P:27636'
G[27658]='FH L30 A:45675 T:46242 P:27638'
G[27659]='L30 A:46242 T:46242 P:27657,27658'
G[27660]='L30 A:46242 T:46413 P:27657,27658'
G[27661]='L30 A:46413 T:46413 P:27660'
G[27662]='L30 A:46243 T:46243 P:27657,27658'
G[27663]='L15 A:46182 T:46182 P:27587'
G[27664]='L341 A:100062021 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[27665]='L341 A:100062045 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[27666]='L341 A:100062044 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[27667]='L341 A:100062046 T:14847'	-- does this need to be tagged HF or can it be turned it with summoning at any time of the year?
G[27668]='L30 A:41711 T:1203395 P:25943'	-- probably is invalidated by one of the quests that has it as a requirement (most likely an O:)
G[27669]='L30 A:45296 T:48034 P:27624'
G[27670]='FA L1 RN A:45966 T:45966'
G[27671]='FA L1 RN A:47250 T:47250 P:28167'
G[27672]='L15 A:46234 T:46234'
G[27673]='fA L15 A:46247 T:46247'
G[27674]='FA L1 RN A:46255 T:42396 P:27635'
G[27675]='FA L1 A:100062056 T:332,3518,8670,14721,29142,43693'
G[27676]='L15 A:46233 T:46233'
G[27677]='L15 A:2748,46234 T:46234 P:27672'
G[27678]='L10 E21655'
G[27679]='L15 A:46236 T:46236'
G[27680]='L15 A:2748,46236 T:46236 P:27679'
G[27681]='L15 A:46235 T:46235'
G[27682]='L15 A:46241 T:46241'
G[27683]='L15 A:44456,10840 T:45417 I:27684'
G[27684]='L15 A:11034 T:45417 I:27683'
G[27685]='L30 A:41252 T:39667 P:25371'
G[27686]='FH L1 A:100063276 T:14375,17098,44853,44871,46708'
G[27687]='L30 A:100062138 T:39884 P:25598'
G[27688]='FA L30 A:45796 T:45796 P:27652+27654 I:27689'
G[27689]='FH L30 A:45675 T:45675 P:27653+27655 I:27688'
G[27690]='FH L30 A:45982 T:46313 P:27606'
G[27691]='L15 A:46172 T:46172'
G[27692]='L10 AZ:280 T:12238'	-- TODO: Get location of entrance to Earth Song Falls for proper A:
G[27693]='FA L15 A:1206335 T:-15 P:27796'
G[27694]='L15 A:46071 T:46071 O:27869'
G[27695]='FA L30 A:45796 T:45796 P:27652+27654 I:27696'
G[27696]='FH L30 A:45675 T:45675 P:27653+27655 I:27695'
G[27697]='L10 AZ:280 T:-280,12238'
G[27698]='L10 AZ:280 T:-280,12238 Z15640'	-- TODO: Set proper A: when entering Foulspore Cavern Entrance
G[27699]='L30 A:-201 T:46338 P:25657'
G[27700]='FA L30 A:45796 T:45796 P:27688+27695 I:27701'
G[27701]='FH L30 A:45675 T:45675 P:27689+27696 I:27700'
G[27702]='FA L30 A:45796 T:45796 P:27700 I:27703'
G[27703]='FH L30 A:45675 T:45675 P:27701 I:27702'
G[27704]='L15 A:46071 T:-130051 P:27694'
G[27705]='L15 A:-130051 T:-100051 P:27704'
G[27706]='L30 A:1205874 T:45772 P:27623'
G[27707]='L30 A:-249,46136 T:0,46136 P:27632'
G[27708]='L30 A:-201 T:41341 P:25884'
G[27709]='FA L15 A:1206336 T:-15 P:27797'
G[27711]='FA L30 A:45796 T:46243 P:27702+27719+27659+27662 I:27712'	-- TODO: Verify 27662 required
G[27712]='FH L30 A:45675 T:46243 P:27703+27798+27659+27662 I:27711'	-- TODO: Verify 27662 required
G[27713]='L15 A:2785 T:2785 O:27927'
G[27714]='L15 A:2920 T:2920 P:27713'
G[27715]='L15 A:4618 T:4618 P:27714'
G[27716]='FA L30 A:100062281 T:40644'
G[27717]='FH L30 A:100062282 T:40920'
G[27718]='FH L30 A:1206109,1206116,1207323,1207324 T:41621 I:28816'
G[27719]='FA L30 A:46413 T:45796 P:27661 I:27798'
G[27720]='FA L30 A:46243 T:46513 P:27659+27662 O:27711 I:28885'
G[27721]='FH L30 A:1206109,1206116,1207323,1207324 T:39865'
G[27722]='FH L30 A:1206109,1206116,1207323,1207324 T:45244'	-- removed M093 because boosted to 100 can get this
G[27724]='FA L2293790 A:1,1206294,1206111,1207320,1207321,1207322 T:36799 I:14481,28827'
G[27725]='FA L10 A:46476 T:46475 P:26526'
G[27726]='FA L2293790 A:1,1206111,1206294,1207320,1207321,1207322 T:39865'
G[27727]='FA L2293790 A:1206111,1206294,1207320,1207321,1207322 T:45226'
G[27729]='L30 AK:40855 T:0'
G[27733]='FA L10 A:46417 T:46417'
G[27737]='FA L10 A:46410 T:46410'
G[27738]='L30 A:-249,46136 T:46136 P:27707'
G[27739]='FA L10 A:46409 T:546409,46409'
G[27740]='L15 A:45948 T:46172 P:27600'
G[27742]='L30 A:46513 T:46513 P:27720,28885'
G[27743]='L30 A:46513 T:46513 P:27720,28885'
G[27744]='L30 A:46671 T:46513 P:27720,28885'	-- TODO: determine if the P is correct
G[27745]='L30 A:46513 T:46243 P:27742+27743+27744'
G[27746]='L7 A:46124 T:2215 P:27601'
G[27747]='FH L30 A:46318 T:46318 P:27690'
G[27748]='L30 A:47158 T:49151 P:28613'
G[27750]='FH L30 A:46319 T:46319 P:27690'
G[27751]='FH L30 A:46313 T:46313 P:27690'
G[27752]='FA L30 A:48010 T:48010'
G[27753]='FA L30 A:48013 T:48013 O:28369'
G[27754]='FA L30 A:46591 T:46591'
G[27755]='L30 A:48501 T:48501 P:28501'
G[27756]='FA L7 A:46612 T:-291,46612'
G[27757]='L15 A:46172 T:46172 P:27691'
G[27758]='FA L7 A:46612 T:-291,46612 P:27756'
G[27760]='L30 A:100062483 T:1206293'
G[27761]='L30 A:1206293 T:1206293 P:27760'
G[27762]='L15 A:48704 T:46650 O:28579,28580'
G[27763]='L15 A:46650 T:46652 O:27762'
G[27764]='L15 A:46652 T:46654 P:27774'
G[27765]='L15 A:46654 T:46654 P:27764'
G[27766]='L15 A:46654 T:46654 P:27764'
G[27768]='L15 A:-100051 T:-110051 P:27705'
G[27769]='L15 A:46654 T:46655 P:27771'
G[27770]='L15 A:46654 T:46654 P:27765+27766'
G[27771]='L15 A:46654 T:46654 P:27770'
G[27772]='L15 A:46655 T:46664 P:27769'
G[27773]='L15 A:-110051 T:-120051 P:27768'
G[27774]='L15 A:46652 T:46652 O:27763'
G[27775]='L15 A:46653 T:46653'
G[27776]='L15 A:46653 T:46653 P:27775'
G[27777]='L30 A:1206293 T:1206293 P:27760'
G[27778]='L30 A:1206293 T:46750 P:27761,27777'
G[27779]='L30 A:46750 T:46750 P:27778'
G[27781]='FA L7 A:46612 T:-291,46612 P:27758'
G[27782]='FA L30 A:46243 T:45796 P:27745 I:27783'
G[27783]='FH L30 A:46243 T:45675 P:27745 I:27782'
G[27784]='FA L30 A:45796 T:46717 P:27782 I:27786'
G[27785]='FA L7 A:46612 T:-291,46612 P:27781'
G[27786]='FH L30 A:45675 T:46717 P:27783 I:27784'
G[27787]='FA L30 A:46717 T:45668 P:27784 I:27788'
G[27788]='FH L30 A:46717 T:45658 P:27786 I:27787'
G[27789]='L15 A:46664 T:46664 P:27772'
G[27790]='FA L7 A:-291,46612 T:546612 P:27785'
G[27791]='FA L15 A:46664 T:46760 P:27789'
G[27792]='FA L15 A:46760 T:46760 P:27791'
G[27793]='FA L15 A:-15 T:-15 P:27693+27709'
G[27794]='FA L15 A:1206374 T:46664 P:27912'
G[27795]='FA L15 A:46676 T:46676 P:27821+27822'
G[27796]='FA L15 A:46760 T:1206335 P:27792'
G[27797]='FA L15 A:46760 T:1206336 P:27792'
G[27798]='FH L30 A:46413 T:45675 P:27661 I:27719'
G[27803]='FA L30 A:46804 T:46804 P:27621'
G[27804]='FA L30 A:46804 T:46804 P:27621'
G[27805]='FA L30 A:46814 T:46814 P:27803'
G[27806]='FA L30 A:46804 T:46805 P:27803+27804'
G[27807]='FA L30 A:46805 T:46811 P:27806'
G[27808]='FA L30 A:46805 T:47317 P:27806'
G[27809]='FA L30 A:46805 T:46850 P:27806'
G[27810]='FA L30 A:46811 T:46811 P:27807'
G[27811]='FA L30 A:46812 T:46812 P:27807'
G[27812]='FA L30 A:46811 T:46805 P:27810+27811'
G[27813]='FA L30 A:46850 T:46850 P:27809'
G[27814]='FA L30 A:46806 T:46806 P:27809'
G[27815]='FA L30 A:46850 T:46805 P:27813+28234'
G[27816]='FA L30 A:46805 T:546804 P:27812+27815'
G[27817]='FA L30 A:546804 T:546804 P:27816'
G[27818]='L15 A:46172 T:46172 P:27757'
G[27819]='L0 E21655'
G[27821]='FA L15 A:46676 T:46676 O:27870'
G[27822]='FA L15 A:46676 T:46676 O:27870'
G[27823]='FA L15 A:2860 T:2860'
G[27824]='FA L15 A:2860 T:2860 P:27823'
G[27825]='FA L15 A:46930 T:46930'
G[27826]='FA L15 A:46664 T:546654 P:27794'
G[27827]='FA L15 A:546654 T:46852 P:27826'
G[27828]='FA L15 A:46852,46855 T:46855 P:27827'
G[27829]='FA L15 A:-15 T:-15,46654 P:27828+27834+27835'
G[27830]='FA L15 A:-15 T:-15,46654 P:27829'
G[27831]='FA L15 A:-15 T:46654 P:27830'
G[27832]='FA L15 A:-15 T:500021 P:27831'
G[27833]='FA L15 A:46972 T:46972'
G[27834]='FA L15 A:46853,46856 T:46856 P:27827'
G[27835]='FA L15 A:46854,46857 T:46857 P:27827'
G[27836]='L30 A:46135 T:46135 P:27630'
G[27837]='L30 A:46135 T:46135 P:27630'
G[27838]='L30 A:46135 T:46135 P:28611'
G[27839]='L30 A:46134 T:46134 P:28201'
G[27840]='L15 A:18221 T:18221'
G[27841]='HD FH K16 L256 RG A:46901 T:46901 I:13952,14166,14167,14168,14169,14170,14171,14172,14173,14174,14175,14176,14177,27846'
G[27842]='FH L7 A:-291 T:46889'
G[27843]='FA L15 A:46676 T:46676 P:27821+27822'
G[27844]='FH L7 A:46906 T:700629'
G[27845]='FA L15 A:46676 T:46676 P:27821+27822'
G[27846]='HD FA K16 L256 RW A:46908 T:46908 I:13952,14166,14167,14168,14169,14170,14171,14172,14173,14174,14175,14176,14177,27841'
G[27847]='FH L7 A:46902 T:700632'
G[27848]='FH L7 A:-291 T:-292 P:27842'
G[27849]='FA L15 A:46676 T:46676 P:27795+27843+27845'
G[27850]='FH L7 A:-292 T:700636 P:27848'
G[27851]='FA L15 A:46676 T:46676 P:27795+27843+27845'
G[27852]='FH L15 A:7623 T:7623'
G[27853]='FH L15 A:7623 T:7623'
G[27854]='FH L15 A:7623 T:7623'
G[27855]='FH L15 A:7623 T:7623'
G[27856]='FH L15 A:7623 T:7623'
G[27857]='FH L15 A:7623 T:7623'
G[27858]='FA L15 A:500021 T:-15 P:27832'
G[27859]='SP L15 A:546664 T:546664 P:27930'
G[27860]='FA L15 A:18221 T:18221'
G[27861]='L30 I:27862,27863,31206'
G[27862]='L30 T:72841 I:27861,27863,31206'
G[27863]='K512 L30 A:46935 T:0 I:27861,27862,31206'	--PM5
G[27864]='FA K512 L30 A:46935 T:0 P:27863'	--PM5
G[27865]='FH K512 L30 A:46935 T:0 P:27863'	--PM5
G[27866]='K512 L30 A:46935 T:0 P:27865,27864'	--PM5
G[27867]='K512 L30 A:46935 T:0 P:27866'	--PM5
G[27868]='K512 L30 A:46935 T:0 P:27867'	--PM5
G[27869]='L15 A:46172 T:46071 P:27818'
G[27870]='FA L15 A:46071 T:46676 P:27914'
G[27871]='FH L15 A:46071 T:7623'
G[27872]='L0 E21655'
G[27873]='L0 E21655'
G[27874]='L30 A:40289,46987,46998 T:41005 P:25611 I:25985'
G[27875]='FA L15 A:17127 T:17127'
G[27876]='FA L15 A:17127 T:17127'
G[27877]='FH L15 A:46759 T:46759'
G[27878]='FH L15 A:46758 T:46758'
G[27879]='FH L15 A:46660 T:46660'
G[27880]='FH L15 A:1068 T:1068'
G[27881]='FH L15 A:46664 T:46757'
G[27882]='FH L15 A:46757 T:46757 P:27881'
G[27883]='FH L15 A:46757 T:1206335'
G[27884]='FH L15 A:46757 T:1206336'
G[27885]='FH L15 A:1206335 T:-15 P:27883'
G[27886]='FH L15 A:1206336 T:-15 P:27884'
G[27887]='FH L15 A:-15 T:-15 P:27885+27886'
G[27888]='FH L15 A:1206374 T:46664 P:27913'
G[27889]='FH L15 A:46664 T:46654'
G[27890]='FH L15 A:46654 T:47011 P:27889'
G[27891]='FH L15 A:47011,47021 T:47021'
G[27892]='FH L15 A:47018,47024 T:47024'
G[27893]='FH L15 A:47013,47022 T:47022'
G[27894]='FH L15 A:47021,47022,47024 T:46654 P:27891+27892+27893'
G[27895]='FH L15 A:46654,46860,46917,46938 T:46654 P:27894'
G[27896]='FH L15 A:46654,46861,46916 T:46654 P:27895'
G[27897]='FH L15 A:46654 T:500021 P:27896'
G[27898]='FH L15 A:500021 T:0 P:27897'
G[27899]='L30 A:47005 T:46978 P:27669'
G[27900]='L30 A:46978 T:46978 P:27669 O:27899'
G[27901]='L30 A:46978 T:46978 P:27669 O:27899'
G[27902]='FA L15 A:17127 T:17127 P:27875+27876'
G[27903]='L30 A:46978 T:50401 P:27901'
G[27904]='FA L15 A:17127 T:17127 P:27875'
G[27905]='L30 A:46978 T:48082 P:27903+27900'
G[27906]='L15 A:7623 T:47041'
G[27907]='FH L15 A:47041 T:47041'
G[27908]='FH L15 A:47041 T:47041'
G[27909]='FH L15 A:47041 T:47041'
G[27910]='FH L15 A:47041 T:47041'
G[27911]='FH L15 A:47041 T:47041'
G[27912]='FA L15 A:-15 T:1206374 P:27793'
G[27913]='FH L15 A:-15 T:1206374 P:27887'
G[27914]='L15 A:-120051 T:46071 P:27773'
G[27915]='L20 A:46071 T:46077 P:27914'
G[27916]='FH L15 A:47041 T:7623 P:27911'
G[27917]='FA L8 A:47006 T:547006'
G[27918]='L15 A:18221 T:17127 P:27840+27860'
G[27919]='L15 A:17127 T:9540'
G[27920]='FA L8 A:547006 T:500226 P:27917'
G[27921]='FA L8 A:500226 T:500227 P:27920'
G[27922]='L30 A:46872 T:46872 P:27003'
G[27923]='L30 A:46872 T:46872 P:27922'
G[27924]='L30 A:46875 T:46875 P:27922'
G[27925]='L30 A:100062768 T:47670 P:27669 I:28132'	-- TODO: Does this exist?  Is is Horde only?  -- Note the L086, which is what Blizzard API reports
G[27926]='L30 A:47670 T:47670 P:27669 O:27925,28132'
G[27927]='L15 AA:46930 AH:46660 T:2785'
G[27928]='L30 A:47670 T:47670 P:27926'
G[27929]='FH L30 A:46313 T:46313 P:27690'
G[27930]='L15 A:-15 T:1206504 P:27858,27898'
G[27931]='L30 A:43071 T:47195 P:26484'
G[27932]='L30 A:47195 T:47195 P:27931'
G[27933]='L30 A:47195 T:47195 P:27931'
G[27934]='L30 A:47195 T:0 P:27932+27933'
G[27935]='L30 A:-207 T:43071 P:27934'
G[27936]='L30 A:-207 T:43071 P:27934'
G[27937]='L30 A:43897 T:44204 P:26836'
G[27938]='L30 A:44204 T:42573 P:27937'
G[27939]='L30 A:47159 T:47159 P:27926'
G[27940]='L30 AK:47202 T:0 P:27926'
G[27941]='L30 A:47670 T:47670 P:27928'
G[27942]='L30 A:47159 T:47159 P:27939'
G[27943]='L30 A:47159 T:47159 P:27939'
G[27944]='K2 L35 A:48255 T:48255 I:27948,28683,28684'
G[27945]='FH L30 A:46324 T:46324 P:27929'	-- TODO: Determine if any required: 27747 27750 27751
G[27946]='L30 E21655'
G[27947]='FH L30 A:46323 T:1206569 P:27929'	-- TODO: Determine if any required: 27747 27750 27751
G[27948]='K2 L35 A:48255 T:48255 I:27944,28683,28684'
G[27949]='K2 L35 A:48250 T:48250 I:27966,27967,28689,28690,28691'
G[27950]='L30 A:47159 T:0 P:27941+27942+27943'
G[27951]='FH L30 A:1206569 T:1206569 P:27947'
G[27952]='FA L30 A:42573 T:44799'
G[27953]='FH L30 A:42573 T:44823'
G[27954]='FH L30 A:1206569 T:46323 P:27951'
G[27955]='FH L30 A:46323 T:46323 P:27954'
G[27956]='L15 A:47269 T:47269'
G[27957]='SP L15 A:47269 T:47269 P:27956'
G[27958]='L15 A:47268 T:47268 P:27957'
G[27959]='L15 A:47280 T:-32 P:B27958'
G[27960]='L15 A:47267 T:47267'
G[27961]='L15 A:47267 T:47267 P:27960'
G[27962]='L15 A:47267 T:47267 P:27960'
G[27963]='L15 A:47266 T:47266 O:28512,28581,28582'
G[27964]='L15 A:47266 T:47266 P:27963'
G[27965]='L15 A:47266 T:14625 P:27957+27958+27961+27962+27964'	-- TODO: G64|Prerequisites|
G[27966]='K2 L35 A:48250 T:48250 I:27949,27967,28689,28690,28691'
G[27967]='K2 L35 A:48250 T:48250 I:27949,27966,28689,28690,28691'
G[27968]='FA L8 A:500227 T:500228 P:27921'
G[27969]='L30 A:47159 T:47159 P:27950'
G[27970]='K2 L35 A:48255 T:48255 I:27971,27972,28050,28678,28679,28680,28681'
G[27971]='K2 L35 A:48255 T:48255 I:27970,27972,28050,28678,28679,28680,28681'
G[27972]='K2 L35 A:48255 T:48255 I:27970,27971,28050,28678,28679,28680,28681'
G[27973]='K2 L35 A:48254 T:48254 I:27975,28694,28695'
G[27974]='FH L8 A:47293 T:547293'
G[27975]='K2 L35 A:48254 T:48254 I:27973,28694,28695'
G[27976]='L15 A:14627 T:14627 P:27965'
G[27977]='L15 A:14626 T:14626 P:27965'
G[27978]='K2 L35 A:48254 T:48254 I:27987,27991,28697,28698,28700'
G[27979]='L15 A:14627 T:14627 P:27976+27977+27982'
G[27980]='L15 A:14634 T:14634'
G[27981]='L15 A:14627 T:14627 P:27965'
G[27982]='L15 A:14626 T:14624 P:27977'	-- there is another P required that is not 28099
G[27983]='L15 A:47332 T:-32 P:B27977'
G[27984]='L15 A:8436 T:8436'	-- there is a P: of somesort or maybe Thorium rep
G[27985]='L15 A:8436 T:-100032 P:27984'
G[27986]='L15 A:14627 T:47393 P:27979+28099'
G[27987]='K2 L35 A:48254 T:48254 I:27978,27991,28697,28698,28700'
G[27988]='FH L8 A:547293 T:500027 P:27974'
G[27989]='L15 A:1206585 T:1206585 P:28100'
G[27990]='L30 A:47159 T:47940 P:28002'
G[27991]='K2 L35 A:48254 T:48254 I:27978,27987,28697,28698,28700'
G[27992]='K2 L35 A:48250 T:48250 I:28046,28692,28693'
G[27993]='L30 A:47318 T:44860 P:28112'
G[27994]='L15 A:1206585 T:1206585 P:28100'
G[27995]='L15 A:1206585 T:11554 P:27989+27994'
G[27996]='FH L8 A:500027 T:500028 P:27988'
G[27997]='L15 A:10923 T:10923 O:28542,28543'
G[27998]='FH L8 A:500028 T:500029 P:27996'
G[27999]='FA L30 A:47317 T:46805 P:27808'
G[28000]='L15 A:47341 T:47341 O:28150'
G[28001]='FA L30 A:546804 T:46591 P:27817'
G[28002]='L30 A:47670 T:47670 P:27969'
G[28003]='FH K64 L7 I:26865,26866,26867'
G[28028]='L15 A:47393 T:47393 P:27986'
G[28029]='L15 A:47393 T:47393 P:27986'
G[28030]='L15 A:47393 T:47393 P:27986'
G[28031]='FA L15 A:40726 T:47383 P:25542,25561'
G[28032]='L15 A:47440 T:47440 P:27986'
G[28033]='L15 A:47393 T:47429 P:28028+28029+28030'
G[28034]='L15 A:47429 T:47393 P:28033'
G[28035]='L15 A:47393 T:14625 P:28034'
G[28038]='FH L30 A:46318 T:46936 P:27929 I:27863'	-- TODO: Determine if any required: 27747 27750 27751
G[28041]='FH L30 A:46313 T:-241,46313 P:27929'	-- TODO: Determine if any required: 27747 27750 27751
G[28042]='FH L15 A:40727 T:47383 P:25543,25562'
G[28043]='FH L30 A:-241,46313 T:47417 P:28041'
G[28044]='L15 A:47366 T:47341 P:28049'
G[28045]='L15 A:47383 T:47383 P:28031,28042'
G[28046]='K2 L35 A:48250 T:48250 I:27992,28692,28693'
G[28047]='L15 A:47383 T:47383 P:28045+28051'
G[28048]='L15 A:47383 T:47383 P:28045+28051'
G[28049]='L15 A:47366 T:47366 P:28000'
G[28050]='K514 L35 A:48255 T:48255 I:27970,27971,27972,28678,28679,28680,28681'	-- PM3
G[28051]='L15 A:47383 T:47383 P:28031,28042'
G[28052]='L15 A:14625 T:547393 P:28035'
G[28053]='SP L15 A:547429 T:547429 P:B28064'
G[28054]='L15 A:547393 T:14628 P:28052'
G[28055]='L15 A:547393 T:14628 P:28052'
G[28056]='L15 A:547393 T:14628 P:28052'
G[28057]='L15 A:14628 T:514626 P:28054+28055+28056'
G[28058]='L15 A:100062933 T:14628'	-- seems to be triggered by someone doing 28057
G[28059]='K2 L35 A:47240 T:47240 I:28063,28682,28685'
G[28060]='L15 A:514626 T:514625 P:28057'
G[28061]='L15 A:514625 T:-32 P:28060'
G[28062]='L15 A:514625 T:-32 P:28060'
G[28063]='K2 L35 A:47240 T:47240 I:28059,28682,28685'
G[28064]='L15 A:-32 T:14625 P:28061+28062'
G[28065]='L35 E31961'
G[28068]='FA K64 L20 M056 A:1207304 T:45903'
G[28069]='FH L20 M056 A:1207303 T:45823'
G[28084]='SP L10 A:42028 T:42028 P:26004'
G[28085]='L15 A:45442 T:47471 P:27329,27330'
G[28086]='L15 A:47471 T:47471 P:28085'
G[28087]='L15 A:47471 T:47471 P:28085'
G[28088]='L15 A:47471 T:47471 P:28086+28087'
G[28089]='FH L7 AP:44640:C26965+X27098;544640:27098+X27290;45631:27290+X27601;46125:27601 T:2215 P:C26965 I:28096,28571'
G[28090]='FH L30 A:47492 T:47492 P:27576'
G[28091]='FH L30 A:47492 T:47492 P:27576'
G[28092]='FH L30 A:47493 T:47374 P:28097'
G[28093]='FH L30 A:47374 T:47605 P:28092'	-- does this need 28094 as well?
G[28094]='FH L30 A:47374 T:47374 P:O28092'
G[28096]='FH L7 A:2215 T:2215 O:28089,28571'
G[28097]='FH L30 A:47492 T:47493 P:28090,28091'
G[28098]='L15 A:47471 T:47471 P:28088'
G[28099]='L15 A:14625 T:14625 P:27965'
G[28100]='L15 A:11554 T:1206585'
G[28101]='FA L30 A:45528 T:47592 P:27507+27508+27509'
G[28102]='L15 A:9116 T:9116 P:28044'
G[28103]='FA L30 A:47592 T:47592 P:28101'
G[28104]='FA L30 A:47592 T:47592 P:28101'
G[28105]='L30 A:46872 T:46872 P:27922'
G[28106]='L0 E21655'
G[28107]='FA L30 A:47611 T:47611 P:B28108'
G[28108]='FA L30 A:47592 T:47611 P:28103+28104'
G[28109]='FA L30 A:47611 T:47605 P:28108'
G[28111]='L7 A:2215 T:47554 P:28096'
G[28112]='L30 A:46872 T:47684 P:27923+27924+28105'
G[28113]='L15 A:47341 T:47341 P:28044'
G[28114]='L7 A:47432 T:47551 P:28096'
G[28115]='L7 A:47432 T:47551 P:28096'
G[28116]='L15 A:10922 T:51664 O:28152'
G[28117]='K2 L35 A:48039 T:48039,52015'
G[28118]='K2 L35 A:48039 T:48039,52015'
G[28119]='L15 A:51664 T:51664 P:28116'
G[28120]='K2 L35 A:48039 T:48039,52015'
G[28121]='L15 A:11019 T:51664'
G[28122]='K514 L35 A:48066 T:48066,52015'	-- PM3
G[28123]='FH L30 A:47417 T:47417 P:28043'
G[28124]='L15 A:47471 T:47580 P:28098'
G[28125]='L15 A:47580 T:47580 P:28124'
G[28126]='L15 A:51664 T:10922 P:28119+28121'
G[28127]='L15 A:47580 T:47580 P:28124'
G[28128]='L15 A:51664 T:11019 P:28119+28121'
G[28129]='L15 A:51664 T:51664 P:28119+28121'
G[28130]='K2 L35 A:47240 T:47240 I:28137,28686,28687'
G[28131]='L15 A:-77,51664 T:51664 P:28129'
G[28132]='L30 A:100062768 T:47670 P:27669 I:27925'
G[28133]='FH L30 A:47417 T:47671 P:28123'
G[28134]='L30 A:47684 T:47684 P:28112'
G[28135]='L30 A:47684 T:45799 P:28134'
G[28136]='L15 A:47580 T:47580 P:28125+28127'
G[28137]='K2 L35 A:47240 T:47240 I:28130,28686,28687'
G[28138]='FH L7 A:47554 T:47554 O:28111'
G[28139]='L15 A:47580 T:47580 P:28125+28127'
G[28140]='L15 A:47580 T:-64 P:28136+28139'
G[28141]='L30 A:47715 T:47715 P:28112'
G[28142]='L15 A:-64 T:47745 P:28140'
G[28144]='FH L7 A:47554 T:47554'
G[28145]='L30 A:47715 T:47715 P:28112'
G[28146]='FH L7 A:47551 T:47551'
G[28147]='FH L30 A:47723 T:47723'
G[28148]='L15 A:10921 T:10921'
G[28149]='FH L30 A:47751 T:47751'
G[28150]='L15 A:10923 T:47341 P:27995+27997+28148'
G[28151]='FH L30 A:47723 T:47723 P:28147'
G[28152]='L15 A:9116 T:10922 P:28113+28102'
G[28153]='L15 A:-77,51664 T:51664 P:28131'
G[28154]='fH L7 A:100063090 T:47554'
G[28155]='L15 A:-77,51664 T:47617 P:28153'
G[28156]='FH L7 A:47681 T:47554 P:28096'
G[28157]='L15 A:47745 T:47745 P:28142'
G[28158]='L15 A:47745 T:47745 P:28142'
G[28159]='L15 A:47745 T:47745 P:28157+28158'
G[28160]='FA L15 A:47745 T:40027 P:28159'
G[28161]='FH L15 A:47745 T:40028 P:28159'
G[28162]='K2 L35 A:48066 T:48066,52015'
G[28163]='K2 L35 A:48066 T:48066,52015'
G[28164]='FH L8 RG CT A:4606,43870 T:45347'
G[28165]='K2 L35 A:48061 T:48061,52015'
G[28166]='FH L30 A:47751 T:47751 P:28149'
G[28167]='FA L1 RN A:45966 T:47250 P:27670'
G[28168]='L7 A:47554 T:47781 P:28144'
G[28169]='FA L1 RN A:47250 T:46274 P:27671'
G[28170]='FH L30 A:47751 T:47751 P:28166'
G[28171]='L30 A:47605 T:47902 P:28758'
G[28172]='FA L15 A:47779 T:47779 O:28514'
G[28173]='L30 A:47902 T:47902 P:28171'
G[28174]='FA L15 A:47811 T:47811 I:28416,26726'
G[28175]='L30 A:47904 T:47904 P:28171'
G[28176]='L30 A:47902 T:47905 P:28173+28175+28191'
G[28177]='FA L15 A:47811 T:47811 P:28174,28416'
G[28178]='FA L15 A:47811 T:47811 P:28174,28416'
G[28179]='FA L15 A:47811 T:47811 P:28174,28416'
G[28180]='FA L15 A:47811 T:14437 P:28177+28178+28179'
G[28181]='FA L15 A:14437 T:14437 P:28180'
G[28182]='FA L15 A:14437 T:14437 P:28180'
G[28183]='FA L15 A:14437 T:47811 P:28181+28182'
G[28184]='FA L15 A:47811 T:48033 P:28172+28183'
G[28185]='K2 L35 A:48061 T:48061,52015'
G[28186]='K2 L35 A:48061 T:48061,52015'
G[28187]='L30 A:47940 T:47972 P:27990'
G[28188]='K2 L35 A:48074 T:48074,52015'
G[28189]='L7 A:1206944 T:-25 P:28192'
G[28190]='L15 A:47692 T:47692'
G[28191]='L30 A:47902 T:47902 P:28171'
G[28192]='FH L7 A:47781 T:47781 P:28096 O:28168'
G[28193]='L30 A:47972 T:47972 P:28187'
G[28194]='L30 A:47967 T:47967 P:28187'
G[28195]='L30 A:47972 T:47972 P:28193'
G[28196]='FH L7 A:100063250 T:47781 P:28192'
G[28197]='FH L7 A:47781 T:47781 P:28192'
G[28198]='L30 A:46134 T:46883 P:27631'
G[28199]='FH L7 A:47899 T:47899 P:28192'
G[28200]='L30 A:48012 T:48012 P:27631'
G[28201]='L30 A:46134 T:46134 P:27631'
G[28202]='FA L15 RH RF RV RK A:48001 T:48109 P:28254'
G[28203]='FA L15 RD RW RA RI A:48001 T:48109 P:28254'
G[28204]='FA L15 RN A:48001 T:48109 P:28254'
G[28205]='FA L15 RE A:48001 T:48109 P:28254'
G[28206]='FH L7 A:47781 T:47869 P:28196+28197+28199'
G[28207]='L15 A:47696 T:47696 O:28305'
G[28208]='L15 A:47696 T:47696 P:28190+28207'
G[28209]='FH L7 A:47900 T:47900 P:28206'
G[28210]='L30 A:46883 T:48022 P:28198'
G[28211]='FA L30 A:48014 T:48014'	-- TODO: Same req: methinks 27752 and maybe 27753 and/or 27754
G[28212]='FA L30 A:48014 T:48014'	-- TODO: Same req: methinks 27752 and maybe 27753 and/or 27754
G[28213]='L15 A:47696 T:47696 P:28208'
G[28214]='L15 A:47692 T:47692 P:28208'
G[28215]='FA L30 A:48014 T:48014'	-- TODO: Same req: methinks 27752 and maybe 27753 and/or 27754
G[28216]='FA L30 A:46591 T:46591,48173 P:27754'	-- TODO: Determine which of 27752 and/or 27753 needed too
G[28217]='L15 A:47843 T:47923 P:28374'
G[28218]='L15 A:47923 T:47923 P:28217'
G[28219]='L15 A:48032 T:48032 P:28229'
G[28220]='L15 A:48032 T:48032 P:28229'
G[28221]='L15 A:48042 T:48042 P:28219+28220'
G[28222]='L15 A:48042 T:48042 P:28219+28220'
G[28223]='K2 L35 A:48074 T:48074,52015'
G[28224]='L15 A:48042 T:48044 P:28221+28222'
G[28225]='L15 A:48033 T:48033 P:28184'
G[28226]='L15 A:48033 T:48033 P:28184'
G[28227]='L15 A:48033 T:48033 P:28225+28226'
G[28228]='L15 A:48044 T:0 P:28224'
G[28229]='L15 A:48126 T:-77 P:28374'
G[28230]='FH L7 A:48020 T:48020 P:28209'
G[28231]='FH L7 A:48021 T:548021 P:28209'
G[28232]='K2 L35 A:48074 T:48074,52015'
G[28233]='FA L30 A:48046 T:48053 P:27809'
G[28234]='FA L30 A:48053 T:48053 P:28233'
G[28235]='FH L7 A:48020 T:548020 P:28230+28231'
G[28237]='FH L7 A:548020 T:547900 P:28235'
G[28238]='FA L30 A:29611 T:544806 P:27106'
G[28239]='FA L15 A:48109 T:48085 P:28202,28203,28204,28205'
G[28240]='L30 E31961'
G[28241]='FA L30 A:48010 T:1206569 P:27752+27753'
G[28242]='FA L30 A:1206569 T:1206569 P:28241'
G[28243]='FA L30 A:1206569 T:48010 P:28242'
G[28244]='FA L30 A:48010,48175 T:48010,48175 P:28243'	-- TODO: Can 48175 really do this?  what phase?
G[28245]='FA L15 A:48085 T:48085 P:28239'
G[28246]='FA L15 A:-36,48110 T:-36,48110 P:B28245'
G[28247]='L30 A:47905 T:47902 P:28176'
G[28248]='FA L30 A:47902 T:45668 P:28247'
G[28249]='FH L30 A:47902 T:45658 P:28247'
G[28250]='K2 L30 A:46603 T:46603'
G[28251]='L7 A:547900 T:2391 P:28237'
G[28252]='FA L15 A:48085 T:-36 P:28245'
G[28253]='FA L15 A:-36,48110 T:48110 P:28246+28252'
G[28254]='FA L15 A:48109 T:48001 P:28184'	-- P:D28225+D28226 incorrect
G[28255]='L30 E31961'
G[28256]='L15 A:47923 T:47923 P:28218'
G[28257]='L15 A:47923 T:47923 P:28256'
G[28258]='FA L20 CW A:4087,17120 T:914'
G[28259]='FA L20 CL A:5173 T:461'
G[28260]='FA L20 CH A:4138,5115,17122 T:44247'
G[28261]='L3942400 A:47923 T:47923 P:28257'
G[28262]='FA L20 CR A:4214,5165 T:164946'
G[28263]='FA L20 CM A:5146,16749,50690 T:331'
G[28264]='L15 A:47923 T:47843 P:28261'
G[28265]='FA L15 A:48109 T:48133 P:28227+28253'
G[28266]='FA L15 A:48133 T:48133 P:28265'
G[28267]='L30 A:47972 T:48162 P:28194+28195'
G[28268]='FA L20 CP A:5147,16761,35281 T:928'
G[28269]='L30 A:48162 T:48186 P:28267'
G[28270]='L30 E31961'
G[28271]='L30 A:48186 T:48186 P:28274 O:28353'
G[28272]='L30 A:48186 T:48186 P:28274'
G[28273]='L30 A:48186 T:48203 P:28269'
G[28274]='L30 A:48203 T:48431 P:28273'
G[28275]='K2 L35 A:48254 T:48254'
G[28276]='L30 A:48022 T:48237 P:28210'
G[28277]='L30 A:48237 T:48237 P:28276'
G[28278]='FA L15 A:48133 T:48133 P:28266'
G[28279]='FA L15 A:-36,48110 T:-36,48110 P:B28278'
G[28280]='FA L30 A:48174 T:48174 P:28215'
G[28281]='FA L30 A:48173 T:48173 P:28280'
G[28282]='FA L30 A:48173 T:48173 P:28281'
G[28283]='FA L15 A:545277 T:48208 P:27314'
G[28284]='FH L15 A:545278 T:48208 P:27315'
G[28285]='FA L20 CT A:11401,11406,16756 T:376'
G[28286]='FA L15 A:-36,48110 T:48110 P:28279'
G[28287]='FA L20 CS A:23127,52292 T:20407'
G[28288]='L15 A:47341 T:47341 P:28113'
G[28289]='L20 CD AA:4217,44395 AH:3034,44726,44978,52319 T:12042'
G[28290]='FH L20 CW A:3042,4593,43009 T:3353'
G[28291]='L30 A:48237 T:46134 P:28277'
G[28292]='FA L30 A:44799 T:44238 P:27058'
G[28293]='FH L30 A:44823 T:47571 P:27059'
G[28294]='FA L30 A:48173 T:48367 P:28282'
G[28295]='FA L30 A:44238 T:44833 P:28292 I:28558'	-- TODO: Discover the other I:...probably the one where you take the caravan itself
G[28296]='FH L30 A:47571 T:44833 P:28293 I:28557'
G[28297]='FH L20 CH A:3039,16674,39116 T:3352'
G[28298]='FH L20 CR A:4584,16684 T:47233'
G[28299]='FH L20 CL A:4563,16648,43881 T:3326'
G[28300]='FH L20 CM A:3047,4566,16653 T:47246'
G[28301]='FH L20 CS A:3032,16661,51639 T:72939'
G[28302]='FH L20 RT CP A:20406,43795 T:44725'
G[28303]='FH L20 RB CP A:16681,20406,43795 T:23128'
G[28304]='FH L20 RU CT A:3045,4606,16658,43870 T:45339'
G[28305]='L15 A:47617 T:47696 P:28126+28128+28155'
G[28306]='L15 A:47696 T:48459 P:28213+28214'
G[28307]='FH L20 RB CT A:4606,16658,43870 T:45337'
G[28308]='FH L20 RT CT A:3045,4606,16658 T:44735'
G[28309]='FH L20 RL RZ CT A:4606,16658 T:45137'
G[28310]='FA L15 A:48110 T:9177 P:28286'
G[28311]='FA L15 A:48307 T:48307 P:28310'
G[28312]='FA L15 A:48307 T:48307 P:28310'
G[28313]='FA L15 A:48307 T:48307 P:28310'
G[28314]='FA L15 A:48306,48346 T:48346 P:28311+28312+28313'
G[28315]='FA L15 A:48306,48346 T:48346 P:28311+28312+28313'
G[28316]='FA L15 A:48306,48346 T:48292 P:28311+28312+28313'
G[28317]='FA L15 A:48307 T:48316 P:28326'
G[28318]='FA L15 A:48307 T:48314 P:28326'
G[28319]='FA L15 A:48307 T:48312 P:28326'
G[28320]='FA L15 A:548306 T:48307 P:28327'
G[28321]='FA L15 A:48307 T:48307 P:28320'
G[28322]='FA L15 A:48307 T:1207125 P:28321'
G[28323]='FH L20 RG CT A:3045,4606,16658,43870 T:45347'
G[28324]='L7 A:2391 T:2391 O:28251'
G[28325]='L7 A:2391 T:2391'
G[28326]='FA L15 A:-36 T:48307 P:28314+28315+28316'
G[28327]='FA L15 A:-36 T:48307 P:28317+28318+28319'
G[28328]='FA K64 L20 CT A:376 T:376 O:28285'
G[28329]='fH L7 A:48319 T:2391'
G[28330]='K512 L7 A:-25,2391 T:2391 P:28329'	-- PM2
G[28331]='L7 A:48129 T:48129'
G[28332]='L7 A:48129 T:48129'
G[28333]='FH L15 A:48127 T:48127 O:28372'
G[28334]='FH L15 A:48127 T:48127 O:28372'
G[28335]='FH L15 A:48333 T:1207104 P:28380'
G[28336]='FH L15 A:48127 T:48127 P:28357+28370'
G[28337]='FA L15 A:48493 T:48493 P:28384'
G[28338]='L15 A:15395 T:15395 O:28373,28392'
G[28339]='FH L15 A:48127 T:48127 P:28357+28370'
G[28340]='FH L15 A:48333 T:48333 P:28380'
G[28341]='L15 A:48339 T:48339'
G[28342]='L15 A:48339 T:48339'
G[28343]='L20 CD A:12042 T:12042 O:28289'
G[28344]='L7 A:48129 T:48218 P:28096+28331+28332'
G[28345]='FH L7 A:48218 T:548218 P:28096 O:28344'
G[28346]='FA L30 A:48365 T:48364 P:28294'
G[28347]='L0 E21655'
G[28348]='FH L7 A:548218 T:548218 P:28345'
G[28349]='FH L1 RG A:34668 T:34874 P:25473'
G[28350]='L30 A:48431 T:48431 P:28274'
G[28351]='L30 A:48431 T:48431 P:28274'
G[28352]='L30 A:48431 T:48431 P:28274'
G[28353]='L30 A:48431 T:48186 P:28350'
G[28354]='FH L7 A:548218 T:548218 P:28348'
G[28355]='L7 AK:2372,2373 T:-25'
G[28356]='fH L7 A:100063686 T:48129'
G[28357]='FH L15 A:48127 T:48127 P:28333+28334'
G[28358]='L15 A:48349 T:48349'
G[28359]='L15 A:48349 T:48349'
G[28360]='L15 A:48459 T:48459 O:28306'
G[28361]='L15 A:48459 T:48459'
G[28362]='L15 A:48461 T:47556'
G[28363]='L30 A:48186 T:48431 P:28271+28272'
G[28364]='L15 A:47556 T:47556 P:28362'
G[28365]='L15 E21655'
G[28366]='L15 A:15395 T:15395'
G[28367]='L30 A:48431 T:48186 P:28363'
G[28368]='FH L15 A:1207104 T:48127 P:28335'
G[28369]='FA L30 A:46591 T:48013'
G[28370]='FH L15 A:48127 T:48127 P:28333+28334'
G[28371]='L10 E21655'
G[28372]='FH L15 A:48469 T:48127 P:28264'
G[28373]='L15 A:48127 T:15395 P:28368'
G[28374]='L15 A:48459 T:48459 P:28360+28361'
G[28375]='FH K32 L7 A:548218 T:48470 P:28354'
G[28376]='L30 A:100063700 T:48431 P:28367'
G[28377]='FA L30 A:48364 T:48472 P:28346'
G[28378]='FA L30 A:48472 T:48472 P:28377'
G[28379]='FA L30 A:48472 T:48472 P:28377'
G[28380]='FH L15 A:48127 T:48333 P:28336+28339'
G[28381]='FA L15 A:48491 T:47931 P:28264'
G[28382]='FA L15 A:47931 T:47931 O:28381'
G[28383]='FA L15 A:48492 T:48492'
G[28384]='FA L15 A:47931 T:48493 P:28382+28383'
G[28385]='FA L15 A:48493 T:1207104 P:28337'
G[28386]='FA L15 A:48493 T:48493 P:28337'
G[28387]='L15 A:48493 T:48493 P:28385+28386'
G[28388]='FA L15 A:48493 T:48493 P:28385+28386'
G[28389]='FA L15 A:48493 T:47931 P:28387+28388'
G[28390]='K2 L30 A:44973 T:44973 P:26709+26583+T49362999 I:28391'
G[28391]='K2 L30 A:43806 T:42466,43806 P:26709+T49362999 I:28390'
G[28392]='L15 A:47931 T:15395 P:28389'
G[28393]='FA K64 L20 CW A:914 T:914 O:28258'
G[28394]='FA K64 L20 CH A:44247 T:44247 O:28260'
G[28395]='K1 L15 A:15395 T:15395 P:28338+28366'
G[28396]='K1 L15 A:11554 T:11554 P:27995'
G[28397]='FH L7 A:48470 T:48470 P:28375'
G[28398]='FA K64 L20 CM A:331 T:331 O:28263'
G[28399]='FA K64 L20 CL A:461 T:461 O:28259'
G[28400]='FH L7 A:48503 T:48545 P:28397'
G[28401]='FA K64 L20 CS A:20407 T:20407 O:28287'
G[28402]='L30 A:48186 T:48528 P:28367'
G[28403]='L30 A:48528 T:48558 P:28402'
G[28404]='L30 A:48558 T:48558 P:28403'
G[28405]='FA K64 L20 CP A:928 T:928 O:28268'
G[28406]='FA K64 L20 CR A:164946 T:164946 O:28262'
G[28407]='FA L30 A:48472 T:48530 P:28378+28379'
G[28408]='FA L30 A:48367 T:48367 P:28407'
G[28409]='FA K32 L30 A:48367 T:48367 P:28407'
G[28410]='FA L30 A:48367 T:48367 P:28407'
G[28411]='FA L30 A:48367 T:48367 P:28407'
G[28413]='FA L30 A:48366 T:48366 P:28407'
G[28414]='FH L1 RG A:37106 T:37106 P:24502 I:24503'
G[28415]='FA L15 A:9177 T:9177 P:28310'
G[28416]='FA L15 A:47811 T:47811 P:26726 I:28174'
G[28417]='FH L15 A:47779 T:47779 P:28515'
G[28418]='FH L15 A:48559 T:48559 P:28667'
G[28419]='FH L15 A:48559 T:48559'
G[28420]='FH L15 A:48559 T:48559'
G[28421]='FH L15 A:48559 T:48559'
G[28422]='FH L15 A:48559 T:14437 P:28419+28420+28421'
G[28423]='FH L15 A:14437 T:14437 P:28422'
G[28424]='FH L15 A:14437 T:14437 P:28422'
G[28425]='FH L15 A:14437 T:48559 P:28423,28424'
G[28426]='FH L15 A:48559 T:48033 P:28425'
G[28427]='FH L15 A:48568 T:48001'
G[28428]='FH L15 RO RU A:48001 T:48568'
G[28429]='FH L15 RT RA RM A:48001 T:48568'
G[28430]='FH L15 RG A:48001 T:48568'
G[28431]='FH L15 RL RB RR RZ A:48001 T:48568'
G[28432]='FH L15 A:48568 T:48085 P:28428,28429,28430,28431'
G[28433]='FH L15 A:48085 T:48085 P:28432'
G[28434]='FH L15 A:9176,48099,48100 AH:48568 T:48568 P:28433'
G[28435]='FH L15 A:48085 T:48111 P:28434'
G[28436]='FH L15 A:48568 T:48568 P:28434,28435'
G[28437]='FH L15 A:48568 T:48133 P:28436'
G[28438]='FH L15 A:48133 T:48133 P:28437'
G[28439]='FH L15 A:48133 T:48133 P:28438'
G[28440]='FH L15 A:48568 T:48568'
G[28441]='FH L15 A:48568 T:48568 P:28440'
G[28442]='FH L15 A:48568 T:10260 P:28441'
G[28443]='FH L15 A:48569 T:48569'
G[28444]='FH L15 A:48569 T:48569'
G[28445]='FH L15 A:48569 T:48569'
G[28446]='FH L15 A:48565,48567 T:48567'
G[28447]='FH L15 A:48565,48567 T:48567'
G[28448]='FH L15 A:48565,48567 T:48292'
G[28449]='FH L15 A:-36 T:48569'
G[28450]='FH L15 A:48569 T:48316'
G[28451]='FH L15 A:48569 T:48314'
G[28452]='FH L15 A:48569 T:48312'
G[28453]='FH L15 A:-36 T:48569'
G[28454]='FH L15 A:48565 T:48569'
G[28455]='FH L15 A:48569 T:48569 P:28454'
G[28456]='FH L15 A:48569 T:1207125 P:28455'
G[28457]='FH L20 CW A:3353 T:3353 O:28290'
G[28458]='FH L20 CM A:47246 T:47246 O:28300'
G[28459]='FH L20 CL A:3326 T:3326 O:28299'
G[28460]='L15 A:9298 T:9298 O:28524,28544,28545,28768'
G[28461]='FH L20 CH A:3352 T:3352 O:28297'
G[28462]='L15 A:100064353 T:9298 Z13329'
G[28463]='FH L20 CR A:47233 T:47233 O:28298'
G[28464]='L15 A:9298 T:1207179 O:28462'
G[28465]='FH L20 CS A:72939 T:72939 O:28301'
G[28466]='FH L20 RT CP A:44725 T:44725 O:28302'
G[28467]='L15 A:1176091,1207179 T:9298 P:28464'
G[28469]='L15 A:9298 T:9298 P:28467'
G[28470]='L15 A:9298 T:9298 P:28469'
G[28471]='L15 A:100012842 T:9298 P:C28470'
G[28472]='L15 A:9298 T:10920 P:28471'
G[28473]='FH L20 RB CP A:23128 T:23128 O:28303'
G[28474]='FH L20 RU CT A:45339 T:45339 O:28304'
G[28475]='FH L20 RB RR CT A:45337 T:45337 O:28307'
G[28476]='FH L20 RT CT A:44735 T:44735 O:28308'
G[28477]='FH L20 RL RZ CT A:45137 T:45137 O:28309'
G[28478]='FH L20 RG CT A:45347 T:45347 O:28323'
G[28479]='L15 A:10920 T:48658 O:28472'
G[28480]='L30 A:48564 T:48564 P:28623'
G[28481]='L20 E21655'
G[28482]='L30 A:48621 T:48698 P:28404'
G[28483]='L30 A:48564 T:48564 P:28623'
G[28484]='fH L7 A:2437 T:2437'
G[28485]='K512 L7 A:2418 T:2418'	-- PM3
G[28486]='L30 A:49345 T:49345 P:28623'
G[28487]='L7 A:2419 T:2419'
G[28488]='K2 L30 A:43805 T:43805 P:26709 I:26710,27048'
G[28489]='L7 A:2397 T:2397'
G[28490]='FA L1966085 M013 A:1207321 T:32973 I:26383,26385'
G[28491]='FH L15 A:10260 T:10260 P:28442'
G[28492]='FA L1966087 A:1,1207321,1207322 T:33187 I:26408'
G[28493]='FH L7 M023 A:1206109,1206116,1207323 T:8582 I:13866,28876'
G[28494]='FH L5 M014 A:1,1206109,1206116,1207323 T:3337 I:26642,A840'
G[28495]='fH L7 A:17092 T:17092'
G[28496]='FH L5 M016 A:1,1206109,1206116,1207323 T:35086 I:25275,25648'	-- Goblins can do this AND 25275, but not in the quest log at the same time.  to implement this most likely an alias quest will need to handle it.  not for the moment.
G[28497]='L30 A:48698 T:48698 P:28482'
G[28498]='L30 A:48761 T:48761 P:28561'
G[28499]='L30 A:48501 T:48501 P:28561'
G[28500]='L30 A:48761 T:48761 P:28498+28499'
G[28501]='L30 A:48761 T:48761 P:28500'
G[28502]='L30 A:47715 T:47715 P:28141'
G[28503]='FA L15 M043 A:1207321,1207322 T:39946 I:25479,25481'
G[28504]='FH L15 M043 A:1206109,1206116,1207323 T:40344'
G[28505]='FA L15 A:5636 T:44453 I:27158,28576,28749'
G[28506]='FH L7 A:48545 T:48545 P:28600'
G[28507]='FA L15 M048 A:1207321,1207322 T:38535'	-- I:27446 no more
G[28508]='FH L15 A:42898 T:44452 I:26920,28575,28750'
G[28509]='FH L15 M048 A:1206109,1206116,1207323 T:38534'
G[28510]='FH L15 M038 A:1206109,1206116,1207323 T:39377'
G[28511]='FA L15 M038 A:1,1207321,1207322 T:40032 I:14410'
G[28512]='L15 AA:46930 AH:46660 T:47266 I:28581,28582'
G[28513]='L15 A:48658 T:48658 P:28479'
G[28514]='FA L15 A:14625 T:47779 I:28666'
G[28515]='FH L15 A:14625 T:47779'
G[28516]='L15 E21655'
G[28517]='FA L5 RW A:42968 T:48736 P:14434'	-- should this P code be here?
G[28518]='L15 A:48659 T:48659 P:28534'
G[28519]='L15 A:48660 T:48660 P:28535'
G[28520]='L30 A:48564 T:47684 P:28480+28483+28486'
G[28521]='L15 A:15395 T:11556 P:28338+28366'
G[28522]='L15 A:11556 T:11556'
G[28523]='SP K1 L15 A:11556 T:11556 P:28522'
G[28524]='L15 A:11556 T:9298 I:28544,28545,28768'
G[28525]='FA L15 M053 A:1,1207321,1207322 T:9270 I:24911'
G[28526]='FH L15 M053 A:1206109,1206116,1207323 T:9270 I:24911'
G[28527]='FH L15 M058 A:1,1206109,1206116,1207323 T:15191 I:28528,28856,28859'
G[28528]='FA L15 M058 A:1,1207321,1207322 T:15191 I:28527,28856,28859'
G[28529]='L5 A:100064450 T:32971'
G[28530]='L15 A:9298 T:9298 P:28467'
G[28531]='FA L10 M033 A:1,1207321,1207322 T:36410 I:25938'
G[28532]='FH L10 M028 A:1206109,1206116,1207323 T:41678'
G[28533]='L30 A:46134,46135,46136 T:47684 P:27738+27838+28291'
G[28534]='L15 A:48658 T:48659 P:28513'
G[28535]='L15 A:48659 T:48660 P:28518'
G[28536]='L15 A:48660 T:10920 P:28519'
G[28537]='L15 A:10920 T:10920 P:28536'
G[28538]='FH L7 A:2278 T:-25,2278 P:28587'
G[28539]='FA L10 M028 A:1207321,1207322 T:34354'
G[28540]='L15 A:10307 T:10307'
G[28542]='FH L15 M048 A:1206109,1206116,1207323 T:10923'
G[28543]='FA L15 M048 A:1207321,1207322 T:10923'
G[28544]='FA L15 M053 A:1,1207321,1207322 T:9298 I:28524,28545,28768'
G[28545]='FH L15 M053 A:1,1206109,1206116,1207323 T:9298 I:28524,28544,28768'
G[28548]='FH L10 M033 A:1,1206109,1206116,1207323 T:35286'	-- note that this is not incompatible with 26134 as a player has both in their log
G[28549]='FH L10 M033 A:1,1206109,1206116,1207323 T:37135 I:26069'
G[28550]='FA L10 M033 A:1,1207321,1207322 T:38378'	-- note that you can have both this and 28551
G[28551]='FA L10 M033 A:1206294,1206111 T:38623'	-- note that you can have both this and 28550
G[28552]='FA L15 M038 A:1,1206294,1206111,1207321,1207322 T:23566 I:26702'
G[28553]='FH L15 A:7623 T:41124 P:27196 O:27916 I:28671,28858,28865'
G[28554]='FH L15 M038 A:1206109,1206116,1207323 T:4926 I:25292'
G[28555]='L30 E31961'
G[28556]='FH L7 A:48545 T:48545 P:28506'
G[28557]='FH L30 A:1206109,1206116,1207323,1207324 T:44833 I:28296'	-- removed M087 because boosted to 100 can get this
G[28558]='FA L2293790 A:1206294,1206111,1207320,1207321 T:44833 I:28295'
G[28559]='FA L1 M013 A:1207322 T:17586 I:9625'
G[28560]='FH L1 M013 A:1,1207325 T:16197 I:9144'
G[28561]='L30 A:47684 T:48761 P:28533'
G[28562]='FA L1966085 A:1206294,1206111 T:42308 I:26378'
G[28563]='FA L1966087 A:1,1206294,1206111 T:464 I:26365'
G[28564]='FA L1966090 A:1,1206294,1206111 T:264 I:26728'
G[28565]='FA L10 M023 A:1,1207320 T:41075 I:26137'
G[28566]='FH L7 A:-25,2278 T:2278 P:28538'
G[28567]='FA L1966085 A:1207320 T:1960 I:26131'
G[28568]='FH L5 M013 A:1,1207324 T:44615 I:26964'
G[28569]='FA L15 A:9177 T:45786 I:28675'
G[28570]='FH L15 A:10260 T:45786 I:28677'
G[28571]='FH L7 M023 A:1207324,1207325 T:2215 I:28089'
G[28572]='FH L10 M028 A:1207324,1207325 T:41949'
G[28573]='FA L10 M028 A:1207320 T:2700 I:26139'
G[28574]='FH L10 M033 A:1,1207324 T:42613'
G[28575]='FH L15 M038 A:1207324 T:44452 I:26920,28508,28750'
G[28576]='FA L15 M038 A:1,1206294,1206111,1207320 T:44453 I:27158,28505,28749'
G[28577]='FH L15 M043 A:1207324 T:45417'
G[28578]='FA L15 M043 A:1206294,1206111,1207320 T:45417'
G[28579]='FA L15 M047 A:1206294,1206111,1207320 T:48704'
G[28580]='FH L15 M048 A:1207324 T:48704'
G[28581]='FH L15 M051 A:1207324,1207325 T:47266 I:28512,28582'
G[28582]='FA L15 M053 A:1206294,1206111,1207320 T:47266 I:28512,28581'	-- needs some other I: because level 52 hunter not available
G[28583]='FH L30 A:46090 T:48993 P:27622'
G[28584]='FH L30 A:49439 T:49439 P:28583'
G[28586]='FH L30 A:49441 T:49441 P:28583'
G[28587]='FH L7 A:48545 T:13817 P:28400'
G[28588]='FH L30 A:48993 T:48993 P:28583'
G[28589]='FH L30 A:48993 T:48993 P:28584+28586+28588'	-- TODO: Verify 28586 required
G[28590]='FH L30 A:48993 T:49378 P:28589'
G[28591]='FH L30 A:49378 T:49378 P:28590'
G[28592]='FH L30 A:49379 T:49002 P:28591'
G[28593]='FH L30 A:49378 T:49000 P:28591'
G[28594]='FH L30 A:49378 T:49000 P:28591'
G[28595]='FH L30 A:49000 T:48993 P:28592+28593+28594'
G[28596]='FA L30 A:49022 T:49022 P:28832'
G[28597]='FA L30 A:49020,49252 T:49020 P:28596'	-- yes, can accept at either, but only turn in at one.
G[28598]='FA L30 A:49020 T:549020 P:28597'
G[28599]='FA L30 A:549020 T:45167 P:28598'
G[28600]='FH L7 A:13817 T:48545 P:28587'
G[28601]='L15 E21655'
G[28602]='L30 A:45296 T:45296 P:27541 I:27517'
G[28603]='FH L7 A:-25,2278 T:2278 P:28566'
G[28604]='FH L7 A:49035 T:49035 P:28566'
G[28605]='FH L7 A:-25,2278 T:2278 P:28603+28604'
G[28607]='SP FH K1 L1 RG AP:34874:X14116;534874:14116 TP:34874:X14116;534874:14116 P:C14071+k100046856 I:14116'	-- I:A14121+A14122+A14123+A14124 (put this back when the clearing code is fixed)
G[28608]='FH L1 RU A:1568 T:1568 P:24959'
G[28609]='L15 A:11191 T:48965'
G[28610]='L15 A:48965 T:48965 P:28609'
G[28611]='L30 A:46135 T:46135 P:27836+27837'
G[28612]='L30 A:49151 T:49204 P:27748'
G[28613]='L30 A:48698 T:47158 P:28497'
G[28614]='L15 A:48722 T:48722'
G[28615]='L15 A:48723 T:48723'
G[28616]='FH L7 A:48545 T:48545 P:28556+28605'
G[28617]='L1 A:49687 T:49687 P:28733'
G[28618]='L15 A:48965 T:11191 P:28610'
G[28619]='FH L10 A:1207279 T:41949 P:28572'
G[28620]='L7 A:2229 T:49201'
G[28621]='L30 A:49204 T:49203 P:28612'
G[28622]='L30 A:49203 T:49248 P:28621'
G[28623]='L30 A:48761 T:48564 P:28501'
G[28624]='L15 A:11192 T:48965 P:28618'
G[28625]='L15 A:48965 T:48965 P:28624'
G[28626]='L15 A:48965 T:11192 P:28625'
G[28627]='L15 A:11193 T:48965 P:28626'
G[28628]='L15 A:48965 T:11193 P:28632'
G[28629]='L15 A:10305 T:10305 P:28627'
G[28630]='L15 A:10305 T:1207291 P:28627'
G[28631]='L15 A:10305 T:10305 P:28627'	-- ODC:5163 (but we do not have 5163)
G[28632]='L15 A:48965 T:48965 P:28627'
G[28633]='L30 A:49248 T:49351 P:28622'
G[28634]='FH L7 A:49201 T:49201 O:28620'
G[28635]='FH L7 A:49243 T:49240'
G[28636]='FH L7 A:49240 T:49243 P:28635'
G[28637]='L15 A:49436 T:49436,-83'
G[28638]='L15 A:49537 T:-83,49537'
G[28639]='L15 A:-83,49436 T:49436 P:28719'
G[28640]='L15 A:49396 T:49396,-83 O:28718'
G[28641]='L15 A:-83,49396 T:49396,-83 P:28640'
G[28642]='L25 E21655'
G[28643]='FH K512 L7 A:49243 T:-25,49243'
G[28644]='FH K512 L7 A:-25,49243 T:-25,49243 P:28643'
G[28645]='FH K512 L7 A:-25,49243 T:-25,49243 P:28644'
G[28646]='FH K512 L7 A:-25,49243 T:-25,49243 P:28645'
G[28647]='FH K512 L7 A:-25,49243 T:49243 P:28646'
G[28648]='L25 E21655'
G[28649]='FA L8 RW CK A:29053 T:29053 P:12738'
G[28650]='FH L8 RG CK A:29053 T:29053 P:12738'
G[28651]='FH L1 A:2119,2122,2123,2124,2126,38911 T:1661 P:28601 I:31148'
G[28652]='FH L1 RU A:1568 T:2307 P:26799'
G[28653]='FH L1 A:1740 T:1569 P:26800'
G[28654]='K64 L30 N35 A:49351 T:39908 P:28633'
G[28655]='FA L30 A:48368 T:49358 P:28408+28409+28410+28411'
G[28656]='L15 A:-83 T:10307 P:I93157,I91082,I91992,I93165,I91991,I93150,I93164'	-- this becomes available once you get one of the "Juju" spell effects
G[28657]='K514 L35 A:48069 T:48069'	-- PM3
G[28658]='K2 L35 A:48069 T:48069'
G[28659]='K2 L35 A:48069 T:48069'
G[28660]='K2 L35 A:48071 T:48071'
G[28661]='K2 L35 A:48071 T:48071'
G[28662]='K2 L35 A:48071 T:48071'
G[28663]='K2 L35 A:48070 T:48070'
G[28664]='K2 L35 A:48070 T:48070'
G[28665]='K2 L35 A:48070 T:48070'
G[28666]='FA L15 M053 A:1206294,1206111,1207320 T:47811 I:28514'	-- needs some other I: because level 52 hunter not available
G[28667]='FH L15 M053 A:1,1207324 T:48559'
G[28668]='K2 L35 A:48062 T:48062'
G[28669]='K2 L35 A:48062 T:48062'
G[28670]='K2 L35 A:48062 T:48062'
G[28671]='FH L15 M058 A:1,1207324 T:41124 I:28553,28858,28865'
G[28672]='FH L1 A:1661 T:1570 P:24961'
G[28673]='FA L15 M058 A:1,1206294,1206111,1207320 T:5393 I:28857,28867'
G[28674]='L15 A:48965 T:11079 P:28722+28628'	-- in 7.3.5 28628 is required, but not sure 28722 is still
G[28675]='FA L15 M058 A:1,1206294,1206111,1207320 T:45786 I:28569'	-- level 54 rogue cannot get this
G[28676]='L15 A:11079 T:49407 O:28674'
G[28677]='FH L15 M055 A:1207324 T:45786 I:28570'
G[28678]='K2 L35 A:48360 T:48360 I:27970,27971,27972,28050,28679,28680,28681'
G[28679]='K2 L35 A:48360 T:48360 I:27970,27971,27972,28050,28678,28680,28681'
G[28680]='K2 L35 A:48360 T:48360 I:27970,27971,27972,28050,28678,28679,28681'
G[28681]='K514 L35 A:48360 T:48360 I:27970,27971,27972,28050,28678,28679,28680'	-- PM3
G[28682]='K2 L35 A:48358 T:48358 I:28059,28063,28685'
G[28683]='K2 L35 A:48360 T:48360 I:27944,27948,28684'
G[28684]='K2 L35 A:48360 T:48360 I:27944,27948,28683'
G[28685]='K2 L35 A:48358 T:48358 I:28059,28063,28682'
G[28686]='K2 L35 A:48358 T:48358 I:28130,28137,28687'
G[28687]='K2 L35 A:48358 T:48358 I:28130,28137,28686'
G[28688]='FH L10 M028 A:1207324,1207325 T:2464 I:26417'
G[28689]='K2 L35 A:48363 T:48363 I:27949,27966,27967,28690,28691'
G[28690]='K2 L35 A:48363 T:48363 I:27949,27966,27967,28689,28691'
G[28691]='K2 L35 A:48363 T:48363 I:27949,27966,27967,28689,28690'
G[28692]='K2 L35 A:48363 T:48363 I:27992,28046,28693'
G[28693]='K2 L35 A:48363 T:48363 I:27992,28046,28692'
G[28694]='K2 L35 A:48361 T:48361 I:27973,27975,28695'
G[28695]='K2 L35 A:48361 T:48361 I:27973,27975,28694'
G[28696]='K2 L35 A:48361 T:48361'
G[28697]='K2 L35 A:48361 T:48361 I:27978,27987,27991,28698,28700'
G[28698]='K2 L35 A:48361 T:48361 I:27978,27987,27991,28697,28700'
G[28699]='FA L10 M028 A:1206294,1206111 T:469 I:26838'
G[28700]='K2 L35 A:48361 T:48361 I:27978,27987,27991,28697,28698'
G[28701]='L15 A:11079 T:11079'
G[28702]='FA L10 M033 A:1,1206294,1206111 T:44082'
G[28703]='L15 A:49407 T:49407'
G[28704]='FH L10 M033 A:1,1207324 T:43095'
G[28705]='FH L10 M062 A:1206109,1206116,1207323,1207324 T:19253 P:9407'
G[28706]='L15 A:49407 T:49399'
G[28707]='L15 A:49399 T:49400 P:28706'
G[28708]='FA L10 M068 A:1,1206294,1206111,1207320,1207321,1207322 T:19229'	-- needs to have I:B10119
G[28709]='FA L1966090 A:1206294,1206111,1207320,1207321 T:25307'
G[28710]='L15 A:49400 T:49402 P:28707'
G[28711]='FH L10 M072 A:1206109,1206116,1207323,1207324 T:25273'
G[28712]='L30 A:47603 T:49417 P:28109,28093'
G[28713]='L1 A:2079 T:2079'
G[28714]='L1 A:2079 T:2079 P:28713'
G[28715]='L1 A:2077 T:2077 P:28713 O:28734'
G[28716]='FA L2293790 A:1206294,1206111,1207320,1207321 T:29611'
G[28717]='FH L30 A:1206109,1206116,1207323,1207324 T:39605'
G[28718]='L15 A:49402 T:49396 P:28710'
G[28719]='L15 A:-83,49436 T:-83,49436 P:28637'
G[28721]='L35 E31961'
G[28722]='L15 A:10305 T:10305 P:28629,28631'
G[28723]='L1 A:2079 T:49479 P:28714+28715'
G[28724]='L1 A:49479 T:49479 P:28723'
G[28725]='L1 A:49479 T:549480 P:28724'
G[28726]='L1 A:549480 T:549480 P:28725'
G[28727]='FA L1 A:549480 T:549480 P:28726'
G[28728]='L1 A:549480 T:49479 P:28727'
G[28729]='L1 A:49479 T:49479 P:28728'
G[28730]='L1 A:49479 T:3514 P:28729'
G[28731]='L1 A:3514 T:3515 P:28730'
G[28732]='L30 A:49444 T:49476'
G[28733]='L1 A:49687 T:49687'
G[28734]='L1 A:2079 T:2077 P:28714'
G[28735]='L30 A:49476 T:-283,49476 O:28732'
G[28736]='K2 L30 A:49523 T:49523 P:28613'
G[28737]='L30 A:-100283 T:-283,49476'
G[28738]='L30 A:49476 T:-283'
G[28739]='L0 E21655'
G[28740]='L30 A:-110283 T:-283 P:28738'
G[28741]='L30 A:-120283 T:549476 P:28740'
G[28742]='L15 A:-83,49396 T:49396 P:28641'
G[28743]='L30 E21655'
G[28744]='L1 A:49687 T:49687 P:28617'
G[28745]='L15 A:-83,49537 T:-83,49537 P:28638'
G[28746]='L30 A:39908 T:39908 P:28654'
G[28747]='L1 A:49687 T:49687 P:28744'
G[28748]='L1 A:49687 T:49687 P:28747'
G[28749]='FA L15 N30 A:49635 T:44453 I:27158,28505,28576'
G[28750]='FH L15 A:49636 T:44452 I:26920,28508,28575'
G[28751]='K2 L1 A:49687 T:49687 P:28748 E18414'
G[28752]='L1 E31961'
G[28753]='L30 A:539908 T:49941 P:28746'
G[28755]='K1 L15 A:49856 T:49856 P:27464'
G[28756]='K1 L15 A:49856 T:49856 P:27464'
G[28757]='FA L1 RH RK CM A:197 T:197'
G[28758]='L30 A:49810 T:47605 P:28712'
G[28759]='FA L1 RH RK CH A:197 T:197 P:28767'
G[28760]='L30 A:49943 T:49943 O:28845'
G[28761]='L256 I:11834'
G[28762]='FA L1 RH RK CP A:197 T:197'
G[28763]='FA L1 RH RK CT A:197 T:197'
G[28764]='FA L1 RH RK CR A:197 T:197'
G[28765]='FA L1 RH RK CL A:197 T:197'
G[28766]='FA L1 RH RK CW A:197 T:197'
G[28767]='FA L1 RH RK CH A:197 T:197'
G[28768]='L15 A:15395 T:9298 I:28524,28544,28545'
G[28769]='FA L1 RH RK CM A:197 T:197 P:28757'
G[28770]='FA L1 RH RK CP A:197 T:197 P:28762'
G[28771]='FA L1 RH RK CT A:197 T:197 P:28763'
G[28772]='FA L1 RH RK CR A:197 T:197 P:28764'
G[28773]='FA L1 RH RK CL A:197 T:197 P:28765'
G[28774]='FA L1 RH RK CW A:197 T:197 P:28766'
G[28775]='L1 A:100065896 T:0 P:PJ475'
G[28776]='L1 A:100065897 T:0 P:PJ475'
G[28777]='L1 A:100065894 T:0 P:PJ475'
G[28778]='L1 CW CP CK A:100065895 T:0 P:PJ475'
G[28779]='L30 A:49943 T:49943 O:28845'
G[28780]='FA L1 RH RK A:43278 T:823 P:28759'
G[28781]='K64 L30 A:50038 T:50038'
G[28782]='L15 A:-83,49537 T:49537 P:28745'
G[28783]='K64 L30 A:50038 T:50038 O:28870'
G[28784]='FA L1 RH RK A:198 T:823 P:28769'
G[28785]='FA L1 RH RK A:925 T:823 P:28770'
G[28786]='FA L1 RH RK A:375 T:823 P:28771'
G[28787]='FA L1 RH RK A:915 T:823 P:28772'
G[28788]='FA L1 RH RK A:459 T:823 P:28773'
G[28789]='FA L1 RH RK A:911 T:823 P:28774'
G[28790]='L30 M080 AZ:85 T:45244'
G[28791]='FA L1 RH RK A:823 T:823 P:28780'
G[28792]='FA L1 RH RK A:823 T:823 P:28784'
G[28793]='FA L1 RH RK A:823 T:823 P:28785'
G[28794]='FA L1 RH RK A:823 T:823 P:28786'
G[28795]='FA L1 RH RK A:823 T:823 P:28787'
G[28796]='FA L1 RH RK A:823 T:823 P:28788'
G[28797]='FA L1 RH RK A:823 T:823 P:28789'
G[28798]='K2 L30 A:1207406 T:1207406 P:K100063127+PX425'
G[28799]='K2 L30 A:1207407 T:1207407 P:K100052843+PX425'
G[28800]='K2 L30 A:1207408 T:1207408 P:K100064397+PX425'
G[28801]='K2 L30 A:1207409 T:1207409 P:K100064397+PX425'
G[28802]='K2 L30 A:1207410 T:1207410 P:K100064397+PX425'
G[28803]='K2 L30 A:1207411 T:1207411 P:K100052843+PX425'
G[28804]='K2 L30 A:1207412 T:1207412 P:K100052843+PX425'
G[28805]='FH L30 A:45244 T:45244 P:28790'
G[28806]='FA L1 RH RK A:951 T:951 P:28780'
G[28807]='L84 A:44293 T:332 P:27060,27064'
G[28808]='FA L1 RH RK A:951 T:951 P:28784'
G[28809]='FA L1 RH RK A:951 T:951 P:28785'
G[28810]='FA L1 RH RK A:951 T:951 P:28786'
G[28811]='FA L1 RH RK A:951 T:951 P:28787'
G[28812]='FA L1 RH RK A:951 T:951 P:28788'
G[28813]='FA L1 RH RK A:951 T:951 P:28789'
G[28814]='L30 A:50048 T:50048 P:28815'
G[28815]='L30 A:50048 T:50048'
G[28816]='L30 A:45244 T:41621 P:28805 I:27718'
G[28817]='FA L1 RH RK A:823 T:197 P:28791'
G[28818]='FA L1 RH RK A:823 T:197 P:28792'
G[28819]='FA L1 RH RK A:823 T:197 P:28793'
G[28820]='FA L1 RH RK A:823 T:197 P:28794'
G[28821]='FA L1 RH RK A:823 T:197 P:28795'
G[28822]='FA L1 RH RK A:823 T:197 P:28796'
G[28823]='FA L1 RH RK A:823 T:197 P:28797'
G[28824]='K64 L30 A:42465,43792 T:42465,43792,44025 P:26871'	-- instead of P it could be V of neutral
G[28825]='fA L30 M080 AZ:84 T:45226'
G[28826]='FA L30 A:45226 T:45226 O:28825'
G[28827]='L30 M093 A:45226 T:36799 P:28826 I:14481,27724'
G[28828]='L15 A:49396 T:49396'
G[28829]='L15 A:50263 T:50263'
G[28830]='L15 A:50263 T:50263 P:28829'
G[28831]='L15 A:50263 T:50263 P:28829'
G[28832]='FA L30 A:544806 T:49022 P:28238'
G[28833]='L30 A:50272 T:40825'
G[28834]='L30 A:50270 T:40825'
G[28836]='L30 A:50270 T:50270'
G[28837]='L15 A:10929 T:10929 P:28537 O:28847'
G[28838]='L15 A:10929 T:10929,-83 P:28837'
G[28839]='L15 A:-83,10929 T:10929,-83 P:28838'
G[28840]='L15 A:-83,10929 T:10929 P:28839'
G[28841]='L15 A:10929 T:10929 P:28840'
G[28842]='L15 A:10929 T:10929 P:28840'
G[28843]='L30 A:50272 T:50272'
G[28845]='L30 A:45772 T:49943 P:27520+27706+27519'
G[28846]='L0 T:38935 J:O25024'
G[28847]='L15 A:50366 T:10929 P:28537+28722'
G[28848]='L15 A:10920 T:50366 P:28537'
G[28849]='FH L30 A:42640 T:50367 P:26337+26372+26374'	-- TODO: Verify requires 26374
G[28850]='FA L1 RW A:50371 T:35077 P:14157'
G[28852]='K64 L30 A:50390 T:50390'
G[28853]='K64 L30 A:50385 T:50385'
G[28854]='K64 L30 A:50387 T:50387'
G[28855]='L1 T:-50 J:D26732,D26278'
G[28856]='L15 A:11118 T:15191 I:28527,28528,28859'
G[28857]='FA L15 A:11118 T:5393 I:28673,28867'
G[28858]='FH L15 A:11118 T:41124 O:27916 I:28671,28553,28865'
G[28859]='L15 A:38269 T:15191 I:28527,28528,28856'
G[28860]='FA K2 L30 A:46591 T:46591 P:28655'
G[28861]='FA K2 L30 A:48010 T:48010 P:28655'
G[28862]='FA K2 L30 A:48010 T:48010 P:28655'
G[28863]='FA K514 L30 A:49386 T:49386 P:28655'	-- PM2
G[28864]='FA K2 L30 A:46591 T:46591 P:28655'
G[28865]='L15 A:50587 T:41124 O:27916 I:28553,28671,28858'
G[28866]='K64 L30 A:44010 T:50048 P:27061'
G[28867]='L15 A:50588 T:5393 I:28673,28857'
G[28868]='FA L1 A:50601 T:50601 P:25839'
G[28869]='L30 A:42469 T:43116 P:26439'
G[28870]='K64 L30 A:47684 T:50038 P:28520'
G[28871]='FH K2 L30 A:50622 T:50622 P:28133'
G[28872]='FH K2 L30 A:46318 T:46318 P:28133'
G[28873]='FH K2 L30 A:46319 T:46319 P:28133'
G[28874]='FH K2 L30 A:46318 T:46318 P:28133'
G[28875]='FH K514 L30 A:49387 T:49387 P:28133'	-- PM2
G[28876]='L7 A:3429 T:8582 I:13866,28493'
G[28877]='L5 A:34698 T:3449 I:29094 Z19342'
G[28878]='L7866880 E21655'
G[28879]='HC L7879680 A:33533 T:34365 P:13937+H13959|K100046545|S200033530'
G[28880]='HC L7879680 A:33532 T:34365 P:13938+H13960|K100046544|S200033529'
G[28881]='L15 A:39059 T:40109 P:25065'
G[28882]='FA K4 L35 A:51288 T:51288'
G[28884]='FH K4 L35 A:51287 T:51287'
G[28885]='FH L30 A:46243 T:46513 P:27659+27662 O:27712 I:27720'
G[28886]='L0 E21655'
G[28887]='L0 E21655'
G[28888]='L0 E21655'
G[28889]='L0 E21655'
G[28890]='L30 E21655'
G[28895]='L30 E21655'
G[28901]='L30 E21655'
G[28903]='L30 E21655'
G[28904]='L30 E21655'
G[28905]='L30 E21655'
G[28906]='L30 E21655'
G[28907]='L30 E21655'
G[28908]='L30 E21655'
G[28909]='FH L30 A:39605 T:42637 P:26294'
G[28910]='SP HM FH L7864576 A:1207982 T:1207982'
G[28911]='SP HM FA L7864576 A:1207983 T:1207983'
G[28912]='SP HM FH L7864576 A:1207984 T:1207984'
G[28913]='SP HM FH L7864576 A:1207985 T:1207985'
G[28914]='SP HM FA L7864576 A:1207986 T:1207986'
G[28915]='SP HM FH L7864576 A:1207987 T:1207987'
G[28916]='SP HM FH L7864576 A:1207988 T:1207988'
G[28917]='SP HM FA L7864576 A:1207989 T:1207989 P:600001'
G[28918]='SP HM FA L7864576 A:1207990 T:1207990'
G[28919]='SP HM FA L7864576 A:1207991 T:1207991'
G[28920]='SP HM FA L7864576 A:1207992 T:1207992'
G[28921]='SP HM FH L7864576 A:1207993 T:1207993'
G[28922]='SP HM FA L7864576 A:51574 T:51574'
G[28923]='SP HM FH L7864576 A:51575 T:51575'
G[28924]='SP HM FH L7864576 A:51582 T:51582'
G[28925]='SP HM FA L7864576 A:51585 T:51585'
G[28926]='SP HM FA L7864576 A:51586 T:51586'
G[28927]='SP HM FH L7864576 A:51587 T:51587'
G[28928]='SP HM FA L7864576 A:51588 T:51588'
G[28929]='SP HM FA L7864576 A:51602 T:51602'
G[28930]='SP HM FH L7864576 A:51603 T:51603 P:600002'
G[28931]='SP HM FH L7864576 A:51604 T:51604'
G[28932]='SP HM FA L7864576 A:51606 T:51606'
G[28933]='SP HM FH L7864576 A:51607 T:51607'
G[28934]='HA FA K2 L7885056 M100 A:38066 T:38066 P:24657 I:24638,24645,24647,24648,24649,24650,24651,24652,24658,24659,24660,24662,24663,24664,24665,24666,28935'
G[28935]='HA FH K2 L7885056 M100 A:37172 T:37172 P:24576 I:24638,24645,24647,24648,24649,24650,24651,24652,24658,24659,24660,24662,24663,24664,24665,24666,28934'
G[28936]='L15'
G[28937]='L15'
G[28938]='L15 E21655'
G[28939]='L15 P:29040'
G[28940]='L15'
G[28943]='SP HM FH L7864576 A:1208089 T:1208089'
G[28944]='SP HM FA L7864576 A:1208090 T:1208090'
G[28945]='SP HM FA L7864576 A:51650 T:51650'
G[28946]='SP HM FH L7864576 A:51651 T:51651'
G[28947]='SP HM FH L7864576 A:1208093 T:1208093'
G[28948]='SP HM FA L7864576 A:1208094 T:1208094'
G[28949]='SP HM FH L7864576 A:51652 T:51652'
G[28950]='SP HM FA L7864576 A:51653 T:51653'
G[28951]='SP HW FA K16 L7864576 A:1208115 T:1208115'
G[28952]='SP HW FA K16 L7864576 A:1208116 T:1208116'
G[28953]='SP HW FH K16 L7864576 A:1208117 T:1208117'
G[28954]='SP HW FA K16 L7864576 A:1208120 T:1208120'	-- Arathi Highlands, Refuge Point
G[28955]='SP HW K16 L7864576 A:1208137 T:1208137'
G[28956]='SP HW FA K16 L7864576 A:1208121 T:1208121'
G[28957]='SP HW FH K16 L7864576 A:1208143 T:1208143'
G[28958]='SP HW FH K16 L7864576 A:1208118 T:1208118'
G[28959]='SP HW FH K16 L7864576 A:1208144 T:1208144 P:600002'
G[28960]='SP HW FA K16 L7864576 A:1208122 T:1208122 P:600001'
G[28961]='SP HW FA K16 L7864576 A:1208123 T:1208123 P:600001'	--  I:28997 removed because it causes headaches with current implementation
G[28962]='SP HW FH K16 L7864576 A:1208145 T:1208145'
G[28963]='SP HW FA K16 L7864576 A:1208124 T:1208124'
G[28964]='SP HW FA K16 L7864576 A:1208125 T:1208125'
G[28965]='SP HW K16 L7864576 A:1208138 T:1208138'
G[28966]='SP HW FH K16 L7864576 A:1208146 T:1208146'
G[28967]='SP HW K16 L7864576 A:1208139 T:1208139'
G[28968]='SP HW FA K16 L7864576 A:1208126 T:1208126'
G[28969]='SP HW FH K16 L7864576 A:1208147 T:1208147'
G[28970]='SP HW FA K16 L7864576 A:1208127 T:1208127'
G[28971]='SP HW FH K16 L7864576 A:1208148 T:1208148'
G[28972]='SP HW FH K16 L7864576 A:1208149 T:1208149'
G[28973]='SP HW FH K16 L7864576 A:1208150 T:1208150'
G[28974]='SP HW FH K16 L7864576 A:1208151 T:1208151'
G[28975]='SP HW FH K16 L7864576 A:1208152 T:1208152 P:26830'	-- Basically when one gets 28640 and returns, one sees the candy bucket available
G[28976]='SP HW FH K16 L7864576 A:1208153 T:1208153'
G[28977]='SP HW FA K16 L7864576 A:1208128 T:1208128'
G[28978]='SP HW FA K16 L7864576 A:1208130 T:1208130'
G[28979]='SP HW FA K16 L7864576 A:1208131 T:1208131'
G[28980]='SP HW FA K16 L7864576 A:1208129,500022 T:1208129,500022'
G[28981]='SP HW K16 L7864576 A:1208141 T:1208141'
G[28982]='SP HW K16 L7864576 A:1208142 T:1208142'
G[28983]='SP HW FA K16 L7864576 A:1208133 T:1208133'
G[28984]='SP HW FH K16 L7864576 A:1208154 T:1208154'
G[28985]='SP HW FA K16 L7864576 A:1208132 T:1208132'
G[28986]='SP HW FH K16 L7864576 A:1208155 T:1208155'
G[28987]='SP HW FH K16 L7864576 A:1208156 T:1208156'
G[28988]='SP HW FA K16 L7864576 A:1208134 T:1208134'
G[28989]='SP HW FH K16 L7864576 A:1208119 T:1208119'
G[28990]='SP HW FA K16 L7864576 A:1208136 T:1208136'
G[28991]='SP HW FA K16 L7864576 A:1208135 T:1208135'
G[28992]='SP HW FH K16 L7864576 A:1208140 T:1208140'
G[28993]='SP HW K16 L7864576 A:1208157 T:1208157'
G[28994]='SP HW K16 L7864576 A:1208158 T:1208158'
G[28995]='SP HW FA K16 L7864576 A:1208159 T:1208159'
G[28996]='SP HW FH K16 L7864576 A:1208160 T:1208160'
G[28998]='SP HW FH K16 L7864576 A:1208161 T:1208161'
G[28999]='SP HW K16 L7864576 A:1208162 T:1208162'
G[29000]='SP HW K16 L7864576 A:1208163 T:1208163'
G[29001]='SP HW K16 L7864576 A:1208164 T:1208164'
G[29002]='SP HW FH K16 L7864576 A:1208165 T:1208165'
G[29003]='SP HW FH K16 L7864576 A:1208166 T:1208166'
G[29004]='SP HW FH K16 L7864576 A:1208167 T:1208167'
G[29005]='SP HW FH K16 L7864576 A:1208168 T:1208168'
G[29006]='SP HW FA K16 L7864576 A:1208169 T:1208169'
G[29007]='SP HW FA K16 L7864576 A:1208170 T:1208170'
G[29008]='SP HW FA K16 L7864576 A:1208171 T:1208171'
G[29009]='SP HW FH K16 L7864576 A:1208172 T:1208172'
G[29010]='SP HW FA K16 L7864576 A:1208173 T:1208173'
G[29011]='SP HW FA K16 L7864576 A:1208174 T:1208174'
G[29012]='SP HW FA K16 L7864576 A:1208175 T:1208175'
G[29013]='SP HW FA K16 L7864576 A:1208176 T:1208176'
G[29014]='SP HW K16 L7864576 A:1208177 T:1208177'
G[29015]='FH L5 A:34674 T:34674 P:14004'
G[29016]='SP HW K16 L7864576 A:1208178 T:1208178'
G[29017]='SP HW K16 L7864576 A:1208179 T:1208179'
G[29018]='SP HW K16 L7864576 A:1208180 T:1208180'
G[29019]='SP HW FH K16 L7864576 A:1208181 T:1208181'
G[29020]='SP HW FA K16 L7864576 A:1208183 T:1208183'
G[29021]='FH L5 A:3442 T:1004141'	-- I:894 TODO: Verify the whole Samophlange chain to see if the server marks other quests complete as well (probably to handle those that did this ages ago)
G[29022]='FH L5 A:1004141 T:1004141 P:29021'
G[29023]='FH L5 A:1004141 T:1004141 P:29022'
G[29024]='FH L5 A:1004141 T:3442 P:29023'
G[29026]='FH L5 A:34674 T:9316 P:14003'
G[29027]='FH L5 A:9316 T:9316 P:29026'
G[29029]='L15'
G[29030]='HM L7864576 A:51682 T:1208184'
G[29031]='SP HM L7864576 A:51697 T:1208187'
G[29032]='FA L15 A:10618 T:10618'
G[29033]='FA L15 E31961'
G[29034]='FA L15 A:10618 T:10618 P:29032'
G[29035]='FA K2 L15 A:51677 T:51677 P:B29034 I:29037,29038,29040'
G[29036]='SP HM L7864576 A:51698 T:1208188'
G[29037]='FA K2 L15 A:51677 T:51677 P:B29034 I:29035,29038,29040'
G[29038]='FA K2 L15 A:51677 T:51677 P:B29034 I:29035,29037,29040'
G[29039]='FA K2 L12800 A:51677 T:51677 P:B29034 I:29051,29052,29053 Z19033'
G[29040]='FA K2 L15 A:51677 T:51677 P:B29034 I:29035,29037,29038'
G[29041]='L0 E21655'
G[29051]='FA K2 L25 A:51677 T:51677 P:B29034 I:29039,29052,29053 Z19033'
G[29052]='FA K2 L12800 A:51677 T:51677 P:B29034 I:29039,29051,29053 Z19033'
G[29053]='FA K2 L12800 A:51677 T:51677 P:B29034 I:29039,29051,29052 Z19033'
G[29054]='HW FA K2 L7864576 A:51934 T:51934'
G[29063]='L0 E21655'
G[29065]='L0 E21655'
G[29066]='L30 A:-198,39933 T:39928 P:25428'	-- there needs to be an I: for this since Nimhfree cannot get it [basically did 25428 before this quest existed]
G[29067]='L1 AA:5177,5499,16723,4160 AH:3347,3009,4611,16642 TA:5177,5499,16723,4160 TH:3347,3009,4611,16642 P:PA475'
G[29070]='L0 E21655'
G[29071]='SP FA L10 M080 A:1208316 T:0'
G[29073]='SP FH L10 M080 A:1208317 T:0'
G[29074]='HW FA L7864576 A:18927,518927,500091,500092,500093,500094,500095,19148,19172,19173,20102,520102,500106,500107,500108,500109,500110,500111,500112,500113,500114,500115,500116,500117,500118,500119,500120,500121,500122,500123,500124,500125,500126,500127,500128,500129,500130 T:51665'
G[29075]='HW K2 L7864576 A:51665 T:51665'
G[29076]='L0 E21655'
G[29078]='FA L1 RF RE RN RD RW RA RV RI SH A:197 T:197'
G[29079]='FA L1 RF RE RN RD RW RA RV RI A:197 T:197 P:29078'
G[29080]='FA L1 RF RE RN RD RW RA RV RI A:197 T:823 P:29079'
G[29081]='FA L1 RF RE RN RD RW RA RV RI A:823 T:823 P:29080'
G[29082]='FA L1 RF RE RN RD RW RA RV RI A:951 T:951 P:29080'
G[29083]='FA L1 RF RE RN RD RW RA RV RI A:823 T:197 P:29081'
G[29084]='L1 E21655'
G[29085]='L1 E21655'
G[29086]='FH L5 A:3442 T:3442'
G[29087]='FH L5 A:34698 T:-10'
G[29088]='FH L5 A:34698 T:34698'
G[29089]='FH L5 A:-10,34698 T:34698 P:29087'
G[29090]='FH L5 A:52192 T:52192'
G[29091]='L5'
G[29092]='HM FA L7868416 A:25324 T:26221 P:11891'
G[29093]='HC FA L7866880 A:14305 T:500007 P:1468'
G[29094]='FH L5 A:3442 T:3449 P:29015+29086 I:28877'
G[29095]='FH L5 A:3449 T:3429 P:876'
G[29096]='L7 E21655'
G[29097]='L10 E21655'
G[29099]='L10 E21655'
G[29100]='FA L35 A:52654 T:52234'
G[29101]='K2 L32 A:52671 T:0,52671 P:29198 I:29125,29147,29161,29164'
G[29102]='FA L35 A:52654 T:52281 P:B29100'
G[29103]='FA L35 A:52281 T:52281 P:29102'
G[29104]='FA L35 A:52234 T:52234 P:29103'
G[29105]='FA L35 A:52281 T:52294 P:29104'
G[29106]='HC FA L7866880 A:14305 T:500006 P:1468'
G[29107]='HC FA L7866880 A:14305 T:514305 P:1468'
G[29108]='L0 E21655'
G[29109]='FH L5 A:3429 T:52207 P:29095'
G[29110]='FH L5 A:52207 T:52309 P:29109'
G[29111]='FH L5 A:52207 T:8582 P:29112'
G[29112]='FH L5 A:52309 T:52207 P:29110'
G[29114]='FA L35 A:52294 T:52346 P:29105'
G[29115]='FA L35 A:52346 T:-50 P:29114'
G[29116]='FA L35 A:-50 T:52234 P:29115'
G[29117]='HC FA L7866880 A:14305 T:14305 P:29093+29106+29107'	-- Craggle Wobbletop wanders up and down 
G[29119]='HC FA L7866880 A:14305 T:500008 P:29093+29106+29107'
G[29120]='FA L35 A:52234 T:52234 P:29116'
G[29121]='FA L35 A:52371 T:52371 P:29213'
G[29122]='K2 L32 A:52671,-198 T:52671 P:29101'
G[29123]='K2 L32 A:52669 T:52669 P:29198 I:29127,29149,29163,29166,29246,29247,29248'	-- It appears that only one of 29123, 29127, 29149 and 29163 will be given each day.  However, you can have more than one of them in the quest log at the same time.  The I: cannot handle this situation properly.  Therefore, it is probably better to err on the side of showing the possibility instead of denying it. ***** 29163 is NOT invalidated with 29201, so I am guessing all four of them are not! ***** ***** I have a player that has both 29101 and 29147 in the log at the same time.  29101 was from the day earlier. *****
G[29124]='FA L35 A:52234 T:52410 P:29121'
G[29125]='K2 L32 A:52669 T:0,52669 P:29198 I:29101,29147,29161,29164'
G[29126]='K2 L32 A:52669,-198 T:52669 P:29125'
G[29127]='K2 L32 A:52669 T:52669 P:29198 I:29123,29149,29163,29166,29246,29247,29248'	-- TODO: Determine whether any of the new stuff needs P: as well
G[29128]='K2 L32 A:553073 T:52824 P:29201'
G[29129]='L35 A:52382 T:15192 P:29452'
G[29131]='FA L35 A:52410 T:52410 P:29124'
G[29132]='L35 A:52408 T:15192 P:29453'
G[29133]='FA L35 A:52753 T:552234 P:29131'
G[29134]='L35 A:15192 T:15192 P:29129,29132'
G[29135]='L35 A:15192 T:15192 P:29134'
G[29137]='K2 L32 A:52824 T:52824 P:29201 I:29141,29142,29304'
G[29138]='K2 L32 A:553080,53080 T:553080 P:29201'
G[29139]='K2 L32 A:52467 T:52467 P:29201 I:29143'
G[29141]='K2 L32 A:52824 T:52824 P:29201 I:29137,29142,29304'
G[29142]='K2 L32 A:52824 T:52824 P:29201 I:29137,29141,29304'
G[29143]='K2 L32 A:52467 T:52467 P:29201 I:29139'
G[29144]='HW FA K258 L7864576 A:51934 T:51934'
G[29145]='L32 A:52669 T:52838 P:25372 O:29387,29388,29389'
G[29146]='HC FH K16 L7866880 A:14444 T:514444 P:172'
G[29147]='K2 L32 A:52669 T:0,52669 P:29198 I:29101,29125,29161,29164'
G[29148]='K2 L32 A:-198,52669 T:52669 P:29147'
G[29149]='K2 L32 A:52669 T:52669 P:29198 I:29123,29127,29163,29166,29246,29247,29248'
G[29150]='FA L35 A:552234 T:552234 P:29133'
G[29151]='FA L35 A:552234 T:552234 P:29150'
G[29152]='FA L35 A:52646 T:52767 P:29151'
G[29153]='FA K1600 L35 A:2496 T:53151 P:29152+T01544999 I:29154'	-- PM5
G[29154]='FA K1600 L35 A:53151 T:72841 P:29152+t01544999 I:29153'	-- PM5
G[29155]='FA L35 A:2496,53151 T:1208420 P:29153,29154'
G[29156]='FA L35 A:1206111,1206294,1207320,1207321,1207322 T:53352'
G[29157]='FH L35 A:1206109,1206116 T:53081'
G[29158]='FA L35 E31961'
G[29159]='K2 L32 A:52921 T:52921 P:29205'
G[29160]='K2 L32 A:52921 T:52921,52476 P:29205 I:29189'
G[29161]='K2 L32 A:52671 T:0,52671 P:29198 I:29101,29125,29147,29164'
G[29162]='K2 L32 A:52671,-198 T:52671 P:29161'
G[29163]='K2 L32 A:52669 T:52669 P:29198 I:29123,29127,29149,29166,29246,29247,29248'
G[29164]='K2 L32 A:52669 T:0,52669 P:29198 I:29101,29125,29147,29161'
G[29165]='K2 L32 A:-198,52669 T:52669 P:29164'
G[29166]='K2 L32 A:52669 T:52669 P:29198 I:29123,29127,29149,29163,29246,29247,29248'
G[29167]='HC FH K16 L7866880 A:14444 T:500043 P:172'
G[29168]='L0 E21655'
G[29169]='L35 E21655'
G[29170]='L1 E21655'
G[29171]='L1 E21655'
G[29172]='K512 L35 A:53023 T:53023'	-- PM5
G[29173]='K1600 L35 A:53023 T:53023'	-- PM5
G[29174]='L35 E21655'
G[29175]='K1600 L35 A:53023 T:53023'	-- PM5
G[29176]='HC FH K16 L7866880 A:14444 T:500042 P:172'
G[29177]='K2 L30 A:40578 T:40578 P:25560'
G[29178]='L0 E21655'
G[29179]='K2 L32 A:52824 T:52824 P:29201'
G[29180]='L0 E21655'
G[29181]='L32 A:52135 T:50082 P:H29137,H29138,H29139,H29141,H29142,H29143,H29179,H29304'
G[29182]='L32 A:52669 T:52490 P:29181'	-- TODO: Did not show up the first day after 29181 was done
G[29183]='L35 E21655'
G[29185]='L35 E21655'
G[29186]='K64 L35 A:52925 T:552925'
G[29189]='K2 L32 A:52921 T:52921,52476 P:29205 I:29160'
G[29190]='HC FH L7866880 A:14444 T:14444 P:29146+29167+29176'
G[29191]='HC FH L7866880 A:14444 T:14444 P:29146+29167+29176'
G[29192]='K2 L32 A:52494 T:52494 P:29205 I:29211'
G[29193]='L35 A:15192 T:52835 P:29135'
G[29194]='K64 L10 A:52835 T:53567 P:29193'
G[29195]='L32 A:52838 T:52845 P:29145'
G[29196]='L32 A:52845 T:52669 P:29195'
G[29197]='L32 A:52669 T:52838 P:29196'
G[29198]='L32 A:52838 T:552845 P:29197'
G[29199]='L32 A:552838 T:552838 P:29198'
G[29200]='L32 A:552838 T:52669 P:29199'
G[29201]='L32 A:552845 T:53385 P:29200'
G[29202]='L32 A:52669 T:52986 P:29201'
G[29203]='L32 A:52135 T:52135 P:29279'
G[29204]='K2 L85'
G[29205]='K2 L32 A:52824 T:52494 P:29214+29138+29137|29141|29142|29304+29139|29143+29179 I:29206'
G[29206]='K2 L32 A:52824 T:52444 P:29181+29138+29137|29141|29142|29304+29139|29143+29179 I:29205'
G[29208]='L35 E32305'
G[29209]='K2 L85'
G[29210]='K2 L32 A:52494 T:52823,552823 P:29192,29211'
G[29211]='K2 L32 A:52494 T:52494 P:29205 I:29192'
G[29212]='L0 E21655'
G[29213]='FA L35 A:52234 T:52371 P:29120'
G[29214]='L32 A:52135 T:52844 P:H29137,H29138,H29139,H29141,H29142,H29143,H29179,H29304'
G[29215]='L32 A:52669 T:52493 P:29214'	-- became available the day after it seems, unless I missed it for some reason
G[29216]='L0 E21655'
G[29217]='K64 L35 A:52933 T:52933'
G[29218]='L32'
G[29219]='FH L35 A:53081'
G[29220]='FH L35 A:53081'
G[29221]='L35 E31961'
G[29222]='FH L35 E31961'
G[29223]='L35 E31961'
G[29225]='L35 A:53567 T:52995 P:29194'
G[29226]='FH L35 E31961'
G[29227]='FH L35 E31961'
G[29228]='FH L35 E21655'
G[29230]='FH L35 E31961'
G[29231]='FH L35 E31961'
G[29232]='FH L35 E31961'
G[29233]='FH L35 E31961'
G[29234]='K128 L35 A:52995 T:53009 P:29225'
G[29235]='FH L35 E31961'
G[29236]='FH L35 E31961'
G[29237]='FH L35 E31961'
G[29238]='FH L35 E31961'
G[29239]='L35 A:53009 T:54233 P:29234'
G[29240]='L35 A:53009 T:53149 P:29239'
G[29241]='K1600 L35 A:53024 T:53024'	-- PM5
G[29242]='K1600 L35 A:53043 T:53043'	-- PM5
G[29243]='K2 L32 A:53056 T:52493 P:29210+29214+29283'
G[29245]='L32 A:1208535 T:52489 P:29214'	-- TODO: Deal with the fact that this only appears after killing 52122
G[29246]='K2 L32 A:52986 T:52986 P:29198 I:29123,29127,29149,29163,29166,29247,29248'
G[29247]='K2 L32 A:52986 T:52986 P:29198 I:29123,29127,29149,29163,29166,29246,29248'
G[29248]='K2 L32 A:52986 T:52986 P:29198 I:29123,29127,29149,29163,29166,29246,29247'
G[29249]='L32 A:52489 T:-338,52489 P:29245'
G[29250]='FH L35 E31961'
G[29251]='FH K1600 L35 A:2496 T:2496 P:1+T01544999 I:29252'	-- PM5
G[29252]='FH K1600 L35 A:53151 T:53151 P:1+t01544999 I:29251'	-- PM5
G[29253]='FH L35 A:2496,53151 T:1208420 P:29251,29252'
G[29254]='L32 A:52489 T:52489 P:29249'
G[29255]='K2 L32 A:52489 T:52489 P:29254 I:29257,29299'
G[29257]='K2 L32 A:52489 T:52489 P:29254 I:29255,29299'
G[29258]='K2 L85'
G[29261]='SP K65 L30 A:1208549 P:K100063128+PX425'
G[29262]='SP K1089 L30 A:1208550 P:K100063128+PX425'
G[29263]='K2 L32 A:53196 T:53214 P:29281 I:29278,29295,29297'
G[29264]='K2 L32 A:52444 T:52444 P:29206'
G[29265]='K2 L32 A:52444 T:52492,52467 P:29206'
G[29266]='L1 E21655'
G[29267]='SP FA L35 A:52374 T:52374 P:29121'
G[29268]='FH L35 E31961'
G[29269]='L35 A:53149 T:53210 P:29240'
G[29270]='K128 L35 A:53210 T:53215 P:29269'
G[29271]='L0 E21655'
G[29272]='K32 L32 A:53233 T:52477 P:29181'
G[29273]='K2 L32 A:52477 T:552478 P:29206+29272 I:29274'
G[29274]='K2 L32 A:500019,52478 T:500016,52477,552477 P:29206+29272 I:29273'	-- TODO: Check if all 52477 can be handled by 552477 as well, and 500016
G[29275]='K2 L32 A:500017,52478 T:500016,52477 P:29192+29272,29211+29272 I:29276'
G[29276]='K2 L32 A:500018,52477 T:552478 P:29205+29272 I:29275'
G[29277]='L0 E21655'
G[29278]='K2 L32 A:53196 T:53214 P:29281 I:29263,29295,29297'
G[29279]='L32 A:53881 T:52669 P:29181+29214'
G[29280]='L32 A:52669 T:53881 P:29279'
G[29281]='L32 A:53214 T:52669 P:29181+29214'
G[29282]='L32 A:52669 T:53196 P:29281'
G[29283]='L32 A:53882 T:52906 P:29181+29214'
G[29284]='L32 A:52669 T:52488 P:29283'
G[29285]='L35 A:53215 T:53349 P:29270'
G[29286]='L0 E21655'
G[29287]='K2 L32 A:52491 T:52491 P:29265 I:29288,29289,29290'
G[29288]='K2 L32 A:52491 T:52490,52491 P:29265 I:29287,29289,29290'
G[29289]='K2 L32 A:52491 T:52491 P:29265 I:29293,29296'
G[29290]='K2 L32 A:52491 T:52491,52490 P:29265 I:29287,29288,29289'
G[29291]='K2 L85'
G[29292]='K2 L85'
G[29293]='K2 L32 A:53259 T:53259,52467 P:29265 I:29289,29296'
G[29294]='L0 E21655'
G[29295]='K2 L32 A:53304 T:53214 P:29265 I:29263,29278,29297'
G[29296]='K2 L32 A:53259 T:53259 P:29265 I:29289,29293'
G[29297]='K2 L32 A:54163 T:53214 P:29205 I:29263,29278,29295'
G[29298]='L32 A:100069854 T:11801'	-- need to have earned the Legacy of Leyara achievement
G[29299]='K2 L32 A:52489 T:52489 P:29254 I:29255,29257'
G[29302]='L32 A:11801 T:11801 P:29298'
G[29303]='L32 A:11801 T:-100063 P:29302'
G[29304]='K2 L32 A:52824 T:52824 P:29201 I:29137,29141,29142'
G[29305]='K2 L32 A:52490,52492 T:52490 P:29181+29293+29287+29283,29181+29296+29287+29283,29181+29293+29288+29283,29181+29296+29288+29283,29181+29293+29289+29283,29181+29296+29289+29283,29181+29293+29290+29283,29181+29296+29290+29283'
G[29307]='K128 L35 A:53349 T:53466 P:29285'
G[29308]='K128 L35 A:53349 T:53371 P:29285'
G[29309]='L35 A:53371 T:53422 P:29308'
G[29310]='L32 A:-63 T:-100198 P:29303'
G[29311]='L32 A:-198 T:52135 P:29310'
G[29312]='L35 A:53466 T:53422 P:29307'
G[29313]='FA K2 L10 A:4210 T:4210 P:PC001 I:26153,26177,26183,26190,26192,29314,29316,29318,29351,29352,29353,29355,29356,29357'
G[29314]='FA K2 L10 A:4210 T:1208825 P:PC001 I:26153,26177,26183,26190,26192,29313,29316,29318,29351,29352,29353,29355,29356,29357'
G[29315]='FH K2 L10 A:4552 T:4552 P:PC001 I:26220,26226,26227,26233,26234,26235,29332,29333,29334,29358,29360,29362,29363,29364,29365'
G[29316]='FA K2 L10 A:4210 T:4210 P:PC001 I:26153,26177,26183,26190,26192,29313,29314,29318,29351,29352,29353,29355,29356,29357'
G[29317]='FH K2 L10 A:4573 T:2055 P:PF001 I:26543,26556,26557,26572,26588,29319,29320,29322,29345,29346,29348,29349,29354,29361'
G[29318]='FA K2 L10 A:4210 T:4210 P:PC001 I:26153,26177,26183,26190,26192,29313,29314,29316,29351,29352,29353,29355,29356,29357'
G[29319]='FH K2 L10 A:4573 T:4573 P:PF001 I:26543,26556,26557,26572,26588,29317,29320,29322,29345,29346,29348,29349,29354,29361'
G[29320]='FH K2 L10 A:4573 T:4573 P:PF001 I:26543,26556,26557,26572,26588,29317,29319,29322,29345,29346,29348,29349,29354,29361'
G[29321]='FA K2 L10 A:4156 T:4156 P:PF001 I:29323,29324,29325,29342,29343,29344,29347,29350,29359,26414,26420,26442,26488,26536'
G[29322]='FH K2 L10 A:4573 T:4573 P:PF001 I:26543,26556,26557,26572,26588,29317,29319,29320,29345,29346,29348,29349,29354,29361'
G[29323]='FA K2 L10 A:4156 T:4156 P:PF001 I:29321,29324,29325,29342,29343,29344,29347,29350,29359,26414,26420,26442,26488,26536'
G[29324]='FA K2 L10 A:4156 T:4156 P:PF001 I:29321,29323,29325,29342,29343,29344,29347,29350,29359,26414,26420,26442,26488,26536'
G[29325]='FA K2 L10 A:4156 T:4156 P:PF001 I:29321,29323,29324,29342,29343,29344,29347,29350,29359,26414,26420,26442,26488,26536'
G[29326]='L35 A:54313 T:54312 O:29439,29440'
G[29327]='L35 A:53524 T:53519 P:29335'
G[29328]='L35 A:53652 T:53652 P:29336'
G[29329]='L35 A:53738 T:553738 P:29337'
G[29330]='L35 A:53925 T:0 P:29338'
G[29331]='L35 A:-338 T:54168 P:29330'
G[29332]='FH K2 L10 A:4552 T:4552 P:PC001 I:26220,26226,26227,26233,26234,26235,29315,29333,29334,29358,29360,29362,29363,29364,29365'
G[29333]='FH K2 L10 A:4552 T:4552 P:PC001 I:26220,26226,26227,26233,26234,26235,29315,29332,29334,29358,29360,29362,29363,29364,29365'
G[29334]='FH K2 L10 A:4552 T:53528 P:PC001 I:26220,26226,26227,26233,26234,26235,29315,29332,29333,29358,29360,29362,29363,29364,29365'
G[29335]='L35 A:54312 T:53524 P:29326'
G[29336]='L35 A:53519 T:53677 P:29327'
G[29337]='L35 A:53652 T:42465 P:29328'
G[29338]='L35 A:553738 T:54014 P:29329'
G[29339]='L35 E21655'
G[29340]='L35 E21655'
G[29341]='L35 E21655'
G[29342]='FA K2 L10 A:5161 T:5161 P:PF001 I:29321,29323,29324,29325,29343,29344,29347,29350,29359,26414,26420,26442,26488,26536'
G[29343]='FA K2 L10 A:5161 T:5161 P:PF001 I:29321,29323,29324,29325,29342,29344,29347,29350,29359,26414,26420,26442,26488,26536'
G[29344]='FA K2 L10 A:5161 T:5161 P:PF001 I:29321,29323,29324,29325,29342,29343,29347,29350,29359,26414,26420,26442,26488,26536'
G[29345]='FH K2 L10 A:3028 T:3028 P:PF001 I:26543,26556,26557,26572,26588,29317,29319,29320,29322,29346,29348,29349,29354,29361'
G[29346]='FH K2 L10 A:3028 T:30709 P:PF001 I:26543,26556,26557,26572,26588,29317,29319,29320,29322,29345,29348,29349,29354,29361'
G[29347]='FA K2 L10 A:5161 T:1355 P:PF001 I:29321,29323,29324,29325,29342,29343,29344,29350,29359,26414,26420,26442,26488,26536'
G[29348]='FH K2 L10 A:3028 T:3028 P:PF001 I:26543,26556,26557,26572,26588,29317,29319,29320,29322,29345,29346,29349,29354,29361'
G[29349]='FH K2 L10 A:3028 T:3028 P:PF001 I:26543,26556,26557,26572,26588,29317,29319,29320,29322,29345,29346,29348,29354,29361'
G[29350]='FA K2 L10 A:5161 T:5161 P:PF001 I:29321,29323,29324,29325,29342,29343,29344,29347,29359,26414,26420,26442,26488,26536'
G[29351]='FA K2 L10 A:5159 T:5159 P:PC001 I:26153,26177,26183,26190,26192,29313,29314,29316,29318,29352,29353,29355,29356,29357'
G[29352]='FA K2 L10 A:5159 T:5159 P:PC001 I:26153,26177,26183,26190,26192,29313,29314,29316,29318,29351,29353,29355,29356,29357'
G[29353]='FA K2 L10 A:5159 T:5159 P:PC001 I:26153,26177,26183,26190,26192,29313,29314,29316,29318,29351,29352,29355,29356,29357'
G[29354]='FH K2 L10 A:3028 T:52657 P:PF001 I:26543,26556,26557,26572,26588,29317,29319,29320,29322,29345,29346,29348,29349,29361'
G[29355]='FA K2 L10 A:5159 T:5159 P:PC001 I:26153,26177,26183,26190,26192,29313,29314,29316,29318,29351,29352,29353,29356,29357'
G[29356]='FA K2 L10 A:5159 T:5159 P:PC001 I:26153,26177,26183,26190,26192,29313,29314,29316,29318,29351,29352,29353,29355,29357'
G[29357]='FA K2 L10 A:4210 T:4210 P:PC001 I:26153,26177,26183,26190,26192,29313,29314,29316,29318,29351,29352,29353,29355,29356'
G[29358]='FH K2 L10 A:3026 T:3026 P:PC001 I:26220,26226,26227,26233,26234,26235,29315,29332,29333,29334,29360,29362,29363,29364,29365'
G[29359]='FA K2 L10 A:4156 T:4156 P:PF001 I:29321,29323,29324,29325,29342,29343,29344,29347,29350,26414,26420,26442,26488,26536'
G[29360]='FH K2 L10 A:4552 T:4552 P:PC001 I:26220,26226,26227,26233,26234,26235,29315,29332,29333,29334,29358,29362,29363,29364,29365'
G[29361]='FH K2 L10 A:4573 T:4573 P:PF001 I:26543,26556,26557,26572,26588,29317,29319,29320,29322,29345,29346,29348,29349,29354'
G[29362]='FH K2 L10 A:3026 T:3026 P:PC001 I:26220,26226,26227,26233,26234,26235,29315,29332,29333,29334,29358,29360,29363,29364,29365'
G[29363]='FH K2 L10 A:3026 T:3026 P:PC001 I:26220,26226,26227,26233,26234,26235,29315,29332,29333,29334,29358,29360,29362,29364,29365'
G[29364]='FH K2 L10 A:3026 T:3026 P:PC001 I:26220,26226,26227,26233,26234,26235,29315,29332,29333,29334,29358,29360,29362,29363,29365'
G[29365]='FH K2 L10 A:3026 T:3026 P:PC001 I:26220,26226,26227,26233,26234,26235,29315,29332,29333,29334,29358,29360,29362,29363,29364'
G[29368]='L0 E21655'
G[29371]='HW K258 L7864576 A:52064 T:52064'
G[29372]='L1'
G[29373]='L1'
G[29374]='HW FH K2 L7864576 A:53763 T:53763'
G[29375]='HW FH K258 L7864576 A:53763 T:53763'
G[29376]='HW FH K2 L7864576 A:15197 T:15197 O:29400'
G[29377]='HW FH K258 L7864576 A:15197 T:15197'
G[29378]='L0 T:93812 E21655'
G[29379]='L0 T:93812 E21655'
G[29380]='L0 T:93812 E21655'
G[29381]='L0 T:93812 E21655'
G[29382]='HV L1'
G[29383]='HV L1'
G[29385]='SP HZ L7866880 A:1187236 T:1187236 Z18612'
G[29386]='FA L1 M084'
G[29387]='FA L32 A:1206111,1206294 T:52669'	-- TODO: There is a P: for this
G[29388]='FH L32 A:1206116 T:52669'	-- TODO:	Look at 29387 comment
G[29389]='L32 A:-198 T:52669 P:29390,29391'
G[29390]='FH L32 A:1206109,1206116 T:0 I:25372'
G[29391]='fA L32 A:1206111,1206294,1207320,1207321,1207322 T:0 I:25372'
G[29392]='HW FA L7866880 A:53949 T:53950 O:29430'
G[29393]='SP HB FH K2 L7864576 A:24497 T:24497 P:11412'
G[29394]='SP HB FA K2 L7864576 A:23558 T:23558 P:11122'
G[29395]='L0 T:93812 E21655'
G[29396]='HB FH L7864576 A:24510 T:24495 P:11409+k100056836'
G[29397]='HB FA L7864576 A:24468 T:23710 P:11318+k100056836'
G[29398]='HW FA L7866880 A:53950 T:8719 P:29392'
G[29399]='HW L7866880 A:8719 T:54021 P:29398'
G[29400]='HW FH K16 L7864576 A:19169,519169,500099,500100,500101,500102,500103,500104,19175,519175,19176,519176,19177,519177,500105,19178,519178,20102,520102,500106,500107,500108,500109,500110,500111,500112,500113,500114,500115,500116,500117,500118,500119,500120,500121,500122,500123,500124,500125,500126,500127,500128,500129,500130 T:15197'
G[29401]='FH L10 A:54004 T:54004'
G[29402]='HW FA L7866880 A:54021 T:54021 P:29399'
G[29403]='HW FA L7866880 A:54021 T:1209072 P:29402'
G[29404]='L1 Z19033'
G[29405]='L1'
G[29406]='L1 RA RA RA A:53566 T:53566 P:30027,30033,30034,30035,30036,30037,30038'
G[29407]='L2'
G[29408]='L1 RA RA RA A:553566 T:553566 P:29524'
G[29409]='L1 RA RA RA A:553566 T:500054 P:29408'
G[29410]='L1 RA RA RA A:500054 T:54943 P:29409'
G[29411]='HW L7866880 A:1209072 T:53949,54118 P:29403 I:529411 OTC:53949+529411'
G[29412]='FA L10 A:54117 T:54117'
G[29413]='HW FA L1 AP:500024:529411;1209076:29411 TP:500024:529411;1209076:29411 P:529411,29411'
G[29414]='L1 RA RA RA A:54567 T:54608 P:29419+29424'
G[29415]='HW FH L7866880 A:54141 T:54142 O:29431'
G[29416]='HW FH L7866880 A:54142 T:44866 P:29415'
G[29417]='L1 RA RA RA A:54568 T:54568 P:29522'
G[29418]='L1 RA RA RA A:54568 T:54568 P:29417'
G[29419]='L1 RA RA RA A:54943 T:554943 P:29410'
G[29420]='L1 RA RA RA A:54609 T:54135 P:29418+29523'
G[29421]='L1 RA RA RA A:54135 T:54135 P:29664'
G[29422]='L1 RA RA RA A:54135 T:54787 P:29421'
G[29423]='L1 RA RA RA A:54787 T:54786 P:29422'
G[29424]='L1 RA RA RA A:54943 T:554943 P:29410'
G[29425]='HW FH L7866880 A:44866 T:54146 P:29416'
G[29426]='HW FH L7866880 A:54146 T:54146 P:29425'
G[29427]='HW FH L7866880 A:54146 T:1209094 P:29426'
G[29428]='HW FH L7866880 A:1209094 T:54141,54146 P:29427 I:529428 OTC:54141+529428'
G[29429]='HW FH L1 AP:1209095:29428;500025:529428 TP:1209095:29428;500025:529428 P:29428,529428'
G[29430]='HW FA L7866880 A:51934 T:53949'
G[29431]='HW FH L7866880 A:53763 T:54141'
G[29432]='K128 L85 P:29225'	-- TODO: Determine if this is just really a Blizzard-ism for 29234
G[29433]='HF K8 L7864576 A:14832 T:14832'
G[29434]='HF K2 L7864576 A:54605 T:54605'
G[29436]='HF K2 L7864576 A:15303 T:15303'
G[29437]='L35 A:52793 T:0 P:29326'
G[29438]='HF K2 L7864576 A:14841 T:14841'
G[29439]='fA L35 A:45226 T:54313'
G[29440]='L35 A:45244 T:54313'
G[29441]='L10'
G[29443]='K8 L7866880 A:100071635 T:14847'
G[29444]='K8 L7866880 A:100071636 T:14829'
G[29445]='K8 L7866880 A:100071637 T:14822'
G[29446]='K8 L7866880 A:100071638 T:14847'
G[29447]='L0 T:88674'
G[29449]='L0 T:88674'
G[29450]='L0 T:88674'
G[29451]='K8 L7866880 A:100071715 T:14847'
G[29452]='L35 CD CM CT CS CL AP:52382:J4842,J4850,J4851 AK:53310 T:52382'
G[29453]='L35 CD CM CT CS CL AP:52408:J4842,J4850,J4851 AK:53310 T:52408'
G[29454]='L0 T:88674'
G[29455]='HF K2 L7864576 A:54485 T:54485'
G[29456]='K8 L7866880 A:100071951 T:14847'
G[29457]='K8 L7866880 A:100071952 T:14847'
G[29458]='K8 L7866880 A:100071953 T:14847'
G[29459]='L0 E21655'
G[29463]='HF K2 L7864576 A:54601 T:54601'
G[29464]='K8 L60 A:100071716 T:14847'
G[29466]='L1 T:88674'
G[29470]='L1 T:88674'
G[29472]='L1 T:88674'
G[29473]='L1 T:88674'
G[29475]='L20 A:11017 T:5174,5518,11017,11031 P:PN200'
G[29477]='L20 AA:5174,5518 AH:11017,52651 TA:5518,7944 TH:11017,52651 P:PN200'
G[29480]='L1 T:154653'
G[29481]='L1 AA:5177,5499,16723,4160 AH:3347,3009,4611,16642 TA:5177,5499,16723,4160 TH:3347,3009,4611,16642 P:PA475'
G[29482]='L1 AA:5177,5499,16723,4160 AH:3347,3009,4611,16642 TA:5177,5499,16723,4160 TH:3347,3009,4611,16642 P:PA475'
G[29484]='L1 T:88674'
G[29506]='HF K8 L15 A:14844 T:14844 P:PA075'
G[29507]='HF K8 L7864576 A:14847,30481 T:14847 P:PX075'
G[29508]='HF K8 L22 A:14829 T:14829 P:PB075'
G[29509]='HF K8 L7864576 A:14845 T:14845 P:PC075'
G[29510]='HF K8 L7864576 A:14822 T:14822 P:PE075'
G[29511]='HF K8 L7864576 A:14841 T:14841 P:PN075'
G[29512]='HF K8 L7864576 A:14833 T:14833 P:PZ075'
G[29513]='HF K8 L7864576 A:14845 T:14845 P:PF075'
G[29514]='HF K8 L7864576 A:14833 T:14833 P:PH075'
G[29515]='HF K8 L22 A:14822 T:14822 P:PI075'
G[29516]='HF K8 L7864576 A:14833 T:14833 P:PJ075'
G[29517]='HF K8 L7864576 A:14841 T:14841 P:PL075'
G[29518]='HF K8 L7864576 A:14841 T:14841 P:PM075'
G[29519]='HF K8 L7864576 A:14833 T:14833 P:PS075'
G[29520]='HF K8 L7864576 A:10445 T:10445 P:PT075'
G[29521]='L1 RA RA RA A:54786 T:54975 P:29423'
G[29522]='L1 RA RA RA A:54608 T:54568 P:29414'
G[29523]='L1 RA RA RA A:54568 T:54568 P:29417'
G[29524]='L1 RA RA RA A:53566 T:553566 P:29406'
G[29527]='FH K64 L10 A:54606 T:54606'
G[29528]='FA K64 L10 A:54603 T:54603'
G[29529]='FA K64 L10 A:54603 T:54603'
G[29530]='FH K64 L10 A:54606 T:54606'
G[29531]='L85'
G[29533]='L15 E21655'
G[29534]='L85'
G[29535]='FH K64 L10 A:54636 T:54636'
G[29536]='FH K64 L10 A:54636 T:54636'
G[29537]='FH K64 L10 A:54636 T:54636'
G[29538]='FA K64 L10 A:54629 T:54629'
G[29539]='FA K64 L10 A:54629 T:54629'
G[29540]='FA K64 L10 A:54629 T:54629'
G[29541]='L85'
G[29542]='FH K64 L10 A:19256 T:54606'
G[29543]='FA K64 L10 A:19309 T:54603'
G[29544]='FH K64 L15 T:54636'
G[29545]='FA K64 L15 T:54629'
G[29546]='L21846'
G[29547]='FA L10 AZ:84,390 T:55789'	-- this might be available anywhere when one logs in
G[29548]='FA L10 A:55789 T:66292 P:29547'
G[29549]='L21846'
G[29550]='L21846'
G[29551]='L21846'
G[29552]='FA L10 A:54614 T:54614 P:31736+31737'
G[29553]='FA L10 A:54615 T:59022 P:29555+29556'
G[29554]='L21846'
G[29555]='FA L10 A:566292 T:54615 P:31745'
G[29556]='FA L10 A:566292 T:54615 P:31745'
G[29557]='L21846'
G[29558]='FA L10 A:55196 T:55196 P:29553'
G[29559]='FA L10 A:55196 T:55196 P:29553'
G[29560]='FA L10 A:55196 T:55196 P:29553'
G[29561]='L21846'
G[29562]='FA L10 A:55196 T:56222 P:29759'
G[29563]='K64 L10 A:54667 T:54667'
G[29564]='K64 L10 A:54668 T:54668'
G[29565]='K64 L10 A:54667 T:54667'
G[29566]='K64 L10 A:17841 T:54667'
G[29567]='K64 L10 A:54674 T:54674'
G[29568]='K64 L10 A:54678 T:54678'
G[29569]='L10 E21655'
G[29570]='K64 L10 A:54675 T:54675'
G[29571]='K64 L10 A:18074 T:54675'
G[29572]='L10 E21655'
G[29573]='K64 L15 A:54692 T:54692'
G[29574]='K64 L15 A:54694 T:54694'
G[29575]='K64 L15 A:54692 T:54692'
G[29576]='L10 A:59383 T:54697'	-- P:29922,30015 seems to be wrong, at least for Alliance, because 29922 not turned in and this available
G[29577]='L15 A:56866 T:56802 O:29871 OAC:30087'
G[29578]='L10 A:54697 T:54697 O:29576'
G[29579]='L10 A:54697 T:54697'
G[29580]='L10 A:54854 T:54854'
G[29581]='L15 A:56802 T:56773 P:29577'
G[29582]='FH K64 L15 A:19606 T:54692'
G[29583]='FA K64 L15 A:21400 T:54692'
G[29584]='L21846'
G[29585]='L10 A:54854 T:54854'	-- correct with both factions and no obvious preqs build 15913
G[29586]='L10 A:55209 T:55009 P:29578+29579+29580+29585'	-- verify as required: 29579 29585
G[29587]='L10 A:55009 T:55009 P:29586'
G[29590]='K64 L15 A:54725 T:54725'
G[29591]='K64 L15 A:54698 T:54698'
G[29592]='L0 T:92031'
G[29593]='FH K64 L10 A:54606 T:54606'
G[29594]='FA K64 L10 A:54603 T:54603'
G[29595]='K64 L15 A:19698 T:54725'
G[29596]='K64 L15 A:54725 T:54725 O:29595'
G[29597]='L10 E21655'
G[29598]='K64 L15 A:18723 T:17876 O:10282'
G[29599]='K64 L15 A:17876 T:18723 P:29598'
G[29600]='L15 A:56802 T:56802'
G[29601]='HF L256 AA:54334 AH:55382 I:7926,7905 Z15640'
G[29602]='L0'
G[29603]='L0'
G[29604]='L0'
G[29605]='K64 L15 A:54840 T:54840'
G[29606]='K64 L15 A:54840 T:54840'
G[29607]='K64 L15 A:54847 T:54847'
G[29608]='FA L10 A:23736,26879 T:32413'
G[29609]='FH L10 A:25288,27344 T:27344'
G[29610]='L0'
G[29611]='FH L10 A:1206109,1206116 AZ:85,390 T:54870 I:29612'	-- boosted to 100 does not get this automatically entering Orgrimmar
G[29612]='FH L10 T:54870 I:29611'
G[29613]='K64 L20 A:54848 T:54848'
G[29614]='K64 L20 A:54849 T:54849'
G[29615]='K64 L20 A:54851 T:54851'
G[29616]='K64 L20 A:17841 T:54848'
G[29617]='L10 A:54998 T:54913'	-- P:29922,30015 seems to be wrong, at least for Alliance, because 29922 not turned in and this available
G[29618]='L10 A:54913 T:54914 O:29617'
G[29619]='L10 A:54913 T:54913 P:29618'
G[29620]='L10 A:54913 T:554914 P:29619'
G[29621]='L85'
G[29622]='L10 A:54926 T:54917 P:29620'
G[29623]='L10 A:54917 T:54917 P:29622'
G[29624]='L10 A:54917 T:54917 P:29623'
G[29625]='L85'
G[29626]='L10 A:54926 T:54915 P:29620'
G[29627]='L10 A:54915 T:54915 P:29626'
G[29628]='L10 A:54915 T:54915 P:29627'
G[29629]='L10 A:54915 T:54915 P:29627'
G[29630]='L10 A:54915 T:54915 P:29627'
G[29631]='L10 A:55094 T:55094 P:29627'
G[29632]='L10 A:54922 T:54922 P:29620'
G[29633]='L10 A:54922 T:54922 P:29632'
G[29634]='L10 A:54922 T:54922 P:29632'
G[29635]='L10 A:54922 T:54922 P:29633+29634'
G[29636]='L10 A:54922 T:54918 P:29635'
G[29637]='L10 A:54918 T:54918 P:29636'
G[29638]='L85 I:29639,29646,29647'	-- this was I with 29639, 29646 and 29647 but removed to make UI cleaner
G[29639]='L10 A:54917 T:54914 P:29624+29628+29629+29630+29637 I:29646,29647'
G[29640]='K64 L20 A:54891 T:18891'
G[29641]='L20 A:18891 T:54891 P:29640'
G[29642]='L20 A:18893 T:54890'
G[29643]='L20 A:54890 T:1182947 P:29642'
G[29644]='L20 A:1182947 T:54890 P:29643'
G[29645]='K64 L20 A:54890 T:54890'
G[29646]='L10 A:54915 T:54914 P:29624+29628+29629+29630+29637 I:29639,29647'
G[29647]='L10 A:54918 T:54914 P:29624+29628+29629+29630+29637 I:29639,29646'
G[29648]='L85'
G[29649]='FA K64 L20 A:54933 T:55138,54933'
G[29650]='FH K65 L20 A:54931 T:55136,54931'
G[29651]='FH K64 L20 A:54932 T:55136'
G[29652]='FA K64 L20 A:54934 T:55138'
G[29653]='FH K64 L20 A:54931 T:55136'
G[29654]='FA K64 L20 A:54933 T:55138'
G[29655]='FH K64 L20 A:54931 T:55136'
G[29656]='FA K64 L20 A:54933 T:55138'
G[29657]='K64 L20 A:-32 AZ:267 T:18481'	-- A:19219
G[29658]='K64 L20 A:18481 T:0 P:29657'
G[29659]='K64 L20 A:-32 AZ:267 T:0'
G[29660]='K64 L20 AZ:266 T:0'
G[29661]='L1 RA RA RA A:54975 T:54975 P:29521'
G[29662]='L1 RA RA RA A:55021 T:55021'
G[29663]='L1 RA RA RA A:54975 T:54975 P:29521'
G[29664]='L1 RA RA RA A:54135 T:54135 P:29420'
G[29665]='L1 RA RA RA A:55940 T:55940 P:29796'
G[29666]='L1 RA RA RA A:55020 T:555020,55020 P:29676'
G[29667]='K64 L20 A:0 T:0 P:29660'
G[29669]='K64 L20 A:0 T:0 P:29667'
G[29670]='L10 A:55009 T:55009 P:29586'
G[29671]='L20'	-- probably not in game
G[29672]='L20'	-- probably not in game
G[29673]='L20'	-- probably not in game
G[29674]='K64 L25 AZ:269 T:20873'
G[29675]='L25 A:-269 T:20885'
G[29676]='L1 RA RA RA A:54975 T:55020 P:29661+29662+29663'
G[29677]='L1 RA RA RA A:55020 T:555020,55020 P:29676'
G[29678]='L1 RA RA RA A:555020,55020 T:-808 P:29666+29677'
G[29679]='L1 RA RA RA A:-808,554975 T:554975 P:29678'
G[29680]='L1 RA RA RA A:554975 T:55477 P:29679'
G[29681]='L25 A:20885 T:20912'
G[29682]='L25 A:24967 T:55007 P:11481,11482'
G[29683]='L1 A:24822 T:24848 P:29682'
G[29684]='K64 L25 A:55007 T:24822'
G[29685]='L25 A:24848 T:55007 P:29683'
G[29686]='K64 L25 A:55007 T:55007'
G[29687]='K64 L25 A:55007 T:55007'
G[29688]='FH K64 L20 A:16575 T:54931'
G[29689]='FA K64 L20 A:16819 T:54933'
G[29690]='FH L10 A:55054 T:55135 P:31853'
G[29691]='K64 L10 A:54674 T:54674'
G[29692]='SP K65 L10 A:54674 T:54674 P:29691'
G[29693]='L1'
G[29694]='FH L10 A:66656 T:66845 P:31769'	-- forced acceptance when entering parts of The Jade Forest
G[29695]='L0'
G[29696]='L1'
G[29697]='L0'
G[29698]='L0'
G[29699]='L0'
G[29700]='L0'
G[29701]='L0'
G[29702]='L0'
G[29703]='L1'
G[29704]='L0'
G[29705]='L1'
G[29706]='L1'
G[29707]='L0'
G[29708]='L0'
G[29709]='L0'
G[29710]='L0'
G[29711]='L0'
G[29712]='L21846'
G[29713]='L21846'
G[29714]='L21846'
G[29715]='L10'
G[29716]='L10 A:55234 T:55274 P:31230'
G[29717]='L10 A:55274 T:55274,55413 P:C29716'	-- it seems you need to be in the area for 29716 for the "companion NPC 55274" to offer this quest.  whether you need to be on 29716 is not known.
G[29718]='L21846'
G[29719]='L85'
G[29720]='L85'
G[29721]='L85'
G[29722]='L10'
G[29723]='L10 A:55274 T:55413 P:29716'
G[29724]='L21846'
G[29725]='FA L10 A:55282 T:55282 P:29733'
G[29726]='FA L10 A:55284 T:55284 P:29725'
G[29727]='FA L10 A:55283 T:55283 P:29726'
G[29728]='FA L10'
G[29729]='L21846'
G[29730]='FH L10 A:55648 T:55648 P:31239 O:29971'	-- TODO: Investigate report that it should be P:29971 instead of current P: and O:
G[29731]='FH L10 A:55646 T:55646 P:29730'
G[29732]='L21846'
G[29733]='FA L10 A:55333 T:55333 P:29894'
G[29734]='SP HL K16 L7864576 A:55216 T:55216'
G[29735]='SP HL K16 L7864576 A:55217 T:55217'
G[29736]='SP HL K16 L7864576 A:55218 T:55218'
G[29737]='SP HL K16 L7864576 A:55219 T:55219'
G[29738]='SP HL K16 L7864576 A:55228 T:55228'
G[29739]='SP HL K16 L7864576 A:55224 T:55224'
G[29740]='SP HL K16 L7864576 A:55227 T:55227'
G[29741]='SP HL K16 L7864576 A:55210 T:55210'
G[29742]='SP HL K16 L7864576 A:55211 T:55211'
G[29743]='L10 A:1212181 T:0 P:31774'
G[29744]='L10'
G[29745]='L10 A:55438 T:0'
G[29746]='L21846'
G[29747]='L10 A:-371 T:0 P:29745'
G[29748]='L10 A:1214871 T:0 P:29745'
G[29749]='L10 A:-371 T:55614 P:29747+29748'
G[29750]='L10 A:55614 T:55614 P:29749'
G[29751]='L10 A:55614 T:55614 P:29749'
G[29752]='L10 A:55614 T:55614 P:29749'
G[29753]='L10 A:55614 T:55614 P:29750'
G[29754]='L10 A:55963 T:0 P:29753+29756'
G[29755]='L10 A:-371 T:59492 P:29754'
G[29756]='L10 A:55614 T:55614 P:29750+29751+29752'
G[29757]='L15 A:56773 T:56773'
G[29758]='L15 A:100083767 T:56773'
G[29759]='FA L10 A:55196 T:55196 P:29558+29559+29560'	-- TODO: Verify required 29559
G[29760]='L341'
G[29761]='L85'
G[29762]='FA L10 A:56366 T:56222 P:29883+29885'
G[29763]='FA K64 L10 A:24111 T:24111'
G[29764]='FA K64 L10 A:24111 T:24111'
G[29765]='FH L10 A:55403 T:55497 P:31774'
G[29766]='L21846'
G[29767]='L21846'
G[29768]='L1 RA RA RA A:55477 T:55477 P:29769+29770'
G[29769]='L1 RA RA RA A:55477 T:55477 P:29680'
G[29770]='L1 RA RA RA A:55479 T:55479 P:29680'
G[29771]='L1 RA RA RA A:55478 T:55478 P:29769+29770'
G[29772]='L1 RA RA RA A:55477 T:55477 P:29768'
G[29773]='L6'
G[29774]='L1 RA RA RA A:55477 T:55477 P:29771+29772'
G[29775]='L1 RA RA RA A:55477 T:554786 P:29774'
G[29776]='L1 RA RA RA A:554786 T:55583 P:29775'
G[29777]='L1 RA RA RA A:55588 T:55588 P:29776'
G[29778]='L1 RA RA RA A:55583 T:55583 P:29776'
G[29779]='L1 RA RA RA A:55583 T:55583,65558,565558 P:29777+29778+29783'
G[29780]='L1 RA RA RA A:55583 T:55583,65558,565558 P:29777+29778+29783'
G[29781]='L1 RA RA RA A:55583 T:55583,65558,565558 P:29777+29778+29783'
G[29782]='L1 RA RA RA A:1209673 T:55585 P:29783'
G[29783]='L1 RA RA RA A:55585 T:55585 P:29776'
G[29784]='L1 RA RA RA A:55583,65558,565558 T:55595 P:29779+29780+29781+29782'	-- TODO: Verify requires 29782
G[29785]='L1 RA RA RA A:55595 T:55592 P:29784'
G[29786]='L1 RA RA RA A:555595 T:55586 P:29785'
G[29787]='L1 RA RA RA A:55586 T:55672 P:29786'
G[29788]='L1 RA RA RA A:55672 T:55672 P:29787'
G[29789]='L1 RA RA RA A:55672 T:55672 P:29787'
G[29790]='L1 RA RA RA A:55672 T:56662 P:29788+29789'
G[29791]='L1 RA RA RA A:56662 T:56012 P:29790'
G[29792]='L1 RA RA RA A:56012 T:55943 P:29791'
G[29793]='L1 RA RA RA A:55942 T:55942 P:30589'
G[29794]='L1 RA RA RA A:55944 T:55944 P:29796'
G[29795]='L1 RA RA RA A:60042 T:60042 P:29792'
G[29796]='L1 RA RA RA A:55942 T:55944 P:29793+30590'
G[29797]='L1 RA RA RA A:55944 T:55944 P:29796'
G[29798]='L1 RA RA RA A:55940 T:56418 P:29665+29794+29797'
G[29799]='L1 RA RA RA A:56418 T:56418 P:29798'
G[29800]='L1 RA RA RA A:57739 T:56013 P:29799'
G[29801]='L35 CR'
G[29802]='L35 CR P:29801'
G[29803]='K64 L10 A:24111 T:24111'
G[29804]='FH L10 A:55497 T:65999 P:29765'
G[29805]='L0'
G[29806]='L1'
G[29807]='K64 L15 A:55564 T:55564'
G[29808]='K64 L15 A:55564 T:55564'
G[29809]='L30'
G[29810]='L1'
G[29811]='K64 L15 A:55564 T:55564'
G[29812]='L85'
G[29813]='L85'
G[29814]='L85'
G[29815]='FH L10 A:55180 T:55180 P:31999'
G[29816]='L85'
G[29817]='L85'
G[29818]='L85'
G[29819]='L85'
G[29820]='L10'
G[29821]='FH L10 A:555521 T:62923 P:31999'
G[29822]='FH L10 A:55172 T:55768 P:29827+31112'	-- removed  I:31195 as this might be a flag that Dook Ookem is killed.  TODO: Attempt to verify this
G[29823]='FH L10 A:55648 T:55648 P:29731'
G[29824]='FH L10 A:55647 T:55647 P:29823'
G[29825]='L15 A:55658 T:0'
G[29826]='L15 A:55658 T:0'
G[29827]='FH L10 A:55180 T:55180 P:29815'
G[29828]='K64 L15 A:55677 T:55677'
G[29829]='K64 L15 A:16128 T:30658'
G[29830]='K64 L15 A:30658 T:30658 O:29829'
G[29831]='L85'
G[29832]='L85'
G[29833]='K64 L20 A:528401 T:55738 I:29836'
G[29834]='K64 L20 A:55738 T:55738'
G[29835]='K64 L20 A:55737 T:55737'
G[29836]='K64 L20 A:28527 T:55737 I:29833'
G[29837]='L21846'
G[29838]='K64 L20 A:55737 T:55737'
G[29839]='K64 L20 A:55738 T:55738'
G[29840]='K64 L20 A:55737 T:55737'
G[29841]='L1'
G[29842]='L21846'
G[29843]='L85'
G[29844]='K64 L20 A:55738 T:55738'
G[29845]='L85'
G[29846]='L85'
G[29847]='L35 CR P:29934'
G[29848]='K64 L20 A:55835 T:55835'
G[29849]='L85'
G[29850]='K64 L20 A:55835 T:55835'
G[29851]='K64 L25 A:0 T:0'
G[29852]='L85'
G[29853]='L1'
G[29854]='L85'
G[29856]='L1'
G[29857]='L85'
G[29858]='L21846'
G[29859]='L85'
G[29860]='K64 L20 A:56027 T:56027'
G[29861]='L20 A:56027 T:56027'
G[29862]='K64 L20 A:56027 T:56027'
G[29863]='L20 A:30105 T:56027 P:13047 I:29861'
G[29864]='K64 L20 A:56072 T:56072'
G[29865]='L10 A:56062 T:56062 P:31230'
G[29866]='L10 A:59178 T:59178 P:31230'
G[29867]='L85'
G[29868]='L85'
G[29869]='L21846'
G[29871]='L15 A:56110 T:56113 P:30086,30087'
G[29872]='L15 A:56110 T:56111 P:30086,30087'
G[29873]='L15 A:56110 T:56115 P:30086,30087'
G[29874]='FA L15 A:56110 T:500070,56114 P:30086,30087 I:29875'
G[29875]='FH L15 A:56110 T:56112,556112 P:30086,30087 I:29874'	-- Blizzard's quest tells you to go the first NPC, but if he has moved then you need to go to the second, even though the Blizzard map puts the ? at the first location.
G[29876]='L85'
G[29877]='L15 A:56440 T:56440 P:29907'
G[29878]='L21846'
G[29879]='FH L10 A:63307 T:56313 P:31167'
G[29880]='L21846'
G[29881]='L10 A:56064 T:56064'
G[29882]='L10 A:56063 T:56063'
G[29883]='FA L10 A:66949 T:66949 P:29562'
G[29884]='L0'
G[29885]='FA L10 A:66949 T:66949 P:29562'
G[29886]='FA L10'
G[29887]='FA L10 A:59058 T:59058 P:29883+29885'
G[29888]='FA L10 A:56222 T:1209845 P:29727'
G[29889]='FA L10 A:1209845 T:54961 P:29888'
G[29890]='FA L10 A:56287 T:56434 P:29891+29892+29893'	-- TODO: Verify required 29891
G[29891]='FA L10 A:61218 T:56287 P:31130'
G[29892]='FA L10 A:61218 T:56287 P:31130'
G[29893]='FA L10 A:61218 T:56287 P:31130'
G[29894]='FA L10 A:59058 T:56222 P:29762+29887'
G[29895]='FA L10'
G[29896]='L21846'
G[29897]='L21846'
G[29898]='FA L10 A:56434 T:56433 P:29890'
G[29899]='FA L10 A:56432 T:56432 P:29890'
G[29900]='FA L10 A:56433 T:56432 P:29890'
G[29901]='FA L10 A:-371 T:60970 P:29898+29899+29900'	-- TODO: Verify required 29899
G[29902]='L21846'
G[29903]='FA L10 A:60970 T:60970 P:29727'
G[29904]='FA L10 A:60970 T:60970 P:29903'
G[29905]='FA L10 A:60970 T:54960 P:29904'
G[29906]='FA L10 A:60970 T:54960 P:29904'
G[29907]='L15 A:56133 T:56204'
G[29908]='L15 A:56204 T:56204 P:29907'
G[29909]='L15 A:56204 T:56207 P:29877+29908'
G[29910]='L15 A:56465 T:56465 P:29909'
G[29911]='L15 A:56207 T:56204 P:29940'
G[29912]='L15 A:56204 T:56205 P:29911'
G[29913]='L15 A:56205 T:56205 P:29912'
G[29914]='L15 A:56205 T:56205 P:29912'
G[29915]='L15 A:56205 T:56208 P:29913+29914'
G[29916]='L15 A:56208 T:56208 P:29915'
G[29917]='L15 A:56208 T:56208 P:29915'
G[29918]='L15 A:56312 T:556312 P:29916+29917'
G[29919]='K32 L15 A:500068 T:56474 P:29918'
G[29920]='L10 A:56708 T:55788 P:29995'
G[29922]='FA L10 A:554960 T:63577 P:29901'
G[29923]='L21846'
G[29924]='FH L10 A:56327 T:0 P:29879'
G[29925]='L10 A:56348 T:56345 P:29723'
G[29926]='L10 A:56346 T:56346 P:29928'
G[29927]='L10 A:56346 T:56347 P:29928'
G[29928]='L10 A:56346 T:56346 P:29925'
G[29929]='L10 A:56347 T:56467 P:29927'
G[29930]='L10 A:56467 T:56346 P:29929'
G[29931]='L10 A:56346 T:59391 P:29930'
G[29932]='L10 A:59391 T:56782 P:30495'
G[29933]='FH L10 A:56351 T:56336 P:29879'
G[29934]='L35 CR P:29802'
G[29935]='FH L10 A:56313 T:56336 P:29879'
G[29936]='FH L10 A:56336 T:56339 P:29935'
G[29937]='FH L10 A:56406 T:56406,556406 P:29941'
G[29938]='L10'
G[29939]='FH L10 A:56406,556406 T:556406 P:29937'
G[29940]='L15 A:56207 T:56207 P:29909'
G[29941]='FH L10 A:56339 T:56339 P:29936'
G[29942]='FH L10 A:56358 T:56358 P:29937'
G[29943]='FH L10 A:556339 T:56490 P:29824'
G[29944]='L15 A:556133 T:556133 P:29919'
G[29945]='L15 A:56138 T:56138 P:29919'
G[29946]='L15 A:556133 T:556133 P:29944'
G[29947]='L15 A:56138 T:56138 P:29945'
G[29948]='L15 A:56474 T:56474 P:29944'
G[29949]='L15 A:556133 T:556138 P:29946+29947+29948'
G[29950]='L15 A:556138 T:556138 P:29949'
G[29951]='L15 A:56474 T:56474 P:29949'
G[29952]='L15 A:500055 T:500055 P:29950'
G[29966]='FH L10 A:56490 T:56339 P:29943'
G[29967]='FH L10 A:556406 T:56525 P:29968'
G[29968]='FH L10 A:500083 T:556406 P:B29943'
G[29969]='L1'
G[29970]='L1'
G[29971]='FH L10 A:556406 T:55647 P:29939+29942+31239'	-- TODO: Verify requires 29942
G[29981]='L15 A:56111 T:56720 O:29872 OAC:30087'
G[29982]='L15 A:56720 T:56720'
G[29983]='L15 A:56720 T:56714 P:29981+29982'
G[29984]='L15 A:56714 T:56714 P:29983'
G[29985]='L15 A:56714 T:56714 P:29984'
G[29986]='L15 A:56714 T:56714 P:29984'
G[29987]='L15 A:56714 T:56714 P:29992+29985+29986'
G[29988]='L15 A:56714 T:56714 P:29987'
G[29989]='L15 A:56714 T:56714 P:29988'
G[29990]='L15 A:556111 T:56720 P:29989'	-- OEC:30629 OPC:30117+30273+30445,30117+30273+30174
G[29992]='L15 A:556111 T:556111 P:29984'
G[29993]='L10 A:59173 T:56065 P:29866'
G[29995]='L10 A:56065 T:56708 P:29993'
G[29997]='L10 A:56782 T:56787 P:29932'
G[29998]='L10 A:56782 T:56786 P:29932'
G[29999]='L10 A:56784 T:56784 P:29932'
G[30000]='L10 A:56784 T:57242 P:29999+30004+30005+30011'	--	TODO: Verify requires 30005 30011
G[30001]='L10 A:56786 T:56786 P:29998'
G[30002]='L10 A:56786 T:56786 P:29998'
G[30003]='L10'
G[30004]='L10 A:56786 T:56782 P:30001+30002'
G[30005]='L10 A:56784 T:56784 P:29932'
G[30006]='K2 L10 A:57324 T:57324 I:V0261,V0271,V0281,V0291,V0301,V0311,V0321,V0331,V0421 D022'	-- TODO: Each of the D022 quests has a prerequisite because just arriving in Jade Forest off the ship does not have them available.
G[30007]='L0'
G[30009]='L85'
G[30011]='L10 A:56787 T:56782 P:29997'
G[30015]='FH L10 A:556339 T:63577 P:29967'
G[30019]='L22103'
G[30020]='L22103'
G[30021]='L22103'
G[30027]='L1 RA RA RA CO A:53566 T:53566'
G[30028]='L15 A:57211 T:57211 P:30029+30030+30031'
G[30029]='L15 A:57211 T:57211 P:30048'
G[30030]='L15 A:57209 T:57209 P:30048'
G[30031]='L15 A:500058 T:500058 P:30048'
G[30032]='L15 A:57211 T:500058 P:30029+30030+30031'
G[30033]='L1 RA RA RA CM A:53566 T:53566'
G[30034]='L1 RA RA RA CH A:53566 T:53566'
G[30035]='L1 RA RA RA CT A:53566 T:53566'
G[30036]='L1 RA RA RA CR A:53566 T:53566'
G[30037]='L1 RA RA RA CS A:53566 T:53566'
G[30038]='L1 RA RA RA CW A:53566 T:53566'
G[30039]='L1 RA CO AZ:808 T:53566 Z19033'
G[30040]='L1 RA CM AZ:808 T:53566 Z19033'
G[30041]='L1 RA CH AZ:808 T:53566 Z19033'
G[30042]='L1 RA CT AZ:808 T:53566 Z19033'
G[30043]='L1 RA CR AZ:808 T:53566 Z19033'
G[30044]='L1 RA CS AZ:808 T:53566 Z19033'
G[30045]='L1 RA CW AZ:808 T:53566 Z19033'
G[30046]='L15 A:500055 T:500056 P:29951+29952'
G[30047]='L15 A:500058 T:500056 P:30032'
G[30048]='L15 A:500056 T:500058 P:30046'
G[30049]='L15 A:500056 T:556474 P:30046'
G[30050]='L15 A:62377 T:62377 P:30046'
G[30051]='L15 A:556474 T:58785 P:30049'
G[30052]='L15 A:57385 T:57385 P:30046'
G[30053]='L15 A:500056 T:-376 P:30046'
G[30054]='L15 A:57401 T:57401 P:30046'
G[30055]='L15 A:-376 T:500056 P:30050+30052+30053+30054'	-- I have a toon that did all the farmer quests first and then accepted 30053 and then when that was turned in, 30055 became available.
G[30056]='L15 A:62385 T:57408 P:30046'
G[30057]='L15 A:57408 T:57402 P:30056'
G[30058]='L15 A:57407 T:57407 P:30059'
G[30059]='L15 A:57424 T:57424'
G[30063]='K2 L10 A:57319 T:57319 I:V0261,V0271,V0281,V0291,V0301,V0311,V0321,V0331,V0421 D022'
G[30064]='K2 L10 A:57319 T:57319 I:V0261,V0271,V0281,V0291,V0301,V0311,V0321,V0331,V0421 D022'
G[30065]='K2 L10 A:57324 T:57324 I:V0261,V0271,V0281,V0291,V0301,V0311,V0321,V0331,V0421 D022'
G[30066]='K2 L10 A:57324 T:57324 I:V0261,V0271,V0281,V0291,V0301,V0311,V0321,V0331,V0421 D022'
G[30067]='K2 L10 A:57324 T:57324 P:W0223 I:30068'
G[30068]='K2 L10 A:57324 T:57324 P:W0223 I:30067'
G[30069]='FA L10 A:54616 T:54617 P:31733'
G[30070]='FA L10 A:554616 T:66581 P:31741+31742+31743+31744'	-- TODO: Technically should verify required: 31744
G[30072]='L15 A:57405 T:57405 O:32035'
G[30073]='L15 A:500056 T:500059 P:30047+30055+30172'
G[30074]='L15 A:500059 T:500060 P:30073'
G[30075]='L15 A:57706 T:500064 P:30074'
G[30076]='L15 A:500062 T:500065 P:30074'
G[30077]='L15 A:500063 T:500066 P:30074'
G[30078]='L15 A:500064 T:500067 P:30075+30076+30077'
G[30079]='L15 A:56115 T:56115 O:29873 OAC:30087'
G[30080]='L15 A:57744 T:58376'
G[30081]='L15 A:56115 T:56115 P:30079+30082'
G[30082]='L15 A:58376 T:57744 P:30080'
G[30083]='L15 A:57744 T:57744 P:30091'
G[30084]='L15 A:57744 T:57744 P:30091'
G[30085]='K64 L15 A:500067 T:59704 P:30078'
G[30086]='L15 A:56110 T:56110 P:29877+29908 I:30087'
G[30087]='L0 T:56111'
G[30088]='L15 A:56115 T:56115 P:30081'
G[30089]='L15 A:56115 T:56115 P:30088'
G[30090]='L15 A:56115 T:56115 P:30089'	--	It appears when 30090 was complete, the exclamation point for Nayeli Legoon appears on the Blizzard map.
G[30091]='L15 A:57744 T:57744 P:30082'
G[30092]='L35 CR'
G[30093]='L35 CR'
G[30094]='FH L35 A:52382 T:54476'
G[30095]='FA L35 A:52408 T:54476'
G[30096]='K64 L35 A:54476 T:54751 O:30094,30095'
G[30097]='K64 L35 A:57864 T:557864'
G[30098]='K64 L35 A:54751 T:55624 P:30096'
G[30099]='K64 L35 A:55624 T:555624 P:30098'
G[30100]='K64 L35 A:555624 T:500032 P:30099'
G[30101]='K64 L35 A:500032 T:55532 P:30100'
G[30102]='K64 L35 A:57913 T:54548 P:30101'
G[30103]='L35 A:54548 T:54971 P:30102'
G[30104]='K64 L35 A:500031 T:500033'
G[30105]='K64 L35 A:100077957 T:54971'
G[30106]='L35 CR'
G[30107]='L35 CR'
G[30108]='L35 CR'
G[30109]='L35 CR'
G[30110]='L35'
G[30111]='L35'
G[30112]='L10 A:23961 T:24137'
G[30113]='L35 CR'
G[30116]='L35 CR'
G[30117]='L15 A:61026 T:56720 P:30078'	-- OEC:30629 OPC:29990+30273+30445,29990+30273+30174
G[30118]='L35 CR'
G[30119]='L85'
G[30120]='K64 L15 A:58149 T:28016'
G[30121]='FH L15 A:58113 T:58160'
G[30122]='L1'
G[30123]='FH L15 A:56112 T:56112 P:30179'
G[30124]='FH L15 A:58114 T:58114 P:30179'
G[30125]='L86 I:30353'
G[30126]='L86 I:30352'
G[30127]='FH L15 A:58114 T:58114 P:30123+30124'
G[30128]='FH L15 A:58206 T:558113 P:30129'
G[30129]='FH L15 A:56112 T:58206 P:30123+30124'
G[30130]='FH L15 A:558113 T:558113 P:30124'	--	TODO: determine if we need P: of 30123 as well
G[30131]='FH L15 A:558113 T:500069 P:30128+30130'	-- TODO: Verify P codes here
G[30132]='FH L15 A:500069 T:558114 P:30131 I:30464'
G[30133]='FH L15 A:57744 T:58547 P:30090 I:30178,30461,30462'
G[30134]='L10 A:58564 T:58225'	-- P:31373,31375
G[30135]='L10 A:58225 T:58225 P:30134'
G[30136]='L10 A:58225 T:58225 P:30134'
G[30137]='L10 A:58225 T:58225 P:30134'
G[30138]='SP L10 A:58225 T:58225 P:30135+30136+30137'	-- TODO: Verify requires 30136
G[30139]='L10 A:58225 T:58228 P:30138+K100078962 I:30140,30141 ODC:30165'	-- not sure server marks the tracking quests properly, so ODC just in case
G[30140]='L10 A:58225 T:58228 P:30138+K100078960 I:30139,30141 ODC:30166'	-- not sure server marks the tracking quests properly, so ODC just in case
G[30141]='L10 A:58225 T:58228 P:30138+K100078961 I:30139,30140 ODC:30167'	-- not sure server marks the tracking quests properly, so ODC just in case
G[30142]='L10 A:58228 T:58228 P:30139,30140,30141'
G[30143]='L10 A:58564 T:58420 P:T4F762999'
G[30144]='L10 A:58420 T:58420 P:30143'
G[30145]='L10 A:58420 T:58420 P:30144'
G[30146]='K2 L10 A:58413 T:58413 P:30142+PF525'
G[30147]='K2 L10 A:58413 T:58413 P:30142+PX525'
G[30148]='K2 L10 A:58413 T:58413 P:30142+PZ525'
G[30149]='K2 L10 A:58413 T:58413 P:30142+PC525'
G[30150]='K2 L10 A:65669,65670,65671 T:65669,65670,65671 P:30142 I:V0181,V0191,V0201,V0211,V0361 D017'
G[30151]='K2 L10 A:65669,65670,65671 T:58564 P:30142+t4F762999 I:V0181,V0191,V0201,V0211,V0361 D017'
G[30152]='K2 L10 A:58420 T:58564 P:30187 I:V0171,V0181,V0191,V0201,V0211 D036'
G[30153]='L90'
G[30154]='K2 L10 A:65669,65670,65671 T:58564 P:30142 I:31698,V0171,V0181,V0201,V0211,V0361 D019'
G[30155]='K2 L10 A:58228 T:58564 P:30142 I:V0171,V0191,V0201,V0211,V0361 D018'
G[30156]='K2 L10 A:65669,65670,65671 T:58564 P:30142 I:V0171,V0191,V0201,V0211,V0361 D018'	-- I:30157,30158,30159
G[30157]='K2 L10 A:58510 T:58564 P:30142 I:V0171,V0191,V0201,V0211,V0361 D018'	-- I:30156,30158,30159
G[30158]='K2 L10 A:58228 T:58564 P:30142 I:30156,30157,30159,V0171,V0191,V0201,V0211,V0361 D018'
G[30159]='K2 L10 A:58510 T:58564 P:30142 I:V0171,V0191,V0201,V0211,V0361 D018'	-- I:30156,30157,30158
G[30160]='SP K1 L15 A:58647,558647 T:58647,558647 P:30257+K100079264+t4FB83999'
G[30163]='FH L15 A:558114 T:558114 P:30132'
G[30164]='FH L15 A:58607 T:58607 P:30230'	-- TODO: Verify the need for 30229 and/or 30163
G[30165]='L0 T:58228 I:30166,30167'
G[30166]='L0 T:58228 I:30165,30167'
G[30167]='L0 T:58228 I:30165,30166'
G[30168]='L15 A:58278 T:58278'	-- P:30273 wrong
G[30169]='L15 A:58278 T:58278'	-- P:30273 wrong
G[30172]='L15 A:58785 T:500056 P:30051'
G[30173]='L1'
G[30174]='FH L15 A:58607 T:558607 P:30164+30175'	-- TODO: Verify 30164 is required	-- OEC:30629 OPC:29990+30117+30273
G[30175]='FH L15 A:58630 T:58954 P:30163+30229+30230 I:30361'	--	TODO: Verify 30163 and 30230 are required
G[30177]='L85'
G[30178]='FA L15 A:57744 T:58547 P:30090 I:30133,30461,30462'
G[30179]='FH L15 A:58160 T:58113 O:30121'
G[30180]='L86'
G[30181]='L15 A:58422 T:58422'
G[30182]='L15 A:63822 T:63822 P:30183'
G[30183]='L15 A:63822 T:63822'
G[30184]='L15 A:58421 T:58421 P:30181'
G[30185]='L15 A:58422 T:558422 P:30182+30184'
G[30186]='L15 A:558422 T:58421 P:30185'
G[30187]='L10 A:58420 T:58420 P:30145'
G[30188]='L10 A:58564 T:58564 P:30145+30187+30166+T4F783999 I:31810,31811'	-- server completes all three (as well as all three prerequisites), what a pain
G[30189]='SP K1 L15 A:58647,558647 T:58647,558647 P:30257+K100079267+t4FB83999'
G[30190]='K2 L90 A:58819 T:58819 P:31242,31245 Z17128 D002'	-- I:30232
G[30191]='K2 L90 A:58819 T:58819 P:31242,31245 Z17128 D002'	-- I:30192
G[30192]='K2 L90 A:58819 T:58819 P:31242,31245 Z17128 D002'	-- I:30231
G[30193]='K2 L90 A:58818 T:58818 P:31242,31245 Z17128 D002'
G[30194]='K2 L90 A:59338 T:59338 P:31242,31245 Z17128 D002'
G[30195]='K2 L90 A:58820 T:58820 P:31242,31245 Z17128 D002'
G[30196]='K2 L90 A:58818 T:58818 P:31242,31245 Z17128 D002'	-- I:30193,30231
G[30197]='L90'
G[30198]='L90'
G[30199]='L90'
G[30200]='K2 L21850 A:58503 T:58503 P:31240,31248,31294,31296'
G[30201]='L90'
G[30202]='L90'
G[30203]='L90'
G[30204]='K2 L21850 A:58504 T:58504 P:31240,31248,31294,31296 Z17128 D011'
G[30205]='K2 L21850 A:63266 T:63266 P:31240,31248,31294,31296 Z17128 D011'
G[30206]='K2 L21850 A:63266 T:63266 P:31240,31248,31294,31296 Z17128 D011'
G[30207]='L0'
G[30208]='L0'
G[30209]='L0'
G[30210]='L0'
G[30211]='L0'
G[30212]='L0'
G[30215]='L0'
G[30216]='L0'
G[30217]='L0'
G[30218]='L0'
G[30219]='L0'
G[30220]='L0'
G[30221]='L0'
G[30222]='L0'
G[30223]='L0'
G[30224]='L0'
G[30225]='K2 L90 A:58503 T:58503 P:30200+W0111 I:30227'
G[30226]='L90'
G[30227]='K2 L90 A:58503 T:58503 P:30200+W0111 I:30225'
G[30228]='K2 L90 A:58503 T:58503 P:31240,31248,31294,31296 Z17128 D011'
G[30229]='FH L15 A:558114 T:558114 P:30132'
G[30230]='FH L15 A:556112 T:556112 P:30132'
G[30231]='K2 L90 A:58818 T:58818 P:31242,31245 Z17128 D002'	-- I:30192
G[30232]='K2 L90 A:59338 T:59338 P:31242,31245 Z17128 D002'	-- I:30190
G[30233]='K2 L90 A:59343 T:59343 P:W0131+W0141+W0151+W0161+t4F550999 I:30234'
G[30234]='K2 L90 A:59343 T:59343 P:W0131+W0141+W0151+W0161+t4F550999 I:30233'
G[30235]='K2 L90 A:59338 T:59338 P:W0024+t4F550999|31245 I:30236,30237 Z17128'
G[30236]='K2 L90 A:59338 T:59338 P:W0024+t4F550999|31245 I:30235,30237 Z17128'
G[30237]='K2 L90 A:59338 T:0 P:31242,31245 Z17128 D002'
G[30238]='K2 L90 A:59338 T:59338 Z17128'
G[30239]='K2 L90 A:-390 T:59338 P:30237'
G[30240]='K2 L30 A:58743 T:58743 I:30242'
G[30241]='FH L15 A:58607 T:556720 P:29990+30117+30273+30174 I:30360,30376'	-- P:30629
G[30242]='K2 L30 A:58743 T:58743 I:30240'
G[30243]='K2 L30 A:58920 T:-390,58920'
G[30244]='K2 L90 A:-390 T:-390 P:30243'
G[30245]='K2 L90 A:58920 T:-390,58920 P:30240|30242+30306 I:30243,30246'
G[30246]='K2 L90 A:58919 T:-390,58919 P:30240|30242+30306 I:30243,30245'
G[30247]='L90'
G[30248]='K2 L90 A:-390,58920 T:58920 P:30245'
G[30249]='K2 L90 A:-390 T:58920 P:30244'
G[30250]='L90'
G[30251]='K2 L90 A:-390 T:58919 P:30246'
G[30252]='L15 A:58721 T:58646 O:31372,31374'
G[30253]='L21846'
G[30254]='L15 A:558646 T:558646 P:30535'
G[30255]='L15 A:558646 T:558646 P:30254'
G[30256]='L15 A:558646 T:558646 P:30255'
G[30257]='L15 A:558646 T:58706 P:30256'
G[30258]='L15 A:58646 T:57401 P:31945+T4F856599'	-- making this based on reputation instead, at the moment 5600 into Honored
G[30259]='L15 A:57401 T:57401 P:30258'
G[30260]='L15 A:58646 T:57385 P:T4F850999'
G[30261]='K2 L30 A:58704 T:58704 P:30240|30242+30306+T4F562999 I:30264'
G[30262]='L90'
G[30263]='K2 L90 A:59338 T:59338 P:31242,31245 Z17128 D002'
G[30264]='K2 L30 A:58919 T:58919 P:30240|30242+30306+T4F562999 I:30261'
G[30265]='K2 L90 A:59343 T:59343 P:31131 I:30291,30338 Z17128 D014'
G[30266]='K2 L30 A:59340 T:59340 P:30240|30242+30306 I:30243,30444'
G[30267]='L15 A:58736 T:58736'
G[30268]='L15 A:58609 T:58609 P:30269 I:30375'
G[30269]='K32 L15 A:58547 T:59138 P:30133,30178'
G[30270]='L15 A:59138 T:59138 P:30269'
G[30271]='L15 A:59188 T:59608 P:30268+30270+30694'
G[30272]='L15 A:59138 T:59608 P:30268+30270+30694'
G[30273]='L15 A:59608 T:59719 P:30271+30272+30695'	-- OEC:30629 OPC:29990+30117+30445,29990+30117+30174
G[30274]='FA L15 A:-100418 T:58745'
G[30275]='L15 T:56773'
G[30277]='K2 L30 A:58503 T:58503 P:30642+30200+W0111 I:30280'
G[30278]='L90'
G[30279]='L90'
G[30280]='K2 L30 A:58503 T:58503'
G[30281]='K2 L90 A:58470 T:-811 P:30307+W0041+W0061+W0031+W0051 I:31131,31242,31243 Z17128 D023'
G[30282]='K2 L90 A:58465 T:58465 P:30307+W0041+W0061+W0031+W0051 I:31131,31242,31243 Z17128 D023'
G[30283]='K2 L90 A:58469 T:58469 P:30307+W0041+W0061+W0031+W0051 I:31131,31242,31243 Z17128 D023'
G[30284]='K2 L90 A:59343 T:59343 P:31131 I:30342 Z17128 D015'
G[30285]='K2 L5920000 A:59337 T:59337 P:31243,31246 I:30286'
G[30286]='K2 L90 A:59337 T:59337 P:31243,31246 I:30285'
G[30287]='K2 L90 A:58911 T:58911 P:31243,31246 I:31293'
G[30288]='K2 L5920000 A:59336 T:59336 P:31243,31246'
G[30289]='K2 L5920000 A:58911 T:58911 P:31243,31246 I:30290'
G[30290]='K2 L90 A:58911 T:58911 P:31243,31246 I:30289'
G[30291]='K2 L90 A:59343 T:59343 P:31131 I:30265,30338 Z17128 D014'
G[30292]='K2 L90 A:58471 T:58471 P:30307+W0041+W0061+W0031+W0051 I:30293,31131,31242,31243 Z17128 D023'
G[30293]='K2 L90 A:58471 T:58467 P:30307+W0041+W0061+W0031+W0051 I:30292,31131,31242,31243 Z17128 D023'
G[30294]='L90'
G[30295]='L1'
G[30296]='K2 L90 A:58911 T:58911 P:30285|30286+30288+30289|30290+30287|31293+t4F550999|31246 I:30297'
G[30297]='K2 L90 A:58911 T:58911 P:30285|30286+30288+30289|30290+30287|31293+t4F550999|31246 I:30296'
G[30298]='K2 L90 A:59332 T:59332 P:31244,31295'
G[30299]='K2 L90 A:59334 T:59334 P:31244,31295 I:30481'
G[30300]='K2 L90 A:59334 T:59334 P:31244,31295'
G[30301]='K2 L90 A:59332 T:59332 Z17128'
G[30302]='K2 L90 A:59332 T:59332 P:30298+30305'
G[30303]='L90'
G[30304]='K2 L21850 A:58504 T:58504 P:31240,31248,31294,31296 Z17128 D011'
G[30305]='K2 L90 A:59333 T:59333 P:31244,31295'
G[30306]='K2 L30 A:58962 T:58962'
G[30307]='K2 L30 A:58408 T:58408 P:30638 Z17128'
G[30308]='K2 L21850 A:558465 T:558465 P:30638 I:30309,30310,31757 Z17128 D005'
G[30309]='K2 L30 A:558465 T:558465 P:30638 I:30308,30310,31757 Z17128 D005'
G[30310]='K2 L5920000 A:558465 T:558465 P:30638 I:30308,30309,31757 Z17128 D005'
G[30311]='L90'
G[30312]='K2 L5920000 A:558468 T:558468 P:30638 I:30320,31755 Z17128 D004'
G[30313]='K2 L90 A:59342 T:59342 P:31131 I:30314,30341 Z17128 D016'
G[30314]='K2 L90 A:59342 T:59342 P:31131 I:30313,30341 Z17128 D016'
G[30315]='L1'
G[30316]='K2 L90'	-- A:58467
G[30317]='K2 L15 A:57298 T:57298 P:30257 I:30318,30319,30321,30322'
G[30318]='K2 L15 A:58707 T:58707 P:30257 I:30317,30319,30321,30322'
G[30319]='K2 L15 A:557402 T:557402 P:30257 I:30317,30318,30321,30322'
G[30320]='K2 L21850 A:558468 T:558468 P:30638 I:30312,31755 Z17128 D004'
G[30321]='K2 L15 A:58710 T:58710 P:30257 I:30317,30318,30319,30322'
G[30322]='K2 L15 A:58706 T:58706 P:30257 I:30317,30318,30319,30321'
G[30323]='K2 L15 A:558761 T:558761 P:30257 I:30324,30325,30326,30327'
G[30324]='K2 L15 A:558709 T:558709 P:30257 I:30323,30325,30326,30327'
G[30325]='K2 L15 A:58708 T:58708 P:30257 I:30323,30324,30326,30327'
G[30326]='K2 L15 A:58705 T:58705 P:30257 I:30323,30324,30325,30327'
G[30327]='K2 L15 A:58647 T:58647 P:30257 I:30323,30324,30325,30326'
G[30328]='K2 L35 A:58715 T:58715 P:30257 I:30329,30330,30331,30332'
G[30329]='K2 L35 A:58713 T:58713 P:30257 I:30328,30330,30331,30332'
G[30330]='K2 L35 A:58716 T:58716 P:30257 I:30328,30329,30331,30332'
G[30331]='K2 L35 A:58714 T:58714 P:30257 I:30328,30329,30330,30332'
G[30332]='K2 L35 A:58712 T:58712 P:30257 I:30328,30329,30330,30331'
G[30333]='K2 L15 A:58646 T:558646 P:30257 I:30334,30335,30336,30337'
G[30334]='K2 L15 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:30333,30335,30336,30337'
G[30335]='K2 L15 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:30333,30334,30336,30337'
G[30336]='K2 L15 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:30333,30334,30335,30337'
G[30337]='K2 L15 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:30333,30334,30335,30336'
G[30338]='K2 L90 A:59343 T:59343 P:31131 I:30265,30291 Z17128 D014'
G[30339]='K2 L90 A:59341 T:59341 P:31131 I:30340 Z17128 D013'
G[30340]='K2 L90 A:59341 T:59341 P:31131 I:30339 Z17128 D013'
G[30341]='K2 L90 A:59342 T:59342 P:31131 I:30313,30314 Z17128 D016'
G[30342]='K2 L90 A:59343 T:59343 P:31131 I:30284 Z17128 D015'
G[30343]='L85'
G[30344]='FA L15 A:58745 T:58745 P:30274'
G[30345]='L86'
G[30346]='FA L15 A:58745 T:-418 P:30344+30350+30384'	-- TODO: Verify requires 30384
G[30347]='FA L15 A:-418 T:58745 P:30346'
G[30348]='FA L15 A:58745 T:58745 P:30347+30349+30351'	-- TODO: Verify requires 30347
G[30349]='FA L15 A:58735 T:58735 P:30344+30350+30384'	-- TODO: Verify requires 30384
G[30350]='FA L15 A:56114 T:56114 P:30274'
G[30351]='FA L15 A:56114,556114 T:58814,556114 P:30344+30350+30384'	-- TODO: Need to identify that 556114 is used if you complete 30346 and/or take 30347 because no longer will 58814 be a valid turnin	-- TODO: Verify requires 30384
G[30352]='L15 A:58779 T:58779 I:30126'
G[30353]='L15 A:58779 T:58779 I:30125'
G[30354]='FA L15 A:58821 T:58821 P:30363,30465'
G[30355]='FA L15 A:556114 T:556114 P:30363,30465'
G[30356]='FA L15 A:58821 T:58821 P:30363,30465'
G[30357]='FA L15 A:558745 T:558745 P:30354+30355+30356'	-- TODO: Verify requires 30354 30355 30356 (or is it the acceptance of 30361 that does it?)
G[30358]='L85'
G[30359]='FA L15 A:558745 T:500072 P:30357+30361'
G[30360]='FA L15 A:58821 T:556720 P:29990+30117+30273+30445 I:30241,30376'	-- P:30629
G[30361]='FA L15 A:558630 T:58954 P:30354+30355+30356 I:30175'	-- TODO: Verify requires 30355
G[30362]='L85'
G[30363]='FA L15 A:58735 T:58821 P:30348 I:30465'
G[30364]='L85'
G[30365]='L0'
G[30366]='L0'
G[30367]='L0'
G[30368]='L0'
G[30369]='L0'
G[30370]='L0'
G[30371]='L0'
G[30372]='L0'
G[30373]='L0'
G[30374]='L0'
G[30375]='L22103 I:30268'
G[30376]='L15 A:59719 T:56720 P:29990+30117+30273+30445|30174 I:30241,30360'	-- P:30629
G[30377]='L85'
G[30378]='L85'
G[30379]='SP K1 L15 A:58706 T:58706 P:30257+K100079264+t50183999'
G[30380]='SP K1 L15 A:58706 T:58706 P:30257+K100079267+t50183999'
G[30381]='SP K1 L15 A:58647,558647 T:58647,558647 P:30257+K100079266+t4FB83999'
G[30382]='SP K1 L15 A:58647,558647 T:58647,558647 P:30257+K100079265+t4FB83999'
G[30383]='SP K1 L15 A:58647,558647 T:58647,558647 P:30257+K100079268+t4FB83999'
G[30384]='FA L15 A:58735 T:58735 P:30274'
G[30385]='K2 L90 A:59338 T:58919 P:W0024+31242+T4F550999 I:31294,31295 Z17128'
G[30386]='SP K2 L15 A:58647,558647 T:58647,558647 P:30257+K100074651+t4FB83999'	-- Shrimp Dumplings Z104307
G[30387]='SP K1 L15 A:58706 T:58706 P:30257+K100079266+t50183999'
G[30388]='SP K1 L15 A:58706 T:58706 P:30257+K100079265+t50183999'
G[30389]='SP K1 L15 A:58706 T:58706 P:30257+K100079268+t50183999'
G[30390]='SP K2 L15 A:58706 T:58706 P:30257+K100074644+t50183999'	-- Swirling Mist Soup Z104304
G[30391]='SP K1 L15 A:58707,558707 T:58707,558707 P:30257+K100079264+t4FC83999'
G[30392]='SP K1 L15 A:58707,558707 T:58707,558707 P:30257+K100079267+t4FC83999'
G[30393]='SP K1 L15 A:58707,558707 T:58707,558707 P:30257+K100079266+t4FC83999'
G[30394]='SP K1 L15 A:58707,558707 T:58707,558707 P:30257+K100079265+t4FC83999'
G[30395]='SP K1 L15 A:58707,558707 T:58707,558707 P:30257+K100079268+t4FC83999'
G[30396]='SP K2 L15 A:58707,558707 T:58707,558707 P:30257+K100074649+t4FC83999'	-- Braised Turtle Z104305
G[30397]='SP K1 L15 A:58709,558709 T:58709,558709 P:30257+K100079264+t4FD83999'
G[30398]='SP K1 L15 A:58709,558709 T:58709,558709 P:30257+K100079267+t4FD83999'
G[30399]='SP K1 L15 A:58709,558709 T:58709,558709 P:30257+K100079266+t4FD83999'
G[30400]='SP K1 L15 A:58709,558709 T:58709,558709 P:30257+K100079265+t4FD83999'
G[30401]='SP K1 L15 A:58709,558709 T:58709,558709 P:30257+K100079268+t4FD83999'
G[30402]='SP K2 L15 A:58709,558709 T:58709,558709 P:30257+K100074647+t4FD83999'	-- Valley Stir Fry Z104302
G[30403]='SP K1 L15 A:558708,58708 T:558708,58708 P:30257+K100079264+t4FE83999'
G[30404]='SP K1 L15 A:558708,58708 T:558708,58708 P:30257+K100079267+t4FE83999'
G[30405]='SP K1 L15 A:558708,58708 T:558708,58708 P:30257+K100079266+t4FE83999'
G[30406]='SP K1 L15 A:558708,58708 T:558708,58708 P:30257+K100079265+t4FE83999'
G[30407]='SP K1 L15 A:558708,58708 T:558708,58708 P:30257+K100079268+t4FE83999'
G[30408]='SP K2 L15 A:558708,58708 T:558708,58708 P:30257+K100074645+t4FE83999'	-- Eternal Blossom Fish Z104299
G[30409]='SP K1 L15 A:557402,57402 T:557402,57402 P:30257+K100079264+t4FF83999'
G[30410]='SP K1 L15 A:557402,57402 T:557402,57402 P:30257+K100079267+t4FF83999'
G[30411]='SP K1 L15 A:557402,57402 T:557402,57402 P:30257+K100079266+t4FF83999'
G[30412]='SP K1 L15 A:557402,57402 T:557402,57402 P:30257+K100079265+t4FF83999'
G[30413]='SP K1 L15 A:557402,57402 T:557402,57402 P:30257+K100079268+t4FF83999'
G[30414]='SP K2 L15 A:557402,57402 T:557402,57402 P:30257+K100074642+t4FF83999'	-- Charbroiled Tiger Steak Z104298
G[30415]='SP K1 L90'	--  A:58709,558709 T:58709,558709 P:30257+K100079264+t4FD83999
G[30416]='SP K1 L15 A:57298,557298 T:57298,557298 P:30257+K100079264+t50383999'
G[30417]='SP K1 L15 A:57298,557298 T:57298,557298 P:30257+K100079267+t50383999'
G[30418]='SP K1 L15 A:57298,557298 T:57298,557298 P:30257+K100079266+t50383999'
G[30419]='SP K1 L15 A:57298,557298 T:57298,557298 P:30257+K100079265+t50383999'
G[30420]='SP K1 L15 A:57298,557298 T:57298,557298 P:30257+K100079268+t50383999'
G[30421]='SP K2 L15 A:57298,557298 T:57298,557298 P:30257+K100074654+t50383999'	-- Wildfowl Roast Z104310
G[30422]='SP K1 L15 A:58705,558705 T:58705,558705 P:30257+K100079264+t50283999'
G[30423]='SP K1 L15 A:58705,558705 T:58705,558705 P:30257+K100079267+t50283999'
G[30424]='SP K1 L15 A:58705,558705 T:58705,558705 P:30257+K100079266+t50283999'
G[30425]='SP K1 L15 A:58705,558705 T:58705,558705 P:30257+K100079265+t50283999'
G[30426]='SP K1 L15 A:58705,558705 T:58705,558705 P:30257+K100079268+t50283999'
G[30427]='SP K2 L15 A:58705,558705 T:58705,558705 P:30257+K100074655+t50283999'	-- Twin Fish Platter Z104311
G[30428]='SP K1 L15 A:58761 T:58761 P:30257+K100079264+t50083999'
G[30429]='SP K1 L15 A:58761 T:58761 P:30257+K100079267+t50083999'
G[30430]='SP K1 L15 A:58761 T:58761 P:30257+K100079266+t50083999'
G[30431]='SP K1 L15 A:58761 T:58761 P:30257+K100079265+t50083999'
G[30432]='SP K1 L15 A:58761 T:58761 P:30257+K100079268+t50083999'
G[30433]='SP K2 L15 A:58761 T:58761 P:30257+K100074652+t50083999'	-- Fire Spirit Salmon Z104308
G[30434]='SP K1 L15 A:58710 T:58710 P:30257+K100079264+t4F983999'
G[30435]='SP K1 L15 A:58710 T:58710 P:30257+K100079267+t4F983999'
G[30436]='SP K1 L15 A:58710 T:58710 P:30257+K100079266+t4F983999'
G[30437]='SP K1 L15 A:58710 T:58710 P:30257+K100079265+t4F983999'
G[30438]='SP K1 L15 A:58710 T:58710 P:30257+K100079268+t4F983999'
G[30439]='SP K2 L15 A:58710 T:58710 P:30257+K100074643+t4F983999'	-- Sauteed Carrots Z104301
G[30442]='L10'
G[30443]='L86'
G[30444]='K2 L90 A:58919 T:58919 P:30240|30242+30306 I:30243,30266'
G[30445]='FA L15 A:58970 T:58821 P:30359'	-- OEC:30629 OPC:29990+30117+30273
G[30449]='L346'
G[30450]='L346'
G[30451]='L346 A:100079326 T:14847'
G[30452]='L346 A:100079323 T:14847'
G[30453]='L0 T:63367'	-- this seems to have been completed when the boat ride happened (quest 31285)
G[30454]='L10'
G[30455]='L10'
G[30457]='L20 A:59073 T:59073'
G[30458]='FA L10 T:55333'
G[30459]='L20 A:59076 T:59076'
G[30460]='L20 A:59077 T:59077'
G[30461]='FH L15 A:57744 T:58547 I:30133,30178,30462'	-- why is this one triggered?
G[30462]='FA L15 I:30133,30178,30461'
G[30464]='FH L15 I:30132'
G[30465]='FA L15 A:58735 T:58821 P:30348 I:30363'
G[30466]='FH L10 A:57108 T:57108 P:1'
G[30467]='L20 A:59263 T:59272 O:31451,31452'
G[30468]='L20 A:59273 T:59273'
G[30469]='L20 A:59263 T:59263'
G[30470]='K2 L15 A:64464 T:558761 P:30257 I:30471,30472,30473,30474,30475,30476,30477,30478,30479'
G[30471]='K2 L15 A:64464 T:558709 P:30257 I:30470,30472,30473,30474,30475,30476,30477,30478,30479'
G[30472]='K2 L15 A:64464 T:58708 P:30257 I:30470,30471,30473,30474,30475,30476,30477,30478,30479'
G[30473]='K2 L15 A:64464 T:58705 P:30257 I:30470,30471,30472,30474,30475,30476,30477,30478,30479'
G[30474]='K2 L15 A:64464 T:58647 P:30257 I:30470,30471,30472,30473,30475,30476,30477,30478,30479'
G[30475]='K2 L15 A:64464 T:57298 P:30257 I:30470,30471,30472,30473,30474,30476,30477,30478,30479'
G[30476]='K2 L15 A:64464 T:58707 P:30257 I:30470,30471,30472,30473,30474,30475,30477,30478,30479'
G[30477]='K2 L15 A:64464 T:57402 P:30257 I:30470,30471,30472,30473,30474,30475,30476,30478,30479'
G[30478]='K2 L15 A:64464 T:58710 P:30257 I:30470,30471,30472,30473,30474,30475,30476,30477,30479'
G[30479]='K2 L15 A:64464 T:58706 P:30257 I:30470,30471,30472,30473,30474,30475,30476,30477,30478'
G[30480]='L20 A:560973 T:500076 P:30468+30496+30967'	-- TODO: Verify 30496 and 30967 are required
G[30481]='K2 L90 A:59333 T:59333 P:31244,31295 I:30299'
G[30482]='K2 L21850 A:-390 T:58470 P:30281'
G[30483]='L90'
G[30484]='FH L10 A:57108 T:57108 P:30499'
G[30485]='FH L10 A:59377 T:59411 P:30466+30484 I:31362'
G[30486]='L0'
G[30487]='L20 A:59696 T:60175 P:30601+30618+30621'
G[30488]='L20 A:59353 T:61693 O:31456,31457'
G[30489]='L20 A:59353 T:59353'
G[30490]='L20'	-- I:30587
G[30491]='L20 A:61693 T:59354 P:30488'
G[30492]='L20 A:59354 T:59371 P:30491+30587'
G[30495]='L10 A:59391 T:59391 P:29931'
G[30496]='L20 A:60973 T:560973'
G[30498]='FA L10 A:57242 T:55122 P:30000'
G[30499]='FH L10 A:57242 T:57108 P:30000'
G[30500]='L10 A:59418 T:59418 P:31303'
G[30501]='L1'
G[30502]='L10 A:59418 T:59418 P:31303'
G[30504]='FH L10 A:59418 T:59418 P:31303 I:31319'
G[30506]='FA L20 A:59076 T:59441 P:30457+30459+30460 I:30507,30508'	-- TODO: Verify requires 30457
G[30507]='FA L20 A:59073 T:59441 P:30457+30459+30460 I:30506,30508'	-- TODO: Verify requires 30457
G[30508]='FA L20 A:59077 T:59441 P:30457+30459+30460 I:30506,30507'	-- TODO: Verify requires 30457
G[30509]='FH L20 A:59076 T:59442 P:30457+30459+30460 I:30510,30511'	-- TODO: Verify requires 30457
G[30510]='FH L20 A:59073 T:59442 P:30457+30459+30460 I:30509,30511'	-- TODO: Verify requires 30457
G[30511]='FH L20 A:59077 T:59442 P:30457+30459+30460 I:30509,30510'	-- TODO: Verify requires 30457
G[30512]='FA L20 A:59441 T:63542 P:30506,30507,30508'	-- I:30513
G[30513]='FH L20 A:59442 T:563535 P:30509,30510,30511'	-- I:30512
G[30514]='FA L20 A:63542 T:563542 P:30512'	-- I:30515
G[30515]='FH L20 A:563535 T:500084 P:30513'	-- I:30514
G[30516]='L15 A:57385 T:57385 P:30260 ODC:30530,30531'
G[30517]='L15 A:558646 T:57298,557298 P:T4F867250'
G[30518]='L15 A:57298,557298 T:57298,557298 P:30517'
G[30519]='L15 A:558646 T:64597 P:T4F871498'	-- Tillers rep went from 8224 to 8499 Revered, so assuming 8499 for now
G[30520]='L90'
G[30521]='L15 A:558646 T:57402,557402 P:T4F879799'
G[30522]='L15 A:57402,557402 T:558646 P:30521'
G[30523]='L15 A:558646 T:58705,558705 P:T4F862999'
G[30524]='L15 A:58705,558705 T:58705,558705 P:30523 ODC:30532,30533'
G[30525]='L15 A:558646 T:558646 P:30522'
G[30526]='L15 A:59533 T:59533 P:T4F875599'	-- Revered +12600
G[30527]='L15 A:558646 T:558646 P:30525'
G[30528]='L15 A:558646 T:558646 P:30527+T4F882999'	-- reports are Tillers Revered +20000. I know for a fact I had +20053 and it was available
G[30529]='L15 A:558646 T:57402,557402 P:30528+T4F883999 ODC:30573,30574'
G[30530]='L0 T:57385'
G[30531]='L0 T:57385 J:30516'
G[30532]='L0 T:58705'
G[30533]='L0 T:58705 J:30524'
G[30534]='L15 A:1215705 T:1215705 P:30574+R114624+i114624+J6551+T4F883999'
G[30535]='L15 A:558646 T:558646 P:30252'
G[30536]='L0'
G[30537]='L0'
G[30538]='L0'
G[30539]='L0'
G[30540]='L0'
G[30541]='L0'
G[30542]='L0'
G[30543]='L0'
G[30544]='L0'
G[30545]='L0'
G[30546]='L0'
G[30547]='L0'
G[30548]='L0'
G[30549]='L0'
G[30550]='L0'
G[30551]='L0'
G[30552]='L0'
G[30553]='L0'
G[30554]='L0'
G[30555]='L0'
G[30556]='L0'
G[30557]='L0'
G[30558]='L0'
G[30559]='L0'
G[30560]='L0'
G[30561]='L0 T:72841'
G[30562]='L0'
G[30564]='L0'
G[30565]='FA L10 A:59550 T:59550 P:30000'	-- this was available when I was done with the Jade Temple...maybe earlier...who knows?
G[30566]='L0 T:72761'
G[30567]='K2048 L35 A:59569 T:59569'
G[30568]='FA L10 A:55122 T:55122 P:30000'	-- this was available when I was done with the Jade Temple...maybe earlier...who knows?
G[30569]='FA L20 A:63754 T:59573 P:30514 I:30570'
G[30570]='FH L20 A:63751 T:59573 P:30515 I:30569'
G[30571]='L20 A:59573 T:59573 P:30569,30570'
G[30573]='L0 T:57402'
G[30574]='L0 T:57402 J:30529'
G[30575]='FA L20 A:559441 T:559441 P:30514 I:31256'
G[30581]='L20 A:59636 T:59636 P:30569,30570'
G[30582]='L20 A:100080241 T:59353'
G[30583]='L20 A:59450 T:59450 P:30514 I:31251'
G[30584]='K2 L15 A:59584 T:59584 P:PF001 D001'
G[30585]='K2 L15 A:60673 T:60673 P:PF001 D001'
G[30586]='K2 L15 A:59584 T:59584 P:PF001 D001'
G[30587]='L20 A:59353 T:59353 P:30488'	-- I:30490
G[30588]='K2 L15 A:59586 T:59586 P:PF525 D001'
G[30589]='L1 RA RA RA A:60042 T:60055 P:29795+30591'
G[30590]='L1 RA RA RA A:60055 T:60055 P:30589'
G[30591]='L1 RA RA RA A:55943 T:55943 P:29792'
G[30592]='L20 A:59701 T:59703'
G[30593]='FA L20 A:59451 T:59451 P:30514 I:30594'
G[30594]='FH L20 A:59449 T:59449 P:30515 I:30593'
G[30595]='L20 A:59821 T:59821 P:31256 I:30766'
G[30596]='FA L20'	-- I:30615,30619,30620
G[30597]='L30 A:100080240 T:66845 P:K100080240+PA500'
G[30598]='K2 L15 A:60673 T:60673 P:PF001 D001'
G[30599]='L20 A:59452 T:59452 P:30602+30603'
G[30600]='L20 A:59452 T:59452 P:30603'
G[30601]='L20 A:59696 T:59696 P:30999'
G[30602]='L20 A:59701,59703,59755 T:59452 P:30592'
G[30603]='L20 A:59452 T:59452 P:30592'
G[30604]='L20 A:59452 T:59452 P:30603'
G[30605]='L20 A:59452 T:59894 P:30599+30600'
G[30606]='L20 A:59894 T:59452 P:30605'
G[30607]='L20 A:59894 T:59894 P:30605'
G[30608]='L20 A:59894 T:59894 P:30605'
G[30609]='L22360'
G[30610]='L20 A:59894 T:59894 P:30607+30608'
G[30611]='L20 A:59452 T:59452 P:30607+30608'
G[30612]='L20 A:59452 T:59452 P:30607+30608'
G[30613]='K2 L15 A:60135 T:60135 P:PF001 D001'
G[30614]='L20 A:59402 T:59402'
G[30615]='L20'	-- I:30596,30619,30620
G[30616]='L20 A:59597 T:59597'
G[30617]='L20 A:59597 T:59701 P:30614+30616+30808'
G[30618]='L20 A:59695 T:59695 P:30999'
G[30619]='FA L20 A:500071 T:500071 P:30514'	-- I:30596,30615,30620
G[30620]='FH L20 A:63535 T:63535 P:30515'	-- I:30596,30615,30619
G[30621]='L20 A:59716 T:59716 P:30999'
G[30622]='L15 A:556720 T:57198 P:30241,30360,30376'
G[30623]='L15 A:59855 T:-376 P:30241,30360,30376'
G[30624]='FA L15 A:500057 T:-376 P:30241,30360,30376 I:30653'
G[30625]='L15 A:57198 T:57198 P:30622+30623+30624|30653'
G[30626]='L15 A:57198 T:556720 P:30625'
G[30627]='L15 A:559856 T:556720 P:30626'
G[30628]='L15 A:556720 T:1211316 P:30627'
G[30629]='L0 J:29990+30117+30273+30445,29990+30117+30273+30174'	-- TODO: Verify requires 29990.  Later can verify requires 30445(Alliance)/30174(Horde)
G[30630]='FA L30'
G[30631]='FA L30 A:58468 T:58468 P:31512'
G[30632]='L30 A:58408 T:58465 P:30631+31384+S115913,30649+31385+S115913 Z17128'
G[30633]='L30 A:58465 T:58465 P:30632'
G[30634]='L30 A:58471 T:58471 P:30632'
G[30635]='L30 A:58465 T:58465 P:30633+30634'
G[30636]='L30 A:58465 T:58465 P:30633+30634'
G[30637]='L30 A:-100390 T:58465 P:30633+30634 I:30654'
G[30638]='L30 A:66769 T:58408 P:30635+30636+30637|30654'	-- TODO: Verify requires 30635
G[30639]='L30 A:59332,58408,59340 T:59332,58408,59340 P:T4F550999'
G[30640]='L30 A:59905 T:59905 P:T4F562999 Z17128'
G[30641]='L30 A:59905 T:59905 P:30640 Z17128'
G[30642]='L30 A:59905 T:559905 P:30641 Z17128'
G[30643]='L30 A:58408 T:559905 P:30642+T4F583999'
G[30644]='L30 A:559905 T:500084 P:30643'
G[30645]='L30 A:500084 T:59906 P:30644'
G[30646]='L30 A:59906 T:558465 P:30645'
G[30647]='L0'
G[30648]='L10 A:59899 T:-376 P:30500+30502+30504|31319'
G[30649]='FH L30 A:58468 T:58468 P:31511 Z17056'	-- an arbitrary date for removal
G[30650]='FA L20 A:500071 T:559441,500073 P:30619+31252'	-- I:30655
G[30651]='FA L20 A:59450 T:59450 P:30619+31252'	-- I:30656
G[30652]='FA L20 A:559441 T:-379 P:30619+31252'	-- I:30657
G[30653]='FH L15 A:60021 T:-376 P:30241,30360,30376 I:30624'
G[30654]='L30 A:58465 T:58465 P:30633+30634 I:30637'
G[30655]='FH L20 A:63535 T:59442 P:30620+31253'	-- I:30650
G[30656]='FH L20 A:59448 T:59448 P:30620+31253'	-- I:30651
G[30657]='FH L20 A:59442 T:-379 P:30620+31253'	-- I:30652
G[30658]='K2 L15 A:60135 T:60135 P:PF001 D001'
G[30660]='FA L20 A:-379 T:500073 P:30652 I:30662'	-- I:30661,30662,30663
G[30661]='FH L20 A:-379 T:59442 P:30657 I:30663'	-- I:30660,30662,30663
G[30662]='FA L20 A:500073 T:500073 P:30652 I:30660'	-- I:30660,30661,30663
G[30663]='FH L20 A:59442 T:59442 P:30657 I:30661'	-- I:30660,30661,30662
G[30665]='L20 A:60161 T:60161 P:30460+30459+30457 O:31455'	-- P:30514
G[30666]='L15 A:60173 T:60173'
G[30667]='L15 A:60182 T:60182'
G[30668]='L15 A:60173 T:60173 P:30666'
G[30669]='L15 A:60173 T:60139 P:30668'
G[30670]='L20 A:60161 T:60161 P:30514,30515'
G[30671]='L15 A:60139 T:60139 P:30669'
G[30672]='L15 A:60139 T:60173 P:30671'
G[30673]='L20 I:30680,30681,30682'
G[30674]='L15 A:-110418 T:-418 P:B30672'	-- TODO: See if this requires me to be on 30672 currently.  It seems like it would. P:B30672
G[30675]='L15 A:100080827 T:-418'
G[30677]='L15'
G[30678]='K2 L15 A:60136 T:60136 P:PF001 D001'
G[30680]='L20 T:72841 I:30673,30681,30682'
G[30681]='L20 I:30673,30680,30682'
G[30682]='L20 A:60178 T:60161'	--  I:30673,30680,30681 (from beta server checks)
G[30683]='L20 A:60175 T:60175 P:30487'
G[30684]='L20 A:60175 T:60795 P:30683 ODC:31306'
G[30690]='L20 A:60161 T:60161 P:30670'
G[30691]='L15 A:60139 T:-418,60139 P:30669'
G[30692]='L20 A:59703 T:59755 P:30612'
G[30694]='L15 A:59138 T:59138 P:30269'
G[30695]='L15 A:59138 T:59608 P:30268+30270+30694'
G[30698]='K2 L15 A:60136 T:60136 P:PF001 D001'
G[30699]='L20 A:60161 T:61816 P:30690'
G[30700]='K2 L15 A:59586 T:59586 P:PF001 D001'
G[30701]='K2 L15 A:60675 T:60675 P:PF001 D001'
G[30704]='L15'
G[30705]='L15'
G[30706]='L15'
G[30710]='L87'
G[30714]='L87'
G[30715]='L20 A:500080 T:500080 P:30699'
G[30716]='K2 L35 A:60528 T:60528 I:V0221,V0251,V0271,V0281,V0291,V0301,V0321,V0331,V0421 D031'
G[30717]='K2 L35 A:60529 T:60529 I:V0221,V0251,V0271,V0281,V0291,V0301,V0321,V0331,V0421 D031'
G[30718]='K2 L35 A:60506 T:60506 I:V0221,V0251,V0271,V0281,V0291,V0301,V0321,V0331,V0421 D031'
G[30719]='L90'	-- It appears the way Blizzard records where you are in the progress with the Chi-Ji battles
G[30720]='L90'	-- is by recording the 15 different completions in the "bits" of the quests 30719 - 30722,
G[30721]='L90 T:72763'	-- which we can use, but the UI would be horrible as it would not mean anything to the user.
G[30722]='L90'	-- Therefore, using having ever completed works, except of course if someone comes into the middle of the chain without having used Grail before.
G[30723]='L20 A:61816 T:61816 P:30699'
G[30724]='L20 A:61816 T:61454 P:30715+30723'	--  I:30765 (which is what the server did on beta)
G[30725]='K2 L15 A:60506 T:60506 P:W0313 I:H30725'
G[30726]='K2 L15 A:60506 T:60506 P:W0313+H30725 I:H30726'
G[30727]='K2 L15 A:60506 T:60506 P:W0313+H30726 I:H30727'
G[30728]='K2 L15 A:60506 T:60506 P:W0313+H30727 I:H30728'
G[30729]='K2 L15 A:60506 T:60506 P:W0313+H30728 I:H30729'
G[30730]='K2 L15 A:60506 T:60506 P:W0313+H30729 I:H30730'
G[30731]='K2 L15 A:60506 T:60506 P:W0313+H30730 I:H30731'
G[30732]='K2 L15 A:60506 T:60506 P:W0313+H30731 I:H30732'
G[30733]='K2 L15 A:60506 T:60506 P:W0313+H30732 I:H30733'
G[30734]='K2 L15 A:60506 T:60506 P:W0313+H30733 I:H30734'
G[30735]='K2 L15 A:60506 T:60506 P:W0313+H30734 I:H30735'
G[30736]='K2 L15 A:60506 T:60506 P:W0313+H30735 I:H30736'
G[30737]='K2 L15 A:60506 T:60506 P:W0313+H30736 I:H30737'
G[30738]='K2 L15 A:60506 T:60506 P:W0313+H30737 I:H307308'
G[30739]='K2 L15 A:60506 T:60506 P:W0313+H30738 I:H30739'
G[30740]='K2 L15 A:60506 T:60506 P:W0313+H30739'
G[30742]='L20 A:60596 T:60596 I:30823'
G[30743]='L20 A:60596 T:60596 I:30824'
G[30744]='L20 A:60503 T:-379,60503 I:30825'
G[30745]='L20 A:60503 T:60503 I:30826'
G[30746]='L20 A:-379 T:560679 P:30744,30825'
G[30747]='L20 A:60679 T:60679 P:30746'
G[30750]='L20 A:61454 T:61454 P:30724'
G[30751]='L20 A:61820 T:61820 P:30724'
G[30752]='L20 A:561819 T:62227 P:30993'
G[30753]='K2 L15 A:60674 T:60674 P:PF001 D001'
G[30754]='K2 L15 A:60674 T:60674 P:PF001 D001'
G[30757]='L20 A:62236 T:56884 O:31030'
G[30759]='L1'
G[30763]='K2 L15 A:60675 T:60675 P:PF001 D001'
G[30765]='L20 I:30724'
G[30766]='L20 P:1 I:30595'
G[30767]='L1 RA RA RA A:56416 T:56418 P:29798'
G[30768]='L25 A:62216 T:60684 P:30992 I:31386,31388,31695'
G[30769]='L25 A:60688 T:60684 P:30814'
G[30770]='L25 A:60688 T:60687 P:30814'
G[30771]='L25 A:60871 T:60687 P:30814'
G[30772]='L25 A:60684 T:60687 P:30769+30770+30771'
G[30773]='L25 A:60687 T:60687 P:30769+30770+30771'
G[30774]='L25 A:60684 T:60687 P:30769+30770+30771'
G[30775]='L25 A:60735 T:60735 P:30769+30770+30771'
G[30776]='L25 A:60684 T:560687 P:30772+30773+30774'
G[30777]='L25 A:560687 T:61261 P:30776'
G[30778]='L25 A:61261 T:61261 P:30777'
G[30779]='L25 A:60864 T:61261 P:30777'
G[30780]='L25 A:60864 T:60864 P:30777'
G[30781]='K32 L25 A:60903 T:61261 P:30777'
G[30782]='L25 A:61261 T:61261 P:30827'	-- OEC:31607 OPC:30783
G[30783]='L25 A:60864 T:60864 P:30827'	-- OEC:31607 OPC:30782
G[30784]='L25 A:61261 T:61261 P:30782+30783'	--  P:31607
G[30785]='L25 A:61261 T:61066 P:30784'
G[30786]='L25 A:60857 T:60857 O:31894'
G[30787]='L25 A:60857 T:60857 P:30786'
G[30788]='L25 A:60857 T:60857 P:30787'
G[30789]='L25 A:60857 T:60857 P:30787'
G[30790]='L25 A:60622 T:60622 P:30815'
G[30791]='L25 A:60622 T:60622 P:30815'
G[30792]='L25 A:60622 T:60622 P:30815'
G[30793]='L25 A:60622 T:560622 P:30790+30791+30792'
G[30794]='L20 A:60694 T:60785 O:30816'	-- TODO: Determine if this really should be P 31298 instead
G[30795]='L20 A:560795 T:61297 P:30829'
G[30796]='L20 A:61297 T:61297 P:30795'
G[30797]='L20 A:1211754 T:61297 P:30684'
G[30798]='L20 A:61297 T:61297 P:30799'
G[30799]='L20 A:61297 T:61297 P:30797'	-- TODO: Verify that 30796 is not required
G[30800]='L20 A:61297 T:61297 P:30798'
G[30801]='L20 A:61297 T:61297 P:30800'
G[30802]='L20 A:61297 T:61297 P:30801'
G[30804]='L20 A:59353 T:59353 P:30582'
G[30805]='L20 A:60785 T:60785 P:30794'
G[30806]='L20 A:60785 T:60785 P:30794'
G[30807]='L20 A:60785 T:60785 P:30794'
G[30808]='L20 A:59371 T:59371'
G[30814]='L25 A:60688 T:60688 O:30768,31386,31388,31695'
G[30815]='L25 A:60857 T:60622 P:30788+30789'
G[30816]='L20 A:60436 T:60694 P:30935'
G[30817]='L1'
G[30818]='L10'
G[30819]='L20 A:60785 T:60436 P:30805+30806+30807'	-- TODO: Verify requires 30805 30806
G[30820]='L20 A:60436 T:60757 P:30819'
G[30821]='K2 L20 A:60679 T:60679 P:30747'
G[30823]='L20 A:60678 T:60596 I:30742'
G[30824]='L20 A:60678 T:60596 I:30743'
G[30825]='L20 A:60677 T:60503 I:30744'
G[30826]='L20 A:60677 T:60503 I:30745'
G[30827]='L25 A:60864 T:60864 P:30778+30779+30780+30781'	-- TODO: Verify requires 30779 30781
G[30828]='L20 A:500076 T:61065 P:30480'
G[30829]='L20 A:60795 T:560795 P:30684'
G[30834]='K32 L20 A:59272 T:59263 P:30467'
G[30854]='L0'
G[30855]='L20 A:61065 T:500076 P:30828'
G[30879]='K2 L20 A:60968 T:60968 I:30880,V0221,V0251,V0261,V0281,V0301,V0311,V0321,V0331 D029'
G[30880]='K2 L20 A:60968 T:60968 I:30879,V0221,V0251,V0261,V0281,V0291,V0311,V0321,V0331 D030'
G[30881]='K2 L20 A:60968 T:60968 P:30879'
G[30882]='K2 L20 A:60968 T:60968 P:30880'
G[30883]='K2 L20 A:60968 T:60968 P:30881'
G[30884]='L25 A:61066 T:61469 O:30785 I:30936'
G[30885]='K2 L20 A:60968 T:60968 P:30882'
G[30886]='L0'
G[30887]='L25 A:61469 T:61468 P:30884'
G[30888]='L25 A:61468 T:61468 P:30887'
G[30889]='L25 A:61467 T:61467 P:30887'
G[30890]='L25 A:61468 T:61468 P:30887'
G[30891]='L25 A:61470 T:61470'
G[30892]='L25 A:61470 T:61470 P:30891+30960'
G[30893]='L25 A:61066 T:61066 P:30960'
G[30894]='L25 A:61470 T:61470 P:30891+30960'
G[30895]='L25 A:61066 T:61066 P:30892+30893+30894'
G[30896]='L25 A:61881 T:61881 P:30960'
G[30897]='L25 A:61880 T:61880 P:30960'
G[30898]='L25 A:61066 T:561021 P:30895'
G[30899]='L25 A:62274 T:61020 P:30976'
G[30900]='L25 A:561021 T:61066 P:30898'
G[30901]='L25 A:61066 T:62436 P:30900'
G[30902]='K2 L20 A:60968 T:60968 P:30885'
G[30907]='K2 L20 A:60968 T:60968 P:30883'
G[30910]='L90'
G[30918]='L90'
G[30921]='L25 A:61482 T:61482'
G[30922]='L25 A:61625 T:61625'
G[30923]='L25 A:61482 T:61482'
G[30924]='L25 A:62547 T:61581 P:30921+30923'
G[30925]='L25 A:61581 T:61581 P:30924'
G[30926]='L25 A:61580 T:561482 P:30925'
G[30927]='L25 A:61584 T:61584 P:30925'
G[30928]='L25 A:61585 T:61585 P:30925'
G[30929]='L25 A:61161 T:61161 P:30921+30923'	-- at the moment the assumption is the same requirements as 30924
G[30930]='L25 A:561161 T:561161 P:30929'
G[30931]='L25 A:61539 T:61539 P:30921+30923'	-- TODO: Verify requires 30923
G[30932]='L25 A:61584 T:561539 P:30931'
G[30933]='L25 A:65341 T:65341 P:30932'
G[30934]='L85'
G[30935]='L20 A:61297 T:61371 P:30802 ODC:31205'
G[30936]='L22617 T:72841 I:30884'
G[30941]='L22360'
G[30942]='L20 A:61503 T:61534 P:30935'
G[30943]='L20 A:61495 T:61495 P:30935'
G[30944]='L20 A:61371 T:61371 P:30935'
G[30945]='L20 A:61496 T:61496 P:30935'
G[30946]='L20 A:63784 T:63784 P:31011'
G[30952]='K2 L25 A:61580 T:61580 I:V0221,V0251,V0261,V0271,V0291,V0301,V0311,V0321,V0421 D033'
G[30953]='K2 L25 A:61585 T:61585 I:V0221,V0251,V0261,V0271,V0291,V0301,V0311,V0321,V0421 D033'
G[30954]='K2 L25 A:61581 T:61581 I:V0221,V0251,V0261,V0271,V0291,V0301,V0311,V0321,V0421 D033'
G[30955]='K2 L25 A:61583 T:61583 I:V0221,V0251,V0261,V0271,V0291,V0301,V0311,V0321,V0421 D033'
G[30956]='K2 L25 A:61580 T:61580 I:V0221,V0251,V0261,V0271,V0291,V0301,V0311,V0331,V0421 D032'
G[30957]='K2 L25 A:61584 T:61584 I:V0221,V0251,V0261,V0271,V0291,V0301,V0311,V0331,V0421 D032'
G[30958]='K2 L25 A:61583 T:61585 I:V0221,V0251,V0261,V0271,V0291,V0301,V0311,V0331,V0421 D032'
G[30959]='K2 L25 A:61581 T:61581 I:V0221,V0251,V0261,V0271,V0291,V0301,V0311,V0331,V0421 D032'
G[30960]='L25 A:61468 T:61066 P:30888+30890'
G[30961]='L0'
G[30963]='L25 A:61625 T:61625'
G[30964]='L25 A:61625 T:61625'
G[30965]='L90'
G[30967]='L20 A:60973 T:60973'
G[30968]='L25 A:62275 T:62802 P:30981+31063+31064'	-- TODO: Verify requires 30981
G[30969]='FH L7 A:61716 T:61716'
G[30970]='L25 A:62436 T:62436 P:30901'
G[30971]='L25 A:62124 T:62124 P:30901'
G[30972]='L25 A:62124 T:61016 P:30970+30971'
G[30973]='L25 A:62273 T:62273 P:30972'
G[30974]='L25 P:1'	-- TODO: Figure out the rules governing this -- removed  A:61016 T:61016 to take this out of the list of quests since it may not even exist
G[30975]='L25 A:62730 T:62736 P:30973'
G[30976]='L25 A:62736 T:62274 P:30975'
G[30977]='L25 A:62278 T:62278 P:30976'
G[30978]='L25 A:61020 T:61020 P:30899'
G[30979]='L25 A:65690 T:62786 P:30978'
G[30980]='L25 A:62788 T:562274 P:30979'
G[30981]='L25 A:562274 T:62275 P:31065'
G[30982]='FH L3856 A:61724 T:61724 Z25860'
G[30983]='FH L7 A:61716 T:61716'
G[30984]='FH L7 A:61724 T:61724'
G[30986]='L1'
G[30987]='FA L1 RA A:60566 T:29611 P:31450'
G[30988]='FA L3866634 RA A:29611 T:61796 P:30987 Z22248'
G[30989]='L10 RA A:61796 T:29611 P:30988 Z22248'
G[30990]='L0'
G[30991]='L20 A:561820 T:561820 P:30994'
G[30992]='L20 A:561820 T:61819 P:30991'
G[30993]='L20 A:61819 T:561819 P:30992'
G[30994]='L20 A:61454 T:561820 P:30750+30751'	-- TODO: Verify required 30750
G[30995]='FA L7 A:61822 T:561822'
G[30996]='FA L7 A:61823 T:561823'
G[30997]='FA L3856 A:61822 T:561822 Z25860'
G[30998]='FA L7 A:61823 T:561823'
G[30999]='L20 A:61850 T:59696'	-- if 31460 is in the quest log one cannot see this quest until it is turned in
G[31000]='L30 A:62667 T:62112 I:31390,31391,31656,31847,31886,31895'
G[31001]='L30 A:62112 T:62166 O:31000,31390,31391,31656,31847,31886,31895'
G[31002]='L30 A:62112 T:62166'
G[31003]='L30 A:62166 T:62203 P:31001+31002'
G[31004]='L30 A:62203 T:62202 P:31003'
G[31005]='L30 A:62202 T:62202 P:31004'
G[31006]='L30 A:62202 T:62538 P:31005+31676'
G[31007]='L30 A:62538 T:62538 P:31006'
G[31008]='L30 A:64599 T:64599 P:31006'
G[31009]='L30 A:64815 T:-422 P:31006'	-- when this is completed, the Ancient Amber Chunk (44.77,41.58) becomes active [Malik the Unscathed]
G[31010]='L30 A:-422 T:62774 P:31009'
G[31011]='L20 A:61371 T:63750 P:30942+30943+30944+30945'	-- TODO: Verify requires 30942 30943 30944
G[31012]='FH L1 RA A:60570 T:39605 P:31450'	-- gets cleared when the Alliance version is done
G[31013]='FH L1 RA A:39605 T:62092 P:31012'	-- gets cleared when the Alliance version is done
G[31014]='FH L3866634 RA A:62092 T:39605,62092 P:31013'	-- gets cleared when the Alliance version is done
G[31015]='L30 A:61962 T:61962'
G[31016]='L30 I:31367,31368'
G[31017]='L90'
G[31018]='L30 A:62538 T:562151 P:T53962999+31005+31676'
G[31019]='L30 A:62538 T:65354 P:31066 ODC:31174'
G[31020]='L30 A:62232,562180 T:63328,562180 P:31019'
G[31021]='L30 A:62232,562180 T:63328,562180 P:31019'
G[31022]='L30 A:63328,562180 T:63328,562180 P:31020+31021'
G[31023]='L30 A:100082870 T:62232,562180'
G[31024]='K2 L30 A:63758 T:63758 P:31092+31359 I:31238,31494,31506,V0081,V0091,V0101 D007'
G[31025]='L22874'
G[31026]='L30 A:63328,562180 T:63328,562180 P:31022'
G[31027]='L0'
G[31028]='L22874'
G[31030]='L20 A:62227 T:62236 P:30752 I:31031'
G[31031]='L20 I:31030'
G[31032]='L25 A:62573 T:62573 P:30976'	-- is this P correct?
G[31033]='L10'
G[31034]='FH L7 A:86832 T:61724 I:31036,31037'
G[31035]='FH L10'	-- seems does not really exist
G[31036]='FH L7 A:36648 T:61724 I:31034,31037'	-- tauren only?
G[31037]='FH L7 A:10181 T:61724 I:31034,31036'	-- undead only?
G[31038]='L25 A:62304 T:62304 P:T4F650999 I:V0241,V0341,V0401,V0411 D039'	-- only given when D035 quests are available
G[31039]='K2 L25 A:62304 T:62304,62295,62378,62379,562295,562378,562379 I:V0241,V0341,V0371,V0381,V0401,V0411 D035'
G[31040]='K2 L25 A:62304 T:62304,62295,62378,62379,562295,562378,562379 I:V0241,V0341,V0371,V0381,V0401,V0411 D035'
G[31041]='K2 L25 A:62304 T:62304,62295,62378,62379,562295,562378,562379 I:V0241,V0341,V0371,V0381,V0401,V0411 D035'
G[31042]='K2 L25 A:62304 T:62304,62295,62378,62379,562295,562378,562379 I:V0241,V0341,V0351,V0371,V0401,V0411 D038'
G[31043]='K2 L25 A:62304 T:62304,62295,62378,62379,562295,562378,562379 I:V0241,V0341,V0351,V0371,V0401,V0411 D038'
G[31044]='K2 L25 A:62304 T:62304,62295,62378,62379,562295,562378,562379 I:V0241,V0341,V0351,V0381,V0401,V0411 D037'
G[31045]='K2 L25 A:62304 T:62304,62295,62378,62379,562295,562378,562379 I:V0241,V0341,V0351,V0381,V0401,V0411 D037'
G[31046]='K2 L25 A:62304 T:62304,62295,62378,62379,562295,562378,562379 I:V0241,V0341,V0371,V0381,V0401,V0411 D035'
G[31047]='K2 L25 A:62304 T:62304,62295,62378,62379,562295,562378,562379 I:V0241,V0341,V0351,V0371,V0401,V0411 D038'
G[31048]='K2 L25 A:62304 T:62304,62295,62378,62379,562295,562378,562379 I:V0241,V0341,V0351,V0381,V0401,V0411 D037'
G[31049]='K2 L25 A:-388 T:62304 P:31039+31040+31041+31046'	-- TODO: Verify requires 31046
G[31050]='L90'
G[31051]='L90'
G[31052]='L90'
G[31053]='L90'	-- when I accepted some dailies from Master Snowdrift *** TODO: Mark these dailies as setting this flag
G[31054]='L90'
G[31055]='L30 A:100083769 T:61962 P:J6716'
G[31058]='K2048 L35 A:65289 T:62491'
G[31060]='L0'
G[31061]='K2 L25 A:-388 T:62304 P:31042+31043+31047+31105'
G[31062]='K2 L25 A:-388 T:62304 P:31044+31045+31048+31106'
G[31063]='L25 A:562274 T:62275 P:31065'
G[31064]='L25 A:562274 T:62275 P:31065'
G[31065]='L25 A:562274 T:562274 P:30980'
G[31066]='L30 A:64815 T:64815 P:31007+31010+31660'	-- TODO: Verify requires 31660
G[31067]='L30 A:62666 T:62666 P:31066 O:31730'
G[31068]='L30 A:1212389 T:62667 P:31066'
G[31069]='L30 A:62666 T:62666 P:31067+31068'
G[31070]='L30 A:62668 T:62668 P:31068'
G[31071]='L30 A:62859 T:62859 P:31068'
G[31072]='L30 A:62667 T:62667 P:31068'
G[31073]='L30 A:62666 T:62666 P:31069+31070'
G[31074]='L30 A:62667 T:62667 P:31072'
G[31075]='L30 A:62666 T:562666 P:31071+31073+31074+31078'
G[31076]='L30 I:31129'
G[31077]='L30 A:562779 T:67138 P:31076,31129'	-- TODO: Change 562779 to 567138
G[31078]='L30 A:67138 T:500077 P:31077'
G[31079]='L30 A:62772 T:62772 P:31075'
G[31080]='L30 A:562668 T:562668 P:31075'
G[31081]='L30 A:562667 T:562667 P:31075'
G[31082]='L30 A:62771 T:62771 P:31075'
G[31083]='L30 AK:62767 T:62771'
G[31084]='L30 A:62771 T:62771 P:31079+31080+31081+31082'	-- TODO: Verify requires 31079 31082
G[31085]='L30 A:562667 T:500078 P:31084'
G[31086]='L30 A:562666 T:500079 P:31084'
G[31087]='L30 A:64815 T:65365 P:31066'
G[31088]='L30 A:65365 T:65365 P:31087'
G[31089]='L30 A:65365 T:62540 P:31088+31090 ODC:31282'
G[31090]='L30 A:65365 T:65365 P:31087'
G[31091]='K32 L30 A:63876 T:64344 P:31089,31682 ODC:31343'
G[31092]='L30 A:64490 T:63758 P:31091'
G[31093]='L30 A:100083770 T:61962 P:J6850'
G[31094]='L30 A:100083771 T:61962 P:J6846'
G[31095]='L30 A:100083772 T:61962 P:J6754'
G[31096]='L30 A:100083774 T:61962 P:J6858'
G[31097]='L30 A:100083773 T:61962 P:J6857'
G[31098]='L90'
G[31099]='L90'
G[31100]='L30 A:100083777 T:61962 P:J6847'
G[31101]='L90'
G[31102]='L30 A:100083779 T:61962 P:J6855'
G[31103]='L30 A:100083780 T:61962 P:J6856'
G[31104]='L25 A:62304 T:62304 P:T4F662999 I:V0241,V0341,V0401,V0411 D039'	-- available with D035
G[31105]='K2 L25 A:62304 T:62304,62295,62378,62379,562295,562378,562379 I:V0241,V0341,V0351,V0371,V0401,V0411 D038'
G[31106]='K2 L25 A:62304 T:62304,62295,62378,62379,562295,562378,562379 I:V0241,V0341,V0351,V0381,V0401,V0411 D037'
G[31107]='L30 A:562774 T:562774 P:31007+31010+31660'	-- TODO: Verify requires 31660
G[31108]='L30 A:64599 T:64599 P:31661'	-- TODO: Determine if this needs 31008 as well
G[31109]='K2 L30 A:62538 T:62538 P:31066 I:31111,31231,31267,V0071,V0081,V0101 D009'
G[31110]='L25 A:62810 T:62810 P:T4F644999'	-- TODO: This is not the proper prerequisite as on 5.2 PTR Wholly shows it available when it is not actually.
G[31111]='K2 L30 A:62538 T:62538 P:31066 I:31109,31231,31267,V0071,V0081,V0091 D010'
G[31112]='L10 A:62923 T:555521 P:29821'
G[31113]='K2 L25 A:63009 T:63009,63195,63196,63197,563195,563196,563197 I:V0341,V0351,V0371,V0381,V0391,V0401 D024'
G[31114]='K2 L25 A:63009 T:63009,63195,63196,63197,563195,563196,563197 I:V0341,V0351,V0371,V0381,V0391,V0401 D024'
G[31115]='L1'
G[31116]='K2 L25 A:63009 T:63009,63195,63196,63197,563195,563196,563197 I:31118,V0341,V0351,V0371,V0381,V0391,V0401 D024'
G[31117]='K2 L25 A:-388,63009 T:63009 P:31114+31116|31118 I:31120'
G[31118]='K2 L25 A:63009,63195,63196,63197,563195,563196,563197 T:63197 I:31116,V0341,V0351,V0371,V0381,V0391,V0401 D024'
G[31119]='K2 L25 A:63009 T:63009,63195,63196,63197,563195,563196,563197 I:V0341,V0351,V0371,V0381,V0391,V0401 D024'
G[31120]='K2 L25 A:-388 T:63009 P:31113+31119 I:31117'
G[31121]='FH L10 A:55768 T:55768 P:29822'
G[31122]='L90'
G[31123]='L90'	-- This is marked on the server after having chosen Chao the Voice (63196), which of course is available after defeating her in combat.
G[31124]='L90'
G[31125]='L90'
G[31126]='L90'
G[31127]='L25 A:63009 T:63009 P:T4F650999 I:V0341,V0351,V0371,V0381,V0391,V0401 D041'	-- available with D024
G[31128]='L25 A:63009 T:63009 P:T4F662999 I:V0341,V0351,V0371,V0381,V0391,V0401 D041'	-- available with D024
G[31129]='L30 A:62779 T:62779 P:29907+31068 I:31076'
G[31130]='FA L10 A:54961 T:61218 P:29889'
G[31131]='K2 L21850 A:58408 T:59342 P:30307+W0041+W0061+W0031+W0051 I:31242,31243,V0231 Z17128'
G[31132]='FH L10 A:63193 T:63217 P:31121'
G[31133]='L30 A:63218 T:63218 P:31069+31070'
G[31134]='FH L10 A:63217 T:63217 P:31132'
G[31135]='FA L1 CO A:42396 T:63238 P:27674'
G[31136]='K2 L90 A:58408 P:W0234+t4F550999'
G[31137]='FA L1 RN A:63238 T:42317 P:31135 I:26421,26422,26423,26424,26425'
G[31138]='L1 A:63238 T:63238 P:31135 Z21691'
G[31139]='FA L1 RH RK CO A:197 T:197'
G[31140]='FA L1 RH RK CO A:197 T:197 P:31139'
G[31141]='FA L5 RH CO A:197 T:63258 P:31140 Z18505'
G[31142]='FA L5 RH CO A:63258 T:63258 P:31141 Z18505'
G[31143]='FA L1 RH RK CO A:63258 T:823 P:31140'
G[31144]='FA L1 RH RK CO A:823 T:823 P:31143'
G[31145]='FA L1 RH RK CO A:823 T:197 P:31144'
G[31146]='FH L5 RU CO A:1569 T:63272 P:26801 Z18505'
G[31147]='L5 RU CO A:63272 T:63272 P:31146 Z18505'
G[31148]='L5 RU A:63272 T:1661 P:28601 I:28651'
G[31150]='L5 RF CO A:37087 T:63285'
G[31151]='L515 A:63285 T:63285 P:31150'
G[31152]='FH L10 A:63217 T:63307 P:31134'
G[31153]='L0'
G[31154]='L0'
G[31155]='L0'
G[31156]='L5 CO A:3143 T:63296 P:25126 Z18505'
G[31157]='FH L515 RO CO A:63296 T:63296 P:31156 Z18505'
G[31158]='L1 CO A:63310 T:63310 P:31159'
G[31159]='FH L1 CO A:37951 T:63310'
G[31160]='L1 CO A:63310 T:63310 P:31158'
G[31161]='L1 CO A:63310 T:563310,63310 P:31160'
G[31162]='L1 CO A:563310,63310 T:63310 P:31161 Z21691'
G[31163]='L1 CO A:63310 T:38966 P:31161'
G[31165]='FH L5 RT CO A:44927 T:63327 Z18505'
G[31166]='FH L515 RT A:63327 T:63327 P:31165 Z18505'
G[31167]='FH L10 A:63307 T:63307 P:31152'
G[31168]='FA L5 RE CO A:2077 T:63331 P:28714+28715 Z22248'
G[31169]='FA L5 RE A:63331 T:63331 P:31168 Z22248'
G[31170]='L5 RB CO A:15278 T:63332 Z21691'
G[31171]='FH L5 RB A:63332 T:63332 P:31170 Z21691'
G[31172]='L5'
G[31173]='FA L5 RD CO A:63335 T:63335 P:9409 Z21691'
G[31174]='L22874 T:65354'
G[31175]='L30 A:62538 T:63071 P:T53950999+31066'
G[31176]='L30 A:63071 T:63071 P:31175'
G[31177]='L30 A:63071 T:63071 P:31175'
G[31178]='L30 A:63071 T:63071 P:31175'
G[31179]='L30 A:63071 T:62538 P:31176+31177+31178'	-- TODO: Verify requires 31176
G[31181]='L30 A:63349 T:63349 P:31265 O:31727'
G[31182]='L30 A:63349 T:63349 P:31265'
G[31183]='L30 A:63349 T:63317 P:31181+31182'
G[31184]='L30 A:63317 T:63317 P:31183'
G[31185]='L30 A:63317 T:63317 P:31183'
G[31186]='L30 A:63955 T:63955 P:31183'	--	need to see if you need to summon Dog first, which would imply P:B31185 is correct
G[31187]='L30 A:63349 T:63349 P:31183'
G[31188]='L30 A:63349 T:63349 P:31183'
G[31189]='L30 A:63349 T:63349 P:31184+31187'
G[31190]='L30 A:563317 T:500075 P:31189'
G[31194]='K2 L10 A:58564 T:58564 P:30142 I:V0171,V0191,V0201,V0211,V0361 D018'
G[31195]='L85'	-- removed  I:29822 ... see comment there
G[31196]='K2 L25 A:63614 T:63614,63622,63623,63624,563622,563623,563624 I:V0241,V0351,V0371,V0381,V0391,V0411 D034'
G[31197]='K2 L25 A:63614 T:63614,63622,63623,63624,563622,563623,563624 I:V0241,V0351,V0371,V0381,V0391,V0411 D034'
G[31198]='K2 L25 A:63614 T:63614,63622,63623,63624,563622,563623,563624 I:V0241,V0351,V0371,V0381,V0391,V0411 D034'
G[31199]='K2 L25 A:63614 T:63614,63622,63623,63624,563622,563623,563624 I:V0241,V0351,V0371,V0381,V0391,V0411 D034'
G[31200]='K2 L25 A:63614 T:63623 I:V0241,V0351,V0371,V0381,V0391,V0411 D034'
G[31201]='K2 L25 A:63614 T:63614,63622,63623,63624,563622,563623,563624 I:V0241,V0351,V0371,V0381,V0391,V0411 D034'
G[31203]='K2 L25 A:-388 T:63614 P:W0344 I:31204'
G[31204]='K2 L25 A:-388 T:63614 P:W0344 I:31203'
G[31205]='L0 T:61371'
G[31206]='L30 I:27861,27862,27863'
G[31207]='L20 A:63315 T:63314 P:1'
G[31208]='L30 A:562151 T:562151 P:31018'
G[31209]='L30 A:562151 T:562151 P:31018'
G[31210]='L30 A:562151 T:562151 P:31018'
G[31211]='L30 A:562151 T:62151 P:31208+31209+31210'
G[31212]='L0'
G[31213]='L0'
G[31214]='L0'	-- When he is your companion for the dailies
G[31216]='K2 L30 A:62151 T:62151 P:31208+31209+31210 I:31808'
G[31218]='L0'
G[31219]='L0'
G[31220]='L25 A:63614 T:63614 P:T4F650999 I:V0241,V0351,V0371,V0381,V0391,V0411 D040'	-- available with D034
G[31221]='L25 A:63614 T:63614 P:T4F662999 I:V0241,V0351,V0371,V0381,V0391,V0411 D040'	-- available with D034
G[31228]='L20 A:63784 T:63784 P:30946'
G[31230]='L10 A:56348 T:56348 P:29922,30015'
G[31231]='K2 L30 A:62538 T:62538 P:31066 I:31109,31111,31267,V0071,V0091,V0101 D008'
G[31232]='K2 L30 A:62180 T:62180 P:31026 I:31270,31496,31507,V0071,V0091,V0101 D008'
G[31233]='K2 L30 A:62180 T:62180 P:31026 I:31269,31502,31508,V0071,V0091,V0101 D008'
G[31234]='K2 L30 A:63072 T:63072 P:31606 I:31271,31503,31509,V0071,V0091,V0101 D008'
G[31235]='K2 L30 A:62538 T:62538 P:31066 I:31268,31487,31505,V0071,V0091,V0101 D008'
G[31237]='K2 L30 A:63785 T:63785 P:31458+31465 I:31272,31504,31510,V0071,V0091,V0101 D008'
G[31238]='K2 L30 A:63758 T:63758 P:31092+31359 I:31024,31494,31506,V0071,V0091,V0101 D008'
G[31239]='FH L10 A:56336 T:56336 P:29941'
G[31240]='K2 L90 A:59343 T:58503 P:W0131+W0141+W0151+W0161+T4F550999 I:31244,31245,31246,31247 Z17128'
G[31241]='L10 A:63748 T:56336 P:29879'
G[31242]='K2 L5920000 A:58408 T:59338 P:30307+W0041+W0061+W0031+W0051 I:31131,31243,V0231 Z17128'
G[31243]='K2 L90 A:58408 T:59337 P:30307+W0041+W0061+W0031+W0051 I:31131,31242,V0231 Z17128'
G[31244]='K2 L90 A:59343 T:59332 P:W0131+W0141+W0151+W0161+T4F550999 I:31240,31245,31246,31247 Z17128'
G[31245]='K2 L90 A:59343 T:59338 P:W0131+W0141+W0151+W0161+T4F550999 I:31240,31244,31246,31247 Z17128'
G[31246]='K2 L90 A:59343 T:58911 P:W0131+W0141+W0151+W0161+T4F550999 I:31240,31244,31245,31247 Z17128'
G[31247]='K2 L90 A:59343 T:58919 P:W0131+W0141+W0151+W0161+T4F550999 I:31240,31244,31245,31246 Z17128'
G[31248]='K2 L90 A:58408 T:58503 P:W0234+T4F550999 I:31249,31250 Z17128'
G[31249]='K2 L90 A:58408 T:59338 P:W0234+T4F550999 I:31248,31250 Z17128'
G[31250]='K2 L90 A:58408 T:58919 P:W0234+T4F550999 I:31248,31249 Z17128'
G[31251]='L20 A:59448 T:59448 P:30515 I:30583'
G[31252]='FA L20 A:59573 T:63754 P:30571+30581'	-- I:31253
G[31253]='FH L20 A:59573 T:63751 P:30571+30581'	-- I:31252
G[31254]='FA L20 N35 A:63778 T:59073'
G[31255]='FH L20 A:63778 T:59073'
G[31256]='FH L20 A:59442 T:59442 P:30515 I:30575'
G[31260]='L15 A:58779 T:58779 P:30353'
G[31261]='fH L10 A:100085783 T:56336'	-- available immediately, but cannot turn in until Grookin are friendly
G[31262]='L15 A:58779 T:58779 P:30352'
G[31265]='L30 A:63349 T:63349 P:31066 O:31727'
G[31266]='L25 A:63009 T:63009 P:T4F683999'
G[31267]='K2 L30 A:62538 T:62538 P:31066 I:31109,31111,31231,V0081,V0091,V0101 D007'
G[31268]='K2 L30 A:63758 T:63758 P:31092+31359 I:31235,31487,31505,V0081,V0091,V0101 D007'
G[31269]='K2 L30 A:62180 T:62180 P:31026 I:31233,31502,31508,V0081,V0091,V0101 D007'
G[31270]='K2 L30 A:62180 T:62180 P:31026 I:31232,31496,31507,V0081,V0091,V0101 D007'
G[31271]='K2 L30 A:63072 T:63072 P:31606 I:31234,31503,31509,V0081,V0091,V0101 D007'
G[31272]='K2 L30 A:63785 T:63785 P:31458+31465 I:31237,31504,31510,V0081,V0091,V0101 D007'
G[31273]='L90'
G[31274]='L35'
G[31275]='L35'
G[31277]='L25 A:63009 T:562304 P:31266'
G[31278]='L1'
G[31279]='L10 A:59405,62322,65528,64041 T:64231 I:31486'
G[31280]='L21850'
G[31281]='L10 A:64231 T:64231'	-- I:31485 turns out to be clutter that is unneeded
G[31282]='L0 T:62540'
G[31283]='L0'
G[31284]='L1'
G[31285]='L20 A:563367 T:63367,563367 OCC:30453'
G[31286]='L20 A:63484 T:63484'
G[31287]='L20 A:63484 T:63484'
G[31288]='K2 L30 A:63984 T:63984 I:31291'	-- on PTR PX525 is wrong, as someone without Archaeology skill can pick it up
G[31289]='L30 T:72841'
G[31291]='K2 L30 A:63983 T:63983 P:PX525 I:31288'
G[31292]='L1 T:72761'
G[31293]='K2 L5920000 A:58911 T:58911 P:31243,31246 I:30287'
G[31294]='K2 L90 A:59338 T:58503 P:W0024+31242+T4F550999 I:30385,31295 Z17128'
G[31295]='K2 L90 A:59338 T:59332 P:W0024+31242+T4F550999 I:30385,31294 Z17128'
G[31296]='K2 L90 A:59337 T:58503 P:30285|30286+30288+30289|30290+30287|31293+31243+T4F550999 I:31297'
G[31297]='K2 L90 A:59337 T:58919 P:30285|30286+30288+30289|30290+30287|31293+31243+T4F550999 I:31296'
G[31298]='L0'	-- This gets set once it is discovered.  Perhaps we need to monitor those alerts in the UI.
G[31299]='L0'
G[31300]='L0'
G[31301]='L0'
G[31302]='L10 A:64231 T:64231 P:31281'
G[31303]='L10 A:59411 T:59418 P:30485,31362'
G[31304]='L1'
G[31305]='L21850'
G[31306]='L20 T:60795'
G[31307]='L1'
G[31308]='FA K8192 L1 A:63014 T:63014 P:S119467 I:31548,31552,31556,31571,31573,31576,31579,31582,31585,31588,31591'
G[31309]='FA K8192 L1 A:63014 T:63014 P:31591,31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31588 I:31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592'
G[31310]='L0'
G[31311]='L10 A:64231 T:58712 P:31302 I:31469'
G[31312]='L15 A:100086404 T:58705,558705 P:J6552+T4F883999'
G[31313]='L15 A:58705,558705 T:58705,558705 P:31312'
G[31314]='L15 A:58705,558705 T:1213767 P:31313'
G[31315]='L15 A:1213767 T:64314 P:31314'
G[31316]='FA K24576 L1 A:63596 T:64330 P:J7433 O:32008,31878,31879,31880,31881,31990'
G[31317]='L0'
G[31318]='L0 T:72841'
G[31319]='FA L10 A:59418 T:59418 P:31303 I:30504'
G[31320]='L15 A:58710 T:58710 P:T4F950399'
G[31321]='L15 A:58710 T:58710 P:31320+T4F958799'
G[31322]='L15 A:58710 T:58710 P:31321+T4F967199'
G[31323]='L15 A:58710 T:58710 P:31322+T4F975599'	-- TODO: When I first got to be Good Friend (1764) it did not appear, but the next day at 3654 (after turning in carrots) it did
G[31324]='K64 L15 A:59822 T:59074'
G[31325]='L15 A:100086433 T:58761'
G[31326]='L15 A:100086434 T:58761'
G[31327]='K64 L15 A:59704 T:64361 O:30085'
G[31328]='L15 A:100086435 T:58761'
G[31329]='L15 A:100086436 T:58761'
G[31331]='L1'
G[31332]='K2 L10 A:64337 T:64337 P:31521+K100086425+t54D50399'
G[31333]='K2 L10 A:64337 T:64337 P:31521+K100086425+T54D50399+t54D58799'
G[31334]='K2 L10 A:64337 T:64337 P:31521+K100086425+T54D58799+t54D67199'
G[31335]='K2 L10 A:64337 T:64337 P:31521+K100086425+T54D67199+t54D75599'
G[31336]='K2 L10 A:64337 T:64337 P:31521+K100086425+T54D75599+t54D83999'
G[31337]='SP K2 L10 A:64337 T:64337 P:31820+K100086425'
G[31338]='L15 A:58709,558709 T:58709,558709 P:T4FD58799'
G[31339]='L15 A:58709,558709 T:58709,558709 P:31338+T4FD67199'
G[31340]='L15 A:58709,558709 T:58709,558709 P:31339+T4FD75599'
G[31341]='L15 A:58709,558709 T:58709,558709 P:31340'
G[31342]='L20 A:56541 T:64387'
G[31343]='L0 T:64344 P:31091 J:31091'
G[31344]='L0'
G[31345]='L0'
G[31346]='L0'
G[31347]='L0'
G[31348]='L0'
G[31349]='L0'
G[31350]='L0'
G[31351]='L0'
G[31352]='L0'
G[31353]='L0'
G[31354]='L30 A:563349,63349 T:64259,564259 P:31190'
G[31355]='K64 L10 A:60578 T:60578'
G[31356]='K64 L10 A:64399 T:64399'
G[31357]='K64 L20 A:64432 T:564432'
G[31359]='L30 A:64344 T:63758 P:31091'
G[31360]='K64 L20 A:64432 T:564432'
G[31362]='FA L10 A:59620 T:59411 P:30565+30568 I:30485'
G[31363]='K1088 L25 A:64467 T:564467'
G[31364]='K1088 L25 A:64467 T:564467'
G[31365]='L25 A:64517 T:64517'
G[31366]='L25 A:64517 T:64517'
G[31367]='FA L30 A:64508 T:61962 I:31016,31368 Z17128'
G[31368]='FH L30 A:64531 T:61962 I:31016,31367 Z17128'
G[31369]='FA L15'	-- A:64033 T:59584 I:31370,31445
G[31370]='FH L15 T:703960'	-- A:64010 T:59584 I:31369,31445
G[31371]='L0'
G[31372]='FA L15 A:64036 T:58721 I:31374,31281'
G[31373]='FA L10 A:64484 T:58228 I:31375 Z16357'
G[31374]='FH L15 A:64011 T:58721 I:31372,31281'
G[31375]='FH L10 A:64533 T:58228 I:31373 Z16357'
G[31376]='FA K2 L10 A:64032 T:57324 I:V0221,V0291,V0301,V0311,V0321,V0331,V0421 D025 D045'
G[31377]='FH K2 L10 A:64001 T:57324 I:V0221,V0291,V0301,V0311,V0321,V0331,V0421 D025 D045'
G[31378]='FA K2 L15 A:64032 T:60506 I:V0221,V0291,V0301,V0311,V0321,V0331,V0421 D026 D045'
G[31379]='FH K2 L15 A:64001 T:60506 I:V0221,V0291,V0301,V0311,V0321,V0331,V0421 D026 D045'
G[31380]='FA K2 L20 A:64032 T:60968 I:V0221,V0291,V0301,V0311,V0321,V0331,V0421 D027 D045'
G[31381]='FH K2 L20 A:64001 T:60968 I:V0221,V0291,V0301,V0311,V0321,V0331,V0421 D027 D045'
G[31382]='FA K2 L25 A:64032 T:61580 I:V0221,V0291,V0301,V0311,V0321,V0331,V0421 D028 D045'
G[31383]='FH K2 L25 A:64001 T:61580 I:V0221,V0291,V0301,V0311,V0321,V0331,V0421 D028 D045'
G[31384]='FA L30 A:64031 T:58919 I:31385'
G[31385]='FH L30 A:64007 T:58919 I:31384'
G[31386]='FA L25 A:64030 T:60688 I:30768,31388,31695'
G[31387]='FA L25 A:64030 T:62304 Z17128'
G[31388]='FH L25 A:64002 T:60688 I:30768,31386,31695'
G[31389]='FH L25 A:64002 Z17128'
G[31390]='FA L30 A:64488 T:62112 I:31000,31391,31656,31847,31886,31895'
G[31391]='FH L30 A:64534 T:62112 I:31000,31390,31656,31847,31886,31895'
G[31392]='FA L20 AP:1;63754:30514;563754:X30514;64521;55809;64448;60289 T:64540 I:31393'
G[31393]='FH L20 A:64521,55809,563751,564521 T:64542 I:31392'	-- reported that Farmhand Ko not immediately available, so this would be a great use of qualified NPCs...correct, not immediately available for him
G[31394]='FA L20 A:64540 T:64540 O:31392 I:31395'
G[31395]='FH L20 A:64542 T:64542 O:31393 I:31394'
G[31396]='L1'
G[31397]='L1'
G[31398]='L30 A:1214062 T:63758 P:31091'
G[31399]='L1'
G[31400]='L1'
G[31401]='L1'
G[31402]='L1'
G[31403]='L1'
G[31404]='L1'
G[31405]='L1'
G[31406]='L1'
G[31407]='L1'
G[31408]='L1 T:72762'
G[31409]='L1'
G[31410]='L1'
G[31411]='L1'
G[31412]='L1'
G[31413]='L1'
G[31414]='L1'
G[31415]='SP L1'	-- A:1213770 T:1213770
G[31416]='SP L1'	-- A:1213771 T:1213771
G[31417]='L1'
G[31418]='L1'
G[31419]='SP L1'	-- A:1213793 T:1213793
G[31420]='SP L1'	-- A:1214438 T:1214438
G[31421]='L1'
G[31422]='L1'
G[31423]='L1'
G[31424]='L1'
G[31425]='L1'
G[31426]='L1'
G[31427]='L1'
G[31428]='L1'
G[31429]='L1'
G[31430]='L1'
G[31431]='L1'
G[31432]='L1'
G[31433]='L1'
G[31434]='L1'
G[31435]='L1'
G[31436]='L1'
G[31437]='L1'
G[31438]='L1'
G[31439]='L30 A:64815 T:64672 P:T53962999+31066'
G[31440]='L15 A:64562 T:564562,500086'
G[31441]='L30 A:64672 T:64705 P:31439'
G[31442]='L35 A:64563 T:564563,500085'
G[31443]='K2 L15 A:100086542 T:63721 P:K100086542'
G[31444]='K2 L15 A:100086544 T:63721 P:K100086544'
G[31445]='L90 T:72841 I:31369,31370'
G[31446]='K2 L15 A:100086545 T:63721 P:K100086545'
G[31447]='L15 A:64562 T:500086'
G[31448]='L35 A:64563 T:500085'
G[31450]='L1 RA RA RA A:56013 TA:60566 TH:60570 P:29800'
G[31451]='FH L20 A:63535 T:59263 P:30655+30656+30661|30663'	-- I:31452
G[31452]='FA L20 A:563542 T:59263 P:30650+30651+30660|30662'	-- I:31451
G[31453]='FH L20 A:59442 T:60161 P:30655+30656+30661|30663'
G[31454]='K4096 L90 A:64616 T:64616 P:31488 Z19033'
G[31455]='FA L20 A:59441 T:60161 P:30650+30651+30660|30662'
G[31456]='FA L20 A:63754 T:59353 P:30660,30662'	-- I:31457
G[31457]='FH L20 A:63751 T:59353 P:30661,30663'	-- I:31456
G[31458]='L30 A:64705 T:63785 P:31441'
G[31459]='FH L20 A:59449 T:61847 P:30655+30656+30661|30663'	-- I:31460
G[31460]='FA L20 A:59451 T:61847 P:30650+30651+30660|30662'	-- I:31459
G[31461]='L0'	-- these get cleared as you are doing a Celestial Experience to keep track of what you have done
G[31462]='L0'
G[31463]='L0'
G[31464]='L0'
G[31465]='L30 A:64705 T:63785 P:31441'
G[31466]='L0 T:83746'
G[31467]='L10 A:58712 T:58712 P:31311'
G[31468]='K4096 L35 A:64616 T:64616 P:31454 Z19033'
G[31469]='L21594 I:31311'
G[31470]='L10 A:64231 T:58713 P:31302'
G[31471]='L10 A:58713 T:58713 P:31470'
G[31472]='L10 A:64231 T:58714 P:31302'
G[31473]='K4096 L35 A:64616 T:64616 P:31454 Z19033'
G[31474]='L10 A:58714 T:58714 P:31472'
G[31475]='L10 A:64231 T:58715 P:31302'
G[31476]='L10 A:58715 T:58715 P:31475'
G[31477]='L10 A:58716 T:58716 P:31478'
G[31478]='L10 A:64231 T:58716 P:31302'
G[31479]='L10 A:64231 T:58717 P:31302'
G[31480]='L10 A:58717 T:58717 P:31479'
G[31481]='L35 A:64616 T:64616 P:31473 Z19033'
G[31482]='L35 A:64616 T:64822 P:31481 Z19033'
G[31483]='L35 A:64822 T:64616 P:31482 Z19033'
G[31484]='L0'
G[31485]='L21850 I:31281'
G[31486]='L10 A:56707,62872,63013 T:64231 I:31279'
G[31487]='K2 L30 A:63758 T:63758 P:31092+31359 I:31235,31268,31505,V0071,V0081,V0101 D009'
G[31488]='K4096 L90 A:60422,62871,63218,64457,66409,66415 AA:64144,65908 AH:64047,66225 T:64616 Z19033'	-- PTR recorded I:31489 but we will not clutter the UI with it
G[31489]='K4096 L90'	-- This seems not to be used.   A:60422,63218,64047,64144,64457,65908,66409,66415 T:64616 I:31488
G[31490]='L10 A:564738 T:64738 E15640'
G[31491]='K2 L90 A:60981 P:1'
G[31492]='K2 L20 A:60981 T:60981 I:V0221,V0251,V0261,V0281,V0311,V0321,V0331,31517 D042'
G[31493]='L10 A:564738 T:64738 E15640'
G[31494]='K2 L30 A:63758 T:63758 P:31092+31359 I:31024,31238,31506,V0071,V0081,V0101 D009'
G[31495]='L35 A:564764 T:64764 E15640'
G[31496]='K2 L30 A:62180 T:62180 P:31026 I:31232,31270,31507,V0071,V0081,V0101 D009'
G[31497]='L35 A:564764 T:64764 E15640'
G[31498]='L35'
G[31499]='L35'
G[31500]='L35'
G[31501]='L35'
G[31502]='K2 L30 A:63072,67091 T:63072,67091 P:31606 I:31233,31269,31508,V0071,V0081,V0101 D009'
G[31503]='K2 L30 A:63072 T:63072 P:31606 I:31234,31271,31509,V0071,V0081,V0101 D009'
G[31504]='K2 L30 A:63785 T:63785 P:31458+31465 I:31237,31272,31510,V0071,V0081,V0101 D009'
G[31505]='K2 L30 A:62538 T:62538 P:31066 I:31235,31268,31487,V0071,V0081,V0091 D010'
G[31506]='K2 L30 A:63758 T:63758 P:31092+31359 I:31024,31238,31494,V0071,V0081,V0091 D010'
G[31507]='K2 L30 A:62180 T:62180 P:31026 I:31232,31270,31496,V0071,V0081,V0091 D010'
G[31508]='K2 L30 A:63072 T:63072 P:31606 I:31233,31269,31502,V0071,V0081,V0091 D010'
G[31509]='K2 L30 A:63072 T:63072 P:31606 I:31234,31271,31503,V0071,V0081,V0091 D010'
G[31510]='K2 L30 A:63785 T:63785 P:31458+31465 I:31237,31272,31504,V0071,V0081,V0091 D010'
G[31511]='FH L20 A:64542 T:59905 P:31395 I:31512'
G[31512]='FA L20 A:64540 T:59905 P:31394 I:31511'
G[31513]='L10 A:64827 T:64854 E15640'
G[31514]='L10 A:64854 T:64841 P:31513 E15640'
G[31515]='L35 A:64838 T:64855 E15640'
G[31516]='L35 A:64855 T:64842 P:31515'
G[31517]='K2 L20 A:60968 T:60968 I:V0221,V0251,V0261,V0281,V0311,V0321,V0331,31492 D042'
G[31518]='L20'
G[31519]='FH K1026 L90 A:63994 T:63994 I:31520,31522,31523,31524,31525,31526,31527,31528'
G[31520]='FH K1026 L35 A:63994 T:63994 I:31519,31522,31523,31524,31525,31526,31527,31528'
G[31521]='L10 A:64231 T:64231 P:PC600'
G[31522]='FH K1026 L35 A:63994 T:63994 I:31519,31520,31523,31524,31525,31526,31527,31528'
G[31523]='FH K1026 L90 A:63994 T:63994 I:31519,31520,31522,31524,31525,31526,31527,31528'
G[31524]='FH K1026 L90 A:63994 T:63994 I:31519,31520,31522,31523,31525,31526,31527,31528'
G[31525]='FH K1026 L35 A:63994 T:63994 I:31519,31520,31522,31523,31524,31526,31527,31528'
G[31526]='FH K1026 L90 A:63994 T:63994 I:31519,31520,31522,31523,31524,31525,31527,31528'
G[31527]='FH K1026 L90 A:63994 T:63994 I:31519,31520,31522,31523,31524,31525,31526,31528'
G[31528]='FH K1026 L90 A:63994 T:63994 I:31519,31520,31522,31523,31524,31525,31526,31527'
G[31529]='L15 A:58708 T:58708 P:T4FE55439 I:31530'	-- Acquaintance +5040 (at least more than 4095)
G[31530]='L15 I:31529'
G[31531]='L15 A:58708 T:58708 P:T4FE71430'	-- Friend +4231 (at least more than 2761)
G[31532]='L15 A:58708 T:58708 P:T4FE79925'	-- Good Friend +4326 (at least more than 2436)
G[31533]='L90'
G[31534]='L15 A:58647,558647 T:58647,558647 P:T4FB58799'
G[31535]='SP K1 L10 A:64395 T:64395 P:31536'
G[31536]='L10 A:64395 T:64395 P:31467+31471+31474+31476+31477+31480'
G[31537]='L15 A:58647,558647 T:58647,558647 P:31534+T4FB67199'
G[31538]='L15 A:58647,558647 T:58647,558647 P:31537+T4FB75599'
G[31539]='K4 L10 A:56065 T:56065 P:PI600 I:31540,31541,31542,31543,31544'
G[31540]='K4 L10 A:56065 T:56065 P:PI600 I:31539,31541,31542,31543,31544'
G[31541]='K4 L10 A:56065 T:56065 P:PI600 I:31539,31540,31542,31543,31544'
G[31542]='K4 L10 A:56065 T:56065 P:PI600 I:31539,31540,31541,31543,31544'
G[31543]='K4 L10 A:56065 T:56065 P:PI600 I:31539,31540,31541,31542,31544'
G[31544]='K4 L10 A:56065 T:56065 P:PI600 I:31539,31540,31541,31542,31543'
G[31545]='L1'
G[31548]='FA K8192 L1 A:63075 T:63075 P:S119467 I:31308,31552,31556,31571,31573,31576,31579,31582,31585,31588,31591'
G[31549]='FA K8192 L1 A:63075 T:63075 P:31591,31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31588 I:31309,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592'
G[31550]='FA K8192 L1 A:63014 T:63014 P:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832 I:31551,31555,31569,31570,31575,31578,31581,31584,31587,31590,31593'
G[31551]='FA K8192 L1 A:63075 T:63075 P:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832 I:31550,31555,31569,31570,31575,31578,31581,31584,31587,31590,31593'
G[31552]='FA K8192 L1 A:63070 T:63070 P:S119467 I:31308,31548,31556,31571,31573,31576,31579,31582,31585,31588,31591'
G[31553]='FA K8192 L1 A:63070 T:63070 P:31591,31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31588 I:31309,31549,31568,31572,31574,31577,31580,31583,31586,31589,31592'
G[31554]='K8192 L5'
G[31555]='FA K8192 L1 A:63070 T:63070 P:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832 I:31550,31551,31569,31570,31575,31578,31581,31584,31587,31590,31593'
G[31556]='FA K8192 L1 A:63077 T:63077 P:S119467 I:31308,31548,31552,31571,31573,31576,31579,31582,31585,31588,31591'
G[31557]='L1'
G[31558]='L1'
G[31559]='L1'
G[31560]='L1'
G[31561]='L1'
G[31562]='L1'
G[31563]='L1'
G[31564]='L1'
G[31565]='L1'
G[31566]='L1'
G[31567]='L1'
G[31568]='FA K8192 L1 A:63077 T:63077 P:31591,31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31588 I:31309,31549,31553,31572,31574,31577,31580,31583,31586,31589,31592'
G[31569]='FA K8192 L1 A:63077 T:63077 P:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832 I:31550,31551,31555,31570,31575,31578,31581,31584,31587,31590,31593'
G[31570]='FH K8192 L1 A:63061 T:63061 P:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832 I:31550,31551,31555,31569,31575,31578,31581,31584,31587,31590,31593'
G[31571]='FH K8192 L1 A:63061 T:63061 P:S119467 I:31308,31548,31552,31556,31573,31576,31579,31582,31585,31588,31591'
G[31572]='FH K8192 L1 A:63061 T:63061 P:31591,31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31588 I:31309,31549,31553,31568,31574,31577,31580,31583,31586,31589,31592'
G[31573]='FH K8192 L1 A:63067 T:63067 P:S119467 I:31308,31548,31552,31556,31571,31576,31579,31582,31585,31588,31591'
G[31574]='FH K8192 L1 A:63067 T:63067 P:31591,31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31588 I:31309,31549,31553,31568,31572,31577,31580,31583,31586,31589,31592'
G[31575]='FH K8192 L1 A:63067 T:63067 P:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832 I:31550,31551,31555,31569,31570,31578,31581,31584,31587,31590,31593'
G[31576]='FH K8192 L1 A:63073 T:63073 P:S119467 I:31308,31548,31552,31556,31571,31573,31579,31582,31585,31588,31591'
G[31577]='FH K8192 L1 A:63073 T:63073 P:31591,31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31588 I:31309,31549,31553,31568,31572,31574,31580,31583,31586,31589,31592'
G[31578]='FH K8192 L1 A:63073 T:63073 P:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832 I:31550,31551,31555,31569,31570,31575,31581,31584,31587,31590,31593'
G[31579]='FH K8192 L1 A:63080 T:63080 P:S119467 I:31308,31548,31552,31556,31571,31573,31576,31582,31585,31588,31591'
G[31580]='FH K8192 L1 A:63080 T:63080 P:31591,31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31588 I:31309,31549,31553,31568,31572,31574,31577,31583,31586,31589,31592'
G[31581]='FH K8192 L1 A:63080 T:63080 P:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832 I:31550,31551,31555,31569,31570,31575,31578,31584,31587,31590,31593'
G[31582]='FA K8192 L1 A:63083 T:63083 P:S119467 I:31308,31548,31552,31556,31571,31573,31576,31579,31585,31588,31591'
G[31583]='FA K8192 L1 A:63083 T:63083 P:31591,31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31588 I:31309,31549,31553,31568,31572,31574,31577,31580,31586,31589,31592'
G[31584]='FA K8192 L1 A:63083 T:63083 P:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832 I:31550,31551,31555,31569,31570,31575,31578,31581,31587,31590,31593'
G[31585]='FH K8192 L1 A:63086 T:63086 P:S119467 I:31308,31548,31552,31556,31571,31573,31576,31579,31582,31588,31591'
G[31586]='FH K8192 L1 A:63086 T:63086 P:31591,31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31588 I:31309,31549,31553,31568,31572,31574,31577,31580,31583,31589,31592'
G[31587]='FH K8192 L1 A:63086 T:63086 P:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832 I:31550,31551,31555,31569,31570,31575,31578,31581,31584,31590,31593'
G[31588]='FH K8192 L1 A:63626 T:63626 P:S119467 I:31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31591'	-- Troll druid [what is really scary is the NE druid now has this in the log]
G[31589]='FH K8192 L1 A:63626 T:63626 P:31591,31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31588 I:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31592'
G[31590]='FH K8192 L1 A:63626 T:63626 P:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832 I:31550,31551,31555,31569,31570,31575,31578,31581,31584,31587,31593'
G[31591]='FA K8192 L1 A:63596 T:63596 P:S119467 I:31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,31588'	-- NE druid
G[31592]='FA K8192 L1 A:63596 T:63596 P:31591,31308,31548,31552,31556,31571,31573,31576,31579,31582,31585,3158 I:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589'
G[31593]='FA K8192 L1 A:63596 T:63596 P:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832 I:31550,31551,31555,31569,31570,31575,31578,31581,31584,31587,31590'
G[31598]='K2 L30 A:100087871 T:64599 P:V0101'
G[31599]='K2 L30 A:100087878 T:64599 P:V0091'
G[31600]='L0'
G[31603]='SP K1 L30 A:64599 T:64599 P:31108'
G[31604]='L22874'
G[31605]='L30 A:64815 T:65253,67091,63072 P:T53950999+31066'
G[31606]='L30 A:65253 T:67091 P:31066'
G[31607]='L0 J:30782+30783'
G[31609]='L30 A:-422 T:62538 P:31959'
G[31611]='K2048 L35 A:63367,563367 T:64901'	-- you get this from 563367 if you have not already done 31285 (since 63367 is at 563367 location)
G[31612]='L30 A:62538 T:62538 P:31609'
G[31613]='K2048 L35 A:62321 T:61203'
G[31614]='L10'
G[31615]='L10'
G[31616]='L10'
G[31617]='L10'
G[31618]='L10'
G[31619]='L10'
G[31620]='L35'
G[31621]='L35'
G[31622]='L35'
G[31623]='L35'
G[31624]='L35'
G[31625]='L35'
G[31626]='L35'
G[31627]='L35'
G[31628]='L35'
G[31629]='L35'
G[31630]='L35'
G[31631]='L35'
G[31632]='L35'
G[31633]='L35'
G[31634]='L35'
G[31635]='L35'
G[31636]='L35'
G[31637]='L35'
G[31638]='L35'
G[31639]='L35'
G[31640]='L35'
G[31641]='L35'
G[31642]='L35'
G[31643]='L35'
G[31644]='L35'
G[31645]='L35'
G[31646]='L35'
G[31647]='L35'
G[31648]='L35'
G[31649]='L35'
G[31650]='L35'
G[31651]='L35'
G[31652]='L90'
G[31654]='L87'
G[31655]='L0'
G[31656]='L30 A:62802 T:62112 P:30968 I:31000,31390,31391,31847,31886,31895'
G[31660]='L30 A:62538 T:62538 P:31006'
G[31661]='L30 A:1214562 T:64599 P:31006'
G[31664]='L1 T:0'
G[31665]='L1'
G[31666]='L1'
G[31668]='L0'
G[31669]='K2 L15 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:31670,31671,31672,31673,31674,31675,31941,31942,31943,32682'
G[31670]='K2 L15 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:31669,31671,31672,31673,31674,31675,31941,31942,31943,32682'
G[31671]='K2 L15 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:31669,31670,31672,31673,31674,31675,31941,31942,31943,32682'
G[31672]='K2 L15 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:31669,31670,31671,31673,31674,31675,31941,31942,31943,32682'
G[31673]='K2 L15 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:31669,31670,31671,31672,31674,31675,31941,31942,31943,32682'
G[31674]='K2 L15 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:31669,31670,31671,31672,31673,31675,31941,31942,31943,32682'
G[31675]='K2 L15 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:31669,31670,31671,31672,31673,31674,31941,31942,31943,32682'
G[31676]='L30 A:62202 T:62202 P:31004'
G[31677]='K2 L30 A:100088715 T:62538 P:V0081'
G[31679]='L30 P:31441'
G[31680]='L30 P:31441+31087|31679'
G[31681]='L30 P:31441+31087|31679'
G[31682]='L30 P:31441+31088|31680+31090|31681'
G[31685]='L15 E21655'
G[31687]='L25 A:62278 T:62278 P:31065'
G[31688]='L25 A:62278 T:62278 P:31065'
G[31689]='L30 A:62774,562774 T:562774 P:31661'
G[31690]='L10 T:56065 P:PI560'
G[31691]='L10 T:56065 P:PI560'
G[31692]='L10 T:56065 P:PI560'
G[31693]='K8194 L1 AA:64330 T:64330 P:J6603'
G[31694]='L1'
G[31695]='L25 A:563542 T:60688 P:30650+30651+30660|30662,30655+30656+30661|30663 I:30768,31386,31388'
G[31697]='L22617'	-- I missed which quest sets this...30898 or 30900 I think.
G[31698]='K2 L10 A:58228 T:58564 P:30142 I:30154,V0171,V0181,V0201,V0211,V0361 D019'
G[31699]='K2 L10 A:58509 T:58564 P:30142 I:31700,V0171,V0181,V0201,V0211,V0361 D019'
G[31700]='K2 L10 A:58509 T:58564 P:30142 I:31699,V0171,V0181,V0201,V0211,V0361 D019'
G[31701]='K2 L10 A:58564 T:58564 P:30142 I:31702,31703,V0171,V0181,V0201,V0211,V0361 D019'
G[31702]='K2 L10 A:58564 T:58564 P:30142 I:31701,31703,V0171,V0181,V0201,V0211,V0361 D019'
G[31703]='K2 L10 A:58564 T:58564 P:30142+t4F762999 I:31701,31702'
G[31704]='K2 L10 A:65669 T:65669 P:30142+t4F762999 I:V0181,V0191,V0201,V0211,V0361 D017'	-- I:31716
G[31705]='K2 L10 A:58564 T:58564 P:30150+31704+t4F762999'
G[31706]='K2 L10 A:58228 T:58564 P:T4F762999 I:V0171,V0181,V0191,V0201,V0361 D021'
G[31707]='K2 L10 A:58228 T:58564 P:T4F762999 I:31709,V0171,V0181,V0191,V0201,V0361 D021'
G[31708]='L10'
G[31709]='K2 L10 A:58508 T:58564 P:T4F762999 I:31707,V0171,V0181,V0191,V0201,V0361 D021'
G[31710]='L10'
G[31711]='K2 L10 A:58564 T:58564 P:T4F762999 I:V0171,V0181,V0191,V0201,V0361 D021'
G[31712]='K2 L10 A:58228 T:58564 P:T4F762999 I:V0171,V0181,V0191,V0211,V0361 D020'
G[31713]='K2 L10 A:58506 T:58506 P:T4F762999 I:31714,V0171,V0181,V0191,V0211,V0361 D020'
G[31714]='K2 L10 A:58511 T:58564 P:T4F762999 I:31713,V0171,V0181,V0191,V0211,V0361 D020'
G[31715]='K2 L10 A:58564 T:58564 P:T4F762999 I:V0171,V0181,V0191,V0211,V0361 D020'
G[31716]='K2 L10 T:72763 I:31704'
G[31717]='K2 L10 A:58564 T:58564 P:30187 I:V0171,V0181,V0191,V0201,V0211 D036'
G[31718]='K2 L10 A:58564 T:58564 P:30187 I:V0171,V0181,V0191,V0201,V0211 D036'
G[31719]='K2 L10 A:58564 T:58564 P:30187 I:V0171,V0181,V0191,V0201,V0211 D036'
G[31720]='K2 L10 A:58564 T:58564 P:30187 I:V0171,V0181,V0191,V0201,V0211 D036'
G[31721]='K2 L10 A:58564 T:58564 P:30187 I:V0171,V0181,V0191,V0201,V0211 D036'
G[31723]='L15 E21655'
G[31724]='FA K24576 L1 AA:64330 T:65648 P:31316'
G[31725]='FA K24576 L1 AA:65648 T:65651 P:31724'
G[31726]='FA K24576 L1 AA:65651 T:65655 P:31725'
G[31727]='L30 A:64599 T:63349 P:31026+31398'
G[31728]='FA K24576 L1 AA:63194 T:65656 P:31729'
G[31729]='FA K24576 L1 AA:65655 T:63194 P:31726'	-- note that you cannot interact with him if you have Bwemba's spirit as he is not even there
G[31730]='L30 A:62538 T:62666 P:31026+31398'
G[31731]='L21846'
G[31732]='FA L10 A:66292 T:66292 P:29548'
G[31733]='FA L10 A:66292 T:54616 P:31732'
G[31734]='FA L10 A:54616 T:54617 P:31733'
G[31735]='FA L10 A:54617 T:554617 P:30069+31734'
G[31736]='FA L10 A:500081 T:65910 P:31735'
G[31737]='FA L10 A:500081 T:66296 P:31735'
G[31738]='FA L10 A:65910 T:65910 P:31736+31737'
G[31739]='FA L10 A:66209 T:66199 P:31736+31737'
G[31740]='FA L10 A:66199 T:65910 P:31739'
G[31741]='FA L10 A:65910 T:554616 P:29552+31738+31740'
G[31742]='FA L10 A:500082 T:554616 P:29552+31738+31740'
G[31743]='FA L10 A:500082 T:554616 P:29552+31738+31740'
G[31744]='FA L10 A:65910 T:554616 P:29552+31738+31740'
G[31745]='FA L10 A:66581 T:566292 P:30070'
G[31752]='SP K2 L1 A:43929 T:43929 I:34774,40753,56042 ODC:34774,40753,56042'
G[31754]='K2 L5920000 A:558471 T:558471 P:30638 I:31756,31758 Z17128 D003'
G[31755]='K2 L30 A:558468 T:558468 P:30638 I:30312,30320 Z17128 D004'
G[31756]='K2 L30 A:558471 T:558471 P:30638 I:31754,31758 Z17128 D003'
G[31757]='K2 L90 A:558465 T:558465 P:30638 I:30308,30309,30310 Z17128 D005'
G[31758]='K2 L5920000 A:558471 T:558471 P:30638 I:31754,31756 Z17128 D003'
G[31759]='L90'
G[31760]='K2 L30 A:558465 T:558465 P:30638 I:31762 Z17128 D006'
G[31761]='L90'
G[31762]='K2 L5920000 A:558465 T:558465 P:30638 I:31760 Z17128 D006'
G[31763]='L90'
G[31764]='L21846'
G[31765]='FH L10 A:55135 T:66667 P:29690'
G[31766]='FH L10 A:66667 T:66190 P:31765'
G[31767]='FH L10 A:66190 T:66646 P:31766'
G[31768]='FH L10 A:66190 T:66646 P:31766'
G[31769]='FH L10 A:66646 T:66656 P:31767+31768'
G[31770]='FH L10 A:66656 T:66220 P:31769'	-- forced acceptance when entering parts of The Jade Forest
G[31771]='FH L10 A:66657 T:66665 P:31769'	-- forced acceptance when entering parts of The Jade Forest
G[31772]='L10 A:66660 T:66848 P:31769 I:31978 ODC:31969'
G[31773]='FH L10 A:66659,66853 T:66665 P:31769'
G[31774]='FH L10 A:66845 T:55403 P:29694+31771+31773'
G[31775]='FH L10 A:65999 T:65999 P:29804'
G[31776]='FH L10 A:65999 T:65999 P:29804'
G[31777]='FH L10 A:55521 T:55521,555521 P:29804'	-- once the phasing at Strongarm Airstrip has happened, 55521 is no longer a valid T
G[31778]='FH L10 A:65998 T:65998 P:29804'
G[31779]='FH L10 A:65999 T:1215844 P:31775+31776+31777+31778'	-- TODO: Verify requires 31776
G[31780]='K8194 L1 AA:65648 T:0,65648 P:J6603'
G[31781]='K8194 L1 AA:65651 T:0,65651 P:J6603'
G[31782]='L30 A:65395 T:62519 P:32030'
G[31784]='SP K1 L10 A:58564 T:58564 P:K100089155'
G[31785]='FA K8192 L1 A:63014 T:63014 P:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592 I:31821,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832'
G[31786]='L10 A:100089169 T:1214205 P:K100089169+PX525'
G[31787]='L10 A:100089170 T:1214206 P:K100089170+PX525'
G[31788]='L10 A:100089171 T:1214207 P:K100089171+PX525'
G[31789]='L10 A:100089172 T:1214208 P:K100089172+PX525'
G[31790]='L10 A:100089173 T:1214209 P:K100089173+PX525'
G[31791]='L10 A:100089174 T:1214210 P:K100089174+PX525'
G[31792]='L10 A:100089175 T:1214211 P:K100089175+PX525'
G[31793]='L10 A:100089176 T:1214212 P:K100089176+PX525'
G[31794]='L10 A:100085477 T:1214213 P:K100085477+PX525'
G[31795]='L10 A:100085557 T:1214217 P:K100085557+PX525'
G[31796]='L10 A:100085558 T:1214218 P:K100085558+PX525'
G[31797]='L10 A:100089178 T:1214219 P:K100089178+PX525'
G[31798]='L10 A:100089179 T:1214220 P:K100089179+PX525'
G[31799]='L10 A:100089180 T:1214221 P:K100089180+PX525'
G[31800]='L10 A:100089181 T:1214222 P:K100089181+PX525'
G[31801]='L10 A:100089182 T:1214223 P:K100089182+PX525'
G[31802]='L10 A:100089183 T:1214224 P:K100089183+PX525'
G[31803]='L10 A:100089184 T:1214225 P:K100089184+PX525'
G[31804]='L10 A:100089185 T:1214226 P:K100089185+PX525'
G[31805]='L10 A:100089209 T:1214214 P:K100089209+PX525'
G[31806]='L1'
G[31807]='L0'
G[31808]='K2 L30 A:63758 T:63758 P:31092+31359+T53955999 I:31216'	-- assuming 5000 into honored for now
G[31809]='L25 A:100089317 T:62304'
G[31810]='L10 A:58564 T:58564 P:30145+30187+30165+T4F783999 I:30188,31811'	-- server completes all three (as well as all three prerequisites), what a pain
G[31811]='L10 A:58564 T:58564 P:30145+30187+30167+T4F783999 I:30188,31810'	-- server completes all three (as well as all three prerequisites), what a pain
G[31812]='FH K24576 L1 A:63626 T:66126 O:31882,31883,31884,31885,32009'
G[31813]='FH K24576 L1 AH:66126 T:66135 P:31812'
G[31814]='FH K24576 L1 AH:66135 T:66136 P:31813'
G[31815]='FH K24576 L1 AH:66136 T:66137 P:31814'
G[31816]='L5'	-- seems never to have been implemented - he's not in the chain
G[31817]='FH K24576 L1 AH:66137 T:66372 P:31815'
G[31818]='K8194 L1 AH:66126 T:66126 P:J6602'
G[31819]='K8194 L1 AH:66135 T:66135 P:J6602'
G[31820]='L10 A:64337 T:64337 P:T54D83999'
G[31821]='FA K8192 L1 A:63596 T:63596 P:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592 I:31785,31822,31823,31824,31825,31826,31827,31828,31830,31831,31832'
G[31822]='FA K8192 L1 A:63075 T:63075 P:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592 I:31785,31821,31823,31824,31825,31826,31827,31828,31830,31831,31832'
G[31823]='FH K8192 L1 A:63073 T:63073 P:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592 I:31785,31821,31822,31824,31825,31826,31827,31828,31830,31831,31832'
G[31824]='FH K8192 L1 A:63080 T:63080 P:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592 I:31785,31821,31822,31823,31825,31826,31827,31828,31830,31831,31832'
G[31825]='FA K8192 L1 A:63077 T:63077 P:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592 I:31785,31821,31822,31823,31824,31826,31827,31828,31830,31831,31832'
G[31826]='FA K8192 L1 A:63070 T:63070 P:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592 I:31785,31821,31822,31823,31824,31825,31827,31828,31830,31831,31832'
G[31827]='FH K8192 L1 A:63626 T:63626 P:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592 I:31785,31821,31822,31823,31824,31825,31826,31828,31830,31831,31832'
G[31828]='FH K8192 L1 A:63086 T:63086 P:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592 I:31785,31821,31822,31823,31824,31825,31826,31827,31830,31831,31832'
G[31829]='L0'
G[31830]='FH K8192 L1 A:63061 T:63061 P:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592 I:31785,31821,31822,31823,31824,31825,31826,31827,31828,31831,31832'
G[31831]='FH K8192 L1 A:63067 T:63067 P:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592 I:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31832'
G[31832]='FA K8192 L1 A:63083 T:63083 P:31309,31549,31553,31568,31572,31574,31577,31580,31583,31586,31589,31592 I:31785,31821,31822,31823,31824,31825,31826,31827,31828,31830,31831'
G[31833]='L10 CO A:66260 T:66260 P:31834'
G[31834]='L10 CO A:66260 T:66260 P:31856'
G[31835]='L10 CO A:66260 T:66260 P:31833'
G[31836]='L15 CO A:66260 T:66260 P:31835'
G[31837]='L20 CO A:66260 T:66260 P:31836'
G[31838]='L25 CO A:66260 T:66260 P:31837'
G[31839]='L30 CO A:66260 T:66260 P:31838'
G[31840]='K2 L10 CO A:66260 T:66260 P:31834'
G[31841]='K2 L10 CO A:66260 T:66260 P:31833'
G[31842]='K2 L10 CO A:66260 T:66260 P:31835'
G[31843]='K2 L15 CO A:66260 T:66260 P:31836'
G[31844]='K2 L20 CO A:66260 T:66260 P:31837'
G[31845]='K2 L25 CO A:66260 T:66260 P:31838'
G[31846]='K2 L30 CO A:66260 T:66260 P:31839'
G[31847]='L30 A:61512 T:62112 I:31000,31390,31391,31656,31886,31895'
G[31850]='K8194 L1 AA:65655 T:0,65655 P:J6603'
G[31851]='K8194 L1 AA:65656 T:0,65656 P:J6603'
G[31852]='K8194 L1 AA:63194 T:0,63194 P:J6603'
G[31853]='FH L10 A:54870 T:55054 P:29611'
G[31854]='K8194 L1 AH:66136 T:66136 P:J6602'
G[31855]='L10 CO A:0 T:66260'
G[31856]='L10 CO A:0 T:66260'
G[31857]='L10 CO A:0 T:66260'
G[31858]='L15 CO A:0 T:66260'
G[31859]='L20 CO T:66260'
G[31860]='L25 CO A:21774 T:66260'
G[31861]='L30 CO A:29432 T:66260'
G[31862]='K8194 L1 AH:66137 T:66137 P:J6602'
G[31863]='L1'
G[31864]='L1'
G[31865]='L1'
G[31866]='L1'
G[31867]='L1'
G[31868]='L1'
G[31869]='L1'
G[31870]='FH K8192 L1 AH:66372 T:66422 P:31817'
G[31871]='K8194 L1 AH:66352 T:66352 P:J6602'
G[31872]='K8194 L1 AH:66372 T:66372 P:J6602'
G[31876]='L10 A:64691 T:56065 P:PI001'
G[31877]='L21850 P:PI001'
G[31878]='FA L1 I:31879,31880,31881,31990,32008'
G[31879]='FA L1 I:31878,31880,31881,31990,32008'
G[31880]='FA L1 I:31878,31879,31881,31990,32008'
G[31881]='FA L1 I:31878,31879,31880,31990,32008'
G[31882]='FH K8192 L1 T:63626 I:31883,31884,31885,32009'
G[31883]='FH K8192 L1 T:63626 I:31882,31884,31885,32009'
G[31884]='FH K8192 L1 T:63626 I:31882,31883,31885,32009'
G[31885]='FH K8192 L1 T:63626 I:31882,31883,31884,32009'
G[31886]='L30 A:63498 T:62112 I:31000,31390,31391,31656,31847,31895'
G[31887]='L5'
G[31888]='L5'
G[31889]='FA K24576 L1 A:63596 T:0 P:31728'
G[31890]='L5'
G[31891]='FH K24576 L1 A:63626 T:-77 P:31870'
G[31892]='L5'
G[31893]='L5'
G[31894]='L25 A:60864 T:60857 P:30784'
G[31895]='L30 P:30926+30927+30928 I:31000,31390,31391,31656,31847,31886'
G[31897]='K24576 L1 A:0,66466 T:66466 P:31889,31891'
G[31902]='FA K24576 L1 N60 A:63596 T:0 P:31728'
G[31903]='FH K24576 L1 N60 A:63626 T:0 P:31870'
G[31904]='K8194 L1 AH:66422 T:66422 P:J6602'
G[31905]='K8194 L1 AH:66436 T:66436 P:J6602'
G[31906]='K8194 L1 AH:66452 T:66452 P:J6602'
G[31907]='K8194 L1 AH:66442 T:66442 P:J6602'
G[31908]='K8194 L1 AH:66412 T:66412 P:J6602'
G[31909]='K8194 L1 A:66466 T:66466 P:31897'
G[31910]='K8194 L1 AA:66478 T:66478 P:J6603'
G[31911]='K8194 L1 AA:66512 T:66512 P:J6603'
G[31912]='K8194 L1 AA:66515 T:66515 P:J6603'
G[31913]='K8194 L1 AA:66518 T:66518 P:J6603'
G[31914]='K8194 L1 AA:66520 T:66520 P:J6603'
G[31915]='K24576 L1 A:0,66522 T:66522 P:31902,31903'
G[31916]='K8194 L1 A:66522 T:66522 P:31915'
G[31917]='FA K8192 L1 AA:65656 T:63596 P:31728'
G[31918]='FH K8192 L1 AH:66422 T:63626 P:31870'
G[31919]='FA K24576 L1 A:63596 T:0 P:31975+31976'
G[31920]='K24576 L1 A:0,66557 T:66557 P:31919,31921'
G[31921]='FH K24576 L1 A:63626 T:0 P:31977+31980'
G[31922]='K8194 L1 A:66550 T:66550 P:31920'
G[31923]='K8194 L1 A:66551 T:66551 P:31920'
G[31924]='K8194 L1 A:66552 T:66552 P:31920'
G[31925]='K8194 L1 A:66553 T:66553 P:31920'
G[31926]='K8194 L1 A:66557 T:66557 P:31920'
G[31927]='FA L1 A:63596 T:66635'
G[31928]='L1 A:66635 T:66675'
G[31929]='FH L1 A:63626'
G[31930]='FA L1 T:-388'
G[31931]='L1 A:66635 T:66635'
G[31932]='L1 A:66636 T:66636'
G[31933]='L1 A:66638 T:66638'
G[31934]='L1 A:66639 T:66639'
G[31935]='L1 A:66675 T:66675'
G[31936]='L15 A:100089812 T:558646 P:30531+R114431+i114431'
G[31937]='L15 A:100089813 T:558646 P:30533+R114483+i114483'
G[31938]='L15 A:100089814 T:558646 P:30574+R114624+i114624'
G[31939]='L1'
G[31940]='L5'
G[31941]='K2 L15 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:31669,31670,31671,31672,31673,31674,31675,31942,31943,32682'
G[31942]='K2 L15 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:31669,31670,31671,31672,31673,31674,31675,31941,31943,32682'
G[31943]='K2 L15 AP:558646:X32682;500089:A32682 TP:558646:X32682;500089:A32682 P:30257 I:31669,31670,31671,31672,31673,31674,31675,31941,31942,32682'
G[31944]='L35 CO A:66260 T:66260 P:31839'
G[31945]='L15 A:58706 T:58706 P:30257 ODC:31950,31960'
G[31946]='L15 A:57401 T:57401 P:30259 ODC:31961'
G[31947]='L15 A:57298,557298 T:57298,557298 P:30518 ODC:31962'
G[31948]='L15 A:64597 T:64597 P:30519'
G[31949]='L15 A:64597 T:64597 P:31948'
G[31950]='L21846 T:58706'
G[31951]='L1 A:-388 T:66741'
G[31952]='FH L1 A:63626'
G[31953]='L1 A:66730 T:66730 P:0'	-- TODO: pet battle needs P: because cannot get immediately
G[31954]='L1 A:66733 T:66733'
G[31955]='L1 A:66734 T:66734'
G[31956]='L1 A:66738 T:66738'
G[31957]='K8194 L1 A:66739 T:66739'
G[31958]='L1 A:66741 T:66741'
G[31959]='L30 A:66875 T:-422 P:T53983999+31026+31085+31179+31211+31354+31398+31439+31606'
G[31960]='L0 T:58706'
G[31961]='L0 T:57401'
G[31962]='L0 T:57298'
G[31963]='L0 T:72841'
G[31964]='L0 T:72841'
G[31965]='L0 T:72841'
G[31966]='FA L1 T:72841'
G[31967]='FH L1 A:63626'
G[31968]='L21846'
G[31969]='L0 T:66848'
G[31970]='L1 T:72841'
G[31971]='L1 A:66824 T:66824'
G[31972]='L1 A:66819 T:66819'	-- TODO: Determine P: as Nimhfree cannot get this
G[31973]='L1 A:66815 T:66815'
G[31974]='K8194 L1 A:66822 T:66822 P:J7525'
G[31975]='FA K8192 L1 A:0,66466 T:63596 P:31897'
G[31976]='FA K8192 L1 A:0,66522 T:63596 P:31915'
G[31977]='FH K8192 L1 A:0,66466 T:63626 P:31897'
G[31978]='L10 A:66662 T:66848 P:31769 I:31772'
G[31979]='L5'
G[31980]='FH K8192 L1 A:0,66522 T:63626 P:31915'
G[31981]='FA L1 A:66557 T:63596'
G[31982]='FH L1 A:66557 T:63626 P:0'	-- TODO: Yoshimo: no quest for my warrior
G[31983]='FH L1 A:66675'
G[31984]='FA L1'
G[31985]='FA L1'
G[31986]='FH L1'
G[31987]='L10'
G[31988]='L90'
G[31989]='L35 CO'
G[31990]='L5 I:31878,31879,31880,31881,32008'
G[31991]='L1 A:66918 T:66918'
G[31992]='L0'
G[31993]='L0'
G[31994]='L0'
G[31995]='L0'
G[31996]='L0'
G[31997]='L0'
G[31998]='FA K1026 L35 A:64028 T:64028 I:32000,32001,32002,32003,32004,32005,32006,32007'
G[31999]='FH L10 A:1215844 T:55172 P:31779'
G[32000]='FA K1026 L90 A:64028 T:64028 I:31998,32001,32002,32003,32004,32005,32006,32007'
G[32001]='FA K1026 L35 A:64028 T:64028 I:31998,32000,32002,32003,32004,32005,32006,32007'
G[32002]='FA K1026 L35 A:64028 T:64028 I:31998,32000,32001,32003,32004,32005,32006,32007'
G[32003]='FA K1026 L35 A:64028 T:64028 I:31998,32000,32001,32002,32004,32005,32006,32007'
G[32004]='FA K1026 L90 A:64028 T:64028 I:31998,32000,32001,32002,32003,32005,32006,32007'
G[32005]='FA K1026 L90 A:64028 T:64028 I:31998,32000,32001,32002,32003,32004,32006,32007'
G[32006]='FA K1026 L90 A:64028 T:64028 I:31998,32000,32001,32002,32003,32004,32005,32007'
G[32007]='FA K1026 L90 A:64028 T:64028 I:31998,32000,32001,32002,32003,32004,32005,32006'
G[32008]='FA K8192 L1 A:0 T:63596 P:J7433 I:31878,31879,31880,31881,31990'	-- NE druid.
G[32009]='FH K8192 L1 A:0,63626 T:63626 I:31882,31883,31884,31885'
G[32010]='FH L35 A:64001 T:64001 P:t4F562999'
G[32011]='FA L65370 A:64032 T:64032 P:t4F562999'
G[32012]='L0'
G[32013]='L90'
G[32014]='L90'
G[32015]='L90'
G[32016]='FA K4 L30 A:64029 T:64029 I:32017 Z17056'	-- an arbitrary date for removal
G[32017]='FH K4 L30 A:63996 T:63996 I:32016 Z17056'	-- an arbitrary date for removal
G[32018]='L15 A:56774 T:56133 I:32019'
G[32019]='L15 A:56782 T:56133 P:1 I:32018'	-- only available before Jade Temple becomes an instance?
G[32020]='SP HW FH K16 L7864576 A:1215873 T:1215873'
G[32021]='SP HW K16 L7864576 A:1215874 T:1215874'
G[32022]='SP HW FH K16 L7864576 A:1215875 T:1215875'
G[32023]='SP HW K16 L7864576 A:1215876 T:1215876'
G[32024]='SP HW K16 L7864576 A:1215877 T:1215877'
G[32026]='SP HW K16 L7864576 A:1215879 T:1215879'
G[32027]='SP HW K16 L7864576 A:1215880 T:1215880'
G[32028]='SP HW FH K16 L7864576 A:1215881 T:1215881 P:31195'
G[32029]='SP HW K16 L7864576 A:1215884 T:1215884'
G[32030]='L30 A:-422 T:65395 P:31026+31085+31354+31398'	-- TODO: Verify requires 31026 31085 31398
G[32031]='SP HW K16 L7864576 A:1215886 T:1215886'
G[32032]='SP HW K16 L7864576 A:1215889 T:1215889'
G[32033]='SP HW FA K16 L7864576 A:1215891 T:1215891'
G[32034]='SP HW K16 L7864576 A:1215892 T:1215892'
G[32035]='L15 A:59585 T:57405'
G[32036]='SP HW K16 L7864576 A:1215894 T:1215894'
G[32037]='SP HW K16 L7864576 A:1215895 T:1215895'
G[32038]='L15 A:58434 T:58434'
G[32039]='SP HW K16 L7864576 A:1215897 T:1215897'
G[32040]='SP HW FH K16 L7864576 A:1215898 T:1215898 P:30515'
G[32041]='SP HW K16 L7864576 A:1215899 T:1215899'
G[32042]='SP HW FA K16 L7864576 A:1215900 T:1215900 P:30514'
G[32043]='SP HW K16 L7864576 A:1215902 T:1215902'
G[32044]='SP HW K16 L7864576 A:1215903 T:1215903'
G[32045]='L15 A:64315 T:64315'
G[32046]='SP HW K16 L7864576 A:1215906 T:1215906'
G[32047]='SP HW FH K16 L7864576 A:1215904 T:1215904'
G[32048]='SP HW K16 L7864576 A:1215905 T:1215905'
G[32049]='SP HW FA K16 L7864576 A:1215907 T:1215907'
G[32050]='SP HW FH K16 L7864576 A:1215908 T:1215908 P:E31769'
G[32051]='SP HW K16 L7864576 A:1215914 T:1215914'
G[32052]='SP HW FA K16 L7864576 A:1215915 T:1215915'
G[32097]='L35'
G[32098]='L90'
G[32099]='L90'
G[32105]='L10'
G[32106]='L7866880 E16139'
G[32107]='L15'
G[32108]='FH L15 A:68072 T:1216274 P:32250 E16139'
G[32109]='FA L15 A:68399,568399 T:1216609 P:32247 E16139'
G[32112]='L1 E16139'
G[32113]='L1 E16139'
G[32114]='L90'
G[32115]='FA K2 L15 A:68275 T:68275 P:32109 I:V0441,32451,V0461,32452,32119,V0511 E16139 D043'
G[32116]='FA K2 L15 A:67631 T:68275 P:32109 I:V0441,32451,V0461,32452,V0511 E16139'
G[32118]='FH K2 L15 A:67847 T:68274 P:32449 E16139'
G[32119]='FA K2 L15 A:68275 T:68275 P:32109 I:V0441,32451,V0461,32452,32115,V0511 E16139 D043'
G[32120]='FH K2 L15 A:68274 T:68274 P:32108 I:V0471,32450,V0481,V0491,V0521 E16139 D050'
G[32121]='FA K2 L15 A:68275 T:68275 P:32109 I:V0441,32451,V0461,32452,V0511 E16139 D043'
G[32122]='FA K2 L15 A:68275 T:68275 P:32109 I:V0441,32451,V0461,32452,V0511 E16139 D043'
G[32123]='FH K2 L15 A:67618 T:67618 P:32108 I:V0471,32450,V0481,V0501,V0521 E16139 D049'
G[32125]='L90 E16139'
G[32126]='FH K2 L15 A:67767 T:67767 P:32108 I:V0471,32450,V0481,V0501,V0521 E16139 D049'
G[32127]='FH K2 L15 A:67767 T:67767 P:32126+32235 E16139'
G[32128]='FH K2 L15 A:67880 T:67880 P:32126+32235 E16139'
G[32129]='FH L15 E16139'
G[32130]='FH K2 L15 A:67402 T:67402 P:32108 I:V0481,V0491,V0501,V0521 E16139 D047'
G[32131]='FH K2 L15 A:67402 T:67402 P:32108 I:V0481,V0491,V0501,V0521 E16139 D047'
G[32132]='FH K2 L15 A:67628 T:67628 P:32108 I:V0481,V0491,V0501,V0521 E16139 D047'
G[32133]='FH K2 L15 A:67628 T:67628 P:32108 I:V0481,V0491,V0501,V0521 E16139 D047'
G[32134]='FH K2 L15 A:67402 T:67402 P:32108 E16139'
G[32135]='FH K2 L15 A:67628 T:67628 P:32108 O:32450 I:V0481,V0491,V0501,V0521 E16139 D047'
G[32136]='FH K2 L15 A:67535 T:67542 P:32108 I:V0471,32450,V0481,V0491,V0501 E16139 D052'
G[32137]='FH K2 L15 A:67542 T:67535 P:32136 E16139'
G[32138]='FH K2 L15 A:67535 T:67534 P:32108 I:V0471,32450,V0491,V0501,V0521 E16139 D048'
G[32139]='FH K2 L15 A:67534 T:67534 P:32138 E16139'
G[32140]='FH K2 L15 A:67535 T:67537 E16139'
G[32141]='FH K2 L15 A:67537 T:67535 E16139'
G[32142]='FA K2 L15 A:67386 T:67386 P:32109 O:32451 I:V0431,32116,V0461,32452,V0511 E16139 D044'
G[32143]='FA K2 L15 A:67976 T:-857 P:32109 I:V0431,32116,V0461,32452,V0511 E16139 D044'
G[32144]='FA K2 L15 A:67444 T:67444 P:32109 I:V0431,32116,V0461,32452,V0511 E16139 D044'
G[32145]='FA K2 L15 A:-418 T:67976 P:32143 E16139'
G[32146]='FA K2 L15 A:67386 T:67386 P:32109 I:V0431,32116,V0461,32452,V0511 E16139 D044'
G[32147]='FA L15 E16139'
G[32148]='FA K2 L15 A:67631 T:67631 P:32109 I:V0431,32116,V0441,32451,V0461,32452 E16139 D051'
G[32149]='FA K2 L15 A:67630 T:67630 P:32109 I:V0431,32116,V0441,32451,V0461,32452 E16139 D051'
G[32150]='FA K2 L15 A:67630 T:67630 P:32109 I:V0431,32116,V0441,32451,V0461,32452 E16139 D051'
G[32151]='FA K2 L15 A:67631 T:67631 P:32109 I:V0431,32116,V0441,32451,V0461,32452 E16139 D051'
G[32152]='FA K2 L15 A:67631 T:67631 P:32109 I:V0431,32116,V0441,32451,V0461,32452 E16139 D051'
G[32153]='FA K2 L15 A:67631 T:67631 P:32109 I:V0431,32116,V0441,32451,V0461,32452 E16139 D051'
G[32154]='FA K2 L15 A:68166 T:68166 P:32109 I:V0431,32116,V0441,32451,V0511 E16139 D046'
G[32155]='L90 E16139'
G[32156]='FA K2 L15 A:67444 T:67444 P:32109 I:V0431,32116,V0441,32451,V0511 E16139 D046'
G[32157]='FA K2 L15 A:67386 T:67386 P:32109 O:32452 I:V0431,32116,V0441,32451,V0511 E16139 D046'
G[32158]='FA K2 L15 A:68182 T:68182 P:32109 I:V0431,32116,V0441,32451,V0511 E16139 D046'
G[32159]='L90 E16139'
G[32161]='FH K2 L15 A:100091819 T:1216161 P:32108 E16139'
G[32162]='FH K2 L15 A:100091821 T:1216162 P:32108 E16139'
G[32163]='FH K2 L15 A:100091822 P:32108 E16139'
G[32164]='FA K2 L15 A:100091854 T:1216161 P:32109 E16139'
G[32165]='FA K2 L15 A:100091855 T:1216162 P:32109 E16139'
G[32166]='FA K2 L15 A:100091856 T:1216163 P:32109 E16139'
G[32167]='FH K2 L15 AK:67555 T:67447 I:32168,32169 E16139'	-- A:-857
G[32168]='FH K2 L15 AK:67556 T:67447 I:32167,32169 E16139'	-- A:-857
G[32169]='FH K2 L15 AK:67557 T:67447 I:32167,32168 E16139'	-- A:-857
G[32170]='FA K2 L15 AK:67555 T:67558 I:32171,32172 E16139'	-- A:-857
G[32171]='FA K2 L15 AK:67556 T:67558 I:32170,32172 E16139'	-- A:-857
G[32172]='FA K2 L15 AK:67557 T:67558 I:32170,32171 E16139'	-- A:-857
G[32173]='L15 E16139'
G[32174]='FA L15 E16139'
G[32175]='K8194 L1 A:67370 T:67370 E16139'
G[32181]='FH K2 L15 A:67503 T:67447 P:32161 E16139'
G[32182]='FH K2 L15 A:67498 T:67447 P:32162 E16139'
G[32183]='FH K2 L15 A:67508 T:67447 P:32163 E16139'
G[32184]='FA K2 L15 A:67436 T:67558 P:32164 E16139'
G[32185]='FA K2 L15 A:67438 T:67558 P:32165 E16139'
G[32186]='FA K2 L15 A:67508 T:67558 P:32166 E16139'
G[32189]='L15 A:58718 T:67565 E16139'	-- only available when Barnaby Fletcher at the market.  How to model?
G[32190]='FH L15 A:67939 T:67581 P:32372+T55F53849 E16139'
G[32191]='FH L15 A:67603 T:67603 P:32190 E16139'
G[32192]='FH L15 A:67581 T:67581 P:32190 E16139'
G[32193]='FA L15 A:67940 T:67682 P:32362+T56057799 E16139'
G[32194]='FA L15 A:67734 T:67734 P:32193 E16139'
G[32195]='FA L15 E16139'
G[32196]='L90 E16139'
G[32197]='FH K2 L15 A:67562 T:67536 P:32108 I:V0471,32450,V0491,V0501,V0521 E16139 D048'	-- TODO: Probably need to merge 048 and 052 because I got all the 052 quests in one day except for 32199.  Instead of 32199 I got 32197 which is marked 048.
G[32198]='SP L15 A:67565 T:67565 P:32189 E16139'
G[32199]='FH K2 L15 A:67562 T:67536 P:32108 I:V0471,32450,V0481,V0491,V0501 E16139 D052'
G[32200]='K2 L32 A:70520 T:70520 P:32259 I:V0921+V0881,V0921+V0641,V0881+V0641 E16408 D053 D087 D062 D066 D070 D078 D084'
G[32201]='FH K2 L32 A:67989 T:67989 P:32259 O:32728 I:V0921+V0871,V0921+V0641,V0871+V0641 E16408 D054 D088 D062 D066 D070 D078 D084'
G[32202]='L90 E16408'
G[32203]='L90 E16408'
G[32204]='FH K2 L32 A:567660 T:567660 P:32259 I:V0871+V0881,V0871+V0641,V0881+V0641 E16408 D058 D092 D062 D066 D070 D078 D084'
G[32205]='L90 E16408'
G[32206]='FH K2 L32 A:567985 T:567985 P:32524 E16408 D076'
G[32207]='FH K2 L32 A:567986 T:567986 P:32523 E16408 D074'
G[32208]='FH K2 L32 A:67986 T:-505 P:32277+W0743,32277+W0763 E16408 D082'
G[32209]='FH K2 L32 A:67986 T:0 P:32277+W0743,32277+W0763 E16408 D082'
G[32210]='L90 E16408'
G[32211]='L90 E16408'
G[32212]='FH L32 A:67990 T:67990 P:>05041 E16408'	-- cleared when 32644 turned in
G[32213]='FH K258 L32 A:67990 T:67990 P:32258 E16408 D068'
G[32214]='FH K2 L15 A:67608 T:67608 P:32108 I:V0471,32450,V0481,V0491,V0501 E16139 D052'
G[32215]='K2 L32 A:569418 T:569418 P:32259 I:V0921+V0881,V0921+V0641,V0881+V0641 E16408 D053 D087 D062 D066 D070 D078 D084'
G[32216]='K2 L32 A:567984 T:567984 P:32259 I:V0921+V0881,V0921+V0641,V0881+V0641 E16408 D053 D087 D062 D066 D070 D078 D084'
G[32217]='K2 L32 A:569418 T:569418 P:32259 I:V0921+V0881,V0921+V0641,V0881+V0641 E16408 D053 D087 D062 D066 D070 D078 D084'
G[32218]='FH K2 L32 A:67983 T:67983 P:32259 I:V0921+V0871,V0921+V0641,V0871+V0641 E16408 D054 D088 D062 D066 D070 D078 D084'
G[32219]='FH K2 L32 A:69389 T:69389 P:32259 I:V0921+V0871,V0921+V0641,V0871+V0641 E16408 D054 D088 D062 D066 D070 D078 D084'
G[32220]='FH K2 L32 A:67983 T:67989 P:32259 I:V0921+V0871,V0921+V0641,V0871+V0641 E16408 D054 D088 D062 D066 D070 D078 D084'
G[32221]='FH K2 L15 A:67608 T:67608 P:32108 I:V0471,32450,V0491,V0501,V0521 E16139 D048'
G[32222]='FH K2 L15 A:1216322 T:67880 P:32108 I:V0471,32450,V0481,V0491,V0501 E16139 D052'
G[32223]='FH K2 L15 A:1216322 T:67880 P:32108 I:V0471,32450,V0491,V0501,V0521 E16139 D048'
G[32224]='FH K2 L32 A:69389 T:69389 P:32259 I:V0921+V0871,V0921+V0641,V0871+V0641 E16408 D054 D088 D062 D066 D070 D078 D084'
G[32225]='FH K2 L32 A:67989 T:67989 P:32259 I:V0921+V0871,V0921+V0641,V0871+V0641 E16408 D054 D088 D062 D066 D070 D078 D084'
G[32226]='FH K2 L32 A:69389 T:69389 P:32259 I:V0921+V0871,V0921+V0641,V0871+V0641 E16408 D054 D088 D062 D066 D070 D078 D084'
G[32227]='K2 L32 A:567984 T:567984 P:32259 I:V0921+V0881,V0921+V0641,V0881+V0641 E16408 D053 D087 D062 D066 D070 D078 D084'
G[32228]='FH K2 L32 A:67673 T:67673 P:32212+32259 I:V0871+V0881,V0871+V0921,V0881+V0921 E16408 D064 D066 D070 D078 D084'
G[32229]='L90 E16408'
G[32230]='FH K2 L32 A:67673 T:67673 P:32212+32259 I:V0871+V0881,V0871+V0921,V0881+V0921 E16408 D064 D066 D070 D078 D084'
G[32231]='FH K2 L90 A:67663 E16408'
G[32232]='FH K2 L32 A:567985 T:567985 P:32524 E16408 D076'
G[32233]='FH K2 L32 A:567985 T:567985 P:32524 E16408 D076'
G[32234]='FH K2 L32 A:67986 T:67986 P:32524 E16408 D076'
G[32235]='FH K2 L15 A:67880 T:67880 P:32108 I:V0471,32450,V0481,V0501,V0521 E16139 D049'
G[32236]='FH K2 L15 A:67554 T:67554 E16139'
G[32237]='FH K2 L15 A:67553 T:67553 P:32108 I:V0471,32450,V0481,V0491,V0501 E16139 D052'
G[32238]='FH K2 L15 A:67533 T:67533 P:32108 I:V0471,32450,V0491,V0501,V0521 E16139 D048'
G[32242]='FH L15 A:67840 T:67834 P:32256 E16139'
G[32243]='FA L15 A:67716 T:67716 P:32193 E16139'
G[32244]='FH L15 A:67603 T:67603 P:32190 E16139'
G[32246]='FA L15 A:64610 T:68311 E16139'
G[32247]='FA L15 A:68392,568399 T:68399,568399 P:32246 E16139'
G[32248]='FA L15 A:67940 T:69026 P:32109 E16139'	-- TODO: This was autoaccepted after hearing their speeches
G[32249]='FH L15 A:64566 T:67812 E16139'
G[32250]='FH L15 A:67867,568072 T:68072,568072 P:32249 E16139'
G[32251]='FH L15 A:-418,67939 T:67414 P:32108 E16139'
G[32252]='K2 L32 A:70520 T:70520 P:32259 I:V0921+V0881,V0921+V0641,V0881+V0641 E16408 D053 D087 D062 D066 D070 D078 D084'
G[32253]='L90 E16408'
G[32254]='FH K2 L32 A:567660 T:567660 P:32259 I:V0871+V0881,V0871+V0641,V0881+V0641 E16408 D058 D092 D062 D066 D070 D078 D084'
G[32255]='FH K2 L32 A:567660 T:567660 P:32259 I:V0871+V0881,V0871+V0641,V0881+V0641 E16408 D058 D092 D062 D066 D070 D078 D084'
G[32256]='FH L15 A:67939 T:67840 P:32108+T55F45949 E16139'
G[32257]='FH L15 A:67834 T:67834 P:32242 E16139'
G[32258]='SP FH K2 L90 A:70561 T:70561 P:32212+=05042,32276+=05043,32277+=05044,32278+=05045,32279+=05046 I:32259 E16408'
G[32259]='SP FH K2 L90 A:70561 T:70561 P:32212+=05042,32276+=05043,32277+=05044,32278+=05045,32279+=05046 I:32258 E16408'
G[32260]='SP FA K2 L90 A:70567 T:70567 P:32644+=05042,32654+=05043,32652+=05044,32655+=05045,32656+=05046 I:32261 E16408'
G[32261]='SP FA K2 L90 A:70567 T:70567 P:32644+=05042,32654+=05043,32652+=05044,32655+=05045,32656+=05046 I:32260 E16408'
G[32262]='FH K258 L32 A:67663 T:67663 P:32258 E16408 D068'
G[32263]='L90 E16408'
G[32264]='FH K258 L32 A:67662 T:67662 P:32258 E16408 D068'
G[32265]='FH K258 L32 A:67662 T:67662 P:32258 E16408 D068'
G[32266]='FH K258 L32 A:67673 T:67673 P:32258 E16408 D068'
G[32267]='L90 E16408'
G[32268]='FH K258 L32 A:67673 T:67673 P:32258 E16408 D068'
G[32269]='FH K258 L32 A:67673 T:67673 P:32258 E16408 D068'
G[32270]='L90 E16408'
G[32271]='L90 E16408'
G[32272]='L90 E16408'
G[32273]='L90 E16408'
G[32274]='FH K2 L32 A:69425 T:69425 P:32259 I:V0871+V0881,V0871+V0641,V0881+V0641 E16408 D058 D092 D062 D066 D070 D078 D084'
G[32275]='K2 L32 A:70520 T:70520 P:32259 I:V0921+V0881,V0921+V0641,V0881+V0641 E16408 D053 D087 D062 D066 D070 D078 D084'
G[32276]='FH L32 A:67990 T:67990 P:32212+>05042 E16408'
G[32277]='FH L32 A:67990 T:69742 P:32276+>05043 E16408'
G[32278]='FH L32 A:570297 T:67990 P:32277+>05044 E16408'
G[32279]='FH L32 A:67990 T:67990 P:32278+>05045 E16408'
G[32280]='L90 E16408'
G[32281]='L90 E16408'
G[32282]='FH K2 L32 A:502081 T:502081 P:32523 E16408 D074'
G[32283]='FH K2 L32 A:567986 T:567986 P:32523 E16408 D074'
G[32284]='FH L15 A:67865 T:67866 P:32242+T55F49899 E16139'
G[32285]='FH K2 L32 A:67662 T:67662 P:32212+32259 I:V0871+V0881,V0871+V0921,V0881+V0921 E16408 D064 D066 D070 D078 D084'
G[32286]='L90 E16408'
G[32287]='FH K2 L32 A:67662 T:67662 P:32212+32259 I:V0871+V0881,V0871+V0921,V0881+V0921 E16408 D064 D066 D070 D078 D084'
G[32288]='FH K258 L32 A:67663 T:67663 P:32258 E16408 D068'
G[32289]='L90 T:72762 E16408'
G[32290]='L90 E16408'
G[32291]='L90 E16408'
G[32292]='FH K2 L32 A:-505 T:70551 P:W0821 E16408'
G[32293]='FH K2 L32 A:67990 P:=09281+W06211,=09282+W06611,=09284+W0786,32278+W0845 E16408 D080 D060'
G[32294]='K2 L90 P:=09283+W0743,=09283+W0763 E16408 D072'	-- TODO: Need to get both pens and terrace location for 67985 to handle this properly
G[32295]='L35 CL A:100092441 T:0 E16139'
G[32296]='L32 A:70316 T:70320 E16408'
G[32297]='FH K2 L32 A:567986 T:567986 P:32523 E16408 D074'
G[32298]='FH K2 L32 A:502081 T:502081 P:32523 E16408 D074'
G[32299]='FH K2 L32 A:69371 T:69371 P:32259 I:V0871+V0881,V0871+V0641,V0881+V0641 E16408 D058 D092 D062 D066 D070 D078 D084'
G[32300]='FH K258 L32 A:67663 T:67663 P:32258 E16408 D068'
G[32301]='FA K258 L32 A:567993 T:567993 P:32261 E16408 D067'
G[32302]='FH K258 L32 A:67673 T:67673 P:32258 E16408 D068'
G[32303]='FH K258 L32 A:67662 T:67662 P:32258 E16408 D068'
G[32304]='FH K258 L32 A:67990 T:67990 P:W0687 E16408'
G[32305]='FH K258 L32 A:67663 T:67663 P:32258 E16408 D068'
G[32306]='L0 E16139'
G[32307]='L35 A:0 TA:5496 TH:3326 P:32295 E16139'
G[32309]='L35 A:3326 T:3326 P:32307 E16139'
G[32310]='fA L35 A:5496 T:5496 P:32307 E16139'
G[32311]='L90 E16139'
G[32312]='L90 E16139'
G[32313]='L90 E16139'
G[32314]='L90 E16139'
G[32315]='FA L15 A:67940 T:67948 P:32194+T56061749 E16139'
G[32316]='FA L15 A:68017 T:68242 P:32315 E16139'
G[32317]='L35 AA:5496 AH:3216 T:0 P:32309,32310 E16139'
G[32318]='L15 A:67866 T:67866 P:32284 E16139'
G[32319]='L15 A:68023 T:68025 P:32318 E16139'
G[32320]='L15 A:68025 T:568025 P:32319 E16139'
G[32321]='FA L15 A:68004 T:68003 P:32355 E16139'
G[32324]='L35 A:0 T:0 E16139'
G[32325]='L35 E16139'
G[32326]='FH L15 A:67939 T:68077 P:32392+T55F77549 E16139'
G[32327]='FH L15 A:68077 T:68077 P:32326 E16139'
G[32328]='FH L15 A:68077 T:67939 P:32327 E16139'
G[32329]='FH L15 A:67939 T:16802 P:32352+T55F65699 E16139'
G[32330]='L15 A:16802 T:68084 P:32329 E16139'
G[32331]='FA L15 A:67940 T:68106 P:32397+T56053849 E16139'	-- Honored + 2850
G[32332]='L15 A:68003 T:68538 P:32321 E16139'
G[32333]='L15 A:68003 T:68538 P:32321 E16139'
G[32334]='L15 A:68003 T:68538 P:32321 E16139'
G[32335]='L15 A:68538 T:568004 P:32332+32333+32334 E16139'
G[32336]='L15 A:68538 T:68544 P:32335+T56081499 E16139'
G[32337]='L15 A:68538 T:68538 P:32335+T56081499 E16139'
G[32338]='L15 A:68538 T:68538 P:32335+T56081499 E16139'
G[32339]='L90 E16139'
G[32340]='L35 E16139'
G[32341]='L90 E16139'
G[32342]='FH K2 L15 A:68274 T:68274 P:32108 I:V0471,32450,V0481,V0491,V0521 E16139 D050'
G[32343]='FH K2 L15 A:68274 T:68274 P:32108 I:V0471,32450,V0481,V0491,V0521 E16139 D050'
G[32344]='FH K2 L15 A:68274 T:68274 P:32108 I:V0471,32450,V0481,V0491,V0521 E16139 D050'
G[32345]='FH K2 L15 A:68274 T:68274 P:32108 I:V0471,32450,V0481,V0491,V0521 E16139 D050'
G[32346]='FA K2 L15 A:68275 T:68275 P:32109 I:V0441,32451,V0461,32452,V0511 E16139 D043'
G[32347]='FA K2 L15 A:68275 T:68275 P:32109 I:V0441,32451,V0461,32452,V0511 E16139 D043'
G[32348]='FH K2 L15 A:68274 T:68274 P:32108 I:V0471,32450,V0481,V0491,V0521 E16139 D050'
G[32351]='FH L15 A:67939 T:68287 P:32378+32379+32384+T55F61749 E16139'
G[32352]='FH L15 A:68287 T:67840 P:32351 E16139'
G[32355]='FA L15 A:67940 T:68004 P:32423+T56077549 E16139'	-- 14542 < x <= 14700 : if this turns out to be 14550, then the 3950 pattern still holds except for the quest before this one...going to set the value at 14550 just in case it is correct
G[32356]='L0 E16139'
G[32357]='L0 E16139'
G[32358]='L35 E16139'
G[32359]='L90 E16139'
G[32360]='L90 E16139'
G[32361]='L0 E16139'
G[32362]='L15 A:68106 T:68106 P:32331 E16139'
G[32363]='FH L15 A:67939 T:68287 P:32330+T55F69649 E16139'
G[32364]='L90 E16139'
G[32365]='L0 E16139'
G[32366]='L90 E16139'
G[32367]='L90 E16139'
G[32368]='FH L15 A:68287 T:68287 P:32448 E16139'
G[32369]='L90 E16139'
G[32370]='FA L15 A:67940 T:68375 P:32316+T56065699 E16139'
G[32371]='FA L15 A:-379,68375 T:68375 P:32377 E16139'
G[32372]='L15 A:568025 T:500087 P:32320 E16139'
G[32373]='FA K4096 L35 A:64616 T:64616 P:31481 E16139 Z19033'	-- this prereq may be bogus.  basically it should be completion of fleet invasion
G[32374]='FA L35 A:64616 T:64616 P:32373 E16139 Z19033'
G[32375]='L90 E16139'
G[32376]='FH L15 A:67939 T:68370 P:32191+32244+T55F57799 E16139'
G[32377]='FA L15 A:68375 T:-379,68375 P:32370 E16139'
G[32378]='FH L15 A:68370 T:68370 P:32376 E16139'
G[32379]='FH L15 A:68370 T:68370 P:32376 E16139'
G[32380]='FA L15 A:67940 T:68526 P:32109+T56045949 E16139'	--	Friendly + 950
G[32381]='FA L15 A:68526 T:68526 P:32380 E16139'
G[32382]='FA L15 A:67940 T:68417 P:32426+T56049899 E16139'	-- Friendly + 4900
G[32383]='FA L15 A:68417 T:68417 P:32382 E16139'
G[32384]='FH L15 A:68370 T:68370 P:32376 E16139'
G[32388]='FA K4096 L35 A:64616 T:64616 P:32474 E16139 Z19033'
G[32389]='FA K4096 L35 A:64616 T:64616 P:32474 E16139 Z19033'
G[32390]='FA K4096 L35 A:64616 T:1216837 P:32388+32389 E16139 Z19033'
G[32391]='FH L15 A:67939 T:68337 P:32368+T55F71661 E16139'
G[32392]='FH L15 A:68337 T:68337 P:32391 E16139'
G[32393]='FA L15 A:67940 T:567734 P:32371+T56069649 E16139'
G[32394]='FA L15 A:567734 T:67951 P:32393 E16139'
G[32395]='L0 E16139'
G[32396]='L10 E16139'
G[32397]='FA L15 A:68417 T:68417 P:32382 E16139'
G[32398]='FH L15 A:67939 T:67844 P:32412+T55F83999 E16139'
G[32399]='FH L15 A:67844 T:68223 P:32398 E16139'
G[32400]='FA L15 A:67940 T:68939 P:T56083999 E16139'
G[32401]='FA L15 A:68939 T:68987 P:32400 E16139'
G[32402]='FH L15 A:67939 T:68586 P:32328+T55F81499 E16139'
G[32403]='FH L15 A:68586 T:68586 P:32402 E16139'
G[32404]='FH L15 A:68586 T:68586 P:32403 E16139'
G[32405]='FH L15 A:68586 T:68586 P:32404 E16139'
G[32406]='FH L15 A:68586 T:68586 P:32405 E16139'
G[32407]='L90 E16139'
G[32408]='FH L15 A:68586 T:68586 P:32406 E16139'
G[32409]='FH L15 A:68586 T:68586 P:32406 E16139'
G[32410]='FH L15 A:68586 T:68586 P:32406 E16139'
G[32411]='FH L15 A:68586 T:68586 P:32408+32409+32410 E16139'
G[32412]='FH L15 A:68586 T:16802 P:32411 E16139'
G[32413]='FH L15 E16139'
G[32414]='FA L15 A:67940 T:68651 P:32394+T56071661 E16139'	-- rep was only 8662 into revered at the time
G[32415]='L90 E16139'
G[32416]='FA L15 A:568651 T:68687 P:32460 E16139'
G[32417]='FA L15 A:68687 T:68687 P:32416 E16139'
G[32418]='FA L15 A:68687 T:68687 P:32416 E16139'
G[32419]='FA L15 A:68687 T:68687 P:32416 E16139'
G[32420]='FA L15 A:68687 T:68687 P:32416 E16139'
G[32421]='FA L15 A:68687 T:68687 P:32416 E16139'
G[32422]='L90 E16139'
G[32423]='FA L15 A:68687 T:68690 P:32417+32418+32419+32420+32421 E16139'
G[32424]='L90 E16139'
G[32425]='L90 E16139'
G[32426]='FA L15 A:68526 T:68531 P:32381 E16139'
G[32427]='FH K4096 L90 A:64616 T:64616 E16139 Z19033'
G[32428]='K8192 L1 AA:64572 AH:64582 TA:64572 TH:64582 P:S119467 E16139'
G[32429]='FH L35 A:64616 T:64616 E16139 Z19033'
G[32430]='FH K4096 L35 A:64616 T:64616 P:32476 E16139 Z19033'
G[32431]='FH K4096 L35 A:64616 T:64616 P:32476 E16139 Z19033'
G[32432]='K4096 L35 A:64616 T:1216837 P:32430+32431 E16139 Z19033'
G[32433]='L90 E16139'
G[32434]='L1 A:68463 T:68463 E16139'
G[32435]='L1 E16139'
G[32436]='L1 E16139'
G[32437]='L0 E16139'
G[32438]='L0 E16139'
G[32439]='L1 A:68462 T:68462 E16139'
G[32440]='L1 A:68464 T:68464 P:0 E16139'	-- TODO: Determine P: for this pet battle quest
G[32441]='L1 A:68465 T:68465 P:0 E16139'	-- TODO: Determine P: for this pet battle quest
G[32442]='L45 CO A:100438 T:100438 E16139'
G[32444]='L1 E16139'
G[32446]='FA K2 L15 A:68166 T:68166 P:32109 I:V0431,32116,V0441,32451,V0511 E16139 D046'
G[32448]='FH L15 A:68287 T:68287 P:32363 E16139'
G[32449]='FH K2 L15 A:67880 T:67847 P:32108 I:V0471,32450,V0481,V0491,V0521 E16139 D050'
G[32450]='FH K2 L15 A:67880 T:67628 P:32108 I:V0481,V0491,V0501,V0521 E16139'
G[32451]='K2 L15 A:68908 T:67386 P:32109 I:V0431,32116,V0461,32452,V0511 E16139'
G[32452]='K2 L15 A:68908 T:67386 P:32109 I:V0431,32116,V0441,32451,V0511 E16139'
G[32455]='FA L15 A:68987 T:69090 P:32401 E16139'
G[32457]='L35 T:69782 E16139'
G[32458]='L15 E16139'
G[32459]='L15 E16139'
G[32460]='FA L15 A:68651 T:568651 P:32414 E16139'
G[32461]='L10 E16139'
G[32467]='L90 E16408'
G[32468]='FH L13 T:127778 E16408'
G[32469]='FA L13 A:16908 T:16908 E16408'
G[32470]='FA L1 A:16908 T:16908 E16408'
G[32471]='FH L1 T:127778 E16408'
G[32472]='L90 E16408'
G[32474]='FA K4096 L90 A:64616 T:64616 P:32373 E16309 Z19033'
G[32475]='L32 E16408'
G[32476]='FH K4096 L90 A:64616 T:64616 P:32427 E16309 Z19033'
G[32477]='L0'
G[32482]='L90 E16408'
G[32485]='FA K258 L32 A:67992 T:67992 P:32261 E16408 D067'
G[32489]='FH K2 L32 A:69371 T:69371 P:32259 I:V0871+V0881,V0871+V0641,V0881+V0641 E16408 D058 D092 D062 D066 D070 D078 D084'
G[32490]='L90 E16408'
G[32491]='FH K2 L32 A:69371 T:69371 P:32259 I:V0871+V0881,V0871+V0641,V0881+V0641 E16408 D058 D092 D062 D066 D070 D078 D084'
G[32492]='L90 E16408'
G[32493]='FH K2 L32 A:67986 T:67986 P:32524 E16408 D076'
G[32494]='FH K2 L32 A:67986 T:67986 P:32524 E16408 D076'
G[32495]='FH K2 L32 A:67989 T:67989 P:32259 I:V0921+V0871,V0921+V0641,V0871+V0641 E16408 D054 D088 D062 D066 D070 D078 D084'
G[32496]='SP HM L7864576 A:1217852 T:1217852 E16408'
G[32497]='SP HM L7864576 A:69522 T:1217845 E16408'
G[32498]='SP HM L7864576 A:69529 T:1217846 E16408'
G[32499]='SP HM L7864576 A:69533 T:1217847 E16408'
G[32500]='SP HM L7864576 A:69535 T:1217848 E16408'
G[32501]='SP HM L7864576 A:69536 T:1217849 E16408'
G[32502]='SP HM L7864576 A:69550 T:1217850 E16408'
G[32503]='SP HM L7864576 A:1217851 T:1217851 E16408'
G[32504]='L10 E16408'
G[32505]='L32 A:1218072 T:1218077 E16408'
G[32506]='FH K2 L32 A:67663 T:67663 P:32212+32259 I:V0871+V0881,V0871+V0921,V0881+V0921 E16408 D064 D066 D070 D078 D084'
G[32507]='FH L32 A:69433 T:69227 E16408'
G[32508]='L90 E16408'
G[32509]='SP HM FH L7864576 A:69551 T:69551 E16408'
G[32510]='SP HM FA L7864576 A:69572 T:69572 E16408'
G[32516]='L90 E16408'
G[32517]='FH K2 L32 A:69389 T:69389 P:32259 I:V0921+V0871,V0921+V0641,V0871+V0641 E16408 D054 D088 D062 D066 D070 D078 D084'
G[32518]='L90 E16408'
G[32519]='L90 E16408'
G[32520]='FH K2 L32 A:67990 T:67990 P:=09281+W06111,=09282+W06511,=09284+W0776,32655+W0835 E16408 D079 D059'
G[32521]='FH K2 L32 A:67660 T:67990 P:=09283+W0743,=09283+W0763,=09284+W0786,32278+W0845 E16408 D080 D072'	-- TODO: Need to get both pens and terrace location for 67985 (and the four other possible questgivers) to handle this properly
G[32522]='FH K2 L32 P:=09283+W0743,=09283+W0763,=09284+W0786,32278+W0845 E16408 D080 D072'	-- TODO: Need to get both pens and terrace location for 67985 (and the four other possible questgivers) to handle this properly
G[32523]='FH K2 L32 P:=05043+W0708,=05044+W0786,32278+W0845 I:32524 E16408'
G[32524]='FH K2 L32 A:70520,567660 T:567985 P:=05043+W0708,=05044+W0786,32278+W0845 I:32523 E16408'
G[32525]='FA K2 L32 AP:69668:X32644;569668:32644 TP:69668:X32644;569668:32644 P:X32644,32644+32260 I:V0891+V0911,V0891+V0631,V0911+V0631 E16408 D056 D090 D061 D065 D069 D077 D083'
G[32526]='FA K2 L32 AP:67997:X32644;567997:32644 TP:67997:X32644;567997:32644 P:X32644,32644+32260 I:V0891+V0911,V0891+V0631,V0911+V0631 E16408 D056 D090 D061 D065 D069 D077 D083'
G[32527]='FA K2 L32 AP:67997:X32644;567997:32644 TP:67997:X32644;567997:32644 P:X32644,32644+32260 O:32731 I:V0891+V0911,V0891+V0631,V0911+V0631 E16408 D056 D090 D061 D065 D069 D077 D083'
G[32528]='FA K2 L32 AP:69668:X32644;569668:32644 TP:69668:X32644;569668:32644 P:X32644,32644+32260 I:V0891+V0911,V0891+V0631,V0911+V0631 E16408 D056 D090 D061 D065 D069 D077 D083'
G[32529]='FA K2 L32 A:69670 T:69670 P:X32644,32644+32260 I:V0891+V0911,V0891+V0631,V0911+V0631 E16408 D056 D090 D061 D065 D069 D077 D083'
G[32530]='FA K2 L32 A:69670 T:69670 P:X32644,32644+32260 I:V0891+V0911,V0891+V0631,V0911+V0631 E16408 D056 D090 D061 D065 D069 D077 D083'
G[32531]='FA K2 L32 A:69670 T:69670 P:X32644,32644+32260 I:V0891+V0911,V0891+V0631,V0911+V0631 E16408 D056 D090 D061 D065 D069 D077 D083'
G[32532]='FA K2 L32 AP:69668:X32644;569668:32644 TP:69668:X32644;569668:32644 P:X32644,32644+32260 I:V0891+V0911,V0891+V0631,V0911+V0631 E16408 D056 D090 D061 D065 D069 D077 D083'
G[32533]='FA K2 L32 AP:69668:X32644;569668:32644 TP:69668:X32644;569668:32644 P:X32644,32644+32260 I:V0891+V0911,V0891+V0631,V0911+V0631 E16408 D056 D090 D061 D065 D069 D077 D083'
G[32534]='L90 T:72762 E16408'
G[32535]='FA K2 L32 AP:67996:X32644;567996:32644 TP:67996:X32644;567996:32644 P:X32644,32644+32260 O:32732 I:V0891+V0901,V0891+V0631,V0901+V0631 E16408 D057 D091 D061 D065 D069 D077 D083'
G[32536]='FA K2 L32 AP:67996:X32644;567996:32644 TP:67996:X32644;567996:32644 P:X32644,32644+32260 I:V0891+V0901,V0891+V0631,V0901+V0631 E16408 D057 D091 D061 D065 D069 D077 D083'
G[32537]='FA K2 L32 AP:67996:X32644;567996:32644 TP:67996:X32644;567996:32644 P:X32644,32644+32260 I:V0891+V0901,V0891+V0631,V0901+V0631 E16408 D057 D091 D061 D065 D069 D077 D083'
G[32538]='K2 L32 AP:69674:X32644;569674:32644 TP:69674:X32644;569674:32644 P:X32644,32644+32260 I:V0901+V0911,V0901+V0631,V0911+V0631 E16408 D055 D089 D061 D065 D069 D077 D083'
G[32539]='K2 L32 AP:69674:X32644;569674:32644 TP:69674:X32644;569674:32644 P:X32644,32644+32260 I:V0901+V0911,V0901+V0631,V0911+V0631 E16408 D055 D089 D061 D065 D069 D077 D083'
G[32540]='K2 L32 AP:70517:X32644;570517:32644 TP:70517:X32644;570517:32644 P:X32644,32644+32260 I:V0901+V0911,V0901+V0631,V0911+V0631 E16408 D055 D089 D061 D065 D069 D077 D083'
G[32541]='K2 L32 AP:69673:X32644;569673:32644 TP:69673:X32644;569673:32644 P:X32644,32644+32260 I:V0901+V0911,V0901+V0631,V0911+V0631 E16408 D055 D089 D061 D065 D069 D077 D083'
G[32542]='K2 L32 A:67992 T:70517 P:X32644,32644+32260 I:V0901+V0911,V0901+V0631,V0911+V0631 E16408 D055 D089 D061 D065 D069 D077 D083'
G[32543]='K2 L32 AP:70517:X32644;570517:32644 TP:70517:X32644;570517:32644 P:X32644,32644+32260 O:32733 I:V0901+V0911,V0901+V0631,V0911+V0631 E16408 D055 D089 D061 D065 D069 D077 D083'
G[32544]='K2 L32 AP:69673:X32644;569673:32644 TP:69673:X32644;569673:32644 P:X32644,32644+32260 I:V0901+V0911,V0901+V0631,V0911+V0631 E16408 D055 D089 D061 D065 D069 D077 D083'
G[32545]='FA K2 L32 AP:69675:X32644;569675:32644 TP:69675:X32644;569675:32644 P:X32644,32644+32260 I:V0891+V0901,V0891+V0631,V0901+V0631 E16408 D057 D091 D061 D065 D069 D077 D083'
G[32546]='FA K2 L32 AP:69677:X32644;569677:32644 TP:69677:X32644;569677:32644 P:X32644,32644+32260 I:V0891+V0901,V0891+V0631,V0901+V0631 E16408 D057 D091 D061 D065 D069 D077 D083'
G[32547]='FA K2 L32 AP:69677:X32644;569677:32644 TP:69677:X32644;569677:32644 P:X32644,32644+32260 I:V0891+V0901,V0891+V0631,V0901+V0631 E16408 D057 D091 D061 D065 D069 D077 D083'
G[32548]='FA K2 L32 AP:69677:X32644;569677:32644 TP:69677:X32644;569677:32644 P:X32644,32644+32260 I:V0891+V0901,V0891+V0631,V0901+V0631 E16408 D057 D091 D061 D065 D069 D077 D083'
G[32549]='FA L32 AP:69678:X32644;569678:32644 T:-504 P:X32644,32644+32260 E16408'	-- T at 45.03,67.89 (at least for early phases)
G[32550]='FA K2 L32 A:67998 T:67998 P:32567 E16408 D073'
G[32551]='FA K2 L32 A:67998 T:67998 P:32567 E16408 D073'
G[32552]='FA K2 L32 A:67999 T:67999 P:32567 E16408 D073'
G[32553]='FA K2 L32 A:67999 T:67999 P:32567 E16408 D073'
G[32554]='FA K2 L32 A:67998 T:67998 P:32567 E16408 D073'
G[32555]='FA K2 L32 A:567999 T:567999 P:32568 E16408 D075'
G[32556]='FA K2 L32 A:567999 T:567999 P:32568 E16408 D075'
G[32557]='FA K2 L32 A:567998 T:567998 P:32568 E16408 D075'
G[32558]='FA K2 L32 A:567999 T:567999 P:32568 E16408 D075'
G[32559]='FA K2 L32 A:567998 T:567998 P:32568 E16408 D075'
G[32560]='FA K2 L32 A:567998 T:567998 P:32568 E16408 D075'
G[32561]='FH K2 L32 P:=09281+W06211,=09282+W06611,=09284+W0786,32278+W0845 E16408 D080 D060'
G[32562]='L32 E16408'
G[32563]='L32 E16408'
G[32564]='FH K2 L5920000 P:=09283+W0743,=09283+W0763 E16408 D072'	-- TODO: Need to get both pens and terrace location for 67985 to handle this properly
G[32565]='FH L32 E16408'
G[32566]='L90 E16408'
G[32567]='FA K2 L32 A:567997,570517,567996,67992 T:67998 P:=05043+W0698,=05044+W0776,32655+W0835 I:32568 E16408'
G[32568]='FA K2 L32 A:567997,570517,567996,67992 T:567998 P:=05043+W0698,=05044+W0776,32655+W0835 I:32567 E16408'
G[32569]='L90 E16408'
G[32570]='L90 E16408'
G[32571]='FA K2 L32 A:67994 T:67994 P:32644+32260 I:V0891+V0901,V0891+V0911,V0901+V0911 E16408 D063 D065 D069 D077 D083'
G[32572]='FA K2 L32 A:567995 T:567995 P:32644+32260 I:V0891+V0901,V0891+V0911,V0901+V0911 E16408 D063 D065 D069 D077 D083'
G[32573]='FA K2 L32 A:567995 T:567995 P:32644+32260 I:V0891+V0901,V0891+V0911,V0901+V0911 E16408 D063 D065 D069 D077 D083'
G[32574]='FA K2 L32 A:567993 T:567993 P:32260+32644 I:V0891+V0901,V0891+V0911,V0901+V0911 E16408 D063 D065 D069 D077 D083'
G[32575]='FA K2 L32 A:567993 T:567993 P:32260+32644 I:V0891+V0901,V0891+V0911,V0901+V0911 E16408 D063 D065 D069 D077 D083'
G[32576]='FA K2 L32 AP:67997:X32644;567997:32644 T:67992 P:32529,32533 E16408'	-- TODO:	Determine proper P: code !!! this is Competing Magic for Alliance definitely
G[32577]='FA K2 L5920000 AP:67998:=09283+32567;567998:=09283+32568;567997:32652;570517:32652;567996:32652;67992:32652 T:67992 P:=09283+W0733,=09283+W0753,=09284+W0776,32655+W0835 E16408 D079 D071'
G[32578]='FA K2 L32 A:67992 T:67992 P:=09281+W06111,=09282+W06511,=09284+W0776,32655+W0835 E16408 D079 D059'
G[32579]='FA K2 L32 AP:67997:X32644;567997:32644 T:67992 P:X32644,32644+32260 E16408'
G[32580]='FA K2 L32 AP:67998:=09283+32567;567998:=09283+32568;567997:32652;570517:32652;567996:32652;67992:32652 T:67992 P:=09283+W0733,=09283+W0753,=09284+W0776,32655+W0835 E16408 D079 D071'
G[32581]='FA K2 L32 AP:67997:X32644;567997:32644 T:67992 P:X32644,32644+32260 E16408'
G[32582]='K2 L32 AP:67998:=09283+32567;567998:=09283+32568 TP:67998:=09283+32567;567998:=09283+32568 P:=09283+W0733,=09283+W0753 E16408 D071'
G[32583]='K2 L90 AP:67998:=09283+32567;567998:=09283+32568 TP:67998:=09283+32567;567998:=09283+32568 P:=09283+W0733,=09283+W0753 E16408 D071'
G[32584]='K2 L32 A:67998 T:67998 P:X32644,32644+32260 E16408'
G[32585]='FA K2 L32 A:67998 T:67998 P:X32644,32644+32260 E16408'
G[32586]='FA K2 L32 AP:67999:32567;567999:32568 T:-928 P:32652+W0733,32652+W0753 E16408 D081'
G[32587]='FA K2 L32 A:-504 T:70552 P:W0811 E16408'
G[32588]='FA K2 L32 AP:67999:32567;567999:32568 T:-928 P:32652+W0733,32652+W0753 E16408 D081'
G[32589]='FH K128 L35 A:67990 T:67990 P:T56C83999 E16408'
G[32590]='K4096 L35 A:64616 T:69782 P:32390,32432 E16446 Z19033'
G[32591]='K4096 L35 A:69782 T:69782 P:32590+32592 E16446 Z19033'	-- TODO: Verify requires 32592
G[32592]='K4096 L35 A:69782 T:69782 P:32390,32432 E16446 Z19033'	-- technically one might have to have accepted 32590 for Wrathion to move
G[32593]='K4096 L35 A:69782 T:70100 P:32591 E16446 Z19033'
G[32594]='K4096 L35 A:70100 T:69782 P:32593 E16446 Z19033'
G[32595]='K4096 L35 A:69782 T:70476 P:32594 E16446 Z19033'
G[32596]='K4096 L35 A:70476 T:69782 P:32595 E16446 Z19033'
G[32597]='K4096 L35 A:69782 T:69782 P:32596 E16446 Z19033'	-- finished Chapter III: Two Princes
G[32598]='L35 E16446 Z19033'
G[32599]='FA K128 L35 A:67992 T:67992 P:T56B83999 E16446'
G[32600]='L30 T:61962 E16446'
G[32601]='L30 T:61962 E16446'
G[32602]='L30 T:61962 E16446'
G[32603]='K8192 L1 AA:64572 AH:64582 TA:64572 TH:64582 P:S119467 E16446'
G[32604]='L1 A:64572 T:64572 E16446'
G[32605]='FH K2 L32 A:567660 T:567660 P:32259 I:V0871+V0881,V0871+V0641,V0881+V0641 E16446 D058 D092 D062 D066 D070 D078 D084'
G[32606]='FA K2 L32 AP:67996:X32644;567996:32644 TP:67996:X32644;567996:32644 P:X32644,32644+32260 I:V0891+V0901,V0891+V0631,V0901+V0631 E16446 D057 D091 D061 D065 D069 D077 D083'
G[32607]='FA K2 L32 A:69413 T:67992 P:32587+32655 E16446 D085'
G[32608]='FA K2 L32 A:69413 T:67992 P:32587+32655 E16446 D085'
G[32609]='L90 T:64337 E16446'
G[32610]='L90 T:64337 E16446'
G[32611]='L90 T:72763 E16446'
G[32613]='SP K1 L35 A:70022 T:70022 E16446'
G[32614]='SP K1 L35 A:70022 T:70022 E16446'
G[32615]='SP K1 L35 A:70022 T:70022 E16446'
G[32616]='SP K1 L35 A:70022 T:70022 E16446'
G[32617]='SP K1 L35 A:70022 T:70022 E16446'
G[32618]='FA L10 XP XL XD A:0 T:4732 P:L020 I:Y891 E16446'
G[32621]='L32 A:100094721 P:PB500 E16467'
G[32622]='L90 E16467'
G[32626]='L90 T:64337 E16467'
G[32627]='FA K258 L32 A:67994 T:67994 P:32261 E16467 D067'
G[32628]='FA K258 L32 A:567995 T:567995 P:32261 E16467 D067'
G[32629]='L90 E16467'
G[32630]='L32 A:100094862 P:PN500 E16467'
G[32631]='FA K258 L32 A:67992 T:67992 P:W0677 E16467'
G[32632]='FA K258 L32 A:67994 T:67994 P:32261 E16467 D067'
G[32633]='FA K258 L32 A:67994 T:67994 P:32261 E16467 D067'
G[32634]='FA K258 L32 A:567995 T:567995 P:32261 E16467 D067'
G[32635]='FA K258 L32 A:67992 T:67992 P:32261 E16467 D067'
G[32636]='FA K258 L32 A:67992 T:67992 P:32261 E16467 D067'
G[32637]='FA K258 L32 A:67992 T:67992 P:32261 E16467 D067'
G[32638]='K258 L32 A:567995 T:567995 P:32261 E16467 D067'
G[32639]='K258 L32 A:567995 T:567995 P:32261 E16467 D067'
G[32640]='FA K512 L32 A:70160 T:70160 E16486'
G[32641]='FH L32 E16486'
G[32642]='FH L15 A:1218750 T:-376 P:FH+32682 E16486'
G[32643]='FH K2 L15 A:-376,1218765 T:1218765 P:32642 E16486'
G[32644]='FA L32 A:70370 T:67992 P:>05041 E16486'
G[32645]='FA L15 A:1218750 T:-376 P:FA+32682 E16486'
G[32646]='FA K2 L15 A:-376,1218765 T:1218765 P:32645 E16486'
G[32647]='L15 A:1218750 T:-376 P:32682 E16486'
G[32648]='K2 L15 A:-376,1218765 T:1218765 P:32647 E16486'
G[32649]='L15 A:1218750 T:-376 P:32682 E16486'
G[32650]='K2 L15 A:-376,1218765 T:1218765 P:32649 E16486'
G[32651]='L90 E16486'
G[32652]='FA L32 A:67992 T:69741 P:32654+>05043 E16486'
G[32653]='L15 A:1218750 T:-376 P:32682 E16486'
G[32654]='FA L32 A:67992 T:67992 P:32644+>05042 E16486'
G[32655]='FA L32 A:70297 T:67992 P:32652+>05044 E16486'
G[32656]='FA L32 A:67992 T:67992 P:32655+>05045 E16486'
G[32657]='K2 L15 A:-376,1218765 T:1218765 P:32653 E16486'
G[32658]='L15 A:1218750 T:-376 P:32682 E16486'
G[32659]='K2 L15 A:-376,1218765 T:1218765 P:32658 E16486'
G[32661]='FA L10 XP XD A:0 P:L020 I:Y891 E16486'
G[32662]='FA L10 XP XL XD A:0 T:4772 P:L020 I:Y891 E16486'
G[32663]='FA L10 XL XD A:0 T:7954 P:L020 I:Y891 E16486'
G[32664]='FA L10 XD A:0 T:4753 P:L020 I:Y891 E16486'
G[32665]='FA L10 A:0 T:70296 P:L020 I:Y891 E16486'
G[32666]='L1 E16486'
G[32667]='FH L10 A:0 T:70301 P:L020 I:Y891 E16486'
G[32668]='FH L10 XP XL XD A:0 T:16280 P:L020 I:Y891 E16486'
G[32669]='FH L10 XL XD A:0 T:4752 P:L020 I:Y891 E16486'
G[32670]='FH L10 XP XD A:0 T:3690 P:L020 I:Y891 E16486'
G[32671]='FH L10 XL XD A:0 T:7953 P:L020 I:Y891 E16486'
G[32672]='FH L10 XL XD A:0 T:4773 P:L020 I:Y891 E16486'
G[32673]='FH L10 XL XD A:0 T:48513 P:L020 I:Y891 E16486'
G[32674]='FH L30 A:0 T:44919 P:PR150+L060 I:J5180'
G[32675]='FA L30 A:0 T:43769 P:L060 I:Y5180'	-- TODO: Technically this was offered to a level 60 without 150 riding, and the I: should probably be Y and not J since account wide is true but the level 60 gets it offered	-- remnoved P:PR150+
G[32676]='FH K2 L32 T:72762 P:32292+32278 E16486 D086'
G[32677]='FH K2 L32 A:69413 T:67990 P:32292+32278 E16486 D086'
G[32678]='FH L32 A:64566 T:70358 I:32679 E16486'
G[32679]='FA L32 A:64610 T:70360 I:32678 E16486'
G[32680]='FH L32 A:70358 T:567990 O:32678 I:32681 E16486'
G[32681]='FA L32 A:70360 T:567992 O:32679 I:32680 E16486'
G[32682]='L15 A:64597 T:64597 P:T4F883999+30574+R114624+i114624 E16486'	-- requires Exalted with Tillers and all plots at farm available
G[32683]='FA L30'
G[32684]='L35 A:64231 T:70398 P:31281 E16486'
G[32685]='L10 A:70398 T:70398 E16486'
G[32686]='L10 A:100095383 T:1218958 P:K100095383+PX525 E16486'
G[32687]='L10 A:100095384 T:1218957 P:K100095384+PX525 E16486'
G[32688]='L10 A:100095385 T:1218956 P:K100095385+PX525 E16486'
G[32689]='L10 A:100095386 T:1218955 P:K100095386+PX525 E16486'
G[32690]='L10 A:100095387 T:1218954 P:K100095387+PX525 E16486'
G[32691]='L10 A:100095388 T:1218953 P:K100095388+PX525 E16486'
G[32692]='L10 A:100095389 T:1218952 P:K100095389+PX525 E16486'
G[32693]='L10 A:100095390 T:1218951 P:K100095390+PX525 E16486'
G[32694]='L90 E16486'
G[32695]='L90 E16486'
G[32696]='L90 E16486'
G[32697]='L90 E16486'
G[32698]='L90 E16486'
G[32699]='L90 E16486'
G[32700]='L90 E16486'
G[32701]='L90 E16486'
G[32702]='L90 E16486'
G[32703]='L90 E16486'
G[32704]='L90 E16486'
G[32705]='L90 E16486'
G[32706]='FA L32 A:70370 T:70160 P:32681 E16486'
G[32707]='L32 A:70160 T:70160 P:32706 E16486'	-- TODO: Determine if it is an O: instead of P:
G[32708]='K512 L32 A:70160 T:70160 P:32707 E16486'
G[32709]='FH L32 A:67990 T:70160 P:32680 E16486'	-- marked complete when 32706 is completed
G[32710]='L35 E16486'
G[32711]='L35 T:-508 E16486'
G[32712]='L35 T:69843 E16486'
G[32713]='L35 E16486'
G[32714]='K4 L35 A:69899 T:-509 E16486'
G[32715]='L35 T:-508 E16486'	-- A: is location of toon at -930:59.32,53.21
G[32716]='L35 E16486'
G[32717]='L23133 E16486'
G[32718]='FH K4 L30 A:63996 T:63996 E16486 Z17227'
G[32719]='FA K4 L30 A:64029 T:64029 E16486 Z17227'
G[32720]='L90 E16503'
G[32721]='FA L32 E16503'
G[32722]='FH L32 T:72762 E16503'
G[32723]='L90 T:72762 E16503'
G[32724]='FA L32 T:72762 E16503'
G[32725]='L1 E16503'
G[32726]='FH L30 E16503'
G[32727]='L90 E16539'
G[32728]='FH L32 A:67673 T:67989 P:32259 I:V0921+V0871,V0921+V0641,V0871+V0641 E16539 D088'
G[32729]='FH K2 L32 A:67990 T:70520 P:32259 I:V0921+V0881,V0921+V0641,V0881+V0641 E16539 D087'	-- this one marked complete when 32733 is
G[32730]='FH L32 A:67663 T:567660 P:32259 I:V0871+V0881,V0871+V0641,V0881+V0641 E16539 D092'
G[32731]='FA K2 L32 AP:67993:X32644;567993:32644 TP:67997:X32644;567997:32644 P:32681+X32644,32260+32644 I:V0911+V0891,V0911+V0631,V0891+V0631 E16539 D090'
G[32732]='FA K2 L32 AP:67995:X32644;567995:32644 TP:67996:X32644;567996:32644 P:32681+X32644,32260+32644 I:V0901+V0891,V0901+V0631,V0891+V0631 E16539 D091'
G[32733]='FA K2 L32 AP:70370:X32644;67992:32644 TP:70517:X32644;570517:32644 P:32681+X32644,32644+32260 I:V0901+V0911,V0901+V0631,V0911+V0631 E16539 D089'
G[32744]='L90 T:73025 E16539'
G[32745]='L90 T:73025 E16539'
G[32746]='L90 T:73025 E16539'
G[32747]='L90 E16539'
G[32748]='L90 E16539'
G[32749]='L90 T:72763 E16539'
G[32750]='L90 E16539'
G[32751]='L90 T:72762 E16539'
G[32752]='L90 T:72841 E16539'
G[32753]='L90 E16539'
G[32754]='L90 T:73293 E16539'
G[32755]='L90 T:73293 E16539'
G[32756]='L90 T:73293 E16539'
G[32758]='L90 E16562'	-- I just checked and this is not used in 16562 as a replacement for 32307 for either faction.  I hope Blizzard does not make use of this quest because Grail handles turning in a quest to different NPCs based on faction without problems, and this is just a waste of space as far as I can tell.
G[32783]='L10 A:70860 T:70909 P:33473 E18546'
G[32784]='L0 E19027'
G[32791]='FH L10 A:70909 T:74000 P:32783 E18546'
G[32792]='L10 A:74000 T:70910 P:32791 E18546'
G[32793]='L0 E19634'
G[32794]='L10 A:70910 T:70941 P:32792+32929 E18546'	-- TODO: Verify requires 32792
G[32795]='FH L10 A:70941 T:570941 P:32794 E18546'
G[32796]='L10 A:570941 T:574163 P:32795 E18546'
G[32797]='L0 E19634'
G[32799]='L0 E18546'
G[32800]='L0 E18546'
G[32801]='L0 E18546'
G[32802]='L0 E18546'
G[32803]='L0 T:93812 E18546'
G[32804]='L10 A:74223 T:74223 P:32792 E18546'	-- TODO: Verify P: correct
G[32805]='K4096 L35 A:69782 T:71352 P:32597 E16758 Z19033'
G[32806]='L30 A:61962 T:61962 E16758'	-- "Blood in the Snow" scenario
G[32807]='L30 A:61962 T:61962 P:32806 E16758'	-- "Dark Heart of Pandaria" scenario
G[32808]='FA L90 A:61962 T:71027 P:32807 E16758'
G[32809]='FA L90 A:71027 T:71027 P:32808 E16758'
G[32810]='L90 A:71027 T:71320 P:32809 E16758 Z17056'	-- an arbitrary date for removal
G[32811]='L90 A:70978 T:70978 P:32871 E16758'
G[32812]='FH L90 A:61962 T:71333 P:32807 E16758 Z17056'	-- an arbitrary date for removal
G[32813]='L0 A:71148 T:71148 P:32819 E16758'
G[32814]='L0 A:71148 T:70978 P:32813 E16758'
G[32815]='L30 A:71150 T:70980 P:32811,32814 E16758'
G[32816]='L30 A:70980 T:570980 P:32815 E16758'
G[32817]='L90 T:90066 E16758'
G[32818]='L90 E16758'
G[32819]='FH L90 A:71148 T:71148 P:32867 E16758'
G[32825]='L90 E16758'
G[32826]='L90 E16758'
G[32827]='L90 E16758'
G[32832]='L90 E16758'
G[32836]='L100 E16758'
G[32837]='L100 E16758'
G[32838]='L100 A:100097979 TA:70752 TH:70751 E16758'
G[32839]='L100 A:70752 T:70752 P:32838 E16758'
G[32840]='L100 E16758'
G[32841]='L100 E16758'
G[32842]='L100 A:63054 T:70752 E16758'
G[32843]='L100 A:70751 E16758'
G[32844]='L100 A:100097982 TA:70752 TH:70751 E16758'
G[32845]='L100 A:70751 E16758'
G[32846]='L100 E16758'
G[32847]='L100 A:70752 E16758'
G[32848]='L100 E16758'
G[32849]='L100 E16758'
G[32850]='L100 A:100097985 TA:70752 TH:70751 E16758'
G[32851]='L100 A:70752 T:70752 P:32850 E16758'
G[32852]='L100 A:100097986 TA:70752 TH:70751 E16758'
G[32853]='L100 A:70752 E18019'
G[32854]='L100 A:54485 T:70752 E16758'
G[32855]='L100 A:70752 E16758'
G[32856]='L100 A:100097988 T:70752 E16758'
G[32857]='L100 A:70752 E16758'
G[32858]='L100 A:71226 T:70752 E16758'
G[32859]='L100 A:70752 T:70752 E16758'
G[32860]='L0 E16758'
G[32861]='L35 A:71352 T:71426 P:0 E16758 Z19033'
G[32862]='FH K4 L90 A:571333 T:571333 P:32814 E16758'
G[32863]='K8196 L1 AA:64572,63596 AH:63626,64582 TA:64572,63596 TH:63626,64582 E16758'	-- Cannot used AP:64572,63596:FA;63626,64582:FH TP:64572,63596:FA;63626,64582:FH because we cannot have more than one NPC id for each qualifier.  If we change the routine that processes this to go through the , separated NPC ids it should work.
G[32864]='L0 E16758'
G[32865]='L0 E16758'
G[32866]='L0 E16758'
G[32867]='L90 A:71333 T:71148 P:32812 E16758'
G[32868]='K24580 L1 AA:64572,63596 AH:64582,63626 TA:64572,63596 TH:64582,63626 E16758'
G[32869]='L1 A:64572 T:64572 E16758'
G[32870]='L35 E16758'
G[32871]='L90 A:71322 T:70978 P:32810 E16758'
G[32872]='FA K4 L90 A:571333 T:571333 P:32811 E16758'
G[32873]='L10 E16790'
G[32874]='L10 E16790'
G[32890]='L1 E16790'
G[32891]='L1 E16790'
G[32892]='L90 A:61962 AZ:390 T:61962 E16790 Z17271'	--	32806 is offered immediately upon turnin, but is available before hand as well -- TODO: Research the rumor that one needs gear good enough to be able to do scenarios to get this quest
G[32893]='L10 E16790'
G[32894]='L10 E16790'
G[32895]='FA K4 L90 A:71336 T:71333 E16837 Z17128'
G[32896]='FH K4 L90 A:71483 T:71333 E16837 Z17128'
G[32897]='L35 E16837'
G[32898]='L10 T:67426 E16837'
G[32899]='L10 E16837'
G[32900]='FA L35 A:64101 T:64101 P:Q480 E16837'
G[32901]='FH L35 A:66998 T:66998 P:Q480 E16837'
G[32910]='L90 E17056'
G[32911]='L0 E18546'
G[32913]='L0 E18546'
G[32914]='L0 E19634'
G[32917]='L0 E18546'
G[32918]='L0 E18546'
G[32919]='L90 E17056'
G[32920]='L0 E18546'
G[32921]='L0 E18546'
G[32922]='L90 E17056'
G[32923]='L90 E17056'
G[32924]='L90 E17056'
G[32929]='L10 A:74222 T:74223 P:32791 E18546'
G[32934]='L0 E18546'
G[32935]='L0 E18546'
G[32936]='L1 E18546'
G[32941]='L0 T:93812 E18546'
G[32942]='FH L15 E17056'
G[32943]='FH L15 E17056'
G[32944]='FA L15 A:1218750 T:-376 P:32682 E17056'
G[32945]='FA L15 A:-376,1218765 T:1218765 P:32944 E17056'
G[32946]='L85 E18546'
G[32949]='L0 E17056'
G[32952]='L0 E17056'
G[32956]='SP K4 L0 A:1220986 T:1220986 E17056'
G[32957]='SP K4 L0 A:1220832 T:1220832 E17056'
G[32958]='SP K4 L0 A:1221036 T:1221036 E17056'
G[32959]='L0 T:71919 E17056'
G[32960]='L0 T:71864 E17056'
G[32961]='L0 T:71823 E17056'
G[32962]='L0 T:73162 E17056'	-- trying to find the lost body
G[32964]='L0 E17056'
G[32965]='L0 E17056'
G[32966]='L0 T:72045 E17056'
G[32967]='L0 T:71143 E17056'
G[32968]='SP K4 L0 A:1220902 T:1220902 E17056'
G[32969]='SP K4 L0 A:1220901 T:1220901 E17056'
G[32970]='L0 T:73703 E17056'	-- me jumping onto the mast?
G[32971]='SP K4 L0 A:1220903 T:1220903 P:32968+32969 E17056'
G[32972]='L0 E17056'
G[32973]='L0 E17056'
G[32974]='L30 A:100102225 T:72751 E17056'
G[32975]='L30 A:72751 T:72754 P:32974 E17056'
G[32976]='L30 A:72754 T:72755 P:32975 E17056'
G[32979]='FH L40 A:74808 T:72230 P:>09761 E18912 D098'
G[32980]='FH L40 A:72230 T:74253 P:32979 E18912'
G[32981]='FH L10 A:79229 T:79229 E18546'
G[32982]='L0 E19533'
G[32983]='FH L40 A:574253 T:500249 P:32980 E18912'
G[32984]='FH L40 A:500249 T:74330 P:32983+33444 E18912'
G[32985]='FH L40 A:74330 T:74330 P:32984 E18912'
G[32989]='FH L10 A:70860 T:72274 P:33473 E18546'
G[32990]='L10 A:72274 T:72274 P:32989 E18546'
G[32991]='L10 A:72274 T:572274 P:32990 E18546'
G[32992]='L10 A:572274 T:500153 P:32991 E18546'
G[32993]='L10 A:500153 T:72373 P:32992 E18546'
G[32994]='L10 A:73097 T:73097 P:33826 E18546'
G[32995]='L23040 E17056'
G[32996]='L23040 E17056'
G[32997]='L0 T:72245 E17056'
G[33000]='L23040 E17056'
G[33001]='L23040 E17056'
G[33002]='L23040 E17056'
G[33003]='L23040 E17056'
G[33007]='L23040 E17056'
G[33008]='L87 E17056'
G[33010]='FH L10 A:574163 T:76720 P:37291,36614 E18663'
G[33011]='L0 E18556'
G[33012]='L0 E18556'
G[33013]='L10 A:74358 T:-525 E18556'	-- no known preqs
G[33014]='L0 E18556'
G[33015]='L0 E18556'
G[33016]='L0 E18556'
G[33017]='L0 T:93812 E18556'
G[33018]='L35 A:1221376 T:72426 P:31467+31471+31474+31476+31477+31480+33231|33232 E17056'
G[33019]='L35 E17056'
G[33020]='L35 A:72426 T:1221413 P:33018 E17056'
G[33021]='L35 A:-429 T:64231 P:33107 E17056'	-- marks 33139 complete as well
G[33022]='L35 A:64231 T:64231 P:33021 E17056'
G[33023]='L35 E17056'
G[33024]='L35 A:64231 T:64231 P:33022 E17056'
G[33025]='L35 E17056'
G[33026]='L35 A:64231 T:64231 P:33024 E17056'
G[33027]='L35 A:64231 T:64231 P:33026 E17056'
G[33028]='L0 E18556'
G[33034]='L0 E18556'
G[33035]='L0 E18556'
G[33036]='L0 E18556'
G[33037]='SP K131072 L0 A:1224783 T:1224783 E18556'
G[33038]='L0 E18556'
G[33039]='L0 E18556'
G[33041]='SP K131072 L0 A:1227134 T:1227134 E18556'
G[33042]='L0 E18556'
G[33043]='L0 E18556'
G[33044]='L0 E18556'
G[33045]='L0 E18556'
G[33046]='SP K131072 L0 A:1232591 T:1232591 E18556'
G[33047]='L90 E17056'
G[33051]='L0 E18546'
G[33052]='L0 E18546'
G[33053]='L0 E18546'
G[33054]='L0 E18546'
G[33055]='L0 T:76561 E18546'
G[33056]='L0 E18546'
G[33057]='L0 E18546'
G[33058]='L0 E18546'
G[33059]='FA L10 A:579043 T:79043 P:33076 E18546'
G[33060]='L0 E18546'
G[33061]='L0 E18546'
G[33062]='FA L10 A:577184 T:577184 O:33359 E18546'	--	TODO: It appears you need the garrison (or something along that line for this to be available)
G[33063]='L0 E18546'
G[33064]='L0 E18546'
G[33065]='L0 E18546'
G[33066]='FA L10 A:77184 T:77417 P:33112 E18546'
G[33067]='L0 E18546'
G[33068]='L0 E18546'
G[33069]='L0 T:90429 E18546'
G[33070]='FA L10 A:80196 T:74043 P:33075 I:33073 E18546'
G[33071]='L1 E21570'
G[33072]='FA L10 A:74043 T:79043 P:34019 E18546'	-- when you meet with Velen for 33072 turnin 34599 completes
G[33073]='L0 I:33070 E18546'
G[33074]='L0 E18546'
G[33075]='FA L10 A:80568 T:75005 P:34692 E18546'
G[33076]='FA L10 A:79043 T:579043 P:33072 E18546'
G[33077]='FA L10 A:71641 T:71641 E18546'
G[33078]='FA L10 A:74121 T:74121 E18546'
G[33079]='L1 T:703997 E18663'
G[33080]='FA L10 A:73425 T:74877 P:33072 E18546'
G[33081]='FA K32 L10 A:74877 T:76067 P:33080 E18546'
G[33082]='FA L10 A:75884 T:575884 P:33586 E18546'
G[33083]='FA L10 A:81176 T:77282 P:34043 E18546'
G[33084]='FA L3276810 A:74233 T:74233 E18546'
G[33085]='L0 E18663'
G[33086]='L0 E18546'
G[33087]='L35 A:71426 T:69782 E17227 Z19033'
G[33088]='L35 A:69782 T:72695 E17227 Z19033'
G[33089]='L1 E17227'
G[33090]='L1 E17227'
G[33091]='L1 E17227'
G[33092]='L1 E17227'
G[33093]='L1 E17227'
G[33094]='L1 E17227'
G[33095]='L1 E17227'
G[33096]='L1 E17227'
G[33097]='L1 E17227'
G[33098]='L35 A:72695 T:72695 E17227 Z19033'
G[33100]='L35 A:72695 T:72695 E17227 Z19033'
G[33104]='L35 A:72695 T:72723 E17227 Z19033'
G[33105]='L35 A:72723 T:73138 E17227 Z19033'
G[33107]='L35 A:1221413 T:-429 P:33020 E17227'
G[33108]='L0 E18546'
G[33109]='L90 E17227'
G[33110]='L90 E17227'
G[33111]='L10 A:1232398 TP:77209:=09711;577209:=09712;500138:=09713 E18546'
G[33112]='FA L10 A:577184 T:577184 P:33115 E18546'
G[33113]='L10 A:72623 T:72623 O:33359 E18546'	--	TODO: It appears you need the garrison (or something along that line for this to be available) (also 33062)
G[33114]='FA L10 A:77417 T:77417 P:33168 E18546'
G[33115]='FA L10 A:577184 T:577184 P:33062 E18546'
G[33116]='FA L10 A:77417 T:577184 P:33114 E18546'
G[33117]='L90 T:71955 E17227'
G[33118]='L90 T:72807 E17227'
G[33119]='L10 A:78222 T:72890 P:33657 E18556'
G[33120]='L10 A:72623 T:72623 P:33113 E18546'
G[33121]='L23040 E17227'
G[33122]='L23040 E17227'
G[33123]='L23040 E17227'
G[33124]='L0 E17227'
G[33125]='FH L10 A:72976 T:72976 E18546'
G[33126]='L0 E19027'
G[33129]='L0 E18546'
G[33130]='L0 E18546'
G[33131]='L0 E18546'
G[33132]='FH L10 A:72976 T:72976 E18546'
G[33133]='FH K4 L30 A:63996 T:63996 E17227'
G[33134]='FA K4 L30 A:64029 T:64029 E17227'
G[33135]='FA L10 E18663'
G[33136]='L35 T:73082 E17227'
G[33137]='K192 L1 A:73082 T:73082 E17227'	-- No preqs known...just get to the island
G[33138]='L35 A:73318 T:73136 E17227'
G[33139]='L35 E17227'	-- marked complete when 33021 is done
G[33145]='FH K32768 L10 A:-110525 T:-525 E18546'
G[33146]='K2 L35 A:64231 T:64231 P:33027 E17227'
G[33147]='L35 A:73335 T:73318 E17227'
G[33148]='L0 E19027'
G[33149]='L0 E18663'
G[33150]='L0 E18546'
G[33151]='L0 E18546'
G[33154]='L0 E18546'
G[33155]='L0 E18546'
G[33156]='FH L30 A:73353 T:72870 O:33232 E17227'
G[33157]='L0 E18546'
G[33158]='L0 E18546'
G[33159]='L0 E18546'
G[33160]='FA L30 A:73348 T:72870 O:33231 E17227'	-- marks 33156 complete as well
G[33161]='L30 A:72870 T:72870 P:33156,33160 E17227'
G[33162]='K4 L0 T:72908 E17227'	-- Cinder death (though it was first of the week for me), another death as well
G[33163]='SP K4 L0 T:73703 E17227'	-- seems to be the first weekly chest you loot.  verified for ghost and spectral so far.
G[33164]='K4 L0 T:71919 E17227'
G[33165]='L0 E18546'
G[33166]='L0 E18546'
G[33167]='L0 E18546'
G[33168]='FA L10 A:77417 T:77417 P:33066 E18546'
G[33170]='SP L0 A:600000 T:600000 E17227'
G[33171]='SP L0 A:600001 T:600001 E17227'
G[33172]='SP L0 A:600002 T:600002 E17227'
G[33173]='SP L0 A:600003 T:600003 E17227'
G[33174]='SP L0 A:600004 T:600004 E17227'
G[33175]='SP L0 A:600005 T:600005 ODC:33216 E17227'
G[33176]='SP L0 A:600006 T:600006 E17227'
G[33177]='SP L0 A:600007 T:600007 E17227'
G[33178]='SP L0 A:600008 T:600008 E17227'
G[33179]='SP L0 A:600009 T:600009 E17227'
G[33180]='SP L0 A:600010 T:600010 E17227'
G[33181]='SP L0 A:600011 T:600011 E17227'
G[33182]='SP L0 A:600012 T:600012 E17227'
G[33183]='SP L0 A:600013 T:600013 E17227'
G[33184]='SP L0 A:600014 T:600014 E17227'
G[33185]='SP L0 A:600015 T:600015 ODC:33217 E17227'
G[33186]='SP L0 A:600016 T:600016 ODC:33218 E17227'
G[33187]='SP L0 A:600017 T:600017 E17227'
G[33188]='SP L0 A:600018 T:600018 E17227'
G[33189]='SP L0 A:600019 T:600019 E17227'
G[33190]='SP L0 A:600020 T:600020 E17227'
G[33191]='SP L0 A:600021 T:600021 E17227'
G[33192]='SP L0 A:600022 T:600022 E17227'
G[33193]='SP L0 A:600023 T:600023 E17227'
G[33194]='SP L0 A:600024 T:600024 ODC:33219 E17227'
G[33195]='SP L0 A:600025 T:600025 E17227'
G[33196]='SP L0 A:600026 T:600026 E17227'
G[33197]='SP L0 A:600027 T:600027 E17227'
G[33198]='SP L0 A:600028 T:600028 E17227'
G[33199]='SP L0 A:600029 T:600029 E17227'
G[33200]='SP L0 A:600030 T:600030 E17227'
G[33201]='SP L0 A:600031 T:600031 E17227'
G[33202]='SP L0 A:600032 T:600032 E17227'
G[33203]='SP L0 A:1221617 T:1221617 E17227'
G[33204]='SP L0 A:600034 T:600034 E17227'
G[33205]='SP L0 A:600035 T:600035 E17227'
G[33206]='SP L0 A:600036 T:600036 ODC:33220 E17227'
G[33207]='SP L0 A:600037 T:600037 E17227'
G[33208]='SP L0 A:600038 T:600038 E17227'
G[33209]='SP L0 A:600039 T:600039 E17227'
G[33210]='SP L0 A:600040 T:600040 E17227'
G[33211]='K2 L30 A:73570 T:73570 E17227'	-- No preqs known...just get to the island
G[33216]='L0 T:72763 E17227'
G[33217]='L0 T:72841 E17227'
G[33218]='L0 T:72807 E17227'
G[33219]='L0 T:72841 E17227'
G[33220]='L0 T:72777 E17227'
G[33221]='L0 T:72875 E17227'
G[33222]='L1 A:73626 T:73626 E17227'
G[33223]='L0 E18546'
G[33224]='L0 E18546'
G[33225]='L90 T:72807 E17227'
G[33226]='L90 T:71955 E17227'	-- killed Niuzao first in the week
G[33227]='SP L0 A:600041 T:600041 E17227'
G[33228]='L30 A:72870 T:72870 P:33156,33160 E17227'
G[33229]='FA L30 A:59894 AZ:390 T:73691 I:33160 E17227'
G[33230]='FH L30 AZ:390 T:73691 E17227'
G[33231]='FA L30 A:73691 T:73348 P:33229 E17227'
G[33232]='FH L30 A:73691 T:73353 P:33230 E17227'
G[33233]='L35 E17227'
G[33234]='SP K1 L30 A:73657 T:73657 P:K100104264 E17227'
G[33235]='SP K1 L30 A:73657 T:73657 P:K100104265 E17227'
G[33236]='SP K1 L30 A:73657 T:73657 P:K100104266 E17227'
G[33238]='SP K1 L30 A:73657 T:73657 P:K100104267 E17227'
G[33239]='SP K1 L30 A:73657 T:73657 P:K100104257 E17227'
G[33248]='FA L35 A:64101 T:61636 E17227'
G[33249]='FH L35 A:66998 T:61636 E17227'
G[33250]='SP K1 L30 A:58564 T:58564 E17227'
G[33252]='L7866880 E17227'
G[33253]='L0 E18546'
G[33255]='FA L10 A:75145 T:72413 P:33837 E18546'
G[33256]='FA L10 A:72413 T:73395 P:33255 E18546'
G[33257]='L0 E1721'
G[33258]='L0 T:72193 E1721'
G[33259]='L0 T:72769 E1721'
G[33260]='L0 T:72908 E1721'	-- first time killed Gu'chi
G[33261]='L0 T:73158 E1721'
G[33263]='FA L10 A:79966 T:73877 P:34820 E18546'
G[33264]='L0 E19027'
G[33265]='L0 E18663'
G[33266]='L0 E18546'
G[33267]='L0 E18546'
G[33268]='L0 E18663'
G[33269]='L10 A:72637 T:72637 P:33112 E18546'
G[33270]='L0 T:73160 E1721'
G[33271]='FA L10 A:73877 T:76748 P:33263 E18546'
G[33272]='L0 T:73161 E1721'
G[33273]='L0 T:73277 E1721'
G[33274]='L0 T:73171 E1721'
G[33275]='L0 T:73282 E1721'
G[33276]='L0 T:72775 E1721'
G[33277]='L0 T:73166 E1721'
G[33278]='L0 T:73163 E1721'
G[33279]='L0 T:72808 E1721'
G[33280]='L0 T:73704 E1721'
G[33281]='L0 T:73169 E1721'
G[33282]='L0 E19342'
G[33283]='L0 T:72771 E1721'
G[33284]='L0 T:73173 E1721'
G[33285]='L0 E1721'
G[33286]='L0 T:73175 E1721'
G[33287]='L0 T:73167 E1721'
G[33288]='L0 T:73666 E1721'
G[33289]='L0 T:73279 E1721'	-- first time killed Evermaw
G[33290]='L0 T:73281 E1721'
G[33291]='L0 T:701747 E1721'
G[33292]='L0 T:0 E1721'
G[33293]='L0 T:72769 E1721'
G[33294]='L0 T:72908 E1721'
G[33295]='L0 T:73158 E1721'
G[33296]='L0 E1721'
G[33297]='L0 T:73161 E1721'
G[33298]='L0 T:73277 E1721'
G[33299]='L0 T:73171 E1721'
G[33300]='L0 T:73282 E1721'
G[33301]='L0 T:72775 E1721'
G[33302]='L0 T:73166 E1721'
G[33303]='L0 T:73163 E1721'
G[33304]='L0 T:72808 E1721'
G[33305]='L0 T:73703 E1721'
G[33306]='L0 T:73169 E1721'
G[33307]='L0 T:73157 E1721'
G[33308]='L0 T:73173 E1721'
G[33309]='L0 T:73172 E1721'
G[33310]='L0 T:73175 E1721'
G[33311]='L0 T:73167 E1721'
G[33312]='L0 T:73666 E1721'
G[33313]='L0 T:73279 E1721'
G[33314]='L0 T:73281 E1721'
G[33315]='L0 T:72809 E1721'
G[33316]='L0 T:72245 E1721'
G[33317]='L0 T:71919 E1721'
G[33318]='L0 T:72045 E1721'
G[33319]='L0 T:72049 E1721'
G[33320]='L0 E18663'
G[33321]='L0 T:73170 E1721'
G[33322]='L0 T:73170 E1721'
G[33323]='L0 E18546'
G[33327]='L0 E18663'
G[33330]='L0 E18546'
G[33331]='FA L10 A:77270 T:-539 P:33263 E18546'
G[33332]='L30 A:72870 T:72870 P:33228 E1721'
G[33333]='L30 A:72870 T:72870 P:33332 E1721'
G[33334]='K516 L30 A:72870 T:72870 P:33333 E1721'
G[33335]='L30 A:72870 T:73303 P:33228 E1721'
G[33336]='L30 A:72870 T:72870 P:33161 E1721'
G[33337]='L30 A:72870 T:72870 P:33338 E1721'
G[33338]='K4 L30 A:72870 T:72870 P:33336 E1721'
G[33340]='L30 A:73303 T:73303 P:33335 E1721'
G[33341]='L30 A:73303 T:73303 P:33340 E1721'
G[33342]='L30 A:73303 T:73303 P:33374 E1721'
G[33343]='L30 A:73303 T:73303 P:33342 E1721'
G[33344]='FH L10 A:75186 T:575177 P:33410 E18546'
G[33345]='L0 E1721'
G[33346]='L0 E1721'
G[33347]='L0 E1721'
G[33348]='L0 T:72762 E1721'	-- trying to find the lost body
G[33349]='L1 E18546'
G[33350]='L1 E18546'
G[33351]='L0 E18663'
G[33352]='L0 E18546'
G[33354]='L90 A:71992 T:14829 E1721'
G[33358]='K2 L35 A:64231 T:64231 P:33027 E1721'
G[33359]='FA L10 A:80645 T:577184 E18546'
G[33360]='L0 E1721'
G[33361]='L0 E1721'
G[33362]='L0 E1721'
G[33363]='L0 E1721'
G[33364]='L0 E1721'
G[33365]='L0 E1721'
G[33366]='L0 E1721'
G[33367]='L0 E1721'
G[33368]='L0 E1721'
G[33369]='L0 E1721'
G[33370]='L0 E1721'
G[33371]='L0 E1721'
G[33372]='L0 E1721'
G[33373]='L0 E1721'
G[33374]='K2 L30 A:73303 T:73303 P:33341 E1721'
G[33375]='L30 A:72870 T:72870 P:33337+33338 E1721'
G[33376]='L30 A:72870 T:72870 P:33375+33338 E1721'
G[33377]='L30 A:72870 T:72870 P:33376+33338 E1721'
G[33378]='L30 A:72870 T:72870 P:33377+33338 E1721'
G[33379]='L30 A:72870 T:72870 P:33378+33338 E1721'
G[33380]='L0 E18716'
G[33381]='L0 E19533'
G[33382]='L0 E18546'
G[33383]='L0 E18546'
G[33384]='SP K131072 L0 A:1223533 T:1223533 E18546'
G[33385]='L0 T:0 E1721'	-- TODO: Determine if this is set when 33338 is turned in.  ensure 33338 is reset each week, otherwise check whether this is to put the proper weekly requirements for the other follow-on quests.  if this needs to be used, must resurrect J codes.
G[33389]='L0 E18546'
G[33395]='L0 E19027'
G[33398]='L1 E18546'
G[33400]='L0 E18546'
G[33401]='L0 E18546'
G[33402]='L0 E18546'
G[33407]='L0 E18716'
G[33408]='FH L10 A:75177 T:75186 P:33546 E18546'
G[33409]='L1 E18546'
G[33410]='FH L10 A:75186 T:75186 P:33408 E18546'
G[33412]='L10 A:81678 T:74635 P:33657 E18556'
G[33416]='L1 E18546'
G[33418]='L0 E18546'
G[33419]='FA L10 A:70902 T:70902 E18546'
G[33422]='L1 E18546'
G[33424]='L1 E18546'
G[33425]='L1 E18546'
G[33427]='L40 A:76622 T:579740 P:32985 E18912'
G[33429]='L1 E18546'
G[33431]='L1 E18546'
G[33432]='L1 E18546'
G[33434]='L1 E18546'
G[33438]='L0 E18546'
G[33439]='L0 E18546'
G[33440]='L0 E18546'
G[33441]='L0 E18546'
G[33442]='L0 E18546'
G[33443]='L0 E18546'
G[33444]='FH L40 A:572230 T:500248 P:32980 E18912'
G[33445]='L0 E18546'
G[33446]='L0 E18546'
G[33447]='L0 E18546'
G[33448]='L0 E18546'
G[33449]='L0 E19634'
G[33450]='L10 A:74635 T:574635 P:33412 E18546'
G[33454]='L10 A:74635 T:574635 P:33412 E18546'
G[33455]='L1 E18546'
G[33456]='L0 E18546'
G[33457]='L0 E18546'
G[33458]='L0 E18546'
G[33461]='FA L10 AP:1230865:=09711;500135:>09711;79966 TP:580159:=09711;80159:>09711 P:33059 E18546'	-- OTC:33267
G[33462]='L10 A:1224306 T:1224305 E18566'
G[33463]='L0 E18546'
G[33464]='L0 E18546'
G[33467]='L10 A:574635 T:81678 P:33450+33454 E18546'
G[33468]='L10 A:70860 T:74651 P:33527 E18556'
G[33469]='L10 A:74651 T:74272 P:33468+33807 E18546'	-- TODO: Verify requires 33807
G[33470]='L10 A:74272 T:74272 P:33469 E18546'
G[33473]='L10 A:74272 T:70860 P:33470 E18546'
G[33483]='L10 A:72890 T:79047 P:33119 E18556'
G[33484]='L10 A:79047 T:78222 P:33483 E18556'
G[33485]='L1 E18546'
G[33492]='L1 E18546'
G[33493]='L10 A:72940 T:574163 P:32994 E18546'
G[33496]='L0 E18546'
G[33497]='L0 E18546'
G[33498]='L0 E18546'
G[33499]='L0 E18546'
G[33500]='L0 T:93812 E18546'
G[33501]='L0 T:93812 E18546'
G[33502]='L0 T:93812 E18546'
G[33504]='L0 T:84460 E18546'
G[33505]='L0 T:93812 E18546'
G[33509]='L0 E18612'
G[33510]='L0 E19027'
G[33511]='L0 T:93812 E18546'	-- Devourer's Gutstone	941:60.91,42.62   after feeding orgres to the Devourer
G[33512]='L0 E18546'
G[33513]='L15 A:74367 T:74888 E18546'	-- TODO: Determine OTC: 27024
G[33514]='L15 A:74367 T:74888 E18546'	-- TODO: Determine OTC: 27009
G[33516]='L0 E18546'
G[33521]='L0 E18612'
G[33522]='L0 E19027'
G[33525]='L0 E18546'
G[33526]='FH L10 A:500152 T:74273 P:33784 E18546'
G[33527]='L10 A:575177 T:75188 P:33344+33622 E18546'
G[33529]='L0 E19027'
G[33530]='L20 N39 A:76790 TA:75119 TH:75121 P:34458,35249 E18546'	-- T:75273
G[33531]='L0 T:93812 E18546'
G[33532]='L0 E18546'
G[33533]='L15 A:73395 T:80978 P:0 I:35556 E18546'	--TODO: Yoshimo: not there for me at max level with almost no quests done
G[33534]='L0 E18546'
G[33536]='L0 E19027'
G[33540]='SP K131072 L0 A:1232587 T:1232587 E18546'
G[33543]='FH L15 A:74594 T:84176 O:35557 E18566'
G[33544]='FH L15 A:84176 T:-543 P:33543 E18566'
G[33545]='L0 E19027'
G[33546]='L10 A:74273 T:75177 P:33526 E18546'	-- removed A:75176
G[33547]='L0 E18612'
G[33548]='FH L15 A:76987 T:74606 P:33543 E18566'
G[33549]='L0 E18546'
G[33550]='L0 T:-539 E18546'
G[33557]='L0 E18546'
G[33560]='L0 E19890'
G[33561]='L1 E18546'
G[33562]='L10 E18546'
G[33563]='FH L15 A:74611 T:574611 P:33543 E18566'
G[33564]='SP K131072 L0 A:1224750 T:1224750 E18546'
G[33565]='SP K131072 L0 A:1224753 T:1224753 E18546'
G[33566]='SP K131072 L0 A:1224754 T:1224754 E18546'
G[33567]='SP K131072 L0 A:1224755 T:1224755 E18546'
G[33568]='SP K131072 L0 A:1232579 T:1232579 E18546'
G[33569]='SP K131072 L0 A:1232583 T:1232583 E18546'
G[33570]='SP K131072 L0 A:1224770 T:1224770 E18546'
G[33571]='L0 E18546'
G[33572]='SP K131072 L0 A:1224781 T:1224781 E18546'
G[33573]='SP K131072 L0 A:1232586 T:1232586 E18546'
G[33574]='SP K131072 L0 A:1224784 T:1224784 E18546'
G[33575]='SP K131072 L0 A:1224785 T:1224785 E18546'
G[33577]='L0 E18546'
G[33578]='L20 A:75311 T:75311 P:34571+34573+34624,34577+34576+34579,34609+34612+34619,34634+34635+34636 E18546'
G[33579]='L20 A:75311 T:75469 P:33578 E18546'
G[33580]='L20 N40 A:75288 T:75288 P:33579 OAC:33645 E18546'	-- is this supposed to be OAC:33645 such that the following two are P:33645 instead of P:33579?
G[33581]='L20 N40 A:75323 T:75323 P:33645 E18546'	-- Yoshimo: can be accepted without 33580 done or in log
G[33582]='L20 N40 A:75324 T:75324 P:33645 E18546'	-- Yoshimo: can be accepted without 33580 done or in log
G[33583]='L0 E19890'
G[33584]='SP K131072 L0 A:1232582 T:1232582 E18546'
G[33586]='FA L10 A:79043 T:75884 P:33059+33081 E18546'
G[33588]='L0 E18546'
G[33592]='L0 E19634'
G[33593]='L15 A:574594 T:574594 P:33548+33544+33563 E18566'
G[33597]='L0 E18546'
G[33602]='L0 E18546'
G[33603]='L0 E18546'
G[33609]='L1 E18546'
G[33610]='SP K131072 L0 A:1225501 T:1225501 E18546'
G[33611]='SP K131072 L0 A:1225502 T:1225502 E18546'
G[33612]='SP K131072 L0 A:1225503 T:1225503 E18546'
G[33613]='SP K131072 L0 A:1224228 T:1224228 E18546'
G[33614]='SP K131072 L0 A:1232588 T:1232588 E18546'
G[33622]='L10 A:75186 T:575177 P:33410 E18546'
G[33633]='L15 N54 A:75593 T:75593 E18546'
G[33634]='L0 E18546'
G[33635]='L1 E18546'
G[33637]='L0 E19890'
G[33638]='L0 E18612'
G[33640]='L0 E18546'
G[33641]='L0 E18546'
G[33642]='L0 E18546'
G[33643]='L0 E18546'
G[33644]='L1 E18546'
G[33645]='L0 T:77750 E18546'
G[33649]='L0 E18546'
G[33656]='L0 E18612'
G[33657]='L10 A:75188 T:70860 P:33527 E18546'
G[33658]='L0 E18612'
G[33659]='L0 E18612'
G[33660]='FH L15 A:1234474 T:82225 P:33662,33663 E18546'
G[33661]='FH L15 A:82222 T:82225 P:33662,33663 E18546'
G[33662]='FH L15 A:85089 T:82222 P:33689+33685+35149 E18546'	--I:36438
G[33663]='FH L15 A:85089 T:82222 P:33689+33685+34992 E18546'
G[33664]='L0 E18546'
G[33685]='FH L15 A:81731 T:85089 P:33694 E18546'
G[33686]='L0 E18612'
G[33689]='FH L15 A:81731 T:85089 P:34992 E18546'
G[33693]='L0 E18546'
G[33694]='FH L15 A:82732 T:81731 P:35151 E18546'	-- TODO: Does this require Lumber Mill choice?
G[33695]='FH L15 A:82225 T:82302 P:33661 E18546'
G[33706]='FH L15 A:82302 T:82302 P:33695 E18546'
G[33707]='L1 T:91473 E21570'
G[33709]='L0 E19634'
G[33713]='L0 E18546'
G[33720]='FH L20 A:500164 T:75924 P:33754 I:34091 E18546'
G[33721]='FH L20 A:75873 T:75924 E18546'
G[33722]='FH L20 A:75806 T:75958 P:33754 E18546'
G[33724]='FH L20 A:75924 T:75941 P:33720+33721 E18546'	-- I:34094
G[33725]='L0 E19634'
G[33726]='L0 E18612'
G[33727]='L20 E18612'
G[33728]='FH L20 A:75941 T:75941 P:33724+33736+34950 E18546'	-- TODO: Verify requires 34950 ,I:34096
G[33729]='FH L20 A:75941 T:75942 P:33728 E18546'
G[33730]='FH L20 A:75942 T:75959 P:33729 E18546'
G[33731]='FH L20 A:75805 T:79604 P:34962 E18546'
G[33732]='L20 E18612'
G[33733]='L0 E18612'
G[33734]='L20 A:75896 T:75913 P:34571+34573+34624,34609+34612+34619,34576+34577+34579 E18546'
G[33735]='FH L20 A:575808 T:75808 E18546'
G[33736]='FH L20 A:75808 T:500165 P:33735 E18546'
G[33737]='L0 E18612'
G[33740]='L20 A:75896 T:75913 P:34571+34573+34624,34609+34612+34619,34576+34577+34579 O:34685,36843 E18546'
G[33746]='L0 E18546'
G[33748]='L0 E18546'
G[33749]='L0 E18546'
G[33750]='L0 E18546'
G[33753]='L0 E19634'
G[33754]='FH L20 A:75806 T:75806 P:34683 E18546'
G[33755]='L1 E18546'
G[33756]='K1 L1 A:74056 T:74056 P:37910 E19658'
G[33761]='L20 A:1225778 T:75913 P:34571+34573+34624,34577+34576+34579,34609+34612+34619,34634+34635+34636 E18546'
G[33765]='FA L10 A:75005 T:74043 P:33075 E18546'
G[33766]='L0 E18546'
G[33767]='L0 E19027'
G[33772]='L0 E18546'
G[33781]='L0 E18546'
G[33782]='FA L10 E18546'
G[33783]='L0 E18612'
G[33784]='L10 A:76557 T:76240 P:34380 E18546'
G[33785]='L10 A:73097 T:73097 P:32993 E18546'
G[33786]='FA L3276810 A:76200 T:76204 O:35459,35444,35450 E18546'
G[33787]='FA L3276810 A:76204 T:76204 O:33786 E18546'
G[33788]='FA L3276810 A:76204 T:76204 P:33787+33808 E18546'
G[33789]='L0 E18663'
G[33793]='FA L3276810 A:81176 T:77282 P:34043 E18546'
G[33794]='FA L3276810 A:81176 T:73395 P:34043 E18546'
G[33795]='FA L3276810 A:81173 T:77282 P:34043 E18546'
G[33800]='L0 E18546'
G[33807]='FH L10 A:79415 T:74651 P:33527 E18546'	-- TODO: P:33527 is wrong
G[33808]='FA L10 A:76204 T:76204 E18546'
G[33813]='FA L10 A:71502 T:71502 P:B33070 E18546'
G[33814]='FA L10 A:81152,581152,500220 T:78564 P:33059 E18546'	-- technically this can be P:33151 as long as 33059 has OTC:33151
G[33815]='FH L10 A:576411 T:78272 P:33868 I:34582 E18546'
G[33816]='FH L10 A:80456 T:80456,76616 P:E34379 E18546'
G[33817]='L0 E18546'
G[33820]='L0 E18546'
G[33822]='L0 E18546'
G[33823]='L0 E18546'
G[33824]='L0 E18546'
G[33825]='L0 E18546'
G[33826]='L10 A:73097 T:73097 P:32993 E18546'
G[33828]='L10 A:72940 T:72940 P:33826 E18546'
G[33829]='L0 E19533'
G[33833]='FA K512 L10 A:1237016 T:76447 E18546'	-- A:1226702 removed
G[33834]='FA K512 L10 A:1237021 T:81292 E18546'	-- A:1226702 removed
G[33836]='FA K512 L10 A:1232405 T:82227 E18546'
G[33837]='FA L10 A:77282 T:573395 P:34054+33083+33793+33795+33794 E18546'	-- TODO: Verify requires 33083 33793
G[33838]='FH L10 A:74977 T:74977 P:36793 U179 E18612'
G[33839]='L0 E18546'
G[33840]='L0 E18546'
G[33843]='L0 T:93812 E18546'
G[33844]='L0 E18546'
G[33846]='L0 E18546'
G[33847]='L0 E18546'
G[33866]='SP K131072 L0 A:1232589 T:1232589 E18546'
G[33867]='SP K131072 L0 A:1226831 T:1226831 E18546'
G[33868]='FH L10 A:78563 T:576411 P:34446 E18546'
G[33869]='L0 T:75422 E18546'
G[33871]='FA L20 A:79724 T:76665 I:34721 E18546'
G[33872]='L20 A:76665 T:76665 O:33871,34721 E18546'
G[33873]='L20 A:76665 T:76665 E18546'
G[33874]='L20 A:76665 T:76665 P:33872+33873 E18546'
G[33875]='L0 E18612'
G[33877]='L0 E18612'
G[33878]='L0 E18612'
G[33879]='L0 E19027'
G[33880]='L0 E18612'
G[33881]='L0 E19027'
G[33882]='L20 A:76826 T:76826 E18546'	-- FA at least
G[33883]='L0 T:74373 E18546'
G[33884]='L20 A:76826 T:76826 E18546'	-- FA at least
G[33885]='SP K131072 L0 A:1226865 T:1226865 E18546'
G[33886]='SP K131072 L0 A:1226861 T:1226861 E18546'
G[33887]='L0 E18546'
G[33888]='L0 E18546'
G[33889]='L0 E18546'
G[33890]='L0 E18546'
G[33891]='SP K131072 L0 A:1226862 T:1226862 E18546'
G[33898]='L10 A:76662 T:76662 P:33657 E18556'
G[33899]='L0 E18546'
G[33900]='L0 E18546'
G[33901]='L0 E18546'
G[33903]='L0 E18546'
G[33904]='L0 E18663'
G[33905]='FA L10 A:74343 T:74043 P:33075 E18546'
G[33906]='L1 E18546'
G[33907]='L0 E18612'
G[33908]='L0 E19027'
G[33909]='L0 E18546'
G[33910]='L0 E18546'
G[33911]='L0 E19890'
G[33913]='L0 E19027'
G[33914]='L0 E19342'
G[33915]='FH L10 A:76862 T:76862 P:1 E18546'	-- I thought it was P:33470, but was wrong
G[33916]='L0 T:93812 E18546'
G[33917]='L20 A:78482 T:78482 P:34971,34981,34711,34712 I:33923 E18546'
G[33918]='FH K512 L10 A:-160525 T:78487 P:L091+1 E18546'
G[33919]='FH K514 L10 A:1226961 T:76746 P:33527 E18546'
G[33920]='L20 N39 A:78519 T:78519 P:34971,34981,34711,34712 E18546'
G[33921]='L0 E18546'
G[33923]='L0 I:33917 E19342'
G[33924]='L0 E18546'
G[33925]='L0 E18546'
G[33926]='L0 T:93812 E18546'
G[33927]='L0 T:75815 E18546'	-- got completed automatically when I saw draeneis blown up (saw a questgiver among them)
G[33928]='L35 A:100113080 T:80593 P:B34894 E18612'
G[33929]='FH L10 A:76889 T:76889 P:33955 E18546'
G[33930]='L0 E18546'
G[33931]='SP L20 A:76904 T:76904 E18546'	-- also completed when 33927 was, reward is Deceptia's Smoldering Boots
G[33933]='L0 T:-535 E18546'
G[33938]='L0 E18546'
G[33940]='L0 T:93812 E18546'
G[33942]='L0 T:93812 E18546'
G[33943]='L0 E18546'
G[33944]='L20 A:1226987 T:76826 E18546'	-- TODO: Determine whether you need to be on quests from Caleb to get this : no you dont :) (no known prequests)
G[33945]='L0 E18546'
G[33946]='L0 T:93812 E18546'
G[33947]='L0 T:90286 E18546'
G[33948]='L0 T:93812 E18546'
G[33949]='L0 E18546'
G[33950]='L0 E19890'
G[33951]='L0 E19750'
G[33952]='L0 E18546'
G[33954]='L0 E19027'
G[33955]='L10 A:76941 T:76889 P:1 E18546'	-- I thought it was P:33470, but was wrong
G[33956]='L0 E19027'
G[33957]='L10 E18546'
G[33958]='FA L20 N39 A:75256 T:75256 P:34452 I:33970 E18546'
G[33959]='L0 E19027'
G[33960]='L0 E18546'
G[33961]='L0 E18546'
G[33962]='L0 E18546'
G[33963]='L0 E18546'
G[33964]='L0 E18612'
G[33965]='L0 E18546'
G[33966]='L0 E18546'
G[33967]='FA L20 N40 A:78028 T:78028 P:34452 I:33971 E18546'
G[33968]='L0 E18612'
G[33969]='FA L20 N39 A:78102 T:78102 P:34452 I:33972 E18546'
G[33970]='FH L20 A:575256 T:575256 P:34451 I:33958 E18546'
G[33971]='FH L20 A:578028 T:578028 P:34451 I:33967 E18546'
G[33972]='FH L20 A:75249 T:75249 P:34451 I:33969 E18546'
G[33973]='L20 A:77031 T:77031 E18546'	-- OTC:33974, which does not seem to exist
G[33974]='L24159 T:75753'
G[33975]='L0 E18612'
G[33976]='L20 N40 A:77082 T:77082 P:34508 E18546'
G[33977]='L0 E18546'
G[33978]='L0 E18546'
G[33979]='L0 E18612'
G[33980]='L0 E18612'
G[33981]='L0 E18546'
G[33982]='L0 E18546'
G[33987]='L0 E18546'
G[33988]='L20 N40 A:1227069 T:-535 P:34240,34242 E18546'
G[33989]='L0 E18546'
G[33990]='L0 E18546'
G[33991]='L0 E18546'
G[33995]='L0 E18546'
G[33996]='L0 E18546'
G[33997]='L0 E18546'
G[33998]='L0 E18546'
G[34004]='L0 E18546'
G[34006]='L0 E19027'
G[34008]='L0 E19027'
G[34012]='L15 A:75008 T:75008 P:35064,35149 E18566'
G[34013]='L20 N40 A:78083 T:78083 P:34240,34242 E18546'
G[34014]='L0 E19750'
G[34015]='L0 E19750'
G[34016]='L0 E19750'
G[34019]='FA L10 A:74043 T:574043 P:33070+33765+33905 E18546'
G[34024]='L0 E18663'
G[34025]='L0 E18546'
G[34026]='FA L40 A:500138 T:77217 P:>09711 E18702 D093'
G[34027]='FA L40 A:77217 T:77217 P:34026 E18702'
G[34028]='FA L40 A:77217 T:577160 P:34027 E18612'
G[34029]='FA L40 A:577160 T:77160 P:34028 E18738'
G[34030]='FA L40 A:77160 T:577161 P:34029 E18738'
G[34031]='FA L40 A:77167 T:77167 P:34030 E18738'
G[34032]='FA L40 A:77167 T:77167 P:34031+34048 E18738'	-- TODO: Verify requires 34031
G[34033]='FA L40 A:77167 T:77161 P:34032 E18738'
G[34034]='FH L40 A:578487 T:77928 P:>09761 E18612 D098'
G[34035]='FH L40 A:77928 T:577928 P:34034 E18764'
G[34039]='FH L40 A:578323 T:78323 P:34042 E18764'
G[34040]='FH L40 A:577928 T:78323 P:34035 E18764'
G[34041]='FH L40 A:577928 T:78323 P:34035 E18764'
G[34042]='FH L40 A:78323 T:578323 P:34040 E18764'
G[34043]='FA L10 A:575884 T:577282 P:33082 E18546'
G[34047]='L0 E18546'
G[34048]='FA L40 A:77167 T:77167 P:34030 E18738'
G[34053]='L0 E18546'
G[34054]='FA L10 A:-539 T:73395 P:35032 E18546'
G[34055]='L0 E18546'
G[34059]='L0 E18546'
G[34060]='L0 E18546'
G[34061]='L0 E18546'
G[34062]='L0 E18546'
G[34063]='L10 E19027'
G[34064]='L0 E18546'
G[34066]='FH L10 A:77210 T:577210 E18566'	-- no known preqs
G[34067]='FH L10 A:100109121 T:577210 I:34264 E18546'	-- TODO: Deal with the fact that this can be picked up before 77210 moves to become 577210, and one can turn it in to 77210 as well.  he moves when you accept 34066
G[34068]='L0 E18546'
G[34069]='FH L10 A:1227504 T:577210 P:O34066 I:34093 E18566'
G[34070]='FH L10 A:577210 T:577210 P:34067+34069,34093 E18566'	-- TODO: Yoshimo: not entirely correct but i couldnt find a sample for an (a+b) OR (c+b) that works
G[34071]='L0 E19342'
G[34072]='FH L10 A:577210 T:577210 P:34067+34069 E18566'
G[34073]='FH L10 A:577210 T:500131 P:34072 E18566'
G[34074]='L0 E18546'
G[34075]='FH L10 A:500131 T:500131 P:34073+34102 E18546'
G[34076]='FA K32768 L10 A:-130539 T:-539 ODC:33086,33165,33166,33167 E18546'
G[34077]='L0 E18663'
G[34078]='FH L40 A:78323 T:500229 P:34039 E18764'
G[34079]='L23132 E19596'
G[34080]='L0 E18546'
G[34083]='L1 E19027'
G[34084]='L0 E18546'
G[34087]='FA L20 A:575803 T:575803 P:36801 E18546'	-- removed P:34874,34875
G[34088]='FA L20 A:575803 T:575803 P:34087 E18546'
G[34089]='FA L20 A:575804 T:575804 P:34087 E18546'
G[34090]='FA L20 A:575874 T:575874 P:34087 E18546'
G[34091]='FA L20 A:1225726 T:575874 P:34087 E18546'	-- ? I:34803 ;I:33720
G[34092]='L20 N40 A:77799 T:77799 P:34326 E18546'
G[34093]='FH L10 I:34069 E18546'	-- removed A:577210 T:577210 because I cannot seem to get this at all
G[34094]='FA L20 A:575874 T:575874 P:34090+34091 E18546'	--I:33724
G[34095]='FA L20 A:575804 T:575804 P:34089 E18546'
G[34096]='FA L20 A:575874 T:575874 P:34094+34095+34959 E18546'	--I:33728
G[34097]='FA L20 A:575874 T:75942 P:34096 I:33729 E18546'
G[34098]='FA L20 A:75942 T:575803 P:34097 E18546'
G[34099]='FA L20 A:75805 T:79608 P:34963 E18546'
G[34100]='L0 E19750'
G[34101]='L0 T:76668 E18546'
G[34102]='FH L10 A:1227806 T:500131 P:34070+34072 E18546'
G[34103]='FA K512 L20 N46 A:80854 T:80854 P:34571+34573+34624,34609+34612+34619 I:34108 E18546'	-- see comment in 34683, TODO: Yoshimo verify 34609 34612 34619
G[34104]='FA K512 L20 N40 A:80854 T:80854 P:34571+34573+34624,34609+34612+34619 I:34107 E18546'	-- see comment in 34683, TODO: Yoshimo verify 34609 34612 34619
G[34105]='FA K512 L20 N46 A:80854 T:80854 P:34571+34573+34624,34609+34612+34619 I:34106 E18546'	-- see comment in 34683, TODO: Yoshimo verify 34609 34612 34619
G[34106]='FH K512 L20 A:80833 T:80833 P:34576+34577+34579,34634+34635+34636 I:34105 E18546'	-- see comment in 34683 , TODO: Yoshimo: verify 34634 34635 34636
G[34107]='FH K512 L20 A:80833 T:80833 P:34576+34577+34579,34634+34635+34636 I:34104 E18546'	-- see comment in 34683 , TODO: Yoshimo: verify 34634 34635 34636
G[34108]='FH K512 L20 A:80833 T:80833 P:34576+34577+34579,34634+34635+34636 I:34103 E18546'	-- see comment in 34683 , TODO: Yoshimo: verify 34634 34635 34636
G[34110]='L0 T:76947 E18546'
G[34111]='L0 T:77973 E18546'
G[34112]='L0 T:77441 E18546'
G[34113]='L0 T:76969 E18546'
G[34114]='L0 T:76969 E18546'
G[34115]='L0 E18546'
G[34116]='L0 E18546'
G[34117]='L0 T:78271 E18546'
G[34118]='L0 T:77973 E18546'
G[34119]='L0 E18546'
G[34120]='L0 E19890'
G[34121]='L0 E19027'
G[34122]='FH L20 A:75389 T:75389 P:34326 I:35227 E18546'
G[34123]='L10 A:76720 T:76487 P:33010 E18702'
G[34124]='L10 A:76487 T:76484 P:34123 E18702'
G[34127]='L0 E18546'
G[34128]='L0 E18546'
G[34129]='L0 T:84460 E18546'
G[34130]='L0 T:78151 E18546'
G[34131]='L0 T:93812 E18546'
G[34132]='L0 T:93812 E18546'
G[34133]='L0 E18546'
G[34134]='L0 T:86682 E18546'
G[34135]='L0 E18546'
G[34140]='L0 E18546'
G[34141]='L0 E19027'
G[34142]='L0 T:77561 E18546'
G[34143]='L0 E18546'
G[34144]='FH L20 N54 A:75389 T:77580 P:34092 I:35254 E18546'
G[34145]='L0 T:77614 E18546'
G[34146]='L0 E18546'
G[34147]='L0 E18546'
G[34148]='L0 E18546'
G[34149]='L0 E18546'
G[34150]='L0 E18546'
G[34151]='L0 E18546'
G[34152]='L0 E18546'
G[34153]='L0 E18546'
G[34154]='FA L20 N41 A:77582 T:79434 P:34157 I:34564 E18546'	-- ODC:34570
G[34155]='L0 E18546'
G[34157]='L20 N40 A:75392 T:77582 P:34092 E18546'
G[34158]='L0 E19027'
G[34159]='L0 E19769'
G[34160]='L0 E18546'
G[34162]='L0 E18546'
G[34163]='L20 N40 A:1227737 T:-535 P:34092+35227|34122 E18546'	-- TODO: Verify requires 35227|34122
G[34164]='L20 N40 A:77629 T:77629 P:34092+35227 E18546'	-- TODO: Verify requires 35227
G[34165]='L0 E18546'
G[34167]='L0 E18546'
G[34168]='L0 E18546'
G[34170]='L0 E18546'
G[34171]='L0 T:77634 E18546'
G[34172]='L0 E18546'
G[34173]='L0 E18546'
G[34174]='SP K131072 L0 A:1227743 T:1227743 E18546'
G[34175]='L0 E18546'
G[34176]='L0 E18546'
G[34177]='L0 E18546'
G[34178]='L0 E18546'
G[34179]='L0 E18546'
G[34180]='L0 E18546'
G[34181]='L0 E19027'
G[34182]='SP L0 A:1227793 T:1227793 P:34184 E18546'
G[34183]='L0 E18546'
G[34184]='L0 T:-535 E18546'
G[34185]='L0 E18546'
G[34189]='L0 E18546'
G[34191]='L0 E18546'
G[34192]='FA L15 A:77730 T:77730 P:>05811 I:35154 E18546'
G[34193]='L30 A:81981 T:81981 P:>05871 I:36404 E18546'
G[34194]='L20 A:77733 T:84372 P:PF001 I:34758 E18546'
G[34195]='L0 E18546'
G[34196]='L0 T:77741 E18546'
G[34197]='L0 E18546'
G[34198]='L0 E18546'
G[34199]='L0 T:77750 E18546'
G[34200]='L0 E18546'
G[34201]='L0 E18546'
G[34204]='L0 T:77776 E18546'
G[34205]='L0 T:77776 E18546'
G[34206]='L0 E18546'
G[34207]='L0 E18546'
G[34208]='SP K65536 L0 A:77784 T:77784 E18546'
G[34209]='FH L10 A:79252 T:72814 E18546'
G[34210]='L0 E18546'
G[34211]='L0 E18546'
G[34212]='L0 E18546'
G[34213]='FA L40 E18612'
G[34214]='L0 E18546'
G[34215]='L0 E18546'
G[34216]='FH L10 A:72814 T:72837 P:34209 E18546'
G[34217]='L40 E18612'
G[34218]='L0 E18546'
G[34219]='L0 E18546'
G[34220]='L0 E18546'
G[34221]='L0 E18546'
G[34222]='L0 E18546'
G[34223]='L0 E18546'
G[34224]='L0 E18546'
G[34225]='L0 E18546'
G[34227]='FH L10 A:72837 T:72874 P:34216 E18546'
G[34228]='L10 A:72836 T:72837 P:34216 E18546'
G[34229]='L10 A:72837 T:72837 P:34228 E18546'
G[34230]='FH L10 A:72874 T:72874 P:34227+34228 E18546'	-- TODO: Verify requires 34228
G[34231]='L0 E18546'
G[34232]='SP K131072 L0 A:1227951 T:1227951 E18546'
G[34233]='SP K131072 L0 A:1227953 T:1227953 E18546'
G[34234]='L20 N40 A:78082 T:78082 P:34240,34242 E18546'
G[34235]='SP K131072 L0 A:1227954 T:1227954 E18546'
G[34236]='SP K131072 L0 A:1227955 T:1227955 E18546'
G[34237]='L0 E19750'
G[34238]='SP K131072 L0 A:1227956 T:1227956 E18546'
G[34239]='SP K131072 L0 A:1227996 T:1227996 E18546'
G[34240]='FA L20 N40 A:75250 T:77869 P:33958+33967+33969 I:34242 E18546'	-- TODO: Verify requires 33958
G[34241]='L0 T:77870 E18546'
G[34242]='FH L20 A:75246 T:77869 P:33970+33971+33972 I:34240 E18546'
G[34243]='L0 E18546'
G[34244]='L40 E18612'
G[34248]='SP K131072 L0 A:1228012 T:1228012 E18546'
G[34249]='SP K131072 L0 A:1228013 T:1228013 E18546'
G[34250]='SP K131072 L0 A:1228014 T:1228014 E18546'
G[34251]='SP K131072 L0 A:1228015 T:1228015 E18546'
G[34252]='SP K131072 L0 A:1228016 T:1228016 E18546'
G[34253]='SP K131072 L0 A:1228017 T:1228017 E18546'
G[34254]='SP K131072 L0 A:1228018 T:1228018 E18546'
G[34255]='SP K131072 L0 A:1228019 T:1228019 E18546'
G[34256]='SP K131072 L0 A:1228020 T:1228020 E18546'
G[34257]='SP K131072 L0 A:1228021 T:1228021 E18546'
G[34258]='SP K131072 L0 A:1228022 T:1228022 E18546'
G[34259]='SP K131072 L0 A:1228023 T:1228023 E18546'
G[34260]='SP K131072 L0 A:1228024 T:1228024 E18546'	-- ? FA for sure...what is 34262?
G[34261]='SP K131072 L0 A:1228025 T:1228025 E18546'
G[34262]='L0 E18546'
G[34263]='SP K131072 L0 A:1228026 T:1228026 E18546'
G[34264]='FH L10 A:77210 T:577210 P:34096+34066 I:34067 E18566'
G[34267]='L0 E18612'
G[34268]='L0 E18546'
G[34269]='L0 E18546'
G[34271]='FH L35 N54 A:81953 T:80595 P:35144+35145 I:35395 E18612'
G[34276]='SP K131072 L0 A:1228483 T:1228483 E18546'	-- Also 34760 was turned in when 34276 was turned in
G[34277]='L10 A:72836 T:72836 P:34227+34228 E18546'	-- TODO: Verify requires 34228
G[34278]='L10 A:72837 T:72837 P:34227+34228 E18546'	-- TODO: Verify requires 34228
G[34279]='L15 T:78030 E18546'
G[34280]='FH L10 A:72874 T:72874 P:34230+34277+34278+34229 E18546'	-- TODO: Verify requires 34277 34278 34229
G[34281]='FA L40 A:78056 T:78056 P:34284 E18912'
G[34282]='L0 E18612'
G[34283]='L0 E18612'
G[34284]='FA L40 A:81492 T:78056 P:>09711 E18850 D093'
G[34285]='FA L40 A:78056 T:78056 P:34281 E18912'
G[34286]='FA L40 A:78185 T:78239 P:34285 E18912'
G[34287]='FA L40 A:78428 T:78428 P:34362 E18912'
G[34288]='FA L40 A:78428 T:78428 P:34362 E18912'
G[34289]='FA L40 A:78428 T:78810 P:34287+34288 E18912'	-- TODO: Verify requires 34287
G[34290]='L0 T:78061 E18546'	-- the stash is located in cave at 946:53.98,27.70
G[34291]='FH L10 A:72874 T:73480 P:34280 E18546'
G[34292]='L10 A:72836 T:72836 P:34280 E18546'
G[34293]='L10 E18645'
G[34294]='FH L10 A:73480 T:573480 P:34291 E18546'
G[34295]='FH L10 A:573480 T:72874 P:34294 E18546'
G[34299]='L0 E18612'
G[34304]='L0 E18612'
G[34307]='L0 E18612'
G[34308]='L0 E18612'
G[34309]='FH L40 A:578487,78985 T:78659 P:>09761 E18912 D098'
G[34311]='L0 E18546'
G[34312]='L0 T:101700 E18546'
G[34313]='L0 T:101700 E18546'
G[34314]='FH L40 A:78659 T:78659 P:34309 E18912'
G[34315]='FH L40 A:78659 T:78659 P:34314 E18912'
G[34316]='FH L40 A:78659 T:78785 P:34315 E18912'
G[34317]='L0 E18612'
G[34318]='FH L40 A:78428 T:78428 P:34381 E18912'
G[34319]='FH L40 A:78428 T:78821 P:34318+34469 E18912'
G[34321]='L40 A:77998 T:77998 E18612'	-- available to FA when on the Garrison campaign
G[34325]='L40 A:77998 T:77998 P:34321 E18612'
G[34326]='L20 N40 A:77082 T:77799 P:33976 E18546'
G[34327]='K32768 L0 E18546'
G[34328]='L0 E18546'
G[34329]='L0 E18546'
G[34330]='L0 E18546'
G[34331]='L0 E18546'
G[34332]='L0 E18546'
G[34333]='L0 E18546'
G[34335]='FH L40 A:78192 T:78187 P:35842 E18764 D098'
G[34336]='L40 A:78187 T:78187 P:34409,34335 E18738'
G[34337]='L40 A:78187 T:78251 P:34347+34336 E18738'
G[34338]='L40 A:78251 T:78251 P:34337 E18738'
G[34339]='L40 A:89179 T:89179 P:34337 E18738'
G[34340]='L40 A:74125 T:74125 P:34337 E18738'
G[34341]='FH L40 A:78251 T:579740 P:34338+34339+34340 E18764'	-- completes Heart of the Breakers, the Warlord's Council
G[34343]='K32768 L0 E18546'
G[34344]='L10 A:78208 T:78208 O:34736 E18566'	-- no known preqs
G[34345]='FH L10 A:78208 T:78208 E18566'	-- no known preqs
G[34346]='FH L10 A:78209 T:78209 E18566'	-- no known preqs
G[34347]='L40 A:1237821 T:78187 P:34409,34335 E18738'
G[34348]='FH L10 A:78208 T:78208 P:34344+34345+34346 E18566'
G[34351]='L20 N39 A:577737 T:78520 P:34458,35249 E18546'
G[34352]='L40 A:83494 T:-539 P:35861,35876 E18612'
G[34353]='L40 A:77982 T:77982 P:35861,35876 E18612'
G[34354]='L40 A:77982 T:77982 P:35876 I:35861,35876 E18612'	-- Nimhfree did not get this one
G[34355]='L40 A:77982 T:78258 P:34353 E18612'
G[34359]='L0 E18546'
G[34360]='L1 E18612'
G[34361]='L0 E18546'
G[34362]='FA L40 A:78239 T:78470 P:34286 E18912'
G[34364]='FH L10 A:70859 T:578466 P:34402 I:34583 E18546'
G[34365]='L40 A:78258 T:78258 P:34355 E18612'
G[34375]='FH L10 A:578466 T:578466 P:34364 E18546'
G[34376]='L0 E18988'
G[34377]='L0 E18988'
G[34378]='FH L10 A:578466 T:78466 P:34765 E18546'
G[34379]='FH L10 A:76411 T:570860 P:34775 E18546'
G[34380]='L10 A:570860 T:76557 P:34379 E18546'
G[34381]='FH L40 A:78785 T:78792 P:34316 E18912'
G[34382]='L0 E18546'
G[34392]='L10 A:-577 T:78558 P:35933 ODC:35253,35983 E18546'
G[34393]='L10 A:78558 T:78558 P:34392 E18546'
G[34397]='L40 A:78258 T:78258 P:34355 E18612'
G[34398]='L10 A:1,1206111 T:78558 I:36881 ODC:37187 E18546'	-- TODO: If you abandon this, you get offered 36881
G[34399]='L20 N41 A:78534 T:78538 E18546'	-- if you have 34709 in your log 34399 does not appear until you turn it in.
G[34400]='L20 N41 A:78534 T:78534 E18546'
G[34401]='FH L20 A:78515 T:78515 P:34399 E18546'
G[34402]='FH L10 A:78272 T:70859 P:33815 E18546'
G[34403]='FA L20 N41 A:78513 T:78513 P:34399 E18546'
G[34404]='FH L20 A:78515 T:78515 P:34399 E18546'
G[34405]='L0 E18612'
G[34406]='FA L20 N41 A:78513 T:78513 P:34399 E18546'
G[34407]='FA L20 N39 A:75119 T:75119 P:34981 I:34418 E18546'
G[34409]='FA L40 A:88112 T:78187 P:35841 E18738'
G[34410]='FA L40 A:78251 T:88112 P:34338+34339+34340 E18738'	-- TODO: Verify requires 34338 34340
G[34411]='L0 E18546'
G[34412]='L0 E18546'
G[34413]='L15 E18546'
G[34414]='FH L20 A:78515 T:78515 P:34401+34404 E18546'
G[34415]='FA L20 N42 A:78513 T:78513 P:34403+34406 E18546'
G[34418]='FH L20 A:75121 T:75121 P:34971,34981,34711,34712 O:34696 I:34407 E18546'
G[34420]='L10 A:78558 T:78559 P:34393 E18546'
G[34421]='FH L10 A:78573 T:578559 P:34420 I:35240 E18546'
G[34422]='L10 A:78559 T:578559 P:34420 ODC:35297 E18546'
G[34423]='L10 A:578559 T:78560 P:34422+35240+35242,34421+34422+35241 ODC:34817 E18546'
G[34424]='L0 E19533'
G[34425]='L10 A:78560 T:578560 P:34423 E18546'
G[34426]='L0 E19342'
G[34427]='FH L10 A:578560 T:578996 P:34425 E18546'
G[34428]='L0 E19342'
G[34429]='L10 A:578560 T:78561 P:34478,34427 E18546'
G[34431]='FA L10 A:79661 T:579537 P:34429 I:34737 E18546'
G[34432]='FA L10 A:578554 T:79316 P:34429 I:34739 E18546'
G[34433]='L0 E19342'
G[34434]='FA K32 L10 A:78994 T:578994 P:34431 I:34740 ODC:34435 E18546'	-- becomes available once entering the area and completing "Ankova the Fallen slain" part of 34431
G[34435]='L0 E19342'
G[34436]='FA L10 A:579537 T:78562 P:34431+34432+34434 I:34741 E18546'
G[34437]='L10 A:79917 T:78996 P:34925 E18546'
G[34438]='L0 E19342'
G[34439]='L10 A:78430 T:78996 P:35019,35005 E18546'
G[34440]='L0 E18546'
G[34441]='L0 E19342'
G[34442]='L10 A:78996 T:79917 P:34439 ODC:34440 E18546'
G[34445]='L10 A:80521 T:80521 P:35747 E18546'
G[34446]='FH L10 A:80521 T:78563 P:34445 E18546'
G[34447]='FH L20 A:78515 T:78538 P:34414 E18546'
G[34448]='FA L20 N42 A:78513 T:78538 P:34415 E18546'
G[34449]='L0 E18663'
G[34450]='L40 A:78258 T:78937 P:34397+34365 E18612'	-- technically it is A:78882 but they are both the same.
G[34451]='FH L20 A:75121 T:75246 P:33917+33920+34418+33530+34351+0 I:34452 E18546'	-- TODO: Verify requires 33920 34418 33530 34351, maybe more of the quests around
G[34452]='FA L20 N39 A:75119 T:75250 P:33530+34351+33920+33917 I:34451 E18546'	-- TODO: Verify requires 33530 33917
G[34453]='L0 E18546'
G[34454]='L0 E18612'
G[34455]='L40 A:1229314 T:-539 P:34355 E18612'
G[34456]='L0 E18546'
G[34457]='K32768 L0 E18612'
G[34458]='FA L20 N39 A:81789 T:577737 P:34701 I:35249 E18546'
G[34459]='L0 E19027'
G[34461]='FH L10 A:78466 T:500151 P:34822+34823+34824 I:34587 E18546'	-- TODO: Verify requires 34822
G[34462]='FH L10 A:79740 T:79740 P:34461+36793 I:34646 U34 E18546'
G[34463]='L40 A:1229330 T:86949 E18546'
G[34464]='L40 A:1229333 T:86949 E18546'
G[34465]='L40 A:1229331 T:86949 E18546'
G[34466]='L40 A:1229344 T:86949 P:0 E18546'
G[34469]='FH L40 A:78428 T:78428 P:34381 E18912'
G[34470]='L0 T:93812 E18546'	-- killing Pale Fish Monger 78606 in cave 941:28.29,66.62
G[34471]='SP K131072 L0 A:1229354 T:1229354 E18546'
G[34472]='L40 A:86949 T:77853 P:34463+34464+34465+34466 E18546'
G[34473]='L0 T:93812 E18546'
G[34474]='L0 E18612'
G[34475]='L0 E18663'
G[34476]='L0 T:93812 E18546'	-- kill all the Frozen Fury near the Frozen Treasure and reveal the Frozen Orc 941:57.16,52.14
G[34477]='L0 T:87538 E18546'
G[34478]='FA L10 A:578560 T:79537 P:34425 E18546'
G[34483]='L0 E18546'
G[34496]='FA K32768 L10 A:-120539 T:-539 E18546'
G[34497]='L0 E18546'
G[34498]='L0 T:78872 E18546'
G[34499]='K32768 L0 E18546'
G[34500]='K32768 L0 E18546'
G[34501]='FH K32768 L10 A:-120525 T:-525 E18546'
G[34502]='K32768 L0 E18546'
G[34503]='L0 T:77434 E18546'
G[34504]='FA K32768 L10 A:-100539 T:-539 E18546'	-- TODO:	Determine how to detect this being removed from log when leaving area before doing anything for it
G[34505]='FH K32768 L10 A:-100525 T:-525 E18546'
G[34506]='K32768 L0 E18546'
G[34507]='L0 T:93812 E18546'
G[34508]='L20 N40 A:77869 T:77082 P:34240,34242 E18546'
G[34509]='L0 E19342'
G[34510]='L0 E18546'
G[34511]='L0 E18546'
G[34512]='L35 N54 A:79310 T:79310 P:0 E18612'
G[34513]='L35 N46 A:79188 T:79310 P:0 E18612'
G[34514]='L35 N54 A:79312 T:79310 P:34598 E18612'
G[34515]='L35 N54 A:79312 T:79310 P:34598 E18612'
G[34516]='L35 N54 A:79899 T:79897 P:0 E18612'
G[34517]='L0 T:101700 E18546'
G[34518]='L0 E18546'
G[34519]='L0 T:101700 E18546'
G[34520]='L0 T:93812 E18546'
G[34521]='L0 T:93812 E18546'
G[34522]='L0 T:101700 E18546'
G[34523]='L0 T:79125 E18546'
G[34524]='L40 E18612'
G[34525]='L40 E18612'
G[34526]='L40 E18612'
G[34527]='L40 E18612'
G[34528]='L40 E18612'
G[34529]='L40 E18612'
G[34530]='L40 E18612'
G[34531]='L40 E18612'
G[34532]='L0 E18612'
G[34533]='L40 E18612'
G[34534]='L40 E18612'
G[34535]='L40 E18612'
G[34536]='L40 E18612'
G[34537]='L40 E18612'
G[34538]='L40 E18612'
G[34539]='L40 E18612'
G[34540]='L40 E18612'
G[34541]='L40 E18612'
G[34542]='L40 E18612'
G[34543]='L40 E18612'
G[34544]='L40 E18612'
G[34545]='L40 E18612'
G[34546]='L40 E18612'
G[34547]='L40 E18612'
G[34548]='L40 E18612'
G[34549]='L40 E18612'
G[34550]='L40 E18612'
G[34551]='L40 E18612'
G[34552]='L40 E18612'
G[34553]='L40 E18612'
G[34554]='L40 E18612'
G[34555]='L40 E18612'
G[34556]='L40 E18612'
G[34557]='L0 E18546'	-- Frostfire Ridge treasure map
G[34558]='FA L20 A:79133 T:79133 O:34676 I:34566 E18546'	-- Changed P: to O: (and made it FA) because toon has this available without even having a garrison in Shadowmoon Valley
G[34559]='L0 E18546'
G[34560]='L0 T:1230665 I:34561 E18546'
G[34561]='L0 T:1230665 I:34560 E18546'
G[34562]='L0 E18546'
G[34563]='FA L20 A:79133 T:79159 P:34558+34560+X34561 E18546'	-- TODO: Verify requires 34560 X34561 -- Yoshimo asks if P:37301,37304 is a better solution
G[34564]='FH L20 N54 A:77582 T:79434 P:34157+36793 I:34154+34570 U205 E18546'
G[34565]='L0 I:34884 E19027'
G[34566]='FH L20 A:79176 T:79176 O:36953 I:34558 E18546'	-- changed P:36953 to O: because Horde boosted to 100 has this available immediately.
G[34567]='L0 E18546'	-- automatically completed when Horde chose Made Tower in Talador
G[34568]='L0 T:79627 E18546'	-- automatically completed when Horde chose Arsenal in Talador
G[34569]='FH L20 A:79176 T:79210 P:34566+34568+X34567 I:34563 E18546'
G[34570]='L0 T:79544 I:34564 E19342'
G[34571]='FA L20 A:79329 T:79329 P:35045 I:34577 E18546'
G[34572]='L35 N45 A:79282 T:81144 P:35148 E18612'	-- removed  I:35155
G[34573]='FA L20 A:79329 T:79329 P:35045 I:34576 E18546'
G[34574]='L0 T:79190 E18546'
G[34575]='FA L10 N46 A:-577 T:79206 P:35884 ODC:36079 E18546'	-- if you abandon this, not sure you can get it back
G[34576]='FH L20 A:79356 T:79356 P:35102 I:34573 E18546'
G[34577]='FH L20 A:79356 T:79356 P:35102 I:34571 E18546'
G[34578]='FA L20 A:79329 T:80627 P:34571+34573+34624 I:34837 E18546'
G[34579]='FH L20 A:79356 T:79356 P:35102 I:34624 E18546'
G[34580]='L0 E18546'
G[34581]='L0 E18546'
G[34582]='FA L10 A:79206 T:79470 O:34575 I:33815 E18546'	-- probably this not available until 34575 turned in or abandoned.  Note that A:79635 is also possible.  Must recheck this without dropping, and with dropping.
G[34583]='FA L10 N57 A:79470 T:79243 P:34582 I:34364 E18546'
G[34584]='FA L10 A:79243 T:79243 P:34583 E18546'
G[34585]='FA L10 A:79567 T:79567 P:34584+34616 I:34765 E18546'
G[34586]='L10 A:79243 T:77209 P:34585 E18546'
G[34587]='L10 A:77209 T:79457 P:35166+35174+35176 I:34461 E18546'	-- TODO: Verify requires 35166
G[34588]='L0 E19533'
G[34589]='L0 E18546'
G[34591]='L0 E18546'
G[34592]='FH L10 A:578466 T:578466 P:34364 I:34616 E18546'
G[34593]='FA L35 N45 A:79282 T:81144 P:35148 I:35157 E18612'	-- I: confirmed by WoW-API
G[34596]='FA L35 N45 A:81144 T:79576 P:34593 I:35158 E18612'	-- I: confirmed by WoW-API
G[34597]='FA L35 N45 A:1231901 T:81144 P:35148 I:35156 E18612'
G[34598]='L35 N54 A:79310 T:79312 P:0 E18612'
G[34599]='L0 E18546'
G[34600]='L0 E18546'
G[34601]='L0 E19890'
G[34602]='L0 E18546'
G[34609]='FA L20 A:79392 T:80260 P:34815 I:34634 E18546'
G[34610]='L0 E21463'
G[34612]='FA L20 A:79392 T:80260 P:34815 I:34635 E18546'
G[34616]='FA L10 A:79243 T:79243 P:34583 I:34592 E18546'
G[34617]='L0 E18546'
G[34619]='FA L20 A:79392 T:80260 P:34815 I:34636 E18546'
G[34622]='L0 E18546'
G[34623]='L0 E19027'
G[34624]='FA L20 A:79329 T:79329 P:35045 I:34579 E18546'
G[34631]='FA L20 A:79133 T:80142 P:34558+34561+X34560 I:34632 E18546'
G[34632]='FH L20 A:79176 T:80142 P:34566+34567+X34568 I:34631 E18546'
G[34633]='L0 E18612'
G[34634]='FH L20 A:79393 T:80193 P:34814 I:34609 E18546'
G[34635]='FH L20 A:79393 T:80193 P:34814 I:34612 E18546'
G[34636]='FH L20 A:79393 T:80193 P:34814 I:34619 E18546'
G[34637]='L0 E18546'
G[34639]='K32768 L20 A:75311 T:79432 E18546'
G[34640]='L0 E18612'
G[34641]='L0 T:93812 E18546'
G[34642]='L0 T:93812 E18546'
G[34645]='L0 E18546'
G[34646]='L10 A:79457 T:81948 P:34587+36797 I:34462 U34 E18546'
G[34647]='L0 T:93812 E18546'
G[34648]='L0 T:93812 E18546'
G[34649]='L0 E18546'
G[34650]='L0 E19634'
G[34651]='L0 E18546'
G[34652]='L0 E18546'
G[34653]='L30 AA:81492 AH:578487 T:79539 P:35554,35537 I:36951 E18546'
G[34654]='L0 E18546'
G[34655]='L30 N40 A:79539 T:79519 O:34653 E18612'
G[34656]='L30 N40 A:79519 T:79519 P:34655 E18612'
G[34657]='L30 N40 A:79519 T:79519 P:34655 E18612'
G[34658]='L30 N40 A:79519 T:579519 P:34657+34656 E18612'
G[34659]='L30 N40 A:579519 T:79890 P:34658 E18612'
G[34660]='K32768 L20 A:87125 T:79544 E18546'
G[34661]='L0 E19342'
G[34662]='L35 N45 A:79188 T:79188 P:34899,34769 O:35922,35921 E18612'
G[34663]='L35 N45 A:79188 T:79188 P:34662 E18612'
G[34664]='L35 N45 A:79188 T:79188 P:34663 E18612'
G[34665]='L35 N45 A:79188 T:79188 P:34664 E18612'
G[34666]='L35 N46 A:79188 T:79188 P:34665 E18612'
G[34667]='K32768 L20 A:-130535 T:-535 E18546'
G[34668]='L0 E18546'
G[34670]='L0 E18988'
G[34671]='L0 E18546'
G[34672]='fA L10 A:75606 T:75606,575606 E18546'
G[34673]='L10 A:74009 T:74009,574009 E18546'
G[34674]='FA L35 A:1232400 T:79263 E18612'	-- TODO: Verify only FA
G[34675]='FA L35 N45 A:79263 T:79576 P:34674 E18612'	--I:34795
G[34676]='FA L20 A:81492 T:79133 O:36495 I:37183 E18546'
G[34677]='L24159 E18612'
G[34678]='FA L35 N45 A:79576 T:79674 P:34675 E18612'
G[34679]='L0 T:79674 E18546'
G[34680]='L0 T:1230741 E18546'
G[34681]='FH L20 A:78487 T:79176 P:36573,36574 O:36494 E18546'
G[34682]='FA L35 N45 A:79674 T:79722 P:34678 E18612'
G[34683]='FH L20 A:79627 T:75806 P:34576+34577+34579,34634+34635+34636 I:36801 E18546'	-- removed P:34874 because boosted to 100 Horde gets this after completing these three (picked Armory) TODO: Yoshimo: verify 34634 34635 34636
G[34684]='L0 E18612'
G[34685]='L20 AA:79573 AH:579573 T:75896 P:FA+34711,FH+34712,FH+34971,FA+34981 ODC:36843 E18546'
G[34686]='L0 E19890'
G[34688]='L0 E19027'
G[34690]='L0 E18663'
G[34691]='L24159 E19634'
G[34692]='L10 A:79953 T:79953 P:34646 I:34775 E18546'
G[34693]='L0 E18612'
G[34694]='L0 E18612'
G[34696]='FH L20 A:79612 T:75121 P:34712,34971 I:34701 E18546'
G[34697]='FH L15 A:76688 T:79320 P:35151+35149 I:34992 E18566'
G[34698]='L15 A:79320 T:79320 P:34704,34697 E18566'
G[34699]='L15 A:79322 T:77014 P:34704,34697 E18566'
G[34700]='L15 A:79320 T:79320 P:34704,34697 E18566'
G[34701]='FA L20 N39 A:79618 T:75119 P:34711,34981 I:34696 E18546'
G[34702]='L15 A:79331 T:79331 P:34704,34697 E18566'
G[34703]='L15 A:77014 T:79322 P:34699 E18566'
G[34704]='FA L15 A:81076 T:79322 P:35063+35064 E18546'
G[34705]='L0 E18546'
G[34706]='FH L20 N54 A:77580 T:79612 P:34564 I:34707 E18663'
G[34707]='FA L20 N41 A:77581 T:79618 P:34154 I:34706 E18612'
G[34708]='L0 E18546'
G[34709]='FA L20 N40 A:79689 T:78534 P:1 E18546'
G[34710]='FH L20 A:79696 T:78534 P:0 I:34709 E18546'
G[34711]='FA L20 A:80617 T:80672 P:34912 I:34712 E18546'
G[34712]='FH L20 A:80389 T:80553 P:34890 I:34711 E18546'
G[34713]='L0 E18546'
G[34714]='L0 E18546'
G[34715]='L0 E18546'
G[34716]='FA L35 N45 A:79722 T:79743 P:34682 E18612'
G[34717]='L35 N45 A:79722 T:79576 P:34682 E18612'	-- OTC: 34720
G[34718]='FA L35 N45 A:79743 T:79743 P:34716 E18612'
G[34719]='FA L35 N45 A:79743 T:79743 P:34716 E18612'
G[34720]='L35 E18702'
G[34721]='FH L20 A:79724 T:76665 I:33871 E18546'
G[34722]='L0 E18702'
G[34723]='K32768 L35 A:-100550 T:-550 E18612'
G[34724]='K32768 L15 A:-150543 T:-543 E18566'
G[34725]='L0 T:80122 E18546'
G[34726]='L0 T:76473 E18546'
G[34727]='L0 T:79725 E18546'
G[34728]='FA K32768 L10 A:-110539 T:-539 E18546'
G[34729]='FH L10 T:76452 E18612'
G[34730]='L0 E18702'
G[34731]='SP L10 A:78208 T:78208 P:34348+36793 U180 E18546'
G[34732]='SP L10 A:79047 T:79047 P:33483+36793 U182 E18546'
G[34733]='L10 T:79492 U32 E18645'
G[34734]='L0 E19027'
G[34735]='L0 E19634'
G[34736]='FH L10 A:78487 T:78208 P:33527 E18556'
G[34737]='FH L10 A:79661 T:79675 P:34429 I:34431 E18546'
G[34738]='L0 E19533'
G[34739]='FH L10 A:500150 T:79315 P:34429 I:34432 E18546'
G[34740]='FH K32 L10 A:78994 T:578994 I:34434 E18546'	-- see note about preqs in 34434
G[34741]='FH L10 A:79675 T:78562 P:34737+34739+34740 I:34436 E18546'
G[34742]='L40 E18612'
G[34743]='L0 T:-539 E18546'
G[34746]='FA L35 N45 A:79743 T:79674 P:34718+34719 E18612'
G[34747]='SP L35 A:581790 T:581790 P:34957+36797 I:34770 U157 E18612'
G[34751]='FH L20 A:79870 T:79870 I:34761 E18546'
G[34755]='L0 E18546'
G[34756]='L30 N40 A:79890 T:81770 P:34659 E18612'
G[34757]='L0 E18663'
G[34758]='fH L20 A:79892 T:79896 P:PF001 I:34194 E18546'	-- availalbe for Horde boost to 100
G[34760]='L0 T:-535 E18546'
G[34761]='FA L20 A:79901 T:79901 I:34751 E18546'
G[34765]='FH L10 A:578466 T:578466 P:34375+34592 I:34585 E18546'
G[34766]='FH L20 A:79921 T:79921 P:34576+34577+34579,34634+34635+34636 I:34773 E18546'	-- TODO: See comment in 34683, TODO: Yoshimo: verify 34634 34635 34636
G[34769]='FA L35 N45 A:79674 T:79576 P:34746 E18612'	--I:34899
G[34770]='SP L35 A:81790 T:81790 P:34868+36793 I:34747 U157 E18612'
G[34771]='L0 E18546'
G[34772]='L0 E18546'
G[34773]='FA L20 A:79963 T:79963 P:34874,34875,34571+34573+34624 I:34766 E18546'
G[34774]='SP K2 L1 A:77789 T:77789 I:31752,40753,56042 ODC:31752,40753,56042 E18546'
G[34775]='FH L10 A:79740 T:79740 P:34462 I:34692 E18546'
G[34776]='FH L20 A:79978 T:79978 I:34777 E18546'
G[34777]='FA L20 N46 A:79979 T:79979 I:34776 E18546'
G[34778]='FA L10 A:79457 T:81912 P:34692 E18546'
G[34779]='FA K32 L10 A:81912 T:80078 P:34778 E18546'
G[34780]='FA L10 A:80075 T:1230933 P:34779 E18546'
G[34781]='FA L10 A:1230933 T:1230933 P:34780 E18546'
G[34782]='FA L10 A:82348 T:80076 P:34781 E18546'
G[34783]='FA L10 A:80076 T:80079 P:34782 E18546'
G[34784]='FA L10 A:80079 T:80079 P:34783 E18546'
G[34785]='FA L10 A:80076 T:80075 P:34782 E18546'
G[34786]='FA L10 A:81140 T:81140 P:34785 E18546'
G[34787]='FA L10 A:80078,580078 T:80073 P:34784+35070 E18546'
G[34788]='FA L10 A:580079 T:580079 P:34792 E18546'
G[34789]='FA L10 A:580073 T:88972 P:34791 E18546'
G[34790]='FA L10 A:82537 T:82537 P:34782 E18546'
G[34791]='FA L10 A:1233229 T:580073 P:35552 E18546'
G[34792]='FA L10 A:88972 T:500134 P:34789 E18546'
G[34793]='L0 T:78390 E18546'
G[34794]='FH L35 A:78487 T:80001 P:1 I:36952 E18612'	-- this also reports 13807 complete
G[34795]='FH L35 N54 A:80001 T:80003 O:34794 E18612'	--I:34675	-- changed P:34794 to O: because Horde boosted to 100 can get this immediately.
G[34801]='FH L20 A:80028 T:80028 I:34802 E18546'
G[34802]='FA L20 A:80028 T:80028 I:34801 E18612'
G[34803]='FH L20 A:79921 T:79921 P:34766 I:34804 E18546'
G[34804]='FA L20 A:79963 T:79963 P:34773 I:34803 E18546'
G[34805]='L30 N40 A:500143 T:81770 P:34659 E18612'
G[34806]='FA L10 A:74547 T:-539 P:33263 E18546'
G[34807]='L0 E18546'
G[34808]='FH L35 N54 A:80003 T:80140 P:34795 E18612'
G[34809]='L35 N54 A:79201 T:1230882 P:34810 E18612'
G[34810]='L35 N54 A:80184 T:79201 P:0 E18612'
G[34811]='L35 N54 A:82658 T:82658 P:34810 E18612'
G[34812]='L0 T:1230977 E18546'
G[34813]='L0 T:80140 E18546'
G[34814]='FH L20 A:80142 T:79393 P:34632 I:34815 E18546'
G[34815]='FA L20 A:80142 T:79392 P:34631 I:34814 E18546'
G[34816]='L0 E19342'
G[34817]='L0 E19342'
G[34818]='FH L35 N54 A:80140 T:80161 P:34808 I:34951 E18612'
G[34819]='L35 N46 A:81955 T:81955 P:34869 E18612'
G[34820]='FA L10 AP:80163:=09711;580163:>09711 T:79966 P:33059 E18546'
G[34821]='L0 E18546'
G[34822]='FH L10 A:78466 T:78466 P:34378 I:35166 E18546'
G[34823]='FH L10 A:78487 T:78487 P:34378 I:35174 E18546'
G[34824]='FH L10 A:78466 T:78466 P:34378 I:35176 E18546'
G[34825]='L0 E18546'
G[34826]='L35 N54 A:80003 T:80003 P:34808 I:35143 E18612'
G[34827]='L30 N40 A:580153 T:80232 P:35611 E18612'
G[34828]='L30 N40 A:80232 T:80232 P:34827 E18612'
G[34829]='L30 N40 A:80232 T:80232 P:34827 E18612'
G[34830]='L30 N40 A:80232 T:80508 P:34828 E18612'
G[34831]='L0 E18546'
G[34833]='L0 T:79335 E18546'
G[34834]='L0 T:79335 E18546'
G[34835]='L0 T:79335 E18546'
G[34836]='FA L10 A:80248 T:80248 E18546'
G[34837]='FH L20 A:79356 T:80229 P:34576+34577+34579 I:34578 E18546'	-- TODO: Verify requires 34577
G[34838]='L30 N40 A:80470 T:80469 P:E34884 E18612'
G[34839]='L0 E18546'
G[34840]='FH L20 A:80229 T:80339 P:34837 E18546'	--I:34976
G[34841]='L0 T:93812 E18546'	-- also marks 34968 complete	Frozen Supplies 941:43.67,55.61  in tower
G[34842]='L0 E18546'
G[34843]='L0 E18546'
G[34844]='L10 E18546'
G[34845]='L93 A:76186 T:76186 P:1 E18546 Z19033'
G[34846]='FH L6576640 E19342'
G[34847]='FA L10 A:77211 T:77211 E18546'
G[34848]='L0 E19533'
G[34849]='FH L35 N54 A:80161 T:80161 P:34818 I:34954 E18612'
G[34850]='FH L35 N54 A:80161 T:80161 P:34818 E18612'
G[34851]='L0 E18546'
G[34855]='FH L20 A:80339,80341 T:80341 P:34840 I:34979 E18546'
G[34856]='L0 E18546'
G[34857]='L0 E18546'	-- when you visit the cave with Durotan and Draka for the first time to turn in 34857 & 35226, this is completed
G[34858]='FH L20 A:80341 T:80341 P:34840 E18546'
G[34859]='L0 T:79334 E18546'
G[34860]='FH L20 A:80341 T:80341 P:34840 I:34977 E18546'
G[34861]='FH L10 A:500151 T:79740 P:34461 E18546'
G[34862]='L0 T:80205 E18546'
G[34865]='L0 E18546'
G[34866]='FH L35 N54 A:80161 T:80319 P:34849+34850 I:34956 E18612'
G[34867]='FH L15 I:35557 E18702'
G[34868]='FH L35 N54 A:80319 T:80140 P:34866 E18612'
G[34869]='L35 N45 A:81955 T:81955 P:34769 E18612'
G[34870]='FH L20 A:80341 T:80342 P:34855+34858+34860 I:34980 E18546'	-- TODO: Verify requires 34858
G[34871]='L1 T:80294 E18546'
G[34872]='L1 E18546'
G[34873]='L1 E18546'
G[34874]='FH L20 A:80193 T:80965 P:34634+34635+34636 I:34875 E18546'	-- TODO: Verify requires 34635
G[34875]='FA L20 A:80260 T:80966 P:34609+34612+34619 I:34874 E18546'	-- TODO: Verify requires 34612
G[34876]='FA L10 A:71641 T:71641 E18546'
G[34877]='L35 N45 A:81144 T:79674 P:34593 ODC:35159 E18612'
G[34878]='FH L20 A:80965 T:80396 P:34874 I:34908 E18546'
G[34879]='FH L20 A:80396 T:80390 P:34878 I:34913 E18546'
G[34881]='L35 N46 A:80593 T:80593 P:FA+35331,FH+34964 E18612'
G[34882]='L30 N40 A:80508 T:80508 P:34830 E18612'
G[34883]='L30 N40 A:80508 T:80508 P:34830 E18612'
G[34884]='L30 N40 A:581770 T:581770 P:35611 I:34565 E18612'
G[34885]='L30 N40 A:80233 T:581770 P:E34884 E18612'
G[34886]='L30 N40 A:80469 T:80469 P:34838 E18612'
G[34887]='FH L20 A:80390 T:80389 P:34879 I:34909 E18546'
G[34888]='FH L20 A:80390 T:80389 P:34879 I:34910 E18546'
G[34889]='FH L20 A:80390 T:80389 P:34879 I:34911 E18546'
G[34890]='FH L20 A:80389 T:80389 P:34887+34888+34889 I:34912 E18546'	-- TODO: Verify requires 34887 34888
G[34891]='FH L35 N54 A:80597 T:80597 P:34965 E18612'	-- I:35333, based on story, not WoW-API
G[34893]='L35 N46 A:80593 T:80593 P:FA+35331,FH+34965 E18612'	-- TODO: G103|Invalidated, Prerequisites, Ancestor faction, Ancestor invalidated|
G[34894]='L35 N46 A:80434 T:80434 P:34943 E18612'
G[34895]='L1 T:702588 E18546'
G[34896]='L0 T:90071 E18546'
G[34897]='FA L10 A:80378 T:73425 ODC:34896 E18546'
G[34898]='SP L30 A:85320 T:85320 P:34886 E18612'	-- ODC:34565
G[34899]='FH L35 N54 A:80140 T:80003 P:34868 E18612'	--I:34769
G[34900]='L35 N46 A:81955 T:81955 P:34819 E18612'
G[34904]='L0 E18546'
G[34905]='L1 E18546'
G[34906]='L0 E18546'
G[34907]='L0 E18546'
G[34908]='FA L20 A:80966 T:80607 P:34875 I:34878 E18546'
G[34909]='FA L20 A:80608 T:80617 P:34913 I:34887 E18546'
G[34910]='FA L20 A:80608 T:80617 P:34913 I:34888 E18546'
G[34911]='FA L20 A:80608 T:80617 P:34913 I:34889 E18546'
G[34912]='FA L20 A:80617 T:80617 P:34909+34910+34911 I:34890 E18546'	-- TODO: Verify requires 34909
G[34913]='FA L20 A:80607 T:80608 P:34908 I:34879 E18546'
G[34914]='FH L35 N54 A:81189 T:80429 P:34899 E18612'
G[34915]='FH L35 N54 A:80429 T:80429 P:34914 E18612'
G[34916]='FH L35 N54 A:80429 T:80429 P:34914 E18612'
G[34917]='FH L35 N54 A:80451 T:80429 P:34914 E18612'
G[34918]='FH L35 N54 A:80429 T:80003 P:34915+34916+34917 E18612'	-- TODO: Verify requires 34915
G[34920]='L0 T:79234 E18546'
G[34921]='L30 N40 A:80648 T:80639 P:35634+35012 E18612'	-- TODO: Verify P:, may also need 35013
G[34922]='L30 N40 A:80740 T:80740 P:35007 E18612'
G[34923]='L30 N40 A:80740 T:80740 P:35007 E18612'
G[34924]='L30 N40 A:80863 T:80746 P:34923+34922 E18612'
G[34925]='L10 A:79917 T:79917 P:34442 E18546'
G[34926]='L0 E19342'
G[34929]='L0 E18546'
G[34931]='L0 T:93812 E18546'
G[34932]='L35 N54 A:80434 T:80434 P:34894 E18612'
G[34934]='L0 T:79231 E18546'	-- completes when in the process of doing 34976
G[34935]='L0 E18546'
G[34936]='L0 E18546'
G[34937]='L0 E18546'
G[34938]='L30 N40 A:80740 T:80481 P:34923+34922 E18612'
G[34939]='L30 N40 A:80860 T:80481 P:34923+34922 E18612'
G[34940]='L0 T:76534 E18546'	-- Strange Looking Dagger 949:52.97,79.96 (in cave)
G[34941]='L35 N54 A:80434 T:80595 P:34932 E18612'
G[34942]='L30 N40 A:80508 T:80153 P:34882+34883 E18612'
G[34943]='L35 N46 A:80595 T:80434 P:FA+35331,FH+34965 E18612'
G[34944]='L0 E18612'
G[34945]='L0 T:80524 E18546'
G[34946]='L0 T:77973 E18546'
G[34947]='L20 E18546'
G[34948]='L20 A:75924 T:1225726 P:33721 E18702'	--TODO: is breadcrumb for 33720. Offered if you went past them.
G[34949]='SP FH L20 A:80553 T:80553 P:34712+36793 U154 E18546'
G[34950]='FH L20 A:75958 T:75959 P:33722+35226 E18546'	-- TODO: requires 33722,could also require 33735+33720+33721 as well
G[34951]='FA L35 N45 A:80624 T:80161 P:34769 I:34818 E18612'
G[34952]='L35 N45 A:79954 T:79954 P:34769 E18612'
G[34953]='L35 A:80161 T:79954 P:0 E18702'
G[34954]='FA L35 N45 A:80161 T:80161 P:34951 E18612'	--I:34849
G[34955]='FA L35 N45 A:80161 T:80161 P:34951 E18612'
G[34956]='FA L35 N45 A:80161 T:80319 P:34954+34955 I:34866 E18612'
G[34957]='FA L35 N45 A:80319 T:79576 P:34956 E18612'
G[34958]='L10 A:78568 T:78568 P:34439 ODC:34438 E18546'
G[34959]='FA L20 A:575803 T:575803 P:34088 E18546'
G[34960]='FH L10 A:1231100 T:500154 E18546'	-- TODO: Is there a P:? -- return is garrison level 2 position
G[34962]='FH L20 A:75959 T:75805 P:33730 E18546'
G[34963]='FA L20 A:575803 T:75805 P:34098 E18546'
G[34964]='FH L35 N54 A:80003 T:80597 P:34918+35158 I:35332 E18612'
G[34965]='FH L35 N54 A:80597 T:80597 O:34964 I:35331 E18612'	-- changed  P:34964 into O: because Horde boosted to 100 can get immediately
G[34966]='L0 E18546'
G[34967]='L0 E18546'	-- "Radided Loot" is top of tower 941:37.26,59.15
G[34968]='L0 T:93812 E18546'	-- see comments for 34841
G[34969]='L0 E18546'
G[34970]='L0 E18546'
G[34971]='FH L20 A:80342 T:80623 P:36793+34870 E18546'	-- completes achievement "Establishing your Armory"
G[34972]='SP FH L20 A:80623 T:80623 P:34971 U155 E18546'
G[34973]='L0 E18546'
G[34974]='L0 E18546'
G[34975]='L0 E18546'
G[34976]='FA L20 A:80627 T:80628 P:34578 E18546'	--I:34837
G[34977]='FA L20 A:80628 T:80632 P:34976 I:34860 E18546'
G[34978]='FA L20 A:80628 T:80632 P:34976 E18546'
G[34979]='FA L20 A:80628 T:80632 P:34976 I:34855 E18546'
G[34980]='FA L20 A:80632 T:80630 P:34977+34978+34979 I:34870 E18546'	-- TODO: Verify requires 34979
G[34981]='FA L20 A:80630 T:80968 P:34980 E18546'	-- this is only when you have the artillery tower I believe
G[34982]='SP FA L20 A:80968 T:80968 P:34981+36797 U155 E18546'
G[34983]='L1 E18546'
G[34984]='L1 E18546'
G[34985]='L1 T:79231 E18546'
G[34986]='L1 E18546'
G[34987]='L10 A:78569 T:78569 P:34439 E18546'
G[34991]='L30 N40 A:80639 T:80639 P:34921 E18612'
G[34992]='FH L0 T:74594 I:35149 E18546'
G[34993]='SP FA L20 A:80672 T:80672 P:34711+36797 U154 E18546'
G[34994]='FA L10 A:80761 T:80761 P:33788 E18546'
G[34995]='FA L10 A:80865 T:80865 P:33788 E18546'
G[34996]='FA L10 A:80859 T:80859 E18546'
G[34997]='FA L10 A:80707 T:-539 E18546'
G[34998]='L30 N40 A:581770 T:80758 P:35611 E18612'
G[34999]='L30 N40 A:81514 T:81514 P:34998 E18612'
G[35000]='L30 N40 A:80758 T:80758 P:34998 E18612'
G[35001]='L30 N40 A:80758 T:1231183 P:35000 E18612'
G[35002]='L30 N40 A:80758 T:1231184 P:35000 E18612'
G[35003]='L30 N40 A:580648 T:86355 P:35001+35002 E18612'
G[35004]='L30 N40 A:580648 T:86355 P:35001+35002 E18612'	-- if you accept 35012 before turning this in, you need to turn it in before he returns
G[35005]='FH L10 A:78553 T:78553 P:34741 I:35019 E18546'
G[35006]='FA L10 A:76204 T:76204 P:33788 E18546'
G[35007]='L30 N40 A:80481 T:80740 P:35010 E18612'
G[35008]='L0 E18612'
G[35009]='L30 N40 A:80481 T:77857 P:34939+34938+34924 E18645'	-- TODO: Verify requires 34938
G[35010]='L30 N40 A:80639 T:80481 P:34991 E18612'
G[35011]='L30 N40 A:586475 T:86475 P:35001+35002 E18612'
G[35012]='L30 N40 A:86355 T:500144 P:35003 E18612'	-- after this was accepted NPC 86355 disappears so cannot turn in 35004
G[35013]='L30 N40 A:86475 T:80834 P:35011 E18612'
G[35014]='FA L10 A:80727 T:80635 P:33788 E18546'
G[35015]='FA L10 A:80635 T:80635 P:35014 E18546'
G[35016]='FH L15 A:81218 T:80757 O:35667 E18566'	-- no known preqs, but Yoshimo reports the P:	-- changed P:35667 to O: because Horde boost to 100 can get this
G[35017]='L15 A:81185 T:80757 E18566'	-- no known preqs
G[35018]='L0 E18546'
G[35019]='FA L10 A:500090 T:500090 P:34436 I:35005 E18546'
G[35020]='L0 E18546'
G[35021]='L15 A:100112378 T:80757 P:C35016 E18566'	-- TODO: Horde boost to 100 tried killing lots of Fungal Lurchers but quest starting item never drops.  however, when accepted 35016 (and NOT 35017), but after interacting with 35017 quest giver, this became available on first Lurcher kill
G[35022]='L35 N54 A:80864 T:80864 P:35393 E18612'
G[35023]='L35 N54 A:80866 T:80866 P:35393 E18612'
G[35024]='L35 N54 A:80864 T:80864 P:35022+35023 E18612'	-- TODO: Verify requires 35022
G[35025]='FH L15 A:81202 T:82832 P:35248+35035 E18566'	-- TODO: Verify requires 35248
G[35026]='L15 A:82832 T:81674 P:35730 E18566'
G[35027]='L15 A:80757 T:80757 P:35016+35017+35021 E18546'
G[35028]='L0 E18546'
G[35029]='FH L15 A:80757 T:80757 P:35016+35017+35021 E18566'
G[35030]='L15 A:80757 T:81241 TP:80757:e35031;81241:E35031 P:35027+35029 E18566'
G[35031]='L15 A:80757 T:81241 P:35027+35029 E18546'
G[35032]='FA L10 A:577282 T:-539 P:34043 E18546'
G[35033]='FA L15 A:80978 T:80921 O:33533,35556 E18546'
G[35035]='FH L15 A:81202 T:81202 P:35880 E18566'
G[35036]='FH L15 A:83569 T:84743 P:35730 I:36508 E18566'
G[35037]='L15 A:80856 T:80856 P:36508,35036 E18566'
G[35038]='FH L15 A:84743 T:84743 P:35036 E18566'
G[35040]='L15 A:81241 T:82732 P:35030+35031 E18566'
G[35041]='FH L15 A:84743 T:80856 P:35038+35202 E18546'
G[35044]='L0 E18546'
G[35045]='FA L20 A:79159 T:79329 P:34563 E18546'
G[35047]='L1 T:79231 E18546'	-- completes when in the process of doing 34976
G[35049]='FA L0 T:75136 I:35064 E18546'
G[35050]='FA L15 A:75146 T:75146,575146 P:35828|36595+35065+35834 E18546'	-- TODO: Verify requires 35065	-- Blizzard has a problem since it will put a yellow ? on the map at 53.31,59.89 before you have chosen to build the outpost and allow D'kaan to stand there.
G[35051]='L0 T:77892 E18546'
G[35055]='FA L15 A:75136 T:75136,575136 P:35828|36595+35065+35834 E18546'	-- TODO: Verify requires 35065	-- Note that completing 35055 (or both 35055 and 35050) allows the new locations of NPCs for turnin, but originals also are still present
G[35056]='L0 T:81240 E18546'
G[35057]='L10 E18546'
G[35058]='fH L10 A:100112566 T:81166 P:PA001 E18556'
G[35059]='FA L35 N45 A:79576 T:81039 P:34596+34957 E18612'	--I:35095
G[35060]='FA L35 N45 A:81039 T:81086 P:35059 E18612'	-- I:35096, based on story, not api
G[35061]='FA L35 N45 A:81086 T:81039 P:35060 E18612'	-- I:35097, based on story, not api
G[35062]='FA L35 N45 A:81039 T:79576 P:35061 E18612'
G[35063]='FA L15 A:575136 T:500136 P:35055+35050 E18546'
G[35064]='FA L0 T:75136 I:35049 E18546'
G[35065]='L15 A:80921 T:75146 P:35033 E18546'
G[35066]='K2 L10 A:79892 T:79892 P:36132 E19027 D097'
G[35067]='L35 N45 A:81097 T:81123 P:35060 E18612'
G[35068]='L35 N45 A:81097 T:81123 P:35060 E18612'
G[35069]='L35 N45 A:81134 T:81123 P:35060 E18612'
G[35070]='L10 A:80075 T:80075 P:34785 E18546'
G[35071]='K2 L10 A:79892 T:79892 P:36132 E19027 D097'
G[35072]='FH K2 L10 A:79892 T:79892 P:36132 E19027 D097'
G[35073]='FH K2 L10 A:79892 T:79892 P:36132 E19027 D097'
G[35074]='FH K2 L10 A:79892 T:79892 P:36132 E19027 D097'
G[35075]='FH K2 L10 A:79892 T:79892 P:36132 E19027 D097'
G[35077]='L30 N40 A:81109 T:81109 E18612'
G[35079]='L30 N40 A:81128 T:81128 E18612'
G[35080]='L30 N40 A:81109 T:81773 P:35077+35079+36179 E18612'
G[35081]='L30 N40 A:81784 T:81784 P:35080 E18612'
G[35082]='L30 N40 A:81773 T:81773 P:35080 E18612'
G[35083]='L35 N54 A:1233263 T:1233263 P:FA+35372,FH+35232 E18612'	-- OTC:35391
G[35084]='L35 N54 A:1233263 T:1233263 P:FA+35372,FH+35232 E18612'	-- OTC:35389
G[35085]='L35 N54 A:1233263 T:1233263 P:35083+35084 E18612'	-- TODO: Verify requires 35083	-- OTC:35387
G[35086]='L35 N54 A:1233263 T:1233263 P:35085 E18612'	-- OTC:35388
G[35087]='L35 N54 A:1233263 T:1233263 P:35085 E18612'	-- OTC:35392
G[35088]='L35 N54 A:1233263 T:1233263 P:35086+35087 E18612'	-- TODO: Verify requires 35086	-- OTC:35390
G[35089]='L30 N40 A:81972 T:81978 P:35285 E18612'
G[35090]='L30 N40 A:81972 T:81978 P:35285 E18612'
G[35091]='L30 N40 A:81978 T:81978 P:35089+35090 E18612'
G[35092]='L0 E19342'
G[35093]='FA L10 E18663'
G[35094]='L0 E19342'
G[35095]='FH L35 N54 A:80003 T:81186 P:34918+35158 E18612'	--TODO: Yoshimo verify 35158 ,I:35059 based on story not WoW-API
G[35096]='FH L35 N54 A:81186 T:81086 P:35095 E18612'	-- I:35060 based on story not WoW-API
G[35097]='FH L35 N54 A:81086 T:81186 P:35096 E18612'	-- I:35061 based on story not WoW-API
G[35098]='FH L35 N54 A:81186 T:80003 P:35097 E18612'	-- Seems like only 35097 is needed, none of the other quests in Uruks  hut. I:35062 based on story not WoW-API
G[35099]='L35 N54 A:81194 T:81193 P:35097 E18612'
G[35100]='L35 N54 A:81194 T:81193 P:35097 E18612'
G[35101]='L35 N54 A:81195 T:81193 P:35097 E18612'
G[35102]='FH L20 A:79210 T:79356 P:34569 E18546'
G[35103]='L10 A:81166 T:81209 P:35058 E18556'
G[35104]='L10 A:81209 T:81210 P:35103 E18556'
G[35106]='L10 A:81210 T:81210 P:35104 E18556'
G[35128]='L15 A:80856 T:84131 P:36209,35041 E18546'
G[35129]='FH L15 A:80856 T:84131 P:35041 E18546'
G[35136]='FH L15 A:84131 T:74594 P:35139+36793 U212 E18546'
G[35137]='FA L15 A:79322 T:81076 P:34698+34700+34702+34703 E18546'	-- TODO: Verify requires 34698 34703
G[35139]='L15 A:84131 T:84131 P:36223|35129+35128+35210 E18546'	-- TODO: Verify requires 35128
G[35140]='L35 N45 A:81039 T:81039 P:35061 E18612'
G[35141]='L35 N45 A:81039 T:81280 P:35140 E18612'
G[35142]='FH L40 A:79774 T:79774,-976 E19342 D144'
G[35143]='L35 A:80161 T:80003 P:34808 I:34826 E18612'
G[35144]='FH L35 N54 A:81335 T:81953 P:35232 I:35398 E18612'
G[35145]='FH L35 N54 A:81335 T:81953 P:35232 I:35397 E18612'
G[35146]='L35 N46 A:84632 T:84861 E18612'	--no known prequest
G[35147]='SP K1 L35 A:87393 T:87393 E18612'
G[35148]='FA L35 N45 A:79954 T:79282 P:34769 E18612'	--I:35150
G[35149]='FH L0 T:74594 I:34992 E18546'
G[35150]='FH L35 N54 A:81319 T:79281 P:34899 E18612'	--I:35148 
G[35151]='FH L15 A:500132 T:500133 P:36460 E18566'
G[35152]='FH L15 A:79320 T:76688 P:34700 E18566'
G[35153]='L0 E18546'
G[35154]='FH L15 A:81688 T:81688 P:>05871 E18566'
G[35155]='L35 N54 A:79281 T:81361 P:35150 E18612'	-- removed  I:34572
G[35156]='FH L35 N54 A:1231901 T:81361 P:35150 I:34597 E18612'	-- TODO: Determine whether you need to be on 35155 or 35157 to get this-> Yoshimo: you don't
G[35157]='FH L35 N54 A:79281 T:81361 P:35150 I:34593 E18612'	-- I: confirmed by WoW-API
G[35158]='FH L35 N54 A:81361 T:80003 P:35157 I:34596 E18612'	-- I: confirmed by WoW-API
G[35159]='L35 N54 A:81361 T:80003 P:35157 E18612'	-- removed  I:34877
G[35161]='L20 E18612'
G[35162]='L0 E18546'
G[35166]='FA L10 A:77209 T:77209 P:34586 I:34822 E18546'
G[35167]='fH L35 N54 A:72822 T:82688 E18612'	--no known prequests
G[35168]='fA L10 AP:77359:G-060018;577359:G-060019;500221:G-060020 TP:77792:G-060018;577792:G-060019;500222:G-060020 P:G-060 E18566'
G[35169]='FA L35 N46 A:79576 T:81412 P:35062 E18612'
G[35170]='L35 N54 A:82688 T:72822 P:35167 E18612'
G[35171]='FH L35 N54 A:80003 T:81415 P:35098 E18612'
G[35172]='L90 AP:77359:G-060018;577359:G-060019;500221:G-060020 TP:77792:G-060018;577792:G-060019;500222:G-060020 P:G-060+35168 E18546'
G[35174]='FA L10 A:79457 T:79457 P:34586 I:34823 E18546'
G[35176]='FA L10 A:77209 T:77209 P:34586 I:34824 E18546'
G[35185]='FA L40 A:83858 T:88276 P:>09711 I:35186 E18612 D093'
G[35186]='FH L40 A:583858 T:88276 P:>09761 I:35185 E18663 D098'
G[35187]='L40 A:88276 T:81530 P:35185,35186 E18612'
G[35188]='L40 A:81499 T:81499 P:35187 E18612'
G[35189]='L40 A:81530 T:81530 P:35187 E18612'
G[35190]='L40 A:81499 T:81499 P:35187 E18612'
G[35191]='L40 A:81530 T:81530 P:35187 E18612'
G[35192]='L0 E18546'
G[35193]='L0 E18716'
G[35194]='L40 A:81530 T:1231918 P:35188+35189+35190+35191 E18716'	-- TODO: Verify requires 35189
G[35195]='L40 A:1231918 T:581530 P:35194 E18716'
G[35196]='FA L40 A:581530 T:83858 P:35195 I:35197 E18716'
G[35197]='FH L40 A:581530 T:583858 P:35195 I:35196 E18716'
G[35201]='L0 E18546'
G[35202]='FH L15 A:84743 T:84743 P:35036 E18566'
G[35203]='L0 E18612'
G[35204]='FA L15 A:81589 T:81589 P:35215+35216 I:35429 E18546'	-- TODO: Verify requires 35215
G[35205]='FA L15 A:81600 T:81601 P:35208 E18546'	-- OTC: 35431
G[35206]='L15 A:81590 T:81590 P:35215+35216 I:35432 E18546'	-- TODO: Verify requires 35215
G[35207]='FA L15 A:81601 T:81601 P:35205+36523 I:35433 E18546'	-- TODO: Verify requires 35205
G[35208]='L15 A:81588 T:81600 P:35215+35216 I:35430 E18546'	-- TODO: Verify requires 35215
G[35209]='FA L15 A:81601 T:81590 P:35207 I:35434 E18546'
G[35210]='L15 A:1236140 T:84131 P:D35128 E18612'
G[35211]='L30 N40 A:81443 T:81443 P:35089+35090+36384 E18612'	-- TODO: Verify requires 35090
G[35212]='FA L15 A:75136 T:81588 P:35063+35049 E18546'
G[35213]='FA L15 A:81588 T:81588 P:35212 I:35399 E18546'
G[35214]='FA L15 A:81589 T:81589 P:35213 I:35400 E18546'
G[35215]='FA L15 A:1231903 T:81588 P:35213 I:35402 E18546'
G[35216]='FA L15 A:81634 T:81588 P:E35215 I:35406 E18546'	-- TODO: Verify prerequisite is killing Voice of Iyu
G[35217]='L0 E18612'
G[35218]='L15 A:80856 T:1233391 P:35934+35037 E18566'	-- TODO Verify requires 35037
G[35219]='L0 T:78457 E18546'
G[35220]='L0 E18546'
G[35221]='L0 E18546'
G[35222]='L0 E18612'
G[35225]='FA L15 A:81588 T:75710 P:35204+35206+35209 E18546'	-- TODO: Verify requires 35204 35209
G[35226]='FH L20 A:75806 T:75958 P:33754 E18546'
G[35227]='FA L20 N40 A:75392 T:75392 P:34326 I:34122 E18546'
G[35228]='L0 E18612'
G[35229]='L15 A:75710 TP:75710:e35234;81751:E35234 P:35225 I:35507 E18546'
G[35231]='FH L35 N54 A:81335 T:80864 P:35232 E18612'	-- I:35393 based on story, not api
G[35232]='FH L35 N54 A:80597 T:81335 P:35265 I:35372 E18612'	-- TODO: Yoshimo: verify 35265 , I: confirmed by WoW-API
G[35233]='FA L15 A:75710 TP:75710:e35234;81751:E35234 P:35225 I:35501 E18546'
G[35234]='FA L15 A:75710 T:81751 P:35225 I:35509 E18546'
G[35235]='L15 A:81751 T:75878 P:35229+35233+35234 I:35510 E18546'	-- TODO: Verify requires 35229 35233
G[35236]='FA K32768 L20 A:-100535 T:-535 I:35237 E18546'
G[35237]='FH K32768 L20 A:79921 I:35236 E18546'	-- available to Horde boost to 100
G[35238]='SP FH L20 A:79853 T:79853 P:34751+36793 U171 E18546'
G[35239]='SP FA L20 A:79853 T:79853 P:34761+36797 U171 E18546'
G[35240]='FA L10 A:81762 T:578559 P:34420 I:34421 E18546'
G[35241]='fH L10 A:81761 T:578553 P:34420 I:35242 E18546'
G[35242]='fA L10 A:81763 T:78554 P:34420 I:35241 E18546'
G[35243]='SP FH L10 A:81765 T:81765 P:36709+36793 U216 E18546'
G[35244]='L0 E18546'
G[35245]='L30 N40 A:80834 T:581770 P:35013 E18612'
G[35247]='FH L15 A:84748 T:85980 P:35149 E18612'
G[35248]='FH L15 A:81202 T:81202 P:35880 E18566'
G[35249]='FH L20 A:78577 T:577737 P:34971,34712 I:34458 E18546'
G[35250]='L0 E18546'
G[35251]='L91 A:70860 T:70860 P:0 E18556'
G[35252]='L0 E18546'
G[35253]='L0 E18546'
G[35254]='FA L20 N40 A:75392 T:75392,77581 P:34092+35227 I:34144 E18612'	-- TODO: Verify requires 35227	-- 77581 is while still doing 34154
G[35255]='L15 A:75878 T:75127 P:35235 I:35416 E18546'
G[35256]='L0 E19890'
G[35257]='L30 N40 A:85598 T:80157 P:O34942 E18612'
G[35258]='L30 N40 A:80157 T:80157 P:35611 O:35257 E18612'	-- TODO: verify 35611
G[35259]='L30 N40 A:80155 T:82123 P:35611 E18612'
G[35260]='L30 N40 A:80157 T:80157 P:35611 E18612'	-- TODO: verify 35611
G[35261]='L30 N40 A:82123 T:1232353 P:35259 E18612'
G[35262]='SP FA L15 A:81772 T:81772 P:35235+36797 U159 E18716'
G[35264]='SP K1 L40 A:81870 T:81870 P:36133 E18702'
G[35265]='FH L35 N54 A:80597 T:80597 P:34941+34893+34891 I:35330 E18612'
G[35266]='L0 E18546'
G[35267]='L0 E18612'
G[35271]='FH L35 N54 A:1232024 T:81193 I:35386 E18612'	-- no known prequest
G[35272]='FH L30 N40 A:81890 T:81890 P:35671 I:35274 E18612'	-- TODO: Yoshimo: verify
G[35273]='L30 N40 A:1232353 T:80155 P:35261 E18612'
G[35274]='FA L30 N40 A:81891 T:81891 P:35671 I:35272 E18612'
G[35275]='FH L30 N40 A:81890 T:81913 P:35272 I:35276 E18612'
G[35276]='FA L30 N40 A:81891 T:81915 P:35274 I:35275 E18612'
G[35277]='FH L30 N40 A:81920 T:81920 P:35275 I:35286 E18612'
G[35279]='L0 E18546'
G[35280]='L0 E18546'
G[35281]='L0 E18546'	-- kill NPC 81406, Bahameye, 947:29.44,7.12
G[35282]='L0 E18546'
G[35283]='L0 T:1232089 I:35284 E18546'	--Arak Outpost Building Tracking Quest (Inn)
G[35284]='L0 I:35283 E18546'	-- Trading Post ?
G[35285]='L30 N40 A:81784 T:81972 P:35081+35082 E18612'
G[35286]='FA L30 N40 A:81929 T:81929 P:35276 I:35277 E18612'
G[35287]='L1 T:61528 E18546'
G[35288]='L1 T:46254 E18546'
G[35289]='L0 E18546'
G[35290]='L0 E18546'	--Arak Outpost Building Tracking Quest (Inn)
G[35291]='L0 E18546'	-- Trading Post ?
G[35293]='FA L30 N40 A:81949 T:81960 P:35286 I:35295 E18612'
G[35294]='L0 E18546'
G[35295]='FH L30 N40 A:81959 T:81961 P:35277 I:35293 E18612'
G[35296]='L24064 E18612'
G[35297]='L0 E18546'	-- this seems to complete when you move forward through Tanaan Jungle to turn in 35240 & 35242
G[35298]='L30 N40 A:81443 T:82468 P:35091+35211+36428 E18612'	-- TODO: Verify requires 35091
G[35303]='L1 T:3654 E18546'
G[35304]='L1 T:46964 E18546'
G[35305]='L1 T:3887 E18546'
G[35306]='L10 E18546'
G[35307]='L1 T:3674 E18546'
G[35308]='L10 E18546'
G[35309]='L35 T:46964 E18546'
G[35310]='L0 E18546'
G[35311]='L35 T:3887 E18546'
G[35312]='L10 T:62205 E18546'
G[35313]='L0 E18546'
G[35314]='L0 E18546'
G[35315]='L10 T:56877 E18546'
G[35316]='L35 T:56930 E18546'
G[35317]='FH L35 N54 A:81953 T:82070 P:35144+35145 I:35396 E18612'
G[35318]='L10 T:61398 E18546'
G[35319]='L10 T:56884 E18546'
G[35320]='L35 T:700062 E18546'
G[35321]='L35 T:61398 E18546'
G[35322]='FH L30 N40 A:81961 T:82100 P:35295 I:35329 E18612'
G[35323]='L10 T:59479 E18546'
G[35324]='L35 T:59479 E18546'
G[35325]='L10 T:56439 E18546'
G[35326]='L0 E18546'
G[35327]='L35 T:56439 E18546'
G[35329]='FA L30 N40 A:81960 T:82100 P:35293 I:35322 E18612'
G[35330]='FA L35 A:82138 T:82138 P:34941+35333+34881+34893 I:35265 E18612'
G[35331]='FA L35 N45 A:82138 T:82138 O:35332 I:34965 E18612'
G[35332]='FA L35 N46 A:79576 T:82138 P:34596+34769 I:34964 E18612'
G[35333]='FA L35 N46 A:82138 T:82138 P:35331 I:34891 E18612'
G[35334]='L0 E18546'
G[35335]='L0 E18546'
G[35337]='L35 N45 A:82092 T:82092 P:34769 E18612'	--I:35374
G[35338]='L35 N45 A:82094 T:82094 P:34769 E18612'	--I:35376
G[35339]='L30 N40 A:82101 T:82124 P:35329,35322 ODC:35340 E18612'
G[35340]='L0 T:82124 E19342'
G[35341]='SP L10 A:79229 T:79229 P:32981+36793 U183 E18546'
G[35342]='fA L10 A:100113103 T:82466 P:PA001+E34019 E18546'
G[35343]='L10 A:82466 T:82497 P:35342 E18546'
G[35344]='L10 A:82497 T:82496 P:35343 E18546'
G[35345]='L10 A:82496 T:82497 P:35344 E18546'
G[35347]='L0 E18546'
G[35348]='L30 E18546'
G[35349]='L30 E18546'
G[35350]='fA L35 N45 A:82092 T:82092 P:35337 E18612'	--I:35375
G[35351]='L35 T:39705 E18546'
G[35352]='L35 T:39700 E18546'
G[35353]='L30 N40 A:82124 T:82126 P:35339 E18612'
G[35356]='fA L35 A:100113107 T:82094 E18612'
G[35357]='L35 N45 A:82094 T:82094 P:35356 E18612'
G[35358]='L30 T:54432 E18546'
G[35359]='L1 E18546'
G[35360]='L1 E18546'
G[35361]='L0 E18546'
G[35362]='L0 E18546'
G[35363]='L30 T:44566 E18546'
G[35364]='L30 T:40788 E18546'
G[35365]='L35 T:44566 E18546'
G[35366]='L35 T:40788 E18546'
G[35367]='L0 E18546'
G[35368]='L0 E18546'
G[35369]='L0 E18546'
G[35370]='L0 E18546'
G[35371]='L0 E18546'
G[35372]='FA L35 A:82138 T:82179 P:35330 I:35232 E18612'	-- I: confirmed by WoW-API
G[35373]='L0 E18546'
G[35374]='L35 N54 A:82078 T:82078 P:34899 E18612'	--I:35337
G[35375]='fH L35 N54 A:82078 T:82078 P:35374 E18612'	--I:35350
G[35376]='L35 N54 A:82080 T:82080 P:34899 E18612'	--I:35338
G[35377]='fH L35 A:100113109 T:82080 E18612'
G[35378]='L35 N54 A:82080 T:82080 P:35377 E18612'
G[35379]='K32768 L35 A:-140550 T:-550 E18612'
G[35380]='L30 N40 A:82126 T:82194 P:35353 E18612'
G[35381]='L0 E18546'
G[35382]='L0 E18546'
G[35383]='L0 E18546'
G[35384]='L0 E18546'
G[35385]='L0 E18546'
G[35386]='FA L35 N45 A:1232024 T:82252 I:35271 E18612'
G[35387]='L0 T:700211 E19342'
G[35388]='L0 E19342'
G[35389]='L0 T:700209 E19342'
G[35390]='L0 T:81409 E19342'
G[35391]='L0 T:700211 P:1 E19342'
G[35392]='L0 T:81216 E19342'
G[35393]='FA L35 A:82179 T:80864 P:35372 I:35231 E18612'
G[35394]='L0 E19890'
G[35395]='FA L35 AA:82181 AH:86393 T:80595 P:35397+35398 I:34271 E18612'	-- TODO: Verify requires 35397
G[35396]='FA L35 AA:82181 AH:86393 T:82214 P:35397+35398 I:35317 E18612'	-- TODO: Verify requires 35397
G[35397]='FA L35 A:82179 T:82181 P:35372 I:35145 E18612'
G[35398]='FA L35 A:82179 T:82181 P:35372 I:35144 E18612'
G[35399]='FH L15 A:574606 T:574606 P:36474 I:35213 E18546'
G[35400]='FH L15 A:74593 T:74593 P:36474 I:35214 E18546'
G[35401]='L30 T:52019 E18546'
G[35402]='FH L15 A:574606 T:574606 P:36474 I:35215 E18546'
G[35403]='L35 T:43875 E18546'
G[35404]='L30 E18546'
G[35405]='L35 T:40484 E18546'
G[35406]='FH L15 A:1235129 T:574606 P:E35402 I:35216 E18546'	-- TODO: Verify prerequisite is killing Voice of Iyu
G[35407]='L30 N40 A:82194 T:82194 P:35380 E18612'
G[35408]='L30 N40 A:82212 T:82212 P:35380 E18612'
G[35411]='L35 T:52730 E18546'
G[35412]='L35 T:52053 E18546'
G[35413]='L30 E18546'
G[35414]='L35 T:44819 E18546'
G[35415]='L30 E18546'
G[35416]='FH L15 A:82337 T:500133 P:35510 I:35255 E18546'	-- completes In the Land of Giants
G[35417]='L0 E18546'
G[35418]='L0 E18546'
G[35419]='L0 E18546'
G[35420]='L30 E18546'
G[35421]='L0 E18546'
G[35422]='L0 E18546'
G[35423]='L0 E18546'
G[35424]='L35 T:39378 E18546'
G[35425]='L0 E18546'
G[35426]='L35 T:39587 E18546'
G[35427]='L0 E18546'
G[35428]='L0 E18546'
G[35429]='FH L15 A:574606 T:82228 P:35402+35406 I:35204 E18546'
G[35430]='FH L15 A:574606,82228 T:82254 P:35400+35402+35399+35406 I:35208 E18546'
G[35431]='L0 T:81942 E19634'
G[35432]='FH L15 A:74593,82233 T:82233 P:35402+35406 I:35206 E18546'
G[35433]='FH L15 A:82233 T:82233 P:35536+35429+35432 I:35207 E18546'
G[35434]='FH L15 A:82228 T:82228 P:35536+35429+35432 I:35209 E18546'
G[35435]='L30 T:54969 E18546'
G[35436]='L10 T:36666 E18546'
G[35437]='L30 T:36502 E18546'
G[35438]='L10 T:36658 E18546'
G[35439]='L30 T:54938 E18546'
G[35440]='L30 T:36658 E18546'
G[35441]='L10 T:36954 E18546'
G[35442]='L30 E18546'
G[35443]='L35 T:23574 E18546'
G[35444]='FA L10 A:82256 T:76200 P:34019 I:35450,35459 E18546'
G[35446]='L10 E18546'
G[35447]='L30 E18546'
G[35448]='L0 E18546'	-- killing Darkmaster Go'vid (82268) at 947:42.42,83.76 though he wanders about
G[35449]='L10 E18546'
G[35450]='FA L10 A:81126 T:76200 P:34019 I:35444,35459 E18546'
G[35452]='L20 E18546'
G[35453]='L30 T:26861 E18546'
G[35454]='L30 E18546'
G[35456]='L10 T:28923 E18546'
G[35457]='L30 E18546'
G[35458]='L30 T:700167 E18546'
G[35459]='FA L10 A:1232397 T:76200 P:34019 I:35444,35450 E18546'
G[35460]='FA L10 A:82270 T:82270 P:36498+37196+i176111,35884+i176111 I:35745 E18546'
G[35461]='L35 T:62205 E18546'
G[35462]='FA L10 A:82270 T:82270 P:35884|37196+i176111 I:35746 E18546'
G[35463]='FA L10 A:82270 T:82270 P:35460+35462+i176111 I:35748 E18612'	-- TODO: Verify needs 35460
G[35464]='FA L10 A:85213 T:85213 P:35460+35462+i176111 I:35744 E18612'	-- TODO: Verify needs 35460
G[35465]='L10 E18546'
G[35466]='L1 E18546'
G[35467]='L1 E18546'
G[35468]='L30 T:27978 E18546'
G[35469]='L1 E18546'
G[35470]='L1 E18546'
G[35472]='L10 E18546'
G[35473]='L30 E18546'
G[35474]='L30 E18546'
G[35475]='L10 T:29306 E18546'
G[35476]='L30 T:29306 E18546'
G[35477]='L30 E18546'
G[35478]='L10 T:31134 E18546'
G[35479]='L1 E18546'
G[35480]='L30 T:700155 E18546'
G[35481]='L0 T:82303 E18546'
G[35482]='FA L30 N40 A:82278 T:82375 P:35407+35408 ODC:36183 E18612'
G[35483]='L10 T:27483 E18546'
G[35484]='L30 T:26632 E18546'
G[35486]='FA L10 A:84929 T:84929 P:36307+i176111 I:35750 E18612'
G[35487]='FH L15 A:82274 T:82274 P:35430 E18546'
G[35488]='FA L10 A:84929 T:84929 P:35486+35492+35494+i176111 I:35762 E18612'	-- TODO: Verify needs 35486 35492
G[35489]='L10 T:29310 E18546'
G[35490]='L30 T:29311 E18546'
G[35491]='L0 T:80524 E18546'
G[35492]='FA L10 A:84929 T:84929 P:36307+i176111 I:35751 E18612'
G[35493]='L30 T:30258 E18546'
G[35494]='FA L10 A:82447 T:82447 P:36307+i176111 I:35761 E18612'
G[35495]='FA L10 A:84929 T:84929 P:35486+35492+35494+i176111 I:35760 E18612'	-- TODO: Verify needs 35486 35492
G[35496]='FA L10 A:76111 T:76111 P:35486+35492+35494+i176111 I:35764 E18612'	-- TODO: Verify needs 35486 35492
G[35497]='L10 T:29120 E18546'
G[35498]='L30 T:29120 E18546'
G[35499]='FA L10 E19103'
G[35500]='FA L10 A:84929 T:84929 P:35488+35495+35496+i176111 I:35763 E18546'	-- TODO: Verify needs 35488 35495
G[35501]='FH L15 A:1232492 T:1232489 P:36488 I:35233 E18546'	-- removed T:82334
G[35502]='L10 T:23954 E18546'
G[35503]='L0 T:82311 E18546'
G[35504]='L7864576 E18546'
G[35505]='L15 A:84811 T:82569 P:35707 I:36368 E18546'	-- 35653 also mark completed
G[35506]='FH L15 A:82574 T:582574 P:35707 I:35652 E18546'
G[35507]='L15 A:85601 T:82334 P:36488 I:35229 E18546'
G[35508]='FH L15 A:82569 T:582574 P:35505 I:35654 E18546'
G[35509]='FH L15 A:85601 T:82334 P:36488 I:35234 E18546'
G[35510]='FH L15 A:82334 T:82337 P:35507+35509+35501 I:35235 E18546'
G[35511]='SP FH L15 A:82338 T:82338 P:35510+36793 U159 E18546'
G[35512]='L30 E18546'
G[35513]='L10 T:26723 E18546'
G[35514]='L30 T:26723 E18546'
G[35515]='L10 T:26796 E18546'
G[35517]='L10 T:16808 E18546'
G[35518]='L30 T:16808 E18546'
G[35519]='L10 T:18708 E18546'
G[35520]='L30 T:18708 E18546'
G[35521]='L10 E18546'
G[35522]='L30 T:17881 E18546'
G[35523]='L0 T:82362 E18546'
G[35524]='FH L15 A:82569 T:582574 P:35505 I:35650 E18546'
G[35525]='L10 E18546'
G[35526]='L30 T:17977 E18546'
G[35527]='FH L15 A:82569 T:582574 P:35505 I:35651 E18546'
G[35528]='L10 T:19220 E18546'
G[35529]='L30 E18546'
G[35530]='L0 E18546'
G[35531]='L10 E18546'
G[35532]='L30 T:-348 E18546'
G[35533]='L10 T:17954 E18546'
G[35534]='L30 E18546'
G[35535]='L10 E18546'
G[35536]='FH L15 A:82274 T:82228 P:35487+36482 E18546'
G[35537]='fH L20 A:79627 T:78487 I:35554 E18546'
G[35538]='L30 T:20912 E18546'
G[35539]='L10 T:18473 E18546'
G[35540]='L30 T:18473 E18546'
G[35541]='L30 E18546'
G[35542]='L10 T:703732 E18546'
G[35543]='L30 T:18096 E18546'
G[35544]='L10 E18546'
G[35545]='L30 T:18373 E18546'
G[35546]='L10 T:18343 E18546'
G[35547]='L30 T:18344 E18546'
G[35548]='L30 E18546'
G[35549]='FA L30 N40 A:82403 T:81929 P:35482 I:35550 E18612'
G[35550]='FH L30 N40 A:82402 T:81920 P:36183 I:35549 E18612'
G[35551]='L0 E18612'
G[35552]='L10 A:80073 T:1233229 P:34787 E18546'
G[35553]='L0 E18546'
G[35554]='fA L20 N46 A:79618 T:81492 I:35537 E18546'
G[35555]='L0 E18546'
G[35556]='fA L15 A:1232400 T:80978 I:33533 E18546'
G[35557]='FH L15 A:1232416 T:74594 P:1 I:34867 E18566'	-- removed A:78487
G[35558]='L0 E18546'
G[35559]='L10 T:17882 E18546'
G[35560]='L30 T:700126 E18546'
G[35561]='L10 T:17942 E18546'
G[35562]='L30 T:17942 E18546'
G[35563]='L1 T:10813 E18546'	-- completed automatically killing 10813 (Balnazzar) at 765[1]:18.86,83.63
G[35564]='L1 T:10558 E18546'	-- completed automatically killing 10997 (Willey Hopebreaker) at 765[1]:3.60,50.18...actually it gets marked completed whenever any of the bonus objective bosses are completed
G[35565]='L10 T:17377 E18546'
G[35566]='L30 T:17377 E18546'
G[35567]='L0 E18546'
G[35568]='L0 E18546'
G[35569]='L0 E18546'
G[35570]='L0 E18546'
G[35571]='L1 E18546'
G[35572]='L10 T:17308 E18546'
G[35573]='L30 T:700099 E18546'
G[35574]='L1 T:45412 E18546'
G[35575]='L1 T:10435 E18546'
G[35576]='SP K131072 L0 A:1232571 T:1232571 E18546'
G[35577]='SP K131072 L0 A:1232584 T:1232584 E18546'
G[35578]='L40 E19027'
G[35579]='SP K131072 L0 A:1232590 T:1232590 E18546'
G[35580]='SP K131072 L0 A:1232592 T:1232592 E18546'
G[35581]='SP K131072 L0 A:1224756 T:1224756 E18546'
G[35582]='L1 E18546'
G[35583]='SP K131072 L0 A:1232595 T:1232595 E18546'
G[35584]='SP K131072 L0 A:1232596 T:1232596 E18546'
G[35586]='L1 T:47739 E18546'
G[35587]='L35 E18546'
G[35588]='L1 E18546'
G[35589]='L1 T:7272 E18546'
G[35590]='L0 E18546'
G[35591]='SP K131072 L0 A:1232598 T:1232598 E18546'
G[35592]='L1 E18546'
G[35593]='L0 T:79708 E18546'
G[35594]='L1 T:59080 E18546'
G[35595]='L35 T:59080 E18546'
G[35596]='L35 T:80083 U170 E18612'
G[35597]='SP K131072 L0 A:1232406 T:1232406 E18546'
G[35598]='L1 T:74434 E18546'
G[35599]='L0 E18546'
G[35600]='SP K131072 L0 A:1232621 T:1232621 E18546'
G[35601]='L1 T:7800 E18546'
G[35602]='L1 T:7361 E18546'
G[35603]='SP K131072 L0 A:1232624 T:1232624 E18546'
G[35604]='L1 E18546'
G[35605]='L1 E18546'
G[35606]='L1 T:59150 E18546'
G[35607]='L1 T:58632 E18546'
G[35608]='L35 T:59150 E18546'
G[35609]='L35 T:58632 E18546'
G[35610]='L1 T:7023 E18546'
G[35611]='L30 N40 AA:579748 AH:79748 T:581770 P:35277,35286 E18612'
G[35612]='L1 T:-435 E18546'
G[35613]='L35 E18546'
G[35614]='SP FA L10 A:74741 T:74741 P:33038+36797 U179 E18546'
G[35615]='L1 T:700226 E18546'
G[35616]='SP K131072 L0 A:1232985 T:1232985 E18546'
G[35617]='SP FA L10 A:76204 T:76204 P:35015+36797 U180 E18546'
G[35618]='FA L10 E18663'
G[35619]='FA L30 N40 A:85550 T:81109 P:35286 I:35620,36861,36862 E18612'
G[35620]='FH L30 A:85566 T:81109 P:35277 I:35619,36861,36862 E18612'
G[35621]='FA L10 E18663'
G[35622]='L0 T:82202 E18546'
G[35623]='L0 T:82486 E18546'
G[35624]='SP L0 A:70902 T:70902 P:33419 E18546 Z19033'
G[35625]='SP FA L10 A:76748 T:76748 P:33271+36797 U182 E18546'
G[35626]='L0 E18612'
G[35627]='L0 E18546'
G[35628]='L0 E18612'
G[35629]='L0 E18612'
G[35630]='L0 E18546'
G[35631]='SP FA L10 A:575884 T:575884 P:33082+36797 U183 E18663'
G[35632]='L35 N54 A:79201 T:79201 P:34809+34811 E18612'	-- TODO: Verify requires 34811
G[35633]='FA L15 A:80762 T:82476 O:35666 E18546'
G[35634]='L30 N40 A:80157 T:82509 P:35273+35258 E18612'
G[35635]='L0 E19890'
G[35636]='L30 N40 A:79890 T:82621 P:34659 E18612'
G[35637]='FA K2 L40 A:-525 T:77988 E18612'
G[35638]='SP K1 L40 A:81870 T:81870 P:36133 E18702'
G[35639]='SP K1 L40 A:81870 T:81870 P:36133 E18702'
G[35640]='FA L15 A:82499 T:82476 E18546'	--  P:O35633 was removed because the quest was available before accepting quest
G[35641]='FH K2 L40 A:79892 T:78578 E18612'
G[35642]='FA L15 A:100113260 T:82476 P:C35016,C35633 E18546'
G[35643]='L0 E18546'
G[35644]='FA L15 A:82476 T:82476 P:35642+35640+35633 E18546'
G[35645]='FA L15 A:82476 T:82476 P:35642+35640+35633 E18546'
G[35646]='SP K131072 L0 A:1233033 T:1233033 E18546'
G[35647]='FA L15 A:82476 TP:82476:e35656;82477:E35656 P:35644+35645 E18546'
G[35648]='SP K131072 L0 A:1233034 T:1233034 E18546'
G[35649]='K32768 L30 A:-180542 T:-542 E18546'
G[35650]='FA L15 A:82569 T:85130 P:36368 I:35524 E18546'
G[35651]='FA L15 A:82569 T:85130 P:36368 I:35527 E18546'
G[35652]='FA L15 A:82575 T:85130 P:35708 I:35506 E18546'
G[35654]='FA L15 A:82569 T:85130 P:36368 I:35508 E18546'
G[35656]='FA L15 A:82476 T:82477 P:35644+35645 E18546'
G[35659]='FA L15 A:82477 T:500137 P:35647+35656 E18546'
G[35660]='L0 E18546'
G[35661]='L0 T:78278 E18546'
G[35662]='L0 E18546'
G[35663]='L35 N54 A:79201 T:79201 P:34809+34811 E18612'	-- TODO: Verify requires 34811
G[35664]='FA L15 A:82610 T:582610 P:35686 E18546'
G[35665]='FA L15 A:582610 T:82832 P:35664+35693 E18546'
G[35666]='L15 AP:500136:35049;500137:35064 T:80762 P:35063 E18546'
G[35667]='L15 A:82732 T:81218 P:35151+0 E18566'	-- TODO: Does this need to be P:35151+34992 ?
G[35668]='L30 N40 A:82621 T:81770 P:35636 E18612'
G[35669]='FH K512 L30 N40 A:1233099 T:81920 P:37314 E18612'	-- TODO: Yoshimo: verify 37314
G[35670]='FH K512 L30 N40 A:1233099 T:82622 P:37314 I:35675 E18612'	-- TODO: Yoshimo: verify 37314
G[35671]='L30 N40 A:81770 T:80153 P:35668+34805+34756 E18612'
G[35672]='FH K512 L30 N40 A:1233099 T:82612 P:37314 E18612'	-- TODO: Yoshimo: verify 37314
G[35673]='L0 E18546'
G[35674]='FA K512 L30 N40 A:1233100 T:81929 P:35283 I:35669 E18612'	-- A:81929 removed
G[35675]='FA K512 L30 N40 A:1233100 T:82664 P:35283 I:35670 E18612'	-- A:81929 removed
G[35676]='FA K512 L30 N40 A:1233100 T:82669 P:35283 I:35672 E18612'	-- A:81929 removed
G[35677]='SP K131072 L0 A:1233101 T:1233101 E18546'
G[35678]='L0 T:86398 E18546'
G[35679]='FA L40 A:83858 T:75028 P:>09711 E18912 D093'
G[35680]='FH L40 A:583858 T:76804 P:>09761 E18912 D098'
G[35681]='L0 E18702'
G[35682]='L0 E18546'
G[35683]='FA L40 A:75028 T:75028 P:35679 E18912'
G[35684]='FH L40 A:76804 T:76804 P:35680 E18912'
G[35685]='FA L40 A:75028 T:75028 P:35683 E18912'
G[35686]='FA L15 A:75127 T:82610 P:35063+35064 E18546'
G[35687]='FH L40 A:76804 T:76804 P:35684 E18912'
G[35688]='L0 P:35636 E18546'
G[35689]='SP FA K1 L110 A:82660 T:82660 P:36133 E18716'
G[35690]='SP FA K1 L110 A:82660 T:82660 P:36133 E18702'
G[35691]='SP FA K1 L110 A:82660 T:82660 P:36133 E18702'
G[35692]='L0 T:80595 E18546'
G[35693]='FA L15 A:82610 T:582610 P:35686 E18546'
G[35694]='SP K131072 L0 A:1233134 T:1233134 E18546'
G[35695]='SP K131072 L0 A:1233135 T:1233135 E18546'
G[35696]='L0 E18546'
G[35697]='FH L30 N40 A:82691 T:82574 P:35277+37314 I:37326 E18612'	-- TODO: Yoshimo: verify P:
G[35698]='L0 E19890'
G[35699]='FA L30 A:82709 T:82574 P:35286+35291 I:37327 E18612'	-- TODO: Yoshimo: verify P:
G[35700]='L0 E21463'
G[35701]='L0 E18546'
G[35702]='FA L15 A:84131 T:75127 P:35139 E18546'
G[35703]='L0 E18546'
G[35704]='L30 N40 A:84262 T:500145 P:36085 E18645'
G[35705]='FH L30 N40 A:82691 T:82713 P:37328+35550 E18612'	-- TODO: Verify requires 37328 35550
G[35706]='FH L30 N40 A:82713 T:82713 P:35705 E18612'
G[35707]='FH L15 A:85077 T:82574 P:34992 E18546'
G[35708]='FA L15 A:85119 T:82575 P:35049 E18546'
G[35709]='L0 E18546'
G[35711]='L0 E18546'
G[35712]='L0 T:82755 E18546'
G[35713]='FA L30 A:82709 T:82759 P:37329+35284,37331+35284 E18612'	-- TODO: requires picking the Alliance Smuggler's Den
G[35714]='L0 T:82758 E18546'
G[35715]='SP K65536 L0 AK:82764 T:82764 E18546'
G[35716]='FA L30 A:82759 T:82759 P:35713 E18612'
G[35717]='L0 T:82778 E18546'
G[35718]='FH L30 N40 A:82713 T:82786 P:35706 E18612'
G[35719]='FA L30 A:82759 T:82788 P:35716+35878 E18612'
G[35720]='L0 E18716'
G[35721]='L0 E18546'
G[35722]='L0 E18546'
G[35723]='L0 E18716'
G[35724]='L0 E18702'
G[35725]='L0 E18546'
G[35726]='L0 E18716'
G[35727]='L0 E18546'
G[35728]='L0 E18546'
G[35729]='L0 E18702'
G[35730]='L15 A:82832 T:82832 P:35025,35665 E18566'
G[35731]='L0 T:82326 E18546'
G[35732]='L0 T:82415 E18546'
G[35733]='L30 N40 A:500145 T:82813 P:34942 E18612'
G[35734]='L30 N40 A:82813 T:500145 P:35733 E18612'
G[35735]='L0 T:82826 E18546'
G[35736]='FH L40 A:77995 T:78487 E18702'
G[35737]='FA L40 A:82833 T:81492 E18612'
G[35738]='FH L30 N40 A:82786 T:82786 P:35718 E18612'
G[35739]='FA L30 A:82788 T:82788 P:35719 E18612'
G[35740]='L0 E18716'
G[35741]='L0 E18702'
G[35742]='L0 E18546'
G[35743]='L0 T:83439 E18546'
G[35744]='FH L10 A:85247 T:85247 P:35745+35746+i176111 I:35464 E18612'
G[35745]='FH L10 A:82851 T:82851 P:36499+37190+i176111,34446+i176111 I:35460 E18546'
G[35746]='FH L10 A:82851 T:82851 P:34446|37190+i176111 I:35462 E18546'
G[35747]='L10 A:578563 T:80521 P:34437+34958+34987 E18546'
G[35748]='FH L10 A:82851 T:82851 P:35745+35746+i176111 I:35463 E18612'
G[35749]='L0 E18546'
G[35750]='FH L10 A:84928 T:84928 P:36292+i176111 I:35486 E18612'
G[35751]='FH L10 A:84928 T:84928 P:36292+i176111 I:35492 E18612'
G[35752]='L0 E18546'
G[35753]='L0 E18546'
G[35754]='L0 E18764'
G[35756]='L0 E18764'
G[35758]='L0 E18716'
G[35759]='SP K131072 L0 A:1233206 T:1233206 E18546'
G[35760]='FH L10 A:84928 T:84928 P:35750+35751+35761+i176111 I:35495 E18612'
G[35761]='FH L10 A:76609 T:76609 P:36292+i176111 I:35494 E18612'
G[35762]='FH L10 A:84928 T:84928 P:35750+35751+35761+i176111 I:35488 E18612'
G[35763]='FH L10 A:84928 T:84928 P:35760+35762+35764+i176111 I:35500 E18612'
G[35764]='FH L10 A:76609 T:76609 P:35750+35751+35761+i176111 I:35496 E18612'
G[35765]='L0 T:82866 E18546'
G[35766]='FH L30 N40 A:82786 T:82786 P:35718 E18612'
G[35767]='L0 E18546'
G[35768]='L0 E18702'
G[35770]='L0 E18546'
G[35771]='L0 E18546'
G[35772]='L0 E18546'
G[35773]='L0 E18738'
G[35774]='L0 E18702'
G[35775]='L0 E18702'
G[35777]='L0 E18764'
G[35778]='L0 E18546'
G[35779]='L0 E18702'
G[35780]='L0 E18702'
G[35781]='L0 E18546'
G[35782]='FA L30 A:82788 T:82788 P:35719 E18612'
G[35783]='L0 E18546'
G[35784]='L0 T:82912 E18546'
G[35785]='L0 E18764'
G[35786]='L40 E18546'
G[35787]='L40 E18546'
G[35788]='L40 E18546'
G[35789]='L0 E18546'
G[35790]='L0 E18702'
G[35792]='L0 E18546'
G[35793]='L0 E18833'
G[35794]='L0 E18716'
G[35795]='L0 E18716'
G[35796]='L0 E18716'
G[35797]='FH L30 N40 A:82786 T:82786 P:35738+35766 E18612'	-- TODO: Verify requires 35738 35766
G[35798]='SP K131072 L0 A:1233241 T:1233241 E18546'
G[35799]='L0 E18702'
G[35800]='L0 E18918'
G[35801]='L0 E18702'
G[35802]='L0 E18716'
G[35803]='L0 E18702'
G[35804]='L0 E18702'
G[35805]='L0 E18702'
G[35807]='FH L15 N54 A:81540 T:74594 P:35151 E18612'
G[35808]='FA L15 A:81540 T:75127 P:35063 E18546'
G[35809]='FA L15 A:81529 T:75127 P:35063 E18546'
G[35810]='FH L15 A:81529 T:74594 P:35151 E18546'
G[35811]='FH L15 A:100113448 T:74594 P:35151 E18546'
G[35812]='FA L15 A:100113449 T:75127 P:35063 E18546'
G[35813]='FA L15 A:100113453 T:75127 P:35063 E18546'
G[35814]='FH L15 A:100113454 T:74594 P:35151 E18546'
G[35815]='FH L15 A:81548 T:74594 P:35151 E18546'
G[35816]='FA L15 A:81548 T:75127 P:35063 E18546'
G[35817]='FA L15 A:75127 T:75127 P:35063 E18546'
G[35818]='FH L15 A:75127 T:74594 P:35151 E18546'
G[35819]='FH L15 A:100113461 T:74594 P:35151 E18546'
G[35820]='FA L15 A:100113461 T:75127 P:35063 E18546'
G[35821]='L0 E18546'
G[35822]='L0 E19027'
G[35823]='L0 E18716'
G[35824]='L0 E18546'
G[35826]='L0 E18702'
G[35827]='L0 E18716'
G[35828]='FA L15 A:80874 T:75136 P:35033 I:36595 E18546'
G[35829]='L0 E18546'
G[35831]='L0 E18716'
G[35833]='L0 E18716'
G[35834]='FA L15 A:80922 T:80987 P:35033 E18546'
G[35835]='FA L30 A:82788 T:82788 P:35739+35782 E18612'
G[35836]='L0 T:82975 E18546'
G[35837]='FA L40 A:81492 T:83051 P:34289+37517+34450+35685+34033+36290+35196+36169 I:35843 E18612'
G[35838]='FA L40 A:83051 T:83053 P:35837 I:35844 E18612'
G[35839]='FA L40 A:83053 T:81492 P:35838 I:35845 E18612'
G[35840]='FA L40 A:83053 T:81492 P:35838 I:35846 E18612'
G[35841]='FA L40 A:83053 T:81492 P:35838 I:35842 E18612'
G[35842]='FH L40 A:83054 T:578487 P:35844 I:35841 E18612'
G[35843]='FH L40 A:578487 T:83052 P:34319+37516+34450+33427+35687+34078+36290+35197 I:35837 E18612 D098'
G[35844]='FH L40 A:83052 T:83054 P:35843 I:35838 E18612'
G[35845]='FH L40 A:83054 T:578487 P:35844 I:35839 E18612'
G[35846]='FH L40 A:83054 T:578487 P:35844 I:35840 E18612'
G[35847]='L0 E18546'
G[35848]='L0 T:83504 E18702'
G[35849]='L0 T:83504 E18702'
G[35850]='L0 E18702'
G[35851]='L0 E18702'
G[35852]='L0 E18702'
G[35853]='L0 E18702'
G[35854]='L0 E18702'
G[35855]='L0 E18702'
G[35856]='L0 E18546'
G[35857]='L0 E18546'
G[35858]='L0 E18546'
G[35859]='L0 E18702'
G[35860]='L0 E18546'
G[35861]='FA L40 A:81492 T:77982 P:>09711 E18663 D093'
G[35862]='L0 E18716'
G[35863]='L0 E18716'
G[35865]='L0 E18546'
G[35866]='FA L110 E18612'
G[35867]='SP K1 L40 A:82966 T:82966 P:36133 E18716'
G[35868]='SP K1 L40 A:82966 T:82966 P:36133 E18716'
G[35869]='SP K1 L40 A:82966 T:82966 P:36133 E18702'
G[35870]='L15 A:82816 T:81674 P:35730 E18566'
G[35871]='SP K1 L40 A:82893 T:82893 P:36127 E18702'
G[35872]='SP K1 L40 A:82893 T:82893 P:36127 E18702'
G[35873]='SP K1 L40 A:82893 T:82893 P:36127 E18702'
G[35874]='L0 E18546'
G[35875]='L0 T:83409 E18546'
G[35876]='FH L40 A:578487 T:77982 P:>09761 E18645 D098'
G[35877]='L0 T:83428 E18546'
G[35878]='FA L30 A:82759 T:82759 P:35713 E18612'
G[35879]='FH L30 N40 A:82713 T:82713 P:35705 E18612'
G[35880]='FH L15 A:500133 T:81202 P:35151+35149 I:34992 E18566'
G[35881]='K32768 L15 A:-140543 T:-543 E18566'
G[35882]='SP FH L15 A:77014 T:77014 P:34703+36793 U176 E18546'
G[35883]='SP FA L15 A:79337 T:79337 P:34703+36797 U176 E18546'	-- TODO: Needs more P: unless requiring the garrison is correct, then we are ok, as the Alliance toon testing has no garrison
G[35884]='FA L10 A:80521 T:78563 P:34445 ODC:34446 E18546'
G[35885]='L1 AZ:280 T:-280 E18546'
G[35886]='L1 AZ:280 T:-280 E18546'
G[35887]='L1 AZ:280 T:-280 E18546'
G[35888]='L1 AZ:280 T:-280 E18546'
G[35889]='L10 AZ:280 T:-280 E18546'
G[35890]='L1 E18546'
G[35891]='L1 E18546'
G[35892]='L1 E18546'
G[35893]='L0 T:83483 E18546'
G[35894]='L1 T:14368 E18546'
G[35895]='L30 N40 A:82813 T:500145 P:35897 E18612'
G[35896]='L30 N40 A:84122 T:500145 P:36059 E18702'
G[35897]='L30 N40 A:500145 T:82813 P:35734 E18612'	-- Yoshimo commented that P: might also need 35012/35013
G[35898]='L0 T:83509 E18546'
G[35899]='L1 E18546'
G[35900]='L0 T:83526 E18546'
G[35901]='L1 E18546'
G[35902]='L1 E18546'
G[35903]='L1 T:9029 E18546'
G[35904]='L1 T:8904 E18546'
G[35905]='L10 A:580079 T:77209 P:34788 E18546'
G[35906]='L0 T:77310 E18546'
G[35907]='FH L30 A:83529 T:83608 P:37328 I:35915 E18612'
G[35908]='L0 E18546'
G[35909]='L0 E18546'
G[35910]='L0 E18546'
G[35911]='L30 T:42333 E18546'
G[35912]='L0 T:83542 E18546'
G[35913]='L35 T:42333 E18546'
G[35914]='FH L10 T:79609 E18612'
G[35915]='FA L30 N40 A:83549 T:83609 P:37329+35283,37331+35283 I:35907 E18612'
G[35919]='SP K131072 L0 A:1224780 T:1224780 E18546'
G[35920]='L0 E18546'
G[35921]='L35 N45 A:583606 T:79188 P:35062 I:35922 E18612'
G[35922]='L35 N54 A:83606 T:79188 P:35098 I:35921 E18612'
G[35923]='L0 T:83603 E18546'
G[35924]='FH L30 A:83608 T:83772 P:35907 I:35926 E18612'
G[35925]='L15 A:1233391 T:80856 P:35026+35870 O:35218 E18546'
G[35926]='FA L30 N40 A:83609 T:83773 P:35915 I:35924 E18612'
G[35927]='L40 E18716'
G[35928]='SP K1 L35 A:82727 T:82727 E18612'	-- TODO: Inidcates probably needs in the inventory "Heart Soup Bone"
G[35929]='K1 L1 AZ:221 T:-221 E18546'	-- TODO: Make available again once instance resets
G[35930]='K1 L1 AZ:221 T:-221 E18546'	-- TODO: Make available again once instance resets
G[35931]='L0 T:83634 E18546'
G[35932]='L0 T:83643 E18546'
G[35933]='L10 A:78558 T:-577 P:34398,36881 I:34398 ODC:36881 E18546'	-- note that Tarnils lost 34398 when turning this in as well
G[35934]='L15 A:80856 T:80856 P:36508,35036 E18566'
G[35935]='FH L40 A:79774 T:79774,-976 E19342 D144'
G[35937]='L40 E18716'
G[35938]='L40 E18912'
G[35939]='L40 E18702'
G[35940]='L40 E18716'
G[35941]='L40 E18918'
G[35942]='L40 E18918'
G[35943]='L0 T:83680 E18546'	-- kill Outrider Duretha (83680) 950:61.78,69.00
G[35944]='FA L15 A:100113586 T:81076 P:35064+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[35945]='L40 A:83686 T:83734 P:35985,36117 E18612'
G[35946]='L0 T:75835 E18546'
G[35947]='FH L30 A:83772 T:83772 P:35924 I:35959 E18612'
G[35948]='FH L15 A:100113590 T:76688 P:35149+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[35950]='L10 T:35451 E18546'
G[35951]='L0 T:80379 E18546'
G[35952]='L0 E18546'
G[35953]='L0 E18546'
G[35954]='L0 T:86934 E18546'
G[35955]='L0 E18546'
G[35956]='L1 E18546'
G[35957]='L10 T:74790 E18546'
G[35958]='L10 E18546'
G[35959]='FA L30 N40 A:83773 T:83773 P:35926 I:35947 E18612'
G[35960]='L10 T:77734 E18546'
G[35961]='L10 T:76266 E18546'
G[35962]='L10 T:76407 E18612'
G[35963]='L40 T:77120 E18612'
G[35964]='L0 T:76668 E18546'
G[35965]='L0 E18546'
G[35966]='L0 E18546'
G[35967]='L0 E18546'
G[35968]='L0 E18546'
G[35969]='SP K131072 L0 A:1233511 T:1233511 E18546'
G[35970]='L40 A:83734 T:83734 P:35945 E18612'
G[35971]='L0 E18546'
G[35972]='L40 A:83734 T:83734 P:35945 E18612'
G[35973]='L40 A:76508 T:76508 P:37511 E18612'
G[35974]='FA K2 L40 A:-581 T:78550 E18716'
G[35975]='SP K131072 L0 A:1233520 T:1233520 P:35049,34992 E18546'
G[35976]='L0 T:83791 E18546'
G[35977]='FH L40 A:83823 T:78999 P:1 E18716'
G[35979]='L0 E18546'
G[35980]='L0 E18546'
G[35981]='SP K131072 L0 A:1233505 T:1233505 P:35049,34992 E18546'
G[35982]='SP K131072 L0 A:1233525 T:1233525 P:35049,34992 E18546'
G[35983]='L0 E18546'
G[35984]='L0 E18546'
G[35985]='FA L40 A:88892 T:83686 P:>09711 E18850 D093'
G[35986]='L0 E18546'
G[35987]='SP K131072 L0 A:1233539 T:1233539 E18546'
G[35988]='K4096 L25188 AA:83858 AH:583858 T:83823 I:39018 E18912 Z22566'	-- OTC:36426
G[35989]='L25188 A:83823 T:83823 P:36157 E18912 Z22566'
G[35990]='L25188 A:83823 T:83823 P:35989 E18912 Z22566'
G[35991]='L25188 A:83823 T:83823 P:35989 E18912 Z22566'
G[35992]='L25188 A:83823 T:83823 P:35989 E18912 Z22566'
G[35993]='K4096 L25188 A:83823 T:83823 P:35990+35991+35992 E18912 Z22566'
G[35994]='K4096 L25188 A:83823 T:83823 P:35993+36158 E18912 Z22566'
G[35995]='K4096 L25188 A:584702 T:584702 P:36206 E18912 Z22566'
G[35996]='L0 E18546'
G[35997]='K4096 L40 A:83823 T:83823 P:36004 E18912'
G[35998]='K4096 L40 A:83823 T:83823 P:36004 E18912'
G[35999]='SP K131072 L0 A:1233549 T:1233549 E18546'
G[36000]='K4096 L25188 A:83823 T:84702 P:35994 E18912 Z22566'
G[36001]='L0 E18546'
G[36002]='SP K131072 L0 A:1233551 T:1233551 E18546'
G[36003]='L0 E18546'
G[36004]='K4096 L40 A:584702 T:83823 P:35995 E18912'
G[36005]='K4096 L40 A:83823 T:83929 P:35998 E19342'
G[36006]='K4096 L40 A:83929 T:83929 P:36005 E19342'
G[36007]='K4096 L40 A:583823 T:83823 P:36006 E19342'
G[36008]='SP K131072 L0 A:1233555 T:1233555 E18546'
G[36009]='K4224 L40 A:83823 T:83823 P:36007 E19342'
G[36010]='K4224 L40 A:83823 T:83823 P:36007 E19342'
G[36011]='SP K131072 L0 A:1233557 T:1233557 P:35049,34992 E18546'
G[36012]='K4224 L40 A:83823 T:83823 P:36007 E19342'
G[36013]='K4224 L40 A:83823 T:83823 P:36007 E19342'
G[36014]='K4224 L40 A:83823 T:83823 P:36009+36010+36012 E19596'	-- TODO: Verify requires 36009 36010
G[36015]='L0 E18546'
G[36016]='K4096 L40 A:83823 T:83823 P:36013+36014 E19906'	-- TODO: Verify requires 36014
G[36017]='K4096 L40 A:83823 T:83823 P:36016 E19890'
G[36018]='K4096 L40 E19906'
G[36019]='SP K131072 L0 A:1233559 T:1233559 P:35049,34992 E18546'
G[36020]='SP K131072 L0 A:1233560 T:1233560 E18546'
G[36021]='SP K131072 L0 A:1233561 T:1233561 E18546'
G[36022]='FH L30 A:83772 T:83772 P:35924 I:36023 E18612'
G[36023]='FA L30 N40 A:83773 T:83773 P:35926 I:36022 E18612'
G[36024]='L40 E18702'
G[36025]='L40 E18716'
G[36026]='L40 E18702'
G[36027]='SP L40 A:77853 T:77853 P:34472 U190 E18702'
G[36028]='FH L30 A:83772 T:83899 P:35947+36022 I:36029 E18612'	-- TODO: verify if both are needed
G[36029]='FA L30 N40 A:83773 T:83900 P:36023+35959 I:36028 E18612'
G[36030]='L40 T:82204 E18702'
G[36031]='L40 E18716'
G[36032]='L40 E18716'
G[36033]='L40 E18833'
G[36034]='L40 E18918'
G[36035]='L0 E18546'
G[36036]='L0 E18546'
G[36037]='SP L15 A:83820 T:83820 U193 E18546'
G[36038]='L40 E19027'
G[36039]='SP K131072 L0 A:1233611 T:1233611 E18546'
G[36040]='L40 E18912'
G[36041]='L40 E18850'
G[36042]='L40 E18702'
G[36046]='SP K131072 L0 A:1233613 T:1233613 E18546'
G[36047]='FH L30 A:83899 T:83903 P:36028 I:36048 E18612'
G[36048]='FA L30 N40 A:83900 T:83904 P:36029 I:36047 E18612'
G[36049]='L0 E18546'
G[36050]='SP K131072 L0 A:1233623 T:1233623 E18546'
G[36051]='L0 T:86946 E18546'
G[36052]='L0 E18546'
G[36053]='L0 E18546'
G[36054]='SP K2 L40 A:87391 T:87391 E18612'
G[36055]='SP K2 L40 A:87391 T:87391 E18612'
G[36056]='SP K2 L40 A:87391 T:87391 E18612'
G[36057]='SP K2 L40 A:87391 T:87391 E18612'
G[36058]='L0 T:80964 E18612'
G[36059]='L30 N40 A:80153 T:84122 P:35895 E18702'
G[36060]='L0 E19027'
G[36061]='L0 E19890'
G[36062]='SP L30 A:82468 T:82468 P:35298 U192 E18612'	-- TODO: Can both factions get this?  if so, put both garrisons...
G[36063]='K1 L40 A:83995 T:83995 P:36198 E18645'
G[36064]='K1 L40 T:83995 P:36198 E18702'
G[36065]='K1 L40 P:36198 E18702'
G[36066]='SP K1 L40 A:83997 T:83997 E18702'
G[36067]='SP K1 L40 A:83997 T:83997 E18702'
G[36068]='SP K1 L40 A:83997 T:83997 E18702'
G[36069]='FA L40 A:87992 T:89063 E18612'
G[36070]='FH L40 E18702'
G[36071]='SP K131072 L0 A:1233641 T:1233641 E18546'
G[36072]='SP K131072 L0 A:1233642 T:1233642 E18546'
G[36073]='SP K131072 L0 A:1233645 T:1233645 E18546'
G[36074]='SP K131072 L0 A:1233649 T:1233649 E18546'
G[36075]='FA L15 A:100114018 T:81076 P:35064+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36076]='FH L15 A:100114019 T:76688 P:35149+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18912'
G[36077]='L0 T:86934 E18546'
G[36078]='FA L15 A:100114020 T:81076 P:35064+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36079]='L0 E18546'	-- TODO:	Determine how this was magically completed when wandering SMV before doing quests, but accepting automatically 34575, and having it automatically dropped when leaving area
G[36080]='FH L15 A:100114021 T:76688 P:35149+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36081]='FA L15 A:100114022 T:81076 P:35064+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36082]='SP K131072 L0 A:1233651 T:1233651 E18546'
G[36083]='FH L15 A:100114023 T:76688 P:35149+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18702'
G[36084]='FA L15 A:100114024 T:81076 P:35064+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36085]='L30 N40 A:84276 T:84262 P:35009 E18612'
G[36086]='FH L15 A:100114025 T:76688 P:35149+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18716'
G[36088]='SP K131072 L0 A:1233658 T:1233658 E18546'
G[36089]='L0 E18546'
G[36090]='FA L15 A:100114026 T:81076 P:35064+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36091]='FH L15 A:100114027 T:76688 P:35149+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36092]='FA L15 A:100114029 T:81076 P:35064+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36094]='FH L15 A:100114030 T:76688 P:35149+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36095]='FA L40 E18612'
G[36096]='FA L15 A:100114031 T:81076 P:35064+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36097]='FH L15 A:100114032 T:76688 P:35149+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18702'
G[36098]='FA L15 A:100114033 T:81076 P:35064+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36099]='L0 T:82561 E18546'
G[36100]='fA L10 AP:77209:=09711;577209:=09712;500138:=09713 TP:77209:=09711;577209:=09712;500138:=09713 P:K100109258,K100111812,K100111813,K100111814,K100111815,K100111816,K100111817,K100111818,Z156522,Z161386,Z161387,Z161388,Z161389,Z161390,Z161391,Z161392 I:37667,37669 E18546'
G[36101]='FH L15 A:100114034 T:76688 P:35149+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18912'
G[36102]='L0 T:80056 E18546'
G[36103]='FA L15 A:100114035 T:81076 P:35064+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36104]='FH L15 A:100114036 T:76688 P:35149+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36105]='FA L15 A:100114037 T:81076 P:35064+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36106]='FH L15 A:100114038 T:76688 P:35149+I164221|I164012|I164107|I164420|I164213|I163869|I164415|I164151|I164123|I164407|I164139 E18546'
G[36107]='FA L15 T:81076 E19342'
G[36108]='FH L15 E19342'
G[36109]='SP K131072 L0 A:1233715 T:1233715 P:K100114054 E18546'
G[36111]='L0 T:90851 E18546'
G[36112]='L0 T:90851 E18546'
G[36113]='L0 E18612'
G[36115]='SP K131072 L0 A:1233768 T:1233768 E18546'
G[36116]='SP K131072 L0 A:1233773 T:1233773 E18546'
G[36117]='FH L40 A:588892 T:83686 P:>09761 E18912 D098'
G[36118]='L0 E18546'
G[36119]='FA L100 A:-100588 T:84173 E18546'
G[36123]='FA L100 A:82909 T:82909 E18546'
G[36124]='L0 E18546'
G[36125]='FA L100 A:82909 T:82909 E18546'	-- TODO: Make available once the specific requirement to talk to Chris Clarkie in quest 36130 is satisfied
G[36127]='FA L100 A:82901 T:82901 E18546'	-- TODO: Make available once the specific requirement to talk to Farseer Kylanda in quest 36130 is satisfied
G[36128]='L0 T:80057 E18546'
G[36129]='L0 E18546'
G[36130]='FA L100 A:84173 T:84173 E18546'
G[36131]='L20 A:79896 T:79896 P:36141 I:36201 E18546'
G[36132]='L20 A:79896 T:79892 P:36131 I:36202 E18546'
G[36133]='FA L100 A:84223 T:82966 E18612'
G[36134]='FA L40 A:81492 T:84145 P:36162 E19445'
G[36135]='L0 E18546'
G[36136]='FH L40 A:578487 T:88530 P:36248 E19445'
G[36137]='L10 A:84247 T:84247 P:G-040 E18546'	-- for the Horde boost to 100, not available until Tanaan output founded, so P:37935 needs to be added.  how to detect boosted?
G[36138]='L10 A:84247 T:84247 P:36137+G-040 E18546'
G[36139]='L10 E18546'
G[36140]='L1 E18546'
G[36141]='L20 A:79896 T:79896 P:34758 I:36199 E18546'
G[36142]='L10 A:84247 T:84247 P:36138+G-041 E18612'
G[36143]='L10 E18546'
G[36144]='L15 E18546'
G[36145]='L30 E18546'
G[36146]='L1 E18546'
G[36147]='L10 E18546'
G[36148]='L1 E18546'
G[36149]='L10 E18546'
G[36150]='L15 E18546'
G[36151]='L30 E18546'
G[36152]='L1 E18546'
G[36153]='L0 T:94472 E18612'
G[36154]='L0 E18612'
G[36155]='L0 E18612'
G[36157]='K4096 L25188 A:83823 T:83823 P:35988 E18912 Z22566'
G[36158]='K4096 L25188 A:83823 T:83823 P:35989 E18912 Z22566'
G[36159]='L0 T:84263 E18546'
G[36160]='FA L40 AP:77209:=09711;577209:=09712;500138:=09713 T:84270 P:34410 E19533'
G[36161]='FA L40 A:84684 T:84511 P:36160 E19533'
G[36162]='FA L40 A:84511 T:84268 P:36161 E19533'
G[36163]='FA L40 A:82776 T:500160 P:>09711 E18912 D093'
G[36164]='FA L40 A:500161 T:84973 P:36163 E18912'
G[36165]='FA L30 N40 A:83904 T:84261 P:36048 I:36166 E18612'
G[36166]='FH L30 A:83903 T:84259 P:36047 I:36165 E18612'
G[36167]='FA L40 A:500162 T:84975 P:36163 E18912'
G[36168]='FA L40 A:500163 T:84974 P:36163 E18912'
G[36169]='FA L40 A:84974 T:84974 P:36164+36167+36168 E18912'	-- TODO: Verify requires 36167 36168
G[36170]='L0 E18546'
G[36171]='FA L40 A:578564 T:578564,-971 E19342 D143'
G[36172]='L0 E18612'
G[36174]='L0 T:84347 E18546'
G[36176]='L10 A:100114877 T:84385 P:PL001+E34019 E18546'
G[36177]='L10 A:84385 T:84385 P:36176 E18546'
G[36178]='L0 T:84406 E18546'
G[36179]='L30 N40 A:85062 T:81128 E18612'
G[36182]='L10 A:84247 T:84247 P:G0138 E18716'
G[36183]='FH L30 N40 A:82278 T:82375 P:35407+35408 E18612'	--very likely both quests required
G[36184]='L0 E18546'
G[36185]='L10 A:84385 T:84492 P:36177 E18702'
G[36186]='L0 T:84431 E18546'
G[36188]='L0 E18546'
G[36189]='L10 AP:84248:G-040025;584248:G-040022 TP:84248:G-040025;584248:G-040022 P:G-040 E18546'
G[36192]='L10 AP:84248:G-040025;584248:G-040022 TP:84248:G-040025;584248:G-040022 P:36189+G-040 E18546'
G[36193]='FA L40 A:84459 T:84459 P:0 E18912'
G[36194]='L10 AP:84248:G-040025;584248:G-040022 TP:84248:G-040025;584248:G-040022 P:36189+G-041 E18612'
G[36195]='L10 AP:84248:G-040025;584248:G-040022 TP:84248:G-040025;584248:G-040022 P:G0138 E18716'
G[36196]='FH L100 T:84473 E18546'	-- TODO: Autoaccept entering Ashran combat zone
G[36197]='FH L100 A:84473 T:84473 P:36196 E18546'
G[36198]='FH L100 A:88448 T:83995 E18546'
G[36199]='L20 A:84372 T:84372 P:34194 I:36141 E18546'
G[36201]='L20 A:84372 T:84372 P:36199 I:36131 E18546'
G[36202]='L20 A:84372 T:77733 P:36201 I:36132 E18546'
G[36203]='L0 T:81548 E18546'
G[36204]='L0 T:80868 E18546'
G[36205]='L10 A:100114965 T:78989 P:PB001 E18546'
G[36206]='K4096 L25188 A:84702 T:584702 P:36000 E18912 Z22566'
G[36207]='L10 A:78989 T:84494 P:36205 E18612'
G[36208]='FA L15 A:500159 T:500159 P:36508 E18546'
G[36209]='FA L15 A:500159 T:500159 P:36208+36210+35925 E18546'	-- TODO: Verify requires 36208
G[36210]='FA L15 A:500159 T:500159 P:36508 E18546'
G[36211]='L0 E18546'
G[36212]='L0 E18546'
G[36213]='L0 E18546'
G[36214]='L0 E18546'
G[36219]='L40 AP:1234243:FA+=09712;500147:FA+=09713;500247:FH T:84637 P:X34666+X36566+>09711|>09761 I:36280,36281,36282 E18612 D093 D098'
G[36220]='L40 A:84637 T:84720 P:36219,36280,36281,36282 E18612'
G[36221]='L40 A:84720 T:84784 P:36220 E18612'
G[36222]='L40 A:84784 T:84784 P:36221 E18612'
G[36223]='FA L15 A:500159 T:84131 P:36209 E18546'
G[36226]='FH L100 A:84660 T:84660 E18612'
G[36227]='FH L100 A:83869 T:83869 E18612'
G[36228]='FH L100 A:83869 T:83869 P:36227 E18702'
G[36229]='L0 T:84435 E18546'
G[36230]='L10 A:84494 T:84494 P:36207 E18612'
G[36236]='L10 A:100114972 T:84776 P:PT001+E34019 E18546'
G[36238]='L10 A:84494 T:78989 P:36230 E18612'
G[36239]='L10 A:100114984 T:84724 P:PI001+E34019 E18546'
G[36240]='L10 A:84724 T:84724 P:36239 E18702'
G[36241]='L10 A:84724 T:84728 P:36240 E18716'
G[36242]='FH L40 A:-100587 T:579740 P:36261 E19533'
G[36243]='L0 T:-542 E18546'
G[36244]='SP K131072 L0 A:1234154 T:1234154 P:PX200 E18546'	-- TODO: Yoshimo: verify
G[36245]='L0 P:PX200 E18546'	-- TODO: Yoshimo: verify
G[36246]='SP K131072 L0 A:1234157 T:1234157 E18546'
G[36247]='SP K131072 L0 A:1234159 T:1234159 E18546'
G[36248]='L40 A:579740 T:579740 P:36242 E19533'	-- A Strike at the Heart, the Warlord Council completed
G[36249]='L0 E18546'
G[36250]='L0 E18546'
G[36251]='L0 E18546'
G[36252]='L0 E18546'
G[36254]='L0 E18546'
G[36255]='L10 A:100115008 T:83482 P:PE001 E18546'
G[36256]='L10 A:83482 T:84739 P:36255 E18612'
G[36257]='L10 A:84739 T:84747 P:36256 E18612'
G[36260]='L10 A:84747 T:84739 P:36257 E18612'
G[36261]='FH L40 A:579740 T:-100587 P:34341 E19533'
G[36262]='L10 A:84776 T:84523 P:36236 E18612'
G[36263]='L0 E18546'
G[36265]='L0 T:84805 E18546'
G[36266]='L10 A:84523 T:84523 P:36262 E18612'
G[36267]='L0 T:84807 E18546'
G[36268]='L0 E18546'
G[36269]='L10 A:84523 T:84523 P:36266 E18702'
G[36271]='FA L10 AP:84524:G-024022;584524:G-024025 TP:84524:G-024022;584524:G-024025 P:G-024 E18612'
G[36272]='FA L15 AP:84524:G-024022;584524:G-024025 TP:84524:G-024022;584524:G-024025 P:G-025 E18702'
G[36273]='L35 N46 A:84632 T:84632 E18612'	-- no known prequest
G[36274]='FA L35 AP:84524:G-024022;584524:G-024025 TP:84524:G-024022;584524:G-024025 P:G0133 E18833'
G[36275]='L35 N54 A:84861 T:84861 P:35146 E18612'
G[36276]='L0 E18546'
G[36277]='L10 T:84554 E18612'
G[36278]='L0 T:84836 E18546'
G[36279]='L0 T:84838 E18546'
G[36280]='L40 AP:1234243:FA+=09712;500147:FA+=09713;500247:FH T:84637 P:34666+X36566+>09711|>09761 I:36219,36281,36282 E18612 D093 D098'
G[36281]='L40 AP:1234243:FA+=09712;500147:FA+=09713;500247:FH T:84637 P:X34666+36566+>09711|>09761 I:36219,36280,36282 E18612 D093 D098'
G[36282]='L40 AP:1234243:FA+=09712;500147:FA+=09713;500247:FH T:84637 P:34666+36566+>09711|>09761 I:36219,36280,36281 E18612 D093 D098'
G[36283]='L0 E18546'
G[36284]='L35 N54 A:84861 T:84861 P:35146 E18612'
G[36285]='L35 N54 A:84861 T:84861 P:36275+36284 E18612'
G[36286]='L10 A:100115278 T:84825 P:PN001+E34019 E18546'
G[36287]='L10 A:84825 T:84825 P:36286 E18612'
G[36288]='L0 E18546'
G[36289]='FA L40 A:84784 T:81492 P:36222 I:36290 E18612'	-- I: confirmed by WoW-API
G[36290]='FH L40 A:84784 T:78487 P:36222 I:36289 E18612'	-- I: confirmed by WoW-API
G[36291]='L0 E18546'
G[36292]='FH L10 A:82851 T:84928 P:35744+35748+i176111 I:36307 E18612'
G[36293]='L0 E19342'
G[36294]='L10 T:79703 E18546'
G[36295]='L10 T:94399 E18546'
G[36296]='L10 T:84892 E18716'
G[36297]='L0 T:84890 E18546'
G[36298]='L0 E18546'
G[36301]='L10 A:100114973 T:84689 P:PT001 E18546'
G[36303]='L0 E18546'
G[36304]='L0 E18546'
G[36305]='L0 T:84951 E18546'
G[36306]='L0 E18546'
G[36307]='FA L10 A:82270 T:84929 P:35463+35464+i176111 I:36292 E18612'	-- TODO: Verify needs 35463
G[36308]='L10 A:100115281 T:83491 P:PE001+E34019 E18546'
G[36309]='L10 A:100115343 T:80827 P:PB001+E34019 E18546'
G[36310]='L10 A:83491 T:84966 P:36308 E18612'
G[36311]='L10 A:80827 T:80827 P:36309 E18612'
G[36312]='L0 E18546'
G[36313]='L10 A:84966 T:84963 P:36310 E18645'
G[36314]='L10 A:100115287 T:84967 P:PJ001 E18546'
G[36315]='L10 A:84963 T:84966 P:36313 E18645'
G[36316]='K64 L30 N40 A:500145 T:500145 P:35704 E18612'
G[36317]='L0 E18546'
G[36318]='L0 E18546'
G[36319]='L0 E18546'
G[36320]='L0 E18546'
G[36321]='L0 E18546'
G[36322]='L0 E18546'
G[36323]='L0 E18546'
G[36324]='L0 E18546'
G[36325]='L0 E18546'
G[36326]='L0 E18546'
G[36327]='L0 E18546'
G[36328]='L0 E18546'
G[36329]='L0 E18546'
G[36330]='L0 E18546'
G[36331]='L0 E18546'
G[36332]='L0 E18546'
G[36333]='L0 E18546'
G[36334]='L0 E18546'
G[36335]='L0 E18546'
G[36336]='L0 E18546'
G[36337]='L0 E18546'
G[36338]='FH K2 L40 A:79892 E18612'
G[36340]='SP K131072 L0 A:1234432 T:1234432 E18546'
G[36341]='FA L40 A:84185 T:84268 P:36134 U217 E19533'
G[36342]='FH L40 A:88530 T:579740 P:36136 U217 E19533'
G[36343]='L0 E18612'
G[36344]='FH L15 AP:85048:G-024022;585048:G-024025 TP:85048:G-024022;585048:G-024025 P:G-025 E18663'
G[36345]='FH L10 AP:85048:G-024022;585048:G-024025 TP:85048:G-024022;585048:G-024025 P:G-024 E18612'
G[36346]='FH L35 AP:85048:G-024022;585048:G-024025 TP:85048:G-024022;585048:G-024025 P:G0133 E18833'
G[36347]='FH L40 E18716'
G[36348]='FA L40 A:84784 P:0 E18702'
G[36352]='L10 A:84967 T:85106 P:36314 E18612'
G[36353]='SP FA L30 A:85080 T:85080 P:35482+36797|36793 I:36864 U204 E18612'
G[36354]='L0 P:PX200 E18546'	-- TODO: Yoshimo: verify 
G[36355]='SP K131072 L0 A:1234449 T:1234449 P:PX200 E18546'	-- TODO: Yoshimo: requires archaeology 200+
G[36356]='L0 P:PX200 E18546'	-- TODO: Yoshimo: verify 
G[36358]='L0 P:PX200 E18546'	-- TODO: Yoshimo: verify 
G[36359]='SP K131072 L0 A:1234454 T:1234454 P:PX200 E18546'	-- TODO: Yoshimo: verify 
G[36360]='SP K131072 L0 A:1234455 T:1234455 P:PX200 E18546'	-- TODO: Yoshimo: requires archaeology 200+
G[36361]='SP K131072 L0 A:1234456 T:1234456 E18546'
G[36362]='SP K131072 L0 A:1234458 T:1234458 E18546'
G[36363]='L0 E18546'
G[36364]='SP K131072 L0 A:1234461 T:1234461 E18546'
G[36365]='SP K131072 L0 A:1234471 T:1234471 E18546'
G[36366]='SP K131072 L0 A:1234472 T:1234472 E18546'
G[36367]='SP K131072 L0 A:1234473 T:1234473 E18546'
G[36368]='L15 A:82575 T:82569 P:35708 I:35505 E18546'	-- OTC:35653
G[36374]='L0 E18546'
G[36375]='SP K131072 L0 A:85190 T:85190 E18546'
G[36376]='L40 A:578564 T:578564,-971 E19612 D143'
G[36377]='SP K131072 L0 A:85206 T:85206 E18546'
G[36378]='L10 A:85106 T:85106 P:36352 E18645'
G[36379]='FA L10 A:85213 T:85213 P:35884|37196+i176111 I:37677,36382 E18612'
G[36380]='L10 A:85106 T:85106 P:36378 E18612'
G[36381]='SP K131072 L0 A:1234618 T:1234618 P:I170183 E18546'
G[36382]='FH L10 A:85247 T:85247 P:34446|37190+i176111 E18612'
G[36383]='FA K2 L40 A:-539 T:85124 E19116'
G[36384]='L30 N40 A:81443 T:81443 P:35285 E18612'
G[36385]='L10 A:100115467 TA:84248 TH:84247 P:0 E18612'	--TODO: still in game? does it require conditions?
G[36386]='L0 E18546'
G[36387]='L0 E18546'
G[36388]='SP K131072 L0 A:3234618 T:3234618 P:I170183 E18546'
G[36389]='L0 T:79598 E18546'
G[36390]='L0 E18546'
G[36391]='L0 T:81038 E18546'
G[36392]='L0 E18546'
G[36393]='L0 E18546'
G[36394]='L0 E18546'
G[36395]='SP K131072 L0 A:1234703 T:1234703 E18546'
G[36396]='L0 T:84417 E18546'
G[36397]='SP K131072 L0 A:1234704 T:1234704 E18546'
G[36398]='SP K131072 L0 A:1234705 T:1234705 E18546'
G[36399]='SP K131072 L0 A:1234734 T:1234734 E18546'
G[36400]='SP K131072 L0 A:1234735 T:1234735 E18546'
G[36401]='SP K131072 L0 A:1234736 T:1234736 E18546'
G[36402]='SP K131072 L0 A:1234740 T:1234740 E18546'
G[36403]='SP K131072 L0 A:1234744 T:1234744 E18546'
G[36404]='L30 A:85344 T:85344 P:>05811 I:34193 E18546'
G[36405]='SP K131072 L0 A:1234746 T:1234746 E18546'
G[36406]='SP K131072 L0 A:1234748 T:1234748 E18546'
G[36407]='SP K131072 L0 A:1235073 T:1235073 E18546'
G[36408]='L10 A:100115507 T:84830 P:PJ001+E34019 E18546'
G[36409]='L10 A:84830 T:84830 P:36408 E18702'
G[36410]='SP K131072 L0 A:1235090 T:1235090 E18546'
G[36411]='SP K131072 L0 A:1235091 T:1235091 E18546'
G[36412]='FA L40 A:578564 T:578564,-971 E19342 D143'
G[36413]='L0 E18546'
G[36414]='FH L40 A:79774 T:79774,-976 E19342 D144'
G[36415]='L0 E18546'
G[36416]='SP K131072 L0 A:1235095 T:1235095 P:PX200 E18546'	-- TODO: Yoshimo: verify
G[36417]='L10 A:84689 T:84689 P:36301 E18612'
G[36418]='SP K131072 L0 A:1235097 T:1235097 E18546'
G[36419]='L10 A:84689 T:84689 P:36417 E18612'
G[36420]='SP K131072 L0 A:1235103 T:1235103 E18546'
G[36421]='SP K131072 L0 A:1235104 T:1235104 E18546'
G[36422]='SP K131072 L0 A:1235105 T:1235105 P:PX200 E18546'	-- TODO: Yoshimo: verify
G[36423]='K16384 L35 A:85418 T:85418 P:>05812 E18612'
G[36424]='L0 E18546'
G[36425]='L30 N40 A:85425 T:-542 P:34827 E18612'
G[36426]='L0 T:700081 E18546'
G[36427]='SP L10 A:85379 T:85379 P:G-040+36793+0 U195 E18612'	--Yoshimo couldn't find him there
G[36428]='L30 N40 A:81443 T:81443 P:35089+35090+36384 E18612'	-- TODO: Verify requires 35090
G[36429]='SP L10 A:85378 T:85378 P:G-040+36797 U195 E18546'
G[36430]='L0 E18546'
G[36431]='L0 E18546'
G[36432]='FA L15 A:75146 AP:500136:35049;500137:35064 T:85426 P:35063 E18546'
G[36433]='SP K131072 L0 A:1235135 T:1235135 P:PX200 E18546'	-- TODO: Yoshimo: verify
G[36434]='L15 A:574594 T:85147 P:33593 E18566'
G[36435]='L10 A:100115593 T:85439 P:PI001 E18546'
G[36436]='FA L15 A:85426 T:85432 E18546'
G[36437]='FA L15 A:85426 T:85432 O:36432 E18546'
G[36438]='FA L15 A:85432 T:85431 P:36436+36437+35064 E18546'	-- TODO: Verify requires 36437--I:33662
G[36439]='FA L15 A:85432 T:85431 P:36436+36437+35049 E18546'	-- TODO: Verify requires 36437
G[36440]='FA L15 AP:85431:35064;585431:35049 T:85436 P:36438,36439 E18546'
G[36441]='FA L15 AP:1234474:35064;500257:35049 T:85436 P:36438,36439 E18546'	-- TODO: note that when this was complete before 36440 was also complete, it appeared in the world that it could be turned in to T:85431 (at least for the Sparring Arena path), but once both complete, NPC moved
G[36442]='FA L15 A:85436 T:82302 P:36440 E18546'
G[36443]='FA L15 A:82302 T:82302 P:36442 E18546'
G[36444]='SP K131072 L0 A:1235141 T:1235141 E18546'
G[36445]='SP K131072 L0 A:1235143 T:1235143 E18546'
G[36446]='SP K131072 L0 A:1235168 T:1235168 E18546'
G[36447]='SP K131072 L0 A:1235172 T:1235172 E18546'
G[36448]='L10 AP:85413:G-040025;585413:G-040022 TP:85413:G-040025;585413:G-040022 P:36429+G-040 E18546'
G[36449]='L10 AP:85414:G-040025;585414:G-040022 TP:85414:G-040025;585414:G-040022 P:36427+G-040 E18546'
G[36450]='SP K131072 L0 A:1235282 T:1235282 E18546'
G[36451]='SP K131072 L0 A:1235289 T:1235289 E18546'
G[36452]='L1 E18546'
G[36453]='SP K131072 L0 A:1235299 T:1235299 E18546'
G[36454]='SP K131072 L0 A:1235300 T:1235300 E18546'
G[36455]='SP K131072 L0 A:1235307 T:1235307 E18546'
G[36456]='SP K131072 L0 A:1235310 T:1235310 E18546'
G[36457]='L10 A:85439 T:85440 P:36435 E18612'
G[36458]='SP K131072 L0 A:1235313 T:1235313 E18546'
G[36459]='L0 E18546'
G[36460]='L15 A:85147 T:500132 P:36434 E18566'
G[36461]='L0 E19596'
G[36462]='SP K131072 L0 A:1235365 T:1235365 P:K100116120 E18546'
G[36463]='L0 E18546'
G[36464]='L0 E18546'	-- completes when you use the treasure map for Shadowmoon Valley
G[36465]='L0 E18546'	-- completes when you use the treasure map for Gorgrond (FA definitely)
G[36466]='L0 E18546'	-- Talador treasure map
G[36467]='L0 E18546'	-- completes when you use the treasure map for spires of arak (FA definitely)
G[36468]='L0 E18546'	-- completes when you use the treasure map for Nagrand
G[36469]='L35 A:79858 P:38242 E18612'
G[36470]='L0 E18546'
G[36471]='K8194 L1 A:85519 T:85519 E18546'
G[36472]='SP K65536 L0 A:85520 T:85520 E18546'
G[36473]='K32768 L15 A:-110543 T:-543 P:35049,34992 E18546'
G[36474]='FH L15 A:500133 T:74593 P:35151+34992 I:35149 E18546'
G[36475]='L10 A:85440 T:85440 P:36457 E18716'
G[36476]='K32768 L15 A:-100543 T:-543 P:35049,34992 E18546'
G[36477]='L40 E18612'
G[36478]='L0 E18546'
G[36479]='L0 E18546'
G[36480]='K32768 L15 A:-130543 T:-543 E18546'
G[36481]='K2 L7864576 A:85546 T:85546 E18546'
G[36482]='FH L15 A:82274 T:82274 P:35430 I:36523 E18546'
G[36483]='L1 A:85418 T:86144 P:0 E18612'	-- TODO: Yoshimo: requires at least the garrison being build
G[36488]='FH L15 A:82228 T:85601 P:35434+35433 E18546'
G[36489]='FH L40 A:75593 T:86499 P:1 E18702'
G[36490]='FA K2 L40 A:88026 T:85043 E18702'
G[36491]='FH L40 E18702'
G[36492]='L0 T:90071 E18546'
G[36493]='L0 T:81858 E18546'
G[36494]='FH L20 A:74594 T:78487 O:36573,36574 E18546'	-- TODO: This can also be accepted from 574594, 500132 and 500133	-- changed P:36573,36574 to O: because Horde boost to 100 gets this
G[36495]='FA L20 N46 A:75127 T:81492 E18546'	-- Blizzard gives this out even if you do not have a garrison.  And Blizzard marks the map with a yellow ? even if you do not have a garrison, course with no NPC present.
G[36496]='L0 E19342'
G[36497]='L0 E19533'
G[36498]='FA L10 A:1206111,1206294,1207320,1207321,1207322,1208316 T:82270 E18546'	-- TODO: Add the ability for this quest to be automatically accepted when attaining level 90, no matter where one is.
G[36499]='FH L10 A:1206109,1206116,1207279,1207323,1207324,1207325,1208317 T:82851 E18546'	-- same comment from 36498
G[36500]='K32768 L15 A:82302 T:-543 P:35064,35149 E18566'
G[36501]='L0 T:72761 E18546'
G[36502]='FA L15 A:100116159 T:75127 P:35063 E18546'
G[36503]='FH L15 A:100116159 T:74594 P:35151 E18546'
G[36504]='K32768 L15 A:85418 T:-543 P:35064,35149 E18546'
G[36505]='L10 A:100116173 T:85751 P:PL001 E18546'
G[36506]='L0 T:81729 E18546'
G[36507]='SP K131072 L0 A:1235860 T:1235860 E18546'
G[36508]='FA L15 A:83569 T:500159 P:35730+E35870|E35026 I:35036 E18546'
G[36509]='L0 T:86934 E18546'
G[36510]='FA K2 L10 A:77733 T:77733 P:36202 E18612 D095'
G[36511]='FA K2 L10 A:77733 T:77733 P:36202 E19027 D095'
G[36512]='SP L20 A:79434 T:79434 P:34154+36797,34564+36793 U205 E18612'
G[36513]='FA K2 L10 A:77733 T:77733 P:36202 E18612 D095'
G[36514]='FA K2 L10 A:77733 T:77733 P:36202 E18612 D095'
G[36515]='FA K2 L10 A:77733 T:77733 P:36202 E18612 D095'
G[36516]='FH L10 A:85751 T:85751 P:36505 E18612'
G[36517]='FA K2 L10 A:77733 T:77733 P:36202 E18612 D095'
G[36518]='SP FH L20 A:79979 T:79979 P:34776+36793 I:36519 U207 E18612'
G[36519]='SP FA L20 A:79979 T:79979 P:34777+36797 I:36518 U207 E18546'
G[36520]='K32768 L15 A:-180543 T:-543 E18546'
G[36521]='L0 E18546'
G[36522]='SP L20 AP:585777:=09711;85777:=09712 TP:585777:=09711;85777:=09712 P:33973+36797 U208 E18663'
G[36523]='FA L15 A:81600 T:81601 P:35208 I:36482 E18546'
G[36524]='L0 E18546'
G[36525]='L0 E18546'
G[36526]='L0 E18546'
G[36527]='L0 T:88674 E18546'
G[36528]='L0 E18546'
G[36529]='L0 T:92766 E18546'
G[36530]='L0 E18546'
G[36531]='L0 E18546'
G[36532]='L0 T:-539 E18546'
G[36533]='L0 T:92819 E18546'
G[36534]='L0 E18546'
G[36535]='L0 E18546'
G[36536]='L0 E18546'
G[36537]='FA K2 L100 A:1236206 T:500220 E18546 D109'
G[36538]='L0 E18546'
G[36539]='L0 T:86144 E18546'
G[36540]='L0 E18546'
G[36541]='L0 E18546'
G[36542]='L0 E18546'
G[36543]='L0 E18546'
G[36544]='L0 E18546'
G[36545]='L0 T:-539 E18546'
G[36546]='L0 E18546'
G[36547]='L0 E18546'
G[36548]='L0 E18546'
G[36549]='L0 T:88674 E18546'
G[36550]='L0 E18546'
G[36551]='L0 T:92766 E18546'
G[36552]='L0 T:92819 E18546'
G[36553]='L0 E18546'
G[36554]='L0 E18546'
G[36555]='L0 E18546'
G[36556]='FA K2 L100 A:1236206 T:500220 E18546 D109'
G[36557]='L0 T:86144 E18546'
G[36558]='L0 E18546'
G[36559]='L0 E18546'
G[36560]='L0 T:90309 E18546'
G[36561]='L0 T:90309 E18546'
G[36563]='K32768 L15 A:-110543 T:-543 E18546'
G[36564]='K32768 L15 A:81241 T:-543 P:35064,35149 E18546'
G[36566]='K32768 L15 A:-170543 T:-543 P:35049,34992 E18546'
G[36567]='FH L10 A:78466 T:500154 P:L093 I:36592,Y9545 E18566'	-- TODO: reported should be P:32795
G[36568]='L0 E18546'
G[36569]='L0 T:90071 E18546'
G[36570]='L0 T:90071 E20444'
G[36571]='K32768 L15 A:-160543 T:-543 E18546'
G[36572]='L0 E19533'
G[36573]='FH L15 A:74594 T:74594 P:35152+35136 E18663'
G[36574]='FH L15 A:500133 T:500133 P:35416+35506+35508+35527+35524 E18663'
G[36575]='FA L15 A:75127 T:75127 P:35255+35652+35654+35651+35650 E18702'
G[36576]='FA L15 A:75127 T:75127 P:35702+35137 E18702'
G[36577]='L0 E18546'
G[36587]='L1 T:72761 E18546'
G[36588]='L1 E18546'
G[36589]='L10 A:100116438 T:85882 P:PN001 E18612'
G[36590]='K32768 L30 A:-140542 T:-542 E18612'	-- OTC:36859
G[36592]='FA L10 A:77209 T:577209 P:33814,L093 I:36567,Y9100 E18612'	-- TODO: reported should be P:33586
G[36593]='L0 E19027'
G[36594]='L10 A:85882 T:85882 P:36589 E18612'
G[36595]='FA L15 A:75146 T:75136 P:E35065 I:35828 E18612'	-- TODO: This is available after NPC 75146 has moved to the spot near the tank...guessing when quest complete, but not turned in
G[36596]='L0 T:81548 E18612'
G[36597]='L0 T:85907 E18612'
G[36600]='L0 E18612'
G[36601]='FA L30 N40 A:580153 T:81492 I:36606 E18612'	-- seems 36602 and 36607 marked complete as well
G[36602]='FH L30 N40 A:80153 T:78487 P:1 E18612'
G[36603]='K32768 L15 A:-120543 T:-543 E18612'
G[36604]='L0 E18612'
G[36605]='L0 E18612'
G[36606]='FA L30 A:81929 T:81492 I:36601 E18612'
G[36607]='FH L30 A:81920 T:78487 E18612'
G[36608]='L20 AA:85708 AH:79971 T:63721 P:36870,36612 E18716'
G[36609]='FH L20 A:63721 T:79971 P:36608 E19342'
G[36610]='L0 T:81548 E18612'
G[36611]='L20 AA:85984 AH:585984 TA:85984 TH:585984 P:36882,36609 E18716'	-- TODO: Make the Alliance/Horde separation for Nat
G[36612]='FH L20 A:79971 T:79971 P:PF700+G0135 E19027'
G[36614]='FH L40 A:78466 T:78466 I:36615 E18612'
G[36615]='FA L40 A:577209 T:500138 P:36592 I:36614 E18612'	-- TODO: available entering garrison at level 100
G[36616]='SP L20 AA:85984 AH:585984 TA:85984 TH:585984 P:36611+36797|36793 U202 E18716'
G[36617]='SP HZ L7866880 A:1187236 T:1187236 E18612'
G[36618]='L0 T:84503 E18612'
G[36619]='L0 E19027'
G[36620]='L0 E18612'
G[36621]='L0 E18612'
G[36623]='FH L40 A:79774 T:79774,-976 E19342 D144'
G[36624]='L10 A:79953 T:86065 P:34692 E18612'
G[36625]='SP K131072 L0 A:1236141 T:1236141 E18612'
G[36626]='FA L10 A:86065 T:86069 P:36624 I:36707 E18612'
G[36627]='L10 A:85882 T:85882 P:36594 E18612'
G[36628]='L0 E18612'
G[36629]='FA L10 A:86069 T:86069 P:36626 I:36708 E18612'
G[36630]='FA L10 A:86069 T:86084 P:36629 I:36709 E18612'
G[36631]='L0 E18612'
G[36632]='L15 E18702'
G[36633]='SP FA L10 A:86084 T:86084 P:36630+36797 U216 E18612'
G[36634]='L0 T:81548 E18612'
G[36635]='L0 E18612'
G[36636]='L0 E18612'
G[36639]='L0 E19890'
G[36640]='L0 E18612'
G[36641]='L10 AP:77363:G-076018;577363:G-076019;500218:G-076020 TP:77791:G-076018;577791:G-076019;500219:G-076020 P:G-076 E18612'
G[36642]='L10 AP:77383:G-090018;577383:G-090019;500139:G-090020 TP:78207:G-090018;578207:G-090019;500140:G-090020 P:G-090 I:37574 E18612'
G[36643]='L10 AP:77382:G-094018;577382:G-094019;500223:G-094020 TP:77778:G-094018;577778:G-094019;500224:G-094020 P:G-094 E18612'
G[36644]='L10 AP:77356:G-096018;577356:G-096019;500157:G-096020 TP:77775:G-096018;577775:G-096019;500158:G-096020 P:G-096 E18612'
G[36645]='L10 AP:77354:G-093018;577354:G-093019;500155:G-093020 TP:77781:G-093018;577781:G-093019;500156:G-093020 P:G-093 I:37570 E18612'
G[36646]='L10 AP:77365:G-091018;577365:G-091019;500141:G-091020 TP:77831:G-091018;577831:G-091019;500142:G-091020 P:G-091 E18612'
G[36647]='L10 AP:77372:G-095018;577372:G-095019;500148:G-095020 TP:77777:G-095018;577777:G-095019;500149:G-095020 P:G-095 E18612'
G[36648]='K2 L40 A:1236206 T:500220 E18612 D109'
G[36649]='K2 L40 A:1236206 T:500220 E18612 D109'
G[36650]='FA L40 A:578564 T:578564,-971 E19342 D143'
G[36651]='L0 T:80868 E18612'
G[36653]='FH L40 A:79774 T:79774,-976 E19342 D144'
G[36654]='L0 T:86134 E18612'
G[36655]='FA L40 A:578564 T:578564,-971 E19342 D143'	-- the A: can be 78564 for garrison level < 3 as well
G[36656]='L0 E18612'
G[36657]='L0 T:-542 E18612'
G[36658]='L0 T:81575 E18612'
G[36659]='L0 E18702'
G[36660]='K32768 L30 A:84122 T:85892 E18612'
G[36661]='L0 E19533'
G[36662]='L1 A:79858 T:79858 P:0 E18612'
G[36663]='L0 E18612'
G[36664]='L0 T:90309 E18612'
G[36665]='L0 E18612'
G[36666]='L0 E18612'
G[36667]='L40 A:79892 T:78495 E18612'
G[36669]='L40 A:88026 T:78495 E18612'
G[36670]='L100 E18612'
G[36671]='L100 E18612'
G[36672]='L100 E18716'
G[36673]='L100 E18702'
G[36674]='K2 L40 A:1236206 T:500220 E18612 D109'
G[36675]='K2 L40 A:1236206 T:500220 E18612 D109'
G[36676]='K2 L40 A:1236206 T:500220 E18612 D109'
G[36677]='K2 L40 A:1236206 T:500220 E18612 D109'
G[36678]='K2 L40 A:1236206 T:500220 E18612 D109'
G[36679]='K2 L40 A:1236206 T:500220 E18612 D109'
G[36680]='K2 L40 A:1236206 T:500220 E18612 D109'
G[36681]='L40 T:92819 E18612'
G[36682]='K2 L40 A:1236206 T:500220 P:>09711 E18612 D109'
G[36683]='K2 L40 A:1236206 T:500220 E18612 D109'
G[36684]='K2 L40 A:1236206 T:500220 E18612 D109'
G[36685]='K2 L40 A:1236206 T:500220 E18612 D109'
G[36686]='K2 L40 A:1236206 T:500220 P:>09711 E18612 D109'
G[36687]='L40 T:92819 E18612'
G[36688]='L40 T:92819 E18612'
G[36689]='L40 T:92819 E18612'
G[36690]='L40 T:92819 E18612'
G[36691]='L40 A:89793 T:92819 E18612'
G[36692]='L40 T:78495 E18612'
G[36693]='L40 T:78495 E18612'
G[36694]='L40 A:89753 T:92819 E18612'
G[36695]='L40 A:83734 T:78495 P:33661 E18612'
G[36696]='L40 A:91195 T:78495 E18612'
G[36697]='L40 A:78487 T:78495 E18612'
G[36698]='L40 A:91195 T:78495 E18612'
G[36699]='L40 A:79892 T:78495 E18612'
G[36700]='L40 T:92819 E18612'
G[36701]='L40 A:87996 T:78495 E18612'
G[36702]='L40 T:86272 E18716'
G[36705]='L100 E18702'
G[36706]='FH L10 A:78466 T:86315 P:L091+34775 E18612'
G[36707]='FH L10 A:86315 T:86312 P:36706 I:36626 E18612'
G[36708]='FH L10 A:86312 T:86312 P:36707 I:36629 E18612'
G[36709]='FH L10 A:86312 T:81765 P:36708 I:36630 E18612'
G[36710]='L0 T:86934 E18612'
G[36711]='L35 T:82746 U209 E18716'
G[36712]='L0 E18612'
G[36713]='L0 E18612'
G[36714]='L0 E18612'
G[36715]='L0 E18612'
G[36716]='L0 E18612'
G[36717]='L0 E18612'
G[36718]='L0 E18612'
G[36720]='L0 E18612'
G[36721]='L0 T:86934 E18612'
G[36722]='L0 T:86934 E18612'
G[36723]='L0 T:86303 E18612'
G[36724]='L0 E18612'
G[36725]='L40 E18612'
G[36726]='L0 T:81548 E18612'
G[36727]='L0 T:86934 E18612'
G[36728]='L0 E18612'
G[36729]='L0 T:86946 E18612'
G[36730]='L0 T:86934 E18612'
G[36731]='L0 T:86934 E18612'
G[36732]='L0 T:81240 E18612'
G[36733]='L0 T:81548 E18612'
G[36734]='L0 T:81540 E18612'
G[36735]='L0 E18612'
G[36736]='L0 E18612'
G[36737]='L0 T:500132 E18612'
G[36738]='L0 E18612'
G[36739]='L0 E18612'
G[36740]='L0 E18612'
G[36741]='SP FA K1 L40 A:85749 T:85749 P:36133 E18612'
G[36742]='FH K1 L40 A:86366 E18702'
G[36743]='L40 T:-581 E18612'
G[36744]='L40 A:100114146 TP:-110581:FA;-587:FH E18612'
G[36745]='L40 T:-581 E18612'
G[36746]='L40 T:-587 E18612'
G[36747]='L40 E18612'
G[36748]='L40 T:-581 E18612'
G[36749]='L40 E18612'
G[36750]='L40 T:-581 E18612'
G[36751]='L40 T:-581 E18612'
G[36752]='L40 E18612'
G[36753]='L40 E18612'
G[36754]='L40 E18612'
G[36755]='L40 E18612'
G[36756]='L40 T:-581 E18612'
G[36757]='L40 E18612'
G[36758]='L40 T:-581 E18612'
G[36759]='L40 E18612'
G[36760]='L40 E18612'
G[36761]='L40 T:-581 E18612'
G[36762]='L40 E18612'
G[36763]='L40 T:-581 E18612'
G[36764]='L40 E18612'
G[36765]='L40 E18612'
G[36766]='L40 T:-581 E18663'
G[36767]='L40 A:77795 T:-581 E18612'
G[36768]='L40 T:-581 E18612'
G[36769]='L40 T:-581 E18612'
G[36770]='L40 A:100235344 TP:-100581:FA;-587:FH E18612'
G[36771]='L40 T:-590 E18612'
G[36772]='L40 T:-581 E18612'
G[36773]='L40 E18612'
G[36774]='L40 T:76872 E18612'
G[36775]='L40 T:-581 E18612'
G[36776]='L40 T:-581 E18612'
G[36777]='L40 T:-587 E18612'
G[36778]='L40 E18612'
G[36779]='L40 T:-590 E18612'
G[36780]='L40 T:-581 E18612'
G[36781]='L0 T:84852 E18612'
G[36782]='L0 T:85564 E18612'
G[36783]='L0 E18612'
G[36784]='L0 E18612'
G[36787]='L0 E18612'
G[36789]='L0 E18612'
G[36790]='L30 N40 A:86381 T:80746 P:34923+34922 E18612'	-- ODC:36796
G[36791]='SP FA K1 L40 A:85749 T:85749 P:36133 E18612'
G[36792]='K32768 L30 A:84122 T:85429 E18612'
G[36793]='FH L0 I:36797 E18612'
G[36794]='L0 E18612'
G[36796]='L0 E19342'
G[36797]='FA L0 I:36793 E18612'	-- this is marked complete after Alliance sees the screen about being allowed to found the garrison
G[36798]='L0 T:-542 E18663'	-- SP K000131072 A:XXX T:XXX   948:37.30,50.66	-- fee Rooby Roo the dog, and loot the poop here
G[36799]='L0 T:90071 E18663'
G[36800]='L10 AA:85984 AH:585984 TA:85984 TH:585984 P:36616 E18663 D096'
G[36801]='FA L20 A:86442 T:575803 P:34571+34573+34624,34875 I:34683 E18663'	-- TODO: Verify requires 34573
G[36802]='L10 AA:85984 AH:585984 TA:85984 TH:585984 P:36616 E18663 D096'
G[36803]='L10 AA:85984 AH:585984 TA:85984 TH:585984 P:36616 E18663 D096'
G[36804]='L10 AA:85984 AH:585984 TA:85984 TH:585984 P:36616 E18663 D096'
G[36805]='L10 AA:85984 AH:585984 TA:85984 TH:585984 P:36616 E18663 D096'
G[36806]='L10 AA:85984 AH:585984 TA:85984 TH:585984 P:36616 E18663 D096'
G[36807]='FH L40 A:85882 T:83011 E18912'
G[36808]='FA L40 A:77733 T:84367 E18663'
G[36809]='FA L40 A:78564 E18833'
G[36810]='L0 E21655'
G[36811]='SP K32768 L10 A:90255 T:-630 P:40815,44140,36920 E21570'	-- given when 40815 or 44140 or 36920 is turned in
G[36812]='FH L15 A:85077 T:85077 P:35506+35524+35527+35508+36793 U211 E18702'
G[36813]='L35 A:84889 T:84889 E18702'
G[36814]='FH L40 E19027'
G[36815]='FA L40 A:84248 T:88394 E18912'
G[36816]='FA L40 A:78564 T:83848 E18850'
G[36817]='FH K2 L40 A:89753 E20216'
G[36818]='FA K2 L40 A:80866 T:72571 P:0 E18912'
G[36819]='FH L40 E18850'
G[36820]='FA L40 A:84637 T:88906 P:0 E18702'
G[36821]='FH K32768 L40 A:84637 T:88478 P:1 E18702'
G[36822]='FA L40 A:85413 T:78210 E18850'	-- automatically turned in when doing 36674 and all the requirements met
G[36823]='FH L40 A:1229330 T:77945 P:1 E18833'
G[36825]='L0 E18663'
G[36826]='FA L40 A:-572 T:72348 E19027'
G[36827]='FH L40 A:88892 T:72297 E18988'
G[36828]='SP FA L15 A:85119 T:85119 P:36797+35652+35654+35651+35650 U211 E18716'
G[36829]='SP K131072 L0 A:1236483 T:1236483 E18663'
G[36830]='FA L40 A:578564 T:578564,-971 E19342 D143'
G[36831]='FH L40 A:79774 T:79774,-976 E19342 D144'
G[36832]='FH L15 T:85980 E18702'
G[36833]='SP FA L15 A:85278 T:85278 P:35702 U212 E18702'	-- removed from P: +36797 because it is not required (tested with Alliance without garrison)
G[36834]='L0 E18663'
G[36837]='L0 T:85564 E18663'
G[36838]='L90 E18663'
G[36839]='L90 E18663'
G[36840]='L90 E18716'
G[36841]='L90 E18702'
G[36842]='FA L90 AP:77356:G-096018;577356:G-096019;500157:G-096020 TP:77775:G-096018;577775:G-096019;500158:G-096020 P:G-096+36644 E18663 Z18663'	-- [I do not believe this is in game]
G[36843]='L20 A:86522 T:75896 P:34576+34577+34579 E18702'	-- at least this is for boosted to 100 Horde
G[36844]='L90 E18702'
G[36845]='L90 E18702'
G[36846]='SP K131072 L0 A:1236610 T:1236610 E18663'
G[36847]='L0 E18663'
G[36848]='L10 AP:77367:G-037024;577367:G-037023 TP:77367:G-037024;577367:G-037023 P:G-037 E18663'
G[36849]='L0 E18663'
G[36850]='L0 E18663'
G[36851]='L0 E18663'
G[36852]='L0 E18663'
G[36853]='L0 E18663'
G[36854]='L0 E18663'
G[36855]='L0 E18663'
G[36856]='L0 E18663'
G[36857]='L0 E18663'
G[36858]='L0 E18663'
G[36859]='L0 T:86044 E18663'
G[36860]='L40 A:87123 T:86155 E18833'
G[36861]='FA L30 A:86589 T:81109 I:35619,35620,36862 E18663'
G[36862]='FH L30 A:86614 T:81109 I:35619,35620,36861 E18663'
G[36863]='L0 T:93812 E18663'
G[36864]='SP FH L30 A:86597 T:86597 P:36793 I:36353 U204 E18702'
G[36865]='L10 E18663'
G[36866]='L1 T:9736 E18663'
G[36867]='L1 E18663'
G[36870]='FA L20 A:85708 T:85708 P:PF700+G0135 E18716'
G[36872]='L0 E18663'
G[36873]='L1 E18663'
G[36874]='L10 AP:86629:G-159022;586629:G-159025 TP:86629:G-159022;586629:G-159025 P:G-159 E18663'
G[36876]='L10 A:86677 T:86677 E18663'
G[36877]='L0 T:90443 E18663'
G[36878]='L0 E18663'
G[36879]='L0 E18663'
G[36880]='L0 T:86689 E18663'
G[36881]='L10 E18663'	-- TODO: Make this offered to you at Dark Portal if you abandon 34398
G[36882]='FA L20 A:63721 T:85708 P:36608 E18716'
G[36884]='L40 E18912'
G[36885]='L0 E18663'
G[36886]='L0 E18663'
G[36887]='L0 E18663'
G[36889]='L10 E18912'
G[36890]='L0 E18663'
G[36891]='L0 E18663'
G[36892]='L0 E18663'
G[36893]='L0 E18663'
G[36894]='L0 E18663'
G[36895]='L0 E18663'
G[36896]='L0 E18663'
G[36897]='L10 E18738'
G[36898]='L0 T:75819 E18663'
G[36899]='L0 T:90066 E18663'
G[36900]='L0 T:92819 E18663'
G[36901]='L0 E18663'
G[36902]='L0 E18663'
G[36903]='L0 E18663'
G[36904]='L0 T:90286 E18663'
G[36905]='L0 E18663'
G[36906]='L0 E18663'
G[36907]='L0 E18663'
G[36911]='FA L10 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:G-065 E18702 D112'
G[36912]='FH L10 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:G-065 E18702 D119'
G[36913]='FA L15 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36916+G-065 E18702 D114'
G[36914]='FA L38 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36915+G-065 E18702 D117'
G[36915]='FA L35 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36918+G-065 E18702 D116'
G[36916]='FA L10 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36911+G-065 E18702 D113'
G[36917]='FH L10 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:36912+G-065 E18702 D118'
G[36918]='FA L20 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36913+G-065 E18702 D115'
G[36919]='L0 T:85572 E18663'
G[36920]='L10 XE A:89362 T:90255 P:37660 E21570'	-- Night Elf Druid
G[36921]='L10 E18764'
G[36922]='L0 E18663'
G[36923]='L10 E18833'
G[36924]='L10 E18912'
G[36925]='L10 E18738'
G[36926]='L10 E18738'
G[36927]='L10 E18912'
G[36928]='L10 E18764'
G[36929]='L10 E18912'
G[36930]='L10 E18918'
G[36931]='L10 E18912'
G[36932]='L10 E18912'
G[36933]='L10 E18912'
G[36934]='L10 E18918'
G[36935]='FH K1 L40 A:86366 E18702'
G[36936]='L0 T:75819 E18663'
G[36937]='SP K131072 L0 A:1236935 T:1236935 E18663'
G[36939]='L0 E21570'
G[36940]='FH L10 A:84928 T:86832 P:35763+i176111 I:36941 E18702'
G[36941]='FA L10 A:84929 T:29611 P:35500+i176111 I:36940 E18663'
G[36942]='L0 T:75273 E18663'
G[36943]='L0 T:86978 E18663'
G[36944]='FH L15 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:36917+G-065 E18702 D120'
G[36945]='FH L20 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:36944+G-065 E18716 D121'
G[36946]='FH L35 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:36945+G-065 E18716 D122'	-- note that all the base beast taming quests are available one after the other just by logging out and back in after the previous one is completed
G[36947]='L40 T:86682 E18716'
G[36948]='FA L30 AP:87206:G-111022;587206:G-111025 TP:87206:G-111022;587206:G-111025 P:G145 E18716'
G[36949]='L0 E21953'
G[36950]='FH L38 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:36946+G-065 E18716 D123'
G[36951]='L30 A:1232400 T:79539 I:34653 E18702'
G[36952]='FH L35 A:1232416 T:80001 P:1 I:34794 E18702'
G[36953]='FH L20 A:1233291 T:79176 P:36573,36574 O:36494 E18702'
G[36955]='L10 A:86677 T:86677 E18716'
G[36956]='L0 E18702'
G[36957]='L10 A:86677 E18912'
G[36958]='L10 E18918'
G[36959]='L10 E18716'
G[36960]='L10 E18716'
G[36961]='L10 E18912'
G[36962]='L10 E18912'
G[36963]='L10 E18716'
G[36964]='L10 E18738'
G[36965]='L10 E18912'
G[36966]='L10 E18912'
G[36967]='L10 E18912'
G[36968]='L10 E18918'
G[36969]='L10 E19342'
G[36970]='L10 E19027'
G[36971]='FA L10 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36972+G-065 E18702 D112'
G[36972]='FA L10 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36911+G-065 E18702 D112'
G[36973]='FA L15 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36971+G-065 E18716 D112'
G[36974]='FA L20 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36973+G-065 E18716 D112'
G[36975]='FA L30 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36974+G-065 E18716 D112'
G[36976]='FA L35 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36975+G-065 E18716 D112'
G[36977]='FA L38 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36976+G-065 E18716 D112'
G[36978]='FA L40 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36977+G-065 E18716 D112'
G[36979]='FA L40 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36978+G-065 E18716 D112'
G[36980]='FA L40 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36979+G-065 E18738 D112'
G[36981]='FA L40 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36980+G-065 E18738 D112'
G[36982]='FA L40 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36981+G-065 E18764 D112'
G[36983]='FA L10 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36984+G-065 E18702 D113'
G[36984]='FA L10 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36916+G-065 E18702 D113'
G[36985]='FA L15 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36983+G-065 E18716 D113'
G[36986]='FA L20 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36985+G-065 E18716 D113'
G[36987]='FA L30 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36986+G-065 E18716 D113'
G[36988]='FA L35 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36987+G-065 E18716 D113'
G[36989]='FA L38 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36988+G-065 E18716 D113'
G[36990]='FA L40 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36989+G-065 E18716 D113'
G[36991]='FA L40 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36990+G-065 E18716 D113'
G[36992]='FA L40 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36991+G-065 E18738 D113'
G[36993]='FA L40 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36992+G-065 E18738 D113'
G[36994]='FA L40 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36993+G-065 E18764 D113'
G[36995]='FA L15 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36913+G-065 E18702 D114'
G[36996]='FA L20 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36995+G-065 E18702 D114'
G[36997]='FA L30 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36996+G-065 E18716 D114'
G[36998]='FA L35 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36997+G-065 E18716 D114'
G[36999]='FA L38 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36998+G-065 E18716 D114'
G[37000]='FA L40 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36999+G-065 E18716 D114'
G[37001]='FA L40 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:37000+G-065 E18716 D114'
G[37002]='FA L40 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:37001+G-065 E18716 D114'
G[37003]='FA L40 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:37002+G-065 E18738 D114'
G[37004]='FA L40 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:37003+G-065 E18738 D114'
G[37005]='FA L20 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36918+G-065 E18702 D115'
G[37006]='FA L30 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37005+G-065 E18716 D115'
G[37007]='FA L35 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37006+G-065 E18716 D115'
G[37008]='FA L38 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37007+G-065 E18716 D115'
G[37009]='FA L40 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37008+G-065 E18716 D115'
G[37010]='FA L40 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37009+G-065 E18716 D115'
G[37011]='FA L40 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37010+G-065 E18716 D115'
G[37012]='FA L40 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37011+G-065 E18738 D115'
G[37013]='FA L40 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37012+G-065 E18738 D115'
G[37014]='FH L30 T:86806 E18716'
G[37015]='FA L35 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:36915+G-065 E18702 D116'
G[37016]='FA L38 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:37015+G-065 E18716 D116'
G[37017]='FA L40 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:37016+G-065 E18716 D116'
G[37018]='FA L40 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:37017+G-065 E18716 D116'
G[37019]='FA L40 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:37018+G-065 E18716 D116'
G[37020]='FA L40 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:37019+G-065 E18716 D116'
G[37021]='FA L40 AP:86973:G-065023;586973:G-065024 TP:86973:G-065023;586973:G-065024 P:37020+G-065 E18716 D116'
G[37022]='FA L35 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:36914+G-065 E18702 D117'
G[37023]='FA L38 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37022+G-065 E18716 D117'
G[37024]='FA L40 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37023+G-065 E18716 D117'
G[37025]='FA L40 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37024+G-065 E18716 D117'
G[37026]='FA L40 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37025+G-065 E18716 D117'
G[37027]='FA L40 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37026+G-065 E18716 D117'
G[37028]='FA L40 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:37027+G-065 E18716 D117'
G[37029]='L40 E19533'
G[37030]='L40 A:87225 E18716'
G[37031]='L40 E18833'
G[37032]='FH L15 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:36944+G-065 E18716 D120'
G[37033]='FH L20 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37032+G-065 E18716 D120'
G[37034]='FH L30 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37033+G-065 E18716 D120'
G[37035]='FH L35 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37034+G-065 E18716 D120'	-- when all the mounts have killed Beast-Lasher an achievement is completed "Beast-Lasher killed"
G[37036]='FH L38 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37035+G-065 E18716 D120'
G[37037]='FH L40 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37036+G-065 E18738 D120'
G[37038]='FH L40 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37037+G-065 E18833 D120'
G[37039]='FH L40 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37038+G-065 E18764 D120'
G[37040]='FH L40 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37039+G-065 E18764 D120'
G[37041]='FH L40 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37040+G-065 E18833 D120'
G[37042]='L0 E21463'
G[37043]='L10 AP:79815:G-008024;579815:G-008023 TP:79815:G-008024;579815:G-008023 P:G-008 E18702'
G[37044]='L10 A:85369 T:85369 P:G-162 E18702'	-- TODO: See comment in 37091
G[37045]='FH L10 N54 AP:79857:G-052018;579857:G-052019;500251:G-052020 TP:79857:G-052018;579857:G-052019;500251:G-052020 P:G-052 E18702'
G[37046]='L10 AP:87305:G-035022;587305:G-035025 TP:87305:G-035022;587305:G-035025 P:G-035 E18702'
G[37047]='FA L40 A:86934 T:86934 P:T6CA51999 E18833'
G[37048]='FH L10 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37049+G-065 E18702 D119'
G[37049]='FH L10 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:36912+G-065 E18702 D119'
G[37050]='FH L15 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37048+G-065 E18716 D119'
G[37051]='FH L20 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37050+G-065 E18716 D119'
G[37052]='FH L30 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37051+G-065 E18716 D119'
G[37053]='FH L35 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37052+G-065 E18716 D119'
G[37054]='FH L38 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37053+G-065 E18716 D119'
G[37055]='FH L40 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37054+G-065 E18716 D119'
G[37056]='FH L40 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37055+G-065 E18716 D119'
G[37057]='FH L40 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37056+G-065 E18738 D119'
G[37058]='FH L40 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37057+G-065 E18738 D119'
G[37059]='FH L40 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37058+G-065 E18764 D119'
G[37060]='FH L10 AP:79862:G-051018;579862:G-051019 TP:79862:G-051018;579862:G-051019 P:G-051 E18702'
G[37062]='L10 AP:87121:G-111022;587121:G-111025 TP:87121:G-111022;587121:G-111025 P:G-111 E18702'
G[37063]='FH L35 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:36946+G-065 E18716 D122'
G[37064]='FH L38 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37063+G-065 E18716 D122'
G[37065]='FH L40 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37064+G-065 E18716 D122'
G[37066]='FH L40 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37065+G-065 E18716 D122'
G[37067]='FH L40 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37066+G-065 E18716 D122'
G[37068]='FH L40 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37067+G-065 E18738 D122'
G[37069]='FH L40 AP:86979:G-065023;586979:G-065024 TP:86979:G-065023;586979:G-065024 P:37068+G-065 E18738 D122'
G[37070]='SP FH L40 P:T6CC51999 E18738'	-- need A: and T: (also 37128)
G[37071]='FH L20 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:36945+G-065 E18716 D121'
G[37072]='FH L30 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37071+G-065 E18716 D121'
G[37073]='FH L35 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37072+G-065 E18716 D121'
G[37074]='FH L38 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37073+G-065 E18716 D121'
G[37075]='FH L40 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37074+G-065 E18716 D121'
G[37076]='FH L40 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37075+G-065 E18716 D121'
G[37077]='FH L40 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37076+G-065 E18738 D121'
G[37078]='FH L40 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37077+G-065 E18738 D121'
G[37079]='FH L40 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37078+G-065 E18738 D121'
G[37080]='SP FA L40 A:86927 T:86927 P:T6C551999 E18738'
G[37081]='FH L40 E18738'
G[37082]='L40 E18702'
G[37083]='L40 E18702'
G[37084]='SP L40 A:586946 T:586946 P:T6C951999 E18738'
G[37085]='L40 A:587561 T:587561 P:T6CD51999 E18833'
G[37086]='FA L10 AP:77378:G-052018;577378:G-052019;500252:G-052020 TP:77378:G-052018;577378:G-052019;500252:G-052020 P:G-052 E18702'
G[37087]='FA L10 AP:84857:G-051018;584857:G-051019;500217:G-051020 TP:84857:G-051018;584857:G-051019;500217:G-051020 P:G-051 E18702'
G[37088]='L10 A:87213 AP:87217:G-111022;587217:G-111025 T:87213 TP:87217:G-111022;587217:G-111025 P:G-111 E18702'
G[37091]='L10 A:84286 T:84286 P:G-162 E18702'	-- TODO: Set up proper locations for 84286 based on plot location
G[37092]='FA L10 AP:77377:G-008024;577377:G-008023 TP:77377:G-008024;577377:G-008023 P:G-008 E18702'
G[37093]='FH L10 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37094+G-065 E18702 D118'
G[37094]='FH L10 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:36917+G-065 E18702 D118'
G[37095]='FH L15 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37093+G-065 E18716 D118'
G[37096]='FH L20 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37095+G-065 E18716 D118'
G[37097]='FH L30 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37096+G-065 E18716 D118'
G[37098]='FH L35 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37097+G-065 E18716 D118'
G[37099]='FH L38 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37098+G-065 E18716 D118'
G[37100]='FH L40 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37099+G-065 E18716 D118'
G[37101]='FH L40 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37000+G-065 E18716 D118'
G[37102]='FH L40 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37101+G-065 E18738 D118'
G[37103]='FH L40 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:38102+G-065 E18738 D118'
G[37104]='FH L40 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:38103+G-065 E18764 D118'
G[37105]='FH L35 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:36950+G-065 E18716 D123'
G[37106]='FH L38 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37105+G-065 E18716 D123'
G[37107]='FH L40 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37106+G-065 E18716 D123'
G[37108]='FH L40 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37107+G-065 E18716 D123'
G[37109]='FH L40 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37108+G-065 E18716 D123'
G[37110]='FH L40 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37109+G-065 E18738 D123'
G[37111]='FH L40 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:37110+G-065 E18738 D123'
G[37112]='FA L1 A:6774 T:295 I:2158 E18702'
G[37113]='FA L40 E19890'
G[37114]='FA L40 E19890'
G[37119]='L10 AP:84947:G-035022;584947:G-035025 TP:84947:G-035022;584947:G-035025 P:G-035 E18702'
G[37120]='L0 E18702'
G[37121]='FA L10 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:G-066 E18702'
G[37122]='FA L10 AP:86974:G-065023;586974:G-065024 TP:86974:G-065023;586974:G-065024 P:G0067 E18912'
G[37123]='FH L10 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:G-066 E18702'
G[37124]='FH L10 AP:87242:G-065023;587242:G-065024 TP:87242:G-065023;587242:G-065024 P:G0067 E19342'
G[37125]='SP K1 L35 A:87393 T:87393 E18702'
G[37126]='FA L40 A:86682 T:86682 E18716'
G[37127]='FA L40 A:86934 T:86934 P:T6CA61999 E18833'
G[37128]='FH L40 P:T6CC61999 E18716'
G[37129]='FA L40 A:86927 T:86927 P:T6C561999 E18833'
G[37130]='L0 E18716'
G[37131]='FH L40 E18738'
G[37132]='L0 T:86657 E18716'
G[37133]='L0 E18716'
G[37134]='L0 T:86657 E18716'
G[37135]='L0 E18716'
G[37136]='L0 E18716'
G[37137]='FA L40 A:586946 T:586946 P:T6C961999 E18912'
G[37140]='FA L40 A:587561 T:587561 P:T6CD61999 E18764'
G[37141]='SP L30 A:83959 T:83959 P:Y8925+36797,Y8926+36793 U218 E18738'
G[37142]='K2 L10 AP:88013:FA+G-034022;588013:FA+G-034025;500166:FH+G-034022;500167:FH+G-034025 TP:88013:FA+G-034022;588013:FA+G-034025;500166:FH+G-034022;500167:FH+G-034025 P:G-034 E18716'
G[37144]='SP L30 A:580758 T:580758 P:37177 U224 E19342'
G[37145]='K2 L15 AP:88017:FA+G-034022;588017:FA+G-034025;500168:FH+G-034022;500169:FH+G-034025 TP:88017:FA+G-034022;588017:FA+G-034025;500168:FH+G-034022;500169:FH+G-034025 P:G-034 E18716'
G[37146]='L20 AP:88022:FA+G-034022;588022:FA+G-034025;500170:FH+G-034022;500171:FH+G-034025 TP:88022:FA+G-034022;588022:FA+G-034025;500170:FH+G-034022;500171:FH+G-034025 P:G-034 E18716'
G[37147]='L30 AP:88023:FA+G-034022;588023:FA+G-034025;500172:FH+G-034022;500173:FH+G-034025 TP:88023:FA+G-034022;588023:FA+G-034025;500172:FH+G-034022;500173:FH+G-034025 P:G-034 E18716'
G[37148]='L35 AP:88024:FA+G-034022;588024:FA+G-034025;500174:FH+G-034022;500175:FH+G-034025 TP:88024:FA+G-034022;588024:FA+G-034025;500174:FH+G-034022;500175:FH+G-034025 P:G-034 E18716'
G[37149]='K1088 L10 AP:88027:FA+G-034022;588027:FA+G-034025;500176:FH+G-034022;500177:FH+G-034025 TP:88027:FA+G-034022;588027:FA+G-034025;500176:FH+G-034022;500177:FH+G-034025 P:G-034 E18716'
G[37150]='L35 AP:88025:FA+G-034022;588025:FA+G-034025;500178:FH+G-034022;500179:FH+G-034025 TP:88025:FA+G-034022;588025:FA+G-034025;500178:FH+G-034022;500179:FH+G-034025 P:G-034 E18716'
G[37151]='L35 AP:88026:FA+G-034022;588026:FA+G-034025;500180:FH+G-034022;500181:FH+G-034025 TP:88026:FA+G-034022;588026:FA+G-034025;500180:FH+G-034022;500181:FH+G-034025 P:G-034 E18716'
G[37152]='K1088 L40 AP:87991:FA+G-034022;587991:FA+G-034025;500182:FH+G-034022;500183:FH+G-034025 TP:87991:FA+G-034022;587991:FA+G-034025;500182:FH+G-034022;500183:FH+G-034025 P:G-034 E18716'
G[37153]='K1088 L40 AP:87992:FA+G-034022;587992:FA+G-034025;500184:FH+G-034022;500185:FH+G-034025 TP:87992:FA+G-034022;587992:FA+G-034025;500184:FH+G-034022;500185:FH+G-034025 P:G-034 E18716'
G[37154]='L40 AP:87997:FA+G-034022;587997:FA+G-034025;500186:FH+G-034022;500187:FH+G-034025 TP:87997:FA+G-034022;587997:FA+G-034025;500186:FH+G-034022;500187:FH+G-034025 P:G-034 E18716'
G[37155]='K1088 L40 AP:87995:FA+G-034022;587995:FA+G-034025;500188:FH+G-034022;500189:FH+G-034025 TP:87995:FA+G-034022;587995:FA+G-034025;500188:FH+G-034022;500189:FH+G-034025 P:G-034 E18716'
G[37156]='L40 AP:87996:FA+G-034022;587996:FA+G-034025;500190:FH+G-034022;500191:FH+G-034025 TP:87996:FA+G-034022;587996:FA+G-034025;500190:FH+G-034022;500191:FH+G-034025 P:G-034 E18716'
G[37157]='K1088 L40 AP:87994:FA+G-034022;587994:FA+G-034025;500192:FH+G-034022;500193:FH+G-034025 TP:87994:FA+G-034022;587994:FA+G-034025;500192:FH+G-034022;500193:FH+G-034025 P:G-034 E18716'
G[37158]='L40 AP:87998:FA+G-034022;587998:FA+G-034025;500194:FH+G-034022;500195:FH+G-034025 TP:87998:FA+G-034022;587998:FA+G-034025;500194:FH+G-034022;500195:FH+G-034025 P:G-034 E18716'
G[37159]='L40 AP:87999:FA+G-034022;587999:FA+G-034025;500196:FH+G-034022;500197:FH+G-034025 TP:87999:FA+G-034022;587999:FA+G-034025;500196:FH+G-034022;500197:FH+G-034025 P:G-034 E18716'
G[37160]='K1088 L40 AP:88007:FA+G-034022;588007:FA+G-034025;500198:FH+G-034022;500199:FH+G-034025 TP:88007:FA+G-034022;588007:FA+G-034025;500198:FH+G-034022;500199:FH+G-034025 P:G-034 E18716'
G[37161]='L40 AP:88000:FA+G-034022;588000:FA+G-034025;500200:FH+G-034022;500201:FH+G-034025 TP:88000:FA+G-034022;588000:FA+G-034025;500200:FH+G-034022;500201:FH+G-034025 P:G-034 E18716'
G[37162]='L40 AP:88001:FA+G-034022;588001:FA+G-034025;500202:FH+G-034022;500203:FH+G-034025 TP:88001:FA+G-034022;588001:FA+G-034025;500202:FH+G-034022;500203:FH+G-034025 P:G-034 E18716'
G[37163]='K1088 L40 AP:88002:FA+G-034022;588002:FA+G-034025;500204:FH+G-034022;500205:FH+G-034025 TP:88002:FA+G-034022;588002:FA+G-034025;500204:FH+G-034022;500205:FH+G-034025 P:G-034 E18716'
G[37164]='K1088 L40 AP:88003:FA+G-034022;588003:FA+G-034025;500206:FH+G-034022;500207:FH+G-034025 TP:88003:FA+G-034022;588003:FA+G-034025;500206:FH+G-034022;500207:FH+G-034025 P:G-034 E18716'
G[37165]='K1088 L40 AP:88004:FA+G-034022;588004:FA+G-034025;500208:FH+G-034022;500209:FH+G-034025 TP:88004:FA+G-034022;588004:FA+G-034025;500208:FH+G-034022;500209:FH+G-034025 P:G-034 E18716'
G[37166]='K1088 L40 AP:88005:FA+G-034022;588005:FA+G-034025;500210:FH+G-034022;500211:FH+G-034025 TP:88005:FA+G-034022;588005:FA+G-034025;500210:FH+G-034022;500211:FH+G-034025 P:G-034 E18716'
G[37167]='K1088 L40 AP:88006:FA+G-034022;588006:FA+G-034025;500212:FH+G-034022;500213:FH+G-034025 TP:88006:FA+G-034022;588006:FA+G-034025;500212:FH+G-034022;500213:FH+G-034025 P:G-034 E18716'
G[37168]='SP L30 A:87561 T:87561 P:0 U219 E18716'	--TODO:Yoshimo: needs P:, probably garrison build
G[37169]='L0 E18716'
G[37175]='L1 E21570'
G[37177]='L30 AZ:542 T:84122 P:T5EB83999 E19342'	-- completes Mantle of the Talon King
G[37179]='L40 AP:88009:FA+G-034022;588009:FA+G-034025;500214:FH+G-034022;500215:FH+G-034025 TP:88009:FA+G-034022;588009:FA+G-034025;500214:FH+G-034022;500215:FH+G-034025 P:G-034 U455 E18716'
G[37180]='FH L40 T:90066 E18716'
G[37181]='FH L40 A:587561 T:587561 P:T6CD61999 E18764'
G[37182]='FH L40 E18738'
G[37183]='FA L20 A:81492 T:79133 O:36495 I:34676 E18716'
G[37184]='FA L35 A:81492 T:79263 E18716'
G[37185]='L0 E18738'
G[37186]='L0 E18738'
G[37187]='L0 E18738'
G[37188]='L0 E18738'
G[37189]='L0 E18738'
G[37190]='FH L23040 E18738'	-- See comment for quest 37196
G[37191]='FA L40 A:87764 T:84268 P:1 E18738'	-- TODO: This becomes available when in 36341 Azuka Bladefury is slain
G[37192]='FH L40 A:87764 T:579740 P:1 E18738'	-- TODO: This becomes available when in 36342 Azuka Bladefury is slain (basically the last item in the quest list becomes available:  Speak to Choluna)
G[37193]='L0 E18738'
G[37194]='L0 E18738'
G[37195]='L0 E18738'
G[37196]='FA L23040 E18738'	-- This indicates for the Alliance character that Blasted Lands is phased for Iron Horde, but seemingly not for boosted level 90 characters
G[37197]='L0 T:78999 E18738'
G[37198]='L0 E18738'
G[37199]='L0 E18738'
G[37201]='K16386 L1 A:83837 T:83837 E18738'
G[37202]='L0 E18738'
G[37203]='K16386 L1 A:87124 T:87124 E18738'
G[37204]='K2 L40 A:87971 T:87971 E19027'
G[37205]='L1 A:87122 T:87122 E18738'
G[37206]='K16386 L1 A:87110 T:87110 E18738'
G[37207]='K16386 L1 N42 A:87123 T:87123 E18738'
G[37208]='K16386 L1 A:87125 T:87125 E18738'
G[37209]='K66 L35 AP:88026:FA+G-034022;588026:FA+G-034025;500180:FH+G-034022;500181:FH+G-034025 TP:88026:FA+G-034022;588026:FA+G-034025;500180:FH+G-034022;500181:FH+G-034025 P:G-034+37151 E18764 D100'
G[37210]='SP K1 L35 A:87706 T:87706 E18738'
G[37211]='SP K1 L35 A:87706 T:87706 E18738'
G[37212]='L0 E18738'
G[37213]='L0 E18738'
G[37214]='L0 E18738'
G[37215]='L0 T:92819 E18738'
G[37216]='L0 T:92819 E18738'
G[37217]='L0 E18738'
G[37218]='L0 E18738'
G[37219]='L0 E18738'
G[37220]='L0 E18738'
G[37221]='SP K1 L35 A:87706 T:87706 E18738'
G[37222]='SP K1 L35 A:87706 T:87706 E18738'
G[37223]='SP K1 L35 A:87706 T:87706 E18738'
G[37224]='SP K1 L35 A:87706 T:87706 E18738'
G[37225]='SP K1 L35 A:87706 T:87706 E18738'
G[37226]='SP K1 L35 A:87706 T:87706 E18738'
G[37227]='K66 L35 A:88025 T:88025 P:G-034 E18912'
G[37228]='K1090 L40 A:87991 T:87991 P:G-034 E18833'
G[37229]='K1090 L40 A:87992 T:87992 P:G-034 E18912'
G[37230]='K1090 L40 A:87994 T:87994 P:G-034 E19027'
G[37231]='L40 A:87995 T:87995 P:G-034 E19027'
G[37232]='K1090 L40 A:87996 T:87996 P:G-034 E18912'
G[37233]='K1090 L40 A:87997 T:87997 P:G-034+37154 E18912'
G[37234]='L40 A:87998 T:87998 P:G-034 E18918'
G[37235]='L40 A:87999 T:87999 P:G-034 E18912'
G[37236]='K1090 L40 A:88000 T:88000 P:G-034 E18912'
G[37237]='K1090 L40 A:88001 T:88001 P:G-034 E19027'
G[37238]='K1090 L40 A:88002 T:88002 P:G-034 E18912'
G[37239]='L40 A:88003 T:88003 P:G-034 E19027'
G[37240]='K1090 L40 A:88004 T:88004 P:G-034 E18912'
G[37241]='K1090 L40 A:88005 T:88005 P:G-034 E18912'
G[37242]='K1090 L40 A:88006 T:88006 P:G-034 E18912 D100'
G[37243]='K1090 L40 A:88007 T:88007 P:G-034 E18912'
G[37244]='K66 L35 AP:88024:FA+G-034022;588024:FA+G-034025;500174:FH+G-034022;500175:FH+G-034025 TP:88024:FA+G-034022;588024:FA+G-034025;500174:FH+G-034022;500175:FH+G-034025 P:G-034 E18764'
G[37245]='K66 L10 A:88027 T:88027 P:G-034 E18764'
G[37246]='L0 E18738'
G[37247]='L1 E18738'
G[37248]='L0 E18833'
G[37249]='L0 E18738'
G[37250]='L0 E18738'
G[37251]='L0 E18738'
G[37252]='L0 E18738'
G[37253]='L0 E18738'
G[37254]='SP K131072 L0 A:1232494 T:1232494 E18738'
G[37255]='L0 E18738'
G[37256]='L10 A:89023 T:89023 P:37690 E21570'
G[37257]='L10 A:88115 T:88115 P:37733 E21570'
G[37258]='L0 E21655'
G[37259]='L100 A:88161 E18738'
G[37260]='L100 E18833'
G[37261]='L100 E18738'
G[37262]='L100 E18764'
G[37263]='L100 E18764'
G[37264]='L100 E18764'
G[37265]='L100 E18764'
G[37266]='L100 E18912'
G[37268]='L0 E18738'
G[37269]='L0 E18738'
G[37270]='K2 L1 AP:88145:G-119018+FA;588145:G-119019+FA;500255:G-119020+FA;88392:G-119018+FH;588392:G-119019+FH;500256:G-119020+FH TP:88145:G-119018+FA;588145:G-119019+FA;500255:G-119020+FA;88392:G-119018+FH;588392:G-119019+FH;500256:G-119020+FH P:z-119 E18738'
G[37271]='L100 E18738'
G[37272]='L100 E18833'
G[37273]='L100 E18738'
G[37274]='L100 E18764'
G[37275]='L100 T:88155 E18764'	-- removed A:32639
G[37276]='FH L30 T:88179 P:36166+36793 U453 E18764'
G[37277]='K2 L100 A:88155 T:88155 E18764'
G[37278]='L100 E18764'
G[37279]='L100 A:88155 E18764'
G[37280]='K32768 L35 A:-550 T:88811 E18738'
G[37281]='SP FA L30 A:88195 T:88195 P:36165+36797 U453 E18738'
G[37282]='L0 E18738'
G[37283]='L0 E18738'
G[37284]='K4 L10 A:83006 T:83006 E18850'
G[37285]='L10 E18912'
G[37286]='L40 E19342'
G[37287]='FA L30 N40 A:84291 T:84291 P:36165 I:37292 E18738'
G[37288]='FA L15 AP:77209:=09711;577209:=09712;500138:=09713 T:85849 P:36575,36576 E18738'
G[37289]='FA L10 A:88223 T:88223 P:E36592 E18738'
G[37290]='FH L15 A:500154,500250 T:85840 P:K100116395 E18738'
G[37291]='FH L10 A:574163,88228 T:88228 P:32796+36567 I:36614 E18738'
G[37292]='FH L30 A:84292 T:84292 P:36166 I:37287 E18738'
G[37293]='FH L35 N54 A:88240 T:88240 E18738'
G[37294]='L0 E18738'
G[37295]='K32768 L100 A:83869 E18738'
G[37296]='L30 N40 A:83463 T:83463 P:37326,37327,35699,35697 E18738'	-- Ally Smugler's den P:35699, Horde Smugler's den P:35697, Ally Stoktron Brewery 37327, Horde Stoktron Brewery 37326
G[37297]='K32768 L100 A:88155 T:79269 E18738'
G[37298]='K32768 L28260 E18738'
G[37299]='K32768 L100 E18738'
G[37300]='L0 E18738'
G[37301]='L0 E18738'	-- automatically completed when Horde chose Arsenal in Talador
G[37302]='L0 T:79190 E18738'	-- Arcane Sanctum
G[37303]='L0 T:79190 E18738'	-- Arcane Sanctum
G[37304]='L0 E18738'	-- automatically completed when Horde chose Arsenal in Talador
G[37305]='L40 E18738'
G[37306]='L40 E18738'
G[37307]='L40 E18738'
G[37308]='L1 E18738'
G[37309]='L1 E18738'
G[37310]='L1 E18738'
G[37311]='L0 E18738'
G[37312]='L0 T:83008 E18738'
G[37313]='FH L0 I:37314 E18738'	-- Arak Inn
G[37314]='FH L0 I:37314+37316+35284+35291 E18738'	-- Trading Post
G[37315]='FA L0 E18738'	-- Arak Inn?
G[37316]='L0 I:37314+35284+35291 E18738'	-- Trading Post
G[37317]='L0 E18738'
G[37318]='L35 N46 A:88500 T:1237705 E18738'	-- no known prequest
G[37319]='K2 L10 AP:88545:G-131018+FA;588545:G-131019+FA;500253:G-131020+FA;88546:G-131018+FH;588546:G-131019+FH;500254:G-131020+FH TP:88545:G-131018+FA;588545:G-131019+FA;500253:G-131020+FA;88546:G-131018+FH;588546:G-131019+FH;500254:G-131020+FH P:z-131 E18738 D126'
G[37320]='K2 L10 AP:88545:G-131018+FA;588545:G-131019+FA;500253:G-131020+FA;88546:G-131018+FH;588546:G-131019+FH;500254:G-131020+FH TP:88545:G-131018+FA;588545:G-131019+FA;500253:G-131020+FA;88546:G-131018+FH;588546:G-131019+FH;500254:G-131020+FH P:z-131 E18738 D126'
G[37321]='K2 L10 AP:88545:G-131018+FA;588545:G-131019+FA;500253:G-131020+FA;88546:G-131018+FH;588546:G-131019+FH;500254:G-131020+FH TP:88545:G-131018+FA;588545:G-131019+FA;500253:G-131020+FA;88546:G-131018+FH;588546:G-131019+FH;500254:G-131020+FH P:z-131 E18738 D126'
G[37322]='FA L10 A:100119208 T:1237790 P:33256 E18764'
G[37323]='K2 L10 AP:88545:G-131018+FA;588545:G-131019+FA;500253:G-131020+FA;88546:G-131018+FH;588546:G-131019+FH;500254:G-131020+FH TP:88545:G-131018+FA;588545:G-131019+FA;500253:G-131020+FA;88546:G-131018+FH;588546:G-131019+FH;500254:G-131020+FH P:z-131 E18764 D126'
G[37324]='K2 L10 AP:88545:G-131018+FA;588545:G-131019+FA;500253:G-131020+FA;88546:G-131018+FH;588546:G-131019+FH;500254:G-131020+FH TP:88545:G-131018+FA;588545:G-131019+FA;500253:G-131020+FA;88546:G-131018+FH;588546:G-131019+FH;500254:G-131020+FH P:z-131 E18764 D126'
G[37325]='K2 L10 AP:88545:G-131018+FA;588545:G-131019+FA;500253:G-131020+FA;88546:G-131018+FH;588546:G-131019+FH;500254:G-131020+FH TP:88545:G-131018+FA;588545:G-131019+FA;500253:G-131020+FA;88546:G-131018+FH;588546:G-131019+FH;500254:G-131020+FH P:z-131 E19342 D126'
G[37326]='FH L30 A:81920 T:83463 P:35277+37313 I:37327,35697 E18764'	-- TODO: verify 
G[37327]='FA L30 N40 A:81929 T:83463 P:35286 I:37326,35699 E18764'
G[37328]='FH L30 A:83463 T:81920 P:37296 I:37329,37330,37331 E18764'	-- Horde STOKTRON BREWERY
G[37329]='FA L30 N40 A:83463 T:81929 P:37296 I:37328,37330,37331 E18764'	-- Ally STOKTRON BREWERY
G[37330]='FH L30 N40 A:83463 T:81920 P:37296 I:37328,37329,37331 E18764'	-- Horde SMUGGLER'S DEN
G[37331]='FA L30 A:83463 T:81929 P:37296 I:37328,37329,37330 E18764'	-- Ally SMUGGLER'S DEN
G[37332]='L10 A:100119317 T:81324 E18764'
G[37333]='L10 E18764'
G[37334]='L10 E18764'
G[37335]='L10 E18764'
G[37336]='L10 E18764'
G[37337]='L0 E18764'
G[37338]='L0 E18764'
G[37339]='L0 E18764'
G[37340]='L0 T:83019 E18764'
G[37341]='L0 T:82992 E18764'
G[37342]='L0 T:88494 E18764'
G[37343]='L0 T:82922 E18764'
G[37344]='L0 T:87668 E18764'
G[37345]='L0 T:82920 E18764'
G[37346]='L0 T:82942 E18764'
G[37347]='L0 T:82930 E18764'
G[37348]='L0 T:82988 E18764'
G[37349]='L0 T:87341 E18764'
G[37350]='L0 E18764'
G[37351]='L0 T:84911 E18764'
G[37352]='L0 T:84925 E18764'
G[37353]='L0 E18764'
G[37354]='L0 T:81542 E18764'
G[37355]='L0 T:88264 E18764'
G[37356]='L0 T:86213 E18764'	-- killling Aqualir at 947:50.98,78.99
G[37357]='L0 E18764'
G[37358]='L0 T:85026 E18764'
G[37359]='L0 T:85073 E18764'
G[37360]='L0 E18764'
G[37361]='L0 E18764'
G[37362]='L0 T:86566 E18764'
G[37363]='L0 T:86562 E18764'
G[37364]='L0 E18764'
G[37365]='L0 T:700134 E18764'
G[37366]='L0 T:86571 E18764'
G[37367]='L0 T:86574 E18764'
G[37368]='L0 T:86579 E18764'
G[37369]='L0 E18764'
G[37370]='L0 E18764'
G[37371]='L0 E18764'
G[37372]='L0 E18764'
G[37373]='L0 E18764'
G[37374]='L0 T:88582 E18764'
G[37375]='L0 T:88583 E18764'
G[37376]='L0 T:88586 E18764'
G[37377]='L0 E18764'
G[37378]='L0 E18764'
G[37379]='L0 E18764'
G[37380]='L0 E18764'
G[37381]='L0 E18764'
G[37382]='L0 E18764'
G[37383]='L0 E18764'
G[37384]='L0 E18764'
G[37385]='L0 T:90286 E18764'
G[37386]='L0 T:82616 E18764'
G[37387]='L0 E18764'
G[37388]='L0 E18764'
G[37389]='L0 E18764'
G[37390]='L0 E18764'
G[37391]='L0 E18764'
G[37392]='L0 E18764'
G[37393]='L0 E18764'
G[37394]='L0 T:83990 E18764'
G[37395]='L0 T:87788 E18764'
G[37396]='L0 T:700354 E18764'
G[37397]='L0 E18764'
G[37398]='L0 E18764'
G[37399]='L0 T:86959 E18764'
G[37400]='L0 T:87234 E18764'
G[37401]='L0 E18764'
G[37402]='L0 E18764'
G[37403]='L0 E18764'
G[37404]='L0 E18764'
G[37405]='L0 E18764'
G[37406]='L0 E18764'
G[37407]='L0 T:80398 E18764'
G[37408]='L0 E18764'
G[37409]='L0 E18764'
G[37410]='L0 T:85568 E18764'
G[37411]='L0 E18764'
G[37412]='L0 E18764'
G[37413]='L0 T:78269 E18764'
G[37416]='L30 E19027'
G[37417]='FA L30 E18764'
G[37418]='FH L10 E18833'
G[37420]='FA L10 A:84286 T:84286 P:G0164 E18912'
G[37421]='K32768 L20 A:-110535 T:-535 P:34561 I:37422 E18764'
G[37422]='K32768 L20 A:-120535 T:-535 P:34560 I:37421 E18764'
G[37423]='L1 E18764'
G[37424]='L1 E18764'
G[37425]='L1 E18764'
G[37426]='L1 E18764'
G[37427]='L1 E18764'
G[37428]='L1 E18764'
G[37429]='L1 E18764'
G[37430]='L1 E18764'
G[37431]='L1 E18764'
G[37432]='L1 E18764'
G[37433]='FA L50 AP:79953:=09711;579953:=09712;500146:=09713 TP:79953:=09711;579953:=09712;500146:=09713 E18764'
G[37434]='FH L50 A:79740 T:79740 E18764'
G[37435]='SP K131072 L0 A:1237946 T:1237946 E18764'
G[37439]='FH L1 RB A:15297 T:15297 E19103'
G[37440]='FH L1 RB A:15296 T:15296 E19103'
G[37441]='L5 E20444'
G[37442]='FH L1 RB A:15295 T:15295 E19103'
G[37443]='FH L1 RB A:15295 T:15295 E19103'
G[37444]='FA L1 A:16535 T:16535 P:10302 O:10304 I:9303 E18918'
G[37445]='FA L1 A:17071 T:17071 P:10302 E18918'
G[37446]='L1 A:11378 T:11378 P:25172 E19103'
G[37447]='L10 A:103761 T:107723 P:42682 E21570'	-- TODO: Probably needs prereq for Altruis
G[37448]='L45 A:110953 T:98100 E21796'
G[37449]='L10 A:90474 T:106630 TP:89362:40374;101927:40375 P:37450+37656 E21570'	-- TODO: Turn in is also 89362 if you are Night Elf Druid (probably all non demon hunter...not sure of faction though)
G[37450]='L10 A:90474 T:90474 P:40815,44140,36920 E21570'
G[37451]='L0 E18816'	-- when found Qiana Moonshadow during quest 34646, but when 34692 turned in this goes away...(as does she on her mission)
G[37452]='L40 T:87391 E18912'
G[37453]='L40 T:87391 E19342'
G[37454]='L40 T:87391 E18833'
G[37455]='L40 E18833'
G[37456]='L40 T:87391 E18833'
G[37457]='L40 E19342'
G[37458]='L100 T:87391 E18833'
G[37459]='L100 E18912'
G[37460]='L0 E18816'
G[37461]='L0 E18816'
G[37462]='L0 E18816'
G[37463]='L0 E18816'
G[37464]='L0 T:83746 E18816'
G[37465]='L0 E18816'
G[37466]='K262144 L10 A:-130630 T:-630 P:a37466 E21570'
G[37467]='K32 L10 A:88867 T:88890 P:37486 E21570'
G[37468]='L10 A:88890 T:89660 P:37467 E21570'
G[37469]='L10 A:89660 T:1240552 P:37730 E21570'
G[37470]='L10 A:89009 T:91403 P:37530 E21570'
G[37471]='L0 E18816'
G[37472]='L0 T:90066 E18816'
G[37473]='L0 T:90066 E18816'
G[37474]='L1 E18833'
G[37475]='K32768 L100 A:88155 T:78557 E18816'
G[37476]='K32768 L100 A:88155 E18816'
G[37477]='K32768 L100 A:88155 E18816'
G[37478]='K32768 L100 A:88155 T:84837 E18816'
G[37479]='FH K32768 L100 A:83869 E18833'
G[37480]='FH K32768 L100 A:84660 E18833'
G[37481]='K32768 L40 A:88155 E18833'
G[37482]='K32768 L40 A:88155 E18833'
G[37483]='FA L40 E18833'
G[37484]='L100 E18833'
G[37485]='L1 E18816'
G[37486]='L10 A:88867 T:88867 P:37497 E21570'
G[37492]='L10 A:88798 T:88798 P:37256 E21570'
G[37493]='L0 E18816'
G[37494]='L45 A:98100 T:111049 E21796'
G[37495]='L10 M109 A:1239120 T:-630 P:37538 E21570'	-- automatically accepted when 37538 turned in
G[37496]='L10 A:88798 T:88873 P:38407 E21570'
G[37497]='K32 L10 A:88115 T:88867 P:37257 E21570'
G[37501]='L40 E18816'
G[37502]='L40 E18816'
G[37503]='L40 E18816'
G[37504]='L40 E18816'
G[37505]='L40 E18816'
G[37506]='L40 E18816'
G[37507]='L10 A:88873 T:88873 P:37496 E21570'	-- determine if P: should be O:
G[37508]='L0 T:96538 E18816'
G[37509]='L0 T:92766 E18816'
G[37510]='L10 A:88873 T:88923 P:37528+37542 E21570'
G[37511]='L40 A:83734 T:76508 P:35970+35972 E18912'
G[37512]='L0 E18816'
G[37513]='L0 E18816'
G[37514]='L0 E18816'
G[37515]='L0 E18816'
G[37516]='FH L40 A:76508 T:588892 P:35973 E18912'
G[37517]='FA L40 A:76508 T:88892 P:35973 E18912'
G[37518]='L10 A:89660 T:89661 P:37736+37678 E21570'
G[37519]='L0 E21655'
G[37520]='SP K1 L35 A:87706 T:87706 E18850'
G[37523]='L40 E18850'
G[37524]='L40 E18850'
G[37525]='L0 E18850'
G[37526]='L0 T:88855 E21570'
G[37528]='L10 A:88873 T:88873 P:37507 E21570'
G[37529]='L0 E21655'
G[37530]='L10 A:89009 T:-110630 P:37469 E21570'
G[37531]='L1 E18850'
G[37532]='L0 E21655'
G[37536]='L10 A:88923 T:89048 P:37510 E21570'
G[37537]='L0 T:89016 E21570'
G[37538]='L10 A:89048 T:1239120 P:37536 E21570'
G[37539]='L0 E18850'
G[37540]='FH L40 CP CT CL A:100119310 T:76804 E18850'
G[37541]='FH L40 CR CK CM CD A:100119316 T:76804 E18850'
G[37542]='L10 A:88873 T:88873 P:37507 E21570'
G[37543]='FH L40 CW CH CS CO A:100119323 T:76804 E18850'
G[37544]='L0 E18850'
G[37545]='L0 E18850'
G[37546]='L0 E18850'
G[37547]='FH L40 CW CH CS CO A:100120207 T:76804 E18850'	-- heroic
G[37548]='FH L40 CW CH CS CO A:100120210 T:76804 E18850'	-- mythic
G[37549]='FH L40 CR CK CM CD A:100120208 T:76804 E18850'	-- heroic
G[37550]='FH L40 CR CK CM CD A:100120211 T:76804 E18850'	-- mythic
G[37551]='FH L40 CP CT CL A:100120206 T:76804 E18850'	-- heroic
G[37552]='FH L40 CP CT CL A:100120209 T:76804 E18850'	-- mythic
G[37553]='FA L40 CP CT CL A:100120277 T:75028 E18850'
G[37554]='FA L40 CR CK CM CD A:100120278 T:75028 E18850'
G[37555]='FA L40 CW CH CS CO A:100120279 T:75028 E18850'
G[37556]='L0 E18850'
G[37557]='FA L40 CP CT CL A:100120280 T:75028 E18850'	-- heroic
G[37558]='FA L40 CR CK CM CD A:100120282 T:75028 E18850'	-- heroic
G[37559]='FA L40 CW CH CS CO A:100120281 T:75028 E18850'	-- heroic
G[37560]='FA L40 CP CT CL A:100120283 T:75028 E18850'	-- mystic
G[37561]='FA L40 CR CK CM CD A:100120285 T:75028 E18850'	-- mythic
G[37562]='FA L40 CW CH CS CO A:100120284 T:75028 E18850'	-- mythic
G[37563]='FH L10 A:76730 T:76730 P:34124 E18912'	-- choose 1 of 3 followers
G[37564]='L0 E18912'
G[37565]='L10 A:1239120 T:89051 P:37538 E21570'
G[37566]='L10 A:89051 T:109334 P:37565 E21570'
G[37567]='L0 E18912'
G[37568]='L10 AP:79813:G-076018;579813:G-076019;500231:G-076020 TP:79814:G-076018;579814:G-076019;500232:G-076020 P:G-076 E18912'	--Alchemy
G[37569]='L10 AP:79867:G-060018;579867:G-060019;500233:G-060020 TP:79817:G-060018;579817:G-060019;500234:G-060020 P:G-060 E18912'	--Blacksmith
G[37570]='L10 AP:79821:G-093018;579821:G-093019;500235:G-093020 TP:79820:G-093018;579820:G-093019;500236:G-093020 P:G-093 E18912'	--Enchant
G[37571]='L10 AP:79826:G-091018;579826:G-091019;500237:G-091020 TP:86696:G-091018;586696:G-091019;500238:G-091020 P:G-091 E18912'	--Engineer
G[37572]='L10 AP:79829:G-095018;579829:G-095019;500239:G-095020 TP:79831:G-095018;579831:G-095019;500240:G-095020 P:G-095 E18912'	--Inscription
G[37573]='L10 AP:79832:G-096018;579832:G-096019;500241:G-096020 TP:79830:G-096018;579830:G-096019;500242:G-096020 P:G-096 E18912'	--Jewel
G[37574]='L10 AP:79834:G-090018;579834:G-090019;500243:G-090020 TP:79833:G-090018;579833:G-090019;500244:G-090020 P:G-090 I:36642 E18912'	--Leather	-- TODO: Need to determine what other requirement is present because Horde boosted to 100 with only 1 in leatherworking cannot get this --- most likely this will become P:G-090+X40416,G-090+40416+37935 -- well it is not completion of the leatherworking quest 36516.  nor is it getting all the recipes in leatherworking for draenor.  nor is it the blueprint, because as a boosted toon I already know it, and could not learn it again.  now having unlearned leatherworking, no quest is available.
G[37575]='L10 AP:79864:G-094018;579864:G-094019;500245:G-094020 TP:79863:G-094018;579863:G-094019;500246:G-094020 P:G-094 E18912'	--Tailor
G[37584]='L0 E18912'
G[37585]='FA L40 A:77160 T:77940 P:0 E18912'
G[37587]='L0 E18912'
G[37589]='L0 E18912'
G[37590]='L0 E18912'
G[37591]='L0 E18912'
G[37592]='FH L90 AP:79832:G-096018;579832:G-096019;500241:G-096020 TP:79830:G-096018;579830:G-096019;500242:G-096020 P:G-096+37573 E18912 Z18912'	--Jewel [I do not believe this is in game]
G[37593]='L0 E18912'
G[37594]='L0 E18912'
G[37595]='L0 E18912'
G[37596]='SP K131072 L0 A:1240644 T:1240644 E21570'
G[37597]='L1 E18912'
G[37598]='L0 T:73161 E18912'
G[37599]='L0 T:73161 E18912'
G[37600]='L0 T:700255 E18912'
G[37601]='L0 T:73161 E18912'
G[37602]='L0 T:700255 E18912'
G[37603]='L0 T:700255 E18912'
G[37604]='L0 E18912'
G[37605]='L0 T:93812 E18912'
G[37606]='L0 T:93812 E18912'
G[37607]='L0 T:73325 E18912'
G[37608]='L0 T:93812 E18912'
G[37609]='L0 T:93812 E18912'
G[37610]='L0 T:93812 E18912'
G[37611]='L0 T:93812 E18912'
G[37612]='L0 T:93812 E18912'
G[37613]='L0 T:89706 E18912'
G[37614]='L0 T:89706 E18912'
G[37622]='FH K32768 L40 A:77928 P:0 E18912'
G[37623]='FA L40 A:81492 T:77979 E18912'
G[37624]='FH L40 A:78985 E18912'
G[37626]='FH L40 A:74253 P:0 E18912'
G[37627]='FA L40 A:86949 T:87788 P:1 E18912'
G[37628]='FH L40 A:88892 T:83848 E18912'
G[37629]='FA L40 A:83051 P:0 E18912'
G[37630]='FH L40 A:83052 P:0 E18912'	-- TODO:Yoshimo: probably replaced with 36693
G[37631]='FA L40 A:83858 T:-539 E18912'
G[37632]='FH L40 A:94789 T:86024 E18912'
G[37633]='FA L40 A:81492 T:78168 E18912'
G[37634]='FH K32768 L40 A:-539 E18912'
G[37635]='FA L40 A:83858 T:84871 E18912'
G[37636]='FH L40 A:86979 E18912'
G[37637]='L0 T:88208 E18912'
G[37638]='L0 E18912'
G[37639]='L0 E18912'
G[37640]='L0 E18912'
G[37644]='L1 A:85418 T:90071 P:0 E18912'	-- TODO: Yoshimo: requires at least the garrison being build
G[37645]='L1 T:90071 E18912'
G[37646]='L0 E18912'
G[37647]='L0 E18912'
G[37648]='L40 E18912'
G[37649]='SP K131072 L0 A:1240645 T:1240645 E21570'
G[37650]='L0 E18912'
G[37652]='L0 T:82616 E18912'
G[37653]='L10 A:89398 T:89398 P:44137,38834 E21570'
G[37654]='L10 A:91419 T:106881 E21570'	-- obviously no prequests
G[37656]='L10 A:90474 T:90474 P:40815,44140,36920 E21570'
G[37657]='L10 A:91419 T:91419 E21570'	-- obviously no prequests
G[37658]='L10 A:90317 T:90317 P:44137,38834 E21570'
G[37659]='L10 A:106881 T:1239328 P:37654 E21570'
G[37660]='L10 A:89398 T:89398 P:37653 E21570'
G[37666]='L45 A:110793 T:110953 E21796'
G[37667]='L0 I:36100,37669 E19342'
G[37669]='L10 A:78466 T:78466 P:K100109258,K100111812,K100111813,K100111814,K100111815,K100111816,K100111817,K100111818,Z156522,Z161386,Z161387,Z161388,Z161389,Z161390,Z161391,Z161392 I:36100,37667 E19027'
G[37670]='L0 E18988'
G[37671]='L0 T:86682 E18988'
G[37672]='L0 E18988'
G[37673]='L0 E18988'
G[37674]='L0 E18988'
G[37675]='L0 E18988'
G[37676]='L0 E18988'
G[37677]='L0 T:72761 E18988'
G[37678]='L10 A:89849 T:89849 P:37468 E21570'
G[37681]='L0 E18988'
G[37682]='L0 E18988'
G[37683]='L0 E18988'
G[37684]='L0 E18988'
G[37687]='FA L40 A:91290 T:91290 P:38446 E19890 D124'
G[37688]='FH L40 A:91292 T:91292 P:38001 E19890 D125'
G[37689]='L45 A:111049 T:98100 E21796'
G[37690]='L10 A:89975 T:89023 P:42271 E21570'
G[37691]='L0 E21570'
G[37697]='L0 E21570'
G[37713]='SP K131072 L0 A:1240646 T:1240646 E21570'
G[37726]='L0 T:89650 E21570'
G[37727]='L10 A:89341 T:89341 P:37256 E21570'
G[37728]='L10 A:89341 T:89341 P:37256 E21570'
G[37729]='L10 A:89661 T:89661 P:42371 E21570'
G[37730]='L10 A:89661 T:89660 P:37729 E21570'
G[37733]='L10 A:89023 T:589023 P:37256 E21570'
G[37736]='L10 A:89660 T:89660 P:37468 E21570'
G[37749]='L40 E19890'
G[37750]='L100 E19533'
G[37751]='L40 E19906'
G[37752]='L100 E19953'
G[37753]='L100 E19890'
G[37754]='L40 E20173'
G[37756]='FH K132 L40 A:89753 T:578487 P:=05873 E19750'
G[37757]='FH K132 L40 A:89753 T:578487 P:=05873 E19750'
G[37758]='FH K132 L40 A:89753 T:578487 P:=05873 E19750'
G[37762]='FH K132 L40 A:89753 T:578487 P:=05873 E19750'
G[37763]='FH K132 L40 A:89753 T:578487 P:=05873 E19750'
G[37764]='FH K132 L40 A:89753 T:578487 P:=05873 E19750'
G[37765]='FH K132 L40 A:89753 T:578487 P:=05873 E19750'
G[37766]='FA K132 L40 A:89763 T:81492 P:=09713 E19533 D094'
G[37767]='FA K132 L40 A:89763 T:81492 P:=09713 E19533 D094'
G[37768]='FA L40 A:91196 T:81492 E19890'
G[37769]='FA K4 L40 A:91196 T:81492 E19890'
G[37770]='FA K4 L40 A:91196 T:90851 E20157'
G[37771]='FA L40 T:90851 E19890'
G[37772]='FA L40 T:90851 E19906'
G[37773]='FA K514 L40 A:89805 T:81492 P:=09713 E19445 D094'
G[37774]='FA K514 L40 A:89805 T:81492 P:=09713 E19445 D094'
G[37775]='FA K514 L40 A:89805 T:81492 P:=09713+X36222 E19445 D094'
G[37776]='FA K514 L40 A:89805 T:81492 P:=09713 E19445 D094'
G[37777]='FA K514 L40 A:89805 T:81492 P:=09713 E19445 D094'
G[37778]='FA K514 L40 A:89805 T:81492 P:=09713 E19445 D094'
G[37779]='K262144 L10 M109 A:-370630 T:-630 P:a37779 E21570'	-- TODO:also completed 42020, does this become a world quest for level 110?
G[37780]='FH K66 L20 A:89753 T:78487 P:=09763 E19533 D099'
G[37781]='FH K66 L10 A:89753 T:78487 P:=09763 E19533 D099'
G[37782]='FH K66 L35 A:89753 T:78487 P:=09763 E19533 D099'
G[37783]='FH K66 L15 A:89753 T:78487 P:=09763 E19533 D099'
G[37784]='FH K66 L10 A:89753 T:78487 P:=09763 E19533 D099'
G[37785]='FH K66 L30 A:89753 T:78487 P:=09763 E19533 D099'
G[37786]='FH K66 L35 A:89753 T:78487 P:=09763 E19533 D099'
G[37787]='FH K66 L35 A:89753 T:78487 P:=09763 E19533 D099'
G[37788]='K2 L40 AA:89793 AH:589793 T:-950 P:=09713,=09763 E19551 D094 D099'
G[37789]='FA K66 L35 A:89763 T:81492 P:=09713 E19533 D094'
G[37790]='FA K66 L35 A:89763 T:81492 P:=09713 E19533 D094'
G[37791]='FA K66 L30 A:89763 T:81492 P:=09713 E19533 D094'
G[37792]='FA K66 L10 A:89763 T:81492 P:=09713 E19533 D094'
G[37793]='FA K66 L15 A:89763 T:81492 P:=09713 E19533 D094'
G[37794]='FA K66 L35 A:89763 T:81492 P:=09713 E19533 D094'
G[37795]='FA K66 L10 A:89763 T:81492 P:=09713 E19445 D094'
G[37796]='FA K66 L20 A:89763 T:81492 P:=09713 E19596 D094'
G[37797]='K2 L40 A:-550,1239791 T:-110550 P:37788 E19596'
G[37798]='K2 L40 A:-110550,1239791 T:-120550 P:37797 E19551'
G[37799]='K2 L40 A:-120550,1239791 T:-130550 P:37798 E19596'
G[37800]='L0 E19551'
G[37802]='L0 E19551'
G[37803]='L0 E19551'
G[37804]='L0 E19551'
G[37805]='L0 E19551'
G[37811]='FA K2 L40 A:-130550,1239791 T:81492 P:37799 E19596'
G[37812]='L1 E21570'
G[37813]='FH K514 L40 A:89806 T:78487 P:=09763 E19445 D099'
G[37814]='FH K514 L40 A:89806 T:78487 P:=09763 E19445 D099'
G[37815]='FH K514 L40 A:89806 T:78487 P:=09763+X36222 E19445 D099'
G[37816]='FH K514 L40 A:89806 T:78487 P:=09763 E19445 D099'
G[37817]='FH K514 L40 A:89806 T:78487 P:=09763 E19445 D099'
G[37818]='FH K514 L40 A:89806 T:78487 P:=09763 E19445 D099'
G[37819]='L7864576 A:74056 T:74056 P:PR001+L020 E19551'
G[37820]='L0 T:89816 E21570'	-- gotten killing Golza the Iron Fin (89816) 1015:65.63,40.19
G[37821]='L0 T:88086 E21570'
G[37822]='L0 T:89850 E21570'
G[37823]='L0 T:89865 E21570'
G[37824]='SP K65536 L0 A:89884 T:89884 E21570'
G[37825]='L0 E21570'
G[37826]='L0 E21570'
G[37827]='L0 E21570'
G[37828]='SP K131072 L0 A:1240643 T:1240643 E21570'
G[37829]='SP K131072 L0 A:1240629 T:1240629 E21570'
G[37830]='SP K131072 L0 A:1240639 T:1240639 E21570'
G[37831]='SP K131072 L0 A:1240630 T:1240630 E21570'
G[37832]='L0 E21570'
G[37833]='L0 E21570'
G[37834]='K4096 L40 A:83823 T:83823 P:36017 E19750'
G[37835]='K4096 L40 A:-539 T:92213 E19750'	-- 947:54.89,15.26 -- while doing 37834
G[37836]='K4096 L40 A:83823 T:83823 P:37834 E19750'
G[37837]='K4096 L40 A:90233 T:90233 P:37964 E19750'
G[37838]='SP K4096 L40 A:90237 T:90237 P:37837 U466 E19890'
G[37839]='FA L40 A:92213 T:591913 P:39003 E20444'
G[37840]='FH L40 T:96130 P:39003 E20444'
G[37841]='K4096 L40 A:90233 TA:92213 TH:592213 P:37837 E19750'
G[37842]='L0 E19551'
G[37843]='L0 E21570'
G[37844]='L0 E21570'
G[37845]='L0 E21570'
G[37848]='K2 L40 AA:89793 AH:589793 T:-948 P:=09713,=09763 E19551 D094 D099'
G[37849]='L40 A:-542 T:-150542 P:37848 E19658'
G[37850]='L40 A:-150542 T:-160542 P:37849 E19658'
G[37851]='L40 A:-160542 T:-170542 P:37850 E19658'
G[37852]='FA L40 A:-170542 T:81492 P:37851 E19658'
G[37853]='L10 A:93354 T:89794 P:38443 E21570'
G[37854]='L0 E21655'
G[37855]='L10 A:89975 T:89978 P:42271 E21570'
G[37856]='L10 A:90916 T:90916 P:37855 E21570'
G[37857]='K32 L10 A:700004 T:89978 P:37957+37859+37856 E21570'
G[37858]='L10 E21570'
G[37859]='L10 A:90423 T:89978 P:37855 E21570'
G[37860]='L10 A:90383 T:-630 P:37960+37959 E21570'
G[37861]='L10 A:89978 T:107995 P:37960+37959 E21570'
G[37862]='L10 A:107995 T:90738 P:37861 E21570'
G[37864]='L0 E19551'
G[37865]='FH L40 T:700295 E19906'
G[37866]='FA K2 L40 A:84286 T:89936 E19953'
G[37867]='L0 E21570'
G[37868]='K1 L1 A:90473 T:90473 P:37911 E19658'
G[37869]='L0 T:90057 E21570'
G[37881]='K2 L40 AA:89793 AH:589793 T:-947 P:=09713,=09763 E19551 D094 D099'
G[37882]='L40 A:-539 T:-140539 P:37881 E19551'
G[37883]='L40 A:-140539 T:-150539 P:37882 E19551'
G[37884]='L40 A:-150539 T:-539 P:37883 E19551'
G[37885]='FA L40 A:-539 T:81492 P:37884 E19551'
G[37886]='L0 T:92766 E19890'
G[37887]='L0 T:92766 E19890'
G[37888]='L0 E19890'
G[37889]='FH L40 A:594429 T:89822 P:39242 I:38435 E19934'
G[37890]='FH L40 A:89822 T:90238 P:37889 I:38436 E19890'
G[37891]='K2 L40 A:1239902 T:90309 P:38446 E19890 D104'
G[37892]='L0 T:90620 E19890'
G[37908]='L0 T:90139 E21570'
G[37909]='L0 T:90164 E21570'
G[37910]='K2 L7864576 A:74056 T:74056 P:37819 E19658'
G[37911]='K2 L1 A:90473 T:90473 P:37819 E19658'
G[37914]='K2 L40 AA:89793 AH:589793 T:-130941 P:=09713,=09763 E19551 D094 D099'
G[37916]='L40 A:-130525 T:-525 P:37914 E19658'
G[37917]='K2 L40 A:-525 T:-140525 P:37916 E19658'
G[37918]='L40 A:-140525 T:-150525 P:37917 E19769'
G[37919]='FA K2 L40 A:-150525 T:81492 P:37918 E19769'
G[37921]='FA L40 A:90180 T:91593 E19890'
G[37924]='FA L40 E19890'
G[37927]='L0 E21570'
G[37928]='L0 T:90217 E21570'
G[37930]='L0 E21570'
G[37932]='L0 T:90244 E21570'
G[37933]='L0 E19890'
G[37934]='FH L40 A:90238 T:590238 P:37890 I:38444 E19890'
G[37935]='FH L40 A:590238 T:90481 P:37934 I:38445 E19890'
G[37937]='L0 T:92451 E19890'
G[37938]='FA K2 L40 A:96147 T:89686 E19934'
G[37939]='L0 T:92766 E19890'
G[37940]='K2 L40 A:1241725 T:90481 P:38001 E19890 D107'
G[37941]='K2 L40 AA:89793 AH:589793 T:-949 P:=09713,=09763 E19551 D094 D099'
G[37942]='L40 A:-543 T:-190543 P:37941 E19769'
G[37943]='L40 A:-190543 T:-200543 P:37942 E19769'
G[37944]='L40 A:-200543 T:-210543 P:37943 E19769'
G[37945]='FA L40 A:-210543 T:78487 P:37944 I:37996 E19769'
G[37946]='L0 E19890'
G[37947]='L0 E19890'
G[37948]='FA K514 L40 A:89805 T:81492 P:=09713+36222 E19445 D094'
G[37949]='FH K514 L40 A:89806 T:78487 P:=09763+36222 E19445 D099'
G[37953]='L0 T:90024 E19890'
G[37956]='SP K131072 L0 A:1240003 T:1240003 E19890'
G[37957]='L10 A:90065 T:89978 P:37855 E21570'
G[37958]='SP K131072 L0 A:1240634 T:1240634 E21570'
G[37959]='L10 A:90383 T:90383 P:37857 E21570'
G[37960]='L10 A:89978 T:89978 P:37857 E21570'
G[37961]='FH L40 A:91072 T:91072 P:37935 E19658'
G[37962]='L0 E21570'
G[37963]='L10 M109 A:89978 T:-630 P:37857 E21570'	-- automatically gotten when turning in 37857
G[37964]='K4096 L40 A:83823 T:90233 P:37836 E19890'
G[37965]='K262144 L10 M109 A:-120630 T:-630 P:a37965 E21570'
G[37966]='FA K2 L40 A:96147 T:92546 E19890'
G[37967]='L0 T:92819 E19890'
G[37968]='K2 L40 A:1239902 T:90309 P:38446 E19890 D104'
G[37969]='L0 T:91695 E19890'	-- Vol'mar is built (also causes 38433 to be marked complete even though that is building Lion's Watch)
G[37970]='FH L40 A:90481 T:92616 E19934'
G[37972]='L40 E19890'
G[37973]='K2 L40 AA:89793 AH:589793 T:-100948 P:=09713,=09763 E19551 D094 D099'
G[37974]='L40 E19658'
G[37975]='L100 E19934'
G[37976]='L40 A:-100542 T:-110542 P:37973 E19658'
G[37977]='L40 A:-110542 T:-120542 P:37976 E19658'
G[37978]='L40 A:-120542 T:-130542 P:37977 E19658'
G[37979]='FA L40 A:-130542 T:81492 P:37978 E19658'
G[37980]='SP K131072 L0 A:1240635 T:1240635 E21570'
G[37981]='L35 E19658'
G[37982]='L0 E21570'
G[37983]='L0 E21570'
G[37984]='L0 E21570'
G[37985]='L0 E21570'
G[37986]='L0 E21570'
G[37987]='L0 E21570'
G[37988]='L0 E21570'
G[37989]='L0 T:90505 E21570'
G[37990]='L0 T:90519 E19890'
G[37991]='L10 A:89795 T:90543 P:37853 E21570'
G[37992]='FH K2 L40 A:-130550 T:78487 P:37799 E19596'
G[37993]='FH L40 A:-170542 P:37851 E19658'
G[37994]='FH L40 A:-539 T:78487 P:37884 E19551'
G[37995]='FH L40 E19658'
G[37996]='FH L40 A:-210543 T:578487 P:37944 I:37945 E19769'
G[37997]='FH L40 A:-130542 T:578487 P:37978 E19658'
G[38000]='L0 E21570'
G[38001]='FH L40 A:90553 T:90481 P:38577 E19890'	-- war table appears after completing this quest
G[38003]='L0 E19658'
G[38004]='L0 E19658'
G[38005]='L0 E19658'
G[38006]='L0 E19658'
G[38007]='L0 E19658'
G[38008]='FA L25600 E19890'
G[38009]='FH L40 A:91291 T:90482 E19906'
G[38010]='L0 T:92766 E19890'
G[38014]='L10 A:102988 T:102988 P:37862 E21570'
G[38015]='L10 A:90738 T:90738 P:37862 E21570'
G[38016]='L0 E21796'
G[38020]='FH L40 T:92910 E19906'
G[38021]='L0 T:92819 E19890'
G[38022]='L0 E19890'
G[38026]='L0 T:90429 E19890'
G[38028]='L0 T:90777 E19890'
G[38029]='L0 T:90438 E19890'
G[38030]='L0 T:90437 E19890'
G[38031]='SP L0 A:90434 T:90434 E19890'
G[38032]='L0 A:90442 T:90442 E19890'
G[38034]='L0 T:90782 E19890'
G[38035]='FA L10 A:96644 T:596644 P:39735,44700 E21570'
G[38036]='FA L10 A:90783 T:90783 P:B39800 E21570'
G[38037]='L0 T:90803 E21570'	-- Cache of infernals located at 1015:35.32,50.38
G[38038]='L0 E19890'
G[38039]='L0 T:92766 E19890'
G[38040]='FH L40 E19906'
G[38041]='L0 E19890'
G[38042]='L0 T:92819 E19890'
G[38043]='FA K2 L40 A:96147 T:95235 E19906'
G[38044]='K2 L40 A:1241725 T:90481 P:38001 E19953 D107'
G[38045]='K2 L40 A:1239902 T:90309 P:38446 E19906 D104'
G[38046]='FA K2 L40 A:1239902 T:90309 P:38446 E19934 D104'
G[38047]='FH K2 L40 A:1241725 T:90481 P:38001 E19953 D107'
G[38051]='FA K2 L40 A:96147 T:90482 E19934'
G[38052]='FA L10 A:90749 T:90749 P:B39800 E21570'
G[38053]='FA L10 A:90866 T:90866 P:B39800 E21570'
G[38054]='FH K2 L40 A:95424 T:90585 E19953'
G[38057]='FA L10 A:90783 T:92414 P:38558+38053+38052 E21570'	-- TODO: Verify requires 38053
G[38058]='FA L10 A:90866 T:-634 P:38558+38053+38036+38052 E21570'	-- TODO: Verify requires 38053
G[38059]='FA L10 A:92414 T:-634 P:38057 E21570'
G[38060]='FA L10 A:-634 T:590749 P:38058 E21570'	-- The Aftermath "earned"
G[38061]='L0 T:90901 E21570'
G[38063]='L0 E19658'
G[38064]='L0 E19658'
G[38065]='L0 T:92031 E19658'
G[38066]='L0 T:93812 E19658'
G[38067]='L0 E19658'
G[38068]='L0 E19658'
G[38069]='L0 E19658'
G[38070]='L0 E19658'
G[38071]='L0 E19658'	-- FA I:38072 buy Music Roll: High Seas from 67881 Proveditor Grantley 857:89.53,33.55
G[38072]='L0 E19658'	-- FH I:38071
G[38073]='L0 E19658'
G[38074]='L0 E19658'
G[38075]='L0 E19658'
G[38076]='L0 E19658'
G[38077]='L0 E19658'
G[38078]='L0 E19658'
G[38079]='L0 E19658'
G[38080]='L0 E19658'
G[38081]='L0 E19658'
G[38082]='L0 E19658'
G[38083]='L0 E19658'
G[38084]='L0 E19658'
G[38085]='L0 E19658'
G[38086]='L0 E19658'
G[38087]='L0 E19658'
G[38088]='L0 E19658'	-- Music Roll: Ghost, available only when dead from interacting with Forlorn Composer (91592) 34:23.65,33.12
G[38089]='SP L0 A:100122224 T:100122224 P:38356,37961 E19658'
G[38090]='SP L0 A:100122226 T:100122226 P:38356,37961 E19658'
G[38091]='L0 T:93812 E19658'
G[38092]='L0 E19658'
G[38093]='L0 E19658'
G[38094]='L0 E19658'
G[38095]='L0 E19658'
G[38096]='L0 E19658'	-- loot Music Roll: Faerie Dragon from "Faerie Dragon Nest" (240624)" at 20:17.56,67.56 during periodic event
G[38097]='L0 E19658'	-- Music Roll: Totems of the Grizzlemaw, gotten when interacting with Remington Brode (91632) in Zone 490 (his path is huge)
G[38098]='L0 T:92031 E19658'
G[38099]='L0 E19658'	-- buy 122238 Music Roll: Darkmoon Carousel from 85484 Chester 823:51.50,75.08
G[38100]='SP L0 A:100122239 T:100122239 P:38356,37961 E19658'
G[38101]='L0 E19658'
G[38102]='L0 E19658'	-- buy 122221 (Music Roll: Song of Liu Lang) from 64605 Tan Shin Tiao 811:82.22,29.30, need revered with Lorewalkers
G[38103]='L7 E19658'
G[38104]='L7 E19658'
G[38105]='L7 E19658'
G[38106]='L7 E19658'
G[38107]='L7 E19658'
G[38108]='L7 E19658'
G[38109]='L10 E19658'
G[38110]='L20 E19658'
G[38111]='L30 E19658'
G[38112]='L40 E19658'
G[38113]='L1 E19658'
G[38114]='L10 E19658'
G[38115]='L10 E19658'
G[38116]='L10 E19658'
G[38117]='L10 E19658'
G[38118]='L10 E19658'
G[38119]='L10 E19658'
G[38120]='L10 E19658'
G[38121]='L20 E19658'
G[38122]='L30 E19658'
G[38123]='L40 E19658'
G[38124]='L1 E19658'
G[38125]='L10 E19658'
G[38126]='L10 E19658'
G[38127]='L10 E19658'
G[38128]='L10 E19658'
G[38129]='L10 E19658'
G[38130]='L10 E19658'
G[38131]='L10 E19658'
G[38132]='L20 E19658'
G[38133]='L30 E19658'
G[38134]='L40 E19658'
G[38135]='L1 E19658'
G[38136]='L10 E19658'
G[38137]='L10 E19658'
G[38138]='L10 E19658'
G[38139]='L10 E19658'
G[38140]='L10 E19658'
G[38141]='L10 E19658'
G[38142]='L10 A:94179 T:73426 P:38384 E21570'
G[38143]='L10 A:73426 T:700274 P:38455+38246+38146 E21570'	-- TODO: Verify requires 38455 38146
G[38144]='L10 A:700274 T:591223 P:38143 E21570'
G[38145]='L10 A:700274 T:591223 P:38143 E21570'
G[38146]='L10 A:100128340 T:93890 E21570'	-- verified do not need to turn in 38142 for this to be available, so for now assuming always available
G[38147]='L10 A:591223 T:700282 P:38144+38145 E21570'
G[38148]='L10 A:700282 T:91109 P:38235+38225+38147+40573 I:38322,38323 E21570'
G[38149]='L10 E19658'
G[38150]='L20 E19658'
G[38151]='L30 E19658'
G[38152]='L40 E19658'
G[38153]='L1 E19658'
G[38154]='L10 E19658'
G[38155]='L10 E19658'
G[38156]='L10 E19658'
G[38157]='L10 E19658'
G[38158]='L10 E19658'
G[38159]='L10 E19658'
G[38160]='L10 E19658'
G[38161]='L20 E19658'
G[38162]='L30 E19658'
G[38163]='L40 E19658'
G[38164]='L1 E19658'
G[38165]='L10 E19658'
G[38166]='L10 E19658'
G[38167]='L10 E19658'
G[38168]='L10 E19658'
G[38169]='L10 E19658'
G[38170]='L10 E19658'
G[38171]='L10 E19658'
G[38172]='L10 E19658'
G[38173]='L10 E19658'
G[38174]='L10 E19658'
G[38175]='FA K2 L10 AP:77377:G-008024;577377:G-008023 TP:77377:G-008024;577377:G-008023 P:G0010 E19658'
G[38176]='L40 A:100122405 T:78495 E19658'
G[38177]='L40 A:100122403 T:78495 E19658'
G[38178]='L40 A:100122402 T:78495 E19658'
G[38179]='L40 A:100122400 T:78495 E19658'
G[38180]='L40 A:100122424 T:78495 E19658'
G[38181]='L40 A:100122421 T:78495 E19658'
G[38182]='L40 A:100122418 T:78495 E19658'
G[38183]='L40 A:100122416 T:78495 E19658'
G[38184]='L40 A:100122413 T:78495 E19658'
G[38185]='L40 A:100122411 T:78495 E19658'
G[38186]='L40 A:100122408 T:78495 E19658'
G[38187]='L40 A:100122412 T:78495 E19658'
G[38188]='FH K2 L10 N54 AP:79815:G-008024;579815:G-008023 TP:79815:G-008024;579815:G-008023 P:G0010 E19658'
G[38189]='L40 A:100122401 T:500220 E19658'
G[38190]='L40 A:100122399 T:500220 E19658'
G[38191]='L40 A:100122406 T:500220 E19658'
G[38192]='L40 A:100122404 T:500220 E19658'
G[38193]='L40 A:100122423 T:500220 E19658'
G[38194]='L40 E19658'	-- missive (Nimhfree cannot buy the Gorian proving grounds so not sure which is FA and which is FH)
G[38195]='L40 A:100122422 T:500220 E19658'
G[38196]='L40 A:100122417 T:500220 E19658'
G[38197]='L40 A:100122415 T:500220 E19658'
G[38198]='L40 A:100122414 T:500220 E19658'
G[38199]='L40 A:100122409 T:500220 E19658'
G[38200]='L40 A:100122407 T:500220 E19658'
G[38201]='L40 A:100122410 T:500220 E19658'
G[38202]='L40 E19658'	-- missive (Nimhfree cannot buy the Gorian proving grounds so not sure which is FA and which is FH)
G[38203]='L10 N53 A:91061,91065 T:91061 E21570'	-- NPC appears when you get to the spot for 91065
G[38204]='L100 E19769'
G[38206]='FA L10 A:596644 T:96663 P:38035 E21570'
G[38207]='L0 T:91087 E19890'
G[38208]='SP K131072 L0 A:1240289 T:1240289 E19890'
G[38209]='L0 T:91093 E19890'
G[38210]='FA L10 N57 A:97306 T:96254 P:38060 I:38459 E21570'
G[38211]='L0 T:92396 E19890'
G[38212]='L0 T:93679 E21570'
G[38213]='L40 A:91291 T:1240317 P:38267,38269 E19890'
G[38214]='L0 E19890'
G[38215]='L0 E21570'
G[38217]='L0 T:91115 E21570'
G[38218]='L0 E21655'
G[38219]='L0 E21655'
G[38220]='L0 E21570'
G[38221]='L0 E19890'
G[38222]='L0 E19890'
G[38223]='L40 A:1240317 T:89400 P:38213 E19890'
G[38224]='L0 E19890'
G[38225]='L10 A:91066 T:91066 P:38381,44106 E21570'
G[38231]='L0 T:90312 E19890'
G[38232]='L10 A:91166 T:91165 P:38460 E21570'
G[38234]='L0 T:700220 E19890'
G[38235]='L10 A:91066 T:91066 P:38381,44106 E21570'
G[38236]='L0 T:95236 E19890'
G[38237]='L10 A:91165 T:591166 P:38232 E21570'
G[38238]='L0 T:91187 E21570'
G[38239]='L0 E21570'
G[38240]='L100 E19934'
G[38241]='L35 A:85418 T:85418 P:=05813 E19658'
G[38242]='L35 A:79858 T:79858 P:=05873 E19658'	-- available for Horde boost to 100
G[38243]='SP K2 L10 AA:90894 AH:91030 TA:90894 TH:91030 P:=09713,=09763 E19658 D094 D099'
G[38246]='L10 A:93581 T:93890 P:38142 O:38922 E21570'
G[38250]='FA K2 L40 A:1239902 T:90309 P:38446 E19934 D104'
G[38251]='SP K131072 L0 A:1240642 T:1240642 E21570'
G[38252]='FH K2 L40 A:1241725 T:90481 P:38001 E19906 D107'
G[38253]='FA L40 AZ:581 T:92219 P:>05812 E19890'	-- TODO: Should this be I:40418 ?
G[38254]='L40 A:90180 T:90177 P:38257 I:38570 E19890'
G[38255]='L40 A:90177 T:91242 P:38254 I:38571 E19890'
G[38256]='FA L40 A:91242 T:591242 P:38255 I:38572 E19890'
G[38257]='L40 A:92219 T:90180 P:38253,40418 I:38568 E19890'
G[38258]='FA L40 A:591242 T:92219 P:38256 I:38573 E19890'
G[38259]='L40 A:92219 T:500216 P:38258 I:38574 E19890'
G[38260]='L0 E19934'
G[38261]='L0 E19890'
G[38262]='L0 T:90884 E19890'
G[38263]='L0 T:90885 E19890'
G[38264]='L0 T:90888 E19890'
G[38265]='L0 T:90887 E19890'
G[38266]='L0 T:90936 E19890'
G[38267]='FA L40 A:91290 T:91291 P:37687 E19890'
G[38268]='L0 T:91289 E21570'
G[38269]='FH L40 A:91292 T:91291 P:37688 E19906'
G[38270]='L40 A:-534 T:91299 P:38560,38453 E19890'
G[38271]='L40 A:91299 T:91351 P:38270 E19890'
G[38272]='L40 A:91351 T:91324 P:38271 E19890'
G[38273]='L40 A:1240547 T:-534 P:38271 E19890'
G[38274]='L40 A:91324 T:92317 P:38272 E19890'
G[38275]='L0 E21570'
G[38276]='L0 E19658'
G[38277]='SP K131072 L0 A:1240519 T:1240519 E21570'
G[38278]='L0 E21570'
G[38279]='L0 E21570'
G[38280]='L0 E19890'
G[38281]='L0 E21570'
G[38282]='L0 T:91374 E19890'
G[38283]='SP K131072 L0 A:1240543 T:1240543 E19890'
G[38284]='L0 E21655'
G[38285]='L0 E21655'
G[38286]='L10 N57 A:91403 T:96028 P:37470 E21570'
G[38287]='SP K2 L10 AA:91024 AH:91033 TA:91024 TH:91033 P:=09713,=09763 E19658 D094 D099'
G[38290]='SP K2 L10 AA:91020 AH:91029 TA:91020 TH:91029 P:=09713,=09763 E19658 D094 D099'	-- just like 39225, this is available to Horde boost to 100
G[38293]='SP K2 L10 AA:91025 AH:91034 TA:91025 TH:91034 P:=09713,=09763 E19658 D094 D099'
G[38296]='SP K2 L10 AA:91404 AH:91031 TA:91404 TH:91031 P:=09713,=09763 E19658 D094 D099'
G[38299]='K16386 L1 A:91017 T:91017 E19658 D094'
G[38300]='K8194 L1 A:91364 T:91364 E19658 D099'	-- available for Horde boost to 100
G[38304]='L10 E21570'
G[38305]='L10 T:92104 E21570'
G[38306]='FH L40 A:91072 T:6566 P:37935 E19658'	-- for the Horde boost to 100, not available until Tanaan output founded
G[38307]='FH L10 A:596683 T:96683 P:39864 E21570'
G[38308]='FH L10 A:1244453 T:-634 P:38362 E21570'
G[38309]='L0 E21570'
G[38310]='L0 E21570'
G[38311]='L0 E21570'
G[38312]='FA L10 A:91222 T:91481 P:38473 E21570'
G[38313]='L0 E21691'
G[38314]='L0 E21570'
G[38315]='L0 E19890'
G[38316]='SP K131072 L0 A:1240631 T:1240631 E21570'
G[38317]='FH L10 A:113911 T:97250 P:38308 E21570'
G[38318]='FA L10 A:91481 T:91519 P:38312 E21570'
G[38320]='SP K131072 L0 A:1240577 T:1240577 E19890'
G[38321]='L0 E21570'
G[38322]='L10 A:91066 T:91109 P:38235+38225+38147+40573 I:38148,38323 E21570'	-- TODO: Verify requires 38235 (same with other quests in I: code)
G[38323]='L10 A:100573 T:91109 P:38235+38225+38147+40573 I:38148,38322 E21570'
G[38324]='L10 A:91531 T:91531 P:39837 E21570'
G[38331]='L10 A:96254 T:96254 P:38210,38459 E21570'
G[38332]='FH L10 A:91473 T:91158 P:39801 E21570'
G[38333]='L0 T:108526 E21570'
G[38334]='SP K131072 L0 A:1240580 T:1240580 E19890'
G[38337]='FA L10 A:91486 TP:91553:c38342;91558:C38342 E21570'	-- gotten from Storm Drake Scale dropped from Stormwing Drake	-- TODO: If you want until you have completed the quests in the tower before you turn this in, you need to do it at NPC 91771
G[38339]='L10 A:91531 T:91531 P:39837 E21570'
G[38341]='L0 E21655'
G[38342]='FA L10 A:91553 T:91558 P:38410 E21570'
G[38343]='L10 M109 A:-100649 T:-649 E21570'
G[38344]='FA L40 A:91589 T:6294 E19658'	-- TODO: Figure out prerequisites, possibly from http://www.wowhead.com/quest=38344/mystery-notebook#comments
G[38345]='FA L40 A:6294 T:6294 P:38344 E19658'
G[38346]='FH L40 A:6566 T:6566 P:38306 E19658'
G[38347]='L10 A:91531 T:97419 P:38324+38339 E21570'
G[38348]='L0 E19658'
G[38351]='FH L10 T:90286 E19750'
G[38352]='L0 T:91579 E21570'
G[38353]='L0 E21655'
G[38354]='FA L10 AP:77367:G-037024;577367:G-037023 TP:77367:G-037024;577367:G-037023 P:G-037 E19658'
G[38355]='SP K131072 L0 A:1240605 T:1240605 E21570'
G[38356]='FA L40 A:91589 T:91589 E19658'
G[38357]='FH L10 A:91590 T:91590 P:39801 E21570'
G[38358]='FH L10 A:91590 T:91590 P:39801 E21570'
G[38359]='SP K131072 L0 T:-641 E21570'	-- small treasure chest at 1018:54.41,74.19
G[38360]='FH L10 A:700621 T:91158 P:38332 E21570'
G[38361]='FH L10 A:700621 T:91158 P:38332 E21570'
G[38362]='FH L10 A:700630 T:91158 P:38361+38360 E21570'	--TODO: Yoshimo: verify 38360
G[38363]='SP K131072 L0 A:1240609 T:1240609'
G[38364]='L0 E21953'
G[38365]='SP K131072 L0 A:1240638 T:1240638 E21570'
G[38366]='SP K131072 L0 A:1240612 T:1240612 E21570'
G[38367]='SP K131072 L0 A:1240637 T:1240637 E21570'
G[38368]='L0 E21570'
G[38369]='SP K131072 L0 A:1240614 T:1240614 E21570'
G[38370]='SP K131072 L0 A:1240641 T:1240641 E21570'
G[38371]='SP K131072 L0 A:1240619 T:1240619 E21570'
G[38372]='SP K262144 L10 M109 A:-100641 T:-641 P:a38372 E21570'
G[38374]='SP K32768 L10 M109 A:-100634 T:-634 P:B38318 E21570'
G[38376]='L10 A:3000002 T:91144 P:42774 E21531'
G[38377]='L10 A:91109 T:100387 P:38148,38322,38323 E21570'
G[38380]='L0 E21570'
G[38381]='L10 XD A:94179 T:91066 P:38384 E21570'
G[38382]='L10 A:94179 T:95395 P:38384 E21570'
G[38383]='L0 E21570'
G[38384]='L10 A:91109 T:94179 P:40122 E21570'
G[38386]='SP K131072 L0 A:1240651 T:1240651 E21570'
G[38387]='SP K131072 L0 A:1240652 T:1240652 E21570'
G[38388]='SP K131072 L0 A:1240653 T:1240653 E21570'
G[38389]='SP K131072 L0 A:1240654 T:1240654 E21570'
G[38390]='L0 E21570'
G[38391]='L0 E21570'
G[38392]='L0 E21570'
G[38393]='L0 E21570'
G[38394]='FA L40 A:6294 T:6294 P:38345 E19658'
G[38395]='FH L40 A:6566 T:6566 P:38346 E19658'
G[38396]='FA L40 A:6294 T:6294 P:38394 I:38397 E19658'
G[38397]='FH L40 A:6566 T:6566 P:38395 I:38396 E19750'
G[38398]='L0 E21570'
G[38399]='L1 E20363'
G[38400]='L0 T:91695 E19890'
G[38401]='L0 E19890'
G[38402]='FA L40 A:6294 T:6294 P:38396 E19750'
G[38404]='FH L40 A:6566 T:6566 P:38397 E19750'
G[38405]='FA L10 A:91481 T:91519 P:38312 E21570'
G[38406]='L10 AA:85984 AH:585984 TA:85984 TH:585984 P:36616 E19658 D096'
G[38407]='L10 A:100122699 T:88798 E21570'
G[38408]='FA L40 A:500146 T:-581 E19658'
G[38410]='FA L10 A:91519 T:91553 P:38405 E21570'
G[38411]='L0 T:91727 E19890'
G[38412]='FA L10 A:91558 T:91249 P:38342 E21570'
G[38413]='L10 A:91249 T:96465 P:38618,38412 E21570'
G[38414]='L10 A:91249 T:96465 P:38618,38412 E21570'
G[38415]='FH L40 A:90481 T:91750 P:38001 I:38421 E19890 D125'
G[38416]='FH L40 A:91750 T:591750 P:38415 E19906'
G[38417]='FH L40 A:91750 T:-535 P:38415 I:38565 E19906'
G[38418]='L0 E21953'
G[38419]='SP K131072 L0 A:1240690 T:1240690 E21570'
G[38420]='L0 T:97091 E21911'
G[38421]='FA L40 A:90309 T:91751 P:38446 I:38415 E19890 D124'
G[38422]='L0 T:91780 E21570'
G[38423]='L0 T:91795 E21570'
G[38424]='L0 T:91892 E21570'
G[38425]='L0 T:91803 E21570'
G[38426]='SP K131072 L0 A:1240855 T:1240855 E19890'
G[38427]='FH L40 A:79740 T:-610 E19658'
G[38428]='L40 A:90426 T:90426 P:38031 E19890'
G[38430]='L0 T:91871 E19890'
G[38431]='L0 T:91874 E21570'
G[38433]='L0 T:91695 E19890'	-- technically FA but also 37969 which should be FH is also complete.  this is complete when 38445 ready to turn in
G[38434]='L0 E21570'
G[38435]='FA L40 A:95002 T:91913 P:39055 I:37889 E19890'
G[38436]='FA L40 A:91913 T:91923 P:38435 I:37890 E19890'
G[38437]='L0 E19890'
G[38438]='L0 T:92766 E19890'
G[38439]='FA K2 L40 A:-534 T:-534 E19906'
G[38440]='K2 L40 A:1239902 T:90309 P:38446 E19906 D104'
G[38441]='K2 L40 A:1241725 T:90481 P:38001 E19934 D107'
G[38442]='SP K32768 L10 M109 A:96254 T:-634 P:38331 E21570'	-- TODO: This is accepted when 39590 is accepted
G[38443]='L10 A:93326 T:93354 P:37449 E21570'
G[38444]='FA L40 A:91923 T:591923 P:38436 I:37934 E19890'
G[38445]='FA L40 A:591923 T:90309 P:38444 I:37935 E19890'
G[38446]='FA L40 A:91935 T:90309 P:38581 E19890'
G[38449]='K2 L40 A:1241725 T:90481 P:38001 E19890 D107'
G[38451]='L0 E21570'
G[38452]='L0 E21570'
G[38453]='FH L40 A:90481 T:-945 P:38001 I:38560 E19890 D125'
G[38454]='L0 E21570'
G[38455]='L10 A:73426 T:73426 P:38142 E21570'
G[38457]='L0 T:91009 E19890'
G[38458]='FH L40 A:90481 T:92055 P:38274+38223+38416 O:38578 E20008'
G[38459]='FH L10 A:97305 T:96254 P:38362 E21570'
G[38460]='L10 A:91166 T:91166 O:42238 E21570'
G[38461]='L0 T:92040 E21570'
G[38462]='L40 A:92055 T:92120 P:38458,38561 E20008'
G[38463]='FH L40 A:92120 T:93659 P:38462 E20008'
G[38465]='L0 E21570'
G[38466]='L0 T:-641 E21570'
G[38468]='L0 T:92117 E21570'
G[38469]='L0 E21655'
G[38470]='L0 E21570'
G[38471]='L0 E21570'
G[38472]='L0 T:92152 E21570'
G[38473]='FA L10 A:96254 T:91222 P:39597 E21570'
G[38474]='SP K131072 L0 A:1241146 T:1241146 E21570'
G[38475]='SP K131072 L0 A:1241147 T:1241147 E21570'
G[38476]='SP K131072 L0 A:1241148 T:1241148 E21570'
G[38477]='SP K131072 L0 A:1241149 T:1241149 E21570'
G[38478]='SP K131072 L0 A:1241150 T:1241150 E21570'
G[38479]='L0 T:92180 E21570'
G[38480]='SP K131072 L0 A:1241151 T:1241151 E21570'
G[38481]='SP K131072 L0 A:1241152 T:1241152 E21570'
G[38482]='L0 E19658'
G[38483]='SP K131072 L0 A:1241153 T:1241153 E21570'
G[38485]='SP K131072 L0 A:1241154 T:1241154 E21570'
G[38486]='SP K131072 L0 A:1241155 T:1241155 E21570'
G[38487]='SP K131072 L0 A:1241180 T:1241180 E21570'
G[38488]='SP K131072 L0 A:1241206 T:1241206 E21570'
G[38489]='SP K131072 L0 A:1241207 T:1241207 E21570'
G[38490]='SP K131072 L0 A:1241208 T:1241208 E21570'
G[38491]='L0 E21570'
G[38494]='L0 E21570'
G[38495]='SP K131072 L0 A:1241212 T:1241212 E21570'
G[38496]='L0 T:92197 E19890'
G[38498]='SP K131072 L0 A:1241213 T:1241213 E21570'
G[38499]='L10 A:92183 T:92183 P:PB001 E21570'
G[38500]='L10 P:PB001+38515 E21570'
G[38501]='L10 A:97261 P:PB001 E21570'
G[38502]='L10 A:97261 P:PB001+38501 E21570'
G[38503]='L0 E21570'
G[38504]='L0 E21570'
G[38505]='L10 P:PB001+38502 E21570'
G[38506]='L10 P:PB001+38505 E21570'
G[38507]='L10 P:PB001+38506 E21570'
G[38508]='L0 E21570'
G[38509]='L0 E21570'
G[38510]='L0 E21570'
G[38511]='L0 E21570'
G[38512]='L0 E21570'
G[38513]='L10 P:PB001+38563 E21570'
G[38514]='L10 P:PB001+38513 E21570'
G[38515]='L10 P:PB001+38507 E21570'
G[38516]='SP K131072 L0 A:1241272 T:1241272 E21570'
G[38517]='L0 E21570'
G[38518]='L10 P:PB001+38519 E21570'
G[38519]='L10 P:PB001+39699 E21570'
G[38520]='L0 E21953'
G[38521]='L0 E21570'
G[38522]='L10 P:PB001+38518 E21570'
G[38523]='L10 P:PB001+38522 E21570'
G[38524]='L45 P:PB001+44449 E21570'
G[38525]='L45 P:PB001+38524 E21570'
G[38526]='L45 P:PB001+38525 E21655'
G[38527]='L45 P:PB001+38526 E21570'
G[38528]='L45 P:PB001+38527 E21570'
G[38529]='SP K131072 L0 A:1241280 T:1241280 E21570'
G[38530]='L45 P:PB001+38528 E21570'
G[38531]='L45 P:PB001+38530 E21570'
G[38532]='L45 P:PB001+38531 E21570'
G[38533]='L45 P:PB001+38833 E21655'
G[38534]='L45 E21655'
G[38535]='L0 E21570'
G[38536]='L45 E21737'
G[38537]='L45 E21737'
G[38538]='L45 E21737'
G[38539]='L45 E21737'
G[38540]='L45 E21911'
G[38541]='L45 E21796'
G[38542]='L45 E21737'
G[38543]='L0 E21570'
G[38544]='L0 E21570'
G[38545]='L0 E21570'
G[38546]='L0 E21570'
G[38547]='L0 E21570'
G[38548]='L0 E21570'
G[38549]='L0 E21570'
G[38550]='L0 E21570'
G[38551]='L0 E21570'
G[38552]='L10 E21570'
G[38557]='L0 T:92274 E19890'
G[38558]='FA L10 A:90866 T:90866 P:B39800 E21570'
G[38559]='L45 P:PB001+38532 E21655'
G[38560]='FA L40 A:90309 T:-945 P:38446 I:38453 E19890 D124'
G[38561]='FA L40 A:90309 T:92055 P:38274+38223+38562 E20008'
G[38562]='FA L40 A:91751 T:591751 P:38421 E19890'
G[38563]='L10 P:PB001+38500 E21570'
G[38564]='L10 P:PB001+39729 E21655'
G[38565]='FA L40 A:91751 T:-535 P:38421 I:38417 E19890'
G[38566]='L10 A:100031 T:91866 P:42811 E21570'
G[38567]='FH L40 AZ:587 T:92400 P:>05872 E19890'	-- TODO: Should this be I:40417 ?
G[38568]='L40 A:92400 T:89937 P:38567,40417 I:38257 E19890'
G[38569]='FH L40 A:75593 T:91596 E19890'
G[38570]='FH L40 A:89937 T:92401 P:38568 I:38254 E19890'
G[38571]='L40 A:92401 T:91242 P:38570 I:38255 E19890'
G[38572]='FH L40 A:91242 T:591242 P:38571 I:38256 E19890'
G[38573]='FH L40 A:591242 T:92400 P:38572 I:38258 E19890'
G[38574]='L40 A:92400 T:500230 P:38573 I:38259 E19890'
G[38575]='L0 E19934'
G[38576]='L10 I:42811 E21570'
G[38577]='FH L40 A:90481 T:90553 P:37935 I:38581 E19890'
G[38578]='L40 A:90584 T:90644 E19890'	-- removed  P:FA+E38445,FH+E37935 because newly boosted Horde level 100 able to get this without any Tanaan quests done
G[38579]='L0 T:92408 E19890'
G[38580]='L0 T:92397 E19890'
G[38581]='FA L40 A:90309 T:91935 P:38445 I:38577 E19890'
G[38582]='L10 A:92420 T:92710 P:38595 E21570'
G[38583]='L0 T:92031 E19890'
G[38584]='L0 E19890'
G[38585]='K2 L40 A:1239902 T:90309 P:38446 E19906 D104'
G[38586]='K2 L40 A:1241725 T:90481 P:38001 E19906 D107'
G[38587]='FA K2 L40 A:90309 T:92083 E19906'
G[38588]='FH L40 T:92026 E19906'
G[38589]='L0 T:92429 E19890'
G[38591]='SP K131072 L0 A:1241433 T:1241433 E19890'
G[38592]='L0 E19890'
G[38593]='SP K131072 L0 A:1241434 T:1241434 E19890'
G[38594]='L0 E19890'
G[38595]='L10 A:92742 T:92420 P:38663 E21570'
G[38596]='L0 T:92326 E21570'
G[38597]='L0 T:92465 E19890'
G[38599]='FH L40 A:90991 T:90991 P:E37935 E19890'
G[38600]='L0 T:92495 E19890'
G[38601]='SP K131072 L0 A:1241449 T:1241449 E19890'
G[38602]='SP K131072 L0 A:1241450 T:1241450 E19890'
G[38603]='FA L40 A:92545 T:92545 P:E38445 E19890'
G[38604]='L0 T:92508 E19890'
G[38605]='L0 T:92517 E19890'
G[38607]='L10 E21570'
G[38608]='L0 E21570'
G[38609]='L0 T:92552 E19890'
G[38610]='L0 E21570'
G[38611]='FH L10 A:96254 T:92561 P:39597 E21570'
G[38612]='FH L10 A:92561 T:92566 P:38611 E21570'
G[38613]='FH L10 A:92566 T:92567 P:38612 E21570'
G[38614]='FH L10 A:92566 T:92567 P:38612 E21570'
G[38615]='FH L10 A:92567 T:92573 P:38613+38614 E21570'	-- TODO: verify 38613
G[38616]='FH L10 T:91771 E21570'
G[38617]='FH L10 A:92573 T:92569 P:38615 E21570'
G[38618]='FH L10 A:92569 T:91249 P:38617 E21570'
G[38620]='L0 T:92574 E19890'
G[38624]='L10 A:92218 T:97074 P:39652 E21570'
G[38625]='L0 T:92590 E21570'
G[38626]='L1 T:92599 E21570'
G[38627]='L0 T:92604 E21570'
G[38628]='L0 T:92606 E19890'
G[38629]='SP K131072 L0 A:1241504 T:1241504 E19890'
G[38630]='L0 T:92626 E21570'
G[38631]='L0 T:92627 E19890'
G[38632]='L0 T:92636 E19890'
G[38633]='L40 E19890'
G[38634]='SP K65536 L0 A:92647 T:92647 E19890'
G[38637]='SP K131072 L0 A:1241518 T:1241518 E21570'
G[38638]='SP K131072 L0 A:1241521 T:1241521 E19890'
G[38639]='L0 T:-534 E19890'
G[38640]='SP K131072 L0 A:1241524 T:1241524 E19890'
G[38641]='L10 A:98584 T:92680 P:38377 E21570'
G[38642]='L0 T:92685 E21570'
G[38643]='L10 A:92688 T:92619 I:39149 E21570'	-- seems to be no prerequisites
G[38644]='L10 A:92683 T:92619 P:38643,39149 E21570'
G[38645]='L10 A:92620 T:92620 P:38643,39149 E21570'
G[38646]='L10 A:92618 T:92618 P:38643+0,39149+0 E21570'	--TODO: Yoshimo: check, seems to require 38644 in the log (or something similiar)
G[38647]='L10 A:92618 T:92618 P:38643,39149 E21570'
G[38648]='L10 E21570'
G[38649]='L45 A:115736 T:115710 P:45260 E21655'
G[38654]='L0 T:92694 E19890'
G[38655]='L10 A:92697 T:92697 P:38641 E21570'
G[38656]='L10 A:100124131 T:700567 E21570'
G[38657]='SP K131072 L0 A:1241533 T:1241533 E19890'
G[38658]='L0 E21655'
G[38660]='L0 E21655'
G[38661]='L0 E21655'
G[38662]='L10 A:92680 T:92680 P:38641 E21570'
G[38663]='L10 A:92680 T:98584 P:38662 E21570'
G[38664]='L0 E21570'
G[38665]='L0 E21570'
G[38666]='L0 E21570'
G[38667]='L0 E21570'
G[38668]='L0 E21570'
G[38669]='L25188 E21691'
G[38670]='L0 E21570'
G[38671]='L10 A:94863 T:94863 P:41056,41054 E21570'
G[38672]='L8 A:92718 T:1244923 P:38729 E21570'
G[38673]='L0 E21691'
G[38674]='SP L0 A:93125 T:93125'
G[38675]='FH L10 A:103022 T:104728 P:41890 O:43576 I:41724 E21570'
G[38676]='SP K131072 L0 A:1241557 T:1241557 E21570'
G[38677]='SP K131072 L0 A:1241558 T:1241558 E21570'
G[38678]='SP K131072 L0 A:1241560 T:1241560 E19890'
G[38679]='SP K131072 L0 A:1241561 T:1241561 E19890'
G[38680]='SP K131072 L0 A:1241562 T:1241562 E21570'
G[38681]='SP K131072 L0 A:1241564 T:1241564 P:0 E21570'
G[38682]='SP K131072 L0 A:1241563 T:1241563 E19890'
G[38683]='SP K131072 L0 A:1241565 T:1241565 E19890'
G[38684]='L10 A:92783 T:92783 P:41724,38675 E21570'
G[38685]='L0 T:92763 E21570'
G[38686]='SP K131072 L0 A:1241566 T:1241566 E19890'
G[38687]='FA L10 A:500262 T:104799 P:43702 I:41763 E21570'
G[38688]='L0 E21570'
G[38689]='L8 A:92986 T:592986 P:38672 E21570'
G[38690]='L8 A:92980 T:96665 P:38672 E21570'
G[38691]='L10 A:92620 T:92842 P:39117+38711+38645+38644+38646+38647 E21570'	-- TODO: Verify requires 38711 38645
G[38692]='L45 A:114948 T:115018 P:38695 E21655'
G[38693]='L0 E21655'
G[38694]='L45 A:115018 T:700801 P:38692+38720 E21655'
G[38695]='L45 A:115710 T:114948 P:38649 E21655'
G[38696]='L0 T:92657 E19890'
G[38697]='L10 E21655'
G[38699]='L0 E21570'
G[38700]='L0 T:92887 E19890'
G[38701]='SP K131072 L0 A:1241599 T:1241599 E19890'
G[38702]='SP K131072 L0 A:1241600 T:1241600 E19890'
G[38703]='SP K131072 L0 A:1241601 T:1241601 E19890'
G[38704]='SP K131072 L0 A:1241602 T:1241602 E19890'
G[38705]='SP K131072 L0 A:1241605 T:1241605 E19890'
G[38706]='L0 E20008'
G[38707]='L0 E19890'
G[38708]='L0 E21570'
G[38709]='L0 T:92941 E19890'	-- Gorabosh (92941) 945:33.28,35.91
G[38710]='L10 CP A:92909 T:90369 P:43635 E21531'
G[38711]='L10 A:100127860 T:92620 E21570'
G[38712]='L0 T:92956 E21570'
G[38713]='L0 E21570'
G[38714]='L10 A:92850 T:592842 P:38718 E21570'
G[38715]='L10 A:92850 T:592842 P:38718 E21570'
G[38716]='SP K32768 L10 M109 A:-130641 T:-641 P:38718 E21570'
G[38717]='L10 A:592842 T:592850 P:38714+38715 E21570'
G[38718]='L10 A:92842 T:92850 P:38691 E21570'
G[38719]='L10 XE A:700068 T:95028 P:38717 E21570'
G[38720]='L45 A:114948 T:115018 P:38695 E21953'
G[38721]='L10 A:93027 T:93149 P:44457,38724 E21570'
G[38723]='L8 A:592718 T:596665 P:38690+38689+39517 E21570'
G[38724]='L10 XE A:592850 T:92987 P:38717 E21570'
G[38725]='L8 A:96655 T:98711 P:39495 E21570'
G[38726]='L0 T:93002 E19890'
G[38727]='L8 A:93127 T:93127 P:39495 E21570'
G[38728]='L8 A:97297 T:97303 P:39663 E21570'
G[38729]='L8 A:97303 T:1244466 P:38728 E21570'
G[38730]='L0 E21570'
G[38731]='SP K131072 L0 A:1241656 T:1241656 E19890'
G[38732]='SP K131072 L0 A:1241657 T:1241657 E19890'
G[38733]='L0 E19890'
G[38734]='L0 E21570'
G[38735]='L0 E19890'	-- 945:25.30,50.26
G[38736]='L0 T:93028 E19890'
G[38738]='SP K131072 L0 A:1241665 T:1241665 E21570'
G[38739]='SP K131072 L0 A:1241666 T:1241666 E19890'	-- TODO: Really should probably mark this one requiring the campaign quest to be done so the cave is opened up
G[38740]='SP K131072 L0 A:1241671 T:1241671 E19890'
G[38741]='SP K131072 L0 A:1241673 T:1241673 E19890'
G[38742]='SP K131072 L0 A:1241674 T:1241674 E19890'
G[38743]='L10 A:104799 T:104921 P:38687,41763 E21570'
G[38744]='L0 E21570'
G[38745]='L0 E21655'
G[38746]='L0 T:91232 E19890'
G[38747]='L0 T:91243 E19890'
G[38748]='SP K32768 L10 M109 A:500262 T:-641 P:43702 E21570'	-- gotten when 43702 is turned in
G[38749]='L0 T:89675 E19890'
G[38750]='L0 T:93057 E19890'
G[38751]='L0 T:92977 E19890'
G[38752]='L0 T:90482 E19890'
G[38753]='L10 A:92710 T:102938 P:38582 E21570'
G[38754]='SP K131072 L0 A:1241692 T:1241692 E19890'
G[38755]='SP K131072 L0 A:1241699 T:1241699 E19890'
G[38756]='SP K65536 L0 A:93076 T:93076 E19890'
G[38757]='SP K131072 L0 A:1241713 T:1241713 E19890'
G[38758]='L0 E19890'
G[38759]='L8 A:94410 T:93759 P:40378 E21570'
G[38760]='L0 E19890'
G[38761]='L0 T:92623 E19890'
G[38762]='SP K131072 L0 A:1241716 T:1241716 E19890'
G[38763]='SP K131072 L0 A:1241717 T:1241717 E21570'
G[38764]='L0 T:93125 E19890'
G[38765]='L8 A:93759 T:93127 P:39050 E21570'
G[38766]='L8 A:93759 T:93127 P:39050 E21570'
G[38767]='L0 T:92965 E21570'
G[38771]='SP K131072 L0 A:1241742 T:1241742 E19890'
G[38772]='L0 T:92423 E21570'
G[38773]='SP K131072 L0 A:1241745 T:1241745 E19890'
G[38774]='L0 T:93166 E21570'
G[38775]='L0 T:93168 E19890'
G[38776]='SP K131072 L0 A:1241760 T:1241760 E19890'
G[38777]='L10 A:-634,-650 T:93189 P:PM001 E21570'
G[38778]='L10 A:93231 T:93231 P:39796 E21570'
G[38779]='SP K131072 L0 A:1241764 T:1241764 E19890'
G[38780]='SP L0 A:93205 T:93205 E21570'
G[38781]='SP K131072 L0 A:1241767 T:1241767 E21570'
G[38782]='SP K131072 L0 A:1241772 T:1241772 E21570'
G[38783]='SP K131072 L0 A:1241773 T:1241773 E21570'
G[38784]='L10 A:-190650 T:93189 P:PM001 E21570'
G[38785]='L10 T:93189 P:PM001 E21570'
G[38786]='L10 A:93691 T:93691 P:38888+PM001 E21570'
G[38787]='L10 A:93691 T:93691 P:38786+PM001 E21570'
G[38788]='SP K131072 L0 A:1241775 T:1241775 E19890'
G[38789]='L10 T:93691 E21570'
G[38790]='L10 E21570'
G[38791]='L10 E21570'
G[38792]='L10 N53 A:93735 T:93691 E21570'
G[38793]='L10 E21570'
G[38794]='L10 E21570'
G[38795]='L10 A:-650 T:93189 P:PM001 E21570'
G[38796]='L10 A:96989 T:93189 P:PM001 E21570'
G[38797]='L10 A:101848 T:93189 P:PM001 E21570'
G[38798]='L10 P:38901 E21570'
G[38799]='L10 N53 A:92264 T:92264 P:38798 E21570'
G[38800]='L10 E21570'
G[38801]='L10 E21570'
G[38802]='L10 T:92264 E21570'
G[38803]='L10 E21570'
G[38804]='L10 E21570'
G[38805]='L10 E21570'
G[38806]='L45 T:93189 E21570'
G[38807]='L45 E21655'
G[38808]='L10 A:93231 T:93231 P:38778+39788 E21570'
G[38809]='SP K131072 L0 A:1241835 T:1241835 E19890'
G[38810]='L10 A:93231 T:93231 P:38778+39788 E21570'
G[38811]='L10 A:93231 T:93446 P:38808+38810 E21570'
G[38812]='L0 T:93236 E19890'
G[38813]='L8 A:93127 T:93127 P:38765+38766 E21570'
G[38814]='SP K131072 L0 A:1241841 T:1241841 E19890'
G[38815]='L10 A:97270 T:93234 P:38823+38816+38817 E21570'	-- TODO: verify requires 38823 38816
G[38816]='L10 A:93446 T:97270 P:38811 E21570'
G[38817]='L10 A:93446 T:97270 P:38811 E21570'
G[38818]='L10 A:93234 T:97319 P:38815 E21570'
G[38819]='L8 A:96420 T:93127 P:39495 E21570'
G[38820]='L0 T:93264 E19890'
G[38821]='L0 T:89857 E19890'
G[38822]='SP K131072 L0 A:1241848 T:1241848 E19890'
G[38823]='L10 A:1241840 T:97270 P:1 E21570'	-- TODO: Yoshimo: check if there is a prequest
G[38825]='L0 T:93279 E19890'
G[38833]='L45 P:PB001+38559 E21655'
G[38834]='L10 A:93337 T:89362 P:41220 E21570'	-- TODO: Given to Night Elf Priest
G[38836]='L0 T:92766 E19890'
G[38837]='L0 T:93371 E21570'
G[38838]='L0 E21570'
G[38839]='L10 E21570'
G[38840]='L0 E21570'
G[38841]='L0 E21570'
G[38842]='SP K262144 L10 M109 A:-110641 T:-641 P:a38842 E21570'
G[38844]='L0 E21570'
G[38845]='L35 E22289'
G[38847]='L0 T:93401 E21570'
G[38850]='L0 E21570'
G[38855]='L0 E20395'
G[38856]='L0 E21570'
G[38857]='L10 A:88863 T:91419 E21570'	-- so far no prequests
G[38861]='SP K131072 L0 A:1242242 T:1242242 E21570'
G[38862]='L10 A:100123980 T:93600 E21570'
G[38863]='SP K131072 L0 A:1242249 T:1242249 E19890'
G[38864]='SP K131072 L0 A:1242250 T:1242250 E21570'
G[38865]='FH L40 A:90481 T:90585 I:38866 E19890'
G[38866]='FA L40 A:-534 T:-534 I:38865 E19890'	-- This was completed as Alliance when attempting to get to the area for 38581 (if you go there without a quest you do not get this)
G[38868]='FA L40 A:91291 T:90265 E19890'
G[38869]='FH K32768 L40 A:94870 T:90265 E19906'
G[38870]='FA L40 A:94870 T:90851 E19890'
G[38871]='FH L40 A:96014 E19890'
G[38872]='FH L10 A:93624 T:93603 P:39855 E21570'	-- TODO: verify 39855 , likely a breadcrumb quest
G[38873]='FH L10 A:93603 T:93603 P:38872 E21570'
G[38874]='L0 E19890'
G[38875]='L0 E21953'
G[38876]='FH L40 A:92055 T:700419 E20008'
G[38877]='FA L40 A:96147 T:-534 E20008'	--  A:92055 is wrong
G[38878]='FH L10 A:94227 T:95611 P:39154 E21570'
G[38879]='L0 E21953'
G[38880]='L0 E21953'
G[38881]='L0 E21953'
G[38882]='FH L10 A:94228 T:95755 P:39155 E21570'
G[38885]='L0 E21570'
G[38886]='SP K131072 L0 A:1242328 T:1242328 E21570'
G[38887]='L0 T:93654 E21570'
G[38888]='L10 A:93189 T:93691 P:38777+38784+38785+PM001 E21570'
G[38889]='L10 T:93677 E21570'
G[38890]='L0 E21570'
G[38892]='L0 E21570'
G[38893]='SP K131072 L0 A:1242346 T:1242346 E21570'
G[38894]='L0 T:703997 E21570'
G[38895]='L0 E21570'
G[38896]='L0 E21570'
G[38900]='L0 T:93758 E21570'
G[38901]='L3932170 A:93189 P:38795+38796+38797 E21570'
G[38902]='L0 E21570'
G[38903]='L0 T:93758 E21570'
G[38904]='FH L10 E21570'
G[38907]='L10 N57 A:97666,700346,700347 T:93826 P:1 O:39733 E21570'
G[38909]='L10 A:593805 T:93826 P:39027 E21570'
G[38910]='L10 A:93841 T:95410 P:39318 E21570'
G[38911]='L10 A:93826 T:93833 P:38907,39989 E21570'	-- TODO: Yoshimo: very if 39989 is really needed
G[38912]='L10 A:93826 T:95256 P:38909 E21570'
G[38913]='L10 A:93826 T:93841 P:38909 E21570'
G[38914]='L0 E21570'
G[38915]='L10 A:108434 T:93846 P:39580+39456+39387 E21570'
G[38916]='L10 A:700109 T:94571 P:39992 E21570'
G[38922]='L10 A:93890 T:93581 P:38142 E21570'
G[38923]='FH L110 E19906'	-- TODO: Autoaccept entering Ashran combat zone
G[38924]='FH L100 E19906'
G[38925]='FA L110 A:94870 T:82909 E19906'
G[38926]='FA L100 A:84223 E19906'
G[38927]='FH L40 E20363'
G[38929]='FA L40 E19906'
G[38932]='L40 A:100126950 TA:93812 TH:94801 P:j10372+FA+39665,j10372+FH+39676 E19906'
G[38933]='L10 A:91866 T:90250 P:39722 E21570'
G[38934]='L7866880 T:-407 E19906'
G[38935]='L15 E19906'
G[38936]='L20 E19906'
G[38937]='L0 E21570'
G[38938]='L0 E21570'
G[38939]='L10 A:94227 T:98955 I:39119 E21570'	--automatically accepted on turnin of 39154	-- ? is this a bonus that needs M109?
G[38940]='L0 E21570'
G[38943]='SP K131072 L0 A:1242446 T:1242446 E21570'
G[38944]='L10 A:93542 T:93542 P:0 E21570'	--TODO: Yoshimo: requires Tailoring, maybe more details
G[38945]='L10 A:93542 T:93542 P:0 E21570'	--TODO: Yoshimo: requires Tailoring, maybe more details 
G[38946]='L10 A:93542 T:93967 P:0 E21570'	--TODO: Yoshimo: requires Tailoring, maybe more details 
G[38947]='L10 A:93967 P:0 E21570'	--TODO: Yoshimo: requires Tailoring, maybe more details 
G[38948]='L10 A:93967 E21570'
G[38949]='L10 A:93967 T:93967 E21570'
G[38950]='L10 A:93967 T:93542 E21570'
G[38951]='L10 A:703995 T:93542 E21570'
G[38952]='L10 A:93542 T:93967 P:0 E21570'	--TODO: Yoshimo: requires Tailoring, maybe more details
G[38953]='L10 A:93967 T:93967 P:0 E21570'	--TODO: Yoshimo: requires Tailoring, maybe more details 
G[38954]='L10 A:93542 T:93967 P:0 E21570'	--TODO: Yoshimo: requires Tailoring, maybe more details 
G[38955]='L10 A:93967 T:93967 E21570'
G[38956]='L10 A:93542 T:93967 P:0 E21691'	--TODO: Yoshimo: requires Tailoring, maybe more details 
G[38957]='L10 A:93967 T:93967 E21570'
G[38958]='L10 A:93525 T:93525 E21570'	--TODO: Yoshimo: requires Tailoring, maybe more details 
G[38959]='L10 E21691'
G[38960]='L10 E21691'
G[38961]='L10 T:93542 E21570'
G[38962]='L45 A:93542 T:93542 E21570'
G[38963]='L10 E21691'
G[38964]='L45 A:93542 T:92456 E21691'
G[38965]='L45 A:96444 T:93542 E21570'
G[38966]='L45 A:93542 T:93542 E21570'
G[38967]='L45 A:93542 T:93969 E21691'
G[38968]='L45 A:93969 T:93969 E21691'
G[38969]='L45 A:93971 T:93971 E21691'
G[38970]='L45 A:93969 T:93969 E21691'
G[38971]='L45 A:93978 T:93978 E21691'
G[38974]='L45 E21691'
G[38975]='L45 E21691'
G[38976]='L0 E21570'
G[38977]='L0 E21570'
G[38978]='L0 E21570'
G[38979]='L0 E21570'
G[38980]='L0 E21570'
G[38981]='L0 E21570'
G[38982]='L0 E21570'
G[38983]='L0 E21570'
G[38989]='FH L40 A:1 E19906'	-- sends one to Tanann for daily.
G[38990]='L10 CK A:700602 T:93437 E21570'
G[38993]='L0 E21570'
G[38994]='L0 T:92335 E21570'
G[38995]='L0 T:126198 E21570'
G[38996]='FA L40 A:1 T:90309 E19906'	-- sends one to Tanaan for daily.  find out what makes it no longer present.  the bounty board in garrison opens the adventure guide
G[38999]='L0 E21655'
G[39000]='L40 AA:92213 AH:592213 TA:92213 TH:592213 P:37841 E19906'	-- the question is once we turn in 39000 and another is available, does it also require 39697 as well?
G[39001]='L100 E19906'
G[39002]='L100 E19906'
G[39003]='L40 AA:92213 AH:592213 TA:92213 TH:592213 P:39000 E19906'
G[39004]='L40 AA:500225 TA:92213 P:FA+37839,FH+37840 E20363'	-- That P: is for Alliance...assuming there is something similar for Horde
G[39005]='L0 E21570'
G[39006]='L0 E21570'
G[39009]='L0 E21570'
G[39010]='L0 E21570'
G[39011]='L10 E21570'
G[39015]='L10 T:92738 E21570'
G[39016]='L0 E21570'
G[39017]='L0 E21570'
G[39018]='L40 A:1 T:83823 I:35988 E19906'	-- TODO: Horde boosted to 100 can get this before doing things.  Also available from Command Board in Frostwall
G[39019]='L40 E19906'
G[39020]='Hg K4 L100 AA:94870 AH:594870 TA:94870 TH:594870 E19953 D111'
G[39021]='Hh K4 L100 AA:94870 AH:594870 TA:94870 TH:594870 E20008 D111'
G[39022]='L40 E19906'
G[39023]='L40 E19906'
G[39024]='L40 E19906'
G[39025]='L10 A:593805 T:97553 P:42104 E21570'
G[39026]='L10 A:593805 T:97553 P:42104 E21570'
G[39027]='L10 A:597553 T:593805 P:39043 E21570'
G[39028]='L0 E21655'
G[39029]='SP K32768 L10 M109 A:92680 T:-641 P:38641 E21570'
G[39030]='L0 E21570'
G[39031]='L0 T:92751 E21570'
G[39032]='L10 E21570'
G[39033]='Ha K4 L40 AA:94870,1 AH:594870,1 TA:94870 TH:594870 E20008 D111'	-- TODO: This now available...perhaps is P:FA+E38445,FH+E37935
G[39034]='Hd K4 L40 AA:94870 AH:594870 TA:94870 TH:594870 E20008 D111'
G[39035]='L0 E19906'
G[39036]='L0 E19906'
G[39037]='L0 E19906'
G[39038]='L0 E19906'
G[39040]='Hc K4 L100 AA:94870 AH:594870 TA:94870 TH:594870 E20008 D111'
G[39041]='Hb K4 L40 AA:94870,1 AH:594870,1 TA:94870 TH:594870 E20008 D111'
G[39042]='He K4 L23140 AA:94870 AH:594870 TA:94870 TH:594870 E20008 D111'
G[39043]='L10 A:97553 T:597553 P:39025+39026 E21570'
G[39044]='L0 E21570'
G[39045]='L0 T:90122 E19906'
G[39046]='L0 T:90094 E19906'
G[39047]='L10 A:99343 T:99254 P:39689+40375 E21570'
G[39048]='L0 E21570'
G[39049]='L8 A:94410 T:93759 P:40378 E21570'
G[39050]='L8 A:93759 T:93759 P:40379+39049+38759 E21570'
G[39051]='K4096 L10 A:594902 T:94902 P:40819 E21570'
G[39052]='L0 E19934'
G[39054]='FA L40 A:94429 T:94429 P:39082 I:39241 E19906'
G[39055]='FA L40 A:95002 T:95002 P:39276 I:39242 E19906'
G[39056]='FA L40 A:93822 T:593822 I:39243 E19906'	-- this appears after I have been to Tanaan, but not sure about any other requirements.
G[39057]='L40 AA:92213 TA:92213 P:37841 E20157'
G[39058]='L1 T:101700 E19906'
G[39059]='FA L10 A:94346 T:94318 P:39855+0 E21570'
G[39060]='FA L10 A:94318 T:94318 P:39059 E21570'
G[39061]='FA L10 A:94318 T:94318 P:39059 E21570'
G[39062]='FA L10 A:94318 T:93779 P:39472+39060+39061 E21570'	-- TODO: Verify requires 39060 39061
G[39063]='FA L10 A:93779 T:95921 P:39062 E21570'
G[39066]='L0 E21691'
G[39067]='FA L40 A:593822 T:593822 P:39056 E19953'
G[39068]='FA L40 A:593822 T:593822 P:39067 E20008'
G[39069]='SP K131072 L0 A:1242642 T:1242642 E21570'
G[39070]='SP K131072 L0 A:1242643 T:1242643 E21570'
G[39071]='SP K131072 L0 A:1242644 T:1242644 E21570'
G[39072]='L0 T:100459 E21570'
G[39073]='SP K131072 L0 A:1242646 T:1242646 E21570'
G[39074]='SP K131072 L0 A:1242647 T:1242647 E21570'
G[39075]='SP K131072 L0 A:1242649 T:1242649 E19906'
G[39076]='L0 E19906'
G[39077]='SP K131072 L0 A:1242660 T:1242660 E21570'
G[39079]='SP K131072 L0 A:1242662 T:1242662 E21570'
G[39080]='SP K131072 L0 A:1242663 T:1242663 E21570'
G[39081]='SP K131072 L0 A:1242664 T:1242664 E21570'
G[39082]='FA L40 A:93822 T:94429 P:38259 I:39236 E19906'
G[39083]='SP K131072 L0 A:1242665 T:1242665 E21570'
G[39084]='SP K131072 L0 A:1242666 T:1242666 E21570'
G[39085]='SP K131072 L0 A:1242667 T:1242667 E21570'
G[39086]='SP K131072 L0 A:1242668 T:1242668 E21570'
G[39087]='SP K131072 L0 A:1242669 T:1242669 E21570'
G[39088]='SP K131072 L0 A:1242670 T:1242670 E21570'
G[39089]='SP K131072 L0 A:1242671 T:1242671 E21570'
G[39090]='L110 AZ:588 T:80297 E19906'
G[39092]='FA L10 A:95921 T:95804 P:39063 E21570'
G[39093]='SP K131072 L0 A:1242675 T:1242675 E21570'
G[39094]='L0 E21570'
G[39095]='L0 E21570'
G[39096]='FA L100 E19906'
G[39097]='SP K131072 L0 A:1242678 T:1242678 E21570'
G[39098]='L0 E21570'
G[39099]='L0 E21570'
G[39100]='L0 E21570'
G[39101]='L0 E21570'
G[39102]='SP K131072 L0 A:1242683 T:1242683 E21570'
G[39103]='L0 E21570'
G[39104]='L0 E21570'
G[39105]='L0 E21570'
G[39106]='L0 E21570'
G[39107]='K4 L10 N40 A:83006 T:83006 E19906'
G[39108]='SP K131072 L0 A:1242959 T:1242959 E21570'
G[39109]='L0 E21570'
G[39110]='L0 E21570'
G[39111]='L0 E21570'
G[39112]='L0 E21570'
G[39113]='L0 E21570'
G[39114]='L0 E21570'
G[39116]='L0 E21570'
G[39117]='L10 A:94117 T:94117 P:38643,39149 E21570'
G[39118]='L0 E21570'
G[39119]='SP K32768 L10 M109 A:93779 T:94856 I:38939 E21570'
G[39120]='L0 T:94413 E21570'
G[39121]='L0 T:94414 E21570'
G[39122]='FA L10 A:95804 T:95932 P:39092 E21570'
G[39123]='L10 A:94409 T:94409 P:40170 E21570'
G[39124]='L10 A:94409 T:94409 P:40170 E21570'
G[39125]='L10 E21570'
G[39126]='L0 E21570'
G[39127]='L25 M093 A:1 T:60688 E19906'
G[39128]='L0 E19906'
G[39129]='L40 E19934'
G[39130]='L0 T:94485 E21570'
G[39131]='L5 E21570'
G[39132]='L0 E21570'
G[39133]='L10 A:94561 T:94561 P:38909 E21570'	-- after getting some quests, attempting to get the tears these appear --TODO: Yoshimo: check if the P: assumption is true
G[39134]='L10 A:94561 T:94561 P:38909 E21570'	-- after getting some quests, attempting to get the tears these appear --TODO: Yoshimo: check if the P: assumption is true
G[39135]='L0 E21570'
G[39136]='L0 E21570'
G[39142]='L10 E21570'
G[39147]='L0 E19906'
G[39149]='L10 A:94594 T:92619 I:38643 E21570'
G[39151]='L0 E21916'
G[39152]='L0 E21570'
G[39153]='FH L10 A:93603 T:93603 P:38872 E21570'
G[39154]='FH L10 A:93603 T:94227 P:38873+39153 E21570'	-- TODO: Yoshimo: verify 39153
G[39155]='FH L10 A:95611 T:94228 P:38878 E21570'
G[39156]='L0 E21570'
G[39157]='L0 E19906'
G[39158]='L0 E21570'
G[39159]='L0 T:91227 E19906'
G[39160]='L0 E19906'
G[39161]='L0 E19906'
G[39162]='L0 E19906'
G[39163]='L0 E19906'
G[39164]='L0 E19906'
G[39165]='L0 E19906'
G[39166]='L0 E19906'
G[39167]='L0 E19906'
G[39168]='L0 E19906'
G[39169]='L0 E19906'
G[39170]='L0 T:95056 E19906'
G[39171]='L0 E19906'
G[39172]='L0 E19906'
G[39173]='L0 E19906'
G[39174]='L0 E21570'	-- completed when jumping back to Skyhold on Warrior doing the first weapon scenario (40043 in this case)
G[39175]='FH L40 A:500229 T:94686 P:PJ001+37935 E19906'
G[39176]='L40 A:94686 T:94605 P:PJ001 O:39175,39195 E19906'
G[39177]='L40 A:94605 T:94686 P:39176 E19906'
G[39178]='K512 L10 A:94101 T:94101 P:39124 E21570'
G[39179]='L10 E21570'
G[39180]='FH L10 A:0 T:17841 I:9912,39181 E19906'
G[39181]='FA L10 A:0 T:17841 I:9912,39180 E19906'
G[39182]='FH L15 A:1 T:18446 E19906'
G[39183]='L0 E19906'
G[39184]='L0 E19906'
G[39185]='L0 E19906'
G[39186]='L0 E19906'
G[39187]='L0 E19906'
G[39188]='FA L15 A:1 T:18446 E19906'
G[39190]='L0 E21570'
G[39191]='L10 E21570'
G[39192]='K4096 L10 A:96586 T:96586 P:39530 E21570'
G[39195]='FA L40 A:77209 T:94686 P:PJ001+38445 E20008'
G[39196]='FH L15 E19906'
G[39197]='FA L15 E19906'
G[39198]='FH L20 E19934'
G[39199]='FA L20 E19906'
G[39200]='L0 E21916'
G[39201]='FH L25 E20008'
G[39202]='FA L25 E20173'
G[39203]='FH L15 E19934'
G[39204]='FA L1966095 A:1,1207320,1207321,1207322 T:26673 E19953'
G[39205]='L0 E21570'
G[39206]='FH L15 E20157'
G[39207]='L1966095 E20157'
G[39208]='L20 E19934'
G[39209]='L20 E19934'
G[39210]='L10 E19934'
G[39212]='L20 A:28674 E19934'
G[39214]='L10 A:100622 T:100635 P:39192 E21570'
G[39216]='L0 E21570'
G[39217]='FA L100 A:84223 T:84223 E19934'
G[39221]='FH K132 L40 A:89753 T:578487 P:=05873 E19750'
G[39225]='FH K132 L40 A:89753 T:578487 E20157'	-- available to Horde boost to 100
G[39228]='FH K132 L40 A:89753 T:578487 P:=05873 E19750'
G[39231]='FH K132 L40 A:89753 T:578487 P:=05873 E19750'
G[39232]='FH K132 L40 A:89753 T:578487 P:=05873 E19750'
G[39233]='FH L100 A:88448 T:88448 E19934'
G[39234]='L100 E21570'
G[39235]='L0 T:94877 E21570'
G[39236]='FH L40 A:94789 T:594429 P:38574 I:39082 E19934'
G[39241]='FH L40 A:594429 T:594429 P:39236 I:39054 E19934'
G[39242]='FH L40 A:594429 T:594429 P:39241 I:39055 E19934'
G[39243]='FH L40 A:94789 T:594789 P:37889 O:39423 I:39056 E19934'	-- I thought  P:37935, but updated based on other comments
G[39245]='FH L40 A:594789 T:594789 P:39676 E19953'
G[39246]='FH L40 A:594789 T:94789 P:39245 E20157'
G[39247]='K4096 L10 A:94902 T:102799 P:39051 E21570'
G[39250]='FA K4 L40 A:91196 T:81492 E20157'
G[39253]='FA L40 A:89763 T:90851 P:0 E20157'	-- TODO: Yoshimo: requires at least the garrison being build
G[39256]='FA L40 T:90851 E20157'
G[39259]='FA L40 T:90851 E20157'
G[39260]='FA L40 T:90851 E20157'
G[39261]='K4096 L10 CE A:99343 T:99247 P:44663,43635,44091 E21570'	-- TODO: Does this need P:40374 as well?
G[39262]='L8 A:93127 T:96436 P:38813 E21570'
G[39263]='L100 A:88448 E19934'
G[39264]='L100 E19934'
G[39265]='L0 E19934'
G[39266]='L0 E19934'
G[39267]='L0 E19934'
G[39268]='L0 E19934'
G[39269]='L0 E21691'
G[39271]='L0 E21570'
G[39272]='L10 A:95191 T:95191 P:38911 E21570'
G[39273]='L0 E21570'
G[39274]='SP K32768 L10 A:95186 T:-650 P:39496 E21570'
G[39276]='FA L40 A:94429 T:95002 P:39054 E19953'
G[39277]='L10 N47 A:95956 T:95956 P:39496 E21570'	-- Chromie time N47
G[39278]='L40 A:100127989 T:83888 E19953'	-- Waterlogged Manifest comes from completing naval mission Black Market Journal
G[39279]='SP K32768 L8 A:98229 T:-672 P:40077 E21570'	-- autoaccepted immediately upon turnin of 40077
G[39282]='L0 E21570'
G[39283]='L10 T:85984 E20008'
G[39285]='L0 E21570'
G[39286]='L100 E21570'
G[39287]='L0 T:95053 E19953'
G[39288]='L0 T:95044 E19953'
G[39289]='L0 T:95056 E19953'
G[39290]='L0 T:95054 E19953'
G[39292]='L100 E20395'
G[39294]='L100 E19953'
G[39296]='L110 E21570'
G[39299]='L40 A:83888 T:-581 P:39278 E20008'
G[39303]='L0 E21570'
G[39304]='L0 E21570'
G[39305]='L10 A:94068 T:700060 P:42425+40070+40071 E21570'
G[39306]='L0 E20157'
G[39307]='L0 E20157'
G[39308]='L0 E20157'
G[39309]='L0 T:90024 E20157'
G[39310]='FA L0 E20157'	-- set when you pick Artillery Strike from NPC 90963 when doing quest 39313
G[39311]='L110 E21570'
G[39312]='L110 E21570'
G[39313]='FA L40 A:90963 T:90963 P:E38445 E19953'
G[39315]='FH L40 A:90993 T:90993 P:E37935 E20157'
G[39316]='L10 A:95186 T:95186 P:39496 E21570'
G[39317]='L10 T:700552 P:38913 E21570'	--  A:93841 removed just to keep it out of the zone list for now, TODO: Yoshimo: verify 38913
G[39318]='L10 A:93841 T:93841 P:38913 E21570'
G[39319]='L0 E21691'
G[39321]='L10 A:95410 T:700170 P:38910 E21570'
G[39322]='L10 A:700170 T:700154 P:39429+39321 E21570'
G[39323]='L10 A:96083 T:95130 P:39490+39272+39491 E21570'	--TODO: Yoshimo: check if conditions are correct (assumed to be equal to 39496
G[39324]='L100 E21570'
G[39325]='L10 A:92458 T:92458 P:PA001 E21570'
G[39326]='L10 A:92458 T:92458 P:PA001 E21570'
G[39327]='L10 A:92458 T:92458 P:PA001 E21570'
G[39328]='L10 A:92458 T:92458 P:PA001 E21570'
G[39329]='L10 A:92458 T:92458 P:PA001 E21570'
G[39330]='L10 A:92458 T:92458 P:PA001 E21570'
G[39331]='L10 A:92458 T:92458 P:PA001 E21570'
G[39332]='L10 A:92458 T:92458 P:PA001 E21570'
G[39333]='L10 E21737'
G[39334]='L10 A:92242 T:92458 P:PA001 E21570'
G[39335]='L10 A:92458 T:92458 P:PA001 E21570'
G[39336]='L10 A:92458 T:92458 P:PA001 E21570'
G[39337]='L10 A:92458 T:105760 P:PA001 E21570'
G[39338]='L10 A:93974 T:92458 P:PA001 E21570'
G[39339]='L45 A:92458 T:92458 P:0 E21570'	--TODO: Yoshimo: requires alchemy ,maybe more details
G[39340]='L45 A:92458 T:92458 P:0 E21570'	--TODO: Yoshimo: requires alchemy ,maybe more details
G[39341]='L45 A:92458 T:92458 P:0 E21570'	--TODO: Yoshimo: requires alchemy ,maybe more details
G[39342]='L45 E21737'
G[39343]='L45 A:92458 T:92458 P:PA001 E21655'
G[39344]='L45 A:92458 P:0 E21737'	--TODO: Yoshimo: requires alchemy ,maybe more details
G[39345]='FH L45 E21737'
G[39346]='L45 E21570'
G[39347]='L45 E21570'
G[39348]='L45 E21570'
G[39349]='L45 E21570'
G[39350]='L45 E21570'
G[39351]='L45 E21655'
G[39352]='L100 E21570'
G[39353]='L0 E21570'
G[39354]='L10 A:95202 T:95202 P:38384 E21570'
G[39355]='L40 A:100128231 TA:93812 TH:94801 P:j10378+FA+39665,j10378+FH+39676 E20157'
G[39356]='L40 A:100128232 TA:93812 TH:94801 P:j10374+FA+39665,j10374+FH+39676 E20157'
G[39357]='L0 T:100409 E21570'
G[39358]='L40 A:100128250 TA:93812 TH:94801 P:FA+T73762999,FH+T73862999 E20157'
G[39359]='L40 A:100128491 TA:93812 TH:94801 P:FA+T73750999,FH+T73850999 E20157'
G[39360]='L40 A:100128252 TA:93812 TH:94801 P:j10379+FA+39665,j10379+FH+39676 E20157'
G[39361]='L40 E20157'
G[39362]='L40 E20157'
G[39363]='L40 A:100128255 TA:93812 TH:94801 P:j10377+FA+39665,j10377+FH+39676 E20157'
G[39364]='L40 A:100128256 TA:93812 TH:94801 P:j10376+FA+39665,j10376+FH+39676 E20157'
G[39365]='L40 A:100128257 TA:93812 TH:94801 P:j10375+FA+39665,j10375+FH+39676 E20157'
G[39366]='L40 A:100128258 TA:93812 TH:94801 P:j10373+FA+39665,j10373+FH+39676 E20157'
G[39367]='L40 E20157'
G[39368]='L40 E20157'
G[39369]='L40 E20157'
G[39370]='L40 E20157'
G[39371]='SP K262144 L10 M109 A:-100650 T:-650 P:a39371 E21570'
G[39372]='L10 A:95256 T:95256 P:38912 E21570'
G[39373]='L10 A:95256 T:95256 P:38912 E21570'
G[39374]='L10 A:95256 T:700238 P:39873+39373+39372 E21570'
G[39375]='L0 T:91871 E20173'	-- Suspiciously glowing chest	945:46.23,46.93
G[39376]='L0 T:93125 E20173'
G[39377]='L0 T:92606 E20173'
G[39378]='L0 T:93001 E20157'
G[39379]='L0 T:92819 E20173'	-- Eyepiercer
G[39380]='L0 T:90429 E20173'
G[39381]='L10 A:96286 T:95421 P:39860 E21570'
G[39382]='L0 E21570'
G[39383]='L10 A:95395 T:95396 P:38382 E21570'
G[39384]='L10 A:95396 T:91650 P:39383 E21570'
G[39385]='FH L10 A:1243454 T:93603 P:38872 E21570'
G[39386]='L10 A:94409 T:96513 P:40228 E21570'
G[39387]='L10 A:700154 T:108434 P:39322 E21570'	-- TODO: Yoshimo: figure out when this is actually T:93826, probably after 39580
G[39388]='L10 E21655'
G[39389]='L10 E21570'
G[39390]='L10 A:1243392 T:92458 E21570'
G[39391]='L10 A:95421 T:95421 P:39381 E21570'
G[39392]='L10 A:94409 T:94409 P:40170 E21570'
G[39393]='K32768 L10 M109 A:95395 T:-641 P:38382 E21570'	-- gotten automatically when turning in 38382
G[39394]='FA L40 A:92120 T:93658 P:38462 E20157'
G[39395]='SP L40 A:92338 T:92338 P:38463,39394 U468 E20157'
G[39396]='L0 T:92338 E20157'
G[39397]='L0 E21570'
G[39398]='L0 E20157'
G[39399]='L0 T:92766 E20157'	-- Akrrilo
G[39400]='L0 T:92817 E20157'	-- Rendarr
G[39401]='FH L40 A:594789 T:594789 P:39243 I:39404 E20157'
G[39404]='FA L40 A:593822 T:593822 P:39056 I:39401 E20008'
G[39405]='L10 A:1251571 T:-634 P:39062 E21570'
G[39406]='L0 T:92817 E20157'
G[39407]='L0 T:92817 E20157'
G[39408]='L0 T:95056 E20157'
G[39409]='SP K131072 L0 A:1234147 T:1234147 E20157'
G[39410]='L0 T:93812 E20157'
G[39411]='L0 T:92766 E20157'
G[39412]='L0 T:85514 E20157'
G[39413]='L0 T:92817 E20157'
G[39414]='L0 T:85514 E20157'	-- ?? treasure... "Young Orc Traveler" 75072 941:54.84,35.45
G[39415]='L0 T:92817 E20157'
G[39416]='L0 T:92766 E20157'
G[39417]='L10 A:96513 T:94409 P:39670+39656 I:40217 E21570'
G[39418]='L0 E21570'
G[39419]='L10 A:94522 T:94522 E21570'
G[39420]='L0 E21570'
G[39422]='FA L40 A:90309 TP:93822:X39056;593822:C39056 P:38445 E20157'	-- X39056 is as close as we can get....really it should be not accepted which we do not have
G[39423]='FH L40 A:90481 T:94789 P:37935 E20157'	-- TODO: Make T:594789 assuming 39243 has been accepted/turned in
G[39424]='K262144 L45 A:-280650 T:-650 P:a39424 E21655'
G[39425]='L10 A:95421 T:95421 P:39381 E21570'
G[39426]='L10 A:95421 T:96453 P:39391+39425+39588 E21570'
G[39427]='L10 E21570'
G[39428]='L0 E21570'
G[39429]='L10 A:95410 T:700170 P:38910 E21570'
G[39430]='L10 A:92458 T:92242 P:PA001 E21570'
G[39431]='L10 A:105760 T:93974 P:PA001 E21570'
G[39432]='L40 AA:95424 AH:595424 TA:95424 TH:595424 P:FA+E38445,FH+E37935 E20157'
G[39433]='K2 L40 AA:95424 AH:595424 TA:95424 TH:595424 P:39432 E20157'
G[39434]='L0 T:92977 E20157'
G[39435]='L0 T:95204 E21570'
G[39436]='L110 E21570'
G[39437]='L10 A:95799 T:95799 P:39440 E21570'
G[39438]='L10 A:95799 T:95799 P:39440 E21570'
G[39439]='L10 A:95799 T:95799 P:39440 E21570'
G[39440]='L10 A:95799 T:95799 P:40229 E21570'
G[39441]='FA K2 L40 A:90974 T:90851 E20157'
G[39442]='FH L40 E20157'
G[39443]='FA K2 L40 A:90974 T:92873 E20157'
G[39444]='FH L40 A:96014 T:90497 E20157'
G[39445]='FA K2 L40 A:96147 T:91721 E20157'
G[39446]='FH L40 A:96014 E20157'
G[39447]='SP FA K2 L40 A:-534 T:-534 E20157'
G[39448]='FH L40 E20157'
G[39449]='FA K2 L40 A:-534 T:90286 E20157'
G[39450]='FH L40 A:91324 E20157'
G[39451]='FA K2 L40 A:90974 T:90074 E20157'
G[39452]='FH K2 L40 A:91324 E20157'
G[39453]='FA L40 A:90974 T:92396 E20157'
G[39454]='FH L40 E20157'
G[39455]='L10 A:700238 T:93836 P:39374 E21570'
G[39456]='L10 A:95392 T:93826,108434 P:40229 E21570'	-- 108434 after she is made high chief
G[39460]='L0 E21570'
G[39461]='L0 E20157'
G[39462]='K262144 L45 A:101957 T:-650 P:a39462 E21655'
G[39463]='L0 E20157'
G[39464]='L0 E21570'
G[39465]='L0 T:95872 E21570'
G[39466]='L0 T:94986 E21570'	-- treasure located at 1024:49.64,37.75
G[39467]='L0 E21570'
G[39468]='L0 T:92766 E20157'
G[39469]='SP K131072 L0 A:1243690 T:1243690 E20157'
G[39470]='SP K131072 L0 A:1243693 T:1243693 E20157'
G[39471]='L0 E21570'	-- 1024:51.18,53.05
G[39472]='FA L10 A:1243700 T:94318 P:39855 E21570'
G[39473]='L0 T:92817 E20157'
G[39474]='L0 T:92817 E20157'
G[39475]='L0 T:92817 E20157'
G[39476]='L0 T:90977 E20157'
G[39477]='L0 T:90977 E20157'
G[39478]='L0 T:90977 E20157'
G[39479]='L0 T:90885 E20157'
G[39480]='L0 T:90885 E20157'
G[39481]='L0 T:90885 E20157'
G[39482]='L0 T:95056 E20157'
G[39483]='L0 T:95056 E20157'
G[39484]='L0 T:80005 E20157'
G[39485]='L0 T:80005 E20157'
G[39487]='L10 A:96038 T:96038 P:39488+39489 E21570'
G[39488]='L10 A:96520 T:96038 P:39661 E21570'
G[39489]='L10 A:96038 T:96038 P:39661 E21570'
G[39490]='L10 A:95191 T:95191 P:38911 E21570'
G[39491]='L10 A:93833 T:93833 P:38911 E21570'
G[39493]='L110 E21570'
G[39494]='L0 E21570'
G[39495]='L8 A:96436 T:93127 P:39262 E21570'
G[39496]='L10 A:93833 T:95186 P:39490+39272+39491 E21570'
G[39497]='L0 T:95976 E20157'
G[39498]='L10 A:96038 T:97662 P:39487 E21570'
G[39499]='L40 A:95659 T:95659 E20157'
G[39500]='L40 A:95659 T:95659 E20173'
G[39501]='L40 E20363'
G[39502]='L40 A:95659 T:95659 E20363'
G[39503]='SP K131072 L0 A:1243773 T:1243773 E21570'
G[39504]='L40 A:95659 T:95659 E20363'
G[39505]='L40 E20395'
G[39506]='L110 E21570'
G[39507]='L0 E21570'
G[39508]='L110 E21570'
G[39509]='FH K2 L40 A:96014 T:96014 P:w1071 I:39567 E20157 D108'
G[39510]='FH K2 L40 A:96014 T:96014 P:w1071 I:39568 E20157 D108'
G[39511]='FH K2 L40 A:96014 T:96014 P:w1071 I:39569 E20157 D108'
G[39512]='FH K2 L40 A:96014 T:96014 P:w1071 I:39570 E20157 D108'
G[39513]='FH K2 L40 A:96014 T:96014 P:w1071 I:39571 E20157 D108'
G[39514]='FH K2 L40 A:96014 T:96014 P:w1071 I:39573 E20157 D108'
G[39515]='L8 A:93127 T:93127 P:40051+39518 E21570'	-- Night Elf
G[39516]='L8 A:93127 T:93127 P:40051+39517 E21570'	-- Night Elf
G[39517]='L0 CE T:99045 I:39518 E21570'
G[39518]='L0 CE T:99045 I:39517 E21570'
G[39519]='FH K2 L40 A:93396 T:93396 P:E37935 I:39581 E20157 D106'
G[39520]='FH L100 E20157'
G[39521]='L100 E20157'
G[39522]='FA L100 E20157'
G[39523]='FA L100 E20157'
G[39524]='L100 E20157'
G[39525]='FA L100 E20157'
G[39526]='FH K2 L40 A:96014 T:96014 P:w1071 I:39574 E20157'
G[39527]='L0 E21570'
G[39528]='L0 E21570'
G[39529]='FH K2 L40 A:93396 T:93396 P:E37935 I:39582 E20157 D106'
G[39530]='K4096 L10 A:96469 T:96586 P:41105,40043 E21570'
G[39531]='SP K131072 L0 A:1243798 T:1243798 E21570'
G[39532]='FH K2 L40 A:93396 T:93396 P:E37935 I:39586 E20157 D106'
G[39533]='L0 T:701022 E21570'
G[39534]='L0 E21570'
G[39535]='L0 E21570'
G[39536]='L0 E21570'
G[39537]='L0 E21570'
G[39538]='L0 E21570'
G[39539]='L0 E21570'
G[39540]='L0 E21570'
G[39541]='L0 E21570'
G[39542]='L0 E21570'
G[39543]='L0 E21570'
G[39544]='L0 E21570'
G[39545]='L0 E21570'
G[39546]='L0 E21570'
G[39547]='L0 E21570'
G[39548]='L0 E21570'
G[39549]='L0 E21570'
G[39550]='L0 E21570'
G[39551]='L0 E21570'
G[39552]='L0 E21570'
G[39553]='L0 E21570'
G[39554]='L0 E21570'
G[39555]='L0 E21570'
G[39556]='L0 E21570'
G[39557]='L0 E21570'
G[39558]='L0 E21570'
G[39559]='L0 E21570'
G[39560]='L0 E21570'
G[39561]='L0 T:93003 E20157'
G[39564]='L0 T:92766 E20157'
G[39565]='K4 L40 A:92805 T:92805 P:FA+E38445,FH+E37935 E20157'
G[39566]='L10 E21570'
G[39567]='FA K2 L40 A:90974 T:90974 P:w1041 I:39509 E20157 D105'
G[39568]='FA K2 L40 A:90974 T:90974 P:w1041 I:39510 E20157 D105'
G[39569]='FA K2 L40 A:90974 T:90974 P:w1041 I:39511 E20157 D105'
G[39570]='FA K2 L40 A:90974 T:90974 P:w1041 I:39512 E20157 D105'
G[39571]='FA K2 L40 A:90974 T:90974 P:w1041 I:39513 E20157 D105'
G[39572]='L10 A:95130 T:96084 P:39323 E21570'
G[39573]='FA K2 L40 A:90974 T:90974 P:w1041 I:39514 E20157 D105'
G[39574]='FA K2 L40 A:90974 T:90974 P:w1041 I:39526 E20157'
G[39575]='L10 A:94571 T:99153 P:38916 E21570'
G[39576]='L10 A:99153 T:98957 E21570'
G[39577]='L10 A:99190 T:96270 P:39578 E21570'
G[39578]='L10 A:108069 T:99190 P:40219 E21570'
G[39579]='L10 A:96270 T:108305 P:39577 E21570'
G[39580]='L10 A:108305 T:108434 P:39579 E21570'
G[39581]='FA K2 L40 A:96147 T:96147 P:E38445 I:39519 E20157 D103'
G[39582]='FA K2 L40 A:96147 T:96147 P:E38445 I:39529 E20157 D103'
G[39586]='FA K2 L40 A:96147 T:96147 P:E38445 I:39532 E20157 D103'
G[39588]='L10 A:95421 T:95421 P:39381 E21570'
G[39589]='L0 E21570'
G[39590]='L10 A:96254 T:1243836 P:38331 E21570'
G[39591]='L10 A:1243836 T:93110 TP:1243836:X39593;96257:39593 P:39590 E21570'
G[39592]='L10 A:1243836 T:93110 TP:1243836:X39593;96257:39593 P:39590 E21570'
G[39593]='L10 A:1243836 T:1243836 P:39590 E21570'
G[39594]='L10 A:96257 T:96258 P:39591+39592+39593 E21570'
G[39595]='L10 A:100128511 T:96215 TP:96258:E39594;1243836 E21570'
G[39596]='L0 T:95318 E21570'
G[39597]='L10 A:96258 T:96254 P:39594 E21570'
G[39601]='FA L40 A:593822 T:90974 P:39056 E20157'
G[39602]='L45 A:92456 T:96347 E21570'
G[39604]='FH L40 A:594789 T:96014 P:39676 E20157'
G[39605]='L45 A:96347 T:1243899 E21655'
G[39606]='SP K131072 L0 A:1251124 T:1251124 E21570'
G[39607]='L0 T:96135 E21570'
G[39608]='L0 E20395'
G[39609]='L0 E20395'
G[39610]='L0 E20395'
G[39611]='L0 E20395'
G[39612]='L0 E20395'
G[39613]='L0 E20395'
G[39614]='L10 A:95186 T:95186 P:39496 E21570'
G[39615]='L0 E20395'
G[39616]='L0 E20395'
G[39617]='L0 E20395'	-- Arachnis 971:73.09,363.37
G[39618]='L0 E21570'
G[39619]='L0 E21570'
G[39620]='L0 E21570'
G[39621]='L0 E21570'
G[39622]='L0 E21570'
G[39623]='L0 E21570'
G[39624]='L0 E21570'
G[39625]='L0 E21570'
G[39626]='L0 E21570'
G[39627]='L0 E21570'
G[39628]='L0 E21570'
G[39629]='L0 E21570'
G[39630]='L0 E21570'
G[39631]='L0 E21570'
G[39632]='L0 E21570'
G[39633]='L0 E21570'
G[39634]='L0 E21570'
G[39635]='L0 E21570'
G[39636]='L0 E21570'
G[39637]='L0 E21570'
G[39638]='L0 E21570'
G[39639]='L0 E21570'
G[39640]='L0 E21570'
G[39641]='L0 E21570'
G[39642]='L0 E21570'
G[39643]='L0 E21570'
G[39644]='L0 E21570'
G[39645]='FA L45 E21737'
G[39646]='L0 T:96410 E21570'
G[39647]='L23140 E21570'
G[39648]='HV K2 L7889920 AA:96451 AH:96735 TA:96362 TH:596362 E20395'
G[39649]='HV K2 L7889920 AA:96451 AH:96735 TA:96362 TH:596362 E20395'
G[39651]='HV K2 L7889920 AA:96451 AH:96735 TA:96362 TH:596362 E20395'
G[39652]='L10 A:96465 T:92218 P:38413+38414+40568 E21570'
G[39654]='K4096 L10 A:93823 T:96469 P:42815 E21570'
G[39655]='FA L40 A:593822 T:593822 P:39404 I:39674 E20157'
G[39656]='L10 A:96513 T:96513 P:39670 E21570'
G[39657]='SP HW L7864576 AA:1243912 AH:3243912 TA:1243912 TH:3243912 E20395'
G[39658]='L7866880 T:1180746 E20395'
G[39659]='L7866880 T:1187236 E20395'
G[39661]='L10 A:95956 T:96520 P:39277+39614+39316 E21570'
G[39663]='L8 A:93127 T:97297 P:38819+38727+39516|39515 E21570'
G[39665]='FA L40 A:93812 T:593822 P:39666 I:39676 E20157'
G[39666]='FA L40 A:593822 T:93812 P:39655 I:39675 E20157'
G[39667]='L45 A:1243899 T:96444 E21655'
G[39668]='HV K2 L7889920 AA:96451 AH:96735 TA:96362 TH:596362 E20395'
G[39670]='L10 A:96513 T:96513 O:39386 E21570'
G[39671]='L0 E20395'
G[39674]='FH L40 A:594789 T:594789 P:39401 I:39655 E20157'
G[39675]='FH L40 A:594789 T:94801 P:39674 I:39666 E20157'	-- TODO: Should this really be P:39674,39655
G[39676]='FH L40 A:94801 T:594789 P:39675 I:39665 E20157'
G[39680]='L10 P:PB001+39702 E21655'
G[39681]='L10 A:92183 T:97261 P:38499+PB001 E21570'
G[39682]='L8 A:596665 T:97643 P:38723,40253 E21570'
G[39683]='L8 A:96675 T:96675 P:39682+39517 E21570'
G[39684]='L8 A:97643 T:96675 P:39682 E21570'
G[39685]='L8 A:97643 T:96675 P:39682 E21570'
G[39686]='L8 A:96675 T:97644 P:39683|40254+39684+39685 E21570'
G[39687]='L0 E21570'
G[39688]='FA L8 A:97644 TP:96669:40375;96666:40374 P:40373+39517 E21570'	-- Night Elf Havoc Sunfury
G[39689]='FA L8 A:97978 T:97978 P:39688,40255 E21570'
G[39690]='FH L8 A:97978 T:97978 P:39694,40256 E21570'
G[39691]='FA L8 A:97296 T:102585 P:39689 E21691'
G[39692]='L8 E21655'
G[39693]='L0 E21691'
G[39694]='FH L8 A:97644 TP:96669:40375;96666:40374 P:40373+39517 E21570'
G[39695]='L0 T:702952 E21570'
G[39696]='L10 E21691'
G[39697]='L40 AA:92213 TA:92213 P:39057 E20157'
G[39698]='FH L10 A:96686 T:596686 P:38307 E21570'
G[39699]='L10 P:PB001+38514 E21655'
G[39702]='L10 P:PB001+38523 E21570'
G[39709]='L0 T:93812 E20157'
G[39710]='L0 T:161067 E20157'
G[39711]='L0 T:90977 E20157'
G[39712]='L0 E20395'
G[39713]='L0 E20157'
G[39714]='L0 E20395'
G[39715]='L0 E20395'
G[39716]='HW K2 L7889920 AA:96705 AH:596705 TA:96362 TH:596362 P:FA+=05813,FH+=05873 E20395'	-- why is =09763 failed for Horde, but =09713 true for the same Horde?  is there only really 971 internally?
G[39717]='L0 E21570'
G[39718]='L10 A:704006 AP:98000:ND;98613:NE;98695:NM;102669:NH;102589:NT;98093:NR;97389:NW;93787:NP T:86563 P:B40653+ND,B39756+NP,B40585+NW,B40997+NR,B41019+NT,B41141+NM,B41099,B41069 E21570'	-- now we cannot accept them all (at least in live)
G[39719]='HW K2 L7889920 AA:96705 AH:596705 TA:96362 TH:596362 P:FA+=05813,FH+=05873 E20395'
G[39720]='HW K2 L7889920 AA:96705 AH:596705 TA:96362 TH:596362 P:FA+=05813,FH+=05873 E20395'
G[39721]='HW K2 L7889920 AA:96705 AH:596705 TA:96362 TH:596362 P:FA+=05813,FH+=05873 E20395'
G[39722]='L10 A:91866 T:91866 P:38566 E21570'
G[39723]='L0 E20157'
G[39724]='L0 T:89741 E20157'
G[39725]='L0 T:93812 E20157'
G[39726]='L10 P:PB001+39680 E21655'
G[39727]='L0 E20157'
G[39728]='L0 E20157'
G[39729]='L10 P:PB001+39726 E21655'
G[39730]='L0 E21570'
G[39731]='L10 AP:98613:NE;98695:NM;102669:NH;102589:NT;98093:NR T:91172 E21570'	-- TODO: Determine prerequisite...started with the initial one...got the quest to return back to here.  2016-09-09:  When you accept one of these, the others on the map are not permitted.  However, if you drop it, all are once again available.  To get the map quests back you need to complete something based on each zone.  For this chain, turning in 39861 makes the board available again.
G[39732]='L0 E21570'
G[39733]='L10 AP:98613:NE;98695:NM;102669:NH;102589:NT;98093:NR T:97666 E21570'	-- TODO: Determine quest that clears it. table quest.  cannot determine what clears this from Nimhfree because this is the last one.	-- Hunter gets this from 102669
G[39734]='L0 E21570'
G[39735]='FA L10 A:98613 T:96644 E21570'	-- All these table quests, A:98613 seem to have a prerequisite that says you need to have completed any you have selected previously before you can get another one.  However, if you do not close the map, you can select more than one.  This should allow you to get them all, except perhaps for the very first one you get while you are on a quest to get from the table.  *** previous comment from Demon Hunter line.  same quest available from Druid "table" as well. *** the Hunter quest starts at NPC 102669.  98613 is the Demon Hunter quest giver.  2016-09-09:  When this one is turned in, the map table is open again.
G[39736]='L0 E20157'
G[39737]='L0 E20157'
G[39738]='L0 E20157'
G[39739]='L0 E20157'
G[39740]='L0 E20157'
G[39741]='L10 A:108571 T:98632 E21570'	--also completes 42665
G[39742]='K32768 L8 A:-677 T:-677 E21570'
G[39743]='L0 E21570'
G[39744]='L0 E21570'
G[39745]='L0 E21570'
G[39746]='K4096 L10 CS A:91731 T:96527 P:44663 OAC:38894 E21570'
G[39748]='L0 T:77789 E20157'
G[39749]='L0 T:93812 E20157'
G[39750]='L0 E20157'
G[39751]='L0 E20157'
G[39752]='L0 E20157'
G[39753]='L0 E20157'
G[39756]='L10 A:90250 T:90250 P:39787,38933 E21570'
G[39757]='L10 CK A:97111 T:97072 E21570'
G[39758]='L0 E20395'
G[39759]='L0 E20395'
G[39761]='L7234048 CK A:97072 T:97072 P:39757 E21570'
G[39762]='L0 T:97093 E21570'
G[39763]='L45 E21655'
G[39764]='L10 A:97094 T:97846 E21570'	--TODO: Yoshimo : check for prequests (so far looks like none are needed)
G[39765]='L10 A:96984 T:96984 E21570'	--TODO: Yoshimo : check for prequests (so far looks like none are needed)
G[39766]='SP K131072 L0 A:1244446 T:1244446 E21570'
G[39767]='L0 E20395'
G[39768]='L10 A:96984 T:96984 E21570'	--TODO: Yoshimo : check for prequests (so far looks like none are needed)
G[39769]='L10 A:96984 T:97130 P:39765+39768 E21570'
G[39770]='L10 E31961'
G[39771]='L10 A:701784 E21570'
G[39772]='L10 A:97130 T:96984 P:40345 E21570'
G[39773]='L10 A:97094 T:97846 E21570'
G[39774]='L10 A:97846 T:97193 P:39764+39773 E21570'
G[39775]='SP L10 A:107840 T:91222 E21570'	--TODO: Yoshimo: verify P:, as alliance  P:38362 is wrong
G[39776]='L10 A:93846 T:93846 P:38915 E21570'
G[39777]='L10 A:97344 T:97344 P:38915 E21570'
G[39778]='L0 E21953'
G[39779]='L0 E21953'
G[39780]='L10 A:97407 T:700705 P:40594 E21570'
G[39781]='K64 L10 N53 A:700705 T:1250548 P:39780 E21570'
G[39782]='L0 T:111578 E21570'
G[39783]='L0 T:96637 E20395'
G[39784]='L0 T:97220 E21570'
G[39785]='L0 E21655'
G[39786]='L10 A:107674 T:107674 P:39787+39793 E21570'
G[39787]='L10 A:107674 T:107674 P:39789 E21570'
G[39788]='L10 A:93231 T:93231 P:39796 E21570'
G[39789]='L10 A:97258 T:107675 E21570'
G[39790]='L45 E21655'
G[39791]='L10 A:93231 T:93446 P:38808+38810 E21570'
G[39792]='L10 A:107675 T:107675 P:39787+39793 E21570'
G[39793]='L10 A:107675 T:107675 P:39789 E21570'
G[39794]='L0 E21570'
G[39795]='L0 E21570'
G[39796]='L10 A:92539 T:93231 P:39804 E21570'
G[39797]='L0 E21570'
G[39798]='L0 E21570'
G[39799]='L10 CK A:93568 T:93568 E21570'
G[39800]='FA L10 A:96663 T:90749 P:38206 E21570'	-- TODO: Also T:590749 when you are about to turn in 38060
G[39801]='FH L10 A:596686 T:0,91473 P:39698 E21570'
G[39802]='L0 T:97326 E21570'
G[39803]='L10 A:97074 T:92539 P:38624 E21570'
G[39804]='L10 A:92539 T:92539 P:39803 E21570'
G[39805]='L0 E21570'
G[39806]='L0 T:97345 E21570'
G[39807]='L0 E21570'
G[39808]='L110 E21570'
G[39809]='L110 E21570'
G[39810]='L110 E21570'
G[39811]='L110 E21570'
G[39812]='SP K131072 L0 A:1244494 T:1244494 E21570'
G[39813]='L110 E21570'
G[39814]='L110 E21570'
G[39815]='L110 E21570'
G[39816]='L10 T:93456 E21691'
G[39817]='L45 E21655'
G[39818]='L10 T:109890 E21691'
G[39819]='L110 E21570'
G[39820]='L110 E21570'
G[39821]='L110 E21570'
G[39822]='L110 E21570'
G[39823]='L110 E21570'
G[39824]='SP K131072 L0 A:1244519 T:1244519 E21570'
G[39825]='L110 E21570'
G[39826]='L110 E21570'
G[39827]='L110 E21570'
G[39828]='L0 E20395'
G[39829]='L0 E20395'
G[39830]='L45 E21570'
G[39832]='L10 A:97072 T:93568 P:39761 E21570'
G[39837]='L10 A:97319 T:91531 P:38818 E21570'
G[39838]='L110 A:97429 T:97429 E21570 Z25860'	-- P:44616 was wrong.  Nimhfree got this at level 110 wih no issues.
G[39839]='L110 A:1244555 T:93531 P:39838 E21570'
G[39840]='L110 A:97718 T:90463 P:39863 E21691'
G[39841]='L110 A:90463 T:97361 P:39840 E21691'
G[39842]='L110 A:97361 T:97361 E21691'
G[39843]='L110 A:97361 T:97361 E21691'
G[39844]='L110 A:97361 T:97361 P:39841 E21691'
G[39845]='FA L110 A:97361 T:700356 E21796'
G[39846]='L0 E21570'
G[39847]='L10 P:PI001 E21570'
G[39848]='L10 A:97419 T:1244559 P:38347 E21570'
G[39849]='L10 A:97480 T:97480 P:39857 E21570'
G[39850]='L10 A:97480 T:97480 P:39849 E21570'
G[39851]='L10 A:97480 T:97480 P:39849 E21570'
G[39852]='L0 E21953'
G[39853]='L10 A:97480 T:97558 P:39850+39851 E21570'
G[39854]='L0 E21570'
G[39855]='L10 A:97558 T:92539 P:39853 E21570'
G[39856]='L0 T:97504 E21570'
G[39857]='L10 A:1244559 T:97480 P:39848 E21570'
G[39858]='SP L0 A:97517 T:97517 E21570'
G[39859]='L10 A:94434 T:94409 O:39417,40217 E21570'
G[39860]='L10 A:93836 T:96286 P:39455 E21570'
G[39861]='L10 A:91172 T:91462 P:39731 E21570'	-- I am guessing turning this in (and doing nothing else in the zone), allow my quest board to give me more quests to do...
G[39862]='L10 A:97301 T:97301 P:38915 E21570'
G[39863]='L110 A:97718 T:97718 P:39839 E21570 Z23835'
G[39864]='FH L10 A:98632 T:596683 E21570'
G[39865]='L0 T:124348 E20395'
G[39866]='L0 T:97593 E21570'
G[39867]='K512 L10 A:95438 T:95438 P:39123 E21570'
G[39868]='L0 E21570'
G[39869]='L10 E21570'
G[39870]='L0 T:97630 E21570'
G[39871]='L0 E21570'
G[39872]='L0 A:97653 T:-650 P:40609 E21570'	-- you need to challenge and defeat Taurson first, T: is the treasure chest (which Nimhfree had at 1024:53.69,51.30 which is where Taurson died)
G[39873]='L10 A:97667 T:1243402 P:38912 E21570'
G[39874]='L10 A:93531 T:93530 P:PE001 E21570'
G[39875]='L10 A:93530 T:93530 P:39874 E21570'
G[39876]='L10 A:93530 T:90317 P:39875 E21655'
G[39877]='L10 A:90317 T:90317 P:39876 E21655'
G[39878]='L10 A:93531 T:98017 P:39905 E21655'
G[39879]='L10 A:98017 T:98017 P:39878 E21655'
G[39880]='L10 A:98017 T:98017 P:39878 E21655'
G[39881]='L10 A:93531 T:98156 P:39883 E21655'
G[39882]='L10 A:98156 T:98156 P:39884+39889 E21655'	-- TODO: Verify requires 39884
G[39883]='L10 A:98017 T:93531 P:39879+39880 E21655'	-- TODO: Verify requires 39879
G[39884]='L10 A:98156 T:98156 P:39881 E21655'
G[39889]='L10 A:98156 T:98156 P:39881 E21655'
G[39891]='L10 A:93531 T:107139 P:39904 E21655'
G[39896]='L112 E21570'
G[39903]='L10 A:93531 T:98367 P:39883 E21655'
G[39904]='L10 A:98367 T:98367 P:40265 E21655'
G[39905]='L10 A:90317 T:93531 P:40048+39877 E21655'	-- TODO: Verify requires 39877
G[39906]='L10 A:98159 T:98159 P:39891 E21655'
G[39907]='L10 A:107139 T:93531 P:39914 E21655'
G[39910]='L10 A:98381 T:98381 P:39891 E21655'
G[39914]='L10 A:98159 T:98159 P:39906+39910+40169 E21655'	-- TODO: Verify requires 39910 40169
G[39916]='L10 A:98675 T:98675 P:40169 E21655'
G[39918]='L10 A:98698 T:107139 P:40130 E21655'
G[39920]='L45 A:93531 T:99420 P:39907 E21655'
G[39921]='L45 A:99420 T:99420 P:39920 E21655'
G[39923]='L45 A:99420 P:39921 E21655'
G[39925]='L0 E21570'
G[39926]='L0 E21570'
G[39927]='L0 E21570'
G[39928]='L0 E21570'
G[39929]='L0 E21570'
G[39930]='L0 E21570'
G[39931]='L10 P:PI001+39847 E21570'
G[39932]='L10 P:PI001 E21570'
G[39933]='L10 P:PI001 E21570'
G[39934]='L10 E21570'
G[39935]='L10 E21570'
G[39936]='L10 P:PI001 E21570'
G[39937]='L10 P:PI001 E21570'
G[39938]='L10 E21570'
G[39939]='L10 P:PI001 E21570'
G[39940]='L10 P:PI001 E21570'
G[39941]='L10 E21570'
G[39942]='L10 E21570'
G[39943]='L10 P:PI001 E21570'
G[39944]='L10 P:PI001 E21570'
G[39945]='L10 P:PI001 E21570'
G[39946]='L10 P:PI001 E21570'
G[39947]='L10 P:PI001 E21570'
G[39948]='L10 P:PI001 E21570'
G[39949]='L10 P:PI001 E21570'
G[39950]='L10 P:PI001 E21570'
G[39951]='L10 E21570'
G[39952]='L10 E21570'
G[39953]='L10 A:92195 P:PI001 E21570'
G[39954]='L10 P:PI001 E21570'
G[39955]='FA L10 P:PI001 E21570'
G[39956]='FA L10 E21655'
G[39957]='L45 E21655'
G[39958]='L10 A:93523 T:93523 P:PL001 E21570'
G[39959]='FH L10 E21570'
G[39960]='FH L10 P:PI001 E21570'
G[39961]='L10 P:PI001 E21570'
G[39962]='L10 E21570'
G[39963]='L0 T:97793 E21570'
G[39964]='L110 E21570'
G[39965]='L110 E21570'
G[39966]='L110 E21570'
G[39967]='L110 E21570'
G[39968]='L110 E21570'
G[39969]='L25088 E21570'
G[39970]='L0 T:105316 E21570'
G[39971]='K4096 L0 A:701784 T:96400 P:43338 E21570'
G[39972]='SP K131072 L0 A:1244692 T:1244692 E21570'
G[39973]='SP K131072 L0 A:1244694 T:1244694 E21570'
G[39974]='L0 T:700612 E21570'
G[39975]='L0 T:97706 E21570'
G[39976]='L0 E21570'
G[39977]='L0 T:99759 E21570'
G[39978]='L0 E21570'
G[39979]='L0 E21570'
G[39980]='L0 E21570'
G[39981]='L0 E21570'
G[39982]='L0 E21570'
G[39983]='L10 A:98825 T:97891 P:40520 E21570'
G[39984]='L10 A:1244708 T:97973 E21570'
G[39985]='L45 A:95688 T:90417 E21570'	-- TODO: This appeared automatically when I entered Dalaran after gaining level 110
G[39986]='L45 A:90417 T:90417 P:39985 E21570'
G[39987]='L45 A:90417 T:98312 P:39986 E21570'
G[39988]='L10 A:98794 T:97892 P:40112 E21570'
G[39989]='L0 E21691'
G[39990]='L10 A:97892 T:97892 P:39988 E21570'
G[39991]='L0 T:700556 E21570'
G[39992]='L10 A:97903 T:98825 P:40388 E21570'
G[39993]='L0 E21570'
G[39994]='L0 T:97933 E21570'
G[39995]='L110 E21570'
G[39996]='L110 E21570'
G[39997]='L110 E21570'
G[39998]='L10 A:97979 T:97851 P:0 E21570'	--TODO: Yoshimo: find conditions
G[39999]='L110 E21570'
G[40000]='L10 A:97974 T:97974 E21570'	-- no obvious prequest
G[40001]='L10 A:92539 T:97979 P:40078 E21570'
G[40002]='L10 A:97979 T:97979 P:40001 E21570'
G[40003]='L10 A:97979 T:97986 P:40002 E21570'
G[40004]='L10 A:97979 T:97986 P:40002 E21570'
G[40005]='L10 A:97986 T:97988 P:40004+40003 E21570'
G[40006]='L110 E21570'
G[40007]='L110 E21570'
G[40008]='K32 L45 A:98312 T:700118 P:39987 E21570'
G[40009]='L45 A:700118 T:700118 P:40123 E21570'
G[40010]='L45 A:97140 T:102600 P:40956 E21570'
G[40011]='L45 A:97140 T:101499 P:42229 E21570'
G[40012]='L45 A:93446 T:1245328 P:42229 E21570'
G[40013]='L10 A:92458 T:92464 P:PH001 E21570'
G[40014]='L10 A:92464 T:92464 P:40013+PH001 E21570'
G[40015]='L10 T:92464 P:PH001 E21570'
G[40016]='L10 A:92464 P:40015+PH001 E21570'
G[40017]='L10 T:92464 P:PH001 E21570'
G[40018]='L10 A:109734 T:92464 P:PH001 E21570'
G[40019]='L10 T:92464 P:40018+PH001 E21570'
G[40020]='L10 T:98135 P:PH001 E21570'
G[40021]='L10 A:98135 P:40020+PH001 E21570'
G[40022]='L10 P:PH001 E21570'
G[40023]='L10 P:40022+PH001 E21570'
G[40024]='L10 A:92458 T:92464 P:PH001 E21570'
G[40025]='L10 A:701613 T:92464 P:PH001 E21570'
G[40026]='L10 A:92464 T:92464 P:40025+PH001 E21570'
G[40028]='L10 P:PH001 E21570'
G[40029]='L10 T:92464 P:PH001 E21570'
G[40030]='L10 T:92464 P:PH001 E21570'
G[40031]='L10 T:92464 P:40030+PH001 E21570'
G[40032]='L10 P:PH001 E21570'
G[40033]='L10 P:40032+PH001 E21570'
G[40034]='L10 A:-650 T:92464 P:PH001 E21570'
G[40035]='L10 A:92464 T:92464 P:40034+PH001 E21570'
G[40036]='L10 T:92464 P:PH001 E21570'
G[40037]='L10 A:92464 T:92464 P:40036+PH001 E21570'
G[40038]='L10 P:PH001 E21570'
G[40039]='L10 P:40038+PH001 E21570'
G[40040]='L10 A:100482 T:92464 P:PH001 E21570'
G[40041]='L10 A:92464 T:92464 P:40040+PH001 E21570'
G[40042]='L10 P:40041+PH001 E21570'
G[40043]='K4096 L10 A:96469 T:96469 P:40579+40581 E21570'
G[40044]='L10 A:97973 T:97973 P:39984 E21570'
G[40045]='L10 A:98067 T:98067 O:40244 E21570'	-- TODO: Originally was P:40244 which is wrong.  Verify.
G[40046]='L10 A:97973 T:97973 P:39984 E21570'
G[40047]='L10 A:98067 T:98067 O:40244 E21570'	-- TODO: Originally was P:40244 which is wrong.  Verify.
G[40048]='L10 A:90317 T:90317 P:39876 E21655'
G[40049]='L10 A:98067 T:98067 O:40244 E21570'	-- TODO: Originally was P:40244 which is wrong.  Verify.
G[40050]='K32768 L10 M109 A:-120650 T:-650 E21570'
G[40051]='L8 A:99045 T:93127 P:40222 E21570'
G[40052]='L10 P:PI001 E21570'
G[40056]='L10 P:PI001 E21570'
G[40057]='L10 P:PI001 E21570'
G[40058]='L10 E21570'
G[40059]='L10 E21570'
G[40060]='L10 P:PI001 E21570'
G[40061]='L10 E21570'
G[40062]='L10 E21570'
G[40063]='L10 P:PI001 E21570'
G[40064]='L10 E21570'
G[40065]='L10 E21570'
G[40066]='L0 E21570'
G[40067]='L0 E21570'
G[40068]='L0 T:98188 E21570'
G[40069]='L10 A:700060 T:94068 E21570'	--no obvious prequest
G[40070]='L10 A:700060 T:94068 E21570'	--no obvious prequest
G[40071]='L10 A:700060 T:94068 E21570'	--no obvious prequest
G[40072]='L10 A:97988 T:1251991 P:40005 E21570'
G[40073]='L0 T:98199 E20490'
G[40074]='L0 E20490'
G[40075]='L0 T:98198 E20490'
G[40076]='L0 T:98486 E21570'
G[40077]='L8 CE A:93011 T:98229 E21531'
G[40078]='L10 A:92539 T:92539 P:39855 E21570'
G[40079]='L0 T:98241 E21570'
G[40080]='L0 T:700284 E21570'
G[40081]='L0 T:98268 E21570'
G[40082]='SP K131072 L0 A:1244887 T:1244887 E21570'
G[40083]='SP K131072 L0 A:1233107 T:1233107 E21570'
G[40084]='L0 T:98299 E21570'
G[40085]='SP K131072 L0 A:1244899 T:1244899 E21570'
G[40086]='SP K131072 L0 A:1244901 T:1244901 E21570'
G[40087]='L0 T:-672 E21570'	-- you get this when you sacrifice Sevis
G[40088]='SP K131072 L0 A:1244902 T:1244902 E21570'
G[40089]='SP K131072 L0 A:1244903 T:1244903 E21570'
G[40090]='SP K131072 L0 A:1244904 T:1244904 E21570'
G[40091]='SP K131072 L0 A:1244905 T:1244905 E21570'
G[40093]='SP K131072 L0 A:1244909 T:1244909 E21570'
G[40094]='SP K131072 L0 A:1244912 T:1244912 E21570'
G[40095]='SP K131072 L0 A:1244913 T:1244913 E21570'
G[40096]='L0 T:98311 E21570'
G[40097]='L0 E21570'
G[40098]='L0 E21655'
G[40099]='SP K131072 L0 A:1244917 T:1244917 E21570'
G[40100]='L0 E21570'
G[40101]='L0 E21655'
G[40102]='L10 A:98067 T:700102 P:40045+40047+40049 E21570'
G[40103]='L0 E21570'
G[40104]='L0 A:98285 T:98285 E20490'
G[40105]='L0 A:98283 T:98283 E20490'
G[40106]='L0 A:98284 T:98284 E20490'
G[40107]='L0 A:98408 T:98408 E20490'
G[40108]='SP K131072 L0 A:1244928 T:1244928 E21570'
G[40109]='L0 T:98421 E21570'
G[40111]='L10 A:98587 T:98498 P:0 E21570'	-- TODO: Yoshimo: possible WQ
G[40112]='L10 A:97891 T:98794 P:39983 E21570'	-- if you abandon this, you will no longer get it from 97891 but rather from 98825
G[40113]='L0 T:98503 E21570'
G[40114]='L110 E21570'
G[40115]='L110 E21570'
G[40116]='L110 E21570'
G[40120]='L10 A:98587 T:98587 E21570'
G[40121]='L45 E21570'
G[40122]='L10 A:91462 T:91109 O:39861 E21570'
G[40123]='L45 A:700118 T:700118 P:40008 E21570'
G[40124]='L0 E21570'
G[40125]='L45 A:97140 T:97140 P:44156 E21570'	-- TODO: Yoshimo: verify 44156
G[40126]='L0 T:95123 E21570'
G[40127]='L0 E21570'
G[40129]='L110 E21570'
G[40130]='L10 A:98675 T:98698 P:39916 E21655'
G[40131]='L10 A:91824 T:93541 P:PS001 E21570'
G[40132]='L10 A:93541 T:93541 P:40131+PS001 E21570'
G[40133]='L10 A:578564 T:94409 P:PS001 E21570'
G[40134]='L10 A:94409 T:94409 P:PS001 E21570'
G[40135]='L10 A:94409 T:94409 P:PS001+0 E21570'	-- Yoshimo: not available with LW196, Skinning 800 on my DH
G[40136]='L10 A:98969 T:93541 P:0 E21655'
G[40137]='L10 A:93541 T:98720 P:PS001+0 E21570'
G[40138]='L10 A:98720 T:98720 P:PS001+0 E21570'	-- Yoshimo: not available with LW196, Skinning 800 on my DH
G[40139]='L10 A:98720 T:98720 P:PS001+0 E21570'
G[40140]='L10 A:98720 P:PS001+0 E22197'	-- Yoshimo: not available with LW196, Skinning 800 on my DH
G[40141]='L10 A:92414 T:93541 P:PS001 E21570'
G[40142]='L10 A:93541 T:93541 P:40141+PS001 E21570'
G[40143]='L10 A:98109 T:93541 P:40142+PS001+0 E21570'
G[40144]='L10 A:93541 T:98791 P:PS001+0 E21570'
G[40145]='L10 A:98791 T:98791 P:40144+PS001 E21570'
G[40146]='L10 A:93541 T:98721 P:PS001+0 E21570'
G[40147]='L10 A:98721 T:98721 P:PS001+0 O:40146 E21570'
G[40148]='L10 A:98721 T:98721 P:PS001+0 E21570'
G[40149]='L10 A:98721 T:98721 P:PS001+0 E21570'
G[40151]='L10 E21570'
G[40152]='L10 P:PS001 E21570'
G[40153]='K4096 L10 P:40955+PS001 E21570'
G[40154]='L10 P:PS001 E21570'
G[40155]='L10 E21916'
G[40156]='L45 A:98648 T:93541 P:PS001 E21570'
G[40157]='L45 A:93541 T:98720 P:PS001+0 E21570'
G[40158]='L45 A:98720 T:98720 P:PS001+40157 E21570'	-- Yoshimo: not available with LW196, Skinning 800 on my DH
G[40159]='L45 A:93541 P:PS001+0 E21796'
G[40160]='L45 E21570'
G[40161]='L45 E21570'
G[40162]='L110 E21570'
G[40163]='L110 E21570'
G[40164]='L0 E21570'
G[40166]='L10 E21570'
G[40167]='L10 A:98825 T:98825 P:40515 E21570'
G[40168]='Hf L7882240 A:100129747 T:98685 E20490'
G[40169]='L10 A:107139 T:98675 P:39891 E21655'
G[40170]='L10 A:94409 T:94409 O:39417,40217 E21570'
G[40173]='Hf K4 L7882240 A:100129928 T:98690 E20490'
G[40175]='L0 T:98890 E21570'
G[40176]='L10 A:93523 T:93523 P:PL001 E21570'
G[40177]='L10 A:93523 T:93522 P:PL001 E21570'
G[40178]='L10 A:93522 T:93522 P:PL001 E21570'
G[40179]='L10 A:93522 T:93522 P:PL001 E21570'
G[40180]='L10 A:93523 T:98931 P:PL001 E21570'
G[40181]='L10 A:98931 T:98931 P:PL001 E21570'
G[40182]='L10 A:98931 T:98931 P:PL001 E21570'
G[40183]='L10 A:93523 T:93523 P:39958+PL001 E21570'
G[40184]='L10 A:93522 T:98948 P:PL001 E21570'
G[40185]='L10 A:98948 T:98948 P:PL001 E21570'
G[40186]='L10 A:98948 T:98948 P:PL001 E21570'
G[40187]='L10 A:98931 T:98964 P:PL001 E21570'
G[40188]='L10 A:98964 T:98964 P:PL001 E21570'
G[40189]='L10 A:98964 T:98964 P:PL001 E21570'
G[40190]='L10 E21570'
G[40191]='L10 A:98948 T:98948 P:PL001 E21570'
G[40192]='L10 A:98948 T:98948 P:PL001 E21570'
G[40193]='L10 E21655'
G[40194]='L10 A:98964 T:98964 P:PL001 E21570'
G[40195]='L10 A:98964 T:99689 P:PL001 E21570'
G[40196]='L10 A:93523 T:93523 P:PL001 E21570'
G[40197]='L10 A:93523 T:93523 P:PL001 E21570'
G[40198]='L10 A:93522 T:93522 P:PL001 E21570'
G[40199]='L10 A:98931 T:98931 P:PL001 E21570'
G[40200]='FA L10 A:93523 T:93523 P:PL001 E21570'
G[40201]='L10 A:93523 T:93523 P:PL001 E21570'
G[40202]='L10 A:93522 T:98948 P:PL001 E21570'
G[40203]='L10 A:98948 T:98948 P:PL001 E21570'
G[40204]='L10 A:98948 T:98948 P:PL001 E21570'
G[40205]='L10 A:98948 T:98948 P:PL001 E21570'
G[40206]='L10 A:98931 T:98964 P:PL001 E21570'
G[40207]='L10 A:98964 T:98964 P:PL001 E21570'
G[40208]='L10 A:98964 T:98964 P:PL001 E21570'
G[40209]='L10 A:98964 T:98964 P:PL001 E21570'
G[40210]='L10 A:98964 T:93523 P:PL001 E21570'
G[40211]='L45 A:93523 T:98969 P:PL001 E21570'
G[40212]='L45 A:98969 T:98969 P:PL001+0 E21570'	--Yoshimo: not available for a 110 DH with LW 196 entering Suramar
G[40213]='L45 A:98969 T:98969 P:PL001+0 E21570'	--Yoshimo: not available for a 110 DH with LW 196 entering Suramar
G[40214]='L45 A:98969 T:98969 P:PL001+0 E21655'	--Yoshimo: not available for a 110 DH with LW 196 entering Suramar
G[40215]='L45 A:93523 P:PL600 E21570'
G[40216]='L10 A:94409 T:94409 P:39859+40170 E21570'
G[40217]='L10 A:99905 T:94409 P:39387,39456 I:39417 E21570'
G[40218]='L10 E21570'
G[40219]='L10 A:99153 T:108069 P:39575 E21570'
G[40220]='L10 A:93600 T:93600 E21570'
G[40221]='L10 A:93600 T:93600 E21570'
G[40222]='L8 A:98711 T:99045 P:38725 E21570'
G[40223]='L0 T:700598 E21570'
G[40224]='L10 E21570'
G[40225]='L10 E21570'
G[40227]='L45 A:99093 T:99093 P:40266+40744 E21570'
G[40228]='L10 A:94409 T:94409 P:39392+39124+40216+39123 E21570'	-- TODO: Verify requires 39124 39123
G[40229]='L10 A:96453 T:95392 P:39426 E21570'
G[40230]='L10 A:98067 T:700102 P:40045+40047+40049 E21570'
G[40231]='L0 E21570'
G[40232]='L0 T:97059 E21570'
G[40233]='L0 T:97057 E21570'
G[40234]='L0 T:97370 E21570'
G[40235]='L40 A:99180 E20490'
G[40236]='L10 A:99181 T:100438 P:12103 E21570'
G[40237]='L40 A:99183 T:99183 E20490'
G[40238]='L45 A:121521 T:121578 P:47431'
G[40240]='L0 E21570'
G[40241]='FH L10 P:PL001 E21570'
G[40242]='L0 T:95290 E21570'
G[40243]='L10 E21691'
G[40244]='L10 A:94409 T:98067 P:40228 E21570'	-- TODO: Yoshimo: check if needed for all quests at Shipwreck Cove
G[40245]='L0 E21570'
G[40246]='L0 E21570'
G[40247]='K4096 L10 CE A:99247 T:90417 P:40814+40818 E21570'
G[40249]='K4096 L10 CE A:99247 T:102799 P:41807+40374 E21570'
G[40250]='L0 E21570'
G[40251]='SP L0 A:96997 T:96997 E21570'
G[40252]='SP L0 A:1280838 T:1280838 P:40404 E21570'
G[40253]='L8 A:592718 T:596665 P:38690+38689+39518 E21570'
G[40254]='L8 A:96675 T:96675 P:39682+39518 E21570'
G[40255]='FA L8 A:97644 TP:96669:40375;96666:40374 P:40373+39518 E21570'	-- Night Elf Tank Altruis, Night Elf Tank Kayn
G[40256]='FH L8 A:97644 TP:96669:40375;96666:40374 P:40373+39518 E21570'	-- Blood Elf Tank Kayn
G[40257]='L45 E21570'
G[40258]='L0 E21570'
G[40259]='L45 E21570'
G[40260]='L0 E21570'
G[40261]='L45 E21570'
G[40265]='L10 A:98367 T:98367 P:39903 E21655'
G[40266]='L45 A:99065 T:99093 P:42229 E21570'	-- TODO: Yoshimo: verify 42229
G[40267]='K4096 L10 A:102700 T:99398 P:41085+41080 E21570'
G[40268]='L110 E21570'
G[40269]='L110 E21570'
G[40270]='K4096 L10 A:99398 T:99415 P:40267 E21570'
G[40272]='L0 E21570'
G[40273]='L0 E21570'
G[40274]='L0 T:700606 E21570'
G[40276]='L10 E21570'
G[40277]='K278528 L45 A:-180627,-600630,-570646 T:-627,-630,-646 P:a40277+46734 E21691'
G[40278]='K278528 L45 A:-530634 T:103245 P:a40278 E21796'
G[40279]='K278528 L45 A:99035 T:99035 P:a40279 E21570'
G[40280]='K278528 L45 A:-480634,-470641,-470650 T:-634,-641,-650 P:a40280 E21570'
G[40282]='K278528 L45 A:94068 T:-650 P:a40282 E21655'
G[40288]='SP L0 A:1280843 T:1280843 P:40293'
G[40293]='SP L0 A:1280842 T:1280842 P:40252'
G[40296]='L0 E21570'
G[40297]='L45 CK CD CH CM CO CP CT CR CS CL CW A:98801 T:99514 P:42229 I:44489 E21570'	-- TODO: YOSHIMO: non-DH, verify 42229
G[40298]='K278528 L45 N53 A:98648 T:94691 P:a40298+46734 E21737'
G[40299]='K278528 L45 N53 A:-200627,-840630,-600646 T:-627,-630,-646 P:a40299+46734 E21570'	-- TODO: Pet battle
G[40300]='L45 A:99093 T:99483 P:40227 E21570'
G[40301]='L0 T:97069 E21570'
G[40302]='L0 E21570'
G[40303]='L0 T:112336 E21570'
G[40304]='L0 E21570'
G[40305]='L0 E21570'
G[40306]='L45 A:99483 T:99575 P:40300 E21570'
G[40307]='L45 A:99514 T:99514 P:40297,44489 E21570'
G[40308]='L45 A:1245688 T:99483 P:40266+40744 E21570'	-- TODO: verify 40744
G[40310]='L1 E21570'
G[40311]='L0 E21691'
G[40313]='L0 E21570'
G[40314]='SP L0 A:1280836 T:1280836 P:40397 E21570'
G[40315]='L45 A:99575 T:99575 P:40306+40578 E21570'
G[40316]='K262144 L10 M109 A:-110650 T:-650 P:a40316 E21570'
G[40317]='L0 E21570'
G[40319]='L45 A:99575 T:99575 P:40315 E21570'
G[40320]='L45 A:99544 T:102334 P:40908 E21570'
G[40321]='L45 A:99575 T:100779 P:40319 E21570'
G[40322]='L110 E21570'
G[40323]='L110 E21570'
G[40324]='L45 A:97140 T:97140 P:41138+42147 E21570'
G[40325]='L45 A:97140 T:97140 P:40324 E21570'
G[40326]='L45 A:1245328 T:1247694 P:40012 I:41212 E21570'	-- Yoshimo: turning this in also completes 41212
G[40327]='L10 A:99689 T:98964 P:40195+PL001 E21570'
G[40328]='L45 A:99890 T:99890 P:40901,44490 E21570'
G[40329]='L10 A:85418 T:85418 P:0 E20490'	-- TODO: Yoshimo: requires at least the garrison being build
G[40331]='L45 A:99544 T:102334 P:40908 E21570'
G[40332]='L45 A:99559 T:102334 P:40908 E21570'
G[40333]='L110 E21570'
G[40334]='L45 A:102334 T:102381 P:40320+40331+40332 E21570'
G[40335]='L110 E21570'
G[40336]='L45 A:102410 T:102410 P:41426+41709 E21570'
G[40337]='K278528 L45 A:-750630,-760680 T:-630,-680 P:a40337 E21911'
G[40338]='L0 T:700610 E21570'
G[40339]='L10 A:97130 T:97130 P:39769 E21570'
G[40340]='L0 E21570'
G[40341]='L10 E21570'
G[40342]='L45 E21570'
G[40343]='L0 E21570'
G[40345]='L10 A:97130 T:97130 P:40339 E21570'
G[40346]='L45 E27980'
G[40347]='L0 T:96590 E21570'
G[40348]='L45 A:99788 T:99788 P:40368 E21570'
G[40349]='L10 A:100130921 T:-110625 E21737'
G[40350]='L10 E21737'
G[40351]='L10 A:100130923 T:-120625 E21737'
G[40352]='L10 T:-625 E21737'
G[40353]='L10 A:100130925 T:-110625 E21737'
G[40354]='L10 A:100130926 T:-140625 E22197'
G[40355]='L10 A:100130927 T:-160625 E21691'
G[40356]='L10 A:100130928 T:-140625 E22197'
G[40357]='L10 A:100130929 T:-150625 E22197'
G[40358]='L10 T:-625 E22197'
G[40359]='L10 A:100130931 T:-100625 E21570'
G[40360]='L10 E21570'
G[40361]='L10 A:100130933 T:-130625 E21570'
G[40362]='L10 A:100130934 T:-170625 E21570'
G[40363]='L10 E21655'
G[40364]='L45 A:104406 T:104406 P:41606 E21570'
G[40368]='L45 A:99788 T:99788 P:0 E21570'	-- TODO: Yoshimo: needs P:, Part of the Feeding Shal'Aran story arc
G[40369]='L0 E21570'
G[40370]='L45 A:99788 T:99788 P:40368 E21570'
G[40373]='L8 A:97644 T:97644 P:39686 E21570'
G[40374]='L0 T:97644 I:40375 E21570'
G[40375]='L0 T:97644 I:40374 E21570'
G[40378]='L8 A:98229 T:94410 P:40077 E21570'
G[40379]='L8 A:100982 T:93759 P:40378 E21570'
G[40380]='L0 E21570'
G[40381]='L0 E21570'
G[40382]='L0 E21570'
G[40383]='L0 E21570'
G[40384]='K4096 L10 CH A:100786 T:102478 P:43635 E21570'	-- P:43635 was wrong for Chromie time
G[40385]='L10 E21570'
G[40386]='L0 E21570'
G[40388]='L10 A:97892 T:97903 P:39990 E21570'
G[40389]='L0 A:0 T:0 P:39824+39503+39466 E21570'	-- TODO: Add killing Crawshuk quest
G[40390]='L45 E21570'
G[40391]='FA L45 A:115736 T:114909 P:45263 E21570'
G[40392]='L10 E21570'
G[40395]='L1 E20490'
G[40397]='SP L0 A:1280815 T:1280815 E21570'
G[40398]='L0 E21570'
G[40399]='L0 E21570'
G[40400]='FA L10 E21570'
G[40401]='L45 A:100185 T:100192 P:0 E21570'	-- Yoshimo: not available on my DH beginning in Suramar
G[40402]='FH L10 RO RU RT RL RG RA RR RM RZ E21570'
G[40403]='FH L10 RB E21570'
G[40404]='SP L0 A:1280837 T:1280837 P:40314 E21570'
G[40405]='L0 T:97449 E21570'
G[40406]='L0 T:98024 E21570'
G[40408]='K4096 L10 A:90369 T:90369 P:38710 E21531'
G[40409]='L0 T:90369 E21570'
G[40410]='L0 E21570'
G[40411]='L0 E21570'
G[40412]='L45 A:100823 T:100878 P:41097+41098 E21570'
G[40413]='L0 P:40612 E21570'	-- you can only see the treasure if you killed the hunters in the cave before
G[40414]='L0 T:100495 E21570'
G[40415]='L10 A:98948 T:93523 P:PL001 E21570'
G[40416]='L0 E20490'	-- I am assuming this is the quest that marks a boosted to 100 level character
G[40417]='FH L40 T:92400 E20726'	-- automatically given to boosted Horde character
G[40418]='FA L40 T:92219 E20490'
G[40419]='L10 E21570'
G[40420]='L0 E21570'
G[40422]='L0 T:97069 E21570'
G[40423]='L0 T:109498 E21570'
G[40424]='K32 L45 A:100185 T:100301 P:40469 E21570'
G[40425]='L0 E21570'
G[40426]='L0 E21570'
G[40427]='L0 E21570'
G[40428]='L0 E21570'
G[40429]='L0 E21570'
G[40430]='L0 E21570'
G[40431]='L0 E21570'
G[40432]='L0 E21570'
G[40433]='L0 E21570'
G[40434]='L0 E21570'
G[40435]='L0 E21570'
G[40436]='L0 E21570'
G[40437]='L0 E21570'
G[40438]='L0 E21570'
G[40439]='L0 E21570'
G[40440]='L0 E21570'
G[40441]='L0 E21570'
G[40442]='L0 E21570'
G[40443]='L0 E21570'
G[40444]='L0 E21570'
G[40445]='L0 E21570'
G[40446]='L0 E21570'
G[40447]='L0 E21570'
G[40448]='L0 E21570'
G[40449]='L0 E21570'
G[40450]='L0 E21570'
G[40451]='L0 E21570'
G[40452]='L0 E21570'
G[40453]='L0 E21570'
G[40454]='L0 E21570'
G[40455]='L0 E21570'
G[40456]='L0 E21570'
G[40457]='L110 E21570'
G[40458]='L110 E21570'
G[40459]='L110 E21570'
G[40460]='L110 E21570'
G[40461]='L110 E21570'
G[40462]='L110 E21570'
G[40463]='L110 E21570'
G[40464]='L110 E21570'
G[40465]='L110 E21570'
G[40466]='L110 E21570'
G[40467]='L110 E21570'
G[40468]='L110 E21570'
G[40469]='L45 A:100192 T:100185 P:40401 E21570'
G[40470]='L45 A:100331 T:97140 P:40424 E21570'	-- TODO: T: changes based on where you have moved her with her quests...therefore, need to be smart about what it is
G[40471]='SP K131072 L0 T:703805 E21570'	-- 1080[6]:62.85,67.70
G[40472]='L0 E21570'
G[40473]='L0 E21570'
G[40474]='SP K131072 L0 A:1245528 T:1245528 E21570'
G[40475]='SP K131072 L0 A:1245529 T:1245529 E21570'
G[40476]='SP K131072 L0 A:1245530 T:1245530 E21570'
G[40477]='SP K131072 L0 A:1245531 T:1245531 E21570'
G[40478]='SP K131072 L0 A:1245532 T:1245532 E21570'
G[40479]='SP K131072 L0 A:1245533 T:1245533 E21570'
G[40480]='SP K131072 L0 A:1245534 T:1245534 E21570'
G[40481]='SP K131072 L0 A:1245535 T:1245535 E21570'
G[40482]='SP K131072 L0 A:1245536 T:1245536 E21570'
G[40483]='SP K131072 L0 A:1245537 T:1245537 E21570'
G[40484]='SP K131072 L0 A:1245538 T:1245538 E21570'
G[40485]='L110 E21570'
G[40486]='L110 E21570'
G[40487]='L0 E21570'
G[40488]='SP K131072 L0 A:1245542 T:1245542 E21570'
G[40489]='L0 E21570'
G[40490]='L110 E21570'
G[40491]='SP K131072 L0 A:1245545 T:1245545 E21570'
G[40492]='L110 E21570'
G[40493]='SP K131072 L0 A:1245547 T:1245547 E21570'
G[40494]='SP K131072 L0 A:1245548 T:1245548 E21570'
G[40495]='K4096 L10 A:101097 T:100323 P:40684+40686 E21570'
G[40496]='SP K131072 L0 A:1245550 T:1245550 E21570'
G[40497]='L0 T:98003 E21570'
G[40498]='SP K131072 L0 A:1245553 T:1245553 E21570'
G[40499]='L0 T:700528 E21570'
G[40500]='L0 E21570'
G[40501]='L0 E22289'
G[40502]='L0 E21570'
G[40504]='L110 E21570'
G[40505]='SP K131072 L0 A:1245579 T:1245579 E21570'
G[40506]='SP K131072 L0 A:1245580 T:1245580 E21570'
G[40507]='SP K131072 L0 A:1245581 T:1245581 E21570'
G[40508]='SP K131072 L0 A:1245601 T:1245601 E21570'
G[40509]='SP K131072 L0 A:1245602 T:1245602 E21570'
G[40510]='SP K131072 L0 A:1245603 T:1245603 E21570'
G[40512]='L110 E21570'
G[40513]='L110 E21570'
G[40514]='L0 E21570'	-- while doing 40495, this completes when you have convinced Revil, allowing 40495 to be turned in
G[40515]='L10 A:93826 T:98825 P:38909 E21570'
G[40516]='L0 E21570'
G[40517]='FA L10 A:100395 T:100429 P:42740,43806 E21570'	-- ODC:41306 (Chromie time)
G[40518]='L10 A:113547 T:100453 P:44281 E21570'
G[40519]='FA L10 AZ:84 T:107934 E21570'	-- Night Elf Druid given this automatically in Legion beta when appearing in SW, and actually Nimhfree got immediately logging in while in Lunarfall -- now in Shadowlands this is given when you select Legion from Chromie
G[40520]='L10 A:98825 T:98825 P:40167 E21570'
G[40521]='L0 E21570'
G[40522]='FH L10 A:100453 T:100866 P:40518,44543 E21691'
G[40523]='L10 A:93526 T:93526 P:PJ001 E21570'
G[40524]='L10 A:93527 T:100538 P:PJ001 E21570'
G[40525]='L10 A:100538 T:100538 P:PJ001 E21570'
G[40526]='L10 T:703934 P:PJ001 E21570'
G[40527]='L10 T:703934 E21570'
G[40528]='L10 A:100710 T:100538 E21570'
G[40529]='L10 A:93526 T:93526 P:PJ001 E21570'
G[40530]='L10 A:93526 T:93526 P:PJ001 E21570'
G[40531]='L10 A:93526 T:93526 P:PJ001 E21570'
G[40532]='L10 E21570'
G[40533]='L10 A:100623 T:93526 P:0 E21570'	--TODO: Yoshimo: requires jewelcrafting ,maybe more details
G[40534]='L10 P:PJ001 E21570'
G[40535]='L10 A:93526 P:PJ001 E21570'
G[40536]='L10 P:PJ001 E21570'
G[40537]='FA L50 E32144'
G[40538]='L10 P:PJ001 E21570'
G[40539]='L10 P:PJ001 E21570'
G[40540]='L10 P:PJ001 E21570'
G[40541]='L10 P:PJ001 E21570'
G[40542]='L10 P:PJ001 E21570'
G[40543]='L10 E21570'
G[40544]='L10 E21570'
G[40545]='L10 A:93539 T:102193 P:PN001 E21570'
G[40546]='L10 P:PJ001 E21570'
G[40547]='L10 P:PJ001 E21570'
G[40554]='L0 E21570'
G[40556]='L10 P:PJ001 E21570'
G[40557]='L0 E21570'
G[40558]='L45 A:100500 T:703840 P:PJ001 E21570'
G[40559]='L45 E21570'
G[40560]='L45 P:PJ001 E21570'
G[40561]='L45 P:PJ001 E21570'
G[40562]='L45 A:93543 T:93543 P:PJ001 E21570'
G[40564]='L1 E21570'
G[40565]='L0 E21570'
G[40566]='L0 E21953'
G[40567]='K512 L10 N53 A:104921 T:104921 P:38743 E21570'
G[40568]='L10 A:91249 T:96465 P:38618,38412 E21570'
G[40569]='L10 A:100438 T:100475 E21570'
G[40570]='L10 A:47684 T:101046 P:40634 E21570'
G[40571]='L0 E21570'
G[40572]='L0 E21570'
G[40573]='L10 A:91650 T:100573 P:39384 E21570'
G[40574]='L0 E21570'
G[40578]='L45 A:99483 T:99575 P:40300 E21570'
G[40579]='K4096 L10 A:96469 T:96469 P:39654 ODC:40618 E21570'
G[40580]='L0 E21570'
G[40581]='L0 E21570'
G[40582]='L0 E21570'
G[40584]='L0 T:109326 E21570'
G[40585]='L10 A:100635 T:100635 P:39214 E21570'
G[40588]='K32 L10 A:100323 T:100729 P:40495 E21570'
G[40590]='L0 E21570'
G[40591]='L0 E21570'
G[40593]='FA L10 A:100675 T:100973 P:40517 E21570'
G[40594]='L10 A:700047 T:97407 P:42512 E21570'
G[40595]='L0 E21570'
G[40596]='L0 E21570'
G[40597]='L110 E21570'
G[40598]='L10 E21570'
G[40601]='L0 E21570'
G[40603]='L45 A:111826 T:100738 P:43526'
G[40604]='K4096 L10 A:100729 T:1245793 P:40588 E21570'
G[40605]='FH L10 A:101035 T:95234 P:40607 ODC:40768,41002 E21691'
G[40606]='L10 A:1245793 T:100729 P:40604 E21570'
G[40607]='FH L10 A:100873 T:101035 P:40760 ODC:40658,40983,33707 E21691'
G[40608]='L45 A:100738 T:100738 P:40603'
G[40609]='L0 T:97668 E21570'
G[40610]='L0 T:97102 E21570'
G[40611]='L10 A:100729 T:100812 P:40606 ODC:41154 E21570'
G[40612]='L0 E21570'
G[40613]='K512 L45 A:100738 T:100738 P:40608'
G[40614]='K512 L45 A:100738 T:100738 P:40613'
G[40615]='K512 L45 A:100738 T:100738 P:40614+40672'	-- TODO: Verify requires 40614
G[40616]='L0 T:91473 E21570'	-- this is when Voljin dies and Sylvanas becomes war chief
G[40617]='L45 A:100775 T:100775 P:0 E21570'	-- Yoshimo: didn't offer quest on my DH
G[40618]='K4096 L10 A:102478 T:102478 P:41415 E21570'
G[40619]='L0 E21570'
G[40620]='L0 E21570'
G[40621]='L0 E21570'
G[40622]='L0 E21570'
G[40623]='L10 A:100812 T:101282 P:40611 ODC:41155 E21570'
G[40625]='L45 A:101076 T:101076 P:0 E21570'	--Yoshimo: not available for a 110 DH entering Suramar
G[40627]='L0 E21570'
G[40628]='L0 E21570'
G[40629]='L0 E21570'
G[40630]='L0 E21570'
G[40632]='FH L45 A:115736 T:700814 P:45263 E21570'
G[40633]='L10 A:100475 T:100571 P:40569 E21570'
G[40634]='L10 CO A:47684 T:47684 E21570'
G[40635]='L45 E27980'
G[40636]='L10 A:100438 T:100438 E21570'
G[40637]='L45 E27980'
G[40638]='L0 E21570'
G[40639]='L0 E21570'
G[40640]='L0 E21570'
G[40641]='L0 E21570'
G[40642]='L45 A:101076 T:101076 P:40694 E21570'
G[40643]='K4096 L10 CD A:101061 T:101064 P:44663 E21570'	-- in beta we had: P:43635
G[40644]='K4096 L10 A:101064 T:103875 P:41106 E21570'
G[40645]='K4096 L10 A:103875 T:101195 P:40644 E21570'
G[40646]='K4096 L10 A:101195 T:101195 P:40645 E21570'
G[40647]='K4096 L10 A:104535 T:104535 P:41792 E21570'
G[40649]='K4096 L10 A:103832 T:113525 P:43979 E21570'	-- here the experiment is to require only the quest that selects the artifact and not the other quest that was just completed to be able to pick an artifact.  hopefully this proves true as it means one could pick the artifacts in any order and all would work out properly.
G[40650]='SP L10 A:98013 T:98013 P:B42583 E21691'	-- TODO: Need U code for Zen'tabra
G[40651]='K4096 L25088 A:97923 T:97923 P:41255 E21570'
G[40652]='L10 A:104241 T:98002 P:41332 E21570 D127'
G[40653]='L10 A:98002 T:98002 P:40652 E21570'
G[40654]='L10 A:101195 T:106442 P:42036 E21570'
G[40655]='L0 E21570'
G[40657]='L45 A:101076 T:101076 P:40625 E21570'
G[40658]='L0 T:91473 E21570'
G[40659]='L45 E21570'
G[40661]='FA L10 A:101004 T:101004 P:44120 E21874'	-- this was not available to human warrior when I got the other...another preq needed
G[40662]='L0 E21570'
G[40663]='L0 E21570'
G[40664]='L0 E21570'
G[40668]='K512 L45 A:100482 T:100482 P:43496 E21570'
G[40672]='K512 L45 A:100738 T:100738 P:40613'
G[40673]='L45 A:101083 T:101083 P:43523'
G[40674]='L45 E21570'
G[40675]='K512 L45 A:101080 T:101080 P:40673'	-- mythic dungeon
G[40678]='K512 L45 A:101080 T:101080 P:40675+43525+43524'	-- TODO: Verify requires 40675 43525
G[40680]='L0 T:103183 E21570'
G[40681]='L0 T:101077 E21570'
G[40683]='L45 A:101076 T:101076 P:40625 E21570'
G[40684]='K4096 L10 A:101097 T:101097 P:40729 E21570'
G[40685]='L0 E21570'
G[40686]='L0 E21570'
G[40687]='L0 T:110548 E21570'
G[40688]='L0 E21570'
G[40689]='L0 E21570'
G[40690]='L0 E21570'
G[40691]='L0 E21570'
G[40692]='L0 E21570'
G[40694]='L45 A:101076 T:101076 P:40657+40683 E21570'
G[40698]='L7234048 A:100438 T:100438 E21570'
G[40699]='L0 E21570'
G[40700]='L0 E21570'
G[40701]='L0 E21570'
G[40702]='L0 T:101195 E21570'
G[40703]='L0 E21570'
G[40704]='L10 T:101046 E21570'
G[40705]='K4096 L10 CT A:102333 T:101314 P:43635 E21570'
G[40706]='K4096 L10 A:101314 T:101314 P:40705 E21570'
G[40707]='L0 E21570'
G[40708]='L0 E21570'
G[40709]='L0 T:703997 E21570'
G[40710]='K4096 L10 A:101314 T:101310 P:40706+40707 E21570'
G[40711]='SP K131072 L0 A:1246037 T:1246037 E21570'
G[40712]='L10 A:101282 T:701785 P:40623 ODC:41156 E21570'
G[40713]='L45 A:101076 T:101076 P:40694 E21570'
G[40714]='L10 CK A:111109 T:101441 E21570'
G[40715]='L10 CK A:101441 T:101441 P:40714 E21570'
G[40716]='K4096 L10 CL A:103506 T:101456 P:44663 ODC:38894 E21570'
G[40717]='FA L10 A:101004 T:113637 P:44120 E21846'
G[40718]='FH L10 A:95234 T:113655 P:40605 E21570'
G[40719]='L0 E21570'
G[40720]='L0 E21570'
G[40721]='L0 E21570'
G[40722]='L0 E21570'
G[40723]='L0 E21570'
G[40724]='L0 E21570'
G[40725]='L0 E21570'
G[40726]='L1 E21570'
G[40727]='L45 A:107225 T:107598 P:41878 E21570'
G[40728]='L0 E21570'
G[40729]='K4096 L10 A:101456 T:101097 P:40716 E21570'
G[40730]='L45 A:107225 T:107225 P:41878 E21570'
G[40731]='L10 A:701785 T:701790 P:40712 E21570'
G[40732]='L0 E21570'
G[40733]='L0 E21570'
G[40734]='L0 E21570'
G[40735]='L0 T:108030 E21570'
G[40736]='L0 E21570'
G[40737]='L0 E21570'
G[40738]='L0 E21570'
G[40739]='L0 E21570'
G[40740]='L10 E21570'
G[40743]='L0 E21570'
G[40744]='L45 A:99065 T:99093 P:42229 E21570'	-- TODO: Yoshimo: verify 42229
G[40745]='L45 A:107997 T:108063 P:40947 E21570'
G[40746]='L45 A:107632 T:107598 P:41877 E21570'
G[40747]='L45 A:101499 T:700525 P:40011 E21570'
G[40748]='L45 A:101499 T:102142 P:40747 E21570'
G[40749]='L45 E21570'
G[40751]='SP K131072 L0 A:1246205 T:1246205 E21570'
G[40752]='SP K131072 L0 A:1246206 T:1246206 E21570'
G[40753]='SP K2 L1 A:101527 T:101527 I:31752,34774,56042 ODC:31752,34774,56042 E21570'
G[40755]='L10 A:101547 T:113836 P:42970 E21846'
G[40759]='L0 T:98622 E21570'
G[40760]='FH L10 A:100866 T:100873 P:40522 ODC:40982 E21691'
G[40761]='L45 A:121230 T:701656 P:47238 E21570'
G[40762]='L45 A:106275 T:101768 E21570'
G[40763]='L45 E21570'
G[40764]='L0 E21570'
G[40765]='L0 T:102242 E21570'
G[40766]='L0 E21570'
G[40767]='SP K131072 L0 A:1246254 T:1246254 E21570'
G[40768]='L0 T:91473 E21570'
G[40769]='L0 E21570'
G[40770]='L0 E21570'
G[40771]='L0 E21570'
G[40772]='L0 E21570'
G[40773]='L0 T:101649 E21570'
G[40775]='L0 E21570'
G[40776]='L0 E21570'
G[40777]='L0 E21570'
G[40779]='L45 E27980'
G[40780]='L0 E21570'
G[40781]='L0 E21570'
G[40782]='L0 E21570'
G[40783]='K4096 L10 CD A:700439 T:101656 P:44444 E21570'	-- TODO: And whatever choosing quest is completed (like 44443 in Nimhfree case)
G[40784]='K4096 L10 A:101656 T:101651 P:40783 E21570'
G[40785]='K4096 L10 A:101651 T:100323 P:40784 E21570'
G[40786]='Hf fH K4 L7882240 A:100133377 T:501759 E20726'
G[40787]='Hf fA L7882240 A:100133378 T:101759 E20726'
G[40788]='L0 E21570'
G[40790]='L0 E21570'
G[40792]='Hi K4 L40 AA:94870 AH:594870 TA:94870 TH:594870 E20779 D111'
G[40793]='L10 CO A:100438 T:99179 E21570'
G[40794]='FA L10 A:1239328 T:106930 P:37659 E21570'
G[40795]='L10 A:99179 T:99179 P:40793 E21570'
G[40796]='L45 A:101848 T:101848 P:0 E21570'
G[40797]='L0 E21570'
G[40798]='L45 A:700326 T:111318 P:40796+42147 E21570'	-- TODO: Yoshimo: verify 42147
G[40803]='L0 E21570'
G[40804]='L0 E21570'
G[40805]='L0 E21570'
G[40806]='L0 E21737'
G[40807]='L0 E21737'
G[40808]='L0 E21737'
G[40810]='L0 E21570'
G[40811]='L0 E21570'
G[40812]='L0 E21570'
G[40813]='L0 E21570'
G[40814]='K4096 L10 CE A:99247 T:99247 P:39261 E21570'
G[40815]='L10 CE A:101927 T:90255 P:37658+37660+40375 E21570'	--obviously also needs reignite the wards 37658
G[40816]='L10 A:99254 T:99254 P:39047 E21570'
G[40817]='L0 T:99247 E21570'
G[40818]='L0 T:99247 P:B40814 E21570'
G[40819]='K4096 L10 A:99247 T:594902 P:40814+40817 E21570'
G[40820]='SP K131072 L0 A:1246353 T:1246353 E21570'
G[40821]='L10 A:701790 T:701790 P:40731 E21570 Z27843'
G[40823]='L10 A:701790 T:101921 P:40731 E21570'
G[40824]='L10 A:101921 T:704006 E21570'
G[40825]='L0 E21570'
G[40827]='L0 E21570'
G[40828]='L0 E21570'
G[40829]='L40 E20726'
G[40830]='L45 A:102142 T:97140 P:40748 E21570'
G[40831]='L0 E21570'
G[40832]='K4096 L10 CR A:102018 T:101513 P:43635 E21570'
G[40833]='L0 E21570'
G[40834]='K4096 L10 A:100323 T:100729 P:40785 E21570'
G[40835]='K4096 L10 A:100729 T:1245793 P:40834 E21570'
G[40836]='L0 E21737'
G[40837]='K4096 L10 A:100729 T:100812 P:40835 E21570'
G[40838]='K4096 L10 A:100812 T:101282 P:40837 E21570'
G[40839]='K4096 L10 A:101513 T:101513 P:40832 E21570'
G[40840]='K4096 L10 A:101513 T:101513 P:40839 E21570'
G[40841]='L0 E21570'
G[40842]='L0 E21570'
G[40843]='L0 E21570'
G[40844]='L0 E21570'
G[40845]='L0 E21570'
G[40847]='K4096 L10 A:94159 T:102120 P:40840+40843 E21570'
G[40848]='L0 E21570'
G[40849]='K4096 L10 A:102120 T:94159 P:40847 E21570'
G[40850]='K262144 L45 A:700340 T:102123 P:a40850 E21570'
G[40851]='L0 E21570'
G[40853]='L0 E20726'
G[40854]='L10 A:102193 T:93520 P:40545 E21570'
G[40855]='L10 A:93520 T:102195 P:40854 E21570'
G[40856]='L10 A:102195 T:102195 P:40855 E21570'
G[40857]='L45 A:93538 T:103484 P:PX001 E21570 D142'
G[40858]='L10 A:102195 T:93520 P:40856 E21570'
G[40859]='L10 A:102195 T:102195 P:40855 E21570'
G[40860]='L10 A:93539 T:102197 P:40858 E21570'
G[40861]='L10 A:102197 T:102197 P:40860 E21570'
G[40862]='L10 A:102197 T:102197 P:40860 E21570'
G[40863]='L10 A:93520 T:93520 P:40858 E21570'
G[40864]='L10 A:93520 T:93520 P:40863 E21570'
G[40865]='L10 A:93539 T:102198 P:40864 E21796'
G[40866]='L10 A:102198 T:102198 P:40865 E21796'
G[40867]='L10 A:102198 T:102198 P:40865 E21796'
G[40868]='L10 A:102198 T:93539 P:40866+40867 E21796'	-- TODO: Verify requires 40867
G[40869]='L10 A:93539 T:93539 P:40864 E21796'
G[40870]='L10 A:93520 T:93520 P:40864 E21796'
G[40871]='L10 A:93539 T:102196 P:40868 E21796'	-- TODO: Determine whether requires 40869 40870 which were done earlier
G[40872]='L10 A:102196 T:102196 P:40871 E21796'
G[40873]='L10 A:102196 T:102196 P:40872 E21796'
G[40874]='L10 A:102196 T:102196 P:40872 E21796'
G[40875]='L10 A:102196 T:102196 P:40872 E21796'
G[40876]='L10 A:102196 T:93539 P:40873+40874+40875 E21796'	-- TODO: Verify requires 40873 40874
G[40877]='L10 A:93539 T:93539 P:40876 E21796'
G[40878]='L10 N45 A:93520 T:93520 P:40876 E21796'
G[40879]='L45 A:93520 T:93520 P:40881 E22197'
G[40880]='L45 A:93520 T:1246438 P:40878 E21846'
G[40881]='L45 A:1246438 T:93520 P:40880 E22197'
G[40882]='L45 A:93539 T:93539 P:40877 E21846'
G[40883]='L45 A:101766 T:101767 P:42229 E21570'
G[40884]='L0 E21570'
G[40885]='L0 E21570'
G[40886]='L0 E21570'
G[40888]='L0 E21570'
G[40889]='L0 E21570'
G[40890]='L10 A:1248534 T:1246466 P:38743 E21570 D139'
G[40891]='L0 E21570'
G[40896]='K262144 L45 A:-250650 T:-650 P:a40896 E21655'
G[40897]='L0 T:99610 E21570'
G[40898]='L45 A:99514 T:99514 P:40297,44489 E21570'
G[40900]='K4096 L10 A:101282 T:101195 P:40838 E21570 D127'	-- TODO: Verify this is really D127 as it seems to be the end of the Balance chain
G[40901]='L45 CK CD CH CM CO CP CT CR CS CL CW A:99514 T:99890 P:40307+40898 I:44490 E21570'
G[40902]='L0 T:700537 E21570'
G[40904]='L40 T:102432 E20726'
G[40905]='L0 T:102303 E21570'
G[40906]='L45 E21570'
G[40907]='L45 A:102309 T:99948 P:42229 E21570'	-- TODO: Yoshimo: verify 42229
G[40908]='L45 A:99948 T:99559 P:40907 E21570'
G[40909]='SP K131072 L0 A:1246555 T:1246555 E21570'
G[40910]='SP K131072 L0 A:1246556 T:1246556 E21570'
G[40911]='SP K131072 L0 A:1246557 T:1246557 E21570'
G[40912]='SP K131072 L0 A:1246558 T:1246558 E21570'
G[40913]='SP K131072 L0 A:1246559 T:1246559 E21570'
G[40914]='SP K131072 L0 A:1246560 T:1246560 E21570'
G[40915]='SP K131072 L0 A:1246561 T:1246561 E21570'
G[40916]='SP K131072 L0 A:1246562 T:1246562 E21570'
G[40917]='L0 E21570'
G[40918]='L0 E21570'
G[40919]='L45 A:101076 T:101076 P:40694 E21570'
G[40920]='K262144 L45 A:-580634,-570641,-570650 T:-634,-641,-650 P:a40920 E22566'
G[40921]='L0 E21570'
G[40922]='L0 E21570'
G[40923]='L0 T:97228 E21570'
G[40924]='L0 T:97333 E21570'
G[40925]='K262144 L45 A:-580634,-570641,-570650 T:102297 P:a40925 E21874'
G[40927]='L45 A:99948 T:102390 P:41034 E21570'
G[40929]='L45 A:99890 T:99890 P:40901,44490 E21570'
G[40930]='L10 CK A:101441 T:100323 E21570'
G[40931]='L10 CK A:100323 T:100729 E21570'
G[40932]='L10 A:100729 T:1245793 E21570'
G[40933]='L10 A:100729 T:100812 E21570'
G[40934]='L10 A:100812 T:101282 E21570'
G[40935]='L10 A:101282 T:93437 E21570'
G[40936]='L0 E21570'
G[40937]='L0 E21570'
G[40938]='K4096 L10 A:101313 T:102655 P:40710 E21570'
G[40939]='L0 E21570'
G[40940]='L0 E21570'
G[40941]='L40 E20726'
G[40942]='L40 E20726'
G[40943]='L40 E20726'
G[40944]='L40 E20726'
G[40947]='L45 A:108411 T:107997 P:41148 E21570'
G[40949]='L45 A:106095 T:106182 P:42229 E21570'	--TODO: Yoshimo: verify 42229
G[40950]='K4096 L10 A:101513 T:101513 P:41924,40849,42504 E21570'
G[40951]='K262144 L45 A:-150650 T:-650 P:a40951 E22908'
G[40952]='L10 E21570'
G[40953]='K4096 L10 A:102478 T:102578 P:41009 E21570'
G[40954]='K4096 L10 A:102578 T:102574 P:40953 E21570'
G[40955]='K4096 L10 A:102574 T:102574 P:40954 E21570'
G[40956]='L45 A:98548 T:1246713 P:44691 E21570'
G[40957]='SP L10 CH A:107317 T:107317 E21570'
G[40958]='L10 A:102940 T:103023 P:40955 E21570'	-- P:41047 was replaced 2021-04-29
G[40959]='L10 A:103023 T:103023 P:40958 E21570'
G[40960]='L10 T:90417 E21570'
G[40961]='L10 A:90417 T:95844 E22197'
G[40962]='L40 A:102432 T:11832 E20726'
G[40963]='L45 A:101767 T:102425 P:40949+41030+40883 E21570'	-- TODO: Verify requires !41030 40883
G[40964]='L45 A:102425 T:101768 P:40963 E21570'
G[40965]='L45 A:101768 T:101768 P:40964 E21570'
G[40966]='K262144 L45 A:93523 T:102501 P:a40966 E21737'
G[40967]='L45 A:101768 T:101768 P:40964 E21570'
G[40968]='L45 A:102425 T:112444 P:40963 E21570'
G[40969]='L45 A:101768 T:101765 P:40965+40967+41032 E21570'
G[40970]='L45 A:101765 T:103129 P:40969 E21570'
G[40971]='L45 A:101765 T:103129 P:40969 E21570'
G[40972]='L45 A:700365 T:97140 P:40970+40971 E21570'	-- TODO: Like all T:97140 we need to make them smart based on where you have moved her during play
G[40973]='L110 E21570'
G[40974]='L45 E21570'
G[40975]='L0 T:110415 E21570'
G[40976]='FH L10 A:597296 T:100873 P:39690 E21570'
G[40978]='K262144 L45 A:-180650 T:-650 P:a40978 E21655'
G[40980]='K262144 L45 A:-630 T:102361 P:a40980 E21916'
G[40981]='L110 E22197'
G[40982]='FH L10 A:100873 T:100873 P:40976 E21691'
G[40983]='FH L10 A:100873 T:101035 P:40982 E21655'
G[40985]='K262144 L110 P:a40985'
G[40986]='L10 E21570'
G[40987]='L10 E21570'
G[40988]='L10 A:102546 T:101846 E21691'	-- Blancmange got this turning in 40102
G[40989]='L10 A:102546 T:101846 P:37727 E21953'	-- This became available when completing a quest that gave a recipe in Legion.  For Nimhree this was 37727
G[40990]='L10 A:101846 T:101846 P:40989 E21570'
G[40991]='L10 A:101846 T:101846 P:40990 E21570'
G[40992]='L0 E21570'
G[40994]='K4096 L10 A:101513 T:102594 P:40950 E21570'
G[40995]='K4096 L10 A:102594 T:102594 P:40994 E21570'
G[40996]='K4096 L10 A:102594 T:98092 P:40995 E21570'
G[40997]='L10 A:98092 T:98092 P:40996 E21570'
G[40998]='L0 E21911'
G[41000]='L45 E27980'
G[41001]='L45 A:102845 T:102845 P:41425+41426+41709 E21570'	-- TODO: Verify requires 41426 41709
G[41002]='FH L10 A:101035 T:95234 P:40983 E21691'
G[41003]='L10 A:100438 T:100438 E21570'
G[41006]='L25088 E21570'
G[41008]='L25088 E21737'
G[41009]='K4096 L10 A:106879 T:102478 P:42185 E21570'
G[41010]='L10 A:102639 T:95844 E22197'
G[41011]='K262144 L45 A:103155 T:102468 P:a41011 E22045'
G[41012]='L0 E21570'
G[41013]='K262400 L45 A:-430634,-440641,-400650,-420680 T:-634,-641,-650,-680 P:a41013 E21570'
G[41014]='K262144 L45 A:98720 T:701043 P:a41014 E21796'
G[41015]='K4096 L7234048 A:102655 T:102709 P:40938 E21570'
G[41016]='L7 E21570'
G[41017]='K4096 L10 A:102709 T:102709 P:41015 E21570'
G[41018]='L0 E21570'
G[41019]='L10 A:102655 T:102655 P:41017 E21570'
G[41024]='K262144 L45 A:-200650 T:-650 P:a41024 E21570'
G[41025]='K262144 L45 A:-747 T:101832 P:a41025 E21691'
G[41026]='K262144 L45 A:111246 T:94688 P:a41026 E21655'
G[41027]='L45 E21570'
G[41028]='L45 A:102600 T:102600 P:40010 E21570'
G[41029]='L0 E21570'
G[41030]='L45 A:100133675 T:101767 P:40883 E21570'	-- TODO: Yoshimo. verify 40883 in log OR completed	
G[41031]='L45 E21570'
G[41032]='L45 A:101768 T:101768 P:40964 E21570'
G[41033]='L10 CE A:109295 T:95237 P:42872+40375 E21570'
G[41034]='L45 A:102381 T:102845 P:40334 E21570'
G[41035]='K4096 L10 CM A:-1014 T:102700 P:43635,K100140192 E21570'	-- automatically accepted when 43635 turned in
G[41036]='K4096 L10 A:102700 T:102700 P:41035 E21570'
G[41037]='K4096 L10 CE A:95240 T:595240 P:41221 E21570'
G[41038]='L45 A:100438 T:102843 E21737'
G[41039]='L45 CO A:102843 T:102996 P:41038 E21737'
G[41040]='L45 CO A:102996 T:103049 P:41039 E21737'
G[41041]='L110 E21570'
G[41042]='L0 E21570'
G[41045]='L0 E21570'
G[41047]='K4096 L10 A:102940 T:102940 P:40153 E21570'
G[41048]='L0 E21570'
G[41049]='L0 E21570'
G[41050]='L0 E21570'
G[41051]='L0 E21570'
G[41052]='FH L10 E21570'
G[41053]='L10 CH A:102574 T:102940 E21570'
G[41054]='FH L10 A:102938 T:103022 P:38753 I:41056 E21570'
G[41055]='K262144 L110 P:a41055 E21570'
G[41056]='FA L10 A:102938 T:103022 P:38753 I:41054 E21570'
G[41057]='K262144 L45 A:-747 T:102983 P:a41057 E21863'
G[41058]='L0 E21796'
G[41059]='L45 A:103049 T:100438 P:41040 E21737'
G[41060]='L10 A:95237 T:595237 P:41033 E21570'
G[41062]='K4096 L10 CE A:595240 T:103025 P:41037 E21570'
G[41064]='K4096 L10 CE A:103025 T:103025 P:41070,41062 E21570'
G[41065]='L0 E21655'
G[41066]='K4096 L10 CE A:95238 T:95238 P:41064 E21570'
G[41067]='L10 A:95238 T:595240 P:41066+40374 E21570'
G[41069]='L10 A:595240 T:595240 P:41067 E21570'	-- TODO: When this was turned in, two white quests appeared ... basically waiting for level...
G[41070]='L10 CE A:595237 T:103025 P:41060 E21570'
G[41071]='L0 E21570'
G[41072]='L0 E21570'
G[41073]='L0 E21570'
G[41074]='L0 E21570'
G[41075]='L0 E21570'
G[41076]='K262144 L45 A:99468 T:-650 P:a41076 E21655'
G[41077]='K262144 L45 A:-650 T:701476 P:a41077 E21737'
G[41078]='K262144 L45 A:-650 T:94098 P:a41078 E21953'
G[41079]='L0 E21570'
G[41080]='L0 E21570'
G[41081]='L0 E21570'
G[41082]='L0 E21570'
G[41083]='L0 E21570'
G[41084]='L0 E21570'
G[41085]='K4096 L10 A:102700 T:102700 P:41036 E21570'
G[41086]='L45 CO A:102820 T:100438 E21691'
G[41087]='L45 CO A:100438 T:109823 P:32442 E21737'	--TODO: Yoshimo: find the ids for his other quests, likely needed too
G[41089]='K262144 L45 A:-140650 T:-650 P:a41089 E21655'
G[41090]='K262144 L45 N53 A:-720634,-670641,-680650 T:700840 P:a41090'
G[41091]='K262144 L110 A:-660634,-640641,-630650 T:-634,-641,-650 P:a41091 E21655'
G[41092]='L0 E21570'
G[41093]='K262144 L110 A:96072 T:96072 P:a41093 E21691'
G[41094]='L10 A:97925 T:-641 E21570'
G[41095]='K262144 L45 A:-230650 T:-650 P:a41095 E21691'
G[41096]='L10 A:95238 T:595237 P:41066+40375 E21570'
G[41097]='L45 A:99890 T:1246884 P:40328+40929 E21570'
G[41098]='L45 A:99890 T:1246885 P:40328+40929 E21570'
G[41099]='L10 A:595237 T:595237 P:41096 E21570'
G[41100]='L0 E21570'
G[41101]='L0 E21911'
G[41102]='L0 E21570'
G[41103]='L0 E21570'
G[41105]='K4096 L10 A:96469 T:96469 P:40579+40582 E21570'
G[41106]='K4096 L10 A:101064 T:101064 P:40643 E21570'
G[41107]='L45 A:103131 T:103131 P:0 E21570'	-- Yoshimo: needs P: for the disguise so to speak
G[41108]='L45 A:111611 T:-680 P:41109 E21570'	-- verify 41109
G[41109]='L45 A:-680 T:111611 P:40968 E21570'
G[41110]='L45 T:112444 E21737'
G[41111]='L45 T:112444 E21570'
G[41112]='K4096 L10 A:102700 T:103092 P:41125 E21570'
G[41113]='K4096 L10 CM A:103092 T:102700 P:41112 E21570'
G[41114]='K4096 L10 A:-625 T:102700 P:11997 E21570'
G[41115]='L10 T:102820 E21570'
G[41116]='L0 E21570'
G[41117]='L0 T:101784 E21570'
G[41119]='L10 A:500260 T:103761 P:41121 E21570'
G[41120]='L10 CE A:108571 T:103156 P:44379 E21570'
G[41121]='L10 CE A:103156 T:500260 P:41120 E21570'
G[41122]='K262144 L45 A:-680 T:103090 P:a41122 E21655'
G[41123]='L45 A:103175 T:103175 P:0 E21570'	--TODO: Yoshimo: Masq required?
G[41124]='K4096 L10 CM A:5102700 T:5103092 P:41113 E21570'
G[41125]='K4096 L7234048 A:102700 T:102700 P:41114 E21570'
G[41126]='L0 E21570'
G[41127]='K262144 L45 A:-170650 T:-1024 P:a41127 E22197'
G[41128]='L0 E21570'
G[41129]='L0 T:95329 E21570'	-- gotten if you give the wrong answer trying to gain access to the Violet Hold with Altruis
G[41134]='L0 E21570'
G[41135]='L0 T:100864 E21570'
G[41136]='L0 T:103214 E21570'
G[41137]='L45 T:100864 E21570'
G[41138]='L45 A:700330 T:103155 P:41028 E21570'
G[41139]='L45 A:103204 T:103204 E21570'
G[41140]='L45 A:103204 T:102365 P:41139 E21570'
G[41141]='L10 A:5103092 T:5103092 P:41124 E21570'
G[41142]='L0 E21570'
G[41143]='L45 A:108389 T:108390 P:42728 E21570'
G[41144]='K262144 L45 A:-270650 T:-650 P:a41144 E21691'
G[41145]='K262144 L45 A:108504 T:700506 P:a41145 E21655'
G[41146]='L45 A:103175 T:104394 P:41465+41466 E21570'
G[41147]='L0 E21846'
G[41148]='L45 A:107598 T:107598 P:40746 E21570'
G[41149]='L45 A:109022 T:-680 P:40012 E21570'
G[41153]='L0 E21570'
G[41154]='L0 E25901'
G[41155]='L10 E21570'
G[41156]='L10 E21570'
G[41157]='L45 A:103484 T:103484 P:40857 E21570'
G[41158]='L45 A:93538 T:103484 P:PX001 E21570 D142'
G[41159]='L45 A:103484 T:103484 P:41158 E21570'
G[41160]='L20 A:115546 T:115546 P:PB001 E21570'
G[41161]='L45 A:93538 T:700706 P:PX001 E21737 D142'
G[41162]='L45 A:700706 T:700706 P:41161 E21737'
G[41163]='L45 A:700706 T:700706 P:41162 E21737'
G[41164]='L45 A:93538 T:700803 P:PX001 E22197 D142'
G[41165]='L45 A:700803 T:700803 P:41164 E22197'
G[41166]='L45 A:700803 T:700805 P:41165 E22197'
G[41167]='L45 A:93538 T:700860 P:PX001 E22371 D142'
G[41168]='L45 A:700860 T:700860 P:41167 E22371'
G[41169]='K64 L45 A:700860 T:700860 P:41168 E22371'
G[41170]='L45 A:103484 P:41802'
G[41171]='L45 A:93538 T:103482 P:PX001 D142'
G[41172]='L45 A:103482 T:103482 P:41171'
G[41173]='L45 A:103482 T:103482 P:PX001 E22594'
G[41174]='L45 A:93538 T:700673 P:PX001 E21874 D142'
G[41175]='L45 A:700673 P:41174'
G[41176]='L45 E27980'
G[41177]='L45 A:93538 T:700696 P:PX001 E21691 D142'
G[41178]='L45 A:700696 T:700696 P:41177 E21691'
G[41179]='L45 A:700696 T:1247704 P:41178 E21737'
G[41180]='L45 A:93538 T:700673 P:PX001 E21874 D142'
G[41181]='L45 A:700673 T:700673 P:41180 E21874'
G[41182]='L45 A:700673 T:700757 P:41181 E21874'
G[41183]='L45 A:93538 T:103482 P:PX001 E22271 D142'
G[41184]='L45 A:103482 T:103482 P:41183 E22271'
G[41185]='L110 A:103482 T:103482 P:41184 E22271'
G[41186]='L45 A:93538 T:103485 P:PX001 E22624 D142'
G[41187]='L45 A:103485 T:103485 P:41186 E22624'
G[41188]='L45 A:103485 T:103485 P:41187 E22624'
G[41189]='L45 A:93538 T:103485 P:PX001 E22197 D142'
G[41190]='L45 A:103485 T:103485 P:41189 E22045'
G[41191]='L110 A:103485 T:103485'
G[41192]='L45 A:93538 T:103485 P:PX001 D142'
G[41193]='L45 A:103485 T:700881 P:41192'
G[41194]='L0 E21570'
G[41195]='L0 E21570'
G[41196]='K262144 L110 A:-350650 T:701986 P:a41196+PM001'
G[41197]='L45 A:700328 T:700328 P:41453 E21570'
G[41198]='K262144 L45 A:-1530650 T:-650 P:a41198+PM001'
G[41199]='K262144 L110 A:-1510650 T:-650 P:a41199+PM001 E21916'
G[41200]='K262144 L45 A:93538 T:-634,-650 P:a41200+PM001'
G[41201]='K262144 L110 A:-1440650 T:-650 P:a41201+PM001'
G[41202]='K262144 L45 A:-1070634,-1180650,-1210680 T:-634,-650,-680 P:a41202+PM001 E22566'
G[41203]='K262144 L110 A:-1140634,-1120641,-1250650 T:-634,-641,-650 P:a41203+PM001 E21655'
G[41204]='K262144 L45 A:-990634,-1070650,-1130680 T:-634,-650,-680 P:a41204+PM001 E22566'
G[41205]='K262144 L110 A:-1400650 T:-650 P:a41205+PM001 E21796'
G[41206]='K262144 L110 A:-1460650 T:-650 P:a41206+PM001 E22566'
G[41207]='K262144 L45 A:-340634,-390641,-300650 T:106902 P:a41207 E22271'
G[41208]='K262144 L110 A:-650 T:-650 P:a41208+PM001 E22231'
G[41209]='K262144 L45 A:-1130634,-1110641,-1240650 T:-634,-641,-650 P:a41209+PM001 E22371'
G[41210]='K262144 L45 A:-630 T:-634,-650 P:a41210+PM001 E21570'
G[41211]='L110 T:101476 E21953'
G[41212]='L0 T:99791'
G[41213]='L0 E21570'
G[41214]='L45 A:103437 T:103437 P:41222 E21655'
G[41215]='L45 A:106897 T:106897 P:40617 E21570'
G[41216]='L45 A:110987 T:111019 P:41215+41230 E21570'
G[41217]='FA L1 CH A:42396 T:103614 P:27674 E21570'
G[41218]='FA L1 RN A:103614 T:42317 P:41217 E21570'
G[41219]='K262144 L110 A:-1200634,-1300650 T:-634,-650 P:a41219+PH001 E21737'
G[41220]='L10 A:86563 T:93337 P:39718 E21570'
G[41221]='K4096 L10 CE A:109295 T:95240 P:42872+40374 E21570'
G[41222]='L45 A:103437 T:103437 P:41140 E21655'
G[41223]='K262144 L45 A:-340634,-390641,-300650 T:-634,-641,-650 P:a41223+PH001 E21737'
G[41224]='K262144 L45 A:-340634,-390641,-300650 T:-634,-641,-650 P:a41224 E21655'
G[41225]='K262144 L110 A:-1320650,-1070650,-1310650,-1300650 T:701608 P:a41225+PH001 E22566'
G[41226]='L0 T:92782 E21655'
G[41227]='FH K262400 L45 A:-680 T:102868 P:a41227 E21570'
G[41228]='K262144 L45 A:-1190634,-1090641,-1300650 T:-634,-641,-650 P:a41228+PH001'
G[41229]='L0 E21570'
G[41230]='L45 A:100775 T:100775 P:40617 E21570'
G[41231]='L45 A:111019 T:111019 P:41216 E21570'
G[41232]='K262144 L45 A:-1390650 T:-650 P:a41232+PS001 E21911'
G[41233]='K262144 L45 A:93541 T:700413 P:a41233+PS001 E22197'
G[41234]='K262144 L45 A:99788 T:106902 P:a41234+PS001 E21737'
G[41235]='K262144 L45 A:-350650 T:-650 P:a41235+PS001 E22594'
G[41237]='K262144 L45 A:-390641,-340634,-300650 T:-634,-641,-650 P:a41237 E21655'
G[41238]='K262144 L45 A:-1080650 T:-650 P:a41238+PS001 E21691'
G[41239]='K262144 L110 A:-1340650 T:-650 P:a41239+PS001'
G[41240]='K262144 L45 A:-650 T:106902 P:a41240+PF001 E21154'
G[41242]='K262144 L110 A:103681 T:103681 P:a41242+PC001'
G[41243]='K262144 L45 A:-960634,-920641,-1010650 T:-634,-641,-650 P:a41243+PF001 E21911'
G[41244]='K262144 L110 A:100823 T:-650 P:a41244+PF001 E21737'
G[41245]='L0 E21953'
G[41246]='L0 T:97266 E21570'
G[41248]='L0 E21953'
G[41250]='L0 E21570'
G[41251]='L0 E21570'
G[41252]='K262144 L45 A:-870650 T:-650 P:a41252+PF001 E21570'
G[41253]='K262144 L110 A:-570634,-560641,-560650 T:700752 P:a41253+PF001 E21737'
G[41255]='K4096 L10 A:101195 T:97923 E21570'	-- TODO: Figure out P:.  This was available when I came back to turn in 41918 (guardian artifact), so one assumes when requirements for the first artifact weapon are satisfied (no matter which weapon)
G[41256]='L45 A:103131 T:103131 P:0 E21570'	--TODO: Yoshimo: Masq required?
G[41257]='FA K262400 L45 A:93541 T:104290 P:a41257 E21570'
G[41258]='L45 A:103131 T:103131 P:41107+41256 E21570'	-- TODO: verify requires 41107
G[41259]='K262144 L45 A:98969 T:701933 P:a41259+PC001 E21796'
G[41260]='K262144 L45 A:-1040641,-1140650,-1190680,-960641,-1060650,-1120680,-1070650,-1130680,-1090641,-1310650,-1360680,-1100641,-1300650,-1370680 T:-641,-650,-680 P:a41260+PC001 E22045'
G[41261]='K262144 L45 A:93538 T:702068 P:a41261+PC001 E21796'
G[41262]='K262144 L45 A:700807 T:700807 P:a41262+PC001'
G[41263]='L0 T:700643 E21570'
G[41264]='K262144 L45 A:-160630 T:-630,-680 P:a41264+PF001 E21655'
G[41265]='K262144 L110 A:-350680,-460630 T:-630,-680 P:a41265+PF001'
G[41266]='K262144 L45 A:-810630 T:-630 P:a41266+PF001'
G[41267]='K262144 L45 A:-530630 T:107376 P:a41267+PF001 E21846'
G[41268]='K262144 L45 A:91131 T:104258 P:a41268+PF001 E22624'
G[41269]='K262144 L45 A:-930641,-1020650,-1080680 T:-641,-650,-680 P:a41269+PF001 E21570'
G[41270]='K262144 L45 A:115499 T:-641,-650,-680 P:a41270+PF001'
G[41271]='K262144 L45 A:-510641 T:-641 P:a41271+PF001 E21691'
G[41272]='K262144 L45 A:-630 T:106901 P:a41272+PF001'
G[41273]='K262144 L45 A:-900641 T:109752 P:a41273+PF001 E22594'
G[41274]='K262144 L45 A:-800634,-790650,-900680 T:-634,-650,-680 P:a41274+PF001 E22566'
G[41275]='K262144 L45 A:119002 T:110645 P:a41275+PF001'
G[41276]='K262144 L45 A:-610634 T:-634 P:a41276+PF001'
G[41277]='K262144 L45 A:93538 T:106904 P:a41277+PF001 E22197'
G[41278]='K262144 L45 A:-990634,-1070650 T:-634,-650 P:a41278+PF001'
G[41279]='K262144 L45 A:-720630,-640634,-630641,-680680 T:-630,-634,-641,-680 P:a41279+PF001 E21570'
G[41280]='K262144 L45 A:-540634,-500641,-560680 T:-680 P:a41280+PF001 E22371'
G[41281]='L0 E21874'
G[41282]='K262144 L45 A:97140 T:97140 P:a41282+PF001'
G[41283]='K262144 L45 A:-1080641,-1290650,-1350680 T:701332 P:a41283+PF001'
G[41284]='L0 E21570'
G[41285]='L0 E21570'
G[41286]='K262144 L45 A:-1260630,-1380680,-1180630,-1360680 T:89802 P:a41286+PH001'
G[41287]='K262144 L110 A:111246 T:107376 P:a41287+PH001 E21655'
G[41288]='K262144 L45 A:-530630 T:701352 P:a41288 E21737'
G[41289]='K262144 L45 A:-1380630 T:-630 P:a41289+PH001 E22231'
G[41290]='K262144 L45 A:50140 T:701410 P:a41290+PH001 E22624'
G[41291]='K262144 L110 A:-970641,-1090641 T:-641 P:a41291+PH001 E21737'
G[41292]='K262144 L45 A:92332 T:106901 P:a41292+PH001'
G[41293]='K262144 L45 A:-720641,-740650,-860680 T:701171 P:a41293 E21916'
G[41294]='K262144 L45 A:-1090641,-1300650,-1100641,-1310650 T:-641,-650 P:a41294+PH001'
G[41295]='K262144 L45 A:-1000641 T:701359 P:a41295+PH001 E21796'
G[41296]='K262144 L45 A:-1190634,-1300650 T:109157 P:a41296+PH001'
G[41297]='K262144 L110 A:-1340634 T:-634 P:a41297+PH001 E22371'
G[41298]='K262144 L45 A:106904 T:106904 P:a41298 E21796'
G[41299]='K262144 L45 A:-1310634 T:-634 P:a41299+PH001'
G[41300]='K262144 L45 A:-1190634,-1300650 T:-634,-650 P:a41300+PH001'
G[41301]='K262144 L110 A:-1770680 T:103848 P:a41301+PH001 E21691'
G[41302]='K262144 L110 A:-680 T:97140 P:a41302+PH001 E21796'
G[41303]='K262144 L45 A:97140 T:97140 P:a41303 E21874'
G[41304]='K262144 L45 A:-980634,-1120680,-1190634,-1360680 T:-634,-680 P:a41304+PH001'
G[41305]='K262144 L45 A:-1270630,-1390680 T:104344 P:a41305+PH001'
G[41306]='L0 T:703997 E21570'
G[41307]='L45 A:103175 T:103175 P:41123 E21570'
G[41308]='K262144 L45 A:-650 T:-650 P:a41308 E21570'
G[41309]='L45 A:103437 T:104161 P:41214 E21655'
G[41310]='L0 E21570'
G[41311]='K262144 L45 N53 A:-530630 T:107376 P:a41311+PM001 E21911'
G[41312]='K262144 L45 A:-720641 T:106901 P:a41312+PM001 E21691'
G[41313]='K262144 L45 A:-1850863 T:-634 P:a41313+PM001 E22566'
G[41314]='K262144 L45 A:700801,-1050630,-1010634,-980641,-1150680 T:115736 P:a41314+PM001'
G[41315]='K262144 L45 A:-530630 T:107376 P:a41315 E21737'
G[41316]='K262144 L110 A:-720641,-740650,-860680 T:-641,-650,-680 P:a41316 E21655'
G[41317]='K262144 L45 A:106904 T:106904 P:a41317 E21796'
G[41318]='K262144 L45 A:93538 T:-630,-634,-641,-680 P:a41318 E21737'
G[41319]='L0 T:99792 E21570'
G[41320]='L45 A:103175 T:103175 P:41123 E21570'
G[41321]='L0 P:41123 E21655'
G[41322]='K262144 L45 A:-1220630 T:-630 P:a41322+PS001 E21655'
G[41323]='K262144 L110 A:-1310630 T:-630 P:a41323+PS001'
G[41324]='K262144 L110 A:-1100630 T:-630 P:a41324+PS001 E21737'
G[41326]='K262144 L45 A:98964 T:107376 P:a41326+PS001 E22624'
G[41327]='K262144 L45 A:-530630 T:107376 P:a41327 E21796'
G[41328]='L0 E21570'
G[41329]='L0 E21570'
G[41330]='L0 E21570'
G[41332]='K4096 L10 A:97923 T:104241 P:40651 E21570'
G[41333]='K262144 L45 A:-1210641 T:111474 P:a41333+PS001 E21911'
G[41334]='K262144 L45 A:-1270641 T:-641 P:a41334+PS001 E21655'
G[41335]='K4096 L10 A:96527 T:96527 P:39746 E21570'
G[41336]='K262144 L45 A:-1300634 T:700435 P:a41336+PS001 E21916'
G[41337]='K262144 L45 A:92742 T:-641 P:a41337+PS001 E21846'
G[41338]='K262144 L45 A:-680 T:106901 P:a41338+PS001'
G[41339]='K262144 L45 A:-720641,-740650,-860680 T:-641,-650,-680 P:a41339 E21737'
G[41340]='K262144 L45 A:-1220634 T:-634 P:a41340+PS001 E21846'
G[41342]='K262144 L45 A:-1170634 T:-634 P:a41342+PS001 E22197'
G[41343]='K262144 L45 A:-1260634 T:-634 P:a41343+PS001'
G[41344]='K262144 L110 A:107667 T:106904 P:a41344+PS001+FH E21570'
G[41345]='K262144 L45 A:701125 T:-634,-650,-680 P:a41345 E21874'
G[41346]='K262144 L110 A:-1160680 T:-680 P:a41346+PS001 E22231'
G[41347]='K262144 L110 A:-1460680 T:-680 P:a41347+PS001 E22624'
G[41349]='K262144 L45 A:-360680 T:-680 P:a41349+PS001 E21691'
G[41350]='K262144 L110 A:-1450680 T:-680 P:a41350+PS001 E21863'
G[41351]='K262144 L45 A:114908 T:-630,-634,-641,-680 P:a41351 E21655'
G[41352]='K262144 L45 A:-1820680 T:-680 P:a41352+PM001'
G[41353]='K262144 L110 A:-1080634,-1060641,-1190650,-1220680 T:-634,-641,-650,-680 P:a41353+PM001'
G[41354]='K262144 L110 A:-1190630,-1280680 T:-630,-680 P:a41354+PM001 E22594'
G[41357]='K262144 L110 A:-1100634,-1270680 T:-634,-680 P:a41357+PM001 E21737'
G[41359]='L0 E21570'
G[41360]='L0 E21570'
G[41367]='L10 N45 A:701851 T:52562'
G[41368]='L10 T:105339'
G[41394]='L10 N45 A:52562 T:52562'
G[41395]='L10 N45 A:52562 T:104110'
G[41397]='L10 N45 A:103976 T:701851'
G[41400]='L0 E21570'
G[41405]='L0 E21570'
G[41406]='L0 E21570'
G[41408]='L0 E21570'
G[41409]='L45 A:104586 T:102845 P:41410 E21570'
G[41410]='L45 A:104586 T:104586 P:40927 E21570'
G[41411]='L10 T:100986'
G[41412]='L0 E21570'	-- this seems to be marked complete when you have discovered the Retreat (basically entered it), which leads me to think it is part of 41413 needed P:41412
G[41413]='SP L10 A:98784 T:98784 E21570'	-- TODO:  it seems you have to enter the building for this to become available.  not sure if it requires you to have gotten your first artifact.
G[41414]='K262144 L45 A:-84 T:104243 P:a41414 E21655'
G[41415]='K4096 L10 A:102478 T:102478 P:40384 E21570'
G[41416]='K262144 L45 A:98648 T:104311 P:a41416 E21655'
G[41420]='FH K262400 L45 A:98105 T:103653 P:a41420 E21570'
G[41421]='FA K262400 L45 A:98648 T:700400 P:a41421 E21570'
G[41422]='K4096 L10 A:113525 T:113525 P:40649 E21570'
G[41423]='L0 E21570'
G[41424]='L0 E21570'
G[41425]='L45 A:104630 T:102845 P:40927 E21570'
G[41426]='L45 A:102390 T:102410 P:40927 E21570'
G[41427]='K262144 L45 A:-200634 T:-634 P:a41427 E21655'
G[41428]='K262144 L45 A:-747 T:95290 P:a41428 E21570'
G[41432]='K262144 L110 P:a41432+PM001'
G[41433]='K262144 L110 A:-970641,-1090650 T:-641,-650 P:a41433+PM001 E21916'
G[41434]='K262144 L45 A:-1080630 T:-630 P:a41434+PM001 E22371'
G[41435]='K262144 L45 A:-1130630,-1230680 T:-630,-680 P:a41435+PM001 E21796'
G[41436]='K4096 L10 A:104349 T:104349 P:41449 E21570'
G[41437]='K262144 L45 A:-1030630 T:-630 P:a41437+PM001 E21953'
G[41438]='K262144 L45 N53 A:-1110630 T:89846 P:a41438+PM001'
G[41439]='K262144 L45 T:701977 P:a41439+PM001'
G[41440]='K262144 L110 P:a41440+PM001'
G[41441]='K262144 L45 A:-1090641,-1220650 T:-641,-650 P:a41441+PM001'
G[41442]='K262144 L110 A:-84 T:702100 P:a41442+PM001 E22624'
G[41443]='K262144 L110 A:-1150634,-1310680 T:109967,-634,-680 P:a41443+PM001 E22371'
G[41444]='K262144 L45 A:-1040634,-1150650 T:-634,-650 P:a41444+PM001 E21570'
G[41445]='K262144 L45 A:-1470634 T:-634 P:a41445+PM001'
G[41446]='K262144 L45 A:-1020634,-1010641,-1110650,-1180680 T:-634,-641,-650,-680 P:a41446+PM001'
G[41447]='K262144 L53 A:-960641,-1140680 T:702103 P:a41447+PM001'
G[41448]='K262144 L45 A:-1250630 T:-630 P:a41448+PM001 E21796'
G[41449]='K4096 L10 A:113525 T:104349 P:41422 E21570'
G[41451]='K262144 L45 A:-290634 T:-634 P:a41451 E21570'
G[41452]='L45 A:103568 T:103568 P:42229 E21570'	--TODO: Yoshimo: verify 42229
G[41453]='L45 A:103570 T:700328 P:41452 E21570'
G[41454]='K262144 L45 A:1977 T:110102 P:a41454+PM001 E21737'
G[41455]='K262144 L110 A:-1410630 T:-630 P:a41455+PM001'
G[41457]='K262144 L45 A:-1150641 T:-641 P:a41457+PM001 E21796'
G[41458]='K262144 L45 A:93538 T:-641 P:a41458+PM001'
G[41459]='K262144 L110 A:-1050634,-1160650 T:-634,-650 P:a41459+PM001'
G[41460]='K262144 L45 A:111246,-1030634,-1120650 T:110466 P:a41460+PM001 E21655'
G[41461]='K262144 L110 A:-1120630,-1200680 T:-630,-680 P:a41461+PM001 E21655'
G[41462]='L45 A:104220 T:700328 E21570'	-- TODO: Starts from item dropped from 104220 near 1033:21.75,29.43
G[41463]='L45 A:103568 T:106696 P:41452 E21570'
G[41464]='L45 A:106696 T:106696 P:41463 E21655'
G[41465]='L45 A:103175 T:103175 P:41307+41320 E21570'
G[41466]='L45 A:103175 T:103175 P:41307+41320 E21570'
G[41467]='L45 A:106696 T:103568 P:41464 E21570'
G[41468]='K4096 L10 A:101195 T:101259 P:40702 E21570'
G[41469]='L45 A:103571 T:700333 P:41479+41480+41485 E21655'	-- TODO: Verify requires 41480
G[41473]='L45 A:103568 T:103569 P:41197+41467 E21655'	-- TODO: Yoshimo: Verify 41197 (help kittens) 41467
G[41474]='L45 A:103569 T:103569 P:41473 E21655'
G[41475]='L45 A:103569 T:103569 P:41473 E21655'
G[41478]='L45 A:103569 T:103571 P:41474+41475 E21655'
G[41479]='L45 A:103571 T:103571 P:41478 E21655'
G[41480]='L45 A:103571 T:103571 P:41478 E21655'
G[41481]='K262144 L45 A:700340 T:-630 P:a41481+PM001 E21796'
G[41482]='K262144 L45 A:-1200630,-1300680 T:-630,-680 P:a41482+PM001 E21655'
G[41483]='K