local ADDON_NAME, ns = ...
local L = ns.NewLocale("enUS")
if not L then return end

-------------------------------------------------------------------------------
---------------------------------- COVENANTS ----------------------------------
-------------------------------------------------------------------------------

L["covenant_required"] = "Requires a member of the %s covenant."
L["anima_channeled"] = "anima channeled to %s."

-------------------------------------------------------------------------------
--------------------------------- ARDENWEALD ----------------------------------
-------------------------------------------------------------------------------

L["deifir_note"] = "Ride the rare around in a circle and use {spell:319566} and {spell:319575} to slow and stun him."
L["faeflayer_note"] = "In a small cave hidden behind a waterfall."
L["gormbore_note"] = "Kill {npc:165420s} over the rumbling ground to spawn the rare."
L["gormtamer_tizo_note"] = "Kill Bristlecone Sprites in the Mistveil Tangle until {npc:164110} spawns."
L["humongozz_note"] = "Plant an {item:175247} in the Damp Loam to spawn a {npc:164122}. The mushroom drops from numerous mobs in the zone."
L["lehgo_note"] = "Destroy Quivering Gorm Eggs and kill {npc:171827} until he spawns. In a cave (entrance to the south-east in the Dusty Burrows)."
L["macabre_note"] = [[
Spawns in multiple locations. To summon, stand in the Mysterious Mushroom Ring with 2 other players and dance with each other.

• Player 1 dances with Player 2
• Player 2 dances with Player 3
• Player 3 dances with Player 1
]]
L["mymaen_note"] = "Kill Rotbriar sprites in the area until he emotes and spawns."
L["rainbowhorn_note"] = [[
Find and click the |cffffff00Great Horn of the Runestag|r to summon the rare. The horn can spawn in multiple places across Ardenweald.

He will always spawn north of Tirna Vaal, so set your {item:6948} there and watch for the zone emote.

|cffff5400T|r|cffffaa00A|r|cffffff00S|r|cffaaff00T|r|cff54ff00E|r |cff00ff55T|r|cff00ffa9H|r|cff00ffffE|r |cff0055ffR|r|cff0000ffA|r|cff5400ffI|r|cffaa00ffN|r|cffff00ffB|r|cffff00aaO|r|cffff0054W|r|cffff0000!|r
]]
L["rootwrithe_note"] = "Poke the {npc:167928s} until the rare appears."
L["rotbriar_note"] = "Talk to {npc:171684} nearby to summon the rare after some dialog."
L["slumbering_note"] = "Running into the fog will stun and port you out. Use a flare or a pet with AOE to knock him out of the fog."
L["skuld_vit_note"] = "In a cave blocked by a barrier. A Night Fae must use {spell:310143} to enter the cave. Once he is pulled, the barrier will disappear."
L["valfir_note"] = "Click the Sparkling Animaseed midway down the path and use {spell:338045} to remove his {spell:338038} buff."
L["wrigglemortis_note"] = "Pull the {npc:164179} to spawn the rare."

L["night_mare_note"] = [[
Travel to Tirna Scithe and follow the root path on the northwest cliff to a broken cart. There you can loot a {item:181243} on the ground.

Take this item to {npc:165704} at Glitterfall Basin. She will give you a {item:181242} in exchange for 10 {item:173204}. |cFFFF8C00If she is not there, you must complete the |cFFFFFD00Trouble at the Gormling Corral|r and |cFFFFFD00Tricky Spriggans|r quest lines.|r

Next, talk to {npc:160262} in the Heart of the Forest to exchange the {item:181242} for a {item:178675}. Talk to the guards to have her come outside if you are not a Night Fae. Use this item to get {spell:327083} buff, allowing you to see the {npc:168135}.
]]

L["star_lake"] = "Star Lake Amphitheater"
L["star_lake_note"] = [[
Talk to {npc:171743}, the Stage Director, to start one of the special encounters. The encounter changes each day.

Participate in all seven encounters to unlock {item:180748} from {npc:163714}.
]]

L["cache_of_the_moon"] = "Collect {npc:171360}'s five missing tools in the Garden of Night and combine them to create {item:180753}. Return her toolkit and she will cast {spell:334353} on you, allowing you to see the cache."
L["cache_of_the_night"] = "Collect {item:180656}, {item:180654} and {item:180655} from across the zone and combine them to create {item:180652}."
L["darkreach_supplies"] = "Jump on the {npc:169995} and glide southwest into the hollowed spire directly above the Cache of the Night treasure."
L["desiccated_moth"] = "Jump on the {npc:169997} northwest of the tree to float onto a branch. Burn {item:180784} in the Incense Burner to collect the treasure."
L["dreamsong_heart"] = "Use the {npc:169997} beneath the tree to get launched into the tree."
L["elusive_faerie_cache"] = "Pick up the {spell:333923} in the northeast corner of Eventide Grove and use it to loot the chest."
L["enchanted_dreamcatcher"] = "Hanging from the top of the roots. Easiest to jump up on the west side."
L["faerie_trove"] = "Located underneath the platform."
L["harmonic_chest"] = "Requires two people. One person plays the harp and the other plays the drum to unlock the chest."
L["hearty_dragon_plume"] = "Click {spell:333554} at the top of the nearby waterfalls and use it to float down onto the branch."
L["old_ardeite_note"] = "Kill {npc:160747} and {npc:160748} in Shimmerbough to the southeast for {item:174042}. Use this item to fly up near the rare and tag it."
L["swollen_anima_seed"] = "A large seed sitting inside a tree trunk."

L["playful_vulpin_note"] = [[
Find and use the correct emote on the {npc:171206} five times to obtain the pet.

• begins to dig curiously = |cFFFF8C00/curious|r
• wanders around unable to sit still = |cFFFF8C00/sit|r
• sings all alone = |cFFFF8C00/sing|r
• dances with joy = |cFFFF8C00/dance|r
• sits down lonely and sad = |cFFFF8C00/pet|r
]]

L["tame_gladerunner"] = "Tame Gladerunner"
L["tame_gladerunner_note"] = [[
Read the "Tale of the Tangle" and then follow the blue lamps through the path until you reach {npc:171767}. Kill him and then loot the {npc:171699}.

If you take a wrong path and {npc:171699} disappears when you reach the end, go back to the start and read "Tale of the Tangle" once more before trying again. If {npc:171767} is not there, you will have to wait for him to respawn.
]]

L["faryl_note"] = "Let Ardenweald's defense be lead by the creatures in the sky."
L["glitterdust_note"] = "The creatures of Ardenweald may look docile, but they will defend their territory with the strength and courage of the mightiest champions ever known. Do you have what it takes?"

L["lost_book_note"] = "Return this lost book to {npc:165867} in the Grove of Memory."
L["options_icons_faerie_tales"] = "{achievement:14788}"
L["options_icons_faerie_tales_desc"] = "Display lost book locations for the {achievement:14788} achievement."

-------------------------------------------------------------------------------
----------------------------------- BASTION -----------------------------------
-------------------------------------------------------------------------------

L["aegeon_note"] = "Kill enemies in the surrounding area until Aegeon spawns as a reinforcement."
L["ascended_council_note"] = "With four other players, click the five temple vespers at the same time to summon the {npc:170899} at Aspirant's Crucible."
L["aspirant_eolis_note"] = "Loot a nearby {item:180613} and read it with the NPC targeted to activate him."
L["baedos_note"] = "Carry casks of Fermenting Purian Fruit from the surrounding area to {npc:161536} until he activates."
L["basilofos_note"] = "Move around the rock until a purple fixate marker appears over your head. Stand still and wait for four emotes to appear, then he will spawn."
L["beasts_of_bastion"] = "Beasts of Bastion"
L["beasts_of_bastion_note"] = "Talk to {npc:161441} to summon one of the four beasts."
L["bookkeeper_mnemis_note"] = "Has a chance to spawn in place of the {npc:166867} units in the area."
L["cloudfeather_patriarch_note"] = "Kill {npc:158110s} in the area until the guardian engages you."
L["collector_astor_note"] = "Read all six chapters of Mercia's Legacy scattered around the room, then talk to {npc:157979} to receive {spell:333779}. Find the hidden {item:180569} in the surrounding area and return it to spawn the rare."
L["corrupted_clawguard_note"] = "Loot a {item:180651} in the room or in Forgefire Outpost up the hill and use it to repair the {npc:171300}."
L["dark_watcher_note"] = "Can only be seen while dead. Talk to her and she will cast {spell:332830} on you before attacking."
L["demi_hoarder_note"] = "Starts with 99 stacks of {spell:333874}, reducing damage taken. Stacks are slowly removed with damage. The rare will follow a path and despawn if it reaches the end."
L["dionae_note"] = "When she becomes immune, click the four {npc:163747} to break her shield."
L["herculon_note"] = [[
Collect {item:172451} and use them to give {npc:158659} stacks of {spell:343531}. At 10 stacks, he will activate.

Motes can be collected from nearby Depleted Anima Canisters located in the room or just outside.

|cFFFF8C00Cannot be defeated during the {wq:Assault on the Vestibule} world quest.|r
]]
L["reekmonger_note"] = "Kill enemies in the Temple of Courage until {npc:171327} emotes and lands."
L["repair_note"] = "With two other players, click the Ancient Incense to summon."
L["sotiros_orstus_note"] = "Click the Black Bell to summon the rares."
L["sundancer_note"] = "Click the statue to obtain the {spell:332309} buff, then use a {item:180445} to glide to the rare and mount it."
L["swelling_tear_note"] = "Click the {npc:171012} to summon one of three rares. Tears can appear in multiple locations in the zone."
L["unstable_memory_note"] = "Can be spawned when {npc:171018s} are present. Drag one {npc:171018} into others to give it 10 stacks of {spell:333558}, turning it into the rare."
L["wingflayer_note"] = "To summon, click the Horn of Courage on the nearby table (southeast, up the stairs)."

L["broken_flute"] = "Kill nearby {npc:170009} until they drop the {item:180536}, then use the tools to repair it."
L["cloudwalkers_coffer"] = "Cloudwalker's Coffer"
L["cloudwalkers_coffer_note"] = "Use the large purple flowers to bounce up to the platform."
L["experimental_construct_part"] = "Loot a nearby {item:180534} and use it to repair the part. The anima has multiple spawn locations."
L["larion_harness"] = "Located inside the Hall of Beasts."
L["memorial_offering"] = "Find {npc:171526} at one of his locations across Bastion and purchase a {item:180788}. Place it in the drink tray near the chest to obtain the {item:180797}."
L["scroll_of_aeons"] = "Loot 2 {item:173973} in the center area and place them on the nearby tribute platters to reveal the treasure."
L["vesper_of_silver_wind"] = "Vesper of the Silver Wind"
L["vesper_of_silver_wind_note"] = "Complete the {achievement:14339} achievement and then talk to {npc:171732} near the entrance to Spires of Ascension to forge a {item:180858}."

L["gift_of_agthia"] = "Click the lit torch near the broken bridge to the northwest and carry {spell:333320} from torch to torch until you reach the chest. Lighting the final torch will grant you {spell:333063}."
L["gift_of_chyrus"] = "Kneel in front of the chest to be granted {spell:333045}."
L["gift_of_devos"] = [[
Southwest of the chest is a torch where you can pick up the {spell:333912}. Mounting, entering combat or taking damage will drop the flame. You must make your way back to the chest and place the flame in the Brazier of Devotion to be granted {spell:333070}.

Before picking up the flame, clear all mobs in front of the chest. While running the flame, click any {npc:156571} along the way for a {spell:335012} debuff that increases movement speed.
]]
L["gift_of_thenios"] = [[
Behind the chest is a flight pad called "Path of Wisdom". This leads to a sequence of platforms with different incenses you can commune with:

• Incense of Knowledge
• Incense of Patience
• Incense of Insight
• Incense of Judgement

Commune with them in the order Patience => Knowledge => Insight. On the Judgement platform an orb called the "Path of Judgement" will appear.

The orb will take you to the true Incense of Judgment. Commune with it and the final flight pad will grant you {spell:333068} to open the chest.
]]
L["gift_of_vesiphone"] = "Ring one of the bells to spawn a {npc:170849} and kill it to receive the {spell:333239} debuff. The falling water opposite the chest will cleanse this debuff and grant you {spell:332785}."

L["count_your_blessings_note"] = "Place a {item:178915} in the tribute bowl to receive the blessing."
L["options_icons_blessings"] = "{achievement:14767}"
L["options_icons_blessings_desc"] = "Display tribute locations for the {achievement:14767} achievement."

L["vesper_of_courage"] = "Vesper of Courage"
L["vesper_of_humility"] = "Vesper of Humility"
L["vesper_of_loyalty"] = "Vesper of Loyalty"
L["vesper_of_purity"] = "Vesper of Purity"
L["vesper_of_wisdom"] = "Vesper of Wisdom"
L["vespers_ascended_note"] = "Click this vesper at the same time as the other four vespers to summon the {npc:170899} at Aspirant's Crucible."
L["options_icons_vespers"] = "{achievement:14734}"
L["options_icons_vespers_desc"] = "Display vesper locations for the {achievement:14734} achievement."

L["anima_shard"] = "Lost Anima Shard"
L["anima_shard_61225"] = "On a lower platform below the bridge."
L["anima_shard_61235"] = "On a ledge above the waterfall."
L["anima_shard_61236"] = "On top of an arch halfway up the main structure."
L["anima_shard_61237"] = "On a ledge just above the water."
L["anima_shard_61238"] = "In the water beneath a small bridge."
L["anima_shard_61239"] = "On top of a thin stone column."
L["anima_shard_61241"] = "Above the entrance to the Chamber of First Reflection."
L["anima_shard_61244"] = "On a rock in the side of the cliff."
L["anima_shard_61245"] = "On a rock above a small waterfall."
L["anima_shard_61247"] = "On the wall above a small water fixture."
L["anima_shard_61249"] = "Hidden behind a stone column on the upper level of Purity's Pinnacle."
L["anima_shard_61250"] = "Sitting behind a staircase."
L["anima_shard_61251"] = "Sitting beneath a small bell."
L["anima_shard_61253"] = "On top of a fallen stone archway."
L["anima_shard_61254"] = "On top of a small wooden structure."
L["anima_shard_61257"] = "On a small ledge directly beneath {npc:162523}."
L["anima_shard_61258"] = "On a small ledge on the underside of Hero's Rest."
L["anima_shard_61260"] = "On the ground under the platform."
L["anima_shard_61261"] = "On a ledge above {npc:163460}'s cave."
L["anima_shard_61263"] = "On top of a stone pillar."
L["anima_shard_61264"] = "On top of a tilted structure."
L["anima_shard_61270"] = "Sitting at the base of a tree."
L["anima_shard_61271"] = "In a bookcase on the upper platform."
L["anima_shard_61273"] = "On a ledge directly below the jutting cliff."
L["anima_shard_61274"] = "Hidden beneath the platform."
L["anima_shard_61275"] = "In the Hall of Beasts behind some barrels."
L["anima_shard_61277"] = "On top of a thin stone column."
L["anima_shard_61278"] = "Underneath the bridge on a rock."
L["anima_shard_61279"] = "On top of a thin stone column."
L["anima_shard_61280"] = "On the corner of the table."
L["anima_shard_61281"] = "On a ledge above the Memorial Offerings treasure."
L["anima_shard_61282"] = "On a ledge below the cliff top."
L["anima_shard_61283"] = "In a cave under Miri's Chapel, behind some barrels."
L["anima_shard_61284"] = "On a ledge under a rocky overhang, path to the south."
L["anima_shard_61285"] = "At the end of a small rock ledge."
L["anima_shard_61286"] = "On a ledge overlooking the path."
L["anima_shard_61287"] = "On a ledge above the small waterfall."
L["anima_shard_61288"] = "On the tip of a small ledge."
L["anima_shard_61289"] = "On top of the gazebo."
L["anima_shard_61290"] = "At the end of a narrow rock ledge."
L["anima_shard_61291"] = "At the bottom of the pond by the feet of a statue."
L["anima_shard_61292"] = "On top of the stone archway."
L["anima_shard_61293"] = "On top of a thin stone column on the lower level."
L["anima_shard_61294"] = "Hidden behind a stack of barrels."
L["anima_shard_61295"] = "Behind {npc:156889} in a bookshelf."
L["anima_shard_61296"] = "Behind the large fallen bell.\n\n"..ns.color.Red('Inside the Necrotic Wake dungeon.')
L["anima_shard_61297"] = "Behind a stone pillar.\n\n"..ns.color.Red('Inside the Necrotic Wake dungeon.')
L["anima_shard_61298"] = "Sitting behind a lounge chair."
L["anima_shard_61299"] = "Hidden behind a large torch."
L["anima_shard_61300"] = "On a ledge hanging over the central font."
L["anima_shard_spires"] = "Three shards are located in the Spires of Ascension dungeon."
L["options_icons_anima_shard"] = "{achievement:14339}"
L["options_icons_anima_shard_desc"] = "Display the locations of all 50 lost anima shards for the {achievement:14339} achievement."

L["hymn_note"] = "Locate hymns at each of the temples and acquire their buffs to earn the achievement."
L["options_icons_hymns"] = "{achievement:14768}"
L["options_icons_hymns_desc"] = "Display hymn locations for the {achievement:14768} achievement."

L["stratios_note"] = "Even the smallest battles should be fought with honor and care. Present your team when you are ready."
L["thenia_note"] = "Such magnificent open plains here. A glorious place to battle. Are you prepared?"
L["zolla_note"] = "We take our defenses very seriously. Whether small or large, we are fully committed to maintain and train the resources that keep Bastion strong."

-------------------------------------------------------------------------------
----------------------------------- KORTHIA -----------------------------------
-------------------------------------------------------------------------------

L["carriage_crusher_note"] = "Follow the {npc:180182} into the Maw and defend it until the {npc:180246} attacks."
L["chamber_note"] = "Use a {item:186718} from {npc:178257} on the Ancient Teleporter to access the chamber."
L["consumption_note"] = [[
This rare will not drop loot until after it consumes 40x {npc:179758} to transform into its blue-shaded form (Rare).

This rare will drop extra research items after it consumes *another* 40x {npc:179758} to transform into its green-shaded form (Rare Elite).

|cFFFF0000The rare will not spawn {npc:179758} to consume while in combat.|r
]]
L["darkmaul_note"] = "Collect {item:187153} from Invasive Mawshrooms and feed them to {npc:180063}. You must complete the event 10 times to obtain the mount."
L["dislodged_nest_note"] = "Click on a nearby Noxious Moth to gain {spell:355181}. Use the {spell:355131} extra action button on {npc:178547} to gain control and ride it into the tree the nest is in."
L["escaped_wilderling_note"] = "Click on the {npc:180014} to start the taming event."
L["flayedwing_transporter_note"] = "Click on {npc:178633} to fly to or from the Vault of Secrets."
L["fleshwing_note"] = "Talk to {npc:180079} to start the collection event."
L["forgotten_feather_note"] = "Floating on a small island accessed by jumping down from Keeper's Respite."
L["konthrogz_note"] = "Spawns from a devourer's portal event. The event can appear in many places throughout Korthia."
L["korthia_limited_rare"] = "|cFFFF8C00This rare is not available on some days.|r"
L["krelva_note"] = "Moves to another platform at 80%, then moves to the mainland at 60%. |cFFFF8C00You must tag the rare after 60% to get kill credit!|r"
L["kroke_note"] = "Slay {npc:179029s} in the area until he appears. Cannot spawn on days when {npc:179029s} are missing."
L["maelie_wanderer"] = "{npc:179912} will spawn in a set location for the day. Once you have used {spell:355862} on her 6 different days return to {npc:179930} to earn the mount."
L["malbog_note"] = "Talk to {npc:179729} to gain {spell:355078} and follow the foot prints until you find the fleshy remains."
L["offering_box_note"] = "Requires Small Offering Key which can be found on the top of the west side wall of the near by ruins."
L["pop_quiz_note"] = "The Pop Quiz event will spawn randomly on the map. Click on the Abandoned Veilstaff and answer the questions from {npc:180162}."
L["razorwing_note"] = "Hand in 10x {item:187054} dropped by devourers in the area."
L["reliwik_note"] = "Click on the uncorrupted razorwing egg to pull him down."
L["spectral_bound_chest"] = "Spectral Bound Chest"
L["spectral_bound_note"] = "Click on 3 nearby Spectral Keys to unlock the chest."
L["stonecrusher_note"] = "Talk to {npc:179974} to start the event."
L["towering_exterminator_note"] = "Spawns from a mawsworn portal event. The event can appear in many places throughout Korthia."
L["worldcracker_note"] = "Talk to {npc:180028} to trigger the escort event."

L["archivist_key_note"] = "Purchase %s from {npc:178257} to unlock."
L["korthian_shrine_note"] = "Click on the shrine to gain {spell:352367} to see the hidden path to the altar."
L["num_research"] = "%d Research"
L["plus_research"] = "+Research"
L["options_icons_relic"] = "{achievement:15066}"
L["options_icons_relic_desc"] = "Display the locations of all 20 relics for {achievement:15066}."

L["rift_portal_note"] = [[
Enter |cFFFFFF00The Rift|r, an alternate phase of Korthia and the Maw with additional rares, relics and caches.

Requires a {item:186731}, which can be purchased from {npc:178257} once you reach tier 4 with {faction:2472}. The keys also have a low chance to drop from rares and caches in the zone.

|cFFFF8C00Not all rift portals are active at any given time.|r
]]
L["rift_rare_only_note"] = "This rare can only be seen and killed inside |cFFFFFF00The Rift|r phase."
L["rift_rare_exit_note"] = [[
This rare will exit |cFFFFFF00The Rift|r phase once interacted with inside the rift.

The three rift rares typically spawn in a set order at about a 20 minute interval:

  1. {npc:179913}
  2. {npc:179608}
  3. {npc:179911}
]]
L["options_icons_rift_portal"] = "{npc:179595s}"
L["options_icons_rift_portal_desc"] = "Display the locations of {npc:179595s} used to enter |cFFFFFF00The Rift|r."

L["riftbound_cache"] = "Riftbound Cache"
L["riftbound_cache_note"] = "There are 4 unique caches that can each appear at set locations inside the rift."
L["options_icons_riftbound_cache"] = "Riftbound Caches"
L["options_icons_riftbound_cache_desc"] = "Display the locations of caches inside |cFFFFFF00The Rift|r."

L["invasive_mawshroom"] = "Invasive Mawshroom"
L["invasive_mawshroom_note"] = "There are 5 unique mawshrooms that can each appear at set locations."
L["mawsworn_cache"] = "Mawsworn Cache"
L["mawsworn_cache_note"] = "There are 3 unique caches that can each appear at set locations."
L["pile_of_bones"] = "Pile of Bones"
L["relic_cache"] = "Relic Cache"
L["shardhide_stash"] = "Shardhide Stash"
L["korthia_shared_chest_note"] = "You can collect relics from these treasures 5 times a day. Additional chests may contain legendary crystals and BOA gear tokens."
L["unusual_nest"] = "Nest of Unusual Materials"
L["unusual_nest_note"] = "All 5 nest locations can be looted each day."

L["options_icons_invasive_mawshroom_desc"] = "Display the locations of Invasive Mawshrooms."
L["options_icons_invasive_mawshroom"] = "Invasive Mawshrooms"
L["options_icons_korthia_dailies_desc"] = "Display the locations of unmarked daily treasures."
L["options_icons_korthia_dailies"] = "Hidden Treasures"
L["options_icons_mawsworn_cache_desc"] = "Display the locations of Mawsworn Caches."
L["options_icons_mawsworn_cache"] = "Mawsworn Caches"
L["options_icons_nest_materials_desc"] = "Display the locations of Nests of Unusual Materials."
L["options_icons_nest_materials"] = "Nests of Unusual Materials"

-------------------------------------------------------------------------------
--------------------------------- MALDRAXXUS ----------------------------------
-------------------------------------------------------------------------------

L["chelicerae_note"] = "Destroy the {npc:159885} to activate the rare."
L["deepscar_note"] = "Can appear in multiple entrances to the Theater of Pain."
L["forgotten_mementos"] = "Pull the Vault Portcullis Chain in the chamber west of the treasure to open the gate."
L["gieger_note"] = "Pull the {npc:162815} to activate the rare."
L["gristlebeak_note"] = "Break all nearby {npc:162761} to engage the rare."
L["leeda_note"] = "Kill the two {npc:162220s} until the rare spawns."
L["nirvaska_note"] = "Only appears when the {wq:Deadly Reminder} world quest is active."
L["ravenomous_note"] = "Squash {npc:159901s} in the area until the rare spawns."
L["sabriel_note"] = "Can appear as one of the champions in the Theater of Pain."
L["schmitd_note"] = "Use nearby {spell:313451} to break his shield."
L["tahonta_note"] = "The mount only drops if you have {npc:159239} with you!"
L["taskmaster_xox_note"] = "Shares a spawn with {npc:160204}, {npc:160230} and {npc:160226}."
L["theater_of_pain_note"] = "Your first boss kill each day has a chance to drop the mount."
L["zargox_the_reborn_note"] = [[
Use {item:175841} on top of the {npc:157124}. To obtain the orb, you must complete the quest {quest:57245} from {npc:157076} and talk to him again.

If the {npc:157124} is not up, reanimate {npc:157132} in the area until it appears.
]]
L["mixed_pool_note"] = [[
Gather ingredients from the surrounding mobs and toss them into the pool. Once 30 ingredients have been added, one of seven rares will spawn depending on the combination used.

• Collect {spell:306713} from {npc:167923} and {npc:167948} to the north.

• Collect {spell:306719} from {npc:165015} and {npc:171142} to the south.

• Collect {spell:306722} from {npc:165027} and {npc:166438} to the south.

Kill each rare once to earn the {item:183903} toy.
]]

L["blackhound_cache"] = "Blackhound Cache"
L["blackhound_cache_note"] = "Summon {npc:157843} at the Abomination Factory, then escort him to the Blackhound Outpost."
L["bladesworn_supply_cache"] = "Bladesworn Supply Cache"
L["cache_of_eyes"] = "Cache of Eyes"
L["cache_of_eyes_note"] = "Spawns at multiple locations within the Sightless Hold."

L["glutharns_note"] = "In a cave behind the waterfall of slime. Kill {npc:172485} and both {npc:172479} to unlock the chest."
L["kyrian_keepsake_note"] = "Inspect the {npc:169664} to loot the treasure."
L["misplaced_supplies"] = "On top of the giant mushroom. Run up the hill and jump onto the smaller brown mushroom, then run up the larger hill and jump onto the giant mushroom."
L["necro_tome_note"] = "To get access to the tower, you have to start a small quest line from {npc:166657}. In a bookcase on the top floor."
L["plaguefallen_chest_note"] = [[
Stand in the green slime (requires healing!) to get 10 stacks of {spell:330069} and be transformed into a {spell:330092}.

Once transformed, visit the cave underneath {npc:158406}'s platform (entrance on the east side) and click the pipe to transport to the chest.
]]
L["ritualists_cache_note"] = "Pick up the {item:181558} on the floor and use them to complete the Book of Binding Rituals."
L["runespeakers_trove_note"] = "Find {npc:170563} to the east and kill him to obtain the {item:181777}."
L["stolen_jar_note"] = "Spawns in multiple different caves."
L["strange_growth_note"] = "Pull on the {npc:165037} to reveal the treasure."
L["vat_of_slime_note"] = "Click the bottle on the table and then click on the vat of slime."

L["giant_cache_of_epic_treasure"] = "Giant Cache of Epic Treasure"
L["spinebug_note"] = [[
Oh look! A {spell:343124}! Approach it brave adventurer, this is surely not a ruse. Wait, is that the music from Karazhan? What is this {npc:174663} doing here ...?

{spell:343163}!
]]

L["oonar_sorrowbane_note"] = [[
In the Theater of Pain, you will find {item:180273} stuck in the ground and {item:181164} attached to it. To pull them free:

• Purchase a {item:182163} from {npc:171808} in Revendreth.
• Purchase a {item:180771} from {npc:166640} in Maldraxxus.
• Purchase a {item:181163} from {npc:169964} in Maldraxxus.
• Get 2 stacks of {spell:306272} from the {wq:A Few Bumps Along the Way} world quest to the west.
• Eat 4x {spell:327367} in Glutharn's Decay.
• Quickly use {item:181163}, drink both potions and pull on the arm and sword.

To pull just the arm, only the 4x {spell:327367} are needed.
]]

L["pet_cat"] = "Pet the damn cat!"
L["hairball"] = ns.color.Red("Only appears in the Festering Sanctum inside the Plaguefall dungeon!")
L["lime"] = "Sitting on top of the large bone arch."
L["moldstopheles"] = "Run around the back of the stalk and jump up the mushroom platforms. For the final platform, use a mount and jump at the corner where it meets the stalk."
L["pus_in_boots"] = "Located under the bridge."

L["options_icons_slime_cat"] = "{achievement:14634}"
L["options_icons_slime_cat_desc"] = "Display locations of kittens for the {achievement:14634} achievement."

L["dundley_note"] = "I'll battle my way to victory and gain the respect I finally deserve. The only downside is everything I own is now sticky. Everything."
L["maximillian_note"] = "I have waited dozens of years for a worthy opponent. To the victor go the spoils!"
L["rotgut_note"] = "Rotgut. Leftovers. Extra pieces. You fight."

-------------------------------------------------------------------------------
--------------------------------- REVENDRETH ----------------------------------
-------------------------------------------------------------------------------

L["amalgamation_of_filth_note"] = "When the world quest {wq:Dirty Job: Demolition Detail} is available click on a Rubbish Box and use {spell:324115} into the water."
L["amalgamation_of_light_note"] = "Move all three mirror traps to release the rare."
L["amalgamation_of_sin_note"] = "During the {wq:Summon Your Sins} world quest, pick the Catalyst of Power for a chance to obtain {item:180376}, then use the item to summon the rare."
L["bog_beast_note"] = "Has a chance to spawn during the world quest {wq:Muck It Up} after using {item:177880} on a {npc:166206}."
L["endlurker_note"] = "Click Anima Stake near {npc:165229} corpse and use {spell:321826} on top of the Shimmering Rift."
L["executioner_aatron_note"] = "Kill the three nearby {npc:166715} to remove {spell:324872}."
L["executioner_adrastia_note"] = "Free {npc:161299s} in the surrounding area and escort them until they despawn. {npc:161310} will eventually spawn to squash the insurrection."
L["famu_note"] = "Talk to {npc:166483} to trigger the event."
L["grand_arcanist_dimitri_note"] = "Kill the four {npc:167467} to release the rare."
L["harika_note"] = "In Dredhollow to the west, loot the {item:176397}, then turn the bolt into {npc:165327} and tell him to bring down the rare."
L["innervus_note"] = "Kill nearby {npc:160375s} to obtain a {item:177223} and unlock the crypt."
L["leeched_soul_note"] = "Inside the nearby crypt. Walk near {npc:165151} to start the event."
L["lord_mortegore_note"] = "Kill surrounding mobs to obtain {item:174378} and use it to empower a {npc:161870}. The rare will spawn once all four sigils are empowered."
L["madalav_note"] = "Click Madalav's Hammer on the nearby anvil to summon him."
L["manifestation_of_wrath_note"] = "Has a chance to spawn when a {npc:169916} is recovered during the {wq:Swarming Souls} world quest."
L["scrivener_lenua_note"] = "Return {npc:160753} to the Forbidden Library."
L["sinstone_hoarder_note"] = "Attempt to loot the {npc:162503} and the rare will reveal itself."
L["sire_ladinas_note"] = "Pick up a Remnant of Light nearby and use {spell:313065} on {npc:157733}."
L["soulstalker_doina_note"] = "Follow downstairs and through the mirror when she runs away."
L["tomb_burster_note"] = "Can be spawned if {npc:155777} is trapped in a web. Kill nearby {npc:155769s} and waves of {npc:155795s} until the rare spawns."
L["worldedge_gorger_note"] = [[
Obtain an {item:173939} from World Reavers, Devourers and Mites in the Banewood and the Endmire. Use it to light the Worldedge Braziers and summon the rare.

Has a chance to drop an {item:180583}, which begins a 7 day quest line to obtain the {spell:333027} mount.
]]

L["dredglaive_note"] = "Under the bridge in the {npc:173671} corpse."
L["forbidden_chamber_note"] = "Loot a Discarded Anima Canister in front of the locked door and learn {spell:340701}. Use it to drain five of the nearby {npc:173838s}, then use {spell:340866} in front of the {npc:173786}."
L["gilded_plum_chest_note"] = "Kill the {npc:166680} wandering up and down the road."
L["lost_quill_note"] = "Loot the {item:182475} from the bottle on the table in the Forbidden Library, then give it to the {npc:173449} on top of the archway outside."
L["rapier_fearless_note"] = "Click the rapier on the ground, then defeat {npc:173603}."
L["remlates_cache_note"] = "On the outer wall of Darkhaven behind the crypt."
L["smuggled_cache_note"] = ns.color.Red("BEFORE YOU LOOT: ").."Make sure you have completed {quest:60480} side quest or you will miss out on 40 {currency:1820} from the treasure and quest."
L["taskmaster_trove_note"] = "Read the Ingress and Egress Rites then carefully make your way to the chest."
L["the_count_note"] = "Farm 99 {currency:1820} in the Endmire and then bring them to {npc:173488}."

L["forgotten_anglers_rod"] = "Forgotten Angler's Rod"

L["loyal_gorger_note"] = "Visit the Endmire and complete a daily offered by your {npc:173498} 7 times to obtain him as a mount."

L["sinrunner_note"] = "Bring food and supplies to {npc:173468} for six days to obtain her reins. She only appears for a few minutes at a time."
L["sinrunner_note_day1"] = "Offer Blanchy 8 {item:182581} from farm areas in Westfall."
L["sinrunner_note_day2"] = "Obtain a {item:182585} from {npc:173570} in Darkhaven and use it to clean Blanchy."
L["sinrunner_note_day3"] = "Equip Blanchy with 4 {item:182595} found on the roads surrounding Darkhaven."
L["sinrunner_note_day4"] = "Pick up the {item:182620} near {npc:173570} and fill it with water from Bastion or Ardenweald. Return the {item:182599} to Blanchy."
L["sinrunner_note_day5"] = "Equip Blanchy with a {item:182597}, sold by {npc:171808} near the Night Market in exchange for assorted meats."
L["sinrunner_note_day6"] = "Feed Blanchy 3 {item:179271}, sold by {npc:167815} by the Hole in the Wall."

L["options_icons_carriages"] = "Carriages"
L["options_icons_carriages_desc"] = "Display locations and paths of rideable carriages."
L["options_icons_dredbats"] = "{npc:161015s}"
L["options_icons_dredbats_desc"] = "Display locations and paths of {npc:161015s}."
L["options_icons_sinrunners"] = "{npc:174032s}"
L["options_icons_sinrunners_desc"] = "Display locations and paths of {npc:174032s}."

L["addius_note"] = "Weak minded beings should not waste my time, but if you insist, I will show you real pain."
L["eyegor_note"] = "Eyegor ready for battle!"
L["sylla_note"] = "One can never expect to have a distinguished battle out here in this awful area, but alas here we are. Do not waste my time."

L["avowed_ritualist_note"] = "Bring nearby {npc:160149s} here to absolve them."
L["fugitive_soul_note"] = "Bring this {npc:160149} to a nearby {npc:166150} to begin a ritual of absolution."
L["souls_absolved"] = "souls absolved"
L["options_icons_fugitives"] = "{achievement:14274}"
L["options_icons_fugitives_desc"] = "Display fugitive soul locations for the {achievement:14274} achievement."

L["grand_inquisitor_note"] = "Turn in 10 {item:180451} to {npc:160248} for a chance at this sinstone."
L["high_inquisitor_note"] = "Turn in 250 {currency:1816} to {npc:160248} for a chance at this sinstone."
L["inquisitor_note"] = "Turn in 100 {currency:1816} to {npc:160248} for a chance at this sinstone."
L["options_icons_inquisitors"] = "Inquisitors"
L["options_icons_inquisitors_desc"] = "Display inquisitor locations for the {achievement:14276} achievement."

L["broken_mirror"] = "Broken Mirror"
L["broken_mirror_note"] = "A group of three broken mirrors will be active each day. Use a {item:181363} to repair each mirror and open the |cFFFFFD00Forgotten Chest|r inside."
L["broken_mirror_crypt"] = "Inside a crypt."
L["broken_mirror_elite"] = "In a small room with elite mobs."
L["broken_mirror_group"] = "Group"
L["broken_mirror_house"] = "Inside the house."
L["broken_mirror_61818"] = "In a small room with {npc:173699}."
L["broken_mirror_61819"] = "In a small room on the ground floor."
L["broken_mirror_61827"] = "In a small room."
L["options_icons_broken_mirror"] = "Broken Mirrors"
L["options_icons_broken_mirror_desc"] = "Display the locations of broken mirrors."

-------------------------------------------------------------------------------
----------------------------------- THE MAW -----------------------------------
-------------------------------------------------------------------------------

L["return_to_the_maw"] = "Return to the Maw"
L["maw_intro_note"] = "Begin the introductory quest chain from {npc:162804} to unlock rares and events in the maw."

L["apholeias_note"] = "With 3 other players, stand on the corners of the platform and cast {spell:331783} to summon the rare."
L["dekaris_note"] = "On top of a large jutting rock."
L["deomen_note"] = "To open his cage, enter the chamber to the south and activate both lock controls on either side of the room."
L["drifting_sorrow_note"] = "Kill {npc:175246s} near the hovering orb to activate the boss."
L["ekphoras_note"] = "With 3 other players, stand on the corners of the platform and cast {spell:330650} to summon the rare."
L["etherwyrm_label"] = "Infused Etherwyrm Cage"
L["etherwyrm_note"] = "Requires the Night Fae assault to be active. Kill an {npc:179030} while in the rift to gain the {item:186190}. Use the key on the Etherwyrm Cage (outside the rift) in the Desolate Hollow cavern (where {npc:175821} resides when the assault is not active)."
L["fallen_charger_note"] = "After the zone-wide yell it will take either of the two paths until it reaches Korthia where it will despawn."
L["ikras_note"] = "Flies around Perdition Hold. This is a good place to pull him."
L["lilabom_note"] = [[
Collect all 5 parts to complete the pet. Some parts may appear in multiple locations.

• {item:186183}
• {item:186184}
• {item:186185}
• {item:186186}
• {item:186187}
]]
L["orophea_note"] = "Pick up {spell:337143} to the southeast and offer it to {npc:172577} to activate."
L["sanngror_note"] = "If he is not attackable, wait until he is not experimenting on souls."
L["sly_note"] = "Talk to {npc:179068} to get the buff {spell:353322} and find {npc:179096} on 3 different kyrian assaults."
L["talaporas_note"] = "With 3 other players, stand on the corners of the platform and cast {spell:331800} to summon the rare."
L["valis_note"] = "Click the three {npc:174810} in the correct order to summon the rare. The order changes each time and clicking the wrong rune deals damage and debuffs you with {spell:343636}."
L["yero_note"] = "Approach {npc:172862} and then follow him down into a nearby cave where he becomes hostile."

L["exos_note"] = [[
Kill the other three Heralds of Grief, Pain and Loss to collect their etchings.

• {item:182328}
• {item:182326}
• {item:182327}

Combine all three etchings to create the {item:182329}, which can be used to summon the rare at the Altar of Domination. Use the {npc:173892} to reach the upper level.
]]

L["animaflow_teleporter_note"] = "Activate to travel directly to other locations in the Maw."
L["chaotic_riftstone_note"] = "Activate to {spell:344157} quickly across the Maw."
L["venari_note"] = [[
Use {currency:1767} to purchase Maw and Torghast upgrades.

|cFFFF8C00Account-wide Torghast upgrades will show as incomplete on alts!|r
]]
L["venari_upgrade"] = "{npc:162804} Upgrade"
L["torghast"] = "Torghast"
L["Ambivalent"] = nil
L["Appreciative"] = nil
L["Apprehensive"] = nil
L["Cordial"] = nil
L["Tentative"] = nil

L["stygian_cache"] = "Stygian Cache"
L["stygian_cache_note"] = "Only one person can loot the cache each time it spawns!"

L["box_of_torments_note"] = "Open the {npc:173837} under the Tremaculum."
L["tormentors_notes_note"] = "Loot the corpse of {npc:173811}."
L["words_of_warden_note"] = "Examine the |cffffff00Paper Scrap|r on a rock behind some pots."

-- Locations given relative to a map area name
L["nexus_area_calcis_branch"] = "Up on a crystal branch in Calcis (use grapple point)"
L["nexus_area_calcis_crystals"] = "Behind some teal crystals in Calcis"
L["nexus_area_cradle_bridge"] = "Beneath the bridge in Ruin's Cradle"
L["nexus_area_domination_bridge"] = "On a bridge south of the Altar of Domination"
L["nexus_area_domination_edge"] = "On the edge atop the Altar of Domination"
L["nexus_area_domination_room"] = "In a small room atop the Altar of Domination"
L["nexus_area_domination_stairs"] = "Atop the Altar of Domination next to the {npc:173904}"
L["nexus_area_gorgoa_bank"] = "On the bank of the Gorgoa (River of Souls)"
L["nexus_area_gorgoa_middle"] = "Right in the middle of the river yo!"
L["nexus_area_gorgoa_mouth"] = "At the mouth of the Gorgoa (River of Souls)"
L["nexus_area_perdition_wall"] = "Along the outer wall of Perdition Hold"
L["nexus_area_torment_rock"] = "On a rock in the Planes of Torment"
L["nexus_area_zone_edge"] = "Along the edge of the zone"
L["nexus_area_zovaal_edge"] = "Along the edge of Zovaal's Cauldron"
L["nexus_area_zovaal_wall"] = "Along the wall below Zovaal's Cauldron"
-- Locations given relative to a named cave/cavern
L["nexus_cave_anguish_lower"] = "In the Pit of Anguish (lower level)"
L["nexus_cave_anguish_outside"] = "Outside the Pit of Anguish"
L["nexus_cave_anguish_upper"] = "In the Pit of Anguish (upper level)"
L["nexus_cave_desmotaeron"] = "In a small cave outside the Desmotaeron"
L["nexus_cave_echoing_outside"] = "Outside the Echoing Caverns"
L["nexus_cave_forlorn"] = "Inside the Forlorn Respite cavern."
L["nexus_cave_howl_outside"] = "On the ground outside the Death's Howl cavern"
L["nexus_cave_howl"] = "Inside the Death's Howl cavern"
L["nexus_cave_roar"] = "Inside the Death's Roar cavern"
L["nexus_cave_ledge"] = "In a small cave below a ledge"
L["nexus_cave_prodigum"] = "In a small cave in the Prodigum"
L["nexus_cave_soulstained"] = "In a small cave in the Soulstained Fields"
L["nexus_cave_torturer"] = "Inside the Torturer's Hovel"
-- Locations given relative to a named NPC
L["nexus_npc_akros"] = "Atop the stairs next to {npc:170787}"
L["nexus_npc_dekaris"] = "At the top of the peak where {npc:157964} resides"
L["nexus_npc_dolos"] = "On the ground behind {npc:170711}"
L["nexus_npc_ekphoras"] = "Next to {npc:169827}'s platform"
L["nexus_npc_incinerator"] = "On a small ledge below {npc:156203}"
L["nexus_npc_orophea"] = "On the ground next to {npc:172577}"
L["nexus_npc_orrholyn"] = "Found below {npc:162845}'s platform"
L["nexus_npc_portal"] = "On a small rock behind the {npc:167531}"
L["nexus_npc_talaporas"] = "By the staircase to {npc:170302}'s platform"
L["nexus_npc_thanassos"] = "On the back of {npc:170731}'s platform"
L["nexus_npc_willbreaker"] = "In the corner behind a {npc:168233}"
-- Locations given relative to the main path/road nearby
L["nexus_road_below"] = "On the ground below the main road"
L["nexus_road_cave"] = "In a small cave below the road"
L["nexus_road_mawrats"] = "In a pack of mawrats beside the road"
L["nexus_road_next"] = "Next to the main path"
L["nexus_room_ramparts"] = "In a small room below the ramparts"
-- Random locations described as best as possible
L["nexus_misc_crystal_ledge"] = "On a rock ledge by some teal crystals"
L["nexus_misc_floating_cage"] = "On a floating cage (use grapple points)"
L["nexus_misc_below_ramparts"] = "Along the bottom of the ramparts"
L["nexus_misc_grapple_ramparts"] = "On top of the ramparts (use grapple point)"
L["nexus_misc_grapple_rock"] = "By a grapple point on a rock"
L["nexus_misc_ledge_below"] = "On the ground under a ledge"
L["nexus_misc_three_chains"] = "On the ground by three chains"

L["stolen_anima_vessel"] = "Stolen Anima Vessel"
L["hidden_anima_cache"] = "Hidden Anima Cache"
L["options_icons_anima_vessel"] = "Stolen Anima Vessels"
L["options_icons_anima_vessel_desc"] = "Display the locations of anima vessels during assaults and inside |cFFFFFF00The Rift|r."

L["rift_hidden_cache"] = "Rift Hidden Cache"
L["options_icons_rift_hidden_cache"] = "Rift Hidden Caches"
L["options_icons_rift_hidden_cache_desc"] = "Display the locations of caches inside |cFFFFFF00The Rift|r."

L["options_icons_bonus_boss"] = "Bonus Elites"
L["options_icons_bonus_boss_desc"] = "Display locations of bonus elites."
L["options_icons_riftstone"] = "{npc:174962s}"
L["options_icons_riftstone_desc"] = "Display the locations of chaotic riftstone teleporters."
L["options_icons_grapples"] = "{npc:176308s}"
L["options_icons_grapples_desc"] = "Display grapple locations for the {item:184653} upgrade."
L["options_icons_stygia_nexus"] = "Stygia Nexus"
L["options_icons_stygia_nexus_desc"] = "Display nexus locations needed for the {item:184168} mount."
L["options_icons_stygian_caches"] = "Stygian Caches"
L["options_icons_stygian_caches_desc"] = "Display cache locations containing extra Stygia."

L["cov_assault_only"] = "Only available during the %s assault."

L["helgarde_supply"] = "Helgarde Supply Cache"
L["helgarde_supply_note"] = "Spawns throughout the Desmotaeron area. Your {npc:180598} can help you locate them."
L["options_icons_helgarde_cache"] = "Helgarde Supply Caches"
L["options_icons_helgarde_cache_desc"] = "Display possible locations for Helgarde Supply Caches in the Desmotaeron area."

L["mawsworn_cache_ramparts_note"] = "This cache is on top of the ramparts. Use the grapple points or a {npc:177093} to reach them."
L["mawsworn_cache_tower_note"] = "This cache is on top of the tower and requires a {npc:177093} to reach. Use the {spell:349853} ability to climb up."
L["mawsworn_cache_quest_note"] = "The {item:186573} will only drop after you have completed the {quest:63545} quest!"

L["nilg_silver_ring_note"] = "Collect 4 {item:186727} in the Desmotaeron and use them to open the Domination Sealed Chest."
L["nilg_silver_ring_note1"] = "Kill {npc:177444} and open the {item:186970}."
L["nilg_silver_ring_note2"] = "Loot the Harrower's Key Ring, located on the wall in an underground room next to {npc:178311}."
L["nilg_silver_ring_note3"] = "Open Helgarde Supply Caches in the Desmotaeron area. Your {npc:180598} can help you locate them."
L["nilg_silver_ring_note4"] = "Farm {npc:177134s} in the Desmotaeron area (low drop rate)."
L["nilg_stone_ring_note"] = "Collect four {item:186600} during the Necrolord assault and combine them at any {npc:171492} in Zovaal's Cauldron."
L["nilg_stone_ring_note1"] = "Found in certain Mawsworn Caches (yellow icon) on top of the ramparts in Perdition Hold."
L["nilg_stone_ring_note2"] = "Complete the {quest:63545} quest, then loot Mawsworn Caches until you find the quest item {item:186573}. This quest is shareable!"
L["nilg_stone_ring_note3"] = "Looted from {npc:179601} in the center area of Perdition Hold."
L["nilg_stone_ring_note4"] = "Found on the ground in Perdition Hold near {npc:170634}. Your {npc:180598} can help you locate it."
L["nilg_gold_band_note"] = "Use the grapple point and follow the path up to the top of the mountain."
L["nilganihmaht_note"] = "You must collect the 5 rings and bring them to {npc:179572} in the rift."
L["calcis"] = "Calcis"
L["desmotaeron"] = "Desmotaeron"

L["zovault_note"] = "Drag {npc:179883} to {npc:179904} once a day for guaranteed riftstones."
L["options_icons_zovault"] = "{npc:179883}"
L["options_icons_zovault_desc"] = "Display possible locations for {npc:179883}."

L["tormentors"] = "Tormentors of Torghast"
L["tormentors_note"] = [[
A tormentor event spawns every 2 hours on the hour. The bosses will always spawn in the order listed below.

The {item:185972} can be looted once a week and contains 50 {currency:1906}.
]]