import flash.external.*;

Stage.scaleMode = "noScale";
Stage.align = "tl";

_root.ready = 'no';
 
_root.readyFunc = function(str:String) {
  return _root.ready;
}

ExternalInterface.addCallback("ready", _root, _root.readyFunc);

if( _root.headerColor != null ) {
	var headerColor = parseInt( _root.headerColor, 16 );
	var menuColor = parseInt( _root.menuColor, 16 );
	var backgroundColor = parseInt( _root.backgroundColor, 16 );
	var startingView = _root.startingView;
	var thumbTint = parseInt( _root.thumbTint, 16 );
	var thumbBorderTint = parseInt( _root.thumbBorderTint, 16 );
	var previewBorderTint = parseInt( _root.previewBorderTint, 16 );
	var previewTint = parseInt( _root.previewTint, 16 );
	var thumbTintAlpha = parseInt( _root.thumbTintAlpha );
	var thumbBorderAlpha = parseInt( _root.thumbBorderAlpha );
	var previewBorderAlpha = parseInt( _root.previewBorderAlpha );
	var previewTintAlpha = parseInt( _root.previewTintAlpha );
		// one of galleryScrollingBottom, galleryScrollingDefault, galleryScrollingLeft, slideshowOnly
	
	updateDisplayWithParams( 
							headerColor, 
							menuColor, 
							backgroundColor, 
							startingView, 
							thumbTint, thumbTintAlpha,
							thumbBorderTint, thumbBorderAlpha,
							previewTint, previewTintAlpha,
							previewBorderTint, previewBorderAlpha );
}
else {
	updateDisplayWithParams( 
							0x5555FF,
							0xFF5555,
							0xFFDD00,
							"galleryScrollingLeft",
							0xEEBB00, 50,
							0xFFAA00, 80,
							0xEEBB00, 90,
							0x000000, 40
							)

}

function fitInAspect( movieClip, w, h ) {
	var targetAspect = w / h;
	var curAspect = movieClip._width / movieClip._height;
	if( targetAspect < curAspect ) {
		// currently the movie is too fat
		var targetWidth =  movieClip._height * targetAspect;
		var adjustment = ( movieClip._width - targetWidth );
		movieClip._x += adjustment / 2;
		movieClip._width -= adjustment;
	}
	if( targetAspect > curAspect ) {
		// currently the movie is too tall
		var targetHeight = movieClip._width / targetAspect;
		var adjustment = ( movieClip._height - targetHeight );
		movieClip._y += adjustment / 2;
		movieClip._height -= adjustment;
	}
}

function updateDisplayWithParams(
							headerColor, 
							menuColor, 
							backgroundColor, 
							startingView,
							thumbBg, thumbTintAlpha,
							thumbBorderTint, thumbBorderAlpha,
							previewBg, previewTintAlpha,
							previewBorderTint, previewBorderAlpha )
{

	_root.flashIcon._y = Stage.height;
	_root.flashIcon._x = 0;

	_root.beginFill( headerColor, 100 );
	_root.moveTo( 0, 0 );
	_root.lineTo( Stage.width, 0 );
	_root.lineTo( Stage.width, 15 );
	_root.lineTo( 0, 15 );
	_root.endFill();
	
	_root.beginFill( menuColor, 100 );
	_root.moveTo( 0, 15 );
	_root.lineTo( Stage.width, 15 );
	_root.lineTo( Stage.width, 21 );
	_root.lineTo( 0, 21 );
	_root.endFill();
	
	_root.beginFill( backgroundColor, 100 );
	_root.moveTo( 0, 21 );
	_root.lineTo( Stage.width, 21 );
	_root.lineTo( Stage.width, Stage.height );
	_root.lineTo( 0, Stage.height );
	_root.endFill();
	
	_root.beginFill( backgroundColor, 100 );
	_root.moveTo( 0, 21 );
	_root.lineTo( Stage.width, 21 );
	_root.lineTo( Stage.width, Stage.height );
	_root.lineTo( 0, Stage.height );
	_root.endFill();

	var thumbSize = 34;
	var thumbSpace = 42;
	var thumbX = -1
	var thumbY = -1
	var thumbX2 = -1
	var thumbY2 = -1
	var previewX = -1
	var previewY = -1
	var previewX2 = -1
	var previewY2 = -1
	
	if( startingView == 'galleryScrollingLeft' ) {
		thumbX = 4
		thumbY = 25
		thumbX2 = 35
		thumbY2 = Stage.height - 4;
		previewX = 39
		previewY = 25
		previewX2 = Stage.width - 4
		previewY2 = Stage.height - 4;
	}
	else if( startingView == 'galleryScrollingBottom' ) {
			thumbX = 4
		thumbY = Stage.height - 35
		thumbX2 = Stage.width - 4
		thumbY2 = Stage.height - 4;
		previewX = 4
		previewY = 25
		previewX2 = Stage.width - 4
		previewY2 = Stage.height - 39;
	}
	else if( startingView == 'slideshowOnly' ) {
		previewX = 4
		previewY = 25
		previewX2 = Stage.width - 4
		previewY2 = Stage.height - 4;
	}
	else if( startingView == 'galleryDefault' ) {
		thumbX = 4
		thumbY = 25
		thumbX2 = Stage.width * 0.4 - 2
		thumbY2 = Stage.height - 4;
		previewX = Stage.width * 0.4 + 2
		previewY = 25
		previewX2 = Stage.width - 4
		previewY2 = Stage.height - 4;
	}
	
	var w = Math.floor( Math.min( previewX2 - previewX, previewY2 - previewY ) / 2 - 20 )
	var h = Math.floor( w * 3 / 4 )
	var previewImgX = ( previewX + previewX2 ) / 2 - w
	var previewImgX2 = previewImgX + w + w
	var previewImgY = ( previewY + previewY2 ) / 2 - h
	var previewImgY2 = previewImgY + h + h
	
	_root.beginFill( 0x888888, 40 );
	_root.moveTo( previewImgX, previewImgY );
	_root.lineTo( previewImgX2, previewImgY );
	_root.lineTo( previewImgX2, previewImgY2 );
	_root.lineTo( previewImgX, previewImgY2 );

	_root.lineStyle( 1, thumbBorderTint, thumbBorderAlpha )
	_root.beginFill( thumbBg, thumbTintAlpha );
	_root.moveTo( thumbX, thumbY );
	_root.lineTo( thumbX2, thumbY );
	_root.lineTo( thumbX2, thumbY2 );
	_root.lineTo( thumbX, thumbY2 );
	_root.endFill();

	_root.lineStyle( 1, previewBorderTint, previewBorderAlpha )
	_root.beginFill( previewBg, previewTintAlpha );
	_root.moveTo( previewX, previewY );
	_root.lineTo( previewX2, previewY );
	_root.lineTo( previewX2, previewY2 );
	_root.lineTo( previewX, previewY2 );
	_root.endFill();

}


