/*!
**********************************************************************
@file ContainerProxy.js

Copyright 2003-2006 Adobe Systems Incorporated.                     
All Rights Reserved.                                                
                                                                    
NOTICE: All information contained herein is the property of Adobe   
Systems Incorporated.                                                                                                                    

***********************************************************************
*/


/**
Object that stores all ribs constants that have significance to other parts of the workflow
*/


/**


/**
Proxy interface to exported JS methods so that both 
ExtendScript and WebKit/IE can query for data
*/
function ContainerProxy()
{
	this.UIHosted = function()
	{
		var isHosted = false;
		try
		{
			isHosted = "object" == typeof window.external;
		}
		catch (ex)
		{
			
		}
		return isHosted;
	};


this.GetDefaultProperties = function()
	{	
		var jsonObj = null;
		try
		{
			if (null == this.cachedDefaultProperties)
			{
				if (this.UIHosted())
				{
					jsonObj = _jsonToObject(window.external.GetDefaultProperties());
				}
				else
				{
					jsonObj = _jsonToObject(GetDefaultProperties());
				}	

				// Add a few bits.
//				var driver = this.GetDriverPayload();
//				if (driver)
//				{
//					jsonObj["productName"] = driver.ProductName;
//					jsonObj["driverAdobeCode"] = driver.AdobeCode;
//
//					// Use the start menu override if appropriate
//					var localSessionData = this.GetSessionData();
//					if (localSessionData && localSessionData.payloadMap && localSessionData.payloadMap[driver.AdobeCode] && localSessionData.payloadMap[driver.AdobeCode]["StartMenuProgramsSubFolder"])
//					{
//						var tokenMap = this.GetDirectoryTokenMap();
//						if (tokenMap && tokenMap["[StartMenu]"])
//						{
//							jsonObj["StartMenuSubFolder"] = _concatPaths(new Array(tokenMap["[StartMenu]"], localSessionData.payloadMap[driver.AdobeCode]["StartMenuProgramsSubFolder"]), jsonObj["platform"]);
//						}
//					}
//				}
//				else
//				{
//					jsonObj["productName"] = "Adobe Setup";
//				}
				this.cachedDefaultProperties = jsonObj;
			}
			else
			{
				jsonObj = this.cachedDefaultProperties;
			}
		}
		catch (ex)
		{
			jsonObj = null;
		}
		
		return jsonObj;		
	}

    this.GetConflictingProcessList = function()
	{	
		var jsonObj = null;
		try
		{
			jsonObj = _jsonToObject(window.external.GetConflictingProcessList());

		}
		catch (ex)
		{
			jsonObj = null;
		}
		
		return jsonObj;		
	}

   this.FileExists = function(inFullFilePath)
	{
	    var jsonObj = null;
		try
		{
		     jsonObj = _jsonToObject(window.external.FileExists(inFullFilePath));
		}
		catch (ex)
		{
			jsonObj = null;
		}
		
		return jsonObj;		
	}

    this.CheckForDiskSpace = function()
	{	
		var jsonObj = null;
		try
		{
			jsonObj = _jsonToObject(window.external.CheckForDiskSpace());

		}
		catch (ex)
		{
			jsonObj = null;
		}
		
		return jsonObj;		
	}	

	this.GetStringsForLanguage = function(inLang)
	{
		var jsonObj = null;
		try
		{
			jsonObj = _jsonToObject(window.external.GetStringsForLanguage(inLang));
		}
		catch (ex)
		{
			jsonObj = null;
		}
		return jsonObj;
	}
	
	this.LoadFile = function(inFullFilePath)
	{
		var jsonObj = null;
		try
		{
			jsonObj = _jsonToObject(window.external.LoadFile(inFullFilePath));
		}
		catch (ex)
		{
			jsonObj = null;
		}
		return jsonObj;
	}

	this.GetCommandLineArguments = function()
	{
		var jsonObj = null;
		try
		{
			if (this.UIHosted())
			{
				jsonObj = _jsonToObject(window.external.GetCommandLineArguments());
			}
			else
			{
				jsonObj = _jsonToObject(GetCommandLineArguments());
			}			
		}
		catch (ex)
		{
			jsonObj = null;
		}
		return jsonObj;	
	}
	
	
	this.LogDebug = function(inMessage)
	{
		this._log(5, inMessage);
	}	
	this.LogInfo = function(inMessage)
	{
		this._log(4, inMessage);		
	}
	this.LogWarning = function(inMessage)
	{
		this._log(3, inMessage);
	}
	this.LogError = function(inMessage)
	{
		this._log(2, inMessage);
	}
	this.LogFatal = function(inMessage)
	{
		this._log(1, inMessage);
	}
	this.UIResizeWindow = function(inWidth, inHeight)
	{
		var jsonObj = null;
		try
		{
			jsonObj = _jsonToObject(window.external.UIResizeWindow(inWidth, inHeight));
		}
		catch (ex)
		{
			jsonObj = null;
		}
		return jsonObj;
	}
	
	this.GetResourcesPath = function()
	{
		var resourcesPath = null;
		
		var commandLineData = this.GetCommandLineArguments();
		
		if (commandLineData
			&& commandLineData.Properties
			&& commandLineData.Properties.resourcesPath)
		{
			resourcesPath = commandLineData.Properties.resourcesPath;
		}
		
		if (null == resourcesPath)
		{
			var objProps = this.GetDefaultProperties();
			if (objProps
				&& objProps.installSourcePath)
			{
				resourcesPath = _concatPaths(new Array(objProps.installSourcePath, "resources"), objProps["platform"]);
			}
		}
		
		return resourcesPath;
	}
			
	this.UIShowWindow = function(inShow)
	{
		var jsonObj = null;
		try
		{
			jsonObj = _jsonToObject(window.external.UIShowWindow(inShow));
		}
		catch (ex)
		{
			jsonObj = null;
		}
		return jsonObj;
	}
	
	this.UISetWindowTitle = function(inTitle)
	{
		var jsonObj = null;
		try
		{
			if (this.UIHosted())
			{
				jsonObj = _jsonToObject(window.external.UISetWindowTitle(inTitle));
			}
			else
			{
				jsonObj = _jsonToObject(UISetWindowTitle(inTitle));
			}			
		}
		catch (ex)
		{
			jsonObj = null;
		}
		return jsonObj;
	}	
	
	this.UISetCloseBoxEnabled = function(inEnabled)
	{
		var jsonObj = null;
		try
		{
			jsonObj = _jsonToObject(window.external.UISetCloseBoxEnabled(inEnabled));
		}
		catch (ex)
		{
			jsonObj = null;
		}
		return jsonObj;
	}	

	this.UIGetProgress = function()
	{
		var jsonObj = null;
		try
		{
			jsonObj = _jsonToObject(window.external.UIGetProgress());
		}
		catch (ex)
		{
			jsonObj = null;
		}
		return jsonObj;
	}	
	this.UIGetPayloadProgress = function()
	{
		var jsonObj = null;
		try
		{
			jsonObj = _jsonToObject(window.external.UIGetPayloadProgress());
		}
		catch (ex)
		{
			jsonObj = null;
		}
		return jsonObj;
	}	
	
	this.UIGetInitialErrors = function()
	{
		var jsonObj = null;
		try
		{
			jsonObj = _jsonToObject(window.external.UIGetInitialErrors());
		}
		catch (ex)
		{
			jsonObj = null;
		}
		return jsonObj;
	}	
	
	this.UIGetUpdatesStatusMap = function()
	{
		var jsonObj = null;
		try
		{
			jsonObj = _jsonToObject(window.external.UIGetUpdatesStatusMap());						
		}
		catch (ex)
		{
			jsonObj = null;
		}
		return jsonObj;
	}
	
	
	this.UIExitDialog = function(inExitArgument)
	{
		var jsonObj = null;
		try
		{
			jsonObj = _jsonToObject(window.external.UIExitDialog(inExitArgument));
		}
		catch (ex)
		{
			jsonObj = null;
		}
		return jsonObj;
	}
	this.UICancelUpdate = function()
	{
		var jsonObj = null;
		try
		{
			jsonObj = _jsonToObject(window.external.UICancelUpdate());
		}
		catch (ex)
		{
			jsonObj = null;
		}
		return jsonObj;
	}
	this.AcquireSetupLock = function()
	{
		var jsonObj = null;
		try
		{
			jsonObj = _jsonToObject(window.external.AcquireSetupLock());
		}
		catch (ex)
		{
			jsonObj = null;
		}
		return jsonObj;
	}
	this.UIShowModalAlert = function(inXHTMLString)
	{
		var jsonObj = null;
		try
		{
			jsonObj = _jsonToObject(window.external.UIShowModalAlert(inXHTMLString));
		}
		catch (ex)
		{
			jsonObj = null;
		}
		return jsonObj;
	}	

	this._log = function(inLevel, inMessage)
	{
		try
		{
            if (typeof(inMessage) == "object")
            {
                inMessage = this._objectToString(inMessage, 0);
            }		
            
			if (true == this.UIHosted())
			{
                window.external.Log(inLevel, inMessage);
			}
			else
			{
				Log(inLevel, inMessage);	
			}
		}
		catch (ex)
		{
		
		}	
	}

	
    /**
    Log an objects's content to the logfile
    */
    this._objectToString = function(inObject, inLevel, inObjectChain)
    {
    	var retString = "";
	    if (null == inObject)
		    return retString;	
    	
		// objectChain is the chain of parent objects in the conversion to a string.
		// These represent the depth and are used to check for referential loops
		var objectChain = inObjectChain ? inObjectChain : new Array;
		
		// chainWithSelf is the chain of objects that would be passed to _objectToString
		// when appending child objects and is used to check for referential loops
		var chainWithSelf = objectChain.concat([inObject]);
		
	    var depth = objectChain.length;
	    var indentString = "";
	    for (var i=0; i < depth; ++i)
		    indentString += "\t";
	    try
	    {
			var firstPass = true;
		    for (var item in inObject)
		    {
				if (firstPass && inLevel <= 0)
				{
					retString += "Log of: " + typeof(inObject) + "\n";
					firstPass = false;
				}
				// add item property name and type to output
			    var itemObject = inObject[item];
				
				// check for reference loops
				var loopFound = false;
				for (var i = 0; i < chainWithSelf.length; ++i)
				{
					if (itemObject === chainWithSelf[i])
					{
						// loop detected, indicate loop
					    var logText = indentString + item + " {LOOP}: Reference to object up " + (chainWithSelf.length - i - 1);
					    retString += logText + "\n";
						loopFound = true;
						break;
					}
				}
				
				// output the item object if it wasn't a loop
				if (!loopFound)
				{
				    var logText = indentString + item + " {" + typeof(itemObject) + "}: ";
					if ("function" == typeof itemObject)
						logText += "[function body omitted]";
					else
				    	logText += itemObject;
				    retString += logText + "\n";
					retString += this._objectToString(itemObject, inLevel, chainWithSelf);
				}
		    }
	    }
	    catch (e)
	    {
		    this.LogError(2, "Unable to log object.  Error: " + e);	
	    }
	    return retString;
    }
}
