/*!
**********************************************************************
@file Welcome.js

Copyright 2003-2006 Adobe Systems Incorporated.                     
All Rights Reserved.                                                
                                                                    
NOTICE: All information contained herein is the property of Adobe   
Systems Incorporated.                                                                                                                    

***********************************************************************
*/
/**
Welcome Page
*/

var _g_this=null;

function Welcome()	
{
	
	var thisCB = this;

	this.quitWB = new WizardButton1(9, "n", gSession.localization.GetString("locQuit", "Quit"),
		"128px", "32px", "156px", "16px","bigbutton_normalsize", document.getElementById("welcomeID_button"), function(){thisCB.Quit();});
	this.nextWB = new WizardButton1(9, "n", gSession.localization.GetString("locNext", "Next"), 
		"128px", "32px", "316px", "16px","bigbutton_normalsize", document.getElementById("welcomeID_button"), function(){thisCB.NavNext();});
	this.Hide();
	
	var systemInfo = gSession.systemInfo;
	var currentPlatform = systemInfo.Macintosh ? "Mac" : "Win";
	_g_this = this;
	var newImagePath = null;
	if(currentPlatform=="Win")
	{
		newImagePath = gSession.GetResourcesPath() +"\\media\\img\\background.png";
	}
	else
	{
		newImagePath = gSession.GetResourcesPath() +"/media/img/background.png";
	}
	var jsonObj = gSession.FileExists(newImagePath);
	if (jsonObj && jsonObj.banner == "1")
	{
		if(currentPlatform=="Win")
		{
			newImagePath = newImagePath.replace(/\\\\+/g, "//");
			newImagePath = newImagePath.replace(/\\+/g, "/");
		}
	         var customBrandingBackground = new WizardImage1(newImagePath, null, "brandHeader", document.getElementById("brandHeader"),null, null, null, true);
	}
	else 
	{
		var brandingNode = document.getElementById("brandingText");
		brandingNode.innerText = gSession.localization.GetString("locProductName","[productName].", gSession.GetDefaultProperties());
	}
	
	gSession.UISetWindowTitle("Adobe Update Installer - " + gSession.localization.GetString("main_pageSubTitle", "Welcome"));
	
	
	var listNode = document.getElementById("updateListID");
		
	    //var li = document.createElement("li");
		   // li.innerHTML = "Loading Setup";
		    //listNode.appendChild(li);
		    listNode.innerHTML =  gSession.localization.GetString("locPageTitle", "Loading Setup");
		
	     //$$$_g_this.nextWB.Disable();
	
	//$$$_g_pollIntervalDisplay = setInterval('IsPayloadManagerReady()', 50);
	
	
	
}

Welcome.prototype = new WizardPage("welcomeID");

Welcome.prototype.NavNext = function()
{
	var stat="";
	stat = CheckForConflictingProcess();
	if(stat!="1")
	{
	    stat=CheckForDiskSpace();
	}
	if(stat!="1")
	    this.ShowNextPage();
}

Welcome.prototype.OnShow = function()
{
	/*var thisCB = this;

	this.quitWB = new WizardButton1(9, "n", gSession.localization.GetString("locQuit", "Quit"),
		"128px", "32px", "156px", "16px","bigbutton_normalsize", document.getElementById("welcomeID_button"), function(){thisCB.Quit();});
	this.nextWB = new WizardButton1(9, "n", gSession.localization.GetString("locNext", "Next"), 
		"128px", "32px", "316px", "16px","bigbutton_normalsize", document.getElementById("welcomeID_button"), function(){thisCB.NavNext();});
*/
	if (gWAM) {
		gWAM.AddElementSet([
			//{element:_,hotkey:_,focal:_,nofocal:_,type:_},
			{element:this.quitWB.GetDisplayElement(),hotkey:'Q',virtualtype:'WizardButton1'},
			{element:this.nextWB.GetDisplayElement(),hotkey:'N',virtualtype:'WizardButton1'}
		]);
		gWAM.SetPageDefaultEnterElement(this.nextWB.GetDisplayElement());
		gWAM.SetPageDefaultFocusElement(this.nextWB.GetDisplayElement());
		gWAM.SetPageDefaultEscapeElement(this.quitWB.GetDisplayElement());
		gWAM.SetFocusOnDefaultElement();
	}
	//$$$window.external.UIStartPayloadInitialize("0");
	RenderUI();
	CheckForError();
	//$$$document.getElementById("welcomeID_button").style.display="none";
	//rtl implementation
		
		this.AutoReverseRTL();
		if(gSession.languagertl)
		{
			this.quitWB.mainelement.style.left="390px";
			this.nextWB.mainelement.style.left="220px";
		}
		
	return true;
}

function CheckForError()
{
    var iCurrentProgressObj = gSession.UIGetProgress("0");	
    var stat = "1";
	if (iCurrentProgressObj._error != null && iCurrentProgressObj._error != "") {
	
		var standardAlerts = null;
		standardAlerts = new StandardAlert(gSession, gSession.localization);
		// Create the pool we can fish standard alerts from.
	//	if( iCurrentProgressObj._error == "kNotEnoughDiskSpace" )
	//	{
	//       gSession.UIExitDialog(standardAlerts.NotEnoughDiskSpace());
	//	}
	//	else 
		if( iCurrentProgressObj._error == "kHigherPatchInstalled" )
		{
	       gSession.UIExitDialog(standardAlerts.HigherPatchInstalled());
		}
		else if( iCurrentProgressObj._error == "kBasePayloadNotInstalled" )
		{
	       gSession.UIExitDialog(standardAlerts.BasePayloadNotInstalled());
		}
//		else if(iCurrentProgressObj._error == "kRollBack")
//		{
//		    gSession.UIExitDialog(standardAlerts.GenericError());Bug#1849064 fix.
//		}
		else if(iCurrentProgressObj._error == "kAlreadyInstalled")
		{
		    gSession.UIExitDialog(standardAlerts.AlreadyInstalled());
		}
        else stat="0";
		//progressPage.ShowNextPage();
	}
	else stat = "0";
	
	return stat;
}

function InitialCheckForError()
{
    var isAdmin = gSession.UIGetInitialErrors("0");
     var stat = "0";
     if( isAdmin._error !=  null && isAdmin._error !="")
     {
        if( isAdmin._error == "0" )
        {
            var standardAlerts = null;
		    standardAlerts = new StandardAlert(gSession, gSession.localization);
            stat = "1";
            gSession.UIExitDialog(standardAlerts.InvalidUserCredentials());
        }
     }
	if (stat == "0") {
		var setupLock = gSession.AcquireSetupLock();
		if (setupLock && setupLock.setupLocked == "0") { // Failed to Acquire lock, Another Setup is running
			var standardAlerts = null;
			standardAlerts = new StandardAlert(gSession, gSession.localization);
			stat = "1";
			gSession.UIExitDialog(standardAlerts.SetupAlreadyRunning());
		}
	}
     return stat;
    
    
}


function CheckForConflictingProcess()
{
    
	var stat = "1";
	var res=true;
	while(stat=="1")
	{
		var jsonObj = gSession.GetConflictingProcessList();
		if (jsonObj._error!= 9999 && jsonObj._error!= 1) 
		{
			var inProcessList;
			inProcessList = jsonObj._blockProcList
			if(inProcessList)
			{
				var standardAlerts = null;
				standardAlerts = new StandardAlert(gSession, gSession.localization);
				res = standardAlerts.ConflictingProcessesRunning(inProcessList);
				if(res == true)
					stat = "0";//quit
    	    
			}
			else stat="0";//no cnflct prcs
		}
		else stat="0";//no cnflct prcs
    }
    return stat;
    
}

function CheckForDiskSpace()
{
    var jsonObj = gSession.CheckForDiskSpace();
	var stat = "0";
    if (jsonObj._error!= 9999 && jsonObj._error!= 1) {
        if( jsonObj._error == "kNotEnoughDiskSpace" )
	{
		var prop = {spaceReq:jsonObj.spaceReq, volume:jsonObj.volume};
	        var standardAlerts = null;
	        standardAlerts = new StandardAlert(gSession, gSession.localization);
    	    standardAlerts.NotEnoughDiskSpace(prop);
    	    stat = "1";
        }
    }
   return stat;
}

function RenderUI()
{
	//$$$document.getElementById("welcomeID_button").style.display="block";

    var listNode = document.getElementById("updateListID");
	var updates = window.external.UIGetUpdatesStatusMap();
		var updcnt=0,alrdtupdcnt=0;
		updates =  eval('(' + updates + ')');
	var multi = 0;
	listNode.innerHTML="";
	for (var si in updates)
	{
		var upd = updates[si];
		if( upd != "9999") 
		{
		    multi++;
		    var li = document.createElement("li");
		    li.innerHTML = upd;
		    listNode.appendChild(li);
		    updcnt=updcnt+1;
		}
	}
		var label=document.getElementById("mainLabelID");
	if(multi > 1)
	{
	
	    	label.innerHTML = gSession.localization.GetString("main_pageInstruction", "Click next to install following updates.");
	}
	else
	{
	    	label.innerHTML = gSession.localization.GetString("main_pageInstructionSing", "Click next to install following update.");
	}
	
	var higherVersionDetecetd = window.external.UIGetHigherUpdateDetectedStatusMap();
	higherVersionDetecetd =  eval('(' + higherVersionDetecetd + ')');
	
	for (var si in higherVersionDetecetd)
	{
		var upd = higherVersionDetecetd[si];
		if( upd != "9999") 
		{
		    //append "productname not Installed"
		    upd = upd + " - " + gSession.localization.GetString("locHigherPatchError", "Newer version detected.",null);
		    var li = document.createElement("li");
		    li.innerHTML = "<font color=#999999>" +upd+ "</font>";
		    listNode.appendChild(li);
		    
		}
	}
	
	var alreadyUpdated = window.external.UIGetAlreadyUpdatedStatusMap();
	alreadyUpdated =  eval('(' + alreadyUpdated + ')');
	
	for (var si in alreadyUpdated)
	{
		var upd = alreadyUpdated[si];
		if( upd != "9999") 
		{
		    //append "Already Installed"
		    upd = upd + " - " + gSession.localization.GetString("locAlreadyInstalled", "Already Installed",null);
		    var li = document.createElement("li");
		    li.innerHTML = "<font color=#999999>" +upd+ "</font>";
		    listNode.appendChild(li);
		    alrdtupdcnt = alrdtupdcnt + 1;
		}
	}
	
	var notInstalled = window.external.UIGetParentNotInstalledUpdatesStatusMap();
	notInstalled =  eval('(' + notInstalled + ')');
	
	for (var si in notInstalled)
	{
		var upd = notInstalled[si];
		if( upd != "9999") 
		{
		    //append "productname not Installed"
		    var prop = {productName:""};
		    upd = upd + " " + gSession.localization.GetString("locBasePayloadError", "[productName] not installed",prop);
		    var li = document.createElement("li");
		    li.innerHTML = "<font color=#999999>" +upd+ "</font>";
		    listNode.appendChild(li);
		    alrdtupdcnt = alrdtupdcnt + 1;
		}
	}	
	
	if( updcnt == 0)
	{
	    //Disable Next Btn
	    _g_this.nextWB.Disable();
	    var label=document.getElementById("mainLabelID");
	    label.innerHTML = gSession.localization.GetString("main_pageSubTitleError", "Cannot Install Please click the Quit button");
	    cleanQuit = 1;
	    
	}
	
}
