/*!
**********************************************************************
@file Progress.js

Copyright 2003-2006 Adobe Systems Incorporated.                     
All Rights Reserved.                                                
                                                                    
NOTICE: All information contained herein is the property of Adobe   
Systems Incorporated.                                                                                                                    

***********************************************************************
*/
/**
Progress Page
*/

/** DIV ID of progress bar for resource loading */
var _k_progressBarID = 'progressBarMid';
var _g_pollIntervalName = null;
var _g_pollIntervalDisplay = null;
var gCurrentActionLabel = null;

var _g_lastPayloadInstalled = '';

function Progress()
{
	this.Hide();
	/*var thisCB = this;
	 this.quitWB = new WizardButton1(9, "n", gSession.localization.GetString("locCancel", "Cancel"), 
		"128px", "32px", "236px", "16px","bigbutton_normalsize", document.getElementById("progressID_button"), function(){if (thisCB.Quit()) gSession.UICancelUpdate();}); */
	if (gSession.systemInfo.Macintosh)
		document.getElementById("progressStatusID").style.top = "50px";

	gCurrentActionLabel = new AdobeProperty("");
	var currentActionElement = document.getElementById("progressStatusID");
	if (currentActionElement)
		gCurrentActionLabel.Bind(currentActionElement);


}


Progress.prototype = new WizardPage("progressID");

Progress.prototype.OnShow = function()
{
/*	var thisCB = this;
	this.quitWB = new WizardButton1(9, "n", gSession.localization.GetString("locCancel", "Cancel"), 
		"128px", "32px", "236px", "16px","bigbutton_normalsize", document.getElementById("progressID_button"), function(){if (thisCB.Quit()) gSession.UICancelUpdate();}); */
	gSession.UISetCloseBoxEnabled(0);		
	if (gWAM) {
	/*	gWAM.AddElementSet([
			//{element:_,hotkey:_,focal:_,nofocal:_,type:_},
			{element:this.quitWB.GetDisplayElement(),hotkey:'Q',virtualtype:'WizardButton1'}
		]);
		gWAM.SetPageDefaultEscapeElement(this.quitWB.GetDisplayElement()); */
		gWAM.SetFocusOnDefaultElement();
	}
	CheckForError();
	
	//rtl implementation
	if(gSession.languagertl)
	{
		this.AutoReverseRTL();
		//this.quitWB.mainelement.style.left="330px";		
		
	}
	
	//$$$_g_pollIntervalName = setInterval('UpdateProgress()', 50);
	_g_pollIntervalDisplay = setInterval('IsPayloadManagerReady()', 50);
	gSession.UISetWindowTitle("Adobe Update Installer - " + gSession.localization.GetString("main_progressSubTitle", "Progress"));
	
	//$$$window.external.UIStartInstall("0");
	window.external.UIStartPayloadInitialize("0");
	return true;
}


function IsPayloadManagerReady()
{
    //start poling and check if the preprocessing is done or not
    var iInit = gSession.UIGetPayloadProgress("0");	
    var stat = "";
	var progressBarStatusNode = document.getElementById("progressStatusID");
	
	if (iInit != null ) {
	    progressBarStatusNode.innerText = gSession.localization.GetString("locPageTitle",
				"Loading Setup", null);
        if(iInit._error!=null && iInit._error=="DONE")
        {
			//progressBarStatusNode.innerText = '';
	        //$$$_g_this.nextWB.Enable();
		    clearInterval(_g_pollIntervalDisplay);
		    //$$$RenderUI();
		    stat = CheckForDiskSpace();
		    if( stat == "0" )
		    {
				progressBarStatusNode.innerText = "";
		        _g_pollIntervalName = setInterval('UpdateProgress()', 10);
		        window.external.UIStartInstall("0");
		    }
		 }
	}
}


function UpdateProgress()
{
	var iCurrentProgressObj = gSession.UIGetProgress("0");	
	if (iCurrentProgressObj._error != null && iCurrentProgressObj._error != "") {
		clearInterval(_g_pollIntervalName);
		//var standardAlerts = null;
		//standardAlerts = new StandardAlert(gSession, gSession.localization);
		// Create the pool we can fish standard alerts from.
	//	if( iCurrentProgressObj._error == "kNotEnoughDiskSpace" )
	//	{
	  //	     gSession.UIExitDialog(standardAlerts.NotEnoughDiskSpace());
	//	}
	//	else
	//	{
		  //  gSession.UIExitDialog(standardAlerts.GenericError());
	//	}
		//progressPage.ShowNextPage();
	}
	iCurrentProgressObj = iCurrentProgressObj.Progress;
	var iCurrentProgress = iCurrentProgressObj.percentage;
	var progressBarNode = document.getElementById(_k_progressBarID);
	var progressBarStatusNode = document.getElementById("progressStatusID");
	var progressBarStyle = progressBarNode.style;	
		
	if (iCurrentProgress)
	{
		if (iCurrentProgress != 0)
		{
			var newWidth =  iCurrentProgress.toString() + "%";
			progressBarStyle.width = newWidth;
			//progressBarNode.alt = newWidth;
			progressBarNode.alt = parseInt(newWidth).toString()+"%";
		}
		var prop = {productName:iCurrentProgressObj.curPayload};
		
		gCurrentActionLabel.Set(gSession.localization.GetString("main_progressStatus",
				"Currently Installing [productName].", prop));
				
		window.external.UIShowWindow(1);
		// progressBarStatusNode.innerText = gSession.localization.GetString("main_progressStatus","Currently Installing [productName].", prop);				
		if (iCurrentProgress >= 100) {
			clearInterval(_g_pollIntervalName);
			progressPage.ShowNextPage();
		}		
	}
}