/*!
**********************************************************************
@file DisableDrag.js

Copyright 2003-2006 Adobe Systems Incorporated.                     
All Rights Reserved.                                                
                                                                    
NOTICE: All information contained herein is the property of Adobe   
Systems Incorporated.                                                                                                                    

***********************************************************************
*/

////////////////////////////////////////////////////////////////////////////
// Code to disable selection/dragging of non-interactive UI elements 
////////////////////////////////////////////////////////////////////////////

/** Set to true to enable dragging */
var g_canDrag = false;

/** Set to true to enable selection */
var g_canSelect = false;

// There are various combinations of document.function, document.body.function
// This is to enable compatibility across all browsers

document.body.ondrag = function()
{
	if(window.event.srcElement.tagName == "INPUT" || window.event.srcElement.tagName == "input")
		return true;
    if(g_canDrag == true)
		return true;

	window.event.cancelBubble = true;
	return false;
}

document.body.onselectstart = function()
{
	if(window.event.srcElement.tagName == "INPUT" || window.event.srcElement.tagName == "input")
		return true;
    if(g_canSelect == true)
		return true;

	window.event.cancelBubble = true;
	return false;
}

document.ondrag = function()
{
	if(window.event.srcElement.tagName == "INPUT" || window.event.srcElement.tagName == "input")
		return true;
    if(g_canDrag == true)
		return true;

	window.event.cancelBubble = true;
	return false;
}

document.onselectstart = function()
{
	if(window.event.srcElement.tagName == "INPUT" || window.event.srcElement.tagName == "input")
		return true;
    if(g_canSelect == true)
		return true;

	window.event.cancelBubble = true;
	return false;
}

document.ondragstart = function()
{
	if(window.event.srcElement.tagName == "INPUT" || window.event.srcElement.tagName == "input")
		return true;
    if(g_canDrag == true)
		return true;

	return false;
}
