/*!
**********************************************************************
@file Welcome.js

Copyright 2003-2006 Adobe Systems Incorporated.                     
All Rights Reserved.                                                
                                                                    
NOTICE: All information contained herein is the property of Adobe   
Systems Incorporated.                                                                                                                    

***********************************************************************
*/
/**
Welcome Page
*/

var cleanQuit = 0;

function WizardPage(pageDivID)
{
	this.pageDivID = pageDivID;
}

WizardPage.prototype.OnShow = function()
{
	return true;
}

WizardPage.prototype.Show = function()
{
	if (gWAM)
		gWAM.RemoveAllElements();
	document.getElementById(this.pageDivID).style.display="block";
	document.getElementById(this.pageDivID+"_button").style.display="block";
	this.OnShow();
}

WizardPage.prototype.Hide = function()
{
	document.getElementById(this.pageDivID).style.display="none";
	document.getElementById(this.pageDivID+"_button").style.display="none";
}

WizardPage.prototype.SetNextPage = function(nextPage)
{
	this.nextPage = nextPage;
}

WizardPage.prototype.ShowNextPage = function()
{
	this.Hide();
	if (this.nextPage)
		this.nextPage.Show();
}

WizardPage.prototype.Quit = function()
{
	if(cleanQuit)
	{
		gSession.UIExitDialog();
		return true;
	}
	var session = gSession;
	var button1 = {label:session.localization.GetString("locQuit", "Quit"), left:"187px", top:"106px", returnCode:"1", hotkey:"Q", defaultOption:"4"};
	var button2 = {label:session.localization.GetString("locResume", "Resume"), left:"325px", top:"106px", returnCode:"2", hotkey:"R", defaultOption:"3"};
	var buttonsArray = new Array(button1,button2);
	var extraOptions = {strAlertIcon:"warning"};
	var wa = new WizardAlert1(session, session.localization.GetString("locQuitAlert", "Are you sure you want to quit?"), "<p>" + session.localization.GetString("locQuitAlertBody", "Click Resume to continue installing this update.") + "</p>", buttonsArray, "",extraOptions);
	var bQuit = false;

	if (wa.returnValue == "1") {
		session.UIExitDialog(wa.returnValue);
		bQuit = true;
	}
	return bQuit;
}



/*
Reverse Everything Under "container" including "contentwrap" except the children of "contentwrap" once :: Done By AutoReverseRTLOnce();
Reverse the children of "contentwrap" everytime :: Done By AutoReverseRTL();
GENERAL PRINCIPLE
Any Element Which Is Dynamically Added To Screen Or Position Changed After OnShow() should call ForceElementAutoReverseRTL();
*/

/*
Reverse Everything Under "container" including "contentwrap" except the children of "contentwrap" once :: Done By AutoReverseRTLOnce();
G
*/
WizardPage.prototype.AutoReverseRTLOnce = function()
{
	if(gSession.maindomrev)
		return;
	else
	{
		gSession.maindomrev=true;
		//EXTENDABLE TO WIZARDS ALL, INCLUDING VIRTUO COMPONENTO
		if(gSession.languagertl)
		{
			var celement = document.getElementById("contentwrap");
			celement.ignorechildren=true;
			document.getElementById("container").ignore=true;
			WizardReverseDisplay1(document.getElementById("container"));
		}
		//EXTENDABLE TO WIZARDS ALL, INCLUDING VIRTUO COMPONENTO
	}
};

/*
Reverse the children of "contentwrap" everytime :: Done By AutoReverseRTL();
G
To Be Called In Every WizardPages onShow();
G
*/
WizardPage.prototype.AutoReverseRTL = function()
{
	//EXTENDABLE TO WIZARDS ALL, INCLUDING VIRTUO COMPONENTO
	if(gSession.languagertl && !(gSession.reversedpage[this.pageName]))
	{
		var celement = document.getElementById("contentwrap");
		celement.ignorechildren=false;
		for(var i=0;i<celement.children.length;i++)
		{
			WizardReverseDisplay1(celement.children[i]);
		}
		gSession.reversedpage[this.pageName]=true;
	}
	//EXTENDABLE TO WIZARDS ALL, INCLUDING VIRTUO COMPONENTO
};

/*
Any Element Which Is Dynamically Added To Screen Or Position Changed After OnShow() should call ForceElementAutoReverseRTL();
G
*/
WizardPage.prototype.ForceElementAutoReverseRTL = function(inElement)
{
	//EXTENDABLE TO WIZARDS ALL, INCLUDING VIRTUO COMPONENTO
	if(gSession.languagertl)
	{
		WizardReverseDisplay1(inElement);
	}
	//EXTENDABLE TO WIZARDS ALL, INCLUDING VIRTUO COMPONENTO
};

